/* Copyright (C) 2004, 2006 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <errno.h>
#include <stdio.h>
#include <string.h>

#include "libnscd.h"

int
main (void)
{
  int ret;

  ret = nscd_flush_cache ("passwd");
  printf ("nscd_flush_cache (\"passwd\") returned %d, (%d): %s\n",
	  ret, errno, strerror (errno));
  ret = nscd_flush_cache ("group");
  printf ("nscd_flush_cache (\"group\") returned %d, %s\n",
	  ret, strerror (errno));
  ret = nscd_flush_cache ("hosts");
  printf ("nscd_flush_cache (\"hosts\") returned %d, %s\n",
	  ret, strerror (errno));
  ret = nscd_flush_cache ("wrong");
  printf ("nscd_flush_cache (\"wrong\") returned %d, %s\n",
	  ret, strerror (errno));

  return 0;
}
