/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.writers;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLEventWriterImpl
implements XMLEventWriter {
    private XMLStreamWriter fStreamWriter;
    private static final boolean DEBUG = false;

    public void close() throws XMLStreamException {
        this.fStreamWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.fStreamWriter.flush();
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.fStreamWriter.setDefaultNamespace(string);
    }

    public NamespaceContext getNamespaceContext() {
        return this.fStreamWriter.getNamespaceContext();
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fStreamWriter.setNamespaceContext(namespaceContext);
    }

    /*
     * Unable to fully structure code
     */
    public void add(XMLEventReader var1_1) throws XMLStreamException {
        if (var1_1 != null) ** GOTO lbl4
        throw new XMLStreamException("Event reader shouldn't be null");
lbl-1000:
        // 1 sources

        {
            this.add(var1_1.nextEvent());
lbl4:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl5:
        // 1 sources

    }

    public XMLEventWriterImpl(XMLStreamWriter xMLStreamWriter) {
        this.fStreamWriter = xMLStreamWriter;
    }

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        int n = xMLEvent.getEventType();
        switch (n) {
            case 11: {
                DTD dTD = (DTD)xMLEvent;
                this.fStreamWriter.writeDTD(dTD.getDocumentTypeDeclaration());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)xMLEvent;
                this.fStreamWriter.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                break;
            }
            case 1: {
                Object object;
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                this.fStreamWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
                Iterator<Namespace> iterator = startElement.getNamespaces();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.fStreamWriter.writeNamespace(object.getPrefix(), object.getNamespaceURI());
                }
                object = startElement.getAttributes();
                while (object.hasNext()) {
                    Attribute attribute = (Attribute)object.next();
                    QName qName2 = attribute.getName();
                    this.fStreamWriter.writeAttribute(qName2.getPrefix(), qName2.getNamespaceURI(), qName2.getLocalPart(), attribute.getValue());
                }
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                this.fStreamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 5: {
                Comment comment = (Comment)xMLEvent;
                this.fStreamWriter.writeComment(comment.getText());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                this.fStreamWriter.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 4: {
                Characters characters = xMLEvent.asCharacters();
                if (characters.isCData()) {
                    this.fStreamWriter.writeCData(characters.getData());
                    break;
                }
                this.fStreamWriter.writeCharacters(characters.getData());
                break;
            }
            case 9: {
                EntityReference entityReference = (EntityReference)xMLEvent;
                this.fStreamWriter.writeEntityRef(entityReference.getName());
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)xMLEvent;
                QName qName = attribute.getName();
                this.fStreamWriter.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), attribute.getValue());
                break;
            }
            case 12: {
                Characters characters = (Characters)xMLEvent;
                if (!characters.isCData()) break;
                this.fStreamWriter.writeCData(characters.getData());
                break;
            }
            case 2: {
                this.fStreamWriter.writeEndElement();
                break;
            }
            case 8: {
                this.fStreamWriter.writeEndDocument();
            }
        }
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.fStreamWriter.getPrefix(string);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.fStreamWriter.setPrefix(string, string2);
    }
}

