/*
 * Copyright (c) 2019-2020, The rav1e contributors. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

/*
 * Copyright © 2018, VideoLAN and dav1d authors
 * Copyright © 2018, Two Orioles, LLC
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "src/arm/asm.S"

const mc_subpel_filters, export=1, align=3
.byte  0,   1,  -3,  63,   4,  -1,   0,   0 /* REGULAR */
.byte  0,   1,  -5,  61,   9,  -2,   0,   0
.byte  0,   1,  -6,  58,  14,  -4,   1,   0
.byte  0,   1,  -7,  55,  19,  -5,   1,   0
.byte  0,   1,  -7,  51,  24,  -6,   1,   0
.byte  0,   1,  -8,  47,  29,  -6,   1,   0
.byte  0,   1,  -7,  42,  33,  -6,   1,   0
.byte  0,   1,  -7,  38,  38,  -7,   1,   0
.byte  0,   1,  -6,  33,  42,  -7,   1,   0
.byte  0,   1,  -6,  29,  47,  -8,   1,   0
.byte  0,   1,  -6,  24,  51,  -7,   1,   0
.byte  0,   1,  -5,  19,  55,  -7,   1,   0
.byte  0,   1,  -4,  14,  58,  -6,   1,   0
.byte  0,   0,  -2,   9,  61,  -5,   1,   0
.byte  0,   0,  -1,   4,  63,  -3,   1,   0
.byte  0,   1,  14,  31,  17,   1,   0,   0 /* SMOOTH */
.byte  0,   0,  13,  31,  18,   2,   0,   0
.byte  0,   0,  11,  31,  20,   2,   0,   0
.byte  0,   0,  10,  30,  21,   3,   0,   0
.byte  0,   0,   9,  29,  22,   4,   0,   0
.byte  0,   0,   8,  28,  23,   5,   0,   0
.byte  0,  -1,   8,  27,  24,   6,   0,   0
.byte  0,  -1,   7,  26,  26,   7,  -1,   0
.byte  0,   0,   6,  24,  27,   8,  -1,   0
.byte  0,   0,   5,  23,  28,   8,   0,   0
.byte  0,   0,   4,  22,  29,   9,   0,   0
.byte  0,   0,   3,  21,  30,  10,   0,   0
.byte  0,   0,   2,  20,  31,  11,   0,   0
.byte  0,   0,   2,  18,  31,  13,   0,   0
.byte  0,   0,   1,  17,  31,  14,   1,   0
.byte -1,   1,  -3,  63,   4,  -1,   1,   0 /* SHARP */
.byte -1,   3,  -6,  62,   8,  -3,   2,  -1
.byte -1,   4,  -9,  60,  13,  -5,   3,  -1
.byte -2,   5, -11,  58,  19,  -7,   3,  -1
.byte -2,   5, -11,  54,  24,  -9,   4,  -1
.byte -2,   5, -12,  50,  30, -10,   4,  -1
.byte -2,   5, -12,  45,  35, -11,   5,  -1
.byte -2,   6, -12,  40,  40, -12,   6,  -2
.byte -1,   5, -11,  35,  45, -12,   5,  -2
.byte -1,   4, -10,  30,  50, -12,   5,  -2
.byte -1,   4,  -9,  24,  54, -11,   5,  -2
.byte -1,   3,  -7,  19,  58, -11,   5,  -2
.byte -1,   3,  -5,  13,  60,  -9,   4,  -1
.byte -1,   2,  -3,   8,  62,  -6,   3,  -1
.byte  0,   1,  -1,   4,  63,  -3,   1,  -1
.byte  0,   0,  -2,  63,   4,  -1,   0,   0 /* REGULAR 4 */
.byte  0,   0,  -4,  61,   9,  -2,   0,   0
.byte  0,   0,  -5,  58,  14,  -3,   0,   0
.byte  0,   0,  -6,  55,  19,  -4,   0,   0
.byte  0,   0,  -6,  51,  24,  -5,   0,   0
.byte  0,   0,  -7,  47,  29,  -5,   0,   0
.byte  0,   0,  -6,  42,  33,  -5,   0,   0
.byte  0,   0,  -6,  38,  38,  -6,   0,   0
.byte  0,   0,  -5,  33,  42,  -6,   0,   0
.byte  0,   0,  -5,  29,  47,  -7,   0,   0
.byte  0,   0,  -5,  24,  51,  -6,   0,   0
.byte  0,   0,  -4,  19,  55,  -6,   0,   0
.byte  0,   0,  -3,  14,  58,  -5,   0,   0
.byte  0,   0,  -2,   9,  61,  -4,   0,   0
.byte  0,   0,  -1,   4,  63,  -2,   0,   0
.byte  0,   0,  15,  31,  17,   1,   0,   0 /* SMOOTH 4 */
.byte  0,   0,  13,  31,  18,   2,   0,   0
.byte  0,   0,  11,  31,  20,   2,   0,   0
.byte  0,   0,  10,  30,  21,   3,   0,   0
.byte  0,   0,   9,  29,  22,   4,   0,   0
.byte  0,   0,   8,  28,  23,   5,   0,   0
.byte  0,   0,   7,  27,  24,   6,   0,   0
.byte  0,   0,   6,  26,  26,   6,   0,   0
.byte  0,   0,   6,  24,  27,   7,   0,   0
.byte  0,   0,   5,  23,  28,   8,   0,   0
.byte  0,   0,   4,  22,  29,   9,   0,   0
.byte  0,   0,   3,  21,  30,  10,   0,   0
.byte  0,   0,   2,  20,  31,  11,   0,   0
.byte  0,   0,   2,  18,  31,  13,   0,   0
.byte  0,   0,   1,  17,  31,  15,   0,   0
endconst

const filter_intra_taps, export=1,  align=4
.byte  -6,  10,  -5,   2,  -3,   1,  -3,   1 /* 0 */
.byte  -4,   6,  -3,   2,  -3,   2,  -3,   1
.byte   0,   0,  10,   0,   1,  10,   1,   2
.byte   0,   0,   6,   0,   2,   6,   2,   2
.byte   0,  12,   0,   9,   0,   7,  10,   5
.byte   0,   2,   0,   2,   0,   2,   6,   3
.byte   0,   0,   0,   0,   0,   0,   0,   0
.byte  12,   0,   9,   0,   7,   0,   5,   0
.byte -10,  16,  -6,   0,  -4,   0,  -2,   0 /* 1 */
.byte -10,  16,  -6,   0,  -4,   0,  -2,   0
.byte   0,   0,  16,   0,   0,  16,   0,   0
.byte   0,   0,  16,   0,   0,  16,   0,   0
.byte   0,  10,   0,   6,   0,   4,  16,   2
.byte   0,   0,   0,   0,   0,   0,  16,   0
.byte   0,   0,   0,   0,   0,   0,   0,   0
.byte  10,   0,   6,   0,   4,   0,   2,   0
.byte  -8,   8,  -8,   0,  -8,   0,  -8,   0 /* 2 */
.byte  -4,   4,  -4,   0,  -4,   0,  -4,   0
.byte   0,   0,   8,   0,   0,   8,   0,   0
.byte   0,   0,   4,   0,   0,   4,   0,   0
.byte   0,  16,   0,  16,   0,  16,   8,  16
.byte   0,   0,   0,   0,   0,   0,   4,   0
.byte   0,   0,   0,   0,   0,   0,   0,   0
.byte  16,   0,  16,   0,  16,   0,  16,   0
.byte  -2,   8,  -1,   3,  -1,   2,   0,   1 /* 3 */
.byte  -1,   4,  -1,   3,  -1,   2,  -1,   2
.byte   0,   0,   8,   0,   3,   8,   2,   3
.byte   0,   0,   4,   0,   3,   4,   2,   3
.byte   0,  10,   0,   6,   0,   4,   8,   2
.byte   0,   3,   0,   4,   0,   4,   4,   3
.byte   0,   0,   0,   0,   0,   0,   0,   0
.byte  10,   0,   6,   0,   4,   0,   3,   0
.byte -12,  14, -10,   0,  -9,   0,  -8,   0 /* 4 */
.byte -10,  12,  -9,   1,  -8,   0,  -7,   0
.byte   0,   0,  14,   0,   0,  14,   0,   0
.byte   0,   0,  12,   0,   0,  12,   0,   1
.byte   0,  14,   0,  12,   0,  11,  14,  10
.byte   0,   0,   0,   0,   0,   1,  12,   1
.byte   0,   0,   0,   0,   0,   0,   0,   0
.byte  14,   0,  12,   0,  11,   0,   9,   0
endconst

const sgr_x_by_x, export=1, align=4
.byte 255, 128,  85,  64,  51,  43,  37,  32,  28,  26,  23,  21,  20,  18,  17
.byte  16,  15,  14,  13,  13,  12,  12,  11,  11,  10,  10,   9,   9,   9,   9
.byte   8,   8,   8,   8,   7,   7,   7,   7,   7,   6,   6,   6,   6,   6,   6
.byte   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   4,   4,   4,   4
.byte   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3
.byte   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3
.byte   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   2
.byte   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2
.byte   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2
.byte   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2
.byte   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2
.byte   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1
.byte   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1
.byte   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1
.byte   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1
.byte   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1
.byte   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1
.byte   0
endconst

const mc_warp_filter, export=1, align=3
/*  [-1, 0) */
.byte 0,   0, 127,   1,   0, 0, 0, 0,  0, - 1, 127,   2,   0, 0, 0, 0
.byte 1, - 3, 127,   4, - 1, 0, 0, 0,  1, - 4, 126,   6, - 2, 1, 0, 0
.byte 1, - 5, 126,   8, - 3, 1, 0, 0,  1, - 6, 125,  11, - 4, 1, 0, 0
.byte 1, - 7, 124,  13, - 4, 1, 0, 0,  2, - 8, 123,  15, - 5, 1, 0, 0
.byte 2, - 9, 122,  18, - 6, 1, 0, 0,  2, -10, 121,  20, - 6, 1, 0, 0
.byte 2, -11, 120,  22, - 7, 2, 0, 0,  2, -12, 119,  25, - 8, 2, 0, 0
.byte 3, -13, 117,  27, - 8, 2, 0, 0,  3, -13, 116,  29, - 9, 2, 0, 0
.byte 3, -14, 114,  32, -10, 3, 0, 0,  3, -15, 113,  35, -10, 2, 0, 0
.byte 3, -15, 111,  37, -11, 3, 0, 0,  3, -16, 109,  40, -11, 3, 0, 0
.byte 3, -16, 108,  42, -12, 3, 0, 0,  4, -17, 106,  45, -13, 3, 0, 0
.byte 4, -17, 104,  47, -13, 3, 0, 0,  4, -17, 102,  50, -14, 3, 0, 0
.byte 4, -17, 100,  52, -14, 3, 0, 0,  4, -18,  98,  55, -15, 4, 0, 0
.byte 4, -18,  96,  58, -15, 3, 0, 0,  4, -18,  94,  60, -16, 4, 0, 0
.byte 4, -18,  91,  63, -16, 4, 0, 0,  4, -18,  89,  65, -16, 4, 0, 0
.byte 4, -18,  87,  68, -17, 4, 0, 0,  4, -18,  85,  70, -17, 4, 0, 0
.byte 4, -18,  82,  73, -17, 4, 0, 0,  4, -18,  80,  75, -17, 4, 0, 0
.byte 4, -18,  78,  78, -18, 4, 0, 0,  4, -17,  75,  80, -18, 4, 0, 0
.byte 4, -17,  73,  82, -18, 4, 0, 0,  4, -17,  70,  85, -18, 4, 0, 0
.byte 4, -17,  68,  87, -18, 4, 0, 0,  4, -16,  65,  89, -18, 4, 0, 0
.byte 4, -16,  63,  91, -18, 4, 0, 0,  4, -16,  60,  94, -18, 4, 0, 0
.byte 3, -15,  58,  96, -18, 4, 0, 0,  4, -15,  55,  98, -18, 4, 0, 0
.byte 3, -14,  52, 100, -17, 4, 0, 0,  3, -14,  50, 102, -17, 4, 0, 0
.byte 3, -13,  47, 104, -17, 4, 0, 0,  3, -13,  45, 106, -17, 4, 0, 0
.byte 3, -12,  42, 108, -16, 3, 0, 0,  3, -11,  40, 109, -16, 3, 0, 0
.byte 3, -11,  37, 111, -15, 3, 0, 0,  2, -10,  35, 113, -15, 3, 0, 0
.byte 3, -10,  32, 114, -14, 3, 0, 0,  2, - 9,  29, 116, -13, 3, 0, 0
.byte 2, - 8,  27, 117, -13, 3, 0, 0,  2, - 8,  25, 119, -12, 2, 0, 0
.byte 2, - 7,  22, 120, -11, 2, 0, 0,  1, - 6,  20, 121, -10, 2, 0, 0
.byte 1, - 6,  18, 122, - 9, 2, 0, 0,  1, - 5,  15, 123, - 8, 2, 0, 0
.byte 1, - 4,  13, 124, - 7, 1, 0, 0,  1, - 4,  11, 125, - 6, 1, 0, 0
.byte 1, - 3,   8, 126, - 5, 1, 0, 0,  1, - 2,   6, 126, - 4, 1, 0, 0
.byte 0, - 1,   4, 127, - 3, 1, 0, 0,  0,   0,   2, 127, - 1, 0, 0, 0
/* [0, 1) */
.byte  0,  0,   0, 127,   1,   0,  0,  0,   0,  0,  -1, 127,   2,   0,  0,  0
.byte  0,  1,  -3, 127,   4,  -2,  1,  0,   0,  1,  -5, 127,   6,  -2,  1,  0
.byte  0,  2,  -6, 126,   8,  -3,  1,  0,  -1,  2,  -7, 126,  11,  -4,  2, -1
.byte -1,  3,  -8, 125,  13,  -5,  2, -1,  -1,  3, -10, 124,  16,  -6,  3, -1
.byte -1,  4, -11, 123,  18,  -7,  3, -1,  -1,  4, -12, 122,  20,  -7,  3, -1
.byte -1,  4, -13, 121,  23,  -8,  3, -1,  -2,  5, -14, 120,  25,  -9,  4, -1
.byte -1,  5, -15, 119,  27, -10,  4, -1,  -1,  5, -16, 118,  30, -11,  4, -1
.byte -2,  6, -17, 116,  33, -12,  5, -1,  -2,  6, -17, 114,  35, -12,  5, -1
.byte -2,  6, -18, 113,  38, -13,  5, -1,  -2,  7, -19, 111,  41, -14,  6, -2
.byte -2,  7, -19, 110,  43, -15,  6, -2,  -2,  7, -20, 108,  46, -15,  6, -2
.byte -2,  7, -20, 106,  49, -16,  6, -2,  -2,  7, -21, 104,  51, -16,  7, -2
.byte -2,  7, -21, 102,  54, -17,  7, -2,  -2,  8, -21, 100,  56, -18,  7, -2
.byte -2,  8, -22,  98,  59, -18,  7, -2,  -2,  8, -22,  96,  62, -19,  7, -2
.byte -2,  8, -22,  94,  64, -19,  7, -2,  -2,  8, -22,  91,  67, -20,  8, -2
.byte -2,  8, -22,  89,  69, -20,  8, -2,  -2,  8, -22,  87,  72, -21,  8, -2
.byte -2,  8, -21,  84,  74, -21,  8, -2,  -2,  8, -22,  82,  77, -21,  8, -2
.byte -2,  8, -21,  79,  79, -21,  8, -2,  -2,  8, -21,  77,  82, -22,  8, -2
.byte -2,  8, -21,  74,  84, -21,  8, -2,  -2,  8, -21,  72,  87, -22,  8, -2
.byte -2,  8, -20,  69,  89, -22,  8, -2,  -2,  8, -20,  67,  91, -22,  8, -2
.byte -2,  7, -19,  64,  94, -22,  8, -2,  -2,  7, -19,  62,  96, -22,  8, -2
.byte -2,  7, -18,  59,  98, -22,  8, -2,  -2,  7, -18,  56, 100, -21,  8, -2
.byte -2,  7, -17,  54, 102, -21,  7, -2,  -2,  7, -16,  51, 104, -21,  7, -2
.byte -2,  6, -16,  49, 106, -20,  7, -2,  -2,  6, -15,  46, 108, -20,  7, -2
.byte -2,  6, -15,  43, 110, -19,  7, -2,  -2,  6, -14,  41, 111, -19,  7, -2
.byte -1,  5, -13,  38, 113, -18,  6, -2,  -1,  5, -12,  35, 114, -17,  6, -2
.byte -1,  5, -12,  33, 116, -17,  6, -2,  -1,  4, -11,  30, 118, -16,  5, -1
.byte -1,  4, -10,  27, 119, -15,  5, -1,  -1,  4,  -9,  25, 120, -14,  5, -2
.byte -1,  3,  -8,  23, 121, -13,  4, -1,  -1,  3,  -7,  20, 122, -12,  4, -1
.byte -1,  3,  -7,  18, 123, -11,  4, -1,  -1,  3,  -6,  16, 124, -10,  3, -1
.byte -1,  2,  -5,  13, 125,  -8,  3, -1,  -1,  2,  -4,  11, 126,  -7,  2, -1
.byte  0,  1,  -3,   8, 126,  -6,  2,  0,   0,  1,  -2,   6, 127,  -5,  1,  0
.byte  0,  1,  -2,   4, 127,  -3,  1,  0,   0,  0,   0,   2, 127,  -1,  0,  0
/* [1, 2) */
.byte 0, 0, 0,   1, 127,   0,   0, 0,  0, 0, 0, - 1, 127,   2,   0, 0
.byte 0, 0, 1, - 3, 127,   4, - 1, 0,  0, 0, 1, - 4, 126,   6, - 2, 1
.byte 0, 0, 1, - 5, 126,   8, - 3, 1,  0, 0, 1, - 6, 125,  11, - 4, 1
.byte 0, 0, 1, - 7, 124,  13, - 4, 1,  0, 0, 2, - 8, 123,  15, - 5, 1
.byte 0, 0, 2, - 9, 122,  18, - 6, 1,  0, 0, 2, -10, 121,  20, - 6, 1
.byte 0, 0, 2, -11, 120,  22, - 7, 2,  0, 0, 2, -12, 119,  25, - 8, 2
.byte 0, 0, 3, -13, 117,  27, - 8, 2,  0, 0, 3, -13, 116,  29, - 9, 2
.byte 0, 0, 3, -14, 114,  32, -10, 3,  0, 0, 3, -15, 113,  35, -10, 2
.byte 0, 0, 3, -15, 111,  37, -11, 3,  0, 0, 3, -16, 109,  40, -11, 3
.byte 0, 0, 3, -16, 108,  42, -12, 3,  0, 0, 4, -17, 106,  45, -13, 3
.byte 0, 0, 4, -17, 104,  47, -13, 3,  0, 0, 4, -17, 102,  50, -14, 3
.byte 0, 0, 4, -17, 100,  52, -14, 3,  0, 0, 4, -18,  98,  55, -15, 4
.byte 0, 0, 4, -18,  96,  58, -15, 3,  0, 0, 4, -18,  94,  60, -16, 4
.byte 0, 0, 4, -18,  91,  63, -16, 4,  0, 0, 4, -18,  89,  65, -16, 4
.byte 0, 0, 4, -18,  87,  68, -17, 4,  0, 0, 4, -18,  85,  70, -17, 4
.byte 0, 0, 4, -18,  82,  73, -17, 4,  0, 0, 4, -18,  80,  75, -17, 4
.byte 0, 0, 4, -18,  78,  78, -18, 4,  0, 0, 4, -17,  75,  80, -18, 4
.byte 0, 0, 4, -17,  73,  82, -18, 4,  0, 0, 4, -17,  70,  85, -18, 4
.byte 0, 0, 4, -17,  68,  87, -18, 4,  0, 0, 4, -16,  65,  89, -18, 4
.byte 0, 0, 4, -16,  63,  91, -18, 4,  0, 0, 4, -16,  60,  94, -18, 4
.byte 0, 0, 3, -15,  58,  96, -18, 4,  0, 0, 4, -15,  55,  98, -18, 4
.byte 0, 0, 3, -14,  52, 100, -17, 4,  0, 0, 3, -14,  50, 102, -17, 4
.byte 0, 0, 3, -13,  47, 104, -17, 4,  0, 0, 3, -13,  45, 106, -17, 4
.byte 0, 0, 3, -12,  42, 108, -16, 3,  0, 0, 3, -11,  40, 109, -16, 3
.byte 0, 0, 3, -11,  37, 111, -15, 3,  0, 0, 2, -10,  35, 113, -15, 3
.byte 0, 0, 3, -10,  32, 114, -14, 3,  0, 0, 2, - 9,  29, 116, -13, 3
.byte 0, 0, 2, - 8,  27, 117, -13, 3,  0, 0, 2, - 8,  25, 119, -12, 2
.byte 0, 0, 2, - 7,  22, 120, -11, 2,  0, 0, 1, - 6,  20, 121, -10, 2
.byte 0, 0, 1, - 6,  18, 122, - 9, 2,  0, 0, 1, - 5,  15, 123, - 8, 2
.byte 0, 0, 1, - 4,  13, 124, - 7, 1,  0, 0, 1, - 4,  11, 125, - 6, 1
.byte 0, 0, 1, - 3,   8, 126, - 5, 1,  0, 0, 1, - 2,   6, 126, - 4, 1
.byte 0, 0, 0, - 1,   4, 127, - 3, 1,  0, 0, 0,   0,   2, 127, - 1, 0
/* dummy (replicate row index 191) */
.byte 0, 0, 0,   0,   2, 127, - 1, 0
endconst

const sm_weights, export=1
.byte   0,   0 /* Unused, because we always offset by bs, which is at least 2. */
.byte 255, 128 /* bs = 2 */
.byte 255, 149,  85,  64 /* bs = 4 */
.byte 255, 197, 146, 105,  73,  50,  37,  32 /* bs = 8 */
.byte 255, 225, 196, 170, 145, 123, 102,  84 /* bs = 16 */
.byte  68,  54,  43,  33,  26,  20,  17,  16
.byte 255, 240, 225, 210, 196, 182, 169, 157 /* bs =32 */
.byte 145, 133, 122, 111, 101,  92,  83,  74
.byte  66,  59,  52,  45,  39,  34,  29,  25
.byte  21,  17,  14,  12,  10,   9,   8,   8
.byte 255, 248, 240, 233, 225, 218, 210, 203 /* bs = 64 */
.byte 196, 189, 182, 176, 169, 163, 156, 150
.byte 144, 138, 133, 127, 121, 116, 111, 106
.byte 101,  96,  91,  86,  82,  77,  73,  69
.byte  65,  61,  57,  54,  50,  47,  44,  41
.byte  38,  35,  32,  29,  27,  25,  22,  20
.byte  18,  16,  15,  13,  12,  10,   9,   8
.byte   7,   6,   6,   5,   5,   4,   4,   4
endconst

const obmc_masks, export=1, align=4
.byte  0,  0 /* Unused */
.byte 19,  0 /* 2 */
.byte 25, 14,  5,  0 /* 4 */
.byte 28, 22, 16, 11,  7,  3,  0,  0 /* 8 */
.byte 30, 27, 24, 21, 18, 15, 12, 10
.byte  8,  6,  4,  3,  0,  0,  0,  0 /* 16 */
.byte 31, 29, 28, 26, 24, 23, 21, 20
.byte 19, 17, 16, 14, 13, 12, 11,  9
.byte  8,  7,  6,  5,  4,  4,  3,  2
.byte  0,  0,  0,  0,  0,  0,  0,  0 /* 32 */
endconst
