// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`RegisterClient`](crate::operation::register_client::builders::RegisterClientFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_name(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::client_name) / [`set_client_name(Option<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_client_name):<br>required: **true**<br><p>The friendly name of the client.</p><br>
    ///   - [`client_type(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::client_type) / [`set_client_type(Option<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_client_type):<br>required: **true**<br><p>The type of client. The service supports only <code>public</code> as a client type. Anything other than public will be rejected by the service.</p><br>
    ///   - [`scopes(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::scopes) / [`set_scopes(Option<Vec::<String>>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_scopes):<br>required: **false**<br><p>The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions when granting an access token.</p><br>
    /// - On success, responds with [`RegisterClientOutput`](crate::operation::register_client::RegisterClientOutput) with field(s):
    ///   - [`client_id(Option<String>)`](crate::operation::register_client::RegisterClientOutput::client_id): <p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>
    ///   - [`client_secret(Option<String>)`](crate::operation::register_client::RegisterClientOutput::client_secret): <p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>
    ///   - [`client_id_issued_at(i64)`](crate::operation::register_client::RegisterClientOutput::client_id_issued_at): <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>
    ///   - [`client_secret_expires_at(i64)`](crate::operation::register_client::RegisterClientOutput::client_secret_expires_at): <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>
    ///   - [`authorization_endpoint(Option<String>)`](crate::operation::register_client::RegisterClientOutput::authorization_endpoint): <p>An endpoint that the client can use to request authorization.</p>
    ///   - [`token_endpoint(Option<String>)`](crate::operation::register_client::RegisterClientOutput::token_endpoint): <p>An endpoint that the client can use to create tokens.</p>
    /// - On failure, responds with [`SdkError<RegisterClientError>`](crate::operation::register_client::RegisterClientError)
    pub fn register_client(&self) -> crate::operation::register_client::builders::RegisterClientFluentBuilder {
        crate::operation::register_client::builders::RegisterClientFluentBuilder::new(self.handle.clone())
    }
}
