// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListKeyPoliciesOutput {
    /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    pub policy_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: ::std::option::Option<::std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub truncated: bool,
    _request_id: Option<String>,
}
impl ListKeyPoliciesOutput {
    /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.policy_names.is_none()`.
    pub fn policy_names(&self) -> &[::std::string::String] {
        self.policy_names.as_deref().unwrap_or_default()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> ::std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl ::aws_types::request_id::RequestId for ListKeyPoliciesOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl ListKeyPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListKeyPoliciesOutput`](crate::operation::list_key_policies::ListKeyPoliciesOutput).
    pub fn builder() -> crate::operation::list_key_policies::builders::ListKeyPoliciesOutputBuilder {
        crate::operation::list_key_policies::builders::ListKeyPoliciesOutputBuilder::default()
    }
}

/// A builder for [`ListKeyPoliciesOutput`](crate::operation::list_key_policies::ListKeyPoliciesOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ListKeyPoliciesOutputBuilder {
    pub(crate) policy_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) next_marker: ::std::option::Option<::std::string::String>,
    pub(crate) truncated: ::std::option::Option<bool>,
    _request_id: Option<String>,
}
impl ListKeyPoliciesOutputBuilder {
    /// Appends an item to `policy_names`.
    ///
    /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
    ///
    /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    pub fn policy_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.policy_names.unwrap_or_default();
        v.push(input.into());
        self.policy_names = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    pub fn set_policy_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.policy_names = input;
        self
    }
    /// <p>A list of key policy names. The only valid value is <code>default</code>.</p>
    pub fn get_policy_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.policy_names
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_marker = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn set_next_marker(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_marker = input;
        self
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn get_next_marker(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_marker
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn truncated(mut self, input: bool) -> Self {
        self.truncated = ::std::option::Option::Some(input);
        self
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn set_truncated(mut self, input: ::std::option::Option<bool>) -> Self {
        self.truncated = input;
        self
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn get_truncated(&self) -> &::std::option::Option<bool> {
        &self.truncated
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`ListKeyPoliciesOutput`](crate::operation::list_key_policies::ListKeyPoliciesOutput).
    pub fn build(self) -> crate::operation::list_key_policies::ListKeyPoliciesOutput {
        crate::operation::list_key_policies::ListKeyPoliciesOutput {
            policy_names: self.policy_names,
            next_marker: self.next_marker,
            truncated: self.truncated.unwrap_or_default(),
            _request_id: self._request_id,
        }
    }
}
