/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.MockTestFactoryTest;
import com.clarkware.junitperf.TestFactory;
import com.clarkware.junitperf.TestMethodFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestFactoryTest
extends TestCase {
    private TestSuite _allMethodsTestSuite;
    private TestSuite _oneMethodTestSuite;
    private Class _testClass = class$com$clarkware$junitperf$MockTestFactoryTest == null ? (class$com$clarkware$junitperf$MockTestFactoryTest = TestFactoryTest.class$("com.clarkware.junitperf.MockTestFactoryTest")) : class$com$clarkware$junitperf$MockTestFactoryTest;
    static /* synthetic */ Class class$com$clarkware$junitperf$MockTestFactoryTest;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$clarkware$junitperf$TestFactoryTest;

    public TestFactoryTest(String name) {
        super(name);
        this._allMethodsTestSuite = new TestSuite(this._testClass);
        this._oneMethodTestSuite = new TestSuite();
        this._oneMethodTestSuite.addTest((Test)new MockTestFactoryTest("testSuccess"));
    }

    public void testAllTestMethods() {
        TestFactory testFactory = new TestFactory(this._testClass);
        TestFactoryTest.assertEquals((int)2, (int)testFactory.countTestCases());
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, testFactory.getTest());
        TestResult result = new TestResult();
        testFactory.run(result);
        TestFactoryTest.assertEquals((int)2, (int)result.runCount());
        TestFactoryTest.assertEquals((int)0, (int)result.errorCount());
        TestFactoryTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testAllTestMethodsSameSuiteForSameThread() {
        TestFactory testFactory = new TestFactory(this._testClass);
        Test test1 = testFactory.getTest();
        Test test2 = testFactory.getTest();
        TestFactoryTest.assertSame((Object)test1, (Object)test2);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test1);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test2);
    }

    public void testAllTestMethodsDifferentSuiteForDifferentThread() {
        TestFactory testFactory = new TestFactory(this._testClass);
        MockRunnable runner1 = new MockRunnable(testFactory);
        MockRunnable runner2 = new MockRunnable(testFactory);
        Thread thread1 = new Thread(runner1);
        Thread thread2 = new Thread(runner2);
        thread1.start();
        thread2.start();
        this.sleep();
        Test test1 = runner1.getTest();
        Test test2 = runner2.getTest();
        TestFactoryTest.assertTrue((test1 != test2 ? 1 : 0) != 0);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test1);
        this.assertEqualsTestSuite((Test)this._allMethodsTestSuite, test2);
    }

    public void testOneTestMethodSuccess() {
        TestMethodFactory testFactory = new TestMethodFactory(this._testClass, "testSuccess");
        TestFactoryTest.assertEquals((int)1, (int)testFactory.countTestCases());
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, testFactory.getTest());
        TestResult result = new TestResult();
        testFactory.run(result);
        TestFactoryTest.assertEquals((int)1, (int)result.runCount());
        TestFactoryTest.assertEquals((int)0, (int)result.errorCount());
        TestFactoryTest.assertEquals((int)0, (int)result.failureCount());
    }

    public void testOneTestMethodFailure() {
        TestMethodFactory testFactory = new TestMethodFactory(this._testClass, "testFailure");
        TestFactoryTest.assertEquals((int)1, (int)testFactory.countTestCases());
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, testFactory.getTest());
        TestResult result = new TestResult();
        testFactory.run(result);
        TestFactoryTest.assertEquals((int)1, (int)result.runCount());
        TestFactoryTest.assertEquals((int)0, (int)result.errorCount());
        TestFactoryTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneTestMethodNoSuchMethod() {
        TestMethodFactory testFactory = new TestMethodFactory(this._testClass, "testFoo");
        TestResult result = new TestResult();
        testFactory.run(result);
        TestFactoryTest.assertEquals((int)1, (int)result.runCount());
        TestFactoryTest.assertEquals((int)0, (int)result.errorCount());
        TestFactoryTest.assertEquals((int)1, (int)result.failureCount());
    }

    public void testOneTestMethodSameSuiteForSameThread() {
        TestMethodFactory testFactory = new TestMethodFactory(this._testClass, "testSuccess");
        Test test1 = testFactory.getTest();
        Test test2 = testFactory.getTest();
        TestFactoryTest.assertSame((Object)test1, (Object)test2);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test1);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test2);
    }

    public void testOneTestMethodDifferentSuiteForDifferentThread() {
        TestMethodFactory testFactory = new TestMethodFactory(this._testClass, "testSuccess");
        MockRunnable runner1 = new MockRunnable(testFactory);
        MockRunnable runner2 = new MockRunnable(testFactory);
        Thread thread1 = new Thread(runner1);
        Thread thread2 = new Thread(runner2);
        thread1.start();
        thread2.start();
        this.sleep();
        Test test1 = runner1.getTest();
        Test test2 = runner2.getTest();
        TestFactoryTest.assertTrue((test1 != test2 ? 1 : 0) != 0);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test1);
        this.assertEqualsTestSuite((Test)this._oneMethodTestSuite, test2);
    }

    public void testClassNotATestCase() {
        try {
            TestFactory testFactory = new TestFactory(class$java$lang$String == null ? (class$java$lang$String = TestFactoryTest.class$("java.lang.String")) : class$java$lang$String);
            TestFactoryTest.fail((String)"Class not assignable to TestCase!");
            testFactory = new TestMethodFactory(class$java$lang$String == null ? (class$java$lang$String = TestFactoryTest.class$("java.lang.String")) : class$java$lang$String, "");
            TestFactoryTest.fail((String)"Class not assignable to TestCase!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void sleep() {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void assertEqualsTestSuite(Test t1, Test t2) {
        TestFactoryTest.assertTrue((boolean)(t1 instanceof TestSuite));
        TestFactoryTest.assertTrue((boolean)(t2 instanceof TestSuite));
        TestSuite suite1 = (TestSuite)t1;
        TestSuite suite2 = (TestSuite)t2;
        TestFactoryTest.assertEquals((int)suite1.countTestCases(), (int)suite2.countTestCases());
        TestFactoryTest.assertEquals((String)suite1.getName(), (String)suite2.getName());
    }

    public static Test suite() {
        return new TestSuite(class$com$clarkware$junitperf$TestFactoryTest == null ? (class$com$clarkware$junitperf$TestFactoryTest = TestFactoryTest.class$("com.clarkware.junitperf.TestFactoryTest")) : class$com$clarkware$junitperf$TestFactoryTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestFactoryTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MockRunnable
    implements Runnable {
        private TestFactory _factory;
        private Test _test;

        public MockRunnable(TestFactory factory) {
            this._factory = factory;
        }

        public void run() {
            this._test = this._factory.getTest();
        }

        public Test getTest() {
            return this._test;
        }
    }
}

