/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGOptionsObject;
import com.sun.jimi.core.encoder.png.PNGWrite;
import com.sun.jimi.core.encoder.png.png_chunk_ihdr;
import com.sun.jimi.core.encoder.png.png_chunk_plte;
import com.sun.jimi.core.encoder.png.png_chunk_trns;
import com.sun.jimi.core.options.PNGOptions;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PNGEncoder
extends JimiEncoderBase
implements PNGConstants {
    private OutputStream out;
    private BufferedOutputStream bOut;
    private DataOutputStream dOut;
    private int state;
    Boolean alpha = null;
    byte interlace = 0;
    int compression = 0;

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        this.encodePNG(adaptiveRasterImage, this.dOut);
        this.state |= 2;
        try {
            this.dOut.flush();
        }
        catch (IOException iOException) {
            throw new JimiException("IOException");
        }
        return false;
    }

    private void encodePNG(AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException {
        try {
            PNGChunkUtil pNGChunkUtil = new PNGChunkUtil();
            png_chunk_ihdr png_chunk_ihdr2 = new png_chunk_ihdr(adaptiveRasterImage, pNGChunkUtil, this);
            png_chunk_plte png_chunk_plte2 = new png_chunk_plte(adaptiveRasterImage, pNGChunkUtil, this);
            png_chunk_trns png_chunk_trns2 = this.alpha != Boolean.FALSE ? new png_chunk_trns(adaptiveRasterImage, pNGChunkUtil, this) : null;
            PNGWrite pNGWrite = new PNGWrite(adaptiveRasterImage, png_chunk_ihdr2, 8192, pNGChunkUtil, this);
            pNGWrite.png_write_sig(dataOutputStream);
            png_chunk_ihdr2.write(dataOutputStream);
            png_chunk_plte2.write(dataOutputStream);
            if (this.alpha != Boolean.FALSE) {
                png_chunk_trns2.write(dataOutputStream);
            }
            pNGWrite.png_write_sbit(dataOutputStream);
            pNGWrite.writeImageData(dataOutputStream);
            pNGWrite.png_write_iend(dataOutputStream);
        }
        catch (IOException iOException) {
            throw new JimiException("IOException");
        }
    }

    public void freeEncoder() throws JimiException {
        this.out = null;
        this.bOut = null;
        super.freeEncoder();
    }

    Boolean getAlpha() {
        return this.alpha;
    }

    int getCompression() {
        return this.compression;
    }

    byte getFilter() {
        return 0;
    }

    byte getInterlace() {
        return this.interlace;
    }

    public OptionsObject getOptionsObject() {
        return new PNGOptionsObject(this);
    }

    public int getState() {
        return this.state;
    }

    protected void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.out = outputStream;
        this.bOut = new BufferedOutputStream(outputStream);
        this.dOut = new DataOutputStream(this.bOut);
        this.state = 0;
        if (adaptiveRasterImage.getOptions() instanceof PNGOptions) {
            int n = ((PNGOptions)adaptiveRasterImage.getOptions()).getCompressionType();
            switch (n) {
                case 0: {
                    this.setCompression(0);
                    break;
                }
                case 2: {
                    this.setCompression(1);
                    break;
                }
                case 3: {
                    this.setCompression(9);
                    break;
                }
                default: {
                    this.setCompression(-1);
                    break;
                }
            }
        } else {
            this.setCompression(-1);
        }
    }

    public void setAlpha(Boolean bl) {
        this.alpha = bl;
    }

    void setCompression(int n) {
        this.compression = n;
    }

    void setFilter(byte by) {
    }

    void setInterlace(byte by) {
        this.interlace = by;
    }
}

