import boto3
import json
from urllib import request

print('Loading function')

def confirm_subscription(event, context):
    print("Received event: " + json.dumps(event))

    url = event.get('SubscribeURL')

    if url is None:
        return {
            'statusCode': '400',
            'body': {'msg': 'Error - missing SubscribeURL'},
            'headers': {
                'Content-Type': 'application/json',
            },
        }

    print("Subscribe URL: %s" % url)

    try:
        r = request.urlopen(url)

        print("Response code: %d" % r.getcode())
        print("Response headers: %s" % json.dumps(r.getheaders()))
        print("Response body: %s" % r.read())
    except request.HTTPError as e:
        print("HTTP error: %d" % (e.code))

    return {
        'statusCode': '200',
        'body': {'msg': 'OK', 'url': url},
        'headers': {
            'Content-Type': 'application/json',
        },
    }
