/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.ftp.FtpConnexion;
import net.sourceforge.plantuml.ftp.FtpServer;

class FtpLoop
implements Runnable {
    private final Socket incoming;
    private final FtpServer ftpServer;
    private final BufferedReader br;
    private final PrintWriter pw;
    private FtpConnexion connexion;
    private String ipClient = null;
    private int port = -1;
    private Mode mode;

    public FtpLoop(Socket socket, FtpServer ftpServer) throws IOException {
        this.incoming = socket;
        this.ftpServer = ftpServer;
        this.br = new BufferedReader(new InputStreamReader(this.incoming.getInputStream(), ftpServer.getCharset()));
        this.pw = new PrintWriter(this.incoming.getOutputStream(), true);
    }

    private void runInternal() throws IOException, InterruptedException {
        String s;
        boolean finish;
        this.localLog("Starting Loop");
        this.myOut("220 PlantUML");
        do {
            s = this.br.readLine();
            this.localLog("s=" + s);
            if (s != null) continue;
            this.pw.close();
            this.br.close();
            return;
        } while (!(finish = this.manage(s)));
    }

    private boolean manage(String cmd) throws UnknownHostException, IOException, InterruptedException {
        String upper = StringUtils.goUpperCase(cmd);
        if (upper.startsWith("USER")) {
            this.myOut("331 Password required");
            String user = cmd.substring("USER ".length());
            this.connexion = this.ftpServer.getFtpConnexion(user);
        } else if (upper.startsWith("PASS")) {
            this.myOut("230 Logged in.");
        } else if (upper.startsWith("PWD")) {
            this.myOut("257 \"/\" is current directory.");
        } else if (upper.startsWith("CWD")) {
            String dir = cmd.substring("CWD ".length());
            this.myOut("250 \"" + dir + "\" is new working directory..");
        } else if (upper.startsWith("TYPE")) {
            this.myOut("200 Command okay.");
        } else if (upper.startsWith("PORT")) {
            this.mode = Mode.ACTIF;
            StringTokenizer st = new StringTokenizer(cmd, " ,");
            st.nextToken();
            this.ipClient = st.nextToken() + "." + st.nextToken() + "." + st.nextToken() + "." + st.nextToken();
            this.port = Integer.parseInt(st.nextToken()) * 256 + Integer.parseInt(st.nextToken());
            this.myOut("200 Command okay.");
        } else if (upper.startsWith("LIST")) {
            if (this.mode == Mode.ACTIF) {
                this.listActif();
            } else {
                this.listPassif();
            }
        } else if (upper.startsWith("STOR")) {
            if (this.mode == Mode.ACTIF) {
                this.storActif(cmd);
            } else {
                this.storPassif(cmd);
            }
        } else if (upper.startsWith("PASV")) {
            this.mode = Mode.PASSIF;
            this.port = this.ftpServer.getFreePort();
            int p1 = this.port / 256;
            int p2 = this.port % 256;
            assert (this.port == p1 * 256 + p2);
            this.localLog("adr=" + this.incoming.getInetAddress().getHostAddress());
            String ipServer = this.ftpServer.getIpServer();
            this.localLog("server=" + ipServer);
            this.myOut("227 Entering Passive Mode (" + ipServer.replace('.', ',') + "," + p1 + "," + p2 + ").");
            this.ipClient = ipServer;
        } else if (upper.startsWith("RETR")) {
            if (this.mode == Mode.ACTIF) {
                this.retrActif(cmd);
            } else {
                this.retrPassif(cmd);
            }
        } else if (upper.startsWith("DELE")) {
            String file = cmd.substring("DELE ".length());
            this.connexion.delete(file);
            this.myOut("200 Command okay.");
        } else {
            if (upper.startsWith("QUIT")) {
                this.myOut("221 Goodbye.");
                return true;
            }
            if (upper.startsWith("SYST")) {
                this.myOut("215 UNIX Type: L8.");
            } else {
                this.myOut("502 Command not implemented.");
            }
        }
        return false;
    }

    private void localLog(String s) {
    }

    private void retr(String fileName, Socket soc) throws UnknownHostException, IOException, InterruptedException {
        OutputStream os = soc.getOutputStream();
        byte[] data = this.connexion.getData(fileName);
        if (data != null) {
            os.write(data);
        }
        os.flush();
        os.close();
        soc.close();
        this.myOut("226 Transfer complete.");
    }

    private void retrPassif(String s) throws UnknownHostException, IOException, InterruptedException {
        String fileName = s.substring("STOR ".length());
        if (!this.connexion.willExist(fileName = this.removeStartingsSlash(fileName))) {
            this.myOut("550 No such file.");
            return;
        }
        this.myOut("150 Opening");
        this.waitForMe(fileName);
        ServerSocket ss = new ServerSocket(this.port);
        Socket incoming = ss.accept();
        this.retr(fileName, incoming);
        ss.close();
    }

    private void waitForMe(String fileName) throws InterruptedException {
        while (!this.connexion.doesExist(fileName)) {
            Thread.sleep(200L);
        }
        return;
    }

    private void retrActif(String s) throws UnknownHostException, IOException, InterruptedException {
        String fileName = s.substring("STOR ".length());
        if (!this.connexion.willExist(fileName = this.removeStartingsSlash(fileName))) {
            this.myOut("550 No such file.");
            return;
        }
        this.myOut("150 Opening");
        this.waitForMe(fileName);
        Socket soc = new Socket(this.ipClient, this.port);
        this.retr(fileName, soc);
    }

    private void storActif(String s) throws IOException {
        String fileName = this.removeStartingsSlash(s.substring("STOR ".length()));
        this.myOut("150 FILE: " + fileName);
        Socket soc = new Socket(this.ipClient, this.port);
        this.stor(fileName, soc);
    }

    private void storPassif(String s) throws IOException {
        String fileName = this.removeStartingsSlash(s.substring("STOR ".length()));
        this.myOut("150 FILE: " + fileName);
        ServerSocket ss = new ServerSocket(this.port);
        Socket incoming = ss.accept();
        this.stor(fileName, incoming);
        ss.close();
    }

    private String removeStartingsSlash(String fileName) {
        while (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private void stor(String fileName, Socket socket) throws UnknownHostException, IOException {
        InputStream is = socket.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copyToStream(is, (OutputStream)baos);
        this.myOut("226 Transfer complete.");
        if ("png".equalsIgnoreCase(fileName)) {
            this.connexion.setFileFormat(FileFormat.PNG);
        } else if ("svg".equalsIgnoreCase(fileName)) {
            this.connexion.setFileFormat(FileFormat.SVG);
        } else if ("eps".equalsIgnoreCase(fileName)) {
            this.connexion.setFileFormat(FileFormat.EPS);
        }
        if (fileName.length() > 3) {
            String data = new String(baos.toByteArray(), this.ftpServer.getCharset());
            String pngFileName = this.connexion.getFutureFileName(fileName);
            this.connexion.futureOutgoing(pngFileName);
            this.connexion.addIncoming(fileName, data);
            this.ftpServer.processImage(this.connexion, fileName);
        }
    }

    private void listActif() throws UnknownHostException, IOException {
        this.myOut("150 Opening ASCII mode data");
        Socket soc = new Socket(this.ipClient, this.port);
        this.list(soc);
    }

    private void listPassif() throws UnknownHostException, IOException {
        this.myOut("150 Opening ASCII mode data");
        ServerSocket ss = new ServerSocket(this.port);
        Socket incoming = ss.accept();
        this.list(incoming);
        ss.close();
    }

    private void list(Socket soc) throws IOException {
        PrintWriter listing = new PrintWriter(soc.getOutputStream(), true);
        Collection<String> files = this.connexion.getFiles();
        if (files.size() > 0) {
            int total = 0;
            for (String n : files) {
                total += (this.connexion.getSize(n) + 511) / 512;
            }
            listing.println("total " + total);
            for (String n : files) {
                String ls = String.format("%10s %4d %-8s %-8s %8d %3s %2s %5s %s", "-rw-rw-r--", 1, "plantuml", "plantuml", this.connexion.getSize(n), "Sep", 28, 2006, n);
                listing.println(ls);
            }
        }
        listing.flush();
        listing.close();
        soc.close();
        this.myOut("226 Listing completed.");
    }

    private void myOut(String s) {
        if (s.indexOf(9) != -1) {
            throw new IllegalArgumentException();
        }
        this.pw.println(s);
        this.pw.flush();
    }

    @Override
    public void run() {
        try {
            this.runInternal();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static enum Mode {
        ACTIF,
        PASSIF;

    }
}

