/*
 * FSRVP persistent state - old on disk format parsers needed for upgrades
 *
 * Copyright (C) David Disseldorp	2012-2015
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "source3/include/includes.h"
#include "source3/include/util_tdb.h"
#include "srv_fss_private.h"
#include "srv_fss_state_old.h"

#define FSS_DB_FMT_SC_SET "Pddd"
#define FSS_DB_FMT_SC "PPPBd"
#define FSS_DB_FMT_SMAP "dPPPd"

NTSTATUS fss_state_old_v0_smap_retrieve(TALLOC_CTX *mem_ctx,
					TDB_DATA *key,
					TDB_DATA *val,
					struct fss_sc_smap **smap_out)
{
	NTSTATUS status;
	struct fss_sc_smap *smap;
	int len;
	int snum_ignored;
	char *share_name;
	char *sc_share_name;
	char *sc_share_comment;

	smap = talloc_zero(mem_ctx, struct fss_sc_smap);
	if (smap == NULL) {
		return NT_STATUS_NO_MEMORY;
	}

	len = tdb_unpack(val->dptr, val->dsize, FSS_DB_FMT_SMAP,
			 &snum_ignored, &share_name, &sc_share_name,
			 &sc_share_comment, (int *)&smap->is_exposed);
	if  (len < 0) {
		return NT_STATUS_NO_MEMORY;
	}

	smap->share_name = talloc_strdup(smap, share_name);
	if (smap->share_name == NULL) {
		status = NT_STATUS_NO_MEMORY;
		goto err_unpack_free;
	}

	/* store the full path so that the heirarchy can be rebuilt */
	smap->sc_share_name = talloc_strdup(smap, (char *)key->dptr);
	if (smap->sc_share_name == NULL) {
		status = NT_STATUS_NO_MEMORY;
		goto err_unpack_free;
	}

	/* sc_share_comment may be empty, keep null in such a case */
	if (strlen(sc_share_comment) > 0) {
		smap->sc_share_comment = talloc_strdup(smap, sc_share_comment);
		if (smap->sc_share_comment == NULL) {
			status = NT_STATUS_NO_MEMORY;
			goto err_unpack_free;
		}
	}

	status = NT_STATUS_OK;
	*smap_out = smap;

err_unpack_free:
	free(share_name);
	free(sc_share_name);
	free(sc_share_comment);
	return status;
}

NTSTATUS fss_state_old_v0_sc_retrieve(TALLOC_CTX *mem_ctx,
				      TDB_DATA *key,
				      TDB_DATA *val,
				      struct fss_sc **sc_out)
{
	NTSTATUS status;
	struct fss_sc *sc;
	int len;
	char *id_str;
	char *volume_name;
	char *sc_path;
	int ts_size;
	time_t *create_ts;

	sc = talloc_zero(mem_ctx, struct fss_sc);
	if (sc == NULL) {
		return NT_STATUS_NO_MEMORY;
	}

	len = tdb_unpack(val->dptr, val->dsize, FSS_DB_FMT_SC,
			 &id_str, &volume_name, &sc_path,
			 &ts_size, &create_ts, &sc->smaps_count);
	if  (len < 0) {
		return NT_STATUS_NO_MEMORY;
	}
	SMB_ASSERT(ts_size == sizeof(*create_ts));

	/* store the full path so that the heirarchy can be rebuilt */
	sc->id_str = talloc_strdup(sc, (char *)key->dptr);
	if (sc->id_str == NULL) {
		status = NT_STATUS_NO_MEMORY;
		goto err_unpack_free;
	}

	sc->volume_name = talloc_strdup(sc, volume_name);
	if (sc->volume_name == NULL) {
		status = NT_STATUS_NO_MEMORY;
		goto err_unpack_free;
	}

	/* sc_path may be empty, keep null in such a case */
	if (strlen(sc_path) > 0) {
		sc->sc_path = talloc_strdup(sc, sc_path);
		if (sc->sc_path == NULL) {
			status = NT_STATUS_NO_MEMORY;
			goto err_unpack_free;
		}
	}

	sc->create_ts = *create_ts;
	status = NT_STATUS_OK;
	*sc_out = sc;

err_unpack_free:
	free(id_str);
	free(volume_name);
	free(sc_path);
	free(create_ts);
	return status;
}

NTSTATUS fss_state_old_v0_sc_set_retrieve(TALLOC_CTX *mem_ctx,
					  TDB_DATA *key,
					  TDB_DATA *val,
					  struct fss_sc_set **sc_set_out)
{
	NTSTATUS status;
	struct fss_sc_set *sc_set;
	int len;
	char *id_str;

	sc_set = talloc_zero(mem_ctx, struct fss_sc_set);
	if (sc_set == NULL) {
		return NT_STATUS_NO_MEMORY;
	}

	len = tdb_unpack(val->dptr, val->dsize, FSS_DB_FMT_SC_SET,
			 &id_str, (int *)&sc_set->state, &sc_set->context,
			 &sc_set->scs_count);
	if  (len < 0) {
		return NT_STATUS_NO_MEMORY;
	}

	/* store the full path so that the heirarchy can be rebuilt */
	sc_set->id_str = talloc_strdup(sc_set, (char *)key->dptr);
	if (sc_set->id_str == NULL) {
		status = NT_STATUS_NO_MEMORY;
		goto err_unpack_free;
	}

	status = NT_STATUS_OK;
	*sc_set_out = sc_set;

err_unpack_free:
	free(id_str);
	return status;
}
