# Environment variables to configure boot/root/rescue images

Images are eventually generated by the `bin/mk_image` script which uses file lists as defined
in `data/*/*.file_list` (see [file list docu](files.md)).

The options here are environment variables used by `mk_image`. They are typically set in `Makefile`.

Notation: in the reference below, the uppercase FOO is the value of the option
(environment variable) lowercase foo.

## General options

<!--
use this to find out actual usage:
  grep bin/mk_image Makefile | tr ' ' '\n' | sort -u
-->

- alternatives=1

  perform a fix-up of update-alternatives links.
  (Used only for the zenroot image, for other images the links are maintained
  manually in the *.file_list files.)

- disjunct=DISJUNCT (eg. `initrd`, `root`)

  The image will include only files that are not in the DISJUNCT image.
  It's basically a deduplication used for inst-sys 'extensions' (like `bind`,
  `gdb`...).

  The same thing (but done explicitly by calling the `common_tree` script) is
  done in the `root+rescue` make target to separate `initrd`, `root`, and
  `rescue` image into 4 disjunct parts.

- filelist=FILELIST

  use SRC/FILELIST.file_list

- fs=FS (eg. `dir`, `squashfs`, `cpio`, default: `none`)

  Use FS as the filesystem for the image.
  May end with `.gz` or `.xz` for compression.

- image=IMAGE (mandatory)

  Use tmp/IMAGE as temporary directory and image/IMAGE as the final image

- tmpdir=f


- kernel=KERNELRPM (eg. `kernel-default`)

  name of kernel RPM, available as `<kernel_rpm>` in *.file_list

- libdeps=DEPS (a comma separated list)

  run `bin/check_libs` on the DEPS (in `tmp/`)

- mode=MODE (`add`, `keep`)

  The default mode:

  1. erases the TMPDIR
  2. adds files according to FILELIST
  3. packs the TMPDIR with FS into IMAGE

  `mode=add` skips (1), and `mode=keep` skips (1) and (2).

- nolinkcheck=1

  don't check for dangling symlinks

- src=SRC (eg. `boot`, `initrd`, `rescue`, `root+rescue`, default: IMAGE)

  look in the `data`/*SRC* directory.

- tmpdir=*TMPDIR*

  Use tmp/TMPDIR instead of tmp/IMAGE as the temporary directory.

  It is similar to RPM BuildRoot as it holds the file tree in the unpacked
  state just before being packaged (see FS) in the IMAGE.

- ignore_packages=package1,package2,...

  List of packages that should always be ignored. Useful for resolving package ambiguities.

  Only valid when building outside OBS.

<!-- old -->

- debug=DEBUG (comma separated tags, eg. `solv`, `filedeps`, `ignore`,
  `ignorelibs`, `pkg`, `if`)

  `ignore`: ignore noncritical errors

- theme=THEME (default: `openSUSE`)

  select this theme


## initrd specific


- linuxrc=LINUXRC (a full path or a file name in /usr/sbin)

  use the specified linuxrc (taken from the running system!).
  Caveats may apply: please also refer to the
  [linuxrc](https://github.com/openSUSE/linuxrc) docs
  and the [troubleshooting section](#troubleshooting-and-hacks).

- with_gdb=1|2|3

  create an initrd with gdb; if with_gdb=2 start linuxrc from gdb


## Obsolete options

They are not used in the current product builds.
Code still exists for them but it may be broken.

- nostrip=1

  Used in the Makefile but ignored in the code. FIXME. See also
  [commit c109ec79](https://github.com/openSUSE/installation-images/commit/c109ec79b432b95454b98216dc2fd07fa8c9b8c4). 

- dist=8.1, dist=8.1-i386+kde

  build for this release
