/*========================== begin_copyright_notice ============================

Copyright (C) 2020-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

#include "../imf.h"
#pragma OPENCL FP_CONTRACT OFF
typedef struct
{
    unsigned long Exp_tbl_H[16];
    unsigned long Exp_tbl_L[16];
    unsigned long L2E;
    unsigned long Shifter;
    unsigned long L2H;
    unsigned long L2L;
    unsigned long EMask;
    unsigned long poly_coeff6;
    unsigned long poly_coeff5;
    unsigned long poly_coeff4;
    unsigned long poly_coeff3;
    unsigned long poly_coeff2;
    unsigned long poly_coeff1;
    unsigned long AbsMask;
    unsigned long Threshold;
    unsigned long SmallX;
    unsigned long IndexMask;
    unsigned long ExponMask;
} __internal_dexp_la_data_avx512_t;
static __constant __internal_dexp_la_data_avx512_t __internal_dexp_la_data_avx512 = {
    {
     0x3ff0000000000000uL, 0x3ff0b5586cf9890fuL, 0x3ff172b83c7d517buL, 0x3ff2387a6e756238uL, 0x3ff306fe0a31b715uL, 0x3ff3dea64c123422uL,
     0x3ff4bfdad5362a27uL, 0x3ff5ab07dd485429uL, 0x3ff6a09e667f3bcduL, 0x3ff7a11473eb0187uL, 0x3ff8ace5422aa0dbuL, 0x3ff9c49182a3f090uL,
     0x3ffae89f995ad3aduL, 0x3ffc199bdd85529cuL, 0x3ffd5818dcfba487uL, 0x3ffea4afa2a490dauL}
    , {
       0x0000000000000000uL, 0x3c979aa65d837b6duL, 0xbc801b15eaa59348uL, 0x3c968efde3a8a894uL, 0x3c834d754db0abb6uL, 0x3c859f48a72a4c6duL,
       0x3c7690cebb7aafb0uL, 0x3c9063e1e21c5409uL, 0xbc93b3efbf5e2228uL, 0xbc7b32dcb94da51duL, 0x3c8db72fc1f0eab4uL, 0x3c71affc2b91ce27uL,
       0x3c8c1a7792cb3387uL, 0x3c736eae30af0cb3uL, 0x3c74a385a63d07a7uL, 0xbc8ff7128fd391f0uL}

    , 0x3ff71547652B82FEuL, 0x42f8000000003ff0uL, 0x3fe62e42fefa39efuL, 0x3c7abc9e3b39803fuL, 0xbfffffffffffffffuL, 0x3f572eb5ef0d213duL,
        0x3f81106603d97c00uL, 0x3fa555564bb4f5f0uL, 0x3fc5555554b508a2uL, 0x3fe0000000002622uL, 0x3fefffffffffff70uL, 0x7fffffffffffffffuL,
        0x40861DA04CBAFE44uL, 0x3bf0000000000000uL, 0x0000000000000078uL, 0x0000000000007ff0uL
};

typedef struct
{
    unsigned long _dbT[(1 << 10)];

    unsigned long _dbInvLn2;
    unsigned long _dbShifter;
    unsigned long _dbLn2hi;
    unsigned long _dbLn2lo;

    unsigned long _dPC0;
    unsigned long _dPC1;
    unsigned long _dPC2;
    unsigned long _lIndexMask;

    unsigned int _iAbsMask;
    unsigned int _iDomainRange;
    unsigned long _dbOvfThreshold;
    unsigned long _dbUdfThreshold;
} __internal_dexp_la_data_t;
static __constant __internal_dexp_la_data_t __internal_dexp_la_data = {
    {

     0x3FF0000000000000uL,
     0x3FF002C605E2E8CFuL,
     0x3FF0058C86DA1C0AuL,
     0x3FF0085382FAEF83uL,
     0x3FF00B1AFA5ABCBFuL,
     0x3FF00DE2ED0EE0F5uL,
     0x3FF010AB5B2CBD11uL,
     0x3FF0137444C9B5B5uL,
     0x3FF0163DA9FB3335uL,
     0x3FF019078AD6A19FuL,
     0x3FF01BD1E77170B4uL,
     0x3FF01E9CBFE113EFuL,
     0x3FF02168143B0281uL,
     0x3FF02433E494B755uL,
     0x3FF027003103B10EuL,
     0x3FF029CCF99D720AuL,
     0x3FF02C9A3E778061uL,
     0x3FF02F67FFA765E6uL,
     0x3FF032363D42B027uL,
     0x3FF03504F75EF071uL,
     0x3FF037D42E11BBCCuL,
     0x3FF03AA3E170AAFEuL,
     0x3FF03D7411915A8AuL,
     0x3FF04044BE896AB6uL,
     0x3FF04315E86E7F85uL,
     0x3FF045E78F5640B9uL,
     0x3FF048B9B35659D8uL,
     0x3FF04B8C54847A28uL,
     0x3FF04E5F72F654B1uL,
     0x3FF051330EC1A03FuL,
     0x3FF0540727FC1762uL,
     0x3FF056DBBEBB786BuL,
     0x3FF059B0D3158574uL,
     0x3FF05C866520045BuL,
     0x3FF05F5C74F0BEC2uL,
     0x3FF06233029D8216uL,
     0x3FF0650A0E3C1F89uL,
     0x3FF067E197E26C14uL,
     0x3FF06AB99FA6407CuL,
     0x3FF06D92259D794DuL,
     0x3FF0706B29DDF6DEuL,
     0x3FF07344AC7D9D51uL,
     0x3FF0761EAD925493uL,
     0x3FF078F92D32085DuL,
     0x3FF07BD42B72A836uL,
     0x3FF07EAFA86A2771uL,
     0x3FF0818BA42E7D30uL,
     0x3FF084681ED5A462uL,
     0x3FF0874518759BC8uL,
     0x3FF08A22912465F2uL,
     0x3FF08D0088F8093FuL,
     0x3FF08FDF00068FE2uL,
     0x3FF092BDF66607E0uL,
     0x3FF0959D6C2C830DuL,
     0x3FF0987D61701716uL,
     0x3FF09B5DD646DD77uL,
     0x3FF09E3ECAC6F383uL,
     0x3FF0A1203F067A63uL,
     0x3FF0A402331B9715uL,
     0x3FF0A6E4A71C726EuL,
     0x3FF0A9C79B1F3919uL,
     0x3FF0ACAB0F3A1B9CuL,
     0x3FF0AF8F03834E52uL,
     0x3FF0B27378110974uL,
     0x3FF0B5586CF9890FuL,
     0x3FF0B83DE2530D11uL,
     0x3FF0BB23D833D93FuL,
     0x3FF0BE0A4EB2353BuL,
     0x3FF0C0F145E46C85uL,
     0x3FF0C3D8BDE0CE7AuL,
     0x3FF0C6C0B6BDAE53uL,
     0x3FF0C9A93091632AuL,
     0x3FF0CC922B7247F7uL,
     0x3FF0CF7BA776BB94uL,
     0x3FF0D265A4B520BAuL,
     0x3FF0D5502343DE02uL,
     0x3FF0D83B23395DECuL,
     0x3FF0DB26A4AC0ED5uL,
     0x3FF0DE12A7B26300uL,
     0x3FF0E0FF2C62D096uL,
     0x3FF0E3EC32D3D1A2uL,
     0x3FF0E6D9BB1BE415uL,
     0x3FF0E9C7C55189C6uL,
     0x3FF0ECB6518B4874uL,
     0x3FF0EFA55FDFA9C5uL,
     0x3FF0F294F0653B45uL,
     0x3FF0F58503328E6DuL,
     0x3FF0F875985E389BuL,
     0x3FF0FB66AFFED31BuL,
     0x3FF0FE584A2AFB21uL,
     0x3FF1014A66F951CEuL,
     0x3FF1043D06807C2FuL,
     0x3FF1073028D7233EuL,
     0x3FF10A23CE13F3E2uL,
     0x3FF10D17F64D9EF1uL,
     0x3FF1100CA19AD92FuL,
     0x3FF11301D0125B51uL,
     0x3FF115F781CAE1FAuL,
     0x3FF118EDB6DB2DC1uL,
     0x3FF11BE46F5A032CuL,
     0x3FF11EDBAB5E2AB6uL,
     0x3FF121D36AFE70C9uL,
     0x3FF124CBAE51A5C8uL,
     0x3FF127C4756E9E05uL,
     0x3FF12ABDC06C31CCuL,
     0x3FF12DB78F613D5BuL,
     0x3FF130B1E264A0E9uL,
     0x3FF133ACB98D40A2uL,
     0x3FF136A814F204ABuL,
     0x3FF139A3F4A9D922uL,
     0x3FF13CA058CBAE1EuL,
     0x3FF13F9D416E77AFuL,
     0x3FF1429AAEA92DE0uL,
     0x3FF14598A092CCB7uL,
     0x3FF1489717425438uL,
     0x3FF14B9612CEC861uL,
     0x3FF14E95934F312EuL,
     0x3FF1519598DA9A9AuL,
     0x3FF154962388149EuL,
     0x3FF15797336EB333uL,
     0x3FF15A98C8A58E51uL,
     0x3FF15D9AE343C1F2uL,
     0x3FF1609D83606E12uL,
     0x3FF163A0A912B6ACuL,
     0x3FF166A45471C3C2uL,
     0x3FF169A88594C157uL,
     0x3FF16CAD3C92DF73uL,
     0x3FF16FB279835224uL,
     0x3FF172B83C7D517BuL,
     0x3FF175BE85981992uL,
     0x3FF178C554EAEA89uL,
     0x3FF17BCCAA8D0888uL,
     0x3FF17ED48695BBC0uL,
     0x3FF181DCE91C506AuL,
     0x3FF184E5D23816C9uL,
     0x3FF187EF4200632BuL,
     0x3FF18AF9388C8DEAuL,
     0x3FF18E03B5F3F36BuL,
     0x3FF1910EBA4DF41FuL,
     0x3FF1941A45B1F487uL,
     0x3FF1972658375D2FuL,
     0x3FF19A32F1F59AB4uL,
     0x3FF19D4013041DC2uL,
     0x3FF1A04DBB7A5B13uL,
     0x3FF1A35BEB6FCB75uL,
     0x3FF1A66AA2FBEBC7uL,
     0x3FF1A979E2363CF8uL,
     0x3FF1AC89A936440DuL,
     0x3FF1AF99F8138A1CuL,
     0x3FF1B2AACEE59C53uL,
     0x3FF1B5BC2DC40BF0uL,
     0x3FF1B8CE14C66E4CuL,
     0x3FF1BBE084045CD4uL,
     0x3FF1BEF37B95750BuL,
     0x3FF1C206FB91588FuL,
     0x3FF1C51B040FAD15uL,
     0x3FF1C82F95281C6BuL,
     0x3FF1CB44AEF2547AuL,
     0x3FF1CE5A51860746uL,
     0x3FF1D1707CFAEAEDuL,
     0x3FF1D4873168B9AAuL,
     0x3FF1D79E6EE731D7uL,
     0x3FF1DAB6358E15E8uL,
     0x3FF1DDCE85752C71uL,
     0x3FF1E0E75EB44027uL,
     0x3FF1E400C1631FDBuL,
     0x3FF1E71AAD999E82uL,
     0x3FF1EA35236F9330uL,
     0x3FF1ED5022FCD91DuL,
     0x3FF1F06BAC594FA0uL,
     0x3FF1F387BF9CDA38uL,
     0x3FF1F6A45CDF6085uL,
     0x3FF1F9C18438CE4DuL,
     0x3FF1FCDF35C1137AuL,
     0x3FF1FFFD7190241EuL,
     0x3FF2031C37BDF872uL,
     0x3FF2063B88628CD6uL,
     0x3FF2095B6395E1D2uL,
     0x3FF20C7BC96FFC18uL,
     0x3FF20F9CBA08E483uL,
     0x3FF212BE3578A819uL,
     0x3FF215E03BD7580CuL,
     0x3FF21902CD3D09B9uL,
     0x3FF21C25E9C1D6AAuL,
     0x3FF21F49917DDC96uL,
     0x3FF2226DC4893D64uL,
     0x3FF2259282FC1F27uL,
     0x3FF228B7CCEEAC25uL,
     0x3FF22BDDA27912D1uL,
     0x3FF22F0403B385D2uL,
     0x3FF2322AF0B63BFFuL,
     0x3FF2355269997062uL,
     0x3FF2387A6E756238uL,
     0x3FF23BA2FF6254F4uL,
     0x3FF23ECC1C78903AuL,
     0x3FF241F5C5D05FE6uL,
     0x3FF2451FFB82140AuL,
     0x3FF2484ABDA600EFuL,
     0x3FF24B760C547F15uL,
     0x3FF24EA1E7A5EB35uL,
     0x3FF251CE4FB2A63FuL,
     0x3FF254FB44931561uL,
     0x3FF25828C65FA1FFuL,
     0x3FF25B56D530B9BCuL,
     0x3FF25E85711ECE75uL,
     0x3FF261B49A425645uL,
     0x3FF264E450B3CB82uL,
     0x3FF26814948BACC3uL,
     0x3FF26B4565E27CDDuL,
     0x3FF26E76C4D0C2E5uL,
     0x3FF271A8B16F0A30uL,
     0x3FF274DB2BD5E254uL,
     0x3FF2780E341DDF29uL,
     0x3FF27B41CA5F98CBuL,
     0x3FF27E75EEB3AB98uL,
     0x3FF281AAA132B832uL,
     0x3FF284DFE1F56381uL,
     0x3FF28815B11456B1uL,
     0x3FF28B4C0EA83F36uL,
     0x3FF28E82FAC9CECAuL,
     0x3FF291BA7591BB70uL,
     0x3FF294F27F18BF72uL,
     0x3FF2982B17779965uL,
     0x3FF29B643EC70C27uL,
     0x3FF29E9DF51FDEE1uL,
     0x3FF2A1D83A9ADD08uL,
     0x3FF2A5130F50D65CuL,
     0x3FF2A84E735A9EECuL,
     0x3FF2AB8A66D10F13uL,
     0x3FF2AEC6E9CD037BuL,
     0x3FF2B203FC675D1FuL,
     0x3FF2B5419EB90148uL,
     0x3FF2B87FD0DAD990uL,
     0x3FF2BBBE92E5D3E3uL,
     0x3FF2BEFDE4F2E280uL,
     0x3FF2C23DC71AFBF7uL,
     0x3FF2C57E39771B2FuL,
     0x3FF2C8BF3C203F5FuL,
     0x3FF2CC00CF2F6C18uL,
     0x3FF2CF42F2BDA93DuL,
     0x3FF2D285A6E4030BuL,
     0x3FF2D5C8EBBB8A15uL,
     0x3FF2D90CC15D5346uL,
     0x3FF2DC5127E277E3uL,
     0x3FF2DF961F641589uL,
     0x3FF2E2DBA7FB4E33uL,
     0x3FF2E621C1C14833uL,
     0x3FF2E9686CCF2E3BuL,
     0x3FF2ECAFA93E2F56uL,
     0x3FF2EFF777277EF0uL,
     0x3FF2F33FD6A454D2uL,
     0x3FF2F688C7CDED23uL,
     0x3FF2F9D24ABD886BuL,
     0x3FF2FD1C5F8C6B93uL,
     0x3FF300670653DFE4uL,
     0x3FF303B23F2D330BuL,
     0x3FF306FE0A31B715uL,
     0x3FF30A4A677AC276uL,
     0x3FF30D975721B004uL,
     0x3FF310E4D93FDEFBuL,
     0x3FF31432EDEEB2FDuL,
     0x3FF3178195479413uL,
     0x3FF31AD0CF63EEACuL,
     0x3FF31E209C5D33A0uL,
     0x3FF32170FC4CD831uL,
     0x3FF324C1EF4C560AuL,
     0x3FF3281375752B40uL,
     0x3FF32B658EE0DA54uL,
     0x3FF32EB83BA8EA32uL,
     0x3FF3320B7BE6E633uL,
     0x3FF3355F4FB45E20uL,
     0x3FF338B3B72AE62DuL,
     0x3FF33C08B26416FFuL,
     0x3FF33F5E41798DAAuL,
     0x3FF342B46484EBB4uL,
     0x3FF3460B1B9FD712uL,
     0x3FF3496266E3FA2DuL,
     0x3FF34CBA466B03E1uL,
     0x3FF35012BA4EA77DuL,
     0x3FF3536BC2A89CC4uL,
     0x3FF356C55F929FF1uL,
     0x3FF35A1F912671B1uL,
     0x3FF35D7A577DD72BuL,
     0x3FF360D5B2B299FCuL,
     0x3FF36431A2DE883BuL,
     0x3FF3678E281B7475uL,
     0x3FF36AEB428335B4uL,
     0x3FF36E48F22FA77CuL,
     0x3FF371A7373AA9CBuL,
     0x3FF3750611BE211CuL,
     0x3FF3786581D3F669uL,
     0x3FF37BC587961726uL,
     0x3FF37F26231E754AuL,
     0x3FF3828754870746uL,
     0x3FF385E91BE9C811uL,
     0x3FF3894B7960B71FuL,
     0x3FF38CAE6D05D866uL,
     0x3FF39011F6F3345FuL,
     0x3FF393761742D808uL,
     0x3FF396DACE0ED4E1uL,
     0x3FF39A401B7140EFuL,
     0x3FF39DA5FF8436BCuL,
     0x3FF3A10C7A61D55BuL,
     0x3FF3A4738C244064uL,
     0x3FF3A7DB34E59FF7uL,
     0x3FF3AB4374C020BDuL,
     0x3FF3AEAC4BCDF3EAuL,
     0x3FF3B215BA294F39uL,
     0x3FF3B57FBFEC6CF4uL,
     0x3FF3B8EA5D318BEFuL,
     0x3FF3BC559212EF89uL,
     0x3FF3BFC15EAADFB1uL,
     0x3FF3C32DC313A8E5uL,
     0x3FF3C69ABF679C2EuL,
     0x3FF3CA0853C10F28uL,
     0x3FF3CD76803A5C00uL,
     0x3FF3D0E544EDE173uL,
     0x3FF3D454A1F602D0uL,
     0x3FF3D7C4976D27FAuL,
     0x3FF3DB35256DBD67uL,
     0x3FF3DEA64C123422uL,
     0x3FF3E2180B7501CCuL,
     0x3FF3E58A63B0A09BuL,
     0x3FF3E8FD54DF8F5CuL,
     0x3FF3EC70DF1C5175uL,
     0x3FF3EFE502816EE3uL,
     0x3FF3F359BF29743FuL,
     0x3FF3F6CF152EF2B8uL,
     0x3FF3FA4504AC801CuL,
     0x3FF3FDBB8DBCB6D2uL,
     0x3FF40132B07A35DFuL,
     0x3FF404AA6CFFA0E5uL,
     0x3FF40822C367A024uL,
     0x3FF40B9BB3CCE07CuL,
     0x3FF40F153E4A136AuL,
     0x3FF4128F62F9EF0EuL,
     0x3FF4160A21F72E2AuL,
     0x3FF419857B5C901FuL,
     0x3FF41D016F44D8F5uL,
     0x3FF4207DFDCAD153uL,
     0x3FF423FB2709468AuL,
     0x3FF42778EB1B0A8BuL,
     0x3FF42AF74A1AF3F1uL,
     0x3FF42E764423DDFDuL,
     0x3FF431F5D950A897uL,
     0x3FF4357609BC3850uL,
     0x3FF438F6D5817663uL,
     0x3FF43C783CBB50B4uL,
     0x3FF43FFA3F84B9D4uL,
     0x3FF4437CDDF8A8FEuL,
     0x3FF4470018321A1AuL,
     0x3FF44A83EE4C0DBDuL,
     0x3FF44E086061892DuL,
     0x3FF4518D6E8D965BuL,
     0x3FF4551318EB43ECuL,
     0x3FF458995F95A532uL,
     0x3FF45C2042A7D232uL,
     0x3FF45FA7C23CE7A4uL,
     0x3FF4632FDE7006F4uL,
     0x3FF466B8975C563EuL,
     0x3FF46A41ED1D0057uL,
     0x3FF46DCBDFCD34C8uL,
     0x3FF471566F8827D0uL,
     0x3FF474E19C691265uL,
     0x3FF4786D668B3237uL,
     0x3FF47BF9CE09C9ABuL,
     0x3FF47F86D3001FE5uL,
     0x3FF48314758980BFuL,
     0x3FF486A2B5C13CD0uL,
     0x3FF48A3193C2A96CuL,
     0x3FF48DC10FA920A1uL,
     0x3FF491512990013FuL,
     0x3FF494E1E192AED2uL,
     0x3FF4987337CC91A5uL,
     0x3FF49C052C5916C4uL,
     0x3FF49F97BF53AFFDuL,
     0x3FF4A32AF0D7D3DEuL,
     0x3FF4A6BEC100FDBAuL,
     0x3FF4AA532FEAADA6uL,
     0x3FF4ADE83DB0687AuL,
     0x3FF4B17DEA6DB7D7uL,
     0x3FF4B514363E2A20uL,
     0x3FF4B8AB213D5283uL,
     0x3FF4BC42AB86C8F1uL,
     0x3FF4BFDAD5362A27uL,
     0x3FF4C3739E6717AAuL,
     0x3FF4C70D073537CAuL,
     0x3FF4CAA70FBC35A1uL,
     0x3FF4CE41B817C114uL,
     0x3FF4D1DD00638ED8uL,
     0x3FF4D578E8BB586BuL,
     0x3FF4D915713ADC1EuL,
     0x3FF4DCB299FDDD0DuL,
     0x3FF4E05063202327uL,
     0x3FF4E3EECCBD7B2AuL,
     0x3FF4E78DD6F1B6A6uL,
     0x3FF4EB2D81D8ABFFuL,
     0x3FF4EECDCD8E3669uL,
     0x3FF4F26EBA2E35F0uL,
     0x3FF4F61047D48F73uL,
     0x3FF4F9B2769D2CA7uL,
     0x3FF4FD5546A3FC17uL,
     0x3FF500F8B804F127uL,
     0x3FF5049CCADC0412uL,
     0x3FF508417F4531EEuL,
     0x3FF50BE6D55C7CA9uL,
     0x3FF50F8CCD3DEB0DuL,
     0x3FF51333670588BFuL,
     0x3FF516DAA2CF6642uL,
     0x3FF51A8280B798F4uL,
     0x3FF51E2B00DA3B14uL,
     0x3FF521D423536BBEuL,
     0x3FF5257DE83F4EEFuL,
     0x3FF529284FBA0D84uL,
     0x3FF52CD359DFD53DuL,
     0x3FF5307F06CCD8BAuL,
     0x3FF5342B569D4F82uL,
     0x3FF537D8496D75FCuL,
     0x3FF53B85DF598D78uL,
     0x3FF53F34187DDC28uL,
     0x3FF542E2F4F6AD27uL,
     0x3FF5469274E05078uL,
     0x3FF54A4298571B06uL,
     0x3FF54DF35F7766A3uL,
     0x3FF551A4CA5D920FuL,
     0x3FF55556D92600F1uL,
     0x3FF559098BED1BDFuL,
     0x3FF55CBCE2CF505BuL,
     0x3FF56070DDE910D2uL,
     0x3FF564257D56D4A2uL,
     0x3FF567DAC1351819uL,
     0x3FF56B90A9A05C72uL,
     0x3FF56F4736B527DAuL,
     0x3FF572FE68900573uL,
     0x3FF576B63F4D854CuL,
     0x3FF57A6EBB0A3C6DuL,
     0x3FF57E27DBE2C4CFuL,
     0x3FF581E1A1F3BD60uL,
     0x3FF5859C0D59CA07uL,
     0x3FF589571E31939FuL,
     0x3FF58D12D497C7FDuL,
     0x3FF590CF30A919EDuL,
     0x3FF5948C32824135uL,
     0x3FF59849DA3FFA96uL,
     0x3FF59C0827FF07CCuL,
     0x3FF59FC71BDC2F8EuL,
     0x3FF5A386B5F43D92uL,
     0x3FF5A746F664028BuL,
     0x3FF5AB07DD485429uL,
     0x3FF5AEC96ABE0D1FuL,
     0x3FF5B28B9EE20D1EuL,
     0x3FF5B64E79D138D8uL,
     0x3FF5BA11FBA87A03uL,
     0x3FF5BDD62484BF56uL,
     0x3FF5C19AF482FC8FuL,
     0x3FF5C5606BC02A6DuL,
     0x3FF5C9268A5946B7uL,
     0x3FF5CCED506B543AuL,
     0x3FF5D0B4BE135ACCuL,
     0x3FF5D47CD36E6747uL,
     0x3FF5D84590998B93uL,
     0x3FF5DC0EF5B1DE9EuL,
     0x3FF5DFD902D47C65uL,
     0x3FF5E3A3B81E85ECuL,
     0x3FF5E76F15AD2148uL,
     0x3FF5EB3B1B9D799AuL,
     0x3FF5EF07CA0CBF0FuL,
     0x3FF5F2D5211826E8uL,
     0x3FF5F6A320DCEB71uL,
     0x3FF5FA71C9784C0BuL,
     0x3FF5FE411B078D26uL,
     0x3FF6021115A7F849uL,
     0x3FF605E1B976DC09uL,
     0x3FF609B306918C13uL,
     0x3FF60D84FD15612AuL,
     0x3FF611579D1FB925uL,
     0x3FF6152AE6CDF6F4uL,
     0x3FF618FEDA3D829FuL,
     0x3FF61CD3778BC944uL,
     0x3FF620A8BED63D1FuL,
     0x3FF6247EB03A5585uL,
     0x3FF628554BD58EE5uL,
     0x3FF62C2C91C56ACDuL,
     0x3FF6300482276FE8uL,
     0x3FF633DD1D1929FDuL,
     0x3FF637B662B829F5uL,
     0x3FF63B90532205D8uL,
     0x3FF63F6AEE7458CDuL,
     0x3FF6434634CCC320uL,
     0x3FF647222648EA3DuL,
     0x3FF64AFEC30678B7uL,
     0x3FF64EDC0B231E41uL,
     0x3FF652B9FEBC8FB7uL,
     0x3FF656989DF08719uL,
     0x3FF65A77E8DCC390uL,
     0x3FF65E57DF9F096BuL,
     0x3FF6623882552225uL,
     0x3FF66619D11CDC5FuL,
     0x3FF669FBCC140BE7uL,
     0x3FF66DDE735889B8uL,
     0x3FF671C1C70833F6uL,
     0x3FF675A5C740EDF5uL,
     0x3FF6798A7420A036uL,
     0x3FF67D6FCDC5386AuL,
     0x3FF68155D44CA973uL,
     0x3FF6853C87D4EB62uL,
     0x3FF68923E87BFB7AuL,
     0x3FF68D0BF65FDC34uL,
     0x3FF690F4B19E9538uL,
     0x3FF694DE1A563367uL,
     0x3FF698C830A4C8D4uL,
     0x3FF69CB2F4A86CCAuL,
     0x3FF6A09E667F3BCDuL,
     0x3FF6A48A86475795uL,
     0x3FF6A877541EE718uL,
     0x3FF6AC64D0241683uL,
     0x3FF6B052FA75173EuL,
     0x3FF6B441D3301FEEuL,
     0x3FF6B8315A736C75uL,
     0x3FF6BC21905D3DF0uL,
     0x3FF6C012750BDABFuL,
     0x3FF6C404089D8E7DuL,
     0x3FF6C7F64B30AA09uL,
     0x3FF6CBE93CE38381uL,
     0x3FF6CFDCDDD47645uL,
     0x3FF6D3D12E21E2FBuL,
     0x3FF6D7C62DEA2F8AuL,
     0x3FF6DBBBDD4BC720uL,
     0x3FF6DFB23C651A2FuL,
     0x3FF6E3A94B549E71uL,
     0x3FF6E7A10A38CEE8uL,
     0x3FF6EB9979302BDDuL,
     0x3FF6EF9298593AE5uL,
     0x3FF6F38C67D286DDuL,
     0x3FF6F786E7BA9FEFuL,
     0x3FF6FB8218301B90uL,
     0x3FF6FF7DF9519484uL,
     0x3FF7037A8B3DAADBuL,
     0x3FF70777CE1303F6uL,
     0x3FF70B75C1F04A84uL,
     0x3FF70F7466F42E87uL,
     0x3FF71373BD3D6551uL,
     0x3FF71773C4EAA988uL,
     0x3FF71B747E1ABB24uL,
     0x3FF71F75E8EC5F74uL,
     0x3FF72378057E611AuL,
     0x3FF7277AD3EF9011uL,
     0x3FF72B7E545EC1A8uL,
     0x3FF72F8286EAD08AuL,
     0x3FF733876BB29CB8uL,
     0x3FF7378D02D50B8FuL,
     0x3FF73B934C7107C7uL,
     0x3FF73F9A48A58174uL,
     0x3FF743A1F7916E05uL,
     0x3FF747AA5953C849uL,
     0x3FF74BB36E0B906DuL,
     0x3FF74FBD35D7CBFDuL,
     0x3FF753C7B0D785E8uL,
     0x3FF757D2DF29CE7CuL,
     0x3FF75BDEC0EDBB6BuL,
     0x3FF75FEB564267C9uL,
     0x3FF763F89F46F40FuL,
     0x3FF768069C1A861DuL,
     0x3FF76C154CDC4937uL,
     0x3FF77024B1AB6E09uL,
     0x3FF77434CAA72AA7uL,
     0x3FF7784597EEBA8FuL,
     0x3FF77C5719A15EA6uL,
     0x3FF780694FDE5D3FuL,
     0x3FF7847C3AC50219uL,
     0x3FF7888FDA749E5DuL,
     0x3FF78CA42F0C88A5uL,
     0x3FF790B938AC1CF6uL,
     0x3FF794CEF772BCC9uL,
     0x3FF798E56B7FCF03uL,
     0x3FF79CFC94F2BFFFuL,
     0x3FF7A11473EB0187uL,
     0x3FF7A52D08880AD9uL,
     0x3FF7A94652E958AAuL,
     0x3FF7AD60532E6D20uL,
     0x3FF7B17B0976CFDBuL,
     0x3FF7B59675E20DEFuL,
     0x3FF7B9B2988FB9ECuL,
     0x3FF7BDCF719F6BD7uL,
     0x3FF7C1ED0130C132uL,
     0x3FF7C60B47635CF9uL,
     0x3FF7CA2A4456E7A3uL,
     0x3FF7CE49F82B0F24uL,
     0x3FF7D26A62FF86F0uL,
     0x3FF7D68B84F407F8uL,
     0x3FF7DAAD5E2850ACuL,
     0x3FF7DECFEEBC24FEuL,
     0x3FF7E2F336CF4E62uL,
     0x3FF7E71736819BCDuL,
     0x3FF7EB3BEDF2E1B9uL,
     0x3FF7EF615D42FA24uL,
     0x3FF7F3878491C491uL,
     0x3FF7F7AE63FF260AuL,
     0x3FF7FBD5FBAB091FuL,
     0x3FF7FFFE4BB55DECuL,
     0x3FF80427543E1A12uL,
     0x3FF80851156538BEuL,
     0x3FF80C7B8F4ABAA9uL,
     0x3FF810A6C20EA617uL,
     0x3FF814D2ADD106D9uL,
     0x3FF818FF52B1EE50uL,
     0x3FF81D2CB0D1736AuL,
     0x3FF8215AC84FB2A6uL,
     0x3FF82589994CCE13uL,
     0x3FF829B923E8ED53uL,
     0x3FF82DE968443D9AuL,
     0x3FF8321A667EF1B2uL,
     0x3FF8364C1EB941F7uL,
     0x3FF83A7E91136C5DuL,
     0x3FF83EB1BDADB46DuL,
     0x3FF842E5A4A8634AuL,
     0x3FF8471A4623C7ADuL,
     0x3FF84B4FA24035EAuL,
     0x3FF84F85B91E07F1uL,
     0x3FF853BC8ADD9D4CuL,
     0x3FF857F4179F5B21uL,
     0x3FF85C2C5F83AC35uL,
     0x3FF8606562AB00ECuL,
     0x3FF8649F2135CF48uL,
     0x3FF868D99B4492EDuL,
     0x3FF86D14D0F7CD1DuL,
     0x3FF87150C27004C2uL,
     0x3FF8758D6FCDC666uL,
     0x3FF879CAD931A436uL,
     0x3FF87E08FEBC3608uL,
     0x3FF88247E08E1957uL,
     0x3FF886877EC7F144uL,
     0x3FF88AC7D98A6699uL,
     0x3FF88F08F0F627CBuL,
     0x3FF8934AC52BE8F7uL,
     0x3FF8978D564C63E7uL,
     0x3FF89BD0A478580FuL,
     0x3FF8A014AFD08A94uL,
     0x3FF8A4597875C644uL,
     0x3FF8A89EFE88DBA1uL,
     0x3FF8ACE5422AA0DBuL,
     0x3FF8B12C437BF1D4uL,
     0x3FF8B574029DB01EuL,
     0x3FF8B9BC7FB0C302uL,
     0x3FF8BE05BAD61778uL,
     0x3FF8C24FB42EA033uL,
     0x3FF8C69A6BDB5598uL,
     0x3FF8CAE5E1FD35C4uL,
     0x3FF8CF3216B5448CuL,
     0x3FF8D37F0A248B7FuL,
     0x3FF8D7CCBC6C19E6uL,
     0x3FF8DC1B2DAD04C4uL,
     0x3FF8E06A5E0866D9uL,
     0x3FF8E4BA4D9F60A1uL,
     0x3FF8E90AFC931857uL,
     0x3FF8ED5C6B04B9F6uL,
     0x3FF8F1AE99157736uL,
     0x3FF8F60186E68793uL,
     0x3FF8FA553499284BuL,
     0x3FF8FEA9A24E9C5CuL,
     0x3FF902FED0282C8AuL,
     0x3FF90754BE472760uL,
     0x3FF90BAB6CCCE12CuL,
     0x3FF91002DBDAB403uL,
     0x3FF9145B0B91FFC6uL,
     0x3FF918B3FC142A19uL,
     0x3FF91D0DAD829E70uL,
     0x3FF921681FFECE05uL,
     0x3FF925C353AA2FE2uL,
     0x3FF92A1F48A640DCuL,
     0x3FF92E7BFF148396uL,
     0x3FF932D977168083uL,
     0x3FF93737B0CDC5E5uL,
     0x3FF93B96AC5BE7D1uL,
     0x3FF93FF669E2802BuL,
     0x3FF94456E9832EADuL,
     0x3FF948B82B5F98E5uL,
     0x3FF94D1A2F996A33uL,
     0x3FF9517CF65253D1uL,
     0x3FF955E07FAC0CCDuL,
     0x3FF95A44CBC8520FuL,
     0x3FF95EA9DAC8E658uL,
     0x3FF9630FACCF9243uL,
     0x3FF9677641FE2446uL,
     0x3FF96BDD9A7670B3uL,
     0x3FF97045B65A51BAuL,
     0x3FF974AE95CBA768uL,
     0x3FF9791838EC57ABuL,
     0x3FF97D829FDE4E50uL,
     0x3FF981EDCAC37D05uL,
     0x3FF98659B9BDDB5BuL,
     0x3FF98AC66CEF66C8uL,
     0x3FF98F33E47A22A2uL,
     0x3FF993A220801829uL,
     0x3FF9981121235681uL,
     0x3FF99C80E685F2B5uL,
     0x3FF9A0F170CA07BAuL,
     0x3FF9A562C011B66DuL,
     0x3FF9A9D4D47F2598uL,
     0x3FF9AE47AE3481EDuL,
     0x3FF9B2BB4D53FE0DuL,
     0x3FF9B72FB1FFD285uL,
     0x3FF9BBA4DC5A3DD3uL,
     0x3FF9C01ACC858463uL,
     0x3FF9C49182A3F090uL,
     0x3FF9C908FED7D2AAuL,
     0x3FF9CD81414380F2uL,
     0x3FF9D1FA4A09579DuL,
     0x3FF9D674194BB8D5uL,
     0x3FF9DAEEAF2D0CB8uL,
     0x3FF9DF6A0BCFC15EuL,
     0x3FF9E3E62F564AD5uL,
     0x3FF9E86319E32323uL,
     0x3FF9ECE0CB98CA4BuL,
     0x3FF9F15F4499C647uL,
     0x3FF9F5DE8508A311uL,
     0x3FF9FA5E8D07F29EuL,
     0x3FF9FEDF5CBA4CE0uL,
     0x3FFA0360F4424FCBuL,
     0x3FFA07E353C29F50uL,
     0x3FFA0C667B5DE565uL,
     0x3FFA10EA6B36D1FEuL,
     0x3FFA156F23701B15uL,
     0x3FFA19F4A42C7CA9uL,
     0x3FFA1E7AED8EB8BBuL,
     0x3FFA2301FFB99757uL,
     0x3FFA2789DACFE68CuL,
     0x3FFA2C127EF47A74uL,
     0x3FFA309BEC4A2D33uL,
     0x3FFA352622F3DEF6uL,
     0x3FFA39B1231475F7uL,
     0x3FFA3E3CECCEDE7CuL,
     0x3FFA42C980460AD8uL,
     0x3FFA4756DD9CF36EuL,
     0x3FFA4BE504F696B1uL,
     0x3FFA5073F675F924uL,
     0x3FFA5503B23E255DuL,
     0x3FFA599438722C03uL,
     0x3FFA5E25893523D4uL,
     0x3FFA62B7A4AA29A1uL,
     0x3FFA674A8AF46052uL,
     0x3FFA6BDE3C36F0E6uL,
     0x3FFA7072B8950A73uL,
     0x3FFA75080031E22BuL,
     0x3FFA799E1330B358uL,
     0x3FFA7E34F1B4BF62uL,
     0x3FFA82CC9BE14DCAuL,
     0x3FFA876511D9AC32uL,
     0x3FFA8BFE53C12E59uL,
     0x3FFA909861BB2E1DuL,
     0x3FFA95333BEB0B7EuL,
     0x3FFA99CEE2742C9DuL,
     0x3FFA9E6B5579FDBFuL,
     0x3FFAA308951FF14DuL,
     0x3FFAA7A6A1897FD2uL,
     0x3FFAAC457ADA2803uL,
     0x3FFAB0E521356EBAuL,
     0x3FFAB58594BEDEFAuL,
     0x3FFABA26D59A09EEuL,
     0x3FFABEC8E3EA86EEuL,
     0x3FFAC36BBFD3F37AuL,
     0x3FFAC80F6979F340uL,
     0x3FFACCB3E100301EuL,
     0x3FFAD159268A5A1CuL,
     0x3FFAD5FF3A3C2774uL,
     0x3FFADAA61C395493uL,
     0x3FFADF4DCCA5A413uL,
     0x3FFAE3F64BA4DEC6uL,
     0x3FFAE89F995AD3ADuL,
     0x3FFAED49B5EB5803uL,
     0x3FFAF1F4A17A4735uL,
     0x3FFAF6A05C2B82E9uL,
     0x3FFAFB4CE622F2FFuL,
     0x3FFAFFFA3F84858CuL,
     0x3FFB04A868742EE4uL,
     0x3FFB09576115E994uL,
     0x3FFB0E07298DB666uL,
     0x3FFB12B7C1FF9C61uL,
     0x3FFB17692A8FA8CDuL,
     0x3FFB1C1B6361EF31uL,
     0x3FFB20CE6C9A8952uL,
     0x3FFB2582465D973CuL,
     0x3FFB2A36F0CF3F3AuL,
     0x3FFB2EEC6C13ADDDuL,
     0x3FFB33A2B84F15FBuL,
     0x3FFB3859D5A5B0B1uL,
     0x3FFB3D11C43BBD62uL,
     0x3FFB41CA843581BAuL,
     0x3FFB468415B749B1uL,
     0x3FFB4B3E78E56786uL,
     0x3FFB4FF9ADE433C6uL,
     0x3FFB54B5B4D80D4AuL,
     0x3FFB59728DE5593AuL,
     0x3FFB5E303930830CuL,
     0x3FFB62EEB6DDFC87uL,
     0x3FFB67AE07123DC3uL,
     0x3FFB6C6E29F1C52AuL,
     0x3FFB712F1FA1177BuL,
     0x3FFB75F0E844BFC6uL,
     0x3FFB7AB384014F76uL,
     0x3FFB7F76F2FB5E47uL,
     0x3FFB843B35578A51uL,
     0x3FFB89004B3A7804uL,
     0x3FFB8DC634C8D228uL,
     0x3FFB928CF22749E4uL,
     0x3FFB9754837A96B7uL,
     0x3FFB9C1CE8E77680uL,
     0x3FFBA0E62292AD7DuL,
     0x3FFBA5B030A1064AuL,
     0x3FFBAA7B133751E3uL,
     0x3FFBAF46CA7A67A7uL,
     0x3FFBB413568F255AuL,
     0x3FFBB8E0B79A6F1FuL,
     0x3FFBBDAEEDC12F82uL,
     0x3FFBC27DF9285775uL,
     0x3FFBC74DD9F4DE4FuL,
     0x3FFBCC1E904BC1D2uL,
     0x3FFBD0F01C520628uL,
     0x3FFBD5C27E2CB5E5uL,
     0x3FFBDA95B600E20BuL,
     0x3FFBDF69C3F3A207uL,
     0x3FFBE43EA82A13B5uL,
     0x3FFBE91462C95B60uL,
     0x3FFBEDEAF3F6A3C2uL,
     0x3FFBF2C25BD71E09uL,
     0x3FFBF79A9A9001D2uL,
     0x3FFBFC73B0468D30uL,
     0x3FFC014D9D2004AAuL,
     0x3FFC06286141B33DuL,
     0x3FFC0B03FCD0EA5CuL,
     0x3FFC0FE06FF301F4uL,
     0x3FFC14BDBACD586AuL,
     0x3FFC199BDD85529CuL,
     0x3FFC1E7AD8405BE6uL,
     0x3FFC235AAB23E61EuL,
     0x3FFC283B56556999uL,
     0x3FFC2D1CD9FA652CuL,
     0x3FFC31FF36385E29uL,
     0x3FFC36E26B34E065uL,
     0x3FFC3BC679157E38uL,
     0x3FFC40AB5FFFD07AuL,
     0x3FFC45912019768CuL,
     0x3FFC4A77B9881650uL,
     0x3FFC4F5F2C715C31uL,
     0x3FFC544778FAFB22uL,
     0x3FFC59309F4AAC9FuL,
     0x3FFC5E1A9F8630ADuL,
     0x3FFC630579D34DDDuL,
     0x3FFC67F12E57D14BuL,
     0x3FFC6CDDBD398EA4uL,
     0x3FFC71CB269E601FuL,
     0x3FFC76B96AAC2686uL,
     0x3FFC7BA88988C933uL,
     0x3FFC8098835A3611uL,
     0x3FFC8589584661A1uL,
     0x3FFC8A7B087346F4uL,
     0x3FFC8F6D9406E7B5uL,
     0x3FFC9460FB274C22uL,
     0x3FFC99553DFA8313uL,
     0x3FFC9E4A5CA6A1F8uL,
     0x3FFCA3405751C4DBuL,
     0x3FFCA8372E220E61uL,
     0x3FFCAD2EE13DA7CBuL,
     0x3FFCB22770CAC0F9uL,
     0x3FFCB720DCEF9069uL,
     0x3FFCBC1B25D25337uL,
     0x3FFCC1164B994D23uL,
     0x3FFCC6124E6AC88BuL,
     0x3FFCCB0F2E6D1675uL,
     0x3FFCD00CEBC68E87uL,
     0x3FFCD50B869D8F0FuL,
     0x3FFCDA0AFF187D02uL,
     0x3FFCDF0B555DC3FAuL,
     0x3FFCE40C8993D63DuL,
     0x3FFCE90E9BE12CB9uL,
     0x3FFCEE118C6C4709uL,
     0x3FFCF3155B5BAB74uL,
     0x3FFCF81A08D5E6ECuL,
     0x3FFCFD1F95018D17uL,
     0x3FFD022600053845uL,
     0x3FFD072D4A07897CuL,
     0x3FFD0C35732F2870uL,
     0x3FFD113E7BA2C38CuL,
     0x3FFD164863890FEEuL,
     0x3FFD1B532B08C968uL,
     0x3FFD205ED248B287uL,
     0x3FFD256B596F948CuL,
     0x3FFD2A78C0A43F72uL,
     0x3FFD2F87080D89F2uL,
     0x3FFD34962FD2517AuL,
     0x3FFD39A638197A3CuL,
     0x3FFD3EB72109EF21uL,
     0x3FFD43C8EACAA1D6uL,
     0x3FFD48DB95828AC7uL,
     0x3FFD4DEF2158A91FuL,
     0x3FFD53038E7402CEuL,
     0x3FFD5818DCFBA487uL,
     0x3FFD5D2F0D16A1C3uL,
     0x3FFD62461EEC14BEuL,
     0x3FFD675E12A31E7FuL,
     0x3FFD6C76E862E6D3uL,
     0x3FFD7190A0529C51uL,
     0x3FFD76AB3A99745BuL,
     0x3FFD7BC6B75EAB1FuL,
     0x3FFD80E316C98398uL,
     0x3FFD86005901478FuL,
     0x3FFD8B1E7E2D479DuL,
     0x3FFD903D8674DB2BuL,
     0x3FFD955D71FF6075uL,
     0x3FFD9A7E40F43C89uL,
     0x3FFD9F9FF37ADB4AuL,
     0x3FFDA4C289BAAF6EuL,
     0x3FFDA9E603DB3285uL,
     0x3FFDAF0A6203E4F5uL,
     0x3FFDB42FA45C4DFDuL,
     0x3FFDB955CB0BFBB6uL,
     0x3FFDBE7CD63A8315uL,
     0x3FFDC3A4C60F7FEAuL,
     0x3FFDC8CD9AB294E4uL,
     0x3FFDCDF7544B6B92uL,
     0x3FFDD321F301B460uL,
     0x3FFDD84D76FD269EuL,
     0x3FFDDD79E065807DuL,
     0x3FFDE2A72F628712uL,
     0x3FFDE7D5641C0658uL,
     0x3FFDED047EB9D12DuL,
     0x3FFDF2347F63C159uL,
     0x3FFDF7656641B78CuL,
     0x3FFDFC97337B9B5FuL,
     0x3FFE01C9E7395B56uL,
     0x3FFE06FD81A2ECE1uL,
     0x3FFE0C3202E04C5DuL,
     0x3FFE11676B197D17uL,
     0x3FFE169DBA768949uL,
     0x3FFE1BD4F11F8220uL,
     0x3FFE210D0F3C7FBAuL,
     0x3FFE264614F5A129uL,
     0x3FFE2B8002730C71uL,
     0x3FFE30BAD7DCEE90uL,
     0x3FFE35F6955B7B78uL,
     0x3FFE3B333B16EE12uL,
     0x3FFE4070C9378842uL,
     0x3FFE45AF3FE592E8uL,
     0x3FFE4AEE9F495DDCuL,
     0x3FFE502EE78B3FF6uL,
     0x3FFE557018D3970BuL,
     0x3FFE5AB2334AC7EEuL,
     0x3FFE5FF537193E75uL,
     0x3FFE653924676D76uL,
     0x3FFE6A7DFB5DCECAuL,
     0x3FFE6FC3BC24E350uL,
     0x3FFE750A66E532EBuL,
     0x3FFE7A51FBC74C83uL,
     0x3FFE7F9A7AF3C60BuL,
     0x3FFE84E3E4933C7EuL,
     0x3FFE8A2E38CE53DFuL,
     0x3FFE8F7977CDB740uL,
     0x3FFE94C5A1BA18BDuL,
     0x3FFE9A12B6BC3181uL,
     0x3FFE9F60B6FCC1C7uL,
     0x3FFEA4AFA2A490DAuL,
     0x3FFEA9FF79DC6D14uL,
     0x3FFEAF503CCD2BE5uL,
     0x3FFEB4A1EB9FA9D1uL,
     0x3FFEB9F4867CCA6EuL,
     0x3FFEBF480D8D786DuL,
     0x3FFEC49C80FAA594uL,
     0x3FFEC9F1E0ED4AC2uL,
     0x3FFECF482D8E67F1uL,
     0x3FFED49F67070435uL,
     0x3FFED9F78D802DC2uL,
     0x3FFEDF50A122F9E6uL,
     0x3FFEE4AAA2188510uL,
     0x3FFEEA059089F2D0uL,
     0x3FFEEF616CA06DD6uL,
     0x3FFEF4BE368527F6uL,
     0x3FFEFA1BEE615A27uL,
     0x3FFEFF7A945E4487uL,
     0x3FFF04DA28A52E59uL,
     0x3FFF0A3AAB5F6609uL,
     0x3FFF0F9C1CB6412AuL,
     0x3FFF14FE7CD31C7BuL,
     0x3FFF1A61CBDF5BE7uL,
     0x3FFF1FC60A046A84uL,
     0x3FFF252B376BBA97uL,
     0x3FFF2A91543EC595uL,
     0x3FFF2FF860A70C22uL,
     0x3FFF35605CCE1613uL,
     0x3FFF3AC948DD7274uL,
     0x3FFF403324FEB781uL,
     0x3FFF459DF15B82ACuL,
     0x3FFF4B09AE1D78A1uL,
     0x3FFF50765B6E4540uL,
     0x3FFF55E3F9779BA5uL,
     0x3FFF5B5288633625uL,
     0x3FFF60C2085AD652uL,
     0x3FFF6632798844F8uL,
     0x3FFF6BA3DC155226uL,
     0x3FFF7116302BD526uL,
     0x3FFF768975F5AC86uL,
     0x3FFF7BFDAD9CBE14uL,
     0x3FFF8172D74AF6E1uL,
     0x3FFF86E8F32A4B45uL,
     0x3FFF8C600164B6DCuL,
     0x3FFF91D802243C89uL,
     0x3FFF9750F592E677uL,
     0x3FFF9CCADBDAC61DuL,
     0x3FFFA245B525F439uL,
     0x3FFFA7C1819E90D8uL,
     0x3FFFAD3E416EC354uL,
     0x3FFFB2BBF4C0BA54uL,
     0x3FFFB83A9BBEABD1uL,
     0x3FFFBDBA3692D514uL,
     0x3FFFC33AC5677AB8uL,
     0x3FFFC8BC4866E8ADuL,
     0x3FFFCE3EBFBB7237uL,
     0x3FFFD3C22B8F71F1uL,
     0x3FFFD9468C0D49CCuL,
     0x3FFFDECBE15F6314uL,
     0x3FFFE4522BB02E6EuL,
     0x3FFFE9D96B2A23D9uL,
     0x3FFFEF619FF7C2B3uL,
     0x3FFFF4EACA4391B6uL,
     0x3FFFFA74EA381EFCuL,

     },

    0x40971547652B82FEuL,
    0x4338000000000000uL,
    0x3F462E42FEC00000uL,
    0x3D5D1CF79ABC9E3BuL,

    0x3FF0000000000000uL,
    0x3FE0000001EBFBE0uL,
    0x3FC5555555555556uL,

    ((1 << 10) - 1),
    0x7fffffffu,
    0x4086232Au,
    0x40862E42FEFA39EFuL,
    0xC0874910D52D3051uL,
};

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_p_L2E = { 0x3ff71547652B82FEUL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_p_Shifter = { 0x42e8000000007fe0UL };

static __constant union
{
    unsigned int w;
    float f;
} __dexp_la_p_L2Ef = { 0x3fB8AA3Bu };

static __constant union
{
    unsigned int w;
    float f;
} __dexp_la_p_Shifterf = { 0x48c07fe0u };

static __constant union
{
    unsigned int w;
    float f;
} __dexp_la_p_fthres = { 0x4431195c };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_p_NL2H = { 0xbfe62e42fefa39efUL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_p_NL2L = { 0xbc7abc9e3b39803fUL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_c5 = { 0x3f8111175064ccb0UL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_c4 = { 0x3fa5555d88783c48UL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_c3 = { 0x3fc5555555538d19UL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_c2 = { 0x3fdffffffffd0b99UL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_c1 = { 0x3ff0000000000000UL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_c0 = { 0x3c943095e0f2f7d1UL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_Tbl_exp[] = {
    {0x0000000000000000UL},
    {0x0000d9b0d3158574UL},
    {0x0001b5586cf9890fUL},
    {0x00009301d0125b51UL},
    {0x000372b83c7d517bUL},
    {0x000354873168b9aaUL},
    {0x0001387a6e756238UL},
    {0x00011e9df51fdee1UL},
    {0x000706fe0a31b715UL},
    {0x0007f1a7373aa9cbUL},
    {0x0006dea64c123422UL},
    {0x0001ce086061892dUL},
    {0x0002bfdad5362a27UL},
    {0x0003b42b569d4f82UL},
    {0x0002ab07dd485429UL},
    {0x0001a47eb03a5585UL},
    {0x000ea09e667f3bcdUL},
    {0x000f9f75e8ec5f74UL},
    {0x000ea11473eb0187UL},
    {0x0001a589994cce13UL},
    {0x0002ace5422aa0dbUL},
    {0x0003b737b0cdc5e5UL},
    {0x0002c49182a3f090UL},
    {0x0001d503b23e255dUL},
    {0x0006e89f995ad3adUL},
    {0x0007ff76f2fb5e47UL},
    {0x0001199bdd85529cUL},
    {0x00013720dcef9069UL},
    {0x00035818dcfba487UL},
    {0x00037c97337b9b5fUL},
    {0x0001a4afa2a490daUL},
    {0x0000d0765b6e4540UL},
};

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_min_norm = { 0x0010000000000000UL };

static __constant union
{
    unsigned long w;
    unsigned int w32[2];
    double f;
} __dexp_la_Inf = { 0x7ff0000000000000UL };

__attribute__((always_inline))
inline int __internal_dexp_la_cout (double *a, double *r)
{
    int nRet = 0;
    double x = *a;
    union
    {
        unsigned long w;
        unsigned int w32[2];
        double f;
    } xi, zero, res_special, scale;
    union
    {
        unsigned long w;
        unsigned int w32[2];
        double f;
    } T;
    union
    {
        unsigned int w;
        float f;
    } idx;
    double N, R, R0, poly, res;
    int expon32, mask32, mask_h;
    unsigned int xa32, sgn_x, expon_corr;
    float xf, fN;

    xf = (float) x;

    idx.f = __builtin_spirv_OpenCL_fma_f32_f32_f32 (xf, __dexp_la_p_L2Ef.f, __dexp_la_p_Shifterf.f);

    fN = idx.f - __dexp_la_p_Shifterf.f;
    N = (double) fN;

    T.w = __dexp_la_Tbl_exp[idx.w & 31].w;
    T.w32[1] ^= (idx.w << (20 - 5));

    R0 = __builtin_spirv_OpenCL_fma_f64_f64_f64 (__dexp_la_p_NL2H.f, N, x);

    R = __builtin_spirv_OpenCL_fma_f64_f64_f64 (__dexp_la_p_NL2L.f, N, R0);

    poly = __builtin_spirv_OpenCL_fma_f64_f64_f64 (__dexp_la_c5.f, R0, __dexp_la_c4.f);
    poly = __builtin_spirv_OpenCL_fma_f64_f64_f64 (poly, R0, __dexp_la_c3.f);
    poly = __builtin_spirv_OpenCL_fma_f64_f64_f64 (poly, R0, __dexp_la_c2.f);
    poly = __builtin_spirv_OpenCL_fma_f64_f64_f64 (poly, R, __dexp_la_c1.f);
    poly = __builtin_spirv_OpenCL_fma_f64_f64_f64 (poly, R, __dexp_la_c0.f);

    if (__builtin_spirv_OpenCL_fabs_f32 (xf) > __dexp_la_p_fthres.f)
        goto EXP_SPECIAL_PATH;

    res = __builtin_spirv_OpenCL_fma_f64_f64_f64 (T.f, poly, T.f);
    *r = res;
    return nRet;

  EXP_SPECIAL_PATH:
    xi.f = x;
    xa32 = xi.w32[1] & 0x7fffffffu;

    sgn_x = xa32 ^ xi.w32[1];

    if (xa32 < 0x40879127u)
    {
        expon_corr = sgn_x ? 0x08000000u : 0xF8000000u;
        scale.w = sgn_x ? 0x37f0000000000000UL : 0x47f0000000000000UL;

        T.w32[1] += expon_corr;

        res = __builtin_spirv_OpenCL_fma_f64_f64_f64 (T.f, poly, T.f);

        res *= scale.f;
    }
    else
    {

        res_special.w = sgn_x ? 0x0000000000000000UL : 0x7ff0000000000000UL;

        xi.w32[1] = xa32;
        res_special.f = (xi.w <= 0x7ff0000000000000UL) ? res_special.f : x;

        zero.w = 0;
        res = res_special.f + zero.f;

    }

    nRet = (res < __dexp_la_min_norm.f) ? 4 : nRet;
    nRet = (res == __dexp_la_Inf.f) ? 3 : nRet;

    *r = res;
    return nRet;

}

double __ocl_svml_exp (double a)
{

    double va1;
    double vr1;
    unsigned int vm;

    double r;

    va1 = a;;

    __internal_dexp_la_cout (&va1, &vr1);
    r = vr1;;

    return r;

}
