// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`Verify`](crate::operation::verify::builders::VerifyFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::verify::builders::VerifyFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::verify::builders::VerifyFluentBuilder::set_key_id):<br>required: **true**<br><p>Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.</p> <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Alias name: <code>alias/ExampleAlias</code></p></li>  <li>   <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p><br>
    ///   - [`message(Blob)`](crate::operation::verify::builders::VerifyFluentBuilder::message) / [`set_message(Option<Blob>)`](crate::operation::verify::builders::VerifyFluentBuilder::set_message):<br>required: **true**<br><p>Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the <code>MessageType</code> parameter with a value of <code>DIGEST</code>.</p> <p>If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.</p><br>
    ///   - [`message_type(MessageType)`](crate::operation::verify::builders::VerifyFluentBuilder::message_type) / [`set_message_type(Option<MessageType>)`](crate::operation::verify::builders::VerifyFluentBuilder::set_message_type):<br>required: **false**<br><p>Tells KMS whether the value of the <code>Message</code> parameter should be hashed as part of the signing algorithm. Use <code>RAW</code> for unhashed messages; use <code>DIGEST</code> for message digests, which are already hashed.</p> <p>When the value of <code>MessageType</code> is <code>RAW</code>, KMS uses the standard signing algorithm, which begins with a hash function. When the value is <code>DIGEST</code>, KMS skips the hashing step in the signing algorithm.</p><important>  <p>Use the <code>DIGEST</code> value only when the value of the <code>Message</code> parameter is a message digest. If you use the <code>DIGEST</code> value with an unhashed message, the security of the verification operation can be compromised.</p> </important> <p>When the value of <code>MessageType</code>is <code>DIGEST</code>, the length of the <code>Message</code> value must match the length of hashed messages for the specified signing algorithm.</p> <p>You can submit a message digest and omit the <code>MessageType</code> or specify <code>RAW</code> so the digest is hashed again while signing. However, if the signed message is hashed once while signing, but twice while verifying, verification fails, even when the message hasn't changed.</p> <p>The hashing algorithm in that <code>Verify</code> uses is based on the <code>SigningAlgorithm</code> value.</p> <ul>  <li>   <p>Signing algorithms that end in SHA_256 use the SHA_256 hashing algorithm.</p></li>  <li>   <p>Signing algorithms that end in SHA_384 use the SHA_384 hashing algorithm.</p></li>  <li>   <p>Signing algorithms that end in SHA_512 use the SHA_512 hashing algorithm.</p></li>  <li>   <p>SM2DSA uses the SM3 hashing algorithm. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification">Offline verification with SM2 key pairs</a>.</p></li> </ul><br>
    ///   - [`signature(Blob)`](crate::operation::verify::builders::VerifyFluentBuilder::signature) / [`set_signature(Option<Blob>)`](crate::operation::verify::builders::VerifyFluentBuilder::set_signature):<br>required: **true**<br><p>The signature that the <code>Sign</code> operation generated.</p><br>
    ///   - [`signing_algorithm(SigningAlgorithmSpec)`](crate::operation::verify::builders::VerifyFluentBuilder::signing_algorithm) / [`set_signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::operation::verify::builders::VerifyFluentBuilder::set_signing_algorithm):<br>required: **true**<br><p>The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.</p><br>
    ///   - [`grant_tokens(impl Into<String>)`](crate::operation::verify::builders::VerifyFluentBuilder::grant_tokens) / [`set_grant_tokens(Option<Vec::<String>>)`](crate::operation::verify::builders::VerifyFluentBuilder::set_grant_tokens):<br>required: **false**<br><p>A list of grant tokens.</p> <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::verify::builders::VerifyFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::verify::builders::VerifyFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`VerifyOutput`](crate::operation::verify::VerifyOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::operation::verify::VerifyOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    ///   - [`signature_valid(bool)`](crate::operation::verify::VerifyOutput::signature_valid): <p>A Boolean value that indicates whether the signature was verified. A value of <code>True</code> indicates that the <code>Signature</code> was produced by signing the <code>Message</code> with the specified <code>KeyID</code> and <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code> operation fails with a <code>KMSInvalidSignatureException</code> exception.</p>
    ///   - [`signing_algorithm(Option<SigningAlgorithmSpec>)`](crate::operation::verify::VerifyOutput::signing_algorithm): <p>The signing algorithm that was used to verify the signature.</p>
    /// - On failure, responds with [`SdkError<VerifyError>`](crate::operation::verify::VerifyError)
    pub fn verify(&self) -> crate::operation::verify::builders::VerifyFluentBuilder {
        crate::operation::verify::builders::VerifyFluentBuilder::new(self.handle.clone())
    }
}
