// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetKeyPolicy`](crate::operation::get_key_policy::builders::GetKeyPolicyFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::get_key_policy::builders::GetKeyPolicyFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::get_key_policy::builders::GetKeyPolicyFluentBuilder::set_key_id):<br>required: **true**<br><p>Gets the key policy for the specified KMS key.</p> <p>Specify the key ID or key ARN of the KMS key.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p><br>
    ///   - [`policy_name(impl Into<String>)`](crate::operation::get_key_policy::builders::GetKeyPolicyFluentBuilder::policy_name) / [`set_policy_name(Option<String>)`](crate::operation::get_key_policy::builders::GetKeyPolicyFluentBuilder::set_policy_name):<br>required: **false**<br><p>Specifies the name of the key policy. If no policy name is specified, the default value is <code>default</code>. The only valid name is <code>default</code>. To get the names of key policies, use <code>ListKeyPolicies</code>.</p><br>
    /// - On success, responds with [`GetKeyPolicyOutput`](crate::operation::get_key_policy::GetKeyPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::operation::get_key_policy::GetKeyPolicyOutput::policy): <p>A key policy document in JSON format.</p>
    ///   - [`policy_name(Option<String>)`](crate::operation::get_key_policy::GetKeyPolicyOutput::policy_name): <p>The name of the key policy. The only valid value is <code>default</code>.</p>
    /// - On failure, responds with [`SdkError<GetKeyPolicyError>`](crate::operation::get_key_policy::GetKeyPolicyError)
    pub fn get_key_policy(&self) -> crate::operation::get_key_policy::builders::GetKeyPolicyFluentBuilder {
        crate::operation::get_key_policy::builders::GetKeyPolicyFluentBuilder::new(self.handle.clone())
    }
}
