/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.XMLFieldHandler;

public class DateFieldHandler
extends XMLFieldHandler {
    private static final byte DEFAULT_DATE_LENGTH = 23;
    private static final String INVALID_DATE = "Invalid dateTime format: ";
    private static final byte START_FLAG = -1;
    private static final byte YEAR_FLAG = 0;
    private static final byte MONTH_FLAG = 1;
    private static final byte DAY_FLAG = 2;
    private static final byte HOURS_FLAG = 3;
    private static final byte MINUTES_FLAG = 4;
    private static final byte SECONDS_FLAG = 5;
    private static final byte MILLIS_FLAG = 6;
    private static final String UTC_TIMEZONE = "UTC";
    private static TimeZone TIMEZONE = TimeZone.getDefault();
    private static boolean _allowTimeZoneSuppression = false;
    private FieldHandler _handler = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Enumeration;

    public DateFieldHandler(FieldHandler fieldHandler) {
        if (fieldHandler == null) {
            String err = "The FieldHandler argument passed to the constructor of DateFieldHandler must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._handler = fieldHandler;
    }

    public Object getValue(Object target) throws IllegalStateException {
        Class<?> type;
        Object val = this._handler.getValue(target);
        if (val == null) {
            return val;
        }
        Object[] formatted = null;
        if ((class$java$util$Date == null ? (class$java$util$Date = DateFieldHandler.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type = val.getClass())) {
            formatted = DateFieldHandler.format((Date)val);
        } else if (type.isArray()) {
            int size = Array.getLength(val);
            String[] values = new String[size];
            for (int i = 0; i < size; ++i) {
                values[i] = DateFieldHandler.format(Array.get(val, i));
            }
            formatted = values;
        } else if ((class$java$util$Enumeration == null ? (class$java$util$Enumeration = DateFieldHandler.class$("java.util.Enumeration")) : class$java$util$Enumeration).isAssignableFrom(type)) {
            Enumeration enumeration = (Enumeration)val;
            Vector<String> values = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                values.addElement(DateFieldHandler.format(enumeration.nextElement()));
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            formatted = valuesArray;
        } else {
            formatted = val.toString();
        }
        return formatted;
    }

    public void setValue(Object target, Object value) throws IllegalStateException {
        Date date = null;
        if (!(value instanceof Date)) {
            try {
                date = DateFieldHandler.parse(value.toString());
            }
            catch (ParseException px) {
                throw new IllegalStateException(px.getMessage());
            }
        } else {
            date = (Date)value;
        }
        this._handler.setValue(target, date);
    }

    public void resetValue(Object target) throws IllegalStateException {
        this._handler.resetValue(target);
    }

    public Object newInstance(Object parent) throws IllegalStateException {
        Object obj = this._handler.newInstance(parent);
        if (obj == null) {
            obj = new Date();
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldHandler)) {
            return false;
        }
        return this._handler.getClass().isInstance(obj) || this.getClass().isInstance(obj);
    }

    public static void setAllowTimeZoneSuppression(boolean allowTimeZoneSuppression) {
        _allowTimeZoneSuppression = allowTimeZoneSuppression;
    }

    public static void setDefaultTimeZone(TimeZone timeZone) {
        TIMEZONE = timeZone == null ? TimeZone.getDefault() : (TimeZone)timeZone.clone();
    }

    protected static Date parse(String dateTime) throws ParseException {
        int i;
        if (dateTime == null) {
            throw new ParseException("Invalid dateTime format: null", 0);
        }
        int[] values = new int[7];
        int flags = -1;
        int sign = 1;
        int value = 0;
        int count = 0;
        boolean delimiter = true;
        char[] chars = dateTime.toCharArray();
        boolean timezone = false;
        for (i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            block0 : switch (ch) {
                case '-': {
                    delimiter = true;
                    switch (flags) {
                        case -1: {
                            sign = -1;
                            break block0;
                        }
                        case 0: {
                            if (value != 0) break block0;
                            String err = INVALID_DATE + dateTime + "; Year must be greater than 0";
                            throw new ParseException(err, i);
                        }
                        case 1: {
                            --value;
                            break block0;
                        }
                        case 5: 
                        case 6: {
                            timezone = true;
                            delimiter = false;
                            break block0;
                        }
                        default: {
                            throw new ParseException(INVALID_DATE + dateTime, i);
                        }
                    }
                }
                case 'T': {
                    delimiter = true;
                    if (flags == 2) break;
                    throw new ParseException(INVALID_DATE + dateTime, i);
                }
                case ':': {
                    delimiter = true;
                    switch (flags) {
                        case 3: 
                        case 4: {
                            break block0;
                        }
                    }
                    throw new ParseException(INVALID_DATE + dateTime, i);
                }
                case '.': {
                    delimiter = true;
                    if (flags == 5) break;
                    throw new ParseException(INVALID_DATE + dateTime, i);
                }
                case '+': 
                case 'Z': {
                    switch (flags) {
                        case 5: 
                        case 6: {
                            break;
                        }
                        default: {
                            throw new ParseException(INVALID_DATE + dateTime, i);
                        }
                    }
                    timezone = true;
                    break;
                }
                default: {
                    delimiter = false;
                    if (flags == -1) {
                        flags = 0;
                    }
                    if (ch >= '0' && ch <= '9') {
                        if (++count > 3 && flags == 6) break;
                        value = value * 10 + Character.digit(ch, 10);
                        break;
                    }
                    throw new ParseException(INVALID_DATE + dateTime, i);
                }
            }
            if (delimiter) {
                if (flags != -1) {
                    values[flags] = value;
                }
                flags = (byte)(flags + 1);
                value = 0;
                count = 0;
            }
            if (timezone) break;
        }
        GregorianCalendar cal = new GregorianCalendar(values[0], values[1], values[2], values[3], values[4], values[5]);
        switch (flags) {
            case 5: {
                cal.set(13, value);
                break;
            }
            case 6: {
                cal.set(14, value);
                break;
            }
            default: {
                throw new ParseException(INVALID_DATE + dateTime, i);
            }
        }
        if (timezone) {
            TimeZone tz = TimeZone.getTimeZone(UTC_TIMEZONE);
            char designator = chars[i++];
            flags = 3;
            int millis = 0;
            count = 0;
            value = 0;
            while (i < chars.length) {
                char ch = chars[i];
                switch (ch) {
                    case ':': {
                        if (count != 2 || flags != 3) {
                            String err = INVALID_DATE + dateTime + "; TimeZone offset must be in the format 'hh:mm'";
                            throw new ParseException(err, i);
                        }
                        millis = value * 3600000;
                        count = 0;
                        value = 0;
                        flags = (byte)(flags + 1);
                        break;
                    }
                    default: {
                        if (ch >= '0' && ch <= '9') {
                            if (count == 2) {
                                millis = value * 3600000;
                                count = 0;
                                value = 0;
                                flags = (byte)(flags + 1);
                            }
                            ++count;
                            value = value * 10 + Character.digit(ch, 10);
                            break;
                        }
                        throw new ParseException("Unparseable date: " + dateTime, i);
                    }
                }
                ++i;
            }
            if (flags == 4) {
                if (count != 2) {
                    String err = INVALID_DATE + dateTime + "; TimeZone offset must be in the format 'hh:mm'";
                    throw new ParseException(err, i);
                }
                millis += value * 60000;
                if (designator == '-') {
                    millis = 0 - millis;
                }
                tz.setRawOffset(millis);
            } else if (designator != 'Z') {
                String err = INVALID_DATE + dateTime + "; TimeZone offset must be in the format 'hh:mm'";
                throw new ParseException(err, i);
            }
            ((Calendar)cal).setTimeZone(tz);
        } else {
            ((Calendar)cal).setTimeZone((TimeZone)TIMEZONE.clone());
        }
        return cal.getTime();
    }

    protected static String format(Date date) {
        int tmp;
        StringBuffer buffer = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.setTimeZone(TIMEZONE);
        int value = cal.get(1);
        if (value > 9999) {
            buffer = new StringBuffer(25);
        } else {
            buffer = new StringBuffer(23);
            for (tmp = 1000; value < tmp; tmp /= 10) {
                buffer.append('0');
            }
        }
        buffer.append(value);
        buffer.append('-');
        value = cal.get(2) + 1;
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(value);
        buffer.append('-');
        value = cal.get(5);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(value);
        buffer.append('T');
        value = cal.get(11);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(value);
        buffer.append(':');
        value = cal.get(12);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(value);
        buffer.append(':');
        value = cal.get(13);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(value);
        buffer.append('.');
        value = cal.get(14);
        for (tmp = 100; value < tmp; tmp /= 10) {
            buffer.append(0);
        }
        if (value > 0) {
            buffer.append(value);
        }
        if ((value = cal.get(15)) == 0 && cal.get(16) == 0) {
            buffer.append('Z');
        } else {
            boolean useTimeZoneOffset = true;
            if (_allowTimeZoneSuppression) {
                boolean bl = useTimeZoneOffset = value != TIMEZONE.getRawOffset();
            }
            if (useTimeZoneOffset) {
                if ((value += cal.get(16)) > 0) {
                    buffer.append('+');
                } else {
                    value = 0 - value;
                    buffer.append('-');
                }
                int minutes = value / 60000;
                value = minutes / 60;
                if (value < 10) {
                    buffer.append('0');
                }
                buffer.append(value);
                buffer.append(':');
                value = minutes % 60;
                if (value < 10) {
                    buffer.append('0');
                }
                buffer.append(value);
            }
        }
        return buffer.toString();
    }

    private static String format(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return DateFieldHandler.format((Date)object);
        }
        return object.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

