/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.exolab.castor.types.GYearMonth;
import org.exolab.castor.types.OperationNotSupportedException;

public class GYear
extends GYearMonth {
    private static final String YEAR_FORMAT = "yyyy";
    private static final String BAD_GYEAR = "Bad gYear format: ";

    public GYear() {
    }

    public GYear(short century, short year) {
        this.setCentury(century);
        this.setYear(year);
    }

    public GYear(int year) {
        short century = (short)(year / 100);
        this.setCentury(century);
        this.setYear((short)(year %= 100));
    }

    public GYear(short[] values) {
        this();
        this.setValues(values);
    }

    public GYear(String gyear) throws ParseException {
        this();
        GYear.parseGYearInternal(gyear, this);
    }

    public void setValues(short[] values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("GYear#setValues: not the right number of values");
        }
        this.setCentury(values[0]);
        this.setYear(values[1]);
        this.setMonth(values[2]);
    }

    public short[] getValues() {
        short[] result = null;
        result = new short[]{this.getCentury(), this.getYear()};
        return result;
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(YEAR_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(SimpleTimeZone.getAvailableIDs(offset)[0]);
            df.setTimeZone(timeZone);
        }
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isNegative()) {
            result.append('-');
        }
        result.append(this.getCentury());
        if (result.length() == 1) {
            result.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getYear());
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                result.append('Z');
            } else {
                StringBuffer timeZone = new StringBuffer();
                if (this.isZoneNegative()) {
                    timeZone.append('-');
                } else {
                    timeZone.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneHour());
                timeZone.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneMinute());
                result.append(timeZone.toString());
                Object var2_2 = null;
            }
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GYear.parseGYear(str);
    }

    public static GYear parseGYear(String str) throws ParseException {
        GYear result = new GYear();
        return GYear.parseGYearInternal(str, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GYear parseGYearInternal(String str, GYear result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GYear();
        }
        if ((chars = str.toCharArray())[idx = 0] == '-') {
            ++idx;
            result.setNegative();
        }
        boolean hasNumber = false;
        boolean has2Digits = false;
        int number = 0;
        int number2 = 0;
        int flags = 3;
        block6: while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case '-': {
                    if (flags != 3) throw new ParseException(BAD_GYEAR + str + "\nA gYear must follow the pattern CCYY(Z|((+|-)hh:mm)).", idx);
                    if (number == 0 && number2 == 0) throw new ParseException(BAD_GYEAR + str + "\n'0000' is not allowed as a year.", idx);
                    if (!has2Digits) {
                        throw new ParseException(BAD_GYEAR + str + "\nThe Century field must have 2 digits.", idx);
                    }
                    result.setCentury((short)number);
                    result.setYear((short)number2);
                    flags = 1;
                    number2 = -1;
                    result.setUTC();
                    result.setZoneNegative(true);
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case 'Z': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GYEAR + str + "'Z'" + "is wrongly placed.", idx);
                    }
                    result.setUTC();
                    continue block6;
                }
                case '+': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GYEAR + str + "'+' " + "is wrongly placed.", idx);
                    }
                    if (number == 0 && number2 == 0) throw new ParseException(BAD_GYEAR + str + "\n'0000' is not allowed as a year.", idx);
                    if (!has2Digits) {
                        throw new ParseException(BAD_GYEAR + str + "\nThe Century field must have 2 digits.", idx);
                    }
                    result.setCentury((short)number);
                    result.setYear((short)number2);
                    result.setUTC();
                    flags = 1;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case ':': {
                    if (flags != 1) {
                        throw new ParseException(BAD_GYEAR + str + "':' " + "is wrongly placed.", idx);
                    }
                    number2 = number;
                    number = -1;
                    flags = 0;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
            }
            if ('0' > ch || ch > '9') throw new ParseException(str + ": Invalid character: " + ch, idx);
            if (hasNumber) {
                if (has2Digits) {
                    number2 = (short)(number2 * 10 + (ch - 48));
                    continue;
                }
                number = (short)(number * 10 + (ch - 48));
                has2Digits = true;
                continue;
            }
            hasNumber = true;
            number = (short)(ch - 48);
        }
        if (flags != 3 && flags != 0) {
            throw new ParseException(BAD_GYEAR + str + "\nA gYear must follow the pattern CCYY(Z|((+|-)hh:mm)).", idx);
        }
        if (flags == 3) {
            if (number == 0 && number2 == 0) throw new ParseException(BAD_GYEAR + str + "\n'0000' is not allowed as a year.", idx);
            if (!has2Digits) {
                throw new ParseException(BAD_GYEAR + str + "\nThe Century field must have 2 digits.", idx);
            }
            result.setCentury((short)number);
            result.setYear((short)number2);
            return result;
        } else {
            if (flags != 0) return result;
            if (number == -1) throw new ParseException(str + "\n In a time zone, the minute field must always be present.", idx);
            result.setZone((short)number2, (short)number);
        }
        return result;
    }

    public short getMonth() {
        String err = "GYear: couldn't access to the Month field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMonth(short month) {
        String err = "GYear: couldn't access to the Month field.";
        throw new OperationNotSupportedException(err);
    }
}

