/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;

public final class CollectionHandlers {
    private static Class _collectionClass = null;
    private static boolean _loadedCollectionClass = false;
    private static Info[] _info;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$org$exolab$castor$mapping$loader$CollectionHandlers;

    public static Class getCollectionType(String name) throws MappingException {
        if (_info == null) {
            CollectionHandlers.loadInfo();
        }
        for (int i = 0; i < _info.length; ++i) {
            if (!CollectionHandlers._info[i].shortName.equalsIgnoreCase(name) && !CollectionHandlers._info[i].javaClass.getName().equals(name)) continue;
            return CollectionHandlers._info[i].javaClass;
        }
        if (!_loadedCollectionClass) {
            _loadedCollectionClass = true;
            try {
                _collectionClass = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return _collectionClass;
    }

    public static boolean hasHandler(Class javaClass) {
        if (_info == null) {
            CollectionHandlers.loadInfo();
        }
        if (javaClass.isArray() && javaClass.getComponentType() != Byte.TYPE) {
            javaClass = array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = CollectionHandlers.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
        }
        for (int i = 0; i < _info.length; ++i) {
            if (!CollectionHandlers._info[i].javaClass.isAssignableFrom(javaClass)) continue;
            return true;
        }
        return false;
    }

    public static String getCollectionName(Class javaClass) {
        int i;
        if (_info == null) {
            CollectionHandlers.loadInfo();
        }
        if (javaClass.isArray() && javaClass.getComponentType() != Byte.TYPE) {
            javaClass = array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = CollectionHandlers.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
        }
        for (i = 0; i < _info.length; ++i) {
            if (!CollectionHandlers._info[i].javaClass.equals(javaClass)) continue;
            return CollectionHandlers._info[i].shortName;
        }
        for (i = 0; i < _info.length; ++i) {
            if (!CollectionHandlers._info[i].javaClass.isAssignableFrom(javaClass)) continue;
            return CollectionHandlers._info[i].shortName;
        }
        return null;
    }

    public static CollectionHandler getHandler(Class javaClass) throws MappingException {
        int i;
        if (_info == null) {
            CollectionHandlers.loadInfo();
        }
        if (javaClass.isArray() && javaClass.getComponentType() != Byte.TYPE) {
            javaClass = array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = CollectionHandlers.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
        }
        for (i = 0; i < _info.length; ++i) {
            if (!CollectionHandlers._info[i].javaClass.equals(javaClass)) continue;
            return CollectionHandlers._info[i].handler;
        }
        for (i = 0; i < _info.length; ++i) {
            if (!CollectionHandlers._info[i].javaClass.isAssignableFrom(javaClass)) continue;
            return CollectionHandlers._info[i].handler;
        }
        throw new MappingException("mapping.noCollectionHandler", javaClass.getName());
    }

    public static boolean isGetSetCollection(Class javaClass) throws MappingException {
        if (_info == null) {
            CollectionHandlers.loadInfo();
        }
        for (int i = 0; i < _info.length; ++i) {
            if (!CollectionHandlers._info[i].javaClass.equals(javaClass)) continue;
            return CollectionHandlers._info[i].getSetCollection;
        }
        throw new MappingException("mapping.noCollectionHandler", javaClass.getName());
    }

    private static synchronized void loadInfo() {
        if (_info == null) {
            Vector<Info> allInfo = new Vector<Info>();
            LocalConfiguration config = LocalConfiguration.getInstance();
            StringTokenizer tokenizer = new StringTokenizer(config.getProperty("org.exolab.castor.mapping.collections", ""), ", ");
            while (tokenizer.hasMoreTokens()) {
                try {
                    Class<?> infoClass = (class$org$exolab$castor$mapping$loader$CollectionHandlers == null ? CollectionHandlers.class$("org.exolab.castor.mapping.loader.CollectionHandlers") : class$org$exolab$castor$mapping$loader$CollectionHandlers).getClassLoader() != null ? (class$org$exolab$castor$mapping$loader$CollectionHandlers == null ? CollectionHandlers.class$("org.exolab.castor.mapping.loader.CollectionHandlers") : class$org$exolab$castor$mapping$loader$CollectionHandlers).getClassLoader().loadClass(tokenizer.nextToken()) : Class.forName(tokenizer.nextToken());
                    Method method = infoClass.getMethod("getCollectionHandlersInfo", null);
                    Info[] info = (Info[])method.invoke(null, null);
                    for (int i = 0; i < info.length; ++i) {
                        allInfo.addElement(info[i]);
                    }
                }
                catch (Exception except) {
                }
            }
            _info = new Info[allInfo.size()];
            allInfo.copyInto(_info);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }

    static class Info {
        final String shortName;
        final Class javaClass;
        final CollectionHandler handler;
        final boolean getSetCollection;

        Info(String shortName, Class javaClass, boolean getSetCollection, CollectionHandler handler) {
            this.shortName = shortName;
            this.javaClass = javaClass;
            this.handler = handler;
            this.getSetCollection = getSetCollection;
        }
    }
}

