/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiImageColorReducer;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;

public class ColorReducer {
    protected JimiImageColorReducer reducer_;
    protected boolean dither_;

    public ColorReducer(int n) {
        this(n, false);
    }

    public ColorReducer(int n, boolean bl) {
        this.reducer_ = new JimiImageColorReducer(n);
        this.dither_ = bl;
    }

    protected JimiRasterImage doColorReduction(ImageProducer imageProducer) throws JimiException {
        if (this.dither_) {
            return this.reducer_.colorReduceFS(imageProducer);
        }
        return this.reducer_.colorReduce(imageProducer);
    }

    public Image getColorReducedImage(Image image) throws JimiException {
        return this.getColorReducedImage(image.getSource());
    }

    public Image getColorReducedImage(ImageProducer imageProducer) throws JimiException {
        return Toolkit.getDefaultToolkit().createImage(this.doColorReduction(imageProducer).getImageProducer());
    }

    public ImageProducer getColorReducedImageProducer(Image image) throws JimiException {
        return this.getColorReducedImageProducer(image.getSource());
    }

    public ImageProducer getColorReducedImageProducer(ImageProducer imageProducer) throws JimiException {
        return this.doColorReduction(imageProducer).getImageProducer();
    }
}

