/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.DefaultWebResponse;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.RequestContext;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebFrame;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;

class FrameHolder {
    private Hashtable _contents = new Hashtable();
    private Hashtable _subFrames = new Hashtable();
    private String _frameName;

    FrameHolder(WebClient client, String name) {
        this._frameName = name;
        DefaultWebResponse blankResponse = new DefaultWebResponse(client, null, "");
        this._contents.put("_top", blankResponse);
        HttpUnitOptions.getScriptingEngine().associate(blankResponse);
    }

    WebResponse get(String target) {
        WebResponse response = (WebResponse)this._contents.get(this.getFrameName(target));
        if (response != null) {
            return response;
        }
        Iterator iterator = this._contents.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!name.endsWith(':' + target)) continue;
            return (WebResponse)this._contents.get(name);
        }
        return null;
    }

    List getActiveFrameNames() {
        ArrayList result = new ArrayList();
        Enumeration e = this._contents.keys();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    String getTargetFrame(WebRequest request) {
        if ("_blank".equalsIgnoreCase(request.getTarget())) {
            return "_top";
        }
        if ("_top".equalsIgnoreCase(request.getTarget())) {
            return "_top";
        }
        String computedTarget = FrameHolder.getTargetFrameName(request.getSourceFrame(), request.getTarget());
        if (this._contents.get(computedTarget) != null) {
            return computedTarget;
        }
        Iterator iterator = this._contents.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!name.endsWith(':' + request.getTarget())) continue;
            return name;
        }
        return request.getTarget();
    }

    String getFrameName(String target) {
        if ("_top".equalsIgnoreCase(target)) {
            return this._frameName;
        }
        if ("_blank".equalsIgnoreCase(target)) {
            return this._frameName;
        }
        return target;
    }

    void updateFrames(WebResponse response, String target, RequestContext requestContext) throws MalformedURLException, IOException, SAXException {
        this.removeSubFrames(target);
        this._contents.put(target, response);
        if (response.isHTML()) {
            if (!response.hasSubframes()) {
                requestContext.addNewResponse(response);
            } else {
                HttpUnitOptions.getScriptingEngine().associate(response);
                this.createSubFrames(target, response.getFrameNames());
                WebRequest[] requests = response.getFrameRequests();
                int i = 0;
                while (i < requests.length) {
                    response.getWindow().getSubframeResponse(requests[i], requestContext);
                    ++i;
                }
            }
        }
    }

    private void removeSubFrames(String targetName) {
        String[] names = (String[])this._subFrames.get(targetName);
        if (names == null) {
            return;
        }
        int i = 0;
        while (i < names.length) {
            this.removeSubFrames(names[i]);
            this._contents.remove(names[i]);
            this._subFrames.remove(names[i]);
            ++i;
        }
    }

    private void createSubFrames(String targetName, String[] frameNames) {
        this._subFrames.put(targetName, frameNames);
        int i = 0;
        while (i < frameNames.length) {
            this._contents.put(frameNames[i], WebResponse.BLANK_RESPONSE);
            ++i;
        }
    }

    private static String getTargetFrameName(String sourceFrameName, String relativeName) {
        if (relativeName.equalsIgnoreCase("_top")) {
            return "_top";
        }
        if (sourceFrameName.indexOf(58) < 0) {
            return relativeName;
        }
        return WebFrame.getParentFrameName(sourceFrameName) + ':' + relativeName;
    }
}

