/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class EntityImageSynchroBar
extends AbstractEntityImage {
    public EntityImageSynchroBar(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    public StyleSignature getDefaultStyleDefinitionBar() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activityBar);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.getSkinParam().getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            return new Dimension2DDouble(8.0, 80.0);
        }
        return new Dimension2DDouble(80.0, 8.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        URectangle rect = new URectangle(dim.getWidth(), dim.getHeight());
        double shadowing = 0.0;
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            shadowing = 4.0;
        }
        HtmlColor color = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.activityBar);
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinitionBar().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            color = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
            shadowing = style.value(PName.Shadowing).asDouble();
        }
        rect.setDeltaShadow(shadowing);
        ug.apply(new UChangeColor(null)).apply(new UChangeBackColor(color)).draw(rect);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

