/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AParentFolder;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.preproc.DefineSignature;
import net.sourceforge.plantuml.preproc.Variables;
import net.sourceforge.plantuml.tim.TVariable;
import net.sourceforge.plantuml.tim.expression.TValue;

public class Define {
    private final DefineSignature signature;
    private final String definition;
    private final String definitionQuoted;
    private final boolean emptyParentheses;
    private Pattern pattern;
    private final AParentFolder currentDir;

    public Define(String key, List<String> lines, boolean emptyParentheses, AParentFolder currentDir) {
        this.currentDir = currentDir;
        this.emptyParentheses = emptyParentheses;
        if (lines == null) {
            this.definition = null;
            this.definitionQuoted = null;
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = lines.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append('\n');
            }
            this.definition = sb.toString();
            this.definitionQuoted = Matcher.quoteReplacement(this.definition);
        }
        this.signature = new DefineSignature(key, this.definitionQuoted);
    }

    public String toString() {
        return this.signature.toString();
    }

    public String apply(String line) {
        if (this.definition == null) {
            return line;
        }
        if (!line.contains(this.getFunctionName())) {
            return line;
        }
        if (this.signature.isMethod()) {
            if (line.indexOf(40) == -1) {
                return line;
            }
            line = this.apply1(line);
        } else {
            line = this.apply2(line);
        }
        return line;
    }

    private String apply2(String line) {
        if (this.pattern == null) {
            String regex = "\\b" + this.signature.getKey() + "\\b" + (this.emptyParentheses ? "(\\(\\))?" : "");
            this.pattern = Pattern.compile(regex);
        }
        line = BackSlash.translateBackSlashes(line);
        line = this.pattern.matcher(line).replaceAll(this.definitionQuoted);
        line = BackSlash.untranslateBackSlashes(line);
        return line;
    }

    private String apply1(String line) {
        for (Variables vars : this.signature.getVariationVariables()) {
            line = vars.applyOn(line);
        }
        return line;
    }

    public final String getFunctionName() {
        return this.signature.getFonctionName();
    }

    public TVariable asTVariable() {
        return new TVariable(TValue.fromString(this.definition));
    }
}

