#
# Copyright (c) 2014, Red Hat, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of Red Hat nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Authors:  Stanislav Ochotnicky <sochotnicky@redhat.com>

import sys
import optparse

from javapackages.xmvn.xmvn_config import XMvnConfig
from javapackages.common.exception import JavaPackagesToolsException


class SaneParser(optparse.OptionParser):
    def format_epilog(self, formatter):
        return self.epilog

usage = "usage: %prog [options] <optionstr> <content>"
epilog = """
Add custom configuration option

optionstr -- XPath-like expression for specifying XMvn configuration
             option location with '/' used as delimiter
             example: buildSettings/compilerSource

content -- XML content to be added to specified node. Can be just text, XML node or multiple nodes.

           examples:
           someText
           <someNode>someText</someNode><someOtherNode/>
"""

if __name__ == "__main__":
    parser = SaneParser(usage=usage,
                        epilog=epilog)

    (options, args) = parser.parse_args()
    if len(args) != 2:
        parser.error("Exactly 2 arguments are required")

    try:
        XMvnConfig().add_custom_option(args[0], args[1])
    except JavaPackagesToolsException as e:
        sys.exit(e)
