/*
 * Copyright (C) 2021 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

// This is a generated file - please don't modify directly
#pragma once

#include <cassert>
#include <cstddef>
#include <cstdint>
#include <cstring>
#include <type_traits>

#ifndef WCH_SAFE_COPY
#ifdef WIN32
#define WCH_SAFE_COPY memcpy_s
#else
inline int safeCopy(void *dst, size_t dstSize, const void *src, size_t sizeToCopy) {
    if (0 == sizeToCopy) {
        return 0;
    }
    if (!dst || !src || (sizeToCopy > dstSize)) {
        return -1;
    }
    memcpy(dst, src, sizeToCopy);
    return 0;
}
#define WCH_SAFE_COPY safeCopy
#endif
#endif

#ifndef WCH_ASSERT
#define WCH_ASSERT assert
#endif

struct TokenHeader {
    TokenHeader(uint16_t tokenId, uint8_t valueDwordCount) : id(tokenId), valueDwordCount(valueDwordCount) {}

    uint16_t id = 0U;             // token identifier
    uint8_t valueDwordCount = 0U; // regular value length in dwords
    union Flags {
        struct {
            bool flag0InlineValueBit0 : 1;  // inline value bit 0
            bool flag1InlineValueBit1 : 1;  // inline value bit 1
            bool flag2InlineValueBit2 : 1;  // inline value bit 2
            bool flag3IsMandatory : 1;      // if not 1, then can be ignored
            bool flag4IsVariableLength : 1; // if 1, then token type is base of TokenVariableLength
            bool flag6Reserved1 : 1;
            bool flag6Reserved2 : 1;
            bool flag7Reserved3 : 1;
        };
        uint8_t packed = 0U;
    } flags;
};
static_assert(std::is_standard_layout_v<TokenHeader>, "");
static_assert(sizeof(TokenHeader) == sizeof(uint32_t), "");

struct TokenVariableLength {
    TokenHeader header;

    TokenVariableLength(uint16_t tokenId, uint32_t arrayElementId, uint32_t valueLengthInBytes, uint32_t valuePaddedSizeInDwords)
        : header(tokenId, 0U), arrayElementId(arrayElementId), valueLengthInBytes(valueLengthInBytes), valuePaddedSizeInDwords(valuePaddedSizeInDwords) {
        header.flags.flag4IsVariableLength = 1;
    }

    TokenVariableLength(uint16_t tokenId, uint32_t arrayElementId, uint32_t valueLengthInBytes)
        : header(tokenId, 0U), arrayElementId(arrayElementId), valueLengthInBytes(valueLengthInBytes) {
        valuePaddedSizeInDwords = (valueLengthInBytes + sizeof(uint32_t) - 1) / sizeof(uint32_t);
        header.flags.flag4IsVariableLength = 1;
    }

    uint32_t arrayElementId = 0U;
    uint32_t valueLengthInBytes = 0U;
    uint32_t valuePaddedSizeInDwords = 1U;

    template <typename T>
    T *getValue() {
        return reinterpret_cast<T *>(this + 1);
    }

    template <typename T>
    const T *getValue() const {
        return reinterpret_cast<const T *>(this + 1);
    }
};
static_assert(std::is_standard_layout_v<TokenVariableLength>, "");
static_assert(sizeof(TokenVariableLength) == 3 * sizeof(uint32_t) + sizeof(TokenHeader), "");

template <size_t DwordsCount>
struct TokenArray {
    TokenHeader header;

    TokenArray(uint16_t tokenId, uint16_t elementSizeBits, uint16_t elementsCount) : header(tokenId, DwordsCount) {
        WCH_ASSERT(static_cast<size_t>(elementSizeBits * elementsCount) <= static_cast<size_t>(DwordsCount * sizeof(uint32_t) * 8U));
    }

    static_assert(DwordsCount <= 255, "");
    uint32_t value[DwordsCount] = {};

    template <typename T>
    T *getValue() {
        return reinterpret_cast<T *>(value);
    }

    template <typename T>
    const T *getValue() const {
        return reinterpret_cast<const T *>(value);
    }

    size_t getValueSizeInBytes() const {
        return header.valueDwordCount * sizeof(uint32_t);
    }
};

static_assert(std::is_standard_layout_v<TokenArray<2>>, "");
static_assert(sizeof(TokenArray<2>) == 2 * sizeof(uint32_t) + sizeof(TokenHeader), "");

struct TokenDword {
    TokenHeader header;

    TokenDword(uint16_t tokenId) : header(tokenId, 1U) {}

    uint32_t value = 0U;

    constexpr uint32_t getValue() const {
        return value;
    }

    void setValue(uint32_t v) {
        value = v;
    }
};
static_assert(std::is_standard_layout_v<TokenDword>, "");
static_assert(sizeof(TokenDword) == sizeof(TokenHeader) + sizeof(uint32_t), "");

struct TokenQword {
    TokenHeader header;

    TokenQword(uint16_t tokenId) : header(tokenId, 2U) {}

    uint32_t valueLo = 0U;
    uint32_t valueHi = 0U;

    constexpr uint64_t getValue() const {
        return (static_cast<uint64_t>(valueHi) << 32) | valueLo;
    }

    void setValue(uint64_t v) {
        valueHi = static_cast<uint32_t>(v >> 32);
        valueLo = static_cast<uint32_t>(v & 0x00000000FFFFFFFF);
    }
};
static_assert(std::is_standard_layout_v<TokenQword>, "");
static_assert(sizeof(TokenQword) == sizeof(TokenHeader) + sizeof(uint64_t), "");

struct TokenBool : TokenHeader {
    TokenBool(uint16_t tokenId) : TokenHeader(tokenId, 0U) {}

    constexpr bool getValue() const {
        return TokenHeader::flags.flag0InlineValueBit0;
    }

    void setValue(bool v) {
        TokenHeader::flags.flag0InlineValueBit0 = (v != false);
    }
};
static_assert(std::is_standard_layout_v<TokenBool>, "");
static_assert(sizeof(TokenBool) == sizeof(TokenHeader), "");

struct TokenPointer : TokenQword {
    TokenPointer(uint16_t tokenId) : TokenQword(tokenId) {}

    template <typename T>
    constexpr T *getValue() const {
        return reinterpret_cast<T *>(static_cast<uintptr_t>(TokenQword::getValue()));
    }

    template <typename T>
    void setValue(T *v) {
        TokenQword::setValue(static_cast<uint64_t>(reinterpret_cast<uintptr_t>(v)));
    }
};
static_assert(std::is_standard_layout_v<TokenPointer>, "");
static_assert(sizeof(TokenPointer) == sizeof(TokenQword), "");

template <typename T>
inline std::enable_if_t<false == std::is_pointer_v<T>, T> readTokValue(const TokenHeader &token) {
    T ret = {};
    switch (token.valueDwordCount) {
    default:
        WCH_ASSERT(false);
        break;
    case 0:
        ret = {static_cast<T>(reinterpret_cast<const TokenBool &>(token).getValue())};
        break;
    case 1:
        ret = {static_cast<T>(reinterpret_cast<const TokenDword &>(token).getValue())};
        break;
    case 2:
        ret = {static_cast<T>(reinterpret_cast<const TokenQword &>(token).getValue())};
        break;
    }
    return ret;
}
template <typename T>
inline std::enable_if_t<std::is_pointer_v<T>, T> readTokValue(const TokenHeader &token) {
    T ret = {};
    switch (token.valueDwordCount) {
    default:
        WCH_ASSERT(false);
        break;
    case 0:
        ret = {reinterpret_cast<T>(static_cast<uintptr_t>(reinterpret_cast<const TokenBool &>(token).getValue()))};
        break;
    case 1:
        ret = {reinterpret_cast<T>(static_cast<uintptr_t>(reinterpret_cast<const TokenDword &>(token).getValue()))};
        break;
    case 2:
        ret = {reinterpret_cast<T>(static_cast<uintptr_t>(reinterpret_cast<const TokenQword &>(token).getValue()))};
        break;
    }
    return ret;
}

// List of valid tokens
enum TOK : uint32_t {
    TOK_S_ADAPTER_INFO = 1,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS89755 = 4,
    TOK_S_GMM_RESOURCE_INFO_WIN_STRUCT = 7,
    TOK_S_GMM_MULTI_TILE_ARCH_REC = 8,
    TOK_S_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__ANONYMOUS32537 = 10,
    TOK_S_GMM_RESOURCE_FLAG_REC = 12,
    TOK_S_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882 = 14,
    TOK_S_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__ANONYMOUS32680 = 16,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS42853 = 17,
    TOK_S_SKU_FEATURE_TABLE = 19,
    TOK_S_ADAPTER_BDF___ANONYMOUS8173 = 20,
    TOK_S_WA_TABLE = 22,
    TOK_S_GT_CCS_INFO__CCSINSTANCES = 25,
    TOK_S_GFX_ESCAPE_HEADER = 26,
    TOK_S_GMM_EXISTING_SYS_MEM_REC = 28,
    TOK_S_GT_SUBSLICE_INFO = 29,
    TOK_S_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT = 31,
    TOK_S_GT_VDBOX_INFO__VDBOX_INSTANCES = 32,
    TOK_S_CREATECONTEXT_PVTDATA = 33,
    TOK_S_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193 = 36,
    TOK_S_GT_VDBOX_INFO__ANONYMOUS5662 = 37,
    TOK_S_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT = 39,
    TOK_S_GT_DUALSUBSLICE_INFO = 41,
    TOK_S_GMM_S3D_INFO_REC = 42,
    TOK_S_GTDIBASE_IN_STRUCT = 43,
    TOK_S_GFX_ESCAPE_HEADER__ANONYMOUS4410 = 44,
    TOK_S_GT_SLICE_INFO = 47,
    TOK_S_COMMAND_BUFFER_HEADER_REC = 48,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS3245 = 49,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS11155 = 51,
    TOK_S_GT_MULTI_TILE_ARCH_INFO = 52,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS91822 = 53,
    TOK_S_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4430 = 54,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS21584 = 55,
    TOK_S_GT_VEBOX_INFO = 56,
    TOK_S_GMM_2D_TEXTURE_OFFSET_INFO_REC = 57,
    TOK_S_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851 = 59,
    TOK_S_GT_SQIDI_INFO = 61,
    TOK_S_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856 = 62,
    TOK_S_CREATECONTEXT_PVTDATA__ANONYMOUS18449 = 63,
    TOK_S_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4963 = 64,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS21990 = 65,
    TOK_S_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682 = 66,
    TOK_S_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401 = 67,
    TOK_S_GT_VDBOX_INFO = 68,
    TOK_S_GT_VEBOX_INFO__VEBOX_INSTANCES = 69,
    TOK_S_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876 = 72,
    TOK_S_KMD_CAPS_INFO = 73,
    TOK_S_GT_VEBOX_INFO__ANONYMOUS3862 = 74,
    TOK_S_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT = 75,
    TOK_S_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457 = 76,
    TOK_S_GMM_3D_TEXTURE_OFFSET_INFO_REC = 78,
    TOK_S_KMD_OVERLAY_OVERRIDE = 79,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS54736 = 80,
    TOK_S_GMM_RESOURCE_INFO_COMMON_STRUCT = 81,
    TOK_S_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501 = 82,
    TOK_S_GT_CCS_INFO = 83,
    TOK_S_GMM_OFFSET_INFO_REC = 84,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS66219 = 85,
    TOK_S_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739 = 86,
    TOK_S_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797 = 87,
    TOK_S_GTDIGET_GPU_CPU_TIMESTAMPS_OUT_STRUCT = 88,
    TOK_S_KMD_OVERLAY_CAPS_INFO = 91,
    TOK_S_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521 = 92,
    TOK_S_GMM_OFFSET_INFO_REC__ANONYMOUS3429 = 94,
    TOK_S_TIME_STAMP_DATA_HEADER = 96,
    TOK_S_GT_CACHE_TYPES = 97,
    TOK_S_FRAME_RATE = 99,
    TOK_S_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171 = 100,
    TOK_S_GMM_RESOURCE_MSAA_INFO_REC = 102,
    TOK_S_GMM_TEXTURE_INFO_REC = 103,
    TOK_S_GMM_RESOURCE_ALIGNMENT_REC = 104,
    TOK_S_GT_CACHE_TYPES__ANONYMOUS9544 = 105,
    TOK_S_TIME_STAMP_DATA_HEADER__ANONYMOUS2466 = 109,
    TOK_S_GMM_TEXTURE_INFO_REC__ANONYMOUS4927 = 111,
    TOK_S_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191 = 112,
    TOK_S_GMM_TEXTURE_INFO_REC__ANONYMOUS6185 = 113,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS88095 = 115,
    TOK_S_GMM_TEXTURE_INFO_REC__ANONYMOUS6590 = 116,
    TOK_S_GT_SYSTEM_INFO = 122,
    TOK_S_KM_DEFERRED_WAIT_INFO = 123,
    TOK_S_GMM_PLANAR_OFFSET_INFO_REC = 128,
    TOK_S_SKU_FEATURE_TABLE__ANONYMOUS37751 = 134,
    TOK_S_GMM_GFX_PARTITIONING = 135,
    TOK_S_PLATFORM_STR = 141,
    TOK_S_ADAPTER_BDF = 142,
    TOK_S_GMM_GFX_PARTITIONING__ANONYMOUS7117 = 144,
    TOK_FBB_GT_SUBSLICE_INFO__ENABLED = 195,
    TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_COUNT = 196,
    TOK_FBD_GT_SUBSLICE_INFO__EU_ENABLED_MASK = 197,
    TOK_FBB_GT_DUALSUBSLICE_INFO__ENABLED = 198,
    TOK_FS_GT_DUALSUBSLICE_INFO__SUB_SLICE = 199,
    TOK_FBB_GT_SLICE_INFO__ENABLED = 200,
    TOK_FS_GT_SLICE_INFO__SUB_SLICE_INFO = 201,
    TOK_FS_GT_SLICE_INFO__DSSINFO = 202,
    TOK_FBD_GT_SLICE_INFO__SUB_SLICE_ENABLED_COUNT = 203,
    TOK_FBD_GT_SLICE_INFO__DUAL_SUB_SLICE_ENABLED_COUNT = 204,
    TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX0ENABLED = 205,
    TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX1ENABLED = 206,
    TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX2ENABLED = 207,
    TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBIT_STRUCT__VEBOX3ENABLED = 208,
    TOK_FS_GT_VEBOX_INFO__VEBOX_INSTANCES__BITS = 210,
    TOK_FBD_GT_VEBOX_INFO__VEBOX_INSTANCES__VEBOX_ENABLE_MASK = 211,
    TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX0 = 212,
    TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX1 = 213,
    TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX2 = 214,
    TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__ANONYMOUS3882__VEBOX3 = 215,
    TOK_FS_GT_VEBOX_INFO__ANONYMOUS3862__SFC_SUPPORTED_BITS = 217,
    TOK_FBD_GT_VEBOX_INFO__ANONYMOUS3862__VALUE = 218,
    TOK_FS_GT_VEBOX_INFO__INSTANCES = 219,
    TOK_FS_GT_VEBOX_INFO__SFCSUPPORT = 220,
    TOK_FBD_GT_VEBOX_INFO__NUMBER_OF_VEBOX_ENABLED = 221,
    TOK_FBB_GT_VEBOX_INFO__IS_VALID = 222,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX0ENABLED = 223,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX1ENABLED = 224,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX2ENABLED = 225,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX3ENABLED = 226,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX4ENABLED = 227,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX5ENABLED = 228,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX6ENABLED = 229,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBIT_STRUCT__VDBOX7ENABLED = 230,
    TOK_FS_GT_VDBOX_INFO__VDBOX_INSTANCES__BITS = 232,
    TOK_FBD_GT_VDBOX_INFO__VDBOX_INSTANCES__VDBOX_ENABLE_MASK = 233,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX0 = 234,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX1 = 235,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX2 = 236,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX3 = 237,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX4 = 238,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX5 = 239,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX6 = 240,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__ANONYMOUS5682__VDBOX7 = 241,
    TOK_FS_GT_VDBOX_INFO__ANONYMOUS5662__SFC_SUPPORTED_BITS = 243,
    TOK_FBD_GT_VDBOX_INFO__ANONYMOUS5662__VALUE = 244,
    TOK_FS_GT_VDBOX_INFO__INSTANCES = 245,
    TOK_FS_GT_VDBOX_INFO__SFCSUPPORT = 246,
    TOK_FBD_GT_VDBOX_INFO__NUMBER_OF_VDBOX_ENABLED = 247,
    TOK_FBB_GT_VDBOX_INFO__IS_VALID = 248,
    TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS0ENABLED = 257,
    TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS1ENABLED = 258,
    TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS2ENABLED = 259,
    TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSBIT_STRUCT__CCS3ENABLED = 260,
    TOK_FS_GT_CCS_INFO__CCSINSTANCES__BITS = 262,
    TOK_FBD_GT_CCS_INFO__CCSINSTANCES__CCSENABLE_MASK = 263,
    TOK_FS_GT_CCS_INFO__INSTANCES = 264,
    TOK_FBD_GT_CCS_INFO__NUMBER_OF_CCSENABLED = 265,
    TOK_FBB_GT_CCS_INFO__IS_VALID = 266,
    TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE0 = 271,
    TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE1 = 272,
    TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE2 = 273,
    TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__ANONYMOUS8876__TILE3 = 274,
    TOK_FBC_GT_MULTI_TILE_ARCH_INFO__ANONYMOUS8856__TILE_MASK = 276,
    TOK_FBC_GT_MULTI_TILE_ARCH_INFO__TILE_COUNT = 277,
    TOK_FBB_GT_MULTI_TILE_ARCH_INFO__IS_VALID = 278,
    TOK_FBD_GT_SQIDI_INFO__NUMBEROF_SQIDI = 279,
    TOK_FBD_GT_SQIDI_INFO__NUMBEROF_DOORBELL_PER_SQIDI = 280,
    TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__L3 = 281,
    TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__LLC = 282,
    TOK_FBD_GT_CACHE_TYPES__ANONYMOUS9544__E_DRAM = 283,
    TOK_FBD_GT_CACHE_TYPES__CACHE_TYPE_MASK = 285,
    TOK_FBD_GT_SYSTEM_INFO__EUCOUNT = 299,
    TOK_FBD_GT_SYSTEM_INFO__THREAD_COUNT = 300,
    TOK_FBD_GT_SYSTEM_INFO__SLICE_COUNT = 301,
    TOK_FBD_GT_SYSTEM_INFO__SUB_SLICE_COUNT = 302,
    TOK_FBD_GT_SYSTEM_INFO__DUAL_SUB_SLICE_COUNT = 303,
    TOK_FBQ_GT_SYSTEM_INFO__L3CACHE_SIZE_IN_KB = 304,
    TOK_FBQ_GT_SYSTEM_INFO__LLCCACHE_SIZE_IN_KB = 305,
    TOK_FBQ_GT_SYSTEM_INFO__EDRAM_SIZE_IN_KB = 306,
    TOK_FBD_GT_SYSTEM_INFO__L3BANK_COUNT = 308,
    TOK_FBD_GT_SYSTEM_INFO__MAX_FILL_RATE = 309,
    TOK_FBD_GT_SYSTEM_INFO__EU_COUNT_PER_POOL_MAX = 310,
    TOK_FBD_GT_SYSTEM_INFO__EU_COUNT_PER_POOL_MIN = 311,
    TOK_FBD_GT_SYSTEM_INFO__TOTAL_VS_THREADS = 312,
    TOK_FBD_GT_SYSTEM_INFO__TOTAL_HS_THREADS = 313,
    TOK_FBD_GT_SYSTEM_INFO__TOTAL_DS_THREADS = 314,
    TOK_FBD_GT_SYSTEM_INFO__TOTAL_GS_THREADS = 315,
    TOK_FBD_GT_SYSTEM_INFO__TOTAL_PS_THREADS_WINDOWER_RANGE = 316,
    TOK_FBD_GT_SYSTEM_INFO__TOTAL_VS_THREADS_POCS = 317,
    TOK_FBD_GT_SYSTEM_INFO__CSR_SIZE_IN_MB = 318,
    TOK_FBD_GT_SYSTEM_INFO__MAX_EU_PER_SUB_SLICE = 319,
    TOK_FBD_GT_SYSTEM_INFO__MAX_SLICES_SUPPORTED = 320,
    TOK_FBD_GT_SYSTEM_INFO__MAX_SUB_SLICES_SUPPORTED = 321,
    TOK_FBD_GT_SYSTEM_INFO__MAX_DUAL_SUB_SLICES_SUPPORTED = 322,
    TOK_FBB_GT_SYSTEM_INFO__IS_L3HASH_MODE_ENABLED = 323,
    TOK_FS_GT_SYSTEM_INFO__SLICE_INFO = 324,
    TOK_FBB_GT_SYSTEM_INFO__IS_DYNAMICALLY_POPULATED = 325,
    TOK_FS_GT_SYSTEM_INFO__SQIDI_INFO = 326,
    TOK_FBD_GT_SYSTEM_INFO__RESERVED_CCSWAYS = 327,
    TOK_FS_GT_SYSTEM_INFO__CCSINFO = 328,
    TOK_FS_GT_SYSTEM_INFO__MULTI_TILE_ARCH_INFO = 329,
    TOK_FS_GT_SYSTEM_INFO__VDBOX_INFO = 330,
    TOK_FS_GT_SYSTEM_INFO__VEBOX_INFO = 331,
    TOK_FBD_GT_SYSTEM_INFO__NUM_THREADS_PER_EU = 336,
    TOK_FS_GT_SYSTEM_INFO__CACHE_TYPES = 363,
    TOK_FBD_GT_SYSTEM_INFO__MAX_VECS = 371,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_DESKTOP = 381,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_VERING = 395,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_VCS2 = 398,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT_BIG_DIE = 401,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT_MEDIUM_DIE = 402,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT_SMALL_DIE = 403,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT1 = 404,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT1_5 = 406,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT2 = 409,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT2_5 = 411,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT3 = 412,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GT4 = 414,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_ULT = 423,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_IVBM0M1PLATFORM = 425,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CHANNEL_SWIZZLING_XORENABLED = 434,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GTA = 439,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GTC = 440,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_GTX = 441,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR5SLICE = 442,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_LCIA = 445,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_RESOURCE_STREAMER = 450,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSRING = 453,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSNODE = 457,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS3245__FTR_CCSMULTI_INSTANCE = 458,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS11155__FTR_DISPLAY_DISABLED = 485,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS11155__FTR_SGTPVSKUSTRAP_PRESENT = 486,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21584__FTR_POOLED_EU_ENABLED = 573,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_MID_BATCH_PREEMPT = 587,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_THREAD_GROUP_LEVEL_PREEMPT = 588,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GP_GPU_MID_THREAD_LEVEL_PREEMPT = 589,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR3D_MID_BATCH_PREEMPT = 590,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR3D_OBJECT_LEVEL_PREEMPT = 591,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PER_CTXT_PREEMPTION_GRANULARITY_CONTROL = 595,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PPGTT = 598,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_IA32E_GFX_PTES = 599,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_MEM_TYPE_MOCS_DEFER_PAT = 600,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PML4SUPPORT = 601,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_SVM = 603,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TILE_MAPPED_RESOURCE = 605,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TRANSLATION_TABLE = 606,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_USER_MODE_TRANSLATION_TABLE = 607,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_NULL_PAGES = 608,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_L3IACOHERENCY = 609,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_EDRAM = 615,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LLCBYPASS = 617,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_CRYSTALWELL = 618,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_CENTRAL_CACHE_POLICY = 619,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_IO_MMU_PAGE_FAULTING = 622,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2GPU_MMU = 626,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2SVM = 627,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_STANDARD_MIP_TAIL_FORMAT = 628,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_WDDM2_1_64KB_PAGES = 630,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_GTT_CACHE_INVALIDATION = 632,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_E2ECOMPRESSION = 634,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LINEAR_CCS = 636,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LOCAL_MEMORY = 640,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_PPGTT64KBWALK_OPTIMIZATION = 642,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_TILE_Y = 645,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_FLAT_PHYS_CCS = 647,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_MULTI_TILE_ARCH = 651,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_LOCAL_MEMORY_ALLOWS4KB = 652,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_DISPLAY_XTILING = 653,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_CAMERA_CAPTURE_CACHING = 660,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_KMD_DAF = 668,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_FRAME_BUFFER_LLC = 679,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS21990__FTR_DRIVER_FLR = 681,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC_LDR2D = 726,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC_HDR2D = 727,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS37751__FTR_ASTC3D = 728,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS42853__FTR_FBC = 760,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS42853__FTR_FBC2ADDRESS_TRANSLATION = 761,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS42853__FTR_FBC_BLITTER_TRACKING = 762,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS42853__FTR_FBC_CPU_TRACKING = 764,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS42853__FTR_VEBOX = 800,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS54736__FTR_REND_COMP = 934,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS54736__FTR_DISPLAY_YTILING = 937,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_S3D = 1123,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_DISPLAY_ENGINE_S3D = 1124,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_SINGLE_VEBOX_SLICE = 1160,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS66219__FTR_SIMULATION_MODE = 1168,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS88095__FTR_ENABLE_GU_C = 1224,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS89755__FTR_VGT = 1239,
    TOK_FBD_SKU_FEATURE_TABLE__ANONYMOUS91822__FTR_ASSIGNED_GPU_TILE = 1257,
    TOK_FBD_WA_TABLE__WA_DO_NOT_USE_MIREPORT_PERF_COUNT = 1562,
    TOK_FBD_WA_TABLE__WA_ALIGN_INDEX_BUFFER = 1606,
    TOK_FBD_WA_TABLE__WA_SEND_MIFLUSHBEFORE_VFE = 1644,
    TOK_FBD_WA_TABLE__WA_DISABLE_PER_CTXT_PREEMPTION_GRANULARITY_CONTROL = 1651,
    TOK_FBD_WA_TABLE__WA_ENABLE_PREEMPTION_GRANULARITY_CONTROL_BY_UMD = 1652,
    TOK_FBD_WA_TABLE__WA_DISABLE_LSQCROPERFFOR_OCL = 1659,
    TOK_FBD_WA_TABLE__WA_VALIGN2FOR96BPP_FORMATS = 1858,
    TOK_FBD_WA_TABLE__WA_VALIGN2FOR_R8G8B8UINTFORMAT = 1859,
    TOK_FBD_WA_TABLE__WA_REPORT_PERF_COUNT_USE_GLOBAL_CONTEXT_ID = 2061,
    TOK_FBD_WA_TABLE__WA_FORCE_PC_BB_FULL_CFG_RESTORE = 2062,
    TOK_FBD_WA_TABLE__WA_CSRUNCACHABLE = 2099,
    TOK_FBD_WA_TABLE__WA_DISABLE_FUSED_THREAD_SCHEDULING = 2132,
    TOK_FBD_WA_TABLE__WA_MODIFY_VFESTATE_AFTER_GPGPUPREEMPTION = 2137,
    TOK_FBD_WA_TABLE__WA_CURSOR16K = 2148,
    TOK_FBD_WA_TABLE__WA8K_ALIGNFOR_ASYNC_FLIP = 2152,
    TOK_FBD_WA_TABLE__WA29BIT_DISPLAY_ADDR_LIMIT = 2153,
    TOK_FBD_WA_TABLE__WA_ALIGN_CONTEXT_IMAGE = 2157,
    TOK_FBD_WA_TABLE__WA_FORCE_GLOBAL_GTT = 2158,
    TOK_FBD_WA_TABLE__WA_REPORT_PERF_COUNT_FORCE_GLOBAL_GTT = 2159,
    TOK_FBD_WA_TABLE__WA_OA_ADDRESS_TRANSLATION = 2160,
    TOK_FBD_WA_TABLE__WA2ROW_VERTICAL_ALIGNMENT = 2161,
    TOK_FBD_WA_TABLE__WA_PPGTT_ALIAS_GLOBAL_GTT_SPACE = 2166,
    TOK_FBD_WA_TABLE__WA_CLEAR_FENCE_REGISTERS_AT_DRIVER_INIT = 2167,
    TOK_FBD_WA_TABLE__WA_RESTRICT_PITCH128KB = 2169,
    TOK_FBD_WA_TABLE__WA_AVOID_LLC = 2170,
    TOK_FBD_WA_TABLE__WA_AVOID_L3 = 2171,
    TOK_FBD_WA_TABLE__WA16TILE_FENCES_ONLY = 2172,
    TOK_FBD_WA_TABLE__WA16MBOABUFFER_ALIGNMENT = 2181,
    TOK_FBD_WA_TABLE__WA_TRANSLATION_TABLE_UNAVAILABLE = 2185,
    TOK_FBD_WA_TABLE__WA_NO_MINIMIZED_TRIVIAL_SURFACE_PADDING = 2189,
    TOK_FBD_WA_TABLE__WA_NO_BUFFER_SAMPLER_PADDING = 2190,
    TOK_FBD_WA_TABLE__WA_SURFACE_STATE_PLANAR_YOFFSET_ALIGN_BY2 = 2196,
    TOK_FBD_WA_TABLE__WA_GTT_CACHING_OFF_BY_DEFAULT = 2197,
    TOK_FBD_WA_TABLE__WA_TOUCH_ALL_SVM_MEMORY = 2203,
    TOK_FBD_WA_TABLE__WA_IOBADDRESS_MUST_BE_VALID_IN_HW_CONTEXT = 2204,
    TOK_FBD_WA_TABLE__WA_FLUSH_TLB_AFTER_CPU_GGTT_WRITES = 2206,
    TOK_FBD_WA_TABLE__WA_MSAA8X_TILE_YDEPTH_PITCH_ALIGNMENT = 2207,
    TOK_FBD_WA_TABLE__WA_DISABLE_NULL_PAGE_AS_DUMMY = 2209,
    TOK_FBD_WA_TABLE__WA_USE_VALIGN16ON_TILE_XYBPP816 = 2211,
    TOK_FBD_WA_TABLE__WA_GTT_PAT0 = 2214,
    TOK_FBD_WA_TABLE__WA_GTT_PAT0WB = 2215,
    TOK_FBD_WA_TABLE__WA_MEM_TYPE_IS_MAX_OF_PAT_AND_MOCS = 2216,
    TOK_FBD_WA_TABLE__WA_GTT_PAT0GTT_WB_OVER_OS_IOMMU_ELLC_ONLY = 2218,
    TOK_FBD_WA_TABLE__WA_ADD_DUMMY_PAGE_FOR_DISPLAY_PREFETCH = 2219,
    TOK_FBD_WA_TABLE__WA_DEFAULT_TILE4 = 2221,
    TOK_FBD_WA_TABLE__WA_LLCCACHING_UNSUPPORTED = 2244,
    TOK_FBD_WA_TABLE__WA_DOUBLE_FAST_CLEAR_WIDTH_ALIGNMENT = 2350,
    TOK_FBD_WA_TABLE__WA_COMPRESSED_RESOURCE_REQUIRES_CONST_VA21 = 2387,
    TOK_FBD_WA_TABLE__WA_DISREGARD_PLATFORM_CHECKS = 2391,
    TOK_FBD_WA_TABLE__WA_LOSSLESS_COMPRESSION_SURFACE_STRIDE = 2485,
    TOK_FBD_WA_TABLE__WA_FBC_LINEAR_SURFACE_STRIDE = 2486,
    TOK_FBD_WA_TABLE__WA4K_ALIGN_UVOFFSET_NV12LINEAR_SURFACE = 2490,
    TOK_FBD_WA_TABLE__WA_ASTC_CORRUPTION_FOR_ODD_COMPRESSED_BLOCK_SIZE_X = 2528,
    TOK_FBD_WA_TABLE__WA_AUX_TABLE16KGRANULAR = 2553,
    TOK_FBD_WA_TABLE__WA_ENCRYPTED_EDRAM_ONLY_PARTIALS = 2600,
    TOK_FBD_WA_TABLE__WA_DISABLE_EDRAM_FOR_DISPLAY_RT = 2601,
    TOK_FBD_WA_TABLE__WA_LIMIT128BMEDIA_COMPR = 2602,
    TOK_FBD_WA_TABLE__WA_UNTYPED_BUFFER_COMPRESSION = 2603,
    TOK_FBD_WA_TABLE__WA_SAMPLER_CACHE_FLUSH_BETWEEN_REDESCRIBED_SURFACE_READS = 2606,
    TOK_FBD_WA_TABLE__WA_ALIGN_YUVRESOURCE_TO_LCU = 2702,
    TOK_FBD_WA_TABLE__WA32BPP_TILE_Y2DCOLOR_NO_HALIGN4 = 2711,
    TOK_FE_PLATFORM_STR__E_PRODUCT_FAMILY = 3475,
    TOK_FE_PLATFORM_STR__E_PCHPRODUCT_FAMILY = 3476,
    TOK_FE_PLATFORM_STR__E_DISPLAY_CORE_FAMILY = 3477,
    TOK_FE_PLATFORM_STR__E_RENDER_CORE_FAMILY = 3478,
    TOK_FE_PLATFORM_STR__E_PLATFORM_TYPE = 3479,
    TOK_FBW_PLATFORM_STR__US_DEVICE_ID = 3480,
    TOK_FBW_PLATFORM_STR__US_REV_ID = 3481,
    TOK_FBW_PLATFORM_STR__US_DEVICE_ID_PCH = 3482,
    TOK_FBW_PLATFORM_STR__US_REV_ID_PCH = 3483,
    TOK_FE_PLATFORM_STR__E_GTTYPE = 3484,
    TOK_FBD_KMD_CAPS_INFO__GAMMA_RGB256X3X16 = 3501,
    TOK_FBD_KMD_CAPS_INFO__GDIACCELERATION = 3502,
    TOK_FBD_KMD_CAPS_INFO__OS_MANAGED_HW_CONTEXT = 3503,
    TOK_FBD_KMD_CAPS_INFO__GRAPHICS_PREEMPTION_GRANULARITY = 3504,
    TOK_FBD_KMD_CAPS_INFO__COMPUTE_PREEMPTION_GRANULARITY = 3505,
    TOK_FBD_KMD_CAPS_INFO__INSTRUMENTATION_IS_ENABLED = 3506,
    TOK_FBD_KMD_CAPS_INFO__DRIVER_STORE_ENABLED = 3507,
    TOK_FBD_KMD_OVERLAY_OVERRIDE__OVERRIDE_OVERLAY_CAPS = 3508,
    TOK_FBD_KMD_OVERLAY_OVERRIDE__RGBOVERLAY = 3509,
    TOK_FBD_KMD_OVERLAY_OVERRIDE__YUY2OVERLAY = 3510,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__FULL_RANGE_RGB = 3512,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__LIMITED_RANGE_RGB = 3513,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT601 = 3514,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT709 = 3515,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT601_XV_YCC = 3516,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__YCB_CR_BT709_XV_YCC = 3517,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__STRETCH_X = 3518,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__ANONYMOUS5191__STRETCH_Y = 3519,
    TOK_FS_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__CAPS = 3521,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__ANONYMOUS5171__CAPS_VALUE = 3522,
    TOK_FS_KMD_OVERLAY_CAPS_INFO__OVOVERRIDE = 3523,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_OVERLAY_DISPLAY_WIDTH = 3524,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_OVERLAY_DISPLAY_HEIGHT = 3525,
    TOK_FBC_KMD_OVERLAY_CAPS_INFO__HWSCALER_EXISTS = 3526,
    TOK_FBD_KMD_OVERLAY_CAPS_INFO__MAX_HWSCALER_STRIDE = 3527,
    TOK_FBD_FRAME_RATE__UI_NUMERATOR = 3528,
    TOK_FBD_FRAME_RATE__UI_DENOMINATOR = 3529,
    TOK_FBD_KM_DEFERRED_WAIT_INFO__FEATURE_SUPPORTED = 3530,
    TOK_FBD_KM_DEFERRED_WAIT_INFO__ACTIVE_DISPLAY = 3531,
    TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__BASE = 3532,
    TOK_FBQ_GMM_GFX_PARTITIONING__ANONYMOUS7117__LIMIT = 3533,
    TOK_FS_GMM_GFX_PARTITIONING__STANDARD = 3534,
    TOK_FS_GMM_GFX_PARTITIONING__STANDARD64KB = 3535,
    TOK_FS_GMM_GFX_PARTITIONING__SVM = 3538,
    TOK_FS_GMM_GFX_PARTITIONING__HEAP32 = 3540,
    TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__BUS = 3541,
    TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__DEVICE = 3542,
    TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__ANONYMOUS8193__FUNCTION = 3543,
    TOK_FBD_ADAPTER_BDF___ANONYMOUS8173__DATA = 3545,
    TOK_FBD_ADAPTER_INFO__KMD_VERSION_INFO = 3548,
    TOK_FBC_ADAPTER_INFO__DEVICE_REGISTRY_PATH = 3550,
    TOK_FS_ADAPTER_INFO__GFX_PLATFORM = 3551,
    TOK_FS_ADAPTER_INFO__SKU_TABLE = 3552,
    TOK_FS_ADAPTER_INFO__WA_TABLE = 3553,
    TOK_FBD_ADAPTER_INFO__GFX_TIME_STAMP_FREQ = 3555,
    TOK_FBD_ADAPTER_INFO__GFX_CORE_FREQUENCY = 3556,
    TOK_FBD_ADAPTER_INFO__FSBFREQUENCY = 3557,
    TOK_FBD_ADAPTER_INFO__MIN_RENDER_FREQ = 3558,
    TOK_FBD_ADAPTER_INFO__MAX_RENDER_FREQ = 3559,
    TOK_FBD_ADAPTER_INFO__PACKAGE_TDP = 3560,
    TOK_FBD_ADAPTER_INFO__MAX_FILL_RATE = 3561,
    TOK_FBD_ADAPTER_INFO__NUMBER_OF_EUS = 3562,
    TOK_FBD_ADAPTER_INFO__DW_RELEASE_TARGET = 3563,
    TOK_FBD_ADAPTER_INFO__SIZE_OF_DMA_BUFFER = 3564,
    TOK_FBD_ADAPTER_INFO__PATCH_LOCATION_LIST_SIZE = 3565,
    TOK_FBD_ADAPTER_INFO__ALLOCATION_LIST_SIZE = 3566,
    TOK_FBD_ADAPTER_INFO__SMALL_PATCH_LOCATION_LIST_SIZE = 3567,
    TOK_FBD_ADAPTER_INFO__DEFAULT_CMD_BUFFER_SIZE = 3568,
    TOK_FBQ_ADAPTER_INFO__GFX_MEMORY_SIZE = 3569,
    TOK_FBD_ADAPTER_INFO__SYSTEM_MEMORY_SIZE = 3570,
    TOK_FBD_ADAPTER_INFO__CACHE_LINE_SIZE = 3571,
    TOK_FE_ADAPTER_INFO__PROCESSOR_FAMILY = 3572,
    TOK_FBC_ADAPTER_INFO__IS_HTSUPPORTED = 3573,
    TOK_FBC_ADAPTER_INFO__IS_MUTI_CORE_CPU = 3574,
    TOK_FBC_ADAPTER_INFO__IS_VTDSUPPORTED = 3575,
    TOK_FBD_ADAPTER_INFO__REGISTRY_PATH_LENGTH = 3576,
    TOK_FBQ_ADAPTER_INFO__DEDICATED_VIDEO_MEMORY = 3577,
    TOK_FBQ_ADAPTER_INFO__SYSTEM_SHARED_MEMORY = 3578,
    TOK_FBQ_ADAPTER_INFO__SYSTEM_VIDEO_MEMORY = 3579,
    TOK_FS_ADAPTER_INFO__OUTPUT_FRAME_RATE = 3580,
    TOK_FS_ADAPTER_INFO__INPUT_FRAME_RATE = 3581,
    TOK_FS_ADAPTER_INFO__CAPS = 3583,
    TOK_FS_ADAPTER_INFO__OVERLAY_CAPS = 3584,
    TOK_FS_ADAPTER_INFO__SYSTEM_INFO = 3585,
    TOK_FS_ADAPTER_INFO__DEFERRED_WAIT_INFO = 3587,
    TOK_FS_ADAPTER_INFO__GFX_PARTITION = 3588,
    TOK_FS_ADAPTER_INFO__ST_ADAPTER_BDF = 3594,
    TOK_PBQ_CREATECONTEXT_PVTDATA__ANONYMOUS18449__P_HW_CONTEXT_ID = 3632,
    TOK_FBD_CREATECONTEXT_PVTDATA__NUMBER_OF_HW_CONTEXT_IDS = 3634,
    TOK_FBD_CREATECONTEXT_PVTDATA__PROCESS_ID = 3635,
    TOK_FBC_CREATECONTEXT_PVTDATA__IS_PROTECTED_PROCESS = 3636,
    TOK_FBC_CREATECONTEXT_PVTDATA__IS_DWM = 3637,
    TOK_FBC_CREATECONTEXT_PVTDATA__IS_MEDIA_USAGE = 3639,
    TOK_FBC_CREATECONTEXT_PVTDATA__GPU_VACONTEXT = 3644,
    TOK_FBC_CREATECONTEXT_PVTDATA__NO_RING_FLUSHES = 3651,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__ANONYMOUS32537__INDEX = 3679,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__ANONYMOUS32537__OFFSET = 3680,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__ANONYMOUS32680__LOW_PART = 3681,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__ANONYMOUS32680__HIGH_PART = 3682,
    TOK_FS_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__ALLOCATION = 3683,
    TOK_FS_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ANONYMOUS32501__GFX_ADDRESS = 3684,
    TOK_FS_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__ADDRESS = 3685,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ANONYMOUS32457__VALUE = 3686,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__ENABLE = 3687,
    TOK_FS_COMMAND_BUFFER_HEADER_REC__ANONYMOUS32401__TAG = 3688,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_CONTEXT_TYPE = 3690,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_PATCH_LIST = 3691,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_REQUESTED_SLICE_STATE = 3699,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_REQUESTED_SUBSLICE_COUNT = 3701,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__UMD_REQUESTED_EUCOUNT = 3702,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__USES_RESOURCE_STREAMER = 3704,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__NEEDS_MID_BATCH_PRE_EMPTION_SUPPORT = 3705,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__USES_GPGPUPIPELINE = 3708,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__REQUIRES_COHERENCY = 3709,
    TOK_FBD_COMMAND_BUFFER_HEADER_REC__PERF_TAG = 3726,
    TOK_FBQ_COMMAND_BUFFER_HEADER_REC__MONITOR_FENCE_VA = 3730,
    TOK_FBQ_COMMAND_BUFFER_HEADER_REC__MONITOR_FENCE_VALUE = 3731,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CAMERA_CAPTURE = 3740,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CCS = 3741,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_DISCARD = 3742,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION = 3743,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__COLOR_SEPARATION_RGBX = 3744,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__CONSTANT = 3745,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__DEPTH = 3746,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN = 3747,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__FLIP_CHAIN_PREFERRED = 3748,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HISTORY_BUFFER = 3749,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__HI_Z = 3750,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDEX = 3751,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INDIRECT_CLEAR_COLOR = 3752,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INSTRUCTION_FLAT = 3753,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__INTERLACED_SCAN = 3754,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MCS = 3755,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MMC = 3756,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__MOTION_COMP = 3757,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__NO_RESTRICTION = 3758,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__OVERLAY = 3759,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PRESENTABLE = 3760,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__PROCEDURAL_TEXTURE = 3761,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__QUERY = 3762,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__RENDER_TARGET = 3763,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D = 3764,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__S3D_DX = 3765,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_NON_PACKED = 3766,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____S3D_WIDI = 3767,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SCRATCH_FLAT = 3768,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__SEPARATE_STENCIL = 3769,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE = 3770,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STATE_DX9CONSTANT_BUFFER = 3771,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__STREAM = 3772,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXT_API = 3773,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TEXTURE = 3774,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILED_RESOURCE = 3775,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__TILE_POOL = 3776,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__UNIFIED_AUX_SURFACE = 3777,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VERTEX = 3778,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739__VIDEO = 3779,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_XCCS = 3780,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_TILE_YCCS = 3781,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____MSAA_TILE_MCS = 3782,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____NON_MSAA_LINEAR_CCS = 3783,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS1739____REMAINING = 3785,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ALLOW_VIRTUAL_PADDING = 3786,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__BIG_PAGE = 3787,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CACHEABLE = 3788,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CONTIG_PHYS_MEMORY_FORI_DART = 3789,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__CORNER_TEXEL_MODE = 3790,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__EXISTING_SYS_MEM = 3791,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__FORCE_RESIDENCY = 3792,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GFDT = 3793,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__GTT_MAP_TYPE = 3794,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__HARDWARE_PROTECTED = 3795,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__KERNEL_MODE_MAPPED = 3796,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_BELOW = 3797,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_MONO = 3798,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LAYOUT_RIGHT = 3799,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LOCAL_ONLY = 3800,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__LINEAR = 3801,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__MEDIA_COMPRESSED = 3802,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_OPTIMIZATION_PADDING = 3803,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NO_PHYS_MEMORY = 3805,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NOT_LOCKABLE = 3806,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__NON_LOCAL_ONLY = 3807,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__STD_SWIZZLE = 3808,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__PSEUDO_STD_SWIZZLE = 3809,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__UNDEFINED64KBSWIZZLE = 3810,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__REDECRIBED_PLANES = 3811,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__RENDER_COMPRESSED = 3812,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__ROTATED = 3813,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SHARED = 3814,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SOFTWARE_PROTECTED = 3815,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__SVM = 3816,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE4 = 3817,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILE64 = 3818,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_W = 3819,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_X = 3820,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_Y = 3821,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YF = 3822,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__TILED_YS = 3823,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__WDDM_PROTECTED = 3824,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797__XADAPTER = 3825,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PREALLOCATED_RES_INFO = 3826,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS6797____PRE_WDDM2SVM = 3827,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__GTMFX2ND_LEVEL_BATCH_RING_SIZE_ALIGN = 3837,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_MPR_ROW_STORE32KALIGN = 3838,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__ILKNEED_AVC_DMV_BUFFER32KALIGN = 3839,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_BUFFER_SAMPLER_PADDING = 3840,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__NO_LEGACY_PLANAR_LINEAR_VIDEO_RESTRICTIONS = 3841,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__CHVASTC_SKIP_VIRTUAL_MIPS = 3842,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_PACKED_MIP_TAIL = 3843,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521____FORCE_OTHER_HVALIGN4 = 3844,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_CLEAR_COLOR = 3845,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__DISABLE_DISPLAY_CCS_COMPRESSION = 3846,
    TOK_FBD_GMM_RESOURCE_FLAG_REC__ANONYMOUS12521__PRE_GEN12FAST_CLEAR_ONLY = 3847,
    TOK_FS_GMM_RESOURCE_FLAG_REC__GPU = 3849,
    TOK_FS_GMM_RESOURCE_FLAG_REC__INFO = 3850,
    TOK_FS_GMM_RESOURCE_FLAG_REC__WA = 3851,
    TOK_FE_GMM_RESOURCE_MSAA_INFO_REC__SAMPLE_PATTERN = 3852,
    TOK_FBD_GMM_RESOURCE_MSAA_INFO_REC__NUM_SAMPLES = 3853,
    TOK_FBC_GMM_RESOURCE_ALIGNMENT_REC__ARRAY_SPACING_SINGLE_LOD = 3854,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__BASE_ALIGNMENT = 3855,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__HALIGN = 3856,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__VALIGN = 3857,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__DALIGN = 3858,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__MIP_TAIL_START_LOD = 3859,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_START_LOD = 3860,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_WIDTH = 3861,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__PACKED_MIP_HEIGHT = 3862,
    TOK_FBD_GMM_RESOURCE_ALIGNMENT_REC__QPITCH = 3863,
    TOK_FBD_GMM_S3D_INFO_REC__DISPLAY_MODE_HEIGHT = 3864,
    TOK_FBD_GMM_S3D_INFO_REC__NUM_BLANK_ACTIVE_LINES = 3865,
    TOK_FBD_GMM_S3D_INFO_REC__RFRAME_OFFSET = 3866,
    TOK_FBD_GMM_S3D_INFO_REC__BLANK_AREA_OFFSET = 3867,
    TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_HEIGHT = 3868,
    TOK_FBD_GMM_S3D_INFO_REC__TALL_BUFFER_SIZE = 3869,
    TOK_FBC_GMM_S3D_INFO_REC__IS_RFRAME = 3870,
    TOK_FBC_GMM_MULTI_TILE_ARCH_REC__ENABLE = 3871,
    TOK_FBC_GMM_MULTI_TILE_ARCH_REC__TILE_INSTANCED = 3872,
    TOK_FBC_GMM_MULTI_TILE_ARCH_REC__GPU_VA_MAPPING_SET = 3873,
    TOK_FBC_GMM_MULTI_TILE_ARCH_REC__LOCAL_MEM_ELIGIBILITY_SET = 3874,
    TOK_FBC_GMM_MULTI_TILE_ARCH_REC__LOCAL_MEM_PREFERRED_SET = 3875,
    TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ANONYMOUS1851__HEIGHT = 3877,
    TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__ARRAY_QPITCH = 3878,
    TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__X = 3879,
    TOK_FBQ_GMM_PLANAR_OFFSET_INFO_REC__Y = 3880,
    TOK_FS_GMM_PLANAR_OFFSET_INFO_REC__UN_ALIGNED = 3881,
    TOK_FBD_GMM_PLANAR_OFFSET_INFO_REC__NO_OF_PLANES = 3886,
    TOK_FBB_GMM_PLANAR_OFFSET_INFO_REC__IS_TILE_ALIGNED_PLANES = 3887,
    TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_LOCK = 3888,
    TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__ARRAY_QPITCH_RENDER = 3889,
    TOK_FBQ_GMM_2D_TEXTURE_OFFSET_INFO_REC__OFFSET = 3890,
    TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__MIP0SLICE_PITCH = 3891,
    TOK_FBQ_GMM_3D_TEXTURE_OFFSET_INFO_REC__OFFSET = 3892,
    TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE3DOFFSET_INFO = 3893,
    TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__TEXTURE2DOFFSET_INFO = 3894,
    TOK_FS_GMM_OFFSET_INFO_REC__ANONYMOUS3429__PLANE = 3895,
    TOK_FE_GMM_TEXTURE_INFO_REC__ANONYMOUS4927__USAGE = 3896,
    TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__SEG1 = 3898,
    TOK_FBD_GMM_TEXTURE_INFO_REC__ANONYMOUS6185__EVICT = 3899,
    TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_GMM_ALLOCATED = 3900,
    TOK_FBC_GMM_TEXTURE_INFO_REC__ANONYMOUS6590__IS_PAGE_ALIGNED = 3901,
    TOK_FE_GMM_TEXTURE_INFO_REC__TYPE = 3902,
    TOK_FE_GMM_TEXTURE_INFO_REC__FORMAT = 3903,
    TOK_FBD_GMM_TEXTURE_INFO_REC__BITS_PER_PIXEL = 3904,
    TOK_FS_GMM_TEXTURE_INFO_REC__FLAGS = 3905,
    TOK_FBQ_GMM_TEXTURE_INFO_REC__BASE_WIDTH = 3906,
    TOK_FBD_GMM_TEXTURE_INFO_REC__BASE_HEIGHT = 3907,
    TOK_FBD_GMM_TEXTURE_INFO_REC__DEPTH = 3908,
    TOK_FBD_GMM_TEXTURE_INFO_REC__MAX_LOD = 3909,
    TOK_FBD_GMM_TEXTURE_INFO_REC__ARRAY_SIZE = 3910,
    TOK_FBD_GMM_TEXTURE_INFO_REC__CP_TAG = 3911,
    TOK_FS_GMM_TEXTURE_INFO_REC__CACHE_POLICY = 3912,
    TOK_FS_GMM_TEXTURE_INFO_REC__MSAA = 3913,
    TOK_FS_GMM_TEXTURE_INFO_REC__ALIGNMENT = 3914,
    TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_MODE = 3915,
    TOK_FBC_GMM_TEXTURE_INFO_REC__MMC_HINT = 3916,
    TOK_FBQ_GMM_TEXTURE_INFO_REC__PITCH = 3917,
    TOK_FBQ_GMM_TEXTURE_INFO_REC__OVERRIDE_PITCH = 3918,
    TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE = 3919,
    TOK_FBQ_GMM_TEXTURE_INFO_REC__CCSIZE = 3920,
    TOK_FBQ_GMM_TEXTURE_INFO_REC__UNPADDED_SIZE = 3921,
    TOK_FBQ_GMM_TEXTURE_INFO_REC__SIZE_REPORT_TO_OS = 3922,
    TOK_FS_GMM_TEXTURE_INFO_REC__OFFSET_INFO = 3923,
    TOK_FE_GMM_TEXTURE_INFO_REC__TILE_MODE = 3924,
    TOK_FBD_GMM_TEXTURE_INFO_REC__CCSMODE_ALIGN = 3925,
    TOK_FBD_GMM_TEXTURE_INFO_REC__LEGACY_FLAGS = 3926,
    TOK_FS_GMM_TEXTURE_INFO_REC__S3D = 3927,
    TOK_FS_GMM_TEXTURE_INFO_REC__SEGMENT_OVERRIDE = 3929,
    TOK_FBD_GMM_TEXTURE_INFO_REC__MAXIMUM_RENAMING_LIST_LENGTH = 3930,
    TOK_FS_GMM_TEXTURE_INFO_REC__PLATFORM = 3931, // _DEBUG || _RELEASE_INTERNAL
    TOK_FS_GMM_TEXTURE_INFO_REC__EXISTING_SYS_MEM = 3932,
    TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_EXISTING_SYS_MEM = 3944,
    TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_VIRT_ADDRESS = 3945,
    TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__P_GFX_ALIGNED_VIRT_ADDRESS = 3946,
    TOK_FBQ_GMM_EXISTING_SYS_MEM_REC__SIZE = 3948,
    TOK_FBC_GMM_EXISTING_SYS_MEM_REC__IS_GMM_ALLOCATED = 3949,
    TOK_FE_GMM_RESOURCE_INFO_COMMON_STRUCT__CLIENT_TYPE = 3950,
    TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__SURF = 3951,
    TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__AUX_SURF = 3952,
    TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__AUX_SEC_SURF = 3953,
    TOK_FBD_GMM_RESOURCE_INFO_COMMON_STRUCT__ROTATE_INFO = 3954,
    TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__EXISTING_SYS_MEM = 3955,
    TOK_FBQ_GMM_RESOURCE_INFO_COMMON_STRUCT__SVM_ADDRESS = 3956,
    TOK_FBQ_GMM_RESOURCE_INFO_COMMON_STRUCT__P_PRIVATE_DATA = 3959,
    TOK_FS_GMM_RESOURCE_INFO_COMMON_STRUCT__MULTI_TILE_ARCH = 3961,
    TOK_FS_GMM_RESOURCE_INFO_WIN_STRUCT__GMM_RESOURCE_INFO_COMMON = 3962,
    TOK_FBD_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4430__SIZE = 3969,
    TOK_FBD_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4430__CHECK_SUM = 3970,
    TOK_FE_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4430__ESCAPE_CODE = 3971,
    TOK_FBD_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4430__UL_RESERVED = 3972,
    TOK_FBD_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4963__UL_RESERVED1 = 3973,
    TOK_FBW_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4963__US_ESCAPE_VERSION = 3974,
    TOK_FBW_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4963__US_FILE_VERSION = 3975,
    TOK_FE_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4963__UL_MAJOR_ESCAPE_CODE = 3976,
    TOK_FBD_GFX_ESCAPE_HEADER__ANONYMOUS4410__ANONYMOUS4963__UI_MINOR_ESCAPE_CODE = 3977,
    TOK_FE_GTDIBASE_IN_STRUCT__FUNCTION = 3978,
    TOK_FE_GTDIGET_GPU_CPU_TIMESTAMPS_OUT_STRUCT__RET_CODE = 3979,
    TOK_FBQ_GTDIGET_GPU_CPU_TIMESTAMPS_OUT_STRUCT__GPU_PERF_TICKS = 3980,
    TOK_FBQ_GTDIGET_GPU_CPU_TIMESTAMPS_OUT_STRUCT__CPU_PERF_TICKS = 3981,
    TOK_FBQ_GTDIGET_GPU_CPU_TIMESTAMPS_OUT_STRUCT__GPU_PERF_FREQ = 3982,
    TOK_FBQ_GTDIGET_GPU_CPU_TIMESTAMPS_OUT_STRUCT__CPU_PERF_FREQ = 3983,
    TOK_FXS_TIME_STAMP_DATA_HEADER__ANONYMOUS2466__M_IN = 3984,
    TOK_FS_TIME_STAMP_DATA_HEADER__ANONYMOUS2466__M_OUT = 3985,
    TOK_FS_TIME_STAMP_DATA_HEADER__M_HEADER = 3986,
    TOK_FS_TIME_STAMP_DATA_HEADER__M_DATA = 3987,
    TOK_FS_GMM_TEXTURE_INFO_REC____PLATFORM = 3988, // !(_DEBUG || _RELEASE_INTERNAL)

    //-------------------
};
