/* valaccodestruct.c generated by valac, the Vala compiler
 * generated from valaccodestruct.vala, do not modify */

/* valaccodestruct.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccode.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeStructPrivate {
	gchar* _name;
	ValaList* declarations;
};

static gint ValaCCodeStruct_private_offset;
static gpointer vala_ccode_struct_parent_class = NULL;

static void vala_ccode_struct_real_write (ValaCCodeNode* base,
                                   ValaCCodeWriter* writer);
static void vala_ccode_struct_finalize (ValaCCodeNode * obj);
static GType vala_ccode_struct_get_type_once (void);

static inline gpointer
vala_ccode_struct_get_instance_private (ValaCCodeStruct* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeStruct_private_offset);
}

const gchar*
vala_ccode_struct_get_name (ValaCCodeStruct* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
vala_ccode_struct_set_name (ValaCCodeStruct* self,
                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

gboolean
vala_ccode_struct_get_is_empty (ValaCCodeStruct* self)
{
	gboolean result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->declarations;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}

ValaCCodeStruct*
vala_ccode_struct_construct (GType object_type,
                             const gchar* name)
{
	ValaCCodeStruct* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaCCodeStruct*) vala_ccode_node_construct (object_type);
	vala_ccode_struct_set_name (self, name);
	return self;
}

ValaCCodeStruct*
vala_ccode_struct_new (const gchar* name)
{
	return vala_ccode_struct_construct (VALA_TYPE_CCODE_STRUCT, name);
}

/**
 * Adds the specified declaration as member to this struct.
 *
 * @param decl a variable declaration
 */
void
vala_ccode_struct_add_declaration (ValaCCodeStruct* self,
                                   ValaCCodeDeclaration* decl)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (decl != NULL);
	_tmp0_ = self->priv->declarations;
	vala_collection_add ((ValaCollection*) _tmp0_, decl);
}

/**
 * Adds a variable with the specified type and name to this struct.
 *
 * @param type_name field type
 * @param name      member name
 */
void
vala_ccode_struct_add_field (ValaCCodeStruct* self,
                             const gchar* type_name,
                             const gchar* name,
                             ValaCCodeModifiers modifiers,
                             ValaCCodeDeclaratorSuffix* declarator_suffix)
{
	ValaCCodeDeclaration* decl = NULL;
	ValaCCodeDeclaration* _tmp0_;
	ValaCCodeVariableDeclarator* _tmp1_;
	ValaCCodeVariableDeclarator* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_name != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = vala_ccode_declaration_new (type_name);
	decl = _tmp0_;
	_tmp1_ = vala_ccode_variable_declarator_new (name, NULL, declarator_suffix);
	_tmp2_ = _tmp1_;
	vala_ccode_declaration_add_declarator (decl, (ValaCCodeDeclarator*) _tmp2_);
	_vala_ccode_node_unref0 (_tmp2_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) decl, modifiers);
	vala_ccode_struct_add_declaration (self, decl);
	_vala_ccode_node_unref0 (decl);
}

static void
vala_ccode_struct_real_write (ValaCCodeNode* base,
                              ValaCCodeWriter* writer)
{
	ValaCCodeStruct * self;
	const gchar* _tmp0_;
	ValaCCodeModifiers _tmp10_;
	ValaCCodeModifiers _tmp11_;
	self = (ValaCCodeStruct*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "struct ");
	_tmp0_ = self->priv->_name;
	vala_ccode_writer_write_string (writer, _tmp0_);
	vala_ccode_writer_write_begin_block (writer);
	{
		ValaList* _decl_list = NULL;
		ValaList* _tmp1_;
		gint _decl_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _decl_index = 0;
		_tmp1_ = self->priv->declarations;
		_decl_list = _tmp1_;
		_tmp2_ = _decl_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_decl_size = _tmp4_;
		_decl_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaCCodeDeclaration* decl = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaCCodeDeclaration* _tmp9_;
			_decl_index = _decl_index + 1;
			_tmp5_ = _decl_index;
			_tmp6_ = _decl_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _decl_list;
			_tmp8_ = vala_list_get (_tmp7_, _decl_index);
			decl = (ValaCCodeDeclaration*) _tmp8_;
			_tmp9_ = decl;
			vala_ccode_node_write_declaration ((ValaCCodeNode*) _tmp9_, writer);
			_vala_ccode_node_unref0 (decl);
		}
	}
	vala_ccode_writer_write_end_block (writer);
	_tmp10_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) self);
	_tmp11_ = _tmp10_;
	if ((_tmp11_ & VALA_CCODE_MODIFIERS_DEPRECATED) == VALA_CCODE_MODIFIERS_DEPRECATED) {
		const gchar* _tmp12_;
		_tmp12_ = vala_GNUC_DEPRECATED;
		vala_ccode_writer_write_string (writer, _tmp12_);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_write_newline (writer);
}

static void
vala_ccode_struct_class_init (ValaCCodeStructClass * klass,
                              gpointer klass_data)
{
	vala_ccode_struct_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_struct_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeStruct_private_offset);
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_struct_real_write;
}

static void
vala_ccode_struct_instance_init (ValaCCodeStruct * self,
                                 gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_ccode_struct_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CCODE_DECLARATION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp0_);
	self->priv->declarations = (ValaList*) _tmp1_;
}

static void
vala_ccode_struct_finalize (ValaCCodeNode * obj)
{
	ValaCCodeStruct * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_STRUCT, ValaCCodeStruct);
	_g_free0 (self->priv->_name);
	_vala_iterable_unref0 (self->priv->declarations);
	VALA_CCODE_NODE_CLASS (vala_ccode_struct_parent_class)->finalize (obj);
}

/**
 * Represents a struct declaration in the C code.
 */
static GType
vala_ccode_struct_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStruct), 0, (GInstanceInitFunc) vala_ccode_struct_instance_init, NULL };
	GType vala_ccode_struct_type_id;
	vala_ccode_struct_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeStruct", &g_define_type_info, 0);
	ValaCCodeStruct_private_offset = g_type_add_instance_private (vala_ccode_struct_type_id, sizeof (ValaCCodeStructPrivate));
	return vala_ccode_struct_type_id;
}

GType
vala_ccode_struct_get_type (void)
{
	static volatile gsize vala_ccode_struct_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_struct_type_id__volatile)) {
		GType vala_ccode_struct_type_id;
		vala_ccode_struct_type_id = vala_ccode_struct_get_type_once ();
		g_once_init_leave (&vala_ccode_struct_type_id__volatile, vala_ccode_struct_type_id);
	}
	return vala_ccode_struct_type_id__volatile;
}

