/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.ec2.model;

import java.io.Serializable;

/**
 * <p>
 * Describes the monitoring for the instance.
 * </p>
 */
public class Monitoring implements Serializable, Cloneable {

    /**
     * <p>
     * Indicates whether monitoring is enabled for the instance.
     * </p>
     */
    private String state;

    /**
     * <p>
     * Indicates whether monitoring is enabled for the instance.
     * </p>
     * 
     * @param state
     *        Indicates whether monitoring is enabled for the instance.
     * @see MonitoringState
     */

    public void setState(String state) {
        this.state = state;
    }

    /**
     * <p>
     * Indicates whether monitoring is enabled for the instance.
     * </p>
     * 
     * @return Indicates whether monitoring is enabled for the instance.
     * @see MonitoringState
     */

    public String getState() {
        return this.state;
    }

    /**
     * <p>
     * Indicates whether monitoring is enabled for the instance.
     * </p>
     * 
     * @param state
     *        Indicates whether monitoring is enabled for the instance.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see MonitoringState
     */

    public Monitoring withState(String state) {
        setState(state);
        return this;
    }

    /**
     * <p>
     * Indicates whether monitoring is enabled for the instance.
     * </p>
     * 
     * @param state
     *        Indicates whether monitoring is enabled for the instance.
     * @see MonitoringState
     */

    public void setState(MonitoringState state) {
        this.state = state.toString();
    }

    /**
     * <p>
     * Indicates whether monitoring is enabled for the instance.
     * </p>
     * 
     * @param state
     *        Indicates whether monitoring is enabled for the instance.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     * @see MonitoringState
     */

    public Monitoring withState(MonitoringState state) {
        setState(state);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getState() != null)
            sb.append("State: " + getState());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Monitoring == false)
            return false;
        Monitoring other = (Monitoring) obj;
        if (other.getState() == null ^ this.getState() == null)
            return false;
        if (other.getState() != null
                && other.getState().equals(this.getState()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getState() == null) ? 0 : getState().hashCode());
        return hashCode;
    }

    @Override
    public Monitoring clone() {
        try {
            return (Monitoring) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}
