; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FAST
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FAST
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,1,1]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movd %xmm3, (%rsi)
; SSE-NEXT:    movd %xmm2, (%rdx)
; SSE-NEXT:    movd %xmm4, (%rcx)
; SSE-NEXT:    movd %xmm5, (%r8)
; SSE-NEXT:    movd %xmm7, (%r9)
; SSE-NEXT:    movd %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: vf2:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,3,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm2[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[3,1,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,3,2,3,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vmovd %xmm3, (%rsi)
; AVX1-NEXT:    vmovd %xmm2, (%rdx)
; AVX1-NEXT:    vmovd %xmm4, (%rcx)
; AVX1-NEXT:    vmovd %xmm5, (%r8)
; AVX1-NEXT:    vmovd %xmm6, (%r9)
; AVX1-NEXT:    vmovd %xmm0, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: vf2:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,3,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm2[0,2,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastw 4(%rdi), %xmm4
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[3,1,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,3,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpbroadcastw 20(%rdi), %xmm6
; AVX2-SLOW-NEXT:    vpbroadcastw 8(%rdi), %xmm7
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-SLOW-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-SLOW-NEXT:    vmovd %xmm3, (%rsi)
; AVX2-SLOW-NEXT:    vmovd %xmm2, (%rdx)
; AVX2-SLOW-NEXT:    vmovd %xmm4, (%rcx)
; AVX2-SLOW-NEXT:    vmovd %xmm5, (%r8)
; AVX2-SLOW-NEXT:    vmovd %xmm6, (%r9)
; AVX2-SLOW-NEXT:    vmovd %xmm0, (%rax)
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: vf2:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,3,2,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm2[0,2,2,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpbroadcastw 4(%rdi), %xmm4
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[12,13,6,7,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpbroadcastw 20(%rdi), %xmm6
; AVX2-FAST-NEXT:    vpbroadcastw 8(%rdi), %xmm7
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-FAST-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-FAST-NEXT:    vmovd %xmm3, (%rsi)
; AVX2-FAST-NEXT:    vmovd %xmm2, (%rdx)
; AVX2-FAST-NEXT:    vmovd %xmm4, (%rcx)
; AVX2-FAST-NEXT:    vmovd %xmm5, (%r8)
; AVX2-FAST-NEXT:    vmovd %xmm6, (%r9)
; AVX2-FAST-NEXT:    vmovd %xmm0, (%rax)
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,3,2,3]
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm2[0,2,2,3,4,5,6,7]
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[1,3,2,3,4,5,6,7]
; AVX512-NEXT:    vpbroadcastw 4(%rdi), %xmm4
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[3,1,2,3]
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm5[0,3,2,3,4,5,6,7]
; AVX512-NEXT:    vpbroadcastw 20(%rdi), %xmm6
; AVX512-NEXT:    vpbroadcastw 8(%rdi), %xmm7
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX512-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX512-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX512-NEXT:    vmovd %xmm3, (%rsi)
; AVX512-NEXT:    vmovd %xmm2, (%rdx)
; AVX512-NEXT:    vmovd %xmm4, (%rcx)
; AVX512-NEXT:    vmovd %xmm5, (%r8)
; AVX512-NEXT:    vmovd %xmm6, (%r9)
; AVX512-NEXT:    vmovd %xmm0, (%rax)
; AVX512-NEXT:    retq
  %wide.vec = load <12 x i16>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <12 x i16> %wide.vec, <12 x i16> poison, <2 x i32> <i32 0, i32 6>
  %strided.vec1 = shufflevector <12 x i16> %wide.vec, <12 x i16> poison, <2 x i32> <i32 1, i32 7>
  %strided.vec2 = shufflevector <12 x i16> %wide.vec, <12 x i16> poison, <2 x i32> <i32 2, i32 8>
  %strided.vec3 = shufflevector <12 x i16> %wide.vec, <12 x i16> poison, <2 x i32> <i32 3, i32 9>
  %strided.vec4 = shufflevector <12 x i16> %wide.vec, <12 x i16> poison, <2 x i32> <i32 4, i32 10>
  %strided.vec5 = shufflevector <12 x i16> %wide.vec, <12 x i16> poison, <2 x i32> <i32 5, i32 11>

  store <2 x i16> %strided.vec0, ptr %out.vec0, align 32
  store <2 x i16> %strided.vec1, ptr %out.vec1, align 32
  store <2 x i16> %strided.vec2, ptr %out.vec2, align 32
  store <2 x i16> %strided.vec3, ptr %out.vec3, align 32
  store <2 x i16> %strided.vec4, ptr %out.vec4, align 32
  store <2 x i16> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    movdqa 32(%rdi), %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm4[0,1,2,3,4,6,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm7
; SSE-NEXT:    psrld $16, %xmm7
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm7[2],xmm4[3],xmm7[3]
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm5[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,3,2,3]
; SSE-NEXT:    psrldq {{.*#+}} xmm5 = xmm5[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,0],xmm1[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm1[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm6, %xmm7
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm8, %xmm6
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm9[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm9[1,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movq %xmm2, (%rsi)
; SSE-NEXT:    movq %xmm4, (%rdx)
; SSE-NEXT:    movq %xmm7, (%rcx)
; SSE-NEXT:    movq %xmm6, (%r8)
; SSE-NEXT:    movq %xmm5, (%r9)
; SSE-NEXT:    movq %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: vf4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm3[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm8 = xmm4[0,2,2,3]
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm5
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2],xmm2[3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm2[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm6 = xmm1[0,1],xmm0[2,3],xmm1[4,5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = xmm6[4,5,0,1,12,13,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0,1,2],xmm5[3],xmm7[4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[2,2,3,3]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[6,7,2,3,14,15,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm7[3],xmm6[4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm7[0],xmm4[1],xmm7[1],xmm4[2],xmm7[2],xmm4[3],xmm7[3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm2[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm4[0],xmm7[0],xmm4[1],xmm7[1]
; AVX1-NEXT:    vpsrlq $48, %xmm1, %xmm1
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm2[1,3,2,3,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-NEXT:    vmovq %xmm8, (%rsi)
; AVX1-NEXT:    vmovq %xmm3, (%rdx)
; AVX1-NEXT:    vmovq %xmm5, (%rcx)
; AVX1-NEXT:    vmovq %xmm6, (%r8)
; AVX1-NEXT:    vmovq %xmm4, (%r9)
; AVX1-NEXT:    vmovq %xmm0, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: vf4:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0],xmm2[1],xmm0[2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],xmm1[2],xmm3[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,12,13,8,9,4,5,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpsrld $16, %xmm1, %xmm4
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[0,1,0,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,7,6,7]
; AVX2-SLOW-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2],xmm2[3],xmm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm5 = xmm0[0,1],xmm2[2,3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm5 = xmm1[0],xmm5[1,2],xmm1[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[6,7,2,3,14,15,10,11,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1],xmm0[2],xmm2[3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[8,9,4,5,0,1,12,13,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[10,11,6,7,2,3,14,15,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vmovq %xmm3, (%rsi)
; AVX2-SLOW-NEXT:    vmovq %xmm4, (%rdx)
; AVX2-SLOW-NEXT:    vmovq %xmm6, (%rcx)
; AVX2-SLOW-NEXT:    vmovq %xmm5, (%r8)
; AVX2-SLOW-NEXT:    vmovq %xmm1, (%r9)
; AVX2-SLOW-NEXT:    vmovq %xmm0, (%rax)
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: vf4:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0],xmm2[1],xmm0[2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],xmm1[2],xmm3[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,1,12,13,8,9,4,5,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpsrld $16, %xmm1, %xmm4
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[u,u,u,u,u,u,u,u,2,3,14,15,12,13,14,15]
; AVX2-FAST-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2],xmm2[3],xmm4[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm5 = xmm0[0,1],xmm2[2,3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm5 = xmm1[0],xmm5[1,2],xmm1[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[4,5,0,1,12,13,8,9,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[6,7,2,3,14,15,10,11,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1],xmm0[2],xmm2[3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[8,9,4,5,0,1,12,13,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[10,11,6,7,2,3,14,15,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vmovq %xmm3, (%rsi)
; AVX2-FAST-NEXT:    vmovq %xmm4, (%rdx)
; AVX2-FAST-NEXT:    vmovq %xmm6, (%rcx)
; AVX2-FAST-NEXT:    vmovq %xmm5, (%r8)
; AVX2-FAST-NEXT:    vmovq %xmm1, (%r9)
; AVX2-FAST-NEXT:    vmovq %xmm0, (%rax)
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm2 = <0,6,12,18,u,u,u,u>
; AVX512-NEXT:    vpermi2w %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm3 = <1,7,13,19,u,u,u,u>
; AVX512-NEXT:    vpermi2w %ymm1, %ymm0, %ymm3
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm4 = <2,8,14,20,u,u,u,u>
; AVX512-NEXT:    vpermi2w %ymm1, %ymm0, %ymm4
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm5 = <3,9,15,21,u,u,u,u>
; AVX512-NEXT:    vpermi2w %ymm1, %ymm0, %ymm5
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm6 = <4,10,16,22,u,u,u,u>
; AVX512-NEXT:    vpermi2w %ymm1, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm7 = <5,11,17,23,u,u,u,u>
; AVX512-NEXT:    vpermi2w %ymm1, %ymm0, %ymm7
; AVX512-NEXT:    vmovq %xmm2, (%rsi)
; AVX512-NEXT:    vmovq %xmm3, (%rdx)
; AVX512-NEXT:    vmovq %xmm4, (%rcx)
; AVX512-NEXT:    vmovq %xmm5, (%r8)
; AVX512-NEXT:    vmovq %xmm6, (%r9)
; AVX512-NEXT:    vmovq %xmm7, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <24 x i16>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <24 x i16> %wide.vec, <24 x i16> poison, <4 x i32> <i32 0, i32 6, i32 12, i32 18>
  %strided.vec1 = shufflevector <24 x i16> %wide.vec, <24 x i16> poison, <4 x i32> <i32 1, i32 7, i32 13, i32 19>
  %strided.vec2 = shufflevector <24 x i16> %wide.vec, <24 x i16> poison, <4 x i32> <i32 2, i32 8, i32 14, i32 20>
  %strided.vec3 = shufflevector <24 x i16> %wide.vec, <24 x i16> poison, <4 x i32> <i32 3, i32 9, i32 15, i32 21>
  %strided.vec4 = shufflevector <24 x i16> %wide.vec, <24 x i16> poison, <4 x i32> <i32 4, i32 10, i32 16, i32 22>
  %strided.vec5 = shufflevector <24 x i16> %wide.vec, <24 x i16> poison, <4 x i32> <i32 5, i32 11, i32 17, i32 23>

  store <4 x i16> %strided.vec0, ptr %out.vec0, align 32
  store <4 x i16> %strided.vec1, ptr %out.vec1, align 32
  store <4 x i16> %strided.vec2, ptr %out.vec2, align 32
  store <4 x i16> %strided.vec3, ptr %out.vec3, align 32
  store <4 x i16> %strided.vec4, ptr %out.vec4, align 32
  store <4 x i16> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa 64(%rdi), %xmm6
; SSE-NEXT:    movdqa 80(%rdi), %xmm10
; SSE-NEXT:    movdqa (%rdi), %xmm13
; SSE-NEXT:    movdqa 16(%rdi), %xmm14
; SSE-NEXT:    movdqa 32(%rdi), %xmm9
; SSE-NEXT:    movdqa 48(%rdi), %xmm11
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm9[0,1,1,2,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm13[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm8[0,1,2,3,4,6,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm12 = xmm12[2],xmm14[2],xmm12[3],xmm14[3]
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    por %xmm4, %xmm12
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm10[0],xmm7[1],xmm10[1],xmm7[2],xmm10[2],xmm7[3],xmm10[3]
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm6[3,0]
; SSE-NEXT:    movaps %xmm6, %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,0],xmm10[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm10[2,3]
; SSE-NEXT:    pslld $16, %xmm10
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1],xmm0[2],xmm10[2],xmm0[3],xmm10[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm11[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm2[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm5[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm0[2,0]
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm8[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm5 = xmm5[2],xmm0[2],xmm5[3],xmm0[3]
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    pandn %xmm9, %xmm1
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[0,1,1,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[3,1],xmm0[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm7[2,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm9[2,2,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm9[0,1,0,3]
; SSE-NEXT:    psrldq {{.*#+}} xmm9 = xmm9[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm9 = xmm9[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    pandn %xmm9, %xmm7
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,0],xmm14[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm14[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm4[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    pand %xmm7, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm3[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm15[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm3[0,1,2,3,4,6,5,4]
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm11, %xmm5
; SSE-NEXT:    psrlq $48, %xmm5
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm15[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,2]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm14[1,1,1,1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm13[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,4,5,4,6]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; SSE-NEXT:    andps %xmm7, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm6[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    psrlq $48, %xmm14
; SSE-NEXT:    psrldq {{.*#+}} xmm13 = xmm13[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm13 = xmm13[0],xmm14[0],xmm13[1],xmm14[1],xmm13[2],xmm14[2],xmm13[3],xmm14[3]
; SSE-NEXT:    psrld $16, %xmm11
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,4,5,5,7]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; SSE-NEXT:    movss {{.*#+}} xmm0 = xmm13[0],xmm0[1,2,3]
; SSE-NEXT:    andps %xmm7, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm6[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,5,7]
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    por %xmm0, %xmm7
; SSE-NEXT:    movaps %xmm12, (%rsi)
; SSE-NEXT:    movaps %xmm1, (%rdx)
; SSE-NEXT:    movdqa %xmm3, (%rcx)
; SSE-NEXT:    movdqa %xmm4, (%r8)
; SSE-NEXT:    movdqa %xmm5, (%r9)
; SSE-NEXT:    movdqa %xmm7, (%rax)
; SSE-NEXT:    retq
;
; AVX1-LABEL: vf8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovdqa (%rdi), %xmm8
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm4
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm1
; AVX1-NEXT:    vpsrlq $16, %xmm4, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm1[0,3,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm7[0,1,0,2,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm8[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm0[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm9 = xmm5[0,1,2],xmm3[3,4,5],xmm5[6,7]
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm5
; AVX1-NEXT:    vpslld $16, %xmm5, %xmm10
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm6
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm6[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm10[0],xmm3[1],xmm10[1],xmm3[2],xmm10[2],xmm3[3],xmm10[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,5],xmm3[6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm4[1,1,1,1]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,1,1,3,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm7[0],xmm3[0],xmm7[1],xmm3[1]
; AVX1-NEXT:    vpsrld $16, %xmm2, %xmm7
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3,4,5],xmm0[6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm6[2,2,3,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm5[0],xmm3[1],xmm5[1],xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm10 = xmm0[0,1,2,3,4,5],xmm3[6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm4[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0,1],xmm8[2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm7 = xmm3[4,5,0,1,12,13,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm11 = xmm7[0,1,2],xmm0[3,4],xmm7[5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm7 = xmm6[0,1,2,3],xmm5[4,5],xmm6[6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm7[u,u,u,u,u,u,u,u,u,u,0,1,12,13,8,9]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2,3,4],xmm0[5,6,7]
; AVX1-NEXT:    vpsrlq $48, %xmm1, %xmm12
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm4[2,2,3,3]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm12[0]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[6,7,2,3,14,15,u,u,u,u,u,u,u,u,u,u]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2],xmm0[3,4],xmm3[5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[u,u,u,u,u,u,u,u,u,u,2,3,14,15,10,11]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4],xmm3[5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[1,1,1,1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm8[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm4[0,1,2,3,4,5,4,6]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm7 = xmm7[1],xmm1[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm7[2,3,4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,3],xmm5[4,5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[u,u,u,u,u,u,u,u,u,u,4,5,0,1,12,13]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4],xmm6[5,6,7]
; AVX1-NEXT:    vpsrlq $48, %xmm2, %xmm2
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm6 = xmm8[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,5,7]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm4[1],xmm1[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3,4,5,6,7]
; AVX1-NEXT:    vpshufb {{.*#+}} xmm2 = xmm5[u,u,u,u,u,u,u,u,u,u,6,7,2,3,14,15]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm2[5,6,7]
; AVX1-NEXT:    vmovdqa %xmm9, (%rsi)
; AVX1-NEXT:    vmovdqa %xmm10, (%rdx)
; AVX1-NEXT:    vmovdqa %xmm11, (%rcx)
; AVX1-NEXT:    vmovdqa %xmm0, (%r8)
; AVX1-NEXT:    vmovdqa %xmm3, (%r9)
; AVX1-NEXT:    vmovdqa %xmm1, (%rax)
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa 80(%rdi), %xmm0
; AVX2-SLOW-NEXT:    vpslld $16, %xmm0, %xmm2
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX2-SLOW-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm8[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm3[0],ymm4[1],ymm3[2,3],ymm4[4],ymm3[5,6],ymm4[7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[0,1,12,13,u,u,4,5,u,u,u,u,12,13,14,15]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm7[0,2,0,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm6[0,1],xmm1[2],xmm6[3],xmm1[4,5],xmm6[6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm9 = xmm1[0,1,2],xmm2[3]
; AVX2-SLOW-NEXT:    vpbroadcastw 74(%rdi), %xmm1
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm7[u,u,u,u,10,11,u,u,2,3,14,15,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,3,14,15,u,u,6,7,u,u,u,u,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm6[2],xmm5[3],xmm6[4,5],xmm5[6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm10 = xmm5[0,1,2],xmm1[3]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm1[2,1,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm6[2,1,2,0,4,5,6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,3,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm1[0,0,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,3,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm7[0],xmm2[1,2],xmm7[3],xmm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm7 = xmm8[0,1],xmm0[2],xmm8[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm7[u,u,u,u,u,u,u,u,u,u,0,1,12,13,8,9]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4],xmm5[5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm6[3,1,2,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm5[0],xmm1[1,2],xmm5[3],xmm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm7[u,u,u,u,u,u,u,u,u,u,2,3,14,15,10,11]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm5[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1],ymm3[2],ymm4[3,4],ymm3[5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[2,2,2,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[8,9,u,u,0,1,12,13,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1],xmm6[2,3],xmm5[4],xmm6[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm8[1],xmm0[2,3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[u,u,u,u,u,u,u,u,u,u,4,5,0,1,12,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4],xmm6[5,6,7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[10,11,u,u,2,3,14,15,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[1,1,2,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm4[1],xmm3[2,3],xmm4[4],xmm3[5,6,7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,6,7,2,3,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3,4],xmm0[5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %xmm9, (%rsi)
; AVX2-SLOW-NEXT:    vmovdqa %xmm10, (%rdx)
; AVX2-SLOW-NEXT:    vmovdqa %xmm2, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %xmm1, (%r8)
; AVX2-SLOW-NEXT:    vmovdqa %xmm5, (%r9)
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: vf8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovdqa 80(%rdi), %xmm0
; AVX2-FAST-NEXT:    vpslld $16, %xmm0, %xmm3
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %xmm10
; AVX2-FAST-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm10[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm8 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm2[0],ymm4[1],ymm2[2,3],ymm4[4],ymm2[5,6],ymm4[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[0,1,12,13,u,u,4,5,u,u,u,u,12,13,14,15]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[2,1,0,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[u,u,u,u,0,1,u,u,8,9,12,13,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm6[0,1],xmm3[2],xmm6[3],xmm3[4,5],xmm6[6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm8 = xmm3[0,1,2],xmm8[3]
; AVX2-FAST-NEXT:    vpbroadcastw 74(%rdi), %xmm6
; AVX2-FAST-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[2,3,14,15,u,u,6,7,u,u,u,u,12,13,14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,2,3,u,u,10,11,14,15,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm7[2],xmm5[3],xmm7[4,5],xmm5[6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm9 = xmm5[0,1,2],xmm6[3]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[2,1,2,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm7[2,1,2,0,4,5,6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,3,2,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm6[u,u,0,1,4,5,u,u,12,13,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm5[1,2],xmm3[3],xmm5[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm5 = xmm10[0,1],xmm0[2],xmm10[3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,u,u,u,u,u,u,0,1,12,13,8,9]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0,1,2,3,4],xmm1[5,6,7]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm7[3,1,2,1,4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,2,3,6,7,u,u,14,15,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm6[1,2],xmm3[3],xmm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[u,u,u,u,u,u,u,u,u,u,2,3,14,15,10,11]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4],xmm5[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2],ymm4[3,4],ymm2[5],ymm4[6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[2,2,2,2,4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm2[8,9,u,u,0,1,12,13,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1],xmm6[2,3],xmm5[4],xmm6[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm10[1],xmm0[2,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[u,u,u,u,u,u,u,u,u,u,4,5,0,1,12,13]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4],xmm6[5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[u,u,6,7,u,u,u,u,10,11,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[10,11,u,u,2,3,14,15,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm4[1],xmm2[2,3],xmm4[4],xmm2[5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,6,7,2,3,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0,1,2,3,4],xmm0[5,6,7]
; AVX2-FAST-NEXT:    vmovdqa %xmm8, (%rsi)
; AVX2-FAST-NEXT:    vmovdqa %xmm9, (%rdx)
; AVX2-FAST-NEXT:    vmovdqa %xmm1, (%rcx)
; AVX2-FAST-NEXT:    vmovdqa %xmm3, (%r8)
; AVX2-FAST-NEXT:    vmovdqa %xmm5, (%r9)
; AVX2-FAST-NEXT:    vmovdqa %xmm0, (%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = <3,9,15,u,u,u,u,u>
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm1
; AVX512-NEXT:    vpermw %zmm1, %zmm0, %zmm8
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = <2,8,14,u,u,u,u,u>
; AVX512-NEXT:    vpermw %zmm1, %zmm0, %zmm9
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = <1,7,13,u,u,u,u,u>
; AVX512-NEXT:    vpermw %zmm1, %zmm0, %zmm6
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm0 = <0,6,12,u,u,u,u,u>
; AVX512-NEXT:    vpermw %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa (%rdi), %xmm7
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX512-NEXT:    vpextrw $2, %xmm1, %eax
; AVX512-NEXT:    vpinsrw $3, %eax, %xmm2, %xmm2
; AVX512-NEXT:    vmovd %xmm0, %eax
; AVX512-NEXT:    vpinsrw $4, %eax, %xmm2, %xmm2
; AVX512-NEXT:    vpextrw $6, %xmm0, %eax
; AVX512-NEXT:    vpinsrw $5, %eax, %xmm2, %xmm2
; AVX512-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512-NEXT:    vpextrw $4, %xmm3, %eax
; AVX512-NEXT:    vpinsrw $6, %eax, %xmm2, %xmm5
; AVX512-NEXT:    vmovdqa 80(%rdi), %xmm2
; AVX512-NEXT:    vpextrw $2, %xmm2, %eax
; AVX512-NEXT:    vpinsrw $7, %eax, %xmm5, %xmm10
; AVX512-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm1[3],xmm6[4,5,6,7]
; AVX512-NEXT:    vpextrw $1, %xmm0, %eax
; AVX512-NEXT:    vpinsrw $4, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrw $7, %xmm0, %eax
; AVX512-NEXT:    vpinsrw $5, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrw $5, %xmm3, %eax
; AVX512-NEXT:    vpinsrw $6, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrw $3, %xmm2, %eax
; AVX512-NEXT:    vpinsrw $7, %eax, %xmm6, %xmm11
; AVX512-NEXT:    vpextrw $4, %xmm1, %eax
; AVX512-NEXT:    vpinsrw $3, %eax, %xmm9, %xmm5
; AVX512-NEXT:    vpextrw $2, %xmm0, %eax
; AVX512-NEXT:    vpinsrw $4, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vmovd %xmm3, %eax
; AVX512-NEXT:    vpinsrw $5, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,5],xmm3[6],xmm5[7]
; AVX512-NEXT:    vpextrw $4, %xmm2, %eax
; AVX512-NEXT:    vpinsrw $7, %eax, %xmm5, %xmm9
; AVX512-NEXT:    vpextrw $5, %xmm1, %eax
; AVX512-NEXT:    vpinsrw $3, %eax, %xmm8, %xmm6
; AVX512-NEXT:    vpextrw $3, %xmm0, %eax
; AVX512-NEXT:    vpinsrw $4, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrw $1, %xmm3, %eax
; AVX512-NEXT:    vpinsrw $5, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrw $7, %xmm3, %eax
; AVX512-NEXT:    vpinsrw $6, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrw $5, %xmm2, %eax
; AVX512-NEXT:    vpinsrw $7, %eax, %xmm6, %xmm6
; AVX512-NEXT:    vpextrw $2, %xmm4, %eax
; AVX512-NEXT:    vpextrw $4, %xmm7, %edi
; AVX512-NEXT:    vmovd %edi, %xmm5
; AVX512-NEXT:    vpinsrw $1, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vmovd %xmm1, %eax
; AVX512-NEXT:    vpinsrw $2, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vpextrw $6, %xmm1, %eax
; AVX512-NEXT:    vpinsrw $3, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3],xmm0[4],xmm5[5,6,7]
; AVX512-NEXT:    vpextrw $2, %xmm3, %eax
; AVX512-NEXT:    vpinsrw $5, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vmovd %xmm2, %eax
; AVX512-NEXT:    vpinsrw $6, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vpextrw $6, %xmm2, %eax
; AVX512-NEXT:    vpinsrw $7, %eax, %xmm5, %xmm5
; AVX512-NEXT:    vpextrw $3, %xmm4, %eax
; AVX512-NEXT:    vpextrw $5, %xmm7, %edi
; AVX512-NEXT:    vmovd %edi, %xmm4
; AVX512-NEXT:    vpinsrw $1, %eax, %xmm4, %xmm4
; AVX512-NEXT:    vpextrw $1, %xmm1, %eax
; AVX512-NEXT:    vpinsrw $2, %eax, %xmm4, %xmm4
; AVX512-NEXT:    vpextrw $7, %xmm1, %eax
; AVX512-NEXT:    vpinsrw $3, %eax, %xmm4, %xmm1
; AVX512-NEXT:    vpextrw $5, %xmm0, %eax
; AVX512-NEXT:    vpinsrw $4, %eax, %xmm1, %xmm0
; AVX512-NEXT:    vpextrw $3, %xmm3, %eax
; AVX512-NEXT:    vpinsrw $5, %eax, %xmm0, %xmm0
; AVX512-NEXT:    vpextrw $1, %xmm2, %eax
; AVX512-NEXT:    vpinsrw $6, %eax, %xmm0, %xmm0
; AVX512-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6],xmm2[7]
; AVX512-NEXT:    vmovdqa %xmm10, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm11, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm9, (%rcx)
; AVX512-NEXT:    vmovdqa %xmm6, (%r8)
; AVX512-NEXT:    vmovdqa %xmm5, (%r9)
; AVX512-NEXT:    vmovdqa %xmm0, (%r10)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <48 x i16>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <48 x i16> %wide.vec, <48 x i16> poison, <8 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42>
  %strided.vec1 = shufflevector <48 x i16> %wide.vec, <48 x i16> poison, <8 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43>
  %strided.vec2 = shufflevector <48 x i16> %wide.vec, <48 x i16> poison, <8 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44>
  %strided.vec3 = shufflevector <48 x i16> %wide.vec, <48 x i16> poison, <8 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45>
  %strided.vec4 = shufflevector <48 x i16> %wide.vec, <48 x i16> poison, <8 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46>
  %strided.vec5 = shufflevector <48 x i16> %wide.vec, <48 x i16> poison, <8 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47>

  store <8 x i16> %strided.vec0, ptr %out.vec0, align 32
  store <8 x i16> %strided.vec1, ptr %out.vec1, align 32
  store <8 x i16> %strided.vec2, ptr %out.vec2, align 32
  store <8 x i16> %strided.vec3, ptr %out.vec3, align 32
  store <8 x i16> %strided.vec4, ptr %out.vec4, align 32
  store <8 x i16> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $72, %rsp
; SSE-NEXT:    movdqa 112(%rdi), %xmm4
; SSE-NEXT:    movdqa 128(%rdi), %xmm11
; SSE-NEXT:    movdqa 64(%rdi), %xmm2
; SSE-NEXT:    movdqa 80(%rdi), %xmm12
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm15
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdi), %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,2,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,1,0,3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm2[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm12[0],xmm6[1],xmm12[1],xmm6[2],xmm12[2],xmm6[3],xmm12[3]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[3,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,0],xmm12[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm12[2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslld $16, %xmm12
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm12[0],xmm3[1],xmm12[1],xmm3[2],xmm12[2],xmm3[3],xmm12[3]
; SSE-NEXT:    movdqa %xmm5, %xmm12
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm5[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,1],xmm1[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm11[0,1,1,2,4,5,6,7]
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa 96(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm7[0,1,2,3,4,6,6,7]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhdq {{.*#+}} xmm8 = xmm8[2],xmm4[2],xmm8[3],xmm4[3]
; SSE-NEXT:    pand %xmm5, %xmm8
; SSE-NEXT:    por %xmm2, %xmm8
; SSE-NEXT:    movdqa 160(%rdi), %xmm3
; SSE-NEXT:    movdqa 176(%rdi), %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm3[3,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,0],xmm2[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm2[2,3]
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    movdqa 144(%rdi), %xmm13
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm13[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm2[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1],xmm9[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm1[2,0]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    pshufhw $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = mem[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm9 = xmm9[2],xmm1[2],xmm9[3],xmm1[3]
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    pandn %xmm14, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    por %xmm1, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[0,1,1,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,1],xmm1[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm6[2,0]
; SSE-NEXT:    psrld $16, %xmm4
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm7 = xmm7[2],xmm4[2],xmm7[3],xmm4[3]
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm11, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[0,1,1,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[1,1,1,1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm0, %xmm10
; SSE-NEXT:    pandn %xmm1, %xmm10
; SSE-NEXT:    movaps (%rsp), %xmm1 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,0],xmm15[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm15[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm7[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    por %xmm10, %xmm2
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps $132, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = xmm4[0,1],mem[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm4[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm7[0,1,2,3,4,6,5,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm10, %xmm4
; SSE-NEXT:    pand %xmm7, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    movdqa %xmm11, %xmm14
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm13[1,1,1,1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm4[0]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,0],xmm2[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,0],xmm2[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm10[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    por %xmm4, %xmm6
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps $132, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[0,1],mem[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm2[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,5,4]
; SSE-NEXT:    movdqa %xmm7, %xmm5
; SSE-NEXT:    pandn %xmm4, %xmm5
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    por %xmm6, %xmm5
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    psrlq $48, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm2[2,2,3,3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm6 = xmm6[0],xmm4[0]
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pandn %xmm6, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    pshufhw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,0,2]
; SSE-NEXT:    movdqa %xmm7, %xmm11
; SSE-NEXT:    pandn %xmm4, %xmm11
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    por %xmm1, %xmm11
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    psrlq $48, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm14[2,2,3,3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm1[0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pshufhw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,2]
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm15[1,1,1,1]
; SSE-NEXT:    movdqa (%rsp), %xmm10 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm14 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm14[0,1,2,3,4,5,4,6]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm12[1]
; SSE-NEXT:    movss {{.*#+}} xmm6 = xmm1[0],xmm6[1,2,3]
; SSE-NEXT:    pshuflw $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    andps %xmm7, %xmm6
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = mem[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    pshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,0,3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm0[0,1,2,3,4,5,4,6]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm13[1]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm6[0],xmm1[1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm3[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    andps %xmm7, %xmm1
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    psrlq $48, %xmm15
; SSE-NEXT:    psrldq {{.*#+}} xmm10 = xmm10[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm15[0],xmm10[1],xmm15[1],xmm10[2],xmm15[2],xmm10[3],xmm15[3]
; SSE-NEXT:    psrld $16, %xmm12
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm14[0,1,2,3,4,5,5,7]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm12[1]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm10[0],xmm1[1,2,3]
; SSE-NEXT:    pshuflw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = mem[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm6[0,1,2,3,4,4,5,7]
; SSE-NEXT:    movdqa %xmm7, %xmm14
; SSE-NEXT:    pandn %xmm12, %xmm14
; SSE-NEXT:    andps %xmm7, %xmm1
; SSE-NEXT:    por %xmm1, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    psrld $16, %xmm13
; SSE-NEXT:    pshufhw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,2,3,4,5,5,7]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm13[1]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm10[0],xmm1[1,2,3]
; SSE-NEXT:    andps %xmm7, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,4,5,7]
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movaps %xmm8, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rdx)
; SSE-NEXT:    movaps %xmm9, (%rdx)
; SSE-NEXT:    movdqa %xmm5, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    movdqa %xmm4, 16(%r8)
; SSE-NEXT:    movdqa %xmm11, (%r8)
; SSE-NEXT:    movdqa %xmm0, 16(%r9)
; SSE-NEXT:    movdqa %xmm2, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm7, 16(%rax)
; SSE-NEXT:    movdqa %xmm14, (%rax)
; SSE-NEXT:    addq $72, %rsp
; SSE-NEXT:    retq
;
; AVX1-LABEL: vf16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    subq $184, %rsp
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm2
; AVX1-NEXT:    vpslld $16, %xmm2, %xmm1
; AVX1-NEXT:    vmovdqa %xmm2, %xmm10
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm8[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vmovdqa (%rdi), %xmm11
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm6
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpsrlq $16, %xmm3, %xmm0
; AVX1-NEXT:    vmovdqa %xmm3, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm2[0,3,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm15[0,1,0,2,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm11[0,1,0,3]
; AVX1-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm3[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1,2],xmm2[3,4,5],xmm5[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2],ymm1[3,4,5],ymm2[6,7]
; AVX1-NEXT:    vmovdqa 176(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpslld $16, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqa 160(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm0[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm14 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX1-NEXT:    vmovdqa 128(%rdi), %xmm1
; AVX1-NEXT:    vpsrlq $16, %xmm1, %xmm0
; AVX1-NEXT:    vmovdqa %xmm1, %xmm9
; AVX1-NEXT:    vmovdqa 144(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,3,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm12 = xmm1[0,1,0,2,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm12[0],xmm0[0],xmm12[1],xmm0[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5],xmm14[6,7]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0]
; AVX1-NEXT:    vandps %ymm2, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    vmovaps %ymm2, %ymm14
; AVX1-NEXT:    vorps %ymm0, %ymm4, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-NEXT:    vpsrld $16, %xmm5, %xmm4
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; AVX1-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm8[2,2,3,3]
; AVX1-NEXT:    vmovdqa %xmm10, %xmm13
; AVX1-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm10[0],xmm4[1],xmm10[1],xmm4[2],xmm10[2],xmm4[3],xmm10[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm0
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm15[0,1,1,3,4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm7, %xmm2
; AVX1-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[1,1,1,1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm4 = xmm4[0],xmm7[0],xmm4[1],xmm7[1]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vmovdqa %xmm6, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpsrld $16, %xmm6, %xmm7
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm3[2],xmm7[2],xmm3[3],xmm7[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2],xmm4[3,4,5],xmm3[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2],ymm0[3,4,5],ymm3[6,7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,1,3,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm9[1,1,1,1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm7[2,2,3,3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm3 = xmm3[0],xmm12[0],xmm3[1],xmm12[1],xmm3[2],xmm12[2],xmm3[3],xmm12[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5],xmm3[6,7]
; AVX1-NEXT:    vandps %ymm0, %ymm14, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vandnps %ymm1, %ymm14, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm3[1,1,1,1]
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm2[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [4,5,0,1,12,13,14,15,8,9,10,11,12,13,14,15]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm6[0,1],xmm11[2,3],xmm6[4,5,6,7]
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm4[0,1,2],xmm0[3,4],xmm4[5,6,7]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX1-NEXT:    vpblendw {{.*#+}} xmm10 = xmm5[0,1],xmm14[2,3],xmm5[4,5,6,7]
; AVX1-NEXT:    vpshufb %xmm1, %xmm10, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,2,3,4,5,6,7,8,9,0,1,12,13,8,9]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm8[0,1,2,3],xmm13[4,5],xmm8[6,7]
; AVX1-NEXT:    vpshufb %xmm5, %xmm4, %xmm15
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm15, %ymm1
; AVX1-NEXT:    vmovaps {{.*#+}} ymm15 = [0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX1-NEXT:    vandnps %ymm0, %ymm15, %ymm0
; AVX1-NEXT:    vandps %ymm1, %ymm15, %ymm1
; AVX1-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm11[1,1,1,1]
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm13 = xmm9[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm13[0],xmm1[0]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm13 = xmm7[0,1,2,3],xmm12[4,5],xmm7[6,7]
; AVX1-NEXT:    vpshufb %xmm5, %xmm13, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm5[0,1,2],xmm1[3,4],xmm5[5,6,7]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm8 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0]
; AVX1-NEXT:    vandps %ymm0, %ymm8, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vandnps %ymm1, %ymm8, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa %xmm3, %xmm6
; AVX1-NEXT:    vpsrlq $48, %xmm3, %xmm1
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[2,2,3,3]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm5[0],xmm1[0]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [6,7,2,3,14,15,14,15,8,9,10,11,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm5, %xmm2, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[3,4],xmm3[5,6,7]
; AVX1-NEXT:    vpshufb %xmm5, %xmm10, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,2,3,4,5,6,7,14,15,2,3,14,15,10,11]
; AVX1-NEXT:    vpshufb %xmm2, %xmm4, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm3
; AVX1-NEXT:    vandnps %ymm1, %ymm15, %ymm1
; AVX1-NEXT:    vandps %ymm3, %ymm15, %ymm3
; AVX1-NEXT:    vorps %ymm1, %ymm3, %ymm1
; AVX1-NEXT:    vpsrlq $48, %xmm11, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm9[2,2,3,3]
; AVX1-NEXT:    vmovdqa %xmm9, %xmm10
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm5[0],xmm3[0]
; AVX1-NEXT:    vpshufb %xmm2, %xmm13, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2],xmm3[3,4],xmm4[5,6,7]
; AVX1-NEXT:    vandps %ymm1, %ymm8, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-NEXT:    vandnps %ymm3, %ymm8, %ymm3
; AVX1-NEXT:    vorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm9[1,1,1,1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm14[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm3 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm3 = xmm2[0,1],mem[2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,4,5,4,5,6,7,0,1,4,5,0,1,12,13]
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX1-NEXT:    vmovdqa (%rsp), %xmm8 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm8[1,1,1,1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm0[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm15[0,1,2,3,4,5,4,6]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm7 = xmm7[1],xmm6[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm7[2,3,4,5,6,7]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm7 = [65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX1-NEXT:    vandnps %ymm1, %ymm7, %ymm1
; AVX1-NEXT:    vandps %ymm7, %ymm5, %ymm5
; AVX1-NEXT:    vorps %ymm1, %ymm5, %ymm1
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm5 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm5 = xmm12[0,1],mem[2,3],xmm12[4,5,6,7]
; AVX1-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm10 = xmm10[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm10[0,1,2,3,4,5,4,6]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4],xmm4[5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vblendps {{.*#+}} ymm12 = ymm1[0,1,2,3,4],ymm0[5,6,7]
; AVX1-NEXT:    vpsrlq $48, %xmm9, %xmm1
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm14[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [6,7,2,3,4,5,6,7,6,7,6,7,2,3,14,15]
; AVX1-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; AVX1-NEXT:    vpsrlq $48, %xmm8, %xmm3
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpsrld $16, %xmm6, %xmm3
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm15[0,1,2,3,4,5,5,7]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm3 = xmm6[1],xmm3[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3,4,5,6,7]
; AVX1-NEXT:    vandnps %ymm1, %ymm7, %ymm1
; AVX1-NEXT:    vandps %ymm7, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vpshufb %xmm4, %xmm5, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm11, %xmm3
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm10[0,1,2,3,4,5,5,7]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rsi)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rdx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rcx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%r8)
; AVX1-NEXT:    vmovaps %ymm12, (%r9)
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-NEXT:    addq $184, %rsp
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm13
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm14
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm5
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm15
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm1[0,1],ymm15[2],ymm1[3,4],ymm15[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[0,1,4,5,4,5,u,u,0,1,12,13,u,u,4,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm8[2,2,2,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm7[3],xmm6[4,5],xmm7[6],xmm6[7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm9
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm2[2,3],ymm5[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm7 = ymm12[0,2,2,1,4,6,6,5]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm7[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm10 = ymm2[0,1],ymm5[0,1]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm10[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm5[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm11[2],ymm2[3,4,5,6],ymm11[7],ymm2[8,9],ymm11[10],ymm2[11,12,13,14],ymm11[15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm13[0],ymm14[1],ymm13[2,3],ymm14[4],ymm13[5,6],ymm14[7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm11[0,1,12,13,u,u,4,5,u,u,u,u,12,13,14,15]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm3[0,2,0,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm4[2],xmm1[3],xmm4[4,5],xmm1[6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm1[0,1,2],ymm9[3,4,5,6,7],ymm1[8,9,10],ymm9[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm8[0,1,2,3,5,5,5,5]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,7,2,3,4,5,u,u,2,3,14,15,u,u,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[2,1,2,1,6,5,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm1[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm5[1,3,2,3,4,5,6,7,9,11,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0,1],ymm1[2],ymm4[3,4,5,6],ymm1[7],ymm4[8,9],ymm1[10],ymm4[11,12,13,14],ymm1[15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,10,11,u,u,2,3,14,15,u,u,u,u]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm11[2,3,14,15,u,u,6,7,u,u,u,u,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1],xmm3[2],xmm4[3],xmm3[4,5],xmm4[6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3,4,5],ymm3[6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7],ymm1[8,9,10],ymm0[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1],ymm11[2],ymm15[3,4],ymm11[5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm1[0,1,2,3,6,5,6,4]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm0[0,0,0,0,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4],xmm4[5,6],xmm3[7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm10[1,1,0,3,5,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,4,4,6,7,8,9,10,11,12,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm9 = ymm12[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm8 = ymm9[0,0,2,3,4,5,6,7,8,8,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm8 = ymm8[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm8[1,2,3,4],ymm4[5,6],ymm8[7],ymm4[8],ymm8[9,10,11,12],ymm4[13,14],ymm8[15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm13[0,1],ymm14[2],ymm13[3,4],ymm14[5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm8[2,1,2,3]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm8, %xmm5
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,3,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm5[0,0,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm2[2,1,2,0,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm7[0],xmm6[1,2],xmm7[3],xmm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0,1,2],ymm3[3,4,5,6,7],ymm4[8,9,10],ymm3[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1,2,3,4],xmm4[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,1,1,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm10[6,7,u,u,u,u,u,u,u,u,2,3,14,15,u,u,22,23,u,u,u,u,u,u,u,u,18,19,30,31,u,u]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm9[0,1,3,3,4,5,6,7,8,9,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm3[1,2,3,4],ymm1[5,6],ymm3[7],ymm1[8],ymm3[9,10,11,12],ymm1[13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7],ymm1[8,9,10],ymm0[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[3,1,2,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm5[0,1,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1,2],xmm2[3],xmm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1],ymm13[2],ymm14[3,4],ymm13[5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm1[2,2,2,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[8,9,u,u,0,1,12,13,u,u,12,13,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2,3],xmm2[4],xmm3[5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm10[2,1,2,1,6,5,6,5]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm3[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm12[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm5[2,2,2,2,4,5,6,7,10,10,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5,4,6,8,9,10,11,12,13,12,14]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm6[1,2,3,4],ymm4[5],ymm6[6,7],ymm4[8],ymm6[9,10,11,12],ymm4[13],ymm6[14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm2, %ymm4, %ymm2
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm11[0],ymm15[1],ymm11[2,3],ymm15[4],ymm11[5,6],ymm15[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm3[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm5[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5,5,7,8,9,10,11,12,13,13,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm5[1,2,3,4],ymm3[5],ymm5[6,7],ymm3[8],ymm5[9,10,11,12],ymm3[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[10,11,u,u,2,3,14,15,u,u,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3],xmm1[4],xmm0[5,6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm6, %ymm0, %ymm3, %ymm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,u,u,u,8,9,u,u,0,1,12,13]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[0,3,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[0,1,0,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm5[0,1,2,3],xmm3[4],xmm5[5],xmm3[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm3[5,6,7]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,10,11,u,u,2,3,14,15]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm4[0,1,1,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,3,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0,1,2,3],xmm1[4],xmm3[5],xmm1[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, (%r8)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: vf16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm14
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm15
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm5
; AVX2-FAST-NEXT:    vmovdqa 160(%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 128(%rdi), %ymm13
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm13[0,1],ymm0[2],ymm13[3,4],ymm0[5],ymm13[6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm8[u,u,u,u,u,u,4,5,u,u,u,u,8,9,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[0,1,4,5,4,5,u,u,0,1,12,13,u,u,4,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm6 = xmm7[0,1,2],xmm6[3],xmm7[4,5],xmm6[6],xmm7[7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm9
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm10 = ymm2[2,3],ymm5[2,3]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm11 = ymm10[2,1,2,1,6,5,6,5]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm12 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,12,13,u,u,u,u,16,17,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm7 = ymm2[0,1],ymm5[0,1]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm5 = ymm7[0,3,2,3,4,7,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,8,9,u,u,16,17,20,21,u,u,22,23,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm12[2],ymm2[3,4,5,6],ymm12[7],ymm2[8,9],ymm12[10],ymm2[11,12,13,14],ymm12[15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = ymm14[0],ymm15[1],ymm14[2,3],ymm15[4],ymm14[5,6],ymm15[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[0,1,12,13,u,u,4,5,u,u,u,u,12,13,14,15]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm12, %xmm3
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[2,1,0,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm3[u,u,u,u,0,1,u,u,8,9,12,13,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm4[2],xmm1[3],xmm4[4,5],xmm1[6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm2[3,4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm1[0,1,2],ymm9[3,4,5,6,7],ymm1[8,9,10],ymm9[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm8[0,1,2,3,5,5,5,5]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,7,2,3,4,5,u,u,2,3,14,15,u,u,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm11[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,10,11,u,u,18,19,22,23,u,u,22,23,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0,1],ymm1[2],ymm4[3,4,5,6],ymm1[7],ymm4[8,9],ymm1[10],ymm4[11,12,13,14],ymm1[15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm12[2,3,14,15,u,u,6,7,u,u,u,u,12,13,14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,2,3,u,u,10,11,14,15,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1],xmm3[2],xmm4[3],xmm3[4,5],xmm4[6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3,4,5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7],ymm1[8,9,10],ymm0[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1],ymm13[2],ymm11[3,4],ymm13[5],ymm11[6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm1[0,1,2,3,6,5,6,4]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[0,1,0,1,0,1,0,1,u,u,8,9,12,13,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm12 = xmm4[0,1,2,3],xmm3[4],xmm4[5,6],xmm3[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm7[4,5,u,u,u,u,u,u,u,u,0,1,12,13,u,u,20,21,u,u,u,u,u,u,u,u,16,17,28,29,u,u]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm9 = ymm10[0,3,2,3,4,7,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm8 = ymm9[u,u,0,1,4,5,6,7,8,9,u,u,u,u,8,9,u,u,16,17,20,21,22,23,24,25,u,u,u,u,24,25]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm8[1,2,3,4],ymm4[5,6],ymm8[7],ymm4[8],ymm8[9,10,11,12],ymm4[13,14],ymm8[15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm8[2,1,2,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm5[2,1,2,0,4,5,6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm8, %xmm2
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm2[u,u,0,1,4,5,u,u,12,13,12,13,12,13,12,13]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0],xmm6[1,2],xmm3[3],xmm6[4,5,6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm6 = ymm4[0,1,2],ymm6[3,4,5,6,7],ymm4[8,9,10],ymm6[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3,4],xmm4[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm3[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,5,6,5]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,3,2,3,2,3,2,3,u,u,10,11,14,15,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4],xmm0[5,6],xmm1[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm7[6,7,u,u,u,u,u,u,u,u,2,3,14,15,u,u,22,23,u,u,u,u,u,u,u,u,18,19,30,31,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm9[u,u,2,3,6,7,6,7,10,11,u,u,u,u,10,11,u,u,18,19,22,23,22,23,26,27,u,u,u,u,26,27]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm3[1,2,3,4],ymm1[5,6],ymm3[7],ymm1[8],ymm3[9,10,11,12],ymm1[13,14],ymm3[15]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7],ymm1[8,9,10],ymm0[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm5[3,1,2,1,4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,2,3,6,7,u,u,14,15,14,15,14,15,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1,2],xmm3[3],xmm2[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm0 = ymm7[2,1,2,1,6,5,6,5]
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm0[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm10[0,1,0,3,4,5,4,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm3 = ymm2[u,u,4,5,4,5,4,5,8,9,u,u,8,9,12,13,u,u,20,21,20,21,20,21,24,25,u,u,24,25,28,29]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm3[1,2,3,4],ymm1[5],ymm3[6,7],ymm1[8],ymm3[9,10,11,12],ymm1[13],ymm3[14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm15[0,1],ymm14[2],ymm15[3,4],ymm14[5],ymm15[6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm4[2,2,2,2,4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[8,9,u,u,0,1,12,13,u,u,12,13,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1],xmm6[2,3],xmm5[4],xmm6[5,6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm13[0],ymm11[1],ymm13[2,3],ymm11[4],ymm13[5,6],ymm11[7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[2,3,u,u,u,u,u,u,u,u,14,15,u,u,u,u,18,19,u,u,u,u,u,u,u,u,30,31,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,6,7,6,7,6,7,8,9,u,u,10,11,14,15,u,u,22,23,22,23,22,23,24,25,u,u,26,27,30,31]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1,2,3,4],ymm0[5],ymm2[6,7],ymm0[8],ymm2[9,10,11,12],ymm0[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm4[u,u,6,7,u,u,u,u,10,11,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[10,11,u,u,2,3,14,15,u,u,10,11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1],xmm3[2,3],xmm2[4],xmm3[5,6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm3
; AVX2-FAST-NEXT:    vpblendvb %ymm6, %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u,u,u,u,u,u,u,8,9,u,u,0,1,12,13]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm5[0,3,2,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm5 = xmm4[0,1,2,3,0,1,4,5,u,u,12,13,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1,2,3],xmm2[4],xmm5[5],xmm2[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4],ymm2[5,6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u,u,u,u,u,u,u,10,11,u,u,2,3,14,15]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm3 = xmm4[0,1,2,3,2,3,6,7,u,u,14,15,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3],xmm2[4],xmm3[5],xmm2[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5,6,7]
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm2, (%rdx)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm9, (%r8)
; AVX2-FAST-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm2
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm3
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = [0,0,0,2,8,14,20,26,0,0,0,2,8,14,20,26]
; AVX512-NEXT:    # ymm0 = mem[0,1,0,1]
; AVX512-NEXT:    vmovdqa 160(%rdi), %ymm4
; AVX512-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX512-NEXT:    vpermi2w %ymm4, %ymm5, %ymm0
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,6,12,18,24,30,36,42,48,54,60,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7],ymm1[8,9,10],ymm0[11,12,13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [0,0,0,3,9,15,21,27,0,0,0,3,9,15,21,27]
; AVX512-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512-NEXT:    vpermi2w %ymm4, %ymm5, %ymm1
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm6 = <1,7,13,19,25,31,37,43,49,55,61,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm3, %zmm2, %zmm6
; AVX512-NEXT:    vpblendw {{.*#+}} ymm1 = ymm6[0,1,2],ymm1[3,4,5,6,7],ymm6[8,9,10],ymm1[11,12,13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [0,0,0,20,26,0,6,12,0,0,0,20,26,0,6,12]
; AVX512-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512-NEXT:    vpermi2w %ymm5, %ymm4, %ymm6
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm7 = <34,40,46,52,58,0,6,12,18,24,30,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm2, %zmm3, %zmm7
; AVX512-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0,1,2],ymm6[3,4,5,6,7],ymm7[8,9,10],ymm6[11,12,13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [0,0,0,21,27,1,7,13,0,0,0,21,27,1,7,13]
; AVX512-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512-NEXT:    vpermi2w %ymm5, %ymm4, %ymm7
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = <35,41,47,53,59,1,7,13,19,25,31,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm2, %zmm3, %zmm8
; AVX512-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1,2],ymm7[3,4,5,6,7],ymm8[8,9,10],ymm7[11,12,13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [0,0,0,6,12,18,24,30,0,0,0,6,12,18,24,30]
; AVX512-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX512-NEXT:    vpermi2w %ymm4, %ymm5, %ymm8
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm9 = <4,10,16,22,28,34,40,46,52,58,u,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm3, %zmm2, %zmm9
; AVX512-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3,4],ymm8[5,6,7]
; AVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [0,0,1,7,13,19,25,31,0,0,1,7,13,19,25,31]
; AVX512-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512-NEXT:    vpermi2w %ymm4, %ymm5, %ymm9
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = <5,11,17,23,29,35,41,47,53,59,u,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3,4],ymm9[5,6,7]
; AVX512-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm1, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm6, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm7, (%r8)
; AVX512-NEXT:    vmovdqa %ymm8, (%r9)
; AVX512-NEXT:    vmovdqa %ymm2, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <96 x i16>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <96 x i16> %wide.vec, <96 x i16> poison, <16 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42, i32 48, i32 54, i32 60, i32 66, i32 72, i32 78, i32 84, i32 90>
  %strided.vec1 = shufflevector <96 x i16> %wide.vec, <96 x i16> poison, <16 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43, i32 49, i32 55, i32 61, i32 67, i32 73, i32 79, i32 85, i32 91>
  %strided.vec2 = shufflevector <96 x i16> %wide.vec, <96 x i16> poison, <16 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44, i32 50, i32 56, i32 62, i32 68, i32 74, i32 80, i32 86, i32 92>
  %strided.vec3 = shufflevector <96 x i16> %wide.vec, <96 x i16> poison, <16 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45, i32 51, i32 57, i32 63, i32 69, i32 75, i32 81, i32 87, i32 93>
  %strided.vec4 = shufflevector <96 x i16> %wide.vec, <96 x i16> poison, <16 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46, i32 52, i32 58, i32 64, i32 70, i32 76, i32 82, i32 88, i32 94>
  %strided.vec5 = shufflevector <96 x i16> %wide.vec, <96 x i16> poison, <16 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47, i32 53, i32 59, i32 65, i32 71, i32 77, i32 83, i32 89, i32 95>

  store <16 x i16> %strided.vec0, ptr %out.vec0, align 32
  store <16 x i16> %strided.vec1, ptr %out.vec1, align 32
  store <16 x i16> %strided.vec2, ptr %out.vec2, align 32
  store <16 x i16> %strided.vec3, ptr %out.vec3, align 32
  store <16 x i16> %strided.vec4, ptr %out.vec4, align 32
  store <16 x i16> %strided.vec5, ptr %out.vec5, align 32

  ret void
}

define void @vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5) nounwind {
; SSE-LABEL: vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $456, %rsp # imm = 0x1C8
; SSE-NEXT:    movdqa 208(%rdi), %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 224(%rdi), %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdi), %xmm2
; SSE-NEXT:    movdqa 80(%rdi), %xmm7
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdi), %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,2,4,5,6,7]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,1,0,3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm4[2],xmm0[3],xmm4[3]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm7[0],xmm0[1],xmm7[1],xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm2[3,0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,0],xmm7[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm7[2,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslld $16, %xmm7
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,3,2,3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,1],xmm0[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm6[0,1,1,2,4,5,6,7]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa 192(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    movdqa 256(%rdi), %xmm4
; SSE-NEXT:    movdqa 272(%rdi), %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm4[3,0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,0],xmm0[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm0[2,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    movdqa 240(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1],xmm0[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,2,4,5,6,7]
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    movdqa 112(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,4,6,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    movdqa 160(%rdi), %xmm5
; SSE-NEXT:    movdqa 176(%rdi), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1],xmm6[2],xmm3[2],xmm6[3],xmm3[3]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm5[3,0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm3[2,3]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslld $16, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm4 = xmm4[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE-NEXT:    movdqa 144(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm14 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm14[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,1],xmm3[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm4[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 320(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[0,1,1,2,4,5,6,7]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa 304(%rdi), %xmm15
; SSE-NEXT:    movdqa 288(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm5[0,1,2,3,4,6,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm15[2],xmm1[3],xmm15[3]
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    movdqa 352(%rdi), %xmm12
; SSE-NEXT:    movdqa 368(%rdi), %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm12[2,2,3,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm11[0],xmm8[1],xmm11[1],xmm8[2],xmm11[2],xmm8[3],xmm11[3]
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm12[3,0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm12, %xmm9
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,0],xmm11[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0],xmm11[2,3]
; SSE-NEXT:    pslld $16, %xmm11
; SSE-NEXT:    psrldq {{.*#+}} xmm9 = xmm9[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0],xmm11[0],xmm9[1],xmm11[1],xmm9[2],xmm11[2],xmm9[3],xmm11[3]
; SSE-NEXT:    movdqa 336(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm1[0,1,0,2,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,1],xmm7[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm9[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    psrld $16, %xmm7
; SSE-NEXT:    pshufhw $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = mem[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm11 = xmm11[2],xmm7[2],xmm11[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pandn %xmm9, %xmm7
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    por %xmm7, %xmm11
; SSE-NEXT:    pshuflw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[0,1,1,3,4,5,6,7]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,1],xmm7[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm4[2,0]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm11, %xmm7
; SSE-NEXT:    psrld $16, %xmm7
; SSE-NEXT:    pshufhw $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm0 = xmm0[2],xmm7[2],xmm0[3],xmm7[3]
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    pshuflw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[0,1,1,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,1],xmm7[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm2
; SSE-NEXT:    pshufhw {{.*#+}} xmm13 = xmm13[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm13 = xmm13[2],xmm2[2],xmm13[3],xmm2[3]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    pand %xmm10, %xmm13
; SSE-NEXT:    por %xmm2, %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm14[0,1,1,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,1],xmm2[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm6[2,0]
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm5[0,1,2,3,5,7,6,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    pandn %xmm14, %xmm10
; SSE-NEXT:    por %xmm2, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,1,1,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[3,1],xmm0[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    psrldq {{.*#+}} xmm0 = xmm0[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[1,1,1,1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm3[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $132, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0,1],mem[0,2]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm0[0,1,2,3,4,6,5,4]
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa %xmm10, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm3, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[1,1,1,1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,0],xmm11[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm11[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm6[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $132, (%rsp), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0,1],mem[0,2]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,6,5,4]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm14[1,1,1,1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,0],xmm15[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm15[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm2[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps $132, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[0,1],mem[0,2]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm3[0,1,2,3,4,6,5,4]
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm11, %xmm3
; SSE-NEXT:    pand %xmm10, %xmm4
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm11[1,1,1,1]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,0],xmm0[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm0[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm3[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,0,2,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps $132, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    # xmm15 = xmm15[0,1],mem[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm15[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,5,4]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    pand %xmm10, %xmm7
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm9, %xmm4
; SSE-NEXT:    psrlq $48, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm9[2,2,3,3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm7 = xmm7[0],xmm4[0]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm7, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pshufhw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,0,2]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    psrlq $48, %xmm8
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = mem[2,2,3,3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm8[0]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm5, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm6[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pshufhw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,0,2]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    pand %xmm10, %xmm5
; SSE-NEXT:    por %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    psrlq $48, %xmm4
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = mem[2,2,3,3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm5, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm15[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,0,2]
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm4, %xmm11
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm3, %xmm11
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    psrlq $48, %xmm3
; SSE-NEXT:    pshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[2,2,3,3]
; SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,3,3,4,5,6,7]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pshufhw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,2]
; SSE-NEXT:    movdqa %xmm10, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm14
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm1, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm9[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm8[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm6[1]
; SSE-NEXT:    movss {{.*#+}} xmm3 = xmm2[0],xmm3[1,2,3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm7[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa %xmm10, %xmm9
; SSE-NEXT:    pandn %xmm2, %xmm9
; SSE-NEXT:    andps %xmm10, %xmm3
; SSE-NEXT:    por %xmm3, %xmm9
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[1,1,1,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm15[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    pshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,0,3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm1[0,1,2,3,4,5,4,6]
; SSE-NEXT:    punpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[1],mem[1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm3[0],xmm2[1,2,3]
; SSE-NEXT:    pshuflw $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    andps %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; SSE-NEXT:    pshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,0,3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm1[0,1,2,3,4,5,4,6]
; SSE-NEXT:    punpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[1],mem[1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm3[0],xmm2[1,2,3]
; SSE-NEXT:    pshuflw $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm3[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    andps %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $238, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[2,3,2,3]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    pshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[0,1,0,3]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,4,6]
; SSE-NEXT:    punpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1],mem[1]
; SSE-NEXT:    movss {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm12[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,6]
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    andps %xmm10, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm1 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; SSE-NEXT:    psrld $16, %xmm6
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm8[0,1,2,3,4,5,5,7]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm6[1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm1[0],xmm2[1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm7[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm1[0,1,2,3,4,4,5,7]
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pandn %xmm8, %xmm1
; SSE-NEXT:    andps %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm6
; SSE-NEXT:    psrldq {{.*#+}} xmm15 = xmm15[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm6[0],xmm15[1],xmm6[1],xmm15[2],xmm6[2],xmm15[3],xmm6[3]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm7
; SSE-NEXT:    pshufhw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,3,4,5,5,7]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm15[0],xmm2[1,2,3]
; SSE-NEXT:    pshuflw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,4,5,7]
; SSE-NEXT:    movdqa %xmm10, %xmm15
; SSE-NEXT:    pandn %xmm7, %xmm15
; SSE-NEXT:    andps %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm15
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm7
; SSE-NEXT:    pshufhw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,3,4,5,5,7]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm6[0],xmm2[1,2,3]
; SSE-NEXT:    pshuflw $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm7[0,1,2,3,4,4,5,7]
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    pandn %xmm8, %xmm7
; SSE-NEXT:    andps %xmm10, %xmm2
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    psrlq $48, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    psrldq {{.*#+}} xmm2 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    psrld $16, %xmm6
; SSE-NEXT:    pshufhw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,1,2,3,4,5,5,7]
; SSE-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm6[1]
; SSE-NEXT:    movss {{.*#+}} xmm2 = xmm8[0],xmm2[1,2,3]
; SSE-NEXT:    andps %xmm10, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm12[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,4,5,7]
; SSE-NEXT:    pandn %xmm6, %xmm10
; SSE-NEXT:    por %xmm2, %xmm10
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rdx)
; SSE-NEXT:    movaps %xmm13, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rcx)
; SSE-NEXT:    movaps (%rsp), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rcx)
; SSE-NEXT:    movdqa %xmm14, 48(%r8)
; SSE-NEXT:    movdqa %xmm11, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movdqa %xmm3, 48(%r9)
; SSE-NEXT:    movdqa %xmm4, 16(%r9)
; SSE-NEXT:    movdqa %xmm5, 32(%r9)
; SSE-NEXT:    movdqa %xmm9, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movdqa %xmm10, 48(%rax)
; SSE-NEXT:    movdqa %xmm7, 16(%rax)
; SSE-NEXT:    movdqa %xmm15, 32(%rax)
; SSE-NEXT:    movdqa %xmm1, (%rax)
; SSE-NEXT:    addq $456, %rsp # imm = 0x1C8
; SSE-NEXT:    retq
;
; AVX1-LABEL: vf32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    subq $584, %rsp # imm = 0x248
; AVX1-NEXT:    vmovdqa 288(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vmovdqa 304(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vmovdqa 272(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpslld $16, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa 256(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm2[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovdqa 224(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpsrlq $16, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa 240(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,0,2,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX1-NEXT:    vmovdqa 192(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vmovdqa 208(%rdi), %xmm3
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[3,4,5],xmm2[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX1-NEXT:    vmovdqa 368(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpslld $16, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa 352(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm2[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-NEXT:    vmovdqa 320(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpsrlq $16, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa 336(%rdi), %xmm3
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,3,2,3]
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm3[0,1,0,2,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,5],xmm1[6,7]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0]
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vandnps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vmovaps %ymm2, %ymm9
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm12
; AVX1-NEXT:    vpslld $16, %xmm12, %xmm0
; AVX1-NEXT:    vmovdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm11
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm11[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vmovdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-NEXT:    vmovdqa 96(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm3[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vmovdqa 112(%rdi), %xmm14
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm2[2],xmm14[2],xmm2[3],xmm14[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm15
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm13
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpsrlq $16, %xmm13, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[0,3,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm1[0,1,0,2,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm2[0,1,2,3,4,6,6,7]
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm7 = xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0,1,2],xmm5[3,4,5],xmm7[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2],ymm15[3,4,5],ymm5[6,7]
; AVX1-NEXT:    vmovdqa 176(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpslld $16, %xmm0, %xmm5
; AVX1-NEXT:    vmovdqa 160(%rdi), %xmm10
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm7 = xmm10[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX1-NEXT:    vmovdqa 128(%rdi), %xmm6
; AVX1-NEXT:    vpsrlq $16, %xmm6, %xmm7
; AVX1-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa 144(%rdi), %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,3,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm15 = xmm0[0,1,0,2,4,5,6,7]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm15[0],xmm7[0],xmm15[1],xmm7[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0,1,2,3,4,5],xmm5[6,7]
; AVX1-NEXT:    vandps %ymm4, %ymm9, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-NEXT:    vandnps %ymm5, %ymm9, %ymm5
; AVX1-NEXT:    vmovaps %ymm9, %ymm7
; AVX1-NEXT:    vorps %ymm5, %ymm4, %ymm4
; AVX1-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vpsrld $16, %xmm14, %xmm4
; AVX1-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm11[2,2,3,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm4 = xmm4[0],xmm12[0],xmm4[1],xmm12[1],xmm4[2],xmm12[2],xmm4[3],xmm12[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,1,1,3,4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm13, %xmm11
; AVX1-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm13[1,1,1,1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vpsrld $16, %xmm8, %xmm4
; AVX1-NEXT:    vmovdqa %xmm8, %xmm9
; AVX1-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[3,4,5],xmm2[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2],ymm3[3,4,5],ymm1[6,7]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,1,1,3,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm6[1,1,1,1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm10[2,2,3,3]
; AVX1-NEXT:    vmovdqa %xmm10, %xmm13
; AVX1-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm10[0],xmm2[1],xmm10[1],xmm2[2],xmm10[2],xmm2[3],xmm10[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5],xmm2[6,7]
; AVX1-NEXT:    vandps %ymm7, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm7, %ymm0
; AVX1-NEXT:    vmovaps %ymm7, %ymm4
; AVX1-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufhw $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm0 = mem[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-NEXT:    vpsrld $16, %xmm7, %xmm1
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-NEXT:    vpshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[2,2,3,3]
; AVX1-NEXT:    vpunpcklwd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = xmm1[0],mem[0],xmm1[1],mem[1],xmm1[2],mem[2],xmm1[3],mem[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vpshuflw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[0,1,1,3,4,5,6,7]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm15[1,1,1,1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX1-NEXT:    vpshufhw $237, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm2 = mem[0,1,2,3,5,7,6,7]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-NEXT:    vpsrld $16, %xmm5, %xmm3
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[3,4,5],xmm2[6,7]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5],ymm1[6,7]
; AVX1-NEXT:    vpshuflw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[0,1,1,3,4,5,6,7]
; AVX1-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm2 = mem[1,1,1,1]
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm6[2,2,3,3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5],xmm2[6,7]
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vandnps %ymm1, %ymm4, %ymm1
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm0 = mem[1,1,1,1]
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm11[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,5,0,1,12,13,14,15,8,9,10,11,12,13,14,15]
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm2 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm2 = xmm9[0,1],mem[2,3],xmm9[4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2],xmm1[3,4],xmm2[5,6,7]
; AVX1-NEXT:    vpblendw $12, (%rsp), %xmm14, %xmm2 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm2 = xmm14[0,1],mem[2,3],xmm14[4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm11 = [0,1,2,3,4,5,6,7,8,9,0,1,12,13,8,9]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-NEXT:    vpblendw $207, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm3 = mem[0,1,2,3],xmm3[4,5],mem[6,7]
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb %xmm11, %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vmovaps {{.*#+}} ymm12 = [0,0,0,0,0,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535]
; AVX1-NEXT:    vandnps %ymm1, %ymm12, %ymm1
; AVX1-NEXT:    vandps %ymm2, %ymm12, %ymm2
; AVX1-NEXT:    vorps %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm2 = mem[1,1,1,1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm3[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm4[0],xmm2[0]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm13[0,1,2,3],xmm10[4,5],xmm13[6,7]
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufb %xmm11, %xmm3, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1,2],xmm2[3,4],xmm4[5,6,7]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm3 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0]
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-NEXT:    vandnps %ymm2, %ymm3, %ymm2
; AVX1-NEXT:    vmovaps %ymm3, %ymm4
; AVX1-NEXT:    vorps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[1,1,1,1]
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm15[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm14 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm14 = xmm5[0,1],mem[2,3],xmm5[4,5,6,7]
; AVX1-NEXT:    vpshufb %xmm0, %xmm14, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm15 = xmm2[0,1,2],xmm1[3,4],xmm2[5,6,7]
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm2 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm2 = xmm7[0,1],mem[2,3],xmm7[4,5,6,7]
; AVX1-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-NEXT:    vpblendw $207, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[0,1,2,3],xmm1[4,5],mem[6,7]
; AVX1-NEXT:    vpshufb %xmm11, %xmm1, %xmm13
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm13, %ymm0
; AVX1-NEXT:    vandnps %ymm15, %ymm12, %ymm13
; AVX1-NEXT:    vandps %ymm0, %ymm12, %ymm0
; AVX1-NEXT:    vorps %ymm0, %ymm13, %ymm13
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm3[1,1,1,1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm7 = xmm9[2,3,4,5,6,7,8,9,10,11,12,13,14,15],zero,zero
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm7[0],xmm0[0]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm15 = xmm6[0,1,2,3],xmm8[4,5],xmm6[6,7]
; AVX1-NEXT:    vpshufb %xmm11, %xmm15, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2],xmm7[3,4],xmm5[5,6,7]
; AVX1-NEXT:    vandps %ymm4, %ymm13, %ymm7
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-NEXT:    vandnps %ymm5, %ymm4, %ymm5
; AVX1-NEXT:    vmovaps %ymm4, %ymm13
; AVX1-NEXT:    vorps %ymm5, %ymm7, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-NEXT:    vpsrlq $48, %xmm11, %xmm5
; AVX1-NEXT:    vpshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm7 = mem[2,2,3,3]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm7[0],xmm5[0]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [6,7,2,3,14,15,14,15,8,9,10,11,12,13,14,15]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm7, %xmm0, %xmm6
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1,2],xmm5[3,4],xmm6[5,6,7]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm7, %xmm0, %xmm6
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm10 = [0,1,2,3,4,5,6,7,14,15,2,3,14,15,10,11]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm10, %xmm0, %xmm8
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm6
; AVX1-NEXT:    vandnps %ymm5, %ymm12, %ymm5
; AVX1-NEXT:    vandps %ymm6, %ymm12, %ymm6
; AVX1-NEXT:    vorps %ymm5, %ymm6, %ymm5
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-NEXT:    vpsrlq $48, %xmm8, %xmm6
; AVX1-NEXT:    vpshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm4 = mem[2,2,3,3]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm6[0]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm10, %xmm0, %xmm6
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1,2],xmm4[3,4],xmm6[5,6,7]
; AVX1-NEXT:    vmovaps %ymm13, %ymm6
; AVX1-NEXT:    vandps %ymm5, %ymm13, %ymm5
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-NEXT:    vandnps %ymm4, %ymm13, %ymm4
; AVX1-NEXT:    vorps %ymm4, %ymm5, %ymm4
; AVX1-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-NEXT:    vpsrlq $48, %xmm13, %xmm4
; AVX1-NEXT:    vpshufd $250, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm5 = mem[2,2,3,3]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm5[0],xmm4[0]
; AVX1-NEXT:    vpshufb %xmm7, %xmm14, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[3,4],xmm5[5,6,7]
; AVX1-NEXT:    vpshufb %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm10, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vandnps %ymm4, %ymm12, %ymm2
; AVX1-NEXT:    vandps %ymm1, %ymm12, %ymm1
; AVX1-NEXT:    vorps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vpsrlq $48, %xmm3, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm9[2,2,3,3]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX1-NEXT:    vpshufb %xmm10, %xmm15, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm2[3,4],xmm0[5,6,7]
; AVX1-NEXT:    vandps %ymm6, %ymm1, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vandnps %ymm0, %ymm6, %ymm0
; AVX1-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm0 = mem[1,1,1,1]
; AVX1-NEXT:    vpshufd $238, (%rsp), %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = xmm1[0,1],mem[2,3],xmm1[4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,4,5,4,5,6,7,0,1,4,5,0,1,12,13]
; AVX1-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[1,1,1,1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm15[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX1-NEXT:    vpshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm2 = mem[0,1,0,3]
; AVX1-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,6]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm11[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3,4,5,6,7]
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm3 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm3 = xmm1[0,1],mem[2,3],xmm1[4,5,6,7]
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm14 = mem[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm14[0,1,2,3,4,5,4,6]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm8[1]
; AVX1-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm3[5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm0 = mem[1,1,1,1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm11[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm12 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm12 = xmm0[0,1],mem[2,3],xmm0[4,5,6,7]
; AVX1-NEXT:    vpshufb %xmm5, %xmm12, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm3
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm9[1,1,1,1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm8[2,3,2,3]
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; AVX1-NEXT:    vpshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm1 = mem[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm1[0,1,2,3,4,5,4,6]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm13[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1],xmm4[2,3,4,5,6,7]
; AVX1-NEXT:    vandnps %ymm3, %ymm2, %ymm3
; AVX1-NEXT:    vandps %ymm2, %ymm4, %ymm4
; AVX1-NEXT:    vorps %ymm3, %ymm4, %ymm6
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpblendw $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm10 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm10 = xmm0[0,1],mem[2,3],xmm0[4,5,6,7]
; AVX1-NEXT:    vpshufb %xmm5, %xmm10, %xmm7
; AVX1-NEXT:    vpshufd $196, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm4 = mem[0,1,0,3]
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm4[0,1,2,3,4,5,4,6]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4],xmm7[5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3,4],ymm5[5,6,7]
; AVX1-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpsrlq $48, %xmm0, %xmm5
; AVX1-NEXT:    vmovdqa (%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm6 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm13 = [6,7,2,3,4,5,6,7,6,7,6,7,2,3,14,15]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm13, %xmm0, %xmm7
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm5
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpsrlq $48, %xmm0, %xmm7
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm6 = xmm15[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm7
; AVX1-NEXT:    vpshufhw $212, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; AVX1-NEXT:    # xmm0 = mem[0,1,2,3,4,5,5,7]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm7[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm6[0,1],xmm0[2,3,4,5,6,7]
; AVX1-NEXT:    vandnps %ymm5, %ymm2, %ymm5
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm5, %ymm0, %ymm0
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX1-NEXT:    vpsrld $16, %xmm5, %xmm5
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm6 = xmm14[0,1,2,3,4,5,5,7]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm5 = xmm6[1],xmm5[1]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-NEXT:    vpshufb %xmm13, %xmm6, %xmm6
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3,4],xmm6[5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0,1,2,3,4],ymm5[5,6,7]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpsrlq $48, %xmm0, %xmm0
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm6 = xmm11[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; AVX1-NEXT:    vpshufb %xmm13, %xmm12, %xmm6
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm6, %ymm0
; AVX1-NEXT:    vpsrlq $48, %xmm9, %xmm6
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm7 = xmm8[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-NEXT:    vpsrld $16, %xmm7, %xmm7
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,7]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm7[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm6[0,1],xmm1[2,3,4,5,6,7]
; AVX1-NEXT:    vandnps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vorps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vpshufb %xmm13, %xmm10, %xmm1
; AVX1-NEXT:    vpsrld $16, %xmm3, %xmm2
; AVX1-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm4[0,1,2,3,4,5,5,7]
; AVX1-NEXT:    vpunpckhqdq {{.*#+}} xmm2 = xmm3[1],xmm2[1]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3,4],xmm1[5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm1[5,6,7]
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rsi)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rdx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%rcx)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%r8)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX1-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-NEXT:    vmovaps %ymm1, (%r9)
; AVX1-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-NEXT:    vmovaps %ymm5, (%rax)
; AVX1-NEXT:    addq $584, %rsp # imm = 0x248
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $520, %rsp # imm = 0x208
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm5
; AVX2-SLOW-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 32(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqa 288(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa 256(%rdi), %ymm3
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm3[2,3],ymm2[2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm4 = ymm12[0,2,2,1,4,6,6,5]
; AVX2-SLOW-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm3[0,1],ymm2[0,1]
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm2[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm3[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4,5,6],ymm4[7],ymm2[8,9],ymm4[10],ymm2[11,12,13,14],ymm4[15]
; AVX2-SLOW-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm7 = ymm0[0,1],ymm1[0,1]
; AVX2-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1],ymm5[2],ymm6[3,4],ymm5[5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = <8,9,u,u,0,1,12,13,u,u,12,13,12,13,14,15>
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm1, %xmm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm2[2,2,2,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm0[0],xmm3[1],xmm0[2,3],xmm3[4],xmm0[5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm10 = ymm7[2,1,2,1,6,5,6,5]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm10[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm9[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm13[2,2,2,2,4,5,6,7,10,10,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5,4,6,8,9,10,11,12,13,12,14]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm11 = ymm0[0],ymm11[1,2,3,4],ymm0[5],ymm11[6,7],ymm0[8],ymm11[9,10,11,12],ymm0[13],ymm11[14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm3, %ymm11, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 224(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm0[0,1],ymm6[2],ymm0[3,4],ymm6[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, %ymm9
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, %ymm8
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %xmm4, %xmm3, %xmm7
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm3, %xmm4
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm4[2,2,2,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm7[0],xmm6[1],xmm7[2,3],xmm6[4],xmm7[5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm14 = ymm12[0,1,0,3,4,5,4,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm7 = ymm14[2,2,2,2,4,5,6,7,10,10,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5,4,6,8,9,10,11,12,13,12,14]
; AVX2-SLOW-NEXT:    vpshufd $102, (%rsp), %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[2,1,2,1,6,5,6,5]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm15 = ymm0[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm7 = ymm15[0],ymm7[1,2,3,4],ymm15[5],ymm7[6,7],ymm15[8],ymm7[9,10,11,12],ymm15[13],ymm7[14,15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm6, %ymm7, %ymm6
; AVX2-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm10[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm7 = ymm13[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5,5,7,8,9,10,11,12,13,13,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm6[0],ymm7[1,2,3,4],ymm6[5],ymm7[6,7],ymm6[8],ymm7[9,10,11,12],ymm6[13],ymm7[14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm7 = <10,11,u,u,2,3,14,15,u,u,10,11,12,13,14,15>
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[1,1,2,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3],xmm2[4],xmm1[5,6,7]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm1, %ymm6, %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm0 = ymm0[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,1,3,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm14[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5,5,7,8,9,10,11,12,13,13,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4],ymm0[5],ymm1[6,7],ymm0[8],ymm1[9,10,11,12],ymm0[13],ymm1[14,15]
; AVX2-SLOW-NEXT:    vpshufb %xmm7, %xmm3, %xmm1
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm4[1,1,2,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3],xmm2[4],xmm1[5,6,7]
; AVX2-SLOW-NEXT:    vpblendvb %ymm5, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6],ymm8[7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm9[0,2,0,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm10 = <0,1,12,13,u,u,4,5,u,u,u,u,12,13,14,15>
; AVX2-SLOW-NEXT:    vpshufb %xmm10, %xmm2, %xmm1
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2],xmm1[3],xmm0[4,5],xmm1[6,7]
; AVX2-SLOW-NEXT:    vpblendd $56, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = ymm0[0,1,2],mem[3,4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovdqa 352(%rdi), %ymm12
; AVX2-SLOW-NEXT:    vmovdqa 320(%rdi), %ymm3
; AVX2-SLOW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm3[0,1],ymm12[2],ymm3[3,4],ymm12[5],ymm3[6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm5[2,2,2,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,1,2,2]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = <0,1,4,5,4,5,u,u,0,1,12,13,u,u,4,5>
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm5, %xmm4
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm4, %xmm7
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm7[0,1,2],xmm1[3],xmm7[4,5],xmm1[6],xmm7[7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm0[0,1,2],ymm1[3,4,5,6,7],ymm0[8,9,10],ymm1[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 160(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm3
; AVX2-SLOW-NEXT:    vpshufb %xmm6, %xmm3, %xmm6
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm13 = xmm7[2,2,2,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm13[0,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm8 = xmm6[0,1,2],xmm1[3],xmm6[4,5],xmm1[6],xmm6[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm15[0,2,2,1,4,6,6,5]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm6 = ymm6[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-SLOW-NEXT:    vpshufd $236, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm13 = mem[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm13[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm11 = ymm11[0,1,2,2,4,5,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm11[0,1],ymm6[2],ymm11[3,4,5,6],ymm6[7],ymm11[8,9],ymm6[10],ymm11[11,12,13,14],ymm6[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendd $146, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm11 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm11 = ymm0[0],mem[1],ymm0[2,3],mem[4],ymm0[5,6],mem[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm10, %xmm11, %xmm10
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm0[0,2,0,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm14[0,1,2,3,4,6,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm10[0,1],xmm1[2],xmm10[3],xmm1[4,5],xmm10[6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm6[3,4,5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm6
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm1[0,1,2],ymm6[3,4,5,6,7],ymm1[8,9,10],ymm6[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm6[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm10[2,1,2,1,6,5,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm1 = ymm1[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshuflw $237, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm8 = mem[1,3,2,3,4,5,6,7,9,11,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm8 = ymm8[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm8[0,1],ymm1[2],ymm8[3,4,5,6],ymm1[7],ymm8[8,9],ymm1[10],ymm8[11,12,13,14],ymm1[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,u,u,10,11,u,u,2,3,14,15,u,u,u,u>
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm9, %xmm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = <2,3,14,15,u,u,6,7,u,u,u,u,12,13,14,15>
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm6[2],xmm2[3],xmm6[4,5],xmm2[6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3,4,5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm2 = <6,7,2,3,4,5,u,u,2,3,14,15,u,u,6,7>
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm4, %xmm4
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2],xmm5[3],xmm4[4,5],xmm5[6],xmm4[7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm1[0,1,2],ymm4[3,4,5,6,7],ymm1[8,9,10],ymm4[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm7[0,1,2,3,5,5,5,5]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[3],xmm2[4,5],xmm3[6],xmm2[7]
; AVX2-SLOW-NEXT:    vpshufb %xmm8, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpshufb %xmm9, %xmm11, %xmm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1],xmm0[2],xmm3[3],xmm0[4,5],xmm3[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm15[2,1,2,1,6,5,6,5]
; AVX2-SLOW-NEXT:    vmovdqa %ymm15, %ymm1
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm3[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm13[1,3,2,3,4,5,6,7,9,11,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm4[0,1],ymm3[2],ymm4[3,4,5,6],ymm3[7],ymm4[8,9],ymm3[10],ymm4[11,12,13,14],ymm3[15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3,4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm0[0,1,2],ymm2[3,4,5,6,7],ymm0[8,9,10],ymm2[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpshufd $197, (%rsp), %ymm0 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm0 = mem[1,1,0,3,5,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm0 = ymm0[0,1,2,3,4,4,6,7,8,9,10,11,12,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm15 = ymm10[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm15[0,0,2,3,4,5,6,7,8,8,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm4[1,2,3,4],ymm0[5,6],ymm4[7],ymm0[8],ymm4[9,10,11,12],ymm0[13,14],ymm4[15]
; AVX2-SLOW-NEXT:    vpblendd $36, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = ymm12[0,1],mem[2],ymm12[3,4],mem[5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm12 = xmm5[0,1,2,1]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm14 = xmm4[2,1,0,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm14[0,0,0,0,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm12[0,1,2,3,6,5,6,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2,3],xmm7[4],xmm5[5,6],xmm7[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendd $36, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm7 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm7 = ymm2[0,1],mem[2],ymm2[3,4],mem[5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm11 = xmm7[2,1,2,3]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,3,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm7[0,0,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm11[2,1,2,0,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1,2],xmm3[3],xmm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm0[0,1,2],ymm3[3,4,5,6,7],ymm0[8,9,10],ymm3[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0,1,2,3,4],xmm0[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendd $219, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[0,1],ymm0[2],mem[3,4],ymm0[5],mem[6,7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,1,0,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm2[0,0,0,0,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,4,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,6,5,6,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm9 = xmm5[0,1,2,3],xmm0[4],xmm5[5,6],xmm0[7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm8[1,1,0,3,5,5,4,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,4,6,7,8,9,10,11,12,12,14,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm13 = ymm1[0,3,2,3,4,7,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm10 = ymm13[0,0,2,3,4,5,6,7,8,8,10,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm10[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0],ymm10[1,2,3,4],ymm5[5,6],ymm10[7],ymm5[8],ymm10[9,10,11,12],ymm5[13,14],ymm10[15]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendd $36, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm10 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm10 = ymm0[0,1],mem[2],ymm0[3,4],mem[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm10[2,1,2,3]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm6
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,3,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm6[0,0,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,6,6,6]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[2,1,2,0,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm4[1,2],xmm1[3],xmm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm4
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1,2],ymm4[3,4,5,6,7],ymm5[8,9,10],ymm4[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3,4],xmm5[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <6,7,u,u,u,u,u,u,u,u,2,3,14,15,u,u,22,23,u,u,u,u,u,u,u,u,18,19,30,31,u,u>
; AVX2-SLOW-NEXT:    vmovdqu (%rsp), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpshufb %ymm10, %ymm1, %ymm4
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm15[0,1,3,3,4,5,6,7,8,9,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm9[1,2,3,4],ymm4[5,6],ymm9[7],ymm4[8],ymm9[9,10,11,12],ymm4[13,14],ymm9[15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm12[0,1,2,3,7,5,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm14[1,1,1,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm5[4],xmm1[5,6],xmm5[7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm11[3,1,2,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm7[0,1,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0],xmm7[1,2],xmm5[3],xmm7[4,5,6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm4[0,1,2],ymm1[3,4,5,6,7],ymm4[8,9,10],ymm1[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1,2,3,4],xmm4[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,5,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[1,1,1,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4],xmm2[5,6],xmm3[7]
; AVX2-SLOW-NEXT:    vpshufb %ymm10, %ymm8, %ymm3
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm13[0,1,3,3,4,5,6,7,8,9,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1,2,3,4],ymm3[5,6],ymm4[7],ymm3[8],ymm4[9,10,11,12],ymm3[13,14],ymm4[15]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[3,1,2,1,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm6[0,1,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,7,7,7,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm4[1,2],xmm0[3],xmm4[4,5,6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1,2],ymm2[3,4,5,6,7],ymm3[8,9,10],ymm2[11,12,13,14,15]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4],xmm3[5,6,7]
; AVX2-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendd $146, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = ymm1[0],mem[1],ymm1[2,3],mem[4],ymm1[5,6],mem[7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm2[0,1,0,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,6,6,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,u,u,u,u,8,9,u,u,0,1,12,13>
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm3, %xmm6
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1,2,3],xmm6[4],xmm4[5],xmm6[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-SLOW-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm4 = mem[0,1,2,3,4],ymm4[5,6,7]
; AVX2-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-SLOW-NEXT:    vpblendd $109, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm6 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm6 = mem[0],ymm1[1],mem[2,3],ymm1[4],mem[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm7, %xmm5
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[0,3,2,1]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm6[0,1,0,2,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,6,6,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm5[4],xmm1[5],xmm5[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-SLOW-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm1 = mem[0,1,2,3,4],ymm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,u,u,u,u,u,u,u,10,11,u,u,2,3,14,15>
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,1,1,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,3,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4],xmm2[5],xmm3[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm2 = mem[0,1,2,3,4],ymm2[5,6,7]
; AVX2-SLOW-NEXT:    vpshufb %xmm5, %xmm7, %xmm3
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm6[0,1,1,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,1,3,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm3 = xmm5[0,1,2,3],xmm3[4],xmm5[5],xmm3[6,7]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-SLOW-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm3 = mem[0,1,2,3,4],ymm3[5,6,7]
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, 32(%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, 32(%rdx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, (%rdx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm5, (%rcx)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, 32(%r8)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, (%r8)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 32(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm4, (%r9)
; AVX2-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-SLOW-NEXT:    vmovdqa %ymm3, 32(%rax)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, (%rax)
; AVX2-SLOW-NEXT:    addq $520, %rsp # imm = 0x208
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $568, %rsp # imm = 0x238
; AVX2-FAST-NEXT:    vmovdqa 288(%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqa 256(%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %ymm9
; AVX2-FAST-NEXT:    vmovdqa 32(%rdi), %ymm11
; AVX2-FAST-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm2[2,3],ymm3[2,3]
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm2[0,1],ymm3[0,1]
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm1[2,3],ymm0[2,3]
; AVX2-FAST-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vperm2i128 {{.*#+}} ymm7 = ymm1[0,1],ymm0[0,1]
; AVX2-FAST-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,4,5,4,5,4,5,8,9,u,u,8,9,12,13,u,u,20,21,20,21,20,21,24,25,u,u,24,25,28,29>
; AVX2-FAST-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm8 = ymm5[0,1,0,3,4,5,4,7]
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm3 = ymm2[2,1,2,1,6,5,6,5]
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm3[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm2[0],ymm0[1,2,3,4],ymm2[5],ymm0[6,7],ymm2[8],ymm0[9,10,11,12],ymm2[13],ymm0[14,15]
; AVX2-FAST-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm11[0,1],ymm9[2],ymm11[3,4],ymm9[5],ymm11[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm15 = <8,9,u,u,0,1,12,13,u,u,12,13,12,13,14,15>
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm2, %xmm1
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm0
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm0[2,2,2,2,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm6[1],xmm1[2,3],xmm6[4],xmm1[5,6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm10 = [255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm12 = ymm12[0,1,0,3,4,5,4,7]
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm12, %ymm1
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm14 = ymm7[2,1,2,1,6,5,6,5]
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm14[0,1,2,3,6,6,6,6,8,9,10,11,14,14,14,14]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm1[1,2,3,4],ymm4[5],ymm1[6,7],ymm4[8],ymm1[9,10,11,12],ymm4[13],ymm1[14,15]
; AVX2-FAST-NEXT:    vmovdqa 224(%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 192(%rdi), %ymm6
; AVX2-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm1[0,1],ymm6[2],ymm1[3,4],ymm6[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm13, %xmm6
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm1
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm7 = xmm1[2,2,2,2,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0],xmm7[1],xmm6[2,3],xmm7[4],xmm6[5,6,7]
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm6, %ymm4, %ymm4
; AVX2-FAST-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <2,3,u,u,u,u,u,u,u,u,14,15,u,u,u,u,18,19,u,u,u,u,u,u,u,u,30,31,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm15, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm6 = <u,u,6,7,6,7,6,7,8,9,u,u,10,11,14,15,u,u,22,23,22,23,22,23,24,25,u,u,26,27,30,31>
; AVX2-FAST-NEXT:    vpshufb %ymm6, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm7[1,2,3,4],ymm3[5],ymm7[6,7],ymm3[8],ymm7[9,10,11,12],ymm3[13],ymm7[14,15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm7 = <u,u,6,7,u,u,u,u,10,11,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm7, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = <10,11,u,u,2,3,14,15,u,u,10,11,12,13,14,15>
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0],xmm0[1],xmm2[2,3],xmm0[4],xmm2[5,6,7]
; AVX2-FAST-NEXT:    vmovdqa %ymm10, %ymm8
; AVX2-FAST-NEXT:    vpblendvb %ymm10, %ymm0, %ymm3, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm15, %ymm14, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm6, %ymm12, %ymm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm2[1,2,3,4],ymm0[5],ymm2[6,7],ymm0[8],ymm2[9,10,11,12],ymm0[13],ymm2[14,15]
; AVX2-FAST-NEXT:    vpshufb %xmm7, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm13, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm10 = <u,u,u,u,u,u,u,u,u,u,u,u,u,u,12,13,u,u,u,u,16,17,u,u,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0],xmm1[1],xmm2[2,3],xmm1[4],xmm2[5,6,7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm2 = ymm5[2,1,2,1,6,5,6,5]
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendvb %ymm8, %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm10, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,u,u,u,u,u,u,u,u,u,u,8,9,u,u,16,17,20,21,u,u,22,23,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufd $236, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm0 = mem[0,3,2,3,4,7,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm0, %ymm6
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm12 = ymm6[0,1],ymm1[2],ymm6[3,4,5,6],ymm1[7],ymm6[8,9],ymm1[10],ymm6[11,12,13,14],ymm1[15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm9[0],ymm11[1],ymm9[2,3],ymm11[4],ymm9[5,6],ymm11[7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm0 = xmm7[2,1,0,3]
; AVX2-FAST-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = <0,1,12,13,u,u,4,5,u,u,u,u,12,13,14,15>
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm3, %xmm1
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm14 = <u,u,u,u,0,1,u,u,8,9,12,13,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm0, %xmm5
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm5[2],xmm1[3],xmm5[4,5],xmm1[6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm12[3,4,5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovdqa 160(%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm2[0,1],ymm0[2],ymm2[3,4],ymm0[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm12 = xmm5[u,u,u,u,u,u,4,5,u,u,u,u,8,9,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm5, %xmm7
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[0,1,4,5,4,5,u,u,0,1,12,13,u,u,4,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm15[0,1,2],xmm12[3],xmm15[4,5],xmm12[6],xmm15[7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm1[0,1,2],ymm4[3,4,5,6,7],ymm1[8,9,10],ymm4[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm4 = ymm13[2,1,2,1,6,5,6,5]
; AVX2-FAST-NEXT:    vpshufb %ymm10, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm6[0,3,2,3,4,7,6,7]
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm15, %ymm12
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm12[0,1],ymm1[2],ymm12[3,4,5,6],ymm1[7],ymm12[8,9],ymm1[10],ymm12[11,12,13,14],ymm1[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendd $146, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm12 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm12 = ymm0[0],mem[1],ymm0[2,3],mem[4],ymm0[5,6],mem[7]
; AVX2-FAST-NEXT:    vpshufb %xmm9, %xmm12, %xmm9
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm12, %xmm11
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm11 = xmm11[2,1,0,3]
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm11, %xmm8
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm8 = xmm9[0,1],xmm8[2],xmm9[3],xmm8[4,5],xmm9[6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2],ymm1[3,4,5],ymm8[6,7]
; AVX2-FAST-NEXT:    vmovdqa 352(%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovdqa 320(%rdi), %ymm10
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1],ymm1[2],ymm10[3,4],ymm1[5],ymm10[6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa %ymm1, %ymm9
; AVX2-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,u,u,u,4,5,u,u,u,u,8,9,u,u]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm14 = xmm1[0,1,4,5,4,5,u,u,0,1,12,13,u,u,4,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm14[0,1,2],xmm2[3],xmm14[4,5],xmm2[6],xmm14[7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm8[0,1,2],ymm2[3,4,5,6,7],ymm8[8,9,10],ymm2[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm8[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = <u,u,u,u,u,u,u,u,u,u,u,u,10,11,u,u,18,19,22,23,u,u,22,23,u,u,u,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm15, %ymm14
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm4[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm15 = ymm14[0,1],ymm4[2],ymm14[3,4,5,6],ymm4[7],ymm14[8,9],ymm4[10],ymm14[11,12,13,14],ymm4[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm14 = <2,3,14,15,u,u,6,7,u,u,u,u,12,13,14,15>
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm12, %xmm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm12 = <u,u,u,u,2,3,u,u,10,11,14,15,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm11, %xmm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0,1],xmm2[2],xmm4[3],xmm2[4,5],xmm4[6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2],ymm15[3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = <6,7,2,3,4,5,u,u,2,3,14,15,u,u,6,7>
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[3],xmm1[4,5],xmm0[6],xmm1[7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7],ymm2[8,9,10],ymm0[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm7, %xmm0
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm2 = xmm5[0,1,2,3,5,5,5,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm2[3],xmm0[4,5],xmm2[6],xmm0[7]
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm3, %xmm2
; AVX2-FAST-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FAST-NEXT:    vpshufb %xmm12, %xmm1, %xmm3
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2],xmm2[3],xmm3[4,5],xmm2[6,7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm8, %ymm1, %ymm3
; AVX2-FAST-NEXT:    vpshuflw $85, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[1,1,1,1,4,5,6,7,9,9,9,9,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4,5,6],ymm4[7],ymm3[8,9],ymm4[10],ymm3[11,12,13,14],ymm4[15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2],ymm3[3,4,5],ymm2[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7],ymm2[8,9,10],ymm0[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} ymm15 = ymm13[0,3,2,3,4,7,6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm7 = <4,5,u,u,u,u,u,u,u,u,0,1,12,13,u,u,20,21,u,u,u,u,u,u,u,u,16,17,28,29,u,u>
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm12 = <u,u,0,1,4,5,6,7,8,9,u,u,u,u,8,9,u,u,16,17,20,21,22,23,24,25,u,u,u,u,24,25>
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm15, %ymm6
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm6[1,2,3,4],ymm4[5,6],ymm6[7],ymm4[8],ymm6[9,10,11,12],ymm4[13,14],ymm6[15]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1],ymm10[2],ymm9[3,4],ymm10[5],ymm9[6,7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[2,1,0,3]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm13 = xmm6[0,1,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm14 = <0,1,0,1,0,1,0,1,u,u,8,9,12,13,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm8, %xmm6
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,6,5,6,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm6[0,1,2,3],xmm0[4],xmm6[5,6],xmm0[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendd $36, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm6 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm6 = ymm1[0,1],mem[2],ymm1[3,4],mem[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm6, %xmm5
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[0,3,2,1]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm6 = xmm6[2,1,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = <u,u,0,1,4,5,u,u,12,13,12,13,12,13,12,13>
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm5, %xmm2
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm6[2,1,2,0,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0],xmm2[1,2],xmm3[3],xmm2[4,5,6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm4[0,1,2],ymm0[3,4,5,6,7],ymm4[8,9,10],ymm0[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3,4],xmm4[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm7, %ymm9, %ymm0
; AVX2-FAST-NEXT:    vpshufd $236, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm10 = mem[0,3,2,3,4,7,6,7]
; AVX2-FAST-NEXT:    vpshufb %ymm12, %ymm10, %ymm3
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm3[1,2,3,4],ymm0[5,6],ymm3[7],ymm0[8],ymm3[9,10,11,12],ymm0[13,14],ymm3[15]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendd $36, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm3 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm3 = ymm11[0,1],mem[2],ymm11[3,4],mem[5],ymm11[6,7]
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm12 = xmm3[2,1,0,3]
; AVX2-FAST-NEXT:    vpshufb %xmm14, %xmm12, %xmm2
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm4 = xmm3[0,1,2,3,6,5,6,4]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm14 = xmm2[0,1,2,3],xmm4[4],xmm2[5,6],xmm4[7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendd $219, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[0,1],ymm2[2],mem[3,4],ymm2[5],mem[6,7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm7
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,3,2,1]
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm7, %xmm2
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,1,2,3]
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm4[2,1,2,0,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1,2],xmm1[3],xmm2[4,5,6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm0[0,1,2],ymm2[3,4,5,6,7],ymm0[8,9,10],ymm2[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3,4],xmm0[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <6,7,u,u,u,u,u,u,u,u,2,3,14,15,u,u,22,23,u,u,u,u,u,u,u,u,18,19,30,31,u,u>
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpshufb %ymm1, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm14 = <u,u,2,3,6,7,6,7,10,11,u,u,u,u,10,11,u,u,18,19,22,23,22,23,26,27,u,u,u,u,26,27>
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm15, %ymm15
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm15[1,2,3,4],ymm2[5,6],ymm15[7],ymm2[8],ymm15[9,10,11,12],ymm2[13,14],ymm15[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm15 = <2,3,2,3,2,3,2,3,u,u,10,11,14,15,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm8, %xmm8
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm13[0,1,2,3,7,5,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm8[0,1,2,3],xmm0[4],xmm8[5,6],xmm0[7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = <u,u,2,3,6,7,u,u,14,15,14,15,14,15,14,15>
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm5, %xmm5
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm6 = xmm6[3,1,2,1,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0],xmm5[1,2],xmm6[3],xmm5[4,5,6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7],ymm2[8,9,10],ymm0[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0,1,2,3,4],xmm2[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FAST-NEXT:    vpshufb %ymm1, %ymm9, %ymm1
; AVX2-FAST-NEXT:    vpshufb %ymm14, %ymm10, %ymm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm1 = ymm1[0],ymm2[1,2,3,4],ymm1[5,6],ymm2[7],ymm1[8],ymm2[9,10,11,12],ymm1[13,14],ymm2[15]
; AVX2-FAST-NEXT:    vpshufb %xmm15, %xmm12, %xmm2
; AVX2-FAST-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,5,6,5]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4],xmm2[5,6],xmm3[7]
; AVX2-FAST-NEXT:    vpshufb %xmm8, %xmm7, %xmm3
; AVX2-FAST-NEXT:    vpshuflw {{.*#+}} xmm4 = xmm4[3,1,2,1,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0],xmm3[1,2],xmm4[3],xmm3[4,5,6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm1[0,1,2],ymm2[3,4,5,6,7],ymm1[8,9,10],ymm2[11,12,13,14,15]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0,1,2,3,4],xmm1[5,6,7]
; AVX2-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FAST-NEXT:    vpblendd $109, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm2 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm2 = mem[0],ymm11[1],mem[2,3],ymm11[4],mem[5,6],ymm11[7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm4 = <u,u,u,u,u,u,u,u,8,9,u,u,0,1,12,13>
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm3, %xmm5
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = <0,1,2,3,0,1,4,5,u,u,12,13,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm2, %xmm7
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm5 = xmm7[0,1,2,3],xmm5[4],xmm7[5],xmm5[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FAST-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm5 = mem[0,1,2,3,4],ymm5[5,6,7]
; AVX2-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vpblendd $109, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm7 = mem[0],ymm0[1],mem[2,3],ymm0[4],mem[5,6],ymm0[7]
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm7, %xmm0
; AVX2-FAST-NEXT:    vpshufb %xmm4, %xmm0, %xmm4
; AVX2-FAST-NEXT:    vpshufd {{.*#+}} xmm7 = xmm7[0,3,2,1]
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm7, %xmm6
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm4 = xmm6[0,1,2,3],xmm4[4],xmm6[5],xmm4[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FAST-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm4 = mem[0,1,2,3,4],ymm4[5,6,7]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = <u,u,u,u,u,u,u,u,10,11,u,u,2,3,14,15>
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = <0,1,2,3,2,3,6,7,u,u,14,15,u,u,u,u>
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4],xmm2[5],xmm3[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm2 = mem[0,1,2,3,4],ymm2[5,6,7]
; AVX2-FAST-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpshufb %xmm1, %xmm7, %xmm1
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3],xmm0[4],xmm1[5],xmm0[6,7]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpblendd $31, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FAST-NEXT:    # ymm0 = mem[0,1,2,3,4],ymm0[5,6,7]
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-FAST-NEXT:    vmovdqa %ymm13, 32(%r8)
; AVX2-FAST-NEXT:    vmovdqa %ymm8, (%r8)
; AVX2-FAST-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FAST-NEXT:    vmovdqa %ymm0, 32(%rax)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, (%rax)
; AVX2-FAST-NEXT:    addq $568, %rsp # imm = 0x238
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqu64 (%rdi), %zmm3
; AVX512-NEXT:    vmovdqu64 64(%rdi), %zmm5
; AVX512-NEXT:    vmovdqu64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqu64 192(%rdi), %zmm4
; AVX512-NEXT:    vmovdqu64 320(%rdi), %zmm0
; AVX512-NEXT:    vmovdqu64 256(%rdi), %zmm1
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,0,0,0,0,0,4,10,16,22,28,34,40,46,52,58,0,0,0,0,0,0,4,10,16,22,28,34,40,46,52,58]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm0, %zmm1, %zmm7
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,6,12,18,24,30,0,0,0,0,0,34,40,46,52,58,0,6,12,18,24,30,0,0,0,0,0,34,40,46,52,58]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm2, %zmm4, %zmm8
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm6 = <0,6,12,18,24,30,36,42,48,54,60,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm5, %zmm3, %zmm6
; AVX512-NEXT:    movl $4192256, %edi # imm = 0x3FF800
; AVX512-NEXT:    kmovd %edi, %k1
; AVX512-NEXT:    vmovdqu16 %zmm8, %zmm6 {%k1}
; AVX512-NEXT:    movw $-2048, %di # imm = 0xF800
; AVX512-NEXT:    kmovd %edi, %k2
; AVX512-NEXT:    vmovdqa32 %zmm7, %zmm6 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,0,0,0,5,11,17,23,29,35,41,47,53,59,0,0,0,0,0,0,5,11,17,23,29,35,41,47,53,59]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm0, %zmm1, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [1,7,13,19,25,31,0,0,0,0,0,35,41,47,53,59,1,7,13,19,25,31,0,0,0,0,0,35,41,47,53,59]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm2, %zmm4, %zmm9
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm7 = <1,7,13,19,25,31,37,43,49,55,61,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm5, %zmm3, %zmm7
; AVX512-NEXT:    vmovdqu16 %zmm9, %zmm7 {%k1}
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm7 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,0,0,0,6,12,18,24,30,36,42,48,54,60,0,0,0,0,0,0,6,12,18,24,30,36,42,48,54,60]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm0, %zmm1, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [34,40,46,52,58,0,0,0,0,0,0,4,10,16,22,28,34,40,46,52,58,0,0,0,0,0,0,4,10,16,22,28]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm4, %zmm2, %zmm9
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm10 = <34,40,46,52,58,0,6,12,18,24,30,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm3, %zmm5, %zmm10
; AVX512-NEXT:    movl $2095104, %edi # imm = 0x1FF800
; AVX512-NEXT:    kmovd %edi, %k2
; AVX512-NEXT:    vmovdqu16 %zmm9, %zmm10 {%k2}
; AVX512-NEXT:    movl $-2097152, %edi # imm = 0xFFE00000
; AVX512-NEXT:    kmovd %edi, %k1
; AVX512-NEXT:    vmovdqu16 %zmm8, %zmm10 {%k1}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,0,0,1,7,13,19,25,31,37,43,49,55,61,0,0,0,0,0,1,7,13,19,25,31,37,43,49,55,61]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm0, %zmm1, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [35,41,47,53,59,0,0,0,0,0,0,5,11,17,23,29,35,41,47,53,59,0,0,0,0,0,0,5,11,17,23,29]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm4, %zmm2, %zmm9
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm11 = <35,41,47,53,59,1,7,13,19,25,31,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm3, %zmm5, %zmm11
; AVX512-NEXT:    vmovdqu16 %zmm9, %zmm11 {%k2}
; AVX512-NEXT:    vmovdqu16 %zmm8, %zmm11 {%k1}
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = <4,10,16,22,28,34,40,46,52,58,u,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm5, %zmm3, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [36,42,48,54,60,0,0,0,0,0,0,6,12,18,24,30,36,42,48,54,60,0,0,0,0,0,0,6,12,18,24,30]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm4, %zmm2, %zmm9
; AVX512-NEXT:    movw $31, %di
; AVX512-NEXT:    kmovd %edi, %k2
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm9 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,0,0,0,0,34,40,46,52,58,0,6,12,18,24,30,0,0,0,0,0,34,40,46,52,58,0,6,12,18,24,30]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm1, %zmm0, %zmm8
; AVX512-NEXT:    vmovdqu16 %zmm8, %zmm9 {%k1}
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = <5,11,17,23,29,35,41,47,53,59,u,u,u,u,u,u>
; AVX512-NEXT:    vpermi2w %zmm5, %zmm3, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [37,43,49,55,61,0,0,0,0,0,1,7,13,19,25,31,37,43,49,55,61,0,0,0,0,0,1,7,13,19,25,31]
; AVX512-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm4, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqa32 %zmm8, %zmm3 {%k2}
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,0,0,0,0,35,41,47,53,59,1,7,13,19,25,31,0,0,0,0,0,35,41,47,53,59,1,7,13,19,25,31]
; AVX512-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512-NEXT:    vmovdqu64 %zmm6, (%rsi)
; AVX512-NEXT:    vmovdqu64 %zmm7, (%rdx)
; AVX512-NEXT:    vmovdqu64 %zmm10, (%rcx)
; AVX512-NEXT:    vmovdqu64 %zmm11, (%r8)
; AVX512-NEXT:    vmovdqu64 %zmm9, (%r9)
; AVX512-NEXT:    vmovdqu64 %zmm3, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <192 x i16>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <192 x i16> %wide.vec, <192 x i16> poison, <32 x i32> <i32 0, i32 6, i32 12, i32 18, i32 24, i32 30, i32 36, i32 42, i32 48, i32 54, i32 60, i32 66, i32 72, i32 78, i32 84, i32 90, i32 96, i32 102, i32 108, i32 114, i32 120, i32 126, i32 132, i32 138, i32 144, i32 150, i32 156, i32 162, i32 168, i32 174, i32 180, i32 186>
  %strided.vec1 = shufflevector <192 x i16> %wide.vec, <192 x i16> poison, <32 x i32> <i32 1, i32 7, i32 13, i32 19, i32 25, i32 31, i32 37, i32 43, i32 49, i32 55, i32 61, i32 67, i32 73, i32 79, i32 85, i32 91, i32 97, i32 103, i32 109, i32 115, i32 121, i32 127, i32 133, i32 139, i32 145, i32 151, i32 157, i32 163, i32 169, i32 175, i32 181, i32 187>
  %strided.vec2 = shufflevector <192 x i16> %wide.vec, <192 x i16> poison, <32 x i32> <i32 2, i32 8, i32 14, i32 20, i32 26, i32 32, i32 38, i32 44, i32 50, i32 56, i32 62, i32 68, i32 74, i32 80, i32 86, i32 92, i32 98, i32 104, i32 110, i32 116, i32 122, i32 128, i32 134, i32 140, i32 146, i32 152, i32 158, i32 164, i32 170, i32 176, i32 182, i32 188>
  %strided.vec3 = shufflevector <192 x i16> %wide.vec, <192 x i16> poison, <32 x i32> <i32 3, i32 9, i32 15, i32 21, i32 27, i32 33, i32 39, i32 45, i32 51, i32 57, i32 63, i32 69, i32 75, i32 81, i32 87, i32 93, i32 99, i32 105, i32 111, i32 117, i32 123, i32 129, i32 135, i32 141, i32 147, i32 153, i32 159, i32 165, i32 171, i32 177, i32 183, i32 189>
  %strided.vec4 = shufflevector <192 x i16> %wide.vec, <192 x i16> poison, <32 x i32> <i32 4, i32 10, i32 16, i32 22, i32 28, i32 34, i32 40, i32 46, i32 52, i32 58, i32 64, i32 70, i32 76, i32 82, i32 88, i32 94, i32 100, i32 106, i32 112, i32 118, i32 124, i32 130, i32 136, i32 142, i32 148, i32 154, i32 160, i32 166, i32 172, i32 178, i32 184, i32 190>
  %strided.vec5 = shufflevector <192 x i16> %wide.vec, <192 x i16> poison, <32 x i32> <i32 5, i32 11, i32 17, i32 23, i32 29, i32 35, i32 41, i32 47, i32 53, i32 59, i32 65, i32 71, i32 77, i32 83, i32 89, i32 95, i32 101, i32 107, i32 113, i32 119, i32 125, i32 131, i32 137, i32 143, i32 149, i32 155, i32 161, i32 167, i32 173, i32 179, i32 185, i32 191>

  store <32 x i16> %strided.vec0, ptr %out.vec0, align 32
  store <32 x i16> %strided.vec1, ptr %out.vec1, align 32
  store <32 x i16> %strided.vec2, ptr %out.vec2, align 32
  store <32 x i16> %strided.vec3, ptr %out.vec3, align 32
  store <32 x i16> %strided.vec4, ptr %out.vec4, align 32
  store <32 x i16> %strided.vec5, ptr %out.vec5, align 32

  ret void
}
