/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LifeEventTile
extends AbstractTile
implements TileWithUpdateStairs {
    private final LifeEvent lifeEvent;
    private final TileArguments tileArguments;
    private final LivingSpace livingSpace;
    private final Rose skin;
    private final ISkinParam skinParam;

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        this.livingSpace.addStepForLivebox(this.getEvent(), y);
    }

    @Override
    public Event getEvent() {
        return this.lifeEvent;
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        return 0.0;
    }

    public LifeEventTile(LifeEvent lifeEvent, TileArguments tileArguments, LivingSpace livingSpace, Rose skin, ISkinParam skinParam) {
        this.lifeEvent = lifeEvent;
        this.tileArguments = tileArguments;
        this.livingSpace = livingSpace;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.isDestroyWithoutMessage()) {
            Component cross = this.skin.createComponent(null, ComponentType.DESTROY, null, this.skinParam, null);
            Dimension2D dimCross = cross.getPreferredDimension(ug.getStringBounder());
            double x = this.livingSpace.getPosC(ug.getStringBounder()).getCurrentValue();
            cross.drawU(ug.apply(new UTranslate(x - dimCross.getWidth() / 2.0, 0.0)), null, (Context2D)((Object)ug));
        }
    }

    public boolean isDestroyWithoutMessage() {
        return this.lifeEvent.getMessage() == null && this.lifeEvent.getType() == LifeEventType.DESTROY;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        if (this.isDestroyWithoutMessage()) {
            Component cross = this.skin.createComponent(null, ComponentType.DESTROY, null, this.skinParam, null);
            Dimension2D dimCross = cross.getPreferredDimension(stringBounder);
            return dimCross.getHeight();
        }
        return 0.0;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.livingSpace.getPosB();
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return RealUtils.max(this.livingSpace.getPosD(stringBounder), this.livingSpace.getPosC2(stringBounder));
    }
}

