// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/pipeline_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Runtime operation information for
// [PipelineService.BatchCancelPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.BatchCancelPipelineJobs].
type BatchCancelPipelineJobsOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *BatchCancelPipelineJobsOperationMetadata) Reset() {
	*x = BatchCancelPipelineJobsOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCancelPipelineJobsOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCancelPipelineJobsOperationMetadata) ProtoMessage() {}

func (x *BatchCancelPipelineJobsOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCancelPipelineJobsOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchCancelPipelineJobsOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{0}
}

func (x *BatchCancelPipelineJobsOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [PipelineService.CreateTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.CreateTrainingPipeline].
type CreateTrainingPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the TrainingPipeline
	// in. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The TrainingPipeline to create.
	TrainingPipeline *TrainingPipeline `protobuf:"bytes,2,opt,name=training_pipeline,json=trainingPipeline,proto3" json:"training_pipeline,omitempty"`
}

func (x *CreateTrainingPipelineRequest) Reset() {
	*x = CreateTrainingPipelineRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTrainingPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTrainingPipelineRequest) ProtoMessage() {}

func (x *CreateTrainingPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTrainingPipelineRequest.ProtoReflect.Descriptor instead.
func (*CreateTrainingPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateTrainingPipelineRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTrainingPipelineRequest) GetTrainingPipeline() *TrainingPipeline {
	if x != nil {
		return x.TrainingPipeline
	}
	return nil
}

// Request message for
// [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.GetTrainingPipeline].
type GetTrainingPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TrainingPipeline resource.
	// Format:
	// `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTrainingPipelineRequest) Reset() {
	*x = GetTrainingPipelineRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTrainingPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrainingPipelineRequest) ProtoMessage() {}

func (x *GetTrainingPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrainingPipelineRequest.ProtoReflect.Descriptor instead.
func (*GetTrainingPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetTrainingPipelineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [PipelineService.ListTrainingPipelines][google.cloud.aiplatform.v1beta1.PipelineService.ListTrainingPipelines].
type ListTrainingPipelinesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list the TrainingPipelines
	// from. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list filter.
	//
	// Supported fields:
	//
	//   - `display_name` supports `=`, `!=` comparisons, and `:` wildcard.
	//   - `state` supports `=`, `!=` comparisons.
	//   - `training_task_definition` `=`, `!=` comparisons, and `:` wildcard.
	//   - `create_time` supports `=`, `!=`,`<`, `<=`,`>`, `>=` comparisons.
	//     `create_time` must be in RFC 3339 format.
	//   - `labels` supports general map functions that is:
	//     `labels.key=value` - key:value equality
	//     `labels.key:* - key existence
	//
	// Some examples of using the filter are:
	//
	//   - `state="PIPELINE_STATE_SUCCEEDED" AND display_name:"my_pipeline_*"`
	//   - `state!="PIPELINE_STATE_FAILED" OR display_name="my_pipeline"`
	//   - `NOT display_name="my_pipeline"`
	//   - `create_time>"2021-05-18T00:00:00Z"`
	//   - `training_task_definition:"*automl_text_classification*"`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	// Typically obtained via
	// [ListTrainingPipelinesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListTrainingPipelinesResponse.next_page_token]
	// of the previous
	// [PipelineService.ListTrainingPipelines][google.cloud.aiplatform.v1beta1.PipelineService.ListTrainingPipelines]
	// call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListTrainingPipelinesRequest) Reset() {
	*x = ListTrainingPipelinesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTrainingPipelinesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTrainingPipelinesRequest) ProtoMessage() {}

func (x *ListTrainingPipelinesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTrainingPipelinesRequest.ProtoReflect.Descriptor instead.
func (*ListTrainingPipelinesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListTrainingPipelinesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTrainingPipelinesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTrainingPipelinesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTrainingPipelinesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTrainingPipelinesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [PipelineService.ListTrainingPipelines][google.cloud.aiplatform.v1beta1.PipelineService.ListTrainingPipelines]
type ListTrainingPipelinesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of TrainingPipelines in the requested page.
	TrainingPipelines []*TrainingPipeline `protobuf:"bytes,1,rep,name=training_pipelines,json=trainingPipelines,proto3" json:"training_pipelines,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListTrainingPipelinesRequest.page_token][google.cloud.aiplatform.v1beta1.ListTrainingPipelinesRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTrainingPipelinesResponse) Reset() {
	*x = ListTrainingPipelinesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTrainingPipelinesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTrainingPipelinesResponse) ProtoMessage() {}

func (x *ListTrainingPipelinesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTrainingPipelinesResponse.ProtoReflect.Descriptor instead.
func (*ListTrainingPipelinesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListTrainingPipelinesResponse) GetTrainingPipelines() []*TrainingPipeline {
	if x != nil {
		return x.TrainingPipelines
	}
	return nil
}

func (x *ListTrainingPipelinesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [PipelineService.DeleteTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.DeleteTrainingPipeline].
type DeleteTrainingPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TrainingPipeline resource to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTrainingPipelineRequest) Reset() {
	*x = DeleteTrainingPipelineRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTrainingPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTrainingPipelineRequest) ProtoMessage() {}

func (x *DeleteTrainingPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTrainingPipelineRequest.ProtoReflect.Descriptor instead.
func (*DeleteTrainingPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteTrainingPipelineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [PipelineService.CancelTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.CancelTrainingPipeline].
type CancelTrainingPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TrainingPipeline to cancel.
	// Format:
	// `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelTrainingPipelineRequest) Reset() {
	*x = CancelTrainingPipelineRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelTrainingPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelTrainingPipelineRequest) ProtoMessage() {}

func (x *CancelTrainingPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelTrainingPipelineRequest.ProtoReflect.Descriptor instead.
func (*CancelTrainingPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{6}
}

func (x *CancelTrainingPipelineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [PipelineService.CreatePipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.CreatePipelineJob].
type CreatePipelineJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the PipelineJob in.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The PipelineJob to create.
	PipelineJob *PipelineJob `protobuf:"bytes,2,opt,name=pipeline_job,json=pipelineJob,proto3" json:"pipeline_job,omitempty"`
	// The ID to use for the PipelineJob, which will become the final component of
	// the PipelineJob name. If not provided, an ID will be automatically
	// generated.
	//
	// This value should be less than 128 characters, and valid characters
	// are `/[a-z][0-9]-/`.
	PipelineJobId string `protobuf:"bytes,3,opt,name=pipeline_job_id,json=pipelineJobId,proto3" json:"pipeline_job_id,omitempty"`
}

func (x *CreatePipelineJobRequest) Reset() {
	*x = CreatePipelineJobRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePipelineJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePipelineJobRequest) ProtoMessage() {}

func (x *CreatePipelineJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePipelineJobRequest.ProtoReflect.Descriptor instead.
func (*CreatePipelineJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreatePipelineJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePipelineJobRequest) GetPipelineJob() *PipelineJob {
	if x != nil {
		return x.PipelineJob
	}
	return nil
}

func (x *CreatePipelineJobRequest) GetPipelineJobId() string {
	if x != nil {
		return x.PipelineJobId
	}
	return ""
}

// Request message for
// [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.GetPipelineJob].
type GetPipelineJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PipelineJob resource.
	// Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPipelineJobRequest) Reset() {
	*x = GetPipelineJobRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPipelineJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPipelineJobRequest) ProtoMessage() {}

func (x *GetPipelineJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPipelineJobRequest.ProtoReflect.Descriptor instead.
func (*GetPipelineJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetPipelineJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [PipelineService.ListPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.ListPipelineJobs].
type ListPipelineJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list the PipelineJobs from.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the PipelineJobs that match the filter expression. The following
	// fields are supported:
	//
	//   - `pipeline_name`: Supports `=` and `!=` comparisons.
	//   - `display_name`: Supports `=`, `!=` comparisons, and `:` wildcard.
	//   - `pipeline_job_user_id`: Supports `=`, `!=` comparisons, and `:` wildcard.
	//     for example, can check if pipeline's display_name contains *step* by
	//     doing display_name:\"*step*\"
	//   - `state`: Supports `=` and `!=` comparisons.
	//   - `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
	//     Values must be in RFC 3339 format.
	//   - `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
	//     Values must be in RFC 3339 format.
	//   - `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
	//     Values must be in RFC 3339 format.
	//   - `labels`: Supports key-value equality and key presence.
	//   - `template_uri`: Supports `=`, `!=` comparisons, and `:` wildcard.
	//   - `template_metadata.version`: Supports `=`, `!=` comparisons, and `:`
	//     wildcard.
	//
	// Filter expressions can be combined together using logical operators
	// (`AND` & `OR`).
	// For example: `pipeline_name="test" AND create_time>"2020-05-18T13:30:00Z"`.
	//
	// The syntax to define filter expression is based on
	// https://google.aip.dev/160.
	//
	// Examples:
	//
	//   - `create_time>"2021-05-18T00:00:00Z" OR
	//     update_time>"2020-05-18T00:00:00Z"` PipelineJobs created or updated
	//     after 2020-05-18 00:00:00 UTC.
	//   - `labels.env = "prod"`
	//     PipelineJobs with label "env" set to "prod".
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	// Typically obtained via
	// [ListPipelineJobsResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListPipelineJobsResponse.next_page_token]
	// of the previous
	// [PipelineService.ListPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.ListPipelineJobs]
	// call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A comma-separated list of fields to order by. The default sort order is in
	// ascending order. Use "desc" after a field name for descending. You can have
	// multiple order_by fields provided e.g. "create_time desc, end_time",
	// "end_time, start_time, update_time" For example, using "create_time desc,
	// end_time" will order results by create time in descending order, and if
	// there are multiple jobs having the same create time, order them by the end
	// time in ascending order. if order_by is not specified, it will order by
	// default order is create time in descending order. Supported fields:
	//
	//   - `create_time`
	//   - `update_time`
	//   - `end_time`
	//   - `start_time`
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListPipelineJobsRequest) Reset() {
	*x = ListPipelineJobsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPipelineJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPipelineJobsRequest) ProtoMessage() {}

func (x *ListPipelineJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPipelineJobsRequest.ProtoReflect.Descriptor instead.
func (*ListPipelineJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListPipelineJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPipelineJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPipelineJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPipelineJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPipelineJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListPipelineJobsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [PipelineService.ListPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.ListPipelineJobs]
type ListPipelineJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of PipelineJobs in the requested page.
	PipelineJobs []*PipelineJob `protobuf:"bytes,1,rep,name=pipeline_jobs,json=pipelineJobs,proto3" json:"pipeline_jobs,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListPipelineJobsRequest.page_token][google.cloud.aiplatform.v1beta1.ListPipelineJobsRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPipelineJobsResponse) Reset() {
	*x = ListPipelineJobsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPipelineJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPipelineJobsResponse) ProtoMessage() {}

func (x *ListPipelineJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPipelineJobsResponse.ProtoReflect.Descriptor instead.
func (*ListPipelineJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListPipelineJobsResponse) GetPipelineJobs() []*PipelineJob {
	if x != nil {
		return x.PipelineJobs
	}
	return nil
}

func (x *ListPipelineJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [PipelineService.DeletePipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.DeletePipelineJob].
type DeletePipelineJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PipelineJob resource to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePipelineJobRequest) Reset() {
	*x = DeletePipelineJobRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePipelineJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePipelineJobRequest) ProtoMessage() {}

func (x *DeletePipelineJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePipelineJobRequest.ProtoReflect.Descriptor instead.
func (*DeletePipelineJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{11}
}

func (x *DeletePipelineJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [PipelineService.BatchDeletePipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.BatchDeletePipelineJobs].
type BatchDeletePipelineJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PipelineJobs' parent resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names of the PipelineJobs to delete.
	// A maximum of 32 PipelineJobs can be deleted in a batch.
	// Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchDeletePipelineJobsRequest) Reset() {
	*x = BatchDeletePipelineJobsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchDeletePipelineJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeletePipelineJobsRequest) ProtoMessage() {}

func (x *BatchDeletePipelineJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeletePipelineJobsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeletePipelineJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{12}
}

func (x *BatchDeletePipelineJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeletePipelineJobsRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Response message for
// [PipelineService.BatchDeletePipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.BatchDeletePipelineJobs].
type BatchDeletePipelineJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PipelineJobs deleted.
	PipelineJobs []*PipelineJob `protobuf:"bytes,1,rep,name=pipeline_jobs,json=pipelineJobs,proto3" json:"pipeline_jobs,omitempty"`
}

func (x *BatchDeletePipelineJobsResponse) Reset() {
	*x = BatchDeletePipelineJobsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchDeletePipelineJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeletePipelineJobsResponse) ProtoMessage() {}

func (x *BatchDeletePipelineJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeletePipelineJobsResponse.ProtoReflect.Descriptor instead.
func (*BatchDeletePipelineJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{13}
}

func (x *BatchDeletePipelineJobsResponse) GetPipelineJobs() []*PipelineJob {
	if x != nil {
		return x.PipelineJobs
	}
	return nil
}

// Request message for
// [PipelineService.CancelPipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.CancelPipelineJob].
type CancelPipelineJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PipelineJob to cancel.
	// Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelPipelineJobRequest) Reset() {
	*x = CancelPipelineJobRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelPipelineJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelPipelineJobRequest) ProtoMessage() {}

func (x *CancelPipelineJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelPipelineJobRequest.ProtoReflect.Descriptor instead.
func (*CancelPipelineJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{14}
}

func (x *CancelPipelineJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [PipelineService.BatchCancelPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.BatchCancelPipelineJobs].
type BatchCancelPipelineJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PipelineJobs' parent resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names of the PipelineJobs to cancel.
	// A maximum of 32 PipelineJobs can be cancelled in a batch.
	// Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchCancelPipelineJobsRequest) Reset() {
	*x = BatchCancelPipelineJobsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCancelPipelineJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCancelPipelineJobsRequest) ProtoMessage() {}

func (x *BatchCancelPipelineJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCancelPipelineJobsRequest.ProtoReflect.Descriptor instead.
func (*BatchCancelPipelineJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{15}
}

func (x *BatchCancelPipelineJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCancelPipelineJobsRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Response message for
// [PipelineService.BatchCancelPipelineJobs][google.cloud.aiplatform.v1beta1.PipelineService.BatchCancelPipelineJobs].
type BatchCancelPipelineJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PipelineJobs cancelled.
	PipelineJobs []*PipelineJob `protobuf:"bytes,1,rep,name=pipeline_jobs,json=pipelineJobs,proto3" json:"pipeline_jobs,omitempty"`
}

func (x *BatchCancelPipelineJobsResponse) Reset() {
	*x = BatchCancelPipelineJobsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCancelPipelineJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCancelPipelineJobsResponse) ProtoMessage() {}

func (x *BatchCancelPipelineJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCancelPipelineJobsResponse.ProtoReflect.Descriptor instead.
func (*BatchCancelPipelineJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP(), []int{16}
}

func (x *BatchCancelPipelineJobsResponse) GetPipelineJobs() []*PipelineJob {
	if x != nil {
		return x.PipelineJobs
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_pipeline_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90,
	0x01, 0x0a, 0x28, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xc7, 0x01, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x64, 0x0a, 0x1a, 0x47,
	0x65, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xee, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xa9, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x12, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x52, 0x11, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x67,
	0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x67, 0x0a, 0x1d, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xdb, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x54, 0x0a, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x22, 0x5a,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x84, 0x02, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x95, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51,
	0x0a, 0x0d, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5d, 0x0a, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xac, 0x01, 0x0a, 0x1e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x12, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x43, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x74, 0x0a, 0x1f, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0d, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52,
	0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x22, 0x5d, 0x0a,
	0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xac, 0x01, 0x0a,
	0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x74, 0x0a, 0x1f, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51,
	0x0a, 0x0d, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x73, 0x32, 0xbd, 0x16, 0x0a, 0x0f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xfd, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x22, 0x70, 0xda, 0x41, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x11, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0xd0, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x49, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0xf5,
	0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x53, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xef,
	0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x22, 0x71, 0xda,
	0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x0c, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73,
	0x12, 0xbc, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xcf, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62,
	0x73, 0x12, 0xe6, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x77, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x94, 0x02, 0x0a, 0x17, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0xca, 0x41, 0x3a, 0x0a, 0x1f, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0xb6, 0x01, 0x0a, 0x11, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xa5, 0x02, 0x0a, 0x17, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa9, 0x01, 0xca, 0x41, 0x4b, 0x0a, 0x1f, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22,
	0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xeb, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x14, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_goTypes = []any{
	(*BatchCancelPipelineJobsOperationMetadata)(nil), // 0: google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsOperationMetadata
	(*CreateTrainingPipelineRequest)(nil),            // 1: google.cloud.aiplatform.v1beta1.CreateTrainingPipelineRequest
	(*GetTrainingPipelineRequest)(nil),               // 2: google.cloud.aiplatform.v1beta1.GetTrainingPipelineRequest
	(*ListTrainingPipelinesRequest)(nil),             // 3: google.cloud.aiplatform.v1beta1.ListTrainingPipelinesRequest
	(*ListTrainingPipelinesResponse)(nil),            // 4: google.cloud.aiplatform.v1beta1.ListTrainingPipelinesResponse
	(*DeleteTrainingPipelineRequest)(nil),            // 5: google.cloud.aiplatform.v1beta1.DeleteTrainingPipelineRequest
	(*CancelTrainingPipelineRequest)(nil),            // 6: google.cloud.aiplatform.v1beta1.CancelTrainingPipelineRequest
	(*CreatePipelineJobRequest)(nil),                 // 7: google.cloud.aiplatform.v1beta1.CreatePipelineJobRequest
	(*GetPipelineJobRequest)(nil),                    // 8: google.cloud.aiplatform.v1beta1.GetPipelineJobRequest
	(*ListPipelineJobsRequest)(nil),                  // 9: google.cloud.aiplatform.v1beta1.ListPipelineJobsRequest
	(*ListPipelineJobsResponse)(nil),                 // 10: google.cloud.aiplatform.v1beta1.ListPipelineJobsResponse
	(*DeletePipelineJobRequest)(nil),                 // 11: google.cloud.aiplatform.v1beta1.DeletePipelineJobRequest
	(*BatchDeletePipelineJobsRequest)(nil),           // 12: google.cloud.aiplatform.v1beta1.BatchDeletePipelineJobsRequest
	(*BatchDeletePipelineJobsResponse)(nil),          // 13: google.cloud.aiplatform.v1beta1.BatchDeletePipelineJobsResponse
	(*CancelPipelineJobRequest)(nil),                 // 14: google.cloud.aiplatform.v1beta1.CancelPipelineJobRequest
	(*BatchCancelPipelineJobsRequest)(nil),           // 15: google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsRequest
	(*BatchCancelPipelineJobsResponse)(nil),          // 16: google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsResponse
	(*GenericOperationMetadata)(nil),                 // 17: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*TrainingPipeline)(nil),                         // 18: google.cloud.aiplatform.v1beta1.TrainingPipeline
	(*fieldmaskpb.FieldMask)(nil),                    // 19: google.protobuf.FieldMask
	(*PipelineJob)(nil),                              // 20: google.cloud.aiplatform.v1beta1.PipelineJob
	(*longrunningpb.Operation)(nil),                  // 21: google.longrunning.Operation
	(*emptypb.Empty)(nil),                            // 22: google.protobuf.Empty
}
var file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_depIdxs = []int32{
	17, // 0: google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	18, // 1: google.cloud.aiplatform.v1beta1.CreateTrainingPipelineRequest.training_pipeline:type_name -> google.cloud.aiplatform.v1beta1.TrainingPipeline
	19, // 2: google.cloud.aiplatform.v1beta1.ListTrainingPipelinesRequest.read_mask:type_name -> google.protobuf.FieldMask
	18, // 3: google.cloud.aiplatform.v1beta1.ListTrainingPipelinesResponse.training_pipelines:type_name -> google.cloud.aiplatform.v1beta1.TrainingPipeline
	20, // 4: google.cloud.aiplatform.v1beta1.CreatePipelineJobRequest.pipeline_job:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob
	19, // 5: google.cloud.aiplatform.v1beta1.ListPipelineJobsRequest.read_mask:type_name -> google.protobuf.FieldMask
	20, // 6: google.cloud.aiplatform.v1beta1.ListPipelineJobsResponse.pipeline_jobs:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob
	20, // 7: google.cloud.aiplatform.v1beta1.BatchDeletePipelineJobsResponse.pipeline_jobs:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob
	20, // 8: google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsResponse.pipeline_jobs:type_name -> google.cloud.aiplatform.v1beta1.PipelineJob
	1,  // 9: google.cloud.aiplatform.v1beta1.PipelineService.CreateTrainingPipeline:input_type -> google.cloud.aiplatform.v1beta1.CreateTrainingPipelineRequest
	2,  // 10: google.cloud.aiplatform.v1beta1.PipelineService.GetTrainingPipeline:input_type -> google.cloud.aiplatform.v1beta1.GetTrainingPipelineRequest
	3,  // 11: google.cloud.aiplatform.v1beta1.PipelineService.ListTrainingPipelines:input_type -> google.cloud.aiplatform.v1beta1.ListTrainingPipelinesRequest
	5,  // 12: google.cloud.aiplatform.v1beta1.PipelineService.DeleteTrainingPipeline:input_type -> google.cloud.aiplatform.v1beta1.DeleteTrainingPipelineRequest
	6,  // 13: google.cloud.aiplatform.v1beta1.PipelineService.CancelTrainingPipeline:input_type -> google.cloud.aiplatform.v1beta1.CancelTrainingPipelineRequest
	7,  // 14: google.cloud.aiplatform.v1beta1.PipelineService.CreatePipelineJob:input_type -> google.cloud.aiplatform.v1beta1.CreatePipelineJobRequest
	8,  // 15: google.cloud.aiplatform.v1beta1.PipelineService.GetPipelineJob:input_type -> google.cloud.aiplatform.v1beta1.GetPipelineJobRequest
	9,  // 16: google.cloud.aiplatform.v1beta1.PipelineService.ListPipelineJobs:input_type -> google.cloud.aiplatform.v1beta1.ListPipelineJobsRequest
	11, // 17: google.cloud.aiplatform.v1beta1.PipelineService.DeletePipelineJob:input_type -> google.cloud.aiplatform.v1beta1.DeletePipelineJobRequest
	12, // 18: google.cloud.aiplatform.v1beta1.PipelineService.BatchDeletePipelineJobs:input_type -> google.cloud.aiplatform.v1beta1.BatchDeletePipelineJobsRequest
	14, // 19: google.cloud.aiplatform.v1beta1.PipelineService.CancelPipelineJob:input_type -> google.cloud.aiplatform.v1beta1.CancelPipelineJobRequest
	15, // 20: google.cloud.aiplatform.v1beta1.PipelineService.BatchCancelPipelineJobs:input_type -> google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsRequest
	18, // 21: google.cloud.aiplatform.v1beta1.PipelineService.CreateTrainingPipeline:output_type -> google.cloud.aiplatform.v1beta1.TrainingPipeline
	18, // 22: google.cloud.aiplatform.v1beta1.PipelineService.GetTrainingPipeline:output_type -> google.cloud.aiplatform.v1beta1.TrainingPipeline
	4,  // 23: google.cloud.aiplatform.v1beta1.PipelineService.ListTrainingPipelines:output_type -> google.cloud.aiplatform.v1beta1.ListTrainingPipelinesResponse
	21, // 24: google.cloud.aiplatform.v1beta1.PipelineService.DeleteTrainingPipeline:output_type -> google.longrunning.Operation
	22, // 25: google.cloud.aiplatform.v1beta1.PipelineService.CancelTrainingPipeline:output_type -> google.protobuf.Empty
	20, // 26: google.cloud.aiplatform.v1beta1.PipelineService.CreatePipelineJob:output_type -> google.cloud.aiplatform.v1beta1.PipelineJob
	20, // 27: google.cloud.aiplatform.v1beta1.PipelineService.GetPipelineJob:output_type -> google.cloud.aiplatform.v1beta1.PipelineJob
	10, // 28: google.cloud.aiplatform.v1beta1.PipelineService.ListPipelineJobs:output_type -> google.cloud.aiplatform.v1beta1.ListPipelineJobsResponse
	21, // 29: google.cloud.aiplatform.v1beta1.PipelineService.DeletePipelineJob:output_type -> google.longrunning.Operation
	21, // 30: google.cloud.aiplatform.v1beta1.PipelineService.BatchDeletePipelineJobs:output_type -> google.longrunning.Operation
	22, // 31: google.cloud.aiplatform.v1beta1.PipelineService.CancelPipelineJob:output_type -> google.protobuf.Empty
	21, // 32: google.cloud.aiplatform.v1beta1.PipelineService.BatchCancelPipelineJobs:output_type -> google.longrunning.Operation
	21, // [21:33] is the sub-list for method output_type
	9,  // [9:21] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_pipeline_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_pipeline_job_proto_init()
	file_google_cloud_aiplatform_v1beta1_training_pipeline_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_pipeline_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_pipeline_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PipelineServiceClient is the client API for PipelineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PipelineServiceClient interface {
	// Creates a TrainingPipeline. A created TrainingPipeline right away will be
	// attempted to be run.
	CreateTrainingPipeline(ctx context.Context, in *CreateTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error)
	// Gets a TrainingPipeline.
	GetTrainingPipeline(ctx context.Context, in *GetTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error)
	// Lists TrainingPipelines in a Location.
	ListTrainingPipelines(ctx context.Context, in *ListTrainingPipelinesRequest, opts ...grpc.CallOption) (*ListTrainingPipelinesResponse, error)
	// Deletes a TrainingPipeline.
	DeleteTrainingPipeline(ctx context.Context, in *DeleteTrainingPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a TrainingPipeline.
	// Starts asynchronous cancellation on the TrainingPipeline. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.GetTrainingPipeline]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the TrainingPipeline is not deleted; instead it becomes a pipeline with
	// a
	// [TrainingPipeline.error][google.cloud.aiplatform.v1beta1.TrainingPipeline.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [TrainingPipeline.state][google.cloud.aiplatform.v1beta1.TrainingPipeline.state]
	// is set to `CANCELLED`.
	CancelTrainingPipeline(ctx context.Context, in *CancelTrainingPipelineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a PipelineJob. A PipelineJob will run immediately when created.
	CreatePipelineJob(ctx context.Context, in *CreatePipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error)
	// Gets a PipelineJob.
	GetPipelineJob(ctx context.Context, in *GetPipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error)
	// Lists PipelineJobs in a Location.
	ListPipelineJobs(ctx context.Context, in *ListPipelineJobsRequest, opts ...grpc.CallOption) (*ListPipelineJobsResponse, error)
	// Deletes a PipelineJob.
	DeletePipelineJob(ctx context.Context, in *DeletePipelineJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Batch deletes PipelineJobs
	// The Operation is atomic. If it fails, none of the PipelineJobs are deleted.
	// If it succeeds, all of the PipelineJobs are deleted.
	BatchDeletePipelineJobs(ctx context.Context, in *BatchDeletePipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a PipelineJob.
	// Starts asynchronous cancellation on the PipelineJob. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.GetPipelineJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the PipelineJob is not deleted; instead it becomes a pipeline with
	// a [PipelineJob.error][google.cloud.aiplatform.v1beta1.PipelineJob.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [PipelineJob.state][google.cloud.aiplatform.v1beta1.PipelineJob.state] is
	// set to `CANCELLED`.
	CancelPipelineJob(ctx context.Context, in *CancelPipelineJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Batch cancel PipelineJobs.
	// Firstly the server will check if all the jobs are in non-terminal states,
	// and skip the jobs that are already terminated.
	// If the operation failed, none of the pipeline jobs are cancelled.
	// The server will poll the states of all the pipeline jobs periodically
	// to check the cancellation status.
	// This operation will return an LRO.
	BatchCancelPipelineJobs(ctx context.Context, in *BatchCancelPipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type pipelineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPipelineServiceClient(cc grpc.ClientConnInterface) PipelineServiceClient {
	return &pipelineServiceClient{cc}
}

func (c *pipelineServiceClient) CreateTrainingPipeline(ctx context.Context, in *CreateTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error) {
	out := new(TrainingPipeline)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/CreateTrainingPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) GetTrainingPipeline(ctx context.Context, in *GetTrainingPipelineRequest, opts ...grpc.CallOption) (*TrainingPipeline, error) {
	out := new(TrainingPipeline)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/GetTrainingPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) ListTrainingPipelines(ctx context.Context, in *ListTrainingPipelinesRequest, opts ...grpc.CallOption) (*ListTrainingPipelinesResponse, error) {
	out := new(ListTrainingPipelinesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/ListTrainingPipelines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) DeleteTrainingPipeline(ctx context.Context, in *DeleteTrainingPipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/DeleteTrainingPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) CancelTrainingPipeline(ctx context.Context, in *CancelTrainingPipelineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/CancelTrainingPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) CreatePipelineJob(ctx context.Context, in *CreatePipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error) {
	out := new(PipelineJob)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/CreatePipelineJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) GetPipelineJob(ctx context.Context, in *GetPipelineJobRequest, opts ...grpc.CallOption) (*PipelineJob, error) {
	out := new(PipelineJob)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/GetPipelineJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) ListPipelineJobs(ctx context.Context, in *ListPipelineJobsRequest, opts ...grpc.CallOption) (*ListPipelineJobsResponse, error) {
	out := new(ListPipelineJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/ListPipelineJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) DeletePipelineJob(ctx context.Context, in *DeletePipelineJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/DeletePipelineJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) BatchDeletePipelineJobs(ctx context.Context, in *BatchDeletePipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/BatchDeletePipelineJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) CancelPipelineJob(ctx context.Context, in *CancelPipelineJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/CancelPipelineJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelineServiceClient) BatchCancelPipelineJobs(ctx context.Context, in *BatchCancelPipelineJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.PipelineService/BatchCancelPipelineJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PipelineServiceServer is the server API for PipelineService service.
type PipelineServiceServer interface {
	// Creates a TrainingPipeline. A created TrainingPipeline right away will be
	// attempted to be run.
	CreateTrainingPipeline(context.Context, *CreateTrainingPipelineRequest) (*TrainingPipeline, error)
	// Gets a TrainingPipeline.
	GetTrainingPipeline(context.Context, *GetTrainingPipelineRequest) (*TrainingPipeline, error)
	// Lists TrainingPipelines in a Location.
	ListTrainingPipelines(context.Context, *ListTrainingPipelinesRequest) (*ListTrainingPipelinesResponse, error)
	// Deletes a TrainingPipeline.
	DeleteTrainingPipeline(context.Context, *DeleteTrainingPipelineRequest) (*longrunningpb.Operation, error)
	// Cancels a TrainingPipeline.
	// Starts asynchronous cancellation on the TrainingPipeline. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetTrainingPipeline][google.cloud.aiplatform.v1beta1.PipelineService.GetTrainingPipeline]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the TrainingPipeline is not deleted; instead it becomes a pipeline with
	// a
	// [TrainingPipeline.error][google.cloud.aiplatform.v1beta1.TrainingPipeline.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [TrainingPipeline.state][google.cloud.aiplatform.v1beta1.TrainingPipeline.state]
	// is set to `CANCELLED`.
	CancelTrainingPipeline(context.Context, *CancelTrainingPipelineRequest) (*emptypb.Empty, error)
	// Creates a PipelineJob. A PipelineJob will run immediately when created.
	CreatePipelineJob(context.Context, *CreatePipelineJobRequest) (*PipelineJob, error)
	// Gets a PipelineJob.
	GetPipelineJob(context.Context, *GetPipelineJobRequest) (*PipelineJob, error)
	// Lists PipelineJobs in a Location.
	ListPipelineJobs(context.Context, *ListPipelineJobsRequest) (*ListPipelineJobsResponse, error)
	// Deletes a PipelineJob.
	DeletePipelineJob(context.Context, *DeletePipelineJobRequest) (*longrunningpb.Operation, error)
	// Batch deletes PipelineJobs
	// The Operation is atomic. If it fails, none of the PipelineJobs are deleted.
	// If it succeeds, all of the PipelineJobs are deleted.
	BatchDeletePipelineJobs(context.Context, *BatchDeletePipelineJobsRequest) (*longrunningpb.Operation, error)
	// Cancels a PipelineJob.
	// Starts asynchronous cancellation on the PipelineJob. The server
	// makes a best effort to cancel the pipeline, but success is not
	// guaranteed. Clients can use
	// [PipelineService.GetPipelineJob][google.cloud.aiplatform.v1beta1.PipelineService.GetPipelineJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// pipeline completed despite cancellation. On successful cancellation,
	// the PipelineJob is not deleted; instead it becomes a pipeline with
	// a [PipelineJob.error][google.cloud.aiplatform.v1beta1.PipelineJob.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [PipelineJob.state][google.cloud.aiplatform.v1beta1.PipelineJob.state] is
	// set to `CANCELLED`.
	CancelPipelineJob(context.Context, *CancelPipelineJobRequest) (*emptypb.Empty, error)
	// Batch cancel PipelineJobs.
	// Firstly the server will check if all the jobs are in non-terminal states,
	// and skip the jobs that are already terminated.
	// If the operation failed, none of the pipeline jobs are cancelled.
	// The server will poll the states of all the pipeline jobs periodically
	// to check the cancellation status.
	// This operation will return an LRO.
	BatchCancelPipelineJobs(context.Context, *BatchCancelPipelineJobsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPipelineServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPipelineServiceServer struct {
}

func (*UnimplementedPipelineServiceServer) CreateTrainingPipeline(context.Context, *CreateTrainingPipelineRequest) (*TrainingPipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTrainingPipeline not implemented")
}
func (*UnimplementedPipelineServiceServer) GetTrainingPipeline(context.Context, *GetTrainingPipelineRequest) (*TrainingPipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrainingPipeline not implemented")
}
func (*UnimplementedPipelineServiceServer) ListTrainingPipelines(context.Context, *ListTrainingPipelinesRequest) (*ListTrainingPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTrainingPipelines not implemented")
}
func (*UnimplementedPipelineServiceServer) DeleteTrainingPipeline(context.Context, *DeleteTrainingPipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTrainingPipeline not implemented")
}
func (*UnimplementedPipelineServiceServer) CancelTrainingPipeline(context.Context, *CancelTrainingPipelineRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelTrainingPipeline not implemented")
}
func (*UnimplementedPipelineServiceServer) CreatePipelineJob(context.Context, *CreatePipelineJobRequest) (*PipelineJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePipelineJob not implemented")
}
func (*UnimplementedPipelineServiceServer) GetPipelineJob(context.Context, *GetPipelineJobRequest) (*PipelineJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipelineJob not implemented")
}
func (*UnimplementedPipelineServiceServer) ListPipelineJobs(context.Context, *ListPipelineJobsRequest) (*ListPipelineJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPipelineJobs not implemented")
}
func (*UnimplementedPipelineServiceServer) DeletePipelineJob(context.Context, *DeletePipelineJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePipelineJob not implemented")
}
func (*UnimplementedPipelineServiceServer) BatchDeletePipelineJobs(context.Context, *BatchDeletePipelineJobsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeletePipelineJobs not implemented")
}
func (*UnimplementedPipelineServiceServer) CancelPipelineJob(context.Context, *CancelPipelineJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelPipelineJob not implemented")
}
func (*UnimplementedPipelineServiceServer) BatchCancelPipelineJobs(context.Context, *BatchCancelPipelineJobsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCancelPipelineJobs not implemented")
}

func RegisterPipelineServiceServer(s *grpc.Server, srv PipelineServiceServer) {
	s.RegisterService(&_PipelineService_serviceDesc, srv)
}

func _PipelineService_CreateTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CreateTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/CreateTrainingPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CreateTrainingPipeline(ctx, req.(*CreateTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_GetTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).GetTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/GetTrainingPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).GetTrainingPipeline(ctx, req.(*GetTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_ListTrainingPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTrainingPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).ListTrainingPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/ListTrainingPipelines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).ListTrainingPipelines(ctx, req.(*ListTrainingPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_DeleteTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).DeleteTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/DeleteTrainingPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).DeleteTrainingPipeline(ctx, req.(*DeleteTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_CancelTrainingPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelTrainingPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CancelTrainingPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/CancelTrainingPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CancelTrainingPipeline(ctx, req.(*CancelTrainingPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_CreatePipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CreatePipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/CreatePipelineJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CreatePipelineJob(ctx, req.(*CreatePipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_GetPipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).GetPipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/GetPipelineJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).GetPipelineJob(ctx, req.(*GetPipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_ListPipelineJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelineJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).ListPipelineJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/ListPipelineJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).ListPipelineJobs(ctx, req.(*ListPipelineJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_DeletePipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).DeletePipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/DeletePipelineJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).DeletePipelineJob(ctx, req.(*DeletePipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_BatchDeletePipelineJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeletePipelineJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).BatchDeletePipelineJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/BatchDeletePipelineJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).BatchDeletePipelineJobs(ctx, req.(*BatchDeletePipelineJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_CancelPipelineJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelPipelineJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).CancelPipelineJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/CancelPipelineJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).CancelPipelineJob(ctx, req.(*CancelPipelineJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelineService_BatchCancelPipelineJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCancelPipelineJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelineServiceServer).BatchCancelPipelineJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.PipelineService/BatchCancelPipelineJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelineServiceServer).BatchCancelPipelineJobs(ctx, req.(*BatchCancelPipelineJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PipelineService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.PipelineService",
	HandlerType: (*PipelineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTrainingPipeline",
			Handler:    _PipelineService_CreateTrainingPipeline_Handler,
		},
		{
			MethodName: "GetTrainingPipeline",
			Handler:    _PipelineService_GetTrainingPipeline_Handler,
		},
		{
			MethodName: "ListTrainingPipelines",
			Handler:    _PipelineService_ListTrainingPipelines_Handler,
		},
		{
			MethodName: "DeleteTrainingPipeline",
			Handler:    _PipelineService_DeleteTrainingPipeline_Handler,
		},
		{
			MethodName: "CancelTrainingPipeline",
			Handler:    _PipelineService_CancelTrainingPipeline_Handler,
		},
		{
			MethodName: "CreatePipelineJob",
			Handler:    _PipelineService_CreatePipelineJob_Handler,
		},
		{
			MethodName: "GetPipelineJob",
			Handler:    _PipelineService_GetPipelineJob_Handler,
		},
		{
			MethodName: "ListPipelineJobs",
			Handler:    _PipelineService_ListPipelineJobs_Handler,
		},
		{
			MethodName: "DeletePipelineJob",
			Handler:    _PipelineService_DeletePipelineJob_Handler,
		},
		{
			MethodName: "BatchDeletePipelineJobs",
			Handler:    _PipelineService_BatchDeletePipelineJobs_Handler,
		},
		{
			MethodName: "CancelPipelineJob",
			Handler:    _PipelineService_CancelPipelineJob_Handler,
		},
		{
			MethodName: "BatchCancelPipelineJobs",
			Handler:    _PipelineService_BatchCancelPipelineJobs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/pipeline_service.proto",
}
