/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "kubevirt.io/api/migrations/v1alpha1"
	scheme "kubevirt.io/client-go/generated/kubevirt/clientset/versioned/scheme"
)

// MigrationPoliciesGetter has a method to return a MigrationPolicyInterface.
// A group's client should implement this interface.
type MigrationPoliciesGetter interface {
	MigrationPolicies() MigrationPolicyInterface
}

// MigrationPolicyInterface has methods to work with MigrationPolicy resources.
type MigrationPolicyInterface interface {
	Create(ctx context.Context, migrationPolicy *v1alpha1.MigrationPolicy, opts v1.CreateOptions) (*v1alpha1.MigrationPolicy, error)
	Update(ctx context.Context, migrationPolicy *v1alpha1.MigrationPolicy, opts v1.UpdateOptions) (*v1alpha1.MigrationPolicy, error)
	UpdateStatus(ctx context.Context, migrationPolicy *v1alpha1.MigrationPolicy, opts v1.UpdateOptions) (*v1alpha1.MigrationPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.MigrationPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.MigrationPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.MigrationPolicy, err error)
	MigrationPolicyExpansion
}

// migrationPolicies implements MigrationPolicyInterface
type migrationPolicies struct {
	client rest.Interface
}

// newMigrationPolicies returns a MigrationPolicies
func newMigrationPolicies(c *MigrationsV1alpha1Client) *migrationPolicies {
	return &migrationPolicies{
		client: c.RESTClient(),
	}
}

// Get takes name of the migrationPolicy, and returns the corresponding migrationPolicy object, and an error if there is any.
func (c *migrationPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.MigrationPolicy, err error) {
	result = &v1alpha1.MigrationPolicy{}
	err = c.client.Get().
		Resource("migrationpolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MigrationPolicies that match those selectors.
func (c *migrationPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.MigrationPolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.MigrationPolicyList{}
	err = c.client.Get().
		Resource("migrationpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested migrationPolicies.
func (c *migrationPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("migrationpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a migrationPolicy and creates it.  Returns the server's representation of the migrationPolicy, and an error, if there is any.
func (c *migrationPolicies) Create(ctx context.Context, migrationPolicy *v1alpha1.MigrationPolicy, opts v1.CreateOptions) (result *v1alpha1.MigrationPolicy, err error) {
	result = &v1alpha1.MigrationPolicy{}
	err = c.client.Post().
		Resource("migrationpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(migrationPolicy).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a migrationPolicy and updates it. Returns the server's representation of the migrationPolicy, and an error, if there is any.
func (c *migrationPolicies) Update(ctx context.Context, migrationPolicy *v1alpha1.MigrationPolicy, opts v1.UpdateOptions) (result *v1alpha1.MigrationPolicy, err error) {
	result = &v1alpha1.MigrationPolicy{}
	err = c.client.Put().
		Resource("migrationpolicies").
		Name(migrationPolicy.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(migrationPolicy).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *migrationPolicies) UpdateStatus(ctx context.Context, migrationPolicy *v1alpha1.MigrationPolicy, opts v1.UpdateOptions) (result *v1alpha1.MigrationPolicy, err error) {
	result = &v1alpha1.MigrationPolicy{}
	err = c.client.Put().
		Resource("migrationpolicies").
		Name(migrationPolicy.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(migrationPolicy).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the migrationPolicy and deletes it. Returns an error if one occurs.
func (c *migrationPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("migrationpolicies").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *migrationPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("migrationpolicies").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched migrationPolicy.
func (c *migrationPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.MigrationPolicy, err error) {
	result = &v1alpha1.MigrationPolicy{}
	err = c.client.Patch(pt).
		Resource("migrationpolicies").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
