/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.examples.mailreader.memory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.examples.mailreader.memory.MemoryUserDatabase;

public final class MemoryDatabasePlugIn
implements PlugIn {
    private MemoryUserDatabase database = null;
    private Log log = LogFactory.getLog(this.getClass());
    private ActionServlet servlet = null;
    private String pathname = "/WEB-INF/database.xml";

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    public void destroy() {
        this.log.info((Object)"Finalizing memory database plug in");
        if (this.database != null) {
            try {
                this.database.close();
            }
            catch (Exception e) {
                this.log.error((Object)"Closing memory database", (Throwable)e);
            }
        }
        this.servlet.getServletContext().removeAttribute("database");
        this.database = null;
        this.servlet = null;
        this.database = null;
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.log.info((Object)("Initializing memory database plug in from '" + this.pathname + "'"));
        this.servlet = servlet;
        this.database = new MemoryUserDatabase();
        try {
            String path = this.calculatePath();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" Loading database from '" + path + "'"));
            }
            this.database.setPathname(path);
            this.database.open();
        }
        catch (Exception e) {
            this.log.error((Object)"Opening memory database", (Throwable)e);
            throw new ServletException("Cannot load database from '" + this.pathname + "'", (Throwable)e);
        }
        servlet.getServletContext().setAttribute("database", (Object)this.database);
    }

    private String calculatePath() throws Exception {
        int n;
        String path = this.servlet.getServletContext().getRealPath(this.pathname);
        if (path != null) {
            return path;
        }
        File dir = (File)this.servlet.getServletContext().getAttribute("javax.servlet.context.tempdir");
        File file = new File(dir, "struts-example-database.xml");
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        InputStream is = this.servlet.getServletContext().getResourceAsStream(this.pathname);
        BufferedInputStream bis = new BufferedInputStream(is, 1024);
        FileOutputStream os = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(os, 1024);
        byte[] buffer = new byte[1024];
        while ((n = bis.read(buffer)) > 0) {
            bos.write(buffer, 0, n);
        }
        bos.close();
        bis.close();
        return file.getAbsolutePath();
    }
}

