import {
  require_picocolors_browser
} from "../_browser-chunks/chunk-VUAFL5XK.js";
import {
  assertTypes,
  diff,
  getDefaultExportFromCjs,
  getType,
  isObject,
  noop,
  printDiffOrStringify,
  processError,
  s,
  stringify
} from "../_browser-chunks/chunk-JVSKG4YS.js";
import {
  dedent
} from "../_browser-chunks/chunk-OPCDBBL3.js";
import {
  __commonJS,
  __export,
  __name,
  __toESM
} from "../_browser-chunks/chunk-MM7DTO55.js";

// ../node_modules/min-indent/index.js
var require_min_indent = __commonJS({
  "../node_modules/min-indent/index.js"(exports, module2) {
    "use strict";
    module2.exports = (string) => {
      const match = string.match(/^[ \t]*(?=\S)/gm);
      if (!match) {
        return 0;
      }
      return match.reduce((r2, a) => Math.min(r2, a.length), Infinity);
    };
  }
});

// ../node_modules/strip-indent/index.js
var require_strip_indent = __commonJS({
  "../node_modules/strip-indent/index.js"(exports, module2) {
    "use strict";
    var minIndent = require_min_indent();
    module2.exports = (string) => {
      const indent = minIndent(string);
      if (indent === 0) {
        return string;
      }
      const regex = new RegExp(`^[ \\t]{${indent}}`, "gm");
      return string.replace(regex, "");
    };
  }
});

// ../node_modules/indent-string/index.js
var require_indent_string = __commonJS({
  "../node_modules/indent-string/index.js"(exports, module2) {
    "use strict";
    module2.exports = (string, count = 1, options) => {
      options = {
        indent: " ",
        includeEmptyLines: false,
        ...options
      };
      if (typeof string !== "string") {
        throw new TypeError(
          `Expected \`input\` to be a \`string\`, got \`${typeof string}\``
        );
      }
      if (typeof count !== "number") {
        throw new TypeError(
          `Expected \`count\` to be a \`number\`, got \`${typeof count}\``
        );
      }
      if (typeof options.indent !== "string") {
        throw new TypeError(
          `Expected \`options.indent\` to be a \`string\`, got \`${typeof options.indent}\``
        );
      }
      if (count === 0) {
        return string;
      }
      const regex = options.includeEmptyLines ? /^/gm : /^(?!\s*$)/gm;
      return string.replace(regex, options.indent.repeat(count));
    };
  }
});

// ../node_modules/redent/index.js
var require_redent = __commonJS({
  "../node_modules/redent/index.js"(exports, module2) {
    "use strict";
    var stripIndent = require_strip_indent();
    var indentString = require_indent_string();
    module2.exports = (string, count = 0, options) => indentString(stripIndent(string), count, options);
  }
});

// ../node_modules/aria-query/lib/util/iteratorProxy.js
var require_iteratorProxy = __commonJS({
  "../node_modules/aria-query/lib/util/iteratorProxy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    function iteratorProxy() {
      var values = this;
      var index = 0;
      var iter = {
        "@@iterator": /* @__PURE__ */ __name(function iterator() {
          return iter;
        }, "iterator"),
        next: /* @__PURE__ */ __name(function next() {
          if (index < values.length) {
            var value = values[index];
            index = index + 1;
            return {
              done: false,
              value
            };
          } else {
            return {
              done: true
            };
          }
        }, "next")
      };
      return iter;
    }
    __name(iteratorProxy, "iteratorProxy");
    var _default = exports.default = iteratorProxy;
  }
});

// ../node_modules/aria-query/lib/util/iterationDecorator.js
var require_iterationDecorator = __commonJS({
  "../node_modules/aria-query/lib/util/iterationDecorator.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = iterationDecorator;
    var _iteratorProxy = _interopRequireDefault(require_iteratorProxy());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    function _typeof5(o2) {
      "@babel/helpers - typeof";
      return _typeof5 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(o3) {
        return typeof o3;
      } : function(o3) {
        return o3 && "function" == typeof Symbol && o3.constructor === Symbol && o3 !== Symbol.prototype ? "symbol" : typeof o3;
      }, _typeof5(o2);
    }
    __name(_typeof5, "_typeof");
    function iterationDecorator(collection, entries) {
      if (typeof Symbol === "function" && _typeof5(Symbol.iterator) === "symbol") {
        Object.defineProperty(collection, Symbol.iterator, {
          value: _iteratorProxy.default.bind(entries)
        });
      }
      return collection;
    }
    __name(iterationDecorator, "iterationDecorator");
  }
});

// ../node_modules/aria-query/lib/ariaPropsMap.js
var require_ariaPropsMap = __commonJS({
  "../node_modules/aria-query/lib/ariaPropsMap.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _iterationDecorator = _interopRequireDefault(require_iterationDecorator());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    function _slicedToArray(r2, e2) {
      return _arrayWithHoles(r2) || _iterableToArrayLimit(r2, e2) || _unsupportedIterableToArray(r2, e2) || _nonIterableRest();
    }
    __name(_slicedToArray, "_slicedToArray");
    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    __name(_nonIterableRest, "_nonIterableRest");
    function _unsupportedIterableToArray(r2, a) {
      if (r2) {
        if ("string" == typeof r2) return _arrayLikeToArray(r2, a);
        var t2 = {}.toString.call(r2).slice(8, -1);
        return "Object" === t2 && r2.constructor && (t2 = r2.constructor.name), "Map" === t2 || "Set" === t2 ? Array.from(r2) : "Arguments" === t2 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t2) ? _arrayLikeToArray(r2, a) : void 0;
      }
    }
    __name(_unsupportedIterableToArray, "_unsupportedIterableToArray");
    function _arrayLikeToArray(r2, a) {
      (null == a || a > r2.length) && (a = r2.length);
      for (var e2 = 0, n2 = Array(a); e2 < a; e2++) n2[e2] = r2[e2];
      return n2;
    }
    __name(_arrayLikeToArray, "_arrayLikeToArray");
    function _iterableToArrayLimit(r2, l2) {
      var t2 = null == r2 ? null : "undefined" != typeof Symbol && r2[Symbol.iterator] || r2["@@iterator"];
      if (null != t2) {
        var e2, n2, i2, u3, a = [], f3 = true, o2 = false;
        try {
          if (i2 = (t2 = t2.call(r2)).next, 0 === l2) {
            if (Object(t2) !== t2) return;
            f3 = false;
          } else for (; !(f3 = (e2 = i2.call(t2)).done) && (a.push(e2.value), a.length !== l2); f3 = true) ;
        } catch (r3) {
          o2 = true, n2 = r3;
        } finally {
          try {
            if (!f3 && null != t2.return && (u3 = t2.return(), Object(u3) !== u3)) return;
          } finally {
            if (o2) throw n2;
          }
        }
        return a;
      }
    }
    __name(_iterableToArrayLimit, "_iterableToArrayLimit");
    function _arrayWithHoles(r2) {
      if (Array.isArray(r2)) return r2;
    }
    __name(_arrayWithHoles, "_arrayWithHoles");
    var properties = [["aria-activedescendant", {
      "type": "id"
    }], ["aria-atomic", {
      "type": "boolean"
    }], ["aria-autocomplete", {
      "type": "token",
      "values": ["inline", "list", "both", "none"]
    }], ["aria-braillelabel", {
      "type": "string"
    }], ["aria-brailleroledescription", {
      "type": "string"
    }], ["aria-busy", {
      "type": "boolean"
    }], ["aria-checked", {
      "type": "tristate"
    }], ["aria-colcount", {
      type: "integer"
    }], ["aria-colindex", {
      type: "integer"
    }], ["aria-colspan", {
      type: "integer"
    }], ["aria-controls", {
      "type": "idlist"
    }], ["aria-current", {
      type: "token",
      values: ["page", "step", "location", "date", "time", true, false]
    }], ["aria-describedby", {
      "type": "idlist"
    }], ["aria-description", {
      "type": "string"
    }], ["aria-details", {
      "type": "id"
    }], ["aria-disabled", {
      "type": "boolean"
    }], ["aria-dropeffect", {
      "type": "tokenlist",
      "values": ["copy", "execute", "link", "move", "none", "popup"]
    }], ["aria-errormessage", {
      "type": "id"
    }], ["aria-expanded", {
      "type": "boolean",
      "allowundefined": true
    }], ["aria-flowto", {
      "type": "idlist"
    }], ["aria-grabbed", {
      "type": "boolean",
      "allowundefined": true
    }], ["aria-haspopup", {
      "type": "token",
      "values": [false, true, "menu", "listbox", "tree", "grid", "dialog"]
    }], ["aria-hidden", {
      "type": "boolean",
      "allowundefined": true
    }], ["aria-invalid", {
      "type": "token",
      "values": ["grammar", false, "spelling", true]
    }], ["aria-keyshortcuts", {
      type: "string"
    }], ["aria-label", {
      "type": "string"
    }], ["aria-labelledby", {
      "type": "idlist"
    }], ["aria-level", {
      "type": "integer"
    }], ["aria-live", {
      "type": "token",
      "values": ["assertive", "off", "polite"]
    }], ["aria-modal", {
      type: "boolean"
    }], ["aria-multiline", {
      "type": "boolean"
    }], ["aria-multiselectable", {
      "type": "boolean"
    }], ["aria-orientation", {
      "type": "token",
      "values": ["vertical", "undefined", "horizontal"]
    }], ["aria-owns", {
      "type": "idlist"
    }], ["aria-placeholder", {
      type: "string"
    }], ["aria-posinset", {
      "type": "integer"
    }], ["aria-pressed", {
      "type": "tristate"
    }], ["aria-readonly", {
      "type": "boolean"
    }], ["aria-relevant", {
      "type": "tokenlist",
      "values": ["additions", "all", "removals", "text"]
    }], ["aria-required", {
      "type": "boolean"
    }], ["aria-roledescription", {
      type: "string"
    }], ["aria-rowcount", {
      type: "integer"
    }], ["aria-rowindex", {
      type: "integer"
    }], ["aria-rowspan", {
      type: "integer"
    }], ["aria-selected", {
      "type": "boolean",
      "allowundefined": true
    }], ["aria-setsize", {
      "type": "integer"
    }], ["aria-sort", {
      "type": "token",
      "values": ["ascending", "descending", "none", "other"]
    }], ["aria-valuemax", {
      "type": "number"
    }], ["aria-valuemin", {
      "type": "number"
    }], ["aria-valuenow", {
      "type": "number"
    }], ["aria-valuetext", {
      "type": "string"
    }]];
    var ariaPropsMap = {
      entries: /* @__PURE__ */ __name(function entries() {
        return properties;
      }, "entries"),
      forEach: /* @__PURE__ */ __name(function forEach(fn3) {
        var thisArg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
        for (var _i = 0, _properties = properties; _i < _properties.length; _i++) {
          var _properties$_i = _slicedToArray(_properties[_i], 2), key = _properties$_i[0], values = _properties$_i[1];
          fn3.call(thisArg, values, key, properties);
        }
      }, "forEach"),
      get: /* @__PURE__ */ __name(function get2(key) {
        var item = properties.filter(function(tuple) {
          return tuple[0] === key ? true : false;
        })[0];
        return item && item[1];
      }, "get"),
      has: /* @__PURE__ */ __name(function has(key) {
        return !!ariaPropsMap.get(key);
      }, "has"),
      keys: /* @__PURE__ */ __name(function keys2() {
        return properties.map(function(_ref) {
          var _ref2 = _slicedToArray(_ref, 1), key = _ref2[0];
          return key;
        });
      }, "keys"),
      values: /* @__PURE__ */ __name(function values() {
        return properties.map(function(_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2), values2 = _ref4[1];
          return values2;
        });
      }, "values")
    };
    var _default = exports.default = (0, _iterationDecorator.default)(ariaPropsMap, ariaPropsMap.entries());
  }
});

// ../node_modules/aria-query/lib/domMap.js
var require_domMap = __commonJS({
  "../node_modules/aria-query/lib/domMap.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _iterationDecorator = _interopRequireDefault(require_iterationDecorator());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    function _slicedToArray(r2, e2) {
      return _arrayWithHoles(r2) || _iterableToArrayLimit(r2, e2) || _unsupportedIterableToArray(r2, e2) || _nonIterableRest();
    }
    __name(_slicedToArray, "_slicedToArray");
    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    __name(_nonIterableRest, "_nonIterableRest");
    function _unsupportedIterableToArray(r2, a) {
      if (r2) {
        if ("string" == typeof r2) return _arrayLikeToArray(r2, a);
        var t2 = {}.toString.call(r2).slice(8, -1);
        return "Object" === t2 && r2.constructor && (t2 = r2.constructor.name), "Map" === t2 || "Set" === t2 ? Array.from(r2) : "Arguments" === t2 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t2) ? _arrayLikeToArray(r2, a) : void 0;
      }
    }
    __name(_unsupportedIterableToArray, "_unsupportedIterableToArray");
    function _arrayLikeToArray(r2, a) {
      (null == a || a > r2.length) && (a = r2.length);
      for (var e2 = 0, n2 = Array(a); e2 < a; e2++) n2[e2] = r2[e2];
      return n2;
    }
    __name(_arrayLikeToArray, "_arrayLikeToArray");
    function _iterableToArrayLimit(r2, l2) {
      var t2 = null == r2 ? null : "undefined" != typeof Symbol && r2[Symbol.iterator] || r2["@@iterator"];
      if (null != t2) {
        var e2, n2, i2, u3, a = [], f3 = true, o2 = false;
        try {
          if (i2 = (t2 = t2.call(r2)).next, 0 === l2) {
            if (Object(t2) !== t2) return;
            f3 = false;
          } else for (; !(f3 = (e2 = i2.call(t2)).done) && (a.push(e2.value), a.length !== l2); f3 = true) ;
        } catch (r3) {
          o2 = true, n2 = r3;
        } finally {
          try {
            if (!f3 && null != t2.return && (u3 = t2.return(), Object(u3) !== u3)) return;
          } finally {
            if (o2) throw n2;
          }
        }
        return a;
      }
    }
    __name(_iterableToArrayLimit, "_iterableToArrayLimit");
    function _arrayWithHoles(r2) {
      if (Array.isArray(r2)) return r2;
    }
    __name(_arrayWithHoles, "_arrayWithHoles");
    var dom = [["a", {
      reserved: false
    }], ["abbr", {
      reserved: false
    }], ["acronym", {
      reserved: false
    }], ["address", {
      reserved: false
    }], ["applet", {
      reserved: false
    }], ["area", {
      reserved: false
    }], ["article", {
      reserved: false
    }], ["aside", {
      reserved: false
    }], ["audio", {
      reserved: false
    }], ["b", {
      reserved: false
    }], ["base", {
      reserved: true
    }], ["bdi", {
      reserved: false
    }], ["bdo", {
      reserved: false
    }], ["big", {
      reserved: false
    }], ["blink", {
      reserved: false
    }], ["blockquote", {
      reserved: false
    }], ["body", {
      reserved: false
    }], ["br", {
      reserved: false
    }], ["button", {
      reserved: false
    }], ["canvas", {
      reserved: false
    }], ["caption", {
      reserved: false
    }], ["center", {
      reserved: false
    }], ["cite", {
      reserved: false
    }], ["code", {
      reserved: false
    }], ["col", {
      reserved: true
    }], ["colgroup", {
      reserved: true
    }], ["content", {
      reserved: false
    }], ["data", {
      reserved: false
    }], ["datalist", {
      reserved: false
    }], ["dd", {
      reserved: false
    }], ["del", {
      reserved: false
    }], ["details", {
      reserved: false
    }], ["dfn", {
      reserved: false
    }], ["dialog", {
      reserved: false
    }], ["dir", {
      reserved: false
    }], ["div", {
      reserved: false
    }], ["dl", {
      reserved: false
    }], ["dt", {
      reserved: false
    }], ["em", {
      reserved: false
    }], ["embed", {
      reserved: false
    }], ["fieldset", {
      reserved: false
    }], ["figcaption", {
      reserved: false
    }], ["figure", {
      reserved: false
    }], ["font", {
      reserved: false
    }], ["footer", {
      reserved: false
    }], ["form", {
      reserved: false
    }], ["frame", {
      reserved: false
    }], ["frameset", {
      reserved: false
    }], ["h1", {
      reserved: false
    }], ["h2", {
      reserved: false
    }], ["h3", {
      reserved: false
    }], ["h4", {
      reserved: false
    }], ["h5", {
      reserved: false
    }], ["h6", {
      reserved: false
    }], ["head", {
      reserved: true
    }], ["header", {
      reserved: false
    }], ["hgroup", {
      reserved: false
    }], ["hr", {
      reserved: false
    }], ["html", {
      reserved: true
    }], ["i", {
      reserved: false
    }], ["iframe", {
      reserved: false
    }], ["img", {
      reserved: false
    }], ["input", {
      reserved: false
    }], ["ins", {
      reserved: false
    }], ["kbd", {
      reserved: false
    }], ["keygen", {
      reserved: false
    }], ["label", {
      reserved: false
    }], ["legend", {
      reserved: false
    }], ["li", {
      reserved: false
    }], ["link", {
      reserved: true
    }], ["main", {
      reserved: false
    }], ["map", {
      reserved: false
    }], ["mark", {
      reserved: false
    }], ["marquee", {
      reserved: false
    }], ["menu", {
      reserved: false
    }], ["menuitem", {
      reserved: false
    }], ["meta", {
      reserved: true
    }], ["meter", {
      reserved: false
    }], ["nav", {
      reserved: false
    }], ["noembed", {
      reserved: true
    }], ["noscript", {
      reserved: true
    }], ["object", {
      reserved: false
    }], ["ol", {
      reserved: false
    }], ["optgroup", {
      reserved: false
    }], ["option", {
      reserved: false
    }], ["output", {
      reserved: false
    }], ["p", {
      reserved: false
    }], ["param", {
      reserved: true
    }], ["picture", {
      reserved: true
    }], ["pre", {
      reserved: false
    }], ["progress", {
      reserved: false
    }], ["q", {
      reserved: false
    }], ["rp", {
      reserved: false
    }], ["rt", {
      reserved: false
    }], ["rtc", {
      reserved: false
    }], ["ruby", {
      reserved: false
    }], ["s", {
      reserved: false
    }], ["samp", {
      reserved: false
    }], ["script", {
      reserved: true
    }], ["section", {
      reserved: false
    }], ["select", {
      reserved: false
    }], ["small", {
      reserved: false
    }], ["source", {
      reserved: true
    }], ["spacer", {
      reserved: false
    }], ["span", {
      reserved: false
    }], ["strike", {
      reserved: false
    }], ["strong", {
      reserved: false
    }], ["style", {
      reserved: true
    }], ["sub", {
      reserved: false
    }], ["summary", {
      reserved: false
    }], ["sup", {
      reserved: false
    }], ["table", {
      reserved: false
    }], ["tbody", {
      reserved: false
    }], ["td", {
      reserved: false
    }], ["textarea", {
      reserved: false
    }], ["tfoot", {
      reserved: false
    }], ["th", {
      reserved: false
    }], ["thead", {
      reserved: false
    }], ["time", {
      reserved: false
    }], ["title", {
      reserved: true
    }], ["tr", {
      reserved: false
    }], ["track", {
      reserved: true
    }], ["tt", {
      reserved: false
    }], ["u", {
      reserved: false
    }], ["ul", {
      reserved: false
    }], ["var", {
      reserved: false
    }], ["video", {
      reserved: false
    }], ["wbr", {
      reserved: false
    }], ["xmp", {
      reserved: false
    }]];
    var domMap = {
      entries: /* @__PURE__ */ __name(function entries() {
        return dom;
      }, "entries"),
      forEach: /* @__PURE__ */ __name(function forEach(fn3) {
        var thisArg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
        for (var _i = 0, _dom = dom; _i < _dom.length; _i++) {
          var _dom$_i = _slicedToArray(_dom[_i], 2), key = _dom$_i[0], values = _dom$_i[1];
          fn3.call(thisArg, values, key, dom);
        }
      }, "forEach"),
      get: /* @__PURE__ */ __name(function get2(key) {
        var item = dom.filter(function(tuple) {
          return tuple[0] === key ? true : false;
        })[0];
        return item && item[1];
      }, "get"),
      has: /* @__PURE__ */ __name(function has(key) {
        return !!domMap.get(key);
      }, "has"),
      keys: /* @__PURE__ */ __name(function keys2() {
        return dom.map(function(_ref) {
          var _ref2 = _slicedToArray(_ref, 1), key = _ref2[0];
          return key;
        });
      }, "keys"),
      values: /* @__PURE__ */ __name(function values() {
        return dom.map(function(_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2), values2 = _ref4[1];
          return values2;
        });
      }, "values")
    };
    var _default = exports.default = (0, _iterationDecorator.default)(domMap, domMap.entries());
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/commandRole.js
var require_commandRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/commandRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var commandRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget"]]
    };
    var _default = exports.default = commandRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/compositeRole.js
var require_compositeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/compositeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var compositeRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-activedescendant": null,
        "aria-disabled": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget"]]
    };
    var _default = exports.default = compositeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/inputRole.js
var require_inputRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/inputRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var inputRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null
      },
      relatedConcepts: [{
        concept: {
          name: "input"
        },
        module: "XForms"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget"]]
    };
    var _default = exports.default = inputRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/landmarkRole.js
var require_landmarkRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/landmarkRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var landmarkRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = landmarkRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/rangeRole.js
var require_rangeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/rangeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var rangeRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-valuemax": null,
        "aria-valuemin": null,
        "aria-valuenow": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = rangeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/roletypeRole.js
var require_roletypeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/roletypeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var roletypeRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: [],
      prohibitedProps: [],
      props: {
        "aria-atomic": null,
        "aria-busy": null,
        "aria-controls": null,
        "aria-current": null,
        "aria-describedby": null,
        "aria-details": null,
        "aria-dropeffect": null,
        "aria-flowto": null,
        "aria-grabbed": null,
        "aria-hidden": null,
        "aria-keyshortcuts": null,
        "aria-label": null,
        "aria-labelledby": null,
        "aria-live": null,
        "aria-owns": null,
        "aria-relevant": null,
        "aria-roledescription": null
      },
      relatedConcepts: [{
        concept: {
          name: "role"
        },
        module: "XHTML"
      }, {
        concept: {
          name: "type"
        },
        module: "Dublin Core"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: []
    };
    var _default = exports.default = roletypeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/sectionRole.js
var require_sectionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/sectionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var sectionRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: [],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "frontmatter"
        },
        module: "DTB"
      }, {
        concept: {
          name: "level"
        },
        module: "DTB"
      }, {
        concept: {
          name: "level"
        },
        module: "SMIL"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = sectionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/sectionheadRole.js
var require_sectionheadRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/sectionheadRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var sectionheadRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = sectionheadRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/selectRole.js
var require_selectRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/selectRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var selectRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-orientation": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite"], ["roletype", "structure", "section", "group"]]
    };
    var _default = exports.default = selectRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/structureRole.js
var require_structureRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/structureRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var structureRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: [],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype"]]
    };
    var _default = exports.default = structureRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/widgetRole.js
var require_widgetRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/widgetRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var widgetRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: [],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype"]]
    };
    var _default = exports.default = widgetRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/abstract/windowRole.js
var require_windowRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/abstract/windowRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var windowRole = {
      abstract: true,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-modal": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype"]]
    };
    var _default = exports.default = windowRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/ariaAbstractRoles.js
var require_ariaAbstractRoles = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/ariaAbstractRoles.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _commandRole = _interopRequireDefault(require_commandRole());
    var _compositeRole = _interopRequireDefault(require_compositeRole());
    var _inputRole = _interopRequireDefault(require_inputRole());
    var _landmarkRole = _interopRequireDefault(require_landmarkRole());
    var _rangeRole = _interopRequireDefault(require_rangeRole());
    var _roletypeRole = _interopRequireDefault(require_roletypeRole());
    var _sectionRole = _interopRequireDefault(require_sectionRole());
    var _sectionheadRole = _interopRequireDefault(require_sectionheadRole());
    var _selectRole = _interopRequireDefault(require_selectRole());
    var _structureRole = _interopRequireDefault(require_structureRole());
    var _widgetRole = _interopRequireDefault(require_widgetRole());
    var _windowRole = _interopRequireDefault(require_windowRole());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var ariaAbstractRoles = [["command", _commandRole.default], ["composite", _compositeRole.default], ["input", _inputRole.default], ["landmark", _landmarkRole.default], ["range", _rangeRole.default], ["roletype", _roletypeRole.default], ["section", _sectionRole.default], ["sectionhead", _sectionheadRole.default], ["select", _selectRole.default], ["structure", _structureRole.default], ["widget", _widgetRole.default], ["window", _windowRole.default]];
    var _default = exports.default = ariaAbstractRoles;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/alertRole.js
var require_alertRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/alertRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var alertRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-atomic": "true",
        "aria-live": "assertive"
      },
      relatedConcepts: [{
        concept: {
          name: "alert"
        },
        module: "XForms"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = alertRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/alertdialogRole.js
var require_alertdialogRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/alertdialogRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var alertdialogRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "alert"
        },
        module: "XForms"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "alert"], ["roletype", "window", "dialog"]]
    };
    var _default = exports.default = alertdialogRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/applicationRole.js
var require_applicationRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/applicationRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var applicationRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-activedescendant": null,
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "Device Independence Delivery Unit"
        }
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = applicationRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/articleRole.js
var require_articleRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/articleRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var articleRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-posinset": null,
        "aria-setsize": null
      },
      relatedConcepts: [{
        concept: {
          name: "article"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "document"]]
    };
    var _default = exports.default = articleRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/bannerRole.js
var require_bannerRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/bannerRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var bannerRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          constraints: ["scoped to the body element"],
          name: "header"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = bannerRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/blockquoteRole.js
var require_blockquoteRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/blockquoteRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var blockquoteRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "blockquote"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = blockquoteRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/buttonRole.js
var require_buttonRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/buttonRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var buttonRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-pressed": null
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            name: "type",
            value: "button"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            name: "type",
            value: "image"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            name: "type",
            value: "reset"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            name: "type",
            value: "submit"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          name: "button"
        },
        module: "HTML"
      }, {
        concept: {
          name: "trigger"
        },
        module: "XForms"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "command"]]
    };
    var _default = exports.default = buttonRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/captionRole.js
var require_captionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/captionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var captionRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "caption"
        },
        module: "HTML"
      }],
      requireContextRole: ["figure", "grid", "table"],
      requiredContextRole: ["figure", "grid", "table"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = captionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/cellRole.js
var require_cellRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/cellRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var cellRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-colindex": null,
        "aria-colspan": null,
        "aria-rowindex": null,
        "aria-rowspan": null
      },
      relatedConcepts: [{
        concept: {
          constraints: ["ancestor table element has table role"],
          name: "td"
        },
        module: "HTML"
      }],
      requireContextRole: ["row"],
      requiredContextRole: ["row"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = cellRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/checkboxRole.js
var require_checkboxRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/checkboxRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var checkboxRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-checked": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-invalid": null,
        "aria-readonly": null,
        "aria-required": null
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            name: "type",
            value: "checkbox"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          name: "option"
        },
        module: "ARIA"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-checked": null
      },
      superClass: [["roletype", "widget", "input"]]
    };
    var _default = exports.default = checkboxRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/codeRole.js
var require_codeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/codeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var codeRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "code"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = codeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/columnheaderRole.js
var require_columnheaderRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/columnheaderRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var columnheaderRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-sort": null
      },
      relatedConcepts: [{
        concept: {
          name: "th"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            name: "scope",
            value: "col"
          }],
          name: "th"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            name: "scope",
            value: "colgroup"
          }],
          name: "th"
        },
        module: "HTML"
      }],
      requireContextRole: ["row"],
      requiredContextRole: ["row"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "cell"], ["roletype", "structure", "section", "cell", "gridcell"], ["roletype", "widget", "gridcell"], ["roletype", "structure", "sectionhead"]]
    };
    var _default = exports.default = columnheaderRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/comboboxRole.js
var require_comboboxRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/comboboxRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var comboboxRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-activedescendant": null,
        "aria-autocomplete": null,
        "aria-errormessage": null,
        "aria-invalid": null,
        "aria-readonly": null,
        "aria-required": null,
        "aria-expanded": "false",
        "aria-haspopup": "listbox"
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "list"
          }, {
            name: "type",
            value: "email"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "list"
          }, {
            name: "type",
            value: "search"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "list"
          }, {
            name: "type",
            value: "tel"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "list"
          }, {
            name: "type",
            value: "text"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "list"
          }, {
            name: "type",
            value: "url"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "list"
          }, {
            name: "type",
            value: "url"
          }],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "multiple"
          }, {
            constraints: ["undefined"],
            name: "size"
          }],
          constraints: ["the multiple attribute is not set and the size attribute does not have a value greater than 1"],
          name: "select"
        },
        module: "HTML"
      }, {
        concept: {
          name: "select"
        },
        module: "XForms"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-controls": null,
        "aria-expanded": "false"
      },
      superClass: [["roletype", "widget", "input"]]
    };
    var _default = exports.default = comboboxRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/complementaryRole.js
var require_complementaryRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/complementaryRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var complementaryRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          constraints: ["scoped to the body element", "scoped to the main element"],
          name: "aside"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "aria-label"
          }],
          constraints: ["scoped to a sectioning content element", "scoped to a sectioning root element other than body"],
          name: "aside"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "aria-labelledby"
          }],
          constraints: ["scoped to a sectioning content element", "scoped to a sectioning root element other than body"],
          name: "aside"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = complementaryRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/contentinfoRole.js
var require_contentinfoRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/contentinfoRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var contentinfoRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          constraints: ["scoped to the body element"],
          name: "footer"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = contentinfoRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/definitionRole.js
var require_definitionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/definitionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var definitionRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "dd"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = definitionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/deletionRole.js
var require_deletionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/deletionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var deletionRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "del"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = deletionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/dialogRole.js
var require_dialogRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/dialogRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var dialogRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "dialog"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "window"]]
    };
    var _default = exports.default = dialogRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/directoryRole.js
var require_directoryRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/directoryRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var directoryRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        module: "DAISY Guide"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "list"]]
    };
    var _default = exports.default = directoryRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/documentRole.js
var require_documentRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/documentRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var documentRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "Device Independence Delivery Unit"
        }
      }, {
        concept: {
          name: "html"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = documentRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/emphasisRole.js
var require_emphasisRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/emphasisRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var emphasisRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "em"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = emphasisRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/feedRole.js
var require_feedRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/feedRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var feedRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["article"]],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "list"]]
    };
    var _default = exports.default = feedRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/figureRole.js
var require_figureRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/figureRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var figureRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "figure"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = figureRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/formRole.js
var require_formRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/formRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var formRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "aria-label"
          }],
          name: "form"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "aria-labelledby"
          }],
          name: "form"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "name"
          }],
          name: "form"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = formRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/genericRole.js
var require_genericRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/genericRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var genericRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "a"
        },
        module: "HTML"
      }, {
        concept: {
          name: "area"
        },
        module: "HTML"
      }, {
        concept: {
          name: "aside"
        },
        module: "HTML"
      }, {
        concept: {
          name: "b"
        },
        module: "HTML"
      }, {
        concept: {
          name: "bdo"
        },
        module: "HTML"
      }, {
        concept: {
          name: "body"
        },
        module: "HTML"
      }, {
        concept: {
          name: "data"
        },
        module: "HTML"
      }, {
        concept: {
          name: "div"
        },
        module: "HTML"
      }, {
        concept: {
          constraints: ["scoped to the main element", "scoped to a sectioning content element", "scoped to a sectioning root element other than body"],
          name: "footer"
        },
        module: "HTML"
      }, {
        concept: {
          constraints: ["scoped to the main element", "scoped to a sectioning content element", "scoped to a sectioning root element other than body"],
          name: "header"
        },
        module: "HTML"
      }, {
        concept: {
          name: "hgroup"
        },
        module: "HTML"
      }, {
        concept: {
          name: "i"
        },
        module: "HTML"
      }, {
        concept: {
          name: "pre"
        },
        module: "HTML"
      }, {
        concept: {
          name: "q"
        },
        module: "HTML"
      }, {
        concept: {
          name: "samp"
        },
        module: "HTML"
      }, {
        concept: {
          name: "section"
        },
        module: "HTML"
      }, {
        concept: {
          name: "small"
        },
        module: "HTML"
      }, {
        concept: {
          name: "span"
        },
        module: "HTML"
      }, {
        concept: {
          name: "u"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = genericRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/gridRole.js
var require_gridRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/gridRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var gridRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-multiselectable": null,
        "aria-readonly": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["row"], ["row", "rowgroup"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite"], ["roletype", "structure", "section", "table"]]
    };
    var _default = exports.default = gridRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/gridcellRole.js
var require_gridcellRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/gridcellRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var gridcellRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null,
        "aria-readonly": null,
        "aria-required": null,
        "aria-selected": null
      },
      relatedConcepts: [{
        concept: {
          constraints: ["ancestor table element has grid role", "ancestor table element has treegrid role"],
          name: "td"
        },
        module: "HTML"
      }],
      requireContextRole: ["row"],
      requiredContextRole: ["row"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "cell"], ["roletype", "widget"]]
    };
    var _default = exports.default = gridcellRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/groupRole.js
var require_groupRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/groupRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var groupRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-activedescendant": null,
        "aria-disabled": null
      },
      relatedConcepts: [{
        concept: {
          name: "details"
        },
        module: "HTML"
      }, {
        concept: {
          name: "fieldset"
        },
        module: "HTML"
      }, {
        concept: {
          name: "optgroup"
        },
        module: "HTML"
      }, {
        concept: {
          name: "address"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = groupRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/headingRole.js
var require_headingRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/headingRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var headingRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-level": "2"
      },
      relatedConcepts: [{
        concept: {
          name: "h1"
        },
        module: "HTML"
      }, {
        concept: {
          name: "h2"
        },
        module: "HTML"
      }, {
        concept: {
          name: "h3"
        },
        module: "HTML"
      }, {
        concept: {
          name: "h4"
        },
        module: "HTML"
      }, {
        concept: {
          name: "h5"
        },
        module: "HTML"
      }, {
        concept: {
          name: "h6"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-level": "2"
      },
      superClass: [["roletype", "structure", "sectionhead"]]
    };
    var _default = exports.default = headingRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/imgRole.js
var require_imgRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/imgRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var imgRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "alt"
          }],
          name: "img"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "alt"
          }],
          name: "img"
        },
        module: "HTML"
      }, {
        concept: {
          name: "imggroup"
        },
        module: "DTB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = imgRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/insertionRole.js
var require_insertionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/insertionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var insertionRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "ins"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = insertionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/linkRole.js
var require_linkRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/linkRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var linkRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-expanded": null,
        "aria-haspopup": null
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "href"
          }],
          name: "a"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "href"
          }],
          name: "area"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "command"]]
    };
    var _default = exports.default = linkRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/listRole.js
var require_listRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/listRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var listRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "menu"
        },
        module: "HTML"
      }, {
        concept: {
          name: "ol"
        },
        module: "HTML"
      }, {
        concept: {
          name: "ul"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["listitem"]],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = listRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/listboxRole.js
var require_listboxRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/listboxRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var listboxRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-invalid": null,
        "aria-multiselectable": null,
        "aria-readonly": null,
        "aria-required": null,
        "aria-orientation": "vertical"
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: [">1"],
            name: "size"
          }],
          constraints: ["the size attribute value is greater than 1"],
          name: "select"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            name: "multiple"
          }],
          name: "select"
        },
        module: "HTML"
      }, {
        concept: {
          name: "datalist"
        },
        module: "HTML"
      }, {
        concept: {
          name: "list"
        },
        module: "ARIA"
      }, {
        concept: {
          name: "select"
        },
        module: "XForms"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["option", "group"], ["option"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite", "select"], ["roletype", "structure", "section", "group", "select"]]
    };
    var _default = exports.default = listboxRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/listitemRole.js
var require_listitemRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/listitemRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var listitemRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-level": null,
        "aria-posinset": null,
        "aria-setsize": null
      },
      relatedConcepts: [{
        concept: {
          constraints: ["direct descendant of ol", "direct descendant of ul", "direct descendant of menu"],
          name: "li"
        },
        module: "HTML"
      }, {
        concept: {
          name: "item"
        },
        module: "XForms"
      }],
      requireContextRole: ["directory", "list"],
      requiredContextRole: ["directory", "list"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = listitemRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/logRole.js
var require_logRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/logRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var logRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-live": "polite"
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = logRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/mainRole.js
var require_mainRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/mainRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var mainRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "main"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = mainRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/markRole.js
var require_markRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/markRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var markRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: [],
      props: {
        "aria-braillelabel": null,
        "aria-brailleroledescription": null,
        "aria-description": null
      },
      relatedConcepts: [{
        concept: {
          name: "mark"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = markRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/marqueeRole.js
var require_marqueeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/marqueeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var marqueeRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = marqueeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/mathRole.js
var require_mathRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/mathRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var mathRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "math"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = mathRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/menuRole.js
var require_menuRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/menuRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var menuRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-orientation": "vertical"
      },
      relatedConcepts: [{
        concept: {
          name: "MENU"
        },
        module: "JAPI"
      }, {
        concept: {
          name: "list"
        },
        module: "ARIA"
      }, {
        concept: {
          name: "select"
        },
        module: "XForms"
      }, {
        concept: {
          name: "sidebar"
        },
        module: "DTB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["menuitem", "group"], ["menuitemradio", "group"], ["menuitemcheckbox", "group"], ["menuitem"], ["menuitemcheckbox"], ["menuitemradio"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite", "select"], ["roletype", "structure", "section", "group", "select"]]
    };
    var _default = exports.default = menuRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/menubarRole.js
var require_menubarRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/menubarRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var menubarRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-orientation": "horizontal"
      },
      relatedConcepts: [{
        concept: {
          name: "toolbar"
        },
        module: "ARIA"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["menuitem", "group"], ["menuitemradio", "group"], ["menuitemcheckbox", "group"], ["menuitem"], ["menuitemcheckbox"], ["menuitemradio"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite", "select", "menu"], ["roletype", "structure", "section", "group", "select", "menu"]]
    };
    var _default = exports.default = menubarRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/menuitemRole.js
var require_menuitemRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/menuitemRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var menuitemRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-posinset": null,
        "aria-setsize": null
      },
      relatedConcepts: [{
        concept: {
          name: "MENU_ITEM"
        },
        module: "JAPI"
      }, {
        concept: {
          name: "listitem"
        },
        module: "ARIA"
      }, {
        concept: {
          name: "option"
        },
        module: "ARIA"
      }],
      requireContextRole: ["group", "menu", "menubar"],
      requiredContextRole: ["group", "menu", "menubar"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "command"]]
    };
    var _default = exports.default = menuitemRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/menuitemcheckboxRole.js
var require_menuitemcheckboxRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/menuitemcheckboxRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var menuitemcheckboxRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "menuitem"
        },
        module: "ARIA"
      }],
      requireContextRole: ["group", "menu", "menubar"],
      requiredContextRole: ["group", "menu", "menubar"],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-checked": null
      },
      superClass: [["roletype", "widget", "input", "checkbox"], ["roletype", "widget", "command", "menuitem"]]
    };
    var _default = exports.default = menuitemcheckboxRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/menuitemradioRole.js
var require_menuitemradioRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/menuitemradioRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var menuitemradioRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "menuitem"
        },
        module: "ARIA"
      }],
      requireContextRole: ["group", "menu", "menubar"],
      requiredContextRole: ["group", "menu", "menubar"],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-checked": null
      },
      superClass: [["roletype", "widget", "input", "checkbox", "menuitemcheckbox"], ["roletype", "widget", "command", "menuitem", "menuitemcheckbox"], ["roletype", "widget", "input", "radio"]]
    };
    var _default = exports.default = menuitemradioRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/meterRole.js
var require_meterRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/meterRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var meterRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-valuetext": null,
        "aria-valuemax": "100",
        "aria-valuemin": "0"
      },
      relatedConcepts: [{
        concept: {
          name: "meter"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-valuenow": null
      },
      superClass: [["roletype", "structure", "range"]]
    };
    var _default = exports.default = meterRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/navigationRole.js
var require_navigationRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/navigationRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var navigationRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "nav"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = navigationRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/noneRole.js
var require_noneRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/noneRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var noneRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: [],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: []
    };
    var _default = exports.default = noneRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/noteRole.js
var require_noteRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/noteRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var noteRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = noteRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/optionRole.js
var require_optionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/optionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var optionRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-checked": null,
        "aria-posinset": null,
        "aria-setsize": null,
        "aria-selected": "false"
      },
      relatedConcepts: [{
        concept: {
          name: "item"
        },
        module: "XForms"
      }, {
        concept: {
          name: "listitem"
        },
        module: "ARIA"
      }, {
        concept: {
          name: "option"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-selected": "false"
      },
      superClass: [["roletype", "widget", "input"]]
    };
    var _default = exports.default = optionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/paragraphRole.js
var require_paragraphRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/paragraphRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var paragraphRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "p"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = paragraphRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/presentationRole.js
var require_presentationRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/presentationRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var presentationRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          attributes: [{
            name: "alt",
            value: ""
          }],
          name: "img"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = presentationRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/progressbarRole.js
var require_progressbarRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/progressbarRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var progressbarRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-valuetext": null
      },
      relatedConcepts: [{
        concept: {
          name: "progress"
        },
        module: "HTML"
      }, {
        concept: {
          name: "status"
        },
        module: "ARIA"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "range"], ["roletype", "widget"]]
    };
    var _default = exports.default = progressbarRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/radioRole.js
var require_radioRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/radioRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var radioRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-checked": null,
        "aria-posinset": null,
        "aria-setsize": null
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            name: "type",
            value: "radio"
          }],
          name: "input"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-checked": null
      },
      superClass: [["roletype", "widget", "input"]]
    };
    var _default = exports.default = radioRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/radiogroupRole.js
var require_radiogroupRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/radiogroupRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var radiogroupRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-invalid": null,
        "aria-readonly": null,
        "aria-required": null
      },
      relatedConcepts: [{
        concept: {
          name: "list"
        },
        module: "ARIA"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["radio"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite", "select"], ["roletype", "structure", "section", "group", "select"]]
    };
    var _default = exports.default = radiogroupRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/regionRole.js
var require_regionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/regionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var regionRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "aria-label"
          }],
          name: "section"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["set"],
            name: "aria-labelledby"
          }],
          name: "section"
        },
        module: "HTML"
      }, {
        concept: {
          name: "Device Independence Glossart perceivable unit"
        }
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = regionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/rowRole.js
var require_rowRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/rowRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var rowRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-colindex": null,
        "aria-expanded": null,
        "aria-level": null,
        "aria-posinset": null,
        "aria-rowindex": null,
        "aria-selected": null,
        "aria-setsize": null
      },
      relatedConcepts: [{
        concept: {
          name: "tr"
        },
        module: "HTML"
      }],
      requireContextRole: ["grid", "rowgroup", "table", "treegrid"],
      requiredContextRole: ["grid", "rowgroup", "table", "treegrid"],
      requiredOwnedElements: [["cell"], ["columnheader"], ["gridcell"], ["rowheader"]],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "group"], ["roletype", "widget"]]
    };
    var _default = exports.default = rowRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/rowgroupRole.js
var require_rowgroupRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/rowgroupRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var rowgroupRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "tbody"
        },
        module: "HTML"
      }, {
        concept: {
          name: "tfoot"
        },
        module: "HTML"
      }, {
        concept: {
          name: "thead"
        },
        module: "HTML"
      }],
      requireContextRole: ["grid", "table", "treegrid"],
      requiredContextRole: ["grid", "table", "treegrid"],
      requiredOwnedElements: [["row"]],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = rowgroupRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/rowheaderRole.js
var require_rowheaderRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/rowheaderRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var rowheaderRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-sort": null
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            name: "scope",
            value: "row"
          }],
          name: "th"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            name: "scope",
            value: "rowgroup"
          }],
          name: "th"
        },
        module: "HTML"
      }],
      requireContextRole: ["row", "rowgroup"],
      requiredContextRole: ["row", "rowgroup"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "cell"], ["roletype", "structure", "section", "cell", "gridcell"], ["roletype", "widget", "gridcell"], ["roletype", "structure", "sectionhead"]]
    };
    var _default = exports.default = rowheaderRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/scrollbarRole.js
var require_scrollbarRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/scrollbarRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var scrollbarRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-valuetext": null,
        "aria-orientation": "vertical",
        "aria-valuemax": "100",
        "aria-valuemin": "0"
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-controls": null,
        "aria-valuenow": null
      },
      superClass: [["roletype", "structure", "range"], ["roletype", "widget"]]
    };
    var _default = exports.default = scrollbarRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/searchRole.js
var require_searchRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/searchRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var searchRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = searchRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/searchboxRole.js
var require_searchboxRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/searchboxRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var searchboxRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "list"
          }, {
            name: "type",
            value: "search"
          }],
          constraints: ["the list attribute is not set"],
          name: "input"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "input", "textbox"]]
    };
    var _default = exports.default = searchboxRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/separatorRole.js
var require_separatorRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/separatorRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var separatorRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-orientation": "horizontal",
        "aria-valuemax": "100",
        "aria-valuemin": "0",
        "aria-valuenow": null,
        "aria-valuetext": null
      },
      relatedConcepts: [{
        concept: {
          name: "hr"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure"]]
    };
    var _default = exports.default = separatorRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/sliderRole.js
var require_sliderRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/sliderRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var sliderRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-haspopup": null,
        "aria-invalid": null,
        "aria-readonly": null,
        "aria-valuetext": null,
        "aria-orientation": "horizontal",
        "aria-valuemax": "100",
        "aria-valuemin": "0"
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            name: "type",
            value: "range"
          }],
          name: "input"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-valuenow": null
      },
      superClass: [["roletype", "widget", "input"], ["roletype", "structure", "range"]]
    };
    var _default = exports.default = sliderRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/spinbuttonRole.js
var require_spinbuttonRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/spinbuttonRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var spinbuttonRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-invalid": null,
        "aria-readonly": null,
        "aria-required": null,
        "aria-valuetext": null,
        "aria-valuenow": "0"
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            name: "type",
            value: "number"
          }],
          name: "input"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite"], ["roletype", "widget", "input"], ["roletype", "structure", "range"]]
    };
    var _default = exports.default = spinbuttonRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/statusRole.js
var require_statusRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/statusRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var statusRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-atomic": "true",
        "aria-live": "polite"
      },
      relatedConcepts: [{
        concept: {
          name: "output"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = statusRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/strongRole.js
var require_strongRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/strongRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var strongRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "strong"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = strongRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/subscriptRole.js
var require_subscriptRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/subscriptRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var subscriptRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "sub"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = subscriptRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/superscriptRole.js
var require_superscriptRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/superscriptRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var superscriptRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: ["aria-label", "aria-labelledby"],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "sup"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = superscriptRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/switchRole.js
var require_switchRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/switchRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var switchRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "button"
        },
        module: "ARIA"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-checked": null
      },
      superClass: [["roletype", "widget", "input", "checkbox"]]
    };
    var _default = exports.default = switchRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/tabRole.js
var require_tabRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/tabRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var tabRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-posinset": null,
        "aria-setsize": null,
        "aria-selected": "false"
      },
      relatedConcepts: [],
      requireContextRole: ["tablist"],
      requiredContextRole: ["tablist"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "sectionhead"], ["roletype", "widget"]]
    };
    var _default = exports.default = tabRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/tableRole.js
var require_tableRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/tableRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var tableRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-colcount": null,
        "aria-rowcount": null
      },
      relatedConcepts: [{
        concept: {
          name: "table"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["row"], ["row", "rowgroup"]],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = tableRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/tablistRole.js
var require_tablistRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/tablistRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var tablistRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-level": null,
        "aria-multiselectable": null,
        "aria-orientation": "horizontal"
      },
      relatedConcepts: [{
        module: "DAISY",
        concept: {
          name: "guide"
        }
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["tab"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite"]]
    };
    var _default = exports.default = tablistRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/tabpanelRole.js
var require_tabpanelRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/tabpanelRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var tabpanelRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = tabpanelRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/termRole.js
var require_termRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/termRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var termRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "dfn"
        },
        module: "HTML"
      }, {
        concept: {
          name: "dt"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = termRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/textboxRole.js
var require_textboxRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/textboxRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var textboxRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-activedescendant": null,
        "aria-autocomplete": null,
        "aria-errormessage": null,
        "aria-haspopup": null,
        "aria-invalid": null,
        "aria-multiline": null,
        "aria-placeholder": null,
        "aria-readonly": null,
        "aria-required": null
      },
      relatedConcepts: [{
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "type"
          }, {
            constraints: ["undefined"],
            name: "list"
          }],
          constraints: ["the list attribute is not set"],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "list"
          }, {
            name: "type",
            value: "email"
          }],
          constraints: ["the list attribute is not set"],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "list"
          }, {
            name: "type",
            value: "tel"
          }],
          constraints: ["the list attribute is not set"],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "list"
          }, {
            name: "type",
            value: "text"
          }],
          constraints: ["the list attribute is not set"],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          attributes: [{
            constraints: ["undefined"],
            name: "list"
          }, {
            name: "type",
            value: "url"
          }],
          constraints: ["the list attribute is not set"],
          name: "input"
        },
        module: "HTML"
      }, {
        concept: {
          name: "input"
        },
        module: "XForms"
      }, {
        concept: {
          name: "textarea"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "input"]]
    };
    var _default = exports.default = textboxRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/timeRole.js
var require_timeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/timeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var timeRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "time"
        },
        module: "HTML"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = timeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/timerRole.js
var require_timerRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/timerRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var timerRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "status"]]
    };
    var _default = exports.default = timerRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/toolbarRole.js
var require_toolbarRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/toolbarRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var toolbarRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-orientation": "horizontal"
      },
      relatedConcepts: [{
        concept: {
          name: "menubar"
        },
        module: "ARIA"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "group"]]
    };
    var _default = exports.default = toolbarRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/tooltipRole.js
var require_tooltipRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/tooltipRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var tooltipRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = tooltipRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/treeRole.js
var require_treeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/treeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var treeRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-invalid": null,
        "aria-multiselectable": null,
        "aria-required": null,
        "aria-orientation": "vertical"
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["treeitem", "group"], ["treeitem"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite", "select"], ["roletype", "structure", "section", "group", "select"]]
    };
    var _default = exports.default = treeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/treegridRole.js
var require_treegridRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/treegridRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var treegridRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["row"], ["row", "rowgroup"]],
      requiredProps: {},
      superClass: [["roletype", "widget", "composite", "grid"], ["roletype", "structure", "section", "table", "grid"], ["roletype", "widget", "composite", "select", "tree"], ["roletype", "structure", "section", "group", "select", "tree"]]
    };
    var _default = exports.default = treegridRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/literal/treeitemRole.js
var require_treeitemRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/literal/treeitemRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var treeitemRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-expanded": null,
        "aria-haspopup": null
      },
      relatedConcepts: [],
      requireContextRole: ["group", "tree"],
      requiredContextRole: ["group", "tree"],
      requiredOwnedElements: [],
      requiredProps: {
        "aria-selected": null
      },
      superClass: [["roletype", "structure", "section", "listitem"], ["roletype", "widget", "input", "option"]]
    };
    var _default = exports.default = treeitemRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/ariaLiteralRoles.js
var require_ariaLiteralRoles = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/ariaLiteralRoles.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _alertRole = _interopRequireDefault(require_alertRole());
    var _alertdialogRole = _interopRequireDefault(require_alertdialogRole());
    var _applicationRole = _interopRequireDefault(require_applicationRole());
    var _articleRole = _interopRequireDefault(require_articleRole());
    var _bannerRole = _interopRequireDefault(require_bannerRole());
    var _blockquoteRole = _interopRequireDefault(require_blockquoteRole());
    var _buttonRole = _interopRequireDefault(require_buttonRole());
    var _captionRole = _interopRequireDefault(require_captionRole());
    var _cellRole = _interopRequireDefault(require_cellRole());
    var _checkboxRole = _interopRequireDefault(require_checkboxRole());
    var _codeRole = _interopRequireDefault(require_codeRole());
    var _columnheaderRole = _interopRequireDefault(require_columnheaderRole());
    var _comboboxRole = _interopRequireDefault(require_comboboxRole());
    var _complementaryRole = _interopRequireDefault(require_complementaryRole());
    var _contentinfoRole = _interopRequireDefault(require_contentinfoRole());
    var _definitionRole = _interopRequireDefault(require_definitionRole());
    var _deletionRole = _interopRequireDefault(require_deletionRole());
    var _dialogRole = _interopRequireDefault(require_dialogRole());
    var _directoryRole = _interopRequireDefault(require_directoryRole());
    var _documentRole = _interopRequireDefault(require_documentRole());
    var _emphasisRole = _interopRequireDefault(require_emphasisRole());
    var _feedRole = _interopRequireDefault(require_feedRole());
    var _figureRole = _interopRequireDefault(require_figureRole());
    var _formRole = _interopRequireDefault(require_formRole());
    var _genericRole = _interopRequireDefault(require_genericRole());
    var _gridRole = _interopRequireDefault(require_gridRole());
    var _gridcellRole = _interopRequireDefault(require_gridcellRole());
    var _groupRole = _interopRequireDefault(require_groupRole());
    var _headingRole = _interopRequireDefault(require_headingRole());
    var _imgRole = _interopRequireDefault(require_imgRole());
    var _insertionRole = _interopRequireDefault(require_insertionRole());
    var _linkRole = _interopRequireDefault(require_linkRole());
    var _listRole = _interopRequireDefault(require_listRole());
    var _listboxRole = _interopRequireDefault(require_listboxRole());
    var _listitemRole = _interopRequireDefault(require_listitemRole());
    var _logRole = _interopRequireDefault(require_logRole());
    var _mainRole = _interopRequireDefault(require_mainRole());
    var _markRole = _interopRequireDefault(require_markRole());
    var _marqueeRole = _interopRequireDefault(require_marqueeRole());
    var _mathRole = _interopRequireDefault(require_mathRole());
    var _menuRole = _interopRequireDefault(require_menuRole());
    var _menubarRole = _interopRequireDefault(require_menubarRole());
    var _menuitemRole = _interopRequireDefault(require_menuitemRole());
    var _menuitemcheckboxRole = _interopRequireDefault(require_menuitemcheckboxRole());
    var _menuitemradioRole = _interopRequireDefault(require_menuitemradioRole());
    var _meterRole = _interopRequireDefault(require_meterRole());
    var _navigationRole = _interopRequireDefault(require_navigationRole());
    var _noneRole = _interopRequireDefault(require_noneRole());
    var _noteRole = _interopRequireDefault(require_noteRole());
    var _optionRole = _interopRequireDefault(require_optionRole());
    var _paragraphRole = _interopRequireDefault(require_paragraphRole());
    var _presentationRole = _interopRequireDefault(require_presentationRole());
    var _progressbarRole = _interopRequireDefault(require_progressbarRole());
    var _radioRole = _interopRequireDefault(require_radioRole());
    var _radiogroupRole = _interopRequireDefault(require_radiogroupRole());
    var _regionRole = _interopRequireDefault(require_regionRole());
    var _rowRole = _interopRequireDefault(require_rowRole());
    var _rowgroupRole = _interopRequireDefault(require_rowgroupRole());
    var _rowheaderRole = _interopRequireDefault(require_rowheaderRole());
    var _scrollbarRole = _interopRequireDefault(require_scrollbarRole());
    var _searchRole = _interopRequireDefault(require_searchRole());
    var _searchboxRole = _interopRequireDefault(require_searchboxRole());
    var _separatorRole = _interopRequireDefault(require_separatorRole());
    var _sliderRole = _interopRequireDefault(require_sliderRole());
    var _spinbuttonRole = _interopRequireDefault(require_spinbuttonRole());
    var _statusRole = _interopRequireDefault(require_statusRole());
    var _strongRole = _interopRequireDefault(require_strongRole());
    var _subscriptRole = _interopRequireDefault(require_subscriptRole());
    var _superscriptRole = _interopRequireDefault(require_superscriptRole());
    var _switchRole = _interopRequireDefault(require_switchRole());
    var _tabRole = _interopRequireDefault(require_tabRole());
    var _tableRole = _interopRequireDefault(require_tableRole());
    var _tablistRole = _interopRequireDefault(require_tablistRole());
    var _tabpanelRole = _interopRequireDefault(require_tabpanelRole());
    var _termRole = _interopRequireDefault(require_termRole());
    var _textboxRole = _interopRequireDefault(require_textboxRole());
    var _timeRole = _interopRequireDefault(require_timeRole());
    var _timerRole = _interopRequireDefault(require_timerRole());
    var _toolbarRole = _interopRequireDefault(require_toolbarRole());
    var _tooltipRole = _interopRequireDefault(require_tooltipRole());
    var _treeRole = _interopRequireDefault(require_treeRole());
    var _treegridRole = _interopRequireDefault(require_treegridRole());
    var _treeitemRole = _interopRequireDefault(require_treeitemRole());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var ariaLiteralRoles = [["alert", _alertRole.default], ["alertdialog", _alertdialogRole.default], ["application", _applicationRole.default], ["article", _articleRole.default], ["banner", _bannerRole.default], ["blockquote", _blockquoteRole.default], ["button", _buttonRole.default], ["caption", _captionRole.default], ["cell", _cellRole.default], ["checkbox", _checkboxRole.default], ["code", _codeRole.default], ["columnheader", _columnheaderRole.default], ["combobox", _comboboxRole.default], ["complementary", _complementaryRole.default], ["contentinfo", _contentinfoRole.default], ["definition", _definitionRole.default], ["deletion", _deletionRole.default], ["dialog", _dialogRole.default], ["directory", _directoryRole.default], ["document", _documentRole.default], ["emphasis", _emphasisRole.default], ["feed", _feedRole.default], ["figure", _figureRole.default], ["form", _formRole.default], ["generic", _genericRole.default], ["grid", _gridRole.default], ["gridcell", _gridcellRole.default], ["group", _groupRole.default], ["heading", _headingRole.default], ["img", _imgRole.default], ["insertion", _insertionRole.default], ["link", _linkRole.default], ["list", _listRole.default], ["listbox", _listboxRole.default], ["listitem", _listitemRole.default], ["log", _logRole.default], ["main", _mainRole.default], ["mark", _markRole.default], ["marquee", _marqueeRole.default], ["math", _mathRole.default], ["menu", _menuRole.default], ["menubar", _menubarRole.default], ["menuitem", _menuitemRole.default], ["menuitemcheckbox", _menuitemcheckboxRole.default], ["menuitemradio", _menuitemradioRole.default], ["meter", _meterRole.default], ["navigation", _navigationRole.default], ["none", _noneRole.default], ["note", _noteRole.default], ["option", _optionRole.default], ["paragraph", _paragraphRole.default], ["presentation", _presentationRole.default], ["progressbar", _progressbarRole.default], ["radio", _radioRole.default], ["radiogroup", _radiogroupRole.default], ["region", _regionRole.default], ["row", _rowRole.default], ["rowgroup", _rowgroupRole.default], ["rowheader", _rowheaderRole.default], ["scrollbar", _scrollbarRole.default], ["search", _searchRole.default], ["searchbox", _searchboxRole.default], ["separator", _separatorRole.default], ["slider", _sliderRole.default], ["spinbutton", _spinbuttonRole.default], ["status", _statusRole.default], ["strong", _strongRole.default], ["subscript", _subscriptRole.default], ["superscript", _superscriptRole.default], ["switch", _switchRole.default], ["tab", _tabRole.default], ["table", _tableRole.default], ["tablist", _tablistRole.default], ["tabpanel", _tabpanelRole.default], ["term", _termRole.default], ["textbox", _textboxRole.default], ["time", _timeRole.default], ["timer", _timerRole.default], ["toolbar", _toolbarRole.default], ["tooltip", _tooltipRole.default], ["tree", _treeRole.default], ["treegrid", _treegridRole.default], ["treeitem", _treeitemRole.default]];
    var _default = exports.default = ariaLiteralRoles;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docAbstractRole.js
var require_docAbstractRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docAbstractRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docAbstractRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "abstract [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docAbstractRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docAcknowledgmentsRole.js
var require_docAcknowledgmentsRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docAcknowledgmentsRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docAcknowledgmentsRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "acknowledgments [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docAcknowledgmentsRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docAfterwordRole.js
var require_docAfterwordRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docAfterwordRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docAfterwordRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "afterword [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docAfterwordRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docAppendixRole.js
var require_docAppendixRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docAppendixRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docAppendixRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "appendix [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docAppendixRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docBacklinkRole.js
var require_docBacklinkRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docBacklinkRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docBacklinkRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "referrer [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "command", "link"]]
    };
    var _default = exports.default = docBacklinkRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docBiblioentryRole.js
var require_docBiblioentryRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docBiblioentryRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docBiblioentryRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "EPUB biblioentry [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: ["doc-bibliography"],
      requiredContextRole: ["doc-bibliography"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "listitem"]]
    };
    var _default = exports.default = docBiblioentryRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docBibliographyRole.js
var require_docBibliographyRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docBibliographyRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docBibliographyRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "bibliography [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["doc-biblioentry"]],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docBibliographyRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docBibliorefRole.js
var require_docBibliorefRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docBibliorefRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docBibliorefRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "biblioref [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "command", "link"]]
    };
    var _default = exports.default = docBibliorefRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docChapterRole.js
var require_docChapterRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docChapterRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docChapterRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "chapter [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docChapterRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docColophonRole.js
var require_docColophonRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docColophonRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docColophonRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "colophon [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docColophonRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docConclusionRole.js
var require_docConclusionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docConclusionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docConclusionRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "conclusion [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docConclusionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docCoverRole.js
var require_docCoverRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docCoverRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docCoverRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "cover [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "img"]]
    };
    var _default = exports.default = docCoverRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docCreditRole.js
var require_docCreditRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docCreditRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docCreditRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "credit [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docCreditRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docCreditsRole.js
var require_docCreditsRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docCreditsRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docCreditsRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "credits [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docCreditsRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docDedicationRole.js
var require_docDedicationRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docDedicationRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docDedicationRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "dedication [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docDedicationRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docEndnoteRole.js
var require_docEndnoteRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docEndnoteRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docEndnoteRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "rearnote [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: ["doc-endnotes"],
      requiredContextRole: ["doc-endnotes"],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "listitem"]]
    };
    var _default = exports.default = docEndnoteRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docEndnotesRole.js
var require_docEndnotesRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docEndnotesRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docEndnotesRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "rearnotes [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["doc-endnote"]],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docEndnotesRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docEpigraphRole.js
var require_docEpigraphRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docEpigraphRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docEpigraphRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "epigraph [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docEpigraphRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docEpilogueRole.js
var require_docEpilogueRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docEpilogueRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docEpilogueRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "epilogue [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docEpilogueRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docErrataRole.js
var require_docErrataRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docErrataRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docErrataRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "errata [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docErrataRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docExampleRole.js
var require_docExampleRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docExampleRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docExampleRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docExampleRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docFootnoteRole.js
var require_docFootnoteRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docFootnoteRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docFootnoteRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "footnote [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docFootnoteRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docForewordRole.js
var require_docForewordRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docForewordRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docForewordRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "foreword [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docForewordRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docGlossaryRole.js
var require_docGlossaryRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docGlossaryRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docGlossaryRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "glossary [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [["definition"], ["term"]],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docGlossaryRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docGlossrefRole.js
var require_docGlossrefRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docGlossrefRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docGlossrefRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "glossref [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "command", "link"]]
    };
    var _default = exports.default = docGlossrefRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docIndexRole.js
var require_docIndexRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docIndexRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docIndexRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "index [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark", "navigation"]]
    };
    var _default = exports.default = docIndexRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docIntroductionRole.js
var require_docIntroductionRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docIntroductionRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docIntroductionRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "introduction [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docIntroductionRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docNoterefRole.js
var require_docNoterefRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docNoterefRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docNoterefRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "noteref [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "widget", "command", "link"]]
    };
    var _default = exports.default = docNoterefRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docNoticeRole.js
var require_docNoticeRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docNoticeRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docNoticeRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "notice [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "note"]]
    };
    var _default = exports.default = docNoticeRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPagebreakRole.js
var require_docPagebreakRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPagebreakRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPagebreakRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "pagebreak [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "separator"]]
    };
    var _default = exports.default = docPagebreakRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPagefooterRole.js
var require_docPagefooterRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPagefooterRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPagefooterRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: [],
      props: {
        "aria-braillelabel": null,
        "aria-brailleroledescription": null,
        "aria-description": null,
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docPagefooterRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPageheaderRole.js
var require_docPageheaderRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPageheaderRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPageheaderRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["prohibited"],
      prohibitedProps: [],
      props: {
        "aria-braillelabel": null,
        "aria-brailleroledescription": null,
        "aria-description": null,
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docPageheaderRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPagelistRole.js
var require_docPagelistRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPagelistRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPagelistRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "page-list [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark", "navigation"]]
    };
    var _default = exports.default = docPagelistRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPartRole.js
var require_docPartRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPartRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPartRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "part [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docPartRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPrefaceRole.js
var require_docPrefaceRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPrefaceRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPrefaceRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "preface [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docPrefaceRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPrologueRole.js
var require_docPrologueRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPrologueRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPrologueRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "prologue [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark"]]
    };
    var _default = exports.default = docPrologueRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docPullquoteRole.js
var require_docPullquoteRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docPullquoteRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docPullquoteRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {},
      relatedConcepts: [{
        concept: {
          name: "pullquote [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["none"]]
    };
    var _default = exports.default = docPullquoteRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docQnaRole.js
var require_docQnaRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docQnaRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docQnaRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "qna [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section"]]
    };
    var _default = exports.default = docQnaRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docSubtitleRole.js
var require_docSubtitleRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docSubtitleRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docSubtitleRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "subtitle [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "sectionhead"]]
    };
    var _default = exports.default = docSubtitleRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docTipRole.js
var require_docTipRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docTipRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docTipRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "help [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "note"]]
    };
    var _default = exports.default = docTipRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/dpub/docTocRole.js
var require_docTocRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/dpub/docTocRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var docTocRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        concept: {
          name: "toc [EPUB-SSV]"
        },
        module: "EPUB"
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "landmark", "navigation"]]
    };
    var _default = exports.default = docTocRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/ariaDpubRoles.js
var require_ariaDpubRoles = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/ariaDpubRoles.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _docAbstractRole = _interopRequireDefault(require_docAbstractRole());
    var _docAcknowledgmentsRole = _interopRequireDefault(require_docAcknowledgmentsRole());
    var _docAfterwordRole = _interopRequireDefault(require_docAfterwordRole());
    var _docAppendixRole = _interopRequireDefault(require_docAppendixRole());
    var _docBacklinkRole = _interopRequireDefault(require_docBacklinkRole());
    var _docBiblioentryRole = _interopRequireDefault(require_docBiblioentryRole());
    var _docBibliographyRole = _interopRequireDefault(require_docBibliographyRole());
    var _docBibliorefRole = _interopRequireDefault(require_docBibliorefRole());
    var _docChapterRole = _interopRequireDefault(require_docChapterRole());
    var _docColophonRole = _interopRequireDefault(require_docColophonRole());
    var _docConclusionRole = _interopRequireDefault(require_docConclusionRole());
    var _docCoverRole = _interopRequireDefault(require_docCoverRole());
    var _docCreditRole = _interopRequireDefault(require_docCreditRole());
    var _docCreditsRole = _interopRequireDefault(require_docCreditsRole());
    var _docDedicationRole = _interopRequireDefault(require_docDedicationRole());
    var _docEndnoteRole = _interopRequireDefault(require_docEndnoteRole());
    var _docEndnotesRole = _interopRequireDefault(require_docEndnotesRole());
    var _docEpigraphRole = _interopRequireDefault(require_docEpigraphRole());
    var _docEpilogueRole = _interopRequireDefault(require_docEpilogueRole());
    var _docErrataRole = _interopRequireDefault(require_docErrataRole());
    var _docExampleRole = _interopRequireDefault(require_docExampleRole());
    var _docFootnoteRole = _interopRequireDefault(require_docFootnoteRole());
    var _docForewordRole = _interopRequireDefault(require_docForewordRole());
    var _docGlossaryRole = _interopRequireDefault(require_docGlossaryRole());
    var _docGlossrefRole = _interopRequireDefault(require_docGlossrefRole());
    var _docIndexRole = _interopRequireDefault(require_docIndexRole());
    var _docIntroductionRole = _interopRequireDefault(require_docIntroductionRole());
    var _docNoterefRole = _interopRequireDefault(require_docNoterefRole());
    var _docNoticeRole = _interopRequireDefault(require_docNoticeRole());
    var _docPagebreakRole = _interopRequireDefault(require_docPagebreakRole());
    var _docPagefooterRole = _interopRequireDefault(require_docPagefooterRole());
    var _docPageheaderRole = _interopRequireDefault(require_docPageheaderRole());
    var _docPagelistRole = _interopRequireDefault(require_docPagelistRole());
    var _docPartRole = _interopRequireDefault(require_docPartRole());
    var _docPrefaceRole = _interopRequireDefault(require_docPrefaceRole());
    var _docPrologueRole = _interopRequireDefault(require_docPrologueRole());
    var _docPullquoteRole = _interopRequireDefault(require_docPullquoteRole());
    var _docQnaRole = _interopRequireDefault(require_docQnaRole());
    var _docSubtitleRole = _interopRequireDefault(require_docSubtitleRole());
    var _docTipRole = _interopRequireDefault(require_docTipRole());
    var _docTocRole = _interopRequireDefault(require_docTocRole());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var ariaDpubRoles = [["doc-abstract", _docAbstractRole.default], ["doc-acknowledgments", _docAcknowledgmentsRole.default], ["doc-afterword", _docAfterwordRole.default], ["doc-appendix", _docAppendixRole.default], ["doc-backlink", _docBacklinkRole.default], ["doc-biblioentry", _docBiblioentryRole.default], ["doc-bibliography", _docBibliographyRole.default], ["doc-biblioref", _docBibliorefRole.default], ["doc-chapter", _docChapterRole.default], ["doc-colophon", _docColophonRole.default], ["doc-conclusion", _docConclusionRole.default], ["doc-cover", _docCoverRole.default], ["doc-credit", _docCreditRole.default], ["doc-credits", _docCreditsRole.default], ["doc-dedication", _docDedicationRole.default], ["doc-endnote", _docEndnoteRole.default], ["doc-endnotes", _docEndnotesRole.default], ["doc-epigraph", _docEpigraphRole.default], ["doc-epilogue", _docEpilogueRole.default], ["doc-errata", _docErrataRole.default], ["doc-example", _docExampleRole.default], ["doc-footnote", _docFootnoteRole.default], ["doc-foreword", _docForewordRole.default], ["doc-glossary", _docGlossaryRole.default], ["doc-glossref", _docGlossrefRole.default], ["doc-index", _docIndexRole.default], ["doc-introduction", _docIntroductionRole.default], ["doc-noteref", _docNoterefRole.default], ["doc-notice", _docNoticeRole.default], ["doc-pagebreak", _docPagebreakRole.default], ["doc-pagefooter", _docPagefooterRole.default], ["doc-pageheader", _docPageheaderRole.default], ["doc-pagelist", _docPagelistRole.default], ["doc-part", _docPartRole.default], ["doc-preface", _docPrefaceRole.default], ["doc-prologue", _docPrologueRole.default], ["doc-pullquote", _docPullquoteRole.default], ["doc-qna", _docQnaRole.default], ["doc-subtitle", _docSubtitleRole.default], ["doc-tip", _docTipRole.default], ["doc-toc", _docTocRole.default]];
    var _default = exports.default = ariaDpubRoles;
  }
});

// ../node_modules/aria-query/lib/etc/roles/graphics/graphicsDocumentRole.js
var require_graphicsDocumentRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/graphics/graphicsDocumentRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var graphicsDocumentRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        module: "GRAPHICS",
        concept: {
          name: "graphics-object"
        }
      }, {
        module: "ARIA",
        concept: {
          name: "img"
        }
      }, {
        module: "ARIA",
        concept: {
          name: "article"
        }
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "document"]]
    };
    var _default = exports.default = graphicsDocumentRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/graphics/graphicsObjectRole.js
var require_graphicsObjectRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/graphics/graphicsObjectRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var graphicsObjectRole = {
      abstract: false,
      accessibleNameRequired: false,
      baseConcepts: [],
      childrenPresentational: false,
      nameFrom: ["author", "contents"],
      prohibitedProps: [],
      props: {
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [{
        module: "GRAPHICS",
        concept: {
          name: "graphics-document"
        }
      }, {
        module: "ARIA",
        concept: {
          name: "group"
        }
      }, {
        module: "ARIA",
        concept: {
          name: "img"
        }
      }, {
        module: "GRAPHICS",
        concept: {
          name: "graphics-symbol"
        }
      }],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "group"]]
    };
    var _default = exports.default = graphicsObjectRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/graphics/graphicsSymbolRole.js
var require_graphicsSymbolRole = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/graphics/graphicsSymbolRole.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var graphicsSymbolRole = {
      abstract: false,
      accessibleNameRequired: true,
      baseConcepts: [],
      childrenPresentational: true,
      nameFrom: ["author"],
      prohibitedProps: [],
      props: {
        "aria-disabled": null,
        "aria-errormessage": null,
        "aria-expanded": null,
        "aria-haspopup": null,
        "aria-invalid": null
      },
      relatedConcepts: [],
      requireContextRole: [],
      requiredContextRole: [],
      requiredOwnedElements: [],
      requiredProps: {},
      superClass: [["roletype", "structure", "section", "img"]]
    };
    var _default = exports.default = graphicsSymbolRole;
  }
});

// ../node_modules/aria-query/lib/etc/roles/ariaGraphicsRoles.js
var require_ariaGraphicsRoles = __commonJS({
  "../node_modules/aria-query/lib/etc/roles/ariaGraphicsRoles.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _graphicsDocumentRole = _interopRequireDefault(require_graphicsDocumentRole());
    var _graphicsObjectRole = _interopRequireDefault(require_graphicsObjectRole());
    var _graphicsSymbolRole = _interopRequireDefault(require_graphicsSymbolRole());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var ariaGraphicsRoles = [["graphics-document", _graphicsDocumentRole.default], ["graphics-object", _graphicsObjectRole.default], ["graphics-symbol", _graphicsSymbolRole.default]];
    var _default = exports.default = ariaGraphicsRoles;
  }
});

// ../node_modules/aria-query/lib/rolesMap.js
var require_rolesMap = __commonJS({
  "../node_modules/aria-query/lib/rolesMap.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _ariaAbstractRoles = _interopRequireDefault(require_ariaAbstractRoles());
    var _ariaLiteralRoles = _interopRequireDefault(require_ariaLiteralRoles());
    var _ariaDpubRoles = _interopRequireDefault(require_ariaDpubRoles());
    var _ariaGraphicsRoles = _interopRequireDefault(require_ariaGraphicsRoles());
    var _iterationDecorator = _interopRequireDefault(require_iterationDecorator());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    function _createForOfIteratorHelper(r2, e2) {
      var t2 = "undefined" != typeof Symbol && r2[Symbol.iterator] || r2["@@iterator"];
      if (!t2) {
        if (Array.isArray(r2) || (t2 = _unsupportedIterableToArray(r2)) || e2 && r2 && "number" == typeof r2.length) {
          t2 && (r2 = t2);
          var _n = 0, F = /* @__PURE__ */ __name(function F2() {
          }, "F");
          return { s: F, n: /* @__PURE__ */ __name(function n2() {
            return _n >= r2.length ? { done: true } : { done: false, value: r2[_n++] };
          }, "n"), e: /* @__PURE__ */ __name(function e3(r3) {
            throw r3;
          }, "e"), f: F };
        }
        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
      }
      var o2, a = true, u3 = false;
      return { s: /* @__PURE__ */ __name(function s3() {
        t2 = t2.call(r2);
      }, "s"), n: /* @__PURE__ */ __name(function n2() {
        var r3 = t2.next();
        return a = r3.done, r3;
      }, "n"), e: /* @__PURE__ */ __name(function e3(r3) {
        u3 = true, o2 = r3;
      }, "e"), f: /* @__PURE__ */ __name(function f3() {
        try {
          a || null == t2.return || t2.return();
        } finally {
          if (u3) throw o2;
        }
      }, "f") };
    }
    __name(_createForOfIteratorHelper, "_createForOfIteratorHelper");
    function _slicedToArray(r2, e2) {
      return _arrayWithHoles(r2) || _iterableToArrayLimit(r2, e2) || _unsupportedIterableToArray(r2, e2) || _nonIterableRest();
    }
    __name(_slicedToArray, "_slicedToArray");
    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    __name(_nonIterableRest, "_nonIterableRest");
    function _unsupportedIterableToArray(r2, a) {
      if (r2) {
        if ("string" == typeof r2) return _arrayLikeToArray(r2, a);
        var t2 = {}.toString.call(r2).slice(8, -1);
        return "Object" === t2 && r2.constructor && (t2 = r2.constructor.name), "Map" === t2 || "Set" === t2 ? Array.from(r2) : "Arguments" === t2 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t2) ? _arrayLikeToArray(r2, a) : void 0;
      }
    }
    __name(_unsupportedIterableToArray, "_unsupportedIterableToArray");
    function _arrayLikeToArray(r2, a) {
      (null == a || a > r2.length) && (a = r2.length);
      for (var e2 = 0, n2 = Array(a); e2 < a; e2++) n2[e2] = r2[e2];
      return n2;
    }
    __name(_arrayLikeToArray, "_arrayLikeToArray");
    function _iterableToArrayLimit(r2, l2) {
      var t2 = null == r2 ? null : "undefined" != typeof Symbol && r2[Symbol.iterator] || r2["@@iterator"];
      if (null != t2) {
        var e2, n2, i2, u3, a = [], f3 = true, o2 = false;
        try {
          if (i2 = (t2 = t2.call(r2)).next, 0 === l2) {
            if (Object(t2) !== t2) return;
            f3 = false;
          } else for (; !(f3 = (e2 = i2.call(t2)).done) && (a.push(e2.value), a.length !== l2); f3 = true) ;
        } catch (r3) {
          o2 = true, n2 = r3;
        } finally {
          try {
            if (!f3 && null != t2.return && (u3 = t2.return(), Object(u3) !== u3)) return;
          } finally {
            if (o2) throw n2;
          }
        }
        return a;
      }
    }
    __name(_iterableToArrayLimit, "_iterableToArrayLimit");
    function _arrayWithHoles(r2) {
      if (Array.isArray(r2)) return r2;
    }
    __name(_arrayWithHoles, "_arrayWithHoles");
    var roles3 = [].concat(_ariaAbstractRoles.default, _ariaLiteralRoles.default, _ariaDpubRoles.default, _ariaGraphicsRoles.default);
    roles3.forEach(function(_ref) {
      var _ref2 = _slicedToArray(_ref, 2), roleDefinition = _ref2[1];
      var _iterator = _createForOfIteratorHelper(roleDefinition.superClass), _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done; ) {
          var superClassIter = _step.value;
          var _iterator2 = _createForOfIteratorHelper(superClassIter), _step2;
          try {
            var _loop = /* @__PURE__ */ __name(function _loop2() {
              var superClassName = _step2.value;
              var superClassRoleTuple = roles3.filter(function(_ref3) {
                var _ref4 = _slicedToArray(_ref3, 1), name = _ref4[0];
                return name === superClassName;
              })[0];
              if (superClassRoleTuple) {
                var superClassDefinition = superClassRoleTuple[1];
                for (var _i = 0, _Object$keys = Object.keys(superClassDefinition.props); _i < _Object$keys.length; _i++) {
                  var prop = _Object$keys[_i];
                  if (
                    // $FlowIssue Accessing the hasOwnProperty on the Object prototype is fine.
                    !Object.prototype.hasOwnProperty.call(roleDefinition.props, prop)
                  ) {
                    roleDefinition.props[prop] = superClassDefinition.props[prop];
                  }
                }
              }
            }, "_loop");
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done; ) {
              _loop();
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    });
    var rolesMap = {
      entries: /* @__PURE__ */ __name(function entries() {
        return roles3;
      }, "entries"),
      forEach: /* @__PURE__ */ __name(function forEach(fn3) {
        var thisArg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
        var _iterator3 = _createForOfIteratorHelper(roles3), _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done; ) {
            var _step3$value = _slicedToArray(_step3.value, 2), key = _step3$value[0], values = _step3$value[1];
            fn3.call(thisArg, values, key, roles3);
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }, "forEach"),
      get: /* @__PURE__ */ __name(function get2(key) {
        var item = roles3.filter(function(tuple) {
          return tuple[0] === key ? true : false;
        })[0];
        return item && item[1];
      }, "get"),
      has: /* @__PURE__ */ __name(function has(key) {
        return !!rolesMap.get(key);
      }, "has"),
      keys: /* @__PURE__ */ __name(function keys2() {
        return roles3.map(function(_ref5) {
          var _ref6 = _slicedToArray(_ref5, 1), key = _ref6[0];
          return key;
        });
      }, "keys"),
      values: /* @__PURE__ */ __name(function values() {
        return roles3.map(function(_ref7) {
          var _ref8 = _slicedToArray(_ref7, 2), values2 = _ref8[1];
          return values2;
        });
      }, "values")
    };
    var _default = exports.default = (0, _iterationDecorator.default)(rolesMap, rolesMap.entries());
  }
});

// ../node_modules/aria-query/lib/elementRoleMap.js
var require_elementRoleMap = __commonJS({
  "../node_modules/aria-query/lib/elementRoleMap.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _iterationDecorator = _interopRequireDefault(require_iterationDecorator());
    var _rolesMap = _interopRequireDefault(require_rolesMap());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    function _slicedToArray(r2, e2) {
      return _arrayWithHoles(r2) || _iterableToArrayLimit(r2, e2) || _unsupportedIterableToArray(r2, e2) || _nonIterableRest();
    }
    __name(_slicedToArray, "_slicedToArray");
    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    __name(_nonIterableRest, "_nonIterableRest");
    function _unsupportedIterableToArray(r2, a) {
      if (r2) {
        if ("string" == typeof r2) return _arrayLikeToArray(r2, a);
        var t2 = {}.toString.call(r2).slice(8, -1);
        return "Object" === t2 && r2.constructor && (t2 = r2.constructor.name), "Map" === t2 || "Set" === t2 ? Array.from(r2) : "Arguments" === t2 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t2) ? _arrayLikeToArray(r2, a) : void 0;
      }
    }
    __name(_unsupportedIterableToArray, "_unsupportedIterableToArray");
    function _arrayLikeToArray(r2, a) {
      (null == a || a > r2.length) && (a = r2.length);
      for (var e2 = 0, n2 = Array(a); e2 < a; e2++) n2[e2] = r2[e2];
      return n2;
    }
    __name(_arrayLikeToArray, "_arrayLikeToArray");
    function _iterableToArrayLimit(r2, l2) {
      var t2 = null == r2 ? null : "undefined" != typeof Symbol && r2[Symbol.iterator] || r2["@@iterator"];
      if (null != t2) {
        var e2, n2, i3, u3, a = [], f3 = true, o2 = false;
        try {
          if (i3 = (t2 = t2.call(r2)).next, 0 === l2) {
            if (Object(t2) !== t2) return;
            f3 = false;
          } else for (; !(f3 = (e2 = i3.call(t2)).done) && (a.push(e2.value), a.length !== l2); f3 = true) ;
        } catch (r3) {
          o2 = true, n2 = r3;
        } finally {
          try {
            if (!f3 && null != t2.return && (u3 = t2.return(), Object(u3) !== u3)) return;
          } finally {
            if (o2) throw n2;
          }
        }
        return a;
      }
    }
    __name(_iterableToArrayLimit, "_iterableToArrayLimit");
    function _arrayWithHoles(r2) {
      if (Array.isArray(r2)) return r2;
    }
    __name(_arrayWithHoles, "_arrayWithHoles");
    var elementRoles3 = [];
    var keys2 = _rolesMap.default.keys();
    for (i2 = 0; i2 < keys2.length; i2++) {
      key = keys2[i2];
      role = _rolesMap.default.get(key);
      if (role) {
        concepts = [].concat(role.baseConcepts, role.relatedConcepts);
        _loop = /* @__PURE__ */ __name(function _loop2() {
          var relation = concepts[k2];
          if (relation.module === "HTML") {
            var concept = relation.concept;
            if (concept) {
              var elementRoleRelation = elementRoles3.filter(function(relation2) {
                return ariaRoleRelationConceptEquals(relation2[0], concept);
              })[0];
              var roles3;
              if (elementRoleRelation) {
                roles3 = elementRoleRelation[1];
              } else {
                roles3 = [];
              }
              var isUnique = true;
              for (var _i = 0; _i < roles3.length; _i++) {
                if (roles3[_i] === key) {
                  isUnique = false;
                  break;
                }
              }
              if (isUnique) {
                roles3.push(key);
              }
              if (!elementRoleRelation) {
                elementRoles3.push([concept, roles3]);
              }
            }
          }
        }, "_loop");
        for (k2 = 0; k2 < concepts.length; k2++) {
          _loop();
        }
      }
    }
    var key;
    var role;
    var concepts;
    var _loop;
    var k2;
    var i2;
    var elementRoleMap = {
      entries: /* @__PURE__ */ __name(function entries() {
        return elementRoles3;
      }, "entries"),
      forEach: /* @__PURE__ */ __name(function forEach(fn3) {
        var thisArg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
        for (var _i2 = 0, _elementRoles = elementRoles3; _i2 < _elementRoles.length; _i2++) {
          var _elementRoles$_i = _slicedToArray(_elementRoles[_i2], 2), _key = _elementRoles$_i[0], values = _elementRoles$_i[1];
          fn3.call(thisArg, values, _key, elementRoles3);
        }
      }, "forEach"),
      get: /* @__PURE__ */ __name(function get2(key2) {
        var item = elementRoles3.filter(function(tuple) {
          return key2.name === tuple[0].name && ariaRoleRelationConceptAttributeEquals(key2.attributes, tuple[0].attributes);
        })[0];
        return item && item[1];
      }, "get"),
      has: /* @__PURE__ */ __name(function has(key2) {
        return !!elementRoleMap.get(key2);
      }, "has"),
      keys: /* @__PURE__ */ __name(function keys3() {
        return elementRoles3.map(function(_ref) {
          var _ref2 = _slicedToArray(_ref, 1), key2 = _ref2[0];
          return key2;
        });
      }, "keys"),
      values: /* @__PURE__ */ __name(function values() {
        return elementRoles3.map(function(_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2), values2 = _ref4[1];
          return values2;
        });
      }, "values")
    };
    function ariaRoleRelationConceptEquals(a, b2) {
      return a.name === b2.name && ariaRoleRelationConstraintsEquals(a.constraints, b2.constraints) && ariaRoleRelationConceptAttributeEquals(a.attributes, b2.attributes);
    }
    __name(ariaRoleRelationConceptEquals, "ariaRoleRelationConceptEquals");
    function ariaRoleRelationConstraintsEquals(a, b2) {
      if (a === void 0 && b2 !== void 0) {
        return false;
      }
      if (a !== void 0 && b2 === void 0) {
        return false;
      }
      if (a !== void 0 && b2 !== void 0) {
        if (a.length !== b2.length) {
          return false;
        }
        for (var _i3 = 0; _i3 < a.length; _i3++) {
          if (a[_i3] !== b2[_i3]) {
            return false;
          }
        }
      }
      return true;
    }
    __name(ariaRoleRelationConstraintsEquals, "ariaRoleRelationConstraintsEquals");
    function ariaRoleRelationConceptAttributeEquals(a, b2) {
      if (a === void 0 && b2 !== void 0) {
        return false;
      }
      if (a !== void 0 && b2 === void 0) {
        return false;
      }
      if (a !== void 0 && b2 !== void 0) {
        if (a.length !== b2.length) {
          return false;
        }
        for (var _i4 = 0; _i4 < a.length; _i4++) {
          if (a[_i4].name !== b2[_i4].name || a[_i4].value !== b2[_i4].value) {
            return false;
          }
          if (a[_i4].constraints === void 0 && b2[_i4].constraints !== void 0) {
            return false;
          }
          if (a[_i4].constraints !== void 0 && b2[_i4].constraints === void 0) {
            return false;
          }
          if (a[_i4].constraints !== void 0 && b2[_i4].constraints !== void 0) {
            if (a[_i4].constraints.length !== b2[_i4].constraints.length) {
              return false;
            }
            for (var j2 = 0; j2 < a[_i4].constraints.length; j2++) {
              if (a[_i4].constraints[j2] !== b2[_i4].constraints[j2]) {
                return false;
              }
            }
          }
        }
      }
      return true;
    }
    __name(ariaRoleRelationConceptAttributeEquals, "ariaRoleRelationConceptAttributeEquals");
    var _default = exports.default = (0, _iterationDecorator.default)(elementRoleMap, elementRoleMap.entries());
  }
});

// ../node_modules/aria-query/lib/roleElementMap.js
var require_roleElementMap = __commonJS({
  "../node_modules/aria-query/lib/roleElementMap.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;
    var _iterationDecorator = _interopRequireDefault(require_iterationDecorator());
    var _rolesMap = _interopRequireDefault(require_rolesMap());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    function _slicedToArray(r2, e2) {
      return _arrayWithHoles(r2) || _iterableToArrayLimit(r2, e2) || _unsupportedIterableToArray(r2, e2) || _nonIterableRest();
    }
    __name(_slicedToArray, "_slicedToArray");
    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    __name(_nonIterableRest, "_nonIterableRest");
    function _unsupportedIterableToArray(r2, a) {
      if (r2) {
        if ("string" == typeof r2) return _arrayLikeToArray(r2, a);
        var t2 = {}.toString.call(r2).slice(8, -1);
        return "Object" === t2 && r2.constructor && (t2 = r2.constructor.name), "Map" === t2 || "Set" === t2 ? Array.from(r2) : "Arguments" === t2 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t2) ? _arrayLikeToArray(r2, a) : void 0;
      }
    }
    __name(_unsupportedIterableToArray, "_unsupportedIterableToArray");
    function _arrayLikeToArray(r2, a) {
      (null == a || a > r2.length) && (a = r2.length);
      for (var e2 = 0, n2 = Array(a); e2 < a; e2++) n2[e2] = r2[e2];
      return n2;
    }
    __name(_arrayLikeToArray, "_arrayLikeToArray");
    function _iterableToArrayLimit(r2, l2) {
      var t2 = null == r2 ? null : "undefined" != typeof Symbol && r2[Symbol.iterator] || r2["@@iterator"];
      if (null != t2) {
        var e2, n2, i3, u3, a = [], f3 = true, o2 = false;
        try {
          if (i3 = (t2 = t2.call(r2)).next, 0 === l2) {
            if (Object(t2) !== t2) return;
            f3 = false;
          } else for (; !(f3 = (e2 = i3.call(t2)).done) && (a.push(e2.value), a.length !== l2); f3 = true) ;
        } catch (r3) {
          o2 = true, n2 = r3;
        } finally {
          try {
            if (!f3 && null != t2.return && (u3 = t2.return(), Object(u3) !== u3)) return;
          } finally {
            if (o2) throw n2;
          }
        }
        return a;
      }
    }
    __name(_iterableToArrayLimit, "_iterableToArrayLimit");
    function _arrayWithHoles(r2) {
      if (Array.isArray(r2)) return r2;
    }
    __name(_arrayWithHoles, "_arrayWithHoles");
    var roleElement = [];
    var keys2 = _rolesMap.default.keys();
    for (i2 = 0; i2 < keys2.length; i2++) {
      key = keys2[i2];
      role = _rolesMap.default.get(key);
      relationConcepts = [];
      if (role) {
        concepts = [].concat(role.baseConcepts, role.relatedConcepts);
        for (k2 = 0; k2 < concepts.length; k2++) {
          relation = concepts[k2];
          if (relation.module === "HTML") {
            concept = relation.concept;
            if (concept != null) {
              relationConcepts.push(concept);
            }
          }
        }
        if (relationConcepts.length > 0) {
          roleElement.push([key, relationConcepts]);
        }
      }
    }
    var key;
    var role;
    var relationConcepts;
    var concepts;
    var relation;
    var concept;
    var k2;
    var i2;
    var roleElementMap = {
      entries: /* @__PURE__ */ __name(function entries() {
        return roleElement;
      }, "entries"),
      forEach: /* @__PURE__ */ __name(function forEach(fn3) {
        var thisArg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
        for (var _i = 0, _roleElement = roleElement; _i < _roleElement.length; _i++) {
          var _roleElement$_i = _slicedToArray(_roleElement[_i], 2), _key = _roleElement$_i[0], values = _roleElement$_i[1];
          fn3.call(thisArg, values, _key, roleElement);
        }
      }, "forEach"),
      get: /* @__PURE__ */ __name(function get2(key2) {
        var item = roleElement.filter(function(tuple) {
          return tuple[0] === key2 ? true : false;
        })[0];
        return item && item[1];
      }, "get"),
      has: /* @__PURE__ */ __name(function has(key2) {
        return !!roleElementMap.get(key2);
      }, "has"),
      keys: /* @__PURE__ */ __name(function keys3() {
        return roleElement.map(function(_ref) {
          var _ref2 = _slicedToArray(_ref, 1), key2 = _ref2[0];
          return key2;
        });
      }, "keys"),
      values: /* @__PURE__ */ __name(function values() {
        return roleElement.map(function(_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2), values2 = _ref4[1];
          return values2;
        });
      }, "values")
    };
    var _default = exports.default = (0, _iterationDecorator.default)(roleElementMap, roleElementMap.entries());
  }
});

// ../node_modules/aria-query/lib/index.js
var require_lib = __commonJS({
  "../node_modules/aria-query/lib/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.roles = exports.roleElements = exports.elementRoles = exports.dom = exports.aria = void 0;
    var _ariaPropsMap = _interopRequireDefault(require_ariaPropsMap());
    var _domMap = _interopRequireDefault(require_domMap());
    var _rolesMap = _interopRequireDefault(require_rolesMap());
    var _elementRoleMap = _interopRequireDefault(require_elementRoleMap());
    var _roleElementMap = _interopRequireDefault(require_roleElementMap());
    function _interopRequireDefault(e2) {
      return e2 && e2.__esModule ? e2 : { default: e2 };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var aria = exports.aria = _ariaPropsMap.default;
    var dom = exports.dom = _domMap.default;
    var roles3 = exports.roles = _rolesMap.default;
    var elementRoles3 = exports.elementRoles = _elementRoleMap.default;
    var roleElements2 = exports.roleElements = _roleElementMap.default;
  }
});

// ../node_modules/css.escape/css.escape.js
var require_css_escape = __commonJS({
  "../node_modules/css.escape/css.escape.js"(exports, module2) {
    (function(root, factory) {
      if (typeof exports == "object") {
        module2.exports = factory(root);
      } else if (typeof define == "function" && define.amd) {
        define([], factory.bind(root, root));
      } else {
        factory(root);
      }
    })(typeof global != "undefined" ? global : exports, function(root) {
      if (root.CSS && root.CSS.escape) {
        return root.CSS.escape;
      }
      var cssEscape = /* @__PURE__ */ __name(function(value) {
        if (arguments.length == 0) {
          throw new TypeError("`CSS.escape` requires an argument.");
        }
        var string = String(value);
        var length = string.length;
        var index = -1;
        var codeUnit;
        var result = "";
        var firstCodeUnit = string.charCodeAt(0);
        while (++index < length) {
          codeUnit = string.charCodeAt(index);
          if (codeUnit == 0) {
            result += "\uFFFD";
            continue;
          }
          if (
            // If the character is in the range [\1-\1F] (U+0001 to U+001F) or is
            // U+007F, […]
            codeUnit >= 1 && codeUnit <= 31 || codeUnit == 127 || // If the character is the first character and is in the range [0-9]
            // (U+0030 to U+0039), […]
            index == 0 && codeUnit >= 48 && codeUnit <= 57 || // If the character is the second character and is in the range [0-9]
            // (U+0030 to U+0039) and the first character is a `-` (U+002D), […]
            index == 1 && codeUnit >= 48 && codeUnit <= 57 && firstCodeUnit == 45
          ) {
            result += "\\" + codeUnit.toString(16) + " ";
            continue;
          }
          if (
            // If the character is the first character and is a `-` (U+002D), and
            // there is no second character, […]
            index == 0 && length == 1 && codeUnit == 45
          ) {
            result += "\\" + string.charAt(index);
            continue;
          }
          if (codeUnit >= 128 || codeUnit == 45 || codeUnit == 95 || codeUnit >= 48 && codeUnit <= 57 || codeUnit >= 65 && codeUnit <= 90 || codeUnit >= 97 && codeUnit <= 122) {
            result += string.charAt(index);
            continue;
          }
          result += "\\" + string.charAt(index);
        }
        return result;
      }, "cssEscape");
      if (!root.CSS) {
        root.CSS = {};
      }
      root.CSS.escape = cssEscape;
      return cssEscape;
    });
  }
});

// ../node_modules/pretty-format/node_modules/ansi-styles/index.js
var require_ansi_styles = __commonJS({
  "../node_modules/pretty-format/node_modules/ansi-styles/index.js"(exports, module2) {
    "use strict";
    var ANSI_BACKGROUND_OFFSET = 10;
    var wrapAnsi256 = /* @__PURE__ */ __name((offset = 0) => (code) => `\x1B[${38 + offset};5;${code}m`, "wrapAnsi256");
    var wrapAnsi16m = /* @__PURE__ */ __name((offset = 0) => (red, green, blue) => `\x1B[${38 + offset};2;${red};${green};${blue}m`, "wrapAnsi16m");
    function assembleStyles() {
      const codes = /* @__PURE__ */ new Map();
      const styles2 = {
        modifier: {
          reset: [0, 0],
          // 21 isn't widely supported and 22 does the same thing
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          overline: [53, 55],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          // Bright color
          blackBright: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          // Bright color
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles2.color.gray = styles2.color.blackBright;
      styles2.bgColor.bgGray = styles2.bgColor.bgBlackBright;
      styles2.color.grey = styles2.color.blackBright;
      styles2.bgColor.bgGrey = styles2.bgColor.bgBlackBright;
      for (const [groupName, group] of Object.entries(styles2)) {
        for (const [styleName, style] of Object.entries(group)) {
          styles2[styleName] = {
            open: `\x1B[${style[0]}m`,
            close: `\x1B[${style[1]}m`
          };
          group[styleName] = styles2[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles2, groupName, {
          value: group,
          enumerable: false
        });
      }
      Object.defineProperty(styles2, "codes", {
        value: codes,
        enumerable: false
      });
      styles2.color.close = "\x1B[39m";
      styles2.bgColor.close = "\x1B[49m";
      styles2.color.ansi256 = wrapAnsi256();
      styles2.color.ansi16m = wrapAnsi16m();
      styles2.bgColor.ansi256 = wrapAnsi256(ANSI_BACKGROUND_OFFSET);
      styles2.bgColor.ansi16m = wrapAnsi16m(ANSI_BACKGROUND_OFFSET);
      Object.defineProperties(styles2, {
        rgbToAnsi256: {
          value: /* @__PURE__ */ __name((red, green, blue) => {
            if (red === green && green === blue) {
              if (red < 8) {
                return 16;
              }
              if (red > 248) {
                return 231;
              }
              return Math.round((red - 8) / 247 * 24) + 232;
            }
            return 16 + 36 * Math.round(red / 255 * 5) + 6 * Math.round(green / 255 * 5) + Math.round(blue / 255 * 5);
          }, "value"),
          enumerable: false
        },
        hexToRgb: {
          value: /* @__PURE__ */ __name((hex2) => {
            const matches3 = /(?<colorString>[a-f\d]{6}|[a-f\d]{3})/i.exec(hex2.toString(16));
            if (!matches3) {
              return [0, 0, 0];
            }
            let { colorString } = matches3.groups;
            if (colorString.length === 3) {
              colorString = colorString.split("").map((character) => character + character).join("");
            }
            const integer = Number.parseInt(colorString, 16);
            return [
              integer >> 16 & 255,
              integer >> 8 & 255,
              integer & 255
            ];
          }, "value"),
          enumerable: false
        },
        hexToAnsi256: {
          value: /* @__PURE__ */ __name((hex2) => styles2.rgbToAnsi256(...styles2.hexToRgb(hex2)), "value"),
          enumerable: false
        }
      });
      return styles2;
    }
    __name(assembleStyles, "assembleStyles");
    Object.defineProperty(module2, "exports", {
      enumerable: true,
      get: assembleStyles
    });
  }
});

// ../node_modules/pretty-format/build/collections.js
var require_collections = __commonJS({
  "../node_modules/pretty-format/build/collections.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.printIteratorEntries = printIteratorEntries;
    exports.printIteratorValues = printIteratorValues;
    exports.printListItems = printListItems;
    exports.printObjectProperties = printObjectProperties;
    var getKeysOfEnumerableProperties = /* @__PURE__ */ __name((object, compareKeys) => {
      const keys2 = Object.keys(object).sort(compareKeys);
      if (Object.getOwnPropertySymbols) {
        Object.getOwnPropertySymbols(object).forEach((symbol) => {
          if (Object.getOwnPropertyDescriptor(object, symbol).enumerable) {
            keys2.push(symbol);
          }
        });
      }
      return keys2;
    }, "getKeysOfEnumerableProperties");
    function printIteratorEntries(iterator, config3, indentation, depth, refs, printer, separator = ": ") {
      let result = "";
      let current = iterator.next();
      if (!current.done) {
        result += config3.spacingOuter;
        const indentationNext = indentation + config3.indent;
        while (!current.done) {
          const name = printer(
            current.value[0],
            config3,
            indentationNext,
            depth,
            refs
          );
          const value = printer(
            current.value[1],
            config3,
            indentationNext,
            depth,
            refs
          );
          result += indentationNext + name + separator + value;
          current = iterator.next();
          if (!current.done) {
            result += "," + config3.spacingInner;
          } else if (!config3.min) {
            result += ",";
          }
        }
        result += config3.spacingOuter + indentation;
      }
      return result;
    }
    __name(printIteratorEntries, "printIteratorEntries");
    function printIteratorValues(iterator, config3, indentation, depth, refs, printer) {
      let result = "";
      let current = iterator.next();
      if (!current.done) {
        result += config3.spacingOuter;
        const indentationNext = indentation + config3.indent;
        while (!current.done) {
          result += indentationNext + printer(current.value, config3, indentationNext, depth, refs);
          current = iterator.next();
          if (!current.done) {
            result += "," + config3.spacingInner;
          } else if (!config3.min) {
            result += ",";
          }
        }
        result += config3.spacingOuter + indentation;
      }
      return result;
    }
    __name(printIteratorValues, "printIteratorValues");
    function printListItems(list, config3, indentation, depth, refs, printer) {
      let result = "";
      if (list.length) {
        result += config3.spacingOuter;
        const indentationNext = indentation + config3.indent;
        for (let i2 = 0; i2 < list.length; i2++) {
          result += indentationNext;
          if (i2 in list) {
            result += printer(list[i2], config3, indentationNext, depth, refs);
          }
          if (i2 < list.length - 1) {
            result += "," + config3.spacingInner;
          } else if (!config3.min) {
            result += ",";
          }
        }
        result += config3.spacingOuter + indentation;
      }
      return result;
    }
    __name(printListItems, "printListItems");
    function printObjectProperties(val, config3, indentation, depth, refs, printer) {
      let result = "";
      const keys2 = getKeysOfEnumerableProperties(val, config3.compareKeys);
      if (keys2.length) {
        result += config3.spacingOuter;
        const indentationNext = indentation + config3.indent;
        for (let i2 = 0; i2 < keys2.length; i2++) {
          const key = keys2[i2];
          const name = printer(key, config3, indentationNext, depth, refs);
          const value = printer(val[key], config3, indentationNext, depth, refs);
          result += indentationNext + name + ": " + value;
          if (i2 < keys2.length - 1) {
            result += "," + config3.spacingInner;
          } else if (!config3.min) {
            result += ",";
          }
        }
        result += config3.spacingOuter + indentation;
      }
      return result;
    }
    __name(printObjectProperties, "printObjectProperties");
  }
});

// ../node_modules/pretty-format/build/plugins/AsymmetricMatcher.js
var require_AsymmetricMatcher = __commonJS({
  "../node_modules/pretty-format/build/plugins/AsymmetricMatcher.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.test = exports.serialize = exports.default = void 0;
    var _collections = require_collections();
    var global2 = function() {
      if (typeof globalThis !== "undefined") {
        return globalThis;
      } else if (typeof global2 !== "undefined") {
        return global2;
      } else if (typeof self !== "undefined") {
        return self;
      } else if (typeof window !== "undefined") {
        return window;
      } else {
        return Function("return this")();
      }
    }();
    var Symbol2 = global2["jest-symbol-do-not-touch"] || global2.Symbol;
    var asymmetricMatcher = typeof Symbol2 === "function" && Symbol2.for ? Symbol2.for("jest.asymmetricMatcher") : 1267621;
    var SPACE = " ";
    var serialize = /* @__PURE__ */ __name((val, config3, indentation, depth, refs, printer) => {
      const stringedValue = val.toString();
      if (stringedValue === "ArrayContaining" || stringedValue === "ArrayNotContaining") {
        if (++depth > config3.maxDepth) {
          return "[" + stringedValue + "]";
        }
        return stringedValue + SPACE + "[" + (0, _collections.printListItems)(
          val.sample,
          config3,
          indentation,
          depth,
          refs,
          printer
        ) + "]";
      }
      if (stringedValue === "ObjectContaining" || stringedValue === "ObjectNotContaining") {
        if (++depth > config3.maxDepth) {
          return "[" + stringedValue + "]";
        }
        return stringedValue + SPACE + "{" + (0, _collections.printObjectProperties)(
          val.sample,
          config3,
          indentation,
          depth,
          refs,
          printer
        ) + "}";
      }
      if (stringedValue === "StringMatching" || stringedValue === "StringNotMatching") {
        return stringedValue + SPACE + printer(val.sample, config3, indentation, depth, refs);
      }
      if (stringedValue === "StringContaining" || stringedValue === "StringNotContaining") {
        return stringedValue + SPACE + printer(val.sample, config3, indentation, depth, refs);
      }
      return val.toAsymmetricMatcher();
    }, "serialize");
    exports.serialize = serialize;
    var test2 = /* @__PURE__ */ __name((val) => val && val.$$typeof === asymmetricMatcher, "test");
    exports.test = test2;
    var plugin = {
      serialize,
      test: test2
    };
    var _default = plugin;
    exports.default = _default;
  }
});

// ../node_modules/pretty-format/node_modules/ansi-regex/index.js
var require_ansi_regex = __commonJS({
  "../node_modules/pretty-format/node_modules/ansi-regex/index.js"(exports, module2) {
    "use strict";
    module2.exports = ({ onlyFirst = false } = {}) => {
      const pattern = [
        "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
        "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"
      ].join("|");
      return new RegExp(pattern, onlyFirst ? void 0 : "g");
    };
  }
});

// ../node_modules/pretty-format/build/plugins/ConvertAnsi.js
var require_ConvertAnsi = __commonJS({
  "../node_modules/pretty-format/build/plugins/ConvertAnsi.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.test = exports.serialize = exports.default = void 0;
    var _ansiRegex = _interopRequireDefault(require_ansi_regex());
    var _ansiStyles = _interopRequireDefault(require_ansi_styles());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var toHumanReadableAnsi = /* @__PURE__ */ __name((text) => text.replace((0, _ansiRegex.default)(), (match) => {
      switch (match) {
        case _ansiStyles.default.red.close:
        case _ansiStyles.default.green.close:
        case _ansiStyles.default.cyan.close:
        case _ansiStyles.default.gray.close:
        case _ansiStyles.default.white.close:
        case _ansiStyles.default.yellow.close:
        case _ansiStyles.default.bgRed.close:
        case _ansiStyles.default.bgGreen.close:
        case _ansiStyles.default.bgYellow.close:
        case _ansiStyles.default.inverse.close:
        case _ansiStyles.default.dim.close:
        case _ansiStyles.default.bold.close:
        case _ansiStyles.default.reset.open:
        case _ansiStyles.default.reset.close:
          return "</>";
        case _ansiStyles.default.red.open:
          return "<red>";
        case _ansiStyles.default.green.open:
          return "<green>";
        case _ansiStyles.default.cyan.open:
          return "<cyan>";
        case _ansiStyles.default.gray.open:
          return "<gray>";
        case _ansiStyles.default.white.open:
          return "<white>";
        case _ansiStyles.default.yellow.open:
          return "<yellow>";
        case _ansiStyles.default.bgRed.open:
          return "<bgRed>";
        case _ansiStyles.default.bgGreen.open:
          return "<bgGreen>";
        case _ansiStyles.default.bgYellow.open:
          return "<bgYellow>";
        case _ansiStyles.default.inverse.open:
          return "<inverse>";
        case _ansiStyles.default.dim.open:
          return "<dim>";
        case _ansiStyles.default.bold.open:
          return "<bold>";
        default:
          return "";
      }
    }), "toHumanReadableAnsi");
    var test2 = /* @__PURE__ */ __name((val) => typeof val === "string" && !!val.match((0, _ansiRegex.default)()), "test");
    exports.test = test2;
    var serialize = /* @__PURE__ */ __name((val, config3, indentation, depth, refs, printer) => printer(toHumanReadableAnsi(val), config3, indentation, depth, refs), "serialize");
    exports.serialize = serialize;
    var plugin = {
      serialize,
      test: test2
    };
    var _default = plugin;
    exports.default = _default;
  }
});

// ../node_modules/pretty-format/build/plugins/DOMCollection.js
var require_DOMCollection = __commonJS({
  "../node_modules/pretty-format/build/plugins/DOMCollection.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.test = exports.serialize = exports.default = void 0;
    var _collections = require_collections();
    var SPACE = " ";
    var OBJECT_NAMES = ["DOMStringMap", "NamedNodeMap"];
    var ARRAY_REGEXP = /^(HTML\w*Collection|NodeList)$/;
    var testName = /* @__PURE__ */ __name((name) => OBJECT_NAMES.indexOf(name) !== -1 || ARRAY_REGEXP.test(name), "testName");
    var test2 = /* @__PURE__ */ __name((val) => val && val.constructor && !!val.constructor.name && testName(val.constructor.name), "test");
    exports.test = test2;
    var isNamedNodeMap = /* @__PURE__ */ __name((collection) => collection.constructor.name === "NamedNodeMap", "isNamedNodeMap");
    var serialize = /* @__PURE__ */ __name((collection, config3, indentation, depth, refs, printer) => {
      const name = collection.constructor.name;
      if (++depth > config3.maxDepth) {
        return "[" + name + "]";
      }
      return (config3.min ? "" : name + SPACE) + (OBJECT_NAMES.indexOf(name) !== -1 ? "{" + (0, _collections.printObjectProperties)(
        isNamedNodeMap(collection) ? Array.from(collection).reduce((props, attribute) => {
          props[attribute.name] = attribute.value;
          return props;
        }, {}) : { ...collection },
        config3,
        indentation,
        depth,
        refs,
        printer
      ) + "}" : "[" + (0, _collections.printListItems)(
        Array.from(collection),
        config3,
        indentation,
        depth,
        refs,
        printer
      ) + "]");
    }, "serialize");
    exports.serialize = serialize;
    var plugin = {
      serialize,
      test: test2
    };
    var _default = plugin;
    exports.default = _default;
  }
});

// ../node_modules/pretty-format/build/plugins/lib/escapeHTML.js
var require_escapeHTML = __commonJS({
  "../node_modules/pretty-format/build/plugins/lib/escapeHTML.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = escapeHTML2;
    function escapeHTML2(str) {
      return str.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    }
    __name(escapeHTML2, "escapeHTML");
  }
});

// ../node_modules/pretty-format/build/plugins/lib/markup.js
var require_markup = __commonJS({
  "../node_modules/pretty-format/build/plugins/lib/markup.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.printText = exports.printProps = exports.printElementAsLeaf = exports.printElement = exports.printComment = exports.printChildren = void 0;
    var _escapeHTML = _interopRequireDefault(require_escapeHTML());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var printProps2 = /* @__PURE__ */ __name((keys2, props, config3, indentation, depth, refs, printer) => {
      const indentationNext = indentation + config3.indent;
      const colors = config3.colors;
      return keys2.map((key) => {
        const value = props[key];
        let printed = printer(value, config3, indentationNext, depth, refs);
        if (typeof value !== "string") {
          if (printed.indexOf("\n") !== -1) {
            printed = config3.spacingOuter + indentationNext + printed + config3.spacingOuter + indentation;
          }
          printed = "{" + printed + "}";
        }
        return config3.spacingInner + indentation + colors.prop.open + key + colors.prop.close + "=" + colors.value.open + printed + colors.value.close;
      }).join("");
    }, "printProps");
    exports.printProps = printProps2;
    var printChildren2 = /* @__PURE__ */ __name((children, config3, indentation, depth, refs, printer) => children.map(
      (child) => config3.spacingOuter + indentation + (typeof child === "string" ? printText2(child, config3) : printer(child, config3, indentation, depth, refs))
    ).join(""), "printChildren");
    exports.printChildren = printChildren2;
    var printText2 = /* @__PURE__ */ __name((text, config3) => {
      const contentColor = config3.colors.content;
      return contentColor.open + (0, _escapeHTML.default)(text) + contentColor.close;
    }, "printText");
    exports.printText = printText2;
    var printComment2 = /* @__PURE__ */ __name((comment, config3) => {
      const commentColor = config3.colors.comment;
      return commentColor.open + "<!--" + (0, _escapeHTML.default)(comment) + "-->" + commentColor.close;
    }, "printComment");
    exports.printComment = printComment2;
    var printElement2 = /* @__PURE__ */ __name((type5, printedProps, printedChildren, config3, indentation) => {
      const tagColor = config3.colors.tag;
      return tagColor.open + "<" + type5 + (printedProps && tagColor.close + printedProps + config3.spacingOuter + indentation + tagColor.open) + (printedChildren ? ">" + tagColor.close + printedChildren + config3.spacingOuter + indentation + tagColor.open + "</" + type5 : (printedProps && !config3.min ? "" : " ") + "/") + ">" + tagColor.close;
    }, "printElement");
    exports.printElement = printElement2;
    var printElementAsLeaf2 = /* @__PURE__ */ __name((type5, config3) => {
      const tagColor = config3.colors.tag;
      return tagColor.open + "<" + type5 + tagColor.close + " \u2026" + tagColor.open + " />" + tagColor.close;
    }, "printElementAsLeaf");
    exports.printElementAsLeaf = printElementAsLeaf2;
  }
});

// ../node_modules/pretty-format/build/plugins/DOMElement.js
var require_DOMElement = __commonJS({
  "../node_modules/pretty-format/build/plugins/DOMElement.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.test = exports.serialize = exports.default = void 0;
    var _markup = require_markup();
    var ELEMENT_NODE2 = 1;
    var TEXT_NODE2 = 3;
    var COMMENT_NODE2 = 8;
    var FRAGMENT_NODE2 = 11;
    var ELEMENT_REGEXP2 = /^((HTML|SVG)\w*)?Element$/;
    var testHasAttribute = /* @__PURE__ */ __name((val) => {
      try {
        return typeof val.hasAttribute === "function" && val.hasAttribute("is");
      } catch {
        return false;
      }
    }, "testHasAttribute");
    var testNode2 = /* @__PURE__ */ __name((val) => {
      const constructorName = val.constructor.name;
      const { nodeType, tagName } = val;
      const isCustomElement3 = typeof tagName === "string" && tagName.includes("-") || testHasAttribute(val);
      return nodeType === ELEMENT_NODE2 && (ELEMENT_REGEXP2.test(constructorName) || isCustomElement3) || nodeType === TEXT_NODE2 && constructorName === "Text" || nodeType === COMMENT_NODE2 && constructorName === "Comment" || nodeType === FRAGMENT_NODE2 && constructorName === "DocumentFragment";
    }, "testNode");
    var test2 = /* @__PURE__ */ __name((val) => {
      var _val$constructor;
      return (val === null || val === void 0 ? void 0 : (_val$constructor = val.constructor) === null || _val$constructor === void 0 ? void 0 : _val$constructor.name) && testNode2(val);
    }, "test");
    exports.test = test2;
    function nodeIsText2(node) {
      return node.nodeType === TEXT_NODE2;
    }
    __name(nodeIsText2, "nodeIsText");
    function nodeIsComment2(node) {
      return node.nodeType === COMMENT_NODE2;
    }
    __name(nodeIsComment2, "nodeIsComment");
    function nodeIsFragment2(node) {
      return node.nodeType === FRAGMENT_NODE2;
    }
    __name(nodeIsFragment2, "nodeIsFragment");
    var serialize = /* @__PURE__ */ __name((node, config3, indentation, depth, refs, printer) => {
      if (nodeIsText2(node)) {
        return (0, _markup.printText)(node.data, config3);
      }
      if (nodeIsComment2(node)) {
        return (0, _markup.printComment)(node.data, config3);
      }
      const type5 = nodeIsFragment2(node) ? "DocumentFragment" : node.tagName.toLowerCase();
      if (++depth > config3.maxDepth) {
        return (0, _markup.printElementAsLeaf)(type5, config3);
      }
      return (0, _markup.printElement)(
        type5,
        (0, _markup.printProps)(
          nodeIsFragment2(node) ? [] : Array.from(node.attributes).map((attr) => attr.name).sort(),
          nodeIsFragment2(node) ? {} : Array.from(node.attributes).reduce((props, attribute) => {
            props[attribute.name] = attribute.value;
            return props;
          }, {}),
          config3,
          indentation + config3.indent,
          depth,
          refs,
          printer
        ),
        (0, _markup.printChildren)(
          Array.prototype.slice.call(node.childNodes || node.children),
          config3,
          indentation + config3.indent,
          depth,
          refs,
          printer
        ),
        config3,
        indentation
      );
    }, "serialize");
    exports.serialize = serialize;
    var plugin = {
      serialize,
      test: test2
    };
    var _default = plugin;
    exports.default = _default;
  }
});

// ../node_modules/pretty-format/build/plugins/Immutable.js
var require_Immutable = __commonJS({
  "../node_modules/pretty-format/build/plugins/Immutable.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.test = exports.serialize = exports.default = void 0;
    var _collections = require_collections();
    var IS_ITERABLE_SENTINEL = "@@__IMMUTABLE_ITERABLE__@@";
    var IS_LIST_SENTINEL2 = "@@__IMMUTABLE_LIST__@@";
    var IS_KEYED_SENTINEL2 = "@@__IMMUTABLE_KEYED__@@";
    var IS_MAP_SENTINEL = "@@__IMMUTABLE_MAP__@@";
    var IS_ORDERED_SENTINEL2 = "@@__IMMUTABLE_ORDERED__@@";
    var IS_RECORD_SENTINEL = "@@__IMMUTABLE_RECORD__@@";
    var IS_SEQ_SENTINEL = "@@__IMMUTABLE_SEQ__@@";
    var IS_SET_SENTINEL2 = "@@__IMMUTABLE_SET__@@";
    var IS_STACK_SENTINEL = "@@__IMMUTABLE_STACK__@@";
    var getImmutableName = /* @__PURE__ */ __name((name) => "Immutable." + name, "getImmutableName");
    var printAsLeaf = /* @__PURE__ */ __name((name) => "[" + name + "]", "printAsLeaf");
    var SPACE = " ";
    var LAZY = "\u2026";
    var printImmutableEntries = /* @__PURE__ */ __name((val, config3, indentation, depth, refs, printer, type5) => ++depth > config3.maxDepth ? printAsLeaf(getImmutableName(type5)) : getImmutableName(type5) + SPACE + "{" + (0, _collections.printIteratorEntries)(
      val.entries(),
      config3,
      indentation,
      depth,
      refs,
      printer
    ) + "}", "printImmutableEntries");
    function getRecordEntries(val) {
      let i2 = 0;
      return {
        next() {
          if (i2 < val._keys.length) {
            const key = val._keys[i2++];
            return {
              done: false,
              value: [key, val.get(key)]
            };
          }
          return {
            done: true,
            value: void 0
          };
        }
      };
    }
    __name(getRecordEntries, "getRecordEntries");
    var printImmutableRecord = /* @__PURE__ */ __name((val, config3, indentation, depth, refs, printer) => {
      const name = getImmutableName(val._name || "Record");
      return ++depth > config3.maxDepth ? printAsLeaf(name) : name + SPACE + "{" + (0, _collections.printIteratorEntries)(
        getRecordEntries(val),
        config3,
        indentation,
        depth,
        refs,
        printer
      ) + "}";
    }, "printImmutableRecord");
    var printImmutableSeq = /* @__PURE__ */ __name((val, config3, indentation, depth, refs, printer) => {
      const name = getImmutableName("Seq");
      if (++depth > config3.maxDepth) {
        return printAsLeaf(name);
      }
      if (val[IS_KEYED_SENTINEL2]) {
        return name + SPACE + "{" + // from Immutable collection of entries or from ECMAScript object
        (val._iter || val._object ? (0, _collections.printIteratorEntries)(
          val.entries(),
          config3,
          indentation,
          depth,
          refs,
          printer
        ) : LAZY) + "}";
      }
      return name + SPACE + "[" + (val._iter || // from Immutable collection of values
      val._array || // from ECMAScript array
      val._collection || // from ECMAScript collection in immutable v4
      val._iterable ? (0, _collections.printIteratorValues)(
        val.values(),
        config3,
        indentation,
        depth,
        refs,
        printer
      ) : LAZY) + "]";
    }, "printImmutableSeq");
    var printImmutableValues = /* @__PURE__ */ __name((val, config3, indentation, depth, refs, printer, type5) => ++depth > config3.maxDepth ? printAsLeaf(getImmutableName(type5)) : getImmutableName(type5) + SPACE + "[" + (0, _collections.printIteratorValues)(
      val.values(),
      config3,
      indentation,
      depth,
      refs,
      printer
    ) + "]", "printImmutableValues");
    var serialize = /* @__PURE__ */ __name((val, config3, indentation, depth, refs, printer) => {
      if (val[IS_MAP_SENTINEL]) {
        return printImmutableEntries(
          val,
          config3,
          indentation,
          depth,
          refs,
          printer,
          val[IS_ORDERED_SENTINEL2] ? "OrderedMap" : "Map"
        );
      }
      if (val[IS_LIST_SENTINEL2]) {
        return printImmutableValues(
          val,
          config3,
          indentation,
          depth,
          refs,
          printer,
          "List"
        );
      }
      if (val[IS_SET_SENTINEL2]) {
        return printImmutableValues(
          val,
          config3,
          indentation,
          depth,
          refs,
          printer,
          val[IS_ORDERED_SENTINEL2] ? "OrderedSet" : "Set"
        );
      }
      if (val[IS_STACK_SENTINEL]) {
        return printImmutableValues(
          val,
          config3,
          indentation,
          depth,
          refs,
          printer,
          "Stack"
        );
      }
      if (val[IS_SEQ_SENTINEL]) {
        return printImmutableSeq(val, config3, indentation, depth, refs, printer);
      }
      return printImmutableRecord(val, config3, indentation, depth, refs, printer);
    }, "serialize");
    exports.serialize = serialize;
    var test2 = /* @__PURE__ */ __name((val) => val && (val[IS_ITERABLE_SENTINEL] === true || val[IS_RECORD_SENTINEL] === true), "test");
    exports.test = test2;
    var plugin = {
      serialize,
      test: test2
    };
    var _default = plugin;
    exports.default = _default;
  }
});

// ../node_modules/pretty-format/node_modules/react-is/cjs/react-is.production.min.js
var require_react_is_production_min = __commonJS({
  "../node_modules/pretty-format/node_modules/react-is/cjs/react-is.production.min.js"(exports) {
    "use strict";
    var b2 = 60103;
    var c2 = 60106;
    var d = 60107;
    var e2 = 60108;
    var f3 = 60114;
    var g2 = 60109;
    var h2 = 60110;
    var k2 = 60112;
    var l2 = 60113;
    var m2 = 60120;
    var n2 = 60115;
    var p = 60116;
    var q = 60121;
    var r2 = 60122;
    var u3 = 60117;
    var v2 = 60129;
    var w2 = 60131;
    if ("function" === typeof Symbol && Symbol.for) {
      x2 = Symbol.for;
      b2 = x2("react.element");
      c2 = x2("react.portal");
      d = x2("react.fragment");
      e2 = x2("react.strict_mode");
      f3 = x2("react.profiler");
      g2 = x2("react.provider");
      h2 = x2("react.context");
      k2 = x2("react.forward_ref");
      l2 = x2("react.suspense");
      m2 = x2("react.suspense_list");
      n2 = x2("react.memo");
      p = x2("react.lazy");
      q = x2("react.block");
      r2 = x2("react.server.block");
      u3 = x2("react.fundamental");
      v2 = x2("react.debug_trace_mode");
      w2 = x2("react.legacy_hidden");
    }
    var x2;
    function y2(a) {
      if ("object" === typeof a && null !== a) {
        var t2 = a.$$typeof;
        switch (t2) {
          case b2:
            switch (a = a.type, a) {
              case d:
              case f3:
              case e2:
              case l2:
              case m2:
                return a;
              default:
                switch (a = a && a.$$typeof, a) {
                  case h2:
                  case k2:
                  case p:
                  case n2:
                  case g2:
                    return a;
                  default:
                    return t2;
                }
            }
          case c2:
            return t2;
        }
      }
    }
    __name(y2, "y");
    var z = g2;
    var A = b2;
    var B = k2;
    var C = d;
    var D2 = p;
    var E2 = n2;
    var F = c2;
    var G = f3;
    var H = e2;
    var I = l2;
    exports.ContextConsumer = h2;
    exports.ContextProvider = z;
    exports.Element = A;
    exports.ForwardRef = B;
    exports.Fragment = C;
    exports.Lazy = D2;
    exports.Memo = E2;
    exports.Portal = F;
    exports.Profiler = G;
    exports.StrictMode = H;
    exports.Suspense = I;
    exports.isAsyncMode = function() {
      return false;
    };
    exports.isConcurrentMode = function() {
      return false;
    };
    exports.isContextConsumer = function(a) {
      return y2(a) === h2;
    };
    exports.isContextProvider = function(a) {
      return y2(a) === g2;
    };
    exports.isElement = function(a) {
      return "object" === typeof a && null !== a && a.$$typeof === b2;
    };
    exports.isForwardRef = function(a) {
      return y2(a) === k2;
    };
    exports.isFragment = function(a) {
      return y2(a) === d;
    };
    exports.isLazy = function(a) {
      return y2(a) === p;
    };
    exports.isMemo = function(a) {
      return y2(a) === n2;
    };
    exports.isPortal = function(a) {
      return y2(a) === c2;
    };
    exports.isProfiler = function(a) {
      return y2(a) === f3;
    };
    exports.isStrictMode = function(a) {
      return y2(a) === e2;
    };
    exports.isSuspense = function(a) {
      return y2(a) === l2;
    };
    exports.isValidElementType = function(a) {
      return "string" === typeof a || "function" === typeof a || a === d || a === f3 || a === v2 || a === e2 || a === l2 || a === m2 || a === w2 || "object" === typeof a && null !== a && (a.$$typeof === p || a.$$typeof === n2 || a.$$typeof === g2 || a.$$typeof === h2 || a.$$typeof === k2 || a.$$typeof === u3 || a.$$typeof === q || a[0] === r2) ? true : false;
    };
    exports.typeOf = y2;
  }
});

// ../node_modules/pretty-format/node_modules/react-is/cjs/react-is.development.js
var require_react_is_development = __commonJS({
  "../node_modules/pretty-format/node_modules/react-is/cjs/react-is.development.js"(exports) {
    "use strict";
    if (process.env.NODE_ENV !== "production") {
      (function() {
        "use strict";
        var REACT_ELEMENT_TYPE = 60103;
        var REACT_PORTAL_TYPE = 60106;
        var REACT_FRAGMENT_TYPE = 60107;
        var REACT_STRICT_MODE_TYPE = 60108;
        var REACT_PROFILER_TYPE = 60114;
        var REACT_PROVIDER_TYPE = 60109;
        var REACT_CONTEXT_TYPE = 60110;
        var REACT_FORWARD_REF_TYPE = 60112;
        var REACT_SUSPENSE_TYPE = 60113;
        var REACT_SUSPENSE_LIST_TYPE = 60120;
        var REACT_MEMO_TYPE = 60115;
        var REACT_LAZY_TYPE = 60116;
        var REACT_BLOCK_TYPE = 60121;
        var REACT_SERVER_BLOCK_TYPE = 60122;
        var REACT_FUNDAMENTAL_TYPE = 60117;
        var REACT_SCOPE_TYPE = 60119;
        var REACT_OPAQUE_ID_TYPE = 60128;
        var REACT_DEBUG_TRACING_MODE_TYPE = 60129;
        var REACT_OFFSCREEN_TYPE = 60130;
        var REACT_LEGACY_HIDDEN_TYPE = 60131;
        if (typeof Symbol === "function" && Symbol.for) {
          var symbolFor = Symbol.for;
          REACT_ELEMENT_TYPE = symbolFor("react.element");
          REACT_PORTAL_TYPE = symbolFor("react.portal");
          REACT_FRAGMENT_TYPE = symbolFor("react.fragment");
          REACT_STRICT_MODE_TYPE = symbolFor("react.strict_mode");
          REACT_PROFILER_TYPE = symbolFor("react.profiler");
          REACT_PROVIDER_TYPE = symbolFor("react.provider");
          REACT_CONTEXT_TYPE = symbolFor("react.context");
          REACT_FORWARD_REF_TYPE = symbolFor("react.forward_ref");
          REACT_SUSPENSE_TYPE = symbolFor("react.suspense");
          REACT_SUSPENSE_LIST_TYPE = symbolFor("react.suspense_list");
          REACT_MEMO_TYPE = symbolFor("react.memo");
          REACT_LAZY_TYPE = symbolFor("react.lazy");
          REACT_BLOCK_TYPE = symbolFor("react.block");
          REACT_SERVER_BLOCK_TYPE = symbolFor("react.server.block");
          REACT_FUNDAMENTAL_TYPE = symbolFor("react.fundamental");
          REACT_SCOPE_TYPE = symbolFor("react.scope");
          REACT_OPAQUE_ID_TYPE = symbolFor("react.opaque.id");
          REACT_DEBUG_TRACING_MODE_TYPE = symbolFor("react.debug_trace_mode");
          REACT_OFFSCREEN_TYPE = symbolFor("react.offscreen");
          REACT_LEGACY_HIDDEN_TYPE = symbolFor("react.legacy_hidden");
        }
        var enableScopeAPI = false;
        function isValidElementType(type5) {
          if (typeof type5 === "string" || typeof type5 === "function") {
            return true;
          }
          if (type5 === REACT_FRAGMENT_TYPE || type5 === REACT_PROFILER_TYPE || type5 === REACT_DEBUG_TRACING_MODE_TYPE || type5 === REACT_STRICT_MODE_TYPE || type5 === REACT_SUSPENSE_TYPE || type5 === REACT_SUSPENSE_LIST_TYPE || type5 === REACT_LEGACY_HIDDEN_TYPE || enableScopeAPI) {
            return true;
          }
          if (typeof type5 === "object" && type5 !== null) {
            if (type5.$$typeof === REACT_LAZY_TYPE || type5.$$typeof === REACT_MEMO_TYPE || type5.$$typeof === REACT_PROVIDER_TYPE || type5.$$typeof === REACT_CONTEXT_TYPE || type5.$$typeof === REACT_FORWARD_REF_TYPE || type5.$$typeof === REACT_FUNDAMENTAL_TYPE || type5.$$typeof === REACT_BLOCK_TYPE || type5[0] === REACT_SERVER_BLOCK_TYPE) {
              return true;
            }
          }
          return false;
        }
        __name(isValidElementType, "isValidElementType");
        function typeOf(object) {
          if (typeof object === "object" && object !== null) {
            var $$typeof = object.$$typeof;
            switch ($$typeof) {
              case REACT_ELEMENT_TYPE:
                var type5 = object.type;
                switch (type5) {
                  case REACT_FRAGMENT_TYPE:
                  case REACT_PROFILER_TYPE:
                  case REACT_STRICT_MODE_TYPE:
                  case REACT_SUSPENSE_TYPE:
                  case REACT_SUSPENSE_LIST_TYPE:
                    return type5;
                  default:
                    var $$typeofType = type5 && type5.$$typeof;
                    switch ($$typeofType) {
                      case REACT_CONTEXT_TYPE:
                      case REACT_FORWARD_REF_TYPE:
                      case REACT_LAZY_TYPE:
                      case REACT_MEMO_TYPE:
                      case REACT_PROVIDER_TYPE:
                        return $$typeofType;
                      default:
                        return $$typeof;
                    }
                }
              case REACT_PORTAL_TYPE:
                return $$typeof;
            }
          }
          return void 0;
        }
        __name(typeOf, "typeOf");
        var ContextConsumer = REACT_CONTEXT_TYPE;
        var ContextProvider = REACT_PROVIDER_TYPE;
        var Element = REACT_ELEMENT_TYPE;
        var ForwardRef = REACT_FORWARD_REF_TYPE;
        var Fragment = REACT_FRAGMENT_TYPE;
        var Lazy = REACT_LAZY_TYPE;
        var Memo = REACT_MEMO_TYPE;
        var Portal = REACT_PORTAL_TYPE;
        var Profiler = REACT_PROFILER_TYPE;
        var StrictMode = REACT_STRICT_MODE_TYPE;
        var Suspense = REACT_SUSPENSE_TYPE;
        var hasWarnedAboutDeprecatedIsAsyncMode = false;
        var hasWarnedAboutDeprecatedIsConcurrentMode = false;
        function isAsyncMode(object) {
          {
            if (!hasWarnedAboutDeprecatedIsAsyncMode) {
              hasWarnedAboutDeprecatedIsAsyncMode = true;
              console["warn"]("The ReactIs.isAsyncMode() alias has been deprecated, and will be removed in React 18+.");
            }
          }
          return false;
        }
        __name(isAsyncMode, "isAsyncMode");
        function isConcurrentMode(object) {
          {
            if (!hasWarnedAboutDeprecatedIsConcurrentMode) {
              hasWarnedAboutDeprecatedIsConcurrentMode = true;
              console["warn"]("The ReactIs.isConcurrentMode() alias has been deprecated, and will be removed in React 18+.");
            }
          }
          return false;
        }
        __name(isConcurrentMode, "isConcurrentMode");
        function isContextConsumer(object) {
          return typeOf(object) === REACT_CONTEXT_TYPE;
        }
        __name(isContextConsumer, "isContextConsumer");
        function isContextProvider(object) {
          return typeOf(object) === REACT_PROVIDER_TYPE;
        }
        __name(isContextProvider, "isContextProvider");
        function isElement5(object) {
          return typeof object === "object" && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
        }
        __name(isElement5, "isElement");
        function isForwardRef(object) {
          return typeOf(object) === REACT_FORWARD_REF_TYPE;
        }
        __name(isForwardRef, "isForwardRef");
        function isFragment(object) {
          return typeOf(object) === REACT_FRAGMENT_TYPE;
        }
        __name(isFragment, "isFragment");
        function isLazy(object) {
          return typeOf(object) === REACT_LAZY_TYPE;
        }
        __name(isLazy, "isLazy");
        function isMemo(object) {
          return typeOf(object) === REACT_MEMO_TYPE;
        }
        __name(isMemo, "isMemo");
        function isPortal(object) {
          return typeOf(object) === REACT_PORTAL_TYPE;
        }
        __name(isPortal, "isPortal");
        function isProfiler(object) {
          return typeOf(object) === REACT_PROFILER_TYPE;
        }
        __name(isProfiler, "isProfiler");
        function isStrictMode(object) {
          return typeOf(object) === REACT_STRICT_MODE_TYPE;
        }
        __name(isStrictMode, "isStrictMode");
        function isSuspense(object) {
          return typeOf(object) === REACT_SUSPENSE_TYPE;
        }
        __name(isSuspense, "isSuspense");
        exports.ContextConsumer = ContextConsumer;
        exports.ContextProvider = ContextProvider;
        exports.Element = Element;
        exports.ForwardRef = ForwardRef;
        exports.Fragment = Fragment;
        exports.Lazy = Lazy;
        exports.Memo = Memo;
        exports.Portal = Portal;
        exports.Profiler = Profiler;
        exports.StrictMode = StrictMode;
        exports.Suspense = Suspense;
        exports.isAsyncMode = isAsyncMode;
        exports.isConcurrentMode = isConcurrentMode;
        exports.isContextConsumer = isContextConsumer;
        exports.isContextProvider = isContextProvider;
        exports.isElement = isElement5;
        exports.isForwardRef = isForwardRef;
        exports.isFragment = isFragment;
        exports.isLazy = isLazy;
        exports.isMemo = isMemo;
        exports.isPortal = isPortal;
        exports.isProfiler = isProfiler;
        exports.isStrictMode = isStrictMode;
        exports.isSuspense = isSuspense;
        exports.isValidElementType = isValidElementType;
        exports.typeOf = typeOf;
      })();
    }
  }
});

// ../node_modules/pretty-format/node_modules/react-is/index.js
var require_react_is = __commonJS({
  "../node_modules/pretty-format/node_modules/react-is/index.js"(exports, module2) {
    "use strict";
    if (process.env.NODE_ENV === "production") {
      module2.exports = require_react_is_production_min();
    } else {
      module2.exports = require_react_is_development();
    }
  }
});

// ../node_modules/pretty-format/build/plugins/ReactElement.js
var require_ReactElement = __commonJS({
  "../node_modules/pretty-format/build/plugins/ReactElement.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.test = exports.serialize = exports.default = void 0;
    var ReactIs = _interopRequireWildcard(require_react_is());
    var _markup = require_markup();
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function") return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = /* @__PURE__ */ __name(function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      }, "_getRequireWildcardCache"))(nodeInterop);
    }
    __name(_getRequireWildcardCache, "_getRequireWildcardCache");
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    __name(_interopRequireWildcard, "_interopRequireWildcard");
    var getChildren = /* @__PURE__ */ __name((arg, children = []) => {
      if (Array.isArray(arg)) {
        arg.forEach((item) => {
          getChildren(item, children);
        });
      } else if (arg != null && arg !== false) {
        children.push(arg);
      }
      return children;
    }, "getChildren");
    var getType2 = /* @__PURE__ */ __name((element) => {
      const type5 = element.type;
      if (typeof type5 === "string") {
        return type5;
      }
      if (typeof type5 === "function") {
        return type5.displayName || type5.name || "Unknown";
      }
      if (ReactIs.isFragment(element)) {
        return "React.Fragment";
      }
      if (ReactIs.isSuspense(element)) {
        return "React.Suspense";
      }
      if (typeof type5 === "object" && type5 !== null) {
        if (ReactIs.isContextProvider(element)) {
          return "Context.Provider";
        }
        if (ReactIs.isContextConsumer(element)) {
          return "Context.Consumer";
        }
        if (ReactIs.isForwardRef(element)) {
          if (type5.displayName) {
            return type5.displayName;
          }
          const functionName = type5.render.displayName || type5.render.name || "";
          return functionName !== "" ? "ForwardRef(" + functionName + ")" : "ForwardRef";
        }
        if (ReactIs.isMemo(element)) {
          const functionName = type5.displayName || type5.type.displayName || type5.type.name || "";
          return functionName !== "" ? "Memo(" + functionName + ")" : "Memo";
        }
      }
      return "UNDEFINED";
    }, "getType");
    var getPropKeys = /* @__PURE__ */ __name((element) => {
      const { props } = element;
      return Object.keys(props).filter((key) => key !== "children" && props[key] !== void 0).sort();
    }, "getPropKeys");
    var serialize = /* @__PURE__ */ __name((element, config3, indentation, depth, refs, printer) => ++depth > config3.maxDepth ? (0, _markup.printElementAsLeaf)(getType2(element), config3) : (0, _markup.printElement)(
      getType2(element),
      (0, _markup.printProps)(
        getPropKeys(element),
        element.props,
        config3,
        indentation + config3.indent,
        depth,
        refs,
        printer
      ),
      (0, _markup.printChildren)(
        getChildren(element.props.children),
        config3,
        indentation + config3.indent,
        depth,
        refs,
        printer
      ),
      config3,
      indentation
    ), "serialize");
    exports.serialize = serialize;
    var test2 = /* @__PURE__ */ __name((val) => val != null && ReactIs.isElement(val), "test");
    exports.test = test2;
    var plugin = {
      serialize,
      test: test2
    };
    var _default = plugin;
    exports.default = _default;
  }
});

// ../node_modules/pretty-format/build/plugins/ReactTestComponent.js
var require_ReactTestComponent = __commonJS({
  "../node_modules/pretty-format/build/plugins/ReactTestComponent.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.test = exports.serialize = exports.default = void 0;
    var _markup = require_markup();
    var global2 = function() {
      if (typeof globalThis !== "undefined") {
        return globalThis;
      } else if (typeof global2 !== "undefined") {
        return global2;
      } else if (typeof self !== "undefined") {
        return self;
      } else if (typeof window !== "undefined") {
        return window;
      } else {
        return Function("return this")();
      }
    }();
    var Symbol2 = global2["jest-symbol-do-not-touch"] || global2.Symbol;
    var testSymbol = typeof Symbol2 === "function" && Symbol2.for ? Symbol2.for("react.test.json") : 245830487;
    var getPropKeys = /* @__PURE__ */ __name((object) => {
      const { props } = object;
      return props ? Object.keys(props).filter((key) => props[key] !== void 0).sort() : [];
    }, "getPropKeys");
    var serialize = /* @__PURE__ */ __name((object, config3, indentation, depth, refs, printer) => ++depth > config3.maxDepth ? (0, _markup.printElementAsLeaf)(object.type, config3) : (0, _markup.printElement)(
      object.type,
      object.props ? (0, _markup.printProps)(
        getPropKeys(object),
        object.props,
        config3,
        indentation + config3.indent,
        depth,
        refs,
        printer
      ) : "",
      object.children ? (0, _markup.printChildren)(
        object.children,
        config3,
        indentation + config3.indent,
        depth,
        refs,
        printer
      ) : "",
      config3,
      indentation
    ), "serialize");
    exports.serialize = serialize;
    var test2 = /* @__PURE__ */ __name((val) => val && val.$$typeof === testSymbol, "test");
    exports.test = test2;
    var plugin = {
      serialize,
      test: test2
    };
    var _default = plugin;
    exports.default = _default;
  }
});

// ../node_modules/pretty-format/build/index.js
var require_build = __commonJS({
  "../node_modules/pretty-format/build/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.DEFAULT_OPTIONS = void 0;
    exports.format = format3;
    exports.plugins = void 0;
    var _ansiStyles = _interopRequireDefault(require_ansi_styles());
    var _collections = require_collections();
    var _AsymmetricMatcher2 = _interopRequireDefault(
      require_AsymmetricMatcher()
    );
    var _ConvertAnsi = _interopRequireDefault(require_ConvertAnsi());
    var _DOMCollection = _interopRequireDefault(require_DOMCollection());
    var _DOMElement = _interopRequireDefault(require_DOMElement());
    var _Immutable = _interopRequireDefault(require_Immutable());
    var _ReactElement = _interopRequireDefault(require_ReactElement());
    var _ReactTestComponent = _interopRequireDefault(
      require_ReactTestComponent()
    );
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    __name(_interopRequireDefault, "_interopRequireDefault");
    var toString2 = Object.prototype.toString;
    var toISOString = Date.prototype.toISOString;
    var errorToString = Error.prototype.toString;
    var regExpToString = RegExp.prototype.toString;
    var getConstructorName2 = /* @__PURE__ */ __name((val) => typeof val.constructor === "function" && val.constructor.name || "Object", "getConstructorName");
    var isWindow = /* @__PURE__ */ __name((val) => typeof window !== "undefined" && val === window, "isWindow");
    var SYMBOL_REGEXP = /^Symbol\((.*)\)(.*)$/;
    var NEWLINE_REGEXP = /\n/gi;
    var _PrettyFormatPluginError = class _PrettyFormatPluginError extends Error {
      constructor(message, stack) {
        super(message);
        this.stack = stack;
        this.name = this.constructor.name;
      }
    };
    __name(_PrettyFormatPluginError, "PrettyFormatPluginError");
    var PrettyFormatPluginError = _PrettyFormatPluginError;
    function isToStringedArrayType(toStringed) {
      return toStringed === "[object Array]" || toStringed === "[object ArrayBuffer]" || toStringed === "[object DataView]" || toStringed === "[object Float32Array]" || toStringed === "[object Float64Array]" || toStringed === "[object Int8Array]" || toStringed === "[object Int16Array]" || toStringed === "[object Int32Array]" || toStringed === "[object Uint8Array]" || toStringed === "[object Uint8ClampedArray]" || toStringed === "[object Uint16Array]" || toStringed === "[object Uint32Array]";
    }
    __name(isToStringedArrayType, "isToStringedArrayType");
    function printNumber(val) {
      return Object.is(val, -0) ? "-0" : String(val);
    }
    __name(printNumber, "printNumber");
    function printBigInt(val) {
      return String(`${val}n`);
    }
    __name(printBigInt, "printBigInt");
    function printFunction(val, printFunctionName) {
      if (!printFunctionName) {
        return "[Function]";
      }
      return "[Function " + (val.name || "anonymous") + "]";
    }
    __name(printFunction, "printFunction");
    function printSymbol(val) {
      return String(val).replace(SYMBOL_REGEXP, "Symbol($1)");
    }
    __name(printSymbol, "printSymbol");
    function printError(val) {
      return "[" + errorToString.call(val) + "]";
    }
    __name(printError, "printError");
    function printBasicValue(val, printFunctionName, escapeRegex, escapeString) {
      if (val === true || val === false) {
        return "" + val;
      }
      if (val === void 0) {
        return "undefined";
      }
      if (val === null) {
        return "null";
      }
      const typeOf = typeof val;
      if (typeOf === "number") {
        return printNumber(val);
      }
      if (typeOf === "bigint") {
        return printBigInt(val);
      }
      if (typeOf === "string") {
        if (escapeString) {
          return '"' + val.replace(/"|\\/g, "\\$&") + '"';
        }
        return '"' + val + '"';
      }
      if (typeOf === "function") {
        return printFunction(val, printFunctionName);
      }
      if (typeOf === "symbol") {
        return printSymbol(val);
      }
      const toStringed = toString2.call(val);
      if (toStringed === "[object WeakMap]") {
        return "WeakMap {}";
      }
      if (toStringed === "[object WeakSet]") {
        return "WeakSet {}";
      }
      if (toStringed === "[object Function]" || toStringed === "[object GeneratorFunction]") {
        return printFunction(val, printFunctionName);
      }
      if (toStringed === "[object Symbol]") {
        return printSymbol(val);
      }
      if (toStringed === "[object Date]") {
        return isNaN(+val) ? "Date { NaN }" : toISOString.call(val);
      }
      if (toStringed === "[object Error]") {
        return printError(val);
      }
      if (toStringed === "[object RegExp]") {
        if (escapeRegex) {
          return regExpToString.call(val).replace(/[\\^$*+?.()|[\]{}]/g, "\\$&");
        }
        return regExpToString.call(val);
      }
      if (val instanceof Error) {
        return printError(val);
      }
      return null;
    }
    __name(printBasicValue, "printBasicValue");
    function printComplexValue(val, config3, indentation, depth, refs, hasCalledToJSON) {
      if (refs.indexOf(val) !== -1) {
        return "[Circular]";
      }
      refs = refs.slice();
      refs.push(val);
      const hitMaxDepth = ++depth > config3.maxDepth;
      const min = config3.min;
      if (config3.callToJSON && !hitMaxDepth && val.toJSON && typeof val.toJSON === "function" && !hasCalledToJSON) {
        return printer(val.toJSON(), config3, indentation, depth, refs, true);
      }
      const toStringed = toString2.call(val);
      if (toStringed === "[object Arguments]") {
        return hitMaxDepth ? "[Arguments]" : (min ? "" : "Arguments ") + "[" + (0, _collections.printListItems)(
          val,
          config3,
          indentation,
          depth,
          refs,
          printer
        ) + "]";
      }
      if (isToStringedArrayType(toStringed)) {
        return hitMaxDepth ? "[" + val.constructor.name + "]" : (min ? "" : !config3.printBasicPrototype && val.constructor.name === "Array" ? "" : val.constructor.name + " ") + "[" + (0, _collections.printListItems)(
          val,
          config3,
          indentation,
          depth,
          refs,
          printer
        ) + "]";
      }
      if (toStringed === "[object Map]") {
        return hitMaxDepth ? "[Map]" : "Map {" + (0, _collections.printIteratorEntries)(
          val.entries(),
          config3,
          indentation,
          depth,
          refs,
          printer,
          " => "
        ) + "}";
      }
      if (toStringed === "[object Set]") {
        return hitMaxDepth ? "[Set]" : "Set {" + (0, _collections.printIteratorValues)(
          val.values(),
          config3,
          indentation,
          depth,
          refs,
          printer
        ) + "}";
      }
      return hitMaxDepth || isWindow(val) ? "[" + getConstructorName2(val) + "]" : (min ? "" : !config3.printBasicPrototype && getConstructorName2(val) === "Object" ? "" : getConstructorName2(val) + " ") + "{" + (0, _collections.printObjectProperties)(
        val,
        config3,
        indentation,
        depth,
        refs,
        printer
      ) + "}";
    }
    __name(printComplexValue, "printComplexValue");
    function isNewPlugin(plugin) {
      return plugin.serialize != null;
    }
    __name(isNewPlugin, "isNewPlugin");
    function printPlugin(plugin, val, config3, indentation, depth, refs) {
      let printed;
      try {
        printed = isNewPlugin(plugin) ? plugin.serialize(val, config3, indentation, depth, refs, printer) : plugin.print(
          val,
          (valChild) => printer(valChild, config3, indentation, depth, refs),
          (str) => {
            const indentationNext = indentation + config3.indent;
            return indentationNext + str.replace(NEWLINE_REGEXP, "\n" + indentationNext);
          },
          {
            edgeSpacing: config3.spacingOuter,
            min: config3.min,
            spacing: config3.spacingInner
          },
          config3.colors
        );
      } catch (error) {
        throw new PrettyFormatPluginError(error.message, error.stack);
      }
      if (typeof printed !== "string") {
        throw new Error(
          `pretty-format: Plugin must return type "string" but instead returned "${typeof printed}".`
        );
      }
      return printed;
    }
    __name(printPlugin, "printPlugin");
    function findPlugin(plugins3, val) {
      for (let p = 0; p < plugins3.length; p++) {
        try {
          if (plugins3[p].test(val)) {
            return plugins3[p];
          }
        } catch (error) {
          throw new PrettyFormatPluginError(error.message, error.stack);
        }
      }
      return null;
    }
    __name(findPlugin, "findPlugin");
    function printer(val, config3, indentation, depth, refs, hasCalledToJSON) {
      const plugin = findPlugin(config3.plugins, val);
      if (plugin !== null) {
        return printPlugin(plugin, val, config3, indentation, depth, refs);
      }
      const basicResult = printBasicValue(
        val,
        config3.printFunctionName,
        config3.escapeRegex,
        config3.escapeString
      );
      if (basicResult !== null) {
        return basicResult;
      }
      return printComplexValue(
        val,
        config3,
        indentation,
        depth,
        refs,
        hasCalledToJSON
      );
    }
    __name(printer, "printer");
    var DEFAULT_THEME = {
      comment: "gray",
      content: "reset",
      prop: "yellow",
      tag: "cyan",
      value: "green"
    };
    var DEFAULT_THEME_KEYS = Object.keys(DEFAULT_THEME);
    var DEFAULT_OPTIONS = {
      callToJSON: true,
      compareKeys: void 0,
      escapeRegex: false,
      escapeString: true,
      highlight: false,
      indent: 2,
      maxDepth: Infinity,
      min: false,
      plugins: [],
      printBasicPrototype: true,
      printFunctionName: true,
      theme: DEFAULT_THEME
    };
    exports.DEFAULT_OPTIONS = DEFAULT_OPTIONS;
    function validateOptions(options) {
      Object.keys(options).forEach((key) => {
        if (!DEFAULT_OPTIONS.hasOwnProperty(key)) {
          throw new Error(`pretty-format: Unknown option "${key}".`);
        }
      });
      if (options.min && options.indent !== void 0 && options.indent !== 0) {
        throw new Error(
          'pretty-format: Options "min" and "indent" cannot be used together.'
        );
      }
      if (options.theme !== void 0) {
        if (options.theme === null) {
          throw new Error('pretty-format: Option "theme" must not be null.');
        }
        if (typeof options.theme !== "object") {
          throw new Error(
            `pretty-format: Option "theme" must be of type "object" but instead received "${typeof options.theme}".`
          );
        }
      }
    }
    __name(validateOptions, "validateOptions");
    var getColorsHighlight = /* @__PURE__ */ __name((options) => DEFAULT_THEME_KEYS.reduce((colors, key) => {
      const value = options.theme && options.theme[key] !== void 0 ? options.theme[key] : DEFAULT_THEME[key];
      const color = value && _ansiStyles.default[value];
      if (color && typeof color.close === "string" && typeof color.open === "string") {
        colors[key] = color;
      } else {
        throw new Error(
          `pretty-format: Option "theme" has a key "${key}" whose value "${value}" is undefined in ansi-styles.`
        );
      }
      return colors;
    }, /* @__PURE__ */ Object.create(null)), "getColorsHighlight");
    var getColorsEmpty = /* @__PURE__ */ __name(() => DEFAULT_THEME_KEYS.reduce((colors, key) => {
      colors[key] = {
        close: "",
        open: ""
      };
      return colors;
    }, /* @__PURE__ */ Object.create(null)), "getColorsEmpty");
    var getPrintFunctionName = /* @__PURE__ */ __name((options) => options && options.printFunctionName !== void 0 ? options.printFunctionName : DEFAULT_OPTIONS.printFunctionName, "getPrintFunctionName");
    var getEscapeRegex = /* @__PURE__ */ __name((options) => options && options.escapeRegex !== void 0 ? options.escapeRegex : DEFAULT_OPTIONS.escapeRegex, "getEscapeRegex");
    var getEscapeString = /* @__PURE__ */ __name((options) => options && options.escapeString !== void 0 ? options.escapeString : DEFAULT_OPTIONS.escapeString, "getEscapeString");
    var getConfig3 = /* @__PURE__ */ __name((options) => {
      var _options$printBasicPr;
      return {
        callToJSON: options && options.callToJSON !== void 0 ? options.callToJSON : DEFAULT_OPTIONS.callToJSON,
        colors: options && options.highlight ? getColorsHighlight(options) : getColorsEmpty(),
        compareKeys: options && typeof options.compareKeys === "function" ? options.compareKeys : DEFAULT_OPTIONS.compareKeys,
        escapeRegex: getEscapeRegex(options),
        escapeString: getEscapeString(options),
        indent: options && options.min ? "" : createIndent(
          options && options.indent !== void 0 ? options.indent : DEFAULT_OPTIONS.indent
        ),
        maxDepth: options && options.maxDepth !== void 0 ? options.maxDepth : DEFAULT_OPTIONS.maxDepth,
        min: options && options.min !== void 0 ? options.min : DEFAULT_OPTIONS.min,
        plugins: options && options.plugins !== void 0 ? options.plugins : DEFAULT_OPTIONS.plugins,
        printBasicPrototype: (_options$printBasicPr = options === null || options === void 0 ? void 0 : options.printBasicPrototype) !== null && _options$printBasicPr !== void 0 ? _options$printBasicPr : true,
        printFunctionName: getPrintFunctionName(options),
        spacingInner: options && options.min ? " " : "\n",
        spacingOuter: options && options.min ? "" : "\n"
      };
    }, "getConfig");
    function createIndent(indent) {
      return new Array(indent + 1).join(" ");
    }
    __name(createIndent, "createIndent");
    function format3(val, options) {
      if (options) {
        validateOptions(options);
        if (options.plugins) {
          const plugin = findPlugin(options.plugins, val);
          if (plugin !== null) {
            return printPlugin(plugin, val, getConfig3(options), "", 0, []);
          }
        }
      }
      const basicResult = printBasicValue(
        val,
        getPrintFunctionName(options),
        getEscapeRegex(options),
        getEscapeString(options)
      );
      if (basicResult !== null) {
        return basicResult;
      }
      return printComplexValue(val, getConfig3(options), "", 0, []);
    }
    __name(format3, "format");
    var plugins2 = {
      AsymmetricMatcher: _AsymmetricMatcher2.default,
      ConvertAnsi: _ConvertAnsi.default,
      DOMCollection: _DOMCollection.default,
      DOMElement: _DOMElement.default,
      Immutable: _Immutable.default,
      ReactElement: _ReactElement.default,
      ReactTestComponent: _ReactTestComponent.default
    };
    exports.plugins = plugins2;
    var _default = format3;
    exports.default = _default;
  }
});

// ../node_modules/lz-string/libs/lz-string.js
var require_lz_string = __commonJS({
  "../node_modules/lz-string/libs/lz-string.js"(exports, module2) {
    var LZString = function() {
      var f3 = String.fromCharCode;
      var keyStrBase64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
      var keyStrUriSafe = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$";
      var baseReverseDic = {};
      function getBaseValue(alphabet, character) {
        if (!baseReverseDic[alphabet]) {
          baseReverseDic[alphabet] = {};
          for (var i2 = 0; i2 < alphabet.length; i2++) {
            baseReverseDic[alphabet][alphabet.charAt(i2)] = i2;
          }
        }
        return baseReverseDic[alphabet][character];
      }
      __name(getBaseValue, "getBaseValue");
      var LZString2 = {
        compressToBase64: /* @__PURE__ */ __name(function(input2) {
          if (input2 == null) return "";
          var res = LZString2._compress(input2, 6, function(a) {
            return keyStrBase64.charAt(a);
          });
          switch (res.length % 4) {
            // To produce valid Base64
            default:
            // When could this happen ?
            case 0:
              return res;
            case 1:
              return res + "===";
            case 2:
              return res + "==";
            case 3:
              return res + "=";
          }
        }, "compressToBase64"),
        decompressFromBase64: /* @__PURE__ */ __name(function(input2) {
          if (input2 == null) return "";
          if (input2 == "") return null;
          return LZString2._decompress(input2.length, 32, function(index) {
            return getBaseValue(keyStrBase64, input2.charAt(index));
          });
        }, "decompressFromBase64"),
        compressToUTF16: /* @__PURE__ */ __name(function(input2) {
          if (input2 == null) return "";
          return LZString2._compress(input2, 15, function(a) {
            return f3(a + 32);
          }) + " ";
        }, "compressToUTF16"),
        decompressFromUTF16: /* @__PURE__ */ __name(function(compressed) {
          if (compressed == null) return "";
          if (compressed == "") return null;
          return LZString2._decompress(compressed.length, 16384, function(index) {
            return compressed.charCodeAt(index) - 32;
          });
        }, "decompressFromUTF16"),
        //compress into uint8array (UCS-2 big endian format)
        compressToUint8Array: /* @__PURE__ */ __name(function(uncompressed) {
          var compressed = LZString2.compress(uncompressed);
          var buf = new Uint8Array(compressed.length * 2);
          for (var i2 = 0, TotalLen = compressed.length; i2 < TotalLen; i2++) {
            var current_value = compressed.charCodeAt(i2);
            buf[i2 * 2] = current_value >>> 8;
            buf[i2 * 2 + 1] = current_value % 256;
          }
          return buf;
        }, "compressToUint8Array"),
        //decompress from uint8array (UCS-2 big endian format)
        decompressFromUint8Array: /* @__PURE__ */ __name(function(compressed) {
          if (compressed === null || compressed === void 0) {
            return LZString2.decompress(compressed);
          } else {
            var buf = new Array(compressed.length / 2);
            for (var i2 = 0, TotalLen = buf.length; i2 < TotalLen; i2++) {
              buf[i2] = compressed[i2 * 2] * 256 + compressed[i2 * 2 + 1];
            }
            var result = [];
            buf.forEach(function(c2) {
              result.push(f3(c2));
            });
            return LZString2.decompress(result.join(""));
          }
        }, "decompressFromUint8Array"),
        //compress into a string that is already URI encoded
        compressToEncodedURIComponent: /* @__PURE__ */ __name(function(input2) {
          if (input2 == null) return "";
          return LZString2._compress(input2, 6, function(a) {
            return keyStrUriSafe.charAt(a);
          });
        }, "compressToEncodedURIComponent"),
        //decompress from an output of compressToEncodedURIComponent
        decompressFromEncodedURIComponent: /* @__PURE__ */ __name(function(input2) {
          if (input2 == null) return "";
          if (input2 == "") return null;
          input2 = input2.replace(/ /g, "+");
          return LZString2._decompress(input2.length, 32, function(index) {
            return getBaseValue(keyStrUriSafe, input2.charAt(index));
          });
        }, "decompressFromEncodedURIComponent"),
        compress: /* @__PURE__ */ __name(function(uncompressed) {
          return LZString2._compress(uncompressed, 16, function(a) {
            return f3(a);
          });
        }, "compress"),
        _compress: /* @__PURE__ */ __name(function(uncompressed, bitsPerChar, getCharFromInt) {
          if (uncompressed == null) return "";
          var i2, value, context_dictionary = {}, context_dictionaryToCreate = {}, context_c = "", context_wc = "", context_w = "", context_enlargeIn = 2, context_dictSize = 3, context_numBits = 2, context_data = [], context_data_val = 0, context_data_position = 0, ii;
          for (ii = 0; ii < uncompressed.length; ii += 1) {
            context_c = uncompressed.charAt(ii);
            if (!Object.prototype.hasOwnProperty.call(context_dictionary, context_c)) {
              context_dictionary[context_c] = context_dictSize++;
              context_dictionaryToCreate[context_c] = true;
            }
            context_wc = context_w + context_c;
            if (Object.prototype.hasOwnProperty.call(context_dictionary, context_wc)) {
              context_w = context_wc;
            } else {
              if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate, context_w)) {
                if (context_w.charCodeAt(0) < 256) {
                  for (i2 = 0; i2 < context_numBits; i2++) {
                    context_data_val = context_data_val << 1;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                  }
                  value = context_w.charCodeAt(0);
                  for (i2 = 0; i2 < 8; i2++) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                    value = value >> 1;
                  }
                } else {
                  value = 1;
                  for (i2 = 0; i2 < context_numBits; i2++) {
                    context_data_val = context_data_val << 1 | value;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                    value = 0;
                  }
                  value = context_w.charCodeAt(0);
                  for (i2 = 0; i2 < 16; i2++) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                      context_data_position = 0;
                      context_data.push(getCharFromInt(context_data_val));
                      context_data_val = 0;
                    } else {
                      context_data_position++;
                    }
                    value = value >> 1;
                  }
                }
                context_enlargeIn--;
                if (context_enlargeIn == 0) {
                  context_enlargeIn = Math.pow(2, context_numBits);
                  context_numBits++;
                }
                delete context_dictionaryToCreate[context_w];
              } else {
                value = context_dictionary[context_w];
                for (i2 = 0; i2 < context_numBits; i2++) {
                  context_data_val = context_data_val << 1 | value & 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = value >> 1;
                }
              }
              context_enlargeIn--;
              if (context_enlargeIn == 0) {
                context_enlargeIn = Math.pow(2, context_numBits);
                context_numBits++;
              }
              context_dictionary[context_wc] = context_dictSize++;
              context_w = String(context_c);
            }
          }
          if (context_w !== "") {
            if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate, context_w)) {
              if (context_w.charCodeAt(0) < 256) {
                for (i2 = 0; i2 < context_numBits; i2++) {
                  context_data_val = context_data_val << 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                }
                value = context_w.charCodeAt(0);
                for (i2 = 0; i2 < 8; i2++) {
                  context_data_val = context_data_val << 1 | value & 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = value >> 1;
                }
              } else {
                value = 1;
                for (i2 = 0; i2 < context_numBits; i2++) {
                  context_data_val = context_data_val << 1 | value;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = 0;
                }
                value = context_w.charCodeAt(0);
                for (i2 = 0; i2 < 16; i2++) {
                  context_data_val = context_data_val << 1 | value & 1;
                  if (context_data_position == bitsPerChar - 1) {
                    context_data_position = 0;
                    context_data.push(getCharFromInt(context_data_val));
                    context_data_val = 0;
                  } else {
                    context_data_position++;
                  }
                  value = value >> 1;
                }
              }
              context_enlargeIn--;
              if (context_enlargeIn == 0) {
                context_enlargeIn = Math.pow(2, context_numBits);
                context_numBits++;
              }
              delete context_dictionaryToCreate[context_w];
            } else {
              value = context_dictionary[context_w];
              for (i2 = 0; i2 < context_numBits; i2++) {
                context_data_val = context_data_val << 1 | value & 1;
                if (context_data_position == bitsPerChar - 1) {
                  context_data_position = 0;
                  context_data.push(getCharFromInt(context_data_val));
                  context_data_val = 0;
                } else {
                  context_data_position++;
                }
                value = value >> 1;
              }
            }
            context_enlargeIn--;
            if (context_enlargeIn == 0) {
              context_enlargeIn = Math.pow(2, context_numBits);
              context_numBits++;
            }
          }
          value = 2;
          for (i2 = 0; i2 < context_numBits; i2++) {
            context_data_val = context_data_val << 1 | value & 1;
            if (context_data_position == bitsPerChar - 1) {
              context_data_position = 0;
              context_data.push(getCharFromInt(context_data_val));
              context_data_val = 0;
            } else {
              context_data_position++;
            }
            value = value >> 1;
          }
          while (true) {
            context_data_val = context_data_val << 1;
            if (context_data_position == bitsPerChar - 1) {
              context_data.push(getCharFromInt(context_data_val));
              break;
            } else context_data_position++;
          }
          return context_data.join("");
        }, "_compress"),
        decompress: /* @__PURE__ */ __name(function(compressed) {
          if (compressed == null) return "";
          if (compressed == "") return null;
          return LZString2._decompress(compressed.length, 32768, function(index) {
            return compressed.charCodeAt(index);
          });
        }, "decompress"),
        _decompress: /* @__PURE__ */ __name(function(length, resetValue, getNextValue) {
          var dictionary = [], next, enlargeIn = 4, dictSize = 4, numBits = 3, entry = "", result = [], i2, w2, bits, resb, maxpower, power, c2, data = { val: getNextValue(0), position: resetValue, index: 1 };
          for (i2 = 0; i2 < 3; i2 += 1) {
            dictionary[i2] = i2;
          }
          bits = 0;
          maxpower = Math.pow(2, 2);
          power = 1;
          while (power != maxpower) {
            resb = data.val & data.position;
            data.position >>= 1;
            if (data.position == 0) {
              data.position = resetValue;
              data.val = getNextValue(data.index++);
            }
            bits |= (resb > 0 ? 1 : 0) * power;
            power <<= 1;
          }
          switch (next = bits) {
            case 0:
              bits = 0;
              maxpower = Math.pow(2, 8);
              power = 1;
              while (power != maxpower) {
                resb = data.val & data.position;
                data.position >>= 1;
                if (data.position == 0) {
                  data.position = resetValue;
                  data.val = getNextValue(data.index++);
                }
                bits |= (resb > 0 ? 1 : 0) * power;
                power <<= 1;
              }
              c2 = f3(bits);
              break;
            case 1:
              bits = 0;
              maxpower = Math.pow(2, 16);
              power = 1;
              while (power != maxpower) {
                resb = data.val & data.position;
                data.position >>= 1;
                if (data.position == 0) {
                  data.position = resetValue;
                  data.val = getNextValue(data.index++);
                }
                bits |= (resb > 0 ? 1 : 0) * power;
                power <<= 1;
              }
              c2 = f3(bits);
              break;
            case 2:
              return "";
          }
          dictionary[3] = c2;
          w2 = c2;
          result.push(c2);
          while (true) {
            if (data.index > length) {
              return "";
            }
            bits = 0;
            maxpower = Math.pow(2, numBits);
            power = 1;
            while (power != maxpower) {
              resb = data.val & data.position;
              data.position >>= 1;
              if (data.position == 0) {
                data.position = resetValue;
                data.val = getNextValue(data.index++);
              }
              bits |= (resb > 0 ? 1 : 0) * power;
              power <<= 1;
            }
            switch (c2 = bits) {
              case 0:
                bits = 0;
                maxpower = Math.pow(2, 8);
                power = 1;
                while (power != maxpower) {
                  resb = data.val & data.position;
                  data.position >>= 1;
                  if (data.position == 0) {
                    data.position = resetValue;
                    data.val = getNextValue(data.index++);
                  }
                  bits |= (resb > 0 ? 1 : 0) * power;
                  power <<= 1;
                }
                dictionary[dictSize++] = f3(bits);
                c2 = dictSize - 1;
                enlargeIn--;
                break;
              case 1:
                bits = 0;
                maxpower = Math.pow(2, 16);
                power = 1;
                while (power != maxpower) {
                  resb = data.val & data.position;
                  data.position >>= 1;
                  if (data.position == 0) {
                    data.position = resetValue;
                    data.val = getNextValue(data.index++);
                  }
                  bits |= (resb > 0 ? 1 : 0) * power;
                  power <<= 1;
                }
                dictionary[dictSize++] = f3(bits);
                c2 = dictSize - 1;
                enlargeIn--;
                break;
              case 2:
                return result.join("");
            }
            if (enlargeIn == 0) {
              enlargeIn = Math.pow(2, numBits);
              numBits++;
            }
            if (dictionary[c2]) {
              entry = dictionary[c2];
            } else {
              if (c2 === dictSize) {
                entry = w2 + w2.charAt(0);
              } else {
                return null;
              }
            }
            result.push(entry);
            dictionary[dictSize++] = w2 + entry.charAt(0);
            enlargeIn--;
            w2 = entry;
            if (enlargeIn == 0) {
              enlargeIn = Math.pow(2, numBits);
              numBits++;
            }
          }
        }, "_decompress")
      };
      return LZString2;
    }();
    if (typeof define === "function" && define.amd) {
      define(function() {
        return LZString;
      });
    } else if (typeof module2 !== "undefined" && module2 != null) {
      module2.exports = LZString;
    } else if (typeof angular !== "undefined" && angular != null) {
      angular.module("LZString", []).factory("LZString", function() {
        return LZString;
      });
    }
  }
});

// src/test/index.ts
import { instrument as instrument2 } from "storybook/internal/instrumenter";

// ../node_modules/chai/index.js
var __defProp = Object.defineProperty;
var __name2 = /* @__PURE__ */ __name((target, value) => __defProp(target, "name", { value, configurable: true }), "__name");
var __export2 = /* @__PURE__ */ __name((target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
}, "__export");
var utils_exports = {};
__export2(utils_exports, {
  addChainableMethod: /* @__PURE__ */ __name(() => addChainableMethod, "addChainableMethod"),
  addLengthGuard: /* @__PURE__ */ __name(() => addLengthGuard, "addLengthGuard"),
  addMethod: /* @__PURE__ */ __name(() => addMethod, "addMethod"),
  addProperty: /* @__PURE__ */ __name(() => addProperty, "addProperty"),
  checkError: /* @__PURE__ */ __name(() => check_error_exports, "checkError"),
  compareByInspect: /* @__PURE__ */ __name(() => compareByInspect, "compareByInspect"),
  eql: /* @__PURE__ */ __name(() => deep_eql_default, "eql"),
  expectTypes: /* @__PURE__ */ __name(() => expectTypes, "expectTypes"),
  flag: /* @__PURE__ */ __name(() => flag, "flag"),
  getActual: /* @__PURE__ */ __name(() => getActual, "getActual"),
  getMessage: /* @__PURE__ */ __name(() => getMessage2, "getMessage"),
  getName: /* @__PURE__ */ __name(() => getName, "getName"),
  getOperator: /* @__PURE__ */ __name(() => getOperator, "getOperator"),
  getOwnEnumerableProperties: /* @__PURE__ */ __name(() => getOwnEnumerableProperties, "getOwnEnumerableProperties"),
  getOwnEnumerablePropertySymbols: /* @__PURE__ */ __name(() => getOwnEnumerablePropertySymbols, "getOwnEnumerablePropertySymbols"),
  getPathInfo: /* @__PURE__ */ __name(() => getPathInfo, "getPathInfo"),
  hasProperty: /* @__PURE__ */ __name(() => hasProperty, "hasProperty"),
  inspect: /* @__PURE__ */ __name(() => inspect2, "inspect"),
  isNaN: /* @__PURE__ */ __name(() => isNaN22, "isNaN"),
  isNumeric: /* @__PURE__ */ __name(() => isNumeric, "isNumeric"),
  isProxyEnabled: /* @__PURE__ */ __name(() => isProxyEnabled, "isProxyEnabled"),
  isRegExp: /* @__PURE__ */ __name(() => isRegExp2, "isRegExp"),
  objDisplay: /* @__PURE__ */ __name(() => objDisplay, "objDisplay"),
  overwriteChainableMethod: /* @__PURE__ */ __name(() => overwriteChainableMethod, "overwriteChainableMethod"),
  overwriteMethod: /* @__PURE__ */ __name(() => overwriteMethod, "overwriteMethod"),
  overwriteProperty: /* @__PURE__ */ __name(() => overwriteProperty, "overwriteProperty"),
  proxify: /* @__PURE__ */ __name(() => proxify, "proxify"),
  test: /* @__PURE__ */ __name(() => test, "test"),
  transferFlags: /* @__PURE__ */ __name(() => transferFlags, "transferFlags"),
  type: /* @__PURE__ */ __name(() => type, "type")
});
var check_error_exports = {};
__export2(check_error_exports, {
  compatibleConstructor: /* @__PURE__ */ __name(() => compatibleConstructor, "compatibleConstructor"),
  compatibleInstance: /* @__PURE__ */ __name(() => compatibleInstance, "compatibleInstance"),
  compatibleMessage: /* @__PURE__ */ __name(() => compatibleMessage, "compatibleMessage"),
  getConstructorName: /* @__PURE__ */ __name(() => getConstructorName, "getConstructorName"),
  getMessage: /* @__PURE__ */ __name(() => getMessage, "getMessage")
});
function isErrorInstance(obj) {
  return obj instanceof Error || Object.prototype.toString.call(obj) === "[object Error]";
}
__name(isErrorInstance, "isErrorInstance");
__name2(isErrorInstance, "isErrorInstance");
function isRegExp(obj) {
  return Object.prototype.toString.call(obj) === "[object RegExp]";
}
__name(isRegExp, "isRegExp");
__name2(isRegExp, "isRegExp");
function compatibleInstance(thrown, errorLike) {
  return isErrorInstance(errorLike) && thrown === errorLike;
}
__name(compatibleInstance, "compatibleInstance");
__name2(compatibleInstance, "compatibleInstance");
function compatibleConstructor(thrown, errorLike) {
  if (isErrorInstance(errorLike)) {
    return thrown.constructor === errorLike.constructor || thrown instanceof errorLike.constructor;
  } else if ((typeof errorLike === "object" || typeof errorLike === "function") && errorLike.prototype) {
    return thrown.constructor === errorLike || thrown instanceof errorLike;
  }
  return false;
}
__name(compatibleConstructor, "compatibleConstructor");
__name2(compatibleConstructor, "compatibleConstructor");
function compatibleMessage(thrown, errMatcher) {
  const comparisonString = typeof thrown === "string" ? thrown : thrown.message;
  if (isRegExp(errMatcher)) {
    return errMatcher.test(comparisonString);
  } else if (typeof errMatcher === "string") {
    return comparisonString.indexOf(errMatcher) !== -1;
  }
  return false;
}
__name(compatibleMessage, "compatibleMessage");
__name2(compatibleMessage, "compatibleMessage");
function getConstructorName(errorLike) {
  let constructorName = errorLike;
  if (isErrorInstance(errorLike)) {
    constructorName = errorLike.constructor.name;
  } else if (typeof errorLike === "function") {
    constructorName = errorLike.name;
    if (constructorName === "") {
      const newConstructorName = new errorLike().name;
      constructorName = newConstructorName || constructorName;
    }
  }
  return constructorName;
}
__name(getConstructorName, "getConstructorName");
__name2(getConstructorName, "getConstructorName");
function getMessage(errorLike) {
  let msg = "";
  if (errorLike && errorLike.message) {
    msg = errorLike.message;
  } else if (typeof errorLike === "string") {
    msg = errorLike;
  }
  return msg;
}
__name(getMessage, "getMessage");
__name2(getMessage, "getMessage");
function flag(obj, key, value) {
  let flags = obj.__flags || (obj.__flags = /* @__PURE__ */ Object.create(null));
  if (arguments.length === 3) {
    flags[key] = value;
  } else {
    return flags[key];
  }
}
__name(flag, "flag");
__name2(flag, "flag");
function test(obj, args) {
  let negate = flag(obj, "negate"), expr = args[0];
  return negate ? !expr : expr;
}
__name(test, "test");
__name2(test, "test");
function type(obj) {
  if (typeof obj === "undefined") {
    return "undefined";
  }
  if (obj === null) {
    return "null";
  }
  const stringTag = obj[Symbol.toStringTag];
  if (typeof stringTag === "string") {
    return stringTag;
  }
  const type32 = Object.prototype.toString.call(obj).slice(8, -1);
  return type32;
}
__name(type, "type");
__name2(type, "type");
var canElideFrames = "captureStackTrace" in Error;
var _a;
var AssertionError = (_a = class extends Error {
  message;
  get name() {
    return "AssertionError";
  }
  get ok() {
    return false;
  }
  constructor(message = "Unspecified AssertionError", props, ssf) {
    super(message);
    this.message = message;
    if (canElideFrames) {
      Error.captureStackTrace(this, ssf || _a);
    }
    for (const key in props) {
      if (!(key in this)) {
        this[key] = props[key];
      }
    }
  }
  toJSON(stack) {
    return {
      ...this,
      name: this.name,
      message: this.message,
      ok: false,
      stack: stack !== false ? this.stack : void 0
    };
  }
}, __name(_a, "_AssertionError"), __name2(_a, "AssertionError"), _a);
function expectTypes(obj, types) {
  let flagMsg = flag(obj, "message");
  let ssfi = flag(obj, "ssfi");
  flagMsg = flagMsg ? flagMsg + ": " : "";
  obj = flag(obj, "object");
  types = types.map(function(t2) {
    return t2.toLowerCase();
  });
  types.sort();
  let str = types.map(function(t2, index) {
    let art = ~["a", "e", "i", "o", "u"].indexOf(t2.charAt(0)) ? "an" : "a";
    let or = types.length > 1 && index === types.length - 1 ? "or " : "";
    return or + art + " " + t2;
  }).join(", ");
  let objType = type(obj).toLowerCase();
  if (!types.some(function(expected) {
    return objType === expected;
  })) {
    throw new AssertionError(
      flagMsg + "object tested must be " + str + ", but " + objType + " given",
      void 0,
      ssfi
    );
  }
}
__name(expectTypes, "expectTypes");
__name2(expectTypes, "expectTypes");
function getActual(obj, args) {
  return args.length > 4 ? args[4] : obj._obj;
}
__name(getActual, "getActual");
__name2(getActual, "getActual");
var ansiColors = {
  bold: ["1", "22"],
  dim: ["2", "22"],
  italic: ["3", "23"],
  underline: ["4", "24"],
  // 5 & 6 are blinking
  inverse: ["7", "27"],
  hidden: ["8", "28"],
  strike: ["9", "29"],
  // 10-20 are fonts
  // 21-29 are resets for 1-9
  black: ["30", "39"],
  red: ["31", "39"],
  green: ["32", "39"],
  yellow: ["33", "39"],
  blue: ["34", "39"],
  magenta: ["35", "39"],
  cyan: ["36", "39"],
  white: ["37", "39"],
  brightblack: ["30;1", "39"],
  brightred: ["31;1", "39"],
  brightgreen: ["32;1", "39"],
  brightyellow: ["33;1", "39"],
  brightblue: ["34;1", "39"],
  brightmagenta: ["35;1", "39"],
  brightcyan: ["36;1", "39"],
  brightwhite: ["37;1", "39"],
  grey: ["90", "39"]
};
var styles = {
  special: "cyan",
  number: "yellow",
  bigint: "yellow",
  boolean: "yellow",
  undefined: "grey",
  null: "bold",
  string: "green",
  symbol: "green",
  date: "magenta",
  regexp: "red"
};
var truncator = "\u2026";
function colorise(value, styleType) {
  const color = ansiColors[styles[styleType]] || ansiColors[styleType] || "";
  if (!color) {
    return String(value);
  }
  return `\x1B[${color[0]}m${String(value)}\x1B[${color[1]}m`;
}
__name(colorise, "colorise");
__name2(colorise, "colorise");
function normaliseOptions({
  showHidden = false,
  depth = 2,
  colors = false,
  customInspect = true,
  showProxy = false,
  maxArrayLength = Infinity,
  breakLength = Infinity,
  seen = [],
  // eslint-disable-next-line no-shadow
  truncate: truncate2 = Infinity,
  stylize = String
} = {}, inspect32) {
  const options = {
    showHidden: Boolean(showHidden),
    depth: Number(depth),
    colors: Boolean(colors),
    customInspect: Boolean(customInspect),
    showProxy: Boolean(showProxy),
    maxArrayLength: Number(maxArrayLength),
    breakLength: Number(breakLength),
    truncate: Number(truncate2),
    seen,
    inspect: inspect32,
    stylize
  };
  if (options.colors) {
    options.stylize = colorise;
  }
  return options;
}
__name(normaliseOptions, "normaliseOptions");
__name2(normaliseOptions, "normaliseOptions");
function isHighSurrogate(char) {
  return char >= "\uD800" && char <= "\uDBFF";
}
__name(isHighSurrogate, "isHighSurrogate");
__name2(isHighSurrogate, "isHighSurrogate");
function truncate(string, length, tail = truncator) {
  string = String(string);
  const tailLength = tail.length;
  const stringLength = string.length;
  if (tailLength > length && stringLength > tailLength) {
    return tail;
  }
  if (stringLength > length && stringLength > tailLength) {
    let end = length - tailLength;
    if (end > 0 && isHighSurrogate(string[end - 1])) {
      end = end - 1;
    }
    return `${string.slice(0, end)}${tail}`;
  }
  return string;
}
__name(truncate, "truncate");
__name2(truncate, "truncate");
function inspectList(list, options, inspectItem, separator = ", ") {
  inspectItem = inspectItem || options.inspect;
  const size = list.length;
  if (size === 0)
    return "";
  const originalLength = options.truncate;
  let output = "";
  let peek = "";
  let truncated = "";
  for (let i2 = 0; i2 < size; i2 += 1) {
    const last = i2 + 1 === list.length;
    const secondToLast = i2 + 2 === list.length;
    truncated = `${truncator}(${list.length - i2})`;
    const value = list[i2];
    options.truncate = originalLength - output.length - (last ? 0 : separator.length);
    const string = peek || inspectItem(value, options) + (last ? "" : separator);
    const nextLength = output.length + string.length;
    const truncatedLength = nextLength + truncated.length;
    if (last && nextLength > originalLength && output.length + truncated.length <= originalLength) {
      break;
    }
    if (!last && !secondToLast && truncatedLength > originalLength) {
      break;
    }
    peek = last ? "" : inspectItem(list[i2 + 1], options) + (secondToLast ? "" : separator);
    if (!last && secondToLast && truncatedLength > originalLength && nextLength + peek.length > originalLength) {
      break;
    }
    output += string;
    if (!last && !secondToLast && nextLength + peek.length >= originalLength) {
      truncated = `${truncator}(${list.length - i2 - 1})`;
      break;
    }
    truncated = "";
  }
  return `${output}${truncated}`;
}
__name(inspectList, "inspectList");
__name2(inspectList, "inspectList");
function quoteComplexKey(key) {
  if (key.match(/^[a-zA-Z_][a-zA-Z_0-9]*$/)) {
    return key;
  }
  return JSON.stringify(key).replace(/'/g, "\\'").replace(/\\"/g, '"').replace(/(^"|"$)/g, "'");
}
__name(quoteComplexKey, "quoteComplexKey");
__name2(quoteComplexKey, "quoteComplexKey");
function inspectProperty([key, value], options) {
  options.truncate -= 2;
  if (typeof key === "string") {
    key = quoteComplexKey(key);
  } else if (typeof key !== "number") {
    key = `[${options.inspect(key, options)}]`;
  }
  options.truncate -= key.length;
  value = options.inspect(value, options);
  return `${key}: ${value}`;
}
__name(inspectProperty, "inspectProperty");
__name2(inspectProperty, "inspectProperty");
function inspectArray(array, options) {
  const nonIndexProperties = Object.keys(array).slice(array.length);
  if (!array.length && !nonIndexProperties.length)
    return "[]";
  options.truncate -= 4;
  const listContents = inspectList(array, options);
  options.truncate -= listContents.length;
  let propertyContents = "";
  if (nonIndexProperties.length) {
    propertyContents = inspectList(nonIndexProperties.map((key) => [key, array[key]]), options, inspectProperty);
  }
  return `[ ${listContents}${propertyContents ? `, ${propertyContents}` : ""} ]`;
}
__name(inspectArray, "inspectArray");
__name2(inspectArray, "inspectArray");
var getArrayName = __name2((array) => {
  if (typeof Buffer === "function" && array instanceof Buffer) {
    return "Buffer";
  }
  if (array[Symbol.toStringTag]) {
    return array[Symbol.toStringTag];
  }
  return array.constructor.name;
}, "getArrayName");
function inspectTypedArray(array, options) {
  const name = getArrayName(array);
  options.truncate -= name.length + 4;
  const nonIndexProperties = Object.keys(array).slice(array.length);
  if (!array.length && !nonIndexProperties.length)
    return `${name}[]`;
  let output = "";
  for (let i2 = 0; i2 < array.length; i2++) {
    const string = `${options.stylize(truncate(array[i2], options.truncate), "number")}${i2 === array.length - 1 ? "" : ", "}`;
    options.truncate -= string.length;
    if (array[i2] !== array.length && options.truncate <= 3) {
      output += `${truncator}(${array.length - array[i2] + 1})`;
      break;
    }
    output += string;
  }
  let propertyContents = "";
  if (nonIndexProperties.length) {
    propertyContents = inspectList(nonIndexProperties.map((key) => [key, array[key]]), options, inspectProperty);
  }
  return `${name}[ ${output}${propertyContents ? `, ${propertyContents}` : ""} ]`;
}
__name(inspectTypedArray, "inspectTypedArray");
__name2(inspectTypedArray, "inspectTypedArray");
function inspectDate(dateObject, options) {
  const stringRepresentation = dateObject.toJSON();
  if (stringRepresentation === null) {
    return "Invalid Date";
  }
  const split = stringRepresentation.split("T");
  const date = split[0];
  return options.stylize(`${date}T${truncate(split[1], options.truncate - date.length - 1)}`, "date");
}
__name(inspectDate, "inspectDate");
__name2(inspectDate, "inspectDate");
function inspectFunction(func, options) {
  const functionType = func[Symbol.toStringTag] || "Function";
  const name = func.name;
  if (!name) {
    return options.stylize(`[${functionType}]`, "special");
  }
  return options.stylize(`[${functionType} ${truncate(name, options.truncate - 11)}]`, "special");
}
__name(inspectFunction, "inspectFunction");
__name2(inspectFunction, "inspectFunction");
function inspectMapEntry([key, value], options) {
  options.truncate -= 4;
  key = options.inspect(key, options);
  options.truncate -= key.length;
  value = options.inspect(value, options);
  return `${key} => ${value}`;
}
__name(inspectMapEntry, "inspectMapEntry");
__name2(inspectMapEntry, "inspectMapEntry");
function mapToEntries(map) {
  const entries = [];
  map.forEach((value, key) => {
    entries.push([key, value]);
  });
  return entries;
}
__name(mapToEntries, "mapToEntries");
__name2(mapToEntries, "mapToEntries");
function inspectMap(map, options) {
  if (map.size === 0)
    return "Map{}";
  options.truncate -= 7;
  return `Map{ ${inspectList(mapToEntries(map), options, inspectMapEntry)} }`;
}
__name(inspectMap, "inspectMap");
__name2(inspectMap, "inspectMap");
var isNaN2 = Number.isNaN || ((i2) => i2 !== i2);
function inspectNumber(number, options) {
  if (isNaN2(number)) {
    return options.stylize("NaN", "number");
  }
  if (number === Infinity) {
    return options.stylize("Infinity", "number");
  }
  if (number === -Infinity) {
    return options.stylize("-Infinity", "number");
  }
  if (number === 0) {
    return options.stylize(1 / number === Infinity ? "+0" : "-0", "number");
  }
  return options.stylize(truncate(String(number), options.truncate), "number");
}
__name(inspectNumber, "inspectNumber");
__name2(inspectNumber, "inspectNumber");
function inspectBigInt(number, options) {
  let nums = truncate(number.toString(), options.truncate - 1);
  if (nums !== truncator)
    nums += "n";
  return options.stylize(nums, "bigint");
}
__name(inspectBigInt, "inspectBigInt");
__name2(inspectBigInt, "inspectBigInt");
function inspectRegExp(value, options) {
  const flags = value.toString().split("/")[2];
  const sourceLength = options.truncate - (2 + flags.length);
  const source = value.source;
  return options.stylize(`/${truncate(source, sourceLength)}/${flags}`, "regexp");
}
__name(inspectRegExp, "inspectRegExp");
__name2(inspectRegExp, "inspectRegExp");
function arrayFromSet(set2) {
  const values = [];
  set2.forEach((value) => {
    values.push(value);
  });
  return values;
}
__name(arrayFromSet, "arrayFromSet");
__name2(arrayFromSet, "arrayFromSet");
function inspectSet(set2, options) {
  if (set2.size === 0)
    return "Set{}";
  options.truncate -= 7;
  return `Set{ ${inspectList(arrayFromSet(set2), options)} }`;
}
__name(inspectSet, "inspectSet");
__name2(inspectSet, "inspectSet");
var stringEscapeChars = new RegExp("['\\u0000-\\u001f\\u007f-\\u009f\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff]", "g");
var escapeCharacters = {
  "\b": "\\b",
  "	": "\\t",
  "\n": "\\n",
  "\f": "\\f",
  "\r": "\\r",
  "'": "\\'",
  "\\": "\\\\"
};
var hex = 16;
var unicodeLength = 4;
function escape(char) {
  return escapeCharacters[char] || `\\u${`0000${char.charCodeAt(0).toString(hex)}`.slice(-unicodeLength)}`;
}
__name(escape, "escape");
__name2(escape, "escape");
function inspectString(string, options) {
  if (stringEscapeChars.test(string)) {
    string = string.replace(stringEscapeChars, escape);
  }
  return options.stylize(`'${truncate(string, options.truncate - 2)}'`, "string");
}
__name(inspectString, "inspectString");
__name2(inspectString, "inspectString");
function inspectSymbol(value) {
  if ("description" in Symbol.prototype) {
    return value.description ? `Symbol(${value.description})` : "Symbol()";
  }
  return value.toString();
}
__name(inspectSymbol, "inspectSymbol");
__name2(inspectSymbol, "inspectSymbol");
var getPromiseValue = __name2(() => "Promise{\u2026}", "getPromiseValue");
var promise_default = getPromiseValue;
function inspectObject(object, options) {
  const properties = Object.getOwnPropertyNames(object);
  const symbols = Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols(object) : [];
  if (properties.length === 0 && symbols.length === 0) {
    return "{}";
  }
  options.truncate -= 4;
  options.seen = options.seen || [];
  if (options.seen.includes(object)) {
    return "[Circular]";
  }
  options.seen.push(object);
  const propertyContents = inspectList(properties.map((key) => [key, object[key]]), options, inspectProperty);
  const symbolContents = inspectList(symbols.map((key) => [key, object[key]]), options, inspectProperty);
  options.seen.pop();
  let sep = "";
  if (propertyContents && symbolContents) {
    sep = ", ";
  }
  return `{ ${propertyContents}${sep}${symbolContents} }`;
}
__name(inspectObject, "inspectObject");
__name2(inspectObject, "inspectObject");
var toStringTag = typeof Symbol !== "undefined" && Symbol.toStringTag ? Symbol.toStringTag : false;
function inspectClass(value, options) {
  let name = "";
  if (toStringTag && toStringTag in value) {
    name = value[toStringTag];
  }
  name = name || value.constructor.name;
  if (!name || name === "_class") {
    name = "<Anonymous Class>";
  }
  options.truncate -= name.length;
  return `${name}${inspectObject(value, options)}`;
}
__name(inspectClass, "inspectClass");
__name2(inspectClass, "inspectClass");
function inspectArguments(args, options) {
  if (args.length === 0)
    return "Arguments[]";
  options.truncate -= 13;
  return `Arguments[ ${inspectList(args, options)} ]`;
}
__name(inspectArguments, "inspectArguments");
__name2(inspectArguments, "inspectArguments");
var errorKeys = [
  "stack",
  "line",
  "column",
  "name",
  "message",
  "fileName",
  "lineNumber",
  "columnNumber",
  "number",
  "description",
  "cause"
];
function inspectObject2(error, options) {
  const properties = Object.getOwnPropertyNames(error).filter((key) => errorKeys.indexOf(key) === -1);
  const name = error.name;
  options.truncate -= name.length;
  let message = "";
  if (typeof error.message === "string") {
    message = truncate(error.message, options.truncate);
  } else {
    properties.unshift("message");
  }
  message = message ? `: ${message}` : "";
  options.truncate -= message.length + 5;
  options.seen = options.seen || [];
  if (options.seen.includes(error)) {
    return "[Circular]";
  }
  options.seen.push(error);
  const propertyContents = inspectList(properties.map((key) => [key, error[key]]), options, inspectProperty);
  return `${name}${message}${propertyContents ? ` { ${propertyContents} }` : ""}`;
}
__name(inspectObject2, "inspectObject2");
__name2(inspectObject2, "inspectObject");
function inspectAttribute([key, value], options) {
  options.truncate -= 3;
  if (!value) {
    return `${options.stylize(String(key), "yellow")}`;
  }
  return `${options.stylize(String(key), "yellow")}=${options.stylize(`"${value}"`, "string")}`;
}
__name(inspectAttribute, "inspectAttribute");
__name2(inspectAttribute, "inspectAttribute");
function inspectNodeCollection(collection, options) {
  return inspectList(collection, options, inspectNode, "\n");
}
__name(inspectNodeCollection, "inspectNodeCollection");
__name2(inspectNodeCollection, "inspectNodeCollection");
function inspectNode(node, options) {
  switch (node.nodeType) {
    case 1:
      return inspectHTML(node, options);
    case 3:
      return options.inspect(node.data, options);
    default:
      return options.inspect(node, options);
  }
}
__name(inspectNode, "inspectNode");
__name2(inspectNode, "inspectNode");
function inspectHTML(element, options) {
  const properties = element.getAttributeNames();
  const name = element.tagName.toLowerCase();
  const head = options.stylize(`<${name}`, "special");
  const headClose = options.stylize(`>`, "special");
  const tail = options.stylize(`</${name}>`, "special");
  options.truncate -= name.length * 2 + 5;
  let propertyContents = "";
  if (properties.length > 0) {
    propertyContents += " ";
    propertyContents += inspectList(properties.map((key) => [key, element.getAttribute(key)]), options, inspectAttribute, " ");
  }
  options.truncate -= propertyContents.length;
  const truncate2 = options.truncate;
  let children = inspectNodeCollection(element.children, options);
  if (children && children.length > truncate2) {
    children = `${truncator}(${element.children.length})`;
  }
  return `${head}${propertyContents}${headClose}${children}${tail}`;
}
__name(inspectHTML, "inspectHTML");
__name2(inspectHTML, "inspectHTML");
var symbolsSupported = typeof Symbol === "function" && typeof Symbol.for === "function";
var chaiInspect = symbolsSupported ? Symbol.for("chai/inspect") : "@@chai/inspect";
var nodeInspect = Symbol.for("nodejs.util.inspect.custom");
var constructorMap = /* @__PURE__ */ new WeakMap();
var stringTagMap = {};
var baseTypesMap = {
  undefined: __name2((value, options) => options.stylize("undefined", "undefined"), "undefined"),
  null: __name2((value, options) => options.stylize("null", "null"), "null"),
  boolean: __name2((value, options) => options.stylize(String(value), "boolean"), "boolean"),
  Boolean: __name2((value, options) => options.stylize(String(value), "boolean"), "Boolean"),
  number: inspectNumber,
  Number: inspectNumber,
  bigint: inspectBigInt,
  BigInt: inspectBigInt,
  string: inspectString,
  String: inspectString,
  function: inspectFunction,
  Function: inspectFunction,
  symbol: inspectSymbol,
  // A Symbol polyfill will return `Symbol` not `symbol` from typedetect
  Symbol: inspectSymbol,
  Array: inspectArray,
  Date: inspectDate,
  Map: inspectMap,
  Set: inspectSet,
  RegExp: inspectRegExp,
  Promise: promise_default,
  // WeakSet, WeakMap are totally opaque to us
  WeakSet: __name2((value, options) => options.stylize("WeakSet{\u2026}", "special"), "WeakSet"),
  WeakMap: __name2((value, options) => options.stylize("WeakMap{\u2026}", "special"), "WeakMap"),
  Arguments: inspectArguments,
  Int8Array: inspectTypedArray,
  Uint8Array: inspectTypedArray,
  Uint8ClampedArray: inspectTypedArray,
  Int16Array: inspectTypedArray,
  Uint16Array: inspectTypedArray,
  Int32Array: inspectTypedArray,
  Uint32Array: inspectTypedArray,
  Float32Array: inspectTypedArray,
  Float64Array: inspectTypedArray,
  Generator: __name2(() => "", "Generator"),
  DataView: __name2(() => "", "DataView"),
  ArrayBuffer: __name2(() => "", "ArrayBuffer"),
  Error: inspectObject2,
  HTMLCollection: inspectNodeCollection,
  NodeList: inspectNodeCollection
};
var inspectCustom = __name2((value, options, type32) => {
  if (chaiInspect in value && typeof value[chaiInspect] === "function") {
    return value[chaiInspect](options);
  }
  if (nodeInspect in value && typeof value[nodeInspect] === "function") {
    return value[nodeInspect](options.depth, options);
  }
  if ("inspect" in value && typeof value.inspect === "function") {
    return value.inspect(options.depth, options);
  }
  if ("constructor" in value && constructorMap.has(value.constructor)) {
    return constructorMap.get(value.constructor)(value, options);
  }
  if (stringTagMap[type32]) {
    return stringTagMap[type32](value, options);
  }
  return "";
}, "inspectCustom");
var toString = Object.prototype.toString;
function inspect(value, opts = {}) {
  const options = normaliseOptions(opts, inspect);
  const { customInspect } = options;
  let type32 = value === null ? "null" : typeof value;
  if (type32 === "object") {
    type32 = toString.call(value).slice(8, -1);
  }
  if (type32 in baseTypesMap) {
    return baseTypesMap[type32](value, options);
  }
  if (customInspect && value) {
    const output = inspectCustom(value, options, type32);
    if (output) {
      if (typeof output === "string")
        return output;
      return inspect(output, options);
    }
  }
  const proto = value ? Object.getPrototypeOf(value) : false;
  if (proto === Object.prototype || proto === null) {
    return inspectObject(value, options);
  }
  if (value && typeof HTMLElement === "function" && value instanceof HTMLElement) {
    return inspectHTML(value, options);
  }
  if ("constructor" in value) {
    if (value.constructor !== Object) {
      return inspectClass(value, options);
    }
    return inspectObject(value, options);
  }
  if (value === Object(value)) {
    return inspectObject(value, options);
  }
  return options.stylize(String(value), type32);
}
__name(inspect, "inspect");
__name2(inspect, "inspect");
var config = {
  /**
   * ### config.includeStack
   *
   * User configurable property, influences whether stack trace
   * is included in Assertion error message. Default of false
   * suppresses stack trace in the error message.
   *
   *     chai.config.includeStack = true;  // enable stack on error
   *
   * @param {boolean}
   * @public
   */
  includeStack: false,
  /**
   * ### config.showDiff
   *
   * User configurable property, influences whether or not
   * the `showDiff` flag should be included in the thrown
   * AssertionErrors. `false` will always be `false`; `true`
   * will be true when the assertion has requested a diff
   * be shown.
   *
   * @param {boolean}
   * @public
   */
  showDiff: true,
  /**
   * ### config.truncateThreshold
   *
   * User configurable property, sets length threshold for actual and
   * expected values in assertion errors. If this threshold is exceeded, for
   * example for large data structures, the value is replaced with something
   * like `[ Array(3) ]` or `{ Object (prop1, prop2) }`.
   *
   * Set it to zero if you want to disable truncating altogether.
   *
   * This is especially userful when doing assertions on arrays: having this
   * set to a reasonable large value makes the failure messages readily
   * inspectable.
   *
   *     chai.config.truncateThreshold = 0;  // disable truncating
   *
   * @param {number}
   * @public
   */
  truncateThreshold: 40,
  /**
   * ### config.useProxy
   *
   * User configurable property, defines if chai will use a Proxy to throw
   * an error when a non-existent property is read, which protects users
   * from typos when using property-based assertions.
   *
   * Set it to false if you want to disable this feature.
   *
   *     chai.config.useProxy = false;  // disable use of Proxy
   *
   * This feature is automatically disabled regardless of this config value
   * in environments that don't support proxies.
   *
   * @param {boolean}
   * @public
   */
  useProxy: true,
  /**
   * ### config.proxyExcludedKeys
   *
   * User configurable property, defines which properties should be ignored
   * instead of throwing an error if they do not exist on the assertion.
   * This is only applied if the environment Chai is running in supports proxies and
   * if the `useProxy` configuration setting is enabled.
   * By default, `then` and `inspect` will not throw an error if they do not exist on the
   * assertion object because the `.inspect` property is read by `util.inspect` (for example, when
   * using `console.log` on the assertion object) and `.then` is necessary for promise type-checking.
   *
   *     // By default these keys will not throw an error if they do not exist on the assertion object
   *     chai.config.proxyExcludedKeys = ['then', 'inspect'];
   *
   * @param {Array}
   * @public
   */
  proxyExcludedKeys: ["then", "catch", "inspect", "toJSON"],
  /**
   * ### config.deepEqual
   *
   * User configurable property, defines which a custom function to use for deepEqual
   * comparisons.
   * By default, the function used is the one from the `deep-eql` package without custom comparator.
   *
   *     // use a custom comparator
   *     chai.config.deepEqual = (expected, actual) => {
   *         return chai.util.eql(expected, actual, {
   *             comparator: (expected, actual) => {
   *                 // for non number comparison, use the default behavior
   *                 if(typeof expected !== 'number') return null;
   *                 // allow a difference of 10 between compared numbers
   *                 return typeof actual === 'number' && Math.abs(actual - expected) < 10
   *             }
   *         })
   *     };
   *
   * @param {Function}
   * @public
   */
  deepEqual: null
};
function inspect2(obj, showHidden, depth, colors) {
  let options = {
    colors,
    depth: typeof depth === "undefined" ? 2 : depth,
    showHidden,
    truncate: config.truncateThreshold ? config.truncateThreshold : Infinity
  };
  return inspect(obj, options);
}
__name(inspect2, "inspect2");
__name2(inspect2, "inspect");
function objDisplay(obj) {
  let str = inspect2(obj), type32 = Object.prototype.toString.call(obj);
  if (config.truncateThreshold && str.length >= config.truncateThreshold) {
    if (type32 === "[object Function]") {
      return !obj.name || obj.name === "" ? "[Function]" : "[Function: " + obj.name + "]";
    } else if (type32 === "[object Array]") {
      return "[ Array(" + obj.length + ") ]";
    } else if (type32 === "[object Object]") {
      let keys2 = Object.keys(obj), kstr = keys2.length > 2 ? keys2.splice(0, 2).join(", ") + ", ..." : keys2.join(", ");
      return "{ Object (" + kstr + ") }";
    } else {
      return str;
    }
  } else {
    return str;
  }
}
__name(objDisplay, "objDisplay");
__name2(objDisplay, "objDisplay");
function getMessage2(obj, args) {
  let negate = flag(obj, "negate");
  let val = flag(obj, "object");
  let expected = args[3];
  let actual = getActual(obj, args);
  let msg = negate ? args[2] : args[1];
  let flagMsg = flag(obj, "message");
  if (typeof msg === "function") msg = msg();
  msg = msg || "";
  msg = msg.replace(/#\{this\}/g, function() {
    return objDisplay(val);
  }).replace(/#\{act\}/g, function() {
    return objDisplay(actual);
  }).replace(/#\{exp\}/g, function() {
    return objDisplay(expected);
  });
  return flagMsg ? flagMsg + ": " + msg : msg;
}
__name(getMessage2, "getMessage2");
__name2(getMessage2, "getMessage");
function transferFlags(assertion, object, includeAll) {
  let flags = assertion.__flags || (assertion.__flags = /* @__PURE__ */ Object.create(null));
  if (!object.__flags) {
    object.__flags = /* @__PURE__ */ Object.create(null);
  }
  includeAll = arguments.length === 3 ? includeAll : true;
  for (let flag3 in flags) {
    if (includeAll || flag3 !== "object" && flag3 !== "ssfi" && flag3 !== "lockSsfi" && flag3 != "message") {
      object.__flags[flag3] = flags[flag3];
    }
  }
}
__name(transferFlags, "transferFlags");
__name2(transferFlags, "transferFlags");
function type2(obj) {
  if (typeof obj === "undefined") {
    return "undefined";
  }
  if (obj === null) {
    return "null";
  }
  const stringTag = obj[Symbol.toStringTag];
  if (typeof stringTag === "string") {
    return stringTag;
  }
  const sliceStart = 8;
  const sliceEnd = -1;
  return Object.prototype.toString.call(obj).slice(sliceStart, sliceEnd);
}
__name(type2, "type2");
__name2(type2, "type");
function FakeMap() {
  this._key = "chai/deep-eql__" + Math.random() + Date.now();
}
__name(FakeMap, "FakeMap");
__name2(FakeMap, "FakeMap");
FakeMap.prototype = {
  get: __name2(/* @__PURE__ */ __name(function get(key) {
    return key[this._key];
  }, "get"), "get"),
  set: __name2(/* @__PURE__ */ __name(function set(key, value) {
    if (Object.isExtensible(key)) {
      Object.defineProperty(key, this._key, {
        value,
        configurable: true
      });
    }
  }, "set"), "set")
};
var MemoizeMap = typeof WeakMap === "function" ? WeakMap : FakeMap;
function memoizeCompare(leftHandOperand, rightHandOperand, memoizeMap) {
  if (!memoizeMap || isPrimitive(leftHandOperand) || isPrimitive(rightHandOperand)) {
    return null;
  }
  var leftHandMap = memoizeMap.get(leftHandOperand);
  if (leftHandMap) {
    var result = leftHandMap.get(rightHandOperand);
    if (typeof result === "boolean") {
      return result;
    }
  }
  return null;
}
__name(memoizeCompare, "memoizeCompare");
__name2(memoizeCompare, "memoizeCompare");
function memoizeSet(leftHandOperand, rightHandOperand, memoizeMap, result) {
  if (!memoizeMap || isPrimitive(leftHandOperand) || isPrimitive(rightHandOperand)) {
    return;
  }
  var leftHandMap = memoizeMap.get(leftHandOperand);
  if (leftHandMap) {
    leftHandMap.set(rightHandOperand, result);
  } else {
    leftHandMap = new MemoizeMap();
    leftHandMap.set(rightHandOperand, result);
    memoizeMap.set(leftHandOperand, leftHandMap);
  }
}
__name(memoizeSet, "memoizeSet");
__name2(memoizeSet, "memoizeSet");
var deep_eql_default = deepEqual;
function deepEqual(leftHandOperand, rightHandOperand, options) {
  if (options && options.comparator) {
    return extensiveDeepEqual(leftHandOperand, rightHandOperand, options);
  }
  var simpleResult = simpleEqual(leftHandOperand, rightHandOperand);
  if (simpleResult !== null) {
    return simpleResult;
  }
  return extensiveDeepEqual(leftHandOperand, rightHandOperand, options);
}
__name(deepEqual, "deepEqual");
__name2(deepEqual, "deepEqual");
function simpleEqual(leftHandOperand, rightHandOperand) {
  if (leftHandOperand === rightHandOperand) {
    return leftHandOperand !== 0 || 1 / leftHandOperand === 1 / rightHandOperand;
  }
  if (leftHandOperand !== leftHandOperand && // eslint-disable-line no-self-compare
  rightHandOperand !== rightHandOperand) {
    return true;
  }
  if (isPrimitive(leftHandOperand) || isPrimitive(rightHandOperand)) {
    return false;
  }
  return null;
}
__name(simpleEqual, "simpleEqual");
__name2(simpleEqual, "simpleEqual");
function extensiveDeepEqual(leftHandOperand, rightHandOperand, options) {
  options = options || {};
  options.memoize = options.memoize === false ? false : options.memoize || new MemoizeMap();
  var comparator = options && options.comparator;
  var memoizeResultLeft = memoizeCompare(leftHandOperand, rightHandOperand, options.memoize);
  if (memoizeResultLeft !== null) {
    return memoizeResultLeft;
  }
  var memoizeResultRight = memoizeCompare(rightHandOperand, leftHandOperand, options.memoize);
  if (memoizeResultRight !== null) {
    return memoizeResultRight;
  }
  if (comparator) {
    var comparatorResult = comparator(leftHandOperand, rightHandOperand);
    if (comparatorResult === false || comparatorResult === true) {
      memoizeSet(leftHandOperand, rightHandOperand, options.memoize, comparatorResult);
      return comparatorResult;
    }
    var simpleResult = simpleEqual(leftHandOperand, rightHandOperand);
    if (simpleResult !== null) {
      return simpleResult;
    }
  }
  var leftHandType = type2(leftHandOperand);
  if (leftHandType !== type2(rightHandOperand)) {
    memoizeSet(leftHandOperand, rightHandOperand, options.memoize, false);
    return false;
  }
  memoizeSet(leftHandOperand, rightHandOperand, options.memoize, true);
  var result = extensiveDeepEqualByType(leftHandOperand, rightHandOperand, leftHandType, options);
  memoizeSet(leftHandOperand, rightHandOperand, options.memoize, result);
  return result;
}
__name(extensiveDeepEqual, "extensiveDeepEqual");
__name2(extensiveDeepEqual, "extensiveDeepEqual");
function extensiveDeepEqualByType(leftHandOperand, rightHandOperand, leftHandType, options) {
  switch (leftHandType) {
    case "String":
    case "Number":
    case "Boolean":
    case "Date":
      return deepEqual(leftHandOperand.valueOf(), rightHandOperand.valueOf());
    case "Promise":
    case "Symbol":
    case "function":
    case "WeakMap":
    case "WeakSet":
      return leftHandOperand === rightHandOperand;
    case "Error":
      return keysEqual(leftHandOperand, rightHandOperand, ["name", "message", "code"], options);
    case "Arguments":
    case "Int8Array":
    case "Uint8Array":
    case "Uint8ClampedArray":
    case "Int16Array":
    case "Uint16Array":
    case "Int32Array":
    case "Uint32Array":
    case "Float32Array":
    case "Float64Array":
    case "Array":
      return iterableEqual(leftHandOperand, rightHandOperand, options);
    case "RegExp":
      return regexpEqual(leftHandOperand, rightHandOperand);
    case "Generator":
      return generatorEqual(leftHandOperand, rightHandOperand, options);
    case "DataView":
      return iterableEqual(new Uint8Array(leftHandOperand.buffer), new Uint8Array(rightHandOperand.buffer), options);
    case "ArrayBuffer":
      return iterableEqual(new Uint8Array(leftHandOperand), new Uint8Array(rightHandOperand), options);
    case "Set":
      return entriesEqual(leftHandOperand, rightHandOperand, options);
    case "Map":
      return entriesEqual(leftHandOperand, rightHandOperand, options);
    case "Temporal.PlainDate":
    case "Temporal.PlainTime":
    case "Temporal.PlainDateTime":
    case "Temporal.Instant":
    case "Temporal.ZonedDateTime":
    case "Temporal.PlainYearMonth":
    case "Temporal.PlainMonthDay":
      return leftHandOperand.equals(rightHandOperand);
    case "Temporal.Duration":
      return leftHandOperand.total("nanoseconds") === rightHandOperand.total("nanoseconds");
    case "Temporal.TimeZone":
    case "Temporal.Calendar":
      return leftHandOperand.toString() === rightHandOperand.toString();
    default:
      return objectEqual(leftHandOperand, rightHandOperand, options);
  }
}
__name(extensiveDeepEqualByType, "extensiveDeepEqualByType");
__name2(extensiveDeepEqualByType, "extensiveDeepEqualByType");
function regexpEqual(leftHandOperand, rightHandOperand) {
  return leftHandOperand.toString() === rightHandOperand.toString();
}
__name(regexpEqual, "regexpEqual");
__name2(regexpEqual, "regexpEqual");
function entriesEqual(leftHandOperand, rightHandOperand, options) {
  try {
    if (leftHandOperand.size !== rightHandOperand.size) {
      return false;
    }
    if (leftHandOperand.size === 0) {
      return true;
    }
  } catch (sizeError) {
    return false;
  }
  var leftHandItems = [];
  var rightHandItems = [];
  leftHandOperand.forEach(__name2(/* @__PURE__ */ __name(function gatherEntries(key, value) {
    leftHandItems.push([key, value]);
  }, "gatherEntries"), "gatherEntries"));
  rightHandOperand.forEach(__name2(/* @__PURE__ */ __name(function gatherEntries(key, value) {
    rightHandItems.push([key, value]);
  }, "gatherEntries"), "gatherEntries"));
  return iterableEqual(leftHandItems.sort(), rightHandItems.sort(), options);
}
__name(entriesEqual, "entriesEqual");
__name2(entriesEqual, "entriesEqual");
function iterableEqual(leftHandOperand, rightHandOperand, options) {
  var length = leftHandOperand.length;
  if (length !== rightHandOperand.length) {
    return false;
  }
  if (length === 0) {
    return true;
  }
  var index = -1;
  while (++index < length) {
    if (deepEqual(leftHandOperand[index], rightHandOperand[index], options) === false) {
      return false;
    }
  }
  return true;
}
__name(iterableEqual, "iterableEqual");
__name2(iterableEqual, "iterableEqual");
function generatorEqual(leftHandOperand, rightHandOperand, options) {
  return iterableEqual(getGeneratorEntries(leftHandOperand), getGeneratorEntries(rightHandOperand), options);
}
__name(generatorEqual, "generatorEqual");
__name2(generatorEqual, "generatorEqual");
function hasIteratorFunction(target) {
  return typeof Symbol !== "undefined" && typeof target === "object" && typeof Symbol.iterator !== "undefined" && typeof target[Symbol.iterator] === "function";
}
__name(hasIteratorFunction, "hasIteratorFunction");
__name2(hasIteratorFunction, "hasIteratorFunction");
function getIteratorEntries(target) {
  if (hasIteratorFunction(target)) {
    try {
      return getGeneratorEntries(target[Symbol.iterator]());
    } catch (iteratorError) {
      return [];
    }
  }
  return [];
}
__name(getIteratorEntries, "getIteratorEntries");
__name2(getIteratorEntries, "getIteratorEntries");
function getGeneratorEntries(generator) {
  var generatorResult = generator.next();
  var accumulator = [generatorResult.value];
  while (generatorResult.done === false) {
    generatorResult = generator.next();
    accumulator.push(generatorResult.value);
  }
  return accumulator;
}
__name(getGeneratorEntries, "getGeneratorEntries");
__name2(getGeneratorEntries, "getGeneratorEntries");
function getEnumerableKeys(target) {
  var keys2 = [];
  for (var key in target) {
    keys2.push(key);
  }
  return keys2;
}
__name(getEnumerableKeys, "getEnumerableKeys");
__name2(getEnumerableKeys, "getEnumerableKeys");
function getEnumerableSymbols(target) {
  var keys2 = [];
  var allKeys = Object.getOwnPropertySymbols(target);
  for (var i2 = 0; i2 < allKeys.length; i2 += 1) {
    var key = allKeys[i2];
    if (Object.getOwnPropertyDescriptor(target, key).enumerable) {
      keys2.push(key);
    }
  }
  return keys2;
}
__name(getEnumerableSymbols, "getEnumerableSymbols");
__name2(getEnumerableSymbols, "getEnumerableSymbols");
function keysEqual(leftHandOperand, rightHandOperand, keys2, options) {
  var length = keys2.length;
  if (length === 0) {
    return true;
  }
  for (var i2 = 0; i2 < length; i2 += 1) {
    if (deepEqual(leftHandOperand[keys2[i2]], rightHandOperand[keys2[i2]], options) === false) {
      return false;
    }
  }
  return true;
}
__name(keysEqual, "keysEqual");
__name2(keysEqual, "keysEqual");
function objectEqual(leftHandOperand, rightHandOperand, options) {
  var leftHandKeys = getEnumerableKeys(leftHandOperand);
  var rightHandKeys = getEnumerableKeys(rightHandOperand);
  var leftHandSymbols = getEnumerableSymbols(leftHandOperand);
  var rightHandSymbols = getEnumerableSymbols(rightHandOperand);
  leftHandKeys = leftHandKeys.concat(leftHandSymbols);
  rightHandKeys = rightHandKeys.concat(rightHandSymbols);
  if (leftHandKeys.length && leftHandKeys.length === rightHandKeys.length) {
    if (iterableEqual(mapSymbols(leftHandKeys).sort(), mapSymbols(rightHandKeys).sort()) === false) {
      return false;
    }
    return keysEqual(leftHandOperand, rightHandOperand, leftHandKeys, options);
  }
  var leftHandEntries = getIteratorEntries(leftHandOperand);
  var rightHandEntries = getIteratorEntries(rightHandOperand);
  if (leftHandEntries.length && leftHandEntries.length === rightHandEntries.length) {
    leftHandEntries.sort();
    rightHandEntries.sort();
    return iterableEqual(leftHandEntries, rightHandEntries, options);
  }
  if (leftHandKeys.length === 0 && leftHandEntries.length === 0 && rightHandKeys.length === 0 && rightHandEntries.length === 0) {
    return true;
  }
  return false;
}
__name(objectEqual, "objectEqual");
__name2(objectEqual, "objectEqual");
function isPrimitive(value) {
  return value === null || typeof value !== "object";
}
__name(isPrimitive, "isPrimitive");
__name2(isPrimitive, "isPrimitive");
function mapSymbols(arr) {
  return arr.map(__name2(/* @__PURE__ */ __name(function mapSymbol(entry) {
    if (typeof entry === "symbol") {
      return entry.toString();
    }
    return entry;
  }, "mapSymbol"), "mapSymbol"));
}
__name(mapSymbols, "mapSymbols");
__name2(mapSymbols, "mapSymbols");
function hasProperty(obj, name) {
  if (typeof obj === "undefined" || obj === null) {
    return false;
  }
  return name in Object(obj);
}
__name(hasProperty, "hasProperty");
__name2(hasProperty, "hasProperty");
function parsePath(path) {
  const str = path.replace(/([^\\])\[/g, "$1.[");
  const parts = str.match(/(\\\.|[^.]+?)+/g);
  return parts.map((value) => {
    if (value === "constructor" || value === "__proto__" || value === "prototype") {
      return {};
    }
    const regexp = /^\[(\d+)\]$/;
    const mArr = regexp.exec(value);
    let parsed = null;
    if (mArr) {
      parsed = { i: parseFloat(mArr[1]) };
    } else {
      parsed = { p: value.replace(/\\([.[\]])/g, "$1") };
    }
    return parsed;
  });
}
__name(parsePath, "parsePath");
__name2(parsePath, "parsePath");
function internalGetPathValue(obj, parsed, pathDepth) {
  let temporaryValue = obj;
  let res = null;
  pathDepth = typeof pathDepth === "undefined" ? parsed.length : pathDepth;
  for (let i2 = 0; i2 < pathDepth; i2++) {
    const part = parsed[i2];
    if (temporaryValue) {
      if (typeof part.p === "undefined") {
        temporaryValue = temporaryValue[part.i];
      } else {
        temporaryValue = temporaryValue[part.p];
      }
      if (i2 === pathDepth - 1) {
        res = temporaryValue;
      }
    }
  }
  return res;
}
__name(internalGetPathValue, "internalGetPathValue");
__name2(internalGetPathValue, "internalGetPathValue");
function getPathInfo(obj, path) {
  const parsed = parsePath(path);
  const last = parsed[parsed.length - 1];
  const info = {
    parent: parsed.length > 1 ? internalGetPathValue(obj, parsed, parsed.length - 1) : obj,
    name: last.p || last.i,
    value: internalGetPathValue(obj, parsed)
  };
  info.exists = hasProperty(info.parent, info.name);
  return info;
}
__name(getPathInfo, "getPathInfo");
__name2(getPathInfo, "getPathInfo");
var _a2;
var Assertion = (_a2 = class {
  /** @type {{}} */
  __flags = {};
  /**
   * Creates object for chaining.
   * `Assertion` objects contain metadata in the form of flags. Three flags can
   * be assigned during instantiation by passing arguments to this constructor:
   *
   * - `object`: This flag contains the target of the assertion. For example, in
   * the assertion `expect(numKittens).to.equal(7);`, the `object` flag will
   * contain `numKittens` so that the `equal` assertion can reference it when
   * needed.
   *
   * - `message`: This flag contains an optional custom error message to be
   * prepended to the error message that's generated by the assertion when it
   * fails.
   *
   * - `ssfi`: This flag stands for "start stack function indicator". It
   * contains a function reference that serves as the starting point for
   * removing frames from the stack trace of the error that's created by the
   * assertion when it fails. The goal is to provide a cleaner stack trace to
   * end users by removing Chai's internal functions. Note that it only works
   * in environments that support `Error.captureStackTrace`, and only when
   * `Chai.config.includeStack` hasn't been set to `false`.
   *
   * - `lockSsfi`: This flag controls whether or not the given `ssfi` flag
   * should retain its current value, even as assertions are chained off of
   * this object. This is usually set to `true` when creating a new assertion
   * from within another assertion. It's also temporarily set to `true` before
   * an overwritten assertion gets called by the overwriting assertion.
   *
   * - `eql`: This flag contains the deepEqual function to be used by the assertion.
   *
   * @param {unknown} obj target of the assertion
   * @param {string} [msg] (optional) custom error message
   * @param {Function} [ssfi] (optional) starting point for removing stack frames
   * @param {boolean} [lockSsfi] (optional) whether or not the ssfi flag is locked
   */
  constructor(obj, msg, ssfi, lockSsfi) {
    flag(this, "ssfi", ssfi || _a2);
    flag(this, "lockSsfi", lockSsfi);
    flag(this, "object", obj);
    flag(this, "message", msg);
    flag(this, "eql", config.deepEqual || deep_eql_default);
    return proxify(this);
  }
  /** @returns {boolean} */
  static get includeStack() {
    console.warn(
      "Assertion.includeStack is deprecated, use chai.config.includeStack instead."
    );
    return config.includeStack;
  }
  /** @param {boolean} value */
  static set includeStack(value) {
    console.warn(
      "Assertion.includeStack is deprecated, use chai.config.includeStack instead."
    );
    config.includeStack = value;
  }
  /** @returns {boolean} */
  static get showDiff() {
    console.warn(
      "Assertion.showDiff is deprecated, use chai.config.showDiff instead."
    );
    return config.showDiff;
  }
  /** @param {boolean} value */
  static set showDiff(value) {
    console.warn(
      "Assertion.showDiff is deprecated, use chai.config.showDiff instead."
    );
    config.showDiff = value;
  }
  /**
   * @param {string} name
   * @param {Function} fn
   */
  static addProperty(name, fn3) {
    addProperty(this.prototype, name, fn3);
  }
  /**
   * @param {string} name
   * @param {Function} fn
   */
  static addMethod(name, fn3) {
    addMethod(this.prototype, name, fn3);
  }
  /**
   * @param {string} name
   * @param {Function} fn
   * @param {Function} chainingBehavior
   */
  static addChainableMethod(name, fn3, chainingBehavior) {
    addChainableMethod(this.prototype, name, fn3, chainingBehavior);
  }
  /**
   * @param {string} name
   * @param {Function} fn
   */
  static overwriteProperty(name, fn3) {
    overwriteProperty(this.prototype, name, fn3);
  }
  /**
   * @param {string} name
   * @param {Function} fn
   */
  static overwriteMethod(name, fn3) {
    overwriteMethod(this.prototype, name, fn3);
  }
  /**
   * @param {string} name
   * @param {Function} fn
   * @param {Function} chainingBehavior
   */
  static overwriteChainableMethod(name, fn3, chainingBehavior) {
    overwriteChainableMethod(this.prototype, name, fn3, chainingBehavior);
  }
  /**
   * ### .assert(expression, message, negateMessage, expected, actual, showDiff)
   *
   * Executes an expression and check expectations. Throws AssertionError for reporting if test doesn't pass.
   *
   * @name assert
   * @param {unknown} _expr to be tested
   * @param {string | Function} msg or function that returns message to display if expression fails
   * @param {string | Function} _negateMsg or function that returns negatedMessage to display if negated expression fails
   * @param {unknown} expected value (remember to check for negation)
   * @param {unknown} _actual (optional) will default to `this.obj`
   * @param {boolean} showDiff (optional) when set to `true`, assert will display a diff in addition to the message if expression fails
   * @returns {void}
   */
  assert(_expr, msg, _negateMsg, expected, _actual, showDiff) {
    const ok = test(this, arguments);
    if (false !== showDiff) showDiff = true;
    if (void 0 === expected && void 0 === _actual) showDiff = false;
    if (true !== config.showDiff) showDiff = false;
    if (!ok) {
      msg = getMessage2(this, arguments);
      const actual = getActual(this, arguments);
      const assertionErrorObjectProperties = {
        actual,
        expected,
        showDiff
      };
      const operator = getOperator(this, arguments);
      if (operator) {
        assertionErrorObjectProperties.operator = operator;
      }
      throw new AssertionError(
        msg,
        assertionErrorObjectProperties,
        // @ts-expect-error Not sure what to do about these types yet
        config.includeStack ? this.assert : flag(this, "ssfi")
      );
    }
  }
  /**
   * Quick reference to stored `actual` value for plugin developers.
   *
   * @returns {unknown}
   */
  get _obj() {
    return flag(this, "object");
  }
  /**
   * Quick reference to stored `actual` value for plugin developers.
   *
   * @param {unknown} val
   */
  set _obj(val) {
    flag(this, "object", val);
  }
}, __name(_a2, "_Assertion"), __name2(_a2, "Assertion"), _a2);
function isProxyEnabled() {
  return config.useProxy && typeof Proxy !== "undefined" && typeof Reflect !== "undefined";
}
__name(isProxyEnabled, "isProxyEnabled");
__name2(isProxyEnabled, "isProxyEnabled");
function addProperty(ctx, name, getter) {
  getter = getter === void 0 ? function() {
  } : getter;
  Object.defineProperty(ctx, name, {
    get: __name2(/* @__PURE__ */ __name(function propertyGetter() {
      if (!isProxyEnabled() && !flag(this, "lockSsfi")) {
        flag(this, "ssfi", propertyGetter);
      }
      let result = getter.call(this);
      if (result !== void 0) return result;
      let newAssertion = new Assertion();
      transferFlags(this, newAssertion);
      return newAssertion;
    }, "propertyGetter"), "propertyGetter"),
    configurable: true
  });
}
__name(addProperty, "addProperty");
__name2(addProperty, "addProperty");
var fnLengthDesc = Object.getOwnPropertyDescriptor(function() {
}, "length");
function addLengthGuard(fn3, assertionName, isChainable) {
  if (!fnLengthDesc.configurable) return fn3;
  Object.defineProperty(fn3, "length", {
    get: __name2(function() {
      if (isChainable) {
        throw Error(
          "Invalid Chai property: " + assertionName + '.length. Due to a compatibility issue, "length" cannot directly follow "' + assertionName + '". Use "' + assertionName + '.lengthOf" instead.'
        );
      }
      throw Error(
        "Invalid Chai property: " + assertionName + '.length. See docs for proper usage of "' + assertionName + '".'
      );
    }, "get")
  });
  return fn3;
}
__name(addLengthGuard, "addLengthGuard");
__name2(addLengthGuard, "addLengthGuard");
function getProperties(object) {
  let result = Object.getOwnPropertyNames(object);
  function addProperty2(property) {
    if (result.indexOf(property) === -1) {
      result.push(property);
    }
  }
  __name(addProperty2, "addProperty2");
  __name2(addProperty2, "addProperty");
  let proto = Object.getPrototypeOf(object);
  while (proto !== null) {
    Object.getOwnPropertyNames(proto).forEach(addProperty2);
    proto = Object.getPrototypeOf(proto);
  }
  return result;
}
__name(getProperties, "getProperties");
__name2(getProperties, "getProperties");
var builtins = ["__flags", "__methods", "_obj", "assert"];
function proxify(obj, nonChainableMethodName) {
  if (!isProxyEnabled()) return obj;
  return new Proxy(obj, {
    get: __name2(/* @__PURE__ */ __name(function proxyGetter(target, property) {
      if (typeof property === "string" && config.proxyExcludedKeys.indexOf(property) === -1 && !Reflect.has(target, property)) {
        if (nonChainableMethodName) {
          throw Error(
            "Invalid Chai property: " + nonChainableMethodName + "." + property + '. See docs for proper usage of "' + nonChainableMethodName + '".'
          );
        }
        let suggestion = null;
        let suggestionDistance = 4;
        getProperties(target).forEach(function(prop) {
          if (
            // we actually mean to check `Object.prototype` here
            // eslint-disable-next-line no-prototype-builtins
            !Object.prototype.hasOwnProperty(prop) && builtins.indexOf(prop) === -1
          ) {
            let dist = stringDistanceCapped(property, prop, suggestionDistance);
            if (dist < suggestionDistance) {
              suggestion = prop;
              suggestionDistance = dist;
            }
          }
        });
        if (suggestion !== null) {
          throw Error(
            "Invalid Chai property: " + property + '. Did you mean "' + suggestion + '"?'
          );
        } else {
          throw Error("Invalid Chai property: " + property);
        }
      }
      if (builtins.indexOf(property) === -1 && !flag(target, "lockSsfi")) {
        flag(target, "ssfi", proxyGetter);
      }
      return Reflect.get(target, property);
    }, "proxyGetter"), "proxyGetter")
  });
}
__name(proxify, "proxify");
__name2(proxify, "proxify");
function stringDistanceCapped(strA, strB, cap) {
  if (Math.abs(strA.length - strB.length) >= cap) {
    return cap;
  }
  let memo = [];
  for (let i2 = 0; i2 <= strA.length; i2++) {
    memo[i2] = Array(strB.length + 1).fill(0);
    memo[i2][0] = i2;
  }
  for (let j2 = 0; j2 < strB.length; j2++) {
    memo[0][j2] = j2;
  }
  for (let i2 = 1; i2 <= strA.length; i2++) {
    let ch = strA.charCodeAt(i2 - 1);
    for (let j2 = 1; j2 <= strB.length; j2++) {
      if (Math.abs(i2 - j2) >= cap) {
        memo[i2][j2] = cap;
        continue;
      }
      memo[i2][j2] = Math.min(
        memo[i2 - 1][j2] + 1,
        memo[i2][j2 - 1] + 1,
        memo[i2 - 1][j2 - 1] + (ch === strB.charCodeAt(j2 - 1) ? 0 : 1)
      );
    }
  }
  return memo[strA.length][strB.length];
}
__name(stringDistanceCapped, "stringDistanceCapped");
__name2(stringDistanceCapped, "stringDistanceCapped");
function addMethod(ctx, name, method) {
  let methodWrapper = __name2(function() {
    if (!flag(this, "lockSsfi")) {
      flag(this, "ssfi", methodWrapper);
    }
    let result = method.apply(this, arguments);
    if (result !== void 0) return result;
    let newAssertion = new Assertion();
    transferFlags(this, newAssertion);
    return newAssertion;
  }, "methodWrapper");
  addLengthGuard(methodWrapper, name, false);
  ctx[name] = proxify(methodWrapper, name);
}
__name(addMethod, "addMethod");
__name2(addMethod, "addMethod");
function overwriteProperty(ctx, name, getter) {
  let _get = Object.getOwnPropertyDescriptor(ctx, name), _super = __name2(function() {
  }, "_super");
  if (_get && "function" === typeof _get.get) _super = _get.get;
  Object.defineProperty(ctx, name, {
    get: __name2(/* @__PURE__ */ __name(function overwritingPropertyGetter() {
      if (!isProxyEnabled() && !flag(this, "lockSsfi")) {
        flag(this, "ssfi", overwritingPropertyGetter);
      }
      let origLockSsfi = flag(this, "lockSsfi");
      flag(this, "lockSsfi", true);
      let result = getter(_super).call(this);
      flag(this, "lockSsfi", origLockSsfi);
      if (result !== void 0) {
        return result;
      }
      let newAssertion = new Assertion();
      transferFlags(this, newAssertion);
      return newAssertion;
    }, "overwritingPropertyGetter"), "overwritingPropertyGetter"),
    configurable: true
  });
}
__name(overwriteProperty, "overwriteProperty");
__name2(overwriteProperty, "overwriteProperty");
function overwriteMethod(ctx, name, method) {
  let _method = ctx[name], _super = __name2(function() {
    throw new Error(name + " is not a function");
  }, "_super");
  if (_method && "function" === typeof _method) _super = _method;
  let overwritingMethodWrapper = __name2(function() {
    if (!flag(this, "lockSsfi")) {
      flag(this, "ssfi", overwritingMethodWrapper);
    }
    let origLockSsfi = flag(this, "lockSsfi");
    flag(this, "lockSsfi", true);
    let result = method(_super).apply(this, arguments);
    flag(this, "lockSsfi", origLockSsfi);
    if (result !== void 0) {
      return result;
    }
    let newAssertion = new Assertion();
    transferFlags(this, newAssertion);
    return newAssertion;
  }, "overwritingMethodWrapper");
  addLengthGuard(overwritingMethodWrapper, name, false);
  ctx[name] = proxify(overwritingMethodWrapper, name);
}
__name(overwriteMethod, "overwriteMethod");
__name2(overwriteMethod, "overwriteMethod");
var canSetPrototype = typeof Object.setPrototypeOf === "function";
var testFn = __name2(function() {
}, "testFn");
var excludeNames = Object.getOwnPropertyNames(testFn).filter(function(name) {
  let propDesc = Object.getOwnPropertyDescriptor(testFn, name);
  if (typeof propDesc !== "object") return true;
  return !propDesc.configurable;
});
var call = Function.prototype.call;
var apply = Function.prototype.apply;
function addChainableMethod(ctx, name, method, chainingBehavior) {
  if (typeof chainingBehavior !== "function") {
    chainingBehavior = __name2(function() {
    }, "chainingBehavior");
  }
  let chainableBehavior = {
    method,
    chainingBehavior
  };
  if (!ctx.__methods) {
    ctx.__methods = {};
  }
  ctx.__methods[name] = chainableBehavior;
  Object.defineProperty(ctx, name, {
    get: __name2(/* @__PURE__ */ __name(function chainableMethodGetter() {
      chainableBehavior.chainingBehavior.call(this);
      let chainableMethodWrapper = __name2(function() {
        if (!flag(this, "lockSsfi")) {
          flag(this, "ssfi", chainableMethodWrapper);
        }
        let result = chainableBehavior.method.apply(this, arguments);
        if (result !== void 0) {
          return result;
        }
        let newAssertion = new Assertion();
        transferFlags(this, newAssertion);
        return newAssertion;
      }, "chainableMethodWrapper");
      addLengthGuard(chainableMethodWrapper, name, true);
      if (canSetPrototype) {
        let prototype = Object.create(this);
        prototype.call = call;
        prototype.apply = apply;
        Object.setPrototypeOf(chainableMethodWrapper, prototype);
      } else {
        let asserterNames = Object.getOwnPropertyNames(ctx);
        asserterNames.forEach(function(asserterName) {
          if (excludeNames.indexOf(asserterName) !== -1) {
            return;
          }
          let pd = Object.getOwnPropertyDescriptor(ctx, asserterName);
          Object.defineProperty(chainableMethodWrapper, asserterName, pd);
        });
      }
      transferFlags(this, chainableMethodWrapper);
      return proxify(chainableMethodWrapper);
    }, "chainableMethodGetter"), "chainableMethodGetter"),
    configurable: true
  });
}
__name(addChainableMethod, "addChainableMethod");
__name2(addChainableMethod, "addChainableMethod");
function overwriteChainableMethod(ctx, name, method, chainingBehavior) {
  let chainableBehavior = ctx.__methods[name];
  let _chainingBehavior = chainableBehavior.chainingBehavior;
  chainableBehavior.chainingBehavior = __name2(/* @__PURE__ */ __name(function overwritingChainableMethodGetter() {
    let result = chainingBehavior(_chainingBehavior).call(this);
    if (result !== void 0) {
      return result;
    }
    let newAssertion = new Assertion();
    transferFlags(this, newAssertion);
    return newAssertion;
  }, "overwritingChainableMethodGetter"), "overwritingChainableMethodGetter");
  let _method = chainableBehavior.method;
  chainableBehavior.method = __name2(/* @__PURE__ */ __name(function overwritingChainableMethodWrapper() {
    let result = method(_method).apply(this, arguments);
    if (result !== void 0) {
      return result;
    }
    let newAssertion = new Assertion();
    transferFlags(this, newAssertion);
    return newAssertion;
  }, "overwritingChainableMethodWrapper"), "overwritingChainableMethodWrapper");
}
__name(overwriteChainableMethod, "overwriteChainableMethod");
__name2(overwriteChainableMethod, "overwriteChainableMethod");
function compareByInspect(a, b2) {
  return inspect2(a) < inspect2(b2) ? -1 : 1;
}
__name(compareByInspect, "compareByInspect");
__name2(compareByInspect, "compareByInspect");
function getOwnEnumerablePropertySymbols(obj) {
  if (typeof Object.getOwnPropertySymbols !== "function") return [];
  return Object.getOwnPropertySymbols(obj).filter(function(sym) {
    return Object.getOwnPropertyDescriptor(obj, sym).enumerable;
  });
}
__name(getOwnEnumerablePropertySymbols, "getOwnEnumerablePropertySymbols");
__name2(getOwnEnumerablePropertySymbols, "getOwnEnumerablePropertySymbols");
function getOwnEnumerableProperties(obj) {
  return Object.keys(obj).concat(getOwnEnumerablePropertySymbols(obj));
}
__name(getOwnEnumerableProperties, "getOwnEnumerableProperties");
__name2(getOwnEnumerableProperties, "getOwnEnumerableProperties");
var isNaN22 = Number.isNaN;
function isObjectType(obj) {
  let objectType = type(obj);
  let objectTypes = ["Array", "Object", "Function"];
  return objectTypes.indexOf(objectType) !== -1;
}
__name(isObjectType, "isObjectType");
__name2(isObjectType, "isObjectType");
function getOperator(obj, args) {
  let operator = flag(obj, "operator");
  let negate = flag(obj, "negate");
  let expected = args[3];
  let msg = negate ? args[2] : args[1];
  if (operator) {
    return operator;
  }
  if (typeof msg === "function") msg = msg();
  msg = msg || "";
  if (!msg) {
    return void 0;
  }
  if (/\shave\s/.test(msg)) {
    return void 0;
  }
  let isObject2 = isObjectType(expected);
  if (/\snot\s/.test(msg)) {
    return isObject2 ? "notDeepStrictEqual" : "notStrictEqual";
  }
  return isObject2 ? "deepStrictEqual" : "strictEqual";
}
__name(getOperator, "getOperator");
__name2(getOperator, "getOperator");
function getName(fn3) {
  return fn3.name;
}
__name(getName, "getName");
__name2(getName, "getName");
function isRegExp2(obj) {
  return Object.prototype.toString.call(obj) === "[object RegExp]";
}
__name(isRegExp2, "isRegExp2");
__name2(isRegExp2, "isRegExp");
function isNumeric(obj) {
  return ["Number", "BigInt"].includes(type(obj));
}
__name(isNumeric, "isNumeric");
__name2(isNumeric, "isNumeric");
var { flag: flag2 } = utils_exports;
[
  "to",
  "be",
  "been",
  "is",
  "and",
  "has",
  "have",
  "with",
  "that",
  "which",
  "at",
  "of",
  "same",
  "but",
  "does",
  "still",
  "also"
].forEach(function(chain) {
  Assertion.addProperty(chain);
});
Assertion.addProperty("not", function() {
  flag2(this, "negate", true);
});
Assertion.addProperty("deep", function() {
  flag2(this, "deep", true);
});
Assertion.addProperty("nested", function() {
  flag2(this, "nested", true);
});
Assertion.addProperty("own", function() {
  flag2(this, "own", true);
});
Assertion.addProperty("ordered", function() {
  flag2(this, "ordered", true);
});
Assertion.addProperty("any", function() {
  flag2(this, "any", true);
  flag2(this, "all", false);
});
Assertion.addProperty("all", function() {
  flag2(this, "all", true);
  flag2(this, "any", false);
});
var functionTypes = {
  function: [
    "function",
    "asyncfunction",
    "generatorfunction",
    "asyncgeneratorfunction"
  ],
  asyncfunction: ["asyncfunction", "asyncgeneratorfunction"],
  generatorfunction: ["generatorfunction", "asyncgeneratorfunction"],
  asyncgeneratorfunction: ["asyncgeneratorfunction"]
};
function an(type32, msg) {
  if (msg) flag2(this, "message", msg);
  type32 = type32.toLowerCase();
  let obj = flag2(this, "object"), article = ~["a", "e", "i", "o", "u"].indexOf(type32.charAt(0)) ? "an " : "a ";
  const detectedType = type(obj).toLowerCase();
  if (functionTypes["function"].includes(type32)) {
    this.assert(
      functionTypes[type32].includes(detectedType),
      "expected #{this} to be " + article + type32,
      "expected #{this} not to be " + article + type32
    );
  } else {
    this.assert(
      type32 === detectedType,
      "expected #{this} to be " + article + type32,
      "expected #{this} not to be " + article + type32
    );
  }
}
__name(an, "an");
__name2(an, "an");
Assertion.addChainableMethod("an", an);
Assertion.addChainableMethod("a", an);
function SameValueZero(a, b2) {
  return isNaN22(a) && isNaN22(b2) || a === b2;
}
__name(SameValueZero, "SameValueZero");
__name2(SameValueZero, "SameValueZero");
function includeChainingBehavior() {
  flag2(this, "contains", true);
}
__name(includeChainingBehavior, "includeChainingBehavior");
__name2(includeChainingBehavior, "includeChainingBehavior");
function include(val, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), objType = type(obj).toLowerCase(), flagMsg = flag2(this, "message"), negate = flag2(this, "negate"), ssfi = flag2(this, "ssfi"), isDeep = flag2(this, "deep"), descriptor = isDeep ? "deep " : "", isEql = isDeep ? flag2(this, "eql") : SameValueZero;
  flagMsg = flagMsg ? flagMsg + ": " : "";
  let included = false;
  switch (objType) {
    case "string":
      included = obj.indexOf(val) !== -1;
      break;
    case "weakset":
      if (isDeep) {
        throw new AssertionError(
          flagMsg + "unable to use .deep.include with WeakSet",
          void 0,
          ssfi
        );
      }
      included = obj.has(val);
      break;
    case "map":
      obj.forEach(function(item) {
        included = included || isEql(item, val);
      });
      break;
    case "set":
      if (isDeep) {
        obj.forEach(function(item) {
          included = included || isEql(item, val);
        });
      } else {
        included = obj.has(val);
      }
      break;
    case "array":
      if (isDeep) {
        included = obj.some(function(item) {
          return isEql(item, val);
        });
      } else {
        included = obj.indexOf(val) !== -1;
      }
      break;
    default: {
      if (val !== Object(val)) {
        throw new AssertionError(
          flagMsg + "the given combination of arguments (" + objType + " and " + type(val).toLowerCase() + ") is invalid for this assertion. You can use an array, a map, an object, a set, a string, or a weakset instead of a " + type(val).toLowerCase(),
          void 0,
          ssfi
        );
      }
      let props = Object.keys(val);
      let firstErr = null;
      let numErrs = 0;
      props.forEach(function(prop) {
        let propAssertion = new Assertion(obj);
        transferFlags(this, propAssertion, true);
        flag2(propAssertion, "lockSsfi", true);
        if (!negate || props.length === 1) {
          propAssertion.property(prop, val[prop]);
          return;
        }
        try {
          propAssertion.property(prop, val[prop]);
        } catch (err) {
          if (!check_error_exports.compatibleConstructor(err, AssertionError)) {
            throw err;
          }
          if (firstErr === null) firstErr = err;
          numErrs++;
        }
      }, this);
      if (negate && props.length > 1 && numErrs === props.length) {
        throw firstErr;
      }
      return;
    }
  }
  this.assert(
    included,
    "expected #{this} to " + descriptor + "include " + inspect2(val),
    "expected #{this} to not " + descriptor + "include " + inspect2(val)
  );
}
__name(include, "include");
__name2(include, "include");
Assertion.addChainableMethod("include", include, includeChainingBehavior);
Assertion.addChainableMethod("contain", include, includeChainingBehavior);
Assertion.addChainableMethod("contains", include, includeChainingBehavior);
Assertion.addChainableMethod("includes", include, includeChainingBehavior);
Assertion.addProperty("ok", function() {
  this.assert(
    flag2(this, "object"),
    "expected #{this} to be truthy",
    "expected #{this} to be falsy"
  );
});
Assertion.addProperty("true", function() {
  this.assert(
    true === flag2(this, "object"),
    "expected #{this} to be true",
    "expected #{this} to be false",
    flag2(this, "negate") ? false : true
  );
});
Assertion.addProperty("numeric", function() {
  const object = flag2(this, "object");
  this.assert(
    ["Number", "BigInt"].includes(type(object)),
    "expected #{this} to be numeric",
    "expected #{this} to not be numeric",
    flag2(this, "negate") ? false : true
  );
});
Assertion.addProperty("callable", function() {
  const val = flag2(this, "object");
  const ssfi = flag2(this, "ssfi");
  const message = flag2(this, "message");
  const msg = message ? `${message}: ` : "";
  const negate = flag2(this, "negate");
  const assertionMessage = negate ? `${msg}expected ${inspect2(val)} not to be a callable function` : `${msg}expected ${inspect2(val)} to be a callable function`;
  const isCallable3 = [
    "Function",
    "AsyncFunction",
    "GeneratorFunction",
    "AsyncGeneratorFunction"
  ].includes(type(val));
  if (isCallable3 && negate || !isCallable3 && !negate) {
    throw new AssertionError(assertionMessage, void 0, ssfi);
  }
});
Assertion.addProperty("false", function() {
  this.assert(
    false === flag2(this, "object"),
    "expected #{this} to be false",
    "expected #{this} to be true",
    flag2(this, "negate") ? true : false
  );
});
Assertion.addProperty("null", function() {
  this.assert(
    null === flag2(this, "object"),
    "expected #{this} to be null",
    "expected #{this} not to be null"
  );
});
Assertion.addProperty("undefined", function() {
  this.assert(
    void 0 === flag2(this, "object"),
    "expected #{this} to be undefined",
    "expected #{this} not to be undefined"
  );
});
Assertion.addProperty("NaN", function() {
  this.assert(
    isNaN22(flag2(this, "object")),
    "expected #{this} to be NaN",
    "expected #{this} not to be NaN"
  );
});
function assertExist() {
  let val = flag2(this, "object");
  this.assert(
    val !== null && val !== void 0,
    "expected #{this} to exist",
    "expected #{this} to not exist"
  );
}
__name(assertExist, "assertExist");
__name2(assertExist, "assertExist");
Assertion.addProperty("exist", assertExist);
Assertion.addProperty("exists", assertExist);
Assertion.addProperty("empty", function() {
  let val = flag2(this, "object"), ssfi = flag2(this, "ssfi"), flagMsg = flag2(this, "message"), itemsCount;
  flagMsg = flagMsg ? flagMsg + ": " : "";
  switch (type(val).toLowerCase()) {
    case "array":
    case "string":
      itemsCount = val.length;
      break;
    case "map":
    case "set":
      itemsCount = val.size;
      break;
    case "weakmap":
    case "weakset":
      throw new AssertionError(
        flagMsg + ".empty was passed a weak collection",
        void 0,
        ssfi
      );
    case "function": {
      const msg = flagMsg + ".empty was passed a function " + getName(val);
      throw new AssertionError(msg.trim(), void 0, ssfi);
    }
    default:
      if (val !== Object(val)) {
        throw new AssertionError(
          flagMsg + ".empty was passed non-string primitive " + inspect2(val),
          void 0,
          ssfi
        );
      }
      itemsCount = Object.keys(val).length;
  }
  this.assert(
    0 === itemsCount,
    "expected #{this} to be empty",
    "expected #{this} not to be empty"
  );
});
function checkArguments() {
  let obj = flag2(this, "object"), type32 = type(obj);
  this.assert(
    "Arguments" === type32,
    "expected #{this} to be arguments but got " + type32,
    "expected #{this} to not be arguments"
  );
}
__name(checkArguments, "checkArguments");
__name2(checkArguments, "checkArguments");
Assertion.addProperty("arguments", checkArguments);
Assertion.addProperty("Arguments", checkArguments);
function assertEqual(val, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object");
  if (flag2(this, "deep")) {
    let prevLockSsfi = flag2(this, "lockSsfi");
    flag2(this, "lockSsfi", true);
    this.eql(val);
    flag2(this, "lockSsfi", prevLockSsfi);
  } else {
    this.assert(
      val === obj,
      "expected #{this} to equal #{exp}",
      "expected #{this} to not equal #{exp}",
      val,
      this._obj,
      true
    );
  }
}
__name(assertEqual, "assertEqual");
__name2(assertEqual, "assertEqual");
Assertion.addMethod("equal", assertEqual);
Assertion.addMethod("equals", assertEqual);
Assertion.addMethod("eq", assertEqual);
function assertEql(obj, msg) {
  if (msg) flag2(this, "message", msg);
  let eql = flag2(this, "eql");
  this.assert(
    eql(obj, flag2(this, "object")),
    "expected #{this} to deeply equal #{exp}",
    "expected #{this} to not deeply equal #{exp}",
    obj,
    this._obj,
    true
  );
}
__name(assertEql, "assertEql");
__name2(assertEql, "assertEql");
Assertion.addMethod("eql", assertEql);
Assertion.addMethod("eqls", assertEql);
function assertAbove(n2, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), doLength = flag2(this, "doLength"), flagMsg = flag2(this, "message"), msgPrefix = flagMsg ? flagMsg + ": " : "", ssfi = flag2(this, "ssfi"), objType = type(obj).toLowerCase(), nType = type(n2).toLowerCase();
  if (doLength && objType !== "map" && objType !== "set") {
    new Assertion(obj, flagMsg, ssfi, true).to.have.property("length");
  }
  if (!doLength && objType === "date" && nType !== "date") {
    throw new AssertionError(
      msgPrefix + "the argument to above must be a date",
      void 0,
      ssfi
    );
  } else if (!isNumeric(n2) && (doLength || isNumeric(obj))) {
    throw new AssertionError(
      msgPrefix + "the argument to above must be a number",
      void 0,
      ssfi
    );
  } else if (!doLength && objType !== "date" && !isNumeric(obj)) {
    let printObj = objType === "string" ? "'" + obj + "'" : obj;
    throw new AssertionError(
      msgPrefix + "expected " + printObj + " to be a number or a date",
      void 0,
      ssfi
    );
  }
  if (doLength) {
    let descriptor = "length", itemsCount;
    if (objType === "map" || objType === "set") {
      descriptor = "size";
      itemsCount = obj.size;
    } else {
      itemsCount = obj.length;
    }
    this.assert(
      itemsCount > n2,
      "expected #{this} to have a " + descriptor + " above #{exp} but got #{act}",
      "expected #{this} to not have a " + descriptor + " above #{exp}",
      n2,
      itemsCount
    );
  } else {
    this.assert(
      obj > n2,
      "expected #{this} to be above #{exp}",
      "expected #{this} to be at most #{exp}",
      n2
    );
  }
}
__name(assertAbove, "assertAbove");
__name2(assertAbove, "assertAbove");
Assertion.addMethod("above", assertAbove);
Assertion.addMethod("gt", assertAbove);
Assertion.addMethod("greaterThan", assertAbove);
function assertLeast(n2, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), doLength = flag2(this, "doLength"), flagMsg = flag2(this, "message"), msgPrefix = flagMsg ? flagMsg + ": " : "", ssfi = flag2(this, "ssfi"), objType = type(obj).toLowerCase(), nType = type(n2).toLowerCase(), errorMessage, shouldThrow = true;
  if (doLength && objType !== "map" && objType !== "set") {
    new Assertion(obj, flagMsg, ssfi, true).to.have.property("length");
  }
  if (!doLength && objType === "date" && nType !== "date") {
    errorMessage = msgPrefix + "the argument to least must be a date";
  } else if (!isNumeric(n2) && (doLength || isNumeric(obj))) {
    errorMessage = msgPrefix + "the argument to least must be a number";
  } else if (!doLength && objType !== "date" && !isNumeric(obj)) {
    let printObj = objType === "string" ? "'" + obj + "'" : obj;
    errorMessage = msgPrefix + "expected " + printObj + " to be a number or a date";
  } else {
    shouldThrow = false;
  }
  if (shouldThrow) {
    throw new AssertionError(errorMessage, void 0, ssfi);
  }
  if (doLength) {
    let descriptor = "length", itemsCount;
    if (objType === "map" || objType === "set") {
      descriptor = "size";
      itemsCount = obj.size;
    } else {
      itemsCount = obj.length;
    }
    this.assert(
      itemsCount >= n2,
      "expected #{this} to have a " + descriptor + " at least #{exp} but got #{act}",
      "expected #{this} to have a " + descriptor + " below #{exp}",
      n2,
      itemsCount
    );
  } else {
    this.assert(
      obj >= n2,
      "expected #{this} to be at least #{exp}",
      "expected #{this} to be below #{exp}",
      n2
    );
  }
}
__name(assertLeast, "assertLeast");
__name2(assertLeast, "assertLeast");
Assertion.addMethod("least", assertLeast);
Assertion.addMethod("gte", assertLeast);
Assertion.addMethod("greaterThanOrEqual", assertLeast);
function assertBelow(n2, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), doLength = flag2(this, "doLength"), flagMsg = flag2(this, "message"), msgPrefix = flagMsg ? flagMsg + ": " : "", ssfi = flag2(this, "ssfi"), objType = type(obj).toLowerCase(), nType = type(n2).toLowerCase(), errorMessage, shouldThrow = true;
  if (doLength && objType !== "map" && objType !== "set") {
    new Assertion(obj, flagMsg, ssfi, true).to.have.property("length");
  }
  if (!doLength && objType === "date" && nType !== "date") {
    errorMessage = msgPrefix + "the argument to below must be a date";
  } else if (!isNumeric(n2) && (doLength || isNumeric(obj))) {
    errorMessage = msgPrefix + "the argument to below must be a number";
  } else if (!doLength && objType !== "date" && !isNumeric(obj)) {
    let printObj = objType === "string" ? "'" + obj + "'" : obj;
    errorMessage = msgPrefix + "expected " + printObj + " to be a number or a date";
  } else {
    shouldThrow = false;
  }
  if (shouldThrow) {
    throw new AssertionError(errorMessage, void 0, ssfi);
  }
  if (doLength) {
    let descriptor = "length", itemsCount;
    if (objType === "map" || objType === "set") {
      descriptor = "size";
      itemsCount = obj.size;
    } else {
      itemsCount = obj.length;
    }
    this.assert(
      itemsCount < n2,
      "expected #{this} to have a " + descriptor + " below #{exp} but got #{act}",
      "expected #{this} to not have a " + descriptor + " below #{exp}",
      n2,
      itemsCount
    );
  } else {
    this.assert(
      obj < n2,
      "expected #{this} to be below #{exp}",
      "expected #{this} to be at least #{exp}",
      n2
    );
  }
}
__name(assertBelow, "assertBelow");
__name2(assertBelow, "assertBelow");
Assertion.addMethod("below", assertBelow);
Assertion.addMethod("lt", assertBelow);
Assertion.addMethod("lessThan", assertBelow);
function assertMost(n2, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), doLength = flag2(this, "doLength"), flagMsg = flag2(this, "message"), msgPrefix = flagMsg ? flagMsg + ": " : "", ssfi = flag2(this, "ssfi"), objType = type(obj).toLowerCase(), nType = type(n2).toLowerCase(), errorMessage, shouldThrow = true;
  if (doLength && objType !== "map" && objType !== "set") {
    new Assertion(obj, flagMsg, ssfi, true).to.have.property("length");
  }
  if (!doLength && objType === "date" && nType !== "date") {
    errorMessage = msgPrefix + "the argument to most must be a date";
  } else if (!isNumeric(n2) && (doLength || isNumeric(obj))) {
    errorMessage = msgPrefix + "the argument to most must be a number";
  } else if (!doLength && objType !== "date" && !isNumeric(obj)) {
    let printObj = objType === "string" ? "'" + obj + "'" : obj;
    errorMessage = msgPrefix + "expected " + printObj + " to be a number or a date";
  } else {
    shouldThrow = false;
  }
  if (shouldThrow) {
    throw new AssertionError(errorMessage, void 0, ssfi);
  }
  if (doLength) {
    let descriptor = "length", itemsCount;
    if (objType === "map" || objType === "set") {
      descriptor = "size";
      itemsCount = obj.size;
    } else {
      itemsCount = obj.length;
    }
    this.assert(
      itemsCount <= n2,
      "expected #{this} to have a " + descriptor + " at most #{exp} but got #{act}",
      "expected #{this} to have a " + descriptor + " above #{exp}",
      n2,
      itemsCount
    );
  } else {
    this.assert(
      obj <= n2,
      "expected #{this} to be at most #{exp}",
      "expected #{this} to be above #{exp}",
      n2
    );
  }
}
__name(assertMost, "assertMost");
__name2(assertMost, "assertMost");
Assertion.addMethod("most", assertMost);
Assertion.addMethod("lte", assertMost);
Assertion.addMethod("lessThanOrEqual", assertMost);
Assertion.addMethod("within", function(start, finish, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), doLength = flag2(this, "doLength"), flagMsg = flag2(this, "message"), msgPrefix = flagMsg ? flagMsg + ": " : "", ssfi = flag2(this, "ssfi"), objType = type(obj).toLowerCase(), startType = type(start).toLowerCase(), finishType = type(finish).toLowerCase(), errorMessage, shouldThrow = true, range = startType === "date" && finishType === "date" ? start.toISOString() + ".." + finish.toISOString() : start + ".." + finish;
  if (doLength && objType !== "map" && objType !== "set") {
    new Assertion(obj, flagMsg, ssfi, true).to.have.property("length");
  }
  if (!doLength && objType === "date" && (startType !== "date" || finishType !== "date")) {
    errorMessage = msgPrefix + "the arguments to within must be dates";
  } else if ((!isNumeric(start) || !isNumeric(finish)) && (doLength || isNumeric(obj))) {
    errorMessage = msgPrefix + "the arguments to within must be numbers";
  } else if (!doLength && objType !== "date" && !isNumeric(obj)) {
    let printObj = objType === "string" ? "'" + obj + "'" : obj;
    errorMessage = msgPrefix + "expected " + printObj + " to be a number or a date";
  } else {
    shouldThrow = false;
  }
  if (shouldThrow) {
    throw new AssertionError(errorMessage, void 0, ssfi);
  }
  if (doLength) {
    let descriptor = "length", itemsCount;
    if (objType === "map" || objType === "set") {
      descriptor = "size";
      itemsCount = obj.size;
    } else {
      itemsCount = obj.length;
    }
    this.assert(
      itemsCount >= start && itemsCount <= finish,
      "expected #{this} to have a " + descriptor + " within " + range,
      "expected #{this} to not have a " + descriptor + " within " + range
    );
  } else {
    this.assert(
      obj >= start && obj <= finish,
      "expected #{this} to be within " + range,
      "expected #{this} to not be within " + range
    );
  }
});
function assertInstanceOf(constructor, msg) {
  if (msg) flag2(this, "message", msg);
  let target = flag2(this, "object");
  let ssfi = flag2(this, "ssfi");
  let flagMsg = flag2(this, "message");
  let isInstanceOf;
  try {
    isInstanceOf = target instanceof constructor;
  } catch (err) {
    if (err instanceof TypeError) {
      flagMsg = flagMsg ? flagMsg + ": " : "";
      throw new AssertionError(
        flagMsg + "The instanceof assertion needs a constructor but " + type(constructor) + " was given.",
        void 0,
        ssfi
      );
    }
    throw err;
  }
  let name = getName(constructor);
  if (name == null) {
    name = "an unnamed constructor";
  }
  this.assert(
    isInstanceOf,
    "expected #{this} to be an instance of " + name,
    "expected #{this} to not be an instance of " + name
  );
}
__name(assertInstanceOf, "assertInstanceOf");
__name2(assertInstanceOf, "assertInstanceOf");
Assertion.addMethod("instanceof", assertInstanceOf);
Assertion.addMethod("instanceOf", assertInstanceOf);
function assertProperty(name, val, msg) {
  if (msg) flag2(this, "message", msg);
  let isNested = flag2(this, "nested"), isOwn = flag2(this, "own"), flagMsg = flag2(this, "message"), obj = flag2(this, "object"), ssfi = flag2(this, "ssfi"), nameType = typeof name;
  flagMsg = flagMsg ? flagMsg + ": " : "";
  if (isNested) {
    if (nameType !== "string") {
      throw new AssertionError(
        flagMsg + "the argument to property must be a string when using nested syntax",
        void 0,
        ssfi
      );
    }
  } else {
    if (nameType !== "string" && nameType !== "number" && nameType !== "symbol") {
      throw new AssertionError(
        flagMsg + "the argument to property must be a string, number, or symbol",
        void 0,
        ssfi
      );
    }
  }
  if (isNested && isOwn) {
    throw new AssertionError(
      flagMsg + 'The "nested" and "own" flags cannot be combined.',
      void 0,
      ssfi
    );
  }
  if (obj === null || obj === void 0) {
    throw new AssertionError(
      flagMsg + "Target cannot be null or undefined.",
      void 0,
      ssfi
    );
  }
  let isDeep = flag2(this, "deep"), negate = flag2(this, "negate"), pathInfo = isNested ? getPathInfo(obj, name) : null, value = isNested ? pathInfo.value : obj[name], isEql = isDeep ? flag2(this, "eql") : (val1, val2) => val1 === val2;
  let descriptor = "";
  if (isDeep) descriptor += "deep ";
  if (isOwn) descriptor += "own ";
  if (isNested) descriptor += "nested ";
  descriptor += "property ";
  let hasProperty2;
  if (isOwn) hasProperty2 = Object.prototype.hasOwnProperty.call(obj, name);
  else if (isNested) hasProperty2 = pathInfo.exists;
  else hasProperty2 = hasProperty(obj, name);
  if (!negate || arguments.length === 1) {
    this.assert(
      hasProperty2,
      "expected #{this} to have " + descriptor + inspect2(name),
      "expected #{this} to not have " + descriptor + inspect2(name)
    );
  }
  if (arguments.length > 1) {
    this.assert(
      hasProperty2 && isEql(val, value),
      "expected #{this} to have " + descriptor + inspect2(name) + " of #{exp}, but got #{act}",
      "expected #{this} to not have " + descriptor + inspect2(name) + " of #{act}",
      val,
      value
    );
  }
  flag2(this, "object", value);
}
__name(assertProperty, "assertProperty");
__name2(assertProperty, "assertProperty");
Assertion.addMethod("property", assertProperty);
function assertOwnProperty(_name, _value, _msg) {
  flag2(this, "own", true);
  assertProperty.apply(this, arguments);
}
__name(assertOwnProperty, "assertOwnProperty");
__name2(assertOwnProperty, "assertOwnProperty");
Assertion.addMethod("ownProperty", assertOwnProperty);
Assertion.addMethod("haveOwnProperty", assertOwnProperty);
function assertOwnPropertyDescriptor(name, descriptor, msg) {
  if (typeof descriptor === "string") {
    msg = descriptor;
    descriptor = null;
  }
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object");
  let actualDescriptor = Object.getOwnPropertyDescriptor(Object(obj), name);
  let eql = flag2(this, "eql");
  if (actualDescriptor && descriptor) {
    this.assert(
      eql(descriptor, actualDescriptor),
      "expected the own property descriptor for " + inspect2(name) + " on #{this} to match " + inspect2(descriptor) + ", got " + inspect2(actualDescriptor),
      "expected the own property descriptor for " + inspect2(name) + " on #{this} to not match " + inspect2(descriptor),
      descriptor,
      actualDescriptor,
      true
    );
  } else {
    this.assert(
      actualDescriptor,
      "expected #{this} to have an own property descriptor for " + inspect2(name),
      "expected #{this} to not have an own property descriptor for " + inspect2(name)
    );
  }
  flag2(this, "object", actualDescriptor);
}
__name(assertOwnPropertyDescriptor, "assertOwnPropertyDescriptor");
__name2(assertOwnPropertyDescriptor, "assertOwnPropertyDescriptor");
Assertion.addMethod("ownPropertyDescriptor", assertOwnPropertyDescriptor);
Assertion.addMethod("haveOwnPropertyDescriptor", assertOwnPropertyDescriptor);
function assertLengthChain() {
  flag2(this, "doLength", true);
}
__name(assertLengthChain, "assertLengthChain");
__name2(assertLengthChain, "assertLengthChain");
function assertLength(n2, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), objType = type(obj).toLowerCase(), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi"), descriptor = "length", itemsCount;
  switch (objType) {
    case "map":
    case "set":
      descriptor = "size";
      itemsCount = obj.size;
      break;
    default:
      new Assertion(obj, flagMsg, ssfi, true).to.have.property("length");
      itemsCount = obj.length;
  }
  this.assert(
    itemsCount == n2,
    "expected #{this} to have a " + descriptor + " of #{exp} but got #{act}",
    "expected #{this} to not have a " + descriptor + " of #{act}",
    n2,
    itemsCount
  );
}
__name(assertLength, "assertLength");
__name2(assertLength, "assertLength");
Assertion.addChainableMethod("length", assertLength, assertLengthChain);
Assertion.addChainableMethod("lengthOf", assertLength, assertLengthChain);
function assertMatch(re, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object");
  this.assert(
    re.exec(obj),
    "expected #{this} to match " + re,
    "expected #{this} not to match " + re
  );
}
__name(assertMatch, "assertMatch");
__name2(assertMatch, "assertMatch");
Assertion.addMethod("match", assertMatch);
Assertion.addMethod("matches", assertMatch);
Assertion.addMethod("string", function(str, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi");
  new Assertion(obj, flagMsg, ssfi, true).is.a("string");
  this.assert(
    ~obj.indexOf(str),
    "expected #{this} to contain " + inspect2(str),
    "expected #{this} to not contain " + inspect2(str)
  );
});
function assertKeys(keys2) {
  let obj = flag2(this, "object"), objType = type(obj), keysType = type(keys2), ssfi = flag2(this, "ssfi"), isDeep = flag2(this, "deep"), str, deepStr = "", actual, ok = true, flagMsg = flag2(this, "message");
  flagMsg = flagMsg ? flagMsg + ": " : "";
  let mixedArgsMsg = flagMsg + "when testing keys against an object or an array you must give a single Array|Object|String argument or multiple String arguments";
  if (objType === "Map" || objType === "Set") {
    deepStr = isDeep ? "deeply " : "";
    actual = [];
    obj.forEach(function(val, key) {
      actual.push(key);
    });
    if (keysType !== "Array") {
      keys2 = Array.prototype.slice.call(arguments);
    }
  } else {
    actual = getOwnEnumerableProperties(obj);
    switch (keysType) {
      case "Array":
        if (arguments.length > 1) {
          throw new AssertionError(mixedArgsMsg, void 0, ssfi);
        }
        break;
      case "Object":
        if (arguments.length > 1) {
          throw new AssertionError(mixedArgsMsg, void 0, ssfi);
        }
        keys2 = Object.keys(keys2);
        break;
      default:
        keys2 = Array.prototype.slice.call(arguments);
    }
    keys2 = keys2.map(function(val) {
      return typeof val === "symbol" ? val : String(val);
    });
  }
  if (!keys2.length) {
    throw new AssertionError(flagMsg + "keys required", void 0, ssfi);
  }
  let len = keys2.length, any = flag2(this, "any"), all = flag2(this, "all"), expected = keys2, isEql = isDeep ? flag2(this, "eql") : (val1, val2) => val1 === val2;
  if (!any && !all) {
    all = true;
  }
  if (any) {
    ok = expected.some(function(expectedKey) {
      return actual.some(function(actualKey) {
        return isEql(expectedKey, actualKey);
      });
    });
  }
  if (all) {
    ok = expected.every(function(expectedKey) {
      return actual.some(function(actualKey) {
        return isEql(expectedKey, actualKey);
      });
    });
    if (!flag2(this, "contains")) {
      ok = ok && keys2.length == actual.length;
    }
  }
  if (len > 1) {
    keys2 = keys2.map(function(key) {
      return inspect2(key);
    });
    let last = keys2.pop();
    if (all) {
      str = keys2.join(", ") + ", and " + last;
    }
    if (any) {
      str = keys2.join(", ") + ", or " + last;
    }
  } else {
    str = inspect2(keys2[0]);
  }
  str = (len > 1 ? "keys " : "key ") + str;
  str = (flag2(this, "contains") ? "contain " : "have ") + str;
  this.assert(
    ok,
    "expected #{this} to " + deepStr + str,
    "expected #{this} to not " + deepStr + str,
    expected.slice(0).sort(compareByInspect),
    actual.sort(compareByInspect),
    true
  );
}
__name(assertKeys, "assertKeys");
__name2(assertKeys, "assertKeys");
Assertion.addMethod("keys", assertKeys);
Assertion.addMethod("key", assertKeys);
function assertThrows(errorLike, errMsgMatcher, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), ssfi = flag2(this, "ssfi"), flagMsg = flag2(this, "message"), negate = flag2(this, "negate") || false;
  new Assertion(obj, flagMsg, ssfi, true).is.a("function");
  if (isRegExp2(errorLike) || typeof errorLike === "string") {
    errMsgMatcher = errorLike;
    errorLike = null;
  }
  let caughtErr;
  let errorWasThrown = false;
  try {
    obj();
  } catch (err) {
    errorWasThrown = true;
    caughtErr = err;
  }
  let everyArgIsUndefined = errorLike === void 0 && errMsgMatcher === void 0;
  let everyArgIsDefined = Boolean(errorLike && errMsgMatcher);
  let errorLikeFail = false;
  let errMsgMatcherFail = false;
  if (everyArgIsUndefined || !everyArgIsUndefined && !negate) {
    let errorLikeString = "an error";
    if (errorLike instanceof Error) {
      errorLikeString = "#{exp}";
    } else if (errorLike) {
      errorLikeString = check_error_exports.getConstructorName(errorLike);
    }
    let actual = caughtErr;
    if (caughtErr instanceof Error) {
      actual = caughtErr.toString();
    } else if (typeof caughtErr === "string") {
      actual = caughtErr;
    } else if (caughtErr && (typeof caughtErr === "object" || typeof caughtErr === "function")) {
      try {
        actual = check_error_exports.getConstructorName(caughtErr);
      } catch (_err) {
      }
    }
    this.assert(
      errorWasThrown,
      "expected #{this} to throw " + errorLikeString,
      "expected #{this} to not throw an error but #{act} was thrown",
      errorLike && errorLike.toString(),
      actual
    );
  }
  if (errorLike && caughtErr) {
    if (errorLike instanceof Error) {
      let isCompatibleInstance = check_error_exports.compatibleInstance(
        caughtErr,
        errorLike
      );
      if (isCompatibleInstance === negate) {
        if (everyArgIsDefined && negate) {
          errorLikeFail = true;
        } else {
          this.assert(
            negate,
            "expected #{this} to throw #{exp} but #{act} was thrown",
            "expected #{this} to not throw #{exp}" + (caughtErr && !negate ? " but #{act} was thrown" : ""),
            errorLike.toString(),
            caughtErr.toString()
          );
        }
      }
    }
    let isCompatibleConstructor = check_error_exports.compatibleConstructor(
      caughtErr,
      errorLike
    );
    if (isCompatibleConstructor === negate) {
      if (everyArgIsDefined && negate) {
        errorLikeFail = true;
      } else {
        this.assert(
          negate,
          "expected #{this} to throw #{exp} but #{act} was thrown",
          "expected #{this} to not throw #{exp}" + (caughtErr ? " but #{act} was thrown" : ""),
          errorLike instanceof Error ? errorLike.toString() : errorLike && check_error_exports.getConstructorName(errorLike),
          caughtErr instanceof Error ? caughtErr.toString() : caughtErr && check_error_exports.getConstructorName(caughtErr)
        );
      }
    }
  }
  if (caughtErr && errMsgMatcher !== void 0 && errMsgMatcher !== null) {
    let placeholder = "including";
    if (isRegExp2(errMsgMatcher)) {
      placeholder = "matching";
    }
    let isCompatibleMessage = check_error_exports.compatibleMessage(
      caughtErr,
      errMsgMatcher
    );
    if (isCompatibleMessage === negate) {
      if (everyArgIsDefined && negate) {
        errMsgMatcherFail = true;
      } else {
        this.assert(
          negate,
          "expected #{this} to throw error " + placeholder + " #{exp} but got #{act}",
          "expected #{this} to throw error not " + placeholder + " #{exp}",
          errMsgMatcher,
          check_error_exports.getMessage(caughtErr)
        );
      }
    }
  }
  if (errorLikeFail && errMsgMatcherFail) {
    this.assert(
      negate,
      "expected #{this} to throw #{exp} but #{act} was thrown",
      "expected #{this} to not throw #{exp}" + (caughtErr ? " but #{act} was thrown" : ""),
      errorLike instanceof Error ? errorLike.toString() : errorLike && check_error_exports.getConstructorName(errorLike),
      caughtErr instanceof Error ? caughtErr.toString() : caughtErr && check_error_exports.getConstructorName(caughtErr)
    );
  }
  flag2(this, "object", caughtErr);
}
__name(assertThrows, "assertThrows");
__name2(assertThrows, "assertThrows");
Assertion.addMethod("throw", assertThrows);
Assertion.addMethod("throws", assertThrows);
Assertion.addMethod("Throw", assertThrows);
function respondTo(method, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), itself = flag2(this, "itself"), context = "function" === typeof obj && !itself ? obj.prototype[method] : obj[method];
  this.assert(
    "function" === typeof context,
    "expected #{this} to respond to " + inspect2(method),
    "expected #{this} to not respond to " + inspect2(method)
  );
}
__name(respondTo, "respondTo");
__name2(respondTo, "respondTo");
Assertion.addMethod("respondTo", respondTo);
Assertion.addMethod("respondsTo", respondTo);
Assertion.addProperty("itself", function() {
  flag2(this, "itself", true);
});
function satisfy(matcher, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object");
  let result = matcher(obj);
  this.assert(
    result,
    "expected #{this} to satisfy " + objDisplay(matcher),
    "expected #{this} to not satisfy" + objDisplay(matcher),
    flag2(this, "negate") ? false : true,
    result
  );
}
__name(satisfy, "satisfy");
__name2(satisfy, "satisfy");
Assertion.addMethod("satisfy", satisfy);
Assertion.addMethod("satisfies", satisfy);
function closeTo(expected, delta, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi");
  new Assertion(obj, flagMsg, ssfi, true).is.numeric;
  let message = "A `delta` value is required for `closeTo`";
  if (delta == void 0) {
    throw new AssertionError(
      flagMsg ? `${flagMsg}: ${message}` : message,
      void 0,
      ssfi
    );
  }
  new Assertion(delta, flagMsg, ssfi, true).is.numeric;
  message = "A `expected` value is required for `closeTo`";
  if (expected == void 0) {
    throw new AssertionError(
      flagMsg ? `${flagMsg}: ${message}` : message,
      void 0,
      ssfi
    );
  }
  new Assertion(expected, flagMsg, ssfi, true).is.numeric;
  const abs = __name2((x2) => x2 < 0n ? -x2 : x2, "abs");
  const strip = __name2((number) => parseFloat(parseFloat(number).toPrecision(12)), "strip");
  this.assert(
    strip(abs(obj - expected)) <= delta,
    "expected #{this} to be close to " + expected + " +/- " + delta,
    "expected #{this} not to be close to " + expected + " +/- " + delta
  );
}
__name(closeTo, "closeTo");
__name2(closeTo, "closeTo");
Assertion.addMethod("closeTo", closeTo);
Assertion.addMethod("approximately", closeTo);
function isSubsetOf(_subset, _superset, cmp, contains, ordered) {
  let superset = Array.from(_superset);
  let subset = Array.from(_subset);
  if (!contains) {
    if (subset.length !== superset.length) return false;
    superset = superset.slice();
  }
  return subset.every(function(elem, idx) {
    if (ordered) return cmp ? cmp(elem, superset[idx]) : elem === superset[idx];
    if (!cmp) {
      let matchIdx = superset.indexOf(elem);
      if (matchIdx === -1) return false;
      if (!contains) superset.splice(matchIdx, 1);
      return true;
    }
    return superset.some(function(elem2, matchIdx) {
      if (!cmp(elem, elem2)) return false;
      if (!contains) superset.splice(matchIdx, 1);
      return true;
    });
  });
}
__name(isSubsetOf, "isSubsetOf");
__name2(isSubsetOf, "isSubsetOf");
Assertion.addMethod("members", function(subset, msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object"), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi");
  new Assertion(obj, flagMsg, ssfi, true).to.be.iterable;
  new Assertion(subset, flagMsg, ssfi, true).to.be.iterable;
  let contains = flag2(this, "contains");
  let ordered = flag2(this, "ordered");
  let subject, failMsg, failNegateMsg;
  if (contains) {
    subject = ordered ? "an ordered superset" : "a superset";
    failMsg = "expected #{this} to be " + subject + " of #{exp}";
    failNegateMsg = "expected #{this} to not be " + subject + " of #{exp}";
  } else {
    subject = ordered ? "ordered members" : "members";
    failMsg = "expected #{this} to have the same " + subject + " as #{exp}";
    failNegateMsg = "expected #{this} to not have the same " + subject + " as #{exp}";
  }
  let cmp = flag2(this, "deep") ? flag2(this, "eql") : void 0;
  this.assert(
    isSubsetOf(subset, obj, cmp, contains, ordered),
    failMsg,
    failNegateMsg,
    subset,
    obj,
    true
  );
});
Assertion.addProperty("iterable", function(msg) {
  if (msg) flag2(this, "message", msg);
  let obj = flag2(this, "object");
  this.assert(
    obj != void 0 && obj[Symbol.iterator],
    "expected #{this} to be an iterable",
    "expected #{this} to not be an iterable",
    obj
  );
});
function oneOf(list, msg) {
  if (msg) flag2(this, "message", msg);
  let expected = flag2(this, "object"), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi"), contains = flag2(this, "contains"), isDeep = flag2(this, "deep"), eql = flag2(this, "eql");
  new Assertion(list, flagMsg, ssfi, true).to.be.an("array");
  if (contains) {
    this.assert(
      list.some(function(possibility) {
        return expected.indexOf(possibility) > -1;
      }),
      "expected #{this} to contain one of #{exp}",
      "expected #{this} to not contain one of #{exp}",
      list,
      expected
    );
  } else {
    if (isDeep) {
      this.assert(
        list.some(function(possibility) {
          return eql(expected, possibility);
        }),
        "expected #{this} to deeply equal one of #{exp}",
        "expected #{this} to deeply equal one of #{exp}",
        list,
        expected
      );
    } else {
      this.assert(
        list.indexOf(expected) > -1,
        "expected #{this} to be one of #{exp}",
        "expected #{this} to not be one of #{exp}",
        list,
        expected
      );
    }
  }
}
__name(oneOf, "oneOf");
__name2(oneOf, "oneOf");
Assertion.addMethod("oneOf", oneOf);
function assertChanges(subject, prop, msg) {
  if (msg) flag2(this, "message", msg);
  let fn3 = flag2(this, "object"), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi");
  new Assertion(fn3, flagMsg, ssfi, true).is.a("function");
  let initial;
  if (!prop) {
    new Assertion(subject, flagMsg, ssfi, true).is.a("function");
    initial = subject();
  } else {
    new Assertion(subject, flagMsg, ssfi, true).to.have.property(prop);
    initial = subject[prop];
  }
  fn3();
  let final = prop === void 0 || prop === null ? subject() : subject[prop];
  let msgObj = prop === void 0 || prop === null ? initial : "." + prop;
  flag2(this, "deltaMsgObj", msgObj);
  flag2(this, "initialDeltaValue", initial);
  flag2(this, "finalDeltaValue", final);
  flag2(this, "deltaBehavior", "change");
  flag2(this, "realDelta", final !== initial);
  this.assert(
    initial !== final,
    "expected " + msgObj + " to change",
    "expected " + msgObj + " to not change"
  );
}
__name(assertChanges, "assertChanges");
__name2(assertChanges, "assertChanges");
Assertion.addMethod("change", assertChanges);
Assertion.addMethod("changes", assertChanges);
function assertIncreases(subject, prop, msg) {
  if (msg) flag2(this, "message", msg);
  let fn3 = flag2(this, "object"), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi");
  new Assertion(fn3, flagMsg, ssfi, true).is.a("function");
  let initial;
  if (!prop) {
    new Assertion(subject, flagMsg, ssfi, true).is.a("function");
    initial = subject();
  } else {
    new Assertion(subject, flagMsg, ssfi, true).to.have.property(prop);
    initial = subject[prop];
  }
  new Assertion(initial, flagMsg, ssfi, true).is.a("number");
  fn3();
  let final = prop === void 0 || prop === null ? subject() : subject[prop];
  let msgObj = prop === void 0 || prop === null ? initial : "." + prop;
  flag2(this, "deltaMsgObj", msgObj);
  flag2(this, "initialDeltaValue", initial);
  flag2(this, "finalDeltaValue", final);
  flag2(this, "deltaBehavior", "increase");
  flag2(this, "realDelta", final - initial);
  this.assert(
    final - initial > 0,
    "expected " + msgObj + " to increase",
    "expected " + msgObj + " to not increase"
  );
}
__name(assertIncreases, "assertIncreases");
__name2(assertIncreases, "assertIncreases");
Assertion.addMethod("increase", assertIncreases);
Assertion.addMethod("increases", assertIncreases);
function assertDecreases(subject, prop, msg) {
  if (msg) flag2(this, "message", msg);
  let fn3 = flag2(this, "object"), flagMsg = flag2(this, "message"), ssfi = flag2(this, "ssfi");
  new Assertion(fn3, flagMsg, ssfi, true).is.a("function");
  let initial;
  if (!prop) {
    new Assertion(subject, flagMsg, ssfi, true).is.a("function");
    initial = subject();
  } else {
    new Assertion(subject, flagMsg, ssfi, true).to.have.property(prop);
    initial = subject[prop];
  }
  new Assertion(initial, flagMsg, ssfi, true).is.a("number");
  fn3();
  let final = prop === void 0 || prop === null ? subject() : subject[prop];
  let msgObj = prop === void 0 || prop === null ? initial : "." + prop;
  flag2(this, "deltaMsgObj", msgObj);
  flag2(this, "initialDeltaValue", initial);
  flag2(this, "finalDeltaValue", final);
  flag2(this, "deltaBehavior", "decrease");
  flag2(this, "realDelta", initial - final);
  this.assert(
    final - initial < 0,
    "expected " + msgObj + " to decrease",
    "expected " + msgObj + " to not decrease"
  );
}
__name(assertDecreases, "assertDecreases");
__name2(assertDecreases, "assertDecreases");
Assertion.addMethod("decrease", assertDecreases);
Assertion.addMethod("decreases", assertDecreases);
function assertDelta(delta, msg) {
  if (msg) flag2(this, "message", msg);
  let msgObj = flag2(this, "deltaMsgObj");
  let initial = flag2(this, "initialDeltaValue");
  let final = flag2(this, "finalDeltaValue");
  let behavior2 = flag2(this, "deltaBehavior");
  let realDelta = flag2(this, "realDelta");
  let expression;
  if (behavior2 === "change") {
    expression = Math.abs(final - initial) === Math.abs(delta);
  } else {
    expression = realDelta === Math.abs(delta);
  }
  this.assert(
    expression,
    "expected " + msgObj + " to " + behavior2 + " by " + delta,
    "expected " + msgObj + " to not " + behavior2 + " by " + delta
  );
}
__name(assertDelta, "assertDelta");
__name2(assertDelta, "assertDelta");
Assertion.addMethod("by", assertDelta);
Assertion.addProperty("extensible", function() {
  let obj = flag2(this, "object");
  let isExtensible = obj === Object(obj) && Object.isExtensible(obj);
  this.assert(
    isExtensible,
    "expected #{this} to be extensible",
    "expected #{this} to not be extensible"
  );
});
Assertion.addProperty("sealed", function() {
  let obj = flag2(this, "object");
  let isSealed = obj === Object(obj) ? Object.isSealed(obj) : true;
  this.assert(
    isSealed,
    "expected #{this} to be sealed",
    "expected #{this} to not be sealed"
  );
});
Assertion.addProperty("frozen", function() {
  let obj = flag2(this, "object");
  let isFrozen = obj === Object(obj) ? Object.isFrozen(obj) : true;
  this.assert(
    isFrozen,
    "expected #{this} to be frozen",
    "expected #{this} to not be frozen"
  );
});
Assertion.addProperty("finite", function(_msg) {
  let obj = flag2(this, "object");
  this.assert(
    typeof obj === "number" && isFinite(obj),
    "expected #{this} to be a finite number",
    "expected #{this} to not be a finite number"
  );
});
function compareSubset(expected, actual) {
  if (expected === actual) {
    return true;
  }
  if (typeof actual !== typeof expected) {
    return false;
  }
  if (typeof expected !== "object" || expected === null) {
    return expected === actual;
  }
  if (!actual) {
    return false;
  }
  if (Array.isArray(expected)) {
    if (!Array.isArray(actual)) {
      return false;
    }
    return expected.every(function(exp) {
      return actual.some(function(act) {
        return compareSubset(exp, act);
      });
    });
  }
  if (expected instanceof Date) {
    if (actual instanceof Date) {
      return expected.getTime() === actual.getTime();
    } else {
      return false;
    }
  }
  return Object.keys(expected).every(function(key) {
    let expectedValue = expected[key];
    let actualValue = actual[key];
    if (typeof expectedValue === "object" && expectedValue !== null && actualValue !== null) {
      return compareSubset(expectedValue, actualValue);
    }
    if (typeof expectedValue === "function") {
      return expectedValue(actualValue);
    }
    return actualValue === expectedValue;
  });
}
__name(compareSubset, "compareSubset");
__name2(compareSubset, "compareSubset");
Assertion.addMethod("containSubset", function(expected) {
  const actual = flag(this, "object");
  const showDiff = config.showDiff;
  this.assert(
    compareSubset(expected, actual),
    "expected #{act} to contain subset #{exp}",
    "expected #{act} to not contain subset #{exp}",
    expected,
    actual,
    showDiff
  );
});
function expect(val, message) {
  return new Assertion(val, message);
}
__name(expect, "expect");
__name2(expect, "expect");
expect.fail = function(actual, expected, message, operator) {
  if (arguments.length < 2) {
    message = actual;
    actual = void 0;
  }
  message = message || "expect.fail()";
  throw new AssertionError(
    message,
    {
      actual,
      expected,
      operator
    },
    expect.fail
  );
};
var should_exports = {};
__export2(should_exports, {
  Should: /* @__PURE__ */ __name(() => Should, "Should"),
  should: /* @__PURE__ */ __name(() => should, "should")
});
function loadShould() {
  function shouldGetter() {
    if (this instanceof String || this instanceof Number || this instanceof Boolean || typeof Symbol === "function" && this instanceof Symbol || typeof BigInt === "function" && this instanceof BigInt) {
      return new Assertion(this.valueOf(), null, shouldGetter);
    }
    return new Assertion(this, null, shouldGetter);
  }
  __name(shouldGetter, "shouldGetter");
  __name2(shouldGetter, "shouldGetter");
  function shouldSetter(value) {
    Object.defineProperty(this, "should", {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  }
  __name(shouldSetter, "shouldSetter");
  __name2(shouldSetter, "shouldSetter");
  Object.defineProperty(Object.prototype, "should", {
    set: shouldSetter,
    get: shouldGetter,
    configurable: true
  });
  let should2 = {};
  should2.fail = function(actual, expected, message, operator) {
    if (arguments.length < 2) {
      message = actual;
      actual = void 0;
    }
    message = message || "should.fail()";
    throw new AssertionError(
      message,
      {
        actual,
        expected,
        operator
      },
      should2.fail
    );
  };
  should2.equal = function(actual, expected, message) {
    new Assertion(actual, message).to.equal(expected);
  };
  should2.Throw = function(fn3, errt, errs, msg) {
    new Assertion(fn3, msg).to.Throw(errt, errs);
  };
  should2.exist = function(val, msg) {
    new Assertion(val, msg).to.exist;
  };
  should2.not = {};
  should2.not.equal = function(actual, expected, msg) {
    new Assertion(actual, msg).to.not.equal(expected);
  };
  should2.not.Throw = function(fn3, errt, errs, msg) {
    new Assertion(fn3, msg).to.not.Throw(errt, errs);
  };
  should2.not.exist = function(val, msg) {
    new Assertion(val, msg).to.not.exist;
  };
  should2["throw"] = should2["Throw"];
  should2.not["throw"] = should2.not["Throw"];
  return should2;
}
__name(loadShould, "loadShould");
__name2(loadShould, "loadShould");
var should = loadShould;
var Should = loadShould;
function assert(express, errmsg) {
  let test2 = new Assertion(null, null, assert, true);
  test2.assert(express, errmsg, "[ negation message unavailable ]");
}
__name(assert, "assert");
__name2(assert, "assert");
assert.fail = function(actual, expected, message, operator) {
  if (arguments.length < 2) {
    message = actual;
    actual = void 0;
  }
  message = message || "assert.fail()";
  throw new AssertionError(
    message,
    {
      actual,
      expected,
      operator
    },
    assert.fail
  );
};
assert.isOk = function(val, msg) {
  new Assertion(val, msg, assert.isOk, true).is.ok;
};
assert.isNotOk = function(val, msg) {
  new Assertion(val, msg, assert.isNotOk, true).is.not.ok;
};
assert.equal = function(act, exp, msg) {
  let test2 = new Assertion(act, msg, assert.equal, true);
  test2.assert(
    exp == flag(test2, "object"),
    "expected #{this} to equal #{exp}",
    "expected #{this} to not equal #{act}",
    exp,
    act,
    true
  );
};
assert.notEqual = function(act, exp, msg) {
  let test2 = new Assertion(act, msg, assert.notEqual, true);
  test2.assert(
    exp != flag(test2, "object"),
    "expected #{this} to not equal #{exp}",
    "expected #{this} to equal #{act}",
    exp,
    act,
    true
  );
};
assert.strictEqual = function(act, exp, msg) {
  new Assertion(act, msg, assert.strictEqual, true).to.equal(exp);
};
assert.notStrictEqual = function(act, exp, msg) {
  new Assertion(act, msg, assert.notStrictEqual, true).to.not.equal(exp);
};
assert.deepEqual = assert.deepStrictEqual = function(act, exp, msg) {
  new Assertion(act, msg, assert.deepEqual, true).to.eql(exp);
};
assert.notDeepEqual = function(act, exp, msg) {
  new Assertion(act, msg, assert.notDeepEqual, true).to.not.eql(exp);
};
assert.isAbove = function(val, abv, msg) {
  new Assertion(val, msg, assert.isAbove, true).to.be.above(abv);
};
assert.isAtLeast = function(val, atlst, msg) {
  new Assertion(val, msg, assert.isAtLeast, true).to.be.least(atlst);
};
assert.isBelow = function(val, blw, msg) {
  new Assertion(val, msg, assert.isBelow, true).to.be.below(blw);
};
assert.isAtMost = function(val, atmst, msg) {
  new Assertion(val, msg, assert.isAtMost, true).to.be.most(atmst);
};
assert.isTrue = function(val, msg) {
  new Assertion(val, msg, assert.isTrue, true).is["true"];
};
assert.isNotTrue = function(val, msg) {
  new Assertion(val, msg, assert.isNotTrue, true).to.not.equal(true);
};
assert.isFalse = function(val, msg) {
  new Assertion(val, msg, assert.isFalse, true).is["false"];
};
assert.isNotFalse = function(val, msg) {
  new Assertion(val, msg, assert.isNotFalse, true).to.not.equal(false);
};
assert.isNull = function(val, msg) {
  new Assertion(val, msg, assert.isNull, true).to.equal(null);
};
assert.isNotNull = function(val, msg) {
  new Assertion(val, msg, assert.isNotNull, true).to.not.equal(null);
};
assert.isNaN = function(val, msg) {
  new Assertion(val, msg, assert.isNaN, true).to.be.NaN;
};
assert.isNotNaN = function(value, message) {
  new Assertion(value, message, assert.isNotNaN, true).not.to.be.NaN;
};
assert.exists = function(val, msg) {
  new Assertion(val, msg, assert.exists, true).to.exist;
};
assert.notExists = function(val, msg) {
  new Assertion(val, msg, assert.notExists, true).to.not.exist;
};
assert.isUndefined = function(val, msg) {
  new Assertion(val, msg, assert.isUndefined, true).to.equal(void 0);
};
assert.isDefined = function(val, msg) {
  new Assertion(val, msg, assert.isDefined, true).to.not.equal(void 0);
};
assert.isCallable = function(value, message) {
  new Assertion(value, message, assert.isCallable, true).is.callable;
};
assert.isNotCallable = function(value, message) {
  new Assertion(value, message, assert.isNotCallable, true).is.not.callable;
};
assert.isObject = function(val, msg) {
  new Assertion(val, msg, assert.isObject, true).to.be.a("object");
};
assert.isNotObject = function(val, msg) {
  new Assertion(val, msg, assert.isNotObject, true).to.not.be.a("object");
};
assert.isArray = function(val, msg) {
  new Assertion(val, msg, assert.isArray, true).to.be.an("array");
};
assert.isNotArray = function(val, msg) {
  new Assertion(val, msg, assert.isNotArray, true).to.not.be.an("array");
};
assert.isString = function(val, msg) {
  new Assertion(val, msg, assert.isString, true).to.be.a("string");
};
assert.isNotString = function(val, msg) {
  new Assertion(val, msg, assert.isNotString, true).to.not.be.a("string");
};
assert.isNumber = function(val, msg) {
  new Assertion(val, msg, assert.isNumber, true).to.be.a("number");
};
assert.isNotNumber = function(val, msg) {
  new Assertion(val, msg, assert.isNotNumber, true).to.not.be.a("number");
};
assert.isNumeric = function(val, msg) {
  new Assertion(val, msg, assert.isNumeric, true).is.numeric;
};
assert.isNotNumeric = function(val, msg) {
  new Assertion(val, msg, assert.isNotNumeric, true).is.not.numeric;
};
assert.isFinite = function(val, msg) {
  new Assertion(val, msg, assert.isFinite, true).to.be.finite;
};
assert.isBoolean = function(val, msg) {
  new Assertion(val, msg, assert.isBoolean, true).to.be.a("boolean");
};
assert.isNotBoolean = function(val, msg) {
  new Assertion(val, msg, assert.isNotBoolean, true).to.not.be.a("boolean");
};
assert.typeOf = function(val, type32, msg) {
  new Assertion(val, msg, assert.typeOf, true).to.be.a(type32);
};
assert.notTypeOf = function(value, type32, message) {
  new Assertion(value, message, assert.notTypeOf, true).to.not.be.a(type32);
};
assert.instanceOf = function(val, type32, msg) {
  new Assertion(val, msg, assert.instanceOf, true).to.be.instanceOf(type32);
};
assert.notInstanceOf = function(val, type32, msg) {
  new Assertion(val, msg, assert.notInstanceOf, true).to.not.be.instanceOf(
    type32
  );
};
assert.include = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.include, true).include(inc);
};
assert.notInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.notInclude, true).not.include(inc);
};
assert.deepInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.deepInclude, true).deep.include(inc);
};
assert.notDeepInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.notDeepInclude, true).not.deep.include(inc);
};
assert.nestedInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.nestedInclude, true).nested.include(inc);
};
assert.notNestedInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.notNestedInclude, true).not.nested.include(
    inc
  );
};
assert.deepNestedInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.deepNestedInclude, true).deep.nested.include(
    inc
  );
};
assert.notDeepNestedInclude = function(exp, inc, msg) {
  new Assertion(
    exp,
    msg,
    assert.notDeepNestedInclude,
    true
  ).not.deep.nested.include(inc);
};
assert.ownInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.ownInclude, true).own.include(inc);
};
assert.notOwnInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.notOwnInclude, true).not.own.include(inc);
};
assert.deepOwnInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.deepOwnInclude, true).deep.own.include(inc);
};
assert.notDeepOwnInclude = function(exp, inc, msg) {
  new Assertion(exp, msg, assert.notDeepOwnInclude, true).not.deep.own.include(
    inc
  );
};
assert.match = function(exp, re, msg) {
  new Assertion(exp, msg, assert.match, true).to.match(re);
};
assert.notMatch = function(exp, re, msg) {
  new Assertion(exp, msg, assert.notMatch, true).to.not.match(re);
};
assert.property = function(obj, prop, msg) {
  new Assertion(obj, msg, assert.property, true).to.have.property(prop);
};
assert.notProperty = function(obj, prop, msg) {
  new Assertion(obj, msg, assert.notProperty, true).to.not.have.property(prop);
};
assert.propertyVal = function(obj, prop, val, msg) {
  new Assertion(obj, msg, assert.propertyVal, true).to.have.property(prop, val);
};
assert.notPropertyVal = function(obj, prop, val, msg) {
  new Assertion(obj, msg, assert.notPropertyVal, true).to.not.have.property(
    prop,
    val
  );
};
assert.deepPropertyVal = function(obj, prop, val, msg) {
  new Assertion(obj, msg, assert.deepPropertyVal, true).to.have.deep.property(
    prop,
    val
  );
};
assert.notDeepPropertyVal = function(obj, prop, val, msg) {
  new Assertion(
    obj,
    msg,
    assert.notDeepPropertyVal,
    true
  ).to.not.have.deep.property(prop, val);
};
assert.ownProperty = function(obj, prop, msg) {
  new Assertion(obj, msg, assert.ownProperty, true).to.have.own.property(prop);
};
assert.notOwnProperty = function(obj, prop, msg) {
  new Assertion(obj, msg, assert.notOwnProperty, true).to.not.have.own.property(
    prop
  );
};
assert.ownPropertyVal = function(obj, prop, value, msg) {
  new Assertion(obj, msg, assert.ownPropertyVal, true).to.have.own.property(
    prop,
    value
  );
};
assert.notOwnPropertyVal = function(obj, prop, value, msg) {
  new Assertion(
    obj,
    msg,
    assert.notOwnPropertyVal,
    true
  ).to.not.have.own.property(prop, value);
};
assert.deepOwnPropertyVal = function(obj, prop, value, msg) {
  new Assertion(
    obj,
    msg,
    assert.deepOwnPropertyVal,
    true
  ).to.have.deep.own.property(prop, value);
};
assert.notDeepOwnPropertyVal = function(obj, prop, value, msg) {
  new Assertion(
    obj,
    msg,
    assert.notDeepOwnPropertyVal,
    true
  ).to.not.have.deep.own.property(prop, value);
};
assert.nestedProperty = function(obj, prop, msg) {
  new Assertion(obj, msg, assert.nestedProperty, true).to.have.nested.property(
    prop
  );
};
assert.notNestedProperty = function(obj, prop, msg) {
  new Assertion(
    obj,
    msg,
    assert.notNestedProperty,
    true
  ).to.not.have.nested.property(prop);
};
assert.nestedPropertyVal = function(obj, prop, val, msg) {
  new Assertion(
    obj,
    msg,
    assert.nestedPropertyVal,
    true
  ).to.have.nested.property(prop, val);
};
assert.notNestedPropertyVal = function(obj, prop, val, msg) {
  new Assertion(
    obj,
    msg,
    assert.notNestedPropertyVal,
    true
  ).to.not.have.nested.property(prop, val);
};
assert.deepNestedPropertyVal = function(obj, prop, val, msg) {
  new Assertion(
    obj,
    msg,
    assert.deepNestedPropertyVal,
    true
  ).to.have.deep.nested.property(prop, val);
};
assert.notDeepNestedPropertyVal = function(obj, prop, val, msg) {
  new Assertion(
    obj,
    msg,
    assert.notDeepNestedPropertyVal,
    true
  ).to.not.have.deep.nested.property(prop, val);
};
assert.lengthOf = function(exp, len, msg) {
  new Assertion(exp, msg, assert.lengthOf, true).to.have.lengthOf(len);
};
assert.hasAnyKeys = function(obj, keys2, msg) {
  new Assertion(obj, msg, assert.hasAnyKeys, true).to.have.any.keys(keys2);
};
assert.hasAllKeys = function(obj, keys2, msg) {
  new Assertion(obj, msg, assert.hasAllKeys, true).to.have.all.keys(keys2);
};
assert.containsAllKeys = function(obj, keys2, msg) {
  new Assertion(obj, msg, assert.containsAllKeys, true).to.contain.all.keys(
    keys2
  );
};
assert.doesNotHaveAnyKeys = function(obj, keys2, msg) {
  new Assertion(obj, msg, assert.doesNotHaveAnyKeys, true).to.not.have.any.keys(
    keys2
  );
};
assert.doesNotHaveAllKeys = function(obj, keys2, msg) {
  new Assertion(obj, msg, assert.doesNotHaveAllKeys, true).to.not.have.all.keys(
    keys2
  );
};
assert.hasAnyDeepKeys = function(obj, keys2, msg) {
  new Assertion(obj, msg, assert.hasAnyDeepKeys, true).to.have.any.deep.keys(
    keys2
  );
};
assert.hasAllDeepKeys = function(obj, keys2, msg) {
  new Assertion(obj, msg, assert.hasAllDeepKeys, true).to.have.all.deep.keys(
    keys2
  );
};
assert.containsAllDeepKeys = function(obj, keys2, msg) {
  new Assertion(
    obj,
    msg,
    assert.containsAllDeepKeys,
    true
  ).to.contain.all.deep.keys(keys2);
};
assert.doesNotHaveAnyDeepKeys = function(obj, keys2, msg) {
  new Assertion(
    obj,
    msg,
    assert.doesNotHaveAnyDeepKeys,
    true
  ).to.not.have.any.deep.keys(keys2);
};
assert.doesNotHaveAllDeepKeys = function(obj, keys2, msg) {
  new Assertion(
    obj,
    msg,
    assert.doesNotHaveAllDeepKeys,
    true
  ).to.not.have.all.deep.keys(keys2);
};
assert.throws = function(fn3, errorLike, errMsgMatcher, msg) {
  if ("string" === typeof errorLike || errorLike instanceof RegExp) {
    errMsgMatcher = errorLike;
    errorLike = null;
  }
  let assertErr = new Assertion(fn3, msg, assert.throws, true).to.throw(
    errorLike,
    errMsgMatcher
  );
  return flag(assertErr, "object");
};
assert.doesNotThrow = function(fn3, errorLike, errMsgMatcher, message) {
  if ("string" === typeof errorLike || errorLike instanceof RegExp) {
    errMsgMatcher = errorLike;
    errorLike = null;
  }
  new Assertion(fn3, message, assert.doesNotThrow, true).to.not.throw(
    errorLike,
    errMsgMatcher
  );
};
assert.operator = function(val, operator, val2, msg) {
  let ok;
  switch (operator) {
    case "==":
      ok = val == val2;
      break;
    case "===":
      ok = val === val2;
      break;
    case ">":
      ok = val > val2;
      break;
    case ">=":
      ok = val >= val2;
      break;
    case "<":
      ok = val < val2;
      break;
    case "<=":
      ok = val <= val2;
      break;
    case "!=":
      ok = val != val2;
      break;
    case "!==":
      ok = val !== val2;
      break;
    default:
      msg = msg ? msg + ": " : msg;
      throw new AssertionError(
        msg + 'Invalid operator "' + operator + '"',
        void 0,
        assert.operator
      );
  }
  let test2 = new Assertion(ok, msg, assert.operator, true);
  test2.assert(
    true === flag(test2, "object"),
    "expected " + inspect2(val) + " to be " + operator + " " + inspect2(val2),
    "expected " + inspect2(val) + " to not be " + operator + " " + inspect2(val2)
  );
};
assert.closeTo = function(act, exp, delta, msg) {
  new Assertion(act, msg, assert.closeTo, true).to.be.closeTo(exp, delta);
};
assert.approximately = function(act, exp, delta, msg) {
  new Assertion(act, msg, assert.approximately, true).to.be.approximately(
    exp,
    delta
  );
};
assert.sameMembers = function(set1, set2, msg) {
  new Assertion(set1, msg, assert.sameMembers, true).to.have.same.members(set2);
};
assert.notSameMembers = function(set1, set2, msg) {
  new Assertion(
    set1,
    msg,
    assert.notSameMembers,
    true
  ).to.not.have.same.members(set2);
};
assert.sameDeepMembers = function(set1, set2, msg) {
  new Assertion(
    set1,
    msg,
    assert.sameDeepMembers,
    true
  ).to.have.same.deep.members(set2);
};
assert.notSameDeepMembers = function(set1, set2, msg) {
  new Assertion(
    set1,
    msg,
    assert.notSameDeepMembers,
    true
  ).to.not.have.same.deep.members(set2);
};
assert.sameOrderedMembers = function(set1, set2, msg) {
  new Assertion(
    set1,
    msg,
    assert.sameOrderedMembers,
    true
  ).to.have.same.ordered.members(set2);
};
assert.notSameOrderedMembers = function(set1, set2, msg) {
  new Assertion(
    set1,
    msg,
    assert.notSameOrderedMembers,
    true
  ).to.not.have.same.ordered.members(set2);
};
assert.sameDeepOrderedMembers = function(set1, set2, msg) {
  new Assertion(
    set1,
    msg,
    assert.sameDeepOrderedMembers,
    true
  ).to.have.same.deep.ordered.members(set2);
};
assert.notSameDeepOrderedMembers = function(set1, set2, msg) {
  new Assertion(
    set1,
    msg,
    assert.notSameDeepOrderedMembers,
    true
  ).to.not.have.same.deep.ordered.members(set2);
};
assert.includeMembers = function(superset, subset, msg) {
  new Assertion(superset, msg, assert.includeMembers, true).to.include.members(
    subset
  );
};
assert.notIncludeMembers = function(superset, subset, msg) {
  new Assertion(
    superset,
    msg,
    assert.notIncludeMembers,
    true
  ).to.not.include.members(subset);
};
assert.includeDeepMembers = function(superset, subset, msg) {
  new Assertion(
    superset,
    msg,
    assert.includeDeepMembers,
    true
  ).to.include.deep.members(subset);
};
assert.notIncludeDeepMembers = function(superset, subset, msg) {
  new Assertion(
    superset,
    msg,
    assert.notIncludeDeepMembers,
    true
  ).to.not.include.deep.members(subset);
};
assert.includeOrderedMembers = function(superset, subset, msg) {
  new Assertion(
    superset,
    msg,
    assert.includeOrderedMembers,
    true
  ).to.include.ordered.members(subset);
};
assert.notIncludeOrderedMembers = function(superset, subset, msg) {
  new Assertion(
    superset,
    msg,
    assert.notIncludeOrderedMembers,
    true
  ).to.not.include.ordered.members(subset);
};
assert.includeDeepOrderedMembers = function(superset, subset, msg) {
  new Assertion(
    superset,
    msg,
    assert.includeDeepOrderedMembers,
    true
  ).to.include.deep.ordered.members(subset);
};
assert.notIncludeDeepOrderedMembers = function(superset, subset, msg) {
  new Assertion(
    superset,
    msg,
    assert.notIncludeDeepOrderedMembers,
    true
  ).to.not.include.deep.ordered.members(subset);
};
assert.oneOf = function(inList, list, msg) {
  new Assertion(inList, msg, assert.oneOf, true).to.be.oneOf(list);
};
assert.isIterable = function(obj, msg) {
  if (obj == void 0 || !obj[Symbol.iterator]) {
    msg = msg ? `${msg} expected ${inspect2(obj)} to be an iterable` : `expected ${inspect2(obj)} to be an iterable`;
    throw new AssertionError(msg, void 0, assert.isIterable);
  }
};
assert.changes = function(fn3, obj, prop, msg) {
  if (arguments.length === 3 && typeof obj === "function") {
    msg = prop;
    prop = null;
  }
  new Assertion(fn3, msg, assert.changes, true).to.change(obj, prop);
};
assert.changesBy = function(fn3, obj, prop, delta, msg) {
  if (arguments.length === 4 && typeof obj === "function") {
    let tmpMsg = delta;
    delta = prop;
    msg = tmpMsg;
  } else if (arguments.length === 3) {
    delta = prop;
    prop = null;
  }
  new Assertion(fn3, msg, assert.changesBy, true).to.change(obj, prop).by(delta);
};
assert.doesNotChange = function(fn3, obj, prop, msg) {
  if (arguments.length === 3 && typeof obj === "function") {
    msg = prop;
    prop = null;
  }
  return new Assertion(fn3, msg, assert.doesNotChange, true).to.not.change(
    obj,
    prop
  );
};
assert.changesButNotBy = function(fn3, obj, prop, delta, msg) {
  if (arguments.length === 4 && typeof obj === "function") {
    let tmpMsg = delta;
    delta = prop;
    msg = tmpMsg;
  } else if (arguments.length === 3) {
    delta = prop;
    prop = null;
  }
  new Assertion(fn3, msg, assert.changesButNotBy, true).to.change(obj, prop).but.not.by(delta);
};
assert.increases = function(fn3, obj, prop, msg) {
  if (arguments.length === 3 && typeof obj === "function") {
    msg = prop;
    prop = null;
  }
  return new Assertion(fn3, msg, assert.increases, true).to.increase(obj, prop);
};
assert.increasesBy = function(fn3, obj, prop, delta, msg) {
  if (arguments.length === 4 && typeof obj === "function") {
    let tmpMsg = delta;
    delta = prop;
    msg = tmpMsg;
  } else if (arguments.length === 3) {
    delta = prop;
    prop = null;
  }
  new Assertion(fn3, msg, assert.increasesBy, true).to.increase(obj, prop).by(delta);
};
assert.doesNotIncrease = function(fn3, obj, prop, msg) {
  if (arguments.length === 3 && typeof obj === "function") {
    msg = prop;
    prop = null;
  }
  return new Assertion(fn3, msg, assert.doesNotIncrease, true).to.not.increase(
    obj,
    prop
  );
};
assert.increasesButNotBy = function(fn3, obj, prop, delta, msg) {
  if (arguments.length === 4 && typeof obj === "function") {
    let tmpMsg = delta;
    delta = prop;
    msg = tmpMsg;
  } else if (arguments.length === 3) {
    delta = prop;
    prop = null;
  }
  new Assertion(fn3, msg, assert.increasesButNotBy, true).to.increase(obj, prop).but.not.by(delta);
};
assert.decreases = function(fn3, obj, prop, msg) {
  if (arguments.length === 3 && typeof obj === "function") {
    msg = prop;
    prop = null;
  }
  return new Assertion(fn3, msg, assert.decreases, true).to.decrease(obj, prop);
};
assert.decreasesBy = function(fn3, obj, prop, delta, msg) {
  if (arguments.length === 4 && typeof obj === "function") {
    let tmpMsg = delta;
    delta = prop;
    msg = tmpMsg;
  } else if (arguments.length === 3) {
    delta = prop;
    prop = null;
  }
  new Assertion(fn3, msg, assert.decreasesBy, true).to.decrease(obj, prop).by(delta);
};
assert.doesNotDecrease = function(fn3, obj, prop, msg) {
  if (arguments.length === 3 && typeof obj === "function") {
    msg = prop;
    prop = null;
  }
  return new Assertion(fn3, msg, assert.doesNotDecrease, true).to.not.decrease(
    obj,
    prop
  );
};
assert.doesNotDecreaseBy = function(fn3, obj, prop, delta, msg) {
  if (arguments.length === 4 && typeof obj === "function") {
    let tmpMsg = delta;
    delta = prop;
    msg = tmpMsg;
  } else if (arguments.length === 3) {
    delta = prop;
    prop = null;
  }
  return new Assertion(fn3, msg, assert.doesNotDecreaseBy, true).to.not.decrease(obj, prop).by(delta);
};
assert.decreasesButNotBy = function(fn3, obj, prop, delta, msg) {
  if (arguments.length === 4 && typeof obj === "function") {
    let tmpMsg = delta;
    delta = prop;
    msg = tmpMsg;
  } else if (arguments.length === 3) {
    delta = prop;
    prop = null;
  }
  new Assertion(fn3, msg, assert.decreasesButNotBy, true).to.decrease(obj, prop).but.not.by(delta);
};
assert.ifError = function(val) {
  if (val) {
    throw val;
  }
};
assert.isExtensible = function(obj, msg) {
  new Assertion(obj, msg, assert.isExtensible, true).to.be.extensible;
};
assert.isNotExtensible = function(obj, msg) {
  new Assertion(obj, msg, assert.isNotExtensible, true).to.not.be.extensible;
};
assert.isSealed = function(obj, msg) {
  new Assertion(obj, msg, assert.isSealed, true).to.be.sealed;
};
assert.isNotSealed = function(obj, msg) {
  new Assertion(obj, msg, assert.isNotSealed, true).to.not.be.sealed;
};
assert.isFrozen = function(obj, msg) {
  new Assertion(obj, msg, assert.isFrozen, true).to.be.frozen;
};
assert.isNotFrozen = function(obj, msg) {
  new Assertion(obj, msg, assert.isNotFrozen, true).to.not.be.frozen;
};
assert.isEmpty = function(val, msg) {
  new Assertion(val, msg, assert.isEmpty, true).to.be.empty;
};
assert.isNotEmpty = function(val, msg) {
  new Assertion(val, msg, assert.isNotEmpty, true).to.not.be.empty;
};
assert.containsSubset = function(val, exp, msg) {
  new Assertion(val, msg).to.containSubset(exp);
};
assert.doesNotContainSubset = function(val, exp, msg) {
  new Assertion(val, msg).to.not.containSubset(exp);
};
var aliases = [
  ["isOk", "ok"],
  ["isNotOk", "notOk"],
  ["throws", "throw"],
  ["throws", "Throw"],
  ["isExtensible", "extensible"],
  ["isNotExtensible", "notExtensible"],
  ["isSealed", "sealed"],
  ["isNotSealed", "notSealed"],
  ["isFrozen", "frozen"],
  ["isNotFrozen", "notFrozen"],
  ["isEmpty", "empty"],
  ["isNotEmpty", "notEmpty"],
  ["isCallable", "isFunction"],
  ["isNotCallable", "isNotFunction"],
  ["containsSubset", "containSubset"]
];
for (const [name, as] of aliases) {
  assert[as] = assert[name];
}
var used = [];
function use(fn3) {
  const exports = {
    use,
    AssertionError,
    util: utils_exports,
    config,
    expect,
    assert,
    Assertion,
    ...should_exports
  };
  if (!~used.indexOf(fn3)) {
    fn3(exports, utils_exports);
    used.push(fn3);
  }
  return exports;
}
__name(use, "use");
__name2(use, "use");

// ../node_modules/@testing-library/jest-dom/dist/matchers.mjs
var matchers_exports = {};
__export(matchers_exports, {
  toAppearAfter: () => toAppearAfter,
  toAppearBefore: () => toAppearBefore,
  toBeChecked: () => toBeChecked,
  toBeDisabled: () => toBeDisabled,
  toBeEmpty: () => toBeEmpty,
  toBeEmptyDOMElement: () => toBeEmptyDOMElement,
  toBeEnabled: () => toBeEnabled,
  toBeInTheDOM: () => toBeInTheDOM,
  toBeInTheDocument: () => toBeInTheDocument,
  toBeInvalid: () => toBeInvalid,
  toBePartiallyChecked: () => toBePartiallyChecked,
  toBePartiallyPressed: () => toBePartiallyPressed,
  toBePressed: () => toBePressed,
  toBeRequired: () => toBeRequired,
  toBeValid: () => toBeValid,
  toBeVisible: () => toBeVisible,
  toContainElement: () => toContainElement,
  toContainHTML: () => toContainHTML,
  toHaveAccessibleDescription: () => toHaveAccessibleDescription,
  toHaveAccessibleErrorMessage: () => toHaveAccessibleErrorMessage,
  toHaveAccessibleName: () => toHaveAccessibleName,
  toHaveAttribute: () => toHaveAttribute,
  toHaveClass: () => toHaveClass,
  toHaveDescription: () => toHaveDescription,
  toHaveDisplayValue: () => toHaveDisplayValue,
  toHaveErrorMessage: () => toHaveErrorMessage,
  toHaveFocus: () => toHaveFocus,
  toHaveFormValues: () => toHaveFormValues,
  toHaveRole: () => toHaveRole,
  toHaveSelection: () => toHaveSelection,
  toHaveStyle: () => toHaveStyle,
  toHaveTextContent: () => toHaveTextContent,
  toHaveValue: () => toHaveValue
});

// ../node_modules/@testing-library/jest-dom/dist/matchers-35e4d3bd.mjs
var import_redent = __toESM(require_redent(), 1);

// ../node_modules/@adobe/css-tools/dist/esm/adobe-css-tools.mjs
var _t = class _t extends Error {
  reason;
  filename;
  line;
  column;
  source;
  constructor(t2, e2, i2, s3, n2) {
    super(`${t2}:${i2}:${s3}: ${e2}`), this.reason = e2, this.filename = t2, this.line = i2, this.column = s3, this.source = n2;
  }
};
__name(_t, "t");
var t = _t;
var _e = class _e {
  start;
  end;
  source;
  constructor(t2, e2, i2) {
    this.start = t2, this.end = e2, this.source = i2;
  }
};
__name(_e, "e");
var e = _e;
var i;
!function(t2) {
  t2.stylesheet = "stylesheet", t2.rule = "rule", t2.declaration = "declaration", t2.comment = "comment", t2.container = "container", t2.charset = "charset", t2.document = "document", t2.customMedia = "custom-media", t2.fontFace = "font-face", t2.host = "host", t2.import = "import", t2.keyframes = "keyframes", t2.keyframe = "keyframe", t2.layer = "layer", t2.media = "media", t2.namespace = "namespace", t2.page = "page", t2.startingStyle = "starting-style", t2.supports = "supports";
}(i || (i = {}));
var s2 = /* @__PURE__ */ __name((t2, e2, i2) => {
  let s3 = i2, n2 = 1e4;
  do {
    const i3 = e2.map((e3) => t2.indexOf(e3, s3));
    i3.push(t2.indexOf("\\", s3));
    const r2 = i3.filter((t3) => -1 !== t3);
    if (0 === r2.length) return -1;
    const o2 = Math.min(...r2);
    if ("\\" !== t2[o2]) return o2;
    s3 = o2 + 2, n2--;
  } while (n2 > 0);
  throw new Error("Too many escaping");
}, "s");
var n = /* @__PURE__ */ __name((t2, e2, i2) => {
  let r2 = i2, o2 = 1e4;
  do {
    const i3 = e2.map((e3) => t2.indexOf(e3, r2));
    i3.push(t2.indexOf("(", r2)), i3.push(t2.indexOf('"', r2)), i3.push(t2.indexOf("'", r2)), i3.push(t2.indexOf("\\", r2));
    const c2 = i3.filter((t3) => -1 !== t3);
    if (0 === c2.length) return -1;
    const a = Math.min(...c2);
    switch (t2[a]) {
      case "\\":
        r2 = a + 2;
        break;
      case "(":
        {
          const e3 = n(t2, [")"], a + 1);
          if (-1 === e3) return -1;
          r2 = e3 + 1;
        }
        break;
      case '"':
        {
          const e3 = s2(t2, ['"'], a + 1);
          if (-1 === e3) return -1;
          r2 = e3 + 1;
        }
        break;
      case "'":
        {
          const e3 = s2(t2, ["'"], a + 1);
          if (-1 === e3) return -1;
          r2 = e3 + 1;
        }
        break;
      default:
        return a;
    }
    o2--;
  } while (o2 > 0);
  throw new Error("Too many escaping");
}, "n");
var r = /\/\*[^]*?(?:\*\/|$)/g;
function o(t2) {
  return t2 ? t2.trim() : "";
}
__name(o, "o");
function c(t2, e2) {
  const i2 = t2 && "string" == typeof t2.type, s3 = i2 ? t2 : e2;
  for (const e3 in t2) {
    const i3 = t2[e3];
    Array.isArray(i3) ? i3.forEach((t3) => {
      c(t3, s3);
    }) : i3 && "object" == typeof i3 && c(i3, s3);
  }
  return i2 && Object.defineProperty(t2, "parent", { configurable: true, writable: true, enumerable: false, value: e2 || null }), t2;
}
__name(c, "c");
var m = /* @__PURE__ */ __name((s3, a) => {
  a = a || {};
  let m2 = 1, h2 = 1;
  function u3() {
    const t2 = { line: m2, column: h2 };
    return (i2) => (i2.position = new e(t2, { line: m2, column: h2 }, a?.source || ""), $(), i2);
  }
  __name(u3, "u");
  const p = [];
  function l2(e2) {
    const i2 = new t(a?.source || "", e2, m2, h2, s3);
    if (!a?.silent) throw i2;
    p.push(i2);
  }
  __name(l2, "l");
  function f3() {
    const t2 = /^{\s*/.exec(s3);
    return !!t2 && (g2(t2), true);
  }
  __name(f3, "f");
  function d() {
    const t2 = /^}/.exec(s3);
    return !!t2 && (g2(t2), true);
  }
  __name(d, "d");
  function y2() {
    let t2;
    const e2 = [];
    for ($(), x2(e2); s3.length && "}" !== s3.charAt(0) && (t2 = A() || S2(), t2); ) e2.push(t2), x2(e2);
    return e2;
  }
  __name(y2, "y");
  function g2(t2) {
    const e2 = t2[0];
    return function(t3) {
      const e3 = t3.match(/\n/g);
      e3 && (m2 += e3.length);
      const i2 = t3.lastIndexOf("\n");
      h2 = ~i2 ? t3.length - i2 : h2 + t3.length;
    }(e2), s3 = s3.slice(e2.length), t2;
  }
  __name(g2, "g");
  function $() {
    const t2 = /^\s*/.exec(s3);
    t2 && g2(t2);
  }
  __name($, "$");
  function x2(t2) {
    t2 = t2 || [];
    let e2 = V();
    for (; e2; ) t2.push(e2), e2 = V();
    return t2;
  }
  __name(x2, "x");
  function V() {
    const t2 = u3();
    if ("/" !== s3.charAt(0) || "*" !== s3.charAt(1)) return;
    const e2 = /^\/\*[^]*?\*\//.exec(s3);
    return e2 ? (g2(e2), t2({ type: i.comment, comment: e2[0].slice(2, -2) })) : l2("End of comment missing");
  }
  __name(V, "V");
  function k2() {
    const t2 = /^([^{]+)/.exec(s3);
    if (!t2) return;
    g2(t2);
    return ((t3, e2) => {
      const i2 = [];
      let s4 = 0;
      for (; s4 < t3.length; ) {
        const r2 = n(t3, e2, s4);
        if (-1 === r2) return i2.push(t3.substring(s4)), i2;
        i2.push(t3.substring(s4, r2)), s4 = r2 + 1;
      }
      return i2;
    })(o(t2[0]).replace(r, ""), [","]).map((t3) => o(t3));
  }
  __name(k2, "k");
  function v2() {
    const t2 = u3(), e2 = /^(\*?[-#/*\\\w]+(\[[0-9a-z_-]+\])?)\s*/.exec(s3);
    if (!e2) return;
    g2(e2);
    const c2 = o(e2[0]), a2 = /^:\s*/.exec(s3);
    if (!a2) return l2("property missing ':'");
    g2(a2);
    let m3 = "";
    const h3 = n(s3, [";", "}"]);
    if (-1 !== h3) {
      m3 = s3.substring(0, h3);
      g2([m3]), m3 = o(m3).replace(r, "");
    }
    const p2 = t2({ type: i.declaration, property: c2.replace(r, ""), value: m3 }), f4 = /^[;\s]*/.exec(s3);
    return f4 && g2(f4), p2;
  }
  __name(v2, "v");
  function w2() {
    const t2 = [];
    if (!f3()) return l2("missing '{'");
    x2(t2);
    let e2 = v2();
    for (; e2; ) t2.push(e2), x2(t2), e2 = v2();
    return d() ? t2 : l2("missing '}'");
  }
  __name(w2, "w");
  function b2() {
    const t2 = [], e2 = u3();
    let n2 = /^((\d+\.\d+|\.\d+|\d+)%?|[a-z]+)\s*/.exec(s3);
    for (; n2; ) {
      const e3 = g2(n2);
      t2.push(e3[1]);
      const i2 = /^,\s*/.exec(s3);
      i2 && g2(i2), n2 = /^((\d+\.\d+|\.\d+|\d+)%?|[a-z]+)\s*/.exec(s3);
    }
    if (t2.length) return e2({ type: i.keyframe, values: t2, declarations: w2() || [] });
  }
  __name(b2, "b");
  const j2 = M2("import"), O = M2("charset"), E2 = M2("namespace");
  function M2(t2) {
    const e2 = new RegExp("^@" + t2 + `\\s*((?::?[^;'"]|"(?:\\\\"|[^"])*?"|'(?:\\\\'|[^'])*?')+)(?:;|$)`);
    return () => {
      const i2 = u3(), n2 = e2.exec(s3);
      if (!n2) return;
      const r2 = g2(n2), o2 = { type: t2 };
      return o2[t2] = r2[1].trim(), i2(o2);
    };
  }
  __name(M2, "M");
  function A() {
    if ("@" === s3[0]) return function() {
      const t2 = u3(), e2 = /^@([-\w]+)?keyframes\s*/.exec(s3);
      if (!e2) return;
      const n2 = g2(e2)[1], r2 = /^([-\w]+)\s*/.exec(s3);
      if (!r2) return l2("@keyframes missing name");
      const o2 = g2(r2)[1];
      if (!f3()) return l2("@keyframes missing '{'");
      let c2 = x2(), a2 = b2();
      for (; a2; ) c2.push(a2), c2 = c2.concat(x2()), a2 = b2();
      return d() ? t2({ type: i.keyframes, name: o2, vendor: n2, keyframes: c2 }) : l2("@keyframes missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@media *([^{]+)/.exec(s3);
      if (!e2) return;
      const n2 = o(g2(e2)[1]);
      if (!f3()) return l2("@media missing '{'");
      const r2 = x2().concat(y2());
      return d() ? t2({ type: i.media, media: n2, rules: r2 }) : l2("@media missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@custom-media\s+(--\S+)\s+([^{;\s][^{;]*);/.exec(s3);
      if (!e2) return;
      const n2 = g2(e2);
      return t2({ type: i.customMedia, name: o(n2[1]), media: o(n2[2]) });
    }() || function() {
      const t2 = u3(), e2 = /^@supports *([^{]+)/.exec(s3);
      if (!e2) return;
      const n2 = o(g2(e2)[1]);
      if (!f3()) return l2("@supports missing '{'");
      const r2 = x2().concat(y2());
      return d() ? t2({ type: i.supports, supports: n2, rules: r2 }) : l2("@supports missing '}'");
    }() || j2() || O() || E2() || function() {
      const t2 = u3(), e2 = /^@([-\w]+)?document *([^{]+)/.exec(s3);
      if (!e2) return;
      const n2 = g2(e2), r2 = o(n2[1]), c2 = o(n2[2]);
      if (!f3()) return l2("@document missing '{'");
      const a2 = x2().concat(y2());
      return d() ? t2({ type: i.document, document: c2, vendor: r2, rules: a2 }) : l2("@document missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@page */.exec(s3);
      if (!e2) return;
      g2(e2);
      const n2 = k2() || [];
      if (!f3()) return l2("@page missing '{'");
      let r2 = x2(), o2 = v2();
      for (; o2; ) r2.push(o2), r2 = r2.concat(x2()), o2 = v2();
      return d() ? t2({ type: i.page, selectors: n2, declarations: r2 }) : l2("@page missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@host\s*/.exec(s3);
      if (!e2) return;
      if (g2(e2), !f3()) return l2("@host missing '{'");
      const n2 = x2().concat(y2());
      return d() ? t2({ type: i.host, rules: n2 }) : l2("@host missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@font-face\s*/.exec(s3);
      if (!e2) return;
      if (g2(e2), !f3()) return l2("@font-face missing '{'");
      let n2 = x2(), r2 = v2();
      for (; r2; ) n2.push(r2), n2 = n2.concat(x2()), r2 = v2();
      return d() ? t2({ type: i.fontFace, declarations: n2 }) : l2("@font-face missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@container *([^{]+)/.exec(s3);
      if (!e2) return;
      const n2 = o(g2(e2)[1]);
      if (!f3()) return l2("@container missing '{'");
      const r2 = x2().concat(y2());
      return d() ? t2({ type: i.container, container: n2, rules: r2 }) : l2("@container missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@starting-style\s*/.exec(s3);
      if (!e2) return;
      if (g2(e2), !f3()) return l2("@starting-style missing '{'");
      const n2 = x2().concat(y2());
      return d() ? t2({ type: i.startingStyle, rules: n2 }) : l2("@starting-style missing '}'");
    }() || function() {
      const t2 = u3(), e2 = /^@layer *([^{;@]+)/.exec(s3);
      if (!e2) return;
      const n2 = o(g2(e2)[1]);
      if (!f3()) {
        const e3 = /^[;\s]*/.exec(s3);
        return e3 && g2(e3), t2({ type: i.layer, layer: n2 });
      }
      const r2 = x2().concat(y2());
      return d() ? t2({ type: i.layer, layer: n2, rules: r2 }) : l2("@layer missing '}'");
    }();
  }
  __name(A, "A");
  function S2() {
    const t2 = u3(), e2 = k2();
    return e2 ? (x2(), t2({ type: i.rule, selectors: e2, declarations: w2() || [] })) : l2("selector missing");
  }
  __name(S2, "S");
  return c(function() {
    const t2 = y2();
    return { type: i.stylesheet, stylesheet: { source: a?.source, rules: t2, parsingErrors: p } };
  }());
}, "m");

// ../node_modules/@testing-library/jest-dom/node_modules/dom-accessibility-api/dist/polyfills/array.from.mjs
var toStr = Object.prototype.toString;
function isCallable(fn3) {
  return typeof fn3 === "function" || toStr.call(fn3) === "[object Function]";
}
__name(isCallable, "isCallable");
function toInteger(value) {
  var number = Number(value);
  if (isNaN(number)) {
    return 0;
  }
  if (number === 0 || !isFinite(number)) {
    return number;
  }
  return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
}
__name(toInteger, "toInteger");
var maxSafeInteger = Math.pow(2, 53) - 1;
function toLength(value) {
  var len = toInteger(value);
  return Math.min(Math.max(len, 0), maxSafeInteger);
}
__name(toLength, "toLength");
function arrayFrom(arrayLike, mapFn) {
  var C = Array;
  var items = Object(arrayLike);
  if (arrayLike == null) {
    throw new TypeError("Array.from requires an array-like object - not null or undefined");
  }
  if (typeof mapFn !== "undefined") {
    if (!isCallable(mapFn)) {
      throw new TypeError("Array.from: when provided, the second argument must be a function");
    }
  }
  var len = toLength(items.length);
  var A = isCallable(C) ? Object(new C(len)) : new Array(len);
  var k2 = 0;
  var kValue;
  while (k2 < len) {
    kValue = items[k2];
    if (mapFn) {
      A[k2] = mapFn(kValue, k2);
    } else {
      A[k2] = kValue;
    }
    k2 += 1;
  }
  A.length = len;
  return A;
}
__name(arrayFrom, "arrayFrom");

// ../node_modules/@testing-library/jest-dom/node_modules/dom-accessibility-api/dist/polyfills/SetLike.mjs
function _typeof(o2) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(o3) {
    return typeof o3;
  } : function(o3) {
    return o3 && "function" == typeof Symbol && o3.constructor === Symbol && o3 !== Symbol.prototype ? "symbol" : typeof o3;
  }, _typeof(o2);
}
__name(_typeof, "_typeof");
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
__name(_classCallCheck, "_classCallCheck");
function _defineProperties(target, props) {
  for (var i2 = 0; i2 < props.length; i2++) {
    var descriptor = props[i2];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
__name(_defineProperties, "_defineProperties");
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", { writable: false });
  return Constructor;
}
__name(_createClass, "_createClass");
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_defineProperty, "_defineProperty");
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
__name(_toPropertyKey, "_toPropertyKey");
function _toPrimitive(input2, hint) {
  if (_typeof(input2) !== "object" || input2 === null) return input2;
  var prim = input2[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input2, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input2);
}
__name(_toPrimitive, "_toPrimitive");
var SetLike = function() {
  function SetLike3() {
    var items = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : [];
    _classCallCheck(this, SetLike3);
    _defineProperty(this, "items", void 0);
    this.items = items;
  }
  __name(SetLike3, "SetLike");
  _createClass(SetLike3, [{
    key: "add",
    value: /* @__PURE__ */ __name(function add(value) {
      if (this.has(value) === false) {
        this.items.push(value);
      }
      return this;
    }, "add")
  }, {
    key: "clear",
    value: /* @__PURE__ */ __name(function clear3() {
      this.items = [];
    }, "clear")
  }, {
    key: "delete",
    value: /* @__PURE__ */ __name(function _delete(value) {
      var previousLength = this.items.length;
      this.items = this.items.filter(function(item) {
        return item !== value;
      });
      return previousLength !== this.items.length;
    }, "_delete")
  }, {
    key: "forEach",
    value: /* @__PURE__ */ __name(function forEach(callbackfn) {
      var _this = this;
      this.items.forEach(function(item) {
        callbackfn(item, item, _this);
      });
    }, "forEach")
  }, {
    key: "has",
    value: /* @__PURE__ */ __name(function has(value) {
      return this.items.indexOf(value) !== -1;
    }, "has")
  }, {
    key: "size",
    get: /* @__PURE__ */ __name(function get2() {
      return this.items.length;
    }, "get")
  }]);
  return SetLike3;
}();
var SetLike_default = typeof Set === "undefined" ? Set : SetLike;

// ../node_modules/@testing-library/jest-dom/node_modules/dom-accessibility-api/dist/getRole.mjs
function getLocalName(element) {
  var _element$localName;
  return (
    // eslint-disable-next-line no-restricted-properties -- actual guard for environments without localName
    (_element$localName = element.localName) !== null && _element$localName !== void 0 ? _element$localName : (
      // eslint-disable-next-line no-restricted-properties -- required for the fallback
      element.tagName.toLowerCase()
    )
  );
}
__name(getLocalName, "getLocalName");
var localNameToRoleMappings = {
  article: "article",
  aside: "complementary",
  button: "button",
  datalist: "listbox",
  dd: "definition",
  details: "group",
  dialog: "dialog",
  dt: "term",
  fieldset: "group",
  figure: "figure",
  // WARNING: Only with an accessible name
  form: "form",
  footer: "contentinfo",
  h1: "heading",
  h2: "heading",
  h3: "heading",
  h4: "heading",
  h5: "heading",
  h6: "heading",
  header: "banner",
  hr: "separator",
  html: "document",
  legend: "legend",
  li: "listitem",
  math: "math",
  main: "main",
  menu: "list",
  nav: "navigation",
  ol: "list",
  optgroup: "group",
  // WARNING: Only in certain context
  option: "option",
  output: "status",
  progress: "progressbar",
  // WARNING: Only with an accessible name
  section: "region",
  summary: "button",
  table: "table",
  tbody: "rowgroup",
  textarea: "textbox",
  tfoot: "rowgroup",
  // WARNING: Only in certain context
  td: "cell",
  th: "columnheader",
  thead: "rowgroup",
  tr: "row",
  ul: "list"
};
var prohibitedAttributes = {
  caption: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  code: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  deletion: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  emphasis: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  generic: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby", "aria-roledescription"]),
  insertion: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  none: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  paragraph: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  presentation: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  strong: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  subscript: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  superscript: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"])
};
function hasGlobalAriaAttributes(element, role) {
  return [
    "aria-atomic",
    "aria-busy",
    "aria-controls",
    "aria-current",
    "aria-description",
    "aria-describedby",
    "aria-details",
    // "disabled",
    "aria-dropeffect",
    // "errormessage",
    "aria-flowto",
    "aria-grabbed",
    // "haspopup",
    "aria-hidden",
    // "invalid",
    "aria-keyshortcuts",
    "aria-label",
    "aria-labelledby",
    "aria-live",
    "aria-owns",
    "aria-relevant",
    "aria-roledescription"
  ].some(function(attributeName) {
    var _prohibitedAttributes;
    return element.hasAttribute(attributeName) && !((_prohibitedAttributes = prohibitedAttributes[role]) !== null && _prohibitedAttributes !== void 0 && _prohibitedAttributes.has(attributeName));
  });
}
__name(hasGlobalAriaAttributes, "hasGlobalAriaAttributes");
function ignorePresentationalRole(element, implicitRole) {
  return hasGlobalAriaAttributes(element, implicitRole);
}
__name(ignorePresentationalRole, "ignorePresentationalRole");
function getRole(element) {
  var explicitRole = getExplicitRole(element);
  if (explicitRole === null || presentationRoles.indexOf(explicitRole) !== -1) {
    var implicitRole = getImplicitRole(element);
    if (presentationRoles.indexOf(explicitRole || "") === -1 || ignorePresentationalRole(element, implicitRole || "")) {
      return implicitRole;
    }
  }
  return explicitRole;
}
__name(getRole, "getRole");
function getImplicitRole(element) {
  var mappedByTag = localNameToRoleMappings[getLocalName(element)];
  if (mappedByTag !== void 0) {
    return mappedByTag;
  }
  switch (getLocalName(element)) {
    case "a":
    case "area":
    case "link":
      if (element.hasAttribute("href")) {
        return "link";
      }
      break;
    case "img":
      if (element.getAttribute("alt") === "" && !ignorePresentationalRole(element, "img")) {
        return "presentation";
      }
      return "img";
    case "input": {
      var _ref = element, type5 = _ref.type;
      switch (type5) {
        case "button":
        case "image":
        case "reset":
        case "submit":
          return "button";
        case "checkbox":
        case "radio":
          return type5;
        case "range":
          return "slider";
        case "email":
        case "tel":
        case "text":
        case "url":
          if (element.hasAttribute("list")) {
            return "combobox";
          }
          return "textbox";
        case "search":
          if (element.hasAttribute("list")) {
            return "combobox";
          }
          return "searchbox";
        case "number":
          return "spinbutton";
        default:
          return null;
      }
    }
    case "select":
      if (element.hasAttribute("multiple") || element.size > 1) {
        return "listbox";
      }
      return "combobox";
  }
  return null;
}
__name(getImplicitRole, "getImplicitRole");
function getExplicitRole(element) {
  var role = element.getAttribute("role");
  if (role !== null) {
    var explicitRole = role.trim().split(" ")[0];
    if (explicitRole.length > 0) {
      return explicitRole;
    }
  }
  return null;
}
__name(getExplicitRole, "getExplicitRole");

// ../node_modules/@testing-library/jest-dom/node_modules/dom-accessibility-api/dist/util.mjs
var presentationRoles = ["presentation", "none"];
function isElement(node) {
  return node !== null && node.nodeType === node.ELEMENT_NODE;
}
__name(isElement, "isElement");
function isHTMLTableCaptionElement(node) {
  return isElement(node) && getLocalName(node) === "caption";
}
__name(isHTMLTableCaptionElement, "isHTMLTableCaptionElement");
function isHTMLInputElement(node) {
  return isElement(node) && getLocalName(node) === "input";
}
__name(isHTMLInputElement, "isHTMLInputElement");
function isHTMLOptGroupElement(node) {
  return isElement(node) && getLocalName(node) === "optgroup";
}
__name(isHTMLOptGroupElement, "isHTMLOptGroupElement");
function isHTMLSelectElement(node) {
  return isElement(node) && getLocalName(node) === "select";
}
__name(isHTMLSelectElement, "isHTMLSelectElement");
function isHTMLTableElement(node) {
  return isElement(node) && getLocalName(node) === "table";
}
__name(isHTMLTableElement, "isHTMLTableElement");
function isHTMLTextAreaElement(node) {
  return isElement(node) && getLocalName(node) === "textarea";
}
__name(isHTMLTextAreaElement, "isHTMLTextAreaElement");
function safeWindow(node) {
  var _ref = node.ownerDocument === null ? node : node.ownerDocument, defaultView = _ref.defaultView;
  if (defaultView === null) {
    throw new TypeError("no window available");
  }
  return defaultView;
}
__name(safeWindow, "safeWindow");
function isHTMLFieldSetElement(node) {
  return isElement(node) && getLocalName(node) === "fieldset";
}
__name(isHTMLFieldSetElement, "isHTMLFieldSetElement");
function isHTMLLegendElement(node) {
  return isElement(node) && getLocalName(node) === "legend";
}
__name(isHTMLLegendElement, "isHTMLLegendElement");
function isHTMLSlotElement(node) {
  return isElement(node) && getLocalName(node) === "slot";
}
__name(isHTMLSlotElement, "isHTMLSlotElement");
function isSVGElement(node) {
  return isElement(node) && node.ownerSVGElement !== void 0;
}
__name(isSVGElement, "isSVGElement");
function isSVGSVGElement(node) {
  return isElement(node) && getLocalName(node) === "svg";
}
__name(isSVGSVGElement, "isSVGSVGElement");
function isSVGTitleElement(node) {
  return isSVGElement(node) && getLocalName(node) === "title";
}
__name(isSVGTitleElement, "isSVGTitleElement");
function queryIdRefs(node, attributeName) {
  if (isElement(node) && node.hasAttribute(attributeName)) {
    var ids = node.getAttribute(attributeName).split(" ");
    var root = node.getRootNode ? node.getRootNode() : node.ownerDocument;
    return ids.map(function(id) {
      return root.getElementById(id);
    }).filter(
      function(element) {
        return element !== null;
      }
      // TODO: why does this not narrow?
    );
  }
  return [];
}
__name(queryIdRefs, "queryIdRefs");
function hasAnyConcreteRoles(node, roles3) {
  if (isElement(node)) {
    return roles3.indexOf(getRole(node)) !== -1;
  }
  return false;
}
__name(hasAnyConcreteRoles, "hasAnyConcreteRoles");

// ../node_modules/@testing-library/jest-dom/node_modules/dom-accessibility-api/dist/accessible-name-and-description.mjs
function asFlatString(s3) {
  return s3.trim().replace(/\s\s+/g, " ");
}
__name(asFlatString, "asFlatString");
function isHidden(node, getComputedStyleImplementation) {
  if (!isElement(node)) {
    return false;
  }
  if (node.hasAttribute("hidden") || node.getAttribute("aria-hidden") === "true") {
    return true;
  }
  var style = getComputedStyleImplementation(node);
  return style.getPropertyValue("display") === "none" || style.getPropertyValue("visibility") === "hidden";
}
__name(isHidden, "isHidden");
function isControl(node) {
  return hasAnyConcreteRoles(node, ["button", "combobox", "listbox", "textbox"]) || hasAbstractRole(node, "range");
}
__name(isControl, "isControl");
function hasAbstractRole(node, role) {
  if (!isElement(node)) {
    return false;
  }
  switch (role) {
    case "range":
      return hasAnyConcreteRoles(node, ["meter", "progressbar", "scrollbar", "slider", "spinbutton"]);
    default:
      throw new TypeError("No knowledge about abstract role '".concat(role, "'. This is likely a bug :("));
  }
}
__name(hasAbstractRole, "hasAbstractRole");
function querySelectorAllSubtree(element, selectors) {
  var elements = arrayFrom(element.querySelectorAll(selectors));
  queryIdRefs(element, "aria-owns").forEach(function(root) {
    elements.push.apply(elements, arrayFrom(root.querySelectorAll(selectors)));
  });
  return elements;
}
__name(querySelectorAllSubtree, "querySelectorAllSubtree");
function querySelectedOptions(listbox) {
  if (isHTMLSelectElement(listbox)) {
    return listbox.selectedOptions || querySelectorAllSubtree(listbox, "[selected]");
  }
  return querySelectorAllSubtree(listbox, '[aria-selected="true"]');
}
__name(querySelectedOptions, "querySelectedOptions");
function isMarkedPresentational(node) {
  return hasAnyConcreteRoles(node, presentationRoles);
}
__name(isMarkedPresentational, "isMarkedPresentational");
function isNativeHostLanguageTextAlternativeElement(node) {
  return isHTMLTableCaptionElement(node);
}
__name(isNativeHostLanguageTextAlternativeElement, "isNativeHostLanguageTextAlternativeElement");
function allowsNameFromContent(node) {
  return hasAnyConcreteRoles(node, ["button", "cell", "checkbox", "columnheader", "gridcell", "heading", "label", "legend", "link", "menuitem", "menuitemcheckbox", "menuitemradio", "option", "radio", "row", "rowheader", "switch", "tab", "tooltip", "treeitem"]);
}
__name(allowsNameFromContent, "allowsNameFromContent");
function isDescendantOfNativeHostLanguageTextAlternativeElement(node) {
  return false;
}
__name(isDescendantOfNativeHostLanguageTextAlternativeElement, "isDescendantOfNativeHostLanguageTextAlternativeElement");
function getValueOfTextbox(element) {
  if (isHTMLInputElement(element) || isHTMLTextAreaElement(element)) {
    return element.value;
  }
  return element.textContent || "";
}
__name(getValueOfTextbox, "getValueOfTextbox");
function getTextualContent(declaration) {
  var content = declaration.getPropertyValue("content");
  if (/^["'].*["']$/.test(content)) {
    return content.slice(1, -1);
  }
  return "";
}
__name(getTextualContent, "getTextualContent");
function isLabelableElement(element) {
  var localName = getLocalName(element);
  return localName === "button" || localName === "input" && element.getAttribute("type") !== "hidden" || localName === "meter" || localName === "output" || localName === "progress" || localName === "select" || localName === "textarea";
}
__name(isLabelableElement, "isLabelableElement");
function findLabelableElement(element) {
  if (isLabelableElement(element)) {
    return element;
  }
  var labelableElement = null;
  element.childNodes.forEach(function(childNode) {
    if (labelableElement === null && isElement(childNode)) {
      var descendantLabelableElement = findLabelableElement(childNode);
      if (descendantLabelableElement !== null) {
        labelableElement = descendantLabelableElement;
      }
    }
  });
  return labelableElement;
}
__name(findLabelableElement, "findLabelableElement");
function getControlOfLabel(label) {
  if (label.control !== void 0) {
    return label.control;
  }
  var htmlFor = label.getAttribute("for");
  if (htmlFor !== null) {
    return label.ownerDocument.getElementById(htmlFor);
  }
  return findLabelableElement(label);
}
__name(getControlOfLabel, "getControlOfLabel");
function getLabels(element) {
  var labelsProperty = element.labels;
  if (labelsProperty === null) {
    return labelsProperty;
  }
  if (labelsProperty !== void 0) {
    return arrayFrom(labelsProperty);
  }
  if (!isLabelableElement(element)) {
    return null;
  }
  var document2 = element.ownerDocument;
  return arrayFrom(document2.querySelectorAll("label")).filter(function(label) {
    return getControlOfLabel(label) === element;
  });
}
__name(getLabels, "getLabels");
function getSlotContents(slot) {
  var assignedNodes = slot.assignedNodes();
  if (assignedNodes.length === 0) {
    return arrayFrom(slot.childNodes);
  }
  return assignedNodes;
}
__name(getSlotContents, "getSlotContents");
function computeTextAlternative(root) {
  var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var consultedNodes = new SetLike_default();
  var window2 = safeWindow(root);
  var _options$compute = options.compute, compute = _options$compute === void 0 ? "name" : _options$compute, _options$computedStyl = options.computedStyleSupportsPseudoElements, computedStyleSupportsPseudoElements = _options$computedStyl === void 0 ? options.getComputedStyle !== void 0 : _options$computedStyl, _options$getComputedS = options.getComputedStyle, getComputedStyle = _options$getComputedS === void 0 ? window2.getComputedStyle.bind(window2) : _options$getComputedS, _options$hidden = options.hidden, hidden = _options$hidden === void 0 ? false : _options$hidden;
  function computeMiscTextAlternative(node, context) {
    var accumulatedText = "";
    if (isElement(node) && computedStyleSupportsPseudoElements) {
      var pseudoBefore = getComputedStyle(node, "::before");
      var beforeContent = getTextualContent(pseudoBefore);
      accumulatedText = "".concat(beforeContent, " ").concat(accumulatedText);
    }
    var childNodes = isHTMLSlotElement(node) ? getSlotContents(node) : arrayFrom(node.childNodes).concat(queryIdRefs(node, "aria-owns"));
    childNodes.forEach(function(child) {
      var result = computeTextAlternative3(child, {
        isEmbeddedInLabel: context.isEmbeddedInLabel,
        isReferenced: false,
        recursion: true
      });
      var display2 = isElement(child) ? getComputedStyle(child).getPropertyValue("display") : "inline";
      var separator = display2 !== "inline" ? " " : "";
      accumulatedText += "".concat(separator).concat(result).concat(separator);
    });
    if (isElement(node) && computedStyleSupportsPseudoElements) {
      var pseudoAfter = getComputedStyle(node, "::after");
      var afterContent = getTextualContent(pseudoAfter);
      accumulatedText = "".concat(accumulatedText, " ").concat(afterContent);
    }
    return accumulatedText.trim();
  }
  __name(computeMiscTextAlternative, "computeMiscTextAlternative");
  function useAttribute(element, attributeName) {
    var attribute = element.getAttributeNode(attributeName);
    if (attribute !== null && !consultedNodes.has(attribute) && attribute.value.trim() !== "") {
      consultedNodes.add(attribute);
      return attribute.value;
    }
    return null;
  }
  __name(useAttribute, "useAttribute");
  function computeTooltipAttributeValue(node) {
    if (!isElement(node)) {
      return null;
    }
    return useAttribute(node, "title");
  }
  __name(computeTooltipAttributeValue, "computeTooltipAttributeValue");
  function computeElementTextAlternative(node) {
    if (!isElement(node)) {
      return null;
    }
    if (isHTMLFieldSetElement(node)) {
      consultedNodes.add(node);
      var children = arrayFrom(node.childNodes);
      for (var i2 = 0; i2 < children.length; i2 += 1) {
        var child = children[i2];
        if (isHTMLLegendElement(child)) {
          return computeTextAlternative3(child, {
            isEmbeddedInLabel: false,
            isReferenced: false,
            recursion: false
          });
        }
      }
    } else if (isHTMLTableElement(node)) {
      consultedNodes.add(node);
      var _children = arrayFrom(node.childNodes);
      for (var _i = 0; _i < _children.length; _i += 1) {
        var _child = _children[_i];
        if (isHTMLTableCaptionElement(_child)) {
          return computeTextAlternative3(_child, {
            isEmbeddedInLabel: false,
            isReferenced: false,
            recursion: false
          });
        }
      }
    } else if (isSVGSVGElement(node)) {
      consultedNodes.add(node);
      var _children2 = arrayFrom(node.childNodes);
      for (var _i2 = 0; _i2 < _children2.length; _i2 += 1) {
        var _child2 = _children2[_i2];
        if (isSVGTitleElement(_child2)) {
          return _child2.textContent;
        }
      }
      return null;
    } else if (getLocalName(node) === "img" || getLocalName(node) === "area") {
      var nameFromAlt = useAttribute(node, "alt");
      if (nameFromAlt !== null) {
        return nameFromAlt;
      }
    } else if (isHTMLOptGroupElement(node)) {
      var nameFromLabel = useAttribute(node, "label");
      if (nameFromLabel !== null) {
        return nameFromLabel;
      }
    }
    if (isHTMLInputElement(node) && (node.type === "button" || node.type === "submit" || node.type === "reset")) {
      var nameFromValue = useAttribute(node, "value");
      if (nameFromValue !== null) {
        return nameFromValue;
      }
      if (node.type === "submit") {
        return "Submit";
      }
      if (node.type === "reset") {
        return "Reset";
      }
    }
    var labels = getLabels(node);
    if (labels !== null && labels.length !== 0) {
      consultedNodes.add(node);
      return arrayFrom(labels).map(function(element) {
        return computeTextAlternative3(element, {
          isEmbeddedInLabel: true,
          isReferenced: false,
          recursion: true
        });
      }).filter(function(label) {
        return label.length > 0;
      }).join(" ");
    }
    if (isHTMLInputElement(node) && node.type === "image") {
      var _nameFromAlt = useAttribute(node, "alt");
      if (_nameFromAlt !== null) {
        return _nameFromAlt;
      }
      var nameFromTitle = useAttribute(node, "title");
      if (nameFromTitle !== null) {
        return nameFromTitle;
      }
      return "Submit Query";
    }
    if (hasAnyConcreteRoles(node, ["button"])) {
      var nameFromSubTree = computeMiscTextAlternative(node, {
        isEmbeddedInLabel: false,
        isReferenced: false
      });
      if (nameFromSubTree !== "") {
        return nameFromSubTree;
      }
    }
    return null;
  }
  __name(computeElementTextAlternative, "computeElementTextAlternative");
  function computeTextAlternative3(current, context) {
    if (consultedNodes.has(current)) {
      return "";
    }
    if (!hidden && isHidden(current, getComputedStyle) && !context.isReferenced) {
      consultedNodes.add(current);
      return "";
    }
    var labelAttributeNode = isElement(current) ? current.getAttributeNode("aria-labelledby") : null;
    var labelElements = labelAttributeNode !== null && !consultedNodes.has(labelAttributeNode) ? queryIdRefs(current, "aria-labelledby") : [];
    if (compute === "name" && !context.isReferenced && labelElements.length > 0) {
      consultedNodes.add(labelAttributeNode);
      return labelElements.map(function(element) {
        return computeTextAlternative3(element, {
          isEmbeddedInLabel: context.isEmbeddedInLabel,
          isReferenced: true,
          // this isn't recursion as specified, otherwise we would skip
          // `aria-label` in
          // <input id="myself" aria-label="foo" aria-labelledby="myself"
          recursion: false
        });
      }).join(" ");
    }
    var skipToStep2E = context.recursion && isControl(current) && compute === "name";
    if (!skipToStep2E) {
      var ariaLabel = (isElement(current) && current.getAttribute("aria-label") || "").trim();
      if (ariaLabel !== "" && compute === "name") {
        consultedNodes.add(current);
        return ariaLabel;
      }
      if (!isMarkedPresentational(current)) {
        var elementTextAlternative = computeElementTextAlternative(current);
        if (elementTextAlternative !== null) {
          consultedNodes.add(current);
          return elementTextAlternative;
        }
      }
    }
    if (hasAnyConcreteRoles(current, ["menu"])) {
      consultedNodes.add(current);
      return "";
    }
    if (skipToStep2E || context.isEmbeddedInLabel || context.isReferenced) {
      if (hasAnyConcreteRoles(current, ["combobox", "listbox"])) {
        consultedNodes.add(current);
        var selectedOptions = querySelectedOptions(current);
        if (selectedOptions.length === 0) {
          return isHTMLInputElement(current) ? current.value : "";
        }
        return arrayFrom(selectedOptions).map(function(selectedOption) {
          return computeTextAlternative3(selectedOption, {
            isEmbeddedInLabel: context.isEmbeddedInLabel,
            isReferenced: false,
            recursion: true
          });
        }).join(" ");
      }
      if (hasAbstractRole(current, "range")) {
        consultedNodes.add(current);
        if (current.hasAttribute("aria-valuetext")) {
          return current.getAttribute("aria-valuetext");
        }
        if (current.hasAttribute("aria-valuenow")) {
          return current.getAttribute("aria-valuenow");
        }
        return current.getAttribute("value") || "";
      }
      if (hasAnyConcreteRoles(current, ["textbox"])) {
        consultedNodes.add(current);
        return getValueOfTextbox(current);
      }
    }
    if (allowsNameFromContent(current) || isElement(current) && context.isReferenced || isNativeHostLanguageTextAlternativeElement(current) || isDescendantOfNativeHostLanguageTextAlternativeElement(current)) {
      var accumulatedText2F = computeMiscTextAlternative(current, {
        isEmbeddedInLabel: context.isEmbeddedInLabel,
        isReferenced: false
      });
      if (accumulatedText2F !== "") {
        consultedNodes.add(current);
        return accumulatedText2F;
      }
    }
    if (current.nodeType === current.TEXT_NODE) {
      consultedNodes.add(current);
      return current.textContent || "";
    }
    if (context.recursion) {
      consultedNodes.add(current);
      return computeMiscTextAlternative(current, {
        isEmbeddedInLabel: context.isEmbeddedInLabel,
        isReferenced: false
      });
    }
    var tooltipAttributeValue = computeTooltipAttributeValue(current);
    if (tooltipAttributeValue !== null) {
      consultedNodes.add(current);
      return tooltipAttributeValue;
    }
    consultedNodes.add(current);
    return "";
  }
  __name(computeTextAlternative3, "computeTextAlternative");
  return asFlatString(computeTextAlternative3(root, {
    isEmbeddedInLabel: false,
    // by spec computeAccessibleDescription starts with the referenced elements as roots
    isReferenced: compute === "description",
    recursion: false
  }));
}
__name(computeTextAlternative, "computeTextAlternative");

// ../node_modules/@testing-library/jest-dom/node_modules/dom-accessibility-api/dist/accessible-description.mjs
function _typeof2(o2) {
  "@babel/helpers - typeof";
  return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(o3) {
    return typeof o3;
  } : function(o3) {
    return o3 && "function" == typeof Symbol && o3.constructor === Symbol && o3 !== Symbol.prototype ? "symbol" : typeof o3;
  }, _typeof2(o2);
}
__name(_typeof2, "_typeof");
function ownKeys(e2, r2) {
  var t2 = Object.keys(e2);
  if (Object.getOwnPropertySymbols) {
    var o2 = Object.getOwnPropertySymbols(e2);
    r2 && (o2 = o2.filter(function(r3) {
      return Object.getOwnPropertyDescriptor(e2, r3).enumerable;
    })), t2.push.apply(t2, o2);
  }
  return t2;
}
__name(ownKeys, "ownKeys");
function _objectSpread(e2) {
  for (var r2 = 1; r2 < arguments.length; r2++) {
    var t2 = null != arguments[r2] ? arguments[r2] : {};
    r2 % 2 ? ownKeys(Object(t2), true).forEach(function(r3) {
      _defineProperty2(e2, r3, t2[r3]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e2, Object.getOwnPropertyDescriptors(t2)) : ownKeys(Object(t2)).forEach(function(r3) {
      Object.defineProperty(e2, r3, Object.getOwnPropertyDescriptor(t2, r3));
    });
  }
  return e2;
}
__name(_objectSpread, "_objectSpread");
function _defineProperty2(obj, key, value) {
  key = _toPropertyKey2(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_defineProperty2, "_defineProperty");
function _toPropertyKey2(arg) {
  var key = _toPrimitive2(arg, "string");
  return _typeof2(key) === "symbol" ? key : String(key);
}
__name(_toPropertyKey2, "_toPropertyKey");
function _toPrimitive2(input2, hint) {
  if (_typeof2(input2) !== "object" || input2 === null) return input2;
  var prim = input2[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input2, hint || "default");
    if (_typeof2(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input2);
}
__name(_toPrimitive2, "_toPrimitive");
function computeAccessibleDescription(root) {
  var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var description = queryIdRefs(root, "aria-describedby").map(function(element) {
    return computeTextAlternative(element, _objectSpread(_objectSpread({}, options), {}, {
      compute: "description"
    }));
  }).join(" ");
  if (description === "") {
    var ariaDescription = root.getAttribute("aria-description");
    description = ariaDescription === null ? "" : ariaDescription;
  }
  if (description === "") {
    var title = root.getAttribute("title");
    description = title === null ? "" : title;
  }
  return description;
}
__name(computeAccessibleDescription, "computeAccessibleDescription");

// ../node_modules/@testing-library/jest-dom/node_modules/dom-accessibility-api/dist/accessible-name.mjs
function prohibitsNaming(node) {
  return hasAnyConcreteRoles(node, ["caption", "code", "deletion", "emphasis", "generic", "insertion", "none", "paragraph", "presentation", "strong", "subscript", "superscript"]);
}
__name(prohibitsNaming, "prohibitsNaming");
function computeAccessibleName(root) {
  var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  if (prohibitsNaming(root)) {
    return "";
  }
  return computeTextAlternative(root, options);
}
__name(computeAccessibleName, "computeAccessibleName");

// ../node_modules/@testing-library/jest-dom/dist/matchers-35e4d3bd.mjs
var import_aria_query = __toESM(require_lib(), 1);
var import_picocolors = __toESM(require_picocolors_browser(), 1);
var import_css = __toESM(require_css_escape(), 1);
var _GenericTypeError = class _GenericTypeError extends Error {
  constructor(expectedString, received, matcherFn, context) {
    super();
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, matcherFn);
    }
    let withType = "";
    try {
      withType = context.utils.printWithType(
        "Received",
        received,
        context.utils.printReceived
      );
    } catch (e2) {
    }
    this.message = [
      context.utils.matcherHint(
        `${context.isNot ? ".not" : ""}.${matcherFn.name}`,
        "received",
        ""
      ),
      "",
      // eslint-disable-next-line new-cap
      `${context.utils.RECEIVED_COLOR(
        "received"
      )} value must ${expectedString}.`,
      withType
    ].join("\n");
  }
};
__name(_GenericTypeError, "GenericTypeError");
var GenericTypeError = _GenericTypeError;
var _HtmlElementTypeError = class _HtmlElementTypeError extends GenericTypeError {
  constructor(...args) {
    super("be an HTMLElement or an SVGElement", ...args);
  }
};
__name(_HtmlElementTypeError, "HtmlElementTypeError");
var HtmlElementTypeError = _HtmlElementTypeError;
var _NodeTypeError = class _NodeTypeError extends GenericTypeError {
  constructor(...args) {
    super("be a Node", ...args);
  }
};
__name(_NodeTypeError, "NodeTypeError");
var NodeTypeError = _NodeTypeError;
function checkHasWindow(htmlElement, ErrorClass, ...args) {
  if (!htmlElement || !htmlElement.ownerDocument || !htmlElement.ownerDocument.defaultView) {
    throw new ErrorClass(htmlElement, ...args);
  }
}
__name(checkHasWindow, "checkHasWindow");
function checkNode(node, ...args) {
  checkHasWindow(node, NodeTypeError, ...args);
  const window2 = node.ownerDocument.defaultView;
  if (!(node instanceof window2.Node)) {
    throw new NodeTypeError(node, ...args);
  }
}
__name(checkNode, "checkNode");
function checkHtmlElement(htmlElement, ...args) {
  checkHasWindow(htmlElement, HtmlElementTypeError, ...args);
  const window2 = htmlElement.ownerDocument.defaultView;
  if (!(htmlElement instanceof window2.HTMLElement) && !(htmlElement instanceof window2.SVGElement)) {
    throw new HtmlElementTypeError(htmlElement, ...args);
  }
}
__name(checkHtmlElement, "checkHtmlElement");
var _InvalidCSSError = class _InvalidCSSError extends Error {
  constructor(received, matcherFn, context) {
    super();
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, matcherFn);
    }
    this.message = [
      received.message,
      "",
      // eslint-disable-next-line new-cap
      context.utils.RECEIVED_COLOR(`Failing css:`),
      // eslint-disable-next-line new-cap
      context.utils.RECEIVED_COLOR(`${received.css}`)
    ].join("\n");
  }
};
__name(_InvalidCSSError, "InvalidCSSError");
var InvalidCSSError = _InvalidCSSError;
function parseCSS(css, ...args) {
  const ast = m(`selector { ${css} }`, { silent: true }).stylesheet;
  if (ast.parsingErrors && ast.parsingErrors.length > 0) {
    const { reason, line } = ast.parsingErrors[0];
    throw new InvalidCSSError(
      {
        css,
        message: `Syntax error parsing expected css: ${reason} on line: ${line}`
      },
      ...args
    );
  }
  const parsedRules = ast.rules[0].declarations.filter((d) => d.type === "declaration").reduce(
    (obj, { property, value }) => Object.assign(obj, { [property]: value }),
    {}
  );
  return parsedRules;
}
__name(parseCSS, "parseCSS");
function display(context, value) {
  return typeof value === "string" ? value : context.utils.stringify(value);
}
__name(display, "display");
function getMessage3(context, matcher, expectedLabel, expectedValue, receivedLabel, receivedValue) {
  return [
    `${matcher}
`,
    // eslint-disable-next-line new-cap
    `${expectedLabel}:
${context.utils.EXPECTED_COLOR(
      (0, import_redent.default)(display(context, expectedValue), 2)
    )}`,
    // eslint-disable-next-line new-cap
    `${receivedLabel}:
${context.utils.RECEIVED_COLOR(
      (0, import_redent.default)(display(context, receivedValue), 2)
    )}`
  ].join("\n");
}
__name(getMessage3, "getMessage");
function matches(textToMatch, matcher) {
  if (matcher instanceof RegExp) {
    return matcher.test(textToMatch);
  } else {
    return textToMatch.includes(String(matcher));
  }
}
__name(matches, "matches");
function deprecate(name, replacementText) {
  console.warn(
    `Warning: ${name} has been deprecated and will be removed in future updates.`,
    replacementText
  );
}
__name(deprecate, "deprecate");
function normalize(text) {
  return text.replace(/\s+/g, " ").trim();
}
__name(normalize, "normalize");
function getTag(element) {
  return element.tagName && element.tagName.toLowerCase();
}
__name(getTag, "getTag");
function getSelectValue({ multiple, options }) {
  const selectedOptions = [...options].filter((option) => option.selected);
  if (multiple) {
    return [...selectedOptions].map((opt) => opt.value);
  }
  if (selectedOptions.length === 0) {
    return void 0;
  }
  return selectedOptions[0].value;
}
__name(getSelectValue, "getSelectValue");
function getInputValue(inputElement) {
  switch (inputElement.type) {
    case "number":
      return inputElement.value === "" ? null : Number(inputElement.value);
    case "checkbox":
      return inputElement.checked;
    default:
      return inputElement.value;
  }
}
__name(getInputValue, "getInputValue");
var rolesSupportingValues = ["meter", "progressbar", "slider", "spinbutton"];
function getAccessibleValue(element) {
  if (!rolesSupportingValues.includes(element.getAttribute("role"))) {
    return void 0;
  }
  return Number(element.getAttribute("aria-valuenow"));
}
__name(getAccessibleValue, "getAccessibleValue");
function getSingleElementValue(element) {
  if (!element) {
    return void 0;
  }
  switch (element.tagName.toLowerCase()) {
    case "input":
      return getInputValue(element);
    case "select":
      return getSelectValue(element);
    default: {
      return element.value ?? getAccessibleValue(element);
    }
  }
}
__name(getSingleElementValue, "getSingleElementValue");
function toSentence(array, { wordConnector = ", ", lastWordConnector = " and " } = {}) {
  return [array.slice(0, -1).join(wordConnector), array[array.length - 1]].join(
    array.length > 1 ? lastWordConnector : ""
  );
}
__name(toSentence, "toSentence");
function compareAsSet(val1, val2) {
  if (Array.isArray(val1) && Array.isArray(val2)) {
    return [...new Set(val1)].every((v2) => new Set(val2).has(v2));
  }
  return val1 === val2;
}
__name(compareAsSet, "compareAsSet");
function toBeInTheDOM(element, container) {
  deprecate(
    "toBeInTheDOM",
    "Please use toBeInTheDocument for searching the entire document and toContainElement for searching a specific container."
  );
  if (element) {
    checkHtmlElement(element, toBeInTheDOM, this);
  }
  if (container) {
    checkHtmlElement(container, toBeInTheDOM, this);
  }
  return {
    pass: container ? container.contains(element) : !!element,
    message: /* @__PURE__ */ __name(() => {
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeInTheDOM`,
          "element",
          ""
        ),
        "",
        "Received:",
        `  ${this.utils.printReceived(
          element ? element.cloneNode(false) : element
        )}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeInTheDOM, "toBeInTheDOM");
function toBeInTheDocument(element) {
  if (element !== null || !this.isNot) {
    checkHtmlElement(element, toBeInTheDocument, this);
  }
  const pass = element === null ? false : element.ownerDocument === element.getRootNode({ composed: true });
  const errorFound = /* @__PURE__ */ __name(() => {
    return `expected document not to contain element, found ${this.utils.stringify(
      element.cloneNode(true)
    )} instead`;
  }, "errorFound");
  const errorNotFound = /* @__PURE__ */ __name(() => {
    return `element could not be found in the document`;
  }, "errorNotFound");
  return {
    pass,
    message: /* @__PURE__ */ __name(() => {
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeInTheDocument`,
          "element",
          ""
        ),
        "",
        // eslint-disable-next-line new-cap
        this.utils.RECEIVED_COLOR(this.isNot ? errorFound() : errorNotFound())
      ].join("\n");
    }, "message")
  };
}
__name(toBeInTheDocument, "toBeInTheDocument");
function toBeEmpty(element) {
  deprecate(
    "toBeEmpty",
    "Please use instead toBeEmptyDOMElement for finding empty nodes in the DOM."
  );
  checkHtmlElement(element, toBeEmpty, this);
  return {
    pass: element.innerHTML === "",
    message: /* @__PURE__ */ __name(() => {
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeEmpty`,
          "element",
          ""
        ),
        "",
        "Received:",
        `  ${this.utils.printReceived(element.innerHTML)}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeEmpty, "toBeEmpty");
function toBeEmptyDOMElement(element) {
  checkHtmlElement(element, toBeEmptyDOMElement, this);
  return {
    pass: isEmptyElement(element),
    message: /* @__PURE__ */ __name(() => {
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeEmptyDOMElement`,
          "element",
          ""
        ),
        "",
        "Received:",
        `  ${this.utils.printReceived(element.innerHTML)}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeEmptyDOMElement, "toBeEmptyDOMElement");
function isEmptyElement(element) {
  const nonCommentChildNodes = [...element.childNodes].filter((node) => node.nodeType !== 8);
  return nonCommentChildNodes.length === 0;
}
__name(isEmptyElement, "isEmptyElement");
function toContainElement(container, element) {
  checkHtmlElement(container, toContainElement, this);
  if (element !== null) {
    checkHtmlElement(element, toContainElement, this);
  }
  return {
    pass: container.contains(element),
    message: /* @__PURE__ */ __name(() => {
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toContainElement`,
          "element",
          "element"
        ),
        "",
        // eslint-disable-next-line new-cap
        this.utils.RECEIVED_COLOR(`${this.utils.stringify(
          container.cloneNode(false)
        )} ${this.isNot ? "contains:" : "does not contain:"} ${this.utils.stringify(element ? element.cloneNode(false) : element)}
        `)
      ].join("\n");
    }, "message")
  };
}
__name(toContainElement, "toContainElement");
function getNormalizedHtml(container, htmlText) {
  const div = container.ownerDocument.createElement("div");
  div.innerHTML = htmlText;
  return div.innerHTML;
}
__name(getNormalizedHtml, "getNormalizedHtml");
function toContainHTML(container, htmlText) {
  checkHtmlElement(container, toContainHTML, this);
  if (typeof htmlText !== "string") {
    throw new Error(`.toContainHTML() expects a string value, got ${htmlText}`);
  }
  return {
    pass: container.outerHTML.includes(getNormalizedHtml(container, htmlText)),
    message: /* @__PURE__ */ __name(() => {
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toContainHTML`,
          "element",
          ""
        ),
        "Expected:",
        // eslint-disable-next-line new-cap
        `  ${this.utils.EXPECTED_COLOR(htmlText)}`,
        "Received:",
        `  ${this.utils.printReceived(container.cloneNode(true))}`
      ].join("\n");
    }, "message")
  };
}
__name(toContainHTML, "toContainHTML");
function toHaveTextContent(node, checkWith, options = { normalizeWhitespace: true }) {
  checkNode(node, toHaveTextContent, this);
  const textContent = options.normalizeWhitespace ? normalize(node.textContent) : node.textContent.replace(/\u00a0/g, " ");
  const checkingWithEmptyString = textContent !== "" && checkWith === "";
  return {
    pass: !checkingWithEmptyString && matches(textContent, checkWith),
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      return getMessage3(
        this,
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toHaveTextContent`,
          "element",
          ""
        ),
        checkingWithEmptyString ? `Checking with empty string will always match, use .toBeEmptyDOMElement() instead` : `Expected element ${to} have text content`,
        checkWith,
        "Received",
        textContent
      );
    }, "message")
  };
}
__name(toHaveTextContent, "toHaveTextContent");
function toHaveAccessibleDescription(htmlElement, expectedAccessibleDescription) {
  checkHtmlElement(htmlElement, toHaveAccessibleDescription, this);
  const actualAccessibleDescription = computeAccessibleDescription(htmlElement);
  const missingExpectedValue = arguments.length === 1;
  let pass = false;
  if (missingExpectedValue) {
    pass = actualAccessibleDescription !== "";
  } else {
    pass = expectedAccessibleDescription instanceof RegExp ? expectedAccessibleDescription.test(actualAccessibleDescription) : this.equals(
      actualAccessibleDescription,
      expectedAccessibleDescription
    );
  }
  return {
    pass,
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      return getMessage3(
        this,
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.${toHaveAccessibleDescription.name}`,
          "element",
          ""
        ),
        `Expected element ${to} have accessible description`,
        expectedAccessibleDescription,
        "Received",
        actualAccessibleDescription
      );
    }, "message")
  };
}
__name(toHaveAccessibleDescription, "toHaveAccessibleDescription");
var ariaInvalidName = "aria-invalid";
var validStates = ["false"];
function toHaveAccessibleErrorMessage(htmlElement, expectedAccessibleErrorMessage) {
  checkHtmlElement(htmlElement, toHaveAccessibleErrorMessage, this);
  const to = this.isNot ? "not to" : "to";
  const method = this.isNot ? ".not.toHaveAccessibleErrorMessage" : ".toHaveAccessibleErrorMessage";
  const errormessageId = htmlElement.getAttribute("aria-errormessage");
  const errormessageIdInvalid = !!errormessageId && /\s+/.test(errormessageId);
  if (errormessageIdInvalid) {
    return {
      pass: false,
      message: /* @__PURE__ */ __name(() => {
        return getMessage3(
          this,
          this.utils.matcherHint(method, "element"),
          "Expected element's `aria-errormessage` attribute to be empty or a single, valid ID",
          "",
          "Received",
          `aria-errormessage="${errormessageId}"`
        );
      }, "message")
    };
  }
  const ariaInvalidVal = htmlElement.getAttribute(ariaInvalidName);
  const fieldValid = !htmlElement.hasAttribute(ariaInvalidName) || validStates.includes(ariaInvalidVal);
  if (fieldValid) {
    return {
      pass: false,
      message: /* @__PURE__ */ __name(() => {
        return getMessage3(
          this,
          this.utils.matcherHint(method, "element"),
          "Expected element to be marked as invalid with attribute",
          `${ariaInvalidName}="${String(true)}"`,
          "Received",
          htmlElement.hasAttribute("aria-invalid") ? `${ariaInvalidName}="${htmlElement.getAttribute(ariaInvalidName)}` : null
        );
      }, "message")
    };
  }
  const error = normalize(
    htmlElement.ownerDocument.getElementById(errormessageId)?.textContent ?? ""
  );
  return {
    pass: expectedAccessibleErrorMessage === void 0 ? Boolean(error) : expectedAccessibleErrorMessage instanceof RegExp ? expectedAccessibleErrorMessage.test(error) : this.equals(error, expectedAccessibleErrorMessage),
    message: /* @__PURE__ */ __name(() => {
      return getMessage3(
        this,
        this.utils.matcherHint(method, "element"),
        `Expected element ${to} have accessible error message`,
        expectedAccessibleErrorMessage ?? "",
        "Received",
        error
      );
    }, "message")
  };
}
__name(toHaveAccessibleErrorMessage, "toHaveAccessibleErrorMessage");
var elementRoleList = buildElementRoleList(import_aria_query.elementRoles);
function toHaveRole(htmlElement, expectedRole) {
  checkHtmlElement(htmlElement, toHaveRole, this);
  const actualRoles = getExplicitOrImplicitRoles(htmlElement);
  const pass = actualRoles.some((el) => el === expectedRole);
  return {
    pass,
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      return getMessage3(
        this,
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.${toHaveRole.name}`,
          "element",
          ""
        ),
        `Expected element ${to} have role`,
        expectedRole,
        "Received",
        actualRoles.join(", ")
      );
    }, "message")
  };
}
__name(toHaveRole, "toHaveRole");
function getExplicitOrImplicitRoles(htmlElement) {
  const hasExplicitRole = htmlElement.hasAttribute("role");
  if (hasExplicitRole) {
    const roleValue = htmlElement.getAttribute("role");
    return roleValue.split(" ").filter(Boolean);
  }
  const implicitRoles = getImplicitAriaRoles(htmlElement);
  return implicitRoles;
}
__name(getExplicitOrImplicitRoles, "getExplicitOrImplicitRoles");
function getImplicitAriaRoles(currentNode) {
  for (const { match, roles: roles3 } of elementRoleList) {
    if (match(currentNode)) {
      return [...roles3];
    }
  }
  return [];
}
__name(getImplicitAriaRoles, "getImplicitAriaRoles");
function buildElementRoleList(elementRolesMap) {
  function makeElementSelector({ name, attributes }) {
    return `${name}${attributes.map(({ name: attributeName, value, constraints = [] }) => {
      const shouldNotExist = constraints.indexOf("undefined") !== -1;
      if (shouldNotExist) {
        return `:not([${attributeName}])`;
      } else if (value) {
        return `[${attributeName}="${value}"]`;
      } else {
        return `[${attributeName}]`;
      }
    }).join("")}`;
  }
  __name(makeElementSelector, "makeElementSelector");
  function getSelectorSpecificity({ attributes = [] }) {
    return attributes.length;
  }
  __name(getSelectorSpecificity, "getSelectorSpecificity");
  function bySelectorSpecificity({ specificity: leftSpecificity }, { specificity: rightSpecificity }) {
    return rightSpecificity - leftSpecificity;
  }
  __name(bySelectorSpecificity, "bySelectorSpecificity");
  function match(element) {
    let { attributes = [] } = element;
    const typeTextIndex = attributes.findIndex(
      (attribute) => attribute.value && attribute.name === "type" && attribute.value === "text"
    );
    if (typeTextIndex >= 0) {
      attributes = [
        ...attributes.slice(0, typeTextIndex),
        ...attributes.slice(typeTextIndex + 1)
      ];
    }
    const selector = makeElementSelector({ ...element, attributes });
    return (node) => {
      if (typeTextIndex >= 0 && node.type !== "text") {
        return false;
      }
      return node.matches(selector);
    };
  }
  __name(match, "match");
  let result = [];
  for (const [element, roles3] of elementRolesMap.entries()) {
    result = [
      ...result,
      {
        match: match(element),
        roles: Array.from(roles3),
        specificity: getSelectorSpecificity(element)
      }
    ];
  }
  return result.sort(bySelectorSpecificity);
}
__name(buildElementRoleList, "buildElementRoleList");
function toHaveAccessibleName(htmlElement, expectedAccessibleName) {
  checkHtmlElement(htmlElement, toHaveAccessibleName, this);
  const actualAccessibleName = computeAccessibleName(htmlElement);
  const missingExpectedValue = arguments.length === 1;
  let pass = false;
  if (missingExpectedValue) {
    pass = actualAccessibleName !== "";
  } else {
    pass = expectedAccessibleName instanceof RegExp ? expectedAccessibleName.test(actualAccessibleName) : this.equals(actualAccessibleName, expectedAccessibleName);
  }
  return {
    pass,
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      return getMessage3(
        this,
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.${toHaveAccessibleName.name}`,
          "element",
          ""
        ),
        `Expected element ${to} have accessible name`,
        expectedAccessibleName,
        "Received",
        actualAccessibleName
      );
    }, "message")
  };
}
__name(toHaveAccessibleName, "toHaveAccessibleName");
function printAttribute(stringify2, name, value) {
  return value === void 0 ? name : `${name}=${stringify2(value)}`;
}
__name(printAttribute, "printAttribute");
function getAttributeComment(stringify2, name, value) {
  return value === void 0 ? `element.hasAttribute(${stringify2(name)})` : `element.getAttribute(${stringify2(name)}) === ${stringify2(value)}`;
}
__name(getAttributeComment, "getAttributeComment");
function toHaveAttribute(htmlElement, name, expectedValue) {
  checkHtmlElement(htmlElement, toHaveAttribute, this);
  const isExpectedValuePresent = expectedValue !== void 0;
  const hasAttribute = htmlElement.hasAttribute(name);
  const receivedValue = htmlElement.getAttribute(name);
  return {
    pass: isExpectedValuePresent ? hasAttribute && this.equals(receivedValue, expectedValue) : hasAttribute,
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      const receivedAttribute = hasAttribute ? printAttribute(this.utils.stringify, name, receivedValue) : null;
      const matcher = this.utils.matcherHint(
        `${this.isNot ? ".not" : ""}.toHaveAttribute`,
        "element",
        this.utils.printExpected(name),
        {
          secondArgument: isExpectedValuePresent ? this.utils.printExpected(expectedValue) : void 0,
          comment: getAttributeComment(
            this.utils.stringify,
            name,
            expectedValue
          )
        }
      );
      return getMessage3(
        this,
        matcher,
        `Expected the element ${to} have attribute`,
        printAttribute(this.utils.stringify, name, expectedValue),
        "Received",
        receivedAttribute
      );
    }, "message")
  };
}
__name(toHaveAttribute, "toHaveAttribute");
function getExpectedClassNamesAndOptions(params) {
  const lastParam = params.pop();
  let expectedClassNames, options;
  if (typeof lastParam === "object" && !(lastParam instanceof RegExp)) {
    expectedClassNames = params;
    options = lastParam;
  } else {
    expectedClassNames = params.concat(lastParam);
    options = { exact: false };
  }
  return { expectedClassNames, options };
}
__name(getExpectedClassNamesAndOptions, "getExpectedClassNamesAndOptions");
function splitClassNames(str) {
  if (!str) return [];
  return str.split(/\s+/).filter((s3) => s3.length > 0);
}
__name(splitClassNames, "splitClassNames");
function isSubset$1(subset, superset) {
  return subset.every(
    (strOrRegexp) => typeof strOrRegexp === "string" ? superset.includes(strOrRegexp) : superset.some((className) => strOrRegexp.test(className))
  );
}
__name(isSubset$1, "isSubset$1");
function toHaveClass(htmlElement, ...params) {
  checkHtmlElement(htmlElement, toHaveClass, this);
  const { expectedClassNames, options } = getExpectedClassNamesAndOptions(params);
  const received = splitClassNames(htmlElement.getAttribute("class"));
  const expected = expectedClassNames.reduce(
    (acc, className) => acc.concat(
      typeof className === "string" || !className ? splitClassNames(className) : className
    ),
    []
  );
  const hasRegExp = expected.some((className) => className instanceof RegExp);
  if (options.exact && hasRegExp) {
    throw new Error("Exact option does not support RegExp expected class names");
  }
  if (options.exact) {
    return {
      pass: isSubset$1(expected, received) && expected.length === received.length,
      message: /* @__PURE__ */ __name(() => {
        const to = this.isNot ? "not to" : "to";
        return getMessage3(
          this,
          this.utils.matcherHint(
            `${this.isNot ? ".not" : ""}.toHaveClass`,
            "element",
            this.utils.printExpected(expected.join(" "))
          ),
          `Expected the element ${to} have EXACTLY defined classes`,
          expected.join(" "),
          "Received",
          received.join(" ")
        );
      }, "message")
    };
  }
  return expected.length > 0 ? {
    pass: isSubset$1(expected, received),
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      return getMessage3(
        this,
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toHaveClass`,
          "element",
          this.utils.printExpected(expected.join(" "))
        ),
        `Expected the element ${to} have class`,
        expected.join(" "),
        "Received",
        received.join(" ")
      );
    }, "message")
  } : {
    pass: this.isNot ? received.length > 0 : false,
    message: /* @__PURE__ */ __name(() => this.isNot ? getMessage3(
      this,
      this.utils.matcherHint(".not.toHaveClass", "element", ""),
      "Expected the element to have classes",
      "(none)",
      "Received",
      received.join(" ")
    ) : [
      this.utils.matcherHint(`.toHaveClass`, "element"),
      "At least one expected class must be provided."
    ].join("\n"), "message")
  };
}
__name(toHaveClass, "toHaveClass");
function getStyleDeclaration(document2, css) {
  const styles2 = {};
  const copy3 = document2.createElement("div");
  Object.keys(css).forEach((property) => {
    copy3.style[property] = css[property];
    styles2[property] = copy3.style[property];
  });
  return styles2;
}
__name(getStyleDeclaration, "getStyleDeclaration");
function isSubset(styles2, computedStyle) {
  return !!Object.keys(styles2).length && Object.entries(styles2).every(([prop, value]) => {
    const isCustomProperty = prop.startsWith("--");
    const spellingVariants = [prop];
    if (!isCustomProperty) spellingVariants.push(prop.toLowerCase());
    return spellingVariants.some(
      (name) => computedStyle[name] === value || computedStyle.getPropertyValue(name) === value
    );
  });
}
__name(isSubset, "isSubset");
function printoutStyles(styles2) {
  return Object.keys(styles2).sort().map((prop) => `${prop}: ${styles2[prop]};`).join("\n");
}
__name(printoutStyles, "printoutStyles");
function expectedDiff(diffFn, expected, computedStyles) {
  const received = Array.from(computedStyles).filter((prop) => expected[prop] !== void 0).reduce(
    (obj, prop) => Object.assign(obj, { [prop]: computedStyles.getPropertyValue(prop) }),
    {}
  );
  const diffOutput = diffFn(printoutStyles(expected), printoutStyles(received));
  return diffOutput.replace(`${import_picocolors.default.red("+ Received")}
`, "");
}
__name(expectedDiff, "expectedDiff");
function toHaveStyle(htmlElement, css) {
  checkHtmlElement(htmlElement, toHaveStyle, this);
  const parsedCSS = typeof css === "object" ? css : parseCSS(css, toHaveStyle, this);
  const { getComputedStyle } = htmlElement.ownerDocument.defaultView;
  const expected = getStyleDeclaration(htmlElement.ownerDocument, parsedCSS);
  const received = getComputedStyle(htmlElement);
  return {
    pass: isSubset(expected, received),
    message: /* @__PURE__ */ __name(() => {
      const matcher = `${this.isNot ? ".not" : ""}.toHaveStyle`;
      return [
        this.utils.matcherHint(matcher, "element", ""),
        expectedDiff(this.utils.diff, expected, received)
      ].join("\n\n");
    }, "message")
  };
}
__name(toHaveStyle, "toHaveStyle");
function toHaveFocus(element) {
  checkHtmlElement(element, toHaveFocus, this);
  return {
    pass: element.ownerDocument.activeElement === element,
    message: /* @__PURE__ */ __name(() => {
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toHaveFocus`,
          "element",
          ""
        ),
        "",
        ...this.isNot ? [
          "Received element is focused:",
          `  ${this.utils.printReceived(element)}`
        ] : [
          "Expected element with focus:",
          `  ${this.utils.printExpected(element)}`,
          "Received element with focus:",
          `  ${this.utils.printReceived(
            element.ownerDocument.activeElement
          )}`
        ]
      ].join("\n");
    }, "message")
  };
}
__name(toHaveFocus, "toHaveFocus");
function getMultiElementValue(elements) {
  const types = [...new Set(elements.map((element) => element.type))];
  if (types.length !== 1) {
    throw new Error(
      "Multiple form elements with the same name must be of the same type"
    );
  }
  switch (types[0]) {
    case "radio": {
      const theChosenOne = elements.find((radio) => radio.checked);
      return theChosenOne ? theChosenOne.value : void 0;
    }
    case "checkbox":
      return elements.filter((checkbox) => checkbox.checked).map((checkbox) => checkbox.value);
    default:
      return elements.map((element) => element.value);
  }
}
__name(getMultiElementValue, "getMultiElementValue");
function getFormValue(container, name) {
  const elements = [...container.querySelectorAll(`[name="${(0, import_css.default)(name)}"]`)];
  if (elements.length === 0) {
    return void 0;
  }
  switch (elements.length) {
    case 1:
      return getSingleElementValue(elements[0]);
    default:
      return getMultiElementValue(elements);
  }
}
__name(getFormValue, "getFormValue");
function getPureName(name) {
  return /\[\]$/.test(name) ? name.slice(0, -2) : name;
}
__name(getPureName, "getPureName");
function getAllFormValues(container) {
  const names = Array.from(container.elements).map((element) => element.name);
  return names.reduce(
    (obj, name) => ({
      ...obj,
      [getPureName(name)]: getFormValue(container, name)
    }),
    {}
  );
}
__name(getAllFormValues, "getAllFormValues");
function toHaveFormValues(formElement, expectedValues) {
  checkHtmlElement(formElement, toHaveFormValues, this);
  if (!formElement.elements) {
    throw new Error("toHaveFormValues must be called on a form or a fieldset");
  }
  const formValues = getAllFormValues(formElement);
  return {
    pass: Object.entries(expectedValues).every(
      ([name, expectedValue]) => compareAsSet(formValues[name], expectedValue)
    ),
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      const matcher = `${this.isNot ? ".not" : ""}.toHaveFormValues`;
      const commonKeyValues = Object.keys(formValues).filter((key) => expectedValues.hasOwnProperty(key)).reduce((obj, key) => ({ ...obj, [key]: formValues[key] }), {});
      return [
        this.utils.matcherHint(matcher, "element", ""),
        `Expected the element ${to} have form values`,
        this.utils.diff(expectedValues, commonKeyValues)
      ].join("\n\n");
    }, "message")
  };
}
__name(toHaveFormValues, "toHaveFormValues");
function isStyleVisible(element) {
  const { getComputedStyle } = element.ownerDocument.defaultView;
  const { display: display2, visibility, opacity } = getComputedStyle(element);
  return display2 !== "none" && visibility !== "hidden" && visibility !== "collapse" && opacity !== "0" && opacity !== 0;
}
__name(isStyleVisible, "isStyleVisible");
function isAttributeVisible(element, previousElement) {
  let detailsVisibility;
  if (previousElement) {
    detailsVisibility = element.nodeName === "DETAILS" && previousElement.nodeName !== "SUMMARY" ? element.hasAttribute("open") : true;
  } else {
    detailsVisibility = element.nodeName === "DETAILS" ? element.hasAttribute("open") : true;
  }
  return !element.hasAttribute("hidden") && detailsVisibility;
}
__name(isAttributeVisible, "isAttributeVisible");
function isElementVisible(element, previousElement) {
  return isStyleVisible(element) && isAttributeVisible(element, previousElement) && (!element.parentElement || isElementVisible(element.parentElement, element));
}
__name(isElementVisible, "isElementVisible");
function toBeVisible(element) {
  checkHtmlElement(element, toBeVisible, this);
  const isInDocument = element.ownerDocument === element.getRootNode({ composed: true });
  const isVisible2 = isInDocument && isElementVisible(element);
  return {
    pass: isVisible2,
    message: /* @__PURE__ */ __name(() => {
      const is = isVisible2 ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeVisible`,
          "element",
          ""
        ),
        "",
        `Received element ${is} visible${isInDocument ? "" : " (element is not in the document)"}:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeVisible, "toBeVisible");
var FORM_TAGS$2 = [
  "fieldset",
  "input",
  "select",
  "optgroup",
  "option",
  "button",
  "textarea"
];
function isFirstLegendChildOfFieldset(element, parent) {
  return getTag(element) === "legend" && getTag(parent) === "fieldset" && element.isSameNode(
    Array.from(parent.children).find((child) => getTag(child) === "legend")
  );
}
__name(isFirstLegendChildOfFieldset, "isFirstLegendChildOfFieldset");
function isElementDisabledByParent(element, parent) {
  return isElementDisabled(parent) && !isFirstLegendChildOfFieldset(element, parent);
}
__name(isElementDisabledByParent, "isElementDisabledByParent");
function isCustomElement(tag) {
  return tag.includes("-");
}
__name(isCustomElement, "isCustomElement");
function canElementBeDisabled(element) {
  const tag = getTag(element);
  return FORM_TAGS$2.includes(tag) || isCustomElement(tag);
}
__name(canElementBeDisabled, "canElementBeDisabled");
function isElementDisabled(element) {
  return canElementBeDisabled(element) && element.hasAttribute("disabled");
}
__name(isElementDisabled, "isElementDisabled");
function isAncestorDisabled(element) {
  const parent = element.parentElement;
  return Boolean(parent) && (isElementDisabledByParent(element, parent) || isAncestorDisabled(parent));
}
__name(isAncestorDisabled, "isAncestorDisabled");
function isElementOrAncestorDisabled(element) {
  return canElementBeDisabled(element) && (isElementDisabled(element) || isAncestorDisabled(element));
}
__name(isElementOrAncestorDisabled, "isElementOrAncestorDisabled");
function toBeDisabled(element) {
  checkHtmlElement(element, toBeDisabled, this);
  const isDisabled3 = isElementOrAncestorDisabled(element);
  return {
    pass: isDisabled3,
    message: /* @__PURE__ */ __name(() => {
      const is = isDisabled3 ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeDisabled`,
          "element",
          ""
        ),
        "",
        `Received element ${is} disabled:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeDisabled, "toBeDisabled");
function toBeEnabled(element) {
  checkHtmlElement(element, toBeEnabled, this);
  const isEnabled = !isElementOrAncestorDisabled(element);
  return {
    pass: isEnabled,
    message: /* @__PURE__ */ __name(() => {
      const is = isEnabled ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeEnabled`,
          "element",
          ""
        ),
        "",
        `Received element ${is} enabled:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeEnabled, "toBeEnabled");
var FORM_TAGS$1 = ["select", "textarea"];
var ARIA_FORM_TAGS = ["input", "select", "textarea"];
var UNSUPPORTED_INPUT_TYPES = [
  "color",
  "hidden",
  "range",
  "submit",
  "image",
  "reset"
];
var SUPPORTED_ARIA_ROLES = [
  "checkbox",
  "combobox",
  "gridcell",
  "listbox",
  "radiogroup",
  "spinbutton",
  "textbox",
  "tree"
];
function isRequiredOnFormTagsExceptInput(element) {
  return FORM_TAGS$1.includes(getTag(element)) && element.hasAttribute("required");
}
__name(isRequiredOnFormTagsExceptInput, "isRequiredOnFormTagsExceptInput");
function isRequiredOnSupportedInput(element) {
  return getTag(element) === "input" && element.hasAttribute("required") && (element.hasAttribute("type") && !UNSUPPORTED_INPUT_TYPES.includes(element.getAttribute("type")) || !element.hasAttribute("type"));
}
__name(isRequiredOnSupportedInput, "isRequiredOnSupportedInput");
function isElementRequiredByARIA(element) {
  return element.hasAttribute("aria-required") && element.getAttribute("aria-required") === "true" && (ARIA_FORM_TAGS.includes(getTag(element)) || element.hasAttribute("role") && SUPPORTED_ARIA_ROLES.includes(element.getAttribute("role")));
}
__name(isElementRequiredByARIA, "isElementRequiredByARIA");
function toBeRequired(element) {
  checkHtmlElement(element, toBeRequired, this);
  const isRequired = isRequiredOnFormTagsExceptInput(element) || isRequiredOnSupportedInput(element) || isElementRequiredByARIA(element);
  return {
    pass: isRequired,
    message: /* @__PURE__ */ __name(() => {
      const is = isRequired ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeRequired`,
          "element",
          ""
        ),
        "",
        `Received element ${is} required:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeRequired, "toBeRequired");
var FORM_TAGS = ["form", "input", "select", "textarea"];
function isElementHavingAriaInvalid(element) {
  return element.hasAttribute("aria-invalid") && element.getAttribute("aria-invalid") !== "false";
}
__name(isElementHavingAriaInvalid, "isElementHavingAriaInvalid");
function isSupportsValidityMethod(element) {
  return FORM_TAGS.includes(getTag(element));
}
__name(isSupportsValidityMethod, "isSupportsValidityMethod");
function isElementInvalid(element) {
  const isHaveAriaInvalid = isElementHavingAriaInvalid(element);
  if (isSupportsValidityMethod(element)) {
    return isHaveAriaInvalid || !element.checkValidity();
  } else {
    return isHaveAriaInvalid;
  }
}
__name(isElementInvalid, "isElementInvalid");
function toBeInvalid(element) {
  checkHtmlElement(element, toBeInvalid, this);
  const isInvalid = isElementInvalid(element);
  return {
    pass: isInvalid,
    message: /* @__PURE__ */ __name(() => {
      const is = isInvalid ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeInvalid`,
          "element",
          ""
        ),
        "",
        `Received element ${is} currently invalid:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeInvalid, "toBeInvalid");
function toBeValid(element) {
  checkHtmlElement(element, toBeValid, this);
  const isValid = !isElementInvalid(element);
  return {
    pass: isValid,
    message: /* @__PURE__ */ __name(() => {
      const is = isValid ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeValid`,
          "element",
          ""
        ),
        "",
        `Received element ${is} currently valid:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeValid, "toBeValid");
function toHaveValue(htmlElement, expectedValue) {
  checkHtmlElement(htmlElement, toHaveValue, this);
  if (htmlElement.tagName.toLowerCase() === "input" && ["checkbox", "radio"].includes(htmlElement.type)) {
    throw new Error(
      "input with type=checkbox or type=radio cannot be used with .toHaveValue(). Use .toBeChecked() for type=checkbox or .toHaveFormValues() instead"
    );
  }
  const receivedValue = getSingleElementValue(htmlElement);
  const expectsValue = expectedValue !== void 0;
  let expectedTypedValue = expectedValue;
  let receivedTypedValue = receivedValue;
  if (expectedValue == receivedValue && expectedValue !== receivedValue) {
    expectedTypedValue = `${expectedValue} (${typeof expectedValue})`;
    receivedTypedValue = `${receivedValue} (${typeof receivedValue})`;
  }
  return {
    pass: expectsValue ? compareAsSet(receivedValue, expectedValue) : Boolean(receivedValue),
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      const matcher = this.utils.matcherHint(
        `${this.isNot ? ".not" : ""}.toHaveValue`,
        "element",
        expectedValue
      );
      return getMessage3(
        this,
        matcher,
        `Expected the element ${to} have value`,
        expectsValue ? expectedTypedValue : "(any)",
        "Received",
        receivedTypedValue
      );
    }, "message")
  };
}
__name(toHaveValue, "toHaveValue");
function toHaveDisplayValue(htmlElement, expectedValue) {
  checkHtmlElement(htmlElement, toHaveDisplayValue, this);
  const tagName = htmlElement.tagName.toLowerCase();
  if (!["select", "input", "textarea"].includes(tagName)) {
    throw new Error(
      ".toHaveDisplayValue() currently supports only input, textarea or select elements, try with another matcher instead."
    );
  }
  if (tagName === "input" && ["radio", "checkbox"].includes(htmlElement.type)) {
    throw new Error(
      `.toHaveDisplayValue() currently does not support input[type="${htmlElement.type}"], try with another matcher instead.`
    );
  }
  const values = getValues(tagName, htmlElement);
  const expectedValues = getExpectedValues(expectedValue);
  const numberOfMatchesWithValues = expectedValues.filter(
    (expected) => values.some(
      (value) => expected instanceof RegExp ? expected.test(value) : this.equals(value, String(expected))
    )
  ).length;
  const matchedWithAllValues = numberOfMatchesWithValues === values.length;
  const matchedWithAllExpectedValues = numberOfMatchesWithValues === expectedValues.length;
  return {
    pass: matchedWithAllValues && matchedWithAllExpectedValues,
    message: /* @__PURE__ */ __name(() => getMessage3(
      this,
      this.utils.matcherHint(
        `${this.isNot ? ".not" : ""}.toHaveDisplayValue`,
        "element",
        ""
      ),
      `Expected element ${this.isNot ? "not " : ""}to have display value`,
      expectedValue,
      "Received",
      values
    ), "message")
  };
}
__name(toHaveDisplayValue, "toHaveDisplayValue");
function getValues(tagName, htmlElement) {
  return tagName === "select" ? Array.from(htmlElement).filter((option) => option.selected).map((option) => option.textContent) : [htmlElement.value];
}
__name(getValues, "getValues");
function getExpectedValues(expectedValue) {
  return expectedValue instanceof Array ? expectedValue : [expectedValue];
}
__name(getExpectedValues, "getExpectedValues");
function toBeChecked(element) {
  checkHtmlElement(element, toBeChecked, this);
  const isValidInput = /* @__PURE__ */ __name(() => {
    return element.tagName.toLowerCase() === "input" && ["checkbox", "radio"].includes(element.type);
  }, "isValidInput");
  const isValidAriaElement = /* @__PURE__ */ __name(() => {
    return roleSupportsChecked(element.getAttribute("role")) && ["true", "false"].includes(element.getAttribute("aria-checked"));
  }, "isValidAriaElement");
  if (!isValidInput() && !isValidAriaElement()) {
    return {
      pass: false,
      message: /* @__PURE__ */ __name(() => `only inputs with type="checkbox" or type="radio" or elements with ${supportedRolesSentence()} and a valid aria-checked attribute can be used with .toBeChecked(). Use .toHaveValue() instead`, "message")
    };
  }
  const isChecked = /* @__PURE__ */ __name(() => {
    if (isValidInput()) return element.checked;
    return element.getAttribute("aria-checked") === "true";
  }, "isChecked");
  return {
    pass: isChecked(),
    message: /* @__PURE__ */ __name(() => {
      const is = isChecked() ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBeChecked`,
          "element",
          ""
        ),
        "",
        `Received element ${is} checked:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBeChecked, "toBeChecked");
function supportedRolesSentence() {
  return toSentence(
    supportedRoles().map((role) => `role="${role}"`),
    { lastWordConnector: " or " }
  );
}
__name(supportedRolesSentence, "supportedRolesSentence");
function supportedRoles() {
  return import_aria_query.roles.keys().filter(roleSupportsChecked);
}
__name(supportedRoles, "supportedRoles");
function roleSupportsChecked(role) {
  return import_aria_query.roles.get(role)?.props["aria-checked"] !== void 0;
}
__name(roleSupportsChecked, "roleSupportsChecked");
function toBePartiallyChecked(element) {
  checkHtmlElement(element, toBePartiallyChecked, this);
  const isValidInput = /* @__PURE__ */ __name(() => {
    return element.tagName.toLowerCase() === "input" && element.type === "checkbox";
  }, "isValidInput");
  const isValidAriaElement = /* @__PURE__ */ __name(() => {
    return element.getAttribute("role") === "checkbox";
  }, "isValidAriaElement");
  if (!isValidInput() && !isValidAriaElement()) {
    return {
      pass: false,
      message: /* @__PURE__ */ __name(() => 'only inputs with type="checkbox" or elements with role="checkbox" and a valid aria-checked attribute can be used with .toBePartiallyChecked(). Use .toHaveValue() instead', "message")
    };
  }
  const isPartiallyChecked = /* @__PURE__ */ __name(() => {
    const isAriaMixed = element.getAttribute("aria-checked") === "mixed";
    if (isValidInput()) {
      return element.indeterminate || isAriaMixed;
    }
    return isAriaMixed;
  }, "isPartiallyChecked");
  return {
    pass: isPartiallyChecked(),
    message: /* @__PURE__ */ __name(() => {
      const is = isPartiallyChecked() ? "is" : "is not";
      return [
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toBePartiallyChecked`,
          "element",
          ""
        ),
        "",
        `Received element ${is} partially checked:`,
        `  ${this.utils.printReceived(element.cloneNode(false))}`
      ].join("\n");
    }, "message")
  };
}
__name(toBePartiallyChecked, "toBePartiallyChecked");
function toHaveDescription(htmlElement, checkWith) {
  deprecate(
    "toHaveDescription",
    "Please use toHaveAccessibleDescription."
  );
  checkHtmlElement(htmlElement, toHaveDescription, this);
  const expectsDescription = checkWith !== void 0;
  const descriptionIDRaw = htmlElement.getAttribute("aria-describedby") || "";
  const descriptionIDs = descriptionIDRaw.split(/\s+/).filter(Boolean);
  let description = "";
  if (descriptionIDs.length > 0) {
    const document2 = htmlElement.ownerDocument;
    const descriptionEls = descriptionIDs.map((descriptionID) => document2.getElementById(descriptionID)).filter(Boolean);
    description = normalize(descriptionEls.map((el) => el.textContent).join(" "));
  }
  return {
    pass: expectsDescription ? checkWith instanceof RegExp ? checkWith.test(description) : this.equals(description, checkWith) : Boolean(description),
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      return getMessage3(
        this,
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toHaveDescription`,
          "element",
          ""
        ),
        `Expected the element ${to} have description`,
        this.utils.printExpected(checkWith),
        "Received",
        this.utils.printReceived(description)
      );
    }, "message")
  };
}
__name(toHaveDescription, "toHaveDescription");
function toHaveErrorMessage(htmlElement, checkWith) {
  deprecate("toHaveErrorMessage", "Please use toHaveAccessibleErrorMessage.");
  checkHtmlElement(htmlElement, toHaveErrorMessage, this);
  if (!htmlElement.hasAttribute("aria-invalid") || htmlElement.getAttribute("aria-invalid") === "false") {
    const not = this.isNot ? ".not" : "";
    return {
      pass: false,
      message: /* @__PURE__ */ __name(() => {
        return getMessage3(
          this,
          this.utils.matcherHint(`${not}.toHaveErrorMessage`, "element", ""),
          `Expected the element to have invalid state indicated by`,
          'aria-invalid="true"',
          "Received",
          htmlElement.hasAttribute("aria-invalid") ? `aria-invalid="${htmlElement.getAttribute("aria-invalid")}"` : this.utils.printReceived("")
        );
      }, "message")
    };
  }
  const expectsErrorMessage = checkWith !== void 0;
  const errormessageIDRaw = htmlElement.getAttribute("aria-errormessage") || "";
  const errormessageIDs = errormessageIDRaw.split(/\s+/).filter(Boolean);
  let errormessage = "";
  if (errormessageIDs.length > 0) {
    const document2 = htmlElement.ownerDocument;
    const errormessageEls = errormessageIDs.map((errormessageID) => document2.getElementById(errormessageID)).filter(Boolean);
    errormessage = normalize(
      errormessageEls.map((el) => el.textContent).join(" ")
    );
  }
  return {
    pass: expectsErrorMessage ? checkWith instanceof RegExp ? checkWith.test(errormessage) : this.equals(errormessage, checkWith) : Boolean(errormessage),
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      return getMessage3(
        this,
        this.utils.matcherHint(
          `${this.isNot ? ".not" : ""}.toHaveErrorMessage`,
          "element",
          ""
        ),
        `Expected the element ${to} have error message`,
        this.utils.printExpected(checkWith),
        "Received",
        this.utils.printReceived(errormessage)
      );
    }, "message")
  };
}
__name(toHaveErrorMessage, "toHaveErrorMessage");
function getSelection(element) {
  const selection = element.ownerDocument.getSelection();
  if (["input", "textarea"].includes(element.tagName.toLowerCase())) {
    if (["radio", "checkbox"].includes(element.type)) return "";
    return element.value.toString().substring(element.selectionStart, element.selectionEnd);
  }
  if (selection.anchorNode === null || selection.focusNode === null) {
    return "";
  }
  const originalRange = selection.getRangeAt(0);
  const temporaryRange = element.ownerDocument.createRange();
  if (selection.containsNode(element, false)) {
    temporaryRange.selectNodeContents(element);
    selection.removeAllRanges();
    selection.addRange(temporaryRange);
  } else if (element.contains(selection.anchorNode) && element.contains(selection.focusNode)) ;
  else {
    const selectionStartsWithinElement = element === originalRange.startContainer || element.contains(originalRange.startContainer);
    const selectionEndsWithinElement = element === originalRange.endContainer || element.contains(originalRange.endContainer);
    selection.removeAllRanges();
    if (selectionStartsWithinElement || selectionEndsWithinElement) {
      temporaryRange.selectNodeContents(element);
      if (selectionStartsWithinElement) {
        temporaryRange.setStart(
          originalRange.startContainer,
          originalRange.startOffset
        );
      }
      if (selectionEndsWithinElement) {
        temporaryRange.setEnd(
          originalRange.endContainer,
          originalRange.endOffset
        );
      }
      selection.addRange(temporaryRange);
    }
  }
  const result = selection.toString();
  selection.removeAllRanges();
  selection.addRange(originalRange);
  return result;
}
__name(getSelection, "getSelection");
function toHaveSelection(htmlElement, expectedSelection) {
  checkHtmlElement(htmlElement, toHaveSelection, this);
  const expectsSelection = expectedSelection !== void 0;
  if (expectsSelection && typeof expectedSelection !== "string") {
    throw new Error(`expected selection must be a string or undefined`);
  }
  const receivedSelection = getSelection(htmlElement);
  return {
    pass: expectsSelection ? compareAsSet(receivedSelection, expectedSelection) : Boolean(receivedSelection),
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      const matcher = this.utils.matcherHint(
        `${this.isNot ? ".not" : ""}.toHaveSelection`,
        "element",
        expectedSelection
      );
      return getMessage3(
        this,
        matcher,
        `Expected the element ${to} have selection`,
        expectsSelection ? expectedSelection : "(any)",
        "Received",
        receivedSelection
      );
    }, "message")
  };
}
__name(toHaveSelection, "toHaveSelection");
function toBePressed(element) {
  checkHtmlElement(element, toBePressed, this);
  const roles3 = (element.getAttribute("role") || "").split(" ").map((role) => role.trim());
  const isButton = element.tagName.toLowerCase() === "button" || element.tagName.toLowerCase() === "input" && element.type === "button" || roles3.includes("button");
  const pressedAttribute = element.getAttribute("aria-pressed");
  const isValidAriaElement = pressedAttribute === "true" || pressedAttribute === "false";
  if (!isButton || !isValidAriaElement) {
    return {
      pass: false,
      message: /* @__PURE__ */ __name(() => `Only button or input with type="button" or element with role="button" and a valid aria-pressed attribute can be used with .toBePressed()`, "message")
    };
  }
  const isPressed = pressedAttribute === "true";
  return {
    pass: isButton && isPressed,
    message: /* @__PURE__ */ __name(() => {
      const matcher = this.utils.matcherHint(
        `${this.isNot ? ".not" : ""}.toBePressed`,
        "element",
        ""
      );
      return getMessage3(
        this,
        matcher,
        `Expected element to have`,
        `aria-pressed="${this.isNot ? "false" : "true"}"`,
        `Received`,
        `aria-pressed="${pressedAttribute}"`
      );
    }, "message")
  };
}
__name(toBePressed, "toBePressed");
function toBePartiallyPressed(element) {
  checkHtmlElement(element, toBePartiallyPressed, this);
  const roles3 = (element.getAttribute("role") || "").split(" ").map((role) => role.trim());
  const isButton = element.tagName.toLowerCase() === "button" || element.tagName.toLowerCase() === "input" && element.type === "button" || roles3.includes("button");
  const pressedAttribute = element.getAttribute("aria-pressed");
  const isValidAriaElement = pressedAttribute === "true" || pressedAttribute === "false" || pressedAttribute === "mixed";
  if (!isButton || !isValidAriaElement) {
    return {
      pass: false,
      message: /* @__PURE__ */ __name(() => `Only button or input with type="button" or element with role="button" and a valid aria-pressed attribute can be used with .toBePartiallyPressed()`, "message")
    };
  }
  const isPartiallyPressed = pressedAttribute === "mixed";
  return {
    pass: isButton && isPartiallyPressed,
    message: /* @__PURE__ */ __name(() => {
      const to = this.isNot ? "not to" : "to";
      const matcher = this.utils.matcherHint(
        `${this.isNot ? ".not" : ""}.toBePartiallyPressed`,
        "element",
        ""
      );
      return getMessage3(
        this,
        matcher,
        `Expected element ${to} have`,
        `aria-pressed="mixed"`,
        `Received`,
        `aria-pressed="${pressedAttribute}"`
      );
    }, "message")
  };
}
__name(toBePartiallyPressed, "toBePartiallyPressed");
var DOCUMENT_POSITION_DISCONNECTED = 1;
var DOCUMENT_POSITION_PRECEDING = 2;
var DOCUMENT_POSITION_FOLLOWING = 4;
var DOCUMENT_POSITION_CONTAINS = 8;
var DOCUMENT_POSITION_CONTAINED_BY = 16;
var DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
var DOCUMENT_POSITIONS_STRINGS = {
  [DOCUMENT_POSITION_DISCONNECTED]: "Node.DOCUMENT_POSITION_DISCONNECTED",
  [DOCUMENT_POSITION_PRECEDING]: "Node.DOCUMENT_POSITION_PRECEDING",
  [DOCUMENT_POSITION_FOLLOWING]: "Node.DOCUMENT_POSITION_FOLLOWING",
  [DOCUMENT_POSITION_CONTAINS]: "Node.DOCUMENT_POSITION_CONTAINS",
  [DOCUMENT_POSITION_CONTAINED_BY]: "Node.DOCUMENT_POSITION_CONTAINED_BY",
  [DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC]: "Node.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC"
};
function makeDocumentPositionErrorString(documentPosition) {
  if (documentPosition in DOCUMENT_POSITIONS_STRINGS) {
    return `${DOCUMENT_POSITIONS_STRINGS[documentPosition]} (${documentPosition})`;
  }
  return `Unknown document position (${documentPosition})`;
}
__name(makeDocumentPositionErrorString, "makeDocumentPositionErrorString");
function checkToAppear(methodName, targetDocumentPosition) {
  return function(element, secondElement) {
    checkHtmlElement(element, toAppearBefore, this);
    checkHtmlElement(secondElement, toAppearBefore, this);
    const documentPosition = element.compareDocumentPosition(secondElement);
    const pass = documentPosition === targetDocumentPosition;
    return {
      pass,
      message: /* @__PURE__ */ __name(() => {
        return [
          this.utils.matcherHint(
            `${this.isNot ? ".not" : ""}.${methodName}`,
            "element",
            "secondElement"
          ),
          "",
          `Received: ${makeDocumentPositionErrorString(documentPosition)}`
        ].join("\n");
      }, "message")
    };
  };
}
__name(checkToAppear, "checkToAppear");
function toAppearBefore(element, secondElement) {
  return checkToAppear("toAppearBefore", DOCUMENT_POSITION_FOLLOWING).apply(
    this,
    [element, secondElement]
  );
}
__name(toAppearBefore, "toAppearBefore");
function toAppearAfter(element, secondElement) {
  return checkToAppear("toAppearAfter", DOCUMENT_POSITION_PRECEDING).apply(
    this,
    [element, secondElement]
  );
}
__name(toAppearAfter, "toAppearAfter");
var extensions = Object.freeze({
  __proto__: null,
  toAppearAfter,
  toAppearBefore,
  toBeChecked,
  toBeDisabled,
  toBeEmpty,
  toBeEmptyDOMElement,
  toBeEnabled,
  toBeInTheDOM,
  toBeInTheDocument,
  toBeInvalid,
  toBePartiallyChecked,
  toBePartiallyPressed,
  toBePressed,
  toBeRequired,
  toBeValid,
  toBeVisible,
  toContainElement,
  toContainHTML,
  toHaveAccessibleDescription,
  toHaveAccessibleErrorMessage,
  toHaveAccessibleName,
  toHaveAttribute,
  toHaveClass,
  toHaveDescription,
  toHaveDisplayValue,
  toHaveErrorMessage,
  toHaveFocus,
  toHaveFormValues,
  toHaveRole,
  toHaveSelection,
  toHaveStyle,
  toHaveTextContent,
  toHaveValue
});

// ../node_modules/@testing-library/jest-dom/dist/matchers.mjs
var import_redent2 = __toESM(require_redent(), 1);
var import_aria_query2 = __toESM(require_lib(), 1);
var import_picocolors2 = __toESM(require_picocolors_browser(), 1);
var import_css2 = __toESM(require_css_escape(), 1);

// ../node_modules/@vitest/utils/dist/index.js
var jsTokens_1;
var hasRequiredJsTokens;
function requireJsTokens() {
  if (hasRequiredJsTokens) return jsTokens_1;
  hasRequiredJsTokens = 1;
  var Identifier, JSXIdentifier, JSXPunctuator, JSXString, JSXText, KeywordsWithExpressionAfter, KeywordsWithNoLineTerminatorAfter, LineTerminatorSequence, MultiLineComment, Newline, NumericLiteral, Punctuator, RegularExpressionLiteral, SingleLineComment, StringLiteral, Template, TokensNotPrecedingObjectLiteral, TokensPrecedingExpression, WhiteSpace;
  RegularExpressionLiteral = /\/(?![*\/])(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\\]).|\\.)*(\/[$_\u200C\u200D\p{ID_Continue}]*|\\)?/yu;
  Punctuator = /--|\+\+|=>|\.{3}|\??\.(?!\d)|(?:&&|\|\||\?\?|[+\-%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2}|\/(?![\/*]))=?|[?~,:;[\](){}]/y;
  Identifier = /(\x23?)(?=[$_\p{ID_Start}\\])(?:[$_\u200C\u200D\p{ID_Continue}]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+/yu;
  StringLiteral = /(['"])(?:(?!\1)[^\\\n\r]|\\(?:\r\n|[^]))*(\1)?/y;
  NumericLiteral = /(?:0[xX][\da-fA-F](?:_?[\da-fA-F])*|0[oO][0-7](?:_?[0-7])*|0[bB][01](?:_?[01])*)n?|0n|[1-9](?:_?\d)*n|(?:(?:0(?!\d)|0\d*[89]\d*|[1-9](?:_?\d)*)(?:\.(?:\d(?:_?\d)*)?)?|\.\d(?:_?\d)*)(?:[eE][+-]?\d(?:_?\d)*)?|0[0-7]+/y;
  Template = /[`}](?:[^`\\$]|\\[^]|\$(?!\{))*(`|\$\{)?/y;
  WhiteSpace = /[\t\v\f\ufeff\p{Zs}]+/yu;
  LineTerminatorSequence = /\r?\n|[\r\u2028\u2029]/y;
  MultiLineComment = /\/\*(?:[^*]|\*(?!\/))*(\*\/)?/y;
  SingleLineComment = /\/\/.*/y;
  JSXPunctuator = /[<>.:={}]|\/(?![\/*])/y;
  JSXIdentifier = /[$_\p{ID_Start}][$_\u200C\u200D\p{ID_Continue}-]*/yu;
  JSXString = /(['"])(?:(?!\1)[^])*(\1)?/y;
  JSXText = /[^<>{}]+/y;
  TokensPrecedingExpression = /^(?:[\/+-]|\.{3}|\?(?:InterpolationIn(?:JSX|Template)|NoLineTerminatorHere|NonExpressionParenEnd|UnaryIncDec))?$|[{}([,;<>=*%&|^!~?:]$/;
  TokensNotPrecedingObjectLiteral = /^(?:=>|[;\]){}]|else|\?(?:NoLineTerminatorHere|NonExpressionParenEnd))?$/;
  KeywordsWithExpressionAfter = /^(?:await|case|default|delete|do|else|instanceof|new|return|throw|typeof|void|yield)$/;
  KeywordsWithNoLineTerminatorAfter = /^(?:return|throw|yield)$/;
  Newline = RegExp(LineTerminatorSequence.source);
  jsTokens_1 = /* @__PURE__ */ __name(function* (input2, { jsx = false } = {}) {
    var braces, firstCodePoint, isExpression, lastIndex, lastSignificantToken, length, match, mode, nextLastIndex, nextLastSignificantToken, parenNesting, postfixIncDec, punctuator, stack;
    ({ length } = input2);
    lastIndex = 0;
    lastSignificantToken = "";
    stack = [
      { tag: "JS" }
    ];
    braces = [];
    parenNesting = 0;
    postfixIncDec = false;
    while (lastIndex < length) {
      mode = stack[stack.length - 1];
      switch (mode.tag) {
        case "JS":
        case "JSNonExpressionParen":
        case "InterpolationInTemplate":
        case "InterpolationInJSX":
          if (input2[lastIndex] === "/" && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken))) {
            RegularExpressionLiteral.lastIndex = lastIndex;
            if (match = RegularExpressionLiteral.exec(input2)) {
              lastIndex = RegularExpressionLiteral.lastIndex;
              lastSignificantToken = match[0];
              postfixIncDec = true;
              yield {
                type: "RegularExpressionLiteral",
                value: match[0],
                closed: match[1] !== void 0 && match[1] !== "\\"
              };
              continue;
            }
          }
          Punctuator.lastIndex = lastIndex;
          if (match = Punctuator.exec(input2)) {
            punctuator = match[0];
            nextLastIndex = Punctuator.lastIndex;
            nextLastSignificantToken = punctuator;
            switch (punctuator) {
              case "(":
                if (lastSignificantToken === "?NonExpressionParenKeyword") {
                  stack.push({
                    tag: "JSNonExpressionParen",
                    nesting: parenNesting
                  });
                }
                parenNesting++;
                postfixIncDec = false;
                break;
              case ")":
                parenNesting--;
                postfixIncDec = true;
                if (mode.tag === "JSNonExpressionParen" && parenNesting === mode.nesting) {
                  stack.pop();
                  nextLastSignificantToken = "?NonExpressionParenEnd";
                  postfixIncDec = false;
                }
                break;
              case "{":
                Punctuator.lastIndex = 0;
                isExpression = !TokensNotPrecedingObjectLiteral.test(lastSignificantToken) && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken));
                braces.push(isExpression);
                postfixIncDec = false;
                break;
              case "}":
                switch (mode.tag) {
                  case "InterpolationInTemplate":
                    if (braces.length === mode.nesting) {
                      Template.lastIndex = lastIndex;
                      match = Template.exec(input2);
                      lastIndex = Template.lastIndex;
                      lastSignificantToken = match[0];
                      if (match[1] === "${") {
                        lastSignificantToken = "?InterpolationInTemplate";
                        postfixIncDec = false;
                        yield {
                          type: "TemplateMiddle",
                          value: match[0]
                        };
                      } else {
                        stack.pop();
                        postfixIncDec = true;
                        yield {
                          type: "TemplateTail",
                          value: match[0],
                          closed: match[1] === "`"
                        };
                      }
                      continue;
                    }
                    break;
                  case "InterpolationInJSX":
                    if (braces.length === mode.nesting) {
                      stack.pop();
                      lastIndex += 1;
                      lastSignificantToken = "}";
                      yield {
                        type: "JSXPunctuator",
                        value: "}"
                      };
                      continue;
                    }
                }
                postfixIncDec = braces.pop();
                nextLastSignificantToken = postfixIncDec ? "?ExpressionBraceEnd" : "}";
                break;
              case "]":
                postfixIncDec = true;
                break;
              case "++":
              case "--":
                nextLastSignificantToken = postfixIncDec ? "?PostfixIncDec" : "?UnaryIncDec";
                break;
              case "<":
                if (jsx && (TokensPrecedingExpression.test(lastSignificantToken) || KeywordsWithExpressionAfter.test(lastSignificantToken))) {
                  stack.push({ tag: "JSXTag" });
                  lastIndex += 1;
                  lastSignificantToken = "<";
                  yield {
                    type: "JSXPunctuator",
                    value: punctuator
                  };
                  continue;
                }
                postfixIncDec = false;
                break;
              default:
                postfixIncDec = false;
            }
            lastIndex = nextLastIndex;
            lastSignificantToken = nextLastSignificantToken;
            yield {
              type: "Punctuator",
              value: punctuator
            };
            continue;
          }
          Identifier.lastIndex = lastIndex;
          if (match = Identifier.exec(input2)) {
            lastIndex = Identifier.lastIndex;
            nextLastSignificantToken = match[0];
            switch (match[0]) {
              case "for":
              case "if":
              case "while":
              case "with":
                if (lastSignificantToken !== "." && lastSignificantToken !== "?.") {
                  nextLastSignificantToken = "?NonExpressionParenKeyword";
                }
            }
            lastSignificantToken = nextLastSignificantToken;
            postfixIncDec = !KeywordsWithExpressionAfter.test(match[0]);
            yield {
              type: match[1] === "#" ? "PrivateIdentifier" : "IdentifierName",
              value: match[0]
            };
            continue;
          }
          StringLiteral.lastIndex = lastIndex;
          if (match = StringLiteral.exec(input2)) {
            lastIndex = StringLiteral.lastIndex;
            lastSignificantToken = match[0];
            postfixIncDec = true;
            yield {
              type: "StringLiteral",
              value: match[0],
              closed: match[2] !== void 0
            };
            continue;
          }
          NumericLiteral.lastIndex = lastIndex;
          if (match = NumericLiteral.exec(input2)) {
            lastIndex = NumericLiteral.lastIndex;
            lastSignificantToken = match[0];
            postfixIncDec = true;
            yield {
              type: "NumericLiteral",
              value: match[0]
            };
            continue;
          }
          Template.lastIndex = lastIndex;
          if (match = Template.exec(input2)) {
            lastIndex = Template.lastIndex;
            lastSignificantToken = match[0];
            if (match[1] === "${") {
              lastSignificantToken = "?InterpolationInTemplate";
              stack.push({
                tag: "InterpolationInTemplate",
                nesting: braces.length
              });
              postfixIncDec = false;
              yield {
                type: "TemplateHead",
                value: match[0]
              };
            } else {
              postfixIncDec = true;
              yield {
                type: "NoSubstitutionTemplate",
                value: match[0],
                closed: match[1] === "`"
              };
            }
            continue;
          }
          break;
        case "JSXTag":
        case "JSXTagEnd":
          JSXPunctuator.lastIndex = lastIndex;
          if (match = JSXPunctuator.exec(input2)) {
            lastIndex = JSXPunctuator.lastIndex;
            nextLastSignificantToken = match[0];
            switch (match[0]) {
              case "<":
                stack.push({ tag: "JSXTag" });
                break;
              case ">":
                stack.pop();
                if (lastSignificantToken === "/" || mode.tag === "JSXTagEnd") {
                  nextLastSignificantToken = "?JSX";
                  postfixIncDec = true;
                } else {
                  stack.push({ tag: "JSXChildren" });
                }
                break;
              case "{":
                stack.push({
                  tag: "InterpolationInJSX",
                  nesting: braces.length
                });
                nextLastSignificantToken = "?InterpolationInJSX";
                postfixIncDec = false;
                break;
              case "/":
                if (lastSignificantToken === "<") {
                  stack.pop();
                  if (stack[stack.length - 1].tag === "JSXChildren") {
                    stack.pop();
                  }
                  stack.push({ tag: "JSXTagEnd" });
                }
            }
            lastSignificantToken = nextLastSignificantToken;
            yield {
              type: "JSXPunctuator",
              value: match[0]
            };
            continue;
          }
          JSXIdentifier.lastIndex = lastIndex;
          if (match = JSXIdentifier.exec(input2)) {
            lastIndex = JSXIdentifier.lastIndex;
            lastSignificantToken = match[0];
            yield {
              type: "JSXIdentifier",
              value: match[0]
            };
            continue;
          }
          JSXString.lastIndex = lastIndex;
          if (match = JSXString.exec(input2)) {
            lastIndex = JSXString.lastIndex;
            lastSignificantToken = match[0];
            yield {
              type: "JSXString",
              value: match[0],
              closed: match[2] !== void 0
            };
            continue;
          }
          break;
        case "JSXChildren":
          JSXText.lastIndex = lastIndex;
          if (match = JSXText.exec(input2)) {
            lastIndex = JSXText.lastIndex;
            lastSignificantToken = match[0];
            yield {
              type: "JSXText",
              value: match[0]
            };
            continue;
          }
          switch (input2[lastIndex]) {
            case "<":
              stack.push({ tag: "JSXTag" });
              lastIndex++;
              lastSignificantToken = "<";
              yield {
                type: "JSXPunctuator",
                value: "<"
              };
              continue;
            case "{":
              stack.push({
                tag: "InterpolationInJSX",
                nesting: braces.length
              });
              lastIndex++;
              lastSignificantToken = "?InterpolationInJSX";
              postfixIncDec = false;
              yield {
                type: "JSXPunctuator",
                value: "{"
              };
              continue;
          }
      }
      WhiteSpace.lastIndex = lastIndex;
      if (match = WhiteSpace.exec(input2)) {
        lastIndex = WhiteSpace.lastIndex;
        yield {
          type: "WhiteSpace",
          value: match[0]
        };
        continue;
      }
      LineTerminatorSequence.lastIndex = lastIndex;
      if (match = LineTerminatorSequence.exec(input2)) {
        lastIndex = LineTerminatorSequence.lastIndex;
        postfixIncDec = false;
        if (KeywordsWithNoLineTerminatorAfter.test(lastSignificantToken)) {
          lastSignificantToken = "?NoLineTerminatorHere";
        }
        yield {
          type: "LineTerminatorSequence",
          value: match[0]
        };
        continue;
      }
      MultiLineComment.lastIndex = lastIndex;
      if (match = MultiLineComment.exec(input2)) {
        lastIndex = MultiLineComment.lastIndex;
        if (Newline.test(match[0])) {
          postfixIncDec = false;
          if (KeywordsWithNoLineTerminatorAfter.test(lastSignificantToken)) {
            lastSignificantToken = "?NoLineTerminatorHere";
          }
        }
        yield {
          type: "MultiLineComment",
          value: match[0],
          closed: match[1] !== void 0
        };
        continue;
      }
      SingleLineComment.lastIndex = lastIndex;
      if (match = SingleLineComment.exec(input2)) {
        lastIndex = SingleLineComment.lastIndex;
        postfixIncDec = false;
        yield {
          type: "SingleLineComment",
          value: match[0]
        };
        continue;
      }
      firstCodePoint = String.fromCodePoint(input2.codePointAt(lastIndex));
      lastIndex += firstCodePoint.length;
      lastSignificantToken = firstCodePoint;
      postfixIncDec = false;
      yield {
        type: mode.tag.startsWith("JSX") ? "JSXInvalid" : "Invalid",
        value: firstCodePoint
      };
    }
    return void 0;
  }, "jsTokens_1");
  return jsTokens_1;
}
__name(requireJsTokens, "requireJsTokens");
var jsTokensExports = requireJsTokens();
var jsTokens = getDefaultExportFromCjs(jsTokensExports);
var reservedWords = {
  keyword: [
    "break",
    "case",
    "catch",
    "continue",
    "debugger",
    "default",
    "do",
    "else",
    "finally",
    "for",
    "function",
    "if",
    "return",
    "switch",
    "throw",
    "try",
    "var",
    "const",
    "while",
    "with",
    "new",
    "this",
    "super",
    "class",
    "extends",
    "export",
    "import",
    "null",
    "true",
    "false",
    "in",
    "instanceof",
    "typeof",
    "void",
    "delete"
  ],
  strict: [
    "implements",
    "interface",
    "let",
    "package",
    "private",
    "protected",
    "public",
    "static",
    "yield"
  ]
};
var keywords = new Set(reservedWords.keyword);
var reservedWordsStrictSet = new Set(reservedWords.strict);
var SAFE_TIMERS_SYMBOL = Symbol("vitest:SAFE_TIMERS");

// ../node_modules/@vitest/spy/node_modules/tinyspy/dist/index.js
function S(e2, t2) {
  if (!e2)
    throw new Error(t2);
}
__name(S, "S");
function f(e2, t2) {
  return typeof t2 === e2;
}
__name(f, "f");
function w(e2) {
  return e2 instanceof Promise;
}
__name(w, "w");
function u(e2, t2, r2) {
  Object.defineProperty(e2, t2, r2);
}
__name(u, "u");
function l(e2, t2, r2) {
  u(e2, t2, { value: r2, configurable: true, writable: true });
}
__name(l, "l");
var y = Symbol.for("tinyspy:spy");
var x = /* @__PURE__ */ new Set();
var h = /* @__PURE__ */ __name((e2) => {
  e2.called = false, e2.callCount = 0, e2.calls = [], e2.results = [], e2.resolves = [], e2.next = [];
}, "h");
var k = /* @__PURE__ */ __name((e2) => (u(e2, y, {
  value: { reset: /* @__PURE__ */ __name(() => h(e2[y]), "reset") }
}), e2[y]), "k");
var T = /* @__PURE__ */ __name((e2) => e2[y] || k(e2), "T");
function R(e2) {
  S(
    f("function", e2) || f("undefined", e2),
    "cannot spy on a non-function value"
  );
  let t2 = /* @__PURE__ */ __name(function(...s3) {
    let n2 = T(t2);
    n2.called = true, n2.callCount++, n2.calls.push(s3);
    let d = n2.next.shift();
    if (d) {
      n2.results.push(d);
      let [a, i2] = d;
      if (a === "ok")
        return i2;
      throw i2;
    }
    let o2, c2 = "ok", p = n2.results.length;
    if (n2.impl)
      try {
        new.target ? o2 = Reflect.construct(n2.impl, s3, new.target) : o2 = n2.impl.apply(this, s3), c2 = "ok";
      } catch (a) {
        throw o2 = a, c2 = "error", n2.results.push([c2, a]), a;
      }
    let g2 = [c2, o2];
    return w(o2) && o2.then(
      (a) => n2.resolves[p] = ["ok", a],
      (a) => n2.resolves[p] = ["error", a]
    ), n2.results.push(g2), o2;
  }, "t");
  l(t2, "_isMockFunction", true), l(t2, "length", e2 ? e2.length : 0), l(t2, "name", e2 && e2.name || "spy");
  let r2 = T(t2);
  return r2.reset(), r2.impl = e2, t2;
}
__name(R, "R");
function v(e2) {
  return !!e2 && e2._isMockFunction === true;
}
__name(v, "v");
var b = /* @__PURE__ */ __name((e2, t2) => {
  let r2 = Object.getOwnPropertyDescriptor(e2, t2);
  if (r2)
    return [e2, r2];
  let s3 = Object.getPrototypeOf(e2);
  for (; s3 !== null; ) {
    let n2 = Object.getOwnPropertyDescriptor(s3, t2);
    if (n2)
      return [s3, n2];
    s3 = Object.getPrototypeOf(s3);
  }
}, "b");
var P = /* @__PURE__ */ __name((e2, t2) => {
  t2 != null && typeof t2 == "function" && t2.prototype != null && Object.setPrototypeOf(e2.prototype, t2.prototype);
}, "P");
function M(e2, t2, r2) {
  S(
    !f("undefined", e2),
    "spyOn could not find an object to spy upon"
  ), S(
    f("object", e2) || f("function", e2),
    "cannot spyOn on a primitive value"
  );
  let [s3, n2] = (() => {
    if (!f("object", t2))
      return [t2, "value"];
    if ("getter" in t2 && "setter" in t2)
      throw new Error("cannot spy on both getter and setter");
    if ("getter" in t2)
      return [t2.getter, "get"];
    if ("setter" in t2)
      return [t2.setter, "set"];
    throw new Error("specify getter or setter to spy on");
  })(), [d, o2] = b(e2, s3) || [];
  S(
    o2 || s3 in e2,
    `${String(s3)} does not exist`
  );
  let c2 = false;
  n2 === "value" && o2 && !o2.value && o2.get && (n2 = "get", c2 = true, r2 = o2.get());
  let p;
  o2 ? p = o2[n2] : n2 !== "value" ? p = /* @__PURE__ */ __name(() => e2[s3], "p") : p = e2[s3], p && j(p) && (p = p[y].getOriginal());
  let g2 = /* @__PURE__ */ __name((I) => {
    let { value: F, ...O } = o2 || {
      configurable: true,
      writable: true
    };
    n2 !== "value" && delete O.writable, O[n2] = I, u(e2, s3, O);
  }, "g"), a = /* @__PURE__ */ __name(() => {
    d !== e2 ? Reflect.deleteProperty(e2, s3) : o2 && !p ? u(e2, s3, o2) : g2(p);
  }, "a");
  r2 || (r2 = p);
  let i2 = E(R(r2), r2);
  n2 === "value" && P(i2, p);
  let m2 = i2[y];
  return l(m2, "restore", a), l(m2, "getOriginal", () => c2 ? p() : p), l(m2, "willCall", (I) => (m2.impl = I, i2)), g2(
    c2 ? () => (P(i2, r2), i2) : i2
  ), x.add(i2), i2;
}
__name(M, "M");
var K = /* @__PURE__ */ new Set([
  "length",
  "name",
  "prototype"
]);
function D(e2) {
  let t2 = /* @__PURE__ */ new Set(), r2 = {};
  for (; e2 && e2 !== Object.prototype && e2 !== Function.prototype; ) {
    let s3 = [
      ...Object.getOwnPropertyNames(e2),
      ...Object.getOwnPropertySymbols(e2)
    ];
    for (let n2 of s3)
      r2[n2] || K.has(n2) || (t2.add(n2), r2[n2] = Object.getOwnPropertyDescriptor(e2, n2));
    e2 = Object.getPrototypeOf(e2);
  }
  return {
    properties: t2,
    descriptors: r2
  };
}
__name(D, "D");
function E(e2, t2) {
  if (!t2 || // the original is already a spy, so it has all the properties
  y in t2)
    return e2;
  let { properties: r2, descriptors: s3 } = D(t2);
  for (let n2 of r2) {
    let d = s3[n2];
    b(e2, n2) || u(e2, n2, d);
  }
  return e2;
}
__name(E, "E");
function j(e2) {
  return v(e2) && "getOriginal" in e2[y];
}
__name(j, "j");

// ../node_modules/@vitest/spy/dist/index.js
var mocks = /* @__PURE__ */ new Set();
function isMockFunction(fn3) {
  return typeof fn3 === "function" && "_isMockFunction" in fn3 && fn3._isMockFunction;
}
__name(isMockFunction, "isMockFunction");
function spyOn(obj, method, accessType) {
  const dictionary = {
    get: "getter",
    set: "setter"
  };
  const objMethod = accessType ? { [dictionary[accessType]]: method } : method;
  let state;
  const descriptor = getDescriptor(obj, method);
  const fn3 = descriptor && descriptor[accessType || "value"];
  if (isMockFunction(fn3)) {
    state = fn3.mock._state();
  }
  try {
    const stub = M(obj, objMethod);
    const spy = enhanceSpy(stub);
    if (state) {
      spy.mock._state(state);
    }
    return spy;
  } catch (error) {
    if (error instanceof TypeError && Symbol.toStringTag && obj[Symbol.toStringTag] === "Module" && (error.message.includes("Cannot redefine property") || error.message.includes("Cannot replace module namespace") || error.message.includes("can't redefine non-configurable property"))) {
      throw new TypeError(`Cannot spy on export "${String(objMethod)}". Module namespace is not configurable in ESM. See: https://vitest.dev/guide/browser/#limitations`, { cause: error });
    }
    throw error;
  }
}
__name(spyOn, "spyOn");
var callOrder = 0;
function enhanceSpy(spy) {
  const stub = spy;
  let implementation;
  let onceImplementations = [];
  let implementationChangedTemporarily = false;
  let instances = [];
  let contexts = [];
  let invocations = [];
  const state = T(spy);
  const mockContext = {
    get calls() {
      return state.calls;
    },
    get contexts() {
      return contexts;
    },
    get instances() {
      return instances;
    },
    get invocationCallOrder() {
      return invocations;
    },
    get results() {
      return state.results.map(([callType, value]) => {
        const type5 = callType === "error" ? "throw" : "return";
        return {
          type: type5,
          value
        };
      });
    },
    get settledResults() {
      return state.resolves.map(([callType, value]) => {
        const type5 = callType === "error" ? "rejected" : "fulfilled";
        return {
          type: type5,
          value
        };
      });
    },
    get lastCall() {
      return state.calls[state.calls.length - 1];
    },
    _state(state2) {
      if (state2) {
        implementation = state2.implementation;
        onceImplementations = state2.onceImplementations;
        implementationChangedTemporarily = state2.implementationChangedTemporarily;
      }
      return {
        implementation,
        onceImplementations,
        implementationChangedTemporarily
      };
    }
  };
  function mockCall(...args) {
    instances.push(this);
    contexts.push(this);
    invocations.push(++callOrder);
    const impl = implementationChangedTemporarily ? implementation : onceImplementations.shift() || implementation || state.getOriginal() || (() => {
    });
    return impl.apply(this, args);
  }
  __name(mockCall, "mockCall");
  let name = stub.name;
  stub.getMockName = () => name || "vi.fn()";
  stub.mockName = (n2) => {
    name = n2;
    return stub;
  };
  stub.mockClear = () => {
    state.reset();
    instances = [];
    contexts = [];
    invocations = [];
    return stub;
  };
  stub.mockReset = () => {
    stub.mockClear();
    implementation = void 0;
    onceImplementations = [];
    return stub;
  };
  stub.mockRestore = () => {
    stub.mockReset();
    state.restore();
    return stub;
  };
  if (Symbol.dispose) {
    stub[Symbol.dispose] = () => stub.mockRestore();
  }
  stub.getMockImplementation = () => implementationChangedTemporarily ? implementation : onceImplementations.at(0) || implementation;
  stub.mockImplementation = (fn3) => {
    implementation = fn3;
    state.willCall(mockCall);
    return stub;
  };
  stub.mockImplementationOnce = (fn3) => {
    onceImplementations.push(fn3);
    return stub;
  };
  function withImplementation(fn3, cb) {
    const originalImplementation = implementation;
    implementation = fn3;
    state.willCall(mockCall);
    implementationChangedTemporarily = true;
    const reset = /* @__PURE__ */ __name(() => {
      implementation = originalImplementation;
      implementationChangedTemporarily = false;
    }, "reset");
    const result = cb();
    if (typeof result === "object" && result && typeof result.then === "function") {
      return result.then(() => {
        reset();
        return stub;
      });
    }
    reset();
    return stub;
  }
  __name(withImplementation, "withImplementation");
  stub.withImplementation = withImplementation;
  stub.mockReturnThis = () => stub.mockImplementation(function() {
    return this;
  });
  stub.mockReturnValue = (val) => stub.mockImplementation(() => val);
  stub.mockReturnValueOnce = (val) => stub.mockImplementationOnce(() => val);
  stub.mockResolvedValue = (val) => stub.mockImplementation(() => Promise.resolve(val));
  stub.mockResolvedValueOnce = (val) => stub.mockImplementationOnce(() => Promise.resolve(val));
  stub.mockRejectedValue = (val) => stub.mockImplementation(() => Promise.reject(val));
  stub.mockRejectedValueOnce = (val) => stub.mockImplementationOnce(() => Promise.reject(val));
  Object.defineProperty(stub, "mock", { get: /* @__PURE__ */ __name(() => mockContext, "get") });
  state.willCall(mockCall);
  mocks.add(stub);
  return stub;
}
__name(enhanceSpy, "enhanceSpy");
function fn(implementation) {
  const enhancedSpy = enhanceSpy(M({ spy: implementation || function() {
  } }, "spy"));
  if (implementation) {
    enhancedSpy.mockImplementation(implementation);
  }
  return enhancedSpy;
}
__name(fn, "fn");
function getDescriptor(obj, method) {
  const objDescriptor = Object.getOwnPropertyDescriptor(obj, method);
  if (objDescriptor) {
    return objDescriptor;
  }
  let currentProto = Object.getPrototypeOf(obj);
  while (currentProto !== null) {
    const descriptor = Object.getOwnPropertyDescriptor(currentProto, method);
    if (descriptor) {
      return descriptor;
    }
    currentProto = Object.getPrototypeOf(currentProto);
  }
}
__name(getDescriptor, "getDescriptor");

// ../node_modules/@vitest/expect/dist/index.js
var MATCHERS_OBJECT = Symbol.for("matchers-object");
var JEST_MATCHERS_OBJECT = Symbol.for("$$jest-matchers-object-storybook");
var GLOBAL_EXPECT = Symbol.for("expect-global");
var ASYMMETRIC_MATCHERS_OBJECT = Symbol.for("asymmetric-matchers-object");
var customMatchers = {
  toSatisfy(actual, expected, message) {
    const { printReceived: printReceived2, printExpected: printExpected2, matcherHint: matcherHint2 } = this.utils;
    const pass = expected(actual);
    return {
      pass,
      message: /* @__PURE__ */ __name(() => pass ? `${matcherHint2(".not.toSatisfy", "received", "")}

Expected value to not satisfy:
${message || printExpected2(expected)}
Received:
${printReceived2(actual)}` : `${matcherHint2(".toSatisfy", "received", "")}

Expected value to satisfy:
${message || printExpected2(expected)}

Received:
${printReceived2(actual)}`, "message")
    };
  },
  toBeOneOf(actual, expected) {
    const { equals: equals2, customTesters } = this;
    const { printReceived: printReceived2, printExpected: printExpected2, matcherHint: matcherHint2 } = this.utils;
    if (!Array.isArray(expected)) {
      throw new TypeError(`You must provide an array to ${matcherHint2(".toBeOneOf")}, not '${typeof expected}'.`);
    }
    const pass = expected.length === 0 || expected.some((item) => equals2(item, actual, customTesters));
    return {
      pass,
      message: /* @__PURE__ */ __name(() => pass ? `${matcherHint2(".not.toBeOneOf", "received", "")}

Expected value to not be one of:
${printExpected2(expected)}
Received:
${printReceived2(actual)}` : `${matcherHint2(".toBeOneOf", "received", "")}

Expected value to be one of:
${printExpected2(expected)}

Received:
${printReceived2(actual)}`, "message")
    };
  }
};
var EXPECTED_COLOR = s.green;
var RECEIVED_COLOR = s.red;
var INVERTED_COLOR = s.inverse;
var BOLD_WEIGHT = s.bold;
var DIM_COLOR = s.dim;
function matcherHint(matcherName, received = "received", expected = "expected", options = {}) {
  const { comment = "", isDirectExpectCall = false, isNot = false, promise = "", secondArgument = "", expectedColor = EXPECTED_COLOR, receivedColor = RECEIVED_COLOR, secondArgumentColor = EXPECTED_COLOR } = options;
  let hint = "";
  let dimString = "expect";
  if (!isDirectExpectCall && received !== "") {
    hint += DIM_COLOR(`${dimString}(`) + receivedColor(received);
    dimString = ")";
  }
  if (promise !== "") {
    hint += DIM_COLOR(`${dimString}.`) + promise;
    dimString = "";
  }
  if (isNot) {
    hint += `${DIM_COLOR(`${dimString}.`)}not`;
    dimString = "";
  }
  if (matcherName.includes(".")) {
    dimString += matcherName;
  } else {
    hint += DIM_COLOR(`${dimString}.`) + matcherName;
    dimString = "";
  }
  if (expected === "") {
    dimString += "()";
  } else {
    hint += DIM_COLOR(`${dimString}(`) + expectedColor(expected);
    if (secondArgument) {
      hint += DIM_COLOR(", ") + secondArgumentColor(secondArgument);
    }
    dimString = ")";
  }
  if (comment !== "") {
    dimString += ` // ${comment}`;
  }
  if (dimString !== "") {
    hint += DIM_COLOR(dimString);
  }
  return hint;
}
__name(matcherHint, "matcherHint");
var SPACE_SYMBOL = "\xB7";
function replaceTrailingSpaces(text) {
  return text.replace(/\s+$/gm, (spaces) => SPACE_SYMBOL.repeat(spaces.length));
}
__name(replaceTrailingSpaces, "replaceTrailingSpaces");
function printReceived(object) {
  return RECEIVED_COLOR(replaceTrailingSpaces(stringify(object)));
}
__name(printReceived, "printReceived");
function printExpected(value) {
  return EXPECTED_COLOR(replaceTrailingSpaces(stringify(value)));
}
__name(printExpected, "printExpected");
function getMatcherUtils() {
  return {
    EXPECTED_COLOR,
    RECEIVED_COLOR,
    INVERTED_COLOR,
    BOLD_WEIGHT,
    DIM_COLOR,
    diff,
    matcherHint,
    printReceived,
    printExpected,
    printDiffOrStringify,
    printWithType
  };
}
__name(getMatcherUtils, "getMatcherUtils");
function printWithType(name, value, print) {
  const type5 = getType(value);
  const hasType = type5 !== "null" && type5 !== "undefined" ? `${name} has type:  ${type5}
` : "";
  const hasValue = `${name} has value: ${print(value)}`;
  return hasType + hasValue;
}
__name(printWithType, "printWithType");
function getCustomEqualityTesters() {
  return globalThis[JEST_MATCHERS_OBJECT].customEqualityTesters;
}
__name(getCustomEqualityTesters, "getCustomEqualityTesters");
function equals(a, b2, customTesters, strictCheck) {
  customTesters = customTesters || [];
  return eq(a, b2, [], [], customTesters, strictCheck ? hasKey : hasDefinedKey);
}
__name(equals, "equals");
var functionToString = Function.prototype.toString;
function isAsymmetric(obj) {
  return !!obj && typeof obj === "object" && "asymmetricMatch" in obj && isA("Function", obj.asymmetricMatch);
}
__name(isAsymmetric, "isAsymmetric");
function asymmetricMatch(a, b2) {
  const asymmetricA = isAsymmetric(a);
  const asymmetricB = isAsymmetric(b2);
  if (asymmetricA && asymmetricB) {
    return void 0;
  }
  if (asymmetricA) {
    return a.asymmetricMatch(b2);
  }
  if (asymmetricB) {
    return b2.asymmetricMatch(a);
  }
}
__name(asymmetricMatch, "asymmetricMatch");
function eq(a, b2, aStack, bStack, customTesters, hasKey2) {
  let result = true;
  const asymmetricResult = asymmetricMatch(a, b2);
  if (asymmetricResult !== void 0) {
    return asymmetricResult;
  }
  const testerContext = { equals };
  for (let i2 = 0; i2 < customTesters.length; i2++) {
    const customTesterResult = customTesters[i2].call(testerContext, a, b2, customTesters);
    if (customTesterResult !== void 0) {
      return customTesterResult;
    }
  }
  if (typeof URL === "function" && a instanceof URL && b2 instanceof URL) {
    return a.href === b2.href;
  }
  if (Object.is(a, b2)) {
    return true;
  }
  if (a === null || b2 === null) {
    return a === b2;
  }
  const className = Object.prototype.toString.call(a);
  if (className !== Object.prototype.toString.call(b2)) {
    return false;
  }
  switch (className) {
    case "[object Boolean]":
    case "[object String]":
    case "[object Number]":
      if (typeof a !== typeof b2) {
        return false;
      } else if (typeof a !== "object" && typeof b2 !== "object") {
        return Object.is(a, b2);
      } else {
        return Object.is(a.valueOf(), b2.valueOf());
      }
    case "[object Date]": {
      const numA = +a;
      const numB = +b2;
      return numA === numB || Number.isNaN(numA) && Number.isNaN(numB);
    }
    case "[object RegExp]":
      return a.source === b2.source && a.flags === b2.flags;
    case "[object Temporal.Instant]":
    case "[object Temporal.ZonedDateTime]":
    case "[object Temporal.PlainDateTime]":
    case "[object Temporal.PlainDate]":
    case "[object Temporal.PlainTime]":
    case "[object Temporal.PlainYearMonth]":
    case "[object Temporal.PlainMonthDay]":
      return a.equals(b2);
    case "[object Temporal.Duration]":
      return a.toString() === b2.toString();
  }
  if (typeof a !== "object" || typeof b2 !== "object") {
    return false;
  }
  if (isDomNode(a) && isDomNode(b2)) {
    return a.isEqualNode(b2);
  }
  let length = aStack.length;
  while (length--) {
    if (aStack[length] === a) {
      return bStack[length] === b2;
    } else if (bStack[length] === b2) {
      return false;
    }
  }
  aStack.push(a);
  bStack.push(b2);
  if (className === "[object Array]" && a.length !== b2.length) {
    return false;
  }
  if (a instanceof Error && b2 instanceof Error) {
    try {
      return isErrorEqual(a, b2, aStack, bStack, customTesters, hasKey2);
    } finally {
      aStack.pop();
      bStack.pop();
    }
  }
  const aKeys = keys(a, hasKey2);
  let key;
  let size = aKeys.length;
  if (keys(b2, hasKey2).length !== size) {
    return false;
  }
  while (size--) {
    key = aKeys[size];
    result = hasKey2(b2, key) && eq(a[key], b2[key], aStack, bStack, customTesters, hasKey2);
    if (!result) {
      return false;
    }
  }
  aStack.pop();
  bStack.pop();
  return result;
}
__name(eq, "eq");
function isErrorEqual(a, b2, aStack, bStack, customTesters, hasKey2) {
  let result = Object.getPrototypeOf(a) === Object.getPrototypeOf(b2) && a.name === b2.name && a.message === b2.message;
  if (typeof b2.cause !== "undefined") {
    result && (result = eq(a.cause, b2.cause, aStack, bStack, customTesters, hasKey2));
  }
  if (a instanceof AggregateError && b2 instanceof AggregateError) {
    result && (result = eq(a.errors, b2.errors, aStack, bStack, customTesters, hasKey2));
  }
  result && (result = eq({ ...a }, { ...b2 }, aStack, bStack, customTesters, hasKey2));
  return result;
}
__name(isErrorEqual, "isErrorEqual");
function keys(obj, hasKey2) {
  const keys2 = [];
  for (const key in obj) {
    if (hasKey2(obj, key)) {
      keys2.push(key);
    }
  }
  return keys2.concat(Object.getOwnPropertySymbols(obj).filter((symbol) => Object.getOwnPropertyDescriptor(obj, symbol).enumerable));
}
__name(keys, "keys");
function hasDefinedKey(obj, key) {
  return hasKey(obj, key) && obj[key] !== void 0;
}
__name(hasDefinedKey, "hasDefinedKey");
function hasKey(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}
__name(hasKey, "hasKey");
function isA(typeName, value) {
  return Object.prototype.toString.apply(value) === `[object ${typeName}]`;
}
__name(isA, "isA");
function isDomNode(obj) {
  return obj !== null && typeof obj === "object" && "nodeType" in obj && typeof obj.nodeType === "number" && "nodeName" in obj && typeof obj.nodeName === "string" && "isEqualNode" in obj && typeof obj.isEqualNode === "function";
}
__name(isDomNode, "isDomNode");
var IS_KEYED_SENTINEL = "@@__IMMUTABLE_KEYED__@@";
var IS_SET_SENTINEL = "@@__IMMUTABLE_SET__@@";
var IS_LIST_SENTINEL = "@@__IMMUTABLE_LIST__@@";
var IS_ORDERED_SENTINEL = "@@__IMMUTABLE_ORDERED__@@";
var IS_RECORD_SYMBOL = "@@__IMMUTABLE_RECORD__@@";
function isImmutableUnorderedKeyed(maybeKeyed) {
  return !!(maybeKeyed && maybeKeyed[IS_KEYED_SENTINEL] && !maybeKeyed[IS_ORDERED_SENTINEL]);
}
__name(isImmutableUnorderedKeyed, "isImmutableUnorderedKeyed");
function isImmutableUnorderedSet(maybeSet) {
  return !!(maybeSet && maybeSet[IS_SET_SENTINEL] && !maybeSet[IS_ORDERED_SENTINEL]);
}
__name(isImmutableUnorderedSet, "isImmutableUnorderedSet");
function isObjectLiteral(source) {
  return source != null && typeof source === "object" && !Array.isArray(source);
}
__name(isObjectLiteral, "isObjectLiteral");
function isImmutableList(source) {
  return Boolean(source && isObjectLiteral(source) && source[IS_LIST_SENTINEL]);
}
__name(isImmutableList, "isImmutableList");
function isImmutableOrderedKeyed(source) {
  return Boolean(source && isObjectLiteral(source) && source[IS_KEYED_SENTINEL] && source[IS_ORDERED_SENTINEL]);
}
__name(isImmutableOrderedKeyed, "isImmutableOrderedKeyed");
function isImmutableOrderedSet(source) {
  return Boolean(source && isObjectLiteral(source) && source[IS_SET_SENTINEL] && source[IS_ORDERED_SENTINEL]);
}
__name(isImmutableOrderedSet, "isImmutableOrderedSet");
function isImmutableRecord(source) {
  return Boolean(source && isObjectLiteral(source) && source[IS_RECORD_SYMBOL]);
}
__name(isImmutableRecord, "isImmutableRecord");
var IteratorSymbol = Symbol.iterator;
function hasIterator(object) {
  return !!(object != null && object[IteratorSymbol]);
}
__name(hasIterator, "hasIterator");
function iterableEquality(a, b2, customTesters = [], aStack = [], bStack = []) {
  if (typeof a !== "object" || typeof b2 !== "object" || Array.isArray(a) || Array.isArray(b2) || !hasIterator(a) || !hasIterator(b2)) {
    return void 0;
  }
  if (a.constructor !== b2.constructor) {
    return false;
  }
  let length = aStack.length;
  while (length--) {
    if (aStack[length] === a) {
      return bStack[length] === b2;
    }
  }
  aStack.push(a);
  bStack.push(b2);
  const filteredCustomTesters = [...customTesters.filter((t2) => t2 !== iterableEquality), iterableEqualityWithStack];
  function iterableEqualityWithStack(a2, b3) {
    return iterableEquality(a2, b3, [...customTesters], [...aStack], [...bStack]);
  }
  __name(iterableEqualityWithStack, "iterableEqualityWithStack");
  if (a.size !== void 0) {
    if (a.size !== b2.size) {
      return false;
    } else if (isA("Set", a) || isImmutableUnorderedSet(a)) {
      let allFound = true;
      for (const aValue of a) {
        if (!b2.has(aValue)) {
          let has = false;
          for (const bValue of b2) {
            const isEqual = equals(aValue, bValue, filteredCustomTesters);
            if (isEqual === true) {
              has = true;
            }
          }
          if (has === false) {
            allFound = false;
            break;
          }
        }
      }
      aStack.pop();
      bStack.pop();
      return allFound;
    } else if (isA("Map", a) || isImmutableUnorderedKeyed(a)) {
      let allFound = true;
      for (const aEntry of a) {
        if (!b2.has(aEntry[0]) || !equals(aEntry[1], b2.get(aEntry[0]), filteredCustomTesters)) {
          let has = false;
          for (const bEntry of b2) {
            const matchedKey = equals(aEntry[0], bEntry[0], filteredCustomTesters);
            let matchedValue = false;
            if (matchedKey === true) {
              matchedValue = equals(aEntry[1], bEntry[1], filteredCustomTesters);
            }
            if (matchedValue === true) {
              has = true;
            }
          }
          if (has === false) {
            allFound = false;
            break;
          }
        }
      }
      aStack.pop();
      bStack.pop();
      return allFound;
    }
  }
  const bIterator = b2[IteratorSymbol]();
  for (const aValue of a) {
    const nextB = bIterator.next();
    if (nextB.done || !equals(aValue, nextB.value, filteredCustomTesters)) {
      return false;
    }
  }
  if (!bIterator.next().done) {
    return false;
  }
  if (!isImmutableList(a) && !isImmutableOrderedKeyed(a) && !isImmutableOrderedSet(a) && !isImmutableRecord(a)) {
    const aEntries = Object.entries(a);
    const bEntries = Object.entries(b2);
    if (!equals(aEntries, bEntries, filteredCustomTesters)) {
      return false;
    }
  }
  aStack.pop();
  bStack.pop();
  return true;
}
__name(iterableEquality, "iterableEquality");
function hasPropertyInObject(object, key) {
  const shouldTerminate = !object || typeof object !== "object" || object === Object.prototype;
  if (shouldTerminate) {
    return false;
  }
  return Object.prototype.hasOwnProperty.call(object, key) || hasPropertyInObject(Object.getPrototypeOf(object), key);
}
__name(hasPropertyInObject, "hasPropertyInObject");
function isObjectWithKeys(a) {
  return isObject(a) && !(a instanceof Error) && !Array.isArray(a) && !(a instanceof Date);
}
__name(isObjectWithKeys, "isObjectWithKeys");
function subsetEquality(object, subset, customTesters = []) {
  const filteredCustomTesters = customTesters.filter((t2) => t2 !== subsetEquality);
  const subsetEqualityWithContext = /* @__PURE__ */ __name((seenReferences = /* @__PURE__ */ new WeakMap()) => (object2, subset2) => {
    if (!isObjectWithKeys(subset2)) {
      return void 0;
    }
    return Object.keys(subset2).every((key) => {
      if (subset2[key] != null && typeof subset2[key] === "object") {
        if (seenReferences.has(subset2[key])) {
          return equals(object2[key], subset2[key], filteredCustomTesters);
        }
        seenReferences.set(subset2[key], true);
      }
      const result = object2 != null && hasPropertyInObject(object2, key) && equals(object2[key], subset2[key], [...filteredCustomTesters, subsetEqualityWithContext(seenReferences)]);
      seenReferences.delete(subset2[key]);
      return result;
    });
  }, "subsetEqualityWithContext");
  return subsetEqualityWithContext()(object, subset);
}
__name(subsetEquality, "subsetEquality");
function typeEquality(a, b2) {
  if (a == null || b2 == null || a.constructor === b2.constructor) {
    return void 0;
  }
  return false;
}
__name(typeEquality, "typeEquality");
function arrayBufferEquality(a, b2) {
  let dataViewA = a;
  let dataViewB = b2;
  if (!(a instanceof DataView && b2 instanceof DataView)) {
    if (!(a instanceof ArrayBuffer) || !(b2 instanceof ArrayBuffer)) {
      return void 0;
    }
    try {
      dataViewA = new DataView(a);
      dataViewB = new DataView(b2);
    } catch {
      return void 0;
    }
  }
  if (dataViewA.byteLength !== dataViewB.byteLength) {
    return false;
  }
  for (let i2 = 0; i2 < dataViewA.byteLength; i2++) {
    if (dataViewA.getUint8(i2) !== dataViewB.getUint8(i2)) {
      return false;
    }
  }
  return true;
}
__name(arrayBufferEquality, "arrayBufferEquality");
function sparseArrayEquality(a, b2, customTesters = []) {
  if (!Array.isArray(a) || !Array.isArray(b2)) {
    return void 0;
  }
  const aKeys = Object.keys(a);
  const bKeys = Object.keys(b2);
  const filteredCustomTesters = customTesters.filter((t2) => t2 !== sparseArrayEquality);
  return equals(a, b2, filteredCustomTesters, true) && equals(aKeys, bKeys);
}
__name(sparseArrayEquality, "sparseArrayEquality");
function generateToBeMessage(deepEqualityName, expected = "#{this}", actual = "#{exp}") {
  const toBeMessage = `expected ${expected} to be ${actual} // Object.is equality`;
  if (["toStrictEqual", "toEqual"].includes(deepEqualityName)) {
    return `${toBeMessage}

If it should pass with deep equality, replace "toBe" with "${deepEqualityName}"

Expected: ${expected}
Received: serializes to the same string
`;
  }
  return toBeMessage;
}
__name(generateToBeMessage, "generateToBeMessage");
function pluralize(word, count) {
  return `${count} ${word}${count === 1 ? "" : "s"}`;
}
__name(pluralize, "pluralize");
function getObjectKeys(object) {
  return [...Object.keys(object), ...Object.getOwnPropertySymbols(object).filter((s3) => {
    var _Object$getOwnPropert;
    return (_Object$getOwnPropert = Object.getOwnPropertyDescriptor(object, s3)) === null || _Object$getOwnPropert === void 0 ? void 0 : _Object$getOwnPropert.enumerable;
  })];
}
__name(getObjectKeys, "getObjectKeys");
function getObjectSubset(object, subset, customTesters) {
  let stripped = 0;
  const getObjectSubsetWithContext = /* @__PURE__ */ __name((seenReferences = /* @__PURE__ */ new WeakMap()) => (object2, subset2) => {
    if (Array.isArray(object2)) {
      if (Array.isArray(subset2) && subset2.length === object2.length) {
        return subset2.map((sub, i2) => getObjectSubsetWithContext(seenReferences)(object2[i2], sub));
      }
    } else if (object2 instanceof Date) {
      return object2;
    } else if (isObject(object2) && isObject(subset2)) {
      if (equals(object2, subset2, [
        ...customTesters,
        iterableEquality,
        subsetEquality
      ])) {
        return subset2;
      }
      const trimmed = {};
      seenReferences.set(object2, trimmed);
      if (typeof object2.constructor === "function" && typeof object2.constructor.name === "string") {
        Object.defineProperty(trimmed, "constructor", {
          enumerable: false,
          value: object2.constructor
        });
      }
      for (const key of getObjectKeys(object2)) {
        if (hasPropertyInObject(subset2, key)) {
          trimmed[key] = seenReferences.has(object2[key]) ? seenReferences.get(object2[key]) : getObjectSubsetWithContext(seenReferences)(object2[key], subset2[key]);
        } else {
          if (!seenReferences.has(object2[key])) {
            stripped += 1;
            if (isObject(object2[key])) {
              stripped += getObjectKeys(object2[key]).length;
            }
            getObjectSubsetWithContext(seenReferences)(object2[key], subset2[key]);
          }
        }
      }
      if (getObjectKeys(trimmed).length > 0) {
        return trimmed;
      }
    }
    return object2;
  }, "getObjectSubsetWithContext");
  return {
    subset: getObjectSubsetWithContext()(object, subset),
    stripped
  };
}
__name(getObjectSubset, "getObjectSubset");
if (!Object.prototype.hasOwnProperty.call(globalThis, MATCHERS_OBJECT)) {
  const globalState = /* @__PURE__ */ new WeakMap();
  Object.defineProperty(globalThis, MATCHERS_OBJECT, { get: /* @__PURE__ */ __name(() => globalState, "get") });
}
if (!Object.prototype.hasOwnProperty.call(globalThis, JEST_MATCHERS_OBJECT)) {
  const matchers = /* @__PURE__ */ Object.create(null);
  const customEqualityTesters = [];
  Object.defineProperty(globalThis, JEST_MATCHERS_OBJECT, {
    configurable: true,
    get: /* @__PURE__ */ __name(() => ({
      state: globalThis[MATCHERS_OBJECT].get(globalThis[GLOBAL_EXPECT]),
      matchers,
      customEqualityTesters
    }), "get")
  });
}
if (!Object.prototype.hasOwnProperty.call(globalThis, ASYMMETRIC_MATCHERS_OBJECT)) {
  const asymmetricMatchers = /* @__PURE__ */ Object.create(null);
  Object.defineProperty(globalThis, ASYMMETRIC_MATCHERS_OBJECT, { get: /* @__PURE__ */ __name(() => asymmetricMatchers, "get") });
}
function getState(expect4) {
  return globalThis[MATCHERS_OBJECT].get(expect4);
}
__name(getState, "getState");
function setState(state, expect4) {
  const map = globalThis[MATCHERS_OBJECT];
  const current = map.get(expect4) || {};
  const results = Object.defineProperties(current, {
    ...Object.getOwnPropertyDescriptors(current),
    ...Object.getOwnPropertyDescriptors(state)
  });
  map.set(expect4, results);
}
__name(setState, "setState");
var _AsymmetricMatcher = class _AsymmetricMatcher {
  // should have "jest" to be compatible with its ecosystem
  $$typeof = Symbol.for("jest.asymmetricMatcher");
  constructor(sample, inverse = false) {
    this.sample = sample;
    this.inverse = inverse;
  }
  getMatcherContext(expect4) {
    return {
      ...getState(expect4 || globalThis[GLOBAL_EXPECT]),
      equals,
      isNot: this.inverse,
      customTesters: getCustomEqualityTesters(),
      utils: {
        ...getMatcherUtils(),
        diff,
        stringify,
        iterableEquality,
        subsetEquality
      }
    };
  }
};
__name(_AsymmetricMatcher, "AsymmetricMatcher");
var AsymmetricMatcher = _AsymmetricMatcher;
AsymmetricMatcher.prototype[Symbol.for("chai/inspect")] = function(options) {
  const result = stringify(this, options.depth, { min: true });
  if (result.length <= options.truncate) {
    return result;
  }
  return `${this.toString()}{\u2026}`;
};
var _StringContaining = class _StringContaining extends AsymmetricMatcher {
  constructor(sample, inverse = false) {
    if (!isA("String", sample)) {
      throw new Error("Expected is not a string");
    }
    super(sample, inverse);
  }
  asymmetricMatch(other) {
    const result = isA("String", other) && other.includes(this.sample);
    return this.inverse ? !result : result;
  }
  toString() {
    return `String${this.inverse ? "Not" : ""}Containing`;
  }
  getExpectedType() {
    return "string";
  }
};
__name(_StringContaining, "StringContaining");
var StringContaining = _StringContaining;
var _Anything = class _Anything extends AsymmetricMatcher {
  asymmetricMatch(other) {
    return other != null;
  }
  toString() {
    return "Anything";
  }
  toAsymmetricMatcher() {
    return "Anything";
  }
};
__name(_Anything, "Anything");
var Anything = _Anything;
var _ObjectContaining = class _ObjectContaining extends AsymmetricMatcher {
  constructor(sample, inverse = false) {
    super(sample, inverse);
  }
  getPrototype(obj) {
    if (Object.getPrototypeOf) {
      return Object.getPrototypeOf(obj);
    }
    if (obj.constructor.prototype === obj) {
      return null;
    }
    return obj.constructor.prototype;
  }
  hasProperty(obj, property) {
    if (!obj) {
      return false;
    }
    if (Object.prototype.hasOwnProperty.call(obj, property)) {
      return true;
    }
    return this.hasProperty(this.getPrototype(obj), property);
  }
  asymmetricMatch(other) {
    if (typeof this.sample !== "object") {
      throw new TypeError(`You must provide an object to ${this.toString()}, not '${typeof this.sample}'.`);
    }
    let result = true;
    const matcherContext = this.getMatcherContext();
    for (const property in this.sample) {
      if (!this.hasProperty(other, property) || !equals(this.sample[property], other[property], matcherContext.customTesters)) {
        result = false;
        break;
      }
    }
    return this.inverse ? !result : result;
  }
  toString() {
    return `Object${this.inverse ? "Not" : ""}Containing`;
  }
  getExpectedType() {
    return "object";
  }
};
__name(_ObjectContaining, "ObjectContaining");
var ObjectContaining = _ObjectContaining;
var _ArrayContaining = class _ArrayContaining extends AsymmetricMatcher {
  constructor(sample, inverse = false) {
    super(sample, inverse);
  }
  asymmetricMatch(other) {
    if (!Array.isArray(this.sample)) {
      throw new TypeError(`You must provide an array to ${this.toString()}, not '${typeof this.sample}'.`);
    }
    const matcherContext = this.getMatcherContext();
    const result = this.sample.length === 0 || Array.isArray(other) && this.sample.every((item) => other.some((another) => equals(item, another, matcherContext.customTesters)));
    return this.inverse ? !result : result;
  }
  toString() {
    return `Array${this.inverse ? "Not" : ""}Containing`;
  }
  getExpectedType() {
    return "array";
  }
};
__name(_ArrayContaining, "ArrayContaining");
var ArrayContaining = _ArrayContaining;
var _Any = class _Any extends AsymmetricMatcher {
  constructor(sample) {
    if (typeof sample === "undefined") {
      throw new TypeError("any() expects to be passed a constructor function. Please pass one or use anything() to match any object.");
    }
    super(sample);
  }
  fnNameFor(func) {
    if (func.name) {
      return func.name;
    }
    const functionToString2 = Function.prototype.toString;
    const matches3 = functionToString2.call(func).match(/^(?:async)?\s*function\s*(?:\*\s*)?([\w$]+)\s*\(/);
    return matches3 ? matches3[1] : "<anonymous>";
  }
  asymmetricMatch(other) {
    if (this.sample === String) {
      return typeof other == "string" || other instanceof String;
    }
    if (this.sample === Number) {
      return typeof other == "number" || other instanceof Number;
    }
    if (this.sample === Function) {
      return typeof other == "function" || typeof other === "function";
    }
    if (this.sample === Boolean) {
      return typeof other == "boolean" || other instanceof Boolean;
    }
    if (this.sample === BigInt) {
      return typeof other == "bigint" || other instanceof BigInt;
    }
    if (this.sample === Symbol) {
      return typeof other == "symbol" || other instanceof Symbol;
    }
    if (this.sample === Object) {
      return typeof other == "object";
    }
    return other instanceof this.sample;
  }
  toString() {
    return "Any";
  }
  getExpectedType() {
    if (this.sample === String) {
      return "string";
    }
    if (this.sample === Number) {
      return "number";
    }
    if (this.sample === Function) {
      return "function";
    }
    if (this.sample === Object) {
      return "object";
    }
    if (this.sample === Boolean) {
      return "boolean";
    }
    return this.fnNameFor(this.sample);
  }
  toAsymmetricMatcher() {
    return `Any<${this.fnNameFor(this.sample)}>`;
  }
};
__name(_Any, "Any");
var Any = _Any;
var _StringMatching = class _StringMatching extends AsymmetricMatcher {
  constructor(sample, inverse = false) {
    if (!isA("String", sample) && !isA("RegExp", sample)) {
      throw new Error("Expected is not a String or a RegExp");
    }
    super(new RegExp(sample), inverse);
  }
  asymmetricMatch(other) {
    const result = isA("String", other) && this.sample.test(other);
    return this.inverse ? !result : result;
  }
  toString() {
    return `String${this.inverse ? "Not" : ""}Matching`;
  }
  getExpectedType() {
    return "string";
  }
};
__name(_StringMatching, "StringMatching");
var StringMatching = _StringMatching;
var _CloseTo = class _CloseTo extends AsymmetricMatcher {
  precision;
  constructor(sample, precision = 2, inverse = false) {
    if (!isA("Number", sample)) {
      throw new Error("Expected is not a Number");
    }
    if (!isA("Number", precision)) {
      throw new Error("Precision is not a Number");
    }
    super(sample);
    this.inverse = inverse;
    this.precision = precision;
  }
  asymmetricMatch(other) {
    if (!isA("Number", other)) {
      return false;
    }
    let result = false;
    if (other === Number.POSITIVE_INFINITY && this.sample === Number.POSITIVE_INFINITY) {
      result = true;
    } else if (other === Number.NEGATIVE_INFINITY && this.sample === Number.NEGATIVE_INFINITY) {
      result = true;
    } else {
      result = Math.abs(this.sample - other) < 10 ** -this.precision / 2;
    }
    return this.inverse ? !result : result;
  }
  toString() {
    return `Number${this.inverse ? "Not" : ""}CloseTo`;
  }
  getExpectedType() {
    return "number";
  }
  toAsymmetricMatcher() {
    return [
      this.toString(),
      this.sample,
      `(${pluralize("digit", this.precision)})`
    ].join(" ");
  }
};
__name(_CloseTo, "CloseTo");
var CloseTo = _CloseTo;
var JestAsymmetricMatchers = /* @__PURE__ */ __name((chai, utils) => {
  utils.addMethod(chai.expect, "anything", () => new Anything());
  utils.addMethod(chai.expect, "any", (expected) => new Any(expected));
  utils.addMethod(chai.expect, "stringContaining", (expected) => new StringContaining(expected));
  utils.addMethod(chai.expect, "objectContaining", (expected) => new ObjectContaining(expected));
  utils.addMethod(chai.expect, "arrayContaining", (expected) => new ArrayContaining(expected));
  utils.addMethod(chai.expect, "stringMatching", (expected) => new StringMatching(expected));
  utils.addMethod(chai.expect, "closeTo", (expected, precision) => new CloseTo(expected, precision));
  chai.expect.not = {
    stringContaining: /* @__PURE__ */ __name((expected) => new StringContaining(expected, true), "stringContaining"),
    objectContaining: /* @__PURE__ */ __name((expected) => new ObjectContaining(expected, true), "objectContaining"),
    arrayContaining: /* @__PURE__ */ __name((expected) => new ArrayContaining(expected, true), "arrayContaining"),
    stringMatching: /* @__PURE__ */ __name((expected) => new StringMatching(expected, true), "stringMatching"),
    closeTo: /* @__PURE__ */ __name((expected, precision) => new CloseTo(expected, precision, true), "closeTo")
  };
}, "JestAsymmetricMatchers");
function createAssertionMessage(util, assertion, hasArgs) {
  const not = util.flag(assertion, "negate") ? "not." : "";
  const name = `${util.flag(assertion, "_name")}(${hasArgs ? "expected" : ""})`;
  const promiseName = util.flag(assertion, "promise");
  const promise = promiseName ? `.${promiseName}` : "";
  return `expect(actual)${promise}.${not}${name}`;
}
__name(createAssertionMessage, "createAssertionMessage");
function recordAsyncExpect(_test, promise, assertion, error) {
  const test2 = _test;
  if (test2 && promise instanceof Promise) {
    promise = promise.finally(() => {
      if (!test2.promises) {
        return;
      }
      const index = test2.promises.indexOf(promise);
      if (index !== -1) {
        test2.promises.splice(index, 1);
      }
    });
    if (!test2.promises) {
      test2.promises = [];
    }
    test2.promises.push(promise);
    let resolved = false;
    test2.onFinished ?? (test2.onFinished = []);
    test2.onFinished.push(() => {
      if (!resolved) {
        var _vitest_worker__;
        const processor = ((_vitest_worker__ = globalThis.__vitest_worker__) === null || _vitest_worker__ === void 0 ? void 0 : _vitest_worker__.onFilterStackTrace) || ((s3) => s3 || "");
        const stack = processor(error.stack);
        console.warn([
          `Promise returned by \`${assertion}\` was not awaited. `,
          "Vitest currently auto-awaits hanging assertions at the end of the test, but this will cause the test to fail in Vitest 3. ",
          "Please remember to await the assertion.\n",
          stack
        ].join(""));
      }
    });
    return {
      then(onFulfilled, onRejected) {
        resolved = true;
        return promise.then(onFulfilled, onRejected);
      },
      catch(onRejected) {
        return promise.catch(onRejected);
      },
      finally(onFinally) {
        return promise.finally(onFinally);
      },
      [Symbol.toStringTag]: "Promise"
    };
  }
  return promise;
}
__name(recordAsyncExpect, "recordAsyncExpect");
function handleTestError(test2, err) {
  var _test$result;
  test2.result || (test2.result = { state: "fail" });
  test2.result.state = "fail";
  (_test$result = test2.result).errors || (_test$result.errors = []);
  test2.result.errors.push(processError(err));
}
__name(handleTestError, "handleTestError");
function wrapAssertion(utils, name, fn3) {
  return function(...args) {
    if (name !== "withTest") {
      utils.flag(this, "_name", name);
    }
    if (!utils.flag(this, "soft")) {
      return fn3.apply(this, args);
    }
    const test2 = utils.flag(this, "vitest-test");
    if (!test2) {
      throw new Error("expect.soft() can only be used inside a test");
    }
    try {
      const result = fn3.apply(this, args);
      if (result && typeof result === "object" && typeof result.then === "function") {
        return result.then(noop, (err) => {
          handleTestError(test2, err);
        });
      }
      return result;
    } catch (err) {
      handleTestError(test2, err);
    }
  };
}
__name(wrapAssertion, "wrapAssertion");
var JestChaiExpect = /* @__PURE__ */ __name((chai, utils) => {
  const { AssertionError: AssertionError2 } = chai;
  const customTesters = getCustomEqualityTesters();
  function def(name, fn3) {
    const addMethod2 = /* @__PURE__ */ __name((n2) => {
      const softWrapper = wrapAssertion(utils, n2, fn3);
      utils.addMethod(chai.Assertion.prototype, n2, softWrapper);
      utils.addMethod(globalThis[JEST_MATCHERS_OBJECT].matchers, n2, softWrapper);
    }, "addMethod");
    if (Array.isArray(name)) {
      name.forEach((n2) => addMethod2(n2));
    } else {
      addMethod2(name);
    }
  }
  __name(def, "def");
  [
    "throw",
    "throws",
    "Throw"
  ].forEach((m2) => {
    utils.overwriteMethod(chai.Assertion.prototype, m2, (_super) => {
      return function(...args) {
        const promise = utils.flag(this, "promise");
        const object = utils.flag(this, "object");
        const isNot = utils.flag(this, "negate");
        if (promise === "rejects") {
          utils.flag(this, "object", () => {
            throw object;
          });
        } else if (promise === "resolves" && typeof object !== "function") {
          if (!isNot) {
            const message = utils.flag(this, "message") || "expected promise to throw an error, but it didn't";
            const error = { showDiff: false };
            throw new AssertionError2(message, error, utils.flag(this, "ssfi"));
          } else {
            return;
          }
        }
        _super.apply(this, args);
      };
    });
  });
  def("withTest", function(test2) {
    utils.flag(this, "vitest-test", test2);
    return this;
  });
  def("toEqual", function(expected) {
    const actual = utils.flag(this, "object");
    const equal = equals(actual, expected, [...customTesters, iterableEquality]);
    return this.assert(equal, "expected #{this} to deeply equal #{exp}", "expected #{this} to not deeply equal #{exp}", expected, actual);
  });
  def("toStrictEqual", function(expected) {
    const obj = utils.flag(this, "object");
    const equal = equals(obj, expected, [
      ...customTesters,
      iterableEquality,
      typeEquality,
      sparseArrayEquality,
      arrayBufferEquality
    ], true);
    return this.assert(equal, "expected #{this} to strictly equal #{exp}", "expected #{this} to not strictly equal #{exp}", expected, obj);
  });
  def("toBe", function(expected) {
    const actual = this._obj;
    const pass = Object.is(actual, expected);
    let deepEqualityName = "";
    if (!pass) {
      const toStrictEqualPass = equals(actual, expected, [
        ...customTesters,
        iterableEquality,
        typeEquality,
        sparseArrayEquality,
        arrayBufferEquality
      ], true);
      if (toStrictEqualPass) {
        deepEqualityName = "toStrictEqual";
      } else {
        const toEqualPass = equals(actual, expected, [...customTesters, iterableEquality]);
        if (toEqualPass) {
          deepEqualityName = "toEqual";
        }
      }
    }
    return this.assert(pass, generateToBeMessage(deepEqualityName), "expected #{this} not to be #{exp} // Object.is equality", expected, actual);
  });
  def("toMatchObject", function(expected) {
    const actual = this._obj;
    const pass = equals(actual, expected, [
      ...customTesters,
      iterableEquality,
      subsetEquality
    ]);
    const isNot = utils.flag(this, "negate");
    const { subset: actualSubset, stripped } = getObjectSubset(actual, expected, customTesters);
    if (pass && isNot || !pass && !isNot) {
      const msg = utils.getMessage(this, [
        pass,
        "expected #{this} to match object #{exp}",
        "expected #{this} to not match object #{exp}",
        expected,
        actualSubset,
        false
      ]);
      const message = stripped === 0 ? msg : `${msg}
(${stripped} matching ${stripped === 1 ? "property" : "properties"} omitted from actual)`;
      throw new AssertionError2(message, {
        showDiff: true,
        expected,
        actual: actualSubset
      });
    }
  });
  def("toMatch", function(expected) {
    const actual = this._obj;
    if (typeof actual !== "string") {
      throw new TypeError(`.toMatch() expects to receive a string, but got ${typeof actual}`);
    }
    return this.assert(typeof expected === "string" ? actual.includes(expected) : actual.match(expected), `expected #{this} to match #{exp}`, `expected #{this} not to match #{exp}`, expected, actual);
  });
  def("toContain", function(item) {
    const actual = this._obj;
    if (typeof Node !== "undefined" && actual instanceof Node) {
      if (!(item instanceof Node)) {
        throw new TypeError(`toContain() expected a DOM node as the argument, but got ${typeof item}`);
      }
      return this.assert(actual.contains(item), "expected #{this} to contain element #{exp}", "expected #{this} not to contain element #{exp}", item, actual);
    }
    if (typeof DOMTokenList !== "undefined" && actual instanceof DOMTokenList) {
      assertTypes(item, "class name", ["string"]);
      const isNot = utils.flag(this, "negate");
      const expectedClassList = isNot ? actual.value.replace(item, "").trim() : `${actual.value} ${item}`;
      return this.assert(actual.contains(item), `expected "${actual.value}" to contain "${item}"`, `expected "${actual.value}" not to contain "${item}"`, expectedClassList, actual.value);
    }
    if (typeof actual === "string" && typeof item === "string") {
      return this.assert(actual.includes(item), `expected #{this} to contain #{exp}`, `expected #{this} not to contain #{exp}`, item, actual);
    }
    if (actual != null && typeof actual !== "string") {
      utils.flag(this, "object", Array.from(actual));
    }
    return this.contain(item);
  });
  def("toContainEqual", function(expected) {
    const obj = utils.flag(this, "object");
    const index = Array.from(obj).findIndex((item) => {
      return equals(item, expected, customTesters);
    });
    this.assert(index !== -1, "expected #{this} to deep equally contain #{exp}", "expected #{this} to not deep equally contain #{exp}", expected);
  });
  def("toBeTruthy", function() {
    const obj = utils.flag(this, "object");
    this.assert(Boolean(obj), "expected #{this} to be truthy", "expected #{this} to not be truthy", true, obj);
  });
  def("toBeFalsy", function() {
    const obj = utils.flag(this, "object");
    this.assert(!obj, "expected #{this} to be falsy", "expected #{this} to not be falsy", false, obj);
  });
  def("toBeGreaterThan", function(expected) {
    const actual = this._obj;
    assertTypes(actual, "actual", ["number", "bigint"]);
    assertTypes(expected, "expected", ["number", "bigint"]);
    return this.assert(actual > expected, `expected ${actual} to be greater than ${expected}`, `expected ${actual} to be not greater than ${expected}`, expected, actual, false);
  });
  def("toBeGreaterThanOrEqual", function(expected) {
    const actual = this._obj;
    assertTypes(actual, "actual", ["number", "bigint"]);
    assertTypes(expected, "expected", ["number", "bigint"]);
    return this.assert(actual >= expected, `expected ${actual} to be greater than or equal to ${expected}`, `expected ${actual} to be not greater than or equal to ${expected}`, expected, actual, false);
  });
  def("toBeLessThan", function(expected) {
    const actual = this._obj;
    assertTypes(actual, "actual", ["number", "bigint"]);
    assertTypes(expected, "expected", ["number", "bigint"]);
    return this.assert(actual < expected, `expected ${actual} to be less than ${expected}`, `expected ${actual} to be not less than ${expected}`, expected, actual, false);
  });
  def("toBeLessThanOrEqual", function(expected) {
    const actual = this._obj;
    assertTypes(actual, "actual", ["number", "bigint"]);
    assertTypes(expected, "expected", ["number", "bigint"]);
    return this.assert(actual <= expected, `expected ${actual} to be less than or equal to ${expected}`, `expected ${actual} to be not less than or equal to ${expected}`, expected, actual, false);
  });
  def("toBeNaN", function() {
    const obj = utils.flag(this, "object");
    this.assert(Number.isNaN(obj), "expected #{this} to be NaN", "expected #{this} not to be NaN", Number.NaN, obj);
  });
  def("toBeUndefined", function() {
    const obj = utils.flag(this, "object");
    this.assert(void 0 === obj, "expected #{this} to be undefined", "expected #{this} not to be undefined", void 0, obj);
  });
  def("toBeNull", function() {
    const obj = utils.flag(this, "object");
    this.assert(obj === null, "expected #{this} to be null", "expected #{this} not to be null", null, obj);
  });
  def("toBeDefined", function() {
    const obj = utils.flag(this, "object");
    this.assert(typeof obj !== "undefined", "expected #{this} to be defined", "expected #{this} to be undefined", obj);
  });
  def("toBeTypeOf", function(expected) {
    const actual = typeof this._obj;
    const equal = expected === actual;
    return this.assert(equal, "expected #{this} to be type of #{exp}", "expected #{this} not to be type of #{exp}", expected, actual);
  });
  def("toBeInstanceOf", function(obj) {
    return this.instanceOf(obj);
  });
  def("toHaveLength", function(length) {
    return this.have.length(length);
  });
  def("toHaveProperty", function(...args) {
    if (Array.isArray(args[0])) {
      args[0] = args[0].map((key) => String(key).replace(/([.[\]])/g, "\\$1")).join(".");
    }
    const actual = this._obj;
    const [propertyName, expected] = args;
    const getValue = /* @__PURE__ */ __name(() => {
      const hasOwn = Object.prototype.hasOwnProperty.call(actual, propertyName);
      if (hasOwn) {
        return {
          value: actual[propertyName],
          exists: true
        };
      }
      return utils.getPathInfo(actual, propertyName);
    }, "getValue");
    const { value, exists } = getValue();
    const pass = exists && (args.length === 1 || equals(expected, value, customTesters));
    const valueString = args.length === 1 ? "" : ` with value ${utils.objDisplay(expected)}`;
    return this.assert(pass, `expected #{this} to have property "${propertyName}"${valueString}`, `expected #{this} to not have property "${propertyName}"${valueString}`, expected, exists ? value : void 0);
  });
  def("toBeCloseTo", function(received, precision = 2) {
    const expected = this._obj;
    let pass = false;
    let expectedDiff2 = 0;
    let receivedDiff = 0;
    if (received === Number.POSITIVE_INFINITY && expected === Number.POSITIVE_INFINITY) {
      pass = true;
    } else if (received === Number.NEGATIVE_INFINITY && expected === Number.NEGATIVE_INFINITY) {
      pass = true;
    } else {
      expectedDiff2 = 10 ** -precision / 2;
      receivedDiff = Math.abs(expected - received);
      pass = receivedDiff < expectedDiff2;
    }
    return this.assert(pass, `expected #{this} to be close to #{exp}, received difference is ${receivedDiff}, but expected ${expectedDiff2}`, `expected #{this} to not be close to #{exp}, received difference is ${receivedDiff}, but expected ${expectedDiff2}`, received, expected, false);
  });
  function assertIsMock(assertion) {
    if (!isMockFunction(assertion._obj)) {
      throw new TypeError(`${utils.inspect(assertion._obj)} is not a spy or a call to a spy!`);
    }
  }
  __name(assertIsMock, "assertIsMock");
  function getSpy(assertion) {
    assertIsMock(assertion);
    return assertion._obj;
  }
  __name(getSpy, "getSpy");
  def(["toHaveBeenCalledTimes", "toBeCalledTimes"], function(number) {
    const spy = getSpy(this);
    const spyName = spy.getMockName();
    const callCount = spy.mock.calls.length;
    return this.assert(callCount === number, `expected "${spyName}" to be called #{exp} times, but got ${callCount} times`, `expected "${spyName}" to not be called #{exp} times`, number, callCount, false);
  });
  def("toHaveBeenCalledOnce", function() {
    const spy = getSpy(this);
    const spyName = spy.getMockName();
    const callCount = spy.mock.calls.length;
    return this.assert(callCount === 1, `expected "${spyName}" to be called once, but got ${callCount} times`, `expected "${spyName}" to not be called once`, 1, callCount, false);
  });
  def(["toHaveBeenCalled", "toBeCalled"], function() {
    const spy = getSpy(this);
    const spyName = spy.getMockName();
    const callCount = spy.mock.calls.length;
    const called = callCount > 0;
    const isNot = utils.flag(this, "negate");
    let msg = utils.getMessage(this, [
      called,
      `expected "${spyName}" to be called at least once`,
      `expected "${spyName}" to not be called at all, but actually been called ${callCount} times`,
      true,
      called
    ]);
    if (called && isNot) {
      msg = formatCalls(spy, msg);
    }
    if (called && isNot || !called && !isNot) {
      throw new AssertionError2(msg);
    }
  });
  function equalsArgumentArray(a, b2) {
    return a.length === b2.length && a.every((aItem, i2) => equals(aItem, b2[i2], [...customTesters, iterableEquality]));
  }
  __name(equalsArgumentArray, "equalsArgumentArray");
  def(["toHaveBeenCalledWith", "toBeCalledWith"], function(...args) {
    const spy = getSpy(this);
    const spyName = spy.getMockName();
    const pass = spy.mock.calls.some((callArg) => equalsArgumentArray(callArg, args));
    const isNot = utils.flag(this, "negate");
    const msg = utils.getMessage(this, [
      pass,
      `expected "${spyName}" to be called with arguments: #{exp}`,
      `expected "${spyName}" to not be called with arguments: #{exp}`,
      args
    ]);
    if (pass && isNot || !pass && !isNot) {
      throw new AssertionError2(formatCalls(spy, msg, args));
    }
  });
  def("toHaveBeenCalledExactlyOnceWith", function(...args) {
    const spy = getSpy(this);
    const spyName = spy.getMockName();
    const callCount = spy.mock.calls.length;
    const hasCallWithArgs = spy.mock.calls.some((callArg) => equalsArgumentArray(callArg, args));
    const pass = hasCallWithArgs && callCount === 1;
    const isNot = utils.flag(this, "negate");
    const msg = utils.getMessage(this, [
      pass,
      `expected "${spyName}" to be called once with arguments: #{exp}`,
      `expected "${spyName}" to not be called once with arguments: #{exp}`,
      args
    ]);
    if (pass && isNot || !pass && !isNot) {
      throw new AssertionError2(formatCalls(spy, msg, args));
    }
  });
  def(["toHaveBeenNthCalledWith", "nthCalledWith"], function(times, ...args) {
    const spy = getSpy(this);
    const spyName = spy.getMockName();
    const nthCall = spy.mock.calls[times - 1];
    const callCount = spy.mock.calls.length;
    const isCalled = times <= callCount;
    this.assert(nthCall && equalsArgumentArray(nthCall, args), `expected ${ordinalOf(times)} "${spyName}" call to have been called with #{exp}${isCalled ? `` : `, but called only ${callCount} times`}`, `expected ${ordinalOf(times)} "${spyName}" call to not have been called with #{exp}`, args, nthCall, isCalled);
  });
  def(["toHaveBeenLastCalledWith", "lastCalledWith"], function(...args) {
    const spy = getSpy(this);
    const spyName = spy.getMockName();
    const lastCall = spy.mock.calls[spy.mock.calls.length - 1];
    this.assert(lastCall && equalsArgumentArray(lastCall, args), `expected last "${spyName}" call to have been called with #{exp}`, `expected last "${spyName}" call to not have been called with #{exp}`, args, lastCall);
  });
  function isSpyCalledBeforeAnotherSpy(beforeSpy, afterSpy, failIfNoFirstInvocation) {
    const beforeInvocationCallOrder = beforeSpy.mock.invocationCallOrder;
    const afterInvocationCallOrder = afterSpy.mock.invocationCallOrder;
    if (beforeInvocationCallOrder.length === 0) {
      return !failIfNoFirstInvocation;
    }
    if (afterInvocationCallOrder.length === 0) {
      return false;
    }
    return beforeInvocationCallOrder[0] < afterInvocationCallOrder[0];
  }
  __name(isSpyCalledBeforeAnotherSpy, "isSpyCalledBeforeAnotherSpy");
  def(["toHaveBeenCalledBefore"], function(resultSpy, failIfNoFirstInvocation = true) {
    const expectSpy = getSpy(this);
    if (!isMockFunction(resultSpy)) {
      throw new TypeError(`${utils.inspect(resultSpy)} is not a spy or a call to a spy`);
    }
    this.assert(isSpyCalledBeforeAnotherSpy(expectSpy, resultSpy, failIfNoFirstInvocation), `expected "${expectSpy.getMockName()}" to have been called before "${resultSpy.getMockName()}"`, `expected "${expectSpy.getMockName()}" to not have been called before "${resultSpy.getMockName()}"`, resultSpy, expectSpy);
  });
  def(["toHaveBeenCalledAfter"], function(resultSpy, failIfNoFirstInvocation = true) {
    const expectSpy = getSpy(this);
    if (!isMockFunction(resultSpy)) {
      throw new TypeError(`${utils.inspect(resultSpy)} is not a spy or a call to a spy`);
    }
    this.assert(isSpyCalledBeforeAnotherSpy(resultSpy, expectSpy, failIfNoFirstInvocation), `expected "${expectSpy.getMockName()}" to have been called after "${resultSpy.getMockName()}"`, `expected "${expectSpy.getMockName()}" to not have been called after "${resultSpy.getMockName()}"`, resultSpy, expectSpy);
  });
  def(["toThrow", "toThrowError"], function(expected) {
    if (typeof expected === "string" || typeof expected === "undefined" || expected instanceof RegExp) {
      return this.throws(expected === "" ? /^$/ : expected);
    }
    const obj = this._obj;
    const promise = utils.flag(this, "promise");
    const isNot = utils.flag(this, "negate");
    let thrown = null;
    if (promise === "rejects") {
      thrown = obj;
    } else if (promise === "resolves" && typeof obj !== "function") {
      if (!isNot) {
        const message = utils.flag(this, "message") || "expected promise to throw an error, but it didn't";
        const error = { showDiff: false };
        throw new AssertionError2(message, error, utils.flag(this, "ssfi"));
      } else {
        return;
      }
    } else {
      let isThrow = false;
      try {
        obj();
      } catch (err) {
        isThrow = true;
        thrown = err;
      }
      if (!isThrow && !isNot) {
        const message = utils.flag(this, "message") || "expected function to throw an error, but it didn't";
        const error = { showDiff: false };
        throw new AssertionError2(message, error, utils.flag(this, "ssfi"));
      }
    }
    if (typeof expected === "function") {
      const name = expected.name || expected.prototype.constructor.name;
      return this.assert(thrown && thrown instanceof expected, `expected error to be instance of ${name}`, `expected error not to be instance of ${name}`, expected, thrown);
    }
    if (expected instanceof Error) {
      const equal = equals(thrown, expected, [...customTesters, iterableEquality]);
      return this.assert(equal, "expected a thrown error to be #{exp}", "expected a thrown error not to be #{exp}", expected, thrown);
    }
    if (typeof expected === "object" && "asymmetricMatch" in expected && typeof expected.asymmetricMatch === "function") {
      const matcher = expected;
      return this.assert(thrown && matcher.asymmetricMatch(thrown), "expected error to match asymmetric matcher", "expected error not to match asymmetric matcher", matcher, thrown);
    }
    throw new Error(`"toThrow" expects string, RegExp, function, Error instance or asymmetric matcher, got "${typeof expected}"`);
  });
  [{
    name: "toHaveResolved",
    condition: /* @__PURE__ */ __name((spy) => spy.mock.settledResults.length > 0 && spy.mock.settledResults.some(({ type: type5 }) => type5 === "fulfilled"), "condition"),
    action: "resolved"
  }, {
    name: ["toHaveReturned", "toReturn"],
    condition: /* @__PURE__ */ __name((spy) => spy.mock.calls.length > 0 && spy.mock.results.some(({ type: type5 }) => type5 !== "throw"), "condition"),
    action: "called"
  }].forEach(({ name, condition, action }) => {
    def(name, function() {
      const spy = getSpy(this);
      const spyName = spy.getMockName();
      const pass = condition(spy);
      this.assert(pass, `expected "${spyName}" to be successfully ${action} at least once`, `expected "${spyName}" to not be successfully ${action}`, pass, !pass, false);
    });
  });
  [{
    name: "toHaveResolvedTimes",
    condition: /* @__PURE__ */ __name((spy, times) => spy.mock.settledResults.reduce((s3, { type: type5 }) => type5 === "fulfilled" ? ++s3 : s3, 0) === times, "condition"),
    action: "resolved"
  }, {
    name: ["toHaveReturnedTimes", "toReturnTimes"],
    condition: /* @__PURE__ */ __name((spy, times) => spy.mock.results.reduce((s3, { type: type5 }) => type5 === "throw" ? s3 : ++s3, 0) === times, "condition"),
    action: "called"
  }].forEach(({ name, condition, action }) => {
    def(name, function(times) {
      const spy = getSpy(this);
      const spyName = spy.getMockName();
      const pass = condition(spy, times);
      this.assert(pass, `expected "${spyName}" to be successfully ${action} ${times} times`, `expected "${spyName}" to not be successfully ${action} ${times} times`, `expected resolved times: ${times}`, `received resolved times: ${pass}`, false);
    });
  });
  [{
    name: "toHaveResolvedWith",
    condition: /* @__PURE__ */ __name((spy, value) => spy.mock.settledResults.some(({ type: type5, value: result }) => type5 === "fulfilled" && equals(value, result)), "condition"),
    action: "resolve"
  }, {
    name: ["toHaveReturnedWith", "toReturnWith"],
    condition: /* @__PURE__ */ __name((spy, value) => spy.mock.results.some(({ type: type5, value: result }) => type5 === "return" && equals(value, result)), "condition"),
    action: "return"
  }].forEach(({ name, condition, action }) => {
    def(name, function(value) {
      const spy = getSpy(this);
      const pass = condition(spy, value);
      const isNot = utils.flag(this, "negate");
      if (pass && isNot || !pass && !isNot) {
        const spyName = spy.getMockName();
        const msg = utils.getMessage(this, [
          pass,
          `expected "${spyName}" to ${action} with: #{exp} at least once`,
          `expected "${spyName}" to not ${action} with: #{exp}`,
          value
        ]);
        const results = action === "return" ? spy.mock.results : spy.mock.settledResults;
        throw new AssertionError2(formatReturns(spy, results, msg, value));
      }
    });
  });
  [{
    name: "toHaveLastResolvedWith",
    condition: /* @__PURE__ */ __name((spy, value) => {
      const result = spy.mock.settledResults[spy.mock.settledResults.length - 1];
      return result && result.type === "fulfilled" && equals(result.value, value);
    }, "condition"),
    action: "resolve"
  }, {
    name: ["toHaveLastReturnedWith", "lastReturnedWith"],
    condition: /* @__PURE__ */ __name((spy, value) => {
      const result = spy.mock.results[spy.mock.results.length - 1];
      return result && result.type === "return" && equals(result.value, value);
    }, "condition"),
    action: "return"
  }].forEach(({ name, condition, action }) => {
    def(name, function(value) {
      const spy = getSpy(this);
      const results = action === "return" ? spy.mock.results : spy.mock.settledResults;
      const result = results[results.length - 1];
      const spyName = spy.getMockName();
      this.assert(condition(spy, value), `expected last "${spyName}" call to ${action} #{exp}`, `expected last "${spyName}" call to not ${action} #{exp}`, value, result === null || result === void 0 ? void 0 : result.value);
    });
  });
  [{
    name: "toHaveNthResolvedWith",
    condition: /* @__PURE__ */ __name((spy, index, value) => {
      const result = spy.mock.settledResults[index - 1];
      return result && result.type === "fulfilled" && equals(result.value, value);
    }, "condition"),
    action: "resolve"
  }, {
    name: ["toHaveNthReturnedWith", "nthReturnedWith"],
    condition: /* @__PURE__ */ __name((spy, index, value) => {
      const result = spy.mock.results[index - 1];
      return result && result.type === "return" && equals(result.value, value);
    }, "condition"),
    action: "return"
  }].forEach(({ name, condition, action }) => {
    def(name, function(nthCall, value) {
      const spy = getSpy(this);
      const spyName = spy.getMockName();
      const results = action === "return" ? spy.mock.results : spy.mock.settledResults;
      const result = results[nthCall - 1];
      const ordinalCall = `${ordinalOf(nthCall)} call`;
      this.assert(condition(spy, nthCall, value), `expected ${ordinalCall} "${spyName}" call to ${action} #{exp}`, `expected ${ordinalCall} "${spyName}" call to not ${action} #{exp}`, value, result === null || result === void 0 ? void 0 : result.value);
    });
  });
  def("withContext", function(context) {
    for (const key in context) {
      utils.flag(this, key, context[key]);
    }
    return this;
  });
  utils.addProperty(chai.Assertion.prototype, "resolves", /* @__PURE__ */ __name(function __VITEST_RESOLVES__() {
    const error = new Error("resolves");
    utils.flag(this, "promise", "resolves");
    utils.flag(this, "error", error);
    const test2 = utils.flag(this, "vitest-test");
    const obj = utils.flag(this, "object");
    if (utils.flag(this, "poll")) {
      throw new SyntaxError(`expect.poll() is not supported in combination with .resolves`);
    }
    if (typeof (obj === null || obj === void 0 ? void 0 : obj.then) !== "function") {
      throw new TypeError(`You must provide a Promise to expect() when using .resolves, not '${typeof obj}'.`);
    }
    const proxy = new Proxy(this, { get: /* @__PURE__ */ __name((target, key, receiver) => {
      const result = Reflect.get(target, key, receiver);
      if (typeof result !== "function") {
        return result instanceof chai.Assertion ? proxy : result;
      }
      return (...args) => {
        utils.flag(this, "_name", key);
        const promise = obj.then((value) => {
          utils.flag(this, "object", value);
          return result.call(this, ...args);
        }, (err) => {
          const _error = new AssertionError2(`promise rejected "${utils.inspect(err)}" instead of resolving`, { showDiff: false });
          _error.cause = err;
          _error.stack = error.stack.replace(error.message, _error.message);
          throw _error;
        });
        return recordAsyncExpect(test2, promise, createAssertionMessage(utils, this, !!args.length), error);
      };
    }, "get") });
    return proxy;
  }, "__VITEST_RESOLVES__"));
  utils.addProperty(chai.Assertion.prototype, "rejects", /* @__PURE__ */ __name(function __VITEST_REJECTS__() {
    const error = new Error("rejects");
    utils.flag(this, "promise", "rejects");
    utils.flag(this, "error", error);
    const test2 = utils.flag(this, "vitest-test");
    const obj = utils.flag(this, "object");
    const wrapper = typeof obj === "function" ? obj() : obj;
    if (utils.flag(this, "poll")) {
      throw new SyntaxError(`expect.poll() is not supported in combination with .rejects`);
    }
    if (typeof (wrapper === null || wrapper === void 0 ? void 0 : wrapper.then) !== "function") {
      throw new TypeError(`You must provide a Promise to expect() when using .rejects, not '${typeof wrapper}'.`);
    }
    const proxy = new Proxy(this, { get: /* @__PURE__ */ __name((target, key, receiver) => {
      const result = Reflect.get(target, key, receiver);
      if (typeof result !== "function") {
        return result instanceof chai.Assertion ? proxy : result;
      }
      return (...args) => {
        utils.flag(this, "_name", key);
        const promise = wrapper.then((value) => {
          const _error = new AssertionError2(`promise resolved "${utils.inspect(value)}" instead of rejecting`, {
            showDiff: true,
            expected: new Error("rejected promise"),
            actual: value
          });
          _error.stack = error.stack.replace(error.message, _error.message);
          throw _error;
        }, (err) => {
          utils.flag(this, "object", err);
          return result.call(this, ...args);
        });
        return recordAsyncExpect(test2, promise, createAssertionMessage(utils, this, !!args.length), error);
      };
    }, "get") });
    return proxy;
  }, "__VITEST_REJECTS__"));
}, "JestChaiExpect");
function ordinalOf(i2) {
  const j2 = i2 % 10;
  const k2 = i2 % 100;
  if (j2 === 1 && k2 !== 11) {
    return `${i2}st`;
  }
  if (j2 === 2 && k2 !== 12) {
    return `${i2}nd`;
  }
  if (j2 === 3 && k2 !== 13) {
    return `${i2}rd`;
  }
  return `${i2}th`;
}
__name(ordinalOf, "ordinalOf");
function formatCalls(spy, msg, showActualCall) {
  if (spy.mock.calls.length) {
    msg += s.gray(`

Received: 

${spy.mock.calls.map((callArg, i2) => {
      let methodCall = s.bold(`  ${ordinalOf(i2 + 1)} ${spy.getMockName()} call:

`);
      if (showActualCall) {
        methodCall += diff(showActualCall, callArg, { omitAnnotationLines: true });
      } else {
        methodCall += stringify(callArg).split("\n").map((line) => `    ${line}`).join("\n");
      }
      methodCall += "\n";
      return methodCall;
    }).join("\n")}`);
  }
  msg += s.gray(`

Number of calls: ${s.bold(spy.mock.calls.length)}
`);
  return msg;
}
__name(formatCalls, "formatCalls");
function formatReturns(spy, results, msg, showActualReturn) {
  if (results.length) {
    msg += s.gray(`

Received: 

${results.map((callReturn, i2) => {
      let methodCall = s.bold(`  ${ordinalOf(i2 + 1)} ${spy.getMockName()} call return:

`);
      if (showActualReturn) {
        methodCall += diff(showActualReturn, callReturn.value, { omitAnnotationLines: true });
      } else {
        methodCall += stringify(callReturn).split("\n").map((line) => `    ${line}`).join("\n");
      }
      methodCall += "\n";
      return methodCall;
    }).join("\n")}`);
  }
  msg += s.gray(`

Number of calls: ${s.bold(spy.mock.calls.length)}
`);
  return msg;
}
__name(formatReturns, "formatReturns");
function getMatcherState(assertion, expect4) {
  const obj = assertion._obj;
  const isNot = utils_exports.flag(assertion, "negate");
  const promise = utils_exports.flag(assertion, "promise") || "";
  const jestUtils = {
    ...getMatcherUtils(),
    diff,
    stringify,
    iterableEquality,
    subsetEquality
  };
  const matcherState = {
    ...getState(expect4),
    customTesters: getCustomEqualityTesters(),
    isNot,
    utils: jestUtils,
    promise,
    equals,
    suppressedErrors: [],
    soft: utils_exports.flag(assertion, "soft"),
    poll: utils_exports.flag(assertion, "poll")
  };
  return {
    state: matcherState,
    isNot,
    obj
  };
}
__name(getMatcherState, "getMatcherState");
var _JestExtendError = class _JestExtendError extends Error {
  constructor(message, actual, expected) {
    super(message);
    this.actual = actual;
    this.expected = expected;
  }
};
__name(_JestExtendError, "JestExtendError");
var JestExtendError = _JestExtendError;
function JestExtendPlugin(c2, expect4, matchers) {
  return (_, utils) => {
    Object.entries(matchers).forEach(([expectAssertionName, expectAssertion]) => {
      function expectWrapper(...args) {
        const { state, isNot, obj } = getMatcherState(this, expect4);
        const result = expectAssertion.call(state, obj, ...args);
        if (result && typeof result === "object" && typeof result.then === "function") {
          const thenable = result;
          return thenable.then(({ pass: pass2, message: message2, actual: actual2, expected: expected2 }) => {
            if (pass2 && isNot || !pass2 && !isNot) {
              throw new JestExtendError(message2(), actual2, expected2);
            }
          });
        }
        const { pass, message, actual, expected } = result;
        if (pass && isNot || !pass && !isNot) {
          throw new JestExtendError(message(), actual, expected);
        }
      }
      __name(expectWrapper, "expectWrapper");
      const softWrapper = wrapAssertion(utils, expectAssertionName, expectWrapper);
      utils.addMethod(globalThis[JEST_MATCHERS_OBJECT].matchers, expectAssertionName, softWrapper);
      utils.addMethod(c2.Assertion.prototype, expectAssertionName, softWrapper);
      const _CustomMatcher = class _CustomMatcher extends AsymmetricMatcher {
        constructor(inverse = false, ...sample) {
          super(sample, inverse);
        }
        asymmetricMatch(other) {
          const { pass } = expectAssertion.call(this.getMatcherContext(expect4), other, ...this.sample);
          return this.inverse ? !pass : pass;
        }
        toString() {
          return `${this.inverse ? "not." : ""}${expectAssertionName}`;
        }
        getExpectedType() {
          return "any";
        }
        toAsymmetricMatcher() {
          return `${this.toString()}<${this.sample.map((item) => stringify(item)).join(", ")}>`;
        }
      };
      __name(_CustomMatcher, "CustomMatcher");
      let CustomMatcher = _CustomMatcher;
      const customMatcher = /* @__PURE__ */ __name((...sample) => new CustomMatcher(false, ...sample), "customMatcher");
      Object.defineProperty(expect4, expectAssertionName, {
        configurable: true,
        enumerable: true,
        value: customMatcher,
        writable: true
      });
      Object.defineProperty(expect4.not, expectAssertionName, {
        configurable: true,
        enumerable: true,
        value: /* @__PURE__ */ __name((...sample) => new CustomMatcher(true, ...sample), "value"),
        writable: true
      });
      Object.defineProperty(globalThis[ASYMMETRIC_MATCHERS_OBJECT], expectAssertionName, {
        configurable: true,
        enumerable: true,
        value: customMatcher,
        writable: true
      });
    });
  };
}
__name(JestExtendPlugin, "JestExtendPlugin");
var JestExtend = /* @__PURE__ */ __name((chai, utils) => {
  utils.addMethod(chai.expect, "extend", (expect4, expects) => {
    use(JestExtendPlugin(chai, expect4, expects));
  });
}, "JestExtend");

// src/test/expect.ts
function createExpect() {
  use(JestExtend);
  use(JestChaiExpect);
  use(JestAsymmetricMatchers);
  const expect4 = /* @__PURE__ */ __name((value, message) => {
    const { assertionCalls } = getState(expect4);
    setState({ assertionCalls: assertionCalls + 1, soft: false }, expect4);
    return expect(value, message);
  }, "expect");
  Object.assign(expect4, expect);
  expect4.getState = () => getState(expect4);
  expect4.setState = (state) => setState(state, expect4);
  expect4.extend = (expects) => expect.extend(expect4, expects);
  expect4.soft = (...args) => {
    const assert2 = expect4(...args);
    expect4.setState({
      soft: true
    });
    return assert2;
  };
  expect4.extend(customMatchers);
  expect4.unreachable = (message) => {
    assert.fail(`expected${message ? ` "${message}" ` : " "}not to be reached`);
  };
  function assertions(expected) {
    const errorGen = /* @__PURE__ */ __name(() => new Error(
      `expected number of assertions to be ${expected}, but got ${expect4.getState().assertionCalls}`
    ), "errorGen");
    if ("captureStackTrace" in Error && typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(errorGen(), assertions);
    }
    expect4.setState({
      expectedAssertionsNumber: expected,
      expectedAssertionsNumberErrorGen: errorGen
    });
  }
  __name(assertions, "assertions");
  function hasAssertions() {
    const error = new Error("expected any number of assertion, but got none");
    if ("captureStackTrace" in Error && typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(error, hasAssertions);
    }
    expect4.setState({
      isExpectingAssertions: true,
      isExpectingAssertionsError: error
    });
  }
  __name(hasAssertions, "hasAssertions");
  setState(
    {
      // this should also add "snapshotState" that is added conditionally
      assertionCalls: 0,
      isExpectingAssertions: false,
      isExpectingAssertionsError: null,
      expectedAssertionsNumber: null,
      expectedAssertionsNumberErrorGen: null
    },
    expect4
  );
  utils_exports.addMethod(expect4, "assertions", assertions);
  utils_exports.addMethod(expect4, "hasAssertions", hasAssertions);
  expect4.extend(matchers_exports);
  return expect4;
}
__name(createExpect, "createExpect");
var expect2 = createExpect();
Object.defineProperty(globalThis, GLOBAL_EXPECT, {
  value: expect2,
  writable: true,
  configurable: true
});

// ../node_modules/tinyspy/dist/index.js
function f2(e2, t2, n2) {
  Object.defineProperty(e2, t2, n2);
}
__name(f2, "f");
var u2 = Symbol.for("tinyspy:spy");
var P2 = /* @__PURE__ */ __name((e2) => {
  e2.called = false, e2.callCount = 0, e2.calls = [], e2.results = [], e2.resolves = [], e2.next = [];
}, "P");
var K2 = /* @__PURE__ */ __name((e2) => (f2(e2, u2, { value: { reset: /* @__PURE__ */ __name(() => P2(e2[u2]), "reset") } }), e2[u2]), "K");
var T2 = /* @__PURE__ */ __name((e2) => e2[u2] || K2(e2), "T");

// src/test/spy.ts
var listeners = /* @__PURE__ */ new Set();
function onMockCall(callback) {
  listeners.add(callback);
  return () => void listeners.delete(callback);
}
__name(onMockCall, "onMockCall");
var spyOn2 = /* @__PURE__ */ __name((...args) => {
  const mock = spyOn(...args);
  return reactiveMock(mock);
}, "spyOn");
function fn2(implementation) {
  const mock = implementation ? fn(implementation) : fn();
  return reactiveMock(mock);
}
__name(fn2, "fn");
function reactiveMock(mock) {
  const reactive = listenWhenCalled(mock);
  const originalMockImplementation = reactive.mockImplementation.bind(null);
  reactive.mockImplementation = (fn3) => listenWhenCalled(originalMockImplementation(fn3));
  return reactive;
}
__name(reactiveMock, "reactiveMock");
function listenWhenCalled(mock) {
  const state = T2(mock);
  const impl = state.impl;
  state.willCall(function(...args) {
    listeners.forEach((listener) => listener(mock, args));
    return impl?.apply(this, args);
  });
  return mock;
}
__name(listenWhenCalled, "listenWhenCalled");
function clearAllMocks() {
  mocks.forEach((spy) => spy.mockClear());
}
__name(clearAllMocks, "clearAllMocks");
function resetAllMocks() {
  mocks.forEach((spy) => spy.mockReset());
}
__name(resetAllMocks, "resetAllMocks");
function restoreAllMocks() {
  mocks.forEach((spy) => spy.mockRestore());
}
__name(restoreAllMocks, "restoreAllMocks");
function mocked(item, _options = {}) {
  return item;
}
__name(mocked, "mocked");

// ../node_modules/@testing-library/dom/dist/@testing-library/dom.esm.js
var dom_esm_exports = {};
__export(dom_esm_exports, {
  buildQueries: () => buildQueries,
  configure: () => configure,
  createEvent: () => createEvent,
  findAllByAltText: () => findAllByAltText,
  findAllByDisplayValue: () => findAllByDisplayValue,
  findAllByLabelText: () => findAllByLabelText,
  findAllByPlaceholderText: () => findAllByPlaceholderText,
  findAllByRole: () => findAllByRole,
  findAllByTestId: () => findAllByTestId,
  findAllByText: () => findAllByText,
  findAllByTitle: () => findAllByTitle,
  findByAltText: () => findByAltText,
  findByDisplayValue: () => findByDisplayValue,
  findByLabelText: () => findByLabelText,
  findByPlaceholderText: () => findByPlaceholderText,
  findByRole: () => findByRole,
  findByTestId: () => findByTestId,
  findByText: () => findByText,
  findByTitle: () => findByTitle,
  fireEvent: () => fireEvent,
  getAllByAltText: () => getAllByAltText,
  getAllByDisplayValue: () => getAllByDisplayValue,
  getAllByLabelText: () => getAllByLabelTextWithSuggestions,
  getAllByPlaceholderText: () => getAllByPlaceholderText,
  getAllByRole: () => getAllByRole,
  getAllByTestId: () => getAllByTestId,
  getAllByText: () => getAllByText,
  getAllByTitle: () => getAllByTitle,
  getByAltText: () => getByAltText,
  getByDisplayValue: () => getByDisplayValue,
  getByLabelText: () => getByLabelTextWithSuggestions,
  getByPlaceholderText: () => getByPlaceholderText,
  getByRole: () => getByRole,
  getByTestId: () => getByTestId,
  getByText: () => getByText,
  getByTitle: () => getByTitle,
  getConfig: () => getConfig,
  getDefaultNormalizer: () => getDefaultNormalizer,
  getElementError: () => getElementError,
  getMultipleElementsFoundError: () => getMultipleElementsFoundError,
  getNodeText: () => getNodeText,
  getQueriesForElement: () => getQueriesForElement,
  getRoles: () => getRoles,
  getSuggestedQuery: () => getSuggestedQuery,
  isInaccessible: () => isInaccessible,
  logDOM: () => logDOM,
  logRoles: () => logRoles,
  makeFindQuery: () => makeFindQuery,
  makeGetAllQuery: () => makeGetAllQuery,
  makeSingleQuery: () => makeSingleQuery,
  prettyDOM: () => prettyDOM,
  prettyFormat: () => prettyFormat,
  queries: () => queries,
  queryAllByAltText: () => queryAllByAltTextWithSuggestions,
  queryAllByAttribute: () => queryAllByAttribute,
  queryAllByDisplayValue: () => queryAllByDisplayValueWithSuggestions,
  queryAllByLabelText: () => queryAllByLabelTextWithSuggestions,
  queryAllByPlaceholderText: () => queryAllByPlaceholderTextWithSuggestions,
  queryAllByRole: () => queryAllByRoleWithSuggestions,
  queryAllByTestId: () => queryAllByTestIdWithSuggestions,
  queryAllByText: () => queryAllByTextWithSuggestions,
  queryAllByTitle: () => queryAllByTitleWithSuggestions,
  queryByAltText: () => queryByAltText,
  queryByAttribute: () => queryByAttribute,
  queryByDisplayValue: () => queryByDisplayValue,
  queryByLabelText: () => queryByLabelText,
  queryByPlaceholderText: () => queryByPlaceholderText,
  queryByRole: () => queryByRole,
  queryByTestId: () => queryByTestId,
  queryByText: () => queryByText,
  queryByTitle: () => queryByTitle,
  queryHelpers: () => queryHelpers,
  screen: () => screen,
  waitFor: () => waitForWrapper,
  waitForElementToBeRemoved: () => waitForElementToBeRemoved,
  within: () => getQueriesForElement,
  wrapAllByQueryWithSuggestion: () => wrapAllByQueryWithSuggestion,
  wrapSingleQueryWithSuggestion: () => wrapSingleQueryWithSuggestion
});
var prettyFormat = __toESM(require_build());

// ../node_modules/dom-accessibility-api/dist/polyfills/array.from.mjs
var toStr2 = Object.prototype.toString;
function isCallable2(fn3) {
  return typeof fn3 === "function" || toStr2.call(fn3) === "[object Function]";
}
__name(isCallable2, "isCallable");
function toInteger2(value) {
  var number = Number(value);
  if (isNaN(number)) {
    return 0;
  }
  if (number === 0 || !isFinite(number)) {
    return number;
  }
  return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
}
__name(toInteger2, "toInteger");
var maxSafeInteger2 = Math.pow(2, 53) - 1;
function toLength2(value) {
  var len = toInteger2(value);
  return Math.min(Math.max(len, 0), maxSafeInteger2);
}
__name(toLength2, "toLength");
function arrayFrom2(arrayLike, mapFn) {
  var C = Array;
  var items = Object(arrayLike);
  if (arrayLike == null) {
    throw new TypeError("Array.from requires an array-like object - not null or undefined");
  }
  if (typeof mapFn !== "undefined") {
    if (!isCallable2(mapFn)) {
      throw new TypeError("Array.from: when provided, the second argument must be a function");
    }
  }
  var len = toLength2(items.length);
  var A = isCallable2(C) ? Object(new C(len)) : new Array(len);
  var k2 = 0;
  var kValue;
  while (k2 < len) {
    kValue = items[k2];
    if (mapFn) {
      A[k2] = mapFn(kValue, k2);
    } else {
      A[k2] = kValue;
    }
    k2 += 1;
  }
  A.length = len;
  return A;
}
__name(arrayFrom2, "arrayFrom");

// ../node_modules/dom-accessibility-api/dist/polyfills/SetLike.mjs
function _typeof3(obj) {
  "@babel/helpers - typeof";
  return _typeof3 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof3(obj);
}
__name(_typeof3, "_typeof");
function _classCallCheck2(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
__name(_classCallCheck2, "_classCallCheck");
function _defineProperties2(target, props) {
  for (var i2 = 0; i2 < props.length; i2++) {
    var descriptor = props[i2];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey3(descriptor.key), descriptor);
  }
}
__name(_defineProperties2, "_defineProperties");
function _createClass2(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties2(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties2(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", { writable: false });
  return Constructor;
}
__name(_createClass2, "_createClass");
function _defineProperty3(obj, key, value) {
  key = _toPropertyKey3(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_defineProperty3, "_defineProperty");
function _toPropertyKey3(arg) {
  var key = _toPrimitive3(arg, "string");
  return _typeof3(key) === "symbol" ? key : String(key);
}
__name(_toPropertyKey3, "_toPropertyKey");
function _toPrimitive3(input2, hint) {
  if (_typeof3(input2) !== "object" || input2 === null) return input2;
  var prim = input2[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input2, hint || "default");
    if (_typeof3(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input2);
}
__name(_toPrimitive3, "_toPrimitive");
var SetLike2 = function() {
  function SetLike3() {
    var items = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : [];
    _classCallCheck2(this, SetLike3);
    _defineProperty3(this, "items", void 0);
    this.items = items;
  }
  __name(SetLike3, "SetLike");
  _createClass2(SetLike3, [{
    key: "add",
    value: /* @__PURE__ */ __name(function add(value) {
      if (this.has(value) === false) {
        this.items.push(value);
      }
      return this;
    }, "add")
  }, {
    key: "clear",
    value: /* @__PURE__ */ __name(function clear3() {
      this.items = [];
    }, "clear")
  }, {
    key: "delete",
    value: /* @__PURE__ */ __name(function _delete(value) {
      var previousLength = this.items.length;
      this.items = this.items.filter(function(item) {
        return item !== value;
      });
      return previousLength !== this.items.length;
    }, "_delete")
  }, {
    key: "forEach",
    value: /* @__PURE__ */ __name(function forEach(callbackfn) {
      var _this = this;
      this.items.forEach(function(item) {
        callbackfn(item, item, _this);
      });
    }, "forEach")
  }, {
    key: "has",
    value: /* @__PURE__ */ __name(function has(value) {
      return this.items.indexOf(value) !== -1;
    }, "has")
  }, {
    key: "size",
    get: /* @__PURE__ */ __name(function get2() {
      return this.items.length;
    }, "get")
  }]);
  return SetLike3;
}();
var SetLike_default2 = typeof Set === "undefined" ? Set : SetLike2;

// ../node_modules/dom-accessibility-api/dist/getRole.mjs
function getLocalName2(element) {
  var _element$localName;
  return (
    // eslint-disable-next-line no-restricted-properties -- actual guard for environments without localName
    (_element$localName = element.localName) !== null && _element$localName !== void 0 ? _element$localName : (
      // eslint-disable-next-line no-restricted-properties -- required for the fallback
      element.tagName.toLowerCase()
    )
  );
}
__name(getLocalName2, "getLocalName");
var localNameToRoleMappings2 = {
  article: "article",
  aside: "complementary",
  button: "button",
  datalist: "listbox",
  dd: "definition",
  details: "group",
  dialog: "dialog",
  dt: "term",
  fieldset: "group",
  figure: "figure",
  // WARNING: Only with an accessible name
  form: "form",
  footer: "contentinfo",
  h1: "heading",
  h2: "heading",
  h3: "heading",
  h4: "heading",
  h5: "heading",
  h6: "heading",
  header: "banner",
  hr: "separator",
  html: "document",
  legend: "legend",
  li: "listitem",
  math: "math",
  main: "main",
  menu: "list",
  nav: "navigation",
  ol: "list",
  optgroup: "group",
  // WARNING: Only in certain context
  option: "option",
  output: "status",
  progress: "progressbar",
  // WARNING: Only with an accessible name
  section: "region",
  summary: "button",
  table: "table",
  tbody: "rowgroup",
  textarea: "textbox",
  tfoot: "rowgroup",
  // WARNING: Only in certain context
  td: "cell",
  th: "columnheader",
  thead: "rowgroup",
  tr: "row",
  ul: "list"
};
var prohibitedAttributes2 = {
  caption: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  code: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  deletion: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  emphasis: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  generic: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby", "aria-roledescription"]),
  insertion: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  paragraph: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  presentation: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  strong: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  subscript: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"]),
  superscript: /* @__PURE__ */ new Set(["aria-label", "aria-labelledby"])
};
function hasGlobalAriaAttributes2(element, role) {
  return [
    "aria-atomic",
    "aria-busy",
    "aria-controls",
    "aria-current",
    "aria-describedby",
    "aria-details",
    // "disabled",
    "aria-dropeffect",
    // "errormessage",
    "aria-flowto",
    "aria-grabbed",
    // "haspopup",
    "aria-hidden",
    // "invalid",
    "aria-keyshortcuts",
    "aria-label",
    "aria-labelledby",
    "aria-live",
    "aria-owns",
    "aria-relevant",
    "aria-roledescription"
  ].some(function(attributeName) {
    var _prohibitedAttributes;
    return element.hasAttribute(attributeName) && !((_prohibitedAttributes = prohibitedAttributes2[role]) !== null && _prohibitedAttributes !== void 0 && _prohibitedAttributes.has(attributeName));
  });
}
__name(hasGlobalAriaAttributes2, "hasGlobalAriaAttributes");
function ignorePresentationalRole2(element, implicitRole) {
  return hasGlobalAriaAttributes2(element, implicitRole);
}
__name(ignorePresentationalRole2, "ignorePresentationalRole");
function getRole2(element) {
  var explicitRole = getExplicitRole2(element);
  if (explicitRole === null || explicitRole === "presentation") {
    var implicitRole = getImplicitRole2(element);
    if (explicitRole !== "presentation" || ignorePresentationalRole2(element, implicitRole || "")) {
      return implicitRole;
    }
  }
  return explicitRole;
}
__name(getRole2, "getRole");
function getImplicitRole2(element) {
  var mappedByTag = localNameToRoleMappings2[getLocalName2(element)];
  if (mappedByTag !== void 0) {
    return mappedByTag;
  }
  switch (getLocalName2(element)) {
    case "a":
    case "area":
    case "link":
      if (element.hasAttribute("href")) {
        return "link";
      }
      break;
    case "img":
      if (element.getAttribute("alt") === "" && !ignorePresentationalRole2(element, "img")) {
        return "presentation";
      }
      return "img";
    case "input": {
      var _ref = element, type5 = _ref.type;
      switch (type5) {
        case "button":
        case "image":
        case "reset":
        case "submit":
          return "button";
        case "checkbox":
        case "radio":
          return type5;
        case "range":
          return "slider";
        case "email":
        case "tel":
        case "text":
        case "url":
          if (element.hasAttribute("list")) {
            return "combobox";
          }
          return "textbox";
        case "search":
          if (element.hasAttribute("list")) {
            return "combobox";
          }
          return "searchbox";
        case "number":
          return "spinbutton";
        default:
          return null;
      }
    }
    case "select":
      if (element.hasAttribute("multiple") || element.size > 1) {
        return "listbox";
      }
      return "combobox";
  }
  return null;
}
__name(getImplicitRole2, "getImplicitRole");
function getExplicitRole2(element) {
  var role = element.getAttribute("role");
  if (role !== null) {
    var explicitRole = role.trim().split(" ")[0];
    if (explicitRole.length > 0) {
      return explicitRole;
    }
  }
  return null;
}
__name(getExplicitRole2, "getExplicitRole");

// ../node_modules/dom-accessibility-api/dist/util.mjs
function isElement2(node) {
  return node !== null && node.nodeType === node.ELEMENT_NODE;
}
__name(isElement2, "isElement");
function isHTMLTableCaptionElement2(node) {
  return isElement2(node) && getLocalName2(node) === "caption";
}
__name(isHTMLTableCaptionElement2, "isHTMLTableCaptionElement");
function isHTMLInputElement2(node) {
  return isElement2(node) && getLocalName2(node) === "input";
}
__name(isHTMLInputElement2, "isHTMLInputElement");
function isHTMLOptGroupElement2(node) {
  return isElement2(node) && getLocalName2(node) === "optgroup";
}
__name(isHTMLOptGroupElement2, "isHTMLOptGroupElement");
function isHTMLSelectElement2(node) {
  return isElement2(node) && getLocalName2(node) === "select";
}
__name(isHTMLSelectElement2, "isHTMLSelectElement");
function isHTMLTableElement2(node) {
  return isElement2(node) && getLocalName2(node) === "table";
}
__name(isHTMLTableElement2, "isHTMLTableElement");
function isHTMLTextAreaElement2(node) {
  return isElement2(node) && getLocalName2(node) === "textarea";
}
__name(isHTMLTextAreaElement2, "isHTMLTextAreaElement");
function safeWindow2(node) {
  var _ref = node.ownerDocument === null ? node : node.ownerDocument, defaultView = _ref.defaultView;
  if (defaultView === null) {
    throw new TypeError("no window available");
  }
  return defaultView;
}
__name(safeWindow2, "safeWindow");
function isHTMLFieldSetElement2(node) {
  return isElement2(node) && getLocalName2(node) === "fieldset";
}
__name(isHTMLFieldSetElement2, "isHTMLFieldSetElement");
function isHTMLLegendElement2(node) {
  return isElement2(node) && getLocalName2(node) === "legend";
}
__name(isHTMLLegendElement2, "isHTMLLegendElement");
function isHTMLSlotElement2(node) {
  return isElement2(node) && getLocalName2(node) === "slot";
}
__name(isHTMLSlotElement2, "isHTMLSlotElement");
function isSVGElement2(node) {
  return isElement2(node) && node.ownerSVGElement !== void 0;
}
__name(isSVGElement2, "isSVGElement");
function isSVGSVGElement2(node) {
  return isElement2(node) && getLocalName2(node) === "svg";
}
__name(isSVGSVGElement2, "isSVGSVGElement");
function isSVGTitleElement2(node) {
  return isSVGElement2(node) && getLocalName2(node) === "title";
}
__name(isSVGTitleElement2, "isSVGTitleElement");
function queryIdRefs2(node, attributeName) {
  if (isElement2(node) && node.hasAttribute(attributeName)) {
    var ids = node.getAttribute(attributeName).split(" ");
    var root = node.getRootNode ? node.getRootNode() : node.ownerDocument;
    return ids.map(function(id) {
      return root.getElementById(id);
    }).filter(
      function(element) {
        return element !== null;
      }
      // TODO: why does this not narrow?
    );
  }
  return [];
}
__name(queryIdRefs2, "queryIdRefs");
function hasAnyConcreteRoles2(node, roles3) {
  if (isElement2(node)) {
    return roles3.indexOf(getRole2(node)) !== -1;
  }
  return false;
}
__name(hasAnyConcreteRoles2, "hasAnyConcreteRoles");

// ../node_modules/dom-accessibility-api/dist/accessible-name-and-description.mjs
function asFlatString2(s3) {
  return s3.trim().replace(/\s\s+/g, " ");
}
__name(asFlatString2, "asFlatString");
function isHidden2(node, getComputedStyleImplementation) {
  if (!isElement2(node)) {
    return false;
  }
  if (node.hasAttribute("hidden") || node.getAttribute("aria-hidden") === "true") {
    return true;
  }
  var style = getComputedStyleImplementation(node);
  return style.getPropertyValue("display") === "none" || style.getPropertyValue("visibility") === "hidden";
}
__name(isHidden2, "isHidden");
function isControl2(node) {
  return hasAnyConcreteRoles2(node, ["button", "combobox", "listbox", "textbox"]) || hasAbstractRole2(node, "range");
}
__name(isControl2, "isControl");
function hasAbstractRole2(node, role) {
  if (!isElement2(node)) {
    return false;
  }
  switch (role) {
    case "range":
      return hasAnyConcreteRoles2(node, ["meter", "progressbar", "scrollbar", "slider", "spinbutton"]);
    default:
      throw new TypeError("No knowledge about abstract role '".concat(role, "'. This is likely a bug :("));
  }
}
__name(hasAbstractRole2, "hasAbstractRole");
function querySelectorAllSubtree2(element, selectors) {
  var elements = arrayFrom2(element.querySelectorAll(selectors));
  queryIdRefs2(element, "aria-owns").forEach(function(root) {
    elements.push.apply(elements, arrayFrom2(root.querySelectorAll(selectors)));
  });
  return elements;
}
__name(querySelectorAllSubtree2, "querySelectorAllSubtree");
function querySelectedOptions2(listbox) {
  if (isHTMLSelectElement2(listbox)) {
    return listbox.selectedOptions || querySelectorAllSubtree2(listbox, "[selected]");
  }
  return querySelectorAllSubtree2(listbox, '[aria-selected="true"]');
}
__name(querySelectedOptions2, "querySelectedOptions");
function isMarkedPresentational2(node) {
  return hasAnyConcreteRoles2(node, ["none", "presentation"]);
}
__name(isMarkedPresentational2, "isMarkedPresentational");
function isNativeHostLanguageTextAlternativeElement2(node) {
  return isHTMLTableCaptionElement2(node);
}
__name(isNativeHostLanguageTextAlternativeElement2, "isNativeHostLanguageTextAlternativeElement");
function allowsNameFromContent2(node) {
  return hasAnyConcreteRoles2(node, ["button", "cell", "checkbox", "columnheader", "gridcell", "heading", "label", "legend", "link", "menuitem", "menuitemcheckbox", "menuitemradio", "option", "radio", "row", "rowheader", "switch", "tab", "tooltip", "treeitem"]);
}
__name(allowsNameFromContent2, "allowsNameFromContent");
function isDescendantOfNativeHostLanguageTextAlternativeElement2(node) {
  return false;
}
__name(isDescendantOfNativeHostLanguageTextAlternativeElement2, "isDescendantOfNativeHostLanguageTextAlternativeElement");
function getValueOfTextbox2(element) {
  if (isHTMLInputElement2(element) || isHTMLTextAreaElement2(element)) {
    return element.value;
  }
  return element.textContent || "";
}
__name(getValueOfTextbox2, "getValueOfTextbox");
function getTextualContent2(declaration) {
  var content = declaration.getPropertyValue("content");
  if (/^["'].*["']$/.test(content)) {
    return content.slice(1, -1);
  }
  return "";
}
__name(getTextualContent2, "getTextualContent");
function isLabelableElement2(element) {
  var localName = getLocalName2(element);
  return localName === "button" || localName === "input" && element.getAttribute("type") !== "hidden" || localName === "meter" || localName === "output" || localName === "progress" || localName === "select" || localName === "textarea";
}
__name(isLabelableElement2, "isLabelableElement");
function findLabelableElement2(element) {
  if (isLabelableElement2(element)) {
    return element;
  }
  var labelableElement = null;
  element.childNodes.forEach(function(childNode) {
    if (labelableElement === null && isElement2(childNode)) {
      var descendantLabelableElement = findLabelableElement2(childNode);
      if (descendantLabelableElement !== null) {
        labelableElement = descendantLabelableElement;
      }
    }
  });
  return labelableElement;
}
__name(findLabelableElement2, "findLabelableElement");
function getControlOfLabel2(label) {
  if (label.control !== void 0) {
    return label.control;
  }
  var htmlFor = label.getAttribute("for");
  if (htmlFor !== null) {
    return label.ownerDocument.getElementById(htmlFor);
  }
  return findLabelableElement2(label);
}
__name(getControlOfLabel2, "getControlOfLabel");
function getLabels2(element) {
  var labelsProperty = element.labels;
  if (labelsProperty === null) {
    return labelsProperty;
  }
  if (labelsProperty !== void 0) {
    return arrayFrom2(labelsProperty);
  }
  if (!isLabelableElement2(element)) {
    return null;
  }
  var document2 = element.ownerDocument;
  return arrayFrom2(document2.querySelectorAll("label")).filter(function(label) {
    return getControlOfLabel2(label) === element;
  });
}
__name(getLabels2, "getLabels");
function getSlotContents2(slot) {
  var assignedNodes = slot.assignedNodes();
  if (assignedNodes.length === 0) {
    return arrayFrom2(slot.childNodes);
  }
  return assignedNodes;
}
__name(getSlotContents2, "getSlotContents");
function computeTextAlternative2(root) {
  var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var consultedNodes = new SetLike_default2();
  var window2 = safeWindow2(root);
  var _options$compute = options.compute, compute = _options$compute === void 0 ? "name" : _options$compute, _options$computedStyl = options.computedStyleSupportsPseudoElements, computedStyleSupportsPseudoElements = _options$computedStyl === void 0 ? options.getComputedStyle !== void 0 : _options$computedStyl, _options$getComputedS = options.getComputedStyle, getComputedStyle = _options$getComputedS === void 0 ? window2.getComputedStyle.bind(window2) : _options$getComputedS, _options$hidden = options.hidden, hidden = _options$hidden === void 0 ? false : _options$hidden;
  function computeMiscTextAlternative(node, context) {
    var accumulatedText = "";
    if (isElement2(node) && computedStyleSupportsPseudoElements) {
      var pseudoBefore = getComputedStyle(node, "::before");
      var beforeContent = getTextualContent2(pseudoBefore);
      accumulatedText = "".concat(beforeContent, " ").concat(accumulatedText);
    }
    var childNodes = isHTMLSlotElement2(node) ? getSlotContents2(node) : arrayFrom2(node.childNodes).concat(queryIdRefs2(node, "aria-owns"));
    childNodes.forEach(function(child) {
      var result = computeTextAlternative3(child, {
        isEmbeddedInLabel: context.isEmbeddedInLabel,
        isReferenced: false,
        recursion: true
      });
      var display2 = isElement2(child) ? getComputedStyle(child).getPropertyValue("display") : "inline";
      var separator = display2 !== "inline" ? " " : "";
      accumulatedText += "".concat(separator).concat(result).concat(separator);
    });
    if (isElement2(node) && computedStyleSupportsPseudoElements) {
      var pseudoAfter = getComputedStyle(node, "::after");
      var afterContent = getTextualContent2(pseudoAfter);
      accumulatedText = "".concat(accumulatedText, " ").concat(afterContent);
    }
    return accumulatedText.trim();
  }
  __name(computeMiscTextAlternative, "computeMiscTextAlternative");
  function useAttribute(element, attributeName) {
    var attribute = element.getAttributeNode(attributeName);
    if (attribute !== null && !consultedNodes.has(attribute) && attribute.value.trim() !== "") {
      consultedNodes.add(attribute);
      return attribute.value;
    }
    return null;
  }
  __name(useAttribute, "useAttribute");
  function computeTooltipAttributeValue(node) {
    if (!isElement2(node)) {
      return null;
    }
    return useAttribute(node, "title");
  }
  __name(computeTooltipAttributeValue, "computeTooltipAttributeValue");
  function computeElementTextAlternative(node) {
    if (!isElement2(node)) {
      return null;
    }
    if (isHTMLFieldSetElement2(node)) {
      consultedNodes.add(node);
      var children = arrayFrom2(node.childNodes);
      for (var i2 = 0; i2 < children.length; i2 += 1) {
        var child = children[i2];
        if (isHTMLLegendElement2(child)) {
          return computeTextAlternative3(child, {
            isEmbeddedInLabel: false,
            isReferenced: false,
            recursion: false
          });
        }
      }
    } else if (isHTMLTableElement2(node)) {
      consultedNodes.add(node);
      var _children = arrayFrom2(node.childNodes);
      for (var _i = 0; _i < _children.length; _i += 1) {
        var _child = _children[_i];
        if (isHTMLTableCaptionElement2(_child)) {
          return computeTextAlternative3(_child, {
            isEmbeddedInLabel: false,
            isReferenced: false,
            recursion: false
          });
        }
      }
    } else if (isSVGSVGElement2(node)) {
      consultedNodes.add(node);
      var _children2 = arrayFrom2(node.childNodes);
      for (var _i2 = 0; _i2 < _children2.length; _i2 += 1) {
        var _child2 = _children2[_i2];
        if (isSVGTitleElement2(_child2)) {
          return _child2.textContent;
        }
      }
      return null;
    } else if (getLocalName2(node) === "img" || getLocalName2(node) === "area") {
      var nameFromAlt = useAttribute(node, "alt");
      if (nameFromAlt !== null) {
        return nameFromAlt;
      }
    } else if (isHTMLOptGroupElement2(node)) {
      var nameFromLabel = useAttribute(node, "label");
      if (nameFromLabel !== null) {
        return nameFromLabel;
      }
    }
    if (isHTMLInputElement2(node) && (node.type === "button" || node.type === "submit" || node.type === "reset")) {
      var nameFromValue = useAttribute(node, "value");
      if (nameFromValue !== null) {
        return nameFromValue;
      }
      if (node.type === "submit") {
        return "Submit";
      }
      if (node.type === "reset") {
        return "Reset";
      }
    }
    var labels = getLabels2(node);
    if (labels !== null && labels.length !== 0) {
      consultedNodes.add(node);
      return arrayFrom2(labels).map(function(element) {
        return computeTextAlternative3(element, {
          isEmbeddedInLabel: true,
          isReferenced: false,
          recursion: true
        });
      }).filter(function(label) {
        return label.length > 0;
      }).join(" ");
    }
    if (isHTMLInputElement2(node) && node.type === "image") {
      var _nameFromAlt = useAttribute(node, "alt");
      if (_nameFromAlt !== null) {
        return _nameFromAlt;
      }
      var nameFromTitle = useAttribute(node, "title");
      if (nameFromTitle !== null) {
        return nameFromTitle;
      }
      return "Submit Query";
    }
    if (hasAnyConcreteRoles2(node, ["button"])) {
      var nameFromSubTree = computeMiscTextAlternative(node, {
        isEmbeddedInLabel: false,
        isReferenced: false
      });
      if (nameFromSubTree !== "") {
        return nameFromSubTree;
      }
    }
    return null;
  }
  __name(computeElementTextAlternative, "computeElementTextAlternative");
  function computeTextAlternative3(current, context) {
    if (consultedNodes.has(current)) {
      return "";
    }
    if (!hidden && isHidden2(current, getComputedStyle) && !context.isReferenced) {
      consultedNodes.add(current);
      return "";
    }
    var labelAttributeNode = isElement2(current) ? current.getAttributeNode("aria-labelledby") : null;
    var labelElements = labelAttributeNode !== null && !consultedNodes.has(labelAttributeNode) ? queryIdRefs2(current, "aria-labelledby") : [];
    if (compute === "name" && !context.isReferenced && labelElements.length > 0) {
      consultedNodes.add(labelAttributeNode);
      return labelElements.map(function(element) {
        return computeTextAlternative3(element, {
          isEmbeddedInLabel: context.isEmbeddedInLabel,
          isReferenced: true,
          // this isn't recursion as specified, otherwise we would skip
          // `aria-label` in
          // <input id="myself" aria-label="foo" aria-labelledby="myself"
          recursion: false
        });
      }).join(" ");
    }
    var skipToStep2E = context.recursion && isControl2(current) && compute === "name";
    if (!skipToStep2E) {
      var ariaLabel = (isElement2(current) && current.getAttribute("aria-label") || "").trim();
      if (ariaLabel !== "" && compute === "name") {
        consultedNodes.add(current);
        return ariaLabel;
      }
      if (!isMarkedPresentational2(current)) {
        var elementTextAlternative = computeElementTextAlternative(current);
        if (elementTextAlternative !== null) {
          consultedNodes.add(current);
          return elementTextAlternative;
        }
      }
    }
    if (hasAnyConcreteRoles2(current, ["menu"])) {
      consultedNodes.add(current);
      return "";
    }
    if (skipToStep2E || context.isEmbeddedInLabel || context.isReferenced) {
      if (hasAnyConcreteRoles2(current, ["combobox", "listbox"])) {
        consultedNodes.add(current);
        var selectedOptions = querySelectedOptions2(current);
        if (selectedOptions.length === 0) {
          return isHTMLInputElement2(current) ? current.value : "";
        }
        return arrayFrom2(selectedOptions).map(function(selectedOption) {
          return computeTextAlternative3(selectedOption, {
            isEmbeddedInLabel: context.isEmbeddedInLabel,
            isReferenced: false,
            recursion: true
          });
        }).join(" ");
      }
      if (hasAbstractRole2(current, "range")) {
        consultedNodes.add(current);
        if (current.hasAttribute("aria-valuetext")) {
          return current.getAttribute("aria-valuetext");
        }
        if (current.hasAttribute("aria-valuenow")) {
          return current.getAttribute("aria-valuenow");
        }
        return current.getAttribute("value") || "";
      }
      if (hasAnyConcreteRoles2(current, ["textbox"])) {
        consultedNodes.add(current);
        return getValueOfTextbox2(current);
      }
    }
    if (allowsNameFromContent2(current) || isElement2(current) && context.isReferenced || isNativeHostLanguageTextAlternativeElement2(current) || isDescendantOfNativeHostLanguageTextAlternativeElement2(current)) {
      var accumulatedText2F = computeMiscTextAlternative(current, {
        isEmbeddedInLabel: context.isEmbeddedInLabel,
        isReferenced: false
      });
      if (accumulatedText2F !== "") {
        consultedNodes.add(current);
        return accumulatedText2F;
      }
    }
    if (current.nodeType === current.TEXT_NODE) {
      consultedNodes.add(current);
      return current.textContent || "";
    }
    if (context.recursion) {
      consultedNodes.add(current);
      return computeMiscTextAlternative(current, {
        isEmbeddedInLabel: context.isEmbeddedInLabel,
        isReferenced: false
      });
    }
    var tooltipAttributeValue = computeTooltipAttributeValue(current);
    if (tooltipAttributeValue !== null) {
      consultedNodes.add(current);
      return tooltipAttributeValue;
    }
    consultedNodes.add(current);
    return "";
  }
  __name(computeTextAlternative3, "computeTextAlternative");
  return asFlatString2(computeTextAlternative3(root, {
    isEmbeddedInLabel: false,
    // by spec computeAccessibleDescription starts with the referenced elements as roots
    isReferenced: compute === "description",
    recursion: false
  }));
}
__name(computeTextAlternative2, "computeTextAlternative");

// ../node_modules/dom-accessibility-api/dist/accessible-description.mjs
function _typeof4(obj) {
  "@babel/helpers - typeof";
  return _typeof4 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof4(obj);
}
__name(_typeof4, "_typeof");
function ownKeys2(object, enumerableOnly) {
  var keys2 = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys2.push.apply(keys2, symbols);
  }
  return keys2;
}
__name(ownKeys2, "ownKeys");
function _objectSpread2(target) {
  for (var i2 = 1; i2 < arguments.length; i2++) {
    var source = null != arguments[i2] ? arguments[i2] : {};
    i2 % 2 ? ownKeys2(Object(source), true).forEach(function(key) {
      _defineProperty4(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys2(Object(source)).forEach(function(key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
__name(_objectSpread2, "_objectSpread");
function _defineProperty4(obj, key, value) {
  key = _toPropertyKey4(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_defineProperty4, "_defineProperty");
function _toPropertyKey4(arg) {
  var key = _toPrimitive4(arg, "string");
  return _typeof4(key) === "symbol" ? key : String(key);
}
__name(_toPropertyKey4, "_toPropertyKey");
function _toPrimitive4(input2, hint) {
  if (_typeof4(input2) !== "object" || input2 === null) return input2;
  var prim = input2[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input2, hint || "default");
    if (_typeof4(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input2);
}
__name(_toPrimitive4, "_toPrimitive");
function computeAccessibleDescription2(root) {
  var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  var description = queryIdRefs2(root, "aria-describedby").map(function(element) {
    return computeTextAlternative2(element, _objectSpread2(_objectSpread2({}, options), {}, {
      compute: "description"
    }));
  }).join(" ");
  if (description === "") {
    var title = root.getAttribute("title");
    description = title === null ? "" : title;
  }
  return description;
}
__name(computeAccessibleDescription2, "computeAccessibleDescription");

// ../node_modules/dom-accessibility-api/dist/accessible-name.mjs
function prohibitsNaming2(node) {
  return hasAnyConcreteRoles2(node, ["caption", "code", "deletion", "emphasis", "generic", "insertion", "paragraph", "presentation", "strong", "subscript", "superscript"]);
}
__name(prohibitsNaming2, "prohibitsNaming");
function computeAccessibleName2(root) {
  var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
  if (prohibitsNaming2(root)) {
    return "";
  }
  return computeTextAlternative2(root, options);
}
__name(computeAccessibleName2, "computeAccessibleName");

// ../node_modules/@testing-library/dom/dist/@testing-library/dom.esm.js
var import_aria_query3 = __toESM(require_lib());
var import_lz_string = __toESM(require_lz_string());
function escapeHTML(str) {
  return str.replace(/</g, "&lt;").replace(/>/g, "&gt;");
}
__name(escapeHTML, "escapeHTML");
var printProps = /* @__PURE__ */ __name((keys2, props, config3, indentation, depth, refs, printer) => {
  const indentationNext = indentation + config3.indent;
  const colors = config3.colors;
  return keys2.map((key) => {
    const value = props[key];
    let printed = printer(value, config3, indentationNext, depth, refs);
    if (typeof value !== "string") {
      if (printed.indexOf("\n") !== -1) {
        printed = config3.spacingOuter + indentationNext + printed + config3.spacingOuter + indentation;
      }
      printed = "{" + printed + "}";
    }
    return config3.spacingInner + indentation + colors.prop.open + key + colors.prop.close + "=" + colors.value.open + printed + colors.value.close;
  }).join("");
}, "printProps");
var NodeTypeTextNode = 3;
var printChildren = /* @__PURE__ */ __name((children, config3, indentation, depth, refs, printer) => children.map((child) => {
  const printedChild = typeof child === "string" ? printText(child, config3) : printer(child, config3, indentation, depth, refs);
  if (printedChild === "" && typeof child === "object" && child !== null && child.nodeType !== NodeTypeTextNode) {
    return "";
  }
  return config3.spacingOuter + indentation + printedChild;
}).join(""), "printChildren");
var printText = /* @__PURE__ */ __name((text, config3) => {
  const contentColor = config3.colors.content;
  return contentColor.open + escapeHTML(text) + contentColor.close;
}, "printText");
var printComment = /* @__PURE__ */ __name((comment, config3) => {
  const commentColor = config3.colors.comment;
  return commentColor.open + "<!--" + escapeHTML(comment) + "-->" + commentColor.close;
}, "printComment");
var printElement = /* @__PURE__ */ __name((type5, printedProps, printedChildren, config3, indentation) => {
  const tagColor = config3.colors.tag;
  return tagColor.open + "<" + type5 + (printedProps && tagColor.close + printedProps + config3.spacingOuter + indentation + tagColor.open) + (printedChildren ? ">" + tagColor.close + printedChildren + config3.spacingOuter + indentation + tagColor.open + "</" + type5 : (printedProps && !config3.min ? "" : " ") + "/") + ">" + tagColor.close;
}, "printElement");
var printElementAsLeaf = /* @__PURE__ */ __name((type5, config3) => {
  const tagColor = config3.colors.tag;
  return tagColor.open + "<" + type5 + tagColor.close + " \u2026" + tagColor.open + " />" + tagColor.close;
}, "printElementAsLeaf");
var ELEMENT_NODE$1 = 1;
var TEXT_NODE$1 = 3;
var COMMENT_NODE$1 = 8;
var FRAGMENT_NODE = 11;
var ELEMENT_REGEXP = /^((HTML|SVG)\w*)?Element$/;
var isCustomElement2 = /* @__PURE__ */ __name((val) => {
  const {
    tagName
  } = val;
  return Boolean(typeof tagName === "string" && tagName.includes("-") || typeof val.hasAttribute === "function" && val.hasAttribute("is"));
}, "isCustomElement");
var testNode = /* @__PURE__ */ __name((val) => {
  const constructorName = val.constructor.name;
  const {
    nodeType
  } = val;
  return nodeType === ELEMENT_NODE$1 && (ELEMENT_REGEXP.test(constructorName) || isCustomElement2(val)) || nodeType === TEXT_NODE$1 && constructorName === "Text" || nodeType === COMMENT_NODE$1 && constructorName === "Comment" || nodeType === FRAGMENT_NODE && constructorName === "DocumentFragment";
}, "testNode");
function nodeIsText(node) {
  return node.nodeType === TEXT_NODE$1;
}
__name(nodeIsText, "nodeIsText");
function nodeIsComment(node) {
  return node.nodeType === COMMENT_NODE$1;
}
__name(nodeIsComment, "nodeIsComment");
function nodeIsFragment(node) {
  return node.nodeType === FRAGMENT_NODE;
}
__name(nodeIsFragment, "nodeIsFragment");
function createDOMElementFilter(filterNode) {
  return {
    test: /* @__PURE__ */ __name((val) => {
      var _val$constructor2;
      return ((val == null || (_val$constructor2 = val.constructor) == null ? void 0 : _val$constructor2.name) || isCustomElement2(val)) && testNode(val);
    }, "test"),
    serialize: /* @__PURE__ */ __name((node, config3, indentation, depth, refs, printer) => {
      if (nodeIsText(node)) {
        return printText(node.data, config3);
      }
      if (nodeIsComment(node)) {
        return printComment(node.data, config3);
      }
      const type5 = nodeIsFragment(node) ? "DocumentFragment" : node.tagName.toLowerCase();
      if (++depth > config3.maxDepth) {
        return printElementAsLeaf(type5, config3);
      }
      return printElement(type5, printProps(nodeIsFragment(node) ? [] : Array.from(node.attributes).map((attr) => attr.name).sort(), nodeIsFragment(node) ? {} : Array.from(node.attributes).reduce((props, attribute) => {
        props[attribute.name] = attribute.value;
        return props;
      }, {}), config3, indentation + config3.indent, depth, refs, printer), printChildren(Array.prototype.slice.call(node.childNodes || node.children).filter(filterNode), config3, indentation + config3.indent, depth, refs, printer), config3, indentation);
    }, "serialize")
  };
}
__name(createDOMElementFilter, "createDOMElementFilter");
var picocolors = null;
var readFileSync = null;
var codeFrameColumns = null;
try {
  const nodeRequire = module && module.require;
  readFileSync = nodeRequire.call(module, "fs").readFileSync;
  codeFrameColumns = nodeRequire.call(module, "@babel/code-frame").codeFrameColumns;
  picocolors = nodeRequire.call(module, "picocolors");
} catch {
}
function getCodeFrame(frame) {
  const locationStart = frame.indexOf("(") + 1;
  const locationEnd = frame.indexOf(")");
  const frameLocation = frame.slice(locationStart, locationEnd);
  const frameLocationElements = frameLocation.split(":");
  const [filename, line, column] = [frameLocationElements[0], parseInt(frameLocationElements[1], 10), parseInt(frameLocationElements[2], 10)];
  let rawFileContents = "";
  try {
    rawFileContents = readFileSync(filename, "utf-8");
  } catch {
    return "";
  }
  const codeFrame = codeFrameColumns(rawFileContents, {
    start: {
      line,
      column
    }
  }, {
    highlightCode: true,
    linesBelow: 0
  });
  return picocolors.dim(frameLocation) + "\n" + codeFrame + "\n";
}
__name(getCodeFrame, "getCodeFrame");
function getUserCodeFrame() {
  if (!readFileSync || !codeFrameColumns) {
    return "";
  }
  const err = new Error();
  const firstClientCodeFrame = err.stack.split("\n").slice(1).find((frame) => !frame.includes("node_modules/"));
  return getCodeFrame(firstClientCodeFrame);
}
__name(getUserCodeFrame, "getUserCodeFrame");
var TEXT_NODE = 3;
function jestFakeTimersAreEnabled() {
  if (typeof jest !== "undefined" && jest !== null) {
    return (
      // legacy timers
      setTimeout._isMockFunction === true || // modern timers
      // eslint-disable-next-line prefer-object-has-own -- not supported by our support matrix
      Object.prototype.hasOwnProperty.call(setTimeout, "clock")
    );
  }
  return false;
}
__name(jestFakeTimersAreEnabled, "jestFakeTimersAreEnabled");
function getDocument() {
  if (typeof window === "undefined") {
    throw new Error("Could not find default container");
  }
  return window.document;
}
__name(getDocument, "getDocument");
function getWindowFromNode(node) {
  if (node.defaultView) {
    return node.defaultView;
  } else if (node.ownerDocument && node.ownerDocument.defaultView) {
    return node.ownerDocument.defaultView;
  } else if (node.window) {
    return node.window;
  } else if (node.ownerDocument && node.ownerDocument.defaultView === null) {
    throw new Error("It looks like the window object is not available for the provided node.");
  } else if (node.then instanceof Function) {
    throw new Error("It looks like you passed a Promise object instead of a DOM node. Did you do something like `fireEvent.click(screen.findBy...` when you meant to use a `getBy` query `fireEvent.click(screen.getBy...`, or await the findBy query `fireEvent.click(await screen.findBy...`?");
  } else if (Array.isArray(node)) {
    throw new Error("It looks like you passed an Array instead of a DOM node. Did you do something like `fireEvent.click(screen.getAllBy...` when you meant to use a `getBy` query `fireEvent.click(screen.getBy...`?");
  } else if (typeof node.debug === "function" && typeof node.logTestingPlaygroundURL === "function") {
    throw new Error("It looks like you passed a `screen` object. Did you do something like `fireEvent.click(screen, ...` when you meant to use a query, e.g. `fireEvent.click(screen.getBy..., `?");
  } else {
    throw new Error("The given node is not an Element, the node type is: " + typeof node + ".");
  }
}
__name(getWindowFromNode, "getWindowFromNode");
function checkContainerType(container) {
  if (!container || !(typeof container.querySelector === "function") || !(typeof container.querySelectorAll === "function")) {
    throw new TypeError("Expected container to be an Element, a Document or a DocumentFragment but got " + getTypeName(container) + ".");
  }
  function getTypeName(object) {
    if (typeof object === "object") {
      return object === null ? "null" : object.constructor.name;
    }
    return typeof object;
  }
  __name(getTypeName, "getTypeName");
}
__name(checkContainerType, "checkContainerType");
var shouldHighlight = /* @__PURE__ */ __name(() => {
  if (typeof process === "undefined") {
    return false;
  }
  let colors;
  try {
    var _process$env;
    const colorsJSON = (_process$env = process.env) == null ? void 0 : _process$env.COLORS;
    if (colorsJSON) {
      colors = JSON.parse(colorsJSON);
    }
  } catch {
  }
  if (typeof colors === "boolean") {
    return colors;
  } else {
    return process.versions !== void 0 && process.versions.node !== void 0;
  }
}, "shouldHighlight");
var {
  DOMCollection
} = prettyFormat.plugins;
var ELEMENT_NODE = 1;
var COMMENT_NODE = 8;
function filterCommentsAndDefaultIgnoreTagsTags(value) {
  return value.nodeType !== COMMENT_NODE && (value.nodeType !== ELEMENT_NODE || !value.matches(getConfig().defaultIgnore));
}
__name(filterCommentsAndDefaultIgnoreTagsTags, "filterCommentsAndDefaultIgnoreTagsTags");
function prettyDOM(dom, maxLength, options) {
  if (options === void 0) {
    options = {};
  }
  if (!dom) {
    dom = getDocument().body;
  }
  if (typeof maxLength !== "number") {
    maxLength = typeof process !== "undefined" && typeof process.env !== "undefined" && process.env.DEBUG_PRINT_LIMIT || 7e3;
  }
  if (maxLength === 0) {
    return "";
  }
  if (dom.documentElement) {
    dom = dom.documentElement;
  }
  let domTypeName = typeof dom;
  if (domTypeName === "object") {
    domTypeName = dom.constructor.name;
  } else {
    dom = {};
  }
  if (!("outerHTML" in dom)) {
    throw new TypeError("Expected an element or document but got " + domTypeName);
  }
  const {
    filterNode = filterCommentsAndDefaultIgnoreTagsTags,
    ...prettyFormatOptions
  } = options;
  const debugContent = prettyFormat.format(dom, {
    plugins: [createDOMElementFilter(filterNode), DOMCollection],
    printFunctionName: false,
    highlight: shouldHighlight(),
    ...prettyFormatOptions
  });
  return maxLength !== void 0 && dom.outerHTML.length > maxLength ? debugContent.slice(0, maxLength) + "..." : debugContent;
}
__name(prettyDOM, "prettyDOM");
var logDOM = /* @__PURE__ */ __name(function() {
  const userCodeFrame = getUserCodeFrame();
  if (userCodeFrame) {
    console.log(prettyDOM(...arguments) + "\n\n" + userCodeFrame);
  } else {
    console.log(prettyDOM(...arguments));
  }
}, "logDOM");
var config2 = {
  testIdAttribute: "data-testid",
  asyncUtilTimeout: 1e3,
  // asyncWrapper and advanceTimersWrapper is to support React's async `act` function.
  // forcing react-testing-library to wrap all async functions would've been
  // a total nightmare (consider wrapping every findBy* query and then also
  // updating `within` so those would be wrapped too. Total nightmare).
  // so we have this config option that's really only intended for
  // react-testing-library to use. For that reason, this feature will remain
  // undocumented.
  asyncWrapper: /* @__PURE__ */ __name((cb) => cb(), "asyncWrapper"),
  unstable_advanceTimersWrapper: /* @__PURE__ */ __name((cb) => cb(), "unstable_advanceTimersWrapper"),
  eventWrapper: /* @__PURE__ */ __name((cb) => cb(), "eventWrapper"),
  // default value for the `hidden` option in `ByRole` queries
  defaultHidden: false,
  // default value for the `ignore` option in `ByText` queries
  defaultIgnore: "script, style",
  // showOriginalStackTrace flag to show the full error stack traces for async errors
  showOriginalStackTrace: false,
  // throw errors w/ suggestions for better queries. Opt in so off by default.
  throwSuggestions: false,
  // called when getBy* queries fail. (message, container) => Error
  getElementError(message, container) {
    const prettifiedDOM = prettyDOM(container);
    const error = new Error([message, "Ignored nodes: comments, " + config2.defaultIgnore + "\n" + prettifiedDOM].filter(Boolean).join("\n\n"));
    error.name = "TestingLibraryElementError";
    return error;
  },
  _disableExpensiveErrorDiagnostics: false,
  computedStyleSupportsPseudoElements: false
};
function runWithExpensiveErrorDiagnosticsDisabled(callback) {
  try {
    config2._disableExpensiveErrorDiagnostics = true;
    return callback();
  } finally {
    config2._disableExpensiveErrorDiagnostics = false;
  }
}
__name(runWithExpensiveErrorDiagnosticsDisabled, "runWithExpensiveErrorDiagnosticsDisabled");
function configure(newConfig) {
  if (typeof newConfig === "function") {
    newConfig = newConfig(config2);
  }
  config2 = {
    ...config2,
    ...newConfig
  };
}
__name(configure, "configure");
function getConfig() {
  return config2;
}
__name(getConfig, "getConfig");
var labelledNodeNames = ["button", "meter", "output", "progress", "select", "textarea", "input"];
function getTextContent(node) {
  if (labelledNodeNames.includes(node.nodeName.toLowerCase())) {
    return "";
  }
  if (node.nodeType === TEXT_NODE) return node.textContent;
  return Array.from(node.childNodes).map((childNode) => getTextContent(childNode)).join("");
}
__name(getTextContent, "getTextContent");
function getLabelContent(element) {
  let textContent;
  if (element.tagName.toLowerCase() === "label") {
    textContent = getTextContent(element);
  } else {
    textContent = element.value || element.textContent;
  }
  return textContent;
}
__name(getLabelContent, "getLabelContent");
function getRealLabels(element) {
  if (element.labels !== void 0) {
    var _labels;
    return (_labels = element.labels) != null ? _labels : [];
  }
  if (!isLabelable(element)) return [];
  const labels = element.ownerDocument.querySelectorAll("label");
  return Array.from(labels).filter((label) => label.control === element);
}
__name(getRealLabels, "getRealLabels");
function isLabelable(element) {
  return /BUTTON|METER|OUTPUT|PROGRESS|SELECT|TEXTAREA/.test(element.tagName) || element.tagName === "INPUT" && element.getAttribute("type") !== "hidden";
}
__name(isLabelable, "isLabelable");
function getLabels3(container, element, _temp) {
  let {
    selector = "*"
  } = _temp === void 0 ? {} : _temp;
  const ariaLabelledBy = element.getAttribute("aria-labelledby");
  const labelsId = ariaLabelledBy ? ariaLabelledBy.split(" ") : [];
  return labelsId.length ? labelsId.map((labelId) => {
    const labellingElement = container.querySelector('[id="' + labelId + '"]');
    return labellingElement ? {
      content: getLabelContent(labellingElement),
      formControl: null
    } : {
      content: "",
      formControl: null
    };
  }) : Array.from(getRealLabels(element)).map((label) => {
    const textToMatch = getLabelContent(label);
    const formControlSelector = "button, input, meter, output, progress, select, textarea";
    const labelledFormControl = Array.from(label.querySelectorAll(formControlSelector)).filter((formControlElement) => formControlElement.matches(selector))[0];
    return {
      content: textToMatch,
      formControl: labelledFormControl
    };
  });
}
__name(getLabels3, "getLabels");
function assertNotNullOrUndefined(matcher) {
  if (matcher === null || matcher === void 0) {
    throw new Error(
      // eslint-disable-next-line @typescript-eslint/restrict-template-expressions -- implicitly converting `T` to `string`
      "It looks like " + matcher + " was passed instead of a matcher. Did you do something like getByText(" + matcher + ")?"
    );
  }
}
__name(assertNotNullOrUndefined, "assertNotNullOrUndefined");
function fuzzyMatches(textToMatch, node, matcher, normalizer) {
  if (typeof textToMatch !== "string") {
    return false;
  }
  assertNotNullOrUndefined(matcher);
  const normalizedText = normalizer(textToMatch);
  if (typeof matcher === "string" || typeof matcher === "number") {
    return normalizedText.toLowerCase().includes(matcher.toString().toLowerCase());
  } else if (typeof matcher === "function") {
    return matcher(normalizedText, node);
  } else {
    return matchRegExp(matcher, normalizedText);
  }
}
__name(fuzzyMatches, "fuzzyMatches");
function matches2(textToMatch, node, matcher, normalizer) {
  if (typeof textToMatch !== "string") {
    return false;
  }
  assertNotNullOrUndefined(matcher);
  const normalizedText = normalizer(textToMatch);
  if (matcher instanceof Function) {
    return matcher(normalizedText, node);
  } else if (matcher instanceof RegExp) {
    return matchRegExp(matcher, normalizedText);
  } else {
    return normalizedText === String(matcher);
  }
}
__name(matches2, "matches");
function getDefaultNormalizer(_temp) {
  let {
    trim = true,
    collapseWhitespace = true
  } = _temp === void 0 ? {} : _temp;
  return (text) => {
    let normalizedText = text;
    normalizedText = trim ? normalizedText.trim() : normalizedText;
    normalizedText = collapseWhitespace ? normalizedText.replace(/\s+/g, " ") : normalizedText;
    return normalizedText;
  };
}
__name(getDefaultNormalizer, "getDefaultNormalizer");
function makeNormalizer(_ref) {
  let {
    trim,
    collapseWhitespace,
    normalizer
  } = _ref;
  if (!normalizer) {
    return getDefaultNormalizer({
      trim,
      collapseWhitespace
    });
  }
  if (typeof trim !== "undefined" || typeof collapseWhitespace !== "undefined") {
    throw new Error('trim and collapseWhitespace are not supported with a normalizer. If you want to use the default trim and collapseWhitespace logic in your normalizer, use "getDefaultNormalizer({trim, collapseWhitespace})" and compose that into your normalizer');
  }
  return normalizer;
}
__name(makeNormalizer, "makeNormalizer");
function matchRegExp(matcher, text) {
  const match = matcher.test(text);
  if (matcher.global && matcher.lastIndex !== 0) {
    console.warn("To match all elements we had to reset the lastIndex of the RegExp because the global flag is enabled. We encourage to remove the global flag from the RegExp.");
    matcher.lastIndex = 0;
  }
  return match;
}
__name(matchRegExp, "matchRegExp");
function getNodeText(node) {
  if (node.matches("input[type=submit], input[type=button], input[type=reset]")) {
    return node.value;
  }
  return Array.from(node.childNodes).filter((child) => child.nodeType === TEXT_NODE && Boolean(child.textContent)).map((c2) => c2.textContent).join("");
}
__name(getNodeText, "getNodeText");
var elementRoleList2 = buildElementRoleList2(import_aria_query3.elementRoles);
function isSubtreeInaccessible(element) {
  if (element.hidden === true) {
    return true;
  }
  if (element.getAttribute("aria-hidden") === "true") {
    return true;
  }
  const window2 = element.ownerDocument.defaultView;
  if (window2.getComputedStyle(element).display === "none") {
    return true;
  }
  return false;
}
__name(isSubtreeInaccessible, "isSubtreeInaccessible");
function isInaccessible(element, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    isSubtreeInaccessible: isSubtreeInaccessibleImpl = isSubtreeInaccessible
  } = options;
  const window2 = element.ownerDocument.defaultView;
  if (window2.getComputedStyle(element).visibility === "hidden") {
    return true;
  }
  let currentElement = element;
  while (currentElement) {
    if (isSubtreeInaccessibleImpl(currentElement)) {
      return true;
    }
    currentElement = currentElement.parentElement;
  }
  return false;
}
__name(isInaccessible, "isInaccessible");
function getImplicitAriaRoles2(currentNode) {
  for (const {
    match,
    roles: roles3
  } of elementRoleList2) {
    if (match(currentNode)) {
      return [...roles3];
    }
  }
  return [];
}
__name(getImplicitAriaRoles2, "getImplicitAriaRoles");
function buildElementRoleList2(elementRolesMap) {
  function makeElementSelector(_ref) {
    let {
      name,
      attributes
    } = _ref;
    return "" + name + attributes.map((_ref2) => {
      let {
        name: attributeName,
        value,
        constraints = []
      } = _ref2;
      const shouldNotExist = constraints.indexOf("undefined") !== -1;
      const shouldBeNonEmpty = constraints.indexOf("set") !== -1;
      const hasExplicitValue = typeof value !== "undefined";
      if (hasExplicitValue) {
        return "[" + attributeName + '="' + value + '"]';
      } else if (shouldNotExist) {
        return ":not([" + attributeName + "])";
      } else if (shouldBeNonEmpty) {
        return "[" + attributeName + "]:not([" + attributeName + '=""])';
      }
      return "[" + attributeName + "]";
    }).join("");
  }
  __name(makeElementSelector, "makeElementSelector");
  function getSelectorSpecificity(_ref3) {
    let {
      attributes = []
    } = _ref3;
    return attributes.length;
  }
  __name(getSelectorSpecificity, "getSelectorSpecificity");
  function bySelectorSpecificity(_ref4, _ref5) {
    let {
      specificity: leftSpecificity
    } = _ref4;
    let {
      specificity: rightSpecificity
    } = _ref5;
    return rightSpecificity - leftSpecificity;
  }
  __name(bySelectorSpecificity, "bySelectorSpecificity");
  function match(element) {
    let {
      attributes = []
    } = element;
    const typeTextIndex = attributes.findIndex((attribute) => attribute.value && attribute.name === "type" && attribute.value === "text");
    if (typeTextIndex >= 0) {
      attributes = [...attributes.slice(0, typeTextIndex), ...attributes.slice(typeTextIndex + 1)];
    }
    const selector = makeElementSelector({
      ...element,
      attributes
    });
    return (node) => {
      if (typeTextIndex >= 0 && node.type !== "text") {
        return false;
      }
      return node.matches(selector);
    };
  }
  __name(match, "match");
  let result = [];
  for (const [element, roles3] of elementRolesMap.entries()) {
    result = [...result, {
      match: match(element),
      roles: Array.from(roles3),
      specificity: getSelectorSpecificity(element)
    }];
  }
  return result.sort(bySelectorSpecificity);
}
__name(buildElementRoleList2, "buildElementRoleList");
function getRoles(container, _temp) {
  let {
    hidden = false
  } = _temp === void 0 ? {} : _temp;
  function flattenDOM(node) {
    return [node, ...Array.from(node.children).reduce((acc, child) => [...acc, ...flattenDOM(child)], [])];
  }
  __name(flattenDOM, "flattenDOM");
  return flattenDOM(container).filter((element) => {
    return hidden === false ? isInaccessible(element) === false : true;
  }).reduce((acc, node) => {
    let roles3 = [];
    if (node.hasAttribute("role")) {
      roles3 = node.getAttribute("role").split(" ").slice(0, 1);
    } else {
      roles3 = getImplicitAriaRoles2(node);
    }
    return roles3.reduce((rolesAcc, role) => Array.isArray(rolesAcc[role]) ? {
      ...rolesAcc,
      [role]: [...rolesAcc[role], node]
    } : {
      ...rolesAcc,
      [role]: [node]
    }, acc);
  }, {});
}
__name(getRoles, "getRoles");
function prettyRoles(dom, _ref6) {
  let {
    hidden,
    includeDescription
  } = _ref6;
  const roles3 = getRoles(dom, {
    hidden
  });
  return Object.entries(roles3).filter((_ref7) => {
    let [role] = _ref7;
    return role !== "generic";
  }).map((_ref8) => {
    let [role, elements] = _ref8;
    const delimiterBar = "-".repeat(50);
    const elementsString = elements.map((el) => {
      const nameString = 'Name "' + computeAccessibleName2(el, {
        computedStyleSupportsPseudoElements: getConfig().computedStyleSupportsPseudoElements
      }) + '":\n';
      const domString = prettyDOM(el.cloneNode(false));
      if (includeDescription) {
        const descriptionString = 'Description "' + computeAccessibleDescription2(el, {
          computedStyleSupportsPseudoElements: getConfig().computedStyleSupportsPseudoElements
        }) + '":\n';
        return "" + nameString + descriptionString + domString;
      }
      return "" + nameString + domString;
    }).join("\n\n");
    return role + ":\n\n" + elementsString + "\n\n" + delimiterBar;
  }).join("\n");
}
__name(prettyRoles, "prettyRoles");
var logRoles = /* @__PURE__ */ __name(function(dom, _temp2) {
  let {
    hidden = false
  } = _temp2 === void 0 ? {} : _temp2;
  return console.log(prettyRoles(dom, {
    hidden
  }));
}, "logRoles");
function computeAriaSelected(element) {
  if (element.tagName === "OPTION") {
    return element.selected;
  }
  return checkBooleanAttribute(element, "aria-selected");
}
__name(computeAriaSelected, "computeAriaSelected");
function computeAriaBusy(element) {
  return element.getAttribute("aria-busy") === "true";
}
__name(computeAriaBusy, "computeAriaBusy");
function computeAriaChecked(element) {
  if ("indeterminate" in element && element.indeterminate) {
    return void 0;
  }
  if ("checked" in element) {
    return element.checked;
  }
  return checkBooleanAttribute(element, "aria-checked");
}
__name(computeAriaChecked, "computeAriaChecked");
function computeAriaPressed(element) {
  return checkBooleanAttribute(element, "aria-pressed");
}
__name(computeAriaPressed, "computeAriaPressed");
function computeAriaCurrent(element) {
  var _ref9, _checkBooleanAttribut;
  return (_ref9 = (_checkBooleanAttribut = checkBooleanAttribute(element, "aria-current")) != null ? _checkBooleanAttribut : element.getAttribute("aria-current")) != null ? _ref9 : false;
}
__name(computeAriaCurrent, "computeAriaCurrent");
function computeAriaExpanded(element) {
  return checkBooleanAttribute(element, "aria-expanded");
}
__name(computeAriaExpanded, "computeAriaExpanded");
function checkBooleanAttribute(element, attribute) {
  const attributeValue = element.getAttribute(attribute);
  if (attributeValue === "true") {
    return true;
  }
  if (attributeValue === "false") {
    return false;
  }
  return void 0;
}
__name(checkBooleanAttribute, "checkBooleanAttribute");
function computeHeadingLevel(element) {
  const implicitHeadingLevels = {
    H1: 1,
    H2: 2,
    H3: 3,
    H4: 4,
    H5: 5,
    H6: 6
  };
  const ariaLevelAttribute = element.getAttribute("aria-level") && Number(element.getAttribute("aria-level"));
  return ariaLevelAttribute || implicitHeadingLevels[element.tagName];
}
__name(computeHeadingLevel, "computeHeadingLevel");
function computeAriaValueNow(element) {
  const valueNow = element.getAttribute("aria-valuenow");
  return valueNow === null ? void 0 : +valueNow;
}
__name(computeAriaValueNow, "computeAriaValueNow");
function computeAriaValueMax(element) {
  const valueMax = element.getAttribute("aria-valuemax");
  return valueMax === null ? void 0 : +valueMax;
}
__name(computeAriaValueMax, "computeAriaValueMax");
function computeAriaValueMin(element) {
  const valueMin = element.getAttribute("aria-valuemin");
  return valueMin === null ? void 0 : +valueMin;
}
__name(computeAriaValueMin, "computeAriaValueMin");
function computeAriaValueText(element) {
  const valueText = element.getAttribute("aria-valuetext");
  return valueText === null ? void 0 : valueText;
}
__name(computeAriaValueText, "computeAriaValueText");
var normalize2 = getDefaultNormalizer();
function escapeRegExp(string) {
  return string.replace(/[.*+\-?^${}()|[\]\\]/g, "\\$&");
}
__name(escapeRegExp, "escapeRegExp");
function getRegExpMatcher(string) {
  return new RegExp(escapeRegExp(string.toLowerCase()), "i");
}
__name(getRegExpMatcher, "getRegExpMatcher");
function makeSuggestion(queryName, element, content, _ref) {
  let {
    variant,
    name
  } = _ref;
  let warning = "";
  const queryOptions = {};
  const queryArgs = [["Role", "TestId"].includes(queryName) ? content : getRegExpMatcher(content)];
  if (name) {
    queryOptions.name = getRegExpMatcher(name);
  }
  if (queryName === "Role" && isInaccessible(element)) {
    queryOptions.hidden = true;
    warning = "Element is inaccessible. This means that the element and all its children are invisible to screen readers.\n    If you are using the aria-hidden prop, make sure this is the right choice for your case.\n    ";
  }
  if (Object.keys(queryOptions).length > 0) {
    queryArgs.push(queryOptions);
  }
  const queryMethod = variant + "By" + queryName;
  return {
    queryName,
    queryMethod,
    queryArgs,
    variant,
    warning,
    toString() {
      if (warning) {
        console.warn(warning);
      }
      let [text, options] = queryArgs;
      text = typeof text === "string" ? "'" + text + "'" : text;
      options = options ? ", { " + Object.entries(options).map((_ref2) => {
        let [k2, v2] = _ref2;
        return k2 + ": " + v2;
      }).join(", ") + " }" : "";
      return queryMethod + "(" + text + options + ")";
    }
  };
}
__name(makeSuggestion, "makeSuggestion");
function canSuggest(currentMethod, requestedMethod, data) {
  return data && (!requestedMethod || requestedMethod.toLowerCase() === currentMethod.toLowerCase());
}
__name(canSuggest, "canSuggest");
function getSuggestedQuery(element, variant, method) {
  var _element$getAttribute, _getImplicitAriaRoles;
  if (variant === void 0) {
    variant = "get";
  }
  if (element.matches(getConfig().defaultIgnore)) {
    return void 0;
  }
  const role = (_element$getAttribute = element.getAttribute("role")) != null ? _element$getAttribute : (_getImplicitAriaRoles = getImplicitAriaRoles2(element)) == null ? void 0 : _getImplicitAriaRoles[0];
  if (role !== "generic" && canSuggest("Role", method, role)) {
    return makeSuggestion("Role", element, role, {
      variant,
      name: computeAccessibleName2(element, {
        computedStyleSupportsPseudoElements: getConfig().computedStyleSupportsPseudoElements
      })
    });
  }
  const labelText = getLabels3(document, element).map((label) => label.content).join(" ");
  if (canSuggest("LabelText", method, labelText)) {
    return makeSuggestion("LabelText", element, labelText, {
      variant
    });
  }
  const placeholderText = element.getAttribute("placeholder");
  if (canSuggest("PlaceholderText", method, placeholderText)) {
    return makeSuggestion("PlaceholderText", element, placeholderText, {
      variant
    });
  }
  const textContent = normalize2(getNodeText(element));
  if (canSuggest("Text", method, textContent)) {
    return makeSuggestion("Text", element, textContent, {
      variant
    });
  }
  if (canSuggest("DisplayValue", method, element.value)) {
    return makeSuggestion("DisplayValue", element, normalize2(element.value), {
      variant
    });
  }
  const alt = element.getAttribute("alt");
  if (canSuggest("AltText", method, alt)) {
    return makeSuggestion("AltText", element, alt, {
      variant
    });
  }
  const title = element.getAttribute("title");
  if (canSuggest("Title", method, title)) {
    return makeSuggestion("Title", element, title, {
      variant
    });
  }
  const testId = element.getAttribute(getConfig().testIdAttribute);
  if (canSuggest("TestId", method, testId)) {
    return makeSuggestion("TestId", element, testId, {
      variant
    });
  }
  return void 0;
}
__name(getSuggestedQuery, "getSuggestedQuery");
function copyStackTrace(target, source) {
  target.stack = source.stack.replace(source.message, target.message);
}
__name(copyStackTrace, "copyStackTrace");
function waitFor(callback, _ref) {
  let {
    container = getDocument(),
    timeout = getConfig().asyncUtilTimeout,
    showOriginalStackTrace = getConfig().showOriginalStackTrace,
    stackTraceError,
    interval = 50,
    onTimeout = /* @__PURE__ */ __name((error) => {
      Object.defineProperty(error, "message", {
        value: getConfig().getElementError(error.message, container).message
      });
      return error;
    }, "onTimeout"),
    mutationObserverOptions = {
      subtree: true,
      childList: true,
      attributes: true,
      characterData: true
    }
  } = _ref;
  if (typeof callback !== "function") {
    throw new TypeError("Received `callback` arg must be a function");
  }
  return new Promise(async (resolve, reject) => {
    let lastError, intervalId, observer;
    let finished = false;
    let promiseStatus = "idle";
    const overallTimeoutTimer = setTimeout(handleTimeout, timeout);
    const usingJestFakeTimers = jestFakeTimersAreEnabled();
    if (usingJestFakeTimers) {
      const {
        unstable_advanceTimersWrapper: advanceTimersWrapper
      } = getConfig();
      checkCallback();
      while (!finished) {
        if (!jestFakeTimersAreEnabled()) {
          const error = new Error("Changed from using fake timers to real timers while using waitFor. This is not allowed and will result in very strange behavior. Please ensure you're awaiting all async things your test is doing before changing to real timers. For more info, please go to https://github.com/testing-library/dom-testing-library/issues/830");
          if (!showOriginalStackTrace) copyStackTrace(error, stackTraceError);
          reject(error);
          return;
        }
        await advanceTimersWrapper(async () => {
          jest.advanceTimersByTime(interval);
        });
        if (finished) {
          break;
        }
        checkCallback();
      }
    } else {
      try {
        checkContainerType(container);
      } catch (e2) {
        reject(e2);
        return;
      }
      intervalId = setInterval(checkRealTimersCallback, interval);
      const {
        MutationObserver
      } = getWindowFromNode(container);
      observer = new MutationObserver(checkRealTimersCallback);
      observer.observe(container, mutationObserverOptions);
      checkCallback();
    }
    function onDone(error, result) {
      finished = true;
      clearTimeout(overallTimeoutTimer);
      if (!usingJestFakeTimers) {
        clearInterval(intervalId);
        observer.disconnect();
      }
      if (error) {
        reject(error);
      } else {
        resolve(result);
      }
    }
    __name(onDone, "onDone");
    function checkRealTimersCallback() {
      if (jestFakeTimersAreEnabled()) {
        const error = new Error("Changed from using real timers to fake timers while using waitFor. This is not allowed and will result in very strange behavior. Please ensure you're awaiting all async things your test is doing before changing to fake timers. For more info, please go to https://github.com/testing-library/dom-testing-library/issues/830");
        if (!showOriginalStackTrace) copyStackTrace(error, stackTraceError);
        return reject(error);
      } else {
        return checkCallback();
      }
    }
    __name(checkRealTimersCallback, "checkRealTimersCallback");
    function checkCallback() {
      if (promiseStatus === "pending") return;
      try {
        const result = runWithExpensiveErrorDiagnosticsDisabled(callback);
        if (typeof (result == null ? void 0 : result.then) === "function") {
          promiseStatus = "pending";
          result.then((resolvedValue) => {
            promiseStatus = "resolved";
            onDone(null, resolvedValue);
          }, (rejectedValue) => {
            promiseStatus = "rejected";
            lastError = rejectedValue;
          });
        } else {
          onDone(null, result);
        }
      } catch (error) {
        lastError = error;
      }
    }
    __name(checkCallback, "checkCallback");
    function handleTimeout() {
      let error;
      if (lastError) {
        error = lastError;
        if (!showOriginalStackTrace && error.name === "TestingLibraryElementError") {
          copyStackTrace(error, stackTraceError);
        }
      } else {
        error = new Error("Timed out in waitFor.");
        if (!showOriginalStackTrace) {
          copyStackTrace(error, stackTraceError);
        }
      }
      onDone(onTimeout(error), null);
    }
    __name(handleTimeout, "handleTimeout");
  });
}
__name(waitFor, "waitFor");
function waitForWrapper(callback, options) {
  const stackTraceError = new Error("STACK_TRACE_MESSAGE");
  return getConfig().asyncWrapper(() => waitFor(callback, {
    stackTraceError,
    ...options
  }));
}
__name(waitForWrapper, "waitForWrapper");
function getElementError(message, container) {
  return getConfig().getElementError(message, container);
}
__name(getElementError, "getElementError");
function getMultipleElementsFoundError(message, container) {
  return getElementError(message + "\n\n(If this is intentional, then use the `*AllBy*` variant of the query (like `queryAllByText`, `getAllByText`, or `findAllByText`)).", container);
}
__name(getMultipleElementsFoundError, "getMultipleElementsFoundError");
function queryAllByAttribute(attribute, container, text, _temp) {
  let {
    exact = true,
    collapseWhitespace,
    trim,
    normalizer
  } = _temp === void 0 ? {} : _temp;
  const matcher = exact ? matches2 : fuzzyMatches;
  const matchNormalizer = makeNormalizer({
    collapseWhitespace,
    trim,
    normalizer
  });
  return Array.from(container.querySelectorAll("[" + attribute + "]")).filter((node) => matcher(node.getAttribute(attribute), node, text, matchNormalizer));
}
__name(queryAllByAttribute, "queryAllByAttribute");
function queryByAttribute(attribute, container, text, options) {
  const els = queryAllByAttribute(attribute, container, text, options);
  if (els.length > 1) {
    throw getMultipleElementsFoundError("Found multiple elements by [" + attribute + "=" + text + "]", container);
  }
  return els[0] || null;
}
__name(queryByAttribute, "queryByAttribute");
function makeSingleQuery(allQuery, getMultipleError2) {
  return function(container) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    const els = allQuery(container, ...args);
    if (els.length > 1) {
      const elementStrings = els.map((element) => getElementError(null, element).message).join("\n\n");
      throw getMultipleElementsFoundError(getMultipleError2(container, ...args) + "\n\nHere are the matching elements:\n\n" + elementStrings, container);
    }
    return els[0] || null;
  };
}
__name(makeSingleQuery, "makeSingleQuery");
function getSuggestionError(suggestion, container) {
  return getConfig().getElementError("A better query is available, try this:\n" + suggestion.toString() + "\n", container);
}
__name(getSuggestionError, "getSuggestionError");
function makeGetAllQuery(allQuery, getMissingError2) {
  return function(container) {
    for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
      args[_key2 - 1] = arguments[_key2];
    }
    const els = allQuery(container, ...args);
    if (!els.length) {
      throw getConfig().getElementError(getMissingError2(container, ...args), container);
    }
    return els;
  };
}
__name(makeGetAllQuery, "makeGetAllQuery");
function makeFindQuery(getter) {
  return (container, text, options, waitForOptions) => {
    return waitForWrapper(() => {
      return getter(container, text, options);
    }, {
      container,
      ...waitForOptions
    });
  };
}
__name(makeFindQuery, "makeFindQuery");
var wrapSingleQueryWithSuggestion = /* @__PURE__ */ __name((query, queryAllByName, variant) => function(container) {
  for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    args[_key3 - 1] = arguments[_key3];
  }
  const element = query(container, ...args);
  const [{
    suggest = getConfig().throwSuggestions
  } = {}] = args.slice(-1);
  if (element && suggest) {
    const suggestion = getSuggestedQuery(element, variant);
    if (suggestion && !queryAllByName.endsWith(suggestion.queryName)) {
      throw getSuggestionError(suggestion.toString(), container);
    }
  }
  return element;
}, "wrapSingleQueryWithSuggestion");
var wrapAllByQueryWithSuggestion = /* @__PURE__ */ __name((query, queryAllByName, variant) => function(container) {
  for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    args[_key4 - 1] = arguments[_key4];
  }
  const els = query(container, ...args);
  const [{
    suggest = getConfig().throwSuggestions
  } = {}] = args.slice(-1);
  if (els.length && suggest) {
    const uniqueSuggestionMessages = [...new Set(els.map((element) => {
      var _getSuggestedQuery;
      return (_getSuggestedQuery = getSuggestedQuery(element, variant)) == null ? void 0 : _getSuggestedQuery.toString();
    }))];
    if (
      // only want to suggest if all the els have the same suggestion.
      uniqueSuggestionMessages.length === 1 && !queryAllByName.endsWith(
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion -- TODO: Can this be null at runtime?
        getSuggestedQuery(els[0], variant).queryName
      )
    ) {
      throw getSuggestionError(uniqueSuggestionMessages[0], container);
    }
  }
  return els;
}, "wrapAllByQueryWithSuggestion");
function buildQueries(queryAllBy, getMultipleError2, getMissingError2) {
  const queryBy = wrapSingleQueryWithSuggestion(makeSingleQuery(queryAllBy, getMultipleError2), queryAllBy.name, "query");
  const getAllBy = makeGetAllQuery(queryAllBy, getMissingError2);
  const getBy = makeSingleQuery(getAllBy, getMultipleError2);
  const getByWithSuggestions = wrapSingleQueryWithSuggestion(getBy, queryAllBy.name, "get");
  const getAllWithSuggestions = wrapAllByQueryWithSuggestion(getAllBy, queryAllBy.name.replace("query", "get"), "getAll");
  const findAllBy = makeFindQuery(wrapAllByQueryWithSuggestion(getAllBy, queryAllBy.name, "findAll"));
  const findBy = makeFindQuery(wrapSingleQueryWithSuggestion(getBy, queryAllBy.name, "find"));
  return [queryBy, getAllWithSuggestions, getByWithSuggestions, findAllBy, findBy];
}
__name(buildQueries, "buildQueries");
var queryHelpers = Object.freeze({
  __proto__: null,
  getElementError,
  wrapAllByQueryWithSuggestion,
  wrapSingleQueryWithSuggestion,
  getMultipleElementsFoundError,
  queryAllByAttribute,
  queryByAttribute,
  makeSingleQuery,
  makeGetAllQuery,
  makeFindQuery,
  buildQueries
});
function queryAllLabels(container) {
  return Array.from(container.querySelectorAll("label,input")).map((node) => {
    return {
      node,
      textToMatch: getLabelContent(node)
    };
  }).filter((_ref) => {
    let {
      textToMatch
    } = _ref;
    return textToMatch !== null;
  });
}
__name(queryAllLabels, "queryAllLabels");
var queryAllLabelsByText = /* @__PURE__ */ __name(function(container, text, _temp) {
  let {
    exact = true,
    trim,
    collapseWhitespace,
    normalizer
  } = _temp === void 0 ? {} : _temp;
  const matcher = exact ? matches2 : fuzzyMatches;
  const matchNormalizer = makeNormalizer({
    collapseWhitespace,
    trim,
    normalizer
  });
  const textToMatchByLabels = queryAllLabels(container);
  return textToMatchByLabels.filter((_ref2) => {
    let {
      node,
      textToMatch
    } = _ref2;
    return matcher(textToMatch, node, text, matchNormalizer);
  }).map((_ref3) => {
    let {
      node
    } = _ref3;
    return node;
  });
}, "queryAllLabelsByText");
var queryAllByLabelText = /* @__PURE__ */ __name(function(container, text, _temp2) {
  let {
    selector = "*",
    exact = true,
    collapseWhitespace,
    trim,
    normalizer
  } = _temp2 === void 0 ? {} : _temp2;
  checkContainerType(container);
  const matcher = exact ? matches2 : fuzzyMatches;
  const matchNormalizer = makeNormalizer({
    collapseWhitespace,
    trim,
    normalizer
  });
  const matchingLabelledElements = Array.from(container.querySelectorAll("*")).filter((element) => {
    return getRealLabels(element).length || element.hasAttribute("aria-labelledby");
  }).reduce((labelledElements, labelledElement) => {
    const labelList = getLabels3(container, labelledElement, {
      selector
    });
    labelList.filter((label) => Boolean(label.formControl)).forEach((label) => {
      if (matcher(label.content, label.formControl, text, matchNormalizer) && label.formControl) {
        labelledElements.push(label.formControl);
      }
    });
    const labelsValue = labelList.filter((label) => Boolean(label.content)).map((label) => label.content);
    if (matcher(labelsValue.join(" "), labelledElement, text, matchNormalizer)) {
      labelledElements.push(labelledElement);
    }
    if (labelsValue.length > 1) {
      labelsValue.forEach((labelValue, index) => {
        if (matcher(labelValue, labelledElement, text, matchNormalizer)) {
          labelledElements.push(labelledElement);
        }
        const labelsFiltered = [...labelsValue];
        labelsFiltered.splice(index, 1);
        if (labelsFiltered.length > 1) {
          if (matcher(labelsFiltered.join(" "), labelledElement, text, matchNormalizer)) {
            labelledElements.push(labelledElement);
          }
        }
      });
    }
    return labelledElements;
  }, []).concat(queryAllByAttribute("aria-label", container, text, {
    exact,
    normalizer: matchNormalizer
  }));
  return Array.from(new Set(matchingLabelledElements)).filter((element) => element.matches(selector));
}, "queryAllByLabelText");
var getAllByLabelText = /* @__PURE__ */ __name(function(container, text) {
  for (var _len = arguments.length, rest = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    rest[_key - 2] = arguments[_key];
  }
  const els = queryAllByLabelText(container, text, ...rest);
  if (!els.length) {
    const labels = queryAllLabelsByText(container, text, ...rest);
    if (labels.length) {
      const tagNames = labels.map((label) => getTagNameOfElementAssociatedWithLabelViaFor(container, label)).filter((tagName) => !!tagName);
      if (tagNames.length) {
        throw getConfig().getElementError(tagNames.map((tagName) => "Found a label with the text of: " + text + ", however the element associated with this label (<" + tagName + " />) is non-labellable [https://html.spec.whatwg.org/multipage/forms.html#category-label]. If you really need to label a <" + tagName + " />, you can use aria-label or aria-labelledby instead.").join("\n\n"), container);
      } else {
        throw getConfig().getElementError("Found a label with the text of: " + text + `, however no form control was found associated to that label. Make sure you're using the "for" attribute or "aria-labelledby" attribute correctly.`, container);
      }
    } else {
      throw getConfig().getElementError("Unable to find a label with the text of: " + text, container);
    }
  }
  return els;
}, "getAllByLabelText");
function getTagNameOfElementAssociatedWithLabelViaFor(container, label) {
  const htmlFor = label.getAttribute("for");
  if (!htmlFor) {
    return null;
  }
  const element = container.querySelector('[id="' + htmlFor + '"]');
  return element ? element.tagName.toLowerCase() : null;
}
__name(getTagNameOfElementAssociatedWithLabelViaFor, "getTagNameOfElementAssociatedWithLabelViaFor");
var getMultipleError$7 = /* @__PURE__ */ __name((c2, text) => "Found multiple elements with the text of: " + text, "getMultipleError$7");
var queryByLabelText = wrapSingleQueryWithSuggestion(makeSingleQuery(queryAllByLabelText, getMultipleError$7), queryAllByLabelText.name, "query");
var getByLabelText = makeSingleQuery(getAllByLabelText, getMultipleError$7);
var findAllByLabelText = makeFindQuery(wrapAllByQueryWithSuggestion(getAllByLabelText, getAllByLabelText.name, "findAll"));
var findByLabelText = makeFindQuery(wrapSingleQueryWithSuggestion(getByLabelText, getAllByLabelText.name, "find"));
var getAllByLabelTextWithSuggestions = wrapAllByQueryWithSuggestion(getAllByLabelText, getAllByLabelText.name, "getAll");
var getByLabelTextWithSuggestions = wrapSingleQueryWithSuggestion(getByLabelText, getAllByLabelText.name, "get");
var queryAllByLabelTextWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByLabelText, queryAllByLabelText.name, "queryAll");
var queryAllByPlaceholderText = /* @__PURE__ */ __name(function() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  checkContainerType(args[0]);
  return queryAllByAttribute("placeholder", ...args);
}, "queryAllByPlaceholderText");
var getMultipleError$6 = /* @__PURE__ */ __name((c2, text) => "Found multiple elements with the placeholder text of: " + text, "getMultipleError$6");
var getMissingError$6 = /* @__PURE__ */ __name((c2, text) => "Unable to find an element with the placeholder text of: " + text, "getMissingError$6");
var queryAllByPlaceholderTextWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByPlaceholderText, queryAllByPlaceholderText.name, "queryAll");
var [queryByPlaceholderText, getAllByPlaceholderText, getByPlaceholderText, findAllByPlaceholderText, findByPlaceholderText] = buildQueries(queryAllByPlaceholderText, getMultipleError$6, getMissingError$6);
var queryAllByText = /* @__PURE__ */ __name(function(container, text, _temp) {
  let {
    selector = "*",
    exact = true,
    collapseWhitespace,
    trim,
    ignore = getConfig().defaultIgnore,
    normalizer
  } = _temp === void 0 ? {} : _temp;
  checkContainerType(container);
  const matcher = exact ? matches2 : fuzzyMatches;
  const matchNormalizer = makeNormalizer({
    collapseWhitespace,
    trim,
    normalizer
  });
  let baseArray = [];
  if (typeof container.matches === "function" && container.matches(selector)) {
    baseArray = [container];
  }
  return [...baseArray, ...Array.from(container.querySelectorAll(selector))].filter((node) => !ignore || !node.matches(ignore)).filter((node) => matcher(getNodeText(node), node, text, matchNormalizer));
}, "queryAllByText");
var getMultipleError$5 = /* @__PURE__ */ __name((c2, text) => "Found multiple elements with the text: " + text, "getMultipleError$5");
var getMissingError$5 = /* @__PURE__ */ __name(function(c2, text, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    collapseWhitespace,
    trim,
    normalizer,
    selector
  } = options;
  const matchNormalizer = makeNormalizer({
    collapseWhitespace,
    trim,
    normalizer
  });
  const normalizedText = matchNormalizer(text.toString());
  const isNormalizedDifferent = normalizedText !== text.toString();
  const isCustomSelector = (selector != null ? selector : "*") !== "*";
  return "Unable to find an element with the text: " + (isNormalizedDifferent ? normalizedText + " (normalized from '" + text + "')" : text) + (isCustomSelector ? ", which matches selector '" + selector + "'" : "") + ". This could be because the text is broken up by multiple elements. In this case, you can provide a function for your text matcher to make your matcher more flexible.";
}, "getMissingError$5");
var queryAllByTextWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByText, queryAllByText.name, "queryAll");
var [queryByText, getAllByText, getByText, findAllByText, findByText] = buildQueries(queryAllByText, getMultipleError$5, getMissingError$5);
var queryAllByDisplayValue = /* @__PURE__ */ __name(function(container, value, _temp) {
  let {
    exact = true,
    collapseWhitespace,
    trim,
    normalizer
  } = _temp === void 0 ? {} : _temp;
  checkContainerType(container);
  const matcher = exact ? matches2 : fuzzyMatches;
  const matchNormalizer = makeNormalizer({
    collapseWhitespace,
    trim,
    normalizer
  });
  return Array.from(container.querySelectorAll("input,textarea,select")).filter((node) => {
    if (node.tagName === "SELECT") {
      const selectedOptions = Array.from(node.options).filter((option) => option.selected);
      return selectedOptions.some((optionNode) => matcher(getNodeText(optionNode), optionNode, value, matchNormalizer));
    } else {
      return matcher(node.value, node, value, matchNormalizer);
    }
  });
}, "queryAllByDisplayValue");
var getMultipleError$4 = /* @__PURE__ */ __name((c2, value) => "Found multiple elements with the display value: " + value + ".", "getMultipleError$4");
var getMissingError$4 = /* @__PURE__ */ __name((c2, value) => "Unable to find an element with the display value: " + value + ".", "getMissingError$4");
var queryAllByDisplayValueWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByDisplayValue, queryAllByDisplayValue.name, "queryAll");
var [queryByDisplayValue, getAllByDisplayValue, getByDisplayValue, findAllByDisplayValue, findByDisplayValue] = buildQueries(queryAllByDisplayValue, getMultipleError$4, getMissingError$4);
var VALID_TAG_REGEXP = /^(img|input|area|.+-.+)$/i;
var queryAllByAltText = /* @__PURE__ */ __name(function(container, alt, options) {
  if (options === void 0) {
    options = {};
  }
  checkContainerType(container);
  return queryAllByAttribute("alt", container, alt, options).filter((node) => VALID_TAG_REGEXP.test(node.tagName));
}, "queryAllByAltText");
var getMultipleError$3 = /* @__PURE__ */ __name((c2, alt) => "Found multiple elements with the alt text: " + alt, "getMultipleError$3");
var getMissingError$3 = /* @__PURE__ */ __name((c2, alt) => "Unable to find an element with the alt text: " + alt, "getMissingError$3");
var queryAllByAltTextWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByAltText, queryAllByAltText.name, "queryAll");
var [queryByAltText, getAllByAltText, getByAltText, findAllByAltText, findByAltText] = buildQueries(queryAllByAltText, getMultipleError$3, getMissingError$3);
var isSvgTitle = /* @__PURE__ */ __name((node) => {
  var _node$parentElement;
  return node.tagName.toLowerCase() === "title" && ((_node$parentElement = node.parentElement) == null ? void 0 : _node$parentElement.tagName.toLowerCase()) === "svg";
}, "isSvgTitle");
var queryAllByTitle = /* @__PURE__ */ __name(function(container, text, _temp) {
  let {
    exact = true,
    collapseWhitespace,
    trim,
    normalizer
  } = _temp === void 0 ? {} : _temp;
  checkContainerType(container);
  const matcher = exact ? matches2 : fuzzyMatches;
  const matchNormalizer = makeNormalizer({
    collapseWhitespace,
    trim,
    normalizer
  });
  return Array.from(container.querySelectorAll("[title], svg > title")).filter((node) => matcher(node.getAttribute("title"), node, text, matchNormalizer) || isSvgTitle(node) && matcher(getNodeText(node), node, text, matchNormalizer));
}, "queryAllByTitle");
var getMultipleError$2 = /* @__PURE__ */ __name((c2, title) => "Found multiple elements with the title: " + title + ".", "getMultipleError$2");
var getMissingError$2 = /* @__PURE__ */ __name((c2, title) => "Unable to find an element with the title: " + title + ".", "getMissingError$2");
var queryAllByTitleWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByTitle, queryAllByTitle.name, "queryAll");
var [queryByTitle, getAllByTitle, getByTitle, findAllByTitle, findByTitle] = buildQueries(queryAllByTitle, getMultipleError$2, getMissingError$2);
var queryAllByRole = /* @__PURE__ */ __name(function(container, role, _temp) {
  let {
    hidden = getConfig().defaultHidden,
    name,
    description,
    queryFallbacks = false,
    selected,
    busy,
    checked,
    pressed,
    current,
    level,
    expanded,
    value: {
      now: valueNow,
      min: valueMin,
      max: valueMax,
      text: valueText
    } = {}
  } = _temp === void 0 ? {} : _temp;
  checkContainerType(container);
  if (selected !== void 0) {
    var _allRoles$get;
    if (((_allRoles$get = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get.props["aria-selected"]) === void 0) {
      throw new Error('"aria-selected" is not supported on role "' + role + '".');
    }
  }
  if (busy !== void 0) {
    var _allRoles$get2;
    if (((_allRoles$get2 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get2.props["aria-busy"]) === void 0) {
      throw new Error('"aria-busy" is not supported on role "' + role + '".');
    }
  }
  if (checked !== void 0) {
    var _allRoles$get3;
    if (((_allRoles$get3 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get3.props["aria-checked"]) === void 0) {
      throw new Error('"aria-checked" is not supported on role "' + role + '".');
    }
  }
  if (pressed !== void 0) {
    var _allRoles$get4;
    if (((_allRoles$get4 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get4.props["aria-pressed"]) === void 0) {
      throw new Error('"aria-pressed" is not supported on role "' + role + '".');
    }
  }
  if (current !== void 0) {
    var _allRoles$get5;
    if (((_allRoles$get5 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get5.props["aria-current"]) === void 0) {
      throw new Error('"aria-current" is not supported on role "' + role + '".');
    }
  }
  if (level !== void 0) {
    if (role !== "heading") {
      throw new Error('Role "' + role + '" cannot have "level" property.');
    }
  }
  if (valueNow !== void 0) {
    var _allRoles$get6;
    if (((_allRoles$get6 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get6.props["aria-valuenow"]) === void 0) {
      throw new Error('"aria-valuenow" is not supported on role "' + role + '".');
    }
  }
  if (valueMax !== void 0) {
    var _allRoles$get7;
    if (((_allRoles$get7 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get7.props["aria-valuemax"]) === void 0) {
      throw new Error('"aria-valuemax" is not supported on role "' + role + '".');
    }
  }
  if (valueMin !== void 0) {
    var _allRoles$get8;
    if (((_allRoles$get8 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get8.props["aria-valuemin"]) === void 0) {
      throw new Error('"aria-valuemin" is not supported on role "' + role + '".');
    }
  }
  if (valueText !== void 0) {
    var _allRoles$get9;
    if (((_allRoles$get9 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get9.props["aria-valuetext"]) === void 0) {
      throw new Error('"aria-valuetext" is not supported on role "' + role + '".');
    }
  }
  if (expanded !== void 0) {
    var _allRoles$get0;
    if (((_allRoles$get0 = import_aria_query3.roles.get(role)) == null ? void 0 : _allRoles$get0.props["aria-expanded"]) === void 0) {
      throw new Error('"aria-expanded" is not supported on role "' + role + '".');
    }
  }
  const subtreeIsInaccessibleCache = /* @__PURE__ */ new WeakMap();
  function cachedIsSubtreeInaccessible(element) {
    if (!subtreeIsInaccessibleCache.has(element)) {
      subtreeIsInaccessibleCache.set(element, isSubtreeInaccessible(element));
    }
    return subtreeIsInaccessibleCache.get(element);
  }
  __name(cachedIsSubtreeInaccessible, "cachedIsSubtreeInaccessible");
  return Array.from(container.querySelectorAll(
    // Only query elements that can be matched by the following filters
    makeRoleSelector(role)
  )).filter((node) => {
    const isRoleSpecifiedExplicitly = node.hasAttribute("role");
    if (isRoleSpecifiedExplicitly) {
      const roleValue = node.getAttribute("role");
      if (queryFallbacks) {
        return roleValue.split(" ").filter(Boolean).some((roleAttributeToken) => roleAttributeToken === role);
      }
      const [firstRoleAttributeToken] = roleValue.split(" ");
      return firstRoleAttributeToken === role;
    }
    const implicitRoles = getImplicitAriaRoles2(node);
    return implicitRoles.some((implicitRole) => {
      return implicitRole === role;
    });
  }).filter((element) => {
    if (selected !== void 0) {
      return selected === computeAriaSelected(element);
    }
    if (busy !== void 0) {
      return busy === computeAriaBusy(element);
    }
    if (checked !== void 0) {
      return checked === computeAriaChecked(element);
    }
    if (pressed !== void 0) {
      return pressed === computeAriaPressed(element);
    }
    if (current !== void 0) {
      return current === computeAriaCurrent(element);
    }
    if (expanded !== void 0) {
      return expanded === computeAriaExpanded(element);
    }
    if (level !== void 0) {
      return level === computeHeadingLevel(element);
    }
    if (valueNow !== void 0 || valueMax !== void 0 || valueMin !== void 0 || valueText !== void 0) {
      let valueMatches = true;
      if (valueNow !== void 0) {
        valueMatches && (valueMatches = valueNow === computeAriaValueNow(element));
      }
      if (valueMax !== void 0) {
        valueMatches && (valueMatches = valueMax === computeAriaValueMax(element));
      }
      if (valueMin !== void 0) {
        valueMatches && (valueMatches = valueMin === computeAriaValueMin(element));
      }
      if (valueText !== void 0) {
        var _computeAriaValueText;
        valueMatches && (valueMatches = matches2((_computeAriaValueText = computeAriaValueText(element)) != null ? _computeAriaValueText : null, element, valueText, (text) => text));
      }
      return valueMatches;
    }
    return true;
  }).filter((element) => {
    if (name === void 0) {
      return true;
    }
    return matches2(computeAccessibleName2(element, {
      computedStyleSupportsPseudoElements: getConfig().computedStyleSupportsPseudoElements
    }), element, name, (text) => text);
  }).filter((element) => {
    if (description === void 0) {
      return true;
    }
    return matches2(computeAccessibleDescription2(element, {
      computedStyleSupportsPseudoElements: getConfig().computedStyleSupportsPseudoElements
    }), element, description, (text) => text);
  }).filter((element) => {
    return hidden === false ? isInaccessible(element, {
      isSubtreeInaccessible: cachedIsSubtreeInaccessible
    }) === false : true;
  });
}, "queryAllByRole");
function makeRoleSelector(role) {
  var _roleElements$get;
  const explicitRoleSelector = '*[role~="' + role + '"]';
  const roleRelations = (_roleElements$get = import_aria_query3.roleElements.get(role)) != null ? _roleElements$get : /* @__PURE__ */ new Set();
  const implicitRoleSelectors = new Set(Array.from(roleRelations).map((_ref) => {
    let {
      name
    } = _ref;
    return name;
  }));
  return [explicitRoleSelector].concat(Array.from(implicitRoleSelectors)).join(",");
}
__name(makeRoleSelector, "makeRoleSelector");
var getNameHint = /* @__PURE__ */ __name((name) => {
  let nameHint = "";
  if (name === void 0) {
    nameHint = "";
  } else if (typeof name === "string") {
    nameHint = ' and name "' + name + '"';
  } else {
    nameHint = " and name `" + name + "`";
  }
  return nameHint;
}, "getNameHint");
var getMultipleError$1 = /* @__PURE__ */ __name(function(c2, role, _temp2) {
  let {
    name
  } = _temp2 === void 0 ? {} : _temp2;
  return 'Found multiple elements with the role "' + role + '"' + getNameHint(name);
}, "getMultipleError$1");
var getMissingError$1 = /* @__PURE__ */ __name(function(container, role, _temp3) {
  let {
    hidden = getConfig().defaultHidden,
    name,
    description
  } = _temp3 === void 0 ? {} : _temp3;
  if (getConfig()._disableExpensiveErrorDiagnostics) {
    return 'Unable to find role="' + role + '"' + getNameHint(name);
  }
  let roles3 = "";
  Array.from(container.children).forEach((childElement) => {
    roles3 += prettyRoles(childElement, {
      hidden,
      includeDescription: description !== void 0
    });
  });
  let roleMessage;
  if (roles3.length === 0) {
    if (hidden === false) {
      roleMessage = "There are no accessible roles. But there might be some inaccessible roles. If you wish to access them, then set the `hidden` option to `true`. Learn more about this here: https://testing-library.com/docs/dom-testing-library/api-queries#byrole";
    } else {
      roleMessage = "There are no available roles.";
    }
  } else {
    roleMessage = ("\nHere are the " + (hidden === false ? "accessible" : "available") + " roles:\n\n  " + roles3.replace(/\n/g, "\n  ").replace(/\n\s\s\n/g, "\n\n") + "\n").trim();
  }
  let nameHint = "";
  if (name === void 0) {
    nameHint = "";
  } else if (typeof name === "string") {
    nameHint = ' and name "' + name + '"';
  } else {
    nameHint = " and name `" + name + "`";
  }
  let descriptionHint = "";
  if (description === void 0) {
    descriptionHint = "";
  } else if (typeof description === "string") {
    descriptionHint = ' and description "' + description + '"';
  } else {
    descriptionHint = " and description `" + description + "`";
  }
  return ("\nUnable to find an " + (hidden === false ? "accessible " : "") + 'element with the role "' + role + '"' + nameHint + descriptionHint + "\n\n" + roleMessage).trim();
}, "getMissingError$1");
var queryAllByRoleWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByRole, queryAllByRole.name, "queryAll");
var [queryByRole, getAllByRole, getByRole, findAllByRole, findByRole] = buildQueries(queryAllByRole, getMultipleError$1, getMissingError$1);
var getTestIdAttribute = /* @__PURE__ */ __name(() => getConfig().testIdAttribute, "getTestIdAttribute");
var queryAllByTestId = /* @__PURE__ */ __name(function() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  checkContainerType(args[0]);
  return queryAllByAttribute(getTestIdAttribute(), ...args);
}, "queryAllByTestId");
var getMultipleError = /* @__PURE__ */ __name((c2, id) => "Found multiple elements by: [" + getTestIdAttribute() + '="' + id + '"]', "getMultipleError");
var getMissingError = /* @__PURE__ */ __name((c2, id) => "Unable to find an element by: [" + getTestIdAttribute() + '="' + id + '"]', "getMissingError");
var queryAllByTestIdWithSuggestions = wrapAllByQueryWithSuggestion(queryAllByTestId, queryAllByTestId.name, "queryAll");
var [queryByTestId, getAllByTestId, getByTestId, findAllByTestId, findByTestId] = buildQueries(queryAllByTestId, getMultipleError, getMissingError);
var queries = Object.freeze({
  __proto__: null,
  queryAllByLabelText: queryAllByLabelTextWithSuggestions,
  queryByLabelText,
  getAllByLabelText: getAllByLabelTextWithSuggestions,
  getByLabelText: getByLabelTextWithSuggestions,
  findAllByLabelText,
  findByLabelText,
  queryByPlaceholderText,
  queryAllByPlaceholderText: queryAllByPlaceholderTextWithSuggestions,
  getByPlaceholderText,
  getAllByPlaceholderText,
  findAllByPlaceholderText,
  findByPlaceholderText,
  queryByText,
  queryAllByText: queryAllByTextWithSuggestions,
  getByText,
  getAllByText,
  findAllByText,
  findByText,
  queryByDisplayValue,
  queryAllByDisplayValue: queryAllByDisplayValueWithSuggestions,
  getByDisplayValue,
  getAllByDisplayValue,
  findAllByDisplayValue,
  findByDisplayValue,
  queryByAltText,
  queryAllByAltText: queryAllByAltTextWithSuggestions,
  getByAltText,
  getAllByAltText,
  findAllByAltText,
  findByAltText,
  queryByTitle,
  queryAllByTitle: queryAllByTitleWithSuggestions,
  getByTitle,
  getAllByTitle,
  findAllByTitle,
  findByTitle,
  queryByRole,
  queryAllByRole: queryAllByRoleWithSuggestions,
  getAllByRole,
  getByRole,
  findAllByRole,
  findByRole,
  queryByTestId,
  queryAllByTestId: queryAllByTestIdWithSuggestions,
  getByTestId,
  getAllByTestId,
  findAllByTestId,
  findByTestId
});
function getQueriesForElement(element, queries$1, initialValue2) {
  if (queries$1 === void 0) {
    queries$1 = queries;
  }
  if (initialValue2 === void 0) {
    initialValue2 = {};
  }
  return Object.keys(queries$1).reduce((helpers, key) => {
    const fn3 = queries$1[key];
    helpers[key] = fn3.bind(null, element);
    return helpers;
  }, initialValue2);
}
__name(getQueriesForElement, "getQueriesForElement");
var isRemoved = /* @__PURE__ */ __name((result) => !result || Array.isArray(result) && !result.length, "isRemoved");
function initialCheck(elements) {
  if (isRemoved(elements)) {
    throw new Error("The element(s) given to waitForElementToBeRemoved are already removed. waitForElementToBeRemoved requires that the element(s) exist(s) before waiting for removal.");
  }
}
__name(initialCheck, "initialCheck");
async function waitForElementToBeRemoved(callback, options) {
  const timeoutError = new Error("Timed out in waitForElementToBeRemoved.");
  if (typeof callback !== "function") {
    initialCheck(callback);
    const elements = Array.isArray(callback) ? callback : [callback];
    const getRemainingElements = elements.map((element) => {
      let parent = element.parentElement;
      if (parent === null) return () => null;
      while (parent.parentElement) parent = parent.parentElement;
      return () => parent.contains(element) ? element : null;
    });
    callback = /* @__PURE__ */ __name(() => getRemainingElements.map((c2) => c2()).filter(Boolean), "callback");
  }
  initialCheck(callback());
  return waitForWrapper(() => {
    let result;
    try {
      result = callback();
    } catch (error) {
      if (error.name === "TestingLibraryElementError") {
        return void 0;
      }
      throw error;
    }
    if (!isRemoved(result)) {
      throw timeoutError;
    }
    return void 0;
  }, options);
}
__name(waitForElementToBeRemoved, "waitForElementToBeRemoved");
var eventMap = {
  // Clipboard Events
  copy: {
    EventType: "ClipboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  cut: {
    EventType: "ClipboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  paste: {
    EventType: "ClipboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  // Composition Events
  compositionEnd: {
    EventType: "CompositionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  compositionStart: {
    EventType: "CompositionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  compositionUpdate: {
    EventType: "CompositionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  // Keyboard Events
  keyDown: {
    EventType: "KeyboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      charCode: 0,
      composed: true
    }
  },
  keyPress: {
    EventType: "KeyboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      charCode: 0,
      composed: true
    }
  },
  keyUp: {
    EventType: "KeyboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      charCode: 0,
      composed: true
    }
  },
  // Focus Events
  focus: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  blur: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  focusIn: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  focusOut: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  // Form Events
  change: {
    EventType: "Event",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  input: {
    EventType: "InputEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  invalid: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: true
    }
  },
  submit: {
    EventType: "Event",
    defaultInit: {
      bubbles: true,
      cancelable: true
    }
  },
  reset: {
    EventType: "Event",
    defaultInit: {
      bubbles: true,
      cancelable: true
    }
  },
  // Mouse Events
  click: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      button: 0,
      composed: true
    }
  },
  contextMenu: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  dblClick: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  drag: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  dragEnd: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  dragEnter: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  dragExit: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  dragLeave: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  dragOver: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  dragStart: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  drop: {
    EventType: "DragEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseDown: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseEnter: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  mouseLeave: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  mouseMove: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseOut: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseOver: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseUp: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  // Selection Events
  select: {
    EventType: "Event",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  // Touch Events
  touchCancel: {
    EventType: "TouchEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  touchEnd: {
    EventType: "TouchEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  touchMove: {
    EventType: "TouchEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  touchStart: {
    EventType: "TouchEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  // UI Events
  resize: {
    EventType: "UIEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  scroll: {
    EventType: "UIEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  // Wheel Events
  wheel: {
    EventType: "WheelEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  // Media Events
  abort: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  canPlay: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  canPlayThrough: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  durationChange: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  emptied: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  encrypted: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  ended: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  loadedData: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  loadedMetadata: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  loadStart: {
    EventType: "ProgressEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  pause: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  play: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  playing: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  progress: {
    EventType: "ProgressEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  rateChange: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  seeked: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  seeking: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  stalled: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  suspend: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  timeUpdate: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  volumeChange: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  waiting: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  // Events
  load: {
    // TODO: load events can be UIEvent or Event depending on what generated them
    // This is where this abstraction breaks down.
    // But the common targets are <img />, <script /> and window.
    // Neither of these targets receive a UIEvent
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  error: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  // Animation Events
  animationStart: {
    EventType: "AnimationEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  animationEnd: {
    EventType: "AnimationEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  animationIteration: {
    EventType: "AnimationEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  // Transition Events
  transitionCancel: {
    EventType: "TransitionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  transitionEnd: {
    EventType: "TransitionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true
    }
  },
  transitionRun: {
    EventType: "TransitionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  transitionStart: {
    EventType: "TransitionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  // pointer events
  pointerOver: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerEnter: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  pointerDown: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerMove: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerUp: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerCancel: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  pointerOut: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerLeave: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  gotPointerCapture: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  lostPointerCapture: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  // history events
  popState: {
    EventType: "PopStateEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  // window events
  offline: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  online: {
    EventType: "Event",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  pageHide: {
    EventType: "PageTransitionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true
    }
  },
  pageShow: {
    EventType: "PageTransitionEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true
    }
  }
};
var eventAliasMap = {
  doubleClick: "dblClick"
};
function fireEvent(element, event) {
  return getConfig().eventWrapper(() => {
    if (!event) {
      throw new Error("Unable to fire an event - please provide an event object.");
    }
    if (!element) {
      throw new Error('Unable to fire a "' + event.type + '" event - please provide a DOM element.');
    }
    return element.dispatchEvent(event);
  });
}
__name(fireEvent, "fireEvent");
function createEvent(eventName, node, init, _temp) {
  let {
    EventType = "Event",
    defaultInit = {}
  } = _temp === void 0 ? {} : _temp;
  if (!node) {
    throw new Error('Unable to fire a "' + eventName + '" event - please provide a DOM element.');
  }
  const eventInit = {
    ...defaultInit,
    ...init
  };
  const {
    target: {
      value,
      files,
      ...targetProperties
    } = {}
  } = eventInit;
  if (value !== void 0) {
    setNativeValue(node, value);
  }
  if (files !== void 0) {
    Object.defineProperty(node, "files", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: files
    });
  }
  Object.assign(node, targetProperties);
  const window2 = getWindowFromNode(node);
  const EventConstructor = window2[EventType] || window2.Event;
  let event;
  if (typeof EventConstructor === "function") {
    event = new EventConstructor(eventName, eventInit);
  } else {
    event = window2.document.createEvent(EventType);
    const {
      bubbles,
      cancelable,
      detail,
      ...otherInit
    } = eventInit;
    event.initEvent(eventName, bubbles, cancelable, detail);
    Object.keys(otherInit).forEach((eventKey) => {
      event[eventKey] = otherInit[eventKey];
    });
  }
  const dataTransferProperties = ["dataTransfer", "clipboardData"];
  dataTransferProperties.forEach((dataTransferKey) => {
    const dataTransferValue = eventInit[dataTransferKey];
    if (typeof dataTransferValue === "object") {
      if (typeof window2.DataTransfer === "function") {
        Object.defineProperty(event, dataTransferKey, {
          value: Object.getOwnPropertyNames(dataTransferValue).reduce((acc, propName) => {
            Object.defineProperty(acc, propName, {
              value: dataTransferValue[propName]
            });
            return acc;
          }, new window2.DataTransfer())
        });
      } else {
        Object.defineProperty(event, dataTransferKey, {
          value: dataTransferValue
        });
      }
    }
  });
  return event;
}
__name(createEvent, "createEvent");
Object.keys(eventMap).forEach((key) => {
  const {
    EventType,
    defaultInit
  } = eventMap[key];
  const eventName = key.toLowerCase();
  createEvent[key] = (node, init) => createEvent(eventName, node, init, {
    EventType,
    defaultInit
  });
  fireEvent[key] = (node, init) => fireEvent(node, createEvent[key](node, init));
});
function setNativeValue(element, value) {
  const {
    set: valueSetter
  } = Object.getOwnPropertyDescriptor(element, "value") || {};
  const prototype = Object.getPrototypeOf(element);
  const {
    set: prototypeValueSetter
  } = Object.getOwnPropertyDescriptor(prototype, "value") || {};
  if (prototypeValueSetter && valueSetter !== prototypeValueSetter) {
    prototypeValueSetter.call(element, value);
  } else {
    if (valueSetter) {
      valueSetter.call(element, value);
    } else {
      throw new Error("The given element does not have a value setter");
    }
  }
}
__name(setNativeValue, "setNativeValue");
Object.keys(eventAliasMap).forEach((aliasKey) => {
  const key = eventAliasMap[aliasKey];
  fireEvent[aliasKey] = function() {
    return fireEvent[key](...arguments);
  };
});
function unindent(string) {
  return string.replace(/[ \t]*[\n][ \t]*/g, "\n");
}
__name(unindent, "unindent");
function encode(value) {
  return import_lz_string.default.compressToEncodedURIComponent(unindent(value));
}
__name(encode, "encode");
function getPlaygroundUrl(markup) {
  return "https://testing-playground.com/#markup=" + encode(markup);
}
__name(getPlaygroundUrl, "getPlaygroundUrl");
var debug = /* @__PURE__ */ __name((element, maxLength, options) => Array.isArray(element) ? element.forEach((el) => logDOM(el, maxLength, options)) : logDOM(element, maxLength, options), "debug");
var logTestingPlaygroundURL = /* @__PURE__ */ __name(function(element) {
  if (element === void 0) {
    element = getDocument().body;
  }
  if (!element || !("innerHTML" in element)) {
    console.log("The element you're providing isn't a valid DOM element.");
    return;
  }
  if (!element.innerHTML) {
    console.log("The provided element doesn't have any children.");
    return;
  }
  const playgroundUrl = getPlaygroundUrl(element.innerHTML);
  console.log("Open this URL in your browser\n\n" + playgroundUrl);
  return playgroundUrl;
}, "logTestingPlaygroundURL");
var initialValue = {
  debug,
  logTestingPlaygroundURL
};
var screen = typeof document !== "undefined" && document.body ? getQueriesForElement(document.body, queries, initialValue) : Object.keys(queries).reduce((helpers, key) => {
  helpers[key] = () => {
    throw new TypeError("For queries bound to document.body a global document has to be available... Learn more: https://testing-library.com/s/screen-global-error");
  };
  return helpers;
}, initialValue);

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/isElementType.js
function isElementType(element, tag, props) {
  if (element.namespaceURI && element.namespaceURI !== "http://www.w3.org/1999/xhtml") {
    return false;
  }
  tag = Array.isArray(tag) ? tag : [
    tag
  ];
  if (!tag.includes(element.tagName.toLowerCase())) {
    return false;
  }
  if (props) {
    return Object.entries(props).every(([k2, v2]) => element[k2] === v2);
  }
  return true;
}
__name(isElementType, "isElementType");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/getWindow.js
function getWindow(node) {
  var _node_ownerDocument;
  if (isDocument(node) && node.defaultView) {
    return node.defaultView;
  } else if ((_node_ownerDocument = node.ownerDocument) === null || _node_ownerDocument === void 0 ? void 0 : _node_ownerDocument.defaultView) {
    return node.ownerDocument.defaultView;
  }
  throw new Error(`Could not determine window of node. Node was ${describe(node)}`);
}
__name(getWindow, "getWindow");
function isDocument(node) {
  return node.nodeType === 9;
}
__name(isDocument, "isDocument");
function describe(val) {
  return typeof val === "function" ? `function ${val.name}` : val === null ? "null" : String(val);
}
__name(describe, "describe");

// ../node_modules/@testing-library/user-event/dist/esm/utils/dataTransfer/Blob.js
function readBlobText(blob, FileReader) {
  return new Promise((res, rej) => {
    const fr = new FileReader();
    fr.onerror = rej;
    fr.onabort = rej;
    fr.onload = () => {
      res(String(fr.result));
    };
    fr.readAsText(blob);
  });
}
__name(readBlobText, "readBlobText");

// ../node_modules/@testing-library/user-event/dist/esm/utils/dataTransfer/FileList.js
function createFileList(window2, files) {
  const list = {
    ...files,
    length: files.length,
    item: /* @__PURE__ */ __name((index) => list[index], "item"),
    [Symbol.iterator]: /* @__PURE__ */ __name(function* nextFile() {
      for (let i2 = 0; i2 < list.length; i2++) {
        yield list[i2];
      }
    }, "nextFile")
  };
  list.constructor = window2.FileList;
  if (window2.FileList) {
    Object.setPrototypeOf(list, window2.FileList.prototype);
  }
  Object.freeze(list);
  return list;
}
__name(createFileList, "createFileList");

// ../node_modules/@testing-library/user-event/dist/esm/utils/dataTransfer/DataTransfer.js
function _define_property(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property, "_define_property");
var _DataTransferItemStub = class _DataTransferItemStub {
  getAsFile() {
    return this.file;
  }
  getAsString(callback) {
    if (typeof this.data === "string") {
      callback(this.data);
    }
  }
  /* istanbul ignore next */
  webkitGetAsEntry() {
    throw new Error("not implemented");
  }
  constructor(dataOrFile, type5) {
    _define_property(this, "kind", void 0);
    _define_property(this, "type", void 0);
    _define_property(this, "file", null);
    _define_property(this, "data", void 0);
    if (typeof dataOrFile === "string") {
      this.kind = "string";
      this.type = String(type5);
      this.data = dataOrFile;
    } else {
      this.kind = "file";
      this.type = dataOrFile.type;
      this.file = dataOrFile;
    }
  }
};
__name(_DataTransferItemStub, "DataTransferItemStub");
var DataTransferItemStub = _DataTransferItemStub;
var _DataTransferItemListStub = class _DataTransferItemListStub extends Array {
  add(...args) {
    const item = new DataTransferItemStub(args[0], args[1]);
    this.push(item);
    return item;
  }
  clear() {
    this.splice(0, this.length);
  }
  remove(index) {
    this.splice(index, 1);
  }
};
__name(_DataTransferItemListStub, "DataTransferItemListStub");
var DataTransferItemListStub = _DataTransferItemListStub;
function getTypeMatcher(type5, exact) {
  const [group, sub] = type5.split("/");
  const isGroup = !sub || sub === "*";
  return (item) => {
    return exact ? item.type === (isGroup ? group : type5) : isGroup ? item.type.startsWith(`${group}/`) : item.type === group;
  };
}
__name(getTypeMatcher, "getTypeMatcher");
function createDataTransferStub(window2) {
  var _a3;
  return new (_a3 = class {
    getData(format3) {
      var _this_items_find;
      const match = (_this_items_find = this.items.find(getTypeMatcher(format3, true))) !== null && _this_items_find !== void 0 ? _this_items_find : this.items.find(getTypeMatcher(format3, false));
      let text = "";
      match === null || match === void 0 ? void 0 : match.getAsString((t2) => {
        text = t2;
      });
      return text;
    }
    setData(format3, data) {
      const matchIndex = this.items.findIndex(getTypeMatcher(format3, true));
      const item = new DataTransferItemStub(data, format3);
      if (matchIndex >= 0) {
        this.items.splice(matchIndex, 1, item);
      } else {
        this.items.push(item);
      }
    }
    clearData(format3) {
      if (format3) {
        const matchIndex = this.items.findIndex(getTypeMatcher(format3, true));
        if (matchIndex >= 0) {
          this.items.remove(matchIndex);
        }
      } else {
        this.items.clear();
      }
    }
    get types() {
      const t2 = [];
      if (this.files.length) {
        t2.push("Files");
      }
      this.items.forEach((i2) => t2.push(i2.type));
      Object.freeze(t2);
      return t2;
    }
    /* istanbul ignore next */
    setDragImage() {
    }
    constructor() {
      _define_property(this, "dropEffect", "none");
      _define_property(this, "effectAllowed", "uninitialized");
      _define_property(this, "items", new DataTransferItemListStub());
      _define_property(this, "files", createFileList(window2, []));
    }
  }, __name(_a3, "DataTransferStub"), _a3)();
}
__name(createDataTransferStub, "createDataTransferStub");
function createDataTransfer(window2, files = []) {
  const dt = typeof window2.DataTransfer === "undefined" ? createDataTransferStub(window2) : (
    /* istanbul ignore next */
    new window2.DataTransfer()
  );
  Object.defineProperty(dt, "files", {
    get: /* @__PURE__ */ __name(() => createFileList(window2, files), "get")
  });
  return dt;
}
__name(createDataTransfer, "createDataTransfer");
async function getBlobFromDataTransferItem(window2, item) {
  if (item.kind === "file") {
    return item.getAsFile();
  }
  return new window2.Blob([
    await new Promise((r2) => item.getAsString(r2))
  ], {
    type: item.type
  });
}
__name(getBlobFromDataTransferItem, "getBlobFromDataTransferItem");

// ../node_modules/@testing-library/user-event/dist/esm/utils/dataTransfer/Clipboard.js
function _define_property2(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property2, "_define_property");
function createClipboardItem(window2, ...blobs) {
  var _a3;
  const dataMap = Object.fromEntries(blobs.map((b2) => [
    typeof b2 === "string" ? "text/plain" : b2.type,
    Promise.resolve(b2)
  ]));
  if (typeof window2.ClipboardItem !== "undefined") {
    return new window2.ClipboardItem(dataMap);
  }
  return new (_a3 = class {
    get types() {
      return Array.from(Object.keys(this.data));
    }
    async getType(type5) {
      const value = await this.data[type5];
      if (!value) {
        throw new Error(`${type5} is not one of the available MIME types on this item.`);
      }
      return value instanceof window2.Blob ? value : new window2.Blob([
        value
      ], {
        type: type5
      });
    }
    constructor(d) {
      _define_property2(this, "data", void 0);
      this.data = d;
    }
  }, __name(_a3, "ClipboardItem"), _a3)(dataMap);
}
__name(createClipboardItem, "createClipboardItem");
var ClipboardStubControl = Symbol("Manage ClipboardSub");
function createClipboardStub(window2, control) {
  var _a3;
  return Object.assign(new (_a3 = class extends window2.EventTarget {
    async read() {
      return Array.from(this.items);
    }
    async readText() {
      let text = "";
      for (const item of this.items) {
        const type5 = item.types.includes("text/plain") ? "text/plain" : item.types.find((t2) => t2.startsWith("text/"));
        if (type5) {
          text += await item.getType(type5).then((b2) => readBlobText(b2, window2.FileReader));
        }
      }
      return text;
    }
    async write(data) {
      this.items = data;
    }
    async writeText(text) {
      this.items = [
        createClipboardItem(window2, text)
      ];
    }
    constructor(...args) {
      super(...args), _define_property2(this, "items", []);
    }
  }, __name(_a3, "Clipboard"), _a3)(), {
    [ClipboardStubControl]: control
  });
}
__name(createClipboardStub, "createClipboardStub");
function isClipboardStub(clipboard) {
  return !!(clipboard === null || clipboard === void 0 ? void 0 : clipboard[ClipboardStubControl]);
}
__name(isClipboardStub, "isClipboardStub");
function attachClipboardStubToView(window2) {
  if (isClipboardStub(window2.navigator.clipboard)) {
    return window2.navigator.clipboard[ClipboardStubControl];
  }
  const realClipboard = Object.getOwnPropertyDescriptor(window2.navigator, "clipboard");
  let stub;
  const control = {
    resetClipboardStub: /* @__PURE__ */ __name(() => {
      stub = createClipboardStub(window2, control);
    }, "resetClipboardStub"),
    detachClipboardStub: /* @__PURE__ */ __name(() => {
      if (realClipboard) {
        Object.defineProperty(window2.navigator, "clipboard", realClipboard);
      } else {
        Object.defineProperty(window2.navigator, "clipboard", {
          value: void 0,
          configurable: true
        });
      }
    }, "detachClipboardStub")
  };
  stub = createClipboardStub(window2, control);
  Object.defineProperty(window2.navigator, "clipboard", {
    get: /* @__PURE__ */ __name(() => stub, "get"),
    configurable: true
  });
  return stub[ClipboardStubControl];
}
__name(attachClipboardStubToView, "attachClipboardStubToView");
function resetClipboardStubOnView(window2) {
  if (isClipboardStub(window2.navigator.clipboard)) {
    window2.navigator.clipboard[ClipboardStubControl].resetClipboardStub();
  }
}
__name(resetClipboardStubOnView, "resetClipboardStubOnView");
function detachClipboardStubFromView(window2) {
  if (isClipboardStub(window2.navigator.clipboard)) {
    window2.navigator.clipboard[ClipboardStubControl].detachClipboardStub();
  }
}
__name(detachClipboardStubFromView, "detachClipboardStubFromView");
async function readDataTransferFromClipboard(document2) {
  const window2 = document2.defaultView;
  const clipboard = window2 === null || window2 === void 0 ? void 0 : window2.navigator.clipboard;
  const items = clipboard && await clipboard.read();
  if (!items) {
    throw new Error("The Clipboard API is unavailable.");
  }
  const dt = createDataTransfer(window2);
  for (const item of items) {
    for (const type5 of item.types) {
      dt.setData(type5, await item.getType(type5).then((b2) => readBlobText(b2, window2.FileReader)));
    }
  }
  return dt;
}
__name(readDataTransferFromClipboard, "readDataTransferFromClipboard");
async function writeDataTransferToClipboard(document2, clipboardData) {
  const window2 = getWindow(document2);
  const clipboard = window2.navigator.clipboard;
  const items = [];
  for (let i2 = 0; i2 < clipboardData.items.length; i2++) {
    const dtItem = clipboardData.items[i2];
    const blob = await getBlobFromDataTransferItem(window2, dtItem);
    items.push(createClipboardItem(window2, blob));
  }
  const written = clipboard && await clipboard.write(items).then(
    () => true,
    // Can happen with other implementations that e.g. require permissions
    /* istanbul ignore next */
    () => false
  );
  if (!written) {
    throw new Error("The Clipboard API is unavailable.");
  }
}
__name(writeDataTransferToClipboard, "writeDataTransferToClipboard");
var g = globalThis;
if (typeof g.afterEach === "function") {
  g.afterEach(() => {
    if (typeof globalThis.window !== "undefined") {
      resetClipboardStubOnView(globalThis.window);
    }
  });
}
if (typeof g.afterAll === "function") {
  g.afterAll(() => {
    if (typeof globalThis.window !== "undefined") {
      detachClipboardStubFromView(globalThis.window);
    }
  });
}

// ../node_modules/@testing-library/user-event/dist/esm/utils/focus/selector.js
var FOCUSABLE_SELECTOR = [
  "input:not([type=hidden]):not([disabled])",
  "button:not([disabled])",
  "select:not([disabled])",
  "textarea:not([disabled])",
  '[contenteditable=""]',
  '[contenteditable="true"]',
  "a[href]",
  "[tabindex]:not([disabled])"
].join(", ");

// ../node_modules/@testing-library/user-event/dist/esm/utils/focus/isFocusable.js
function isFocusable(element) {
  return element.matches(FOCUSABLE_SELECTOR);
}
__name(isFocusable, "isFocusable");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/cloneEvent.js
function cloneEvent(event) {
  return new event.constructor(event.type, event);
}
__name(cloneEvent, "cloneEvent");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/isDisabled.js
function isDisabled2(element) {
  for (let el = element; el; el = el.parentElement) {
    if (isElementType(el, [
      "button",
      "input",
      "select",
      "textarea",
      "optgroup",
      "option"
    ])) {
      if (el.hasAttribute("disabled")) {
        return true;
      }
    } else if (isElementType(el, "fieldset")) {
      var _el_querySelector;
      if (el.hasAttribute("disabled") && !((_el_querySelector = el.querySelector(":scope > legend")) === null || _el_querySelector === void 0 ? void 0 : _el_querySelector.contains(element))) {
        return true;
      }
    } else if (el.tagName.includes("-")) {
      if (el.constructor.formAssociated && el.hasAttribute("disabled")) {
        return true;
      }
    }
  }
  return false;
}
__name(isDisabled2, "isDisabled");

// ../node_modules/@testing-library/user-event/dist/esm/utils/focus/getActiveElement.js
function getActiveElement(document2) {
  const activeElement = document2.activeElement;
  if (activeElement === null || activeElement === void 0 ? void 0 : activeElement.shadowRoot) {
    return getActiveElement(activeElement.shadowRoot);
  } else {
    if (isDisabled2(activeElement)) {
      return document2.ownerDocument ? (
        /* istanbul ignore next */
        document2.ownerDocument.body
      ) : document2.body;
    }
    return activeElement;
  }
}
__name(getActiveElement, "getActiveElement");
function getActiveElementOrBody(document2) {
  var _getActiveElement;
  return (_getActiveElement = getActiveElement(document2)) !== null && _getActiveElement !== void 0 ? _getActiveElement : (
    /* istanbul ignore next */
    document2.body
  );
}
__name(getActiveElementOrBody, "getActiveElementOrBody");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/findClosest.js
function findClosest(element, callback) {
  let el = element;
  do {
    if (callback(el)) {
      return el;
    }
    el = el.parentElement;
  } while (el && el !== element.ownerDocument.body);
  return void 0;
}
__name(findClosest, "findClosest");

// ../node_modules/@testing-library/user-event/dist/esm/utils/edit/isContentEditable.js
function isContentEditable(element) {
  return element.hasAttribute("contenteditable") && (element.getAttribute("contenteditable") == "true" || element.getAttribute("contenteditable") == "");
}
__name(isContentEditable, "isContentEditable");
function getContentEditable(node) {
  const element = getElement(node);
  return element && (element.closest('[contenteditable=""]') || element.closest('[contenteditable="true"]'));
}
__name(getContentEditable, "getContentEditable");
function getElement(node) {
  return node.nodeType === 1 ? node : node.parentElement;
}
__name(getElement, "getElement");

// ../node_modules/@testing-library/user-event/dist/esm/utils/click/isClickableInput.js
var clickableInputTypes = function(clickableInputTypes2) {
  clickableInputTypes2["button"] = "button";
  clickableInputTypes2["color"] = "color";
  clickableInputTypes2["file"] = "file";
  clickableInputTypes2["image"] = "image";
  clickableInputTypes2["reset"] = "reset";
  clickableInputTypes2["submit"] = "submit";
  clickableInputTypes2["checkbox"] = "checkbox";
  clickableInputTypes2["radio"] = "radio";
  return clickableInputTypes2;
}(clickableInputTypes || {});
function isClickableInput(element) {
  return isElementType(element, "button") || isElementType(element, "input") && element.type in clickableInputTypes;
}
__name(isClickableInput, "isClickableInput");

// ../node_modules/@testing-library/user-event/dist/esm/utils/edit/isEditable.js
function isEditable(element) {
  return isEditableInputOrTextArea(element) && !element.readOnly || isContentEditable(element);
}
__name(isEditable, "isEditable");
var editableInputTypes = function(editableInputTypes2) {
  editableInputTypes2["text"] = "text";
  editableInputTypes2["date"] = "date";
  editableInputTypes2["datetime-local"] = "datetime-local";
  editableInputTypes2["email"] = "email";
  editableInputTypes2["month"] = "month";
  editableInputTypes2["number"] = "number";
  editableInputTypes2["password"] = "password";
  editableInputTypes2["search"] = "search";
  editableInputTypes2["tel"] = "tel";
  editableInputTypes2["time"] = "time";
  editableInputTypes2["url"] = "url";
  editableInputTypes2["week"] = "week";
  return editableInputTypes2;
}(editableInputTypes || {});
function isEditableInputOrTextArea(element) {
  return isElementType(element, "textarea") || isElementType(element, "input") && element.type in editableInputTypes;
}
__name(isEditableInputOrTextArea, "isEditableInputOrTextArea");

// ../node_modules/@testing-library/user-event/dist/esm/utils/focus/selection.js
function hasOwnSelection(node) {
  return isElement3(node) && isEditableInputOrTextArea(node);
}
__name(hasOwnSelection, "hasOwnSelection");
function hasNoSelection(node) {
  return isElement3(node) && isClickableInput(node);
}
__name(hasNoSelection, "hasNoSelection");
function isElement3(node) {
  return node.nodeType === 1;
}
__name(isElement3, "isElement");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/updateSelectionOnFocus.js
function updateSelectionOnFocus(element) {
  const selection = element.ownerDocument.getSelection();
  if (!(selection === null || selection === void 0 ? void 0 : selection.focusNode)) {
    return;
  }
  if (hasOwnSelection(element)) {
    const contenteditable = getContentEditable(selection.focusNode);
    if (contenteditable) {
      if (!selection.isCollapsed) {
        var _contenteditable_firstChild;
        const focusNode = ((_contenteditable_firstChild = contenteditable.firstChild) === null || _contenteditable_firstChild === void 0 ? void 0 : _contenteditable_firstChild.nodeType) === 3 ? contenteditable.firstChild : contenteditable;
        selection.setBaseAndExtent(focusNode, 0, focusNode, 0);
      }
    } else {
      selection.setBaseAndExtent(element, 0, element, 0);
    }
  }
}
__name(updateSelectionOnFocus, "updateSelectionOnFocus");

// ../node_modules/@testing-library/user-event/dist/esm/event/wrapEvent.js
function wrapEvent(cb, _element) {
  return getConfig().eventWrapper(cb);
}
__name(wrapEvent, "wrapEvent");

// ../node_modules/@testing-library/user-event/dist/esm/event/focus.js
function focusElement(element) {
  const target = findClosest(element, isFocusable);
  const activeElement = getActiveElement(element.ownerDocument);
  if ((target !== null && target !== void 0 ? target : element.ownerDocument.body) === activeElement) {
    return;
  } else if (target) {
    wrapEvent(() => target.focus());
  } else {
    wrapEvent(() => activeElement === null || activeElement === void 0 ? void 0 : activeElement.blur());
  }
  updateSelectionOnFocus(target !== null && target !== void 0 ? target : element.ownerDocument.body);
}
__name(focusElement, "focusElement");
function blurElement(element) {
  if (!isFocusable(element)) return;
  const wasActive = getActiveElement(element.ownerDocument) === element;
  if (!wasActive) return;
  wrapEvent(() => element.blur());
}
__name(blurElement, "blurElement");

// ../node_modules/@testing-library/user-event/dist/esm/event/behavior/registry.js
var behavior = {};

// ../node_modules/@testing-library/user-event/dist/esm/event/behavior/click.js
behavior.click = (event, target, instance) => {
  const context = target.closest("button,input,label,select,textarea");
  const control = context && isElementType(context, "label") && context.control;
  if (control && control !== target) {
    return () => {
      if (isFocusable(control)) {
        focusElement(control);
        instance.dispatchEvent(control, cloneEvent(event));
      }
    };
  } else if (isElementType(target, "input", {
    type: "file"
  })) {
    return () => {
      blurElement(target);
      target.dispatchEvent(new (getWindow(target)).Event("fileDialog"));
      focusElement(target);
    };
  }
};

// ../node_modules/@testing-library/user-event/dist/esm/document/UI.js
var UIValue = Symbol("Displayed value in UI");
var UISelection = Symbol("Displayed selection in UI");
var InitialValue = Symbol("Initial value to compare on blur");
function isUIValue(value) {
  return typeof value === "object" && UIValue in value;
}
__name(isUIValue, "isUIValue");
function isUISelectionStart(start) {
  return !!start && typeof start === "object" && UISelection in start;
}
__name(isUISelectionStart, "isUISelectionStart");
function setUIValue(element, value) {
  if (element[InitialValue] === void 0) {
    element[InitialValue] = element.value;
  }
  element[UIValue] = value;
  element.value = Object.assign(new String(value), {
    [UIValue]: true
  });
}
__name(setUIValue, "setUIValue");
function getUIValue(element) {
  return element[UIValue] === void 0 ? element.value : String(element[UIValue]);
}
__name(getUIValue, "getUIValue");
function setUIValueClean(element) {
  element[UIValue] = void 0;
}
__name(setUIValueClean, "setUIValueClean");
function clearInitialValue(element) {
  element[InitialValue] = void 0;
}
__name(clearInitialValue, "clearInitialValue");
function getInitialValue(element) {
  return element[InitialValue];
}
__name(getInitialValue, "getInitialValue");
function setUISelectionRaw(element, selection) {
  element[UISelection] = selection;
}
__name(setUISelectionRaw, "setUISelectionRaw");
function setUISelection(element, { focusOffset: focusOffsetParam, anchorOffset: anchorOffsetParam = focusOffsetParam }, mode = "replace") {
  const valueLength = getUIValue(element).length;
  const sanitizeOffset = /* @__PURE__ */ __name((o2) => Math.max(0, Math.min(valueLength, o2)), "sanitizeOffset");
  const anchorOffset = mode === "replace" || element[UISelection] === void 0 ? sanitizeOffset(anchorOffsetParam) : element[UISelection].anchorOffset;
  const focusOffset = sanitizeOffset(focusOffsetParam);
  const startOffset = Math.min(anchorOffset, focusOffset);
  const endOffset = Math.max(anchorOffset, focusOffset);
  element[UISelection] = {
    anchorOffset,
    focusOffset
  };
  if (element.selectionStart === startOffset && element.selectionEnd === endOffset) {
    return;
  }
  const startObj = Object.assign(new Number(startOffset), {
    [UISelection]: true
  });
  try {
    element.setSelectionRange(startObj, endOffset);
  } catch {
  }
}
__name(setUISelection, "setUISelection");
function getUISelection(element) {
  var _element_selectionStart, _element_selectionEnd, _element_UISelection;
  const sel = (_element_UISelection = element[UISelection]) !== null && _element_UISelection !== void 0 ? _element_UISelection : {
    anchorOffset: (_element_selectionStart = element.selectionStart) !== null && _element_selectionStart !== void 0 ? _element_selectionStart : 0,
    focusOffset: (_element_selectionEnd = element.selectionEnd) !== null && _element_selectionEnd !== void 0 ? _element_selectionEnd : 0
  };
  return {
    ...sel,
    startOffset: Math.min(sel.anchorOffset, sel.focusOffset),
    endOffset: Math.max(sel.anchorOffset, sel.focusOffset)
  };
}
__name(getUISelection, "getUISelection");
function hasUISelection(element) {
  return !!element[UISelection];
}
__name(hasUISelection, "hasUISelection");
function setUISelectionClean(element) {
  element[UISelection] = void 0;
}
__name(setUISelectionClean, "setUISelectionClean");

// ../node_modules/@testing-library/user-event/dist/esm/utils/edit/timeValue.js
var parseInt2 = globalThis.parseInt;
function buildTimeValue(value) {
  const onlyDigitsValue = value.replace(/\D/g, "");
  if (onlyDigitsValue.length < 2) {
    return value;
  }
  const firstDigit = parseInt2(onlyDigitsValue[0], 10);
  const secondDigit = parseInt2(onlyDigitsValue[1], 10);
  if (firstDigit >= 3 || firstDigit === 2 && secondDigit >= 4) {
    let index;
    if (firstDigit >= 3) {
      index = 1;
    } else {
      index = 2;
    }
    return build(onlyDigitsValue, index);
  }
  if (value.length === 2) {
    return value;
  }
  return build(onlyDigitsValue, 2);
}
__name(buildTimeValue, "buildTimeValue");
function build(onlyDigitsValue, index) {
  const hours = onlyDigitsValue.slice(0, index);
  const validHours = Math.min(parseInt2(hours, 10), 23);
  const minuteCharacters = onlyDigitsValue.slice(index);
  const parsedMinutes = parseInt2(minuteCharacters, 10);
  const validMinutes = Math.min(parsedMinutes, 59);
  return `${validHours.toString().padStart(2, "0")}:${validMinutes.toString().padStart(2, "0")}`;
}
__name(build, "build");
function isValidDateOrTimeValue(element, value) {
  const clone2 = element.cloneNode();
  clone2.value = value;
  return clone2.value === value;
}
__name(isValidDateOrTimeValue, "isValidDateOrTimeValue");

// ../node_modules/@testing-library/user-event/dist/esm/utils/edit/maxLength.js
var maxLengthSupportedTypes = function(maxLengthSupportedTypes2) {
  maxLengthSupportedTypes2["email"] = "email";
  maxLengthSupportedTypes2["password"] = "password";
  maxLengthSupportedTypes2["search"] = "search";
  maxLengthSupportedTypes2["telephone"] = "telephone";
  maxLengthSupportedTypes2["text"] = "text";
  maxLengthSupportedTypes2["url"] = "url";
  return maxLengthSupportedTypes2;
}(maxLengthSupportedTypes || {});
function getMaxLength(element) {
  var _element_getAttribute;
  const attr = (_element_getAttribute = element.getAttribute("maxlength")) !== null && _element_getAttribute !== void 0 ? _element_getAttribute : "";
  return /^\d+$/.test(attr) && Number(attr) >= 0 ? Number(attr) : void 0;
}
__name(getMaxLength, "getMaxLength");
function supportsMaxLength(element) {
  return isElementType(element, "textarea") || isElementType(element, "input") && element.type in maxLengthSupportedTypes;
}
__name(supportsMaxLength, "supportsMaxLength");

// ../node_modules/@testing-library/user-event/dist/esm/utils/focus/cursor.js
function getNextCursorPosition(node, offset, direction, inputType) {
  if (isTextNode(node) && offset + direction >= 0 && offset + direction <= node.nodeValue.length) {
    return {
      node,
      offset: offset + direction
    };
  }
  const nextNode = getNextCharacterContentNode(node, offset, direction);
  if (nextNode) {
    if (isTextNode(nextNode)) {
      return {
        node: nextNode,
        offset: direction > 0 ? Math.min(1, nextNode.nodeValue.length) : Math.max(nextNode.nodeValue.length - 1, 0)
      };
    } else if (isElementType(nextNode, "br")) {
      const nextPlusOne = getNextCharacterContentNode(nextNode, void 0, direction);
      if (!nextPlusOne) {
        if (direction < 0 && inputType === "deleteContentBackward") {
          return {
            node: nextNode.parentNode,
            offset: getOffset(nextNode)
          };
        }
        return void 0;
      } else if (isTextNode(nextPlusOne)) {
        return {
          node: nextPlusOne,
          offset: direction > 0 ? 0 : nextPlusOne.nodeValue.length
        };
      } else if (direction < 0 && isElementType(nextPlusOne, "br")) {
        return {
          node: nextNode.parentNode,
          offset: getOffset(nextNode)
        };
      } else {
        return {
          node: nextPlusOne.parentNode,
          offset: getOffset(nextPlusOne) + (direction > 0 ? 0 : 1)
        };
      }
    } else {
      return {
        node: nextNode.parentNode,
        offset: getOffset(nextNode) + (direction > 0 ? 1 : 0)
      };
    }
  }
}
__name(getNextCursorPosition, "getNextCursorPosition");
function getNextCharacterContentNode(node, offset, direction) {
  const nextOffset = Number(offset) + (direction < 0 ? -1 : 0);
  if (offset !== void 0 && isElement4(node) && nextOffset >= 0 && nextOffset < node.children.length) {
    node = node.children[nextOffset];
  }
  return walkNodes(node, direction === 1 ? "next" : "previous", isTreatedAsCharacterContent);
}
__name(getNextCharacterContentNode, "getNextCharacterContentNode");
function isTreatedAsCharacterContent(node) {
  if (isTextNode(node)) {
    return true;
  }
  if (isElement4(node)) {
    if (isElementType(node, [
      "input",
      "textarea"
    ])) {
      return node.type !== "hidden";
    } else if (isElementType(node, "br")) {
      return true;
    }
  }
  return false;
}
__name(isTreatedAsCharacterContent, "isTreatedAsCharacterContent");
function getOffset(node) {
  let i2 = 0;
  while (node.previousSibling) {
    i2++;
    node = node.previousSibling;
  }
  return i2;
}
__name(getOffset, "getOffset");
function isElement4(node) {
  return node.nodeType === 1;
}
__name(isElement4, "isElement");
function isTextNode(node) {
  return node.nodeType === 3;
}
__name(isTextNode, "isTextNode");
function walkNodes(node, direction, callback) {
  for (; ; ) {
    var _node_ownerDocument;
    const sibling = node[`${direction}Sibling`];
    if (sibling) {
      node = getDescendant(sibling, direction === "next" ? "first" : "last");
      if (callback(node)) {
        return node;
      }
    } else if (node.parentNode && (!isElement4(node.parentNode) || !isContentEditable(node.parentNode) && node.parentNode !== ((_node_ownerDocument = node.ownerDocument) === null || _node_ownerDocument === void 0 ? void 0 : _node_ownerDocument.body))) {
      node = node.parentNode;
    } else {
      break;
    }
  }
}
__name(walkNodes, "walkNodes");
function getDescendant(node, direction) {
  while (node.hasChildNodes()) {
    node = node[`${direction}Child`];
  }
  return node;
}
__name(getDescendant, "getDescendant");

// ../node_modules/@testing-library/user-event/dist/esm/document/trackValue.js
var TrackChanges = Symbol("Track programmatic changes for React workaround");
function isReact17Element(element) {
  return Object.getOwnPropertyNames(element).some((k2) => k2.startsWith("__react")) && getWindow(element).REACT_VERSION === 17;
}
__name(isReact17Element, "isReact17Element");
function startTrackValue(element) {
  if (!isReact17Element(element)) {
    return;
  }
  element[TrackChanges] = {
    previousValue: String(element.value),
    tracked: []
  };
}
__name(startTrackValue, "startTrackValue");
function trackOrSetValue(element, v2) {
  var _element_TrackChanges_tracked, _element_TrackChanges;
  (_element_TrackChanges = element[TrackChanges]) === null || _element_TrackChanges === void 0 ? void 0 : (_element_TrackChanges_tracked = _element_TrackChanges.tracked) === null || _element_TrackChanges_tracked === void 0 ? void 0 : _element_TrackChanges_tracked.push(v2);
  if (!element[TrackChanges]) {
    setUIValueClean(element);
    setUISelection(element, {
      focusOffset: v2.length
    });
  }
}
__name(trackOrSetValue, "trackOrSetValue");
function commitValueAfterInput(element, cursorOffset) {
  var _changes_tracked;
  const changes = element[TrackChanges];
  element[TrackChanges] = void 0;
  if (!(changes === null || changes === void 0 ? void 0 : (_changes_tracked = changes.tracked) === null || _changes_tracked === void 0 ? void 0 : _changes_tracked.length)) {
    return;
  }
  const isJustReactStateUpdate = changes.tracked.length === 2 && changes.tracked[0] === changes.previousValue && changes.tracked[1] === element.value;
  if (!isJustReactStateUpdate) {
    setUIValueClean(element);
  }
  if (hasUISelection(element)) {
    setUISelection(element, {
      focusOffset: isJustReactStateUpdate ? cursorOffset : element.value.length
    });
  }
}
__name(commitValueAfterInput, "commitValueAfterInput");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/getTargetTypeAndSelection.js
function getTargetTypeAndSelection(node) {
  const element = getElement2(node);
  if (element && hasOwnSelection(element)) {
    return {
      type: "input",
      selection: getUISelection(element)
    };
  }
  const selection = element === null || element === void 0 ? void 0 : element.ownerDocument.getSelection();
  const isCE = getContentEditable(node) && (selection === null || selection === void 0 ? void 0 : selection.anchorNode) && getContentEditable(selection.anchorNode);
  return {
    type: isCE ? "contenteditable" : "default",
    selection
  };
}
__name(getTargetTypeAndSelection, "getTargetTypeAndSelection");
function getElement2(node) {
  return node.nodeType === 1 ? node : node.parentElement;
}
__name(getElement2, "getElement");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/getInputRange.js
function getInputRange(focusNode) {
  const typeAndSelection = getTargetTypeAndSelection(focusNode);
  if (typeAndSelection.type === "input") {
    return typeAndSelection.selection;
  } else if (typeAndSelection.type === "contenteditable") {
    var _typeAndSelection_selection;
    return (_typeAndSelection_selection = typeAndSelection.selection) === null || _typeAndSelection_selection === void 0 ? void 0 : _typeAndSelection_selection.getRangeAt(0);
  }
}
__name(getInputRange, "getInputRange");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/setSelection.js
function setSelection({ focusNode, focusOffset, anchorNode = focusNode, anchorOffset = focusOffset }) {
  var _anchorNode_ownerDocument_getSelection, _anchorNode_ownerDocument;
  const typeAndSelection = getTargetTypeAndSelection(focusNode);
  if (typeAndSelection.type === "input") {
    return setUISelection(focusNode, {
      anchorOffset,
      focusOffset
    });
  }
  (_anchorNode_ownerDocument = anchorNode.ownerDocument) === null || _anchorNode_ownerDocument === void 0 ? void 0 : (_anchorNode_ownerDocument_getSelection = _anchorNode_ownerDocument.getSelection()) === null || _anchorNode_ownerDocument_getSelection === void 0 ? void 0 : _anchorNode_ownerDocument_getSelection.setBaseAndExtent(anchorNode, anchorOffset, focusNode, focusOffset);
}
__name(setSelection, "setSelection");

// ../node_modules/@testing-library/user-event/dist/esm/event/input.js
function isDateOrTime(element) {
  return isElementType(element, "input") && [
    "date",
    "time"
  ].includes(element.type);
}
__name(isDateOrTime, "isDateOrTime");
function input(instance, element, data, inputType = "insertText") {
  const inputRange = getInputRange(element);
  if (!inputRange) {
    return;
  }
  if (!isDateOrTime(element)) {
    const unprevented = instance.dispatchUIEvent(element, "beforeinput", {
      inputType,
      data
    });
    if (!unprevented) {
      return;
    }
  }
  if ("startContainer" in inputRange) {
    editContenteditable(instance, element, inputRange, data, inputType);
  } else {
    editInputElement(instance, element, inputRange, data, inputType);
  }
}
__name(input, "input");
function editContenteditable(instance, element, inputRange, data, inputType) {
  let del = false;
  if (!inputRange.collapsed) {
    del = true;
    inputRange.deleteContents();
  } else if ([
    "deleteContentBackward",
    "deleteContentForward"
  ].includes(inputType)) {
    const nextPosition = getNextCursorPosition(inputRange.startContainer, inputRange.startOffset, inputType === "deleteContentBackward" ? -1 : 1, inputType);
    if (nextPosition) {
      del = true;
      const delRange = inputRange.cloneRange();
      if (delRange.comparePoint(nextPosition.node, nextPosition.offset) < 0) {
        delRange.setStart(nextPosition.node, nextPosition.offset);
      } else {
        delRange.setEnd(nextPosition.node, nextPosition.offset);
      }
      delRange.deleteContents();
    }
  }
  if (data) {
    if (inputRange.endContainer.nodeType === 3) {
      const offset = inputRange.endOffset;
      inputRange.endContainer.insertData(offset, data);
      inputRange.setStart(inputRange.endContainer, offset + data.length);
      inputRange.setEnd(inputRange.endContainer, offset + data.length);
    } else {
      const text = element.ownerDocument.createTextNode(data);
      inputRange.insertNode(text);
      inputRange.setStart(text, data.length);
      inputRange.setEnd(text, data.length);
    }
  }
  if (del || data) {
    instance.dispatchUIEvent(element, "input", {
      inputType
    });
  }
}
__name(editContenteditable, "editContenteditable");
function editInputElement(instance, element, inputRange, data, inputType) {
  let dataToInsert = data;
  if (supportsMaxLength(element)) {
    const maxLength = getMaxLength(element);
    if (maxLength !== void 0 && data.length > 0) {
      const spaceUntilMaxLength = maxLength - element.value.length;
      if (spaceUntilMaxLength > 0) {
        dataToInsert = data.substring(0, spaceUntilMaxLength);
      } else {
        return;
      }
    }
  }
  const { newValue, newOffset, oldValue } = calculateNewValue(dataToInsert, element, inputRange, inputType);
  if (newValue === oldValue && newOffset === inputRange.startOffset && newOffset === inputRange.endOffset) {
    return;
  }
  if (isElementType(element, "input", {
    type: "number"
  }) && !isValidNumberInput(newValue)) {
    return;
  }
  setUIValue(element, newValue);
  setSelection({
    focusNode: element,
    anchorOffset: newOffset,
    focusOffset: newOffset
  });
  if (isDateOrTime(element)) {
    if (isValidDateOrTimeValue(element, newValue)) {
      commitInput(instance, element, newOffset, {});
      instance.dispatchUIEvent(element, "change");
      clearInitialValue(element);
    }
  } else {
    commitInput(instance, element, newOffset, {
      data,
      inputType
    });
  }
}
__name(editInputElement, "editInputElement");
function calculateNewValue(inputData, node, { startOffset, endOffset }, inputType) {
  const value = getUIValue(node);
  const prologEnd = Math.max(0, startOffset === endOffset && inputType === "deleteContentBackward" ? startOffset - 1 : startOffset);
  const prolog = value.substring(0, prologEnd);
  const epilogStart = Math.min(value.length, startOffset === endOffset && inputType === "deleteContentForward" ? startOffset + 1 : endOffset);
  const epilog = value.substring(epilogStart, value.length);
  let newValue = `${prolog}${inputData}${epilog}`;
  let newOffset = prologEnd + inputData.length;
  if (isElementType(node, "input", {
    type: "time"
  })) {
    const builtValue = buildTimeValue(newValue);
    if (builtValue !== "" && isValidDateOrTimeValue(node, builtValue)) {
      newValue = builtValue;
      newOffset = builtValue.length;
    }
  }
  return {
    oldValue: value,
    newValue,
    newOffset
  };
}
__name(calculateNewValue, "calculateNewValue");
function commitInput(instance, element, newOffset, inputInit) {
  instance.dispatchUIEvent(element, "input", inputInit);
  commitValueAfterInput(element, newOffset);
}
__name(commitInput, "commitInput");
function isValidNumberInput(value) {
  var _value_match, _value_match1;
  const valueParts = value.split("e", 2);
  return !(/[^\d.\-e]/.test(value) || Number((_value_match = value.match(/-/g)) === null || _value_match === void 0 ? void 0 : _value_match.length) > 2 || Number((_value_match1 = value.match(/\./g)) === null || _value_match1 === void 0 ? void 0 : _value_match1.length) > 1 || valueParts[1] && !/^-?\d*$/.test(valueParts[1]));
}
__name(isValidNumberInput, "isValidNumberInput");

// ../node_modules/@testing-library/user-event/dist/esm/event/behavior/cut.js
behavior.cut = (event, target, instance) => {
  return () => {
    if (isEditable(target)) {
      input(instance, target, "", "deleteByCut");
    }
  };
};

// ../node_modules/@testing-library/user-event/dist/esm/document/getValueOrTextContent.js
function getValueOrTextContent(element) {
  if (!element) {
    return null;
  }
  if (isContentEditable(element)) {
    return element.textContent;
  }
  return getUIValue(element);
}
__name(getValueOrTextContent, "getValueOrTextContent");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/isVisible.js
function isVisible(element) {
  const window2 = getWindow(element);
  for (let el = element; el === null || el === void 0 ? void 0 : el.ownerDocument; el = el.parentElement) {
    const { display: display2, visibility } = window2.getComputedStyle(el);
    if (display2 === "none") {
      return false;
    }
    if (visibility === "hidden") {
      return false;
    }
  }
  return true;
}
__name(isVisible, "isVisible");

// ../node_modules/@testing-library/user-event/dist/esm/utils/focus/getTabDestination.js
function getTabDestination(activeElement, shift) {
  const document2 = activeElement.ownerDocument;
  const focusableElements = document2.querySelectorAll(FOCUSABLE_SELECTOR);
  const enabledElements = Array.from(focusableElements).filter((el) => el === activeElement || !(Number(el.getAttribute("tabindex")) < 0 || isDisabled2(el)));
  if (Number(activeElement.getAttribute("tabindex")) >= 0) {
    enabledElements.sort((a, b2) => {
      const i2 = Number(a.getAttribute("tabindex"));
      const j2 = Number(b2.getAttribute("tabindex"));
      if (i2 === j2) {
        return 0;
      } else if (i2 === 0) {
        return 1;
      } else if (j2 === 0) {
        return -1;
      }
      return i2 - j2;
    });
  }
  const checkedRadio = {};
  let prunedElements = [
    document2.body
  ];
  const activeRadioGroup = isElementType(activeElement, "input", {
    type: "radio"
  }) ? activeElement.name : void 0;
  enabledElements.forEach((currentElement) => {
    const el = currentElement;
    if (isElementType(el, "input", {
      type: "radio"
    }) && el.name) {
      if (el === activeElement) {
        prunedElements.push(el);
        return;
      } else if (el.name === activeRadioGroup) {
        return;
      }
      if (el.checked) {
        prunedElements = prunedElements.filter((e2) => !isElementType(e2, "input", {
          type: "radio",
          name: el.name
        }));
        prunedElements.push(el);
        checkedRadio[el.name] = el;
        return;
      }
      if (typeof checkedRadio[el.name] !== "undefined") {
        return;
      }
    }
    prunedElements.push(el);
  });
  for (let index = prunedElements.findIndex((el) => el === activeElement); ; ) {
    index += shift ? -1 : 1;
    if (index === prunedElements.length) {
      index = 0;
    } else if (index === -1) {
      index = prunedElements.length - 1;
    }
    if (prunedElements[index] === activeElement || prunedElements[index] === document2.body || isVisible(prunedElements[index])) {
      return prunedElements[index];
    }
  }
}
__name(getTabDestination, "getTabDestination");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/moveSelection.js
function moveSelection(node, direction) {
  if (hasOwnSelection(node)) {
    const selection = getUISelection(node);
    setSelection({
      focusNode: node,
      focusOffset: selection.startOffset === selection.endOffset ? selection.focusOffset + direction : direction < 0 ? selection.startOffset : selection.endOffset
    });
  } else {
    const selection = node.ownerDocument.getSelection();
    if (!(selection === null || selection === void 0 ? void 0 : selection.focusNode)) {
      return;
    }
    if (selection.isCollapsed) {
      const nextPosition = getNextCursorPosition(selection.focusNode, selection.focusOffset, direction);
      if (nextPosition) {
        setSelection({
          focusNode: nextPosition.node,
          focusOffset: nextPosition.offset
        });
      }
    } else {
      selection[direction < 0 ? "collapseToStart" : "collapseToEnd"]();
    }
  }
}
__name(moveSelection, "moveSelection");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/selectAll.js
function selectAll(target) {
  if (hasOwnSelection(target)) {
    return setSelection({
      focusNode: target,
      anchorOffset: 0,
      focusOffset: getUIValue(target).length
    });
  }
  var _getContentEditable;
  const focusNode = (_getContentEditable = getContentEditable(target)) !== null && _getContentEditable !== void 0 ? _getContentEditable : target.ownerDocument.body;
  setSelection({
    focusNode,
    anchorOffset: 0,
    focusOffset: focusNode.childNodes.length
  });
}
__name(selectAll, "selectAll");
function isAllSelected(target) {
  if (hasOwnSelection(target)) {
    return getUISelection(target).startOffset === 0 && getUISelection(target).endOffset === getUIValue(target).length;
  }
  var _getContentEditable;
  const focusNode = (_getContentEditable = getContentEditable(target)) !== null && _getContentEditable !== void 0 ? _getContentEditable : target.ownerDocument.body;
  const selection = target.ownerDocument.getSelection();
  return (selection === null || selection === void 0 ? void 0 : selection.anchorNode) === focusNode && selection.focusNode === focusNode && selection.anchorOffset === 0 && selection.focusOffset === focusNode.childNodes.length;
}
__name(isAllSelected, "isAllSelected");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/setSelectionRange.js
function setSelectionRange(element, anchorOffset, focusOffset) {
  var _element_firstChild;
  if (hasOwnSelection(element)) {
    return setSelection({
      focusNode: element,
      anchorOffset,
      focusOffset
    });
  }
  if (isContentEditable(element) && ((_element_firstChild = element.firstChild) === null || _element_firstChild === void 0 ? void 0 : _element_firstChild.nodeType) === 3) {
    return setSelection({
      focusNode: element.firstChild,
      anchorOffset,
      focusOffset
    });
  }
  throw new Error("Not implemented. The result of this interaction is unreliable.");
}
__name(setSelectionRange, "setSelectionRange");

// ../node_modules/@testing-library/user-event/dist/esm/event/radio.js
function walkRadio(instance, el, direction) {
  const window2 = getWindow(el);
  const group = Array.from(el.ownerDocument.querySelectorAll(el.name ? `input[type="radio"][name="${window2.CSS.escape(el.name)}"]` : `input[type="radio"][name=""], input[type="radio"]:not([name])`));
  for (let i2 = group.findIndex((e2) => e2 === el) + direction; ; i2 += direction) {
    if (!group[i2]) {
      i2 = direction > 0 ? 0 : group.length - 1;
    }
    if (group[i2] === el) {
      return;
    }
    if (isDisabled2(group[i2])) {
      continue;
    }
    focusElement(group[i2]);
    instance.dispatchUIEvent(group[i2], "click");
    return;
  }
}
__name(walkRadio, "walkRadio");

// ../node_modules/@testing-library/user-event/dist/esm/event/behavior/keydown.js
behavior.keydown = (event, target, instance) => {
  var _keydownBehavior_event_key;
  var _keydownBehavior_event_key1;
  return (_keydownBehavior_event_key1 = (_keydownBehavior_event_key = keydownBehavior[event.key]) === null || _keydownBehavior_event_key === void 0 ? void 0 : _keydownBehavior_event_key.call(keydownBehavior, event, target, instance)) !== null && _keydownBehavior_event_key1 !== void 0 ? _keydownBehavior_event_key1 : combinationBehavior(event, target, instance);
};
var keydownBehavior = {
  ArrowDown: /* @__PURE__ */ __name((event, target, instance) => {
    if (isElementType(target, "input", {
      type: "radio"
    })) {
      return () => walkRadio(instance, target, 1);
    }
  }, "ArrowDown"),
  ArrowLeft: /* @__PURE__ */ __name((event, target, instance) => {
    if (isElementType(target, "input", {
      type: "radio"
    })) {
      return () => walkRadio(instance, target, -1);
    }
    return () => moveSelection(target, -1);
  }, "ArrowLeft"),
  ArrowRight: /* @__PURE__ */ __name((event, target, instance) => {
    if (isElementType(target, "input", {
      type: "radio"
    })) {
      return () => walkRadio(instance, target, 1);
    }
    return () => moveSelection(target, 1);
  }, "ArrowRight"),
  ArrowUp: /* @__PURE__ */ __name((event, target, instance) => {
    if (isElementType(target, "input", {
      type: "radio"
    })) {
      return () => walkRadio(instance, target, -1);
    }
  }, "ArrowUp"),
  Backspace: /* @__PURE__ */ __name((event, target, instance) => {
    if (isEditable(target)) {
      return () => {
        input(instance, target, "", "deleteContentBackward");
      };
    }
  }, "Backspace"),
  Delete: /* @__PURE__ */ __name((event, target, instance) => {
    if (isEditable(target)) {
      return () => {
        input(instance, target, "", "deleteContentForward");
      };
    }
  }, "Delete"),
  End: /* @__PURE__ */ __name((event, target) => {
    if (isElementType(target, [
      "input",
      "textarea"
    ]) || isContentEditable(target)) {
      return () => {
        var _getValueOrTextContent;
        var _getValueOrTextContent_length;
        const newPos = (_getValueOrTextContent_length = (_getValueOrTextContent = getValueOrTextContent(target)) === null || _getValueOrTextContent === void 0 ? void 0 : _getValueOrTextContent.length) !== null && _getValueOrTextContent_length !== void 0 ? _getValueOrTextContent_length : (
          /* istanbul ignore next */
          0
        );
        setSelectionRange(target, newPos, newPos);
      };
    }
  }, "End"),
  Home: /* @__PURE__ */ __name((event, target) => {
    if (isElementType(target, [
      "input",
      "textarea"
    ]) || isContentEditable(target)) {
      return () => {
        setSelectionRange(target, 0, 0);
      };
    }
  }, "Home"),
  PageDown: /* @__PURE__ */ __name((event, target) => {
    if (isElementType(target, [
      "input"
    ])) {
      return () => {
        const newPos = getUIValue(target).length;
        setSelectionRange(target, newPos, newPos);
      };
    }
  }, "PageDown"),
  PageUp: /* @__PURE__ */ __name((event, target) => {
    if (isElementType(target, [
      "input"
    ])) {
      return () => {
        setSelectionRange(target, 0, 0);
      };
    }
  }, "PageUp"),
  Tab: /* @__PURE__ */ __name((event, target, instance) => {
    return () => {
      const dest = getTabDestination(target, instance.system.keyboard.modifiers.Shift);
      focusElement(dest);
      if (hasOwnSelection(dest)) {
        setUISelection(dest, {
          anchorOffset: 0,
          focusOffset: dest.value.length
        });
      }
    };
  }, "Tab")
};
var combinationBehavior = /* @__PURE__ */ __name((event, target, instance) => {
  if (event.code === "KeyA" && instance.system.keyboard.modifiers.Control) {
    return () => selectAll(target);
  }
}, "combinationBehavior");

// ../node_modules/@testing-library/user-event/dist/esm/event/behavior/keypress.js
behavior.keypress = (event, target, instance) => {
  if (event.key === "Enter") {
    if (isElementType(target, "button") || isElementType(target, "input") && ClickInputOnEnter.includes(target.type) || isElementType(target, "a") && Boolean(target.href)) {
      return () => {
        instance.dispatchUIEvent(target, "click");
      };
    } else if (isElementType(target, "input")) {
      const form = target.form;
      const submit = form === null || form === void 0 ? void 0 : form.querySelector('input[type="submit"], button:not([type]), button[type="submit"]');
      if (submit) {
        return () => instance.dispatchUIEvent(submit, "click");
      } else if (form && SubmitSingleInputOnEnter.includes(target.type) && form.querySelectorAll("input").length === 1) {
        return () => instance.dispatchUIEvent(form, "submit");
      } else {
        return;
      }
    }
  }
  if (isEditable(target)) {
    const inputType = event.key === "Enter" ? isContentEditable(target) && !instance.system.keyboard.modifiers.Shift ? "insertParagraph" : "insertLineBreak" : "insertText";
    const inputData = event.key === "Enter" ? "\n" : event.key;
    return () => input(instance, target, inputData, inputType);
  }
};
var ClickInputOnEnter = [
  "button",
  "color",
  "file",
  "image",
  "reset",
  "submit"
];
var SubmitSingleInputOnEnter = [
  "email",
  "month",
  "password",
  "search",
  "tel",
  "text",
  "url",
  "week"
];

// ../node_modules/@testing-library/user-event/dist/esm/event/behavior/keyup.js
behavior.keyup = (event, target, instance) => {
  var _keyupBehavior_event_key;
  return (_keyupBehavior_event_key = keyupBehavior[event.key]) === null || _keyupBehavior_event_key === void 0 ? void 0 : _keyupBehavior_event_key.call(keyupBehavior, event, target, instance);
};
var keyupBehavior = {
  " ": /* @__PURE__ */ __name((event, target, instance) => {
    if (isClickableInput(target)) {
      return () => instance.dispatchUIEvent(target, "click");
    }
  }, " ")
};

// ../node_modules/@testing-library/user-event/dist/esm/event/behavior/paste.js
behavior.paste = (event, target, instance) => {
  if (isEditable(target)) {
    return () => {
      var _event_clipboardData;
      const insertData = (_event_clipboardData = event.clipboardData) === null || _event_clipboardData === void 0 ? void 0 : _event_clipboardData.getData("text");
      if (insertData) {
        input(instance, target, insertData, "insertFromPaste");
      }
    };
  }
};

// ../node_modules/@testing-library/user-event/dist/esm/event/eventMap.js
var eventMap2 = {
  auxclick: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  beforeinput: {
    EventType: "InputEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  blur: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  click: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  contextmenu: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  copy: {
    EventType: "ClipboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  change: {
    EventType: "Event",
    defaultInit: {
      bubbles: true,
      cancelable: false
    }
  },
  cut: {
    EventType: "ClipboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  dblclick: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  focus: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  focusin: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  focusout: {
    EventType: "FocusEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  keydown: {
    EventType: "KeyboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  keypress: {
    EventType: "KeyboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  keyup: {
    EventType: "KeyboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  paste: {
    EventType: "ClipboardEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  input: {
    EventType: "InputEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  mousedown: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseenter: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  mouseleave: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false,
      composed: true
    }
  },
  mousemove: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseout: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseover: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  mouseup: {
    EventType: "MouseEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerover: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerenter: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  pointerdown: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointermove: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerup: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointercancel: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: false,
      composed: true
    }
  },
  pointerout: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: true,
      cancelable: true,
      composed: true
    }
  },
  pointerleave: {
    EventType: "PointerEvent",
    defaultInit: {
      bubbles: false,
      cancelable: false
    }
  },
  submit: {
    EventType: "Event",
    defaultInit: {
      bubbles: true,
      cancelable: true
    }
  }
};
function getEventClass(type5) {
  return eventMap2[type5].EventType;
}
__name(getEventClass, "getEventClass");
var mouseEvents = [
  "MouseEvent",
  "PointerEvent"
];
function isMouseEvent(type5) {
  return mouseEvents.includes(getEventClass(type5));
}
__name(isMouseEvent, "isMouseEvent");
function isKeyboardEvent(type5) {
  return getEventClass(type5) === "KeyboardEvent";
}
__name(isKeyboardEvent, "isKeyboardEvent");

// ../node_modules/@testing-library/user-event/dist/esm/event/createEvent.js
var eventInitializer = {
  ClipboardEvent: [
    initClipboardEvent
  ],
  Event: [],
  FocusEvent: [
    initUIEvent,
    initFocusEvent
  ],
  InputEvent: [
    initUIEvent,
    initInputEvent
  ],
  MouseEvent: [
    initUIEvent,
    initUIEventModifiers,
    initMouseEvent
  ],
  PointerEvent: [
    initUIEvent,
    initUIEventModifiers,
    initMouseEvent,
    initPointerEvent
  ],
  KeyboardEvent: [
    initUIEvent,
    initUIEventModifiers,
    initKeyboardEvent
  ]
};
function createEvent2(type5, target, init) {
  const window2 = getWindow(target);
  const { EventType, defaultInit } = eventMap2[type5];
  const event = new (getEventConstructors(window2))[EventType](type5, defaultInit);
  eventInitializer[EventType].forEach((f3) => f3(event, init !== null && init !== void 0 ? init : {}));
  return event;
}
__name(createEvent2, "createEvent");
function getEventConstructors(window2) {
  var _a3, _b, _c, _d, _e2, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o;
  var _window_Event;
  const Event = (_window_Event = window2.Event) !== null && _window_Event !== void 0 ? _window_Event : (_a3 = class {
  }, __name(_a3, "Event"), _a3);
  var _window_AnimationEvent;
  const AnimationEvent = (_window_AnimationEvent = window2.AnimationEvent) !== null && _window_AnimationEvent !== void 0 ? _window_AnimationEvent : (_b = class extends Event {
  }, __name(_b, "AnimationEvent"), _b);
  var _window_ClipboardEvent;
  const ClipboardEvent = (_window_ClipboardEvent = window2.ClipboardEvent) !== null && _window_ClipboardEvent !== void 0 ? _window_ClipboardEvent : (_c = class extends Event {
  }, __name(_c, "ClipboardEvent"), _c);
  var _window_PopStateEvent;
  const PopStateEvent = (_window_PopStateEvent = window2.PopStateEvent) !== null && _window_PopStateEvent !== void 0 ? _window_PopStateEvent : (_d = class extends Event {
  }, __name(_d, "PopStateEvent"), _d);
  var _window_ProgressEvent;
  const ProgressEvent = (_window_ProgressEvent = window2.ProgressEvent) !== null && _window_ProgressEvent !== void 0 ? _window_ProgressEvent : (_e2 = class extends Event {
  }, __name(_e2, "ProgressEvent"), _e2);
  var _window_TransitionEvent;
  const TransitionEvent = (_window_TransitionEvent = window2.TransitionEvent) !== null && _window_TransitionEvent !== void 0 ? _window_TransitionEvent : (_f = class extends Event {
  }, __name(_f, "TransitionEvent"), _f);
  var _window_UIEvent;
  const UIEvent = (_window_UIEvent = window2.UIEvent) !== null && _window_UIEvent !== void 0 ? _window_UIEvent : (_g = class extends Event {
  }, __name(_g, "UIEvent"), _g);
  var _window_CompositionEvent;
  const CompositionEvent = (_window_CompositionEvent = window2.CompositionEvent) !== null && _window_CompositionEvent !== void 0 ? _window_CompositionEvent : (_h = class extends UIEvent {
  }, __name(_h, "CompositionEvent"), _h);
  var _window_FocusEvent;
  const FocusEvent = (_window_FocusEvent = window2.FocusEvent) !== null && _window_FocusEvent !== void 0 ? _window_FocusEvent : (_i = class extends UIEvent {
  }, __name(_i, "FocusEvent"), _i);
  var _window_InputEvent;
  const InputEvent = (_window_InputEvent = window2.InputEvent) !== null && _window_InputEvent !== void 0 ? _window_InputEvent : (_j = class extends UIEvent {
  }, __name(_j, "InputEvent"), _j);
  var _window_KeyboardEvent;
  const KeyboardEvent = (_window_KeyboardEvent = window2.KeyboardEvent) !== null && _window_KeyboardEvent !== void 0 ? _window_KeyboardEvent : (_k = class extends UIEvent {
  }, __name(_k, "KeyboardEvent"), _k);
  var _window_MouseEvent;
  const MouseEvent = (_window_MouseEvent = window2.MouseEvent) !== null && _window_MouseEvent !== void 0 ? _window_MouseEvent : (_l = class extends UIEvent {
  }, __name(_l, "MouseEvent"), _l);
  var _window_DragEvent;
  const DragEvent = (_window_DragEvent = window2.DragEvent) !== null && _window_DragEvent !== void 0 ? _window_DragEvent : (_m = class extends MouseEvent {
  }, __name(_m, "DragEvent"), _m);
  var _window_PointerEvent;
  const PointerEvent = (_window_PointerEvent = window2.PointerEvent) !== null && _window_PointerEvent !== void 0 ? _window_PointerEvent : (_n = class extends MouseEvent {
  }, __name(_n, "PointerEvent"), _n);
  var _window_TouchEvent;
  const TouchEvent = (_window_TouchEvent = window2.TouchEvent) !== null && _window_TouchEvent !== void 0 ? _window_TouchEvent : (_o = class extends UIEvent {
  }, __name(_o, "TouchEvent"), _o);
  return {
    Event,
    AnimationEvent,
    ClipboardEvent,
    PopStateEvent,
    ProgressEvent,
    TransitionEvent,
    UIEvent,
    CompositionEvent,
    FocusEvent,
    InputEvent,
    KeyboardEvent,
    MouseEvent,
    DragEvent,
    PointerEvent,
    TouchEvent
  };
}
__name(getEventConstructors, "getEventConstructors");
function assignProps(obj, props) {
  for (const [key, value] of Object.entries(props)) {
    Object.defineProperty(obj, key, {
      get: /* @__PURE__ */ __name(() => value !== null && value !== void 0 ? value : null, "get")
    });
  }
}
__name(assignProps, "assignProps");
function sanitizeNumber(n2) {
  return Number(n2 !== null && n2 !== void 0 ? n2 : 0);
}
__name(sanitizeNumber, "sanitizeNumber");
function initClipboardEvent(event, { clipboardData }) {
  assignProps(event, {
    clipboardData
  });
}
__name(initClipboardEvent, "initClipboardEvent");
function initFocusEvent(event, { relatedTarget }) {
  assignProps(event, {
    relatedTarget
  });
}
__name(initFocusEvent, "initFocusEvent");
function initInputEvent(event, { data, inputType, isComposing }) {
  assignProps(event, {
    data,
    isComposing: Boolean(isComposing),
    inputType: String(inputType)
  });
}
__name(initInputEvent, "initInputEvent");
function initUIEvent(event, { view, detail }) {
  assignProps(event, {
    view,
    detail: sanitizeNumber(detail !== null && detail !== void 0 ? detail : 0)
  });
}
__name(initUIEvent, "initUIEvent");
function initUIEventModifiers(event, { altKey, ctrlKey, metaKey, shiftKey, modifierAltGraph, modifierCapsLock, modifierFn, modifierFnLock, modifierNumLock, modifierScrollLock, modifierSymbol, modifierSymbolLock }) {
  assignProps(event, {
    altKey: Boolean(altKey),
    ctrlKey: Boolean(ctrlKey),
    metaKey: Boolean(metaKey),
    shiftKey: Boolean(shiftKey),
    getModifierState(k2) {
      return Boolean({
        Alt: altKey,
        AltGraph: modifierAltGraph,
        CapsLock: modifierCapsLock,
        Control: ctrlKey,
        Fn: modifierFn,
        FnLock: modifierFnLock,
        Meta: metaKey,
        NumLock: modifierNumLock,
        ScrollLock: modifierScrollLock,
        Shift: shiftKey,
        Symbol: modifierSymbol,
        SymbolLock: modifierSymbolLock
      }[k2]);
    }
  });
}
__name(initUIEventModifiers, "initUIEventModifiers");
function initKeyboardEvent(event, { key, code, location, repeat, isComposing, charCode }) {
  assignProps(event, {
    key: String(key),
    code: String(code),
    location: sanitizeNumber(location),
    repeat: Boolean(repeat),
    isComposing: Boolean(isComposing),
    charCode
  });
}
__name(initKeyboardEvent, "initKeyboardEvent");
function initMouseEvent(event, { x: x2, y: y2, screenX, screenY, clientX = x2, clientY = y2, button, buttons, relatedTarget, offsetX, offsetY, pageX, pageY }) {
  assignProps(event, {
    screenX: sanitizeNumber(screenX),
    screenY: sanitizeNumber(screenY),
    clientX: sanitizeNumber(clientX),
    x: sanitizeNumber(clientX),
    clientY: sanitizeNumber(clientY),
    y: sanitizeNumber(clientY),
    button: sanitizeNumber(button),
    buttons: sanitizeNumber(buttons),
    relatedTarget,
    offsetX: sanitizeNumber(offsetX),
    offsetY: sanitizeNumber(offsetY),
    pageX: sanitizeNumber(pageX),
    pageY: sanitizeNumber(pageY)
  });
}
__name(initMouseEvent, "initMouseEvent");
function initPointerEvent(event, { pointerId, width, height, pressure, tangentialPressure, tiltX, tiltY, twist, pointerType, isPrimary }) {
  assignProps(event, {
    pointerId: sanitizeNumber(pointerId),
    width: sanitizeNumber(width !== null && width !== void 0 ? width : 1),
    height: sanitizeNumber(height !== null && height !== void 0 ? height : 1),
    pressure: sanitizeNumber(pressure),
    tangentialPressure: sanitizeNumber(tangentialPressure),
    tiltX: sanitizeNumber(tiltX),
    tiltY: sanitizeNumber(tiltY),
    twist: sanitizeNumber(twist),
    pointerType: String(pointerType),
    isPrimary: Boolean(isPrimary)
  });
}
__name(initPointerEvent, "initPointerEvent");

// ../node_modules/@testing-library/user-event/dist/esm/event/dispatchEvent.js
function dispatchUIEvent(target, type5, init, preventDefault = false) {
  if (isMouseEvent(type5) || isKeyboardEvent(type5)) {
    init = {
      ...init,
      ...this.system.getUIEventModifiers()
    };
  }
  const event = createEvent2(type5, target, init);
  return dispatchEvent.call(this, target, event, preventDefault);
}
__name(dispatchUIEvent, "dispatchUIEvent");
function dispatchEvent(target, event, preventDefault = false) {
  var _behavior_type;
  const type5 = event.type;
  const behaviorImplementation = preventDefault ? () => {
  } : (_behavior_type = behavior[type5]) === null || _behavior_type === void 0 ? void 0 : _behavior_type.call(behavior, event, target, this);
  if (behaviorImplementation) {
    event.preventDefault();
    let defaultPrevented = false;
    Object.defineProperty(event, "defaultPrevented", {
      get: /* @__PURE__ */ __name(() => defaultPrevented, "get")
    });
    Object.defineProperty(event, "preventDefault", {
      value: /* @__PURE__ */ __name(() => {
        defaultPrevented = event.cancelable;
      }, "value")
    });
    wrapEvent(() => target.dispatchEvent(event));
    if (!defaultPrevented) {
      behaviorImplementation();
    }
    return !defaultPrevented;
  }
  return wrapEvent(() => target.dispatchEvent(event));
}
__name(dispatchEvent, "dispatchEvent");
function dispatchDOMEvent(target, type5, init) {
  const event = createEvent2(type5, target, init);
  wrapEvent(() => target.dispatchEvent(event));
}
__name(dispatchDOMEvent, "dispatchDOMEvent");

// ../node_modules/@testing-library/user-event/dist/esm/document/patchFocus.js
var patched = Symbol("patched focus/blur methods");
function patchFocus(HTMLElement2) {
  if (HTMLElement2.prototype[patched]) {
    return;
  }
  const { focus, blur } = HTMLElement2.prototype;
  Object.defineProperties(HTMLElement2.prototype, {
    focus: {
      configurable: true,
      get: /* @__PURE__ */ __name(() => patchedFocus, "get")
    },
    blur: {
      configurable: true,
      get: /* @__PURE__ */ __name(() => patchedBlur, "get")
    },
    [patched]: {
      configurable: true,
      get: /* @__PURE__ */ __name(() => ({
        focus,
        blur
      }), "get")
    }
  });
  let activeCall;
  function patchedFocus(options) {
    if (this.ownerDocument.visibilityState !== "hidden") {
      return focus.call(this, options);
    }
    const blurred = getActiveTarget(this.ownerDocument);
    if (blurred === this) {
      return;
    }
    const thisCall = Symbol("focus call");
    activeCall = thisCall;
    if (blurred) {
      blur.call(blurred);
      dispatchDOMEvent(blurred, "blur", {
        relatedTarget: this
      });
      dispatchDOMEvent(blurred, "focusout", {
        relatedTarget: activeCall === thisCall ? this : null
      });
    }
    if (activeCall === thisCall) {
      focus.call(this, options);
      dispatchDOMEvent(this, "focus", {
        relatedTarget: blurred
      });
    }
    if (activeCall === thisCall) {
      dispatchDOMEvent(this, "focusin", {
        relatedTarget: blurred
      });
    }
  }
  __name(patchedFocus, "patchedFocus");
  function patchedBlur() {
    if (this.ownerDocument.visibilityState !== "hidden") {
      return blur.call(this);
    }
    const blurred = getActiveTarget(this.ownerDocument);
    if (blurred !== this) {
      return;
    }
    const thisCall = Symbol("blur call");
    activeCall = thisCall;
    blur.call(this);
    dispatchDOMEvent(blurred, "blur", {
      relatedTarget: null
    });
    dispatchDOMEvent(blurred, "focusout", {
      relatedTarget: null
    });
  }
  __name(patchedBlur, "patchedBlur");
}
__name(patchFocus, "patchFocus");
function getActiveTarget(document2) {
  const active = getActiveElement(document2);
  return (active === null || active === void 0 ? void 0 : active.tagName) === "BODY" ? null : active;
}
__name(getActiveTarget, "getActiveTarget");

// ../node_modules/@testing-library/user-event/dist/esm/document/interceptor.js
var Interceptor = Symbol("Interceptor for programmatical calls");
function prepareInterceptor(element, propName, interceptorImpl) {
  const prototypeDescriptor = Object.getOwnPropertyDescriptor(element.constructor.prototype, propName);
  const objectDescriptor = Object.getOwnPropertyDescriptor(element, propName);
  const target = (prototypeDescriptor === null || prototypeDescriptor === void 0 ? void 0 : prototypeDescriptor.set) ? "set" : "value";
  if (typeof (prototypeDescriptor === null || prototypeDescriptor === void 0 ? void 0 : prototypeDescriptor[target]) !== "function" || prototypeDescriptor[target][Interceptor]) {
    throw new Error(`Element ${element.tagName} does not implement "${String(propName)}".`);
  }
  function intercept(...args) {
    const { applyNative = false, realArgs, then } = interceptorImpl.call(this, ...args);
    const realFunc = (!applyNative && objectDescriptor || prototypeDescriptor)[target];
    if (target === "set") {
      realFunc.call(this, realArgs);
    } else {
      realFunc.call(this, ...realArgs);
    }
    then === null || then === void 0 ? void 0 : then();
  }
  __name(intercept, "intercept");
  intercept[Interceptor] = Interceptor;
  Object.defineProperty(element, propName, {
    ...objectDescriptor !== null && objectDescriptor !== void 0 ? objectDescriptor : prototypeDescriptor,
    [target]: intercept
  });
}
__name(prepareInterceptor, "prepareInterceptor");
function prepareValueInterceptor(element) {
  prepareInterceptor(element, "value", /* @__PURE__ */ __name(function interceptorImpl(v2) {
    const isUI = isUIValue(v2);
    if (isUI) {
      startTrackValue(this);
    }
    return {
      applyNative: !!isUI,
      realArgs: sanitizeValue(this, v2),
      then: isUI ? void 0 : () => trackOrSetValue(this, String(v2))
    };
  }, "interceptorImpl"));
}
__name(prepareValueInterceptor, "prepareValueInterceptor");
function sanitizeValue(element, v2) {
  if (isElementType(element, "input", {
    type: "number"
  }) && String(v2) !== "" && !Number.isNaN(Number(v2))) {
    return String(Number(v2));
  }
  return String(v2);
}
__name(sanitizeValue, "sanitizeValue");
function prepareSelectionInterceptor(element) {
  prepareInterceptor(element, "setSelectionRange", /* @__PURE__ */ __name(function interceptorImpl(start, ...others) {
    const isUI = isUISelectionStart(start);
    return {
      applyNative: !!isUI,
      realArgs: [
        Number(start),
        ...others
      ],
      then: /* @__PURE__ */ __name(() => isUI ? void 0 : setUISelectionClean(element), "then")
    };
  }, "interceptorImpl"));
  prepareInterceptor(element, "selectionStart", /* @__PURE__ */ __name(function interceptorImpl(v2) {
    return {
      realArgs: v2,
      then: /* @__PURE__ */ __name(() => setUISelectionClean(element), "then")
    };
  }, "interceptorImpl"));
  prepareInterceptor(element, "selectionEnd", /* @__PURE__ */ __name(function interceptorImpl(v2) {
    return {
      realArgs: v2,
      then: /* @__PURE__ */ __name(() => setUISelectionClean(element), "then")
    };
  }, "interceptorImpl"));
  prepareInterceptor(element, "select", /* @__PURE__ */ __name(function interceptorImpl() {
    return {
      realArgs: [],
      then: /* @__PURE__ */ __name(() => setUISelectionRaw(element, {
        anchorOffset: 0,
        focusOffset: getUIValue(element).length
      }), "then")
    };
  }, "interceptorImpl"));
}
__name(prepareSelectionInterceptor, "prepareSelectionInterceptor");
function prepareRangeTextInterceptor(element) {
  prepareInterceptor(element, "setRangeText", /* @__PURE__ */ __name(function interceptorImpl(...realArgs) {
    return {
      realArgs,
      then: /* @__PURE__ */ __name(() => {
        setUIValueClean(element);
        setUISelectionClean(element);
      }, "then")
    };
  }, "interceptorImpl"));
}
__name(prepareRangeTextInterceptor, "prepareRangeTextInterceptor");

// ../node_modules/@testing-library/user-event/dist/esm/document/prepareDocument.js
var isPrepared = Symbol("Node prepared with document state workarounds");
function prepareDocument(document2) {
  if (document2[isPrepared]) {
    return;
  }
  document2.addEventListener("focus", (e2) => {
    const el = e2.target;
    prepareElement(el);
  }, {
    capture: true,
    passive: true
  });
  if (document2.activeElement) {
    prepareElement(document2.activeElement);
  }
  document2.addEventListener("blur", (e2) => {
    const el = e2.target;
    const initialValue2 = getInitialValue(el);
    if (initialValue2 !== void 0) {
      if (el.value !== initialValue2) {
        dispatchDOMEvent(el, "change");
      }
      clearInitialValue(el);
    }
  }, {
    capture: true,
    passive: true
  });
  document2[isPrepared] = isPrepared;
}
__name(prepareDocument, "prepareDocument");
function prepareElement(el) {
  if (el[isPrepared]) {
    return;
  }
  if (isElementType(el, [
    "input",
    "textarea"
  ])) {
    prepareValueInterceptor(el);
    prepareSelectionInterceptor(el);
    prepareRangeTextInterceptor(el);
  }
  el[isPrepared] = isPrepared;
}
__name(prepareElement, "prepareElement");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/getDocumentFromNode.js
function getDocumentFromNode(el) {
  return isDocument2(el) ? el : el.ownerDocument;
}
__name(getDocumentFromNode, "getDocumentFromNode");
function isDocument2(node) {
  return node.nodeType === 9;
}
__name(isDocument2, "isDocument");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/level.js
var ApiLevel = function(ApiLevel2) {
  ApiLevel2[ApiLevel2["Trigger"] = 2] = "Trigger";
  ApiLevel2[ApiLevel2["Call"] = 1] = "Call";
  return ApiLevel2;
}({});
function setLevelRef(instance, level) {
  instance.levelRefs[level] = {};
}
__name(setLevelRef, "setLevelRef");
function getLevelRef(instance, level) {
  return instance.levelRefs[level];
}
__name(getLevelRef, "getLevelRef");

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/wait.js
function wait(config3) {
  const delay = config3.delay;
  if (typeof delay !== "number") {
    return;
  }
  return Promise.all([
    new Promise((resolve) => globalThis.setTimeout(() => resolve(), delay)),
    config3.advanceTimers(delay)
  ]);
}
__name(wait, "wait");

// ../node_modules/@testing-library/user-event/dist/esm/options.js
var PointerEventsCheckLevel = function(PointerEventsCheckLevel2) {
  PointerEventsCheckLevel2[PointerEventsCheckLevel2["EachTrigger"] = 4] = "EachTrigger";
  PointerEventsCheckLevel2[PointerEventsCheckLevel2["EachApiCall"] = 2] = "EachApiCall";
  PointerEventsCheckLevel2[PointerEventsCheckLevel2["EachTarget"] = 1] = "EachTarget";
  PointerEventsCheckLevel2[PointerEventsCheckLevel2["Never"] = 0] = "Never";
  return PointerEventsCheckLevel2;
}({});

// ../node_modules/@testing-library/user-event/dist/esm/system/keyboard.js
function _define_property3(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property3, "_define_property");
var DOM_KEY_LOCATION = function(DOM_KEY_LOCATION2) {
  DOM_KEY_LOCATION2[DOM_KEY_LOCATION2["STANDARD"] = 0] = "STANDARD";
  DOM_KEY_LOCATION2[DOM_KEY_LOCATION2["LEFT"] = 1] = "LEFT";
  DOM_KEY_LOCATION2[DOM_KEY_LOCATION2["RIGHT"] = 2] = "RIGHT";
  DOM_KEY_LOCATION2[DOM_KEY_LOCATION2["NUMPAD"] = 3] = "NUMPAD";
  return DOM_KEY_LOCATION2;
}({});
var modifierKeys = [
  "Alt",
  "AltGraph",
  "Control",
  "Fn",
  "Meta",
  "Shift",
  "Symbol"
];
function isModifierKey(key) {
  return modifierKeys.includes(key);
}
__name(isModifierKey, "isModifierKey");
var modifierLocks = [
  "CapsLock",
  "FnLock",
  "NumLock",
  "ScrollLock",
  "SymbolLock"
];
function isModifierLock(key) {
  return modifierLocks.includes(key);
}
__name(isModifierLock, "isModifierLock");
var _KeyboardHost = class _KeyboardHost {
  isKeyPressed(keyDef) {
    return this.pressed.has(String(keyDef.code));
  }
  getPressedKeys() {
    return this.pressed.values().map((p) => p.keyDef);
  }
  /** Press a key */
  async keydown(instance, keyDef) {
    const key = String(keyDef.key);
    const code = String(keyDef.code);
    const target = getActiveElementOrBody(instance.config.document);
    this.setKeydownTarget(target);
    this.pressed.add(code, keyDef);
    if (isModifierKey(key)) {
      this.modifiers[key] = true;
    }
    const unprevented = instance.dispatchUIEvent(target, "keydown", {
      key,
      code
    });
    if (isModifierLock(key) && !this.modifiers[key]) {
      this.modifiers[key] = true;
      this.modifierLockStart[key] = true;
    }
    if (unprevented) {
      this.pressed.setUnprevented(code);
    }
    if (unprevented && this.hasKeyPress(key)) {
      instance.dispatchUIEvent(getActiveElementOrBody(instance.config.document), "keypress", {
        key,
        code,
        charCode: keyDef.key === "Enter" ? 13 : String(keyDef.key).charCodeAt(0)
      });
    }
  }
  /** Release a key */
  async keyup(instance, keyDef) {
    const key = String(keyDef.key);
    const code = String(keyDef.code);
    const unprevented = this.pressed.isUnprevented(code);
    this.pressed.delete(code);
    if (isModifierKey(key) && !this.pressed.values().find((p) => p.keyDef.key === key)) {
      this.modifiers[key] = false;
    }
    instance.dispatchUIEvent(getActiveElementOrBody(instance.config.document), "keyup", {
      key,
      code
    }, !unprevented);
    if (isModifierLock(key) && this.modifiers[key]) {
      if (this.modifierLockStart[key]) {
        this.modifierLockStart[key] = false;
      } else {
        this.modifiers[key] = false;
      }
    }
  }
  setKeydownTarget(target) {
    if (target !== this.lastKeydownTarget) {
      this.carryChar = "";
    }
    this.lastKeydownTarget = target;
  }
  hasKeyPress(key) {
    return (key.length === 1 || key === "Enter") && !this.modifiers.Control && !this.modifiers.Alt;
  }
  constructor(system) {
    _define_property3(this, "system", void 0);
    _define_property3(this, "modifiers", {
      Alt: false,
      AltGraph: false,
      CapsLock: false,
      Control: false,
      Fn: false,
      FnLock: false,
      Meta: false,
      NumLock: false,
      ScrollLock: false,
      Shift: false,
      Symbol: false,
      SymbolLock: false
    });
    _define_property3(this, "pressed", new class {
      add(code, keyDef) {
        var _this_registry, _code;
        var _;
        (_ = (_this_registry = this.registry)[_code = code]) !== null && _ !== void 0 ? _ : _this_registry[_code] = {
          keyDef,
          unpreventedDefault: false
        };
      }
      has(code) {
        return !!this.registry[code];
      }
      setUnprevented(code) {
        const o2 = this.registry[code];
        if (o2) {
          o2.unpreventedDefault = true;
        }
      }
      isUnprevented(code) {
        var _this_registry_code;
        return !!((_this_registry_code = this.registry[code]) === null || _this_registry_code === void 0 ? void 0 : _this_registry_code.unpreventedDefault);
      }
      delete(code) {
        delete this.registry[code];
      }
      values() {
        return Object.values(this.registry);
      }
      constructor() {
        _define_property3(this, "registry", {});
      }
    }());
    _define_property3(this, "carryChar", "");
    _define_property3(this, "lastKeydownTarget", void 0);
    _define_property3(this, "modifierLockStart", {});
    this.system = system;
  }
};
__name(_KeyboardHost, "KeyboardHost");
var KeyboardHost = _KeyboardHost;

// ../node_modules/@testing-library/user-event/dist/esm/keyboard/keyMap.js
var defaultKeyMap = [
  // alphanumeric block - writing system
  ..."0123456789".split("").map((c2) => ({
    code: `Digit${c2}`,
    key: c2
  })),
  ...")!@#$%^&*(".split("").map((c2, i2) => ({
    code: `Digit${i2}`,
    key: c2,
    shiftKey: true
  })),
  ..."abcdefghijklmnopqrstuvwxyz".split("").map((c2) => ({
    code: `Key${c2.toUpperCase()}`,
    key: c2
  })),
  ..."ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("").map((c2) => ({
    code: `Key${c2}`,
    key: c2,
    shiftKey: true
  })),
  {
    code: "BracketLeft",
    key: "["
  },
  {
    code: "BracketLeft",
    key: "{",
    shiftKey: true
  },
  {
    code: "BracketRight",
    key: "]"
  },
  {
    code: "BracketRight",
    key: "}",
    shiftKey: true
  },
  // alphanumeric block - functional
  {
    code: "Space",
    key: " "
  },
  {
    code: "AltLeft",
    key: "Alt",
    location: DOM_KEY_LOCATION.LEFT
  },
  {
    code: "AltRight",
    key: "Alt",
    location: DOM_KEY_LOCATION.RIGHT
  },
  {
    code: "ShiftLeft",
    key: "Shift",
    location: DOM_KEY_LOCATION.LEFT
  },
  {
    code: "ShiftRight",
    key: "Shift",
    location: DOM_KEY_LOCATION.RIGHT
  },
  {
    code: "ControlLeft",
    key: "Control",
    location: DOM_KEY_LOCATION.LEFT
  },
  {
    code: "ControlRight",
    key: "Control",
    location: DOM_KEY_LOCATION.RIGHT
  },
  {
    code: "MetaLeft",
    key: "Meta",
    location: DOM_KEY_LOCATION.LEFT
  },
  {
    code: "MetaRight",
    key: "Meta",
    location: DOM_KEY_LOCATION.RIGHT
  },
  {
    code: "OSLeft",
    key: "OS",
    location: DOM_KEY_LOCATION.LEFT
  },
  {
    code: "OSRight",
    key: "OS",
    location: DOM_KEY_LOCATION.RIGHT
  },
  {
    code: "ContextMenu",
    key: "ContextMenu"
  },
  {
    code: "Tab",
    key: "Tab"
  },
  {
    code: "CapsLock",
    key: "CapsLock"
  },
  {
    code: "Backspace",
    key: "Backspace"
  },
  {
    code: "Enter",
    key: "Enter"
  },
  // function
  {
    code: "Escape",
    key: "Escape"
  },
  // arrows
  {
    code: "ArrowUp",
    key: "ArrowUp"
  },
  {
    code: "ArrowDown",
    key: "ArrowDown"
  },
  {
    code: "ArrowLeft",
    key: "ArrowLeft"
  },
  {
    code: "ArrowRight",
    key: "ArrowRight"
  },
  // control pad
  {
    code: "Home",
    key: "Home"
  },
  {
    code: "End",
    key: "End"
  },
  {
    code: "Delete",
    key: "Delete"
  },
  {
    code: "PageUp",
    key: "PageUp"
  },
  {
    code: "PageDown",
    key: "PageDown"
  },
  // Special keys that are not part of a default US-layout but included for specific behavior
  {
    code: "Fn",
    key: "Fn"
  },
  {
    code: "Symbol",
    key: "Symbol"
  },
  {
    code: "AltRight",
    key: "AltGraph"
  }
];

// ../node_modules/@testing-library/user-event/dist/esm/pointer/keyMap.js
var defaultKeyMap2 = [
  {
    name: "MouseLeft",
    pointerType: "mouse",
    button: "primary"
  },
  {
    name: "MouseRight",
    pointerType: "mouse",
    button: "secondary"
  },
  {
    name: "MouseMiddle",
    pointerType: "mouse",
    button: "auxiliary"
  },
  {
    name: "TouchA",
    pointerType: "touch"
  },
  {
    name: "TouchB",
    pointerType: "touch"
  },
  {
    name: "TouchC",
    pointerType: "touch"
  }
];

// ../node_modules/@testing-library/user-event/dist/esm/system/pointer/buttons.js
function _define_property4(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property4, "_define_property");
var _Buttons = class _Buttons {
  getButtons() {
    let v2 = 0;
    for (const button of Object.keys(this.pressed)) {
      v2 |= 2 ** Number(button);
    }
    return v2;
  }
  down(keyDef) {
    const button = getMouseButtonId(keyDef.button);
    if (button in this.pressed) {
      this.pressed[button].push(keyDef);
      return void 0;
    }
    this.pressed[button] = [
      keyDef
    ];
    return button;
  }
  up(keyDef) {
    const button = getMouseButtonId(keyDef.button);
    if (button in this.pressed) {
      this.pressed[button] = this.pressed[button].filter((k2) => k2.name !== keyDef.name);
      if (this.pressed[button].length === 0) {
        delete this.pressed[button];
        return button;
      }
    }
    return void 0;
  }
  constructor() {
    _define_property4(this, "pressed", {});
  }
};
__name(_Buttons, "Buttons");
var Buttons = _Buttons;
var MouseButton = {
  primary: 0,
  secondary: 1,
  auxiliary: 2,
  back: 3,
  X1: 3,
  forward: 4,
  X2: 4
};
function getMouseButtonId(button = 0) {
  if (button in MouseButton) {
    return MouseButton[button];
  }
  return Number(button);
}
__name(getMouseButtonId, "getMouseButtonId");
var MouseButtonFlip = {
  1: 2,
  2: 1
};
function getMouseEventButton(button) {
  button = getMouseButtonId(button);
  if (button in MouseButtonFlip) {
    return MouseButtonFlip[button];
  }
  return button;
}
__name(getMouseEventButton, "getMouseEventButton");

// ../node_modules/@testing-library/user-event/dist/esm/system/pointer/device.js
function _define_property5(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property5, "_define_property");
var _Device = class _Device {
  get countPressed() {
    return this.pressedKeys.size;
  }
  isPressed(keyDef) {
    return this.pressedKeys.has(keyDef.name);
  }
  addPressed(keyDef) {
    return this.pressedKeys.add(keyDef.name);
  }
  removePressed(keyDef) {
    return this.pressedKeys.delete(keyDef.name);
  }
  constructor() {
    _define_property5(this, "pressedKeys", /* @__PURE__ */ new Set());
  }
};
__name(_Device, "Device");
var Device = _Device;

// ../node_modules/@testing-library/user-event/dist/esm/utils/misc/getTreeDiff.js
function getTreeDiff(a, b2) {
  const treeA = [];
  for (let el = a; el; el = el.parentElement) {
    treeA.push(el);
  }
  const treeB = [];
  for (let el = b2; el; el = el.parentElement) {
    treeB.push(el);
  }
  let i2 = 0;
  for (; ; i2++) {
    if (i2 >= treeA.length || i2 >= treeB.length || treeA[treeA.length - 1 - i2] !== treeB[treeB.length - 1 - i2]) {
      break;
    }
  }
  return [
    treeA.slice(0, treeA.length - i2),
    treeB.slice(0, treeB.length - i2),
    treeB.slice(treeB.length - i2)
  ];
}
__name(getTreeDiff, "getTreeDiff");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/resolveCaretPosition.js
function resolveCaretPosition({ target, node, offset }) {
  if (hasOwnSelection(target)) {
    return {
      node: target,
      offset: offset !== null && offset !== void 0 ? offset : getUIValue(target).length
    };
  } else if (node) {
    return {
      node,
      offset: offset !== null && offset !== void 0 ? offset : node.nodeType === 3 ? node.nodeValue.length : node.childNodes.length
    };
  }
  return findNodeAtTextOffset(target, offset);
}
__name(resolveCaretPosition, "resolveCaretPosition");
function findNodeAtTextOffset(node, offset, isRoot = true) {
  let i2 = offset === void 0 ? node.childNodes.length - 1 : 0;
  const step = offset === void 0 ? -1 : 1;
  while (offset === void 0 ? i2 >= (isRoot ? Math.max(node.childNodes.length - 1, 0) : 0) : i2 <= node.childNodes.length) {
    if (offset && i2 === node.childNodes.length) {
      throw new Error("The given offset is out of bounds.");
    }
    const c2 = node.childNodes.item(i2);
    const text = String(c2.textContent);
    if (text.length) {
      if (offset !== void 0 && text.length < offset) {
        offset -= text.length;
      } else if (c2.nodeType === 1) {
        return findNodeAtTextOffset(c2, offset, false);
      } else {
        if (c2.nodeType === 3) {
          return {
            node: c2,
            offset: offset !== null && offset !== void 0 ? offset : c2.nodeValue.length
          };
        }
      }
    }
    i2 += step;
  }
  return {
    node,
    offset: node.childNodes.length
  };
}
__name(findNodeAtTextOffset, "findNodeAtTextOffset");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/setSelectionPerMouse.js
function setSelectionPerMouseDown({ document: document2, target, clickCount, node, offset }) {
  if (hasNoSelection(target)) {
    return;
  }
  const targetHasOwnSelection = hasOwnSelection(target);
  const text = String(targetHasOwnSelection ? getUIValue(target) : target.textContent);
  const [start, end] = node ? (
    // which elements might be considered in the same line of text.
    // TODO: support expanding initial range on multiple clicks if node is given
    [
      offset,
      offset
    ]
  ) : getTextRange(text, offset, clickCount);
  if (targetHasOwnSelection) {
    setUISelection(target, {
      anchorOffset: start !== null && start !== void 0 ? start : text.length,
      focusOffset: end !== null && end !== void 0 ? end : text.length
    });
    return {
      node: target,
      start: start !== null && start !== void 0 ? start : 0,
      end: end !== null && end !== void 0 ? end : text.length
    };
  } else {
    const { node: startNode, offset: startOffset } = resolveCaretPosition({
      target,
      node,
      offset: start
    });
    const { node: endNode, offset: endOffset } = resolveCaretPosition({
      target,
      node,
      offset: end
    });
    const range = target.ownerDocument.createRange();
    try {
      range.setStart(startNode, startOffset);
      range.setEnd(endNode, endOffset);
    } catch (e2) {
      throw new Error("The given offset is out of bounds.");
    }
    const selection = document2.getSelection();
    selection === null || selection === void 0 ? void 0 : selection.removeAllRanges();
    selection === null || selection === void 0 ? void 0 : selection.addRange(range.cloneRange());
    return range;
  }
}
__name(setSelectionPerMouseDown, "setSelectionPerMouseDown");
function getTextRange(text, pos, clickCount) {
  if (clickCount % 3 === 1 || text.length === 0) {
    return [
      pos,
      pos
    ];
  }
  const textPos = pos !== null && pos !== void 0 ? pos : text.length;
  if (clickCount % 3 === 2) {
    return [
      textPos - text.substr(0, pos).match(/(\w+|\s+|\W)?$/)[0].length,
      pos === void 0 ? pos : pos + text.substr(pos).match(/^(\w+|\s+|\W)?/)[0].length
    ];
  }
  return [
    textPos - text.substr(0, pos).match(/[^\r\n]*$/)[0].length,
    pos === void 0 ? pos : pos + text.substr(pos).match(/^[^\r\n]*/)[0].length
  ];
}
__name(getTextRange, "getTextRange");

// ../node_modules/@testing-library/user-event/dist/esm/event/selection/modifySelectionPerMouse.js
function modifySelectionPerMouseMove(selectionRange, { document: document2, target, node, offset }) {
  const selectionFocus = resolveCaretPosition({
    target,
    node,
    offset
  });
  if ("node" in selectionRange) {
    if (selectionFocus.node === selectionRange.node) {
      const anchorOffset = selectionFocus.offset < selectionRange.start ? selectionRange.end : selectionRange.start;
      const focusOffset = selectionFocus.offset > selectionRange.end || selectionFocus.offset < selectionRange.start ? selectionFocus.offset : selectionRange.end;
      setUISelection(selectionRange.node, {
        anchorOffset,
        focusOffset
      });
    }
  } else {
    const range = selectionRange.cloneRange();
    const cmp = range.comparePoint(selectionFocus.node, selectionFocus.offset);
    if (cmp < 0) {
      range.setStart(selectionFocus.node, selectionFocus.offset);
    } else if (cmp > 0) {
      range.setEnd(selectionFocus.node, selectionFocus.offset);
    }
    const selection = document2.getSelection();
    selection === null || selection === void 0 ? void 0 : selection.removeAllRanges();
    selection === null || selection === void 0 ? void 0 : selection.addRange(range.cloneRange());
  }
}
__name(modifySelectionPerMouseMove, "modifySelectionPerMouseMove");

// ../node_modules/@testing-library/user-event/dist/esm/system/pointer/shared.js
function isDifferentPointerPosition(positionA, positionB) {
  var _positionA_coords, _positionB_coords, _positionA_coords1, _positionB_coords1, _positionA_coords2, _positionB_coords2, _positionA_coords3, _positionB_coords3, _positionA_coords4, _positionB_coords4, _positionA_coords5, _positionB_coords5, _positionA_coords6, _positionB_coords6, _positionA_coords7, _positionB_coords7, _positionA_coords8, _positionB_coords8, _positionA_coords9, _positionB_coords9, _positionA_caret, _positionB_caret, _positionA_caret1, _positionB_caret1;
  return positionA.target !== positionB.target || ((_positionA_coords = positionA.coords) === null || _positionA_coords === void 0 ? void 0 : _positionA_coords.x) !== ((_positionB_coords = positionB.coords) === null || _positionB_coords === void 0 ? void 0 : _positionB_coords.x) || ((_positionA_coords1 = positionA.coords) === null || _positionA_coords1 === void 0 ? void 0 : _positionA_coords1.y) !== ((_positionB_coords1 = positionB.coords) === null || _positionB_coords1 === void 0 ? void 0 : _positionB_coords1.y) || ((_positionA_coords2 = positionA.coords) === null || _positionA_coords2 === void 0 ? void 0 : _positionA_coords2.clientX) !== ((_positionB_coords2 = positionB.coords) === null || _positionB_coords2 === void 0 ? void 0 : _positionB_coords2.clientX) || ((_positionA_coords3 = positionA.coords) === null || _positionA_coords3 === void 0 ? void 0 : _positionA_coords3.clientY) !== ((_positionB_coords3 = positionB.coords) === null || _positionB_coords3 === void 0 ? void 0 : _positionB_coords3.clientY) || ((_positionA_coords4 = positionA.coords) === null || _positionA_coords4 === void 0 ? void 0 : _positionA_coords4.offsetX) !== ((_positionB_coords4 = positionB.coords) === null || _positionB_coords4 === void 0 ? void 0 : _positionB_coords4.offsetX) || ((_positionA_coords5 = positionA.coords) === null || _positionA_coords5 === void 0 ? void 0 : _positionA_coords5.offsetY) !== ((_positionB_coords5 = positionB.coords) === null || _positionB_coords5 === void 0 ? void 0 : _positionB_coords5.offsetY) || ((_positionA_coords6 = positionA.coords) === null || _positionA_coords6 === void 0 ? void 0 : _positionA_coords6.pageX) !== ((_positionB_coords6 = positionB.coords) === null || _positionB_coords6 === void 0 ? void 0 : _positionB_coords6.pageX) || ((_positionA_coords7 = positionA.coords) === null || _positionA_coords7 === void 0 ? void 0 : _positionA_coords7.pageY) !== ((_positionB_coords7 = positionB.coords) === null || _positionB_coords7 === void 0 ? void 0 : _positionB_coords7.pageY) || ((_positionA_coords8 = positionA.coords) === null || _positionA_coords8 === void 0 ? void 0 : _positionA_coords8.screenX) !== ((_positionB_coords8 = positionB.coords) === null || _positionB_coords8 === void 0 ? void 0 : _positionB_coords8.screenX) || ((_positionA_coords9 = positionA.coords) === null || _positionA_coords9 === void 0 ? void 0 : _positionA_coords9.screenY) !== ((_positionB_coords9 = positionB.coords) === null || _positionB_coords9 === void 0 ? void 0 : _positionB_coords9.screenY) || ((_positionA_caret = positionA.caret) === null || _positionA_caret === void 0 ? void 0 : _positionA_caret.node) !== ((_positionB_caret = positionB.caret) === null || _positionB_caret === void 0 ? void 0 : _positionB_caret.node) || ((_positionA_caret1 = positionA.caret) === null || _positionA_caret1 === void 0 ? void 0 : _positionA_caret1.offset) !== ((_positionB_caret1 = positionB.caret) === null || _positionB_caret1 === void 0 ? void 0 : _positionB_caret1.offset);
}
__name(isDifferentPointerPosition, "isDifferentPointerPosition");

// ../node_modules/@testing-library/user-event/dist/esm/system/pointer/mouse.js
function _define_property6(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property6, "_define_property");
var _Mouse = class _Mouse {
  move(instance, position, isPrevented) {
    const prevPosition = this.position;
    const prevTarget = this.getTarget(instance);
    this.position = position;
    if (!isDifferentPointerPosition(prevPosition, position)) {
      return;
    }
    const nextTarget = this.getTarget(instance);
    const init = this.getEventInit("mousemove");
    const [leave, enter] = getTreeDiff(prevTarget, nextTarget);
    return {
      leave: /* @__PURE__ */ __name(() => {
        if (prevTarget !== nextTarget) {
          instance.dispatchUIEvent(prevTarget, "mouseout", init);
          leave.forEach((el) => instance.dispatchUIEvent(el, "mouseleave", init));
        }
      }, "leave"),
      enter: /* @__PURE__ */ __name(() => {
        if (prevTarget !== nextTarget) {
          instance.dispatchUIEvent(nextTarget, "mouseover", init);
          enter.forEach((el) => instance.dispatchUIEvent(el, "mouseenter", init));
        }
      }, "enter"),
      move: /* @__PURE__ */ __name(() => {
        if (isPrevented) {
          return;
        }
        instance.dispatchUIEvent(nextTarget, "mousemove", init);
        this.modifySelecting(instance);
      }, "move")
    };
  }
  down(instance, keyDef, isPrevented) {
    const button = this.buttons.down(keyDef);
    if (button === void 0) {
      return;
    }
    const target = this.getTarget(instance);
    this.buttonDownTarget[button] = target;
    const init = this.getEventInit("mousedown", keyDef.button);
    const disabled = isDisabled2(target);
    if (!isPrevented && (disabled || instance.dispatchUIEvent(target, "mousedown", init))) {
      this.startSelecting(instance, init.detail);
      focusElement(target);
    }
    if (!disabled && getMouseEventButton(keyDef.button) === 2) {
      instance.dispatchUIEvent(target, "contextmenu", this.getEventInit("contextmenu", keyDef.button));
    }
  }
  up(instance, keyDef, isPrevented) {
    const button = this.buttons.up(keyDef);
    if (button === void 0) {
      return;
    }
    const target = this.getTarget(instance);
    if (!isDisabled2(target)) {
      if (!isPrevented) {
        const mouseUpInit = this.getEventInit("mouseup", keyDef.button);
        instance.dispatchUIEvent(target, "mouseup", mouseUpInit);
        this.endSelecting();
      }
      const clickTarget = getTreeDiff(this.buttonDownTarget[button], target)[2][0];
      if (clickTarget) {
        const init = this.getEventInit("click", keyDef.button);
        if (init.detail) {
          instance.dispatchUIEvent(clickTarget, init.button === 0 ? "click" : "auxclick", init);
          if (init.button === 0 && init.detail === 2) {
            instance.dispatchUIEvent(clickTarget, "dblclick", {
              ...this.getEventInit("dblclick", keyDef.button),
              detail: init.detail
            });
          }
        }
      }
    }
  }
  resetClickCount() {
    this.clickCount.reset();
  }
  getEventInit(type5, button) {
    const init = {
      ...this.position.coords
    };
    init.button = getMouseEventButton(button);
    init.buttons = this.buttons.getButtons();
    if (type5 === "mousedown") {
      init.detail = this.clickCount.getOnDown(init.button);
    } else if (type5 === "mouseup") {
      init.detail = this.clickCount.getOnUp(init.button);
    } else if (type5 === "click" || type5 === "auxclick") {
      init.detail = this.clickCount.incOnClick(init.button);
    }
    return init;
  }
  getTarget(instance) {
    var _this_position_target;
    return (_this_position_target = this.position.target) !== null && _this_position_target !== void 0 ? _this_position_target : instance.config.document.body;
  }
  startSelecting(instance, clickCount) {
    var _this_position_caret, _this_position_caret1;
    this.selecting = setSelectionPerMouseDown({
      document: instance.config.document,
      target: this.getTarget(instance),
      node: (_this_position_caret = this.position.caret) === null || _this_position_caret === void 0 ? void 0 : _this_position_caret.node,
      offset: (_this_position_caret1 = this.position.caret) === null || _this_position_caret1 === void 0 ? void 0 : _this_position_caret1.offset,
      clickCount
    });
  }
  modifySelecting(instance) {
    var _this_position_caret, _this_position_caret1;
    if (!this.selecting) {
      return;
    }
    modifySelectionPerMouseMove(this.selecting, {
      document: instance.config.document,
      target: this.getTarget(instance),
      node: (_this_position_caret = this.position.caret) === null || _this_position_caret === void 0 ? void 0 : _this_position_caret.node,
      offset: (_this_position_caret1 = this.position.caret) === null || _this_position_caret1 === void 0 ? void 0 : _this_position_caret1.offset
    });
  }
  endSelecting() {
    this.selecting = void 0;
  }
  constructor() {
    _define_property6(this, "position", {});
    _define_property6(this, "buttons", new Buttons());
    _define_property6(this, "selecting", void 0);
    _define_property6(this, "buttonDownTarget", {});
    _define_property6(this, "clickCount", new class {
      incOnClick(button) {
        const current = this.down[button] === void 0 ? void 0 : Number(this.down[button]) + 1;
        this.count = this.count[button] === void 0 ? {} : {
          [button]: Number(this.count[button]) + 1
        };
        return current;
      }
      getOnDown(button) {
        var _this_count_button;
        this.down = {
          [button]: (_this_count_button = this.count[button]) !== null && _this_count_button !== void 0 ? _this_count_button : 0
        };
        var _this_count_button1;
        this.count = {
          [button]: (_this_count_button1 = this.count[button]) !== null && _this_count_button1 !== void 0 ? _this_count_button1 : 0
        };
        return Number(this.count[button]) + 1;
      }
      getOnUp(button) {
        return this.down[button] === void 0 ? void 0 : Number(this.down[button]) + 1;
      }
      reset() {
        this.count = {};
      }
      constructor() {
        _define_property6(this, "down", {});
        _define_property6(this, "count", {});
      }
    }());
  }
};
__name(_Mouse, "Mouse");
var Mouse = _Mouse;

// ../node_modules/@testing-library/user-event/dist/esm/utils/pointer/cssPointerEvents.js
function hasPointerEvents(instance, element) {
  var _checkPointerEvents;
  return ((_checkPointerEvents = checkPointerEvents(instance, element)) === null || _checkPointerEvents === void 0 ? void 0 : _checkPointerEvents.pointerEvents) !== "none";
}
__name(hasPointerEvents, "hasPointerEvents");
function closestPointerEventsDeclaration(element) {
  const window2 = getWindow(element);
  for (let el = element, tree = []; el === null || el === void 0 ? void 0 : el.ownerDocument; el = el.parentElement) {
    tree.push(el);
    const pointerEvents = window2.getComputedStyle(el).pointerEvents;
    if (pointerEvents && ![
      "inherit",
      "unset"
    ].includes(pointerEvents)) {
      return {
        pointerEvents,
        tree
      };
    }
  }
  return void 0;
}
__name(closestPointerEventsDeclaration, "closestPointerEventsDeclaration");
var PointerEventsCheck = Symbol("Last check for pointer-events");
function checkPointerEvents(instance, element) {
  const lastCheck = element[PointerEventsCheck];
  const needsCheck = instance.config.pointerEventsCheck !== PointerEventsCheckLevel.Never && (!lastCheck || hasBitFlag(instance.config.pointerEventsCheck, PointerEventsCheckLevel.EachApiCall) && lastCheck[ApiLevel.Call] !== getLevelRef(instance, ApiLevel.Call) || hasBitFlag(instance.config.pointerEventsCheck, PointerEventsCheckLevel.EachTrigger) && lastCheck[ApiLevel.Trigger] !== getLevelRef(instance, ApiLevel.Trigger));
  if (!needsCheck) {
    return lastCheck === null || lastCheck === void 0 ? void 0 : lastCheck.result;
  }
  const declaration = closestPointerEventsDeclaration(element);
  element[PointerEventsCheck] = {
    [ApiLevel.Call]: getLevelRef(instance, ApiLevel.Call),
    [ApiLevel.Trigger]: getLevelRef(instance, ApiLevel.Trigger),
    result: declaration
  };
  return declaration;
}
__name(checkPointerEvents, "checkPointerEvents");
function assertPointerEvents(instance, element) {
  const declaration = checkPointerEvents(instance, element);
  if ((declaration === null || declaration === void 0 ? void 0 : declaration.pointerEvents) === "none") {
    throw new Error([
      `Unable to perform pointer interaction as the element ${declaration.tree.length > 1 ? "inherits" : "has"} \`pointer-events: none\`:`,
      "",
      printTree(declaration.tree)
    ].join("\n"));
  }
}
__name(assertPointerEvents, "assertPointerEvents");
function printTree(tree) {
  return tree.reverse().map((el, i2) => [
    "".padEnd(i2),
    el.tagName,
    el.id && `#${el.id}`,
    el.hasAttribute("data-testid") && `(testId=${el.getAttribute("data-testid")})`,
    getLabelDescr(el),
    tree.length > 1 && i2 === 0 && "  <-- This element declared `pointer-events: none`",
    tree.length > 1 && i2 === tree.length - 1 && "  <-- Asserted pointer events here"
  ].filter(Boolean).join("")).join("\n");
}
__name(printTree, "printTree");
function getLabelDescr(element) {
  var _element_labels;
  let label;
  if (element.hasAttribute("aria-label")) {
    label = element.getAttribute("aria-label");
  } else if (element.hasAttribute("aria-labelledby")) {
    var _element_ownerDocument_getElementById_textContent, _element_ownerDocument_getElementById;
    label = (_element_ownerDocument_getElementById = element.ownerDocument.getElementById(element.getAttribute("aria-labelledby"))) === null || _element_ownerDocument_getElementById === void 0 ? void 0 : (_element_ownerDocument_getElementById_textContent = _element_ownerDocument_getElementById.textContent) === null || _element_ownerDocument_getElementById_textContent === void 0 ? void 0 : _element_ownerDocument_getElementById_textContent.trim();
  } else if (isElementType(element, [
    "button",
    "input",
    "meter",
    "output",
    "progress",
    "select",
    "textarea"
  ]) && ((_element_labels = element.labels) === null || _element_labels === void 0 ? void 0 : _element_labels.length)) {
    label = Array.from(element.labels).map((el) => {
      var _el_textContent;
      return (_el_textContent = el.textContent) === null || _el_textContent === void 0 ? void 0 : _el_textContent.trim();
    }).join("|");
  } else if (isElementType(element, "button")) {
    var _element_textContent;
    label = (_element_textContent = element.textContent) === null || _element_textContent === void 0 ? void 0 : _element_textContent.trim();
  }
  label = label === null || label === void 0 ? void 0 : label.replace(/\n/g, "  ");
  if (Number(label === null || label === void 0 ? void 0 : label.length) > 30) {
    label = `${label === null || label === void 0 ? void 0 : label.substring(0, 29)}\u2026`;
  }
  return label ? `(label=${label})` : "";
}
__name(getLabelDescr, "getLabelDescr");
function hasBitFlag(conf, flag3) {
  return (conf & flag3) > 0;
}
__name(hasBitFlag, "hasBitFlag");

// ../node_modules/@testing-library/user-event/dist/esm/system/pointer/pointer.js
function _define_property7(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property7, "_define_property");
var _Pointer = class _Pointer {
  init(instance) {
    const target = this.getTarget(instance);
    const [, enter] = getTreeDiff(null, target);
    const init = this.getEventInit();
    assertPointerEvents(instance, target);
    instance.dispatchUIEvent(target, "pointerover", init);
    enter.forEach((el) => instance.dispatchUIEvent(el, "pointerenter", init));
    return this;
  }
  move(instance, position) {
    const prevPosition = this.position;
    const prevTarget = this.getTarget(instance);
    this.position = position;
    if (!isDifferentPointerPosition(prevPosition, position)) {
      return;
    }
    const nextTarget = this.getTarget(instance);
    const init = this.getEventInit(-1);
    const [leave, enter] = getTreeDiff(prevTarget, nextTarget);
    return {
      leave: /* @__PURE__ */ __name(() => {
        if (hasPointerEvents(instance, prevTarget)) {
          if (prevTarget !== nextTarget) {
            instance.dispatchUIEvent(prevTarget, "pointerout", init);
            leave.forEach((el) => instance.dispatchUIEvent(el, "pointerleave", init));
          }
        }
      }, "leave"),
      enter: /* @__PURE__ */ __name(() => {
        assertPointerEvents(instance, nextTarget);
        if (prevTarget !== nextTarget) {
          instance.dispatchUIEvent(nextTarget, "pointerover", init);
          enter.forEach((el) => instance.dispatchUIEvent(el, "pointerenter", init));
        }
      }, "enter"),
      move: /* @__PURE__ */ __name(() => {
        instance.dispatchUIEvent(nextTarget, "pointermove", init);
      }, "move")
    };
  }
  down(instance, button = 0) {
    if (this.isDown) {
      return;
    }
    const target = this.getTarget(instance);
    assertPointerEvents(instance, target);
    this.isDown = true;
    this.isPrevented = !instance.dispatchUIEvent(target, "pointerdown", this.getEventInit(button));
  }
  up(instance, button = 0) {
    if (!this.isDown) {
      return;
    }
    const target = this.getTarget(instance);
    assertPointerEvents(instance, target);
    this.isPrevented = false;
    this.isDown = false;
    instance.dispatchUIEvent(target, "pointerup", this.getEventInit(button));
  }
  release(instance) {
    const target = this.getTarget(instance);
    const [leave] = getTreeDiff(target, null);
    const init = this.getEventInit();
    if (hasPointerEvents(instance, target)) {
      instance.dispatchUIEvent(target, "pointerout", init);
      leave.forEach((el) => instance.dispatchUIEvent(el, "pointerleave", init));
    }
    this.isCancelled = true;
  }
  getTarget(instance) {
    var _this_position_target;
    return (_this_position_target = this.position.target) !== null && _this_position_target !== void 0 ? _this_position_target : instance.config.document.body;
  }
  getEventInit(button) {
    return {
      ...this.position.coords,
      pointerId: this.pointerId,
      pointerType: this.pointerType,
      isPrimary: this.isPrimary,
      button: getMouseEventButton(button),
      buttons: this.buttons.getButtons()
    };
  }
  constructor({ pointerId, pointerType, isPrimary }, buttons) {
    _define_property7(this, "pointerId", void 0);
    _define_property7(this, "pointerType", void 0);
    _define_property7(this, "isPrimary", void 0);
    _define_property7(this, "buttons", void 0);
    _define_property7(this, "isMultitouch", false);
    _define_property7(this, "isCancelled", false);
    _define_property7(this, "isDown", false);
    _define_property7(this, "isPrevented", false);
    _define_property7(this, "position", {});
    this.pointerId = pointerId;
    this.pointerType = pointerType;
    this.isPrimary = isPrimary;
    this.isMultitouch = !isPrimary;
    this.buttons = buttons;
  }
};
__name(_Pointer, "Pointer");
var Pointer = _Pointer;

// ../node_modules/@testing-library/user-event/dist/esm/system/pointer/index.js
function _define_property8(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property8, "_define_property");
var _PointerHost = class _PointerHost {
  isKeyPressed(keyDef) {
    return this.devices.get(keyDef.pointerType).isPressed(keyDef);
  }
  async press(instance, keyDef, position) {
    this.devices.get(keyDef.pointerType).addPressed(keyDef);
    this.buttons.down(keyDef);
    const pointerName = this.getPointerName(keyDef);
    const pointer3 = keyDef.pointerType === "touch" ? this.pointers.new(pointerName, keyDef.pointerType, this.buttons) : this.pointers.get(pointerName);
    pointer3.position = position;
    if (pointer3.pointerType !== "touch") {
      this.mouse.position = position;
    }
    if (pointer3.pointerType === "touch") {
      pointer3.init(instance);
    }
    pointer3.down(instance, keyDef.button);
    if (pointer3.pointerType !== "touch") {
      this.mouse.down(instance, keyDef, pointer3.isPrevented);
    }
  }
  async move(instance, pointerName, position) {
    const pointer3 = this.pointers.get(pointerName);
    const pointermove = pointer3.move(instance, position);
    const mousemove = pointer3.pointerType === "touch" ? void 0 : this.mouse.move(instance, position, pointer3.isPrevented);
    pointermove === null || pointermove === void 0 ? void 0 : pointermove.leave();
    mousemove === null || mousemove === void 0 ? void 0 : mousemove.leave();
    pointermove === null || pointermove === void 0 ? void 0 : pointermove.enter();
    mousemove === null || mousemove === void 0 ? void 0 : mousemove.enter();
    pointermove === null || pointermove === void 0 ? void 0 : pointermove.move();
    mousemove === null || mousemove === void 0 ? void 0 : mousemove.move();
  }
  async release(instance, keyDef, position) {
    const device = this.devices.get(keyDef.pointerType);
    device.removePressed(keyDef);
    this.buttons.up(keyDef);
    const pointer3 = this.pointers.get(this.getPointerName(keyDef));
    const isPrevented = pointer3.isPrevented;
    pointer3.position = position;
    if (pointer3.pointerType !== "touch") {
      this.mouse.position = position;
    }
    if (device.countPressed === 0) {
      pointer3.up(instance, keyDef.button);
    }
    if (pointer3.pointerType === "touch") {
      pointer3.release(instance);
    }
    if (pointer3.pointerType === "touch" && !pointer3.isMultitouch) {
      const mousemove = this.mouse.move(instance, position, isPrevented);
      mousemove === null || mousemove === void 0 ? void 0 : mousemove.leave();
      mousemove === null || mousemove === void 0 ? void 0 : mousemove.enter();
      mousemove === null || mousemove === void 0 ? void 0 : mousemove.move();
      this.mouse.down(instance, keyDef, isPrevented);
    }
    if (!pointer3.isMultitouch) {
      const mousemove = this.mouse.move(instance, position, isPrevented);
      mousemove === null || mousemove === void 0 ? void 0 : mousemove.leave();
      mousemove === null || mousemove === void 0 ? void 0 : mousemove.enter();
      mousemove === null || mousemove === void 0 ? void 0 : mousemove.move();
      this.mouse.up(instance, keyDef, isPrevented);
    }
  }
  getPointerName(keyDef) {
    return keyDef.pointerType === "touch" ? keyDef.name : keyDef.pointerType;
  }
  getPreviousPosition(pointerName) {
    return this.pointers.has(pointerName) ? this.pointers.get(pointerName).position : void 0;
  }
  resetClickCount() {
    this.mouse.resetClickCount();
  }
  getMouseTarget(instance) {
    var _this_mouse_position_target;
    return (_this_mouse_position_target = this.mouse.position.target) !== null && _this_mouse_position_target !== void 0 ? _this_mouse_position_target : instance.config.document.body;
  }
  setMousePosition(position) {
    this.mouse.position = position;
    this.pointers.get("mouse").position = position;
  }
  constructor(system) {
    _define_property8(this, "system", void 0);
    _define_property8(this, "mouse", void 0);
    _define_property8(this, "buttons", void 0);
    _define_property8(this, "devices", new class {
      get(k2) {
        var _this_registry, _k;
        var _;
        return (_ = (_this_registry = this.registry)[_k = k2]) !== null && _ !== void 0 ? _ : _this_registry[_k] = new Device();
      }
      constructor() {
        _define_property8(this, "registry", {});
      }
    }());
    _define_property8(this, "pointers", new class {
      new(pointerName, pointerType, buttons) {
        const isPrimary = pointerType !== "touch" || !Object.values(this.registry).some((p) => p.pointerType === "touch" && !p.isCancelled);
        if (!isPrimary) {
          Object.values(this.registry).forEach((p) => {
            if (p.pointerType === pointerType && !p.isCancelled) {
              p.isMultitouch = true;
            }
          });
        }
        this.registry[pointerName] = new Pointer({
          pointerId: this.nextId++,
          pointerType,
          isPrimary
        }, buttons);
        return this.registry[pointerName];
      }
      get(pointerName) {
        if (!this.has(pointerName)) {
          throw new Error(`Trying to access pointer "${pointerName}" which does not exist.`);
        }
        return this.registry[pointerName];
      }
      has(pointerName) {
        return pointerName in this.registry;
      }
      constructor() {
        _define_property8(this, "registry", {});
        _define_property8(this, "nextId", 1);
      }
    }());
    this.system = system;
    this.buttons = new Buttons();
    this.mouse = new Mouse();
    this.pointers.new("mouse", "mouse", this.buttons);
  }
};
__name(_PointerHost, "PointerHost");
var PointerHost = _PointerHost;

// ../node_modules/@testing-library/user-event/dist/esm/system/index.js
function _define_property9(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
__name(_define_property9, "_define_property");
var _System = class _System {
  getUIEventModifiers() {
    return {
      altKey: this.keyboard.modifiers.Alt,
      ctrlKey: this.keyboard.modifiers.Control,
      metaKey: this.keyboard.modifiers.Meta,
      shiftKey: this.keyboard.modifiers.Shift,
      modifierAltGraph: this.keyboard.modifiers.AltGraph,
      modifierCapsLock: this.keyboard.modifiers.CapsLock,
      modifierFn: this.keyboard.modifiers.Fn,
      modifierFnLock: this.keyboard.modifiers.FnLock,
      modifierNumLock: this.keyboard.modifiers.NumLock,
      modifierScrollLock: this.keyboard.modifiers.ScrollLock,
      modifierSymbol: this.keyboard.modifiers.Symbol,
      modifierSymbolLock: this.keyboard.modifiers.SymbolLock
    };
  }
  constructor() {
    _define_property9(this, "keyboard", new KeyboardHost(this));
    _define_property9(this, "pointer", new PointerHost(this));
  }
};
__name(_System, "System");
var System = _System;

// ../node_modules/@testing-library/user-event/dist/esm/convenience/click.js
async function click(element) {
  const pointerIn = [];
  if (!this.config.skipHover) {
    pointerIn.push({
      target: element
    });
  }
  pointerIn.push({
    keys: "[MouseLeft]",
    target: element
  });
  return this.pointer(pointerIn);
}
__name(click, "click");
async function dblClick(element) {
  return this.pointer([
    {
      target: element
    },
    "[MouseLeft][MouseLeft]"
  ]);
}
__name(dblClick, "dblClick");
async function tripleClick(element) {
  return this.pointer([
    {
      target: element
    },
    "[MouseLeft][MouseLeft][MouseLeft]"
  ]);
}
__name(tripleClick, "tripleClick");

// ../node_modules/@testing-library/user-event/dist/esm/convenience/hover.js
async function hover(element) {
  return this.pointer({
    target: element
  });
}
__name(hover, "hover");
async function unhover(element) {
  assertPointerEvents(this, this.system.pointer.getMouseTarget(this));
  return this.pointer({
    target: element.ownerDocument.body
  });
}
__name(unhover, "unhover");

// ../node_modules/@testing-library/user-event/dist/esm/convenience/tab.js
async function tab({ shift } = {}) {
  return this.keyboard(shift === true ? "{Shift>}{Tab}{/Shift}" : shift === false ? "[/ShiftLeft][/ShiftRight]{Tab}" : "{Tab}");
}
__name(tab, "tab");

// ../node_modules/@testing-library/user-event/dist/esm/utils/keyDef/readNextDescriptor.js
var bracketDict = function(bracketDict2) {
  bracketDict2["{"] = "}";
  bracketDict2["["] = "]";
  return bracketDict2;
}(bracketDict || {});
function readNextDescriptor(text, context) {
  let pos = 0;
  const startBracket = text[pos] in bracketDict ? text[pos] : "";
  pos += startBracket.length;
  const isEscapedChar = new RegExp(`^\\${startBracket}{2}`).test(text);
  const type5 = isEscapedChar ? "" : startBracket;
  return {
    type: type5,
    ...type5 === "" ? readPrintableChar(text, pos, context) : readTag(text, pos, type5, context)
  };
}
__name(readNextDescriptor, "readNextDescriptor");
function readPrintableChar(text, pos, context) {
  const descriptor = text[pos];
  assertDescriptor(descriptor, text, pos, context);
  pos += descriptor.length;
  return {
    consumedLength: pos,
    descriptor,
    releasePrevious: false,
    releaseSelf: true,
    repeat: 1
  };
}
__name(readPrintableChar, "readPrintableChar");
function readTag(text, pos, startBracket, context) {
  var _text_slice_match, _text_slice_match1;
  const releasePreviousModifier = text[pos] === "/" ? "/" : "";
  pos += releasePreviousModifier.length;
  const escapedDescriptor = startBracket === "{" && text[pos] === "\\";
  pos += Number(escapedDescriptor);
  const descriptor = escapedDescriptor ? text[pos] : (_text_slice_match = text.slice(pos).match(startBracket === "{" ? /^\w+|^[^}>/]/ : /^\w+/)) === null || _text_slice_match === void 0 ? void 0 : _text_slice_match[0];
  assertDescriptor(descriptor, text, pos, context);
  pos += descriptor.length;
  var _text_slice_match_;
  const repeatModifier = (_text_slice_match_ = (_text_slice_match1 = text.slice(pos).match(/^>\d+/)) === null || _text_slice_match1 === void 0 ? void 0 : _text_slice_match1[0]) !== null && _text_slice_match_ !== void 0 ? _text_slice_match_ : "";
  pos += repeatModifier.length;
  const releaseSelfModifier = text[pos] === "/" || !repeatModifier && text[pos] === ">" ? text[pos] : "";
  pos += releaseSelfModifier.length;
  const expectedEndBracket = bracketDict[startBracket];
  const endBracket = text[pos] === expectedEndBracket ? expectedEndBracket : "";
  if (!endBracket) {
    throw new Error(getErrorMessage([
      !repeatModifier && "repeat modifier",
      !releaseSelfModifier && "release modifier",
      `"${expectedEndBracket}"`
    ].filter(Boolean).join(" or "), text[pos], text, context));
  }
  pos += endBracket.length;
  return {
    consumedLength: pos,
    descriptor,
    releasePrevious: !!releasePreviousModifier,
    repeat: repeatModifier ? Math.max(Number(repeatModifier.substr(1)), 1) : 1,
    releaseSelf: hasReleaseSelf(releaseSelfModifier, repeatModifier)
  };
}
__name(readTag, "readTag");
function assertDescriptor(descriptor, text, pos, context) {
  if (!descriptor) {
    throw new Error(getErrorMessage("key descriptor", text[pos], text, context));
  }
}
__name(assertDescriptor, "assertDescriptor");
function hasReleaseSelf(releaseSelfModifier, repeatModifier) {
  if (releaseSelfModifier) {
    return releaseSelfModifier === "/";
  }
  if (repeatModifier) {
    return false;
  }
}
__name(hasReleaseSelf, "hasReleaseSelf");
function getErrorMessage(expected, found, text, context) {
  return `Expected ${expected} but found "${found !== null && found !== void 0 ? found : ""}" in "${text}"
    See ${context === "pointer" ? `https://testing-library.com/docs/user-event/pointer#pressing-a-button-or-touching-the-screen` : `https://testing-library.com/docs/user-event/keyboard`}
    for more information about how userEvent parses your input.`;
}
__name(getErrorMessage, "getErrorMessage");

// ../node_modules/@testing-library/user-event/dist/esm/keyboard/parseKeyDef.js
function parseKeyDef(keyboardMap, text) {
  const defs = [];
  do {
    const { type: type5, descriptor, consumedLength, releasePrevious, releaseSelf = true, repeat } = readNextDescriptor(text, "keyboard");
    var _keyboardMap_find;
    const keyDef = (_keyboardMap_find = keyboardMap.find((def) => {
      if (type5 === "[") {
        var _def_code;
        return ((_def_code = def.code) === null || _def_code === void 0 ? void 0 : _def_code.toLowerCase()) === descriptor.toLowerCase();
      } else if (type5 === "{") {
        var _def_key;
        return ((_def_key = def.key) === null || _def_key === void 0 ? void 0 : _def_key.toLowerCase()) === descriptor.toLowerCase();
      }
      return def.key === descriptor;
    })) !== null && _keyboardMap_find !== void 0 ? _keyboardMap_find : {
      key: "Unknown",
      code: "Unknown",
      [type5 === "[" ? "code" : "key"]: descriptor
    };
    defs.push({
      keyDef,
      releasePrevious,
      releaseSelf,
      repeat
    });
    text = text.slice(consumedLength);
  } while (text);
  return defs;
}
__name(parseKeyDef, "parseKeyDef");

// ../node_modules/@testing-library/user-event/dist/esm/keyboard/index.js
async function keyboard(text) {
  const actions = parseKeyDef(this.config.keyboardMap, text);
  for (let i2 = 0; i2 < actions.length; i2++) {
    await wait(this.config);
    await keyboardAction(this, actions[i2]);
  }
}
__name(keyboard, "keyboard");
async function keyboardAction(instance, { keyDef, releasePrevious, releaseSelf, repeat }) {
  const { system } = instance;
  if (system.keyboard.isKeyPressed(keyDef)) {
    await system.keyboard.keyup(instance, keyDef);
  }
  if (!releasePrevious) {
    for (let i2 = 1; i2 <= repeat; i2++) {
      await system.keyboard.keydown(instance, keyDef);
      if (i2 < repeat) {
        await wait(instance.config);
      }
    }
    if (releaseSelf) {
      await system.keyboard.keyup(instance, keyDef);
    }
  }
}
__name(keyboardAction, "keyboardAction");
async function releaseAllKeys(instance) {
  for (const k2 of instance.system.keyboard.getPressedKeys()) {
    await instance.system.keyboard.keyup(instance, k2);
  }
}
__name(releaseAllKeys, "releaseAllKeys");

// ../node_modules/@testing-library/user-event/dist/esm/document/copySelection.js
function copySelection(target) {
  const data = hasOwnSelection(target) ? {
    "text/plain": readSelectedValueFromInput(target)
  } : {
    "text/plain": String(target.ownerDocument.getSelection())
  };
  const dt = createDataTransfer(getWindow(target));
  for (const type5 in data) {
    if (data[type5]) {
      dt.setData(type5, data[type5]);
    }
  }
  return dt;
}
__name(copySelection, "copySelection");
function readSelectedValueFromInput(target) {
  const sel = getUISelection(target);
  const val = getUIValue(target);
  return val.substring(sel.startOffset, sel.endOffset);
}
__name(readSelectedValueFromInput, "readSelectedValueFromInput");

// ../node_modules/@testing-library/user-event/dist/esm/clipboard/copy.js
async function copy() {
  const doc = this.config.document;
  var _doc_activeElement;
  const target = (_doc_activeElement = doc.activeElement) !== null && _doc_activeElement !== void 0 ? _doc_activeElement : (
    /* istanbul ignore next */
    doc.body
  );
  const clipboardData = copySelection(target);
  if (clipboardData.items.length === 0) {
    return;
  }
  if (this.dispatchUIEvent(target, "copy", {
    clipboardData
  }) && this.config.writeToClipboard) {
    await writeDataTransferToClipboard(doc, clipboardData);
  }
  return clipboardData;
}
__name(copy, "copy");

// ../node_modules/@testing-library/user-event/dist/esm/clipboard/cut.js
async function cut() {
  const doc = this.config.document;
  var _doc_activeElement;
  const target = (_doc_activeElement = doc.activeElement) !== null && _doc_activeElement !== void 0 ? _doc_activeElement : (
    /* istanbul ignore next */
    doc.body
  );
  const clipboardData = copySelection(target);
  if (clipboardData.items.length === 0) {
    return;
  }
  if (this.dispatchUIEvent(target, "cut", {
    clipboardData
  }) && this.config.writeToClipboard) {
    await writeDataTransferToClipboard(target.ownerDocument, clipboardData);
  }
  return clipboardData;
}
__name(cut, "cut");

// ../node_modules/@testing-library/user-event/dist/esm/clipboard/paste.js
async function paste(clipboardData) {
  const doc = this.config.document;
  var _doc_activeElement;
  const target = (_doc_activeElement = doc.activeElement) !== null && _doc_activeElement !== void 0 ? _doc_activeElement : (
    /* istanbul ignore next */
    doc.body
  );
  var _ref;
  const dataTransfer = (_ref = typeof clipboardData === "string" ? getClipboardDataFromString(doc, clipboardData) : clipboardData) !== null && _ref !== void 0 ? _ref : await readDataTransferFromClipboard(doc).catch(() => {
    throw new Error("`userEvent.paste()` without `clipboardData` requires the `ClipboardAPI` to be available.");
  });
  this.dispatchUIEvent(target, "paste", {
    clipboardData: dataTransfer
  });
}
__name(paste, "paste");
function getClipboardDataFromString(doc, text) {
  const dt = createDataTransfer(getWindow(doc));
  dt.setData("text", text);
  return dt;
}
__name(getClipboardDataFromString, "getClipboardDataFromString");

// ../node_modules/@testing-library/user-event/dist/esm/pointer/parseKeyDef.js
function parseKeyDef2(pointerMap, keys2) {
  const defs = [];
  do {
    const { descriptor, consumedLength, releasePrevious, releaseSelf = true } = readNextDescriptor(keys2, "pointer");
    const keyDef = pointerMap.find((p) => p.name === descriptor);
    if (keyDef) {
      defs.push({
        keyDef,
        releasePrevious,
        releaseSelf
      });
    }
    keys2 = keys2.slice(consumedLength);
  } while (keys2);
  return defs;
}
__name(parseKeyDef2, "parseKeyDef");

// ../node_modules/@testing-library/user-event/dist/esm/pointer/index.js
async function pointer(input2) {
  const { pointerMap } = this.config;
  const actions = [];
  (Array.isArray(input2) ? input2 : [
    input2
  ]).forEach((actionInput) => {
    if (typeof actionInput === "string") {
      actions.push(...parseKeyDef2(pointerMap, actionInput));
    } else if ("keys" in actionInput) {
      actions.push(...parseKeyDef2(pointerMap, actionInput.keys).map((i2) => ({
        ...actionInput,
        ...i2
      })));
    } else {
      actions.push(actionInput);
    }
  });
  for (let i2 = 0; i2 < actions.length; i2++) {
    await wait(this.config);
    await pointerAction(this, actions[i2]);
  }
  this.system.pointer.resetClickCount();
}
__name(pointer, "pointer");
async function pointerAction(instance, action) {
  var _previousPosition_caret, _previousPosition_caret1;
  const pointerName = "pointerName" in action && action.pointerName ? action.pointerName : "keyDef" in action ? instance.system.pointer.getPointerName(action.keyDef) : "mouse";
  const previousPosition = instance.system.pointer.getPreviousPosition(pointerName);
  var _action_target, _action_coords, _action_node, _action_offset;
  const position = {
    target: (_action_target = action.target) !== null && _action_target !== void 0 ? _action_target : getPrevTarget(instance, previousPosition),
    coords: (_action_coords = action.coords) !== null && _action_coords !== void 0 ? _action_coords : previousPosition === null || previousPosition === void 0 ? void 0 : previousPosition.coords,
    caret: {
      node: (_action_node = action.node) !== null && _action_node !== void 0 ? _action_node : hasCaretPosition(action) ? void 0 : previousPosition === null || previousPosition === void 0 ? void 0 : (_previousPosition_caret = previousPosition.caret) === null || _previousPosition_caret === void 0 ? void 0 : _previousPosition_caret.node,
      offset: (_action_offset = action.offset) !== null && _action_offset !== void 0 ? _action_offset : hasCaretPosition(action) ? void 0 : previousPosition === null || previousPosition === void 0 ? void 0 : (_previousPosition_caret1 = previousPosition.caret) === null || _previousPosition_caret1 === void 0 ? void 0 : _previousPosition_caret1.offset
    }
  };
  if ("keyDef" in action) {
    if (instance.system.pointer.isKeyPressed(action.keyDef)) {
      setLevelRef(instance, ApiLevel.Trigger);
      await instance.system.pointer.release(instance, action.keyDef, position);
    }
    if (!action.releasePrevious) {
      setLevelRef(instance, ApiLevel.Trigger);
      await instance.system.pointer.press(instance, action.keyDef, position);
      if (action.releaseSelf) {
        setLevelRef(instance, ApiLevel.Trigger);
        await instance.system.pointer.release(instance, action.keyDef, position);
      }
    }
  } else {
    setLevelRef(instance, ApiLevel.Trigger);
    await instance.system.pointer.move(instance, pointerName, position);
  }
}
__name(pointerAction, "pointerAction");
function hasCaretPosition(action) {
  var _action_target, _ref;
  return !!((_ref = (_action_target = action.target) !== null && _action_target !== void 0 ? _action_target : action.node) !== null && _ref !== void 0 ? _ref : action.offset !== void 0);
}
__name(hasCaretPosition, "hasCaretPosition");
function getPrevTarget(instance, position) {
  if (!position) {
    throw new Error("This pointer has no previous position. Provide a target property!");
  }
  var _position_target;
  return (_position_target = position.target) !== null && _position_target !== void 0 ? _position_target : instance.config.document.body;
}
__name(getPrevTarget, "getPrevTarget");

// ../node_modules/@testing-library/user-event/dist/esm/utility/clear.js
async function clear(element) {
  if (!isEditable(element) || isDisabled2(element)) {
    throw new Error("clear()` is only supported on editable elements.");
  }
  focusElement(element);
  if (element.ownerDocument.activeElement !== element) {
    throw new Error("The element to be cleared could not be focused.");
  }
  selectAll(element);
  if (!isAllSelected(element)) {
    throw new Error("The element content to be cleared could not be selected.");
  }
  input(this, element, "", "deleteContentBackward");
}
__name(clear, "clear");

// ../node_modules/@testing-library/user-event/dist/esm/utility/selectOptions.js
async function selectOptions(select, values) {
  return selectOptionsBase.call(this, true, select, values);
}
__name(selectOptions, "selectOptions");
async function deselectOptions(select, values) {
  return selectOptionsBase.call(this, false, select, values);
}
__name(deselectOptions, "deselectOptions");
async function selectOptionsBase(newValue, select, values) {
  if (!newValue && !select.multiple) {
    throw getConfig().getElementError(`Unable to deselect an option in a non-multiple select. Use selectOptions to change the selection instead.`, select);
  }
  const valArray = Array.isArray(values) ? values : [
    values
  ];
  const allOptions = Array.from(select.querySelectorAll('option, [role="option"]'));
  const selectedOptions = valArray.map((val) => {
    if (typeof val !== "string" && allOptions.includes(val)) {
      return val;
    } else {
      const matchingOption = allOptions.find((o2) => o2.value === val || o2.innerHTML === val);
      if (matchingOption) {
        return matchingOption;
      } else {
        throw getConfig().getElementError(`Value "${String(val)}" not found in options`, select);
      }
    }
  }).filter((option) => !isDisabled2(option));
  if (isDisabled2(select) || !selectedOptions.length) return;
  const selectOption = /* @__PURE__ */ __name((option) => {
    option.selected = newValue;
    this.dispatchUIEvent(select, "input", {
      bubbles: true,
      cancelable: false,
      composed: true
    });
    this.dispatchUIEvent(select, "change");
  }, "selectOption");
  if (isElementType(select, "select")) {
    if (select.multiple) {
      for (const option of selectedOptions) {
        const withPointerEvents = this.config.pointerEventsCheck === 0 ? true : hasPointerEvents(this, option);
        if (withPointerEvents) {
          this.dispatchUIEvent(option, "pointerover");
          this.dispatchUIEvent(select, "pointerenter");
          this.dispatchUIEvent(option, "mouseover");
          this.dispatchUIEvent(select, "mouseenter");
          this.dispatchUIEvent(option, "pointermove");
          this.dispatchUIEvent(option, "mousemove");
          this.dispatchUIEvent(option, "pointerdown");
          this.dispatchUIEvent(option, "mousedown");
        }
        focusElement(select);
        if (withPointerEvents) {
          this.dispatchUIEvent(option, "pointerup");
          this.dispatchUIEvent(option, "mouseup");
        }
        selectOption(option);
        if (withPointerEvents) {
          this.dispatchUIEvent(option, "click");
        }
        await wait(this.config);
      }
    } else if (selectedOptions.length === 1) {
      const withPointerEvents = this.config.pointerEventsCheck === 0 ? true : hasPointerEvents(this, select);
      if (withPointerEvents) {
        await this.click(select);
      } else {
        focusElement(select);
      }
      selectOption(selectedOptions[0]);
      if (withPointerEvents) {
        this.dispatchUIEvent(select, "pointerover");
        this.dispatchUIEvent(select, "pointerenter");
        this.dispatchUIEvent(select, "mouseover");
        this.dispatchUIEvent(select, "mouseenter");
        this.dispatchUIEvent(select, "pointerup");
        this.dispatchUIEvent(select, "mouseup");
        this.dispatchUIEvent(select, "click");
      }
      await wait(this.config);
    } else {
      throw getConfig().getElementError(`Cannot select multiple options on a non-multiple select`, select);
    }
  } else if (select.getAttribute("role") === "listbox") {
    for (const option of selectedOptions) {
      await this.click(option);
      await this.unhover(option);
    }
  } else {
    throw getConfig().getElementError(`Cannot select options on elements that are neither select nor listbox elements`, select);
  }
}
__name(selectOptionsBase, "selectOptionsBase");

// ../node_modules/@testing-library/user-event/dist/esm/utility/type.js
async function type3(element, text, { skipClick = this.config.skipClick, skipAutoClose = this.config.skipAutoClose, initialSelectionStart, initialSelectionEnd } = {}) {
  if (element.disabled) return;
  if (!skipClick) {
    await this.click(element);
  }
  if (initialSelectionStart !== void 0) {
    setSelectionRange(element, initialSelectionStart, initialSelectionEnd !== null && initialSelectionEnd !== void 0 ? initialSelectionEnd : initialSelectionStart);
  }
  await this.keyboard(text);
  if (!skipAutoClose) {
    await releaseAllKeys(this);
  }
}
__name(type3, "type");

// ../node_modules/@testing-library/user-event/dist/esm/utils/edit/setFiles.js
var fakeFiles = Symbol("files and value properties are mocked");
function restoreProperty(obj, prop, descriptor) {
  if (descriptor) {
    Object.defineProperty(obj, prop, descriptor);
  } else {
    delete obj[prop];
  }
}
__name(restoreProperty, "restoreProperty");
function setFiles(el, files) {
  var _el_fakeFiles;
  (_el_fakeFiles = el[fakeFiles]) === null || _el_fakeFiles === void 0 ? void 0 : _el_fakeFiles.restore();
  const typeDescr = Object.getOwnPropertyDescriptor(el, "type");
  const valueDescr = Object.getOwnPropertyDescriptor(el, "value");
  const filesDescr = Object.getOwnPropertyDescriptor(el, "files");
  function restore() {
    restoreProperty(el, "type", typeDescr);
    restoreProperty(el, "value", valueDescr);
    restoreProperty(el, "files", filesDescr);
  }
  __name(restore, "restore");
  el[fakeFiles] = {
    restore
  };
  Object.defineProperties(el, {
    files: {
      configurable: true,
      get: /* @__PURE__ */ __name(() => files, "get")
    },
    value: {
      configurable: true,
      get: /* @__PURE__ */ __name(() => files.length ? `C:\\fakepath\\${files[0].name}` : "", "get"),
      set(v2) {
        if (v2 === "") {
          restore();
        } else {
          var _valueDescr_set;
          valueDescr === null || valueDescr === void 0 ? void 0 : (_valueDescr_set = valueDescr.set) === null || _valueDescr_set === void 0 ? void 0 : _valueDescr_set.call(el, v2);
        }
      }
    },
    type: {
      configurable: true,
      get: /* @__PURE__ */ __name(() => "file", "get"),
      set(v2) {
        if (v2 !== "file") {
          restore();
          el.type = v2;
        }
      }
    }
  });
}
__name(setFiles, "setFiles");

// ../node_modules/@testing-library/user-event/dist/esm/utility/upload.js
async function upload(element, fileOrFiles) {
  const input2 = isElementType(element, "label") ? element.control : element;
  if (!input2 || !isElementType(input2, "input", {
    type: "file"
  })) {
    throw new TypeError(`The ${input2 === element ? "given" : "associated"} ${input2 === null || input2 === void 0 ? void 0 : input2.tagName} element does not accept file uploads`);
  }
  if (isDisabled2(element)) return;
  const files = (Array.isArray(fileOrFiles) ? fileOrFiles : [
    fileOrFiles
  ]).filter((file) => !this.config.applyAccept || isAcceptableFile(file, input2.accept)).slice(0, input2.multiple ? void 0 : 1);
  const fileDialog = /* @__PURE__ */ __name(() => {
    var _input_files;
    if (files.length === ((_input_files = input2.files) === null || _input_files === void 0 ? void 0 : _input_files.length) && files.every((f3, i2) => {
      var _input_files2;
      return f3 === ((_input_files2 = input2.files) === null || _input_files2 === void 0 ? void 0 : _input_files2.item(i2));
    })) {
      return;
    }
    setFiles(input2, createFileList(getWindow(element), files));
    this.dispatchUIEvent(input2, "input");
    this.dispatchUIEvent(input2, "change");
  }, "fileDialog");
  input2.addEventListener("fileDialog", fileDialog);
  await this.click(element);
  input2.removeEventListener("fileDialog", fileDialog);
}
__name(upload, "upload");
function normalize3(nameOrType) {
  return nameOrType.toLowerCase().replace(/(\.|\/)jpg\b/g, "$1jpeg");
}
__name(normalize3, "normalize");
function isAcceptableFile(file, accept) {
  if (!accept) {
    return true;
  }
  const wildcards = [
    "audio/*",
    "image/*",
    "video/*"
  ];
  return normalize3(accept).trim().split(/\s*,\s*/).some((acceptToken) => {
    if (acceptToken.startsWith(".")) {
      return normalize3(file.name).endsWith(acceptToken);
    } else if (wildcards.includes(acceptToken)) {
      return normalize3(file.type).startsWith(acceptToken.replace("*", ""));
    }
    return normalize3(file.type) === acceptToken;
  });
}
__name(isAcceptableFile, "isAcceptableFile");

// ../node_modules/@testing-library/user-event/dist/esm/setup/api.js
var userEventApi = {
  click,
  dblClick,
  tripleClick,
  hover,
  unhover,
  tab,
  keyboard,
  copy,
  cut,
  paste,
  pointer,
  clear,
  deselectOptions,
  selectOptions,
  type: type3,
  upload
};

// ../node_modules/@testing-library/user-event/dist/esm/setup/wrapAsync.js
function wrapAsync(implementation) {
  return getConfig().asyncWrapper(implementation);
}
__name(wrapAsync, "wrapAsync");

// ../node_modules/@testing-library/user-event/dist/esm/setup/setup.js
var defaultOptionsDirect = {
  applyAccept: true,
  autoModify: true,
  delay: 0,
  document: globalThis.document,
  keyboardMap: defaultKeyMap,
  pointerMap: defaultKeyMap2,
  pointerEventsCheck: PointerEventsCheckLevel.EachApiCall,
  skipAutoClose: false,
  skipClick: false,
  skipHover: false,
  writeToClipboard: false,
  advanceTimers: /* @__PURE__ */ __name(() => Promise.resolve(), "advanceTimers")
};
var defaultOptionsSetup = {
  ...defaultOptionsDirect,
  writeToClipboard: true
};
function createConfig(options = {}, defaults = defaultOptionsSetup, node) {
  const document2 = getDocument2(options, node, defaults);
  return {
    ...defaults,
    ...options,
    document: document2
  };
}
__name(createConfig, "createConfig");
function setupMain(options = {}) {
  const config3 = createConfig(options);
  prepareDocument(config3.document);
  patchFocus(getWindow(config3.document).HTMLElement);
  var _config_document_defaultView;
  const view = (_config_document_defaultView = config3.document.defaultView) !== null && _config_document_defaultView !== void 0 ? _config_document_defaultView : (
    /* istanbul ignore next */
    globalThis.window
  );
  attachClipboardStubToView(view);
  return createInstance(config3).api;
}
__name(setupMain, "setupMain");
function setupDirect({ keyboardState, pointerState, ...options } = {}, node) {
  const config3 = createConfig(options, defaultOptionsDirect, node);
  prepareDocument(config3.document);
  patchFocus(getWindow(config3.document).HTMLElement);
  var _ref;
  const system = (_ref = pointerState !== null && pointerState !== void 0 ? pointerState : keyboardState) !== null && _ref !== void 0 ? _ref : new System();
  return {
    api: createInstance(config3, system).api,
    system
  };
}
__name(setupDirect, "setupDirect");
function setupSub(options) {
  return createInstance({
    ...this.config,
    ...options
  }, this.system).api;
}
__name(setupSub, "setupSub");
function wrapAndBindImpl(instance, impl) {
  function method(...args) {
    setLevelRef(instance, ApiLevel.Call);
    return wrapAsync(() => impl.apply(instance, args).then(async (ret) => {
      await wait(instance.config);
      return ret;
    }));
  }
  __name(method, "method");
  Object.defineProperty(method, "name", {
    get: /* @__PURE__ */ __name(() => impl.name, "get")
  });
  return method;
}
__name(wrapAndBindImpl, "wrapAndBindImpl");
function createInstance(config3, system = new System()) {
  const instance = {};
  Object.assign(instance, {
    config: config3,
    dispatchEvent: dispatchEvent.bind(instance),
    dispatchUIEvent: dispatchUIEvent.bind(instance),
    system,
    levelRefs: {},
    ...userEventApi
  });
  return {
    instance,
    api: {
      ...Object.fromEntries(Object.entries(userEventApi).map(([name, api]) => [
        name,
        wrapAndBindImpl(instance, api)
      ])),
      setup: setupSub.bind(instance)
    }
  };
}
__name(createInstance, "createInstance");
function getDocument2(options, node, defaults) {
  var _options_document, _ref;
  return (_ref = (_options_document = options.document) !== null && _options_document !== void 0 ? _options_document : node && getDocumentFromNode(node)) !== null && _ref !== void 0 ? _ref : defaults.document;
}
__name(getDocument2, "getDocument");

// ../node_modules/@testing-library/user-event/dist/esm/setup/directApi.js
var directApi_exports = {};
__export(directApi_exports, {
  clear: () => clear2,
  click: () => click2,
  copy: () => copy2,
  cut: () => cut2,
  dblClick: () => dblClick2,
  deselectOptions: () => deselectOptions2,
  hover: () => hover2,
  keyboard: () => keyboard2,
  paste: () => paste2,
  pointer: () => pointer2,
  selectOptions: () => selectOptions2,
  tab: () => tab2,
  tripleClick: () => tripleClick2,
  type: () => type4,
  unhover: () => unhover2,
  upload: () => upload2
});
function clear2(element) {
  return setupDirect().api.clear(element);
}
__name(clear2, "clear");
function click2(element, options = {}) {
  return setupDirect(options, element).api.click(element);
}
__name(click2, "click");
function copy2(options = {}) {
  return setupDirect(options).api.copy();
}
__name(copy2, "copy");
function cut2(options = {}) {
  return setupDirect(options).api.cut();
}
__name(cut2, "cut");
function dblClick2(element, options = {}) {
  return setupDirect(options).api.dblClick(element);
}
__name(dblClick2, "dblClick");
function deselectOptions2(select, values, options = {}) {
  return setupDirect(options).api.deselectOptions(select, values);
}
__name(deselectOptions2, "deselectOptions");
function hover2(element, options = {}) {
  return setupDirect(options).api.hover(element);
}
__name(hover2, "hover");
async function keyboard2(text, options = {}) {
  const { api, system } = setupDirect(options);
  return api.keyboard(text).then(() => system);
}
__name(keyboard2, "keyboard");
async function pointer2(input2, options = {}) {
  const { api, system } = setupDirect(options);
  return api.pointer(input2).then(() => system);
}
__name(pointer2, "pointer");
function paste2(clipboardData, options) {
  return setupDirect(options).api.paste(clipboardData);
}
__name(paste2, "paste");
function selectOptions2(select, values, options = {}) {
  return setupDirect(options).api.selectOptions(select, values);
}
__name(selectOptions2, "selectOptions");
function tripleClick2(element, options = {}) {
  return setupDirect(options).api.tripleClick(element);
}
__name(tripleClick2, "tripleClick");
function type4(element, text, options = {}) {
  return setupDirect(options, element).api.type(element, text, options);
}
__name(type4, "type");
function unhover2(element, options = {}) {
  const { api, system } = setupDirect(options);
  system.pointer.setMousePosition({
    target: element
  });
  return api.unhover(element);
}
__name(unhover2, "unhover");
function upload2(element, fileOrFiles, options = {}) {
  return setupDirect(options).api.upload(element, fileOrFiles);
}
__name(upload2, "upload");
function tab2(options = {}) {
  return setupDirect().api.tab(options);
}
__name(tab2, "tab");

// ../node_modules/@testing-library/user-event/dist/esm/setup/index.js
var userEvent = {
  ...directApi_exports,
  setup: setupMain
};

// src/test/testing-library.ts
import { once } from "storybook/internal/client-logger";
import { instrument } from "storybook/internal/instrumenter";
var testingLibrary = instrument(
  { ...dom_esm_exports },
  {
    getKeys: /* @__PURE__ */ __name((obj) => Object.keys(obj).filter((key) => key !== "eventWrapper"), "getKeys"),
    intercept: /* @__PURE__ */ __name((method, path) => path[0] === "fireEvent" || method.startsWith("find") || method.startsWith("waitFor"), "intercept")
  }
);
testingLibrary.screen = new Proxy(testingLibrary.screen, {
  get(target, prop, receiver) {
    if (typeof window !== "undefined" && globalThis.location?.href?.includes("viewMode=docs")) {
      once.warn(dedent`
        You are using Testing Library's \`screen\` object while the story is rendered in docs mode. This will likely lead to issues, as multiple stories are rendered in the same page and therefore screen will potentially find multiple elements. Use the \`canvas\` utility from the story context instead, which will scope the queries to each story's canvas.

        More info: https://storybook.js.org/docs/writing-tests/interaction-testing?ref=error#querying-the-canvas
      `);
    }
    return Reflect.get(target, prop, receiver);
  }
});
var {
  buildQueries: buildQueries2,
  configure: configure2,
  createEvent: createEvent3,
  fireEvent: fireEvent2,
  findAllByAltText: findAllByAltText2,
  findAllByDisplayValue: findAllByDisplayValue2,
  findAllByLabelText: findAllByLabelText2,
  findAllByPlaceholderText: findAllByPlaceholderText2,
  findAllByRole: findAllByRole2,
  findAllByTestId: findAllByTestId2,
  findAllByText: findAllByText2,
  findAllByTitle: findAllByTitle2,
  findByAltText: findByAltText2,
  findByDisplayValue: findByDisplayValue2,
  findByLabelText: findByLabelText2,
  findByPlaceholderText: findByPlaceholderText2,
  findByRole: findByRole2,
  findByTestId: findByTestId2,
  findByText: findByText2,
  findByTitle: findByTitle2,
  getAllByAltText: getAllByAltText2,
  getAllByDisplayValue: getAllByDisplayValue2,
  getAllByLabelText: getAllByLabelText2,
  getAllByPlaceholderText: getAllByPlaceholderText2,
  getAllByRole: getAllByRole2,
  getAllByTestId: getAllByTestId2,
  getAllByText: getAllByText2,
  getAllByTitle: getAllByTitle2,
  getByAltText: getByAltText2,
  getByDisplayValue: getByDisplayValue2,
  getByLabelText: getByLabelText2,
  getByPlaceholderText: getByPlaceholderText2,
  getByRole: getByRole2,
  getByTestId: getByTestId2,
  getByText: getByText2,
  getByTitle: getByTitle2,
  getConfig: getConfig2,
  getDefaultNormalizer: getDefaultNormalizer2,
  getElementError: getElementError2,
  getNodeText: getNodeText2,
  getQueriesForElement: getQueriesForElement2,
  getRoles: getRoles2,
  getSuggestedQuery: getSuggestedQuery2,
  isInaccessible: isInaccessible2,
  logDOM: logDOM2,
  logRoles: logRoles2,
  prettyDOM: prettyDOM2,
  queries: queries2,
  queryAllByAltText: queryAllByAltText2,
  queryAllByAttribute: queryAllByAttribute2,
  queryAllByDisplayValue: queryAllByDisplayValue2,
  queryAllByLabelText: queryAllByLabelText2,
  queryAllByPlaceholderText: queryAllByPlaceholderText2,
  queryAllByRole: queryAllByRole2,
  queryAllByTestId: queryAllByTestId2,
  queryAllByText: queryAllByText2,
  queryAllByTitle: queryAllByTitle2,
  queryByAltText: queryByAltText2,
  queryByAttribute: queryByAttribute2,
  queryByDisplayValue: queryByDisplayValue2,
  queryByLabelText: queryByLabelText2,
  queryByPlaceholderText: queryByPlaceholderText2,
  queryByRole: queryByRole2,
  queryByTestId: queryByTestId2,
  queryByText: queryByText2,
  queryByTitle: queryByTitle2,
  queryHelpers: queryHelpers2,
  screen: screen2,
  waitFor: waitFor2,
  waitForElementToBeRemoved: waitForElementToBeRemoved2,
  within,
  prettyFormat: prettyFormat2
} = testingLibrary;
var uninstrumentedUserEvent = userEvent;
var { userEvent: userEvent2 } = instrument(
  { userEvent },
  { intercept: true, getKeys: /* @__PURE__ */ __name((obj) => Object.keys(obj).filter((key) => key !== "eventWrapper"), "getKeys") }
);

// src/test/index.ts
var { expect: expect3 } = instrument2(
  { expect: expect2 },
  {
    getKeys: /* @__PURE__ */ __name((obj, depth) => {
      if ("constructor" in obj && obj.constructor === Assertion) {
        const privateApi = ["assert", "__methods", "__flags", "_obj"];
        const keys2 = Object.keys(Object.getPrototypeOf(obj)).filter(
          (it) => !privateApi.includes(it)
        );
        return depth > 2 ? keys2 : [...keys2, "not"];
      }
      if ("any" in obj) {
        return Object.keys(obj).filter((it) => it !== "any");
      }
      return Object.keys(obj);
    }, "getKeys"),
    mutate: true,
    intercept: /* @__PURE__ */ __name((method) => method !== "expect", "intercept")
  }
);
var sb = {
  mock: /* @__PURE__ */ __name(() => {
  }, "mock")
};
export {
  buildQueries2 as buildQueries,
  clearAllMocks,
  configure2 as configure,
  createEvent3 as createEvent,
  expect3 as expect,
  findAllByAltText2 as findAllByAltText,
  findAllByDisplayValue2 as findAllByDisplayValue,
  findAllByLabelText2 as findAllByLabelText,
  findAllByPlaceholderText2 as findAllByPlaceholderText,
  findAllByRole2 as findAllByRole,
  findAllByTestId2 as findAllByTestId,
  findAllByText2 as findAllByText,
  findAllByTitle2 as findAllByTitle,
  findByAltText2 as findByAltText,
  findByDisplayValue2 as findByDisplayValue,
  findByLabelText2 as findByLabelText,
  findByPlaceholderText2 as findByPlaceholderText,
  findByRole2 as findByRole,
  findByTestId2 as findByTestId,
  findByText2 as findByText,
  findByTitle2 as findByTitle,
  fireEvent2 as fireEvent,
  fn2 as fn,
  getAllByAltText2 as getAllByAltText,
  getAllByDisplayValue2 as getAllByDisplayValue,
  getAllByLabelText2 as getAllByLabelText,
  getAllByPlaceholderText2 as getAllByPlaceholderText,
  getAllByRole2 as getAllByRole,
  getAllByTestId2 as getAllByTestId,
  getAllByText2 as getAllByText,
  getAllByTitle2 as getAllByTitle,
  getByAltText2 as getByAltText,
  getByDisplayValue2 as getByDisplayValue,
  getByLabelText2 as getByLabelText,
  getByPlaceholderText2 as getByPlaceholderText,
  getByRole2 as getByRole,
  getByTestId2 as getByTestId,
  getByText2 as getByText,
  getByTitle2 as getByTitle,
  getConfig2 as getConfig,
  getDefaultNormalizer2 as getDefaultNormalizer,
  getElementError2 as getElementError,
  getNodeText2 as getNodeText,
  getQueriesForElement2 as getQueriesForElement,
  getRoles2 as getRoles,
  getSuggestedQuery2 as getSuggestedQuery,
  isInaccessible2 as isInaccessible,
  isMockFunction,
  logDOM2 as logDOM,
  logRoles2 as logRoles,
  mocked,
  mocks,
  onMockCall,
  prettyDOM2 as prettyDOM,
  prettyFormat2 as prettyFormat,
  queries2 as queries,
  queryAllByAltText2 as queryAllByAltText,
  queryAllByAttribute2 as queryAllByAttribute,
  queryAllByDisplayValue2 as queryAllByDisplayValue,
  queryAllByLabelText2 as queryAllByLabelText,
  queryAllByPlaceholderText2 as queryAllByPlaceholderText,
  queryAllByRole2 as queryAllByRole,
  queryAllByTestId2 as queryAllByTestId,
  queryAllByText2 as queryAllByText,
  queryAllByTitle2 as queryAllByTitle,
  queryByAltText2 as queryByAltText,
  queryByAttribute2 as queryByAttribute,
  queryByDisplayValue2 as queryByDisplayValue,
  queryByLabelText2 as queryByLabelText,
  queryByPlaceholderText2 as queryByPlaceholderText,
  queryByRole2 as queryByRole,
  queryByTestId2 as queryByTestId,
  queryByText2 as queryByText,
  queryByTitle2 as queryByTitle,
  queryHelpers2 as queryHelpers,
  resetAllMocks,
  restoreAllMocks,
  sb,
  screen2 as screen,
  spyOn2 as spyOn,
  uninstrumentedUserEvent,
  userEvent2 as userEvent,
  waitFor2 as waitFor,
  waitForElementToBeRemoved2 as waitForElementToBeRemoved,
  within
};
