import CJS_COMPAT_NODE_URL_39zvq8kkt8 from 'node:url';
import CJS_COMPAT_NODE_PATH_39zvq8kkt8 from 'node:path';
import CJS_COMPAT_NODE_MODULE_39zvq8kkt8 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_39zvq8kkt8.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_39zvq8kkt8.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_39zvq8kkt8.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  require_pretty_hrtime
} from "../_node-chunks/chunk-V7ZKSK5R.js";
import {
  ansi_styles_default,
  boxen,
  require_string_width,
  stripAnsi
} from "../_node-chunks/chunk-VTD5TIUC.js";
import "../_node-chunks/chunk-2JVDNALC.js";
import {
  execaSync,
  optionalEnvToBoolean
} from "../_node-chunks/chunk-F6NUZ463.js";
import "../_node-chunks/chunk-C4ROO6RE.js";
import {
  require_prompts,
  require_src
} from "../_node-chunks/chunk-VWYF3SCI.js";
import {
  require_picocolors
} from "../_node-chunks/chunk-4WKJYHSS.js";
import {
  __commonJS,
  __export,
  __name,
  __require,
  __toESM
} from "../_node-chunks/chunk-JBW3FROT.js";

// ../node_modules/are-we-there-yet/lib/tracker-base.js
var require_tracker_base = __commonJS({
  "../node_modules/are-we-there-yet/lib/tracker-base.js"(exports, module) {
    "use strict";
    var EventEmitter = __require("events");
    var trackerId = 0;
    var TrackerBase = class extends EventEmitter {
      static {
        __name(this, "TrackerBase");
      }
      constructor(name) {
        super();
        this.id = ++trackerId;
        this.name = name;
      }
    };
    module.exports = TrackerBase;
  }
});

// ../node_modules/are-we-there-yet/lib/tracker.js
var require_tracker = __commonJS({
  "../node_modules/are-we-there-yet/lib/tracker.js"(exports, module) {
    "use strict";
    var TrackerBase = require_tracker_base();
    var Tracker = class extends TrackerBase {
      static {
        __name(this, "Tracker");
      }
      constructor(name, todo) {
        super(name);
        this.workDone = 0;
        this.workTodo = todo || 0;
      }
      completed() {
        return this.workTodo === 0 ? 0 : this.workDone / this.workTodo;
      }
      addWork(work) {
        this.workTodo += work;
        this.emit("change", this.name, this.completed(), this);
      }
      completeWork(work) {
        this.workDone += work;
        if (this.workDone > this.workTodo) {
          this.workDone = this.workTodo;
        }
        this.emit("change", this.name, this.completed(), this);
      }
      finish() {
        this.workTodo = this.workDone = 1;
        this.emit("change", this.name, 1, this);
      }
    };
    module.exports = Tracker;
  }
});

// ../node_modules/are-we-there-yet/lib/tracker-stream.js
var require_tracker_stream = __commonJS({
  "../node_modules/are-we-there-yet/lib/tracker-stream.js"(exports, module) {
    "use strict";
    var stream = __require("stream");
    var Tracker = require_tracker();
    var TrackerStream = class extends stream.Transform {
      static {
        __name(this, "TrackerStream");
      }
      constructor(name, size, options) {
        super(options);
        this.tracker = new Tracker(name, size);
        this.name = name;
        this.id = this.tracker.id;
        this.tracker.on("change", this.trackerChange.bind(this));
      }
      trackerChange(name, completion) {
        this.emit("change", name, completion, this);
      }
      _transform(data, encoding, cb) {
        this.tracker.completeWork(data.length ? data.length : 1);
        this.push(data);
        cb();
      }
      _flush(cb) {
        this.tracker.finish();
        cb();
      }
      completed() {
        return this.tracker.completed();
      }
      addWork(work) {
        return this.tracker.addWork(work);
      }
      finish() {
        return this.tracker.finish();
      }
    };
    module.exports = TrackerStream;
  }
});

// ../node_modules/are-we-there-yet/lib/tracker-group.js
var require_tracker_group = __commonJS({
  "../node_modules/are-we-there-yet/lib/tracker-group.js"(exports, module) {
    "use strict";
    var TrackerBase = require_tracker_base();
    var Tracker = require_tracker();
    var TrackerStream = require_tracker_stream();
    var TrackerGroup = class _TrackerGroup extends TrackerBase {
      static {
        __name(this, "TrackerGroup");
      }
      parentGroup = null;
      trackers = [];
      completion = {};
      weight = {};
      totalWeight = 0;
      finished = false;
      bubbleChange = bubbleChange(this);
      nameInTree() {
        var names = [];
        var from = this;
        while (from) {
          names.unshift(from.name);
          from = from.parentGroup;
        }
        return names.join("/");
      }
      addUnit(unit, weight) {
        if (unit.addUnit) {
          var toTest = this;
          while (toTest) {
            if (unit === toTest) {
              throw new Error(
                "Attempted to add tracker group " + unit.name + " to tree that already includes it " + this.nameInTree(this)
              );
            }
            toTest = toTest.parentGroup;
          }
          unit.parentGroup = this;
        }
        this.weight[unit.id] = weight || 1;
        this.totalWeight += this.weight[unit.id];
        this.trackers.push(unit);
        this.completion[unit.id] = unit.completed();
        unit.on("change", this.bubbleChange);
        if (!this.finished) {
          this.emit("change", unit.name, this.completion[unit.id], unit);
        }
        return unit;
      }
      completed() {
        if (this.trackers.length === 0) {
          return 0;
        }
        var valPerWeight = 1 / this.totalWeight;
        var completed = 0;
        for (var ii = 0; ii < this.trackers.length; ii++) {
          var trackerId = this.trackers[ii].id;
          completed += valPerWeight * this.weight[trackerId] * this.completion[trackerId];
        }
        return completed;
      }
      newGroup(name, weight) {
        return this.addUnit(new _TrackerGroup(name), weight);
      }
      newItem(name, todo, weight) {
        return this.addUnit(new Tracker(name, todo), weight);
      }
      newStream(name, todo, weight) {
        return this.addUnit(new TrackerStream(name, todo), weight);
      }
      finish() {
        this.finished = true;
        if (!this.trackers.length) {
          this.addUnit(new Tracker(), 1, true);
        }
        for (var ii = 0; ii < this.trackers.length; ii++) {
          var tracker = this.trackers[ii];
          tracker.finish();
          tracker.removeListener("change", this.bubbleChange);
        }
        this.emit("change", this.name, 1, this);
      }
      debug(depth = 0) {
        const indent = " ".repeat(depth);
        let output = `${indent}${this.name || "top"}: ${this.completed()}
`;
        this.trackers.forEach(function(tracker) {
          output += tracker instanceof _TrackerGroup ? tracker.debug(depth + 1) : `${indent} ${tracker.name}: ${tracker.completed()}
`;
        });
        return output;
      }
    };
    function bubbleChange(trackerGroup) {
      return function(name, completed, tracker) {
        trackerGroup.completion[tracker.id] = completed;
        if (trackerGroup.finished) {
          return;
        }
        trackerGroup.emit("change", name || trackerGroup.name, trackerGroup.completed(), trackerGroup);
      };
    }
    __name(bubbleChange, "bubbleChange");
    module.exports = TrackerGroup;
  }
});

// ../node_modules/are-we-there-yet/lib/index.js
var require_lib = __commonJS({
  "../node_modules/are-we-there-yet/lib/index.js"(exports) {
    "use strict";
    exports.TrackerGroup = require_tracker_group();
    exports.Tracker = require_tracker();
    exports.TrackerStream = require_tracker_stream();
  }
});

// ../node_modules/console-control-strings/index.js
var require_console_control_strings = __commonJS({
  "../node_modules/console-control-strings/index.js"(exports) {
    "use strict";
    var prefix = "\x1B[";
    exports.up = /* @__PURE__ */ __name(function up(num) {
      return prefix + (num || "") + "A";
    }, "up");
    exports.down = /* @__PURE__ */ __name(function down(num) {
      return prefix + (num || "") + "B";
    }, "down");
    exports.forward = /* @__PURE__ */ __name(function forward(num) {
      return prefix + (num || "") + "C";
    }, "forward");
    exports.back = /* @__PURE__ */ __name(function back(num) {
      return prefix + (num || "") + "D";
    }, "back");
    exports.nextLine = /* @__PURE__ */ __name(function nextLine(num) {
      return prefix + (num || "") + "E";
    }, "nextLine");
    exports.previousLine = /* @__PURE__ */ __name(function previousLine(num) {
      return prefix + (num || "") + "F";
    }, "previousLine");
    exports.horizontalAbsolute = /* @__PURE__ */ __name(function horizontalAbsolute(num) {
      if (num == null) throw new Error("horizontalAboslute requires a column to position to");
      return prefix + num + "G";
    }, "horizontalAbsolute");
    exports.eraseData = /* @__PURE__ */ __name(function eraseData() {
      return prefix + "J";
    }, "eraseData");
    exports.eraseLine = /* @__PURE__ */ __name(function eraseLine() {
      return prefix + "K";
    }, "eraseLine");
    exports.goto = function(x2, y2) {
      return prefix + y2 + ";" + x2 + "H";
    };
    exports.gotoSOL = function() {
      return "\r";
    };
    exports.beep = function() {
      return "\x07";
    };
    exports.hideCursor = /* @__PURE__ */ __name(function hideCursor() {
      return prefix + "?25l";
    }, "hideCursor");
    exports.showCursor = /* @__PURE__ */ __name(function showCursor() {
      return prefix + "?25h";
    }, "showCursor");
    var colors2 = {
      reset: 0,
      // styles
      bold: 1,
      italic: 3,
      underline: 4,
      inverse: 7,
      // resets
      stopBold: 22,
      stopItalic: 23,
      stopUnderline: 24,
      stopInverse: 27,
      // colors
      white: 37,
      black: 30,
      blue: 34,
      cyan: 36,
      green: 32,
      magenta: 35,
      red: 31,
      yellow: 33,
      bgWhite: 47,
      bgBlack: 40,
      bgBlue: 44,
      bgCyan: 46,
      bgGreen: 42,
      bgMagenta: 45,
      bgRed: 41,
      bgYellow: 43,
      grey: 90,
      brightBlack: 90,
      brightRed: 91,
      brightGreen: 92,
      brightYellow: 93,
      brightBlue: 94,
      brightMagenta: 95,
      brightCyan: 96,
      brightWhite: 97,
      bgGrey: 100,
      bgBrightBlack: 100,
      bgBrightRed: 101,
      bgBrightGreen: 102,
      bgBrightYellow: 103,
      bgBrightBlue: 104,
      bgBrightMagenta: 105,
      bgBrightCyan: 106,
      bgBrightWhite: 107
    };
    exports.color = /* @__PURE__ */ __name(function color(colorWith) {
      if (arguments.length !== 1 || !Array.isArray(colorWith)) {
        colorWith = Array.prototype.slice.call(arguments);
      }
      return prefix + colorWith.map(colorNameToCode).join(";") + "m";
    }, "color");
    function colorNameToCode(color) {
      if (colors2[color] != null) return colors2[color];
      throw new Error("Unknown color or style name: " + color);
    }
    __name(colorNameToCode, "colorNameToCode");
  }
});

// ../node_modules/wide-align/align.js
var require_align = __commonJS({
  "../node_modules/wide-align/align.js"(exports) {
    "use strict";
    var stringWidth2 = require_string_width();
    exports.center = alignCenter;
    exports.left = alignLeft;
    exports.right = alignRight;
    function createPadding(width) {
      var result = "";
      var string = " ";
      var n = width;
      do {
        if (n % 2) {
          result += string;
        }
        n = Math.floor(n / 2);
        string += string;
      } while (n);
      return result;
    }
    __name(createPadding, "createPadding");
    function alignLeft(str, width) {
      var trimmed = str.trimRight();
      if (trimmed.length === 0 && str.length >= width) return str;
      var padding = "";
      var strWidth = stringWidth2(trimmed);
      if (strWidth < width) {
        padding = createPadding(width - strWidth);
      }
      return trimmed + padding;
    }
    __name(alignLeft, "alignLeft");
    function alignRight(str, width) {
      var trimmed = str.trimLeft();
      if (trimmed.length === 0 && str.length >= width) return str;
      var padding = "";
      var strWidth = stringWidth2(trimmed);
      if (strWidth < width) {
        padding = createPadding(width - strWidth);
      }
      return padding + trimmed;
    }
    __name(alignRight, "alignRight");
    function alignCenter(str, width) {
      var trimmed = str.trim();
      if (trimmed.length === 0 && str.length >= width) return str;
      var padLeft = "";
      var padRight = "";
      var strWidth = stringWidth2(trimmed);
      if (strWidth < width) {
        var padLeftBy = parseInt((width - strWidth) / 2, 10);
        padLeft = createPadding(padLeftBy);
        padRight = createPadding(width - (strWidth + padLeftBy));
      }
      return padLeft + trimmed + padRight;
    }
    __name(alignCenter, "alignCenter");
  }
});

// ../node_modules/aproba/index.js
var require_aproba = __commonJS({
  "../node_modules/aproba/index.js"(exports, module) {
    "use strict";
    module.exports = validate;
    function isArguments(thingy) {
      return thingy != null && typeof thingy === "object" && thingy.hasOwnProperty("callee");
    }
    __name(isArguments, "isArguments");
    var types = {
      "*": { label: "any", check: /* @__PURE__ */ __name(() => true, "check") },
      A: { label: "array", check: /* @__PURE__ */ __name((_) => Array.isArray(_) || isArguments(_), "check") },
      S: { label: "string", check: /* @__PURE__ */ __name((_) => typeof _ === "string", "check") },
      N: { label: "number", check: /* @__PURE__ */ __name((_) => typeof _ === "number", "check") },
      F: { label: "function", check: /* @__PURE__ */ __name((_) => typeof _ === "function", "check") },
      O: { label: "object", check: /* @__PURE__ */ __name((_) => typeof _ === "object" && _ != null && !types.A.check(_) && !types.E.check(_), "check") },
      B: { label: "boolean", check: /* @__PURE__ */ __name((_) => typeof _ === "boolean", "check") },
      E: { label: "error", check: /* @__PURE__ */ __name((_) => _ instanceof Error, "check") },
      Z: { label: "null", check: /* @__PURE__ */ __name((_) => _ == null, "check") }
    };
    function addSchema(schema, arity) {
      const group = arity[schema.length] = arity[schema.length] || [];
      if (group.indexOf(schema) === -1) group.push(schema);
    }
    __name(addSchema, "addSchema");
    function validate(rawSchemas, args) {
      if (arguments.length !== 2) throw wrongNumberOfArgs(["SA"], arguments.length);
      if (!rawSchemas) throw missingRequiredArg(0, "rawSchemas");
      if (!args) throw missingRequiredArg(1, "args");
      if (!types.S.check(rawSchemas)) throw invalidType(0, ["string"], rawSchemas);
      if (!types.A.check(args)) throw invalidType(1, ["array"], args);
      const schemas = rawSchemas.split("|");
      const arity = {};
      schemas.forEach((schema) => {
        for (let ii = 0; ii < schema.length; ++ii) {
          const type = schema[ii];
          if (!types[type]) throw unknownType(ii, type);
        }
        if (/E.*E/.test(schema)) throw moreThanOneError(schema);
        addSchema(schema, arity);
        if (/E/.test(schema)) {
          addSchema(schema.replace(/E.*$/, "E"), arity);
          addSchema(schema.replace(/E/, "Z"), arity);
          if (schema.length === 1) addSchema("", arity);
        }
      });
      let matching = arity[args.length];
      if (!matching) {
        throw wrongNumberOfArgs(Object.keys(arity), args.length);
      }
      for (let ii = 0; ii < args.length; ++ii) {
        let newMatching = matching.filter((schema) => {
          const type = schema[ii];
          const typeCheck = types[type].check;
          return typeCheck(args[ii]);
        });
        if (!newMatching.length) {
          const labels = matching.map((_) => types[_[ii]].label).filter((_) => _ != null);
          throw invalidType(ii, labels, args[ii]);
        }
        matching = newMatching;
      }
    }
    __name(validate, "validate");
    function missingRequiredArg(num) {
      return newException("EMISSINGARG", "Missing required argument #" + (num + 1));
    }
    __name(missingRequiredArg, "missingRequiredArg");
    function unknownType(num, type) {
      return newException("EUNKNOWNTYPE", "Unknown type " + type + " in argument #" + (num + 1));
    }
    __name(unknownType, "unknownType");
    function invalidType(num, expectedTypes, value) {
      let valueType;
      Object.keys(types).forEach((typeCode) => {
        if (types[typeCode].check(value)) valueType = types[typeCode].label;
      });
      return newException("EINVALIDTYPE", "Argument #" + (num + 1) + ": Expected " + englishList(expectedTypes) + " but got " + valueType);
    }
    __name(invalidType, "invalidType");
    function englishList(list) {
      return list.join(", ").replace(/, ([^,]+)$/, " or $1");
    }
    __name(englishList, "englishList");
    function wrongNumberOfArgs(expected, got) {
      const english = englishList(expected);
      const args = expected.every((ex) => ex.length === 1) ? "argument" : "arguments";
      return newException("EWRONGARGCOUNT", "Expected " + english + " " + args + " but got " + got);
    }
    __name(wrongNumberOfArgs, "wrongNumberOfArgs");
    function moreThanOneError(schema) {
      return newException(
        "ETOOMANYERRORTYPES",
        'Only one error type per argument signature is allowed, more than one found in "' + schema + '"'
      );
    }
    __name(moreThanOneError, "moreThanOneError");
    function newException(code, msg) {
      const err = new TypeError(msg);
      err.code = code;
      if (Error.captureStackTrace) Error.captureStackTrace(err, validate);
      return err;
    }
    __name(newException, "newException");
  }
});

// ../node_modules/gauge/node_modules/ansi-regex/index.js
var require_ansi_regex = __commonJS({
  "../node_modules/gauge/node_modules/ansi-regex/index.js"(exports, module) {
    "use strict";
    module.exports = ({ onlyFirst = false } = {}) => {
      const pattern = [
        "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
        "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"
      ].join("|");
      return new RegExp(pattern, onlyFirst ? void 0 : "g");
    };
  }
});

// ../node_modules/gauge/node_modules/strip-ansi/index.js
var require_strip_ansi = __commonJS({
  "../node_modules/gauge/node_modules/strip-ansi/index.js"(exports, module) {
    "use strict";
    var ansiRegex2 = require_ansi_regex();
    module.exports = (string) => typeof string === "string" ? string.replace(ansiRegex2(), "") : string;
  }
});

// ../node_modules/gauge/lib/wide-truncate.js
var require_wide_truncate = __commonJS({
  "../node_modules/gauge/lib/wide-truncate.js"(exports, module) {
    "use strict";
    var stringWidth2 = require_string_width();
    var stripAnsi3 = require_strip_ansi();
    module.exports = wideTruncate;
    function wideTruncate(str, target) {
      if (stringWidth2(str) === 0) {
        return str;
      }
      if (target <= 0) {
        return "";
      }
      if (stringWidth2(str) <= target) {
        return str;
      }
      var noAnsi = stripAnsi3(str);
      var ansiSize = str.length + noAnsi.length;
      var truncated = str.slice(0, target + ansiSize);
      while (stringWidth2(truncated) > target) {
        truncated = truncated.slice(0, -1);
      }
      return truncated;
    }
    __name(wideTruncate, "wideTruncate");
  }
});

// ../node_modules/gauge/lib/error.js
var require_error = __commonJS({
  "../node_modules/gauge/lib/error.js"(exports) {
    "use strict";
    var util = __require("util");
    var User = exports.User = /* @__PURE__ */ __name(function User2(msg) {
      var err = new Error(msg);
      Error.captureStackTrace(err, User2);
      err.code = "EGAUGE";
      return err;
    }, "User");
    exports.MissingTemplateValue = /* @__PURE__ */ __name(function MissingTemplateValue(item, values) {
      var err = new User(util.format('Missing template value "%s"', item.type));
      Error.captureStackTrace(err, MissingTemplateValue);
      err.template = item;
      err.values = values;
      return err;
    }, "MissingTemplateValue");
    exports.Internal = /* @__PURE__ */ __name(function Internal(msg) {
      var err = new Error(msg);
      Error.captureStackTrace(err, Internal);
      err.code = "EGAUGEINTERNAL";
      return err;
    }, "Internal");
  }
});

// ../node_modules/gauge/lib/template-item.js
var require_template_item = __commonJS({
  "../node_modules/gauge/lib/template-item.js"(exports, module) {
    "use strict";
    var stringWidth2 = require_string_width();
    module.exports = TemplateItem;
    function isPercent(num) {
      if (typeof num !== "string") {
        return false;
      }
      return num.slice(-1) === "%";
    }
    __name(isPercent, "isPercent");
    function percent(num) {
      return Number(num.slice(0, -1)) / 100;
    }
    __name(percent, "percent");
    function TemplateItem(values, outputLength) {
      this.overallOutputLength = outputLength;
      this.finished = false;
      this.type = null;
      this.value = null;
      this.length = null;
      this.maxLength = null;
      this.minLength = null;
      this.kerning = null;
      this.align = "left";
      this.padLeft = 0;
      this.padRight = 0;
      this.index = null;
      this.first = null;
      this.last = null;
      if (typeof values === "string") {
        this.value = values;
      } else {
        for (var prop in values) {
          this[prop] = values[prop];
        }
      }
      if (isPercent(this.length)) {
        this.length = Math.round(this.overallOutputLength * percent(this.length));
      }
      if (isPercent(this.minLength)) {
        this.minLength = Math.round(this.overallOutputLength * percent(this.minLength));
      }
      if (isPercent(this.maxLength)) {
        this.maxLength = Math.round(this.overallOutputLength * percent(this.maxLength));
      }
      return this;
    }
    __name(TemplateItem, "TemplateItem");
    TemplateItem.prototype = {};
    TemplateItem.prototype.getBaseLength = function() {
      var length = this.length;
      if (length == null && typeof this.value === "string" && this.maxLength == null && this.minLength == null) {
        length = stringWidth2(this.value);
      }
      return length;
    };
    TemplateItem.prototype.getLength = function() {
      var length = this.getBaseLength();
      if (length == null) {
        return null;
      }
      return length + this.padLeft + this.padRight;
    };
    TemplateItem.prototype.getMaxLength = function() {
      if (this.maxLength == null) {
        return null;
      }
      return this.maxLength + this.padLeft + this.padRight;
    };
    TemplateItem.prototype.getMinLength = function() {
      if (this.minLength == null) {
        return null;
      }
      return this.minLength + this.padLeft + this.padRight;
    };
  }
});

// ../node_modules/gauge/lib/render-template.js
var require_render_template = __commonJS({
  "../node_modules/gauge/lib/render-template.js"(exports, module) {
    "use strict";
    var align = require_align();
    var validate = require_aproba();
    var wideTruncate = require_wide_truncate();
    var error2 = require_error();
    var TemplateItem = require_template_item();
    function renderValueWithValues(values) {
      return function(item) {
        return renderValue(item, values);
      };
    }
    __name(renderValueWithValues, "renderValueWithValues");
    var renderTemplate = module.exports = function(width, template, values) {
      var items = prepareItems(width, template, values);
      var rendered = items.map(renderValueWithValues(values)).join("");
      return align.left(wideTruncate(rendered, width), width);
    };
    function preType(item) {
      var cappedTypeName = item.type[0].toUpperCase() + item.type.slice(1);
      return "pre" + cappedTypeName;
    }
    __name(preType, "preType");
    function postType(item) {
      var cappedTypeName = item.type[0].toUpperCase() + item.type.slice(1);
      return "post" + cappedTypeName;
    }
    __name(postType, "postType");
    function hasPreOrPost(item, values) {
      if (!item.type) {
        return;
      }
      return values[preType(item)] || values[postType(item)];
    }
    __name(hasPreOrPost, "hasPreOrPost");
    function generatePreAndPost(baseItem, parentValues) {
      var item = Object.assign({}, baseItem);
      var values = Object.create(parentValues);
      var template = [];
      var pre = preType(item);
      var post = postType(item);
      if (values[pre]) {
        template.push({ value: values[pre] });
        values[pre] = null;
      }
      item.minLength = null;
      item.length = null;
      item.maxLength = null;
      template.push(item);
      values[item.type] = values[item.type];
      if (values[post]) {
        template.push({ value: values[post] });
        values[post] = null;
      }
      return function($1, $2, length) {
        return renderTemplate(length, template, values);
      };
    }
    __name(generatePreAndPost, "generatePreAndPost");
    function prepareItems(width, template, values) {
      function cloneAndObjectify(item, index, arr) {
        var cloned = new TemplateItem(item, width);
        var type = cloned.type;
        if (cloned.value == null) {
          if (!(type in values)) {
            if (cloned.default == null) {
              throw new error2.MissingTemplateValue(cloned, values);
            } else {
              cloned.value = cloned.default;
            }
          } else {
            cloned.value = values[type];
          }
        }
        if (cloned.value == null || cloned.value === "") {
          return null;
        }
        cloned.index = index;
        cloned.first = index === 0;
        cloned.last = index === arr.length - 1;
        if (hasPreOrPost(cloned, values)) {
          cloned.value = generatePreAndPost(cloned, values);
        }
        return cloned;
      }
      __name(cloneAndObjectify, "cloneAndObjectify");
      var output = template.map(cloneAndObjectify).filter(function(item) {
        return item != null;
      });
      var remainingSpace = width;
      var variableCount = output.length;
      function consumeSpace(length) {
        if (length > remainingSpace) {
          length = remainingSpace;
        }
        remainingSpace -= length;
      }
      __name(consumeSpace, "consumeSpace");
      function finishSizing(item, length) {
        if (item.finished) {
          throw new error2.Internal("Tried to finish template item that was already finished");
        }
        if (length === Infinity) {
          throw new error2.Internal("Length of template item cannot be infinity");
        }
        if (length != null) {
          item.length = length;
        }
        item.minLength = null;
        item.maxLength = null;
        --variableCount;
        item.finished = true;
        if (item.length == null) {
          item.length = item.getBaseLength();
        }
        if (item.length == null) {
          throw new error2.Internal("Finished template items must have a length");
        }
        consumeSpace(item.getLength());
      }
      __name(finishSizing, "finishSizing");
      output.forEach(function(item) {
        if (!item.kerning) {
          return;
        }
        var prevPadRight = item.first ? 0 : output[item.index - 1].padRight;
        if (!item.first && prevPadRight < item.kerning) {
          item.padLeft = item.kerning - prevPadRight;
        }
        if (!item.last) {
          item.padRight = item.kerning;
        }
      });
      output.forEach(function(item) {
        if (item.getBaseLength() == null) {
          return;
        }
        finishSizing(item);
      });
      var resized = 0;
      var resizing;
      var hunkSize;
      do {
        resizing = false;
        hunkSize = Math.round(remainingSpace / variableCount);
        output.forEach(function(item) {
          if (item.finished) {
            return;
          }
          if (!item.maxLength) {
            return;
          }
          if (item.getMaxLength() < hunkSize) {
            finishSizing(item, item.maxLength);
            resizing = true;
          }
        });
      } while (resizing && resized++ < output.length);
      if (resizing) {
        throw new error2.Internal("Resize loop iterated too many times while determining maxLength");
      }
      resized = 0;
      do {
        resizing = false;
        hunkSize = Math.round(remainingSpace / variableCount);
        output.forEach(function(item) {
          if (item.finished) {
            return;
          }
          if (!item.minLength) {
            return;
          }
          if (item.getMinLength() >= hunkSize) {
            finishSizing(item, item.minLength);
            resizing = true;
          }
        });
      } while (resizing && resized++ < output.length);
      if (resizing) {
        throw new error2.Internal("Resize loop iterated too many times while determining minLength");
      }
      hunkSize = Math.round(remainingSpace / variableCount);
      output.forEach(function(item) {
        if (item.finished) {
          return;
        }
        finishSizing(item, hunkSize);
      });
      return output;
    }
    __name(prepareItems, "prepareItems");
    function renderFunction(item, values, length) {
      validate("OON", arguments);
      if (item.type) {
        return item.value(values, values[item.type + "Theme"] || {}, length);
      } else {
        return item.value(values, {}, length);
      }
    }
    __name(renderFunction, "renderFunction");
    function renderValue(item, values) {
      var length = item.getBaseLength();
      var value = typeof item.value === "function" ? renderFunction(item, values, length) : item.value;
      if (value == null || value === "") {
        return "";
      }
      var alignWith = align[item.align] || align.left;
      var leftPadding = item.padLeft ? align.left("", item.padLeft) : "";
      var rightPadding = item.padRight ? align.right("", item.padRight) : "";
      var truncated = wideTruncate(String(value), length);
      var aligned = alignWith(truncated, length);
      return leftPadding + aligned + rightPadding;
    }
    __name(renderValue, "renderValue");
  }
});

// ../node_modules/gauge/lib/plumbing.js
var require_plumbing = __commonJS({
  "../node_modules/gauge/lib/plumbing.js"(exports, module) {
    "use strict";
    var consoleControl = require_console_control_strings();
    var renderTemplate = require_render_template();
    var validate = require_aproba();
    var Plumbing = module.exports = function(theme, template, width) {
      if (!width) {
        width = 80;
      }
      validate("OAN", [theme, template, width]);
      this.showing = false;
      this.theme = theme;
      this.width = width;
      this.template = template;
    };
    Plumbing.prototype = {};
    Plumbing.prototype.setTheme = function(theme) {
      validate("O", [theme]);
      this.theme = theme;
    };
    Plumbing.prototype.setTemplate = function(template) {
      validate("A", [template]);
      this.template = template;
    };
    Plumbing.prototype.setWidth = function(width) {
      validate("N", [width]);
      this.width = width;
    };
    Plumbing.prototype.hide = function() {
      return consoleControl.gotoSOL() + consoleControl.eraseLine();
    };
    Plumbing.prototype.hideCursor = consoleControl.hideCursor;
    Plumbing.prototype.showCursor = consoleControl.showCursor;
    Plumbing.prototype.show = function(status) {
      var values = Object.create(this.theme);
      for (var key in status) {
        values[key] = status[key];
      }
      return renderTemplate(this.width, this.template, values).trim() + consoleControl.color("reset") + consoleControl.eraseLine() + consoleControl.gotoSOL();
    };
  }
});

// ../node_modules/has-unicode/index.js
var require_has_unicode = __commonJS({
  "../node_modules/has-unicode/index.js"(exports, module) {
    "use strict";
    var os = __require("os");
    var hasUnicode = module.exports = function() {
      if (os.type() == "Windows_NT") {
        return false;
      }
      var isUTF8 = /UTF-?8$/i;
      var ctype = process.env.LC_ALL || process.env.LC_CTYPE || process.env.LANG;
      return isUTF8.test(ctype);
    };
  }
});

// ../node_modules/color-support/index.js
var require_color_support = __commonJS({
  "../node_modules/color-support/index.js"(exports, module) {
    module.exports = colorSupport({ alwaysReturn: true }, colorSupport);
    function hasNone(obj, options) {
      obj.level = 0;
      obj.hasBasic = false;
      obj.has256 = false;
      obj.has16m = false;
      if (!options.alwaysReturn) {
        return false;
      }
      return obj;
    }
    __name(hasNone, "hasNone");
    function hasBasic(obj) {
      obj.hasBasic = true;
      obj.has256 = false;
      obj.has16m = false;
      obj.level = 1;
      return obj;
    }
    __name(hasBasic, "hasBasic");
    function has256(obj) {
      obj.hasBasic = true;
      obj.has256 = true;
      obj.has16m = false;
      obj.level = 2;
      return obj;
    }
    __name(has256, "has256");
    function has16m(obj) {
      obj.hasBasic = true;
      obj.has256 = true;
      obj.has16m = true;
      obj.level = 3;
      return obj;
    }
    __name(has16m, "has16m");
    function colorSupport(options, obj) {
      options = options || {};
      obj = obj || {};
      if (typeof options.level === "number") {
        switch (options.level) {
          case 0:
            return hasNone(obj, options);
          case 1:
            return hasBasic(obj);
          case 2:
            return has256(obj);
          case 3:
            return has16m(obj);
        }
      }
      obj.level = 0;
      obj.hasBasic = false;
      obj.has256 = false;
      obj.has16m = false;
      if (typeof process === "undefined" || !process || !process.stdout || !process.env || !process.platform) {
        return hasNone(obj, options);
      }
      var env = options.env || process.env;
      var stream = options.stream || process.stdout;
      var term = options.term || env.TERM || "";
      var platform = options.platform || process.platform;
      if (!options.ignoreTTY && !stream.isTTY) {
        return hasNone(obj, options);
      }
      if (!options.ignoreDumb && term === "dumb" && !env.COLORTERM) {
        return hasNone(obj, options);
      }
      if (platform === "win32") {
        return hasBasic(obj);
      }
      if (env.TMUX) {
        return has256(obj);
      }
      if (!options.ignoreCI && (env.CI || env.TEAMCITY_VERSION)) {
        if (env.TRAVIS) {
          return has256(obj);
        } else {
          return hasNone(obj, options);
        }
      }
      switch (env.TERM_PROGRAM) {
        case "iTerm.app":
          var ver = env.TERM_PROGRAM_VERSION || "0.";
          if (/^[0-2]\./.test(ver)) {
            return has256(obj);
          } else {
            return has16m(obj);
          }
        case "HyperTerm":
        case "Hyper":
          return has16m(obj);
        case "MacTerm":
          return has16m(obj);
        case "Apple_Terminal":
          return has256(obj);
      }
      if (/^xterm-256/.test(term)) {
        return has256(obj);
      }
      if (/^screen|^xterm|^vt100|color|ansi|cygwin|linux/i.test(term)) {
        return hasBasic(obj);
      }
      if (env.COLORTERM) {
        return hasBasic(obj);
      }
      return hasNone(obj, options);
    }
    __name(colorSupport, "colorSupport");
  }
});

// ../node_modules/gauge/lib/has-color.js
var require_has_color = __commonJS({
  "../node_modules/gauge/lib/has-color.js"(exports, module) {
    "use strict";
    var colorSupport = require_color_support();
    module.exports = colorSupport().hasBasic;
  }
});

// ../node_modules/gauge/node_modules/signal-exit/dist/cjs/signals.js
var require_signals = __commonJS({
  "../node_modules/gauge/node_modules/signal-exit/dist/cjs/signals.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.signals = void 0;
    exports.signals = [];
    exports.signals.push("SIGHUP", "SIGINT", "SIGTERM");
    if (process.platform !== "win32") {
      exports.signals.push(
        "SIGALRM",
        "SIGABRT",
        "SIGVTALRM",
        "SIGXCPU",
        "SIGXFSZ",
        "SIGUSR2",
        "SIGTRAP",
        "SIGSYS",
        "SIGQUIT",
        "SIGIOT"
        // should detect profiler and enable/disable accordingly.
        // see #21
        // 'SIGPROF'
      );
    }
    if (process.platform === "linux") {
      exports.signals.push("SIGIO", "SIGPOLL", "SIGPWR", "SIGSTKFLT");
    }
  }
});

// ../node_modules/gauge/node_modules/signal-exit/dist/cjs/index.js
var require_cjs = __commonJS({
  "../node_modules/gauge/node_modules/signal-exit/dist/cjs/index.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.unload = exports.load = exports.onExit = exports.signals = void 0;
    var signals_js_1 = require_signals();
    Object.defineProperty(exports, "signals", { enumerable: true, get: /* @__PURE__ */ __name(function() {
      return signals_js_1.signals;
    }, "get") });
    var processOk = /* @__PURE__ */ __name((process3) => !!process3 && typeof process3 === "object" && typeof process3.removeListener === "function" && typeof process3.emit === "function" && typeof process3.reallyExit === "function" && typeof process3.listeners === "function" && typeof process3.kill === "function" && typeof process3.pid === "number" && typeof process3.on === "function", "processOk");
    var kExitEmitter = Symbol.for("signal-exit emitter");
    var global = globalThis;
    var ObjectDefineProperty = Object.defineProperty.bind(Object);
    var Emitter = class {
      static {
        __name(this, "Emitter");
      }
      emitted = {
        afterExit: false,
        exit: false
      };
      listeners = {
        afterExit: [],
        exit: []
      };
      count = 0;
      id = Math.random();
      constructor() {
        if (global[kExitEmitter]) {
          return global[kExitEmitter];
        }
        ObjectDefineProperty(global, kExitEmitter, {
          value: this,
          writable: false,
          enumerable: false,
          configurable: false
        });
      }
      on(ev, fn) {
        this.listeners[ev].push(fn);
      }
      removeListener(ev, fn) {
        const list = this.listeners[ev];
        const i = list.indexOf(fn);
        if (i === -1) {
          return;
        }
        if (i === 0 && list.length === 1) {
          list.length = 0;
        } else {
          list.splice(i, 1);
        }
      }
      emit(ev, code, signal) {
        if (this.emitted[ev]) {
          return false;
        }
        this.emitted[ev] = true;
        let ret = false;
        for (const fn of this.listeners[ev]) {
          ret = fn(code, signal) === true || ret;
        }
        if (ev === "exit") {
          ret = this.emit("afterExit", code, signal) || ret;
        }
        return ret;
      }
    };
    var SignalExitBase = class {
      static {
        __name(this, "SignalExitBase");
      }
    };
    var signalExitWrap = /* @__PURE__ */ __name((handler) => {
      return {
        onExit(cb, opts) {
          return handler.onExit(cb, opts);
        },
        load() {
          return handler.load();
        },
        unload() {
          return handler.unload();
        }
      };
    }, "signalExitWrap");
    var SignalExitFallback = class extends SignalExitBase {
      static {
        __name(this, "SignalExitFallback");
      }
      onExit() {
        return () => {
        };
      }
      load() {
      }
      unload() {
      }
    };
    var SignalExit = class extends SignalExitBase {
      static {
        __name(this, "SignalExit");
      }
      // "SIGHUP" throws an `ENOSYS` error on Windows,
      // so use a supported signal instead
      /* c8 ignore start */
      #hupSig = process2.platform === "win32" ? "SIGINT" : "SIGHUP";
      /* c8 ignore stop */
      #emitter = new Emitter();
      #process;
      #originalProcessEmit;
      #originalProcessReallyExit;
      #sigListeners = {};
      #loaded = false;
      constructor(process3) {
        super();
        this.#process = process3;
        this.#sigListeners = {};
        for (const sig of signals_js_1.signals) {
          this.#sigListeners[sig] = () => {
            const listeners = this.#process.listeners(sig);
            let { count } = this.#emitter;
            const p = process3;
            if (typeof p.__signal_exit_emitter__ === "object" && typeof p.__signal_exit_emitter__.count === "number") {
              count += p.__signal_exit_emitter__.count;
            }
            if (listeners.length === count) {
              this.unload();
              const ret = this.#emitter.emit("exit", null, sig);
              const s = sig === "SIGHUP" ? this.#hupSig : sig;
              if (!ret)
                process3.kill(process3.pid, s);
            }
          };
        }
        this.#originalProcessReallyExit = process3.reallyExit;
        this.#originalProcessEmit = process3.emit;
      }
      onExit(cb, opts) {
        if (!processOk(this.#process)) {
          return () => {
          };
        }
        if (this.#loaded === false) {
          this.load();
        }
        const ev = opts?.alwaysLast ? "afterExit" : "exit";
        this.#emitter.on(ev, cb);
        return () => {
          this.#emitter.removeListener(ev, cb);
          if (this.#emitter.listeners["exit"].length === 0 && this.#emitter.listeners["afterExit"].length === 0) {
            this.unload();
          }
        };
      }
      load() {
        if (this.#loaded) {
          return;
        }
        this.#loaded = true;
        this.#emitter.count += 1;
        for (const sig of signals_js_1.signals) {
          try {
            const fn = this.#sigListeners[sig];
            if (fn)
              this.#process.on(sig, fn);
          } catch (_) {
          }
        }
        this.#process.emit = (ev, ...a) => {
          return this.#processEmit(ev, ...a);
        };
        this.#process.reallyExit = (code) => {
          return this.#processReallyExit(code);
        };
      }
      unload() {
        if (!this.#loaded) {
          return;
        }
        this.#loaded = false;
        signals_js_1.signals.forEach((sig) => {
          const listener = this.#sigListeners[sig];
          if (!listener) {
            throw new Error("Listener not defined for signal: " + sig);
          }
          try {
            this.#process.removeListener(sig, listener);
          } catch (_) {
          }
        });
        this.#process.emit = this.#originalProcessEmit;
        this.#process.reallyExit = this.#originalProcessReallyExit;
        this.#emitter.count -= 1;
      }
      #processReallyExit(code) {
        if (!processOk(this.#process)) {
          return 0;
        }
        this.#process.exitCode = code || 0;
        this.#emitter.emit("exit", this.#process.exitCode, null);
        return this.#originalProcessReallyExit.call(this.#process, this.#process.exitCode);
      }
      #processEmit(ev, ...args) {
        const og = this.#originalProcessEmit;
        if (ev === "exit" && processOk(this.#process)) {
          if (typeof args[0] === "number") {
            this.#process.exitCode = args[0];
          }
          const ret = og.call(this.#process, ev, ...args);
          this.#emitter.emit("exit", this.#process.exitCode, null);
          return ret;
        } else {
          return og.call(this.#process, ev, ...args);
        }
      }
    };
    var process2 = globalThis.process;
    _a = signalExitWrap(processOk(process2) ? new SignalExit(process2) : new SignalExitFallback()), /**
     * Called when the process is exiting, whether via signal, explicit
     * exit, or running out of stuff to do.
     *
     * If the global process object is not suitable for instrumentation,
     * then this will be a no-op.
     *
     * Returns a function that may be used to unload signal-exit.
     */
    exports.onExit = _a.onExit, /**
     * Load the listeners.  Likely you never need to call this, unless
     * doing a rather deep integration with signal-exit functionality.
     * Mostly exposed for the benefit of testing.
     *
     * @internal
     */
    exports.load = _a.load, /**
     * Unload the listeners.  Likely you never need to call this, unless
     * doing a rather deep integration with signal-exit functionality.
     * Mostly exposed for the benefit of testing.
     *
     * @internal
     */
    exports.unload = _a.unload;
  }
});

// ../node_modules/gauge/lib/spin.js
var require_spin = __commonJS({
  "../node_modules/gauge/lib/spin.js"(exports, module) {
    "use strict";
    module.exports = /* @__PURE__ */ __name(function spin(spinstr, spun) {
      return spinstr[spun % spinstr.length];
    }, "spin");
  }
});

// ../node_modules/gauge/lib/progress-bar.js
var require_progress_bar = __commonJS({
  "../node_modules/gauge/lib/progress-bar.js"(exports, module) {
    "use strict";
    var validate = require_aproba();
    var renderTemplate = require_render_template();
    var wideTruncate = require_wide_truncate();
    var stringWidth2 = require_string_width();
    module.exports = function(theme, width, completed) {
      validate("ONN", [theme, width, completed]);
      if (completed < 0) {
        completed = 0;
      }
      if (completed > 1) {
        completed = 1;
      }
      if (width <= 0) {
        return "";
      }
      var sofar = Math.round(width * completed);
      var rest = width - sofar;
      var template = [
        { type: "complete", value: repeat(theme.complete, sofar), length: sofar },
        { type: "remaining", value: repeat(theme.remaining, rest), length: rest }
      ];
      return renderTemplate(width, template, theme);
    };
    function repeat(string, width) {
      var result = "";
      var n = width;
      do {
        if (n % 2) {
          result += string;
        }
        n = Math.floor(n / 2);
        string += string;
      } while (n && stringWidth2(result) < width);
      return wideTruncate(result, width);
    }
    __name(repeat, "repeat");
  }
});

// ../node_modules/gauge/lib/base-theme.js
var require_base_theme = __commonJS({
  "../node_modules/gauge/lib/base-theme.js"(exports, module) {
    "use strict";
    var spin = require_spin();
    var progressBar = require_progress_bar();
    module.exports = {
      activityIndicator: /* @__PURE__ */ __name(function(values, theme) {
        if (values.spun == null) {
          return;
        }
        return spin(theme, values.spun);
      }, "activityIndicator"),
      progressbar: /* @__PURE__ */ __name(function(values, theme, width) {
        if (values.completed == null) {
          return;
        }
        return progressBar(theme, width, values.completed);
      }, "progressbar")
    };
  }
});

// ../node_modules/gauge/lib/theme-set.js
var require_theme_set = __commonJS({
  "../node_modules/gauge/lib/theme-set.js"(exports, module) {
    "use strict";
    module.exports = function() {
      return ThemeSetProto.newThemeSet();
    };
    var ThemeSetProto = {};
    ThemeSetProto.baseTheme = require_base_theme();
    ThemeSetProto.newTheme = function(parent, theme) {
      if (!theme) {
        theme = parent;
        parent = this.baseTheme;
      }
      return Object.assign({}, parent, theme);
    };
    ThemeSetProto.getThemeNames = function() {
      return Object.keys(this.themes);
    };
    ThemeSetProto.addTheme = function(name, parent, theme) {
      this.themes[name] = this.newTheme(parent, theme);
    };
    ThemeSetProto.addToAllThemes = function(theme) {
      var themes = this.themes;
      Object.keys(themes).forEach(function(name) {
        Object.assign(themes[name], theme);
      });
      Object.assign(this.baseTheme, theme);
    };
    ThemeSetProto.getTheme = function(name) {
      if (!this.themes[name]) {
        throw this.newMissingThemeError(name);
      }
      return this.themes[name];
    };
    ThemeSetProto.setDefault = function(opts, name) {
      if (name == null) {
        name = opts;
        opts = {};
      }
      var platform = opts.platform == null ? "fallback" : opts.platform;
      var hasUnicode = !!opts.hasUnicode;
      var hasColor = !!opts.hasColor;
      if (!this.defaults[platform]) {
        this.defaults[platform] = { true: {}, false: {} };
      }
      this.defaults[platform][hasUnicode][hasColor] = name;
    };
    ThemeSetProto.getDefault = function(opts) {
      if (!opts) {
        opts = {};
      }
      var platformName = opts.platform || process.platform;
      var platform = this.defaults[platformName] || this.defaults.fallback;
      var hasUnicode = !!opts.hasUnicode;
      var hasColor = !!opts.hasColor;
      if (!platform) {
        throw this.newMissingDefaultThemeError(platformName, hasUnicode, hasColor);
      }
      if (!platform[hasUnicode][hasColor]) {
        if (hasUnicode && hasColor && platform[!hasUnicode][hasColor]) {
          hasUnicode = false;
        } else if (hasUnicode && hasColor && platform[hasUnicode][!hasColor]) {
          hasColor = false;
        } else if (hasUnicode && hasColor && platform[!hasUnicode][!hasColor]) {
          hasUnicode = false;
          hasColor = false;
        } else if (hasUnicode && !hasColor && platform[!hasUnicode][hasColor]) {
          hasUnicode = false;
        } else if (!hasUnicode && hasColor && platform[hasUnicode][!hasColor]) {
          hasColor = false;
        } else if (platform === this.defaults.fallback) {
          throw this.newMissingDefaultThemeError(platformName, hasUnicode, hasColor);
        }
      }
      if (platform[hasUnicode][hasColor]) {
        return this.getTheme(platform[hasUnicode][hasColor]);
      } else {
        return this.getDefault(Object.assign({}, opts, { platform: "fallback" }));
      }
    };
    ThemeSetProto.newMissingThemeError = /* @__PURE__ */ __name(function newMissingThemeError(name) {
      var err = new Error('Could not find a gauge theme named "' + name + '"');
      Error.captureStackTrace.call(err, newMissingThemeError);
      err.theme = name;
      err.code = "EMISSINGTHEME";
      return err;
    }, "newMissingThemeError");
    ThemeSetProto.newMissingDefaultThemeError = /* @__PURE__ */ __name(function newMissingDefaultThemeError(platformName, hasUnicode, hasColor) {
      var err = new Error(
        "Could not find a gauge theme for your platform/unicode/color use combo:\n    platform = " + platformName + "\n    hasUnicode = " + hasUnicode + "\n    hasColor = " + hasColor
      );
      Error.captureStackTrace.call(err, newMissingDefaultThemeError);
      err.platform = platformName;
      err.hasUnicode = hasUnicode;
      err.hasColor = hasColor;
      err.code = "EMISSINGTHEME";
      return err;
    }, "newMissingDefaultThemeError");
    ThemeSetProto.newThemeSet = function() {
      var themeset = /* @__PURE__ */ __name(function(opts) {
        return themeset.getDefault(opts);
      }, "themeset");
      return Object.assign(themeset, ThemeSetProto, {
        themes: Object.assign({}, this.themes),
        baseTheme: Object.assign({}, this.baseTheme),
        defaults: JSON.parse(JSON.stringify(this.defaults || {}))
      });
    };
  }
});

// ../node_modules/gauge/lib/themes.js
var require_themes = __commonJS({
  "../node_modules/gauge/lib/themes.js"(exports, module) {
    "use strict";
    var color = require_console_control_strings().color;
    var ThemeSet = require_theme_set();
    var themes = module.exports = new ThemeSet();
    themes.addTheme("ASCII", {
      preProgressbar: "[",
      postProgressbar: "]",
      progressbarTheme: {
        complete: "#",
        remaining: "."
      },
      activityIndicatorTheme: "-\\|/",
      preSubsection: ">"
    });
    themes.addTheme("colorASCII", themes.getTheme("ASCII"), {
      progressbarTheme: {
        preComplete: color("bgBrightWhite", "brightWhite"),
        complete: "#",
        postComplete: color("reset"),
        preRemaining: color("bgBrightBlack", "brightBlack"),
        remaining: ".",
        postRemaining: color("reset")
      }
    });
    themes.addTheme("brailleSpinner", {
      preProgressbar: "(",
      postProgressbar: ")",
      progressbarTheme: {
        complete: "#",
        remaining: "\u2802"
      },
      activityIndicatorTheme: "\u280B\u2819\u2839\u2838\u283C\u2834\u2826\u2827\u2807\u280F",
      preSubsection: ">"
    });
    themes.addTheme("colorBrailleSpinner", themes.getTheme("brailleSpinner"), {
      progressbarTheme: {
        preComplete: color("bgBrightWhite", "brightWhite"),
        complete: "#",
        postComplete: color("reset"),
        preRemaining: color("bgBrightBlack", "brightBlack"),
        remaining: "\u2802",
        postRemaining: color("reset")
      }
    });
    themes.setDefault({}, "ASCII");
    themes.setDefault({ hasColor: true }, "colorASCII");
    themes.setDefault({ platform: "darwin", hasUnicode: true }, "brailleSpinner");
    themes.setDefault({ platform: "darwin", hasUnicode: true, hasColor: true }, "colorBrailleSpinner");
    themes.setDefault({ platform: "linux", hasUnicode: true }, "brailleSpinner");
    themes.setDefault({ platform: "linux", hasUnicode: true, hasColor: true }, "colorBrailleSpinner");
  }
});

// ../node_modules/gauge/lib/set-interval.js
var require_set_interval = __commonJS({
  "../node_modules/gauge/lib/set-interval.js"(exports, module) {
    "use strict";
    module.exports = setInterval;
  }
});

// ../node_modules/gauge/lib/process.js
var require_process = __commonJS({
  "../node_modules/gauge/lib/process.js"(exports, module) {
    "use strict";
    module.exports = process;
  }
});

// ../node_modules/gauge/lib/set-immediate.js
var require_set_immediate = __commonJS({
  "../node_modules/gauge/lib/set-immediate.js"(exports, module) {
    "use strict";
    var process2 = require_process();
    try {
      module.exports = setImmediate;
    } catch (ex) {
      module.exports = process2.nextTick;
    }
  }
});

// ../node_modules/gauge/lib/index.js
var require_lib2 = __commonJS({
  "../node_modules/gauge/lib/index.js"(exports, module) {
    "use strict";
    var Plumbing = require_plumbing();
    var hasUnicode = require_has_unicode();
    var hasColor = require_has_color();
    var onExit = require_cjs().onExit;
    var defaultThemes = require_themes();
    var setInterval2 = require_set_interval();
    var process2 = require_process();
    var setImmediate2 = require_set_immediate();
    module.exports = Gauge;
    function callWith(obj, method) {
      return function() {
        return method.call(obj);
      };
    }
    __name(callWith, "callWith");
    function Gauge(arg1, arg2) {
      var options, writeTo;
      if (arg1 && arg1.write) {
        writeTo = arg1;
        options = arg2 || {};
      } else if (arg2 && arg2.write) {
        writeTo = arg2;
        options = arg1 || {};
      } else {
        writeTo = process2.stderr;
        options = arg1 || arg2 || {};
      }
      this._status = {
        spun: 0,
        section: "",
        subsection: ""
      };
      this._paused = false;
      this._disabled = true;
      this._showing = false;
      this._onScreen = false;
      this._needsRedraw = false;
      this._hideCursor = options.hideCursor == null ? true : options.hideCursor;
      this._fixedFramerate = options.fixedFramerate == null ? !/^v0\.8\./.test(process2.version) : options.fixedFramerate;
      this._lastUpdateAt = null;
      this._updateInterval = options.updateInterval == null ? 50 : options.updateInterval;
      this._themes = options.themes || defaultThemes;
      this._theme = options.theme;
      var theme = this._computeTheme(options.theme);
      var template = options.template || [
        { type: "progressbar", length: 20 },
        { type: "activityIndicator", kerning: 1, length: 1 },
        { type: "section", kerning: 1, default: "" },
        { type: "subsection", kerning: 1, default: "" }
      ];
      this.setWriteTo(writeTo, options.tty);
      var PlumbingClass = options.Plumbing || Plumbing;
      this._gauge = new PlumbingClass(theme, template, this.getWidth());
      this._$$doRedraw = callWith(this, this._doRedraw);
      this._$$handleSizeChange = callWith(this, this._handleSizeChange);
      this._cleanupOnExit = options.cleanupOnExit == null || options.cleanupOnExit;
      this._removeOnExit = null;
      if (options.enabled || options.enabled == null && this._tty && this._tty.isTTY) {
        this.enable();
      } else {
        this.disable();
      }
    }
    __name(Gauge, "Gauge");
    Gauge.prototype = {};
    Gauge.prototype.isEnabled = function() {
      return !this._disabled;
    };
    Gauge.prototype.setTemplate = function(template) {
      this._gauge.setTemplate(template);
      if (this._showing) {
        this._requestRedraw();
      }
    };
    Gauge.prototype._computeTheme = function(theme) {
      if (!theme) {
        theme = {};
      }
      if (typeof theme === "string") {
        theme = this._themes.getTheme(theme);
      } else if (Object.keys(theme).length === 0 || theme.hasUnicode != null || theme.hasColor != null) {
        var useUnicode = theme.hasUnicode == null ? hasUnicode() : theme.hasUnicode;
        var useColor = theme.hasColor == null ? hasColor : theme.hasColor;
        theme = this._themes.getDefault({
          hasUnicode: useUnicode,
          hasColor: useColor,
          platform: theme.platform
        });
      }
      return theme;
    };
    Gauge.prototype.setThemeset = function(themes) {
      this._themes = themes;
      this.setTheme(this._theme);
    };
    Gauge.prototype.setTheme = function(theme) {
      this._gauge.setTheme(this._computeTheme(theme));
      if (this._showing) {
        this._requestRedraw();
      }
      this._theme = theme;
    };
    Gauge.prototype._requestRedraw = function() {
      this._needsRedraw = true;
      if (!this._fixedFramerate) {
        this._doRedraw();
      }
    };
    Gauge.prototype.getWidth = function() {
      return (this._tty && this._tty.columns || 80) - 1;
    };
    Gauge.prototype.setWriteTo = function(writeTo, tty) {
      var enabled = !this._disabled;
      if (enabled) {
        this.disable();
      }
      this._writeTo = writeTo;
      this._tty = tty || writeTo === process2.stderr && process2.stdout.isTTY && process2.stdout || writeTo.isTTY && writeTo || this._tty;
      if (this._gauge) {
        this._gauge.setWidth(this.getWidth());
      }
      if (enabled) {
        this.enable();
      }
    };
    Gauge.prototype.enable = function() {
      if (!this._disabled) {
        return;
      }
      this._disabled = false;
      if (this._tty) {
        this._enableEvents();
      }
      if (this._showing) {
        this.show();
      }
    };
    Gauge.prototype.disable = function() {
      if (this._disabled) {
        return;
      }
      if (this._showing) {
        this._lastUpdateAt = null;
        this._showing = false;
        this._doRedraw();
        this._showing = true;
      }
      this._disabled = true;
      if (this._tty) {
        this._disableEvents();
      }
    };
    Gauge.prototype._enableEvents = function() {
      if (this._cleanupOnExit) {
        this._removeOnExit = onExit(callWith(this, this.disable));
      }
      this._tty.on("resize", this._$$handleSizeChange);
      if (this._fixedFramerate) {
        this.redrawTracker = setInterval2(this._$$doRedraw, this._updateInterval);
        if (this.redrawTracker.unref) {
          this.redrawTracker.unref();
        }
      }
    };
    Gauge.prototype._disableEvents = function() {
      this._tty.removeListener("resize", this._$$handleSizeChange);
      if (this._fixedFramerate) {
        clearInterval(this.redrawTracker);
      }
      if (this._removeOnExit) {
        this._removeOnExit();
      }
    };
    Gauge.prototype.hide = function(cb) {
      if (this._disabled) {
        return cb && process2.nextTick(cb);
      }
      if (!this._showing) {
        return cb && process2.nextTick(cb);
      }
      this._showing = false;
      this._doRedraw();
      cb && setImmediate2(cb);
    };
    Gauge.prototype.show = function(section, completed) {
      this._showing = true;
      if (typeof section === "string") {
        this._status.section = section;
      } else if (typeof section === "object") {
        var sectionKeys = Object.keys(section);
        for (var ii = 0; ii < sectionKeys.length; ++ii) {
          var key = sectionKeys[ii];
          this._status[key] = section[key];
        }
      }
      if (completed != null) {
        this._status.completed = completed;
      }
      if (this._disabled) {
        return;
      }
      this._requestRedraw();
    };
    Gauge.prototype.pulse = function(subsection) {
      this._status.subsection = subsection || "";
      this._status.spun++;
      if (this._disabled) {
        return;
      }
      if (!this._showing) {
        return;
      }
      this._requestRedraw();
    };
    Gauge.prototype._handleSizeChange = function() {
      this._gauge.setWidth(this._tty.columns - 1);
      this._requestRedraw();
    };
    Gauge.prototype._doRedraw = function() {
      if (this._disabled || this._paused) {
        return;
      }
      if (!this._fixedFramerate) {
        var now = Date.now();
        if (this._lastUpdateAt && now - this._lastUpdateAt < this._updateInterval) {
          return;
        }
        this._lastUpdateAt = now;
      }
      if (!this._showing && this._onScreen) {
        this._onScreen = false;
        var result = this._gauge.hide();
        if (this._hideCursor) {
          result += this._gauge.showCursor();
        }
        return this._writeTo.write(result);
      }
      if (!this._showing && !this._onScreen) {
        return;
      }
      if (this._showing && !this._onScreen) {
        this._onScreen = true;
        this._needsRedraw = true;
        if (this._hideCursor) {
          this._writeTo.write(this._gauge.hideCursor());
        }
      }
      if (!this._needsRedraw) {
        return;
      }
      if (!this._writeTo.write(this._gauge.show(this._status))) {
        this._paused = true;
        this._writeTo.on("drain", callWith(this, function() {
          this._paused = false;
          this._doRedraw();
        }));
      }
    };
  }
});

// ../node_modules/set-blocking/index.js
var require_set_blocking = __commonJS({
  "../node_modules/set-blocking/index.js"(exports, module) {
    module.exports = function(blocking) {
      [process.stdout, process.stderr].forEach(function(stream) {
        if (stream._handle && stream.isTTY && typeof stream._handle.setBlocking === "function") {
          stream._handle.setBlocking(blocking);
        }
      });
    };
  }
});

// ../node_modules/npmlog/lib/log.js
var require_log = __commonJS({
  "../node_modules/npmlog/lib/log.js"(exports, module) {
    "use strict";
    var Progress = require_lib();
    var Gauge = require_lib2();
    var EE = __require("events").EventEmitter;
    var log2 = exports = module.exports = new EE();
    var util = __require("util");
    var setBlocking = require_set_blocking();
    var consoleControl = require_console_control_strings();
    setBlocking(true);
    var stream = process.stderr;
    Object.defineProperty(log2, "stream", {
      set: /* @__PURE__ */ __name(function(newStream) {
        stream = newStream;
        if (this.gauge) {
          this.gauge.setWriteTo(stream, stream);
        }
      }, "set"),
      get: /* @__PURE__ */ __name(function() {
        return stream;
      }, "get")
    });
    var colorEnabled;
    log2.useColor = function() {
      return colorEnabled != null ? colorEnabled : stream.isTTY;
    };
    log2.enableColor = function() {
      colorEnabled = true;
      this.gauge.setTheme({ hasColor: colorEnabled, hasUnicode: unicodeEnabled });
    };
    log2.disableColor = function() {
      colorEnabled = false;
      this.gauge.setTheme({ hasColor: colorEnabled, hasUnicode: unicodeEnabled });
    };
    log2.level = "info";
    log2.gauge = new Gauge(stream, {
      enabled: false,
      // no progress bars unless asked
      theme: { hasColor: log2.useColor() },
      template: [
        { type: "progressbar", length: 20 },
        { type: "activityIndicator", kerning: 1, length: 1 },
        { type: "section", default: "" },
        ":",
        { type: "logline", kerning: 1, default: "" }
      ]
    });
    log2.tracker = new Progress.TrackerGroup();
    log2.progressEnabled = log2.gauge.isEnabled();
    var unicodeEnabled;
    log2.enableUnicode = function() {
      unicodeEnabled = true;
      this.gauge.setTheme({ hasColor: this.useColor(), hasUnicode: unicodeEnabled });
    };
    log2.disableUnicode = function() {
      unicodeEnabled = false;
      this.gauge.setTheme({ hasColor: this.useColor(), hasUnicode: unicodeEnabled });
    };
    log2.setGaugeThemeset = function(themes) {
      this.gauge.setThemeset(themes);
    };
    log2.setGaugeTemplate = function(template) {
      this.gauge.setTemplate(template);
    };
    log2.enableProgress = function() {
      if (this.progressEnabled || this._paused) {
        return;
      }
      this.progressEnabled = true;
      this.tracker.on("change", this.showProgress);
      this.gauge.enable();
    };
    log2.disableProgress = function() {
      if (!this.progressEnabled) {
        return;
      }
      this.progressEnabled = false;
      this.tracker.removeListener("change", this.showProgress);
      this.gauge.disable();
    };
    var trackerConstructors = ["newGroup", "newItem", "newStream"];
    var mixinLog = /* @__PURE__ */ __name(function(tracker) {
      Object.keys(log2).forEach(function(P2) {
        if (P2[0] === "_") {
          return;
        }
        if (trackerConstructors.filter(function(C) {
          return C === P2;
        }).length) {
          return;
        }
        if (tracker[P2]) {
          return;
        }
        if (typeof log2[P2] !== "function") {
          return;
        }
        var func = log2[P2];
        tracker[P2] = function() {
          return func.apply(log2, arguments);
        };
      });
      if (tracker instanceof Progress.TrackerGroup) {
        trackerConstructors.forEach(function(C) {
          var func = tracker[C];
          tracker[C] = function() {
            return mixinLog(func.apply(tracker, arguments));
          };
        });
      }
      return tracker;
    }, "mixinLog");
    trackerConstructors.forEach(function(C) {
      log2[C] = function() {
        return mixinLog(this.tracker[C].apply(this.tracker, arguments));
      };
    });
    log2.clearProgress = function(cb) {
      if (!this.progressEnabled) {
        return cb && process.nextTick(cb);
      }
      this.gauge.hide(cb);
    };
    log2.showProgress = function(name, completed) {
      if (!this.progressEnabled) {
        return;
      }
      var values = {};
      if (name) {
        values.section = name;
      }
      var last = log2.record[log2.record.length - 1];
      if (last) {
        values.subsection = last.prefix;
        var disp = log2.disp[last.level] || last.level;
        var logline = this._format(disp, log2.style[last.level]);
        if (last.prefix) {
          logline += " " + this._format(last.prefix, this.prefixStyle);
        }
        logline += " " + last.message.split(/\r?\n/)[0];
        values.logline = logline;
      }
      values.completed = completed || this.tracker.completed();
      this.gauge.show(values);
    }.bind(log2);
    log2.pause = function() {
      this._paused = true;
      if (this.progressEnabled) {
        this.gauge.disable();
      }
    };
    log2.resume = function() {
      if (!this._paused) {
        return;
      }
      this._paused = false;
      var b2 = this._buffer;
      this._buffer = [];
      b2.forEach(function(m) {
        this.emitLog(m);
      }, this);
      if (this.progressEnabled) {
        this.gauge.enable();
      }
    };
    log2._buffer = [];
    var id = 0;
    log2.record = [];
    log2.maxRecordSize = 1e4;
    log2.log = function(lvl, prefix, message) {
      var l = this.levels[lvl];
      if (l === void 0) {
        return this.emit("error", new Error(util.format(
          "Undefined log level: %j",
          lvl
        )));
      }
      var a = new Array(arguments.length - 2);
      var stack = null;
      for (var i = 2; i < arguments.length; i++) {
        var arg = a[i - 2] = arguments[i];
        if (typeof arg === "object" && arg instanceof Error && arg.stack) {
          Object.defineProperty(arg, "stack", {
            value: stack = arg.stack + "",
            enumerable: true,
            writable: true
          });
        }
      }
      if (stack) {
        a.unshift(stack + "\n");
      }
      message = util.format.apply(util, a);
      var m = {
        id: id++,
        level: lvl,
        prefix: String(prefix || ""),
        message,
        messageRaw: a
      };
      this.emit("log", m);
      this.emit("log." + lvl, m);
      if (m.prefix) {
        this.emit(m.prefix, m);
      }
      this.record.push(m);
      var mrs = this.maxRecordSize;
      var n = this.record.length - mrs;
      if (n > mrs / 10) {
        var newSize = Math.floor(mrs * 0.9);
        this.record = this.record.slice(-1 * newSize);
      }
      this.emitLog(m);
    }.bind(log2);
    log2.emitLog = function(m) {
      if (this._paused) {
        this._buffer.push(m);
        return;
      }
      if (this.progressEnabled) {
        this.gauge.pulse(m.prefix);
      }
      var l = this.levels[m.level];
      if (l === void 0) {
        return;
      }
      if (l < this.levels[this.level]) {
        return;
      }
      if (l > 0 && !isFinite(l)) {
        return;
      }
      var disp = log2.disp[m.level] != null ? log2.disp[m.level] : m.level;
      this.clearProgress();
      m.message.split(/\r?\n/).forEach(function(line) {
        var heading = this.heading;
        if (heading) {
          this.write(heading, this.headingStyle);
          this.write(" ");
        }
        this.write(disp, log2.style[m.level]);
        var p = m.prefix || "";
        if (p) {
          this.write(" ");
        }
        this.write(p, this.prefixStyle);
        this.write(" " + line + "\n");
      }, this);
      this.showProgress();
    };
    log2._format = function(msg, style) {
      if (!stream) {
        return;
      }
      var output = "";
      if (this.useColor()) {
        style = style || {};
        var settings = [];
        if (style.fg) {
          settings.push(style.fg);
        }
        if (style.bg) {
          settings.push("bg" + style.bg[0].toUpperCase() + style.bg.slice(1));
        }
        if (style.bold) {
          settings.push("bold");
        }
        if (style.underline) {
          settings.push("underline");
        }
        if (style.inverse) {
          settings.push("inverse");
        }
        if (settings.length) {
          output += consoleControl.color(settings);
        }
        if (style.beep) {
          output += consoleControl.beep();
        }
      }
      output += msg;
      if (this.useColor()) {
        output += consoleControl.color("reset");
      }
      return output;
    };
    log2.write = function(msg, style) {
      if (!stream) {
        return;
      }
      stream.write(this._format(msg, style));
    };
    log2.addLevel = function(lvl, n, style, disp) {
      if (disp == null) {
        disp = lvl;
      }
      this.levels[lvl] = n;
      this.style[lvl] = style;
      if (!this[lvl]) {
        this[lvl] = function() {
          var a = new Array(arguments.length + 1);
          a[0] = lvl;
          for (var i = 0; i < arguments.length; i++) {
            a[i + 1] = arguments[i];
          }
          return this.log.apply(this, a);
        }.bind(this);
      }
      this.disp[lvl] = disp;
    };
    log2.prefixStyle = { fg: "magenta" };
    log2.headingStyle = { fg: "white", bg: "black" };
    log2.style = {};
    log2.levels = {};
    log2.disp = {};
    log2.addLevel("silly", -Infinity, { inverse: true }, "sill");
    log2.addLevel("verbose", 1e3, { fg: "cyan", bg: "black" }, "verb");
    log2.addLevel("info", 2e3, { fg: "green" });
    log2.addLevel("timing", 2500, { fg: "green", bg: "black" });
    log2.addLevel("http", 3e3, { fg: "green", bg: "black" });
    log2.addLevel("notice", 3500, { fg: "cyan", bg: "black" });
    log2.addLevel("warn", 4e3, { fg: "black", bg: "yellow" }, "WARN");
    log2.addLevel("error", 5e3, { fg: "red", bg: "black" }, "ERR!");
    log2.addLevel("silent", Infinity);
    log2.on("error", function() {
    });
  }
});

// ../node_modules/eastasianwidth/eastasianwidth.js
var require_eastasianwidth = __commonJS({
  "../node_modules/eastasianwidth/eastasianwidth.js"(exports, module) {
    var eaw = {};
    if ("undefined" == typeof module) {
      window.eastasianwidth = eaw;
    } else {
      module.exports = eaw;
    }
    eaw.eastAsianWidth = function(character) {
      var x2 = character.charCodeAt(0);
      var y2 = character.length == 2 ? character.charCodeAt(1) : 0;
      var codePoint = x2;
      if (55296 <= x2 && x2 <= 56319 && (56320 <= y2 && y2 <= 57343)) {
        x2 &= 1023;
        y2 &= 1023;
        codePoint = x2 << 10 | y2;
        codePoint += 65536;
      }
      if (12288 == codePoint || 65281 <= codePoint && codePoint <= 65376 || 65504 <= codePoint && codePoint <= 65510) {
        return "F";
      }
      if (8361 == codePoint || 65377 <= codePoint && codePoint <= 65470 || 65474 <= codePoint && codePoint <= 65479 || 65482 <= codePoint && codePoint <= 65487 || 65490 <= codePoint && codePoint <= 65495 || 65498 <= codePoint && codePoint <= 65500 || 65512 <= codePoint && codePoint <= 65518) {
        return "H";
      }
      if (4352 <= codePoint && codePoint <= 4447 || 4515 <= codePoint && codePoint <= 4519 || 4602 <= codePoint && codePoint <= 4607 || 9001 <= codePoint && codePoint <= 9002 || 11904 <= codePoint && codePoint <= 11929 || 11931 <= codePoint && codePoint <= 12019 || 12032 <= codePoint && codePoint <= 12245 || 12272 <= codePoint && codePoint <= 12283 || 12289 <= codePoint && codePoint <= 12350 || 12353 <= codePoint && codePoint <= 12438 || 12441 <= codePoint && codePoint <= 12543 || 12549 <= codePoint && codePoint <= 12589 || 12593 <= codePoint && codePoint <= 12686 || 12688 <= codePoint && codePoint <= 12730 || 12736 <= codePoint && codePoint <= 12771 || 12784 <= codePoint && codePoint <= 12830 || 12832 <= codePoint && codePoint <= 12871 || 12880 <= codePoint && codePoint <= 13054 || 13056 <= codePoint && codePoint <= 19903 || 19968 <= codePoint && codePoint <= 42124 || 42128 <= codePoint && codePoint <= 42182 || 43360 <= codePoint && codePoint <= 43388 || 44032 <= codePoint && codePoint <= 55203 || 55216 <= codePoint && codePoint <= 55238 || 55243 <= codePoint && codePoint <= 55291 || 63744 <= codePoint && codePoint <= 64255 || 65040 <= codePoint && codePoint <= 65049 || 65072 <= codePoint && codePoint <= 65106 || 65108 <= codePoint && codePoint <= 65126 || 65128 <= codePoint && codePoint <= 65131 || 110592 <= codePoint && codePoint <= 110593 || 127488 <= codePoint && codePoint <= 127490 || 127504 <= codePoint && codePoint <= 127546 || 127552 <= codePoint && codePoint <= 127560 || 127568 <= codePoint && codePoint <= 127569 || 131072 <= codePoint && codePoint <= 194367 || 177984 <= codePoint && codePoint <= 196605 || 196608 <= codePoint && codePoint <= 262141) {
        return "W";
      }
      if (32 <= codePoint && codePoint <= 126 || 162 <= codePoint && codePoint <= 163 || 165 <= codePoint && codePoint <= 166 || 172 == codePoint || 175 == codePoint || 10214 <= codePoint && codePoint <= 10221 || 10629 <= codePoint && codePoint <= 10630) {
        return "Na";
      }
      if (161 == codePoint || 164 == codePoint || 167 <= codePoint && codePoint <= 168 || 170 == codePoint || 173 <= codePoint && codePoint <= 174 || 176 <= codePoint && codePoint <= 180 || 182 <= codePoint && codePoint <= 186 || 188 <= codePoint && codePoint <= 191 || 198 == codePoint || 208 == codePoint || 215 <= codePoint && codePoint <= 216 || 222 <= codePoint && codePoint <= 225 || 230 == codePoint || 232 <= codePoint && codePoint <= 234 || 236 <= codePoint && codePoint <= 237 || 240 == codePoint || 242 <= codePoint && codePoint <= 243 || 247 <= codePoint && codePoint <= 250 || 252 == codePoint || 254 == codePoint || 257 == codePoint || 273 == codePoint || 275 == codePoint || 283 == codePoint || 294 <= codePoint && codePoint <= 295 || 299 == codePoint || 305 <= codePoint && codePoint <= 307 || 312 == codePoint || 319 <= codePoint && codePoint <= 322 || 324 == codePoint || 328 <= codePoint && codePoint <= 331 || 333 == codePoint || 338 <= codePoint && codePoint <= 339 || 358 <= codePoint && codePoint <= 359 || 363 == codePoint || 462 == codePoint || 464 == codePoint || 466 == codePoint || 468 == codePoint || 470 == codePoint || 472 == codePoint || 474 == codePoint || 476 == codePoint || 593 == codePoint || 609 == codePoint || 708 == codePoint || 711 == codePoint || 713 <= codePoint && codePoint <= 715 || 717 == codePoint || 720 == codePoint || 728 <= codePoint && codePoint <= 731 || 733 == codePoint || 735 == codePoint || 768 <= codePoint && codePoint <= 879 || 913 <= codePoint && codePoint <= 929 || 931 <= codePoint && codePoint <= 937 || 945 <= codePoint && codePoint <= 961 || 963 <= codePoint && codePoint <= 969 || 1025 == codePoint || 1040 <= codePoint && codePoint <= 1103 || 1105 == codePoint || 8208 == codePoint || 8211 <= codePoint && codePoint <= 8214 || 8216 <= codePoint && codePoint <= 8217 || 8220 <= codePoint && codePoint <= 8221 || 8224 <= codePoint && codePoint <= 8226 || 8228 <= codePoint && codePoint <= 8231 || 8240 == codePoint || 8242 <= codePoint && codePoint <= 8243 || 8245 == codePoint || 8251 == codePoint || 8254 == codePoint || 8308 == codePoint || 8319 == codePoint || 8321 <= codePoint && codePoint <= 8324 || 8364 == codePoint || 8451 == codePoint || 8453 == codePoint || 8457 == codePoint || 8467 == codePoint || 8470 == codePoint || 8481 <= codePoint && codePoint <= 8482 || 8486 == codePoint || 8491 == codePoint || 8531 <= codePoint && codePoint <= 8532 || 8539 <= codePoint && codePoint <= 8542 || 8544 <= codePoint && codePoint <= 8555 || 8560 <= codePoint && codePoint <= 8569 || 8585 == codePoint || 8592 <= codePoint && codePoint <= 8601 || 8632 <= codePoint && codePoint <= 8633 || 8658 == codePoint || 8660 == codePoint || 8679 == codePoint || 8704 == codePoint || 8706 <= codePoint && codePoint <= 8707 || 8711 <= codePoint && codePoint <= 8712 || 8715 == codePoint || 8719 == codePoint || 8721 == codePoint || 8725 == codePoint || 8730 == codePoint || 8733 <= codePoint && codePoint <= 8736 || 8739 == codePoint || 8741 == codePoint || 8743 <= codePoint && codePoint <= 8748 || 8750 == codePoint || 8756 <= codePoint && codePoint <= 8759 || 8764 <= codePoint && codePoint <= 8765 || 8776 == codePoint || 8780 == codePoint || 8786 == codePoint || 8800 <= codePoint && codePoint <= 8801 || 8804 <= codePoint && codePoint <= 8807 || 8810 <= codePoint && codePoint <= 8811 || 8814 <= codePoint && codePoint <= 8815 || 8834 <= codePoint && codePoint <= 8835 || 8838 <= codePoint && codePoint <= 8839 || 8853 == codePoint || 8857 == codePoint || 8869 == codePoint || 8895 == codePoint || 8978 == codePoint || 9312 <= codePoint && codePoint <= 9449 || 9451 <= codePoint && codePoint <= 9547 || 9552 <= codePoint && codePoint <= 9587 || 9600 <= codePoint && codePoint <= 9615 || 9618 <= codePoint && codePoint <= 9621 || 9632 <= codePoint && codePoint <= 9633 || 9635 <= codePoint && codePoint <= 9641 || 9650 <= codePoint && codePoint <= 9651 || 9654 <= codePoint && codePoint <= 9655 || 9660 <= codePoint && codePoint <= 9661 || 9664 <= codePoint && codePoint <= 9665 || 9670 <= codePoint && codePoint <= 9672 || 9675 == codePoint || 9678 <= codePoint && codePoint <= 9681 || 9698 <= codePoint && codePoint <= 9701 || 9711 == codePoint || 9733 <= codePoint && codePoint <= 9734 || 9737 == codePoint || 9742 <= codePoint && codePoint <= 9743 || 9748 <= codePoint && codePoint <= 9749 || 9756 == codePoint || 9758 == codePoint || 9792 == codePoint || 9794 == codePoint || 9824 <= codePoint && codePoint <= 9825 || 9827 <= codePoint && codePoint <= 9829 || 9831 <= codePoint && codePoint <= 9834 || 9836 <= codePoint && codePoint <= 9837 || 9839 == codePoint || 9886 <= codePoint && codePoint <= 9887 || 9918 <= codePoint && codePoint <= 9919 || 9924 <= codePoint && codePoint <= 9933 || 9935 <= codePoint && codePoint <= 9953 || 9955 == codePoint || 9960 <= codePoint && codePoint <= 9983 || 10045 == codePoint || 10071 == codePoint || 10102 <= codePoint && codePoint <= 10111 || 11093 <= codePoint && codePoint <= 11097 || 12872 <= codePoint && codePoint <= 12879 || 57344 <= codePoint && codePoint <= 63743 || 65024 <= codePoint && codePoint <= 65039 || 65533 == codePoint || 127232 <= codePoint && codePoint <= 127242 || 127248 <= codePoint && codePoint <= 127277 || 127280 <= codePoint && codePoint <= 127337 || 127344 <= codePoint && codePoint <= 127386 || 917760 <= codePoint && codePoint <= 917999 || 983040 <= codePoint && codePoint <= 1048573 || 1048576 <= codePoint && codePoint <= 1114109) {
        return "A";
      }
      return "N";
    };
    eaw.characterLength = function(character) {
      var code = this.eastAsianWidth(character);
      if (code == "F" || code == "W" || code == "A") {
        return 2;
      } else {
        return 1;
      }
    };
    function stringToArray(string) {
      return string.match(/[\uD800-\uDBFF][\uDC00-\uDFFF]|[^\uD800-\uDFFF]/g) || [];
    }
    __name(stringToArray, "stringToArray");
    eaw.length = function(string) {
      var characters = stringToArray(string);
      var len = 0;
      for (var i = 0; i < characters.length; i++) {
        len = len + this.characterLength(characters[i]);
      }
      return len;
    };
    eaw.slice = function(text2, start, end) {
      textLen = eaw.length(text2);
      start = start ? start : 0;
      end = end ? end : 1;
      if (start < 0) {
        start = textLen + start;
      }
      if (end < 0) {
        end = textLen + end;
      }
      var result = "";
      var eawLen = 0;
      var chars = stringToArray(text2);
      for (var i = 0; i < chars.length; i++) {
        var char = chars[i];
        var charLen = eaw.length(char);
        if (eawLen >= start - (charLen == 2 ? 1 : 0)) {
          if (eawLen + charLen <= end) {
            result += char;
          } else {
            break;
          }
        }
        eawLen += charLen;
      }
      return result;
    };
  }
});

// ../node_modules/emoji-regex/index.js
var require_emoji_regex = __commonJS({
  "../node_modules/emoji-regex/index.js"(exports, module) {
    "use strict";
    module.exports = function() {
      return /\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74|\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67)\uDB40\uDC7F|(?:\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFE])|(?:\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFC-\uDFFF])|\uD83D\uDC68(?:\uD83C\uDFFB(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFC-\uDFFF])|[\u2695\u2696\u2708]\uFE0F|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))?|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFE])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])\uFE0F|\u200D(?:(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D[\uDC66\uDC67])|\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC)?|(?:\uD83D\uDC69(?:\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69]))|\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1)(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC69(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83E\uDDD1(?:\u200D(?:\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83E\uDDD1(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDC69(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDE36\u200D\uD83C\uDF2B|\uD83C\uDFF3\uFE0F\u200D\u26A7|\uD83D\uDC3B\u200D\u2744|(?:(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\uD83C\uDFF4\u200D\u2620|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])\u200D[\u2640\u2642]|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u2600-\u2604\u260E\u2611\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26B0\u26B1\u26C8\u26CF\u26D1\u26D3\u26E9\u26F0\u26F1\u26F4\u26F7\u26F8\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u3030\u303D\u3297\u3299]|\uD83C[\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]|\uD83D[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3])\uFE0F|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83D\uDE35\u200D\uD83D\uDCAB|\uD83D\uDE2E\u200D\uD83D\uDCA8|\uD83D\uDC15\u200D\uD83E\uDDBA|\uD83E\uDDD1(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83D\uDC69(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF6\uD83C\uDDE6|\uD83C\uDDF4\uD83C\uDDF2|\uD83D\uDC08\u200D\u2B1B|\u2764\uFE0F\u200D(?:\uD83D\uDD25|\uD83E\uDE79)|\uD83D\uDC41\uFE0F|\uD83C\uDFF3\uFE0F|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|[#\*0-9]\uFE0F\u20E3|\u2764\uFE0F|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|\uD83C\uDFF4|(?:[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270C\u270D]|\uD83D[\uDD74\uDD90])(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC08\uDC15\uDC3B\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE2E\uDE35\uDE36\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5]|\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD]|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF]|[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0D\uDD0E\uDD10-\uDD17\uDD1D\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78\uDD7A-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCB\uDDD0\uDDE0-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6]|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26A7\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDED5-\uDED7\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDC8F\uDC91\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1F\uDD26\uDD30-\uDD39\uDD3C-\uDD3E\uDD77\uDDB5\uDDB6\uDDB8\uDDB9\uDDBB\uDDCD-\uDDCF\uDDD1-\uDDDD])/g;
    };
  }
});

// src/node-logger/index.ts
var import_npmlog = __toESM(require_log(), 1);
var import_pretty_hrtime = __toESM(require_pretty_hrtime(), 1);

// src/node-logger/logger/logger.ts
var logger_exports = {};
__export(logger_exports, {
  SYMBOLS: () => SYMBOLS,
  debug: () => debug,
  error: () => error,
  getLogLevel: () => getLogLevel,
  info: () => info,
  intro: () => intro,
  log: () => log,
  logBox: () => logBox,
  outro: () => outro,
  setLogLevel: () => setLogLevel,
  shouldLog: () => shouldLog,
  step: () => step,
  warn: () => warn,
  wrapTextForClack: () => wrapTextForClack
});

// ../node_modules/@clack/core/dist/index.mjs
var import_picocolors = __toESM(require_picocolors(), 1);
var import_sisteransi = __toESM(require_src(), 1);
import { stdout as z, stdin as Y } from "node:process";
import * as k from "node:readline";
import nt from "node:readline";
import { ReadStream as q } from "node:tty";
var ut = /* @__PURE__ */ __name((t2) => t2 === 161 || t2 === 164 || t2 === 167 || t2 === 168 || t2 === 170 || t2 === 173 || t2 === 174 || t2 >= 176 && t2 <= 180 || t2 >= 182 && t2 <= 186 || t2 >= 188 && t2 <= 191 || t2 === 198 || t2 === 208 || t2 === 215 || t2 === 216 || t2 >= 222 && t2 <= 225 || t2 === 230 || t2 >= 232 && t2 <= 234 || t2 === 236 || t2 === 237 || t2 === 240 || t2 === 242 || t2 === 243 || t2 >= 247 && t2 <= 250 || t2 === 252 || t2 === 254 || t2 === 257 || t2 === 273 || t2 === 275 || t2 === 283 || t2 === 294 || t2 === 295 || t2 === 299 || t2 >= 305 && t2 <= 307 || t2 === 312 || t2 >= 319 && t2 <= 322 || t2 === 324 || t2 >= 328 && t2 <= 331 || t2 === 333 || t2 === 338 || t2 === 339 || t2 === 358 || t2 === 359 || t2 === 363 || t2 === 462 || t2 === 464 || t2 === 466 || t2 === 468 || t2 === 470 || t2 === 472 || t2 === 474 || t2 === 476 || t2 === 593 || t2 === 609 || t2 === 708 || t2 === 711 || t2 >= 713 && t2 <= 715 || t2 === 717 || t2 === 720 || t2 >= 728 && t2 <= 731 || t2 === 733 || t2 === 735 || t2 >= 768 && t2 <= 879 || t2 >= 913 && t2 <= 929 || t2 >= 931 && t2 <= 937 || t2 >= 945 && t2 <= 961 || t2 >= 963 && t2 <= 969 || t2 === 1025 || t2 >= 1040 && t2 <= 1103 || t2 === 1105 || t2 === 8208 || t2 >= 8211 && t2 <= 8214 || t2 === 8216 || t2 === 8217 || t2 === 8220 || t2 === 8221 || t2 >= 8224 && t2 <= 8226 || t2 >= 8228 && t2 <= 8231 || t2 === 8240 || t2 === 8242 || t2 === 8243 || t2 === 8245 || t2 === 8251 || t2 === 8254 || t2 === 8308 || t2 === 8319 || t2 >= 8321 && t2 <= 8324 || t2 === 8364 || t2 === 8451 || t2 === 8453 || t2 === 8457 || t2 === 8467 || t2 === 8470 || t2 === 8481 || t2 === 8482 || t2 === 8486 || t2 === 8491 || t2 === 8531 || t2 === 8532 || t2 >= 8539 && t2 <= 8542 || t2 >= 8544 && t2 <= 8555 || t2 >= 8560 && t2 <= 8569 || t2 === 8585 || t2 >= 8592 && t2 <= 8601 || t2 === 8632 || t2 === 8633 || t2 === 8658 || t2 === 8660 || t2 === 8679 || t2 === 8704 || t2 === 8706 || t2 === 8707 || t2 === 8711 || t2 === 8712 || t2 === 8715 || t2 === 8719 || t2 === 8721 || t2 === 8725 || t2 === 8730 || t2 >= 8733 && t2 <= 8736 || t2 === 8739 || t2 === 8741 || t2 >= 8743 && t2 <= 8748 || t2 === 8750 || t2 >= 8756 && t2 <= 8759 || t2 === 8764 || t2 === 8765 || t2 === 8776 || t2 === 8780 || t2 === 8786 || t2 === 8800 || t2 === 8801 || t2 >= 8804 && t2 <= 8807 || t2 === 8810 || t2 === 8811 || t2 === 8814 || t2 === 8815 || t2 === 8834 || t2 === 8835 || t2 === 8838 || t2 === 8839 || t2 === 8853 || t2 === 8857 || t2 === 8869 || t2 === 8895 || t2 === 8978 || t2 >= 9312 && t2 <= 9449 || t2 >= 9451 && t2 <= 9547 || t2 >= 9552 && t2 <= 9587 || t2 >= 9600 && t2 <= 9615 || t2 >= 9618 && t2 <= 9621 || t2 === 9632 || t2 === 9633 || t2 >= 9635 && t2 <= 9641 || t2 === 9650 || t2 === 9651 || t2 === 9654 || t2 === 9655 || t2 === 9660 || t2 === 9661 || t2 === 9664 || t2 === 9665 || t2 >= 9670 && t2 <= 9672 || t2 === 9675 || t2 >= 9678 && t2 <= 9681 || t2 >= 9698 && t2 <= 9701 || t2 === 9711 || t2 === 9733 || t2 === 9734 || t2 === 9737 || t2 === 9742 || t2 === 9743 || t2 === 9756 || t2 === 9758 || t2 === 9792 || t2 === 9794 || t2 === 9824 || t2 === 9825 || t2 >= 9827 && t2 <= 9829 || t2 >= 9831 && t2 <= 9834 || t2 === 9836 || t2 === 9837 || t2 === 9839 || t2 === 9886 || t2 === 9887 || t2 === 9919 || t2 >= 9926 && t2 <= 9933 || t2 >= 9935 && t2 <= 9939 || t2 >= 9941 && t2 <= 9953 || t2 === 9955 || t2 === 9960 || t2 === 9961 || t2 >= 9963 && t2 <= 9969 || t2 === 9972 || t2 >= 9974 && t2 <= 9977 || t2 === 9979 || t2 === 9980 || t2 === 9982 || t2 === 9983 || t2 === 10045 || t2 >= 10102 && t2 <= 10111 || t2 >= 11094 && t2 <= 11097 || t2 >= 12872 && t2 <= 12879 || t2 >= 57344 && t2 <= 63743 || t2 >= 65024 && t2 <= 65039 || t2 === 65533 || t2 >= 127232 && t2 <= 127242 || t2 >= 127248 && t2 <= 127277 || t2 >= 127280 && t2 <= 127337 || t2 >= 127344 && t2 <= 127373 || t2 === 127375 || t2 === 127376 || t2 >= 127387 && t2 <= 127404 || t2 >= 917760 && t2 <= 917999 || t2 >= 983040 && t2 <= 1048573 || t2 >= 1048576 && t2 <= 1114109, "ut");
var ot = /* @__PURE__ */ __name((t2) => t2 === 12288 || t2 >= 65281 && t2 <= 65376 || t2 >= 65504 && t2 <= 65510, "ot");
var at = /* @__PURE__ */ __name((t2) => t2 >= 4352 && t2 <= 4447 || t2 === 8986 || t2 === 8987 || t2 === 9001 || t2 === 9002 || t2 >= 9193 && t2 <= 9196 || t2 === 9200 || t2 === 9203 || t2 === 9725 || t2 === 9726 || t2 === 9748 || t2 === 9749 || t2 >= 9800 && t2 <= 9811 || t2 === 9855 || t2 === 9875 || t2 === 9889 || t2 === 9898 || t2 === 9899 || t2 === 9917 || t2 === 9918 || t2 === 9924 || t2 === 9925 || t2 === 9934 || t2 === 9940 || t2 === 9962 || t2 === 9970 || t2 === 9971 || t2 === 9973 || t2 === 9978 || t2 === 9981 || t2 === 9989 || t2 === 9994 || t2 === 9995 || t2 === 10024 || t2 === 10060 || t2 === 10062 || t2 >= 10067 && t2 <= 10069 || t2 === 10071 || t2 >= 10133 && t2 <= 10135 || t2 === 10160 || t2 === 10175 || t2 === 11035 || t2 === 11036 || t2 === 11088 || t2 === 11093 || t2 >= 11904 && t2 <= 11929 || t2 >= 11931 && t2 <= 12019 || t2 >= 12032 && t2 <= 12245 || t2 >= 12272 && t2 <= 12287 || t2 >= 12289 && t2 <= 12350 || t2 >= 12353 && t2 <= 12438 || t2 >= 12441 && t2 <= 12543 || t2 >= 12549 && t2 <= 12591 || t2 >= 12593 && t2 <= 12686 || t2 >= 12688 && t2 <= 12771 || t2 >= 12783 && t2 <= 12830 || t2 >= 12832 && t2 <= 12871 || t2 >= 12880 && t2 <= 19903 || t2 >= 19968 && t2 <= 42124 || t2 >= 42128 && t2 <= 42182 || t2 >= 43360 && t2 <= 43388 || t2 >= 44032 && t2 <= 55203 || t2 >= 63744 && t2 <= 64255 || t2 >= 65040 && t2 <= 65049 || t2 >= 65072 && t2 <= 65106 || t2 >= 65108 && t2 <= 65126 || t2 >= 65128 && t2 <= 65131 || t2 >= 94176 && t2 <= 94180 || t2 === 94192 || t2 === 94193 || t2 >= 94208 && t2 <= 100343 || t2 >= 100352 && t2 <= 101589 || t2 >= 101632 && t2 <= 101640 || t2 >= 110576 && t2 <= 110579 || t2 >= 110581 && t2 <= 110587 || t2 === 110589 || t2 === 110590 || t2 >= 110592 && t2 <= 110882 || t2 === 110898 || t2 >= 110928 && t2 <= 110930 || t2 === 110933 || t2 >= 110948 && t2 <= 110951 || t2 >= 110960 && t2 <= 111355 || t2 === 126980 || t2 === 127183 || t2 === 127374 || t2 >= 127377 && t2 <= 127386 || t2 >= 127488 && t2 <= 127490 || t2 >= 127504 && t2 <= 127547 || t2 >= 127552 && t2 <= 127560 || t2 === 127568 || t2 === 127569 || t2 >= 127584 && t2 <= 127589 || t2 >= 127744 && t2 <= 127776 || t2 >= 127789 && t2 <= 127797 || t2 >= 127799 && t2 <= 127868 || t2 >= 127870 && t2 <= 127891 || t2 >= 127904 && t2 <= 127946 || t2 >= 127951 && t2 <= 127955 || t2 >= 127968 && t2 <= 127984 || t2 === 127988 || t2 >= 127992 && t2 <= 128062 || t2 === 128064 || t2 >= 128066 && t2 <= 128252 || t2 >= 128255 && t2 <= 128317 || t2 >= 128331 && t2 <= 128334 || t2 >= 128336 && t2 <= 128359 || t2 === 128378 || t2 === 128405 || t2 === 128406 || t2 === 128420 || t2 >= 128507 && t2 <= 128591 || t2 >= 128640 && t2 <= 128709 || t2 === 128716 || t2 >= 128720 && t2 <= 128722 || t2 >= 128725 && t2 <= 128727 || t2 >= 128732 && t2 <= 128735 || t2 === 128747 || t2 === 128748 || t2 >= 128756 && t2 <= 128764 || t2 >= 128992 && t2 <= 129003 || t2 === 129008 || t2 >= 129292 && t2 <= 129338 || t2 >= 129340 && t2 <= 129349 || t2 >= 129351 && t2 <= 129535 || t2 >= 129648 && t2 <= 129660 || t2 >= 129664 && t2 <= 129672 || t2 >= 129680 && t2 <= 129725 || t2 >= 129727 && t2 <= 129733 || t2 >= 129742 && t2 <= 129755 || t2 >= 129760 && t2 <= 129768 || t2 >= 129776 && t2 <= 129784 || t2 >= 131072 && t2 <= 196605 || t2 >= 196608 && t2 <= 262141, "at");
var N = /[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/y;
var y = /[\x00-\x08\x0A-\x1F\x7F-\x9F]{1,1000}/y;
var M = /\t{1,1000}/y;
var O = /[\u{1F1E6}-\u{1F1FF}]{2}|\u{1F3F4}[\u{E0061}-\u{E007A}]{2}[\u{E0030}-\u{E0039}\u{E0061}-\u{E007A}]{1,3}\u{E007F}|(?:\p{Emoji}\uFE0F\u20E3?|\p{Emoji_Modifier_Base}\p{Emoji_Modifier}?|\p{Emoji_Presentation})(?:\u200D(?:\p{Emoji_Modifier_Base}\p{Emoji_Modifier}?|\p{Emoji_Presentation}|\p{Emoji}\uFE0F\u20E3?))*/yu;
var L = /(?:[\x20-\x7E\xA0-\xFF](?!\uFE0F)){1,1000}/y;
var lt = /\p{M}+/gu;
var ht = { limit: 1 / 0, ellipsis: "" };
var J = /* @__PURE__ */ __name((t2, s = {}, e = {}) => {
  const i = s.limit ?? 1 / 0, r = s.ellipsis ?? "", n = s?.ellipsisWidth ?? (r ? J(r, ht, e).width : 0), F = e.ansiWidth ?? 0, l = e.controlWidth ?? 0, a = e.tabWidth ?? 8, v = e.ambiguousWidth ?? 1, g = e.emojiWidth ?? 2, m = e.fullWidthWidth ?? 2, A = e.regularWidth ?? 1, V = e.wideWidth ?? 2;
  let o = 0, u = 0, p = t2.length, E = 0, f = false, d2 = p, _ = Math.max(0, i - n), C = 0, x2 = 0, h = 0, c = 0;
  t: for (; ; ) {
    if (x2 > C || u >= p && u > o) {
      const rt = t2.slice(C, x2) || t2.slice(o, u);
      E = 0;
      for (const H2 of rt.replaceAll(lt, "")) {
        const R2 = H2.codePointAt(0) || 0;
        if (ot(R2) ? c = m : at(R2) ? c = V : v !== A && ut(R2) ? c = v : c = A, h + c > _ && (d2 = Math.min(d2, Math.max(C, o) + E)), h + c > i) {
          f = true;
          break t;
        }
        E += H2.length, h += c;
      }
      C = x2 = 0;
    }
    if (u >= p) break;
    if (L.lastIndex = u, L.test(t2)) {
      if (E = L.lastIndex - u, c = E * A, h + c > _ && (d2 = Math.min(d2, u + Math.floor((_ - h) / A))), h + c > i) {
        f = true;
        break;
      }
      h += c, C = o, x2 = u, u = o = L.lastIndex;
      continue;
    }
    if (N.lastIndex = u, N.test(t2)) {
      if (h + F > _ && (d2 = Math.min(d2, u)), h + F > i) {
        f = true;
        break;
      }
      h += F, C = o, x2 = u, u = o = N.lastIndex;
      continue;
    }
    if (y.lastIndex = u, y.test(t2)) {
      if (E = y.lastIndex - u, c = E * l, h + c > _ && (d2 = Math.min(d2, u + Math.floor((_ - h) / l))), h + c > i) {
        f = true;
        break;
      }
      h += c, C = o, x2 = u, u = o = y.lastIndex;
      continue;
    }
    if (M.lastIndex = u, M.test(t2)) {
      if (E = M.lastIndex - u, c = E * a, h + c > _ && (d2 = Math.min(d2, u + Math.floor((_ - h) / a))), h + c > i) {
        f = true;
        break;
      }
      h += c, C = o, x2 = u, u = o = M.lastIndex;
      continue;
    }
    if (O.lastIndex = u, O.test(t2)) {
      if (h + g > _ && (d2 = Math.min(d2, u)), h + g > i) {
        f = true;
        break;
      }
      h += g, C = o, x2 = u, u = o = O.lastIndex;
      continue;
    }
    u += 1;
  }
  return { width: f ? _ : h, index: f ? d2 : p, truncated: f, ellipsed: f && i >= n };
}, "J");
var ct = { limit: 1 / 0, ellipsis: "", ellipsisWidth: 0 };
var S = /* @__PURE__ */ __name((t2, s = {}) => J(t2, ct, s).width, "S");
var W = "\x1B";
var X = "\x9B";
var Ft = 39;
var P = "\x07";
var Z = "[";
var pt = "]";
var Q = "m";
var j = `${pt}8;;`;
var tt = new RegExp(`(?:\\${Z}(?<code>\\d+)m|\\${j}(?<uri>.*)${P})`, "y");
var ft = /* @__PURE__ */ __name((t2) => {
  if (t2 >= 30 && t2 <= 37 || t2 >= 90 && t2 <= 97) return 39;
  if (t2 >= 40 && t2 <= 47 || t2 >= 100 && t2 <= 107) return 49;
  if (t2 === 1 || t2 === 2) return 22;
  if (t2 === 3) return 23;
  if (t2 === 4) return 24;
  if (t2 === 7) return 27;
  if (t2 === 8) return 28;
  if (t2 === 9) return 29;
  if (t2 === 0) return 0;
}, "ft");
var st = /* @__PURE__ */ __name((t2) => `${W}${Z}${t2}${Q}`, "st");
var et = /* @__PURE__ */ __name((t2) => `${W}${j}${t2}${P}`, "et");
var dt = /* @__PURE__ */ __name((t2) => t2.map((s) => S(s)), "dt");
var U = /* @__PURE__ */ __name((t2, s, e) => {
  const i = s[Symbol.iterator]();
  let r = false, n = false, F = t2.at(-1), l = F === void 0 ? 0 : S(F), a = i.next(), v = i.next(), g = 0;
  for (; !a.done; ) {
    const m = a.value, A = S(m);
    l + A <= e ? t2[t2.length - 1] += m : (t2.push(m), l = 0), (m === W || m === X) && (r = true, n = s.startsWith(j, g + 1)), r ? n ? m === P && (r = false, n = false) : m === Q && (r = false) : (l += A, l === e && !v.done && (t2.push(""), l = 0)), a = v, v = i.next(), g += m.length;
  }
  F = t2.at(-1), !l && F !== void 0 && F.length > 0 && t2.length > 1 && (t2[t2.length - 2] += t2.pop());
}, "U");
var mt = /* @__PURE__ */ __name((t2) => {
  const s = t2.split(" ");
  let e = s.length;
  for (; e > 0 && !(S(s[e - 1]) > 0); ) e--;
  return e === s.length ? t2 : s.slice(0, e).join(" ") + s.slice(e).join("");
}, "mt");
var gt = /* @__PURE__ */ __name((t2, s, e = {}) => {
  if (e.trim !== false && t2.trim() === "") return "";
  let i = "", r, n;
  const F = t2.split(" "), l = dt(F);
  let a = [""];
  for (const [o, u] of F.entries()) {
    e.trim !== false && (a[a.length - 1] = (a.at(-1) ?? "").trimStart());
    let p = S(a.at(-1) ?? "");
    if (o !== 0 && (p >= s && (e.wordWrap === false || e.trim === false) && (a.push(""), p = 0), (p > 0 || e.trim === false) && (a[a.length - 1] += " ", p++)), e.hard && l[o] > s) {
      const E = s - p, f = 1 + Math.floor((l[o] - E - 1) / s);
      Math.floor((l[o] - 1) / s) < f && a.push(""), U(a, u, s);
      continue;
    }
    if (p + l[o] > s && p > 0 && l[o] > 0) {
      if (e.wordWrap === false && p < s) {
        U(a, u, s);
        continue;
      }
      a.push("");
    }
    if (p + l[o] > s && e.wordWrap === false) {
      U(a, u, s);
      continue;
    }
    a[a.length - 1] += u;
  }
  e.trim !== false && (a = a.map((o) => mt(o)));
  const v = a.join(`
`), g = v[Symbol.iterator]();
  let m = g.next(), A = g.next(), V = 0;
  for (; !m.done; ) {
    const o = m.value, u = A.value;
    if (i += o, o === W || o === X) {
      tt.lastIndex = V + 1;
      const f = tt.exec(v)?.groups;
      if (f?.code !== void 0) {
        const d2 = Number.parseFloat(f.code);
        r = d2 === Ft ? void 0 : d2;
      } else f?.uri !== void 0 && (n = f.uri.length === 0 ? void 0 : f.uri);
    }
    const p = r ? ft(r) : void 0;
    u === `
` ? (n && (i += et("")), r && p && (i += st(p))) : o === `
` && (r && p && (i += st(r)), n && (i += et(n))), V += o.length, m = A, A = g.next();
  }
  return i;
}, "gt");
function it(t2, s, e) {
  return String(t2).normalize().replaceAll(`\r
`, `
`).split(`
`).map((i) => gt(i, s, e)).join(`
`);
}
__name(it, "it");
var Et = ["up", "down", "left", "right", "space", "enter", "cancel"];
var b = { actions: new Set(Et), aliases: /* @__PURE__ */ new Map([["k", "up"], ["j", "down"], ["h", "left"], ["l", "right"], ["", "cancel"], ["escape", "cancel"]]), messages: { cancel: "Canceled", error: "Something went wrong" } };
function G(t2, s) {
  if (typeof t2 == "string") return b.aliases.get(t2) === s;
  for (const e of t2) if (e !== void 0 && G(e, s)) return true;
  return false;
}
__name(G, "G");
function At(t2, s) {
  if (t2 === s) return;
  const e = t2.split(`
`), i = s.split(`
`), r = [];
  for (let n = 0; n < Math.max(e.length, i.length); n++) e[n] !== i[n] && r.push(n);
  return r;
}
__name(At, "At");
var It = globalThis.process.platform.startsWith("win");
var K = Symbol("clack:cancel");
function _t(t2) {
  return t2 === K;
}
__name(_t, "_t");
function T(t2, s) {
  const e = t2;
  e.isTTY && e.setRawMode(s);
}
__name(T, "T");
function bt({ input: t2 = Y, output: s = z, overwrite: e = true, hideCursor: i = true } = {}) {
  const r = k.createInterface({ input: t2, output: s, prompt: "", tabSize: 1 });
  k.emitKeypressEvents(t2, r), t2 instanceof q && t2.isTTY && t2.setRawMode(true);
  const n = /* @__PURE__ */ __name((F, { name: l, sequence: a }) => {
    const v = String(F);
    if (G([v, l, a], "cancel")) {
      i && s.write(import_sisteransi.cursor.show), process.exit(0);
      return;
    }
    if (!e) return;
    const g = l === "return" ? 0 : -1, m = l === "return" ? -1 : 0;
    k.moveCursor(s, g, m, () => {
      k.clearLine(s, 1, () => {
        t2.once("keypress", n);
      });
    });
  }, "n");
  return i && s.write(import_sisteransi.cursor.hide), t2.once("keypress", n), () => {
    t2.off("keypress", n), i && s.write(import_sisteransi.cursor.show), t2 instanceof q && t2.isTTY && !It && t2.setRawMode(false), r.terminal = false, r.close();
  };
}
__name(bt, "bt");
var Ct = /* @__PURE__ */ __name((t2) => "columns" in t2 && typeof t2.columns == "number" ? t2.columns : 80, "Ct");
var Bt = /* @__PURE__ */ __name((t2) => "rows" in t2 && typeof t2.rows == "number" ? t2.rows : 20, "Bt");
var B = class {
  static {
    __name(this, "B");
  }
  input;
  output;
  _abortSignal;
  rl;
  opts;
  _render;
  _track = false;
  _prevFrame = "";
  _subscribers = /* @__PURE__ */ new Map();
  _cursor = 0;
  state = "initial";
  error = "";
  value;
  userInput = "";
  constructor(s, e = true) {
    const { input: i = Y, output: r = z, render: n, signal: F, ...l } = s;
    this.opts = l, this.onKeypress = this.onKeypress.bind(this), this.close = this.close.bind(this), this.render = this.render.bind(this), this._render = n.bind(this), this._track = e, this._abortSignal = F, this.input = i, this.output = r;
  }
  unsubscribe() {
    this._subscribers.clear();
  }
  setSubscriber(s, e) {
    const i = this._subscribers.get(s) ?? [];
    i.push(e), this._subscribers.set(s, i);
  }
  on(s, e) {
    this.setSubscriber(s, { cb: e });
  }
  once(s, e) {
    this.setSubscriber(s, { cb: e, once: true });
  }
  emit(s, ...e) {
    const i = this._subscribers.get(s) ?? [], r = [];
    for (const n of i) n.cb(...e), n.once && r.push(() => i.splice(i.indexOf(n), 1));
    for (const n of r) n();
  }
  prompt() {
    return new Promise((s) => {
      if (this._abortSignal) {
        if (this._abortSignal.aborted) return this.state = "cancel", this.close(), s(K);
        this._abortSignal.addEventListener("abort", () => {
          this.state = "cancel", this.close();
        }, { once: true });
      }
      this.rl = nt.createInterface({ input: this.input, tabSize: 2, prompt: "", escapeCodeTimeout: 50, terminal: true }), this.rl.prompt(), this.opts.initialUserInput !== void 0 && this._setUserInput(this.opts.initialUserInput, true), this.input.on("keypress", this.onKeypress), T(this.input, true), this.output.on("resize", this.render), this.render(), this.once("submit", () => {
        this.output.write(import_sisteransi.cursor.show), this.output.off("resize", this.render), T(this.input, false), s(this.value);
      }), this.once("cancel", () => {
        this.output.write(import_sisteransi.cursor.show), this.output.off("resize", this.render), T(this.input, false), s(K);
      });
    });
  }
  _isActionKey(s, e) {
    return s === "	";
  }
  _setValue(s) {
    this.value = s, this.emit("value", this.value);
  }
  _setUserInput(s, e) {
    this.userInput = s ?? "", this.emit("userInput", this.userInput), e && this._track && this.rl && (this.rl.write(this.userInput), this._cursor = this.rl.cursor);
  }
  _clearUserInput() {
    this.rl?.write(null, { ctrl: true, name: "u" }), this._setUserInput("");
  }
  onKeypress(s, e) {
    if (this._track && e.name !== "return" && (e.name && this._isActionKey(s, e) && this.rl?.write(null, { ctrl: true, name: "h" }), this._cursor = this.rl?.cursor ?? 0, this._setUserInput(this.rl?.line)), this.state === "error" && (this.state = "active"), e?.name && (!this._track && b.aliases.has(e.name) && this.emit("cursor", b.aliases.get(e.name)), b.actions.has(e.name) && this.emit("cursor", e.name)), s && (s.toLowerCase() === "y" || s.toLowerCase() === "n") && this.emit("confirm", s.toLowerCase() === "y"), this.emit("key", s?.toLowerCase(), e), e?.name === "return") {
      if (this.opts.validate) {
        const i = this.opts.validate(this.value);
        i && (this.error = i instanceof Error ? i.message : i, this.state = "error", this.rl?.write(this.userInput));
      }
      this.state !== "error" && (this.state = "submit");
    }
    G([s, e?.name, e?.sequence], "cancel") && (this.state = "cancel"), (this.state === "submit" || this.state === "cancel") && this.emit("finalize"), this.render(), (this.state === "submit" || this.state === "cancel") && this.close();
  }
  close() {
    this.input.unpipe(), this.input.removeListener("keypress", this.onKeypress), this.output.write(`
`), T(this.input, false), this.rl?.close(), this.rl = void 0, this.emit(`${this.state}`, this.value), this.unsubscribe();
  }
  restoreCursor() {
    const s = it(this._prevFrame, process.stdout.columns, { hard: true, trim: false }).split(`
`).length - 1;
    this.output.write(import_sisteransi.cursor.move(-999, s * -1));
  }
  render() {
    const s = it(this._render(this) ?? "", process.stdout.columns, { hard: true, trim: false });
    if (s !== this._prevFrame) {
      if (this.state === "initial") this.output.write(import_sisteransi.cursor.hide);
      else {
        const e = At(this._prevFrame, s);
        if (this.restoreCursor(), e && e?.length === 1) {
          const i = e[0];
          this.output.write(import_sisteransi.cursor.move(0, i)), this.output.write(import_sisteransi.erase.lines(1));
          const r = s.split(`
`);
          this.output.write(r[i]), this._prevFrame = s, this.output.write(import_sisteransi.cursor.move(0, r.length - i - 1));
          return;
        }
        if (e && e?.length > 1) {
          const i = e[0];
          this.output.write(import_sisteransi.cursor.move(0, i)), this.output.write(import_sisteransi.erase.down());
          const r = s.split(`
`).slice(i);
          this.output.write(r.join(`
`)), this._prevFrame = s;
          return;
        }
        this.output.write(import_sisteransi.erase.down());
      }
      this.output.write(s), this.state === "initial" && (this.state = "active"), this._prevFrame = s;
    }
  }
};
var Vt = class extends B {
  static {
    __name(this, "Vt");
  }
  get cursor() {
    return this.value ? 0 : 1;
  }
  get _value() {
    return this.cursor === 0;
  }
  constructor(s) {
    super(s, false), this.value = !!s.initialValue, this.on("userInput", () => {
      this.value = this._value;
    }), this.on("confirm", (e) => {
      this.output.write(import_sisteransi.cursor.move(0, -1)), this.value = e, this.state = "submit", this.close();
    }), this.on("cursor", () => {
      this.value = !this.value;
    });
  }
};
function w(t2, s, e) {
  const i = t2 + s, r = Math.max(e.length - 1, 0), n = i < 0 ? r : i > r ? 0 : i;
  return e[n].disabled ? w(n, s < 0 ? -1 : 1, e) : n;
}
__name(w, "w");
var yt = class extends B {
  static {
    __name(this, "yt");
  }
  options;
  cursor = 0;
  get _value() {
    return this.options[this.cursor].value;
  }
  get _enabledOptions() {
    return this.options.filter((s) => s.disabled !== true);
  }
  toggleAll() {
    const s = this._enabledOptions, e = this.value !== void 0 && this.value.length === s.length;
    this.value = e ? [] : s.map((i) => i.value);
  }
  toggleInvert() {
    const s = this.value;
    if (!s) return;
    const e = this._enabledOptions.filter((i) => !s.includes(i.value));
    this.value = e.map((i) => i.value);
  }
  toggleValue() {
    this.value === void 0 && (this.value = []);
    const s = this.value.includes(this._value);
    this.value = s ? this.value.filter((e) => e !== this._value) : [...this.value, this._value];
  }
  constructor(s) {
    super(s, false), this.options = s.options, this.value = [...s.initialValues ?? []];
    const e = Math.max(this.options.findIndex(({ value: i }) => i === s.cursorAt), 0);
    this.cursor = this.options[e].disabled ? w(e, 1, this.options) : e, this.on("key", (i) => {
      i === "a" && this.toggleAll(), i === "i" && this.toggleInvert();
    }), this.on("cursor", (i) => {
      switch (i) {
        case "left":
        case "up":
          this.cursor = w(this.cursor, -1, this.options);
          break;
        case "down":
        case "right":
          this.cursor = w(this.cursor, 1, this.options);
          break;
        case "space":
          this.toggleValue();
          break;
      }
    });
  }
};
var Lt = class extends B {
  static {
    __name(this, "Lt");
  }
  options;
  cursor = 0;
  get _selectedValue() {
    return this.options[this.cursor];
  }
  changeValue() {
    this.value = this._selectedValue.value;
  }
  constructor(s) {
    super(s, false), this.options = s.options;
    const e = this.options.findIndex(({ value: r }) => r === s.initialValue), i = e === -1 ? 0 : e;
    this.cursor = this.options[i].disabled ? w(i, 1, this.options) : i, this.changeValue(), this.on("cursor", (r) => {
      switch (r) {
        case "left":
        case "up":
          this.cursor = w(this.cursor, -1, this.options);
          break;
        case "down":
        case "right":
          this.cursor = w(this.cursor, 1, this.options);
          break;
      }
      this.changeValue();
    });
  }
};
var Tt = class extends B {
  static {
    __name(this, "Tt");
  }
  get userInputWithCursor() {
    if (this.state === "submit") return this.userInput;
    const s = this.userInput;
    if (this.cursor >= s.length) return `${this.userInput}\u2588`;
    const e = s.slice(0, this.cursor), [i, ...r] = s.slice(this.cursor);
    return `${e}${import_picocolors.default.inverse(i)}${r.join("")}`;
  }
  get cursor() {
    return this._cursor;
  }
  constructor(s) {
    super({ ...s, initialUserInput: s.initialUserInput ?? s.initialValue }), this.on("userInput", (e) => {
      this._setValue(e);
    }), this.on("finalize", () => {
      this.value || (this.value = s.defaultValue), this.value === void 0 && (this.value = "");
    });
  }
};

// ../node_modules/@clack/prompts/dist/index.mjs
var import_picocolors2 = __toESM(require_picocolors(), 1);
import N2 from "node:process";
var import_sisteransi2 = __toESM(require_src(), 1);
function ut2() {
  return N2.platform !== "win32" ? N2.env.TERM !== "linux" : !!N2.env.CI || !!N2.env.WT_SESSION || !!N2.env.TERMINUS_SUBLIME || N2.env.ConEmuTask === "{cmd::Cmder}" || N2.env.TERM_PROGRAM === "Terminus-Sublime" || N2.env.TERM_PROGRAM === "vscode" || N2.env.TERM === "xterm-256color" || N2.env.TERM === "alacritty" || N2.env.TERMINAL_EMULATOR === "JetBrains-JediTerm";
}
__name(ut2, "ut");
var z2 = ut2();
var ne = /* @__PURE__ */ __name(() => process.env.CI === "true", "ne");
var Be = /* @__PURE__ */ __name((e) => e.isTTY === true, "Be");
var I2 = /* @__PURE__ */ __name((e, i) => z2 ? e : i, "I");
var be = I2("\u25C6", "*");
var ae = I2("\u25A0", "x");
var oe = I2("\u25B2", "x");
var W2 = I2("\u25C7", "o");
var le = I2("\u250C", "T");
var d = I2("\u2502", "|");
var x = I2("\u2514", "\u2014");
var xe = I2("\u2510", "T");
var _e = I2("\u2518", "\u2014");
var J2 = I2("\u25CF", ">");
var H = I2("\u25CB", " ");
var Z2 = I2("\u25FB", "[\u2022]");
var j2 = I2("\u25FC", "[+]");
var X2 = I2("\u25FB", "[ ]");
var De = I2("\u25AA", "\u2022");
var Q2 = I2("\u2500", "-");
var ue = I2("\u256E", "+");
var Te = I2("\u251C", "+");
var ce = I2("\u256F", "+");
var Me = I2("\u2570", "+");
var Re = I2("\u256D", "+");
var de = I2("\u25CF", "\u2022");
var $e = I2("\u25C6", "*");
var he = I2("\u25B2", "!");
var me = I2("\u25A0", "x");
var L2 = /* @__PURE__ */ __name((e) => {
  switch (e) {
    case "initial":
    case "active":
      return import_picocolors2.default.cyan(be);
    case "cancel":
      return import_picocolors2.default.red(ae);
    case "error":
      return import_picocolors2.default.yellow(oe);
    case "submit":
      return import_picocolors2.default.green(W2);
  }
}, "L");
var ct2 = /* @__PURE__ */ __name((e) => e === 161 || e === 164 || e === 167 || e === 168 || e === 170 || e === 173 || e === 174 || e >= 176 && e <= 180 || e >= 182 && e <= 186 || e >= 188 && e <= 191 || e === 198 || e === 208 || e === 215 || e === 216 || e >= 222 && e <= 225 || e === 230 || e >= 232 && e <= 234 || e === 236 || e === 237 || e === 240 || e === 242 || e === 243 || e >= 247 && e <= 250 || e === 252 || e === 254 || e === 257 || e === 273 || e === 275 || e === 283 || e === 294 || e === 295 || e === 299 || e >= 305 && e <= 307 || e === 312 || e >= 319 && e <= 322 || e === 324 || e >= 328 && e <= 331 || e === 333 || e === 338 || e === 339 || e === 358 || e === 359 || e === 363 || e === 462 || e === 464 || e === 466 || e === 468 || e === 470 || e === 472 || e === 474 || e === 476 || e === 593 || e === 609 || e === 708 || e === 711 || e >= 713 && e <= 715 || e === 717 || e === 720 || e >= 728 && e <= 731 || e === 733 || e === 735 || e >= 768 && e <= 879 || e >= 913 && e <= 929 || e >= 931 && e <= 937 || e >= 945 && e <= 961 || e >= 963 && e <= 969 || e === 1025 || e >= 1040 && e <= 1103 || e === 1105 || e === 8208 || e >= 8211 && e <= 8214 || e === 8216 || e === 8217 || e === 8220 || e === 8221 || e >= 8224 && e <= 8226 || e >= 8228 && e <= 8231 || e === 8240 || e === 8242 || e === 8243 || e === 8245 || e === 8251 || e === 8254 || e === 8308 || e === 8319 || e >= 8321 && e <= 8324 || e === 8364 || e === 8451 || e === 8453 || e === 8457 || e === 8467 || e === 8470 || e === 8481 || e === 8482 || e === 8486 || e === 8491 || e === 8531 || e === 8532 || e >= 8539 && e <= 8542 || e >= 8544 && e <= 8555 || e >= 8560 && e <= 8569 || e === 8585 || e >= 8592 && e <= 8601 || e === 8632 || e === 8633 || e === 8658 || e === 8660 || e === 8679 || e === 8704 || e === 8706 || e === 8707 || e === 8711 || e === 8712 || e === 8715 || e === 8719 || e === 8721 || e === 8725 || e === 8730 || e >= 8733 && e <= 8736 || e === 8739 || e === 8741 || e >= 8743 && e <= 8748 || e === 8750 || e >= 8756 && e <= 8759 || e === 8764 || e === 8765 || e === 8776 || e === 8780 || e === 8786 || e === 8800 || e === 8801 || e >= 8804 && e <= 8807 || e === 8810 || e === 8811 || e === 8814 || e === 8815 || e === 8834 || e === 8835 || e === 8838 || e === 8839 || e === 8853 || e === 8857 || e === 8869 || e === 8895 || e === 8978 || e >= 9312 && e <= 9449 || e >= 9451 && e <= 9547 || e >= 9552 && e <= 9587 || e >= 9600 && e <= 9615 || e >= 9618 && e <= 9621 || e === 9632 || e === 9633 || e >= 9635 && e <= 9641 || e === 9650 || e === 9651 || e === 9654 || e === 9655 || e === 9660 || e === 9661 || e === 9664 || e === 9665 || e >= 9670 && e <= 9672 || e === 9675 || e >= 9678 && e <= 9681 || e >= 9698 && e <= 9701 || e === 9711 || e === 9733 || e === 9734 || e === 9737 || e === 9742 || e === 9743 || e === 9756 || e === 9758 || e === 9792 || e === 9794 || e === 9824 || e === 9825 || e >= 9827 && e <= 9829 || e >= 9831 && e <= 9834 || e === 9836 || e === 9837 || e === 9839 || e === 9886 || e === 9887 || e === 9919 || e >= 9926 && e <= 9933 || e >= 9935 && e <= 9939 || e >= 9941 && e <= 9953 || e === 9955 || e === 9960 || e === 9961 || e >= 9963 && e <= 9969 || e === 9972 || e >= 9974 && e <= 9977 || e === 9979 || e === 9980 || e === 9982 || e === 9983 || e === 10045 || e >= 10102 && e <= 10111 || e >= 11094 && e <= 11097 || e >= 12872 && e <= 12879 || e >= 57344 && e <= 63743 || e >= 65024 && e <= 65039 || e === 65533 || e >= 127232 && e <= 127242 || e >= 127248 && e <= 127277 || e >= 127280 && e <= 127337 || e >= 127344 && e <= 127373 || e === 127375 || e === 127376 || e >= 127387 && e <= 127404 || e >= 917760 && e <= 917999 || e >= 983040 && e <= 1048573 || e >= 1048576 && e <= 1114109, "ct");
var dt2 = /* @__PURE__ */ __name((e) => e === 12288 || e >= 65281 && e <= 65376 || e >= 65504 && e <= 65510, "dt");
var $t = /* @__PURE__ */ __name((e) => e >= 4352 && e <= 4447 || e === 8986 || e === 8987 || e === 9001 || e === 9002 || e >= 9193 && e <= 9196 || e === 9200 || e === 9203 || e === 9725 || e === 9726 || e === 9748 || e === 9749 || e >= 9800 && e <= 9811 || e === 9855 || e === 9875 || e === 9889 || e === 9898 || e === 9899 || e === 9917 || e === 9918 || e === 9924 || e === 9925 || e === 9934 || e === 9940 || e === 9962 || e === 9970 || e === 9971 || e === 9973 || e === 9978 || e === 9981 || e === 9989 || e === 9994 || e === 9995 || e === 10024 || e === 10060 || e === 10062 || e >= 10067 && e <= 10069 || e === 10071 || e >= 10133 && e <= 10135 || e === 10160 || e === 10175 || e === 11035 || e === 11036 || e === 11088 || e === 11093 || e >= 11904 && e <= 11929 || e >= 11931 && e <= 12019 || e >= 12032 && e <= 12245 || e >= 12272 && e <= 12287 || e >= 12289 && e <= 12350 || e >= 12353 && e <= 12438 || e >= 12441 && e <= 12543 || e >= 12549 && e <= 12591 || e >= 12593 && e <= 12686 || e >= 12688 && e <= 12771 || e >= 12783 && e <= 12830 || e >= 12832 && e <= 12871 || e >= 12880 && e <= 19903 || e >= 19968 && e <= 42124 || e >= 42128 && e <= 42182 || e >= 43360 && e <= 43388 || e >= 44032 && e <= 55203 || e >= 63744 && e <= 64255 || e >= 65040 && e <= 65049 || e >= 65072 && e <= 65106 || e >= 65108 && e <= 65126 || e >= 65128 && e <= 65131 || e >= 94176 && e <= 94180 || e === 94192 || e === 94193 || e >= 94208 && e <= 100343 || e >= 100352 && e <= 101589 || e >= 101632 && e <= 101640 || e >= 110576 && e <= 110579 || e >= 110581 && e <= 110587 || e === 110589 || e === 110590 || e >= 110592 && e <= 110882 || e === 110898 || e >= 110928 && e <= 110930 || e === 110933 || e >= 110948 && e <= 110951 || e >= 110960 && e <= 111355 || e === 126980 || e === 127183 || e === 127374 || e >= 127377 && e <= 127386 || e >= 127488 && e <= 127490 || e >= 127504 && e <= 127547 || e >= 127552 && e <= 127560 || e === 127568 || e === 127569 || e >= 127584 && e <= 127589 || e >= 127744 && e <= 127776 || e >= 127789 && e <= 127797 || e >= 127799 && e <= 127868 || e >= 127870 && e <= 127891 || e >= 127904 && e <= 127946 || e >= 127951 && e <= 127955 || e >= 127968 && e <= 127984 || e === 127988 || e >= 127992 && e <= 128062 || e === 128064 || e >= 128066 && e <= 128252 || e >= 128255 && e <= 128317 || e >= 128331 && e <= 128334 || e >= 128336 && e <= 128359 || e === 128378 || e === 128405 || e === 128406 || e === 128420 || e >= 128507 && e <= 128591 || e >= 128640 && e <= 128709 || e === 128716 || e >= 128720 && e <= 128722 || e >= 128725 && e <= 128727 || e >= 128732 && e <= 128735 || e === 128747 || e === 128748 || e >= 128756 && e <= 128764 || e >= 128992 && e <= 129003 || e === 129008 || e >= 129292 && e <= 129338 || e >= 129340 && e <= 129349 || e >= 129351 && e <= 129535 || e >= 129648 && e <= 129660 || e >= 129664 && e <= 129672 || e >= 129680 && e <= 129725 || e >= 129727 && e <= 129733 || e >= 129742 && e <= 129755 || e >= 129760 && e <= 129768 || e >= 129776 && e <= 129784 || e >= 131072 && e <= 196605 || e >= 196608 && e <= 262141, "$t");
var pe = /[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/y;
var ee = /[\x00-\x08\x0A-\x1F\x7F-\x9F]{1,1000}/y;
var te = /\t{1,1000}/y;
var ge = /[\u{1F1E6}-\u{1F1FF}]{2}|\u{1F3F4}[\u{E0061}-\u{E007A}]{2}[\u{E0030}-\u{E0039}\u{E0061}-\u{E007A}]{1,3}\u{E007F}|(?:\p{Emoji}\uFE0F\u20E3?|\p{Emoji_Modifier_Base}\p{Emoji_Modifier}?|\p{Emoji_Presentation})(?:\u200D(?:\p{Emoji_Modifier_Base}\p{Emoji_Modifier}?|\p{Emoji_Presentation}|\p{Emoji}\uFE0F\u20E3?))*/yu;
var se = /(?:[\x20-\x7E\xA0-\xFF](?!\uFE0F)){1,1000}/y;
var ht2 = /\p{M}+/gu;
var mt2 = { limit: 1 / 0, ellipsis: "" };
var Oe = /* @__PURE__ */ __name((e, i = {}, s = {}) => {
  const r = i.limit ?? 1 / 0, n = i.ellipsis ?? "", o = i?.ellipsisWidth ?? (n ? Oe(n, mt2, s).width : 0), l = s.ansiWidth ?? 0, u = s.controlWidth ?? 0, a = s.tabWidth ?? 8, h = s.ambiguousWidth ?? 1, y2 = s.emojiWidth ?? 2, E = s.fullWidthWidth ?? 2, f = s.regularWidth ?? 1, F = s.wideWidth ?? 2;
  let c = 0, m = 0, $2 = e.length, p = 0, g = false, v = $2, S2 = Math.max(0, r - o), w2 = 0, b2 = 0, A = 0, C = 0;
  e: for (; ; ) {
    if (b2 > w2 || m >= $2 && m > c) {
      const _ = e.slice(w2, b2) || e.slice(c, m);
      p = 0;
      for (const D2 of _.replaceAll(ht2, "")) {
        const T2 = D2.codePointAt(0) || 0;
        if (dt2(T2) ? C = E : $t(T2) ? C = F : h !== f && ct2(T2) ? C = h : C = f, A + C > S2 && (v = Math.min(v, Math.max(w2, c) + p)), A + C > r) {
          g = true;
          break e;
        }
        p += D2.length, A += C;
      }
      w2 = b2 = 0;
    }
    if (m >= $2) break;
    if (se.lastIndex = m, se.test(e)) {
      if (p = se.lastIndex - m, C = p * f, A + C > S2 && (v = Math.min(v, m + Math.floor((S2 - A) / f))), A + C > r) {
        g = true;
        break;
      }
      A += C, w2 = c, b2 = m, m = c = se.lastIndex;
      continue;
    }
    if (pe.lastIndex = m, pe.test(e)) {
      if (A + l > S2 && (v = Math.min(v, m)), A + l > r) {
        g = true;
        break;
      }
      A += l, w2 = c, b2 = m, m = c = pe.lastIndex;
      continue;
    }
    if (ee.lastIndex = m, ee.test(e)) {
      if (p = ee.lastIndex - m, C = p * u, A + C > S2 && (v = Math.min(v, m + Math.floor((S2 - A) / u))), A + C > r) {
        g = true;
        break;
      }
      A += C, w2 = c, b2 = m, m = c = ee.lastIndex;
      continue;
    }
    if (te.lastIndex = m, te.test(e)) {
      if (p = te.lastIndex - m, C = p * a, A + C > S2 && (v = Math.min(v, m + Math.floor((S2 - A) / a))), A + C > r) {
        g = true;
        break;
      }
      A += C, w2 = c, b2 = m, m = c = te.lastIndex;
      continue;
    }
    if (ge.lastIndex = m, ge.test(e)) {
      if (A + y2 > S2 && (v = Math.min(v, m)), A + y2 > r) {
        g = true;
        break;
      }
      A += y2, w2 = c, b2 = m, m = c = ge.lastIndex;
      continue;
    }
    m += 1;
  }
  return { width: g ? S2 : A, index: g ? v : $2, truncated: g, ellipsed: g && r >= o };
}, "Oe");
var pt2 = { limit: 1 / 0, ellipsis: "", ellipsisWidth: 0 };
var M2 = /* @__PURE__ */ __name((e, i = {}) => Oe(e, pt2, i).width, "M");
var re = "\x1B";
var Ne = "\x9B";
var gt2 = 39;
var fe = "\x07";
var Pe = "[";
var ft2 = "]";
var Le = "m";
var Fe = `${ft2}8;;`;
var We = new RegExp(`(?:\\${Pe}(?<code>\\d+)m|\\${Fe}(?<uri>.*)${fe})`, "y");
var Ft2 = /* @__PURE__ */ __name((e) => {
  if (e >= 30 && e <= 37 || e >= 90 && e <= 97) return 39;
  if (e >= 40 && e <= 47 || e >= 100 && e <= 107) return 49;
  if (e === 1 || e === 2) return 22;
  if (e === 3) return 23;
  if (e === 4) return 24;
  if (e === 7) return 27;
  if (e === 8) return 28;
  if (e === 9) return 29;
  if (e === 0) return 0;
}, "Ft");
var je = /* @__PURE__ */ __name((e) => `${re}${Pe}${e}${Le}`, "je");
var Ve = /* @__PURE__ */ __name((e) => `${re}${Fe}${e}${fe}`, "Ve");
var yt2 = /* @__PURE__ */ __name((e) => e.map((i) => M2(i)), "yt");
var ye = /* @__PURE__ */ __name((e, i, s) => {
  const r = i[Symbol.iterator]();
  let n = false, o = false, l = e.at(-1), u = l === void 0 ? 0 : M2(l), a = r.next(), h = r.next(), y2 = 0;
  for (; !a.done; ) {
    const E = a.value, f = M2(E);
    u + f <= s ? e[e.length - 1] += E : (e.push(E), u = 0), (E === re || E === Ne) && (n = true, o = i.startsWith(Fe, y2 + 1)), n ? o ? E === fe && (n = false, o = false) : E === Le && (n = false) : (u += f, u === s && !h.done && (e.push(""), u = 0)), a = h, h = r.next(), y2 += E.length;
  }
  l = e.at(-1), !u && l !== void 0 && l.length > 0 && e.length > 1 && (e[e.length - 2] += e.pop());
}, "ye");
var Et2 = /* @__PURE__ */ __name((e) => {
  const i = e.split(" ");
  let s = i.length;
  for (; s > 0 && !(M2(i[s - 1]) > 0); ) s--;
  return s === i.length ? e : i.slice(0, s).join(" ") + i.slice(s).join("");
}, "Et");
var vt2 = /* @__PURE__ */ __name((e, i, s = {}) => {
  if (s.trim !== false && e.trim() === "") return "";
  let r = "", n, o;
  const l = e.split(" "), u = yt2(l);
  let a = [""];
  for (const [c, m] of l.entries()) {
    s.trim !== false && (a[a.length - 1] = (a.at(-1) ?? "").trimStart());
    let $2 = M2(a.at(-1) ?? "");
    if (c !== 0 && ($2 >= i && (s.wordWrap === false || s.trim === false) && (a.push(""), $2 = 0), ($2 > 0 || s.trim === false) && (a[a.length - 1] += " ", $2++)), s.hard && u[c] > i) {
      const p = i - $2, g = 1 + Math.floor((u[c] - p - 1) / i);
      Math.floor((u[c] - 1) / i) < g && a.push(""), ye(a, m, i);
      continue;
    }
    if ($2 + u[c] > i && $2 > 0 && u[c] > 0) {
      if (s.wordWrap === false && $2 < i) {
        ye(a, m, i);
        continue;
      }
      a.push("");
    }
    if ($2 + u[c] > i && s.wordWrap === false) {
      ye(a, m, i);
      continue;
    }
    a[a.length - 1] += m;
  }
  s.trim !== false && (a = a.map((c) => Et2(c)));
  const h = a.join(`
`), y2 = h[Symbol.iterator]();
  let E = y2.next(), f = y2.next(), F = 0;
  for (; !E.done; ) {
    const c = E.value, m = f.value;
    if (r += c, c === re || c === Ne) {
      We.lastIndex = F + 1;
      const g = We.exec(h)?.groups;
      if (g?.code !== void 0) {
        const v = Number.parseFloat(g.code);
        n = v === gt2 ? void 0 : v;
      } else g?.uri !== void 0 && (o = g.uri.length === 0 ? void 0 : g.uri);
    }
    const $2 = n ? Ft2(n) : void 0;
    m === `
` ? (o && (r += Ve("")), n && $2 && (r += je($2))) : c === `
` && (n && $2 && (r += je(n)), o && (r += Ve(o))), F += c.length, E = f, f = y2.next();
  }
  return r;
}, "vt");
function U2(e, i, s) {
  return String(e).normalize().replaceAll(`\r
`, `
`).split(`
`).map((r) => vt2(r, i, s)).join(`
`);
}
__name(U2, "U");
var At2 = /* @__PURE__ */ __name((e, i, s, r, n) => {
  let o = i, l = 0;
  for (let u = s; u < r; u++) {
    const a = e[u];
    if (o = o - a.length, l++, o <= n) break;
  }
  return { lineCount: o, removals: l };
}, "At");
var K2 = /* @__PURE__ */ __name((e) => {
  const { cursor: i, options: s, style: r } = e, n = e.output ?? process.stdout, o = Ct(n), l = e.columnPadding ?? 0, u = e.rowPadding ?? 4, a = o - l, h = Bt(n), y2 = import_picocolors2.default.dim("..."), E = e.maxItems ?? Number.POSITIVE_INFINITY, f = Math.max(h - u, 0), F = Math.max(Math.min(E, f), 5);
  let c = 0;
  i >= F - 3 && (c = Math.max(Math.min(i - F + 3, s.length - F), 0));
  let m = F < s.length && c > 0, $2 = F < s.length && c + F < s.length;
  const p = Math.min(c + F, s.length), g = [];
  let v = 0;
  m && v++, $2 && v++;
  const S2 = c + (m ? 1 : 0), w2 = p - ($2 ? 1 : 0);
  for (let A = S2; A < w2; A++) {
    const C = U2(r(s[A], A === i), a, { hard: true, trim: false }).split(`
`);
    g.push(C), v += C.length;
  }
  if (v > f) {
    let A = 0, C = 0, _ = v;
    const D2 = i - S2, T2 = /* @__PURE__ */ __name((k2, B2) => At2(g, _, k2, B2, f), "T");
    m ? ({ lineCount: _, removals: A } = T2(0, D2), _ > f && ({ lineCount: _, removals: C } = T2(D2 + 1, g.length))) : ({ lineCount: _, removals: C } = T2(D2 + 1, g.length), _ > f && ({ lineCount: _, removals: A } = T2(0, D2))), A > 0 && (m = true, g.splice(0, A)), C > 0 && ($2 = true, g.splice(g.length - C, C));
  }
  const b2 = [];
  m && b2.push(y2);
  for (const A of g) for (const C of A) b2.push(C);
  return $2 && b2.push(y2), b2;
}, "K");
var xt = /* @__PURE__ */ __name((e) => {
  const i = e.active ?? "Yes", s = e.inactive ?? "No";
  return new Vt({ active: i, inactive: s, signal: e.signal, input: e.input, output: e.output, initialValue: e.initialValue ?? true, render() {
    const r = `${import_picocolors2.default.gray(d)}
${L2(this.state)}  ${e.message}
`, n = this.value ? i : s;
    switch (this.state) {
      case "submit":
        return `${r}${import_picocolors2.default.gray(d)}  ${import_picocolors2.default.dim(n)}`;
      case "cancel":
        return `${r}${import_picocolors2.default.gray(d)}  ${import_picocolors2.default.strikethrough(import_picocolors2.default.dim(n))}
${import_picocolors2.default.gray(d)}`;
      default:
        return `${r}${import_picocolors2.default.cyan(d)}  ${this.value ? `${import_picocolors2.default.green(J2)} ${i}` : `${import_picocolors2.default.dim(H)} ${import_picocolors2.default.dim(i)}`} ${import_picocolors2.default.dim("/")} ${this.value ? `${import_picocolors2.default.dim(H)} ${import_picocolors2.default.dim(s)}` : `${import_picocolors2.default.green(J2)} ${s}`}
${import_picocolors2.default.cyan(x)}
`;
    }
  } }).prompt();
}, "xt");
var R = { message: /* @__PURE__ */ __name((e = [], { symbol: i = import_picocolors2.default.gray(d), secondarySymbol: s = import_picocolors2.default.gray(d), output: r = process.stdout, spacing: n = 1 } = {}) => {
  const o = [];
  for (let u = 0; u < n; u++) o.push(`${s}`);
  const l = Array.isArray(e) ? e : e.split(`
`);
  if (l.length > 0) {
    const [u, ...a] = l;
    u.length > 0 ? o.push(`${i}  ${u}`) : o.push(i);
    for (const h of a) h.length > 0 ? o.push(`${s}  ${h}`) : o.push(s);
  }
  r.write(`${o.join(`
`)}
`);
}, "message"), info: /* @__PURE__ */ __name((e, i) => {
  R.message(e, { ...i, symbol: import_picocolors2.default.blue(de) });
}, "info"), success: /* @__PURE__ */ __name((e, i) => {
  R.message(e, { ...i, symbol: import_picocolors2.default.green($e) });
}, "success"), step: /* @__PURE__ */ __name((e, i) => {
  R.message(e, { ...i, symbol: import_picocolors2.default.green(W2) });
}, "step"), warn: /* @__PURE__ */ __name((e, i) => {
  R.message(e, { ...i, symbol: import_picocolors2.default.yellow(he) });
}, "warn"), warning: /* @__PURE__ */ __name((e, i) => {
  R.warn(e, i);
}, "warning"), error: /* @__PURE__ */ __name((e, i) => {
  R.message(e, { ...i, symbol: import_picocolors2.default.red(me) });
}, "error") };
var Tt2 = /* @__PURE__ */ __name((e = "", i) => {
  (i?.output ?? process.stdout).write(`${import_picocolors2.default.gray(x)}  ${import_picocolors2.default.red(e)}

`);
}, "Tt");
var Mt2 = /* @__PURE__ */ __name((e = "", i) => {
  (i?.output ?? process.stdout).write(`${import_picocolors2.default.gray(le)}  ${e}
`);
}, "Mt");
var Rt = /* @__PURE__ */ __name((e = "", i) => {
  (i?.output ?? process.stdout).write(`${import_picocolors2.default.gray(d)}
${import_picocolors2.default.gray(x)}  ${e}

`);
}, "Rt");
var Ot = /* @__PURE__ */ __name((e) => {
  const i = /* @__PURE__ */ __name((r, n) => {
    const o = r.label ?? String(r.value);
    return n === "disabled" ? `${import_picocolors2.default.gray(X2)} ${import_picocolors2.default.gray(o)}${r.hint ? ` ${import_picocolors2.default.dim(`(${r.hint ?? "disabled"})`)}` : ""}` : n === "active" ? `${import_picocolors2.default.cyan(Z2)} ${o}${r.hint ? ` ${import_picocolors2.default.dim(`(${r.hint})`)}` : ""}` : n === "selected" ? `${import_picocolors2.default.green(j2)} ${import_picocolors2.default.dim(o)}${r.hint ? ` ${import_picocolors2.default.dim(`(${r.hint})`)}` : ""}` : n === "cancelled" ? `${import_picocolors2.default.strikethrough(import_picocolors2.default.dim(o))}` : n === "active-selected" ? `${import_picocolors2.default.green(j2)} ${o}${r.hint ? ` ${import_picocolors2.default.dim(`(${r.hint})`)}` : ""}` : n === "submitted" ? `${import_picocolors2.default.dim(o)}` : `${import_picocolors2.default.dim(X2)} ${import_picocolors2.default.dim(o)}`;
  }, "i"), s = e.required ?? true;
  return new yt({ options: e.options, signal: e.signal, input: e.input, output: e.output, initialValues: e.initialValues, required: s, cursorAt: e.cursorAt, validate(r) {
    if (s && (r === void 0 || r.length === 0)) return `Please select at least one option.
${import_picocolors2.default.reset(import_picocolors2.default.dim(`Press ${import_picocolors2.default.gray(import_picocolors2.default.bgWhite(import_picocolors2.default.inverse(" space ")))} to select, ${import_picocolors2.default.gray(import_picocolors2.default.bgWhite(import_picocolors2.default.inverse(" enter ")))} to submit`))}`;
  }, render() {
    const r = `${import_picocolors2.default.gray(d)}
${L2(this.state)}  ${e.message}
`, n = this.value ?? [], o = /* @__PURE__ */ __name((l, u) => {
      if (l.disabled) return i(l, "disabled");
      const a = n.includes(l.value);
      return u && a ? i(l, "active-selected") : a ? i(l, "selected") : i(l, u ? "active" : "inactive");
    }, "o");
    switch (this.state) {
      case "submit":
        return `${r}${import_picocolors2.default.gray(d)}  ${this.options.filter(({ value: l }) => n.includes(l)).map((l) => i(l, "submitted")).join(import_picocolors2.default.dim(", ")) || import_picocolors2.default.dim("none")}`;
      case "cancel": {
        const l = this.options.filter(({ value: u }) => n.includes(u)).map((u) => i(u, "cancelled")).join(import_picocolors2.default.dim(", "));
        return `${r}${import_picocolors2.default.gray(d)}${l.trim() ? `  ${l}
${import_picocolors2.default.gray(d)}` : ""}`;
      }
      case "error": {
        const l = `${import_picocolors2.default.yellow(d)}  `, u = this.error.split(`
`).map((a, h) => h === 0 ? `${import_picocolors2.default.yellow(x)}  ${import_picocolors2.default.yellow(a)}` : `   ${a}`).join(`
`);
        return `${r}${l}${K2({ output: e.output, options: this.options, cursor: this.cursor, maxItems: e.maxItems, columnPadding: l.length, style: o }).join(`
${l}`)}
${u}
`;
      }
      default: {
        const l = `${import_picocolors2.default.cyan(d)}  `;
        return `${r}${l}${K2({ output: e.output, options: this.options, cursor: this.cursor, maxItems: e.maxItems, columnPadding: l.length, style: o }).join(`
${l}`)}
${import_picocolors2.default.cyan(x)}
`;
      }
    }
  } }).prompt();
}, "Ot");
var Vt2 = import_picocolors2.default.magenta;
var Ee = /* @__PURE__ */ __name(({ indicator: e = "dots", onCancel: i, output: s = process.stdout, cancelMessage: r, errorMessage: n, frames: o = z2 ? ["\u25D2", "\u25D0", "\u25D3", "\u25D1"] : ["\u2022", "o", "O", "0"], delay: l = z2 ? 80 : 120, signal: u, ...a } = {}) => {
  const h = ne();
  let y2, E, f = false, F = false, c = "", m, $2 = performance.now();
  const p = Ct(s), g = a?.styleFrame ?? Vt2, v = /* @__PURE__ */ __name((B2) => {
    const O2 = B2 > 1 ? n ?? b.messages.error : r ?? b.messages.cancel;
    F = B2 === 1, f && (k2(O2, B2), F && typeof i == "function" && i());
  }, "v"), S2 = /* @__PURE__ */ __name(() => v(2), "S"), w2 = /* @__PURE__ */ __name(() => v(1), "w"), b2 = /* @__PURE__ */ __name(() => {
    process.on("uncaughtExceptionMonitor", S2), process.on("unhandledRejection", S2), process.on("SIGINT", w2), process.on("SIGTERM", w2), process.on("exit", v), u && u.addEventListener("abort", w2);
  }, "b"), A = /* @__PURE__ */ __name(() => {
    process.removeListener("uncaughtExceptionMonitor", S2), process.removeListener("unhandledRejection", S2), process.removeListener("SIGINT", w2), process.removeListener("SIGTERM", w2), process.removeListener("exit", v), u && u.removeEventListener("abort", w2);
  }, "A"), C = /* @__PURE__ */ __name(() => {
    if (m === void 0) return;
    h && s.write(`
`);
    const B2 = U2(m, p, { hard: true, trim: false }).split(`
`);
    B2.length > 1 && s.write(import_sisteransi2.cursor.up(B2.length - 1)), s.write(import_sisteransi2.cursor.to(0)), s.write(import_sisteransi2.erase.down());
  }, "C"), _ = /* @__PURE__ */ __name((B2) => B2.replace(/\.+$/, ""), "_"), D2 = /* @__PURE__ */ __name((B2) => {
    const O2 = (performance.now() - B2) / 1e3, P2 = Math.floor(O2 / 60), G2 = Math.floor(O2 % 60);
    return P2 > 0 ? `[${P2}m ${G2}s]` : `[${G2}s]`;
  }, "D"), T2 = /* @__PURE__ */ __name((B2 = "") => {
    f = true, y2 = bt({ output: s }), c = _(B2), $2 = performance.now(), s.write(`${import_picocolors2.default.gray(d)}
`);
    let O2 = 0, P2 = 0;
    b2(), E = setInterval(() => {
      if (h && c === m) return;
      C(), m = c;
      const G2 = g(o[O2]);
      let Y2;
      if (h) Y2 = `${G2}  ${c}...`;
      else if (e === "timer") Y2 = `${G2}  ${c} ${D2($2)}`;
      else {
        const Xe = ".".repeat(Math.floor(P2)).slice(0, 3);
        Y2 = `${G2}  ${c}${Xe}`;
      }
      const Je = U2(Y2, p, { hard: true, trim: false });
      s.write(Je), O2 = O2 + 1 < o.length ? O2 + 1 : 0, P2 = P2 < 4 ? P2 + 0.125 : 0;
    }, l);
  }, "T"), k2 = /* @__PURE__ */ __name((B2 = "", O2 = 0) => {
    if (!f) return;
    f = false, clearInterval(E), C();
    const P2 = O2 === 0 ? import_picocolors2.default.green(W2) : O2 === 1 ? import_picocolors2.default.red(ae) : import_picocolors2.default.red(oe);
    c = B2 ?? c, e === "timer" ? s.write(`${P2}  ${c} ${D2($2)}
`) : s.write(`${P2}  ${c}
`), A(), y2();
  }, "k");
  return { start: T2, stop: k2, message: /* @__PURE__ */ __name((B2 = "") => {
    c = _(B2 ?? c);
  }, "message"), get isCancelled() {
    return F;
  } };
}, "Ee");
var Ke = { light: I2("\u2500", "-"), heavy: I2("\u2501", "="), block: I2("\u2588", "#") };
var Gt = /* @__PURE__ */ __name((e) => {
  const i = /* @__PURE__ */ __name((s, r) => {
    const n = s.label ?? String(s.value);
    switch (r) {
      case "disabled":
        return `${import_picocolors2.default.gray(H)} ${import_picocolors2.default.gray(n)}${s.hint ? ` ${import_picocolors2.default.dim(`(${s.hint ?? "disabled"})`)}` : ""}`;
      case "selected":
        return `${import_picocolors2.default.dim(n)}`;
      case "active":
        return `${import_picocolors2.default.green(J2)} ${n}${s.hint ? ` ${import_picocolors2.default.dim(`(${s.hint})`)}` : ""}`;
      case "cancelled":
        return `${import_picocolors2.default.strikethrough(import_picocolors2.default.dim(n))}`;
      default:
        return `${import_picocolors2.default.dim(H)} ${import_picocolors2.default.dim(n)}`;
    }
  }, "i");
  return new Lt({ options: e.options, signal: e.signal, input: e.input, output: e.output, initialValue: e.initialValue, render() {
    const s = `${import_picocolors2.default.gray(d)}
${L2(this.state)}  ${e.message}
`;
    switch (this.state) {
      case "submit":
        return `${s}${import_picocolors2.default.gray(d)}  ${i(this.options[this.cursor], "selected")}`;
      case "cancel":
        return `${s}${import_picocolors2.default.gray(d)}  ${i(this.options[this.cursor], "cancelled")}
${import_picocolors2.default.gray(d)}`;
      default: {
        const r = `${import_picocolors2.default.cyan(d)}  `;
        return `${s}${r}${K2({ output: e.output, cursor: this.cursor, options: this.options, maxItems: e.maxItems, columnPadding: r.length, style: /* @__PURE__ */ __name((n, o) => i(n, n.disabled ? "disabled" : o ? "active" : "inactive"), "style") }).join(`
${r}`)}
${import_picocolors2.default.cyan(x)}
`;
      }
    }
  } }).prompt();
}, "Gt");
var qe = `${import_picocolors2.default.gray(d)}  `;
var Kt = /* @__PURE__ */ __name((e) => {
  const i = e.output ?? process.stdout, s = Ct(i), r = import_picocolors2.default.gray(d), n = e.spacing ?? 1, o = 3, l = e.retainLog === true, u = !ne() && Be(i);
  i.write(`${r}
`), i.write(`${import_picocolors2.default.green(W2)}  ${e.title}
`);
  for (let $2 = 0; $2 < n; $2++) i.write(`${r}
`);
  const a = [{ value: "", full: "" }];
  let h = false;
  const y2 = /* @__PURE__ */ __name(($2) => {
    if (a.length === 0) return;
    let p = 0;
    $2 && (p += n + 2);
    for (const g of a) {
      const { value: v, result: S2 } = g;
      let w2 = S2?.message ?? v;
      if (w2.length === 0) continue;
      S2 === void 0 && g.header !== void 0 && g.header !== "" && (w2 += `
${g.header}`);
      const b2 = w2.split(`
`).reduce((A, C) => C === "" ? A + 1 : A + Math.ceil((C.length + o) / s), 0);
      p += b2;
    }
    p > 0 && (p += 1, i.write(import_sisteransi2.erase.lines(p)));
  }, "y"), E = /* @__PURE__ */ __name(($2, p, g) => {
    const v = g ? `${$2.full}
${$2.value}` : $2.value;
    $2.header !== void 0 && $2.header !== "" && R.message($2.header.split(`
`).map(import_picocolors2.default.bold), { output: i, secondarySymbol: r, symbol: r, spacing: 0 }), R.message(v.split(`
`).map(import_picocolors2.default.dim), { output: i, secondarySymbol: r, symbol: r, spacing: p ?? n });
  }, "E"), f = /* @__PURE__ */ __name(() => {
    for (const $2 of a) {
      const { header: p, value: g, full: v } = $2;
      (p === void 0 || p.length === 0) && g.length === 0 || E($2, void 0, l === true && v.length > 0);
    }
  }, "f"), F = /* @__PURE__ */ __name(($2, p, g) => {
    if (y2(false), (g?.raw !== true || !h) && $2.value !== "" && ($2.value += `
`), $2.value += p, h = g?.raw === true, e.limit !== void 0) {
      const v = $2.value.split(`
`), S2 = v.length - e.limit;
      if (S2 > 0) {
        const w2 = v.splice(0, S2);
        l && ($2.full += ($2.full === "" ? "" : `
`) + w2.join(`
`));
      }
      $2.value = v.join(`
`);
    }
    u && c();
  }, "F"), c = /* @__PURE__ */ __name(() => {
    for (const $2 of a) $2.result ? $2.result.status === "error" ? R.error($2.result.message, { output: i, secondarySymbol: r, spacing: 0 }) : R.success($2.result.message, { output: i, secondarySymbol: r, spacing: 0 }) : $2.value !== "" && E($2, 0);
  }, "c"), m = /* @__PURE__ */ __name(($2, p) => {
    y2(false), $2.result = p, u && c();
  }, "m");
  return { message($2, p) {
    F(a[0], $2, p);
  }, group($2) {
    const p = { header: $2, value: "", full: "" };
    return a.push(p), { message(g, v) {
      F(p, g, v);
    }, error(g) {
      m(p, { status: "error", message: g });
    }, success(g) {
      m(p, { status: "success", message: g });
    } };
  }, error($2, p) {
    y2(true), R.error($2, { output: i, secondarySymbol: r, spacing: 1 }), p?.showLog !== false && f(), a.splice(1, a.length - 1), a[0].value = "", a[0].full = "";
  }, success($2, p) {
    y2(true), R.success($2, { output: i, secondarySymbol: r, spacing: 1 }), p?.showLog === true && f(), a.splice(1, a.length - 1), a[0].value = "", a[0].full = "";
  } };
}, "Kt");
var qt = /* @__PURE__ */ __name((e) => new Tt({ validate: e.validate, placeholder: e.placeholder, defaultValue: e.defaultValue, initialValue: e.initialValue, output: e.output, signal: e.signal, input: e.input, render() {
  const i = `${import_picocolors2.default.gray(d)}
${L2(this.state)}  ${e.message}
`, s = e.placeholder ? import_picocolors2.default.inverse(e.placeholder[0]) + import_picocolors2.default.dim(e.placeholder.slice(1)) : import_picocolors2.default.inverse(import_picocolors2.default.hidden("_")), r = this.userInput ? this.userInputWithCursor : s, n = this.value ?? "";
  switch (this.state) {
    case "error": {
      const o = this.error ? `  ${import_picocolors2.default.yellow(this.error)}` : "";
      return `${i.trim()}
${import_picocolors2.default.yellow(d)}  ${r}
${import_picocolors2.default.yellow(x)}${o}
`;
    }
    case "submit": {
      const o = n ? `  ${import_picocolors2.default.dim(n)}` : "";
      return `${i}${import_picocolors2.default.gray(d)}${o}`;
    }
    case "cancel": {
      const o = n ? `  ${import_picocolors2.default.strikethrough(import_picocolors2.default.dim(n))}` : "";
      return `${i}${import_picocolors2.default.gray(d)}${o}${n.trim() ? `
${import_picocolors2.default.gray(d)}` : ""}`;
    }
    default:
      return `${i}${import_picocolors2.default.cyan(d)}  ${r}
${import_picocolors2.default.cyan(x)}
`;
  }
} }).prompt(), "qt");

// src/node-logger/prompts/prompt-config.ts
var prompt_config_exports = {};
__export(prompt_config_exports, {
  getPreferredStdio: () => getPreferredStdio,
  getPromptLibrary: () => getPromptLibrary,
  getPromptProvider: () => getPromptProvider,
  isClackEnabled: () => isClackEnabled,
  isPromptsEnabled: () => isPromptsEnabled,
  setPromptLibrary: () => setPromptLibrary
});

// src/node-logger/logger/log-tracker.ts
import { promises as fs } from "node:fs";
import path, { join } from "node:path";
import { isCI } from "storybook/internal/common";

// ../lib/cli-storybook/src/automigrate/helpers/cleanLog.ts
import { EOL } from "node:os";
var ansiRegex = /* @__PURE__ */ __name(({ onlyFirst = false } = {}) => {
  const pattern = [
    "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
    "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"
  ].join("|");
  return new RegExp(pattern, onlyFirst ? void 0 : "g");
}, "ansiRegex");
var cleanLog = /* @__PURE__ */ __name((str) => str.replace(ansiRegex(), "").replace(/╮│/g, "\u256E\n\u2502").replace(/││/g, "\u2502\n\u2502").replace(/│╰/g, "\u2502\n\u2570").replace(/⚠️ {2}failed to check/g, `${EOL}\u26A0\uFE0F  failed to check`), "cleanLog");

// src/node-logger/logger/log-tracker.ts
var DEBUG_LOG_FILE_NAME = "debug-storybook.log";
var LogTracker = class {
  static {
    __name(this, "LogTracker");
  }
  /** Array to store log entries */
  #logs = [];
  /** Path where log file will be written */
  #logFilePath = "";
  /**
   * Flag indicating if logs should be written to file it is enabled either by users providing the
   * `--write-logs` flag to a CLI command or when we explicitly enable it by calling
   * `logTracker.enableLogWriting()` e.g. in automigrate or doctor command when there are issues
   */
  #shouldWriteLogsToFile = false;
  constructor() {
    this.#logFilePath = join(process.cwd(), DEBUG_LOG_FILE_NAME);
  }
  /** Enables writing logs to file. */
  enableLogWriting() {
    this.#shouldWriteLogsToFile = true;
  }
  /** Returns whether logs should be written to file. */
  get shouldWriteLogsToFile() {
    return this.#shouldWriteLogsToFile;
  }
  /** Returns the configured log file path. */
  get logFilePath() {
    return this.#logFilePath;
  }
  /** Returns a copy of all stored logs. */
  get logs() {
    return [...this.#logs];
  }
  /**
   * Adds a new log entry.
   *
   * @param level - The log level
   * @param message - The log message
   * @param metadata - Optional metadata to attach to the log, can be any JSON serializable value
   */
  addLog(level, message, metadata) {
    this.#logs.push({
      timestamp: /* @__PURE__ */ new Date(),
      level,
      message: cleanLog(message),
      metadata
    });
  }
  /** Clears all stored logs. */
  clear() {
    this.#logs = [];
  }
  /**
   * Writes all stored logs to a file and clears the log store.
   *
   * @param filePath - Optional custom file path to write logs to
   * @returns The path where logs were written, by default is debug-storybook.log in current working
   *   directory
   */
  async writeToFile(filePath = this.#logFilePath) {
    const logContent = this.#logs.map((log2) => {
      const timestamp = log2.timestamp.toLocaleTimeString("en-US", { hour12: false }) + `.${log2.timestamp.getMilliseconds().toString().padStart(3, "0")}`;
      const metadata = log2.metadata ? ` ${JSON.stringify(log2.metadata)}` : "";
      return `[${timestamp}] [${log2.level.toUpperCase()}] ${log2.message}${metadata}`;
    }).join("\n");
    await fs.writeFile(filePath, logContent, "utf-8");
    this.#logs = [];
    return isCI() ? filePath : path.relative(process.cwd(), filePath);
  }
};
var logTracker = new LogTracker();

// src/node-logger/prompts/prompt-provider-base.ts
var PromptProvider = class {
  static {
    __name(this, "PromptProvider");
  }
};

// src/node-logger/prompts/prompt-provider-clack.ts
var currentTaskLog = null;
var ClackPromptProvider = class extends PromptProvider {
  static {
    __name(this, "ClackPromptProvider");
  }
  handleCancel(result, promptOptions) {
    if (_t(result)) {
      if (promptOptions?.onCancel) {
        promptOptions.onCancel();
      } else {
        Tt2("Operation canceled.");
        process.exit(0);
      }
    }
  }
  async text(options, promptOptions) {
    const result = await qt(options);
    this.handleCancel(result, promptOptions);
    logTracker.addLog("prompt", options.message, { choice: result });
    return result.toString();
  }
  async confirm(options, promptOptions) {
    const result = await xt(options);
    this.handleCancel(result, promptOptions);
    logTracker.addLog("prompt", options.message, { choice: result });
    return Boolean(result);
  }
  async select(options, promptOptions) {
    const result = await Gt(options);
    this.handleCancel(result, promptOptions);
    logTracker.addLog("prompt", options.message, { choice: result });
    return result;
  }
  async multiselect(options, promptOptions) {
    const result = await Ot({
      ...options,
      required: options.required
    });
    this.handleCancel(result, promptOptions);
    logTracker.addLog("prompt", options.message, { choice: result });
    return result;
  }
  spinner(options) {
    const task = Ee();
    const spinnerId = `${options.id}-spinner`;
    return {
      start: /* @__PURE__ */ __name((message) => {
        logTracker.addLog("info", `${spinnerId}-start: ${message}`);
        task.start(message);
      }, "start"),
      message: /* @__PURE__ */ __name((message) => {
        logTracker.addLog("info", `${spinnerId}: ${message}`);
        task.message(message);
      }, "message"),
      stop: /* @__PURE__ */ __name((message) => {
        logTracker.addLog("info", `${spinnerId}-stop: ${message}`);
        task.stop(message);
      }, "stop")
    };
  }
  taskLog(options) {
    const task = Kt(options);
    const taskId = `${options.id}-task`;
    logTracker.addLog("info", `${taskId}-start: ${options.title}`);
    currentTaskLog = task;
    return {
      message: /* @__PURE__ */ __name((message) => {
        logTracker.addLog("info", `${taskId}: ${message}`);
        task.message(message);
      }, "message"),
      error: /* @__PURE__ */ __name((message) => {
        logTracker.addLog("error", `${taskId}-error: ${message}`);
        task.error(message, { showLog: true });
        currentTaskLog = null;
      }, "error"),
      success: /* @__PURE__ */ __name((message, options2) => {
        logTracker.addLog("info", `${taskId}-success: ${message}`);
        task.success(message, options2);
        currentTaskLog = null;
      }, "success")
    };
  }
};

// src/node-logger/prompts/prompt-provider-prompts.ts
var import_prompts = __toESM(require_prompts(), 1);
var PromptsPromptProvider = class extends PromptProvider {
  static {
    __name(this, "PromptsPromptProvider");
  }
  getBaseOptions(promptOptions) {
    return {
      onCancel: /* @__PURE__ */ __name(() => {
        if (promptOptions?.onCancel) {
          promptOptions.onCancel();
        } else {
          logger.info("Operation canceled.");
          process.exit(0);
        }
      }, "onCancel")
    };
  }
  async text(options, promptOptions) {
    const validate = options.validate ? (value) => {
      const result2 = options.validate(value);
      if (result2 instanceof Error) {
        return result2.message;
      }
      if (typeof result2 === "string") {
        return result2;
      }
      return true;
    } : void 0;
    const result = await (0, import_prompts.default)(
      {
        type: "text",
        name: "value",
        message: options.message,
        initial: options.initialValue,
        validate
      },
      { ...this.getBaseOptions(promptOptions) }
    );
    logTracker.addLog("prompt", options.message, { choice: result.value });
    return result.value;
  }
  async confirm(options, promptOptions) {
    const result = await (0, import_prompts.default)(
      {
        type: "confirm",
        name: "value",
        message: options.message,
        initial: options.initialValue,
        active: options.active,
        inactive: options.inactive
      },
      { ...this.getBaseOptions(promptOptions) }
    );
    logTracker.addLog("prompt", options.message, { choice: result.value });
    return result.value;
  }
  async select(options, promptOptions) {
    const result = await (0, import_prompts.default)(
      {
        type: "select",
        name: "value",
        message: options.message,
        choices: options.options.map((opt) => ({
          title: opt.label || String(opt.value),
          value: opt.value,
          description: opt.hint,
          selected: opt.value === options.initialValue
        }))
      },
      { ...this.getBaseOptions(promptOptions) }
    );
    logTracker.addLog("prompt", options.message, { choice: result.value });
    return result.value;
  }
  async multiselect(options, promptOptions) {
    const result = await (0, import_prompts.default)(
      {
        type: "multiselect",
        name: "value",
        message: options.message,
        choices: options.options.map((opt) => ({
          title: opt.label || String(opt.value),
          value: opt.value,
          description: opt.hint,
          selected: options.initialValues?.includes(opt.value)
        })),
        min: options.required ? 1 : 0
      },
      { ...this.getBaseOptions(promptOptions) }
    );
    logTracker.addLog("prompt", options.message, { choice: result.value });
    return result.value;
  }
  spinner(options) {
    let interval;
    const chars = ["\u280B", "\u2819", "\u2839", "\u2838", "\u283C", "\u2834", "\u2826", "\u2827", "\u2807", "\u280F"];
    let i = 0;
    const spinnerId = `${options.id}-spinner`;
    return {
      start: /* @__PURE__ */ __name((message) => {
        logTracker.addLog("info", `${spinnerId}-start: ${message}`);
        process.stdout.write("\x1B[?25l");
        interval = setInterval(() => {
          process.stdout.write(`\r${chars[i]} ${message || "Loading..."}`);
          i = (i + 1) % chars.length;
        }, 100);
      }, "start"),
      stop: /* @__PURE__ */ __name((message) => {
        logTracker.addLog("info", `${spinnerId}-stop: ${message}`);
        clearInterval(interval);
        process.stdout.write("\x1B[?25h");
        if (message) {
          process.stdout.write(`\r\u2713 ${message}
`);
        } else {
          process.stdout.write("\r\x1B[K");
        }
      }, "stop"),
      message: /* @__PURE__ */ __name((text2) => {
        logTracker.addLog("info", `${spinnerId}: ${text2}`);
        process.stdout.write(`\r${text2}`);
      }, "message")
    };
  }
  taskLog(options) {
    logger.info(`${options.title}
`);
    const taskId = `${options.id}-task`;
    logTracker.addLog("info", `${taskId}-start: ${options.title}`);
    return {
      message: /* @__PURE__ */ __name((text2) => {
        logger.info(text2);
        logTracker.addLog("info", `${taskId}: ${text2}`);
      }, "message"),
      success: /* @__PURE__ */ __name((message) => {
        logger.info(message);
        logTracker.addLog("info", `${taskId}-success: ${message}`);
      }, "success"),
      error: /* @__PURE__ */ __name((message) => {
        logger.error(message);
        logTracker.addLog("error", `${taskId}-error: ${message}`);
      }, "error")
    };
  }
};

// src/node-logger/prompts/prompt-config.ts
var PROVIDERS = {
  clack: new ClackPromptProvider(),
  prompts: new PromptsPromptProvider()
};
var currentPromptLibrary = optionalEnvToBoolean(process.env.USE_CLACK) ? "clack" : "prompts";
var setPromptLibrary = /* @__PURE__ */ __name((library) => {
  currentPromptLibrary = library;
}, "setPromptLibrary");
var getPromptLibrary = /* @__PURE__ */ __name(() => {
  return currentPromptLibrary;
}, "getPromptLibrary");
var getPromptProvider = /* @__PURE__ */ __name(() => {
  return PROVIDERS[currentPromptLibrary];
}, "getPromptProvider");
var isClackEnabled = /* @__PURE__ */ __name(() => {
  return currentPromptLibrary === "clack";
}, "isClackEnabled");
var isPromptsEnabled = /* @__PURE__ */ __name(() => {
  return currentPromptLibrary === "prompts";
}, "isPromptsEnabled");
var getPreferredStdio = /* @__PURE__ */ __name(() => {
  return isClackEnabled() ? "pipe" : "inherit";
}, "getPreferredStdio");

// src/node-logger/wrap-utils.ts
var import_picocolors3 = __toESM(require_picocolors(), 1);

// ../node_modules/wrap-ansi/node_modules/string-width/index.js
var import_eastasianwidth = __toESM(require_eastasianwidth(), 1);
var import_emoji_regex = __toESM(require_emoji_regex(), 1);
function stringWidth(string, options = {}) {
  if (typeof string !== "string" || string.length === 0) {
    return 0;
  }
  options = {
    ambiguousIsNarrow: true,
    ...options
  };
  string = stripAnsi(string);
  if (string.length === 0) {
    return 0;
  }
  string = string.replace((0, import_emoji_regex.default)(), "  ");
  const ambiguousCharacterWidth = options.ambiguousIsNarrow ? 1 : 2;
  let width = 0;
  for (const character of string) {
    const codePoint = character.codePointAt(0);
    if (codePoint <= 31 || codePoint >= 127 && codePoint <= 159) {
      continue;
    }
    if (codePoint >= 768 && codePoint <= 879) {
      continue;
    }
    const code = import_eastasianwidth.default.eastAsianWidth(character);
    switch (code) {
      case "F":
      case "W":
        width += 2;
        break;
      case "A":
        width += ambiguousCharacterWidth;
        break;
      default:
        width += 1;
    }
  }
  return width;
}
__name(stringWidth, "stringWidth");

// ../node_modules/wrap-ansi/index.js
var ESCAPES = /* @__PURE__ */ new Set([
  "\x1B",
  "\x9B"
]);
var END_CODE = 39;
var ANSI_ESCAPE_BELL = "\x07";
var ANSI_CSI = "[";
var ANSI_OSC = "]";
var ANSI_SGR_TERMINATOR = "m";
var ANSI_ESCAPE_LINK = `${ANSI_OSC}8;;`;
var wrapAnsiCode = /* @__PURE__ */ __name((code) => `${ESCAPES.values().next().value}${ANSI_CSI}${code}${ANSI_SGR_TERMINATOR}`, "wrapAnsiCode");
var wrapAnsiHyperlink = /* @__PURE__ */ __name((uri) => `${ESCAPES.values().next().value}${ANSI_ESCAPE_LINK}${uri}${ANSI_ESCAPE_BELL}`, "wrapAnsiHyperlink");
var wordLengths = /* @__PURE__ */ __name((string) => string.split(" ").map((character) => stringWidth(character)), "wordLengths");
var wrapWord = /* @__PURE__ */ __name((rows, word, columns) => {
  const characters = [...word];
  let isInsideEscape = false;
  let isInsideLinkEscape = false;
  let visible = stringWidth(stripAnsi(rows[rows.length - 1]));
  for (const [index, character] of characters.entries()) {
    const characterLength = stringWidth(character);
    if (visible + characterLength <= columns) {
      rows[rows.length - 1] += character;
    } else {
      rows.push(character);
      visible = 0;
    }
    if (ESCAPES.has(character)) {
      isInsideEscape = true;
      isInsideLinkEscape = characters.slice(index + 1).join("").startsWith(ANSI_ESCAPE_LINK);
    }
    if (isInsideEscape) {
      if (isInsideLinkEscape) {
        if (character === ANSI_ESCAPE_BELL) {
          isInsideEscape = false;
          isInsideLinkEscape = false;
        }
      } else if (character === ANSI_SGR_TERMINATOR) {
        isInsideEscape = false;
      }
      continue;
    }
    visible += characterLength;
    if (visible === columns && index < characters.length - 1) {
      rows.push("");
      visible = 0;
    }
  }
  if (!visible && rows[rows.length - 1].length > 0 && rows.length > 1) {
    rows[rows.length - 2] += rows.pop();
  }
}, "wrapWord");
var stringVisibleTrimSpacesRight = /* @__PURE__ */ __name((string) => {
  const words = string.split(" ");
  let last = words.length;
  while (last > 0) {
    if (stringWidth(words[last - 1]) > 0) {
      break;
    }
    last--;
  }
  if (last === words.length) {
    return string;
  }
  return words.slice(0, last).join(" ") + words.slice(last).join("");
}, "stringVisibleTrimSpacesRight");
var exec = /* @__PURE__ */ __name((string, columns, options = {}) => {
  if (options.trim !== false && string.trim() === "") {
    return "";
  }
  let returnValue = "";
  let escapeCode;
  let escapeUrl;
  const lengths = wordLengths(string);
  let rows = [""];
  for (const [index, word] of string.split(" ").entries()) {
    if (options.trim !== false) {
      rows[rows.length - 1] = rows[rows.length - 1].trimStart();
    }
    let rowLength = stringWidth(rows[rows.length - 1]);
    if (index !== 0) {
      if (rowLength >= columns && (options.wordWrap === false || options.trim === false)) {
        rows.push("");
        rowLength = 0;
      }
      if (rowLength > 0 || options.trim === false) {
        rows[rows.length - 1] += " ";
        rowLength++;
      }
    }
    if (options.hard && lengths[index] > columns) {
      const remainingColumns = columns - rowLength;
      const breaksStartingThisLine = 1 + Math.floor((lengths[index] - remainingColumns - 1) / columns);
      const breaksStartingNextLine = Math.floor((lengths[index] - 1) / columns);
      if (breaksStartingNextLine < breaksStartingThisLine) {
        rows.push("");
      }
      wrapWord(rows, word, columns);
      continue;
    }
    if (rowLength + lengths[index] > columns && rowLength > 0 && lengths[index] > 0) {
      if (options.wordWrap === false && rowLength < columns) {
        wrapWord(rows, word, columns);
        continue;
      }
      rows.push("");
    }
    if (rowLength + lengths[index] > columns && options.wordWrap === false) {
      wrapWord(rows, word, columns);
      continue;
    }
    rows[rows.length - 1] += word;
  }
  if (options.trim !== false) {
    rows = rows.map((row) => stringVisibleTrimSpacesRight(row));
  }
  const pre = [...rows.join("\n")];
  for (const [index, character] of pre.entries()) {
    returnValue += character;
    if (ESCAPES.has(character)) {
      const { groups } = new RegExp(`(?:\\${ANSI_CSI}(?<code>\\d+)m|\\${ANSI_ESCAPE_LINK}(?<uri>.*)${ANSI_ESCAPE_BELL})`).exec(pre.slice(index).join("")) || { groups: {} };
      if (groups.code !== void 0) {
        const code2 = Number.parseFloat(groups.code);
        escapeCode = code2 === END_CODE ? void 0 : code2;
      } else if (groups.uri !== void 0) {
        escapeUrl = groups.uri.length === 0 ? void 0 : groups.uri;
      }
    }
    const code = ansi_styles_default.codes.get(Number(escapeCode));
    if (pre[index + 1] === "\n") {
      if (escapeUrl) {
        returnValue += wrapAnsiHyperlink("");
      }
      if (escapeCode && code) {
        returnValue += wrapAnsiCode(code);
      }
    } else if (character === "\n") {
      if (escapeCode && code) {
        returnValue += wrapAnsiCode(escapeCode);
      }
      if (escapeUrl) {
        returnValue += wrapAnsiHyperlink(escapeUrl);
      }
    }
  }
  return returnValue;
}, "exec");
function wrapAnsi(string, columns, options) {
  return String(string).normalize().replace(/\r\n/g, "\n").split("\n").map((line) => exec(line, columns, options)).join("\n");
}
__name(wrapAnsi, "wrapAnsi");

// src/node-logger/wrap-utils.ts
function getTerminalWidth() {
  const defaultWidth = 80;
  try {
    return process.stdout.columns || defaultWidth;
  } catch {
    return defaultWidth;
  }
}
__name(getTerminalWidth, "getTerminalWidth");
var ANSI_REGEX = /\u001b\[[0-9;]*m|\u001b\]8;;[^\u0007]*\u0007|\u001b\]8;;\u0007/g;
var URL_REGEX = /(https?:\/\/[^\s\u0000-\u001F\u007F]+)/g;
function stripAnsi2(str) {
  return str.replace(ANSI_REGEX, "");
}
__name(stripAnsi2, "stripAnsi");
function getVisibleLength(str) {
  return stripAnsi2(str).length;
}
__name(getVisibleLength, "getVisibleLength");
function getEnvFromTerminal(key) {
  return execaSync("echo", [`$${key}`], { shell: true }).stdout.trim();
}
__name(getEnvFromTerminal, "getEnvFromTerminal");
function supportsHyperlinks() {
  try {
    const termProgram = getEnvFromTerminal("TERM_PROGRAM");
    const termProgramVersion = getEnvFromTerminal("TERM_PROGRAM_VERSION");
    switch (termProgram) {
      case "iTerm.app":
        if (termProgramVersion.trim()) {
          const version = termProgramVersion.trim().split(".").map(Number);
          return version[0] > 3 || version[0] === 3 && version[1] >= 1;
        }
        return true;
      // Assume recent version
      case "Apple_Terminal":
        return false;
      default:
        return true;
    }
  } catch (error2) {
    return false;
  }
}
__name(supportsHyperlinks, "supportsHyperlinks");
function protectUrls(text2, options) {
  const defaultMaxUrlLength = Math.floor(getTerminalWidth() * 0.8);
  const maxLineWidth = options?.maxLineWidth ?? getTerminalWidth();
  const useHyperlinks = supportsHyperlinks();
  return text2.replace(URL_REGEX, (match, capturedUrl, offset) => {
    if (!useHyperlinks) {
      return match;
    }
    let searchPos = 0;
    while (true) {
      const hyperlinkStart = text2.indexOf("\x1B]8;;", searchPos);
      if (hyperlinkStart === -1) {
        break;
      }
      const hyperlinkEnd = text2.indexOf("\x1B]8;;\x07", hyperlinkStart);
      if (hyperlinkEnd === -1) {
        searchPos = hyperlinkStart + 1;
        continue;
      }
      if (offset >= hyperlinkStart && offset < hyperlinkEnd + 7) {
        return match;
      }
      searchPos = hyperlinkEnd + 1;
    }
    const textBeforeUrl = text2.substring(0, offset);
    const lastNewlineIndex = textBeforeUrl.lastIndexOf("\n");
    const currentLinePrefix = lastNewlineIndex === -1 ? textBeforeUrl : textBeforeUrl.substring(lastNewlineIndex + 1);
    const prefixLength = getVisibleLength(currentLinePrefix);
    const availableSpace = maxLineWidth - prefixLength;
    const minUrlLength = 20;
    const configuredMax = options?.maxUrlLength ?? defaultMaxUrlLength;
    let effectiveMaxLength = Math.min(configuredMax, defaultMaxUrlLength, availableSpace);
    if (capturedUrl.length <= minUrlLength) {
      effectiveMaxLength = capturedUrl.length;
    } else if (effectiveMaxLength < minUrlLength) {
      effectiveMaxLength = capturedUrl.length;
    }
    if (capturedUrl.length > effectiveMaxLength) {
      const truncatedText = capturedUrl.substring(0, effectiveMaxLength - 3) + "...";
      return `\x1B]8;;${capturedUrl}\x07${truncatedText}\x1B]8;;\x07`;
    }
    return `\x1B]8;;${capturedUrl}\x07${capturedUrl}\x1B]8;;\x07`;
  });
}
__name(protectUrls, "protectUrls");
function createHyperlink(title, url) {
  if (supportsHyperlinks()) {
    return `\x1B]8;;${url}\x07${title}\x1B]8;;\x07`;
  }
  return `${title}: ${url}`;
}
__name(createHyperlink, "createHyperlink");
function splitTextPreservingUrls(text2) {
  const parts = [];
  let lastIndex = 0;
  let match;
  URL_REGEX.lastIndex = 0;
  while ((match = URL_REGEX.exec(text2)) !== null) {
    if (match.index > lastIndex) {
      const beforeUrl = text2.slice(lastIndex, match.index);
      parts.push(...beforeUrl.split(" ").filter((part) => part.length > 0));
    }
    parts.push(match[0]);
    lastIndex = match.index + match[0].length;
  }
  if (lastIndex < text2.length) {
    const remaining = text2.slice(lastIndex);
    parts.push(...remaining.split(" ").filter((part) => part.length > 0));
  }
  return parts;
}
__name(splitTextPreservingUrls, "splitTextPreservingUrls");
var MAX_OPTIMAL_WIDTH = 80;
function getOptimalWidth(width) {
  return Math.min(width, MAX_OPTIMAL_WIDTH);
}
__name(getOptimalWidth, "getOptimalWidth");
function wrapTextForClack(text2, width) {
  const terminalWidth = width || getTerminalWidth();
  const contentWidth = Math.max(terminalWidth - 10, 40);
  const maxOptimalWidth = getOptimalWidth(contentWidth);
  const protectedText = protectUrls(text2, { maxLineWidth: maxOptimalWidth });
  return wrapAnsi(protectedText, maxOptimalWidth);
}
__name(wrapTextForClack, "wrapTextForClack");
function wrapTextForClackHint(text2, width, label) {
  const terminalWidth = width || getTerminalWidth();
  const labelWidth = label ? getVisibleLength(label) : 0;
  const reservedSpaceFirstLine = 8 + labelWidth;
  const firstLineWidth = Math.min(
    MAX_OPTIMAL_WIDTH - reservedSpaceFirstLine,
    Math.max(terminalWidth - reservedSpaceFirstLine, 30)
  );
  const indentSpaces = 3 + 1;
  const continuationLineWidth = getOptimalWidth(Math.max(terminalWidth - indentSpaces, 30));
  const protectedText = protectUrls(text2, { maxLineWidth: continuationLineWidth });
  const initialWrap = wrapAnsi(protectedText, continuationLineWidth);
  const lines = initialWrap.split("\n");
  if (lines.length > 0 && getVisibleLength(lines[0]) > firstLineWidth) {
    const words = splitTextPreservingUrls(text2);
    let firstLinePart = "";
    let remainingPart = "";
    for (let i = 0; i < words.length; i++) {
      const testLine = i === 0 ? words[i] : firstLinePart + " " + words[i];
      if (getVisibleLength(testLine) <= firstLineWidth) {
        firstLinePart = testLine;
      } else {
        remainingPart = words.slice(i).join(" ");
        break;
      }
    }
    if (!firstLinePart && words.length > 0) {
      firstLinePart = words[0];
      remainingPart = words.slice(1).join(" ");
    }
    let finalLines = [firstLinePart];
    if (remainingPart.trim()) {
      const protectedRemainder = protectUrls(remainingPart.trim(), {
        maxLineWidth: continuationLineWidth
      });
      const wrappedRemainder = wrapAnsi(protectedRemainder, continuationLineWidth);
      finalLines = finalLines.concat(wrappedRemainder.split("\n"));
    }
    if (finalLines.length <= 1) {
      return finalLines[0] || "";
    }
    const indentation2 = (0, import_picocolors3.reset)((0, import_picocolors3.cyan)(d)) + " ".repeat(indentSpaces);
    return finalLines.map((line, index) => {
      if (index === 0) {
        return line;
      }
      return `${indentation2}${(0, import_picocolors3.dim)(line)}`;
    }).join("\n");
  }
  if (lines.length <= 1) {
    return initialWrap;
  }
  const indentation = (0, import_picocolors3.reset)((0, import_picocolors3.cyan)(d)) + " ".repeat(indentSpaces);
  return lines.map((line, index) => {
    if (index === 0) {
      return line;
    }
    return `${indentation}${(0, import_picocolors3.dim)(line)}`;
  }).join("\n");
}
__name(wrapTextForClackHint, "wrapTextForClackHint");

// src/node-logger/logger/colors.ts
var import_picocolors4 = __toESM(require_picocolors(), 1);
var CLI_COLORS = {
  success: import_picocolors4.default.green,
  error: import_picocolors4.default.red,
  warning: import_picocolors4.default.yellow,
  info: import_picocolors4.default.blue,
  debug: import_picocolors4.default.gray,
  // Only color a link if it is the primary call to action, otherwise links shouldn't be colored
  cta: import_picocolors4.default.cyan
};

// src/node-logger/logger/logger.ts
var createLogFunction = /* @__PURE__ */ __name((clackFn, consoleFn) => () => isClackEnabled() ? (message) => {
  if (currentTaskLog) {
    currentTaskLog.message(message);
  } else {
    clackFn(wrapTextForClack(message));
  }
} : consoleFn, "createLogFunction");
var LOG_FUNCTIONS = {
  log: createLogFunction(R.message, console.log),
  info: createLogFunction(R.info, console.log),
  warn: createLogFunction(R.warn, console.warn),
  error: createLogFunction(R.error, console.error),
  intro: createLogFunction(Mt2, console.log),
  outro: createLogFunction(Rt, console.log),
  step: createLogFunction(R.step, console.log)
};
var LOG_LEVELS = {
  trace: 1,
  debug: 2,
  info: 3,
  warn: 4,
  error: 5,
  silent: 10
};
var currentLogLevel = "info";
var setLogLevel = /* @__PURE__ */ __name((level) => {
  currentLogLevel = level;
}, "setLogLevel");
var getLogLevel = /* @__PURE__ */ __name(() => {
  return currentLogLevel;
}, "getLogLevel");
var shouldLog = /* @__PURE__ */ __name((level) => {
  return LOG_LEVELS[currentLogLevel] <= LOG_LEVELS[level];
}, "shouldLog");
function getMinimalTrace() {
  const stack = new Error().stack;
  if (!stack) {
    return;
  }
  const lines = stack.split("\n").slice(1);
  const userStackLines = lines.filter(
    (line) => !["getMinimalTrace", "createLogger", "logFunction"].some((fn) => line.includes(fn))
  );
  if (userStackLines.length === 0) {
    return;
  }
  const callStack = "\n" + userStackLines.slice(0, 2).join("\n");
  return callStack;
}
__name(getMinimalTrace, "getMinimalTrace");
var formatLogMessage = /* @__PURE__ */ __name((args) => {
  return args.map((arg) => {
    if (typeof arg === "string") {
      return arg;
    }
    if (typeof arg === "object") {
      return JSON.stringify(arg, null, 2);
    }
    return String(arg);
  }).join(" ");
}, "formatLogMessage");
function createLogger(level, logFn, prefix) {
  return /* @__PURE__ */ __name(function logFunction2(...args) {
    const message = formatLogMessage(args);
    logTracker.addLog(level, message);
    if (level === "prompt") {
      level = "info";
    }
    if (shouldLog(level)) {
      const formattedMessage = prefix ? `${prefix} ${message}` : message;
      logFn(formattedMessage);
    }
  }, "logFunction");
}
__name(createLogger, "createLogger");
var debug = createLogger(
  "debug",
  /* @__PURE__ */ __name(function logFunction(message) {
    if (shouldLog("trace")) {
      message += getMinimalTrace();
    }
    LOG_FUNCTIONS.log()(message);
  }, "logFunction"),
  "[DEBUG]"
);
var log = createLogger("info", (...args) => {
  return LOG_FUNCTIONS.log()(...args);
});
var info = createLogger("info", (...args) => {
  return LOG_FUNCTIONS.info()(...args);
});
var warn = createLogger("warn", (...args) => {
  return LOG_FUNCTIONS.warn()(...args);
});
var error = createLogger("error", (...args) => {
  return LOG_FUNCTIONS.error()(...args);
});
var logBox = /* @__PURE__ */ __name((message, options) => {
  if (shouldLog("info")) {
    logTracker.addLog("info", message);
    if (isClackEnabled()) {
      if (options?.title) {
        log(options.title);
      }
      log(message);
    } else {
      console.log(
        boxen(message, {
          borderStyle: "round",
          padding: 1,
          borderColor: "#F1618C",
          // pink
          ...options
        })
      );
    }
  }
}, "logBox");
var intro = /* @__PURE__ */ __name((message) => {
  logTracker.addLog("info", message);
  console.log("\n");
  LOG_FUNCTIONS.intro()(message);
}, "intro");
var outro = /* @__PURE__ */ __name((message) => {
  logTracker.addLog("info", message);
  LOG_FUNCTIONS.outro()(message);
  console.log("\n");
}, "outro");
var step = /* @__PURE__ */ __name((message) => {
  logTracker.addLog("info", message);
  LOG_FUNCTIONS.step()(message);
}, "step");
var SYMBOLS = {
  success: CLI_COLORS.success("\u2714"),
  error: CLI_COLORS.error("\u2715")
};

// src/node-logger/prompts/prompt-functions.ts
var prompt_functions_exports = {};
__export(prompt_functions_exports, {
  confirm: () => confirm,
  multiselect: () => multiselect,
  select: () => select,
  spinner: () => spinner,
  taskLog: () => taskLog,
  text: () => text
});
var activeSpinner = null;
var activeTaskLog = null;
var originalConsoleLog = null;
var patchConsoleLog = /* @__PURE__ */ __name(() => {
  if (!originalConsoleLog) {
    originalConsoleLog = console.log;
    console.log = (...args) => {
      const message = args.map((arg) => typeof arg === "string" ? arg : JSON.stringify(arg)).join(" ");
      if (activeTaskLog) {
        activeTaskLog.message(message);
      } else if (activeSpinner) {
        activeSpinner.message(message);
      } else {
        originalConsoleLog(...args);
      }
    };
  }
}, "patchConsoleLog");
var restoreConsoleLog = /* @__PURE__ */ __name(() => {
  if (originalConsoleLog && !activeSpinner && !activeTaskLog) {
    console.log = originalConsoleLog;
    originalConsoleLog = null;
  }
}, "restoreConsoleLog");
var text = /* @__PURE__ */ __name(async (options, promptOptions) => {
  return getPromptProvider().text(options, promptOptions);
}, "text");
var confirm = /* @__PURE__ */ __name(async (options, promptOptions) => {
  return getPromptProvider().confirm(options, promptOptions);
}, "confirm");
var select = /* @__PURE__ */ __name(async (options, promptOptions) => {
  return getPromptProvider().select(options, promptOptions);
}, "select");
var multiselect = /* @__PURE__ */ __name(async (options, promptOptions) => {
  return getPromptProvider().multiselect(
    {
      ...options,
      options: options.options.map((opt) => ({
        ...opt,
        hint: opt.hint ? wrapTextForClackHint(opt.hint, void 0, opt.label || String(opt.value)) : void 0
      }))
    },
    promptOptions
  );
}, "multiselect");
var spinner = /* @__PURE__ */ __name((options) => {
  const spinnerInstance = getPromptProvider().spinner(options);
  const wrappedSpinner = {
    start: /* @__PURE__ */ __name((message) => {
      activeSpinner = wrappedSpinner;
      patchConsoleLog();
      spinnerInstance.start(message);
    }, "start"),
    stop: /* @__PURE__ */ __name((message) => {
      activeSpinner = null;
      restoreConsoleLog();
      spinnerInstance.stop(message);
    }, "stop"),
    message: /* @__PURE__ */ __name((text2) => {
      spinnerInstance.message(text2);
    }, "message")
  };
  return wrappedSpinner;
}, "spinner");
var taskLog = /* @__PURE__ */ __name((options) => {
  const task = getPromptProvider().taskLog(options);
  const wrappedTaskLog = {
    message: /* @__PURE__ */ __name((message) => {
      task.message(wrapTextForClack(message));
    }, "message"),
    success: /* @__PURE__ */ __name((message, options2) => {
      activeTaskLog = null;
      restoreConsoleLog();
      task.success(message, options2);
    }, "success"),
    error: /* @__PURE__ */ __name((message) => {
      activeTaskLog = null;
      restoreConsoleLog();
      task.error(message);
    }, "error")
  };
  activeTaskLog = wrappedTaskLog;
  patchConsoleLog();
  return wrappedTaskLog;
}, "taskLog");

// src/node-logger/tasks.ts
var executeTask = /* @__PURE__ */ __name(async (childProcessFactories, {
  id,
  intro: intro2,
  error: error2,
  success,
  limitLines = 4
}) => {
  logTracker.addLog("info", intro2);
  const task = taskLog({
    id,
    title: intro2,
    retainLog: false,
    limit: limitLines
  });
  const factories = Array.isArray(childProcessFactories) ? childProcessFactories : [childProcessFactories];
  try {
    for (const factory of factories) {
      const childProcess = factory();
      childProcess.stdout?.on("data", (data) => {
        const message = data.toString().trim();
        logTracker.addLog("info", message);
        task.message(message);
      });
      await childProcess;
    }
    logTracker.addLog("info", success);
    task.success(success);
  } catch (err) {
    const errorMessage = err instanceof Error ? err.stack ?? err.message : String(err);
    logTracker.addLog("error", error2, { error: errorMessage });
    task.error(error2);
    throw err;
  }
}, "executeTask");
var executeTaskWithSpinner = /* @__PURE__ */ __name(async (childProcessFactories, { id, intro: intro2, error: error2, success }) => {
  logTracker.addLog("info", intro2);
  const task = spinner({ id });
  task.start(intro2);
  const factories = Array.isArray(childProcessFactories) ? childProcessFactories : [childProcessFactories];
  try {
    for (const factory of factories) {
      const childProcess = factory();
      childProcess.stdout?.on("data", (data) => {
        const message = data.toString().trim().slice(0, 25);
        logTracker.addLog("info", `${intro2}: ${data.toString()}`);
        task.message(`${intro2}: ${message}`);
      });
      await childProcess;
    }
    logTracker.addLog("info", success);
    task.stop(success);
  } catch (err) {
    logTracker.addLog("error", error2, { error: err });
    task.stop(error2);
    throw err;
  }
}, "executeTaskWithSpinner");

// src/node-logger/prompts/index.ts
var prompt = {
  ...prompt_functions_exports,
  ...prompt_config_exports,
  executeTask,
  executeTaskWithSpinner
};

// src/node-logger/index.ts
import_npmlog.default.stream = process.stdout;
function hex(hexColor) {
  if (!/^#?[0-9A-Fa-f]{6}$/.test(hexColor)) {
    throw new Error("Invalid hex color. It must be a 6-character hex code.");
  }
  if (hexColor.startsWith("#")) {
    hexColor = hexColor.slice(1);
  }
  const r = parseInt(hexColor.slice(0, 2), 16);
  const g = parseInt(hexColor.slice(2, 4), 16);
  const b2 = parseInt(hexColor.slice(4, 6), 16);
  return (text2) => `\x1B[38;2;${r};${g};${b2}m${text2}\x1B[39m`;
}
__name(hex, "hex");
var colors = {
  pink: hex("#F1618C"),
  purple: hex("#B57EE5"),
  orange: hex("#F3AD38"),
  green: hex("#A2E05E"),
  blue: hex("#6DABF5"),
  red: hex("#F16161"),
  gray: hex("#B8C2CC")
};
var logger = {
  ...logger_exports,
  verbose: /* @__PURE__ */ __name((message) => debug(message), "verbose"),
  info: /* @__PURE__ */ __name((message) => isClackEnabled() ? info(message) : import_npmlog.default.info("", message), "info"),
  plain: /* @__PURE__ */ __name((message) => log(message), "plain"),
  line: /* @__PURE__ */ __name((count = 1) => log(`${Array(count - 1).fill("\n")}`), "line"),
  warn: /* @__PURE__ */ __name((message) => warn(message), "warn"),
  trace: /* @__PURE__ */ __name(({ message, time }) => debug(`${message} (${colors.purple((0, import_pretty_hrtime.default)(time))})`), "trace"),
  setLevel: /* @__PURE__ */ __name((level = "info") => {
    import_npmlog.default.level = level;
    setLogLevel(level);
  }, "setLevel"),
  error: /* @__PURE__ */ __name((message) => {
    let msg;
    if (message instanceof Error && message.stack) {
      msg = message.stack.toString();
    } else {
      msg = message.toString();
    }
    error(
      msg.replace(message.toString(), colors.red(message.toString())).replaceAll(process.cwd(), ".")
    );
  }, "error")
};
var logged = /* @__PURE__ */ new Set();
var once = /* @__PURE__ */ __name((type) => (message) => {
  if (logged.has(message)) {
    return void 0;
  }
  logged.add(message);
  return logger[type](message);
}, "once");
once.clear = () => logged.clear();
once.verbose = once("verbose");
once.info = once("info");
once.warn = once("warn");
once.error = once("error");
var deprecate = once("warn");
var export_instance = import_npmlog.default;
export {
  CLI_COLORS,
  colors,
  createHyperlink,
  deprecate,
  export_instance as instance,
  logTracker,
  logger,
  once,
  prompt,
  protectUrls
};
