import {
  UniversalStore,
  parse,
  stringify
} from "../_browser-chunks/chunk-XDGMHOV7.js";
import {
  StatusTypeIdMismatchError
} from "../_browser-chunks/chunk-6A7OIVEL.js";
import {
  StatusTypeIdMismatchError as StatusTypeIdMismatchError2
} from "../_browser-chunks/chunk-FDWKXLBI.js";
import {
  StorybookError
} from "../_browser-chunks/chunk-LASUB7TL.js";
import {
  countBy,
  dequal,
  partition
} from "../_browser-chunks/chunk-VQJJDUCI.js";
import {
  require_picocolors_browser
} from "../_browser-chunks/chunk-VUAFL5XK.js";
import {
  isEqual
} from "../_browser-chunks/chunk-ZNRFDIVA.js";
import "../_browser-chunks/chunk-AB7OOPUX.js";
import {
  mapValues,
  mergeWith,
  pick,
  toMerged
} from "../_browser-chunks/chunk-KHNISLMN.js";
import "../_browser-chunks/chunk-FSBVR7H5.js";
import {
  require_memoizerific
} from "../_browser-chunks/chunk-NVV6MIOE.js";
import {
  dedent
} from "../_browser-chunks/chunk-OPCDBBL3.js";
import {
  __commonJS,
  __export,
  __name,
  __toESM
} from "../_browser-chunks/chunk-MM7DTO55.js";

// ../node_modules/toggle-selection/index.js
var require_toggle_selection = __commonJS({
  "../node_modules/toggle-selection/index.js"(exports, module) {
    module.exports = function() {
      var selection = document.getSelection();
      if (!selection.rangeCount) {
        return function() {
        };
      }
      var active = document.activeElement;
      var ranges = [];
      for (var i = 0; i < selection.rangeCount; i++) {
        ranges.push(selection.getRangeAt(i));
      }
      switch (active.tagName.toUpperCase()) {
        // .toUpperCase handles XHTML
        case "INPUT":
        case "TEXTAREA":
          active.blur();
          break;
        default:
          active = null;
          break;
      }
      selection.removeAllRanges();
      return function() {
        selection.type === "Caret" && selection.removeAllRanges();
        if (!selection.rangeCount) {
          ranges.forEach(function(range) {
            selection.addRange(range);
          });
        }
        active && active.focus();
      };
    };
  }
});

// ../node_modules/copy-to-clipboard/index.js
var require_copy_to_clipboard = __commonJS({
  "../node_modules/copy-to-clipboard/index.js"(exports, module) {
    "use strict";
    var deselectCurrent = require_toggle_selection();
    var clipboardToIE11Formatting = {
      "text/plain": "Text",
      "text/html": "Url",
      "default": "Text"
    };
    var defaultMessage = "Copy to clipboard: #{key}, Enter";
    function format(message) {
      var copyKey = (/mac os x/i.test(navigator.userAgent) ? "\u2318" : "Ctrl") + "+C";
      return message.replace(/#{\s*key\s*}/g, copyKey);
    }
    __name(format, "format");
    function copy2(text, options) {
      var debug, message, reselectPrevious, range, selection, mark, success = false;
      if (!options) {
        options = {};
      }
      debug = options.debug || false;
      try {
        reselectPrevious = deselectCurrent();
        range = document.createRange();
        selection = document.getSelection();
        mark = document.createElement("span");
        mark.textContent = text;
        mark.ariaHidden = "true";
        mark.style.all = "unset";
        mark.style.position = "fixed";
        mark.style.top = 0;
        mark.style.clip = "rect(0, 0, 0, 0)";
        mark.style.whiteSpace = "pre";
        mark.style.webkitUserSelect = "text";
        mark.style.MozUserSelect = "text";
        mark.style.msUserSelect = "text";
        mark.style.userSelect = "text";
        mark.addEventListener("copy", function(e) {
          e.stopPropagation();
          if (options.format) {
            e.preventDefault();
            if (typeof e.clipboardData === "undefined") {
              debug && console.warn("unable to use e.clipboardData");
              debug && console.warn("trying IE specific stuff");
              window.clipboardData.clearData();
              var format2 = clipboardToIE11Formatting[options.format] || clipboardToIE11Formatting["default"];
              window.clipboardData.setData(format2, text);
            } else {
              e.clipboardData.clearData();
              e.clipboardData.setData(options.format, text);
            }
          }
          if (options.onCopy) {
            e.preventDefault();
            options.onCopy(e.clipboardData);
          }
        });
        document.body.appendChild(mark);
        range.selectNodeContents(mark);
        selection.addRange(range);
        var successful = document.execCommand("copy");
        if (!successful) {
          throw new Error("copy command was unsuccessful");
        }
        success = true;
      } catch (err) {
        debug && console.error("unable to copy using execCommand: ", err);
        debug && console.warn("trying IE specific stuff");
        try {
          window.clipboardData.setData(options.format || "text", text);
          options.onCopy && options.onCopy(window.clipboardData);
          success = true;
        } catch (err2) {
          debug && console.error("unable to copy using clipboardData: ", err2);
          debug && console.error("falling back to prompt");
          message = format("message" in options ? options.message : defaultMessage);
          window.prompt(message, text);
        }
      } finally {
        if (selection) {
          if (typeof selection.removeRange == "function") {
            selection.removeRange(range);
          } else {
            selection.removeAllRanges();
          }
        }
        if (mark) {
          document.body.removeChild(mark);
        }
        reselectPrevious();
      }
      return success;
    }
    __name(copy2, "copy");
    module.exports = copy2;
  }
});

// ../node_modules/store2/dist/store2.js
var require_store2 = __commonJS({
  "../node_modules/store2/dist/store2.js"(exports, module) {
    (function(window2, define) {
      var _ = {
        version: "2.14.4",
        areas: {},
        apis: {},
        nsdelim: ".",
        // utilities
        inherit: /* @__PURE__ */ __name(function(api, o) {
          for (var p in api) {
            if (!o.hasOwnProperty(p)) {
              Object.defineProperty(o, p, Object.getOwnPropertyDescriptor(api, p));
            }
          }
          return o;
        }, "inherit"),
        stringify: /* @__PURE__ */ __name(function(d, fn) {
          return d === void 0 || typeof d === "function" ? d + "" : JSON.stringify(d, fn || _.replace);
        }, "stringify"),
        parse: /* @__PURE__ */ __name(function(s, fn) {
          try {
            return JSON.parse(s, fn || _.revive);
          } catch (e) {
            return s;
          }
        }, "parse"),
        // extension hooks
        fn: /* @__PURE__ */ __name(function(name, fn) {
          _.storeAPI[name] = fn;
          for (var api in _.apis) {
            _.apis[api][name] = fn;
          }
        }, "fn"),
        get: /* @__PURE__ */ __name(function(area, key) {
          return area.getItem(key);
        }, "get"),
        set: /* @__PURE__ */ __name(function(area, key, string) {
          area.setItem(key, string);
        }, "set"),
        remove: /* @__PURE__ */ __name(function(area, key) {
          area.removeItem(key);
        }, "remove"),
        key: /* @__PURE__ */ __name(function(area, i) {
          return area.key(i);
        }, "key"),
        length: /* @__PURE__ */ __name(function(area) {
          return area.length;
        }, "length"),
        clear: /* @__PURE__ */ __name(function(area) {
          area.clear();
        }, "clear"),
        // core functions
        Store: /* @__PURE__ */ __name(function(id, area, namespace) {
          var store3 = _.inherit(_.storeAPI, function(key, data, overwrite) {
            if (arguments.length === 0) {
              return store3.getAll();
            }
            if (typeof data === "function") {
              return store3.transact(key, data, overwrite);
            }
            if (data !== void 0) {
              return store3.set(key, data, overwrite);
            }
            if (typeof key === "string" || typeof key === "number") {
              return store3.get(key);
            }
            if (typeof key === "function") {
              return store3.each(key);
            }
            if (!key) {
              return store3.clear();
            }
            return store3.setAll(key, data);
          });
          store3._id = id;
          try {
            var testKey = "__store2_test";
            area.setItem(testKey, "ok");
            store3._area = area;
            area.removeItem(testKey);
          } catch (e) {
            store3._area = _.storage("fake");
          }
          store3._ns = namespace || "";
          if (!_.areas[id]) {
            _.areas[id] = store3._area;
          }
          if (!_.apis[store3._ns + store3._id]) {
            _.apis[store3._ns + store3._id] = store3;
          }
          return store3;
        }, "Store"),
        storeAPI: {
          // admin functions
          area: /* @__PURE__ */ __name(function(id, area) {
            var store3 = this[id];
            if (!store3 || !store3.area) {
              store3 = _.Store(id, area, this._ns);
              if (!this[id]) {
                this[id] = store3;
              }
            }
            return store3;
          }, "area"),
          namespace: /* @__PURE__ */ __name(function(namespace, singleArea, delim) {
            delim = delim || this._delim || _.nsdelim;
            if (!namespace) {
              return this._ns ? this._ns.substring(0, this._ns.length - delim.length) : "";
            }
            var ns = namespace, store3 = this[ns];
            if (!store3 || !store3.namespace) {
              store3 = _.Store(this._id, this._area, this._ns + ns + delim);
              store3._delim = delim;
              if (!this[ns]) {
                this[ns] = store3;
              }
              if (!singleArea) {
                for (var name in _.areas) {
                  store3.area(name, _.areas[name]);
                }
              }
            }
            return store3;
          }, "namespace"),
          isFake: /* @__PURE__ */ __name(function(force) {
            if (force) {
              this._real = this._area;
              this._area = _.storage("fake");
            } else if (force === false) {
              this._area = this._real || this._area;
            }
            return this._area.name === "fake";
          }, "isFake"),
          toString: /* @__PURE__ */ __name(function() {
            return "store" + (this._ns ? "." + this.namespace() : "") + "[" + this._id + "]";
          }, "toString"),
          // storage functions
          has: /* @__PURE__ */ __name(function(key) {
            if (this._area.has) {
              return this._area.has(this._in(key));
            }
            return !!(this._in(key) in this._area);
          }, "has"),
          size: /* @__PURE__ */ __name(function() {
            return this.keys().length;
          }, "size"),
          each: /* @__PURE__ */ __name(function(fn, fill) {
            for (var i = 0, m = _.length(this._area); i < m; i++) {
              var key = this._out(_.key(this._area, i));
              if (key !== void 0) {
                if (fn.call(this, key, this.get(key), fill) === false) {
                  break;
                }
              }
              if (m > _.length(this._area)) {
                m--;
                i--;
              }
            }
            return fill || this;
          }, "each"),
          keys: /* @__PURE__ */ __name(function(fillList) {
            return this.each(function(k, v, list) {
              list.push(k);
            }, fillList || []);
          }, "keys"),
          get: /* @__PURE__ */ __name(function(key, alt) {
            var s = _.get(this._area, this._in(key)), fn;
            if (typeof alt === "function") {
              fn = alt;
              alt = null;
            }
            return s !== null ? _.parse(s, fn) : alt != null ? alt : s;
          }, "get"),
          getAll: /* @__PURE__ */ __name(function(fillObj) {
            return this.each(function(k, v, all) {
              all[k] = v;
            }, fillObj || {});
          }, "getAll"),
          transact: /* @__PURE__ */ __name(function(key, fn, alt) {
            var val = this.get(key, alt), ret = fn(val);
            this.set(key, ret === void 0 ? val : ret);
            return this;
          }, "transact"),
          set: /* @__PURE__ */ __name(function(key, data, overwrite) {
            var d = this.get(key), replacer;
            if (d != null && overwrite === false) {
              return data;
            }
            if (typeof overwrite === "function") {
              replacer = overwrite;
              overwrite = void 0;
            }
            return _.set(this._area, this._in(key), _.stringify(data, replacer), overwrite) || d;
          }, "set"),
          setAll: /* @__PURE__ */ __name(function(data, overwrite) {
            var changed, val;
            for (var key in data) {
              val = data[key];
              if (this.set(key, val, overwrite) !== val) {
                changed = true;
              }
            }
            return changed;
          }, "setAll"),
          add: /* @__PURE__ */ __name(function(key, data, replacer) {
            var d = this.get(key);
            if (d instanceof Array) {
              data = d.concat(data);
            } else if (d !== null) {
              var type = typeof d;
              if (type === typeof data && type === "object") {
                for (var k in data) {
                  d[k] = data[k];
                }
                data = d;
              } else {
                data = d + data;
              }
            }
            _.set(this._area, this._in(key), _.stringify(data, replacer));
            return data;
          }, "add"),
          remove: /* @__PURE__ */ __name(function(key, alt) {
            var d = this.get(key, alt);
            _.remove(this._area, this._in(key));
            return d;
          }, "remove"),
          clear: /* @__PURE__ */ __name(function() {
            if (!this._ns) {
              _.clear(this._area);
            } else {
              this.each(function(k) {
                _.remove(this._area, this._in(k));
              }, 1);
            }
            return this;
          }, "clear"),
          clearAll: /* @__PURE__ */ __name(function() {
            var area = this._area;
            for (var id in _.areas) {
              if (_.areas.hasOwnProperty(id)) {
                this._area = _.areas[id];
                this.clear();
              }
            }
            this._area = area;
            return this;
          }, "clearAll"),
          // internal use functions
          _in: /* @__PURE__ */ __name(function(k) {
            if (typeof k !== "string") {
              k = _.stringify(k);
            }
            return this._ns ? this._ns + k : k;
          }, "_in"),
          _out: /* @__PURE__ */ __name(function(k) {
            return this._ns ? k && k.indexOf(this._ns) === 0 ? k.substring(this._ns.length) : void 0 : (
              // so each() knows to skip it
              k
            );
          }, "_out")
        },
        // end _.storeAPI
        storage: /* @__PURE__ */ __name(function(name) {
          return _.inherit(_.storageAPI, { items: {}, name });
        }, "storage"),
        storageAPI: {
          length: 0,
          has: /* @__PURE__ */ __name(function(k) {
            return this.items.hasOwnProperty(k);
          }, "has"),
          key: /* @__PURE__ */ __name(function(i) {
            var c = 0;
            for (var k in this.items) {
              if (this.has(k) && i === c++) {
                return k;
              }
            }
          }, "key"),
          setItem: /* @__PURE__ */ __name(function(k, v) {
            if (!this.has(k)) {
              this.length++;
            }
            this.items[k] = v;
          }, "setItem"),
          removeItem: /* @__PURE__ */ __name(function(k) {
            if (this.has(k)) {
              delete this.items[k];
              this.length--;
            }
          }, "removeItem"),
          getItem: /* @__PURE__ */ __name(function(k) {
            return this.has(k) ? this.items[k] : null;
          }, "getItem"),
          clear: /* @__PURE__ */ __name(function() {
            for (var k in this.items) {
              this.removeItem(k);
            }
          }, "clear")
        }
        // end _.storageAPI
      };
      var store2 = (
        // safely set this up (throws error in IE10/32bit mode for local files)
        _.Store("local", function() {
          try {
            return localStorage;
          } catch (e) {
          }
        }())
      );
      store2.local = store2;
      store2._ = _;
      store2.area("session", function() {
        try {
          return sessionStorage;
        } catch (e) {
        }
      }());
      store2.area("page", _.storage("page"));
      if (typeof define === "function" && define.amd !== void 0) {
        define("store2", [], function() {
          return store2;
        });
      } else if (typeof module !== "undefined" && module.exports) {
        module.exports = store2;
      } else {
        if (window2.store) {
          _.conflict = window2.store;
        }
        window2.store = store2;
      }
    })(exports, exports && exports.define);
  }
});

// src/manager-api/root.tsx
import React4, {
  Component,
  Fragment,
  useCallback as useCallback2,
  useContext,
  useEffect,
  useMemo,
  useRef as useRef2,
  useState
} from "react";
import {
  DOCS_PREPARED as DOCS_PREPARED2,
  SET_STORIES as SET_STORIES2,
  SHARED_STATE_CHANGED,
  SHARED_STATE_SET,
  STORY_CHANGED as STORY_CHANGED2,
  STORY_PREPARED as STORY_PREPARED2
} from "storybook/internal/core-events";

// src/manager-api/context.ts
import { createContext as ReactCreateContext } from "react";
var createContext = /* @__PURE__ */ __name(({ api, state }) => ReactCreateContext({ api, state }), "createContext");

// src/manager-api/lib/merge.ts
import { logger } from "storybook/internal/client-logger";
var merge_default = /* @__PURE__ */ __name((a, ...b) => {
  let target = {};
  target = mergeWith(
    {},
    a,
    (objValue, srcValue) => {
      if (Array.isArray(srcValue) && Array.isArray(objValue)) {
        srcValue.forEach((s) => {
          const existing = objValue.find((o) => o === s || isEqual(o, s));
          if (!existing) {
            objValue.push(s);
          }
        });
        return objValue;
      }
      if (Array.isArray(objValue)) {
        logger.log(["the types mismatch, picking", objValue]);
        return objValue;
      }
    }
  );
  for (const obj of b) {
    target = mergeWith(target, obj, (objValue, srcValue) => {
      if (Array.isArray(srcValue) && Array.isArray(objValue)) {
        srcValue.forEach((s) => {
          const existing = objValue.find((o) => o === s || isEqual(o, s));
          if (!existing) {
            objValue.push(s);
          }
        });
        return objValue;
      }
      if (Array.isArray(objValue)) {
        logger.log(["the types mismatch, picking", objValue]);
        return objValue;
      }
    });
  }
  return target;
}, "default");
var noArrayMerge = /* @__PURE__ */ __name((a, ...b) => {
  let target = {};
  target = mergeWith(
    {},
    a,
    (objValue, srcValue) => {
      if (Array.isArray(srcValue)) {
        return srcValue;
      }
    }
  );
  for (const obj of b) {
    target = mergeWith(target, obj, (objValue, srcValue) => {
      if (Array.isArray(srcValue)) {
        return srcValue;
      }
    });
  }
  return target;
}, "noArrayMerge");

// src/manager-api/initial-state.ts
var main = /* @__PURE__ */ __name((...additions) => additions.reduce((acc, item) => merge_default(acc, item), {}), "main");
var initial_state_default = main;

// src/manager-api/lib/addons.ts
import { logger as logger2 } from "storybook/internal/client-logger";
import { SET_CONFIG } from "storybook/internal/core-events";
import { Addon_TypesEnum } from "storybook/internal/types";
import { global } from "@storybook/global";

// src/manager-api/lib/storybook-channel-mock.ts
import { Channel } from "storybook/internal/channels";
function mockChannel() {
  const transport = {
    setHandler: /* @__PURE__ */ __name(() => {
    }, "setHandler"),
    send: /* @__PURE__ */ __name(() => {
    }, "send")
  };
  return new Channel({ transport });
}
__name(mockChannel, "mockChannel");

// src/manager-api/lib/addons.ts
var _AddonStore = class _AddonStore {
  constructor() {
    this.loaders = {};
    this.elements = {};
    this.config = {};
    this.getChannel = /* @__PURE__ */ __name(() => {
      if (!this.channel) {
        this.setChannel(mockChannel());
      }
      return this.channel;
    }, "getChannel");
    this.ready = /* @__PURE__ */ __name(() => this.promise, "ready");
    this.hasChannel = /* @__PURE__ */ __name(() => !!this.channel, "hasChannel");
    this.setChannel = /* @__PURE__ */ __name((channel) => {
      this.channel = channel;
      this.resolve();
    }, "setChannel");
    this.setConfig = /* @__PURE__ */ __name((value) => {
      Object.assign(this.config, value);
      if (this.hasChannel()) {
        this.getChannel().emit(SET_CONFIG, this.config);
      } else {
        this.ready().then((channel) => {
          channel.emit(SET_CONFIG, this.config);
        });
      }
    }, "setConfig");
    this.getConfig = /* @__PURE__ */ __name(() => this.config, "getConfig");
    /**
     * Registers an addon loader function.
     *
     * @param {string} id - The id of the addon loader.
     * @param {(api: API) => void} callback - The function that will be called to register the addon.
     * @returns {void}
     */
    this.register = /* @__PURE__ */ __name((id, callback) => {
      if (this.loaders[id]) {
        logger2.warn(`${id} was loaded twice, this could have bad side-effects`);
      }
      this.loaders[id] = callback;
    }, "register");
    this.loadAddons = /* @__PURE__ */ __name((api) => {
      Object.values(this.loaders).forEach((value) => value(api));
    }, "loadAddons");
    this.promise = new Promise((res) => {
      this.resolve = () => res(this.getChannel());
    });
  }
  getElements(type) {
    if (!this.elements[type]) {
      this.elements[type] = {};
    }
    return this.elements[type];
  }
  /**
   * Adds an addon to the addon store.
   *
   * @param {string} id - The id of the addon.
   * @param {Addon_Type} addon - The addon to add.
   * @returns {void}
   */
  add(id, addon) {
    const { type } = addon;
    const collection = this.getElements(type);
    collection[id] = { ...addon, id };
  }
  experimental_getRegisteredAddons() {
    return Object.keys(this.loaders);
  }
};
__name(_AddonStore, "AddonStore");
var AddonStore = _AddonStore;
var KEY = "__STORYBOOK_ADDONS_MANAGER";
function getAddonsStore() {
  if (!global[KEY]) {
    global[KEY] = new AddonStore();
  }
  return global[KEY];
}
__name(getAddonsStore, "getAddonsStore");
var addons = getAddonsStore();

// src/manager-api/modules/addons.ts
var addons_exports = {};
__export(addons_exports, {
  ensurePanel: () => ensurePanel,
  init: () => init
});
import { Addon_TypesEnum as Addon_TypesEnum2 } from "storybook/internal/types";
function ensurePanel(panels, selectedPanel, currentPanel) {
  const keys2 = Object.keys(panels);
  if (keys2.indexOf(selectedPanel) >= 0) {
    return selectedPanel;
  }
  if (keys2.length) {
    return keys2[0];
  }
  return currentPanel;
}
__name(ensurePanel, "ensurePanel");
var init = /* @__PURE__ */ __name(({ provider, store: store2, fullAPI }) => {
  const api = {
    getElements: /* @__PURE__ */ __name((type) => provider.getElements(type), "getElements"),
    getSelectedPanel: /* @__PURE__ */ __name(() => {
      const { selectedPanel } = store2.getState();
      return ensurePanel(api.getElements(Addon_TypesEnum2.PANEL), selectedPanel, selectedPanel);
    }, "getSelectedPanel"),
    setSelectedPanel: /* @__PURE__ */ __name((panelName) => {
      store2.setState({ selectedPanel: panelName }, { persistence: "session" });
    }, "setSelectedPanel"),
    setAddonState(addonId, newStateOrMerger, options) {
      const merger = typeof newStateOrMerger === "function" ? newStateOrMerger : () => newStateOrMerger;
      return store2.setState(
        (s) => ({ ...s, addons: { ...s.addons, [addonId]: merger(s.addons[addonId]) } }),
        options
      ).then(() => api.getAddonState(addonId));
    },
    getAddonState: /* @__PURE__ */ __name((addonId) => {
      return store2.getState().addons[addonId] || globalThis?.STORYBOOK_ADDON_STATE[addonId];
    }, "getAddonState")
  };
  return {
    api,
    state: {
      selectedPanel: ensurePanel(
        api.getElements(Addon_TypesEnum2.PANEL),
        store2.getState().selectedPanel
      ),
      addons: {}
    }
  };
}, "init");

// src/manager-api/modules/channel.ts
var channel_exports = {};
__export(channel_exports, {
  init: () => init2
});
var init2 = /* @__PURE__ */ __name(({ provider }) => {
  const api = {
    getChannel: /* @__PURE__ */ __name(() => provider.channel, "getChannel"),
    on: /* @__PURE__ */ __name((type, handler) => {
      provider.channel?.on(type, handler);
      return () => provider.channel?.off(type, handler);
    }, "on"),
    off: /* @__PURE__ */ __name((type, handler) => provider.channel?.off(type, handler), "off"),
    once: /* @__PURE__ */ __name((type, handler) => provider.channel?.once(type, handler), "once"),
    emit: /* @__PURE__ */ __name((type, data, ...args) => {
      if (data?.options?.target && data.options.target !== "storybook-preview-iframe" && !data.options.target.startsWith("storybook-ref-")) {
        data.options.target = data.options.target !== "storybook_internal" ? `storybook-ref-${data.options.target}` : "storybook-preview-iframe";
      }
      provider.channel?.emit(type, data, ...args);
    }, "emit")
  };
  return { api, state: {} };
}, "init");

// src/manager-api/modules/globals.ts
var globals_exports = {};
__export(globals_exports, {
  init: () => init4
});
import { logger as logger4 } from "storybook/internal/client-logger";
import { GLOBALS_UPDATED, SET_GLOBALS, UPDATE_GLOBALS } from "storybook/internal/core-events";

// src/manager-api/lib/events.ts
import { logger as logger3 } from "storybook/internal/client-logger";

// src/manager-api/modules/refs.ts
var refs_exports = {};
__export(refs_exports, {
  defaultStoryMapper: () => defaultStoryMapper,
  getSourceType: () => getSourceType,
  init: () => init3
});
import { global as global2 } from "@storybook/global";

// src/manager-api/lib/stories.ts
import { sanitize } from "storybook/internal/csf";
var import_memoizerific = __toESM(require_memoizerific(), 1);

// src/manager-api/lib/intersect.ts
var intersect_default = /* @__PURE__ */ __name((a, b) => {
  if (!Array.isArray(a) || !Array.isArray(b) || !a.length || !b.length) {
    return [];
  }
  return a.reduce((acc, aValue) => {
    if (b.includes(aValue)) {
      acc.push(aValue);
    }
    return acc;
  }, []);
}, "default");

// src/manager-api/lib/stories.ts
var TITLE_PATH_SEPARATOR = /\s*\/\s*/;
var denormalizeStoryParameters = /* @__PURE__ */ __name(({
  globalParameters,
  kindParameters,
  stories
}) => {
  return mapValues(stories, (storyData) => ({
    ...storyData,
    parameters: combineParameters(
      globalParameters,
      kindParameters[storyData.kind],
      storyData.parameters
    )
  }));
}, "denormalizeStoryParameters");
var transformSetStoriesStoryDataToPreparedStoryIndex = /* @__PURE__ */ __name((stories) => {
  const entries = Object.entries(stories).reduce(
    (acc, [id, story]) => {
      if (!story) {
        return acc;
      }
      const { docsOnly, fileName, ...parameters } = story.parameters;
      const base = {
        title: story.kind,
        id,
        name: story.name,
        importPath: fileName
      };
      if (docsOnly) {
        acc[id] = {
          type: "docs",
          tags: ["stories-mdx"],
          storiesImports: [],
          ...base
        };
      } else {
        const { argTypes, args, initialArgs } = story;
        acc[id] = {
          type: "story",
          subtype: "story",
          ...base,
          parameters,
          argTypes,
          args,
          initialArgs
        };
      }
      return acc;
    },
    {}
  );
  return { v: 5, entries };
}, "transformSetStoriesStoryDataToPreparedStoryIndex");
var transformStoryIndexV2toV3 = /* @__PURE__ */ __name((index) => {
  return {
    v: 3,
    stories: Object.values(index.stories).reduce(
      (acc, entry) => {
        acc[entry.id] = {
          ...entry,
          title: entry.kind,
          name: entry.name || entry.story,
          importPath: entry.parameters.fileName || ""
        };
        return acc;
      },
      {}
    )
  };
}, "transformStoryIndexV2toV3");
var transformStoryIndexV3toV4 = /* @__PURE__ */ __name((index) => {
  const countByTitle = countBy(Object.values(index.stories), (item) => item.title);
  return {
    v: 4,
    entries: Object.values(index.stories).reduce(
      (acc, entry) => {
        let type = "story";
        if (entry.parameters?.docsOnly || entry.name === "Page" && countByTitle[entry.title] === 1) {
          type = "docs";
        }
        acc[entry.id] = {
          type,
          ...type === "docs" && { tags: ["stories-mdx"], storiesImports: [] },
          ...entry
        };
        delete acc[entry.id].story;
        delete acc[entry.id].kind;
        return acc;
      },
      {}
    )
  };
}, "transformStoryIndexV3toV4");
var transformStoryIndexV4toV5 = /* @__PURE__ */ __name((index) => {
  return {
    v: 5,
    entries: Object.values(index.entries).reduce(
      (acc, entry) => {
        acc[entry.id] = {
          ...entry,
          tags: entry.tags ? ["dev", "test", ...entry.tags] : ["dev"]
        };
        return acc;
      },
      {}
    )
  };
}, "transformStoryIndexV4toV5");
var transformStoryIndexToStoriesHash = /* @__PURE__ */ __name((input, { provider, docsOptions, filters, allStatuses }) => {
  if (!input.v) {
    throw new Error("Composition: Missing stories.json version");
  }
  let index = input;
  index = index.v === 2 ? transformStoryIndexV2toV3(index) : index;
  index = index.v === 3 ? transformStoryIndexV3toV4(index) : index;
  index = index.v === 4 ? transformStoryIndexV4toV5(index) : index;
  index = index;
  const indexEntries = Object.values(index.entries);
  const filterFunctions = Object.values(filters);
  const entryValues = indexEntries.filter((entry) => {
    const statuses = allStatuses[entry.id] ?? {};
    if (Object.values(statuses).some(({ value }) => value === "status-value:error")) {
      return true;
    }
    if (filterFunctions.every((fn) => fn({ ...entry, statuses }))) {
      return true;
    }
    const children = indexEntries.filter((item) => "parent" in item && item.parent === entry.id);
    return children.some((child) => filterFunctions.every((fn) => fn({ ...child, statuses })));
  });
  const { sidebar = {} } = provider.getConfig();
  const { showRoots, collapsedRoots = [], renderLabel } = sidebar;
  const setShowRoots = typeof showRoots !== "undefined";
  const storiesHashOutOfOrder = entryValues.reduce((acc, item) => {
    if (docsOptions.docsMode && item.type !== "docs") {
      return acc;
    }
    const { title } = item;
    const groups = title.trim().split(TITLE_PATH_SEPARATOR);
    const root = (!setShowRoots || showRoots) && groups.length > 1 ? [groups.shift()] : [];
    const names = [...root, ...groups];
    const paths = names.reduce((list, name, idx) => {
      const parent = idx > 0 && list[idx - 1];
      const id = sanitize(parent ? `${parent}-${name}` : name);
      if (name.trim() === "") {
        throw new Error(dedent`Invalid title ${title} ending in slash.`);
      }
      if (parent === id) {
        throw new Error(
          dedent`
          Invalid part '${name}', leading to id === parentId ('${id}'), inside title '${title}'

          Did you create a path that uses the separator char accidentally, such as 'Vue <docs/>' where '/' is a separator char? See https://github.com/storybookjs/storybook/issues/6128
          `
        );
      }
      list.push(id);
      return list;
    }, []);
    paths.forEach((id, idx) => {
      const childId = paths[idx + 1] || item.id;
      if (root.length && idx === 0) {
        acc[id] = merge_default(acc[id] || {}, {
          type: "root",
          id,
          name: names[idx],
          tags: [],
          depth: idx,
          renderLabel,
          startCollapsed: collapsedRoots.includes(id),
          // Note that this will later get appended to the previous list of children (see below)
          children: [childId]
        });
      } else if ((!acc[id] || acc[id].type === "component") && idx === paths.length - 1) {
        acc[id] = merge_default(acc[id] || {}, {
          type: "component",
          id,
          name: names[idx],
          tags: [],
          parent: paths[idx - 1],
          depth: idx,
          renderLabel,
          ...childId && {
            children: [childId]
          }
        });
      } else {
        acc[id] = merge_default(acc[id] || {}, {
          type: "group",
          id,
          name: names[idx],
          tags: [],
          parent: paths[idx - 1],
          depth: idx,
          renderLabel,
          ...childId && {
            children: [childId]
          }
        });
      }
    });
    acc[item.id] = {
      tags: [],
      ...item,
      depth: paths.length,
      parent: "parent" in item ? item.parent : paths[paths.length - 1],
      renderLabel,
      prepared: !!item.parameters
    };
    return acc;
  }, {});
  function addItem(acc, item) {
    if (!acc[item.id]) {
      acc[item.id] = item;
      if ("children" in item && item.children) {
        item.children.forEach((childId) => addItem(acc, storiesHashOutOfOrder[childId]));
        item.tags = item.children.reduce((currentTags, childId) => {
          return currentTags === null ? acc[childId].tags : intersect_default(currentTags, acc[childId].tags);
        }, null) || [];
      }
    }
    if (item.type === "component") {
      const firstChild = acc[item.children[0]];
      if (firstChild && "importPath" in firstChild) {
        item.importPath = firstChild.importPath;
      }
    }
    return acc;
  }
  __name(addItem, "addItem");
  let storiesHash = Object.values(storiesHashOutOfOrder).filter((i) => i.type !== "root" && !i.parent).reduce((acc, item) => addItem(acc, item), {});
  storiesHash = Object.values(storiesHashOutOfOrder).filter((i) => i.type === "root").reduce(addItem, storiesHash);
  storiesHash = Object.values(storiesHash).reduce((acc, item) => {
    if (item.type === "story" && item.subtype === "test") {
      const story = acc[item.parent];
      const component = acc[story.parent];
      acc[component.id] = {
        ...component,
        // Remove test from the component node as it will be attached to the story node instead
        children: component.children && component.children.filter((id) => id !== item.id)
      };
      acc[story.id] = {
        ...story,
        // Add test to the story node
        children: (story.children || []).concat(item.id)
      };
      acc[item.id] = {
        ...item,
        depth: item.depth + 1
      };
    } else {
      acc[item.id] = item;
    }
    return acc;
  }, {});
  return storiesHash;
}, "transformStoryIndexToStoriesHash");
var addPreparedStories = /* @__PURE__ */ __name((newHash, oldHash) => {
  if (!oldHash) {
    return newHash;
  }
  return Object.fromEntries(
    Object.entries(newHash).map(([id, newEntry]) => {
      const oldEntry = oldHash[id];
      if (newEntry.type === "story" && oldEntry?.type === "story" && oldEntry.prepared) {
        if ("children" in oldEntry) {
          delete oldEntry.children;
        }
        return [id, { ...oldEntry, ...newEntry, prepared: true }];
      }
      return [id, newEntry];
    })
  );
}, "addPreparedStories");
var getComponentLookupList = (0, import_memoizerific.default)(1)((hash) => {
  return Object.entries(hash).reduce((acc, i) => {
    const value = i[1];
    if (value.type === "component") {
      acc.push([...value.children]);
    }
    return acc;
  }, []);
});
var getStoriesLookupList = (0, import_memoizerific.default)(1)((hash) => {
  return Object.keys(hash).filter((k) => ["story", "docs"].includes(hash[k].type));
});

// src/manager-api/modules/refs.ts
var { location, fetch } = global2;
var getSourceType = /* @__PURE__ */ __name((source, refId) => {
  const { origin: localOrigin, pathname: localPathname } = location;
  const { origin: sourceOrigin, pathname: sourcePathname } = new URL(source);
  const localFull = `${localOrigin + localPathname}`.replace("/iframe.html", "").replace(/\/$/, "");
  const sourceFull = `${sourceOrigin + sourcePathname}`.replace("/iframe.html", "").replace(/\/$/, "");
  if (localFull === sourceFull) {
    return ["local", sourceFull];
  }
  if (refId || source) {
    return ["external", sourceFull];
  }
  return [null, null];
}, "getSourceType");
var defaultStoryMapper = /* @__PURE__ */ __name((b, a) => {
  return { ...a, kind: a.kind.replace("|", "/") };
}, "defaultStoryMapper");
var addRefIds = /* @__PURE__ */ __name((input, ref) => {
  return Object.entries(input).reduce((acc, [id, item]) => {
    return { ...acc, [id]: { ...item, refId: ref.id } };
  }, {});
}, "addRefIds");
async function handleRequest(request) {
  if (!request) {
    return {};
  }
  try {
    const response = await request;
    if (response === false || response === true) {
      throw new Error("Unexpected boolean response");
    }
    if (!response.ok) {
      throw new Error(`Unexpected response not OK: ${response.statusText}`);
    }
    const json = await response.json();
    if (json.entries || json.stories) {
      return { storyIndex: json };
    }
    return json;
  } catch (err) {
    return { indexError: err };
  }
}
__name(handleRequest, "handleRequest");
var parseUrl = /* @__PURE__ */ __name((url) => {
  const credentialsRegex = /https?:\/\/(.+:.+)@/;
  let cleanUrl = url;
  let authorization;
  const [, credentials] = url.match(credentialsRegex) || [];
  if (credentials) {
    cleanUrl = url.replace(`${credentials}@`, "");
    authorization = btoa(`${credentials}`);
  }
  return {
    url: cleanUrl,
    authorization
  };
}, "parseUrl");
var map = /* @__PURE__ */ __name((input, ref, options) => {
  const { storyMapper } = options;
  if (storyMapper) {
    return Object.entries(input).reduce((acc, [id, item]) => {
      return { ...acc, [id]: storyMapper(ref, item) };
    }, {});
  }
  return input;
}, "map");
var init3 = /* @__PURE__ */ __name(({ store: store2, provider, singleStory, docsOptions = {} }, { runCheck = true } = {}) => {
  const api = {
    findRef: /* @__PURE__ */ __name((source) => {
      const refs2 = api.getRefs();
      return Object.values(refs2).find(({ url }) => url.match(source));
    }, "findRef"),
    changeRefVersion: /* @__PURE__ */ __name(async (id, url) => {
      const { versions, title } = api.getRefs()[id];
      const ref = {
        id,
        url,
        versions,
        title,
        index: {},
        filteredIndex: {},
        expanded: true
      };
      await api.setRef(id, { ...ref, type: "unknown" }, false);
      await api.checkRef(ref);
    }, "changeRefVersion"),
    changeRefState: /* @__PURE__ */ __name((id, previewInitialized) => {
      const { [id]: ref, ...updated } = api.getRefs();
      updated[id] = { ...ref, previewInitialized };
      store2.setState({
        refs: updated
      });
    }, "changeRefState"),
    checkRef: /* @__PURE__ */ __name(async (ref) => {
      const { id, url, version: version2, type } = ref;
      const isPublic = type === "server-checked";
      const loadedData = {};
      const query = version2 ? `?version=${version2}` : "";
      const credentials = isPublic ? "omit" : "include";
      const urlParseResult = parseUrl(url);
      const headers = {
        Accept: "application/json"
      };
      if (urlParseResult.authorization) {
        Object.assign(headers, {
          Authorization: `Basic ${urlParseResult.authorization}`
        });
      }
      const [indexResult, storiesResult] = await Promise.all(
        ["index.json", "stories.json"].map(
          async (file) => handleRequest(
            fetch(`${urlParseResult.url}/${file}${query}`, {
              headers,
              credentials
            })
          )
        )
      );
      if (!indexResult.indexError || !storiesResult.indexError) {
        const metadata = await handleRequest(
          fetch(`${urlParseResult.url}/metadata.json${query}`, {
            headers,
            credentials,
            cache: "no-cache"
          }).catch(() => false)
        );
        Object.assign(loadedData, {
          ...indexResult.indexError ? storiesResult : indexResult,
          ...!metadata.indexError && metadata
        });
      } else if (!isPublic) {
        loadedData.indexError = {
          message: dedent`
            Error: Loading of ref failed
              at fetch (lib/api/src/modules/refs.ts)

            URL: ${urlParseResult.url}

            We weren't able to load the above URL,
            it's possible a CORS error happened.

            Please check your dev-tools network tab.
          `
        };
      }
      const versions = ref.versions && Object.keys(ref.versions).length ? ref.versions : loadedData.versions;
      await api.setRef(id, {
        id,
        url: urlParseResult.url,
        ...loadedData,
        ...versions ? { versions } : {},
        type: !loadedData.storyIndex ? "auto-inject" : "lazy"
      });
    }, "checkRef"),
    getRefs: /* @__PURE__ */ __name(() => {
      const { refs: refs2 = {} } = store2.getState();
      return refs2;
    }, "getRefs"),
    setRef: /* @__PURE__ */ __name(async (id, { storyIndex, setStoriesData, ...rest }, ready = false) => {
      if (singleStory) {
        return;
      }
      let internal_index;
      let index;
      let filteredIndex;
      const { filters } = store2.getState();
      const { storyMapper = defaultStoryMapper } = provider.getConfig();
      const ref = api.getRefs()[id];
      if (storyIndex || setStoriesData) {
        internal_index = setStoriesData ? transformSetStoriesStoryDataToPreparedStoryIndex(
          map(setStoriesData, ref, { storyMapper })
        ) : storyIndex;
        filteredIndex = transformStoryIndexToStoriesHash(storyIndex, {
          provider,
          docsOptions,
          filters,
          allStatuses: {}
        });
        index = transformStoryIndexToStoriesHash(storyIndex, {
          provider,
          docsOptions,
          filters: {},
          allStatuses: {}
        });
      }
      if (index) {
        index = addRefIds(index, ref);
      }
      if (filteredIndex) {
        filteredIndex = addRefIds(filteredIndex, ref);
      }
      await api.updateRef(id, { ...ref, ...rest, index, filteredIndex, internal_index });
    }, "setRef"),
    updateRef: /* @__PURE__ */ __name(async (id, data) => {
      const { [id]: ref, ...updated } = api.getRefs();
      updated[id] = { ...ref, ...data };
      const ordered = Object.keys(initialState).reduce((obj, key) => {
        obj[key] = updated[key];
        return obj;
      }, {});
      await store2.setState({
        refs: ordered
      });
    }, "updateRef")
  };
  const refs = !singleStory && global2.REFS || {};
  const initialState = refs;
  if (runCheck) {
    new Promise(async (resolve) => {
      for (const ref of Object.values(refs)) {
        await api.checkRef({ ...ref, stories: {} });
      }
      resolve(void 0);
    });
  }
  return {
    api,
    state: {
      refs: initialState
    }
  };
}, "init");

// src/manager-api/lib/events.ts
var getEventMetadata = /* @__PURE__ */ __name((context, fullAPI) => {
  const { source, refId, type } = context;
  const [sourceType, sourceLocation] = getSourceType(source, refId);
  let ref;
  if (refId || sourceType === "external") {
    ref = refId && fullAPI.getRefs()[refId] ? fullAPI.getRefs()[refId] : fullAPI.findRef(sourceLocation);
  }
  const meta = {
    source,
    sourceType,
    sourceLocation,
    refId,
    ref,
    type
  };
  switch (true) {
    case typeof refId === "string":
    case sourceType === "local":
    case sourceType === "external": {
      return meta;
    }
    // if we couldn't find the source, something risky happened, we ignore the input, and log a warning
    default: {
      logger3.warn(`Received a ${type} frame that was not configured as a ref`);
      return null;
    }
  }
}, "getEventMetadata");

// src/manager-api/modules/globals.ts
var init4 = /* @__PURE__ */ __name(({ store: store2, fullAPI, provider }) => {
  const api = {
    getGlobals() {
      return store2.getState().globals;
    },
    getUserGlobals() {
      return store2.getState().userGlobals;
    },
    getStoryGlobals() {
      return store2.getState().storyGlobals;
    },
    getGlobalTypes() {
      return store2.getState().globalTypes;
    },
    updateGlobals(newGlobals) {
      provider.channel?.emit(UPDATE_GLOBALS, {
        globals: newGlobals,
        options: {
          target: "storybook-preview-iframe"
        }
      });
    }
  };
  const state = {
    globals: {},
    userGlobals: {},
    storyGlobals: {},
    globalTypes: {}
  };
  const updateGlobals = /* @__PURE__ */ __name(({
    globals,
    storyGlobals,
    userGlobals
  }) => {
    const {
      globals: currentGlobals,
      userGlobals: currentUserGlobals,
      storyGlobals: currentStoryGlobals
    } = store2.getState();
    if (!dequal(globals, currentGlobals)) {
      store2.setState({ globals });
    }
    if (!dequal(userGlobals, currentUserGlobals)) {
      store2.setState({ userGlobals });
    }
    if (!dequal(storyGlobals, currentStoryGlobals)) {
      store2.setState({ storyGlobals });
    }
  }, "updateGlobals");
  provider.channel?.on(
    GLOBALS_UPDATED,
    /* @__PURE__ */ __name(function handleGlobalsUpdated({ globals, storyGlobals, userGlobals }) {
      const { ref } = getEventMetadata(this, fullAPI);
      if (!ref) {
        updateGlobals({ globals, storyGlobals, userGlobals });
      } else {
        logger4.warn(
          "received a GLOBALS_UPDATED from a non-local ref. This is not currently supported."
        );
      }
    }, "handleGlobalsUpdated")
  );
  provider.channel?.on(
    SET_GLOBALS,
    /* @__PURE__ */ __name(function handleSetGlobals({ globals, globalTypes }) {
      const { ref } = getEventMetadata(this, fullAPI);
      const currentGlobals = store2.getState()?.globals;
      if (!ref) {
        store2.setState({ globals, userGlobals: globals, globalTypes });
      } else if (Object.keys(globals).length > 0) {
        logger4.warn("received globals from a non-local ref. This is not currently supported.");
      }
      if (currentGlobals && Object.keys(currentGlobals).length !== 0 && !dequal(globals, currentGlobals)) {
        api.updateGlobals(currentGlobals);
      }
    }, "handleSetGlobals")
  );
  return {
    api,
    state
  };
}, "init");

// src/manager-api/modules/layout.ts
var layout_exports = {};
__export(layout_exports, {
  ActiveTabs: () => ActiveTabs,
  defaultLayoutState: () => defaultLayoutState,
  focusableUIElements: () => focusableUIElements,
  init: () => init5
});
import { SET_CONFIG as SET_CONFIG2 } from "storybook/internal/core-events";
import { global as global3 } from "@storybook/global";
import { create } from "storybook/theming/create";
var { document: document2 } = global3;
var isFunction = /* @__PURE__ */ __name((val) => typeof val === "function", "isFunction");
var ActiveTabs = {
  SIDEBAR: "sidebar",
  CANVAS: "canvas",
  ADDONS: "addons"
};
var defaultLayoutState = {
  ui: {
    enableShortcuts: true
  },
  layout: {
    initialActive: ActiveTabs.CANVAS,
    showToolbar: true,
    navSize: 300,
    bottomPanelHeight: 300,
    rightPanelWidth: 400,
    recentVisibleSizes: {
      navSize: 300,
      bottomPanelHeight: 300,
      rightPanelWidth: 400
    },
    panelPosition: "bottom",
    showTabs: true
  },
  layoutCustomisations: {
    showSidebar: void 0,
    showToolbar: void 0
  },
  selectedPanel: void 0,
  theme: create()
};
var focusableUIElements = {
  storySearchField: "storybook-explorer-searchfield",
  storyListMenu: "storybook-explorer-menu",
  storyPanelRoot: "storybook-panel-root"
};
var getIsNavShown = /* @__PURE__ */ __name((state) => {
  return state.layout.navSize > 0;
}, "getIsNavShown");
var getIsPanelShown = /* @__PURE__ */ __name((state) => {
  const { bottomPanelHeight, rightPanelWidth, panelPosition } = state.layout;
  return panelPosition === "bottom" && bottomPanelHeight > 0 || panelPosition === "right" && rightPanelWidth > 0;
}, "getIsPanelShown");
var getIsFullscreen = /* @__PURE__ */ __name((state) => {
  return !getIsNavShown(state) && !getIsPanelShown(state);
}, "getIsFullscreen");
var getRecentVisibleSizes = /* @__PURE__ */ __name((layoutState) => {
  return {
    navSize: layoutState.navSize > 0 ? layoutState.navSize : layoutState.recentVisibleSizes.navSize,
    bottomPanelHeight: layoutState.bottomPanelHeight > 0 ? layoutState.bottomPanelHeight : layoutState.recentVisibleSizes.bottomPanelHeight,
    rightPanelWidth: layoutState.rightPanelWidth > 0 ? layoutState.rightPanelWidth : layoutState.recentVisibleSizes.rightPanelWidth
  };
}, "getRecentVisibleSizes");
var init5 = /* @__PURE__ */ __name(({ store: store2, provider, singleStory }) => {
  const api = {
    toggleFullscreen(nextState) {
      return store2.setState(
        (state) => {
          const isFullscreen = getIsFullscreen(state);
          const shouldFullscreen = typeof nextState === "boolean" ? nextState : !isFullscreen;
          if (shouldFullscreen === isFullscreen) {
            return { layout: state.layout };
          }
          return shouldFullscreen ? {
            layout: {
              ...state.layout,
              navSize: 0,
              bottomPanelHeight: 0,
              rightPanelWidth: 0,
              recentVisibleSizes: getRecentVisibleSizes(state.layout)
            }
          } : {
            layout: {
              ...state.layout,
              navSize: state.singleStory ? 0 : state.layout.recentVisibleSizes.navSize,
              bottomPanelHeight: state.layout.recentVisibleSizes.bottomPanelHeight,
              rightPanelWidth: state.layout.recentVisibleSizes.rightPanelWidth
            }
          };
        },
        { persistence: "session" }
      );
    },
    togglePanel(nextState) {
      return store2.setState(
        (state) => {
          const isPanelShown = getIsPanelShown(state);
          const shouldShowPanel = typeof nextState === "boolean" ? nextState : !isPanelShown;
          if (shouldShowPanel === isPanelShown) {
            return { layout: state.layout };
          }
          return shouldShowPanel ? {
            layout: {
              ...state.layout,
              bottomPanelHeight: state.layout.recentVisibleSizes.bottomPanelHeight,
              rightPanelWidth: state.layout.recentVisibleSizes.rightPanelWidth
            }
          } : {
            layout: {
              ...state.layout,
              bottomPanelHeight: 0,
              rightPanelWidth: 0,
              recentVisibleSizes: getRecentVisibleSizes(state.layout)
            }
          };
        },
        { persistence: "session" }
      );
    },
    togglePanelPosition(position) {
      return store2.setState(
        (state) => {
          const nextPosition = position || (state.layout.panelPosition === "right" ? "bottom" : "right");
          return {
            layout: {
              ...state.layout,
              panelPosition: nextPosition,
              bottomPanelHeight: state.layout.recentVisibleSizes.bottomPanelHeight,
              rightPanelWidth: state.layout.recentVisibleSizes.rightPanelWidth
            }
          };
        },
        { persistence: "permanent" }
      );
    },
    toggleNav(nextState) {
      return store2.setState(
        (state) => {
          if (state.singleStory) {
            return { layout: state.layout };
          }
          const isNavShown = getIsNavShown(state);
          const shouldShowNav = typeof nextState === "boolean" ? nextState : !isNavShown;
          if (shouldShowNav === isNavShown) {
            return { layout: state.layout };
          }
          return shouldShowNav ? {
            layout: {
              ...state.layout,
              navSize: state.layout.recentVisibleSizes.navSize
            }
          } : {
            layout: {
              ...state.layout,
              navSize: 0,
              recentVisibleSizes: getRecentVisibleSizes(state.layout)
            }
          };
        },
        { persistence: "session" }
      );
    },
    toggleToolbar(toggled) {
      return store2.setState(
        (state) => {
          const value = typeof toggled !== "undefined" ? toggled : !state.layout.showToolbar;
          return {
            layout: {
              ...state.layout,
              showToolbar: value
            }
          };
        },
        { persistence: "session" }
      );
    },
    setSizes({
      navSize,
      bottomPanelHeight,
      rightPanelWidth
    }) {
      return store2.setState(
        (state) => {
          const nextLayoutState = {
            ...state.layout,
            navSize: navSize ?? state.layout.navSize,
            bottomPanelHeight: bottomPanelHeight ?? state.layout.bottomPanelHeight,
            rightPanelWidth: rightPanelWidth ?? state.layout.rightPanelWidth
          };
          return {
            layout: {
              ...nextLayoutState,
              recentVisibleSizes: getRecentVisibleSizes(nextLayoutState)
            }
          };
        },
        { persistence: "session" }
      );
    },
    focusOnUIElement(elementId, select) {
      if (!elementId) {
        return;
      }
      const element = document2.getElementById(elementId);
      if (element) {
        element.focus();
        if (select) {
          element.select();
        }
      }
    },
    getInitialOptions() {
      const { theme, selectedPanel, layoutCustomisations, ...options } = provider.getConfig();
      return {
        ...defaultLayoutState,
        layout: {
          ...toMerged(
            defaultLayoutState.layout,
            pick(options, Object.keys(defaultLayoutState.layout))
          ),
          ...singleStory && { navSize: 0 }
        },
        layoutCustomisations: {
          ...defaultLayoutState.layoutCustomisations,
          ...layoutCustomisations ?? {}
        },
        ui: toMerged(defaultLayoutState.ui, pick(options, Object.keys(defaultLayoutState.ui))),
        selectedPanel: selectedPanel || defaultLayoutState.selectedPanel,
        theme: theme || defaultLayoutState.theme
      };
    },
    getIsFullscreen() {
      return getIsFullscreen(store2.getState());
    },
    getIsPanelShown() {
      return getIsPanelShown(store2.getState());
    },
    getIsNavShown() {
      return getIsNavShown(store2.getState());
    },
    getShowToolbarWithCustomisations(showToolbar) {
      const state = store2.getState();
      if (isFunction(state.layoutCustomisations.showToolbar)) {
        return state.layoutCustomisations.showToolbar(state, showToolbar) ?? showToolbar;
      }
      return showToolbar;
    },
    getShowPanelWithCustomisations(showPanel) {
      const state = store2.getState();
      if (isFunction(state.layoutCustomisations.showPanel)) {
        return state.layoutCustomisations.showPanel(state, showPanel) ?? showPanel;
      }
      return showPanel;
    },
    getNavSizeWithCustomisations(navSize) {
      const state = store2.getState();
      if (isFunction(state.layoutCustomisations.showSidebar)) {
        const shouldShowNav = state.layoutCustomisations.showSidebar(state, navSize !== 0);
        if (navSize === 0 && shouldShowNav === true) {
          return state.layout.recentVisibleSizes.navSize;
        } else if (navSize !== 0 && shouldShowNav === false) {
          return 0;
        }
      }
      return navSize;
    },
    setOptions: /* @__PURE__ */ __name((options) => {
      const { layout, ui, selectedPanel, theme } = store2.getState();
      if (!options) {
        return;
      }
      const updatedLayout = {
        ...layout,
        ...options.layout || {},
        ...pick(options, Object.keys(layout)),
        ...singleStory && { navSize: 0 }
      };
      const updatedUi = {
        ...ui,
        ...options.ui,
        ...toMerged(options.ui || {}, pick(options, Object.keys(ui)))
      };
      const updatedTheme = {
        ...theme,
        ...options.theme
      };
      const modification = {};
      if (!isEqual(ui, updatedUi)) {
        modification.ui = updatedUi;
      }
      if (!isEqual(layout, updatedLayout)) {
        modification.layout = updatedLayout;
      }
      if (options.selectedPanel && !isEqual(selectedPanel, options.selectedPanel)) {
        modification.selectedPanel = options.selectedPanel;
      }
      if (Object.keys(modification).length) {
        store2.setState(modification, { persistence: "permanent" });
      }
      if (!isEqual(theme, updatedTheme)) {
        store2.setState({ theme: updatedTheme });
      }
    }, "setOptions")
  };
  const persisted = pick(store2.getState(), ["layout", "selectedPanel"]);
  provider.channel?.on(SET_CONFIG2, () => {
    api.setOptions(merge_default(api.getInitialOptions(), persisted));
  });
  return {
    api,
    state: merge_default(api.getInitialOptions(), persisted)
  };
}, "init");

// src/manager-api/modules/notifications.ts
var notifications_exports = {};
__export(notifications_exports, {
  init: () => init6
});
var init6 = /* @__PURE__ */ __name(({ store: store2 }) => {
  const api = {
    addNotification: /* @__PURE__ */ __name((newNotification) => {
      store2.setState(({ notifications }) => {
        const [existing, others] = partition(notifications, (n) => n.id === newNotification.id);
        existing.forEach((notification) => {
          if (notification.onClear) {
            notification.onClear({ dismissed: false, timeout: false });
          }
        });
        return { notifications: [...others, newNotification] };
      });
    }, "addNotification"),
    clearNotification: /* @__PURE__ */ __name((notificationId) => {
      store2.setState(({ notifications }) => {
        const [matching, others] = partition(notifications, (n) => n.id === notificationId);
        matching.forEach((notification) => {
          if (notification.onClear) {
            notification.onClear({ dismissed: false, timeout: false });
          }
        });
        return { notifications: others };
      });
    }, "clearNotification")
  };
  const state = { notifications: [] };
  return {
    api,
    state
  };
}, "init");

// src/manager-api/modules/open-in-editor.tsx
var open_in_editor_exports = {};
__export(open_in_editor_exports, {
  init: () => init7
});
import React from "react";
import {
  OPEN_IN_EDITOR_REQUEST,
  OPEN_IN_EDITOR_RESPONSE
} from "storybook/internal/core-events";
import { FailedIcon } from "@storybook/icons";
var init7 = /* @__PURE__ */ __name(({ provider, fullAPI }) => {
  const api = {
    openInEditor(payload) {
      return new Promise((resolve) => {
        const { file, line, column } = payload;
        const handler = /* @__PURE__ */ __name((res) => {
          if (res.file === file && res.line === line && res.column === column) {
            provider.channel?.off(OPEN_IN_EDITOR_RESPONSE, handler);
            resolve(res);
          }
        }, "handler");
        provider.channel?.on(OPEN_IN_EDITOR_RESPONSE, handler);
        provider.channel?.emit(OPEN_IN_EDITOR_REQUEST, payload);
      });
    }
  };
  const state = { notifications: [] };
  return {
    api,
    state,
    init: /* @__PURE__ */ __name(async () => {
      const { color } = await import("../theming/index.js");
      provider.channel?.on(OPEN_IN_EDITOR_RESPONSE, (payload) => {
        if (payload.error !== null) {
          fullAPI.addNotification({
            id: "open-in-editor-error",
            content: {
              headline: "Failed to open in editor",
              subHeadline: payload.error || "Check the Storybook process on the command line for more details."
            },
            icon: React.createElement(FailedIcon, { color: color.negative }),
            duration: 8e3
          });
        }
      });
    }, "init")
  };
}, "init");

// src/manager-api/modules/provider.ts
var provider_exports = {};
__export(provider_exports, {
  init: () => init8
});
var init8 = /* @__PURE__ */ __name(({ provider, fullAPI }) => {
  return {
    api: provider.renderPreview ? { renderPreview: provider.renderPreview } : {},
    state: {},
    init: /* @__PURE__ */ __name(() => {
      provider.handleAPI(fullAPI);
    }, "init")
  };
}, "init");

// src/manager-api/modules/settings.ts
var settings_exports = {};
__export(settings_exports, {
  init: () => init9
});
var init9 = /* @__PURE__ */ __name(({ store: store2, navigate, fullAPI }) => {
  const isSettingsScreenActive = /* @__PURE__ */ __name(() => {
    const { path } = fullAPI.getUrlState();
    return !!(path || "").match(/^\/settings/);
  }, "isSettingsScreenActive");
  const api = {
    closeSettings: /* @__PURE__ */ __name(() => {
      const {
        settings: { lastTrackedStoryId }
      } = store2.getState();
      if (lastTrackedStoryId) {
        fullAPI.selectStory(lastTrackedStoryId);
      } else {
        fullAPI.selectFirstStory();
      }
    }, "closeSettings"),
    changeSettingsTab: /* @__PURE__ */ __name((path) => {
      navigate(`/settings/${path}`);
    }, "changeSettingsTab"),
    isSettingsScreenActive,
    retrieveSelection() {
      const { settings } = store2.getState();
      return settings.lastTrackedStoryId;
    },
    storeSelection: /* @__PURE__ */ __name(async () => {
      const { storyId, settings } = store2.getState();
      await store2.setState({
        settings: { ...settings, lastTrackedStoryId: storyId }
      });
    }, "storeSelection")
  };
  return {
    state: { settings: { lastTrackedStoryId: null } },
    api
  };
}, "init");

// src/manager-api/modules/shortcuts.ts
var shortcuts_exports = {};
__export(shortcuts_exports, {
  controlOrMetaKey: () => controlOrMetaKey2,
  defaultShortcuts: () => defaultShortcuts,
  init: () => init10,
  isMacLike: () => isMacLike2,
  keys: () => keys
});
var import_copy_to_clipboard = __toESM(require_copy_to_clipboard(), 1);
import {
  FORCE_REMOUNT,
  PREVIEW_KEYDOWN,
  STORIES_COLLAPSE_ALL,
  STORIES_EXPAND_ALL
} from "storybook/internal/core-events";
import { global as global5 } from "@storybook/global";

// src/manager-api/lib/shortcut.ts
import { global as global4 } from "@storybook/global";
var { navigator: navigator2 } = global4;
var isMacLike = /* @__PURE__ */ __name(() => navigator2 && navigator2.platform ? !!navigator2.platform.match(/(Mac|iPhone|iPod|iPad)/i) : false, "isMacLike");
var controlOrMetaSymbol = /* @__PURE__ */ __name(() => isMacLike() ? "\u2318" : "ctrl", "controlOrMetaSymbol");
var controlOrMetaKey = /* @__PURE__ */ __name(() => isMacLike() ? "meta" : "control", "controlOrMetaKey");
var optionOrAltSymbol = /* @__PURE__ */ __name(() => isMacLike() ? "\u2325" : "alt", "optionOrAltSymbol");
var isShortcutTaken = /* @__PURE__ */ __name((arr1, arr2) => JSON.stringify(arr1) === JSON.stringify(arr2), "isShortcutTaken");
var eventToShortcut = /* @__PURE__ */ __name((e) => {
  if (["Meta", "Alt", "Control", "Shift"].includes(e.key)) {
    return null;
  }
  const keys2 = [];
  if (e.altKey) {
    keys2.push("alt");
  }
  if (e.ctrlKey) {
    keys2.push("control");
  }
  if (e.metaKey) {
    keys2.push("meta");
  }
  if (e.shiftKey) {
    keys2.push("shift");
  }
  const codeUpper = e.code?.toUpperCase();
  const codeToCharMap = {
    MINUS: "-",
    EQUAL: "=",
    BRACKETLEFT: "[",
    BRACKETRIGHT: "]",
    BACKSLASH: "\\",
    SEMICOLON: ";",
    QUOTE: "'",
    BACKQUOTE: "`",
    COMMA: ",",
    PERIOD: ".",
    SLASH: "/"
  };
  const codeChar = codeUpper ? codeUpper.startsWith("KEY") && codeUpper.length === 4 ? codeUpper.replace("KEY", "") : codeUpper.startsWith("DIGIT") ? codeUpper.replace("DIGIT", "") : codeToCharMap[codeUpper] : void 0;
  if (e.key && e.key.length === 1 && e.key !== " ") {
    const key = e.key.toUpperCase();
    const code = codeChar;
    if (code && code.length === 1 && code !== key) {
      keys2.push([key, code]);
    } else {
      keys2.push(key);
    }
  } else if (e.key === "Dead" && codeChar) {
    keys2.push(codeChar);
  }
  if (e.key === " ") {
    keys2.push("space");
  }
  if (e.key === "Escape") {
    keys2.push("escape");
  }
  if (e.key === "ArrowRight") {
    keys2.push("ArrowRight");
  }
  if (e.key === "ArrowDown") {
    keys2.push("ArrowDown");
  }
  if (e.key === "ArrowUp") {
    keys2.push("ArrowUp");
  }
  if (e.key === "ArrowLeft") {
    keys2.push("ArrowLeft");
  }
  return keys2.length > 0 ? keys2 : null;
}, "eventToShortcut");
var shortcutMatchesShortcut = /* @__PURE__ */ __name((inputShortcut, shortcut) => {
  if (!inputShortcut || !shortcut) {
    return false;
  }
  if (inputShortcut.join("").startsWith("shift/")) {
    inputShortcut.shift();
  }
  if (inputShortcut.length !== shortcut.length) {
    return false;
  }
  return !inputShortcut.find(
    (input, i) => Array.isArray(input) ? !input.includes(shortcut[i]) : input !== shortcut[i]
  );
}, "shortcutMatchesShortcut");
var eventMatchesShortcut = /* @__PURE__ */ __name((e, shortcut) => {
  return shortcutMatchesShortcut(eventToShortcut(e), shortcut);
}, "eventMatchesShortcut");
var keyToSymbol = /* @__PURE__ */ __name((key) => {
  if (key === "alt") {
    return optionOrAltSymbol();
  }
  if (key === "control") {
    return "\u2303";
  }
  if (key === "meta") {
    return "\u2318";
  }
  if (key === "shift") {
    return "\u21E7\u200B";
  }
  if (key === "Enter" || key === "Backspace" || key === "Esc") {
    return "";
  }
  if (key === "escape") {
    return "";
  }
  if (key === " ") {
    return "SPACE";
  }
  if (key === "ArrowUp") {
    return "\u2191";
  }
  if (key === "ArrowDown") {
    return "\u2193";
  }
  if (key === "ArrowLeft") {
    return "\u2190";
  }
  if (key === "ArrowRight") {
    return "\u2192";
  }
  return key?.toUpperCase();
}, "keyToSymbol");
var shortcutToHumanString = /* @__PURE__ */ __name((shortcut) => {
  return shortcut.map(keyToSymbol).join(" ");
}, "shortcutToHumanString");

// src/manager-api/modules/shortcuts.ts
var { navigator: navigator3, document: document3 } = global5;
var isMacLike2 = /* @__PURE__ */ __name(() => navigator3 && navigator3.platform ? !!navigator3.platform.match(/(Mac|iPhone|iPod|iPad)/i) : false, "isMacLike");
var controlOrMetaKey2 = /* @__PURE__ */ __name(() => isMacLike2() ? "meta" : "control", "controlOrMetaKey");
function keys(o) {
  return Object.keys(o);
}
__name(keys, "keys");
var defaultShortcuts = Object.freeze({
  fullScreen: ["alt", "F"],
  togglePanel: ["alt", "A"],
  panelPosition: ["alt", "D"],
  toggleNav: ["alt", "S"],
  toolbar: ["alt", "T"],
  search: [controlOrMetaKey2(), "K"],
  focusNav: ["1"],
  focusIframe: ["2"],
  focusPanel: ["3"],
  prevComponent: ["alt", "ArrowUp"],
  nextComponent: ["alt", "ArrowDown"],
  prevStory: ["alt", "ArrowLeft"],
  nextStory: ["alt", "ArrowRight"],
  shortcutsPage: [controlOrMetaKey2(), "shift", ","],
  aboutPage: [controlOrMetaKey2(), ","],
  escape: ["escape"],
  // This one is not customizable
  collapseAll: [controlOrMetaKey2(), "shift", "ArrowUp"],
  expandAll: [controlOrMetaKey2(), "shift", "ArrowDown"],
  remount: ["alt", "R"],
  openInEditor: ["alt", "shift", "E"],
  copyStoryLink: ["alt", "shift", "L"]
  // TODO: bring this back once we want to add shortcuts for this
  // copyStoryName: ['alt', 'shift', 'C'],
});
var addonsShortcuts = {};
function shouldSkipShortcut(event) {
  const target = event.target;
  if (/input|textarea/i.test(target.tagName) || target.getAttribute("contenteditable") !== null) {
    return true;
  }
  const dialogElement = target.closest("dialog[open]");
  if (dialogElement) {
    return true;
  }
  return false;
}
__name(shouldSkipShortcut, "shouldSkipShortcut");
var init10 = /* @__PURE__ */ __name(({ store: store2, fullAPI, provider }) => {
  const api = {
    // Getting and setting shortcuts
    getShortcutKeys() {
      return store2.getState().shortcuts;
    },
    getDefaultShortcuts() {
      return {
        ...defaultShortcuts,
        ...api.getAddonsShortcutDefaults()
      };
    },
    getAddonsShortcuts() {
      return addonsShortcuts;
    },
    getAddonsShortcutLabels() {
      const labels = {};
      Object.entries(api.getAddonsShortcuts()).forEach(([actionName, { label }]) => {
        labels[actionName] = label;
      });
      return labels;
    },
    getAddonsShortcutDefaults() {
      const defaults = {};
      Object.entries(api.getAddonsShortcuts()).forEach(([actionName, { defaultShortcut }]) => {
        defaults[actionName] = defaultShortcut;
      });
      return defaults;
    },
    async setShortcuts(shortcuts) {
      await store2.setState({ shortcuts }, { persistence: "permanent" });
      return shortcuts;
    },
    async restoreAllDefaultShortcuts() {
      return api.setShortcuts(api.getDefaultShortcuts());
    },
    async setShortcut(action, value) {
      const shortcuts = api.getShortcutKeys();
      await api.setShortcuts({ ...shortcuts, [action]: value });
      return value;
    },
    async setAddonShortcut(addon, shortcut) {
      const shortcuts = api.getShortcutKeys();
      await api.setShortcuts({
        ...shortcuts,
        [`${addon}-${shortcut.actionName}`]: shortcut.defaultShortcut
      });
      addonsShortcuts[`${addon}-${shortcut.actionName}`] = shortcut;
      return shortcut;
    },
    async restoreDefaultShortcut(action) {
      const defaultShortcut = api.getDefaultShortcuts()[action];
      return api.setShortcut(action, defaultShortcut);
    },
    // Listening to shortcut events
    handleKeydownEvent(event) {
      const shortcut = eventToShortcut(event);
      const shortcuts = api.getShortcutKeys();
      const actions = keys(shortcuts);
      const matchedFeature = actions.find(
        (feature) => shortcutMatchesShortcut(shortcut, shortcuts[feature])
      );
      if (matchedFeature) {
        api.handleShortcutFeature(matchedFeature, event);
      }
    },
    // warning: event might not have a full prototype chain because it may originate from the channel
    handleShortcutFeature(feature, event) {
      const {
        ui: { enableShortcuts },
        storyId
      } = store2.getState();
      if (!enableShortcuts) {
        return;
      }
      if (event?.preventDefault) {
        event.preventDefault();
      }
      switch (feature) {
        case "escape": {
          if (fullAPI.getIsFullscreen()) {
            fullAPI.toggleFullscreen(false);
          } else if (fullAPI.getIsNavShown()) {
            fullAPI.toggleNav(true);
          }
          break;
        }
        case "focusNav": {
          if (fullAPI.getIsFullscreen()) {
            fullAPI.toggleFullscreen(false);
          }
          if (!fullAPI.getIsNavShown()) {
            fullAPI.toggleNav(true);
          }
          fullAPI.focusOnUIElement(focusableUIElements.storyListMenu);
          break;
        }
        case "search": {
          if (fullAPI.getIsFullscreen()) {
            fullAPI.toggleFullscreen(false);
          }
          if (!fullAPI.getIsNavShown()) {
            fullAPI.toggleNav(true);
          }
          setTimeout(() => {
            fullAPI.focusOnUIElement(focusableUIElements.storySearchField, true);
          }, 0);
          break;
        }
        case "focusIframe": {
          const element = document3.getElementById("storybook-preview-iframe");
          if (element) {
            try {
              element.contentWindow.focus();
            } catch (e) {
            }
          }
          break;
        }
        case "focusPanel": {
          if (fullAPI.getIsFullscreen()) {
            fullAPI.toggleFullscreen(false);
          }
          if (!fullAPI.getIsPanelShown()) {
            fullAPI.togglePanel(true);
          }
          fullAPI.focusOnUIElement(focusableUIElements.storyPanelRoot);
          break;
        }
        case "nextStory": {
          fullAPI.jumpToStory(1);
          break;
        }
        case "prevStory": {
          fullAPI.jumpToStory(-1);
          break;
        }
        case "nextComponent": {
          fullAPI.jumpToComponent(1);
          break;
        }
        case "prevComponent": {
          fullAPI.jumpToComponent(-1);
          break;
        }
        case "fullScreen": {
          fullAPI.toggleFullscreen();
          break;
        }
        case "togglePanel": {
          fullAPI.togglePanel();
          break;
        }
        case "toggleNav": {
          fullAPI.toggleNav();
          break;
        }
        case "toolbar": {
          fullAPI.toggleToolbar();
          break;
        }
        case "panelPosition": {
          if (fullAPI.getIsFullscreen()) {
            fullAPI.toggleFullscreen(false);
          }
          if (!fullAPI.getIsPanelShown()) {
            fullAPI.togglePanel(true);
          }
          fullAPI.togglePanelPosition();
          break;
        }
        case "aboutPage": {
          fullAPI.navigate("/settings/about");
          break;
        }
        case "shortcutsPage": {
          fullAPI.navigate("/settings/shortcuts");
          break;
        }
        case "collapseAll": {
          fullAPI.emit(STORIES_COLLAPSE_ALL);
          break;
        }
        case "expandAll": {
          fullAPI.emit(STORIES_EXPAND_ALL);
          break;
        }
        case "remount": {
          fullAPI.emit(FORCE_REMOUNT, { storyId });
          break;
        }
        case "openInEditor": {
          if (global5.CONFIG_TYPE === "DEVELOPMENT") {
            fullAPI.openInEditor({
              file: fullAPI.getCurrentStoryData().importPath
            });
          }
          break;
        }
        // TODO: bring this back once we want to add shortcuts for this
        // case 'copyStoryName': {
        //   const storyData = fullAPI.getCurrentStoryData();
        //   if (storyData.type === 'story') {
        //     copy(storyData.exportName);
        //   }
        //   break;
        // }
        case "copyStoryLink": {
          (0, import_copy_to_clipboard.default)(window.location.href);
          break;
        }
        default:
          addonsShortcuts[feature].action();
          break;
      }
    }
  };
  const { shortcuts: persistedShortcuts = defaultShortcuts } = store2.getState();
  const state = {
    // Any saved shortcuts that are still in our set of defaults
    shortcuts: keys(defaultShortcuts).reduce(
      (acc, key) => ({ ...acc, [key]: persistedShortcuts[key] || defaultShortcuts[key] }),
      defaultShortcuts
    )
  };
  const initModule = /* @__PURE__ */ __name(() => {
    document3.addEventListener("keydown", (event) => {
      if (!shouldSkipShortcut(event)) {
        api.handleKeydownEvent(event);
      }
    });
    provider.channel?.on(PREVIEW_KEYDOWN, (data) => {
      api.handleKeydownEvent(data.event);
    });
  }, "initModule");
  return { api, state, init: initModule };
}, "init");

// src/manager-api/modules/stories.ts
var stories_exports = {};
__export(stories_exports, {
  init: () => init11
});
import { logger as logger5 } from "storybook/internal/client-logger";
import {
  CONFIG_ERROR,
  CURRENT_STORY_WAS_SET,
  DOCS_PREPARED,
  PRELOAD_ENTRIES,
  RESET_STORY_ARGS,
  SELECT_STORY,
  SET_CONFIG as SET_CONFIG3,
  SET_CURRENT_STORY,
  SET_FILTER,
  SET_INDEX,
  SET_STORIES,
  STORY_ARGS_UPDATED,
  STORY_CHANGED,
  STORY_INDEX_INVALIDATED,
  STORY_MISSING,
  STORY_PREPARED,
  STORY_SPECIFIED,
  UPDATE_STORY_ARGS
} from "storybook/internal/core-events";
import { sanitize as sanitize2, toId } from "storybook/internal/csf";
import { global as global6 } from "@storybook/global";

// src/server-errors.ts
var import_picocolors = __toESM(require_picocolors_browser(), 1);
var _StatusTypeIdMismatchError = class _StatusTypeIdMismatchError extends StorybookError {
  constructor(data) {
    super({
      category: "CORE-SERVER" /* CORE_SERVER */,
      code: 16,
      message: `Status has typeId "${data.status.typeId}" but was added to store with typeId "${data.typeId}". Full status: ${JSON.stringify(
        data.status,
        null,
        2
      )}`
    });
    this.data = data;
  }
};
__name(_StatusTypeIdMismatchError, "StatusTypeIdMismatchError");
var StatusTypeIdMismatchError3 = _StatusTypeIdMismatchError;

// src/shared/status-store/index.ts
var UNIVERSAL_STATUS_STORE_OPTIONS = {
  id: "storybook/status",
  leader: true,
  initialState: {}
};
var StatusStoreEventType = {
  SELECT: "select"
};
function createStatusStore({
  universalStatusStore: universalStatusStore2,
  useUniversalStore: useUniversalStore2,
  environment
}) {
  const fullStatusStore2 = {
    getAll() {
      return universalStatusStore2.getState();
    },
    set(statuses) {
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const status of statuses) {
          const { storyId, typeId } = status;
          newState[storyId] = { ...newState[storyId] ?? {}, [typeId]: status };
        }
        return newState;
      });
    },
    onAllStatusChange(listener) {
      return universalStatusStore2.onStateChange((state, prevState) => {
        listener(state, prevState);
      });
    },
    onSelect(listener) {
      return universalStatusStore2.subscribe(StatusStoreEventType.SELECT, (event) => {
        listener(event.payload);
      });
    },
    selectStatuses: /* @__PURE__ */ __name((statuses) => {
      universalStatusStore2.send({ type: StatusStoreEventType.SELECT, payload: statuses });
    }, "selectStatuses"),
    unset(storyIds) {
      if (!storyIds) {
        universalStatusStore2.setState({});
        return;
      }
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const storyId of storyIds) {
          delete newState[storyId];
        }
        return newState;
      });
    },
    typeId: void 0
  };
  const getStatusStoreByTypeId2 = /* @__PURE__ */ __name((typeId) => ({
    getAll: fullStatusStore2.getAll,
    set(statuses) {
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const status of statuses) {
          const { storyId } = status;
          if (status.typeId !== typeId) {
            switch (environment) {
              case "server":
                throw new StatusTypeIdMismatchError3({
                  status,
                  typeId
                });
              case "manager":
                throw new StatusTypeIdMismatchError({
                  status,
                  typeId
                });
              case "preview":
              default:
                throw new StatusTypeIdMismatchError2({
                  status,
                  typeId
                });
            }
          }
          newState[storyId] = { ...newState[storyId] ?? {}, [typeId]: status };
        }
        return newState;
      });
    },
    onAllStatusChange: fullStatusStore2.onAllStatusChange,
    onSelect(listener) {
      return universalStatusStore2.subscribe(StatusStoreEventType.SELECT, (event) => {
        if (event.payload.some((status) => status.typeId === typeId)) {
          listener(event.payload);
        }
      });
    },
    unset(storyIds) {
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const storyId in newState) {
          if (newState[storyId]?.[typeId] && (!storyIds || storyIds?.includes(storyId))) {
            const { [typeId]: omittedStatus, ...storyStatusesWithoutTypeId } = newState[storyId];
            newState[storyId] = storyStatusesWithoutTypeId;
          }
        }
        return newState;
      });
    },
    typeId
  }), "getStatusStoreByTypeId");
  if (!useUniversalStore2) {
    return { getStatusStoreByTypeId: getStatusStoreByTypeId2, fullStatusStore: fullStatusStore2, universalStatusStore: universalStatusStore2 };
  }
  return {
    getStatusStoreByTypeId: getStatusStoreByTypeId2,
    fullStatusStore: fullStatusStore2,
    universalStatusStore: universalStatusStore2,
    useStatusStore: /* @__PURE__ */ __name((selector) => useUniversalStore2(universalStatusStore2, selector)[0], "useStatusStore")
  };
}
__name(createStatusStore, "createStatusStore");

// src/shared/universal-store/use-universal-store-manager.ts
import * as React2 from "react";
var useUniversalStore = /* @__PURE__ */ __name((universalStore, selector) => {
  const snapshotRef = React2.useRef(
    selector ? selector(universalStore.getState()) : universalStore.getState()
  );
  const subscribe = React2.useCallback(
    (listener) => universalStore.onStateChange((state2, previousState) => {
      if (!selector) {
        snapshotRef.current = state2;
        listener();
        return;
      }
      const selectedState = selector(state2);
      const selectedPreviousState = selector(previousState);
      const hasChanges = !isEqual(selectedState, selectedPreviousState);
      if (hasChanges) {
        snapshotRef.current = selectedState;
        listener();
      }
    }),
    [universalStore, selector]
  );
  const getSnapshot = React2.useCallback(() => {
    const currentState = universalStore.getState();
    const selectedState = selector ? selector(currentState) : currentState;
    if (isEqual(selectedState, snapshotRef.current)) {
      return snapshotRef.current;
    }
    snapshotRef.current = selectedState;
    return snapshotRef.current;
  }, [universalStore, selector]);
  const state = React2.useSyncExternalStore(subscribe, getSnapshot);
  return [state, universalStore.setState];
}, "useUniversalStore");

// src/manager-api/stores/status.ts
var statusStore = createStatusStore({
  universalStatusStore: UniversalStore.create({
    ...UNIVERSAL_STATUS_STORE_OPTIONS,
    leader: globalThis.CONFIG_TYPE === "PRODUCTION"
  }),
  useUniversalStore,
  environment: "manager"
});
var { fullStatusStore, getStatusStoreByTypeId, useStatusStore, universalStatusStore } = statusStore;

// src/manager-api/modules/stories.ts
var { fetch: fetch2 } = global6;
var STORY_INDEX_PATH = "./index.json";
var removedOptions = ["enableShortcuts", "theme", "showRoots"];
function removeRemovedOptions(options) {
  if (!options || typeof options === "string") {
    return options;
  }
  const result = { ...options };
  removedOptions.forEach((option) => {
    if (option in result) {
      delete result[option];
    }
  });
  return result;
}
__name(removeRemovedOptions, "removeRemovedOptions");
var init11 = /* @__PURE__ */ __name(({
  fullAPI,
  store: store2,
  navigate,
  provider,
  storyId: initialStoryId,
  viewMode: initialViewMode,
  docsOptions = {}
}) => {
  const api = {
    storyId: toId,
    getData: /* @__PURE__ */ __name((storyId, refId) => {
      const result = api.resolveStory(storyId, refId);
      if (result?.type === "story" || result?.type === "docs") {
        return result;
      }
      return void 0;
    }, "getData"),
    isPrepared: /* @__PURE__ */ __name((storyId, refId) => {
      const data = api.getData(storyId, refId);
      if (!data) {
        return false;
      }
      return data.type === "story" ? data.prepared : true;
    }, "isPrepared"),
    resolveStory: /* @__PURE__ */ __name((storyId, refId) => {
      const { refs, index } = store2.getState();
      if (refId && !refs[refId]) {
        return void 0;
      }
      if (refId) {
        return refs?.[refId]?.index?.[storyId] ?? void 0;
      }
      return index ? index[storyId] : void 0;
    }, "resolveStory"),
    getCurrentStoryData: /* @__PURE__ */ __name(() => {
      const { storyId, refId } = store2.getState();
      return api.getData(storyId, refId);
    }, "getCurrentStoryData"),
    getParameters: /* @__PURE__ */ __name((storyIdOrCombo, parameterName) => {
      const { storyId, refId } = typeof storyIdOrCombo === "string" ? { storyId: storyIdOrCombo, refId: void 0 } : storyIdOrCombo;
      const data = api.getData(storyId, refId);
      if (["story", "docs"].includes(data?.type)) {
        const { parameters } = data;
        if (parameters) {
          return parameterName ? parameters[parameterName] : parameters;
        }
      }
      return null;
    }, "getParameters"),
    getCurrentParameter: /* @__PURE__ */ __name((parameterName) => {
      const { storyId, refId } = store2.getState();
      const parameters = api.getParameters({ storyId, refId }, parameterName);
      return parameters || void 0;
    }, "getCurrentParameter"),
    jumpToComponent: /* @__PURE__ */ __name((direction) => {
      const { filteredIndex, storyId, refs, refId } = store2.getState();
      const story = api.getData(storyId, refId);
      if (!story) {
        return;
      }
      const hash = refId ? refs[refId].filteredIndex || {} : filteredIndex;
      if (!hash) {
        return;
      }
      const result = api.findSiblingStoryId(storyId, hash, direction, true);
      if (result) {
        api.selectStory(result, void 0, { ref: refId });
      }
    }, "jumpToComponent"),
    jumpToStory: /* @__PURE__ */ __name((direction) => {
      const { filteredIndex, storyId, refs, refId } = store2.getState();
      const story = api.getData(storyId, refId);
      if (!story) {
        return;
      }
      const hash = story.refId ? refs[story.refId].filteredIndex : filteredIndex;
      if (!hash) {
        return;
      }
      const result = api.findSiblingStoryId(storyId, hash, direction, false);
      if (result) {
        api.selectStory(result, void 0, { ref: refId });
      }
    }, "jumpToStory"),
    selectFirstStory: /* @__PURE__ */ __name(() => {
      const { index } = store2.getState();
      if (!index) {
        return;
      }
      const firstStory = Object.keys(index).find((id) => index[id].type === "story");
      if (firstStory) {
        api.selectStory(firstStory);
        return;
      }
      navigate("/");
    }, "selectFirstStory"),
    selectStory: /* @__PURE__ */ __name((titleOrId = void 0, name = void 0, options = {}) => {
      const { ref } = options;
      const { storyId, index, filteredIndex, refs, settings } = store2.getState();
      const gotoStory = /* @__PURE__ */ __name((entry) => {
        if (entry?.type === "docs" || entry?.type === "story") {
          store2.setState({ settings: { ...settings, lastTrackedStoryId: entry.id } });
          navigate(`/${entry.type}/${entry.refId ? `${entry.refId}_${entry.id}` : entry.id}`);
          return true;
        }
        return false;
      }, "gotoStory");
      const kindSlug = storyId?.split("--", 2)[0];
      const hash = ref ? refs[ref].index : index;
      const filteredHash = ref ? refs[ref].filteredIndex : filteredIndex;
      if (!hash || !filteredHash) {
        return;
      }
      if (!name) {
        const entry = titleOrId ? hash[titleOrId] || hash[sanitize2(titleOrId)] : hash[kindSlug];
        if (!entry) {
          throw new Error(`Unknown id or title: '${titleOrId}'`);
        }
        if (!gotoStory(entry)) {
          gotoStory(api.findLeafEntry(filteredHash, entry.id));
        }
      } else if (!titleOrId) {
        gotoStory(hash[toId(kindSlug, name)]);
      } else {
        const id = ref ? `${ref}_${toId(titleOrId, name)}` : toId(titleOrId, name);
        if (hash[id]) {
          gotoStory(hash[id]);
        } else {
          const entry = hash[sanitize2(titleOrId)];
          if (entry?.type === "component") {
            const foundId = entry.children.find((childId) => hash[childId].name === name);
            gotoStory(foundId ? hash[foundId] : void 0);
          }
        }
      }
    }, "selectStory"),
    findLeafEntry(index, storyId) {
      const entry = index[storyId];
      if (entry.type === "docs" || entry.type === "story") {
        return entry;
      }
      const childStoryId = entry.children.find((childId) => index[childId]) || entry.children[0];
      return api.findLeafEntry(index, childStoryId);
    },
    findLeafStoryId(index, storyId) {
      return api.findLeafEntry(index, storyId)?.id;
    },
    findAllLeafStoryIds(entryId) {
      const { index } = store2.getState();
      if (!index) {
        return [];
      }
      const findChildEntriesRecursively = /* @__PURE__ */ __name((currentEntryId, results = []) => {
        const node = index[currentEntryId];
        if (!node) {
          return results;
        }
        if (node.type === "story") {
          results.push(node.id);
        }
        if ("children" in node) {
          node.children?.forEach((childId) => findChildEntriesRecursively(childId, results));
        }
        return results;
      }, "findChildEntriesRecursively");
      return findChildEntriesRecursively(entryId, []);
    },
    findSiblingStoryId(storyId, index, direction, toSiblingGroup) {
      if (toSiblingGroup) {
        const lookupList2 = getComponentLookupList(index);
        const position2 = lookupList2.findIndex((i) => i.includes(storyId));
        if (position2 === lookupList2.length - 1 && direction > 0) {
          return;
        }
        if (position2 === 0 && direction < 0) {
          return;
        }
        if (lookupList2[position2 + direction]) {
          return lookupList2[position2 + direction][0];
        }
        return;
      }
      const lookupList = getStoriesLookupList(index);
      const position = lookupList.indexOf(storyId);
      if (position === lookupList.length - 1 && direction > 0) {
        return;
      }
      if (position === 0 && direction < 0) {
        return;
      }
      return lookupList[position + direction];
    },
    updateStoryArgs: /* @__PURE__ */ __name((story, updatedArgs) => {
      const { id: storyId, refId } = story;
      provider.channel?.emit(UPDATE_STORY_ARGS, {
        storyId,
        updatedArgs,
        options: { target: refId }
      });
    }, "updateStoryArgs"),
    resetStoryArgs: /* @__PURE__ */ __name((story, argNames) => {
      const { id: storyId, refId } = story;
      provider.channel?.emit(RESET_STORY_ARGS, {
        storyId,
        argNames,
        options: { target: refId }
      });
    }, "resetStoryArgs"),
    fetchIndex: /* @__PURE__ */ __name(async () => {
      try {
        const result = await fetch2(STORY_INDEX_PATH);
        if (result.status !== 200) {
          throw new Error(await result.text());
        }
        const storyIndex = await result.json();
        if (storyIndex.v < 3) {
          logger5.warn(`Skipping story index with version v${storyIndex.v}, awaiting SET_STORIES.`);
          return;
        }
        await api.setIndex(storyIndex);
      } catch (err) {
        await store2.setState({ indexError: err });
      }
    }, "fetchIndex"),
    // The story index we receive on SET_INDEX is "prepared" in that it has parameters
    // The story index we receive on fetchStoryIndex is not, but all the prepared fields are optional
    // so we can cast one to the other easily enough
    setIndex: /* @__PURE__ */ __name(async (input) => {
      const { filteredIndex: oldFilteredHash, index: oldHash, filters } = store2.getState();
      const allStatuses = fullStatusStore.getAll();
      const newFilteredHash = transformStoryIndexToStoriesHash(input, {
        provider,
        docsOptions,
        filters,
        allStatuses
      });
      const newHash = transformStoryIndexToStoriesHash(input, {
        provider,
        docsOptions,
        filters: {},
        allStatuses
      });
      await store2.setState({
        internal_index: input,
        filteredIndex: addPreparedStories(newFilteredHash, oldFilteredHash),
        index: addPreparedStories(newHash, oldHash),
        indexError: void 0
      });
    }, "setIndex"),
    // FIXME: is there a bug where filtered stories get added back in on updateStory???
    updateStory: /* @__PURE__ */ __name(async (storyId, update2, ref) => {
      if (!ref) {
        const { index, filteredIndex } = store2.getState();
        if (index) {
          index[storyId] = {
            ...index[storyId],
            ...update2
          };
        }
        if (filteredIndex) {
          filteredIndex[storyId] = {
            ...filteredIndex[storyId],
            ...update2
          };
        }
        if (index || filteredIndex) {
          await store2.setState({ index, filteredIndex });
        }
      } else {
        const { id: refId, index, filteredIndex } = ref;
        index[storyId] = {
          ...index[storyId],
          ...update2
        };
        filteredIndex[storyId] = {
          ...filteredIndex[storyId],
          ...update2
        };
        await fullAPI.updateRef(refId, { index, filteredIndex });
      }
    }, "updateStory"),
    updateDocs: /* @__PURE__ */ __name(async (docsId, update2, ref) => {
      if (!ref) {
        const { index, filteredIndex } = store2.getState();
        if (index) {
          index[docsId] = {
            ...index[docsId],
            ...update2
          };
        }
        if (filteredIndex) {
          filteredIndex[docsId] = {
            ...filteredIndex[docsId],
            ...update2
          };
        }
        if (index || filteredIndex) {
          await store2.setState({ index, filteredIndex });
        }
      } else {
        const { id: refId, index, filteredIndex } = ref;
        index[docsId] = {
          ...index[docsId],
          ...update2
        };
        filteredIndex[docsId] = {
          ...filteredIndex[docsId],
          ...update2
        };
        await fullAPI.updateRef(refId, { index, filteredIndex });
      }
    }, "updateDocs"),
    setPreviewInitialized: /* @__PURE__ */ __name(async (ref) => {
      if (!ref) {
        store2.setState({ previewInitialized: true });
      } else {
        fullAPI.updateRef(ref.id, { previewInitialized: true });
      }
    }, "setPreviewInitialized"),
    experimental_setFilter: /* @__PURE__ */ __name(async (id, filterFunction) => {
      await store2.setState({ filters: { ...store2.getState().filters, [id]: filterFunction } });
      const { internal_index: index } = store2.getState();
      if (!index) {
        return;
      }
      await api.setIndex(index);
      const refs = await fullAPI.getRefs();
      Object.entries(refs).forEach(([refId, { internal_index, ...ref }]) => {
        fullAPI.setRef(refId, { ...ref, storyIndex: internal_index }, true);
      });
      provider.channel?.emit(SET_FILTER, { id });
    }, "experimental_setFilter")
  };
  provider.channel?.on(
    STORY_SPECIFIED,
    /* @__PURE__ */ __name(function handler({
      storyId,
      viewMode
    }) {
      const { sourceType } = getEventMetadata(this, fullAPI);
      if (sourceType === "local") {
        const state = store2.getState();
        const isCanvasRoute = state.path === "/" || state.viewMode === "story" || state.viewMode === "docs";
        const stateHasSelection = state.viewMode && state.storyId;
        const stateSelectionDifferent = state.viewMode !== viewMode || state.storyId !== storyId;
        const { type } = state.index?.[state.storyId] || {};
        const isStory = !(type === "root" || type === "component" || type === "group");
        if (isCanvasRoute) {
          if (stateHasSelection && stateSelectionDifferent && isStory) {
            provider.channel?.emit(SET_CURRENT_STORY, {
              storyId: state.storyId,
              viewMode: state.viewMode
            });
          } else if (stateSelectionDifferent) {
            navigate(`/${viewMode}/${storyId}`);
          }
        }
      }
    }, "handler")
  );
  provider.channel?.on(CURRENT_STORY_WAS_SET, /* @__PURE__ */ __name(function handler() {
    const { ref } = getEventMetadata(this, fullAPI);
    api.setPreviewInitialized(ref);
  }, "handler"));
  provider.channel?.on(STORY_CHANGED, /* @__PURE__ */ __name(function handler() {
    const { sourceType } = getEventMetadata(this, fullAPI);
    if (sourceType === "local") {
      const options = api.getCurrentParameter("options");
      if (options) {
        fullAPI.setOptions(removeRemovedOptions(options));
      }
    }
  }, "handler"));
  provider.channel?.on(
    STORY_PREPARED,
    /* @__PURE__ */ __name(function handler({ id, ...update2 }) {
      const { ref, sourceType } = getEventMetadata(this, fullAPI);
      api.updateStory(id, { ...update2, prepared: true }, ref);
      if (!ref) {
        if (!store2.getState().hasCalledSetOptions) {
          const { options } = update2.parameters;
          fullAPI.setOptions(removeRemovedOptions(options));
          store2.setState({ hasCalledSetOptions: true });
        }
      }
      if (sourceType === "local") {
        const { storyId, index, refId } = store2.getState();
        if (!index) {
          return;
        }
        const toBePreloaded = Array.from(
          /* @__PURE__ */ new Set([
            api.findSiblingStoryId(storyId, index, 1, true),
            api.findSiblingStoryId(storyId, index, -1, true)
          ])
        ).filter(Boolean);
        provider.channel?.emit(PRELOAD_ENTRIES, {
          ids: toBePreloaded,
          options: { target: refId }
        });
      }
    }, "handler")
  );
  provider.channel?.on(
    DOCS_PREPARED,
    /* @__PURE__ */ __name(function handler({ id, ...update2 }) {
      const { ref } = getEventMetadata(this, fullAPI);
      api.updateStory(id, { ...update2, prepared: true }, ref);
    }, "handler")
  );
  provider.channel?.on(SET_INDEX, /* @__PURE__ */ __name(function handler(index) {
    const { ref } = getEventMetadata(this, fullAPI);
    if (!ref) {
      api.setIndex(index);
      const options = api.getCurrentParameter("options");
      fullAPI.setOptions(removeRemovedOptions(options));
    } else {
      fullAPI.setRef(ref.id, { ...ref, storyIndex: index }, true);
    }
  }, "handler"));
  provider.channel?.on(SET_STORIES, /* @__PURE__ */ __name(function handler(data) {
    const { ref } = getEventMetadata(this, fullAPI);
    const setStoriesData = data.v ? denormalizeStoryParameters(data) : data.stories;
    if (!ref) {
      throw new Error("Cannot call SET_STORIES for local frame");
    } else {
      fullAPI.setRef(ref.id, { ...ref, setStoriesData }, true);
    }
  }, "handler"));
  provider.channel?.on(
    SELECT_STORY,
    /* @__PURE__ */ __name(function handler({
      kind,
      title = kind,
      story,
      name = story,
      storyId,
      ...rest
    }) {
      const { ref } = getEventMetadata(this, fullAPI);
      if (!ref) {
        fullAPI.selectStory(storyId || title, name, rest);
      } else {
        fullAPI.selectStory(storyId || title, name, { ...rest, ref: ref.id });
      }
    }, "handler")
  );
  provider.channel?.on(
    STORY_ARGS_UPDATED,
    /* @__PURE__ */ __name(function handleStoryArgsUpdated({ storyId, args }) {
      const { ref } = getEventMetadata(this, fullAPI);
      api.updateStory(storyId, { args }, ref);
    }, "handleStoryArgsUpdated")
  );
  provider.channel?.on(CONFIG_ERROR, /* @__PURE__ */ __name(function handleConfigError(err) {
    const { ref } = getEventMetadata(this, fullAPI);
    api.setPreviewInitialized(ref);
  }, "handleConfigError"));
  provider.channel?.on(STORY_MISSING, /* @__PURE__ */ __name(function handleConfigError(err) {
    const { ref } = getEventMetadata(this, fullAPI);
    api.setPreviewInitialized(ref);
  }, "handleConfigError"));
  provider.channel?.on(SET_CONFIG3, () => {
    const config2 = provider.getConfig();
    if (config2?.sidebar?.filters) {
      store2.setState({
        filters: {
          ...store2.getState().filters,
          ...config2?.sidebar?.filters
        }
      });
    }
  });
  fullStatusStore.onAllStatusChange(async () => {
    const { internal_index: index } = store2.getState();
    if (!index) {
      return;
    }
    await api.setIndex(index);
    const refs = await fullAPI.getRefs();
    Object.entries(refs).forEach(([refId, { internal_index, ...ref }]) => {
      fullAPI.setRef(refId, { ...ref, storyIndex: internal_index }, true);
    });
  });
  const config = provider.getConfig();
  return {
    api,
    state: {
      storyId: initialStoryId,
      viewMode: initialViewMode,
      hasCalledSetOptions: false,
      previewInitialized: false,
      filters: config?.sidebar?.filters || {}
    },
    init: /* @__PURE__ */ __name(async () => {
      provider.channel?.on(STORY_INDEX_INVALIDATED, () => api.fetchIndex());
      await api.fetchIndex();
    }, "init")
  };
}, "init");

// src/manager-api/modules/url.ts
var url_exports = {};
__export(url_exports, {
  init: () => init12
});
import {
  GLOBALS_UPDATED as GLOBALS_UPDATED2,
  NAVIGATE_URL,
  SET_CURRENT_STORY as SET_CURRENT_STORY2,
  STORY_ARGS_UPDATED as STORY_ARGS_UPDATED2,
  UPDATE_QUERY_PARAMS
} from "storybook/internal/core-events";
import { buildArgsParam, queryFromLocation } from "storybook/internal/router";
import { global as global7 } from "@storybook/global";
var { window: globalWindow } = global7;
var parseBoolean = /* @__PURE__ */ __name((value) => {
  if (value === "true" || value === "1") {
    return true;
  }
  if (value === "false" || value === "0") {
    return false;
  }
  return void 0;
}, "parseBoolean");
var prevParams;
var initialUrlSupport = /* @__PURE__ */ __name(({
  state: { location: location2, path, viewMode, storyId: storyIdFromUrl },
  singleStory
}) => {
  const {
    full,
    panel,
    nav,
    shortcuts,
    addonPanel,
    tabs,
    path: queryPath,
    ...otherParams
    // the rest gets passed to the iframe
  } = queryFromLocation(location2);
  let navSize;
  let bottomPanelHeight;
  let rightPanelWidth;
  if (parseBoolean(full) === true) {
    navSize = 0;
    bottomPanelHeight = 0;
    rightPanelWidth = 0;
  } else if (parseBoolean(full) === false) {
    navSize = defaultLayoutState.layout.navSize;
    bottomPanelHeight = defaultLayoutState.layout.bottomPanelHeight;
    rightPanelWidth = defaultLayoutState.layout.rightPanelWidth;
  }
  if (!singleStory) {
    if (parseBoolean(nav) === true) {
      navSize = defaultLayoutState.layout.navSize;
    }
    if (parseBoolean(nav) === false) {
      navSize = 0;
    }
  }
  if (parseBoolean(panel) === false) {
    bottomPanelHeight = 0;
    rightPanelWidth = 0;
  }
  const layout = {
    navSize,
    bottomPanelHeight,
    rightPanelWidth,
    panelPosition: ["right", "bottom"].includes(panel) ? panel : void 0,
    showTabs: parseBoolean(tabs)
  };
  const ui = {
    enableShortcuts: parseBoolean(shortcuts)
  };
  const selectedPanel = addonPanel || void 0;
  const storyId = storyIdFromUrl;
  const customQueryParams = dequal(prevParams, otherParams) ? prevParams : otherParams;
  prevParams = customQueryParams;
  return { viewMode, layout, ui, selectedPanel, location: location2, path, customQueryParams, storyId };
}, "initialUrlSupport");
var init12 = /* @__PURE__ */ __name((moduleArgs) => {
  const { store: store2, navigate, provider, fullAPI } = moduleArgs;
  const navigateTo = /* @__PURE__ */ __name((path, queryParams = {}, options = {}) => {
    const params = Object.entries(queryParams).filter(([, v]) => v).sort(([a], [b]) => a < b ? -1 : 1).map(([k, v]) => `${k}=${v}`);
    const to = [path, ...params].join("&");
    return navigate(to, options);
  }, "navigateTo");
  const api = {
    getQueryParam(key) {
      const { customQueryParams } = store2.getState();
      return customQueryParams ? customQueryParams[key] : void 0;
    },
    getUrlState() {
      const { location: location2, path, customQueryParams, storyId, url, viewMode } = store2.getState();
      return {
        path,
        hash: location2.hash ?? "",
        queryParams: customQueryParams,
        storyId,
        url,
        viewMode
      };
    },
    setQueryParams(input) {
      const { customQueryParams } = store2.getState();
      const queryParams = {};
      const update2 = {
        ...customQueryParams,
        ...Object.entries(input).reduce((acc, [key, value]) => {
          if (value !== null) {
            acc[key] = value;
          }
          return acc;
        }, queryParams)
      };
      if (!dequal(customQueryParams, update2)) {
        store2.setState({ customQueryParams: update2 });
        provider.channel?.emit(UPDATE_QUERY_PARAMS, update2);
      }
    },
    applyQueryParams(input, options) {
      const { path, hash = "", queryParams } = api.getUrlState();
      navigateTo(`${path}${hash}`, { ...queryParams, ...input }, options);
      api.setQueryParams(input);
    },
    navigateUrl(url, options) {
      navigate(url, { plain: true, ...options });
    }
  };
  const updateArgsParam = /* @__PURE__ */ __name(() => {
    const { path, hash = "", queryParams, viewMode } = api.getUrlState();
    if (viewMode !== "story") {
      return;
    }
    const currentStory = fullAPI.getCurrentStoryData();
    if (currentStory?.type !== "story") {
      return;
    }
    const { args, initialArgs } = currentStory;
    const argsString = buildArgsParam(initialArgs, args);
    navigateTo(`${path}${hash}`, { ...queryParams, args: argsString }, { replace: true });
    api.setQueryParams({ args: argsString });
  }, "updateArgsParam");
  provider.channel?.on(SET_CURRENT_STORY2, () => updateArgsParam());
  let handleOrId;
  provider.channel?.on(STORY_ARGS_UPDATED2, () => {
    if ("requestIdleCallback" in globalWindow) {
      if (handleOrId) {
        globalWindow.cancelIdleCallback(handleOrId);
      }
      handleOrId = globalWindow.requestIdleCallback(updateArgsParam, { timeout: 1e3 });
    } else {
      if (handleOrId) {
        clearTimeout(handleOrId);
      }
      setTimeout(updateArgsParam, 100);
    }
  });
  provider.channel?.on(GLOBALS_UPDATED2, ({ userGlobals, initialGlobals }) => {
    const { path, hash = "", queryParams } = api.getUrlState();
    const globalsString = buildArgsParam(initialGlobals, userGlobals);
    navigateTo(`${path}${hash}`, { ...queryParams, globals: globalsString }, { replace: true });
    api.setQueryParams({ globals: globalsString });
  });
  provider.channel?.on(NAVIGATE_URL, (url, options) => {
    api.navigateUrl(url, options);
  });
  return {
    api,
    state: initialUrlSupport(moduleArgs)
  };
}, "init");

// src/manager-api/modules/versions.ts
var versions_exports = {};
__export(versions_exports, {
  init: () => init13
});
var import_memoizerific2 = __toESM(require_memoizerific(), 1);
import { global as global8 } from "@storybook/global";
import semver from "semver";

// src/manager-api/version.ts
var version = "10.0.8";

// src/manager-api/modules/versions.ts
var { VERSIONCHECK } = global8;
var getVersionCheckData = (0, import_memoizerific2.default)(1)(() => {
  try {
    return { ...JSON.parse(VERSIONCHECK).data || {} };
  } catch (e) {
    return {};
  }
});
var normalizeRendererName = /* @__PURE__ */ __name((renderer) => {
  if (renderer.includes("vue")) {
    return "vue";
  }
  return renderer;
}, "normalizeRendererName");
var init13 = /* @__PURE__ */ __name(({ store: store2 }) => {
  const { dismissedVersionNotification } = store2.getState();
  const state = {
    versions: {
      current: {
        version
      },
      ...getVersionCheckData()
    },
    dismissedVersionNotification
  };
  const api = {
    getCurrentVersion: /* @__PURE__ */ __name(() => {
      const {
        versions: { current }
      } = store2.getState();
      return current;
    }, "getCurrentVersion"),
    getLatestVersion: /* @__PURE__ */ __name(() => {
      const {
        versions: { latest, next, current }
      } = store2.getState();
      if (current && semver.prerelease(current.version) && next) {
        return latest && semver.gt(latest.version, next.version) ? latest : next;
      }
      return latest;
    }, "getLatestVersion"),
    // TODO: Move this to it's own "info" module later
    getDocsUrl: /* @__PURE__ */ __name(({ subpath, versioned, renderer }) => {
      const {
        versions: { latest, current }
      } = store2.getState();
      let url = "https://storybook.js.org/docs/";
      if (versioned && current?.version && latest?.version) {
        const versionDiff = semver.diff(latest.version, current.version);
        const isLatestDocs = versionDiff === "patch" || versionDiff === null || // assume latest version when current version is a 0.0.0 canary
        semver.satisfies(current.version, "0.0.0", { includePrerelease: true });
        if (!isLatestDocs) {
          url += `${semver.major(current.version)}.${semver.minor(current.version)}/`;
        }
      }
      const [cleanedSubpath, hash] = subpath?.split("#") || [];
      if (cleanedSubpath) {
        url += `${cleanedSubpath}/`;
      }
      if (renderer && typeof global8.STORYBOOK_RENDERER !== "undefined") {
        const rendererName = global8.STORYBOOK_RENDERER;
        if (rendererName) {
          url += `?renderer=${normalizeRendererName(rendererName)}`;
        }
      }
      if (hash) {
        url += `#${hash}`;
      }
      return url;
    }, "getDocsUrl"),
    versionUpdateAvailable: /* @__PURE__ */ __name(() => {
      const latest = api.getLatestVersion();
      const current = api.getCurrentVersion();
      if (latest) {
        if (!latest.version) {
          return true;
        }
        if (!current.version) {
          return true;
        }
        const onPrerelease = !!semver.prerelease(current.version);
        const actualCurrent = onPrerelease ? `${semver.major(current.version)}.${semver.minor(current.version)}.${semver.patch(
          current.version
        )}` : current.version;
        const diff = semver.diff(actualCurrent, latest.version);
        return semver.gt(latest.version, actualCurrent) && diff !== "patch" && !diff.includes("pre");
      }
      return false;
    }, "versionUpdateAvailable")
  };
  const initModule = /* @__PURE__ */ __name(async () => {
    const { versions = {} } = store2.getState();
    const { latest, next } = getVersionCheckData();
    await store2.setState({
      versions: { ...versions, latest, next }
    });
  }, "initModule");
  return { init: initModule, state, api };
}, "init");

// src/manager-api/modules/whatsnew.tsx
var whatsnew_exports = {};
__export(whatsnew_exports, {
  init: () => init14
});
import React3 from "react";
import {
  REQUEST_WHATS_NEW_DATA,
  RESULT_WHATS_NEW_DATA,
  SET_WHATS_NEW_CACHE,
  TOGGLE_WHATS_NEW_NOTIFICATIONS
} from "storybook/internal/core-events";
import { global as global9 } from "@storybook/global";
var WHATS_NEW_NOTIFICATION_ID = "whats-new";
var StorybookIcon = /* @__PURE__ */ __name(({ color = "currentColor", size = 14 }) => {
  return React3.createElement(
    "svg",
    {
      width: size,
      height: size,
      viewBox: "0 0 14 14",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    },
    React3.createElement(
      "path",
      {
        fillRule: "evenodd",
        clipRule: "evenodd",
        d: "M2.042.616a.704.704 0 00-.66.729L1.816 12.9c.014.367.306.66.672.677l9.395.422h.032a.704.704 0 00.704-.703V.704c0-.015 0-.03-.002-.044a.704.704 0 00-.746-.659l-.773.049.057 1.615a.105.105 0 01-.17.086l-.52-.41-.617.468a.105.105 0 01-.168-.088L9.746.134 2.042.616zm8.003 4.747c-.247.192-2.092.324-2.092.05.04-1.045-.429-1.091-.689-1.091-.247 0-.662.075-.662.634 0 .57.607.893 1.32 1.27 1.014.538 2.24 1.188 2.24 2.823 0 1.568-1.273 2.433-2.898 2.433-1.676 0-3.141-.678-2.976-3.03.065-.275 2.197-.21 2.197 0-.026.971.195 1.256.753 1.256.43 0 .624-.236.624-.634 0-.602-.633-.958-1.361-1.367-.987-.554-2.148-1.205-2.148-2.7 0-1.494 1.027-2.489 2.86-2.489 1.832 0 2.832.98 2.832 2.845z",
        fill: color
      }
    )
  );
}, "StorybookIcon");
var init14 = /* @__PURE__ */ __name(({ fullAPI, store: store2, provider }) => {
  const state = {
    whatsNewData: void 0
  };
  function setWhatsNewState(newState) {
    store2.setState({ whatsNewData: newState });
    state.whatsNewData = newState;
  }
  __name(setWhatsNewState, "setWhatsNewState");
  const api = {
    isWhatsNewUnread() {
      return state.whatsNewData?.status === "SUCCESS" && !state.whatsNewData.postIsRead;
    },
    whatsNewHasBeenRead() {
      if (state.whatsNewData?.status === "SUCCESS") {
        setWhatsNewCache({ lastReadPost: state.whatsNewData.url });
        setWhatsNewState({ ...state.whatsNewData, postIsRead: true });
        fullAPI.clearNotification(WHATS_NEW_NOTIFICATION_ID);
      }
    },
    toggleWhatsNewNotifications() {
      if (state.whatsNewData?.status === "SUCCESS") {
        setWhatsNewState({
          ...state.whatsNewData,
          disableWhatsNewNotifications: !state.whatsNewData.disableWhatsNewNotifications
        });
        provider.channel?.emit(TOGGLE_WHATS_NEW_NOTIFICATIONS, {
          disableWhatsNewNotifications: state.whatsNewData.disableWhatsNewNotifications
        });
      }
    }
  };
  function getLatestWhatsNewPost() {
    provider.channel?.emit(REQUEST_WHATS_NEW_DATA);
    return new Promise(
      (resolve) => provider.channel?.once(
        RESULT_WHATS_NEW_DATA,
        ({ data }) => resolve(data)
      )
    );
  }
  __name(getLatestWhatsNewPost, "getLatestWhatsNewPost");
  function setWhatsNewCache(cache) {
    provider.channel?.emit(SET_WHATS_NEW_CACHE, cache);
  }
  __name(setWhatsNewCache, "setWhatsNewCache");
  const initModule = /* @__PURE__ */ __name(async () => {
    if (global9.CONFIG_TYPE !== "DEVELOPMENT") {
      return;
    }
    const whatsNewData = await getLatestWhatsNewPost();
    setWhatsNewState(whatsNewData);
    const urlState = fullAPI.getUrlState();
    const isOnboardingView = urlState?.path === "/onboarding" || urlState.queryParams?.onboarding === "true";
    if (!isOnboardingView && whatsNewData.status === "SUCCESS" && !whatsNewData.disableWhatsNewNotifications && whatsNewData.showNotification) {
      fullAPI.addNotification({
        id: WHATS_NEW_NOTIFICATION_ID,
        link: "/settings/whats-new",
        content: {
          headline: whatsNewData.title,
          subHeadline: "Learn what's new in Storybook"
        },
        icon: React3.createElement(StorybookIcon, null),
        onClear({ dismissed }) {
          if (dismissed) {
            setWhatsNewCache({ lastDismissedPost: whatsNewData.url });
          }
        }
      });
    }
  }, "initModule");
  return { init: initModule, state, api };
}, "init");

// src/manager-api/store.ts
var import_store2 = __toESM(require_store2(), 1);

// src/manager-api/lib/store-setup.ts
var store_setup_default = /* @__PURE__ */ __name((_) => {
  _.fn("set", function(key, data) {
    return _.set(
      // @ts-expect-error('this' implicitly has type 'any')
      this._area,
      // @ts-expect-error('this' implicitly has type 'any')
      this._in(key),
      stringify(data, { maxDepth: 50 })
    );
  });
  _.fn("get", function(key, alt) {
    const value = _.get(this._area, this._in(key));
    return value !== null ? parse(value) : alt || value;
  });
}, "default");

// src/manager-api/store.ts
store_setup_default(import_store2.default._);
var STORAGE_KEY = "@storybook/manager/store";
function get(storage) {
  const data = storage.get(STORAGE_KEY);
  return data || {};
}
__name(get, "get");
function set(storage, value) {
  return storage.set(STORAGE_KEY, value);
}
__name(set, "set");
function update(storage, patch) {
  const previous = get(storage);
  return set(storage, { ...previous, ...patch });
}
__name(update, "update");
var _Store = class _Store {
  constructor({ setState, getState }) {
    this.upstreamSetState = setState;
    this.upstreamGetState = getState;
  }
  // The assumption is that this will be called once, to initialize the React state
  // when the module is instantiated
  getInitialState(base) {
    return { ...base, ...get(import_store2.default.local), ...get(import_store2.default.session) };
  }
  getState() {
    return this.upstreamGetState();
  }
  async setState(inputPatch, cbOrOptions, inputOptions) {
    let callback;
    let options;
    if (typeof cbOrOptions === "function") {
      callback = cbOrOptions;
      options = inputOptions;
    } else {
      options = cbOrOptions;
    }
    const { persistence = "none" } = options || {};
    let patch = {};
    let delta = {};
    if (typeof inputPatch === "function") {
      patch = /* @__PURE__ */ __name((state) => {
        const getDelta = inputPatch;
        delta = getDelta(state);
        return delta;
      }, "patch");
    } else {
      patch = inputPatch;
      delta = patch;
    }
    const newState = await new Promise((resolve) => {
      this.upstreamSetState(patch, () => {
        resolve(this.getState());
      });
    });
    if (persistence !== "none") {
      const storage = persistence === "session" ? import_store2.default.session : import_store2.default.local;
      await update(storage, delta);
    }
    if (callback) {
      callback(newState);
    }
    return newState;
  }
};
__name(_Store, "Store");
var Store = _Store;

// src/manager-api/lib/request-response.ts
var _RequestResponseError = class _RequestResponseError extends Error {
  constructor(message, payload) {
    super(message);
    this.payload = void 0;
    this.payload = payload;
  }
};
__name(_RequestResponseError, "RequestResponseError");
var RequestResponseError = _RequestResponseError;
var experimental_requestResponse = /* @__PURE__ */ __name((channel, requestEvent, responseEvent, payload, timeout = 5e3) => {
  let timeoutId;
  return new Promise((resolve, reject) => {
    const request = {
      id: Math.random().toString(16).slice(2),
      payload
    };
    const responseHandler = /* @__PURE__ */ __name((response) => {
      if (response.id !== request.id) {
        return;
      }
      clearTimeout(timeoutId);
      channel.off(responseEvent, responseHandler);
      if (response.success) {
        resolve(response.payload);
      } else {
        reject(new RequestResponseError(response.error, response.payload));
      }
    }, "responseHandler");
    channel.emit(requestEvent, request);
    channel.on(responseEvent, responseHandler);
    timeoutId = setTimeout(() => {
      channel.off(responseEvent, responseHandler);
      reject(new RequestResponseError("Timed out waiting for response"));
    }, timeout);
  });
}, "experimental_requestResponse");

// src/manager-api/root.tsx
var { ActiveTabs: ActiveTabs2 } = layout_exports;
var ManagerContext = createContext({ api: void 0, state: initial_state_default({}) });
var combineParameters = /* @__PURE__ */ __name((...parameterSets) => noArrayMerge({}, ...parameterSets), "combineParameters");
var _ManagerProvider = class _ManagerProvider extends Component {
  constructor(props) {
    super(props);
    this.api = {};
    this.initModules = /* @__PURE__ */ __name(() => {
      this.modules.forEach((module) => {
        if ("init" in module) {
          module.init();
        }
      });
    }, "initModules");
    const {
      location: location2,
      path,
      refId,
      viewMode = props.docsOptions.docsMode ? "docs" : props.viewMode,
      singleStory,
      storyId,
      docsOptions,
      navigate
    } = props;
    const store2 = new Store({
      getState: /* @__PURE__ */ __name(() => this.state, "getState"),
      setState: /* @__PURE__ */ __name((stateChange, callback) => {
        this.setState(stateChange, () => callback(this.state));
        return this.state;
      }, "setState")
    });
    const routeData = { location: location2, path, viewMode, singleStory, storyId, refId };
    const optionsData = { docsOptions };
    this.state = store2.getInitialState(initial_state_default({ ...routeData, ...optionsData }));
    const apiData = {
      navigate,
      store: store2,
      provider: props.provider
    };
    this.modules = [
      provider_exports,
      channel_exports,
      addons_exports,
      layout_exports,
      notifications_exports,
      settings_exports,
      shortcuts_exports,
      stories_exports,
      refs_exports,
      globals_exports,
      url_exports,
      versions_exports,
      whatsnew_exports,
      open_in_editor_exports
    ].map(
      (m) => m.init({ ...routeData, ...optionsData, ...apiData, state: this.state, fullAPI: this.api })
    );
    const state = initial_state_default(this.state, ...this.modules.map((m) => m.state));
    const api = Object.assign(this.api, { navigate }, ...this.modules.map((m) => m.api));
    this.state = state;
    this.api = api;
  }
  static getDerivedStateFromProps(props, state) {
    if (state.path !== props.path) {
      return {
        ...state,
        location: props.location,
        path: props.path,
        refId: props.refId,
        viewMode: props.viewMode,
        storyId: props.storyId
      };
    }
    return null;
  }
  shouldComponentUpdate(nextProps, nextState) {
    const prevProps = this.props;
    const prevState = this.state;
    return prevProps.path !== nextProps.path || !isEqual(prevState, nextState);
  }
  render() {
    const { children } = this.props;
    const value = {
      state: this.state,
      api: this.api
    };
    return React4.createElement(EffectOnMount, { effect: this.initModules }, React4.createElement(ManagerContext.Provider, { value }, React4.createElement(ManagerConsumer, null, children)));
  }
};
__name(_ManagerProvider, "ManagerProvider");
_ManagerProvider.displayName = "Manager";
var ManagerProvider = _ManagerProvider;
var EffectOnMount = /* @__PURE__ */ __name(({ children, effect }) => {
  React4.useEffect(effect, []);
  return children;
}, "EffectOnMount");
var defaultFilter = /* @__PURE__ */ __name((c) => c, "defaultFilter");
function ManagerConsumer({
  // @ts-expect-error (Converted from ts-ignore)
  filter = defaultFilter,
  children
}) {
  const managerContext = useContext(ManagerContext);
  const renderer = useRef2(children);
  const filterer = useRef2(filter);
  if (typeof renderer.current !== "function") {
    return React4.createElement(Fragment, null, renderer.current);
  }
  const comboData = filterer.current(managerContext);
  const comboDataArray = useMemo(() => {
    return [...Object.entries(comboData).reduce((acc, keyval) => acc.concat(keyval), [])];
  }, [managerContext.state]);
  return useMemo(() => {
    const Child = renderer.current;
    return React4.createElement(Child, { ...comboData });
  }, comboDataArray);
}
__name(ManagerConsumer, "ManagerConsumer");
function useStorybookState() {
  const { state } = useContext(ManagerContext);
  return state;
}
__name(useStorybookState, "useStorybookState");
function useStorybookApi() {
  const { api } = useContext(ManagerContext);
  return api;
}
__name(useStorybookApi, "useStorybookApi");
function orDefault(fromStore, defaultState) {
  if (typeof fromStore === "undefined") {
    return defaultState;
  }
  return fromStore;
}
__name(orDefault, "orDefault");
var useChannel = /* @__PURE__ */ __name((eventMap, deps = []) => {
  const api = useStorybookApi();
  useEffect(() => {
    Object.entries(eventMap).forEach(([type, listener]) => api.on(type, listener));
    return () => {
      Object.entries(eventMap).forEach(([type, listener]) => api.off(type, listener));
    };
  }, deps);
  return api.emit;
}, "useChannel");
function useStoryPrepared(storyId) {
  const api = useStorybookApi();
  return api.isPrepared(storyId);
}
__name(useStoryPrepared, "useStoryPrepared");
function useParameter(parameterKey, defaultValue) {
  const api = useStorybookApi();
  const [parameter, setParameter] = useState(api.getCurrentParameter(parameterKey));
  const handleParameterChange = useCallback2(() => {
    const newParameter = api.getCurrentParameter(parameterKey);
    setParameter(newParameter);
  }, [api, parameterKey]);
  useChannel(
    {
      [STORY_PREPARED2]: handleParameterChange,
      [DOCS_PREPARED2]: handleParameterChange
    },
    [handleParameterChange]
  );
  return orDefault(parameter, defaultValue);
}
__name(useParameter, "useParameter");
globalThis.STORYBOOK_ADDON_STATE = {};
var { STORYBOOK_ADDON_STATE } = globalThis;
function useSharedState(stateId, defaultState) {
  const api = useStorybookApi();
  const existingState = api.getAddonState(stateId) || STORYBOOK_ADDON_STATE[stateId];
  const state = orDefault(
    existingState,
    STORYBOOK_ADDON_STATE[stateId] ? STORYBOOK_ADDON_STATE[stateId] : defaultState
  );
  let quicksync = false;
  if (state === defaultState && defaultState !== void 0) {
    STORYBOOK_ADDON_STATE[stateId] = defaultState;
    quicksync = true;
  }
  useEffect(() => {
    if (quicksync) {
      api.setAddonState(stateId, defaultState);
    }
  }, [quicksync]);
  const setState = useCallback2(
    async (s, options) => {
      await api.setAddonState(stateId, s, options);
      const result = api.getAddonState(stateId);
      STORYBOOK_ADDON_STATE[stateId] = result;
      return result;
    },
    [api, stateId]
  );
  const allListeners = useMemo(() => {
    const stateChangeHandlers = {
      [`${SHARED_STATE_CHANGED}-client-${stateId}`]: setState,
      [`${SHARED_STATE_SET}-client-${stateId}`]: setState
    };
    const stateInitializationHandlers = {
      [SET_STORIES2]: async () => {
        const currentState = api.getAddonState(stateId);
        if (currentState) {
          STORYBOOK_ADDON_STATE[stateId] = currentState;
          api.emit(`${SHARED_STATE_SET}-manager-${stateId}`, currentState);
        } else if (STORYBOOK_ADDON_STATE[stateId]) {
          await setState(STORYBOOK_ADDON_STATE[stateId]);
          api.emit(`${SHARED_STATE_SET}-manager-${stateId}`, STORYBOOK_ADDON_STATE[stateId]);
        } else if (defaultState !== void 0) {
          await setState(defaultState);
          STORYBOOK_ADDON_STATE[stateId] = defaultState;
          api.emit(`${SHARED_STATE_SET}-manager-${stateId}`, defaultState);
        }
      },
      [STORY_CHANGED2]: () => {
        const currentState = api.getAddonState(stateId);
        if (currentState !== void 0) {
          api.emit(`${SHARED_STATE_SET}-manager-${stateId}`, currentState);
        }
      }
    };
    return {
      ...stateChangeHandlers,
      ...stateInitializationHandlers
    };
  }, [stateId]);
  const emit = useChannel(allListeners);
  const stateSetter = useCallback2(
    async (newStateOrMerger, options) => {
      await setState(newStateOrMerger, options);
      const result = api.getAddonState(stateId);
      emit(`${SHARED_STATE_CHANGED}-manager-${stateId}`, result);
    },
    [api, emit, setState, stateId]
  );
  return [state, stateSetter];
}
__name(useSharedState, "useSharedState");
function useAddonState(addonId, defaultState) {
  return useSharedState(addonId, defaultState);
}
__name(useAddonState, "useAddonState");
function useArgs() {
  const { getCurrentStoryData, updateStoryArgs, resetStoryArgs } = useStorybookApi();
  const data = getCurrentStoryData();
  const args = data?.type === "story" ? data.args : {};
  const initialArgs = data?.type === "story" ? data.initialArgs : {};
  const updateArgs = useCallback2(
    (newArgs) => updateStoryArgs(data, newArgs),
    [data, updateStoryArgs]
  );
  const resetArgs = useCallback2(
    (argNames) => resetStoryArgs(data, argNames),
    [data, resetStoryArgs]
  );
  return [args, updateArgs, resetArgs, initialArgs];
}
__name(useArgs, "useArgs");
function useGlobals() {
  const api = useStorybookApi();
  return [api.getGlobals(), api.updateGlobals, api.getStoryGlobals(), api.getUserGlobals()];
}
__name(useGlobals, "useGlobals");
function useGlobalTypes() {
  return useStorybookApi().getGlobalTypes();
}
__name(useGlobalTypes, "useGlobalTypes");
function useCurrentStory() {
  const { getCurrentStoryData } = useStorybookApi();
  return getCurrentStoryData();
}
__name(useCurrentStory, "useCurrentStory");
function useArgTypes() {
  const current = useCurrentStory();
  return current?.type === "story" && current.argTypes || {};
}
__name(useArgTypes, "useArgTypes");
var typesX = Addon_TypesEnum;

// src/shared/universal-store/mock.ts
import { Channel as Channel2 } from "storybook/internal/channels";
var _MockUniversalStore = class _MockUniversalStore extends UniversalStore {
  constructor(options, testUtils) {
    UniversalStore.isInternalConstructing = true;
    super(
      { ...options, leader: true },
      { channel: new Channel2({}), environment: UniversalStore.Environment.MOCK }
    );
    UniversalStore.isInternalConstructing = false;
    if (typeof testUtils?.fn !== "function") {
      return;
    }
    this.testUtils = testUtils;
    this.getState = testUtils.fn(this.getState);
    this.setState = testUtils.fn(this.setState);
    this.subscribe = testUtils.fn(this.subscribe);
    this.onStateChange = testUtils.fn(this.onStateChange);
    this.send = testUtils.fn(this.send);
  }
  /** Create a mock universal store. This is just an alias for the constructor */
  static create(options, testUtils) {
    return new _MockUniversalStore(options, testUtils);
  }
  unsubscribeAll() {
    if (!this.testUtils) {
      throw new Error(
        dedent`Cannot call unsubscribeAll on a store that does not have testUtils.
        Please provide testUtils as the second argument when creating the store.`
      );
    }
    const callReturnedUnsubscribeFn = /* @__PURE__ */ __name((result) => {
      try {
        result.value();
      } catch (e) {
      }
    }, "callReturnedUnsubscribeFn");
    this.subscribe.mock?.results.forEach(callReturnedUnsubscribeFn);
    this.onStateChange.mock?.results.forEach(callReturnedUnsubscribeFn);
  }
};
__name(_MockUniversalStore, "MockUniversalStore");
var MockUniversalStore = _MockUniversalStore;

// src/shared/test-provider-store/index.ts
var UNIVERSAL_TEST_PROVIDER_STORE_OPTIONS = {
  id: "storybook/test-provider",
  leader: true,
  initialState: {}
};
function createTestProviderStore({
  universalTestProviderStore: universalTestProviderStore2,
  useUniversalStore: useUniversalStore2
}) {
  const baseStore = {
    settingsChanged: /* @__PURE__ */ __name(() => {
      universalTestProviderStore2.untilReady().then(() => {
        universalTestProviderStore2.send({ type: "settings-changed" });
      });
    }, "settingsChanged"),
    onRunAll: /* @__PURE__ */ __name((listener) => universalTestProviderStore2.subscribe("run-all", listener), "onRunAll"),
    onClearAll: /* @__PURE__ */ __name((listener) => universalTestProviderStore2.subscribe("clear-all", listener), "onClearAll")
  };
  const fullTestProviderStore2 = {
    ...baseStore,
    getFullState: universalTestProviderStore2.getState,
    setFullState: universalTestProviderStore2.setState,
    onSettingsChanged: /* @__PURE__ */ __name((listener) => universalTestProviderStore2.subscribe("settings-changed", listener), "onSettingsChanged"),
    runAll: /* @__PURE__ */ __name(async () => {
      await universalTestProviderStore2.untilReady();
      universalTestProviderStore2.send({ type: "run-all" });
    }, "runAll"),
    clearAll: /* @__PURE__ */ __name(async () => {
      await universalTestProviderStore2.untilReady();
      universalTestProviderStore2.send({ type: "clear-all" });
    }, "clearAll")
  };
  const getTestProviderStoreById2 = /* @__PURE__ */ __name((testProviderId) => {
    const getStateForTestProvider = /* @__PURE__ */ __name(() => universalTestProviderStore2.getState()[testProviderId] ?? "test-provider-state:pending", "getStateForTestProvider");
    const setStateForTestProvider = /* @__PURE__ */ __name((state) => {
      universalTestProviderStore2.untilReady().then(() => {
        universalTestProviderStore2.setState((currentState) => ({
          ...currentState,
          [testProviderId]: state
        }));
      });
    }, "setStateForTestProvider");
    return {
      ...baseStore,
      testProviderId,
      getState: getStateForTestProvider,
      setState: setStateForTestProvider,
      runWithState: /* @__PURE__ */ __name(async (callback) => {
        setStateForTestProvider("test-provider-state:running");
        try {
          await callback();
          setStateForTestProvider("test-provider-state:succeeded");
        } catch (error) {
          setStateForTestProvider("test-provider-state:crashed");
        }
      }, "runWithState")
    };
  }, "getTestProviderStoreById");
  if (useUniversalStore2) {
    return {
      getTestProviderStoreById: getTestProviderStoreById2,
      fullTestProviderStore: fullTestProviderStore2,
      universalTestProviderStore: universalTestProviderStore2,
      useTestProviderStore: /* @__PURE__ */ __name((selector) => useUniversalStore2(universalTestProviderStore2, selector)[0], "useTestProviderStore")
    };
  }
  return {
    getTestProviderStoreById: getTestProviderStoreById2,
    fullTestProviderStore: fullTestProviderStore2,
    universalTestProviderStore: universalTestProviderStore2
  };
}
__name(createTestProviderStore, "createTestProviderStore");

// src/manager-api/stores/test-provider.ts
var testProviderStore = createTestProviderStore({
  universalTestProviderStore: UniversalStore.create({
    ...UNIVERSAL_TEST_PROVIDER_STORE_OPTIONS,
    leader: globalThis.CONFIG_TYPE === "PRODUCTION"
  }),
  useUniversalStore
});
var {
  fullTestProviderStore,
  getTestProviderStoreById,
  useTestProviderStore,
  universalTestProviderStore
} = testProviderStore;
export {
  ActiveTabs2 as ActiveTabs,
  ManagerConsumer as Consumer,
  ManagerContext,
  ManagerProvider as Provider,
  RequestResponseError,
  addons,
  combineParameters,
  controlOrMetaKey,
  controlOrMetaSymbol,
  eventMatchesShortcut,
  eventToShortcut,
  MockUniversalStore as experimental_MockUniversalStore,
  UniversalStore as experimental_UniversalStore,
  getStatusStoreByTypeId as experimental_getStatusStore,
  getTestProviderStoreById as experimental_getTestProviderStore,
  experimental_requestResponse,
  useStatusStore as experimental_useStatusStore,
  useTestProviderStore as experimental_useTestProviderStore,
  useUniversalStore as experimental_useUniversalStore,
  fullStatusStore as internal_fullStatusStore,
  fullTestProviderStore as internal_fullTestProviderStore,
  universalStatusStore as internal_universalStatusStore,
  universalTestProviderStore as internal_universalTestProviderStore,
  isMacLike,
  isShortcutTaken,
  keyToSymbol,
  merge_default as merge,
  mockChannel,
  optionOrAltSymbol,
  shortcutMatchesShortcut,
  shortcutToHumanString,
  typesX as types,
  useAddonState,
  useArgTypes,
  useArgs,
  useChannel,
  useGlobalTypes,
  useGlobals,
  useParameter,
  useSharedState,
  useStoryPrepared,
  useStorybookApi,
  useStorybookState
};
