import CJS_COMPAT_NODE_URL_39zvq8kkt8 from 'node:url';
import CJS_COMPAT_NODE_PATH_39zvq8kkt8 from 'node:path';
import CJS_COMPAT_NODE_MODULE_39zvq8kkt8 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_39zvq8kkt8.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_39zvq8kkt8.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_39zvq8kkt8.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  glob
} from "../../_node-chunks/chunk-EGWLH7SG.js";
import {
  slash
} from "../../_node-chunks/chunk-QHYQ5G5G.js";
import {
  __name
} from "../../_node-chunks/chunk-JBW3FROT.js";

// src/core-server/utils/remove-mdx-entries.ts
import { isAbsolute, join, relative } from "node:path";
import { commonGlobOptions, normalizeStories } from "storybook/internal/common";
async function removeMDXEntries(entries, options) {
  const list = normalizeStories(entries, {
    configDir: options.configDir,
    workingDir: options.configDir,
    defaultFilesPattern: "**/*.@(stories.@(js|jsx|mjs|ts|tsx))"
  });
  const result = (await Promise.all(
    list.map(async ({ directory, files, titlePrefix }) => {
      const pattern = join(directory, files);
      const absolutePattern = isAbsolute(pattern) ? pattern : join(options.configDir, pattern);
      const absoluteDirectory = isAbsolute(directory) ? directory : join(options.configDir, directory);
      return {
        files: (await glob(slash(absolutePattern), {
          ...commonGlobOptions(absolutePattern),
          follow: true
        })).map((f) => relative(absoluteDirectory, f)),
        directory,
        titlePrefix
      };
    })
  )).flatMap(({ directory, files, titlePrefix }, i) => {
    const filteredEntries = files.filter((s) => !s.endsWith(".mdx"));
    let items = [];
    if (filteredEntries.length < files.length) {
      items = filteredEntries.map((k) => ({
        directory,
        titlePrefix,
        files: `**/${k}`
      }));
    } else {
      items = [
        { directory: list[i].directory, titlePrefix: list[i].titlePrefix, files: list[i].files }
      ];
    }
    return items;
  });
  return result;
}
__name(removeMDXEntries, "removeMDXEntries");

// src/core-server/presets/common-override-preset.ts
var framework = /* @__PURE__ */ __name(async (config) => {
  const name = typeof config === "string" ? config : config?.name;
  const options = typeof config === "string" ? {} : config?.options || {};
  return {
    name,
    options
  };
}, "framework");
var stories = /* @__PURE__ */ __name(async (entries, options) => {
  if (options?.build?.test?.disableMDXEntries) {
    return removeMDXEntries(entries, options);
  }
  return entries;
}, "stories");
var typescript = /* @__PURE__ */ __name(async (input, options) => {
  if (options?.build?.test?.disableDocgen) {
    return { ...input ?? {}, reactDocgen: false, check: false };
  }
  return input;
}, "typescript");
var createTestBuildFeatures = /* @__PURE__ */ __name((value) => ({
  disableBlocks: value,
  disabledAddons: value ? ["@storybook/addon-docs", "@storybook/addon-essentials/docs", "@storybook/addon-coverage"] : [],
  disableMDXEntries: value,
  disableAutoDocs: value,
  disableDocgen: value,
  disableSourcemaps: value,
  disableTreeShaking: value,
  esbuildMinify: value
}), "createTestBuildFeatures");
var build = /* @__PURE__ */ __name(async (value, options) => {
  return {
    ...value,
    test: options.test ? {
      ...createTestBuildFeatures(!!options.test),
      ...value?.test
    } : createTestBuildFeatures(false)
  };
}, "build");
export {
  build,
  framework,
  stories,
  typescript
};
