import CJS_COMPAT_NODE_URL_39zvq8kkt8 from 'node:url';
import CJS_COMPAT_NODE_PATH_39zvq8kkt8 from 'node:path';
import CJS_COMPAT_NODE_MODULE_39zvq8kkt8 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_39zvq8kkt8.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_39zvq8kkt8.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_39zvq8kkt8.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  detectPnp
} from "../_node-chunks/chunk-K373EZTP.js";
import {
  require_pretty_hrtime
} from "../_node-chunks/chunk-V7ZKSK5R.js";
import {
  boxen,
  require_string_width
} from "../_node-chunks/chunk-VTD5TIUC.js";
import "../_node-chunks/chunk-2JVDNALC.js";
import {
  StatusTypeIdMismatchError,
  StorybookError
} from "../_node-chunks/chunk-OVJEF4RI.js";
import {
  getErrorLevel,
  mapStaticDir,
  parseStaticDir,
  sendTelemetryError,
  useStatics,
  withTelemetry
} from "../_node-chunks/chunk-TKXE3RQ5.js";
import "../_node-chunks/chunk-DPKZQ6YX.js";
import {
  telemetry
} from "../_node-chunks/chunk-4UOXOBHK.js";
import "../_node-chunks/chunk-A3KNZ5FW.js";
import {
  userOrAutoTitleFromSpecifier
} from "../_node-chunks/chunk-FYLSDVSH.js";
import "../_node-chunks/chunk-V4MKEKP7.js";
import "../_node-chunks/chunk-NEOS45YA.js";
import "../_node-chunks/chunk-CWWI6A7W.js";
import {
  optionalEnvToBoolean,
  require_cross_spawn
} from "../_node-chunks/chunk-F6NUZ463.js";
import {
  up2 as up
} from "../_node-chunks/chunk-C4ROO6RE.js";
import "../_node-chunks/chunk-5VYG646K.js";
import {
  invariant
} from "../_node-chunks/chunk-HUKSE3QZ.js";
import {
  importModule,
  resolvePackageDir
} from "../_node-chunks/chunk-425EMBPZ.js";
import {
  join,
  relative,
  resolve
} from "../_node-chunks/chunk-J5R55OCP.js";
import {
  require_prompts
} from "../_node-chunks/chunk-VWYF3SCI.js";
import "../_node-chunks/chunk-EGWLH7SG.js";
import {
  slash
} from "../_node-chunks/chunk-QHYQ5G5G.js";
import {
  require_dist
} from "../_node-chunks/chunk-PK3UILX6.js";
import {
  require_lib,
  require_src
} from "../_node-chunks/chunk-UOLIYXDF.js";
import {
  require_picocolors
} from "../_node-chunks/chunk-4WKJYHSS.js";
import {
  __commonJS,
  __name,
  __require,
  __toESM
} from "../_node-chunks/chunk-JBW3FROT.js";

// ../node_modules/tsconfig-paths/lib/filesystem.js
var require_filesystem = __commonJS({
  "../node_modules/tsconfig-paths/lib/filesystem.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.removeExtension = exports.fileExistsAsync = exports.readJsonFromDiskAsync = exports.readJsonFromDiskSync = exports.fileExistsSync = void 0;
    var fs6 = __require("fs");
    function fileExistsSync(path2) {
      if (!fs6.existsSync(path2)) {
        return false;
      }
      try {
        var stats = fs6.statSync(path2);
        return stats.isFile();
      } catch (err) {
        return false;
      }
    }
    __name(fileExistsSync, "fileExistsSync");
    exports.fileExistsSync = fileExistsSync;
    function readJsonFromDiskSync(packageJsonPath) {
      if (!fs6.existsSync(packageJsonPath)) {
        return void 0;
      }
      return __require(packageJsonPath);
    }
    __name(readJsonFromDiskSync, "readJsonFromDiskSync");
    exports.readJsonFromDiskSync = readJsonFromDiskSync;
    function readJsonFromDiskAsync(path2, callback) {
      fs6.readFile(path2, "utf8", function(err, result) {
        if (err || !result) {
          return callback();
        }
        var json = JSON.parse(result);
        return callback(void 0, json);
      });
    }
    __name(readJsonFromDiskAsync, "readJsonFromDiskAsync");
    exports.readJsonFromDiskAsync = readJsonFromDiskAsync;
    function fileExistsAsync(path2, callback2) {
      fs6.stat(path2, function(err, stats) {
        if (err) {
          return callback2(void 0, false);
        }
        callback2(void 0, stats ? stats.isFile() : false);
      });
    }
    __name(fileExistsAsync, "fileExistsAsync");
    exports.fileExistsAsync = fileExistsAsync;
    function removeExtension(path2) {
      return path2.substring(0, path2.lastIndexOf(".")) || path2;
    }
    __name(removeExtension, "removeExtension");
    exports.removeExtension = removeExtension;
  }
});

// ../node_modules/tsconfig-paths/lib/mapping-entry.js
var require_mapping_entry = __commonJS({
  "../node_modules/tsconfig-paths/lib/mapping-entry.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getAbsoluteMappingEntries = void 0;
    var path2 = __require("path");
    function getAbsoluteMappingEntries(absoluteBaseUrl, paths, addMatchAll) {
      var sortedKeys = sortByLongestPrefix(Object.keys(paths));
      var absolutePaths = [];
      for (var _i = 0, sortedKeys_1 = sortedKeys; _i < sortedKeys_1.length; _i++) {
        var key = sortedKeys_1[_i];
        absolutePaths.push({
          pattern: key,
          paths: paths[key].map(function(pathToResolve) {
            return path2.resolve(absoluteBaseUrl, pathToResolve);
          })
        });
      }
      if (!paths["*"] && addMatchAll) {
        absolutePaths.push({
          pattern: "*",
          paths: ["".concat(absoluteBaseUrl.replace(/\/$/, ""), "/*")]
        });
      }
      return absolutePaths;
    }
    __name(getAbsoluteMappingEntries, "getAbsoluteMappingEntries");
    exports.getAbsoluteMappingEntries = getAbsoluteMappingEntries;
    function sortByLongestPrefix(arr) {
      return arr.concat().sort(function(a, b) {
        return getPrefixLength(b) - getPrefixLength(a);
      });
    }
    __name(sortByLongestPrefix, "sortByLongestPrefix");
    function getPrefixLength(pattern) {
      var prefixLength = pattern.indexOf("*");
      return pattern.substr(0, prefixLength).length;
    }
    __name(getPrefixLength, "getPrefixLength");
  }
});

// ../node_modules/tsconfig-paths/lib/try-path.js
var require_try_path = __commonJS({
  "../node_modules/tsconfig-paths/lib/try-path.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.exhaustiveTypeException = exports.getStrippedPath = exports.getPathsToTry = void 0;
    var path2 = __require("path");
    var path_1 = __require("path");
    var filesystem_1 = require_filesystem();
    function getPathsToTry(extensions, absolutePathMappings, requestedModule) {
      if (!absolutePathMappings || !requestedModule || requestedModule[0] === ".") {
        return void 0;
      }
      var pathsToTry = [];
      for (var _i = 0, absolutePathMappings_1 = absolutePathMappings; _i < absolutePathMappings_1.length; _i++) {
        var entry = absolutePathMappings_1[_i];
        var starMatch = entry.pattern === requestedModule ? "" : matchStar(entry.pattern, requestedModule);
        if (starMatch !== void 0) {
          var _loop_1 = /* @__PURE__ */ __name(function(physicalPathPattern2) {
            var physicalPath = physicalPathPattern2.replace("*", starMatch);
            pathsToTry.push({ type: "file", path: physicalPath });
            pathsToTry.push.apply(pathsToTry, extensions.map(function(e) {
              return { type: "extension", path: physicalPath + e };
            }));
            pathsToTry.push({
              type: "package",
              path: path2.join(physicalPath, "/package.json")
            });
            var indexPath = path2.join(physicalPath, "/index");
            pathsToTry.push.apply(pathsToTry, extensions.map(function(e) {
              return { type: "index", path: indexPath + e };
            }));
          }, "_loop_1");
          for (var _a = 0, _b = entry.paths; _a < _b.length; _a++) {
            var physicalPathPattern = _b[_a];
            _loop_1(physicalPathPattern);
          }
        }
      }
      return pathsToTry.length === 0 ? void 0 : pathsToTry;
    }
    __name(getPathsToTry, "getPathsToTry");
    exports.getPathsToTry = getPathsToTry;
    function getStrippedPath(tryPath) {
      return tryPath.type === "index" ? (0, path_1.dirname)(tryPath.path) : tryPath.type === "file" ? tryPath.path : tryPath.type === "extension" ? (0, filesystem_1.removeExtension)(tryPath.path) : tryPath.type === "package" ? tryPath.path : exhaustiveTypeException(tryPath.type);
    }
    __name(getStrippedPath, "getStrippedPath");
    exports.getStrippedPath = getStrippedPath;
    function exhaustiveTypeException(check) {
      throw new Error("Unknown type ".concat(check));
    }
    __name(exhaustiveTypeException, "exhaustiveTypeException");
    exports.exhaustiveTypeException = exhaustiveTypeException;
    function matchStar(pattern, search) {
      if (search.length < pattern.length) {
        return void 0;
      }
      if (pattern === "*") {
        return search;
      }
      var star = pattern.indexOf("*");
      if (star === -1) {
        return void 0;
      }
      var part1 = pattern.substring(0, star);
      var part2 = pattern.substring(star + 1);
      if (search.substr(0, star) !== part1) {
        return void 0;
      }
      if (search.substr(search.length - part2.length) !== part2) {
        return void 0;
      }
      return search.substr(star, search.length - part2.length);
    }
    __name(matchStar, "matchStar");
  }
});

// ../node_modules/tsconfig-paths/lib/match-path-sync.js
var require_match_path_sync = __commonJS({
  "../node_modules/tsconfig-paths/lib/match-path-sync.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.matchFromAbsolutePaths = exports.createMatchPath = void 0;
    var path2 = __require("path");
    var Filesystem = require_filesystem();
    var MappingEntry = require_mapping_entry();
    var TryPath = require_try_path();
    function createMatchPath2(absoluteBaseUrl, paths, mainFields, addMatchAll) {
      if (mainFields === void 0) {
        mainFields = ["main"];
      }
      if (addMatchAll === void 0) {
        addMatchAll = true;
      }
      var absolutePaths = MappingEntry.getAbsoluteMappingEntries(absoluteBaseUrl, paths, addMatchAll);
      return function(requestedModule, readJson, fileExists2, extensions) {
        return matchFromAbsolutePaths(absolutePaths, requestedModule, readJson, fileExists2, extensions, mainFields);
      };
    }
    __name(createMatchPath2, "createMatchPath");
    exports.createMatchPath = createMatchPath2;
    function matchFromAbsolutePaths(absolutePathMappings, requestedModule, readJson, fileExists2, extensions, mainFields) {
      if (readJson === void 0) {
        readJson = Filesystem.readJsonFromDiskSync;
      }
      if (fileExists2 === void 0) {
        fileExists2 = Filesystem.fileExistsSync;
      }
      if (extensions === void 0) {
        extensions = Object.keys(__require.extensions);
      }
      if (mainFields === void 0) {
        mainFields = ["main"];
      }
      var tryPaths = TryPath.getPathsToTry(extensions, absolutePathMappings, requestedModule);
      if (!tryPaths) {
        return void 0;
      }
      return findFirstExistingPath(tryPaths, readJson, fileExists2, mainFields);
    }
    __name(matchFromAbsolutePaths, "matchFromAbsolutePaths");
    exports.matchFromAbsolutePaths = matchFromAbsolutePaths;
    function findFirstExistingMainFieldMappedFile(packageJson, mainFields, packageJsonPath, fileExists2) {
      for (var index = 0; index < mainFields.length; index++) {
        var mainFieldSelector = mainFields[index];
        var candidateMapping = typeof mainFieldSelector === "string" ? packageJson[mainFieldSelector] : mainFieldSelector.reduce(function(obj, key) {
          return obj[key];
        }, packageJson);
        if (candidateMapping && typeof candidateMapping === "string") {
          var candidateFilePath = path2.join(path2.dirname(packageJsonPath), candidateMapping);
          if (fileExists2(candidateFilePath)) {
            return candidateFilePath;
          }
        }
      }
      return void 0;
    }
    __name(findFirstExistingMainFieldMappedFile, "findFirstExistingMainFieldMappedFile");
    function findFirstExistingPath(tryPaths, readJson, fileExists2, mainFields) {
      if (readJson === void 0) {
        readJson = Filesystem.readJsonFromDiskSync;
      }
      if (mainFields === void 0) {
        mainFields = ["main"];
      }
      for (var _i = 0, tryPaths_1 = tryPaths; _i < tryPaths_1.length; _i++) {
        var tryPath = tryPaths_1[_i];
        if (tryPath.type === "file" || tryPath.type === "extension" || tryPath.type === "index") {
          if (fileExists2(tryPath.path)) {
            return TryPath.getStrippedPath(tryPath);
          }
        } else if (tryPath.type === "package") {
          var packageJson = readJson(tryPath.path);
          if (packageJson) {
            var mainFieldMappedFile = findFirstExistingMainFieldMappedFile(packageJson, mainFields, tryPath.path, fileExists2);
            if (mainFieldMappedFile) {
              return mainFieldMappedFile;
            }
          }
        } else {
          TryPath.exhaustiveTypeException(tryPath.type);
        }
      }
      return void 0;
    }
    __name(findFirstExistingPath, "findFirstExistingPath");
  }
});

// ../node_modules/tsconfig-paths/lib/match-path-async.js
var require_match_path_async = __commonJS({
  "../node_modules/tsconfig-paths/lib/match-path-async.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.matchFromAbsolutePathsAsync = exports.createMatchPathAsync = void 0;
    var path2 = __require("path");
    var TryPath = require_try_path();
    var MappingEntry = require_mapping_entry();
    var Filesystem = require_filesystem();
    function createMatchPathAsync(absoluteBaseUrl, paths, mainFields, addMatchAll) {
      if (mainFields === void 0) {
        mainFields = ["main"];
      }
      if (addMatchAll === void 0) {
        addMatchAll = true;
      }
      var absolutePaths = MappingEntry.getAbsoluteMappingEntries(absoluteBaseUrl, paths, addMatchAll);
      return function(requestedModule, readJson, fileExists2, extensions, callback) {
        return matchFromAbsolutePathsAsync(absolutePaths, requestedModule, readJson, fileExists2, extensions, callback, mainFields);
      };
    }
    __name(createMatchPathAsync, "createMatchPathAsync");
    exports.createMatchPathAsync = createMatchPathAsync;
    function matchFromAbsolutePathsAsync(absolutePathMappings, requestedModule, readJson, fileExists2, extensions, callback, mainFields) {
      if (readJson === void 0) {
        readJson = Filesystem.readJsonFromDiskAsync;
      }
      if (fileExists2 === void 0) {
        fileExists2 = Filesystem.fileExistsAsync;
      }
      if (extensions === void 0) {
        extensions = Object.keys(__require.extensions);
      }
      if (mainFields === void 0) {
        mainFields = ["main"];
      }
      var tryPaths = TryPath.getPathsToTry(extensions, absolutePathMappings, requestedModule);
      if (!tryPaths) {
        return callback();
      }
      findFirstExistingPath(tryPaths, readJson, fileExists2, callback, 0, mainFields);
    }
    __name(matchFromAbsolutePathsAsync, "matchFromAbsolutePathsAsync");
    exports.matchFromAbsolutePathsAsync = matchFromAbsolutePathsAsync;
    function findFirstExistingMainFieldMappedFile(packageJson, mainFields, packageJsonPath, fileExistsAsync, doneCallback, index) {
      if (index === void 0) {
        index = 0;
      }
      if (index >= mainFields.length) {
        return doneCallback(void 0, void 0);
      }
      var tryNext = /* @__PURE__ */ __name(function() {
        return findFirstExistingMainFieldMappedFile(packageJson, mainFields, packageJsonPath, fileExistsAsync, doneCallback, index + 1);
      }, "tryNext");
      var mainFieldSelector = mainFields[index];
      var mainFieldMapping = typeof mainFieldSelector === "string" ? packageJson[mainFieldSelector] : mainFieldSelector.reduce(function(obj, key) {
        return obj[key];
      }, packageJson);
      if (typeof mainFieldMapping !== "string") {
        return tryNext();
      }
      var mappedFilePath = path2.join(path2.dirname(packageJsonPath), mainFieldMapping);
      fileExistsAsync(mappedFilePath, function(err, exists) {
        if (err) {
          return doneCallback(err);
        }
        if (exists) {
          return doneCallback(void 0, mappedFilePath);
        }
        return tryNext();
      });
    }
    __name(findFirstExistingMainFieldMappedFile, "findFirstExistingMainFieldMappedFile");
    function findFirstExistingPath(tryPaths, readJson, fileExists2, doneCallback, index, mainFields) {
      if (index === void 0) {
        index = 0;
      }
      if (mainFields === void 0) {
        mainFields = ["main"];
      }
      var tryPath = tryPaths[index];
      if (tryPath.type === "file" || tryPath.type === "extension" || tryPath.type === "index") {
        fileExists2(tryPath.path, function(err, exists) {
          if (err) {
            return doneCallback(err);
          }
          if (exists) {
            return doneCallback(void 0, TryPath.getStrippedPath(tryPath));
          }
          if (index === tryPaths.length - 1) {
            return doneCallback();
          }
          return findFirstExistingPath(tryPaths, readJson, fileExists2, doneCallback, index + 1, mainFields);
        });
      } else if (tryPath.type === "package") {
        readJson(tryPath.path, function(err, packageJson) {
          if (err) {
            return doneCallback(err);
          }
          if (packageJson) {
            return findFirstExistingMainFieldMappedFile(packageJson, mainFields, tryPath.path, fileExists2, function(mainFieldErr, mainFieldMappedFile) {
              if (mainFieldErr) {
                return doneCallback(mainFieldErr);
              }
              if (mainFieldMappedFile) {
                return doneCallback(void 0, mainFieldMappedFile);
              }
              return findFirstExistingPath(tryPaths, readJson, fileExists2, doneCallback, index + 1, mainFields);
            });
          }
          return findFirstExistingPath(tryPaths, readJson, fileExists2, doneCallback, index + 1, mainFields);
        });
      } else {
        TryPath.exhaustiveTypeException(tryPath.type);
      }
    }
    __name(findFirstExistingPath, "findFirstExistingPath");
  }
});

// ../node_modules/strip-bom/index.js
var require_strip_bom = __commonJS({
  "../node_modules/strip-bom/index.js"(exports, module) {
    "use strict";
    module.exports = (x) => {
      if (typeof x !== "string") {
        throw new TypeError("Expected a string, got " + typeof x);
      }
      if (x.charCodeAt(0) === 65279) {
        return x.slice(1);
      }
      return x;
    };
  }
});

// ../node_modules/tsconfig-paths/lib/tsconfig-loader.js
var require_tsconfig_loader = __commonJS({
  "../node_modules/tsconfig-paths/lib/tsconfig-loader.js"(exports) {
    "use strict";
    var __assign = exports && exports.__assign || function() {
      __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
        }
        return t;
      };
      return __assign.apply(this, arguments);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loadTsconfig = exports.walkForTsConfig = exports.tsConfigLoader = void 0;
    var path2 = __require("path");
    var fs6 = __require("fs");
    var JSON5 = require_lib();
    var StripBom = require_strip_bom();
    function tsConfigLoader(_a) {
      var getEnv = _a.getEnv, cwd = _a.cwd, _b = _a.loadSync, loadSync = _b === void 0 ? loadSyncDefault : _b;
      var TS_NODE_PROJECT = getEnv("TS_NODE_PROJECT");
      var TS_NODE_BASEURL = getEnv("TS_NODE_BASEURL");
      var loadResult = loadSync(cwd, TS_NODE_PROJECT, TS_NODE_BASEURL);
      return loadResult;
    }
    __name(tsConfigLoader, "tsConfigLoader");
    exports.tsConfigLoader = tsConfigLoader;
    function loadSyncDefault(cwd, filename, baseUrl) {
      var configPath = resolveConfigPath(cwd, filename);
      if (!configPath) {
        return {
          tsConfigPath: void 0,
          baseUrl: void 0,
          paths: void 0
        };
      }
      var config = loadTsconfig(configPath);
      return {
        tsConfigPath: configPath,
        baseUrl: baseUrl || config && config.compilerOptions && config.compilerOptions.baseUrl,
        paths: config && config.compilerOptions && config.compilerOptions.paths
      };
    }
    __name(loadSyncDefault, "loadSyncDefault");
    function resolveConfigPath(cwd, filename) {
      if (filename) {
        var absolutePath = fs6.lstatSync(filename).isDirectory() ? path2.resolve(filename, "./tsconfig.json") : path2.resolve(cwd, filename);
        return absolutePath;
      }
      if (fs6.statSync(cwd).isFile()) {
        return path2.resolve(cwd);
      }
      var configAbsolutePath = walkForTsConfig(cwd);
      return configAbsolutePath ? path2.resolve(configAbsolutePath) : void 0;
    }
    __name(resolveConfigPath, "resolveConfigPath");
    function walkForTsConfig(directory, readdirSync2) {
      if (readdirSync2 === void 0) {
        readdirSync2 = fs6.readdirSync;
      }
      var files = readdirSync2(directory);
      var filesToCheck = ["tsconfig.json", "jsconfig.json"];
      for (var _i = 0, filesToCheck_1 = filesToCheck; _i < filesToCheck_1.length; _i++) {
        var fileToCheck = filesToCheck_1[_i];
        if (files.indexOf(fileToCheck) !== -1) {
          return path2.join(directory, fileToCheck);
        }
      }
      var parentDirectory = path2.dirname(directory);
      if (directory === parentDirectory) {
        return void 0;
      }
      return walkForTsConfig(parentDirectory, readdirSync2);
    }
    __name(walkForTsConfig, "walkForTsConfig");
    exports.walkForTsConfig = walkForTsConfig;
    function loadTsconfig(configFilePath, existsSync3, readFileSync) {
      if (existsSync3 === void 0) {
        existsSync3 = fs6.existsSync;
      }
      if (readFileSync === void 0) {
        readFileSync = /* @__PURE__ */ __name(function(filename) {
          return fs6.readFileSync(filename, "utf8");
        }, "readFileSync");
      }
      if (!existsSync3(configFilePath)) {
        return void 0;
      }
      var configString = readFileSync(configFilePath);
      var cleanedJson = StripBom(configString);
      var config;
      try {
        config = JSON5.parse(cleanedJson);
      } catch (e) {
        throw new Error("".concat(configFilePath, " is malformed ").concat(e.message));
      }
      var extendedConfig = config.extends;
      if (extendedConfig) {
        var base = void 0;
        if (Array.isArray(extendedConfig)) {
          base = extendedConfig.reduce(function(currBase, extendedConfigElement) {
            return mergeTsconfigs(currBase, loadTsconfigFromExtends(configFilePath, extendedConfigElement, existsSync3, readFileSync));
          }, {});
        } else {
          base = loadTsconfigFromExtends(configFilePath, extendedConfig, existsSync3, readFileSync);
        }
        return mergeTsconfigs(base, config);
      }
      return config;
    }
    __name(loadTsconfig, "loadTsconfig");
    exports.loadTsconfig = loadTsconfig;
    function loadTsconfigFromExtends(configFilePath, extendedConfigValue, existsSync3, readFileSync) {
      var _a;
      if (typeof extendedConfigValue === "string" && extendedConfigValue.indexOf(".json") === -1) {
        extendedConfigValue += ".json";
      }
      var currentDir = path2.dirname(configFilePath);
      var extendedConfigPath = path2.join(currentDir, extendedConfigValue);
      if (extendedConfigValue.indexOf("/") !== -1 && extendedConfigValue.indexOf(".") !== -1 && !existsSync3(extendedConfigPath)) {
        extendedConfigPath = path2.join(currentDir, "node_modules", extendedConfigValue);
      }
      var config = loadTsconfig(extendedConfigPath, existsSync3, readFileSync) || {};
      if ((_a = config.compilerOptions) === null || _a === void 0 ? void 0 : _a.baseUrl) {
        var extendsDir = path2.dirname(extendedConfigValue);
        config.compilerOptions.baseUrl = path2.join(extendsDir, config.compilerOptions.baseUrl);
      }
      return config;
    }
    __name(loadTsconfigFromExtends, "loadTsconfigFromExtends");
    function mergeTsconfigs(base, config) {
      base = base || {};
      config = config || {};
      return __assign(__assign(__assign({}, base), config), { compilerOptions: __assign(__assign({}, base.compilerOptions), config.compilerOptions) });
    }
    __name(mergeTsconfigs, "mergeTsconfigs");
  }
});

// ../node_modules/tsconfig-paths/lib/config-loader.js
var require_config_loader = __commonJS({
  "../node_modules/tsconfig-paths/lib/config-loader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.configLoader = exports.loadConfig = void 0;
    var TsConfigLoader2 = require_tsconfig_loader();
    var path2 = __require("path");
    function loadConfig3(cwd) {
      if (cwd === void 0) {
        cwd = process.cwd();
      }
      return configLoader({ cwd });
    }
    __name(loadConfig3, "loadConfig");
    exports.loadConfig = loadConfig3;
    function configLoader(_a) {
      var cwd = _a.cwd, explicitParams = _a.explicitParams, _b = _a.tsConfigLoader, tsConfigLoader = _b === void 0 ? TsConfigLoader2.tsConfigLoader : _b;
      if (explicitParams) {
        var absoluteBaseUrl = path2.isAbsolute(explicitParams.baseUrl) ? explicitParams.baseUrl : path2.join(cwd, explicitParams.baseUrl);
        return {
          resultType: "success",
          configFileAbsolutePath: "",
          baseUrl: explicitParams.baseUrl,
          absoluteBaseUrl,
          paths: explicitParams.paths,
          mainFields: explicitParams.mainFields,
          addMatchAll: explicitParams.addMatchAll
        };
      }
      var loadResult = tsConfigLoader({
        cwd,
        getEnv: /* @__PURE__ */ __name(function(key) {
          return process.env[key];
        }, "getEnv")
      });
      if (!loadResult.tsConfigPath) {
        return {
          resultType: "failed",
          message: "Couldn't find tsconfig.json"
        };
      }
      return {
        resultType: "success",
        configFileAbsolutePath: loadResult.tsConfigPath,
        baseUrl: loadResult.baseUrl,
        absoluteBaseUrl: path2.resolve(path2.dirname(loadResult.tsConfigPath), loadResult.baseUrl || ""),
        paths: loadResult.paths || {},
        addMatchAll: loadResult.baseUrl !== void 0
      };
    }
    __name(configLoader, "configLoader");
    exports.configLoader = configLoader;
  }
});

// ../node_modules/minimist/index.js
var require_minimist = __commonJS({
  "../node_modules/minimist/index.js"(exports, module) {
    "use strict";
    function hasKey(obj, keys) {
      var o = obj;
      keys.slice(0, -1).forEach(function(key2) {
        o = o[key2] || {};
      });
      var key = keys[keys.length - 1];
      return key in o;
    }
    __name(hasKey, "hasKey");
    function isNumber(x) {
      if (typeof x === "number") {
        return true;
      }
      if (/^0x[0-9a-f]+$/i.test(x)) {
        return true;
      }
      return /^[-+]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(x);
    }
    __name(isNumber, "isNumber");
    function isConstructorOrProto(obj, key) {
      return key === "constructor" && typeof obj[key] === "function" || key === "__proto__";
    }
    __name(isConstructorOrProto, "isConstructorOrProto");
    module.exports = function(args, opts) {
      if (!opts) {
        opts = {};
      }
      var flags = {
        bools: {},
        strings: {},
        unknownFn: null
      };
      if (typeof opts.unknown === "function") {
        flags.unknownFn = opts.unknown;
      }
      if (typeof opts.boolean === "boolean" && opts.boolean) {
        flags.allBools = true;
      } else {
        [].concat(opts.boolean).filter(Boolean).forEach(function(key2) {
          flags.bools[key2] = true;
        });
      }
      var aliases = {};
      function aliasIsBoolean(key2) {
        return aliases[key2].some(function(x) {
          return flags.bools[x];
        });
      }
      __name(aliasIsBoolean, "aliasIsBoolean");
      Object.keys(opts.alias || {}).forEach(function(key2) {
        aliases[key2] = [].concat(opts.alias[key2]);
        aliases[key2].forEach(function(x) {
          aliases[x] = [key2].concat(aliases[key2].filter(function(y) {
            return x !== y;
          }));
        });
      });
      [].concat(opts.string).filter(Boolean).forEach(function(key2) {
        flags.strings[key2] = true;
        if (aliases[key2]) {
          [].concat(aliases[key2]).forEach(function(k) {
            flags.strings[k] = true;
          });
        }
      });
      var defaults = opts.default || {};
      var argv = { _: [] };
      function argDefined(key2, arg2) {
        return flags.allBools && /^--[^=]+$/.test(arg2) || flags.strings[key2] || flags.bools[key2] || aliases[key2];
      }
      __name(argDefined, "argDefined");
      function setKey(obj, keys, value2) {
        var o = obj;
        for (var i2 = 0; i2 < keys.length - 1; i2++) {
          var key2 = keys[i2];
          if (isConstructorOrProto(o, key2)) {
            return;
          }
          if (o[key2] === void 0) {
            o[key2] = {};
          }
          if (o[key2] === Object.prototype || o[key2] === Number.prototype || o[key2] === String.prototype) {
            o[key2] = {};
          }
          if (o[key2] === Array.prototype) {
            o[key2] = [];
          }
          o = o[key2];
        }
        var lastKey = keys[keys.length - 1];
        if (isConstructorOrProto(o, lastKey)) {
          return;
        }
        if (o === Object.prototype || o === Number.prototype || o === String.prototype) {
          o = {};
        }
        if (o === Array.prototype) {
          o = [];
        }
        if (o[lastKey] === void 0 || flags.bools[lastKey] || typeof o[lastKey] === "boolean") {
          o[lastKey] = value2;
        } else if (Array.isArray(o[lastKey])) {
          o[lastKey].push(value2);
        } else {
          o[lastKey] = [o[lastKey], value2];
        }
      }
      __name(setKey, "setKey");
      function setArg(key2, val, arg2) {
        if (arg2 && flags.unknownFn && !argDefined(key2, arg2)) {
          if (flags.unknownFn(arg2) === false) {
            return;
          }
        }
        var value2 = !flags.strings[key2] && isNumber(val) ? Number(val) : val;
        setKey(argv, key2.split("."), value2);
        (aliases[key2] || []).forEach(function(x) {
          setKey(argv, x.split("."), value2);
        });
      }
      __name(setArg, "setArg");
      Object.keys(flags.bools).forEach(function(key2) {
        setArg(key2, defaults[key2] === void 0 ? false : defaults[key2]);
      });
      var notFlags = [];
      if (args.indexOf("--") !== -1) {
        notFlags = args.slice(args.indexOf("--") + 1);
        args = args.slice(0, args.indexOf("--"));
      }
      for (var i = 0; i < args.length; i++) {
        var arg = args[i];
        var key;
        var next;
        if (/^--.+=/.test(arg)) {
          var m = arg.match(/^--([^=]+)=([\s\S]*)$/);
          key = m[1];
          var value = m[2];
          if (flags.bools[key]) {
            value = value !== "false";
          }
          setArg(key, value, arg);
        } else if (/^--no-.+/.test(arg)) {
          key = arg.match(/^--no-(.+)/)[1];
          setArg(key, false, arg);
        } else if (/^--.+/.test(arg)) {
          key = arg.match(/^--(.+)/)[1];
          next = args[i + 1];
          if (next !== void 0 && !/^(-|--)[^-]/.test(next) && !flags.bools[key] && !flags.allBools && (aliases[key] ? !aliasIsBoolean(key) : true)) {
            setArg(key, next, arg);
            i += 1;
          } else if (/^(true|false)$/.test(next)) {
            setArg(key, next === "true", arg);
            i += 1;
          } else {
            setArg(key, flags.strings[key] ? "" : true, arg);
          }
        } else if (/^-[^-]+/.test(arg)) {
          var letters = arg.slice(1, -1).split("");
          var broken = false;
          for (var j = 0; j < letters.length; j++) {
            next = arg.slice(j + 2);
            if (next === "-") {
              setArg(letters[j], next, arg);
              continue;
            }
            if (/[A-Za-z]/.test(letters[j]) && next[0] === "=") {
              setArg(letters[j], next.slice(1), arg);
              broken = true;
              break;
            }
            if (/[A-Za-z]/.test(letters[j]) && /-?\d+(\.\d*)?(e-?\d+)?$/.test(next)) {
              setArg(letters[j], next, arg);
              broken = true;
              break;
            }
            if (letters[j + 1] && letters[j + 1].match(/\W/)) {
              setArg(letters[j], arg.slice(j + 2), arg);
              broken = true;
              break;
            } else {
              setArg(letters[j], flags.strings[letters[j]] ? "" : true, arg);
            }
          }
          key = arg.slice(-1)[0];
          if (!broken && key !== "-") {
            if (args[i + 1] && !/^(-|--)[^-]/.test(args[i + 1]) && !flags.bools[key] && (aliases[key] ? !aliasIsBoolean(key) : true)) {
              setArg(key, args[i + 1], arg);
              i += 1;
            } else if (args[i + 1] && /^(true|false)$/.test(args[i + 1])) {
              setArg(key, args[i + 1] === "true", arg);
              i += 1;
            } else {
              setArg(key, flags.strings[key] ? "" : true, arg);
            }
          }
        } else {
          if (!flags.unknownFn || flags.unknownFn(arg) !== false) {
            argv._.push(flags.strings._ || !isNumber(arg) ? arg : Number(arg));
          }
          if (opts.stopEarly) {
            argv._.push.apply(argv._, args.slice(i + 1));
            break;
          }
        }
      }
      Object.keys(defaults).forEach(function(k) {
        if (!hasKey(argv, k.split("."))) {
          setKey(argv, k.split("."), defaults[k]);
          (aliases[k] || []).forEach(function(x) {
            setKey(argv, x.split("."), defaults[k]);
          });
        }
      });
      if (opts["--"]) {
        argv["--"] = notFlags.slice();
      } else {
        notFlags.forEach(function(k) {
          argv._.push(k);
        });
      }
      return argv;
    };
  }
});

// ../node_modules/tsconfig-paths/lib/register.js
var require_register = __commonJS({
  "../node_modules/tsconfig-paths/lib/register.js"(exports) {
    "use strict";
    var __spreadArray = exports && exports.__spreadArray || function(to, from, pack) {
      if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
        }
      }
      return to.concat(ar || Array.prototype.slice.call(from));
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.register = void 0;
    var match_path_sync_1 = require_match_path_sync();
    var config_loader_1 = require_config_loader();
    var noOp = /* @__PURE__ */ __name(function() {
      return void 0;
    }, "noOp");
    function getCoreModules(builtinModules) {
      builtinModules = builtinModules || [
        "assert",
        "buffer",
        "child_process",
        "cluster",
        "crypto",
        "dgram",
        "dns",
        "domain",
        "events",
        "fs",
        "http",
        "https",
        "net",
        "os",
        "path",
        "punycode",
        "querystring",
        "readline",
        "stream",
        "string_decoder",
        "tls",
        "tty",
        "url",
        "util",
        "v8",
        "vm",
        "zlib"
      ];
      var coreModules = {};
      for (var _i = 0, builtinModules_1 = builtinModules; _i < builtinModules_1.length; _i++) {
        var module_1 = builtinModules_1[_i];
        coreModules[module_1] = true;
      }
      return coreModules;
    }
    __name(getCoreModules, "getCoreModules");
    function register(params) {
      var cwd;
      var explicitParams;
      if (params) {
        cwd = params.cwd;
        if (params.baseUrl || params.paths) {
          explicitParams = params;
        }
      } else {
        var minimist = require_minimist();
        var argv = minimist(process.argv.slice(2), {
          // eslint-disable-next-line id-denylist
          string: ["project"],
          alias: {
            project: ["P"]
          }
        });
        cwd = argv.project;
      }
      var configLoaderResult = (0, config_loader_1.configLoader)({
        cwd: cwd !== null && cwd !== void 0 ? cwd : process.cwd(),
        explicitParams
      });
      if (configLoaderResult.resultType === "failed") {
        console.warn("".concat(configLoaderResult.message, ". tsconfig-paths will be skipped"));
        return noOp;
      }
      var matchPath = (0, match_path_sync_1.createMatchPath)(configLoaderResult.absoluteBaseUrl, configLoaderResult.paths, configLoaderResult.mainFields, configLoaderResult.addMatchAll);
      var Module = __require("module");
      var originalResolveFilename = Module._resolveFilename;
      var coreModules = getCoreModules(Module.builtinModules);
      Module._resolveFilename = function(request, _parent) {
        var isCoreModule = coreModules.hasOwnProperty(request);
        if (!isCoreModule) {
          var found = matchPath(request);
          if (found) {
            var modifiedArguments = __spreadArray([found], [].slice.call(arguments, 1), true);
            return originalResolveFilename.apply(this, modifiedArguments);
          }
        }
        return originalResolveFilename.apply(this, arguments);
      };
      return function() {
        Module._resolveFilename = originalResolveFilename;
      };
    }
    __name(register, "register");
    exports.register = register;
  }
});

// ../node_modules/tsconfig-paths/lib/index.js
var require_lib2 = __commonJS({
  "../node_modules/tsconfig-paths/lib/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loadConfig = exports.register = exports.matchFromAbsolutePathsAsync = exports.createMatchPathAsync = exports.matchFromAbsolutePaths = exports.createMatchPath = void 0;
    var match_path_sync_1 = require_match_path_sync();
    Object.defineProperty(exports, "createMatchPath", { enumerable: true, get: /* @__PURE__ */ __name(function() {
      return match_path_sync_1.createMatchPath;
    }, "get") });
    Object.defineProperty(exports, "matchFromAbsolutePaths", { enumerable: true, get: /* @__PURE__ */ __name(function() {
      return match_path_sync_1.matchFromAbsolutePaths;
    }, "get") });
    var match_path_async_1 = require_match_path_async();
    Object.defineProperty(exports, "createMatchPathAsync", { enumerable: true, get: /* @__PURE__ */ __name(function() {
      return match_path_async_1.createMatchPathAsync;
    }, "get") });
    Object.defineProperty(exports, "matchFromAbsolutePathsAsync", { enumerable: true, get: /* @__PURE__ */ __name(function() {
      return match_path_async_1.matchFromAbsolutePathsAsync;
    }, "get") });
    var register_1 = require_register();
    Object.defineProperty(exports, "register", { enumerable: true, get: /* @__PURE__ */ __name(function() {
      return register_1.register;
    }, "get") });
    var config_loader_1 = require_config_loader();
    Object.defineProperty(exports, "loadConfig", { enumerable: true, get: /* @__PURE__ */ __name(function() {
      return config_loader_1.loadConfig;
    }, "get") });
  }
});

// ../node_modules/@discoveryjs/json-ext/package.json
var require_package = __commonJS({
  "../node_modules/@discoveryjs/json-ext/package.json"(exports, module) {
    module.exports = {
      name: "@discoveryjs/json-ext",
      version: "0.5.7",
      description: "A set of utilities that extend the use of JSON",
      keywords: [
        "json",
        "utils",
        "stream",
        "async",
        "promise",
        "stringify",
        "info"
      ],
      author: "Roman Dvornov <rdvornov@gmail.com> (https://github.com/lahmatiy)",
      license: "MIT",
      repository: "discoveryjs/json-ext",
      main: "./src/index",
      browser: {
        "./src/stringify-stream.js": "./src/stringify-stream-browser.js",
        "./src/text-decoder.js": "./src/text-decoder-browser.js",
        "./src/version.js": "./dist/version.js"
      },
      types: "./index.d.ts",
      scripts: {
        test: "mocha --reporter progress",
        lint: "eslint src test",
        "lint-and-test": "npm run lint && npm test",
        build: "rollup --config",
        "test:all": "npm run test:src && npm run test:dist",
        "test:src": "npm test",
        "test:dist": "cross-env MODE=dist npm test && cross-env MODE=dist-min npm test",
        "build-and-test": "npm run build && npm run test:dist",
        coverage: "c8 --reporter=lcovonly npm test",
        prepublishOnly: "npm run lint && npm test && npm run build-and-test"
      },
      devDependencies: {
        "@rollup/plugin-commonjs": "^15.1.0",
        "@rollup/plugin-json": "^4.1.0",
        "@rollup/plugin-node-resolve": "^9.0.0",
        c8: "^7.10.0",
        chalk: "^4.1.0",
        "cross-env": "^7.0.3",
        eslint: "^8.10.0",
        mocha: "^8.4.0",
        rollup: "^2.28.2",
        "rollup-plugin-terser": "^7.0.2"
      },
      engines: {
        node: ">=10.0.0"
      },
      files: [
        "dist",
        "src",
        "index.d.ts"
      ]
    };
  }
});

// ../node_modules/@discoveryjs/json-ext/src/version.js
var require_version = __commonJS({
  "../node_modules/@discoveryjs/json-ext/src/version.js"(exports, module) {
    module.exports = require_package().version;
  }
});

// ../node_modules/@discoveryjs/json-ext/src/utils.js
var require_utils = __commonJS({
  "../node_modules/@discoveryjs/json-ext/src/utils.js"(exports, module) {
    var PrimitiveType = 1;
    var ObjectType = 2;
    var ArrayType = 3;
    var PromiseType = 4;
    var ReadableStringType = 5;
    var ReadableObjectType = 6;
    var escapableCharCodeSubstitution = {
      // JSON Single Character Escape Sequences
      8: "\\b",
      9: "\\t",
      10: "\\n",
      12: "\\f",
      13: "\\r",
      34: '\\"',
      92: "\\\\"
    };
    function isLeadingSurrogate(code) {
      return code >= 55296 && code <= 56319;
    }
    __name(isLeadingSurrogate, "isLeadingSurrogate");
    function isTrailingSurrogate(code) {
      return code >= 56320 && code <= 57343;
    }
    __name(isTrailingSurrogate, "isTrailingSurrogate");
    function isReadableStream(value) {
      return typeof value.pipe === "function" && typeof value._read === "function" && typeof value._readableState === "object" && value._readableState !== null;
    }
    __name(isReadableStream, "isReadableStream");
    function replaceValue(holder, key, value, replacer) {
      if (value && typeof value.toJSON === "function") {
        value = value.toJSON();
      }
      if (replacer !== null) {
        value = replacer.call(holder, String(key), value);
      }
      switch (typeof value) {
        case "function":
        case "symbol":
          value = void 0;
          break;
        case "object":
          if (value !== null) {
            const cls = value.constructor;
            if (cls === String || cls === Number || cls === Boolean) {
              value = value.valueOf();
            }
          }
          break;
      }
      return value;
    }
    __name(replaceValue, "replaceValue");
    function getTypeNative(value) {
      if (value === null || typeof value !== "object") {
        return PrimitiveType;
      }
      if (Array.isArray(value)) {
        return ArrayType;
      }
      return ObjectType;
    }
    __name(getTypeNative, "getTypeNative");
    function getTypeAsync(value) {
      if (value === null || typeof value !== "object") {
        return PrimitiveType;
      }
      if (typeof value.then === "function") {
        return PromiseType;
      }
      if (isReadableStream(value)) {
        return value._readableState.objectMode ? ReadableObjectType : ReadableStringType;
      }
      if (Array.isArray(value)) {
        return ArrayType;
      }
      return ObjectType;
    }
    __name(getTypeAsync, "getTypeAsync");
    function normalizeReplacer(replacer) {
      if (typeof replacer === "function") {
        return replacer;
      }
      if (Array.isArray(replacer)) {
        const allowlist = new Set(
          replacer.map((item) => {
            const cls = item && item.constructor;
            return cls === String || cls === Number ? String(item) : null;
          }).filter((item) => typeof item === "string")
        );
        return [...allowlist];
      }
      return null;
    }
    __name(normalizeReplacer, "normalizeReplacer");
    function normalizeSpace(space) {
      if (typeof space === "number") {
        if (!Number.isFinite(space) || space < 1) {
          return false;
        }
        return " ".repeat(Math.min(space, 10));
      }
      if (typeof space === "string") {
        return space.slice(0, 10) || false;
      }
      return false;
    }
    __name(normalizeSpace, "normalizeSpace");
    module.exports = {
      escapableCharCodeSubstitution,
      isLeadingSurrogate,
      isTrailingSurrogate,
      type: {
        PRIMITIVE: PrimitiveType,
        PROMISE: PromiseType,
        ARRAY: ArrayType,
        OBJECT: ObjectType,
        STRING_STREAM: ReadableStringType,
        OBJECT_STREAM: ReadableObjectType
      },
      isReadableStream,
      replaceValue,
      getTypeNative,
      getTypeAsync,
      normalizeReplacer,
      normalizeSpace
    };
  }
});

// ../node_modules/@discoveryjs/json-ext/src/stringify-info.js
var require_stringify_info = __commonJS({
  "../node_modules/@discoveryjs/json-ext/src/stringify-info.js"(exports, module) {
    var {
      normalizeReplacer,
      normalizeSpace,
      replaceValue,
      getTypeNative,
      getTypeAsync,
      isLeadingSurrogate,
      isTrailingSurrogate,
      escapableCharCodeSubstitution,
      type: {
        PRIMITIVE,
        OBJECT,
        ARRAY,
        PROMISE,
        STRING_STREAM,
        OBJECT_STREAM
      }
    } = require_utils();
    var charLength2048 = Array.from({ length: 2048 }).map((_, code) => {
      if (escapableCharCodeSubstitution.hasOwnProperty(code)) {
        return 2;
      }
      if (code < 32) {
        return 6;
      }
      return code < 128 ? 1 : 2;
    });
    function stringLength(str) {
      let len = 0;
      let prevLeadingSurrogate = false;
      for (let i = 0; i < str.length; i++) {
        const code = str.charCodeAt(i);
        if (code < 2048) {
          len += charLength2048[code];
        } else if (isLeadingSurrogate(code)) {
          len += 6;
          prevLeadingSurrogate = true;
          continue;
        } else if (isTrailingSurrogate(code)) {
          len = prevLeadingSurrogate ? len - 2 : len + 6;
        } else {
          len += 3;
        }
        prevLeadingSurrogate = false;
      }
      return len + 2;
    }
    __name(stringLength, "stringLength");
    function primitiveLength(value) {
      switch (typeof value) {
        case "string":
          return stringLength(value);
        case "number":
          return Number.isFinite(value) ? String(value).length : 4;
        case "boolean":
          return value ? 4 : 5;
        case "undefined":
        case "object":
          return 4;
        /* null */
        default:
          return 0;
      }
    }
    __name(primitiveLength, "primitiveLength");
    function spaceLength(space) {
      space = normalizeSpace(space);
      return typeof space === "string" ? space.length : 0;
    }
    __name(spaceLength, "spaceLength");
    module.exports = /* @__PURE__ */ __name(function jsonStringifyInfo(value, replacer, space, options) {
      function walk(holder, key, value2) {
        if (stop) {
          return;
        }
        value2 = replaceValue(holder, key, value2, replacer);
        let type = getType(value2);
        if (type !== PRIMITIVE && stack.has(value2)) {
          circular.add(value2);
          length += 4;
          if (!options.continueOnCircular) {
            stop = true;
          }
          return;
        }
        switch (type) {
          case PRIMITIVE:
            if (value2 !== void 0 || Array.isArray(holder)) {
              length += primitiveLength(value2);
            } else if (holder === root) {
              length += 9;
            }
            break;
          case OBJECT: {
            if (visited.has(value2)) {
              duplicate.add(value2);
              length += visited.get(value2);
              break;
            }
            const valueLength = length;
            let entries = 0;
            length += 2;
            stack.add(value2);
            for (const key2 in value2) {
              if (hasOwnProperty.call(value2, key2) && (allowlist === null || allowlist.has(key2))) {
                const prevLength = length;
                walk(value2, key2, value2[key2]);
                if (prevLength !== length) {
                  length += stringLength(key2) + 1;
                  entries++;
                }
              }
            }
            if (entries > 1) {
              length += entries - 1;
            }
            stack.delete(value2);
            if (space > 0 && entries > 0) {
              length += (1 + (stack.size + 1) * space + 1) * entries;
              length += 1 + stack.size * space;
            }
            visited.set(value2, length - valueLength);
            break;
          }
          case ARRAY: {
            if (visited.has(value2)) {
              duplicate.add(value2);
              length += visited.get(value2);
              break;
            }
            const valueLength = length;
            length += 2;
            stack.add(value2);
            for (let i = 0; i < value2.length; i++) {
              walk(value2, i, value2[i]);
            }
            if (value2.length > 1) {
              length += value2.length - 1;
            }
            stack.delete(value2);
            if (space > 0 && value2.length > 0) {
              length += (1 + (stack.size + 1) * space) * value2.length;
              length += 1 + stack.size * space;
            }
            visited.set(value2, length - valueLength);
            break;
          }
          case PROMISE:
          case STRING_STREAM:
            async.add(value2);
            break;
          case OBJECT_STREAM:
            length += 2;
            async.add(value2);
            break;
        }
      }
      __name(walk, "walk");
      let allowlist = null;
      replacer = normalizeReplacer(replacer);
      if (Array.isArray(replacer)) {
        allowlist = new Set(replacer);
        replacer = null;
      }
      space = spaceLength(space);
      options = options || {};
      const visited = /* @__PURE__ */ new Map();
      const stack = /* @__PURE__ */ new Set();
      const duplicate = /* @__PURE__ */ new Set();
      const circular = /* @__PURE__ */ new Set();
      const async = /* @__PURE__ */ new Set();
      const getType = options.async ? getTypeAsync : getTypeNative;
      const root = { "": value };
      let stop = false;
      let length = 0;
      walk(root, "", value);
      return {
        minLength: isNaN(length) ? Infinity : length,
        circular: [...circular],
        duplicate: [...duplicate],
        async: [...async]
      };
    }, "jsonStringifyInfo");
  }
});

// ../node_modules/@discoveryjs/json-ext/src/stringify-stream.js
var require_stringify_stream = __commonJS({
  "../node_modules/@discoveryjs/json-ext/src/stringify-stream.js"(exports, module) {
    var { Readable } = __require("stream");
    var {
      normalizeReplacer,
      normalizeSpace,
      replaceValue,
      getTypeAsync,
      type: {
        PRIMITIVE,
        OBJECT,
        ARRAY,
        PROMISE,
        STRING_STREAM,
        OBJECT_STREAM
      }
    } = require_utils();
    var noop2 = /* @__PURE__ */ __name(() => {
    }, "noop");
    var hasOwnProperty2 = Object.prototype.hasOwnProperty;
    var wellformedStringStringify = JSON.stringify("\uD800") === '"\\ud800"' ? JSON.stringify : (s) => JSON.stringify(s).replace(
      /\p{Surrogate}/gu,
      (m) => `\\u${m.charCodeAt(0).toString(16)}`
    );
    function push() {
      this.push(this._stack.value);
      this.popStack();
    }
    __name(push, "push");
    function pushPrimitive(value) {
      switch (typeof value) {
        case "string":
          this.push(this.encodeString(value));
          break;
        case "number":
          this.push(Number.isFinite(value) ? this.encodeNumber(value) : "null");
          break;
        case "boolean":
          this.push(value ? "true" : "false");
          break;
        case "undefined":
        case "object":
          this.push("null");
          break;
        default:
          this.destroy(new TypeError(`Do not know how to serialize a ${value.constructor && value.constructor.name || typeof value}`));
      }
    }
    __name(pushPrimitive, "pushPrimitive");
    function processObjectEntry(key) {
      const current = this._stack;
      if (!current.first) {
        current.first = true;
      } else {
        this.push(",");
      }
      if (this.space) {
        this.push(`
${this.space.repeat(this._depth)}${this.encodeString(key)}: `);
      } else {
        this.push(this.encodeString(key) + ":");
      }
    }
    __name(processObjectEntry, "processObjectEntry");
    function processObject() {
      const current = this._stack;
      if (current.index === current.keys.length) {
        if (this.space && current.first) {
          this.push(`
${this.space.repeat(this._depth - 1)}}`);
        } else {
          this.push("}");
        }
        this.popStack();
        return;
      }
      const key = current.keys[current.index];
      this.processValue(current.value, key, current.value[key], processObjectEntry);
      current.index++;
    }
    __name(processObject, "processObject");
    function processArrayItem(index) {
      if (index !== 0) {
        this.push(",");
      }
      if (this.space) {
        this.push(`
${this.space.repeat(this._depth)}`);
      }
    }
    __name(processArrayItem, "processArrayItem");
    function processArray() {
      const current = this._stack;
      if (current.index === current.value.length) {
        if (this.space && current.index > 0) {
          this.push(`
${this.space.repeat(this._depth - 1)}]`);
        } else {
          this.push("]");
        }
        this.popStack();
        return;
      }
      this.processValue(current.value, current.index, current.value[current.index], processArrayItem);
      current.index++;
    }
    __name(processArray, "processArray");
    function createStreamReader(fn) {
      return function() {
        const current = this._stack;
        const data = current.value.read(this._readSize);
        if (data !== null) {
          current.first = false;
          fn.call(this, data, current);
        } else {
          if (current.first && !current.value._readableState.reading || current.ended) {
            this.popStack();
          } else {
            current.first = true;
            current.awaiting = true;
          }
        }
      };
    }
    __name(createStreamReader, "createStreamReader");
    var processReadableObject = createStreamReader(function(data, current) {
      this.processValue(current.value, current.index, data, processArrayItem);
      current.index++;
    });
    var processReadableString = createStreamReader(function(data) {
      this.push(data);
    });
    var JsonStringifyStream = class extends Readable {
      static {
        __name(this, "JsonStringifyStream");
      }
      constructor(value, replacer, space) {
        super({
          autoDestroy: true
        });
        this.getKeys = Object.keys;
        this.replacer = normalizeReplacer(replacer);
        if (Array.isArray(this.replacer)) {
          const allowlist = this.replacer;
          this.getKeys = (value2) => allowlist.filter((key) => hasOwnProperty2.call(value2, key));
          this.replacer = null;
        }
        this.space = normalizeSpace(space);
        this._depth = 0;
        this.error = null;
        this._processing = false;
        this._ended = false;
        this._readSize = 0;
        this._buffer = "";
        this._stack = null;
        this._visited = /* @__PURE__ */ new WeakSet();
        this.pushStack({
          handler: /* @__PURE__ */ __name(() => {
            this.popStack();
            this.processValue({ "": value }, "", value, noop2);
          }, "handler")
        });
      }
      encodeString(value) {
        if (/[^\x20-\uD799]|[\x22\x5c]/.test(value)) {
          return wellformedStringStringify(value);
        }
        return '"' + value + '"';
      }
      encodeNumber(value) {
        return value;
      }
      processValue(holder, key, value, callback) {
        value = replaceValue(holder, key, value, this.replacer);
        let type = getTypeAsync(value);
        switch (type) {
          case PRIMITIVE:
            if (callback !== processObjectEntry || value !== void 0) {
              callback.call(this, key);
              pushPrimitive.call(this, value);
            }
            break;
          case OBJECT:
            callback.call(this, key);
            if (this._visited.has(value)) {
              return this.destroy(new TypeError("Converting circular structure to JSON"));
            }
            this._visited.add(value);
            this._depth++;
            this.push("{");
            this.pushStack({
              handler: processObject,
              value,
              index: 0,
              first: false,
              keys: this.getKeys(value)
            });
            break;
          case ARRAY:
            callback.call(this, key);
            if (this._visited.has(value)) {
              return this.destroy(new TypeError("Converting circular structure to JSON"));
            }
            this._visited.add(value);
            this.push("[");
            this.pushStack({
              handler: processArray,
              value,
              index: 0
            });
            this._depth++;
            break;
          case PROMISE:
            this.pushStack({
              handler: noop2,
              awaiting: true
            });
            Promise.resolve(value).then((resolved) => {
              this.popStack();
              this.processValue(holder, key, resolved, callback);
              this.processStack();
            }).catch((error) => {
              this.destroy(error);
            });
            break;
          case STRING_STREAM:
          case OBJECT_STREAM:
            callback.call(this, key);
            if (value.readableEnded || value._readableState.endEmitted) {
              return this.destroy(new Error("Readable Stream has ended before it was serialized. All stream data have been lost"));
            }
            if (value.readableFlowing) {
              return this.destroy(new Error("Readable Stream is in flowing mode, data may have been lost. Trying to pause stream."));
            }
            if (type === OBJECT_STREAM) {
              this.push("[");
              this.pushStack({
                handler: push,
                value: this.space ? "\n" + this.space.repeat(this._depth) + "]" : "]"
              });
              this._depth++;
            }
            const self2 = this.pushStack({
              handler: type === OBJECT_STREAM ? processReadableObject : processReadableString,
              value,
              index: 0,
              first: false,
              ended: false,
              awaiting: !value.readable || value.readableLength === 0
            });
            const continueProcessing = /* @__PURE__ */ __name(() => {
              if (self2.awaiting) {
                self2.awaiting = false;
                this.processStack();
              }
            }, "continueProcessing");
            value.once("error", (error) => this.destroy(error));
            value.once("end", () => {
              self2.ended = true;
              continueProcessing();
            });
            value.on("readable", continueProcessing);
            break;
        }
      }
      pushStack(node) {
        node.prev = this._stack;
        return this._stack = node;
      }
      popStack() {
        const { handler, value } = this._stack;
        if (handler === processObject || handler === processArray || handler === processReadableObject) {
          this._visited.delete(value);
          this._depth--;
        }
        this._stack = this._stack.prev;
      }
      processStack() {
        if (this._processing || this._ended) {
          return;
        }
        try {
          this._processing = true;
          while (this._stack !== null && !this._stack.awaiting) {
            this._stack.handler.call(this);
            if (!this._processing) {
              return;
            }
          }
          this._processing = false;
        } catch (error) {
          this.destroy(error);
          return;
        }
        if (this._stack === null && !this._ended) {
          this._finish();
          this.push(null);
        }
      }
      push(data) {
        if (data !== null) {
          this._buffer += data;
          if (this._buffer.length < this._readSize) {
            return;
          }
          data = this._buffer;
          this._buffer = "";
          this._processing = false;
        }
        super.push(data);
      }
      _read(size) {
        this._readSize = size || this.readableHighWaterMark;
        this.processStack();
      }
      _finish() {
        this._ended = true;
        this._processing = false;
        this._stack = null;
        this._visited = null;
        if (this._buffer && this._buffer.length) {
          super.push(this._buffer);
        }
        this._buffer = "";
      }
      _destroy(error, cb) {
        this.error = this.error || error;
        this._finish();
        cb(error);
      }
    };
    module.exports = /* @__PURE__ */ __name(function createJsonStringifyStream(value, replacer, space) {
      return new JsonStringifyStream(value, replacer, space);
    }, "createJsonStringifyStream");
  }
});

// ../node_modules/@discoveryjs/json-ext/src/text-decoder.js
var require_text_decoder = __commonJS({
  "../node_modules/@discoveryjs/json-ext/src/text-decoder.js"(exports, module) {
    module.exports = __require("util").TextDecoder;
  }
});

// ../node_modules/@discoveryjs/json-ext/src/parse-chunked.js
var require_parse_chunked = __commonJS({
  "../node_modules/@discoveryjs/json-ext/src/parse-chunked.js"(exports, module) {
    var { isReadableStream } = require_utils();
    var TextDecoder = require_text_decoder();
    var STACK_OBJECT = 1;
    var STACK_ARRAY = 2;
    var decoder = new TextDecoder();
    function isObject(value) {
      return value !== null && typeof value === "object";
    }
    __name(isObject, "isObject");
    function adjustPosition(error, parser) {
      if (error.name === "SyntaxError" && parser.jsonParseOffset) {
        error.message = error.message.replace(
          /at position (\d+)/,
          (_, pos) => "at position " + (Number(pos) + parser.jsonParseOffset)
        );
      }
      return error;
    }
    __name(adjustPosition, "adjustPosition");
    function append(array, elements) {
      const initialLength = array.length;
      array.length += elements.length;
      for (let i = 0; i < elements.length; i++) {
        array[initialLength + i] = elements[i];
      }
    }
    __name(append, "append");
    module.exports = function(chunkEmitter) {
      let parser = new ChunkParser();
      if (isObject(chunkEmitter) && isReadableStream(chunkEmitter)) {
        return new Promise((resolve4, reject) => {
          chunkEmitter.on("data", (chunk) => {
            try {
              parser.push(chunk);
            } catch (e) {
              reject(adjustPosition(e, parser));
              parser = null;
            }
          }).on("error", (e) => {
            parser = null;
            reject(e);
          }).on("end", () => {
            try {
              resolve4(parser.finish());
            } catch (e) {
              reject(adjustPosition(e, parser));
            } finally {
              parser = null;
            }
          });
        });
      }
      if (typeof chunkEmitter === "function") {
        const iterator = chunkEmitter();
        if (isObject(iterator) && (Symbol.iterator in iterator || Symbol.asyncIterator in iterator)) {
          return new Promise(async (resolve4, reject) => {
            try {
              for await (const chunk of iterator) {
                parser.push(chunk);
              }
              resolve4(parser.finish());
            } catch (e) {
              reject(adjustPosition(e, parser));
            } finally {
              parser = null;
            }
          });
        }
      }
      throw new Error(
        "Chunk emitter should be readable stream, generator, async generator or function returning an iterable object"
      );
    };
    var ChunkParser = class {
      static {
        __name(this, "ChunkParser");
      }
      constructor() {
        this.value = void 0;
        this.valueStack = null;
        this.stack = new Array(100);
        this.lastFlushDepth = 0;
        this.flushDepth = 0;
        this.stateString = false;
        this.stateStringEscape = false;
        this.pendingByteSeq = null;
        this.pendingChunk = null;
        this.chunkOffset = 0;
        this.jsonParseOffset = 0;
      }
      parseAndAppend(fragment, wrap) {
        if (this.stack[this.lastFlushDepth - 1] === STACK_OBJECT) {
          if (wrap) {
            this.jsonParseOffset--;
            fragment = "{" + fragment + "}";
          }
          Object.assign(this.valueStack.value, JSON.parse(fragment));
        } else {
          if (wrap) {
            this.jsonParseOffset--;
            fragment = "[" + fragment + "]";
          }
          append(this.valueStack.value, JSON.parse(fragment));
        }
      }
      prepareAddition(fragment) {
        const { value } = this.valueStack;
        const expectComma = Array.isArray(value) ? value.length !== 0 : Object.keys(value).length !== 0;
        if (expectComma) {
          if (fragment[0] === ",") {
            this.jsonParseOffset++;
            return fragment.slice(1);
          }
          if (fragment[0] !== "}" && fragment[0] !== "]") {
            this.jsonParseOffset -= 3;
            return "[[]" + fragment;
          }
        }
        return fragment;
      }
      flush(chunk, start, end) {
        let fragment = chunk.slice(start, end);
        this.jsonParseOffset = this.chunkOffset + start;
        if (this.pendingChunk !== null) {
          fragment = this.pendingChunk + fragment;
          this.jsonParseOffset -= this.pendingChunk.length;
          this.pendingChunk = null;
        }
        if (this.flushDepth === this.lastFlushDepth) {
          if (this.flushDepth > 0) {
            this.parseAndAppend(this.prepareAddition(fragment), true);
          } else {
            this.value = JSON.parse(fragment);
            this.valueStack = {
              value: this.value,
              prev: null
            };
          }
        } else if (this.flushDepth > this.lastFlushDepth) {
          for (let i = this.flushDepth - 1; i >= this.lastFlushDepth; i--) {
            fragment += this.stack[i] === STACK_OBJECT ? "}" : "]";
          }
          if (this.lastFlushDepth === 0) {
            this.value = JSON.parse(fragment);
            this.valueStack = {
              value: this.value,
              prev: null
            };
          } else {
            this.parseAndAppend(this.prepareAddition(fragment), true);
          }
          for (let i = this.lastFlushDepth || 1; i < this.flushDepth; i++) {
            let value = this.valueStack.value;
            if (this.stack[i - 1] === STACK_OBJECT) {
              let key;
              for (key in value) ;
              value = value[key];
            } else {
              value = value[value.length - 1];
            }
            this.valueStack = {
              value,
              prev: this.valueStack
            };
          }
        } else {
          fragment = this.prepareAddition(fragment);
          for (let i = this.lastFlushDepth - 1; i >= this.flushDepth; i--) {
            this.jsonParseOffset--;
            fragment = (this.stack[i] === STACK_OBJECT ? "{" : "[") + fragment;
          }
          this.parseAndAppend(fragment, false);
          for (let i = this.lastFlushDepth - 1; i >= this.flushDepth; i--) {
            this.valueStack = this.valueStack.prev;
          }
        }
        this.lastFlushDepth = this.flushDepth;
      }
      push(chunk) {
        if (typeof chunk !== "string") {
          if (this.pendingByteSeq !== null) {
            const origRawChunk = chunk;
            chunk = new Uint8Array(this.pendingByteSeq.length + origRawChunk.length);
            chunk.set(this.pendingByteSeq);
            chunk.set(origRawChunk, this.pendingByteSeq.length);
            this.pendingByteSeq = null;
          }
          if (chunk[chunk.length - 1] > 127) {
            for (let seqLength = 0; seqLength < chunk.length; seqLength++) {
              const byte = chunk[chunk.length - 1 - seqLength];
              if (byte >> 6 === 3) {
                seqLength++;
                if (seqLength !== 4 && byte >> 3 === 30 || seqLength !== 3 && byte >> 4 === 14 || seqLength !== 2 && byte >> 5 === 6) {
                  this.pendingByteSeq = chunk.slice(chunk.length - seqLength);
                  chunk = chunk.slice(0, -seqLength);
                }
                break;
              }
            }
          }
          chunk = decoder.decode(chunk);
        }
        const chunkLength = chunk.length;
        let lastFlushPoint = 0;
        let flushPoint = 0;
        scan: for (let i = 0; i < chunkLength; i++) {
          if (this.stateString) {
            for (; i < chunkLength; i++) {
              if (this.stateStringEscape) {
                this.stateStringEscape = false;
              } else {
                switch (chunk.charCodeAt(i)) {
                  case 34:
                    this.stateString = false;
                    continue scan;
                  case 92:
                    this.stateStringEscape = true;
                }
              }
            }
            break;
          }
          switch (chunk.charCodeAt(i)) {
            case 34:
              this.stateString = true;
              this.stateStringEscape = false;
              break;
            case 44:
              flushPoint = i;
              break;
            case 123:
              flushPoint = i + 1;
              this.stack[this.flushDepth++] = STACK_OBJECT;
              break;
            case 91:
              flushPoint = i + 1;
              this.stack[this.flushDepth++] = STACK_ARRAY;
              break;
            case 93:
            /* ] */
            case 125:
              flushPoint = i + 1;
              this.flushDepth--;
              if (this.flushDepth < this.lastFlushDepth) {
                this.flush(chunk, lastFlushPoint, flushPoint);
                lastFlushPoint = flushPoint;
              }
              break;
            case 9:
            /* \t */
            case 10:
            /* \n */
            case 13:
            /* \r */
            case 32:
              if (lastFlushPoint === i) {
                lastFlushPoint++;
              }
              if (flushPoint === i) {
                flushPoint++;
              }
              break;
          }
        }
        if (flushPoint > lastFlushPoint) {
          this.flush(chunk, lastFlushPoint, flushPoint);
        }
        if (flushPoint < chunkLength) {
          if (this.pendingChunk !== null) {
            this.pendingChunk += chunk;
          } else {
            this.pendingChunk = chunk.slice(flushPoint, chunkLength);
          }
        }
        this.chunkOffset += chunkLength;
      }
      finish() {
        if (this.pendingChunk !== null) {
          this.flush("", 0, 0);
          this.pendingChunk = null;
        }
        return this.value;
      }
    };
  }
});

// ../node_modules/@discoveryjs/json-ext/src/index.js
var require_src2 = __commonJS({
  "../node_modules/@discoveryjs/json-ext/src/index.js"(exports, module) {
    module.exports = {
      version: require_version(),
      stringifyInfo: require_stringify_info(),
      stringifyStream: require_stringify_stream(),
      parseChunked: require_parse_chunked()
    };
  }
});

// ../node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "../node_modules/graceful-fs/polyfills.js"(exports, module) {
    var constants = __require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform2 = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d) {
        cwd = null;
        chdir.call(process, d);
      };
      if (Object.setPrototypeOf) Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module.exports = patch;
    function patch(fs6) {
      if (constants.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs6);
      }
      if (!fs6.lutimes) {
        patchLutimes(fs6);
      }
      fs6.chown = chownFix(fs6.chown);
      fs6.fchown = chownFix(fs6.fchown);
      fs6.lchown = chownFix(fs6.lchown);
      fs6.chmod = chmodFix(fs6.chmod);
      fs6.fchmod = chmodFix(fs6.fchmod);
      fs6.lchmod = chmodFix(fs6.lchmod);
      fs6.chownSync = chownFixSync(fs6.chownSync);
      fs6.fchownSync = chownFixSync(fs6.fchownSync);
      fs6.lchownSync = chownFixSync(fs6.lchownSync);
      fs6.chmodSync = chmodFixSync(fs6.chmodSync);
      fs6.fchmodSync = chmodFixSync(fs6.fchmodSync);
      fs6.lchmodSync = chmodFixSync(fs6.lchmodSync);
      fs6.stat = statFix(fs6.stat);
      fs6.fstat = statFix(fs6.fstat);
      fs6.lstat = statFix(fs6.lstat);
      fs6.statSync = statFixSync(fs6.statSync);
      fs6.fstatSync = statFixSync(fs6.fstatSync);
      fs6.lstatSync = statFixSync(fs6.lstatSync);
      if (fs6.chmod && !fs6.lchmod) {
        fs6.lchmod = function(path2, mode, cb) {
          if (cb) process.nextTick(cb);
        };
        fs6.lchmodSync = function() {
        };
      }
      if (fs6.chown && !fs6.lchown) {
        fs6.lchown = function(path2, uid, gid, cb) {
          if (cb) process.nextTick(cb);
        };
        fs6.lchownSync = function() {
        };
      }
      if (platform2 === "win32") {
        fs6.rename = typeof fs6.rename !== "function" ? fs6.rename : function(fs$rename) {
          function rename(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, /* @__PURE__ */ __name(function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM" || er.code === "EBUSY") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs6.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb) cb(er);
            }, "CB"));
          }
          __name(rename, "rename");
          if (Object.setPrototypeOf) Object.setPrototypeOf(rename, fs$rename);
          return rename;
        }(fs6.rename);
      }
      fs6.read = typeof fs6.read !== "function" ? fs6.read : function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = /* @__PURE__ */ __name(function(er, _, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs6, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            }, "callback");
          }
          return fs$read.call(fs6, fd, buffer, offset, length, position, callback);
        }
        __name(read, "read");
        if (Object.setPrototypeOf) Object.setPrototypeOf(read, fs$read);
        return read;
      }(fs6.read);
      fs6.readSync = typeof fs6.readSync !== "function" ? fs6.readSync : /* @__PURE__ */ function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs6, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      }(fs6.readSync);
      function patchLchmod(fs7) {
        fs7.lchmod = function(path2, mode, callback) {
          fs7.open(
            path2,
            constants.O_WRONLY | constants.O_SYMLINK,
            mode,
            function(err, fd) {
              if (err) {
                if (callback) callback(err);
                return;
              }
              fs7.fchmod(fd, mode, function(err2) {
                fs7.close(fd, function(err22) {
                  if (callback) callback(err2 || err22);
                });
              });
            }
          );
        };
        fs7.lchmodSync = function(path2, mode) {
          var fd = fs7.openSync(path2, constants.O_WRONLY | constants.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs7.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs7.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs7.closeSync(fd);
            }
          }
          return ret;
        };
      }
      __name(patchLchmod, "patchLchmod");
      function patchLutimes(fs7) {
        if (constants.hasOwnProperty("O_SYMLINK") && fs7.futimes) {
          fs7.lutimes = function(path2, at, mt, cb) {
            fs7.open(path2, constants.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb) cb(er);
                return;
              }
              fs7.futimes(fd, at, mt, function(er2) {
                fs7.close(fd, function(er22) {
                  if (cb) cb(er2 || er22);
                });
              });
            });
          };
          fs7.lutimesSync = function(path2, at, mt) {
            var fd = fs7.openSync(path2, constants.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs7.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs7.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs7.closeSync(fd);
              }
            }
            return ret;
          };
        } else if (fs7.futimes) {
          fs7.lutimes = function(_a, _b, _c, cb) {
            if (cb) process.nextTick(cb);
          };
          fs7.lutimesSync = function() {
          };
        }
      }
      __name(patchLutimes, "patchLutimes");
      function chmodFix(orig) {
        if (!orig) return orig;
        return function(target, mode, cb) {
          return orig.call(fs6, target, mode, function(er) {
            if (chownErOk(er)) er = null;
            if (cb) cb.apply(this, arguments);
          });
        };
      }
      __name(chmodFix, "chmodFix");
      function chmodFixSync(orig) {
        if (!orig) return orig;
        return function(target, mode) {
          try {
            return orig.call(fs6, target, mode);
          } catch (er) {
            if (!chownErOk(er)) throw er;
          }
        };
      }
      __name(chmodFixSync, "chmodFixSync");
      function chownFix(orig) {
        if (!orig) return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs6, target, uid, gid, function(er) {
            if (chownErOk(er)) er = null;
            if (cb) cb.apply(this, arguments);
          });
        };
      }
      __name(chownFix, "chownFix");
      function chownFixSync(orig) {
        if (!orig) return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs6, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er)) throw er;
          }
        };
      }
      __name(chownFixSync, "chownFixSync");
      function statFix(orig) {
        if (!orig) return orig;
        return function(target, options, cb) {
          if (typeof options === "function") {
            cb = options;
            options = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0) stats.uid += 4294967296;
              if (stats.gid < 0) stats.gid += 4294967296;
            }
            if (cb) cb.apply(this, arguments);
          }
          __name(callback, "callback");
          return options ? orig.call(fs6, target, options, callback) : orig.call(fs6, target, callback);
        };
      }
      __name(statFix, "statFix");
      function statFixSync(orig) {
        if (!orig) return orig;
        return function(target, options) {
          var stats = options ? orig.call(fs6, target, options) : orig.call(fs6, target);
          if (stats) {
            if (stats.uid < 0) stats.uid += 4294967296;
            if (stats.gid < 0) stats.gid += 4294967296;
          }
          return stats;
        };
      }
      __name(statFixSync, "statFixSync");
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
      __name(chownErOk, "chownErOk");
    }
    __name(patch, "patch");
  }
});

// ../node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "../node_modules/graceful-fs/legacy-streams.js"(exports, module) {
    var Stream = __require("stream").Stream;
    module.exports = legacy;
    function legacy(fs6) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path2, options) {
        if (!(this instanceof ReadStream)) return new ReadStream(path2, options);
        Stream.call(this);
        var self2 = this;
        this.path = path2;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.encoding) this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if ("number" !== typeof this.end) {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self2._read();
          });
          return;
        }
        fs6.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self2.emit("error", err);
            self2.readable = false;
            return;
          }
          self2.fd = fd;
          self2.emit("open", fd);
          self2._read();
        });
      }
      __name(ReadStream, "ReadStream");
      function WriteStream(path2, options) {
        if (!(this instanceof WriteStream)) return new WriteStream(path2, options);
        Stream.call(this);
        this.path = path2;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs6.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
      __name(WriteStream, "WriteStream");
    }
    __name(legacy, "legacy");
  }
});

// ../node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "../node_modules/graceful-fs/clone.js"(exports, module) {
    "use strict";
    module.exports = clone;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy = { __proto__: getPrototypeOf(obj) };
      else
        var copy = /* @__PURE__ */ Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy;
    }
    __name(clone, "clone");
  }
});

// ../node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "../node_modules/graceful-fs/graceful-fs.js"(exports, module) {
    var fs6 = __require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone = require_clone();
    var util = __require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = Symbol.for("graceful-fs.queue");
      previousSymbol = Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop2() {
    }
    __name(noop2, "noop");
    function publishQueue(context, queue2) {
      Object.defineProperty(context, gracefulQueue, {
        get: /* @__PURE__ */ __name(function() {
          return queue2;
        }, "get")
      });
    }
    __name(publishQueue, "publishQueue");
    var debug = noop2;
    if (util.debuglog)
      debug = util.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug = /* @__PURE__ */ __name(function() {
        var m = util.format.apply(util, arguments);
        m = "GFS4: " + m.split(/\n/).join("\nGFS4: ");
        console.error(m);
      }, "debug");
    if (!fs6[gracefulQueue]) {
      queue = global[gracefulQueue] || [];
      publishQueue(fs6, queue);
      fs6.close = function(fs$close) {
        function close(fd, cb) {
          return fs$close.call(fs6, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        __name(close, "close");
        Object.defineProperty(close, previousSymbol, {
          value: fs$close
        });
        return close;
      }(fs6.close);
      fs6.closeSync = function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs6, arguments);
          resetQueue();
        }
        __name(closeSync, "closeSync");
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      }(fs6.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug(fs6[gracefulQueue]);
          __require("assert").equal(fs6[gracefulQueue].length, 0);
        });
      }
    }
    var queue;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs6[gracefulQueue]);
    }
    module.exports = patch(clone(fs6));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs6.__patched) {
      module.exports = patch(fs6);
      fs6.__patched = true;
    }
    function patch(fs7) {
      polyfills(fs7);
      fs7.gracefulify = patch;
      fs7.createReadStream = createReadStream;
      fs7.createWriteStream = createWriteStream2;
      var fs$readFile = fs7.readFile;
      fs7.readFile = readFile5;
      function readFile5(path2, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readFile(path2, options, cb);
        function go$readFile(path3, options2, cb2, startTime) {
          return fs$readFile(path3, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path3, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$readFile, "go$readFile");
      }
      __name(readFile5, "readFile");
      var fs$writeFile = fs7.writeFile;
      fs7.writeFile = writeFile4;
      function writeFile4(path2, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$writeFile(path2, data, options, cb);
        function go$writeFile(path3, data2, options2, cb2, startTime) {
          return fs$writeFile(path3, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path3, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$writeFile, "go$writeFile");
      }
      __name(writeFile4, "writeFile");
      var fs$appendFile = fs7.appendFile;
      if (fs$appendFile)
        fs7.appendFile = appendFile;
      function appendFile(path2, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$appendFile(path2, data, options, cb);
        function go$appendFile(path3, data2, options2, cb2, startTime) {
          return fs$appendFile(path3, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path3, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$appendFile, "go$appendFile");
      }
      __name(appendFile, "appendFile");
      var fs$copyFile = fs7.copyFile;
      if (fs$copyFile)
        fs7.copyFile = copyFile;
      function copyFile(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$copyFile, "go$copyFile");
      }
      __name(copyFile, "copyFile");
      var fs$readdir = fs7.readdir;
      fs7.readdir = readdir;
      var noReaddirOptionVersions = /^v[0-5]\./;
      function readdir(path2, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        var go$readdir = noReaddirOptionVersions.test(process.version) ? /* @__PURE__ */ __name(function go$readdir2(path3, options2, cb2, startTime) {
          return fs$readdir(path3, fs$readdirCallback(
            path3,
            options2,
            cb2,
            startTime
          ));
        }, "go$readdir") : /* @__PURE__ */ __name(function go$readdir2(path3, options2, cb2, startTime) {
          return fs$readdir(path3, options2, fs$readdirCallback(
            path3,
            options2,
            cb2,
            startTime
          ));
        }, "go$readdir");
        return go$readdir(path2, options, cb);
        function fs$readdirCallback(path3, options2, cb2, startTime) {
          return function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([
                go$readdir,
                [path3, options2, cb2],
                err,
                startTime || Date.now(),
                Date.now()
              ]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          };
        }
        __name(fs$readdirCallback, "fs$readdirCallback");
      }
      __name(readdir, "readdir");
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs7);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs7.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs7.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs7, "ReadStream", {
        get: /* @__PURE__ */ __name(function() {
          return ReadStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          ReadStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs7, "WriteStream", {
        get: /* @__PURE__ */ __name(function() {
          return WriteStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          WriteStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs7, "FileReadStream", {
        get: /* @__PURE__ */ __name(function() {
          return FileReadStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          FileReadStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs7, "FileWriteStream", {
        get: /* @__PURE__ */ __name(function() {
          return FileWriteStream;
        }, "get"),
        set: /* @__PURE__ */ __name(function(val) {
          FileWriteStream = val;
        }, "set"),
        enumerable: true,
        configurable: true
      });
      function ReadStream(path2, options) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      __name(ReadStream, "ReadStream");
      function ReadStream$open() {
        var that = this;
        open2(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      __name(ReadStream$open, "ReadStream$open");
      function WriteStream(path2, options) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      __name(WriteStream, "WriteStream");
      function WriteStream$open() {
        var that = this;
        open2(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      __name(WriteStream$open, "WriteStream$open");
      function createReadStream(path2, options) {
        return new fs7.ReadStream(path2, options);
      }
      __name(createReadStream, "createReadStream");
      function createWriteStream2(path2, options) {
        return new fs7.WriteStream(path2, options);
      }
      __name(createWriteStream2, "createWriteStream");
      var fs$open = fs7.open;
      fs7.open = open2;
      function open2(path2, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path2, flags, mode, cb);
        function go$open(path3, flags2, mode2, cb2, startTime) {
          return fs$open(path3, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path3, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$open, "go$open");
      }
      __name(open2, "open");
      return fs7;
    }
    __name(patch, "patch");
    function enqueue(elem) {
      debug("ENQUEUE", elem[0].name, elem[1]);
      fs6[gracefulQueue].push(elem);
      retry2();
    }
    __name(enqueue, "enqueue");
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i = 0; i < fs6[gracefulQueue].length; ++i) {
        if (fs6[gracefulQueue][i].length > 2) {
          fs6[gracefulQueue][i][3] = now;
          fs6[gracefulQueue][i][4] = now;
        }
      }
      retry2();
    }
    __name(resetQueue, "resetQueue");
    function retry2() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs6[gracefulQueue].length === 0)
        return;
      var elem = fs6[gracefulQueue].shift();
      var fn = elem[0];
      var args = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug("RETRY", fn.name, args);
        fn.apply(null, args);
      } else if (Date.now() - startTime >= 6e4) {
        debug("TIMEOUT", fn.name, args);
        var cb = args.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug("RETRY", fn.name, args);
          fn.apply(null, args.concat([startTime]));
        } else {
          fs6[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry2, 0);
      }
    }
    __name(retry2, "retry");
  }
});

// ../node_modules/watchpack/lib/reducePlan.js
var require_reducePlan = __commonJS({
  "../node_modules/watchpack/lib/reducePlan.js"(exports, module) {
    "use strict";
    var path2 = __require("path");
    module.exports = (plan, limit) => {
      const treeMap = /* @__PURE__ */ new Map();
      for (const [filePath, value] of plan) {
        treeMap.set(filePath, {
          filePath,
          parent: void 0,
          children: void 0,
          entries: 1,
          active: true,
          value
        });
      }
      let currentCount = treeMap.size;
      for (const node of treeMap.values()) {
        const parentPath = path2.dirname(node.filePath);
        if (parentPath !== node.filePath) {
          let parent = treeMap.get(parentPath);
          if (parent === void 0) {
            parent = {
              filePath: parentPath,
              parent: void 0,
              children: [node],
              entries: node.entries,
              active: false,
              value: void 0
            };
            treeMap.set(parentPath, parent);
            node.parent = parent;
          } else {
            node.parent = parent;
            if (parent.children === void 0) {
              parent.children = [node];
            } else {
              parent.children.push(node);
            }
            do {
              parent.entries += node.entries;
              parent = parent.parent;
            } while (parent);
          }
        }
      }
      while (currentCount > limit) {
        const overLimit = currentCount - limit;
        let bestNode = void 0;
        let bestCost = Infinity;
        for (const node of treeMap.values()) {
          if (node.entries <= 1 || !node.children || !node.parent) continue;
          if (node.children.length === 0) continue;
          if (node.children.length === 1 && !node.value) continue;
          const cost = node.entries - 1 >= overLimit ? node.entries - 1 - overLimit : overLimit - node.entries + 1 + limit * 0.3;
          if (cost < bestCost) {
            bestNode = node;
            bestCost = cost;
          }
        }
        if (!bestNode) break;
        const reduction = bestNode.entries - 1;
        bestNode.active = true;
        bestNode.entries = 1;
        currentCount -= reduction;
        let parent = bestNode.parent;
        while (parent) {
          parent.entries -= reduction;
          parent = parent.parent;
        }
        const queue = new Set(bestNode.children);
        for (const node of queue) {
          node.active = false;
          node.entries = 0;
          if (node.children) {
            for (const child of node.children) queue.add(child);
          }
        }
      }
      const newPlan = /* @__PURE__ */ new Map();
      for (const rootNode of treeMap.values()) {
        if (!rootNode.active) continue;
        const map = /* @__PURE__ */ new Map();
        const queue = /* @__PURE__ */ new Set([rootNode]);
        for (const node of queue) {
          if (node.active && node !== rootNode) continue;
          if (node.value) {
            if (Array.isArray(node.value)) {
              for (const item of node.value) {
                map.set(item, node.filePath);
              }
            } else {
              map.set(node.value, node.filePath);
            }
          }
          if (node.children) {
            for (const child of node.children) {
              queue.add(child);
            }
          }
        }
        newPlan.set(rootNode.filePath, map);
      }
      return newPlan;
    };
  }
});

// ../node_modules/watchpack/lib/watchEventSource.js
var require_watchEventSource = __commonJS({
  "../node_modules/watchpack/lib/watchEventSource.js"(exports) {
    "use strict";
    var fs6 = __require("fs");
    var path2 = __require("path");
    var { EventEmitter } = __require("events");
    var reducePlan = require_reducePlan();
    var IS_OSX = __require("os").platform() === "darwin";
    var IS_WIN = __require("os").platform() === "win32";
    var SUPPORTS_RECURSIVE_WATCHING = IS_OSX || IS_WIN;
    var watcherLimit = +process.env.WATCHPACK_WATCHER_LIMIT || (IS_OSX ? 20 : 1e4);
    var recursiveWatcherLogging = !!process.env.WATCHPACK_RECURSIVE_WATCHER_LOGGING;
    var isBatch = false;
    var watcherCount = 0;
    var pendingWatchers = /* @__PURE__ */ new Map();
    var recursiveWatchers = /* @__PURE__ */ new Map();
    var directWatchers = /* @__PURE__ */ new Map();
    var underlyingWatcher = /* @__PURE__ */ new Map();
    function createEPERMError(filePath) {
      const error = new Error(`Operation not permitted: ${filePath}`);
      error.code = "EPERM";
      return error;
    }
    __name(createEPERMError, "createEPERMError");
    function createHandleChangeEvent(watcher, filePath, handleChangeEvent) {
      return (type, filename) => {
        if (type === "rename" && path2.isAbsolute(filename) && path2.basename(filename) === path2.basename(filePath)) {
          if (!IS_OSX) {
            watcher.emit("error", createEPERMError(filename));
          }
          return;
        }
        handleChangeEvent(type, filename);
      };
    }
    __name(createHandleChangeEvent, "createHandleChangeEvent");
    var DirectWatcher = class {
      static {
        __name(this, "DirectWatcher");
      }
      constructor(filePath) {
        this.filePath = filePath;
        this.watchers = /* @__PURE__ */ new Set();
        this.watcher = void 0;
        try {
          const watcher = fs6.watch(filePath);
          this.watcher = watcher;
          const handleChangeEvent = createHandleChangeEvent(
            watcher,
            filePath,
            (type, filename) => {
              for (const w of this.watchers) {
                w.emit("change", type, filename);
              }
            }
          );
          watcher.on("change", handleChangeEvent);
          watcher.on("error", (error) => {
            for (const w of this.watchers) {
              w.emit("error", error);
            }
          });
        } catch (err) {
          process.nextTick(() => {
            for (const w of this.watchers) {
              w.emit("error", err);
            }
          });
        }
        watcherCount++;
      }
      add(watcher) {
        underlyingWatcher.set(watcher, this);
        this.watchers.add(watcher);
      }
      remove(watcher) {
        this.watchers.delete(watcher);
        if (this.watchers.size === 0) {
          directWatchers.delete(this.filePath);
          watcherCount--;
          if (this.watcher) this.watcher.close();
        }
      }
      getWatchers() {
        return this.watchers;
      }
    };
    var RecursiveWatcher = class {
      static {
        __name(this, "RecursiveWatcher");
      }
      constructor(rootPath) {
        this.rootPath = rootPath;
        this.mapWatcherToPath = /* @__PURE__ */ new Map();
        this.mapPathToWatchers = /* @__PURE__ */ new Map();
        this.watcher = void 0;
        try {
          const watcher = fs6.watch(rootPath, {
            recursive: true
          });
          this.watcher = watcher;
          watcher.on("change", (type, filename) => {
            if (!filename) {
              if (recursiveWatcherLogging) {
                process.stderr.write(
                  `[watchpack] dispatch ${type} event in recursive watcher (${this.rootPath}) to all watchers
`
                );
              }
              for (const w of this.mapWatcherToPath.keys()) {
                w.emit("change", type);
              }
            } else {
              const dir = path2.dirname(filename);
              const watchers = this.mapPathToWatchers.get(dir);
              if (recursiveWatcherLogging) {
                process.stderr.write(
                  `[watchpack] dispatch ${type} event in recursive watcher (${this.rootPath}) for '${filename}' to ${watchers ? watchers.size : 0} watchers
`
                );
              }
              if (watchers === void 0) return;
              for (const w of watchers) {
                w.emit("change", type, path2.basename(filename));
              }
            }
          });
          watcher.on("error", (error) => {
            for (const w of this.mapWatcherToPath.keys()) {
              w.emit("error", error);
            }
          });
        } catch (err) {
          process.nextTick(() => {
            for (const w of this.mapWatcherToPath.keys()) {
              w.emit("error", err);
            }
          });
        }
        watcherCount++;
        if (recursiveWatcherLogging) {
          process.stderr.write(
            `[watchpack] created recursive watcher at ${rootPath}
`
          );
        }
      }
      add(filePath, watcher) {
        underlyingWatcher.set(watcher, this);
        const subpath = filePath.slice(this.rootPath.length + 1) || ".";
        this.mapWatcherToPath.set(watcher, subpath);
        const set = this.mapPathToWatchers.get(subpath);
        if (set === void 0) {
          const newSet = /* @__PURE__ */ new Set();
          newSet.add(watcher);
          this.mapPathToWatchers.set(subpath, newSet);
        } else {
          set.add(watcher);
        }
      }
      remove(watcher) {
        const subpath = this.mapWatcherToPath.get(watcher);
        if (!subpath) return;
        this.mapWatcherToPath.delete(watcher);
        const set = this.mapPathToWatchers.get(subpath);
        set.delete(watcher);
        if (set.size === 0) {
          this.mapPathToWatchers.delete(subpath);
        }
        if (this.mapWatcherToPath.size === 0) {
          recursiveWatchers.delete(this.rootPath);
          watcherCount--;
          if (this.watcher) this.watcher.close();
          if (recursiveWatcherLogging) {
            process.stderr.write(
              `[watchpack] closed recursive watcher at ${this.rootPath}
`
            );
          }
        }
      }
      getWatchers() {
        return this.mapWatcherToPath;
      }
    };
    var Watcher = class extends EventEmitter {
      static {
        __name(this, "Watcher");
      }
      close() {
        if (pendingWatchers.has(this)) {
          pendingWatchers.delete(this);
          return;
        }
        const watcher = underlyingWatcher.get(this);
        watcher.remove(this);
        underlyingWatcher.delete(this);
      }
    };
    var createDirectWatcher = /* @__PURE__ */ __name((filePath) => {
      const existing = directWatchers.get(filePath);
      if (existing !== void 0) return existing;
      const w = new DirectWatcher(filePath);
      directWatchers.set(filePath, w);
      return w;
    }, "createDirectWatcher");
    var createRecursiveWatcher = /* @__PURE__ */ __name((rootPath) => {
      const existing = recursiveWatchers.get(rootPath);
      if (existing !== void 0) return existing;
      const w = new RecursiveWatcher(rootPath);
      recursiveWatchers.set(rootPath, w);
      return w;
    }, "createRecursiveWatcher");
    var execute = /* @__PURE__ */ __name(() => {
      const map = /* @__PURE__ */ new Map();
      const addWatcher = /* @__PURE__ */ __name((watcher, filePath) => {
        const entry = map.get(filePath);
        if (entry === void 0) {
          map.set(filePath, watcher);
        } else if (Array.isArray(entry)) {
          entry.push(watcher);
        } else {
          map.set(filePath, [entry, watcher]);
        }
      }, "addWatcher");
      for (const [watcher, filePath] of pendingWatchers) {
        addWatcher(watcher, filePath);
      }
      pendingWatchers.clear();
      if (!SUPPORTS_RECURSIVE_WATCHING || watcherLimit - watcherCount >= map.size) {
        for (const [filePath, entry] of map) {
          const w = createDirectWatcher(filePath);
          if (Array.isArray(entry)) {
            for (const item of entry) w.add(item);
          } else {
            w.add(entry);
          }
        }
        return;
      }
      for (const watcher of recursiveWatchers.values()) {
        for (const [w, subpath] of watcher.getWatchers()) {
          addWatcher(w, path2.join(watcher.rootPath, subpath));
        }
      }
      for (const watcher of directWatchers.values()) {
        for (const w of watcher.getWatchers()) {
          addWatcher(w, watcher.filePath);
        }
      }
      const plan = reducePlan(map, watcherLimit * 0.9);
      for (const [filePath, entry] of plan) {
        if (entry.size === 1) {
          for (const [watcher, filePath2] of entry) {
            const w = createDirectWatcher(filePath2);
            const old = underlyingWatcher.get(watcher);
            if (old === w) continue;
            w.add(watcher);
            if (old !== void 0) old.remove(watcher);
          }
        } else {
          const filePaths = new Set(entry.values());
          if (filePaths.size > 1) {
            const w = createRecursiveWatcher(filePath);
            for (const [watcher, watcherPath] of entry) {
              const old = underlyingWatcher.get(watcher);
              if (old === w) continue;
              w.add(watcherPath, watcher);
              if (old !== void 0) old.remove(watcher);
            }
          } else {
            for (const filePath2 of filePaths) {
              const w = createDirectWatcher(filePath2);
              for (const watcher of entry.keys()) {
                const old = underlyingWatcher.get(watcher);
                if (old === w) continue;
                w.add(watcher);
                if (old !== void 0) old.remove(watcher);
              }
            }
          }
        }
      }
    }, "execute");
    exports.watch = (filePath) => {
      const watcher = new Watcher();
      const directWatcher = directWatchers.get(filePath);
      if (directWatcher !== void 0) {
        directWatcher.add(watcher);
        return watcher;
      }
      let current = filePath;
      for (; ; ) {
        const recursiveWatcher = recursiveWatchers.get(current);
        if (recursiveWatcher !== void 0) {
          recursiveWatcher.add(filePath, watcher);
          return watcher;
        }
        const parent = path2.dirname(current);
        if (parent === current) break;
        current = parent;
      }
      pendingWatchers.set(watcher, filePath);
      if (!isBatch) execute();
      return watcher;
    };
    exports.batch = (fn) => {
      isBatch = true;
      try {
        fn();
      } finally {
        isBatch = false;
        execute();
      }
    };
    exports.getNumberOfWatchers = () => {
      return watcherCount;
    };
    exports.createHandleChangeEvent = createHandleChangeEvent;
    exports.watcherLimit = watcherLimit;
  }
});

// ../node_modules/watchpack/lib/DirectoryWatcher.js
var require_DirectoryWatcher = __commonJS({
  "../node_modules/watchpack/lib/DirectoryWatcher.js"(exports, module) {
    "use strict";
    var EventEmitter = __require("events").EventEmitter;
    var fs6 = require_graceful_fs();
    var path2 = __require("path");
    var watchEventSource = require_watchEventSource();
    var EXISTANCE_ONLY_TIME_ENTRY = Object.freeze({});
    var FS_ACCURACY = 2e3;
    var IS_OSX = __require("os").platform() === "darwin";
    var IS_WIN = __require("os").platform() === "win32";
    var WATCHPACK_POLLING = process.env.WATCHPACK_POLLING;
    var FORCE_POLLING = `${+WATCHPACK_POLLING}` === WATCHPACK_POLLING ? +WATCHPACK_POLLING : !!WATCHPACK_POLLING && WATCHPACK_POLLING !== "false";
    function withoutCase(str) {
      return str.toLowerCase();
    }
    __name(withoutCase, "withoutCase");
    function needCalls(times, callback) {
      return function() {
        if (--times === 0) {
          return callback();
        }
      };
    }
    __name(needCalls, "needCalls");
    var Watcher = class extends EventEmitter {
      static {
        __name(this, "Watcher");
      }
      constructor(directoryWatcher, filePath, startTime) {
        super();
        this.directoryWatcher = directoryWatcher;
        this.path = filePath;
        this.startTime = startTime && +startTime;
      }
      checkStartTime(mtime, initial) {
        const startTime = this.startTime;
        if (typeof startTime !== "number") return !initial;
        return startTime <= mtime;
      }
      close() {
        this.emit("closed");
      }
    };
    var DirectoryWatcher = class extends EventEmitter {
      static {
        __name(this, "DirectoryWatcher");
      }
      constructor(watcherManager, directoryPath, options) {
        super();
        if (FORCE_POLLING) {
          options.poll = FORCE_POLLING;
        }
        this.watcherManager = watcherManager;
        this.options = options;
        this.path = directoryPath;
        this.files = /* @__PURE__ */ new Map();
        this.filesWithoutCase = /* @__PURE__ */ new Map();
        this.directories = /* @__PURE__ */ new Map();
        this.lastWatchEvent = 0;
        this.initialScan = true;
        this.ignored = options.ignored || (() => false);
        this.nestedWatching = false;
        this.polledWatching = typeof options.poll === "number" ? options.poll : options.poll ? 5007 : false;
        this.timeout = void 0;
        this.initialScanRemoved = /* @__PURE__ */ new Set();
        this.initialScanFinished = void 0;
        this.watchers = /* @__PURE__ */ new Map();
        this.parentWatcher = null;
        this.refs = 0;
        this._activeEvents = /* @__PURE__ */ new Map();
        this.closed = false;
        this.scanning = false;
        this.scanAgain = false;
        this.scanAgainInitial = false;
        this.createWatcher();
        this.doScan(true);
      }
      createWatcher() {
        try {
          if (this.polledWatching) {
            this.watcher = {
              close: /* @__PURE__ */ __name(() => {
                if (this.timeout) {
                  clearTimeout(this.timeout);
                  this.timeout = void 0;
                }
              }, "close")
            };
          } else {
            if (IS_OSX) {
              this.watchInParentDirectory();
            }
            this.watcher = watchEventSource.watch(this.path);
            this.watcher.on("change", this.onWatchEvent.bind(this));
            this.watcher.on("error", this.onWatcherError.bind(this));
          }
        } catch (err) {
          this.onWatcherError(err);
        }
      }
      forEachWatcher(path3, fn) {
        const watchers = this.watchers.get(withoutCase(path3));
        if (watchers !== void 0) {
          for (const w of watchers) {
            fn(w);
          }
        }
      }
      setMissing(itemPath, initial, type) {
        if (this.initialScan) {
          this.initialScanRemoved.add(itemPath);
        }
        const oldDirectory = this.directories.get(itemPath);
        if (oldDirectory) {
          if (this.nestedWatching) oldDirectory.close();
          this.directories.delete(itemPath);
          this.forEachWatcher(itemPath, (w) => w.emit("remove", type));
          if (!initial) {
            this.forEachWatcher(
              this.path,
              (w) => w.emit("change", itemPath, null, type, initial)
            );
          }
        }
        const oldFile = this.files.get(itemPath);
        if (oldFile) {
          this.files.delete(itemPath);
          const key = withoutCase(itemPath);
          const count = this.filesWithoutCase.get(key) - 1;
          if (count <= 0) {
            this.filesWithoutCase.delete(key);
            this.forEachWatcher(itemPath, (w) => w.emit("remove", type));
          } else {
            this.filesWithoutCase.set(key, count);
          }
          if (!initial) {
            this.forEachWatcher(
              this.path,
              (w) => w.emit("change", itemPath, null, type, initial)
            );
          }
        }
      }
      setFileTime(filePath, mtime, initial, ignoreWhenEqual, type) {
        const now = Date.now();
        if (this.ignored(filePath)) return;
        const old = this.files.get(filePath);
        let safeTime, accuracy;
        if (initial) {
          safeTime = Math.min(now, mtime) + FS_ACCURACY;
          accuracy = FS_ACCURACY;
        } else {
          safeTime = now;
          accuracy = 0;
          if (old && old.timestamp === mtime && mtime + FS_ACCURACY < now) {
            return;
          }
        }
        if (ignoreWhenEqual && old && old.timestamp === mtime) return;
        this.files.set(filePath, {
          safeTime,
          accuracy,
          timestamp: mtime
        });
        if (!old) {
          const key = withoutCase(filePath);
          const count = this.filesWithoutCase.get(key);
          this.filesWithoutCase.set(key, (count || 0) + 1);
          if (count !== void 0) {
            this.doScan(false);
          }
          this.forEachWatcher(filePath, (w) => {
            if (!initial || w.checkStartTime(safeTime, initial)) {
              w.emit("change", mtime, type);
            }
          });
        } else if (!initial) {
          this.forEachWatcher(filePath, (w) => w.emit("change", mtime, type));
        }
        this.forEachWatcher(this.path, (w) => {
          if (!initial || w.checkStartTime(safeTime, initial)) {
            w.emit("change", filePath, safeTime, type, initial);
          }
        });
      }
      setDirectory(directoryPath, birthtime, initial, type) {
        if (this.ignored(directoryPath)) return;
        if (directoryPath === this.path) {
          if (!initial) {
            this.forEachWatcher(
              this.path,
              (w) => w.emit("change", directoryPath, birthtime, type, initial)
            );
          }
        } else {
          const old = this.directories.get(directoryPath);
          if (!old) {
            const now = Date.now();
            if (this.nestedWatching) {
              this.createNestedWatcher(directoryPath);
            } else {
              this.directories.set(directoryPath, true);
            }
            let safeTime;
            if (initial) {
              safeTime = Math.min(now, birthtime) + FS_ACCURACY;
            } else {
              safeTime = now;
            }
            this.forEachWatcher(directoryPath, (w) => {
              if (!initial || w.checkStartTime(safeTime, false)) {
                w.emit("change", birthtime, type);
              }
            });
            this.forEachWatcher(this.path, (w) => {
              if (!initial || w.checkStartTime(safeTime, initial)) {
                w.emit("change", directoryPath, safeTime, type, initial);
              }
            });
          }
        }
      }
      createNestedWatcher(directoryPath) {
        const watcher = this.watcherManager.watchDirectory(directoryPath, 1);
        watcher.on("change", (filePath, mtime, type, initial) => {
          this.forEachWatcher(this.path, (w) => {
            if (!initial || w.checkStartTime(mtime, initial)) {
              w.emit("change", filePath, mtime, type, initial);
            }
          });
        });
        this.directories.set(directoryPath, watcher);
      }
      setNestedWatching(flag) {
        if (this.nestedWatching !== !!flag) {
          this.nestedWatching = !!flag;
          if (this.nestedWatching) {
            for (const directory of this.directories.keys()) {
              this.createNestedWatcher(directory);
            }
          } else {
            for (const [directory, watcher] of this.directories) {
              watcher.close();
              this.directories.set(directory, true);
            }
          }
        }
      }
      watch(filePath, startTime) {
        const key = withoutCase(filePath);
        let watchers = this.watchers.get(key);
        if (watchers === void 0) {
          watchers = /* @__PURE__ */ new Set();
          this.watchers.set(key, watchers);
        }
        this.refs++;
        const watcher = new Watcher(this, filePath, startTime);
        watcher.on("closed", () => {
          if (--this.refs <= 0) {
            this.close();
            return;
          }
          watchers.delete(watcher);
          if (watchers.size === 0) {
            this.watchers.delete(key);
            if (this.path === filePath) this.setNestedWatching(false);
          }
        });
        watchers.add(watcher);
        let safeTime;
        if (filePath === this.path) {
          this.setNestedWatching(true);
          safeTime = this.lastWatchEvent;
          for (const entry of this.files.values()) {
            fixupEntryAccuracy(entry);
            safeTime = Math.max(safeTime, entry.safeTime);
          }
        } else {
          const entry = this.files.get(filePath);
          if (entry) {
            fixupEntryAccuracy(entry);
            safeTime = entry.safeTime;
          } else {
            safeTime = 0;
          }
        }
        if (safeTime) {
          if (safeTime >= startTime) {
            process.nextTick(() => {
              if (this.closed) return;
              if (filePath === this.path) {
                watcher.emit(
                  "change",
                  filePath,
                  safeTime,
                  "watch (outdated on attach)",
                  true
                );
              } else {
                watcher.emit(
                  "change",
                  safeTime,
                  "watch (outdated on attach)",
                  true
                );
              }
            });
          }
        } else if (this.initialScan) {
          if (this.initialScanRemoved.has(filePath)) {
            process.nextTick(() => {
              if (this.closed) return;
              watcher.emit("remove");
            });
          }
        } else if (filePath !== this.path && !this.directories.has(filePath) && watcher.checkStartTime(this.initialScanFinished, false)) {
          process.nextTick(() => {
            if (this.closed) return;
            watcher.emit("initial-missing", "watch (missing on attach)");
          });
        }
        return watcher;
      }
      onWatchEvent(eventType, filename) {
        if (this.closed) return;
        if (!filename) {
          this.doScan(false);
          return;
        }
        const filePath = path2.join(this.path, filename);
        if (this.ignored(filePath)) return;
        if (this._activeEvents.get(filename) === void 0) {
          this._activeEvents.set(filename, false);
          const checkStats = /* @__PURE__ */ __name(() => {
            if (this.closed) return;
            this._activeEvents.set(filename, false);
            fs6.lstat(filePath, (err, stats) => {
              if (this.closed) return;
              if (this._activeEvents.get(filename) === true) {
                process.nextTick(checkStats);
                return;
              }
              this._activeEvents.delete(filename);
              if (err) {
                if (err.code !== "ENOENT" && err.code !== "EPERM" && err.code !== "EBUSY") {
                  this.onStatsError(err);
                } else {
                  if (filename === path2.basename(this.path)) {
                    if (!fs6.existsSync(this.path)) {
                      this.onDirectoryRemoved("stat failed");
                    }
                  }
                }
              }
              this.lastWatchEvent = Date.now();
              if (!stats) {
                this.setMissing(filePath, false, eventType);
              } else if (stats.isDirectory()) {
                this.setDirectory(
                  filePath,
                  +stats.birthtime || 1,
                  false,
                  eventType
                );
              } else if (stats.isFile() || stats.isSymbolicLink()) {
                if (stats.mtime) {
                  ensureFsAccuracy(stats.mtime);
                }
                this.setFileTime(
                  filePath,
                  +stats.mtime || +stats.ctime || 1,
                  false,
                  false,
                  eventType
                );
              }
            });
          }, "checkStats");
          process.nextTick(checkStats);
        } else {
          this._activeEvents.set(filename, true);
        }
      }
      onWatcherError(err) {
        if (this.closed) return;
        if (err) {
          if (err.code !== "EPERM" && err.code !== "ENOENT") {
            console.error("Watchpack Error (watcher): " + err);
          }
          this.onDirectoryRemoved("watch error");
        }
      }
      onStatsError(err) {
        if (err) {
          console.error("Watchpack Error (stats): " + err);
        }
      }
      onScanError(err) {
        if (err) {
          console.error("Watchpack Error (initial scan): " + err);
        }
        this.onScanFinished();
      }
      onScanFinished() {
        if (this.polledWatching) {
          this.timeout = setTimeout(() => {
            if (this.closed) return;
            this.doScan(false);
          }, this.polledWatching);
        }
      }
      onDirectoryRemoved(reason) {
        if (this.watcher) {
          this.watcher.close();
          this.watcher = null;
        }
        this.watchInParentDirectory();
        const type = `directory-removed (${reason})`;
        for (const directory of this.directories.keys()) {
          this.setMissing(directory, null, type);
        }
        for (const file of this.files.keys()) {
          this.setMissing(file, null, type);
        }
      }
      watchInParentDirectory() {
        if (!this.parentWatcher) {
          const parentDir = path2.dirname(this.path);
          if (path2.dirname(parentDir) === parentDir) return;
          this.parentWatcher = this.watcherManager.watchFile(this.path, 1);
          this.parentWatcher.on("change", (mtime, type) => {
            if (this.closed) return;
            if ((!IS_OSX || this.polledWatching) && this.parentWatcher) {
              this.parentWatcher.close();
              this.parentWatcher = null;
            }
            if (!this.watcher) {
              this.createWatcher();
              this.doScan(false);
              this.forEachWatcher(
                this.path,
                (w) => w.emit("change", this.path, mtime, type, false)
              );
            }
          });
          this.parentWatcher.on("remove", () => {
            this.onDirectoryRemoved("parent directory removed");
          });
        }
      }
      doScan(initial) {
        if (this.scanning) {
          if (this.scanAgain) {
            if (!initial) this.scanAgainInitial = false;
          } else {
            this.scanAgain = true;
            this.scanAgainInitial = initial;
          }
          return;
        }
        this.scanning = true;
        if (this.timeout) {
          clearTimeout(this.timeout);
          this.timeout = void 0;
        }
        process.nextTick(() => {
          if (this.closed) return;
          fs6.readdir(this.path, (err, items) => {
            if (this.closed) return;
            if (err) {
              if (err.code === "ENOENT" || err.code === "EPERM") {
                this.onDirectoryRemoved("scan readdir failed");
              } else {
                this.onScanError(err);
              }
              this.initialScan = false;
              this.initialScanFinished = Date.now();
              if (initial) {
                for (const watchers of this.watchers.values()) {
                  for (const watcher of watchers) {
                    if (watcher.checkStartTime(this.initialScanFinished, false)) {
                      watcher.emit(
                        "initial-missing",
                        "scan (parent directory missing in initial scan)"
                      );
                    }
                  }
                }
              }
              if (this.scanAgain) {
                this.scanAgain = false;
                this.doScan(this.scanAgainInitial);
              } else {
                this.scanning = false;
              }
              return;
            }
            const itemPaths = new Set(
              items.map((item) => path2.join(this.path, item.normalize("NFC")))
            );
            for (const file of this.files.keys()) {
              if (!itemPaths.has(file)) {
                this.setMissing(file, initial, "scan (missing)");
              }
            }
            for (const directory of this.directories.keys()) {
              if (!itemPaths.has(directory)) {
                this.setMissing(directory, initial, "scan (missing)");
              }
            }
            if (this.scanAgain) {
              this.scanAgain = false;
              this.doScan(initial);
              return;
            }
            const itemFinished = needCalls(itemPaths.size + 1, () => {
              if (this.closed) return;
              this.initialScan = false;
              this.initialScanRemoved = null;
              this.initialScanFinished = Date.now();
              if (initial) {
                const missingWatchers = new Map(this.watchers);
                missingWatchers.delete(withoutCase(this.path));
                for (const item of itemPaths) {
                  missingWatchers.delete(withoutCase(item));
                }
                for (const watchers of missingWatchers.values()) {
                  for (const watcher of watchers) {
                    if (watcher.checkStartTime(this.initialScanFinished, false)) {
                      watcher.emit(
                        "initial-missing",
                        "scan (missing in initial scan)"
                      );
                    }
                  }
                }
              }
              if (this.scanAgain) {
                this.scanAgain = false;
                this.doScan(this.scanAgainInitial);
              } else {
                this.scanning = false;
                this.onScanFinished();
              }
            });
            for (const itemPath of itemPaths) {
              fs6.lstat(itemPath, (err2, stats) => {
                if (this.closed) return;
                if (err2) {
                  if (err2.code === "ENOENT" || err2.code === "EPERM" || err2.code === "EACCES" || err2.code === "EBUSY" || // TODO https://github.com/libuv/libuv/pull/4566
                  err2.code === "EINVAL" && IS_WIN) {
                    this.setMissing(itemPath, initial, "scan (" + err2.code + ")");
                  } else {
                    this.onScanError(err2);
                  }
                  itemFinished();
                  return;
                }
                if (stats.isFile() || stats.isSymbolicLink()) {
                  if (stats.mtime) {
                    ensureFsAccuracy(stats.mtime);
                  }
                  this.setFileTime(
                    itemPath,
                    +stats.mtime || +stats.ctime || 1,
                    initial,
                    true,
                    "scan (file)"
                  );
                } else if (stats.isDirectory()) {
                  if (!initial || !this.directories.has(itemPath))
                    this.setDirectory(
                      itemPath,
                      +stats.birthtime || 1,
                      initial,
                      "scan (dir)"
                    );
                }
                itemFinished();
              });
            }
            itemFinished();
          });
        });
      }
      getTimes() {
        const obj = /* @__PURE__ */ Object.create(null);
        let safeTime = this.lastWatchEvent;
        for (const [file, entry] of this.files) {
          fixupEntryAccuracy(entry);
          safeTime = Math.max(safeTime, entry.safeTime);
          obj[file] = Math.max(entry.safeTime, entry.timestamp);
        }
        if (this.nestedWatching) {
          for (const w of this.directories.values()) {
            const times = w.directoryWatcher.getTimes();
            for (const file of Object.keys(times)) {
              const time = times[file];
              safeTime = Math.max(safeTime, time);
              obj[file] = time;
            }
          }
          obj[this.path] = safeTime;
        }
        if (!this.initialScan) {
          for (const watchers of this.watchers.values()) {
            for (const watcher of watchers) {
              const path3 = watcher.path;
              if (!Object.prototype.hasOwnProperty.call(obj, path3)) {
                obj[path3] = null;
              }
            }
          }
        }
        return obj;
      }
      collectTimeInfoEntries(fileTimestamps, directoryTimestamps) {
        let safeTime = this.lastWatchEvent;
        for (const [file, entry] of this.files) {
          fixupEntryAccuracy(entry);
          safeTime = Math.max(safeTime, entry.safeTime);
          fileTimestamps.set(file, entry);
        }
        if (this.nestedWatching) {
          for (const w of this.directories.values()) {
            safeTime = Math.max(
              safeTime,
              w.directoryWatcher.collectTimeInfoEntries(
                fileTimestamps,
                directoryTimestamps
              )
            );
          }
          fileTimestamps.set(this.path, EXISTANCE_ONLY_TIME_ENTRY);
          directoryTimestamps.set(this.path, {
            safeTime
          });
        } else {
          for (const dir of this.directories.keys()) {
            fileTimestamps.set(dir, EXISTANCE_ONLY_TIME_ENTRY);
            if (!directoryTimestamps.has(dir))
              directoryTimestamps.set(dir, EXISTANCE_ONLY_TIME_ENTRY);
          }
          fileTimestamps.set(this.path, EXISTANCE_ONLY_TIME_ENTRY);
          directoryTimestamps.set(this.path, EXISTANCE_ONLY_TIME_ENTRY);
        }
        if (!this.initialScan) {
          for (const watchers of this.watchers.values()) {
            for (const watcher of watchers) {
              const path3 = watcher.path;
              if (!fileTimestamps.has(path3)) {
                fileTimestamps.set(path3, null);
              }
            }
          }
        }
        return safeTime;
      }
      close() {
        this.closed = true;
        this.initialScan = false;
        if (this.watcher) {
          this.watcher.close();
          this.watcher = null;
        }
        if (this.nestedWatching) {
          for (const w of this.directories.values()) {
            w.close();
          }
          this.directories.clear();
        }
        if (this.parentWatcher) {
          this.parentWatcher.close();
          this.parentWatcher = null;
        }
        this.emit("closed");
      }
    };
    module.exports = DirectoryWatcher;
    module.exports.EXISTANCE_ONLY_TIME_ENTRY = EXISTANCE_ONLY_TIME_ENTRY;
    function fixupEntryAccuracy(entry) {
      if (entry.accuracy > FS_ACCURACY) {
        entry.safeTime = entry.safeTime - entry.accuracy + FS_ACCURACY;
        entry.accuracy = FS_ACCURACY;
      }
    }
    __name(fixupEntryAccuracy, "fixupEntryAccuracy");
    function ensureFsAccuracy(mtime) {
      if (!mtime) return;
      if (FS_ACCURACY > 1 && mtime % 1 !== 0) FS_ACCURACY = 1;
      else if (FS_ACCURACY > 10 && mtime % 10 !== 0) FS_ACCURACY = 10;
      else if (FS_ACCURACY > 100 && mtime % 100 !== 0) FS_ACCURACY = 100;
      else if (FS_ACCURACY > 1e3 && mtime % 1e3 !== 0) FS_ACCURACY = 1e3;
    }
    __name(ensureFsAccuracy, "ensureFsAccuracy");
  }
});

// ../node_modules/watchpack/lib/getWatcherManager.js
var require_getWatcherManager = __commonJS({
  "../node_modules/watchpack/lib/getWatcherManager.js"(exports, module) {
    "use strict";
    var path2 = __require("path");
    var DirectoryWatcher = require_DirectoryWatcher();
    var WatcherManager = class {
      static {
        __name(this, "WatcherManager");
      }
      constructor(options) {
        this.options = options;
        this.directoryWatchers = /* @__PURE__ */ new Map();
      }
      getDirectoryWatcher(directory) {
        const watcher = this.directoryWatchers.get(directory);
        if (watcher === void 0) {
          const newWatcher = new DirectoryWatcher(this, directory, this.options);
          this.directoryWatchers.set(directory, newWatcher);
          newWatcher.on("closed", () => {
            this.directoryWatchers.delete(directory);
          });
          return newWatcher;
        }
        return watcher;
      }
      watchFile(p, startTime) {
        const directory = path2.dirname(p);
        if (directory === p) return null;
        return this.getDirectoryWatcher(directory).watch(p, startTime);
      }
      watchDirectory(directory, startTime) {
        return this.getDirectoryWatcher(directory).watch(directory, startTime);
      }
    };
    var watcherManagers = /* @__PURE__ */ new WeakMap();
    module.exports = (options) => {
      const watcherManager = watcherManagers.get(options);
      if (watcherManager !== void 0) return watcherManager;
      const newWatcherManager = new WatcherManager(options);
      watcherManagers.set(options, newWatcherManager);
      return newWatcherManager;
    };
    module.exports.WatcherManager = WatcherManager;
  }
});

// ../node_modules/watchpack/lib/LinkResolver.js
var require_LinkResolver = __commonJS({
  "../node_modules/watchpack/lib/LinkResolver.js"(exports, module) {
    "use strict";
    var fs6 = __require("fs");
    var path2 = __require("path");
    var EXPECTED_ERRORS = /* @__PURE__ */ new Set(["EINVAL", "ENOENT"]);
    if (process.platform === "win32") EXPECTED_ERRORS.add("UNKNOWN");
    var LinkResolver = class {
      static {
        __name(this, "LinkResolver");
      }
      constructor() {
        this.cache = /* @__PURE__ */ new Map();
      }
      /**
       * @param {string} file path to file or directory
       * @returns {string[]} array of file and all symlinks contributed in the resolving process (first item is the resolved file)
       */
      resolve(file) {
        const cacheEntry = this.cache.get(file);
        if (cacheEntry !== void 0) {
          return cacheEntry;
        }
        const parent = path2.dirname(file);
        if (parent === file) {
          const result = Object.freeze([file]);
          this.cache.set(file, result);
          return result;
        }
        const parentResolved = this.resolve(parent);
        let realFile = file;
        if (parentResolved[0] !== parent) {
          const basename4 = path2.basename(file);
          realFile = path2.resolve(parentResolved[0], basename4);
        }
        try {
          const linkContent = fs6.readlinkSync(realFile);
          const resolvedLink = path2.resolve(parentResolved[0], linkContent);
          const linkResolved = this.resolve(resolvedLink);
          let result;
          if (linkResolved.length > 1 && parentResolved.length > 1) {
            const resultSet = new Set(linkResolved);
            resultSet.add(realFile);
            for (let i = 1; i < parentResolved.length; i++) {
              resultSet.add(parentResolved[i]);
            }
            result = Object.freeze(Array.from(resultSet));
          } else if (parentResolved.length > 1) {
            result = parentResolved.slice();
            result[0] = linkResolved[0];
            result.push(realFile);
            Object.freeze(result);
          } else if (linkResolved.length > 1) {
            result = linkResolved.slice();
            result.push(realFile);
            Object.freeze(result);
          } else {
            result = Object.freeze([
              // the resolve real location
              linkResolved[0],
              // add the link
              realFile
            ]);
          }
          this.cache.set(file, result);
          return result;
        } catch (e) {
          if (!EXPECTED_ERRORS.has(e.code)) {
            throw e;
          }
          const result = parentResolved.slice();
          result[0] = realFile;
          Object.freeze(result);
          this.cache.set(file, result);
          return result;
        }
      }
    };
    module.exports = LinkResolver;
  }
});

// ../node_modules/glob-to-regexp/index.js
var require_glob_to_regexp = __commonJS({
  "../node_modules/glob-to-regexp/index.js"(exports, module) {
    module.exports = function(glob, opts) {
      if (typeof glob !== "string") {
        throw new TypeError("Expected a string");
      }
      var str = String(glob);
      var reStr = "";
      var extended = opts ? !!opts.extended : false;
      var globstar = opts ? !!opts.globstar : false;
      var inGroup = false;
      var flags = opts && typeof opts.flags === "string" ? opts.flags : "";
      var c;
      for (var i = 0, len = str.length; i < len; i++) {
        c = str[i];
        switch (c) {
          case "/":
          case "$":
          case "^":
          case "+":
          case ".":
          case "(":
          case ")":
          case "=":
          case "!":
          case "|":
            reStr += "\\" + c;
            break;
          case "?":
            if (extended) {
              reStr += ".";
              break;
            }
          case "[":
          case "]":
            if (extended) {
              reStr += c;
              break;
            }
          case "{":
            if (extended) {
              inGroup = true;
              reStr += "(";
              break;
            }
          case "}":
            if (extended) {
              inGroup = false;
              reStr += ")";
              break;
            }
          case ",":
            if (inGroup) {
              reStr += "|";
              break;
            }
            reStr += "\\" + c;
            break;
          case "*":
            var prevChar = str[i - 1];
            var starCount = 1;
            while (str[i + 1] === "*") {
              starCount++;
              i++;
            }
            var nextChar = str[i + 1];
            if (!globstar) {
              reStr += ".*";
            } else {
              var isGlobstar = starCount > 1 && (prevChar === "/" || prevChar === void 0) && (nextChar === "/" || nextChar === void 0);
              if (isGlobstar) {
                reStr += "((?:[^/]*(?:/|$))*)";
                i++;
              } else {
                reStr += "([^/]*)";
              }
            }
            break;
          default:
            reStr += c;
        }
      }
      if (!flags || !~flags.indexOf("g")) {
        reStr = "^" + reStr + "$";
      }
      return new RegExp(reStr, flags);
    };
  }
});

// ../node_modules/watchpack/lib/watchpack.js
var require_watchpack = __commonJS({
  "../node_modules/watchpack/lib/watchpack.js"(exports, module) {
    "use strict";
    var getWatcherManager = require_getWatcherManager();
    var LinkResolver = require_LinkResolver();
    var EventEmitter = __require("events").EventEmitter;
    var globToRegExp = require_glob_to_regexp();
    var watchEventSource = require_watchEventSource();
    var EMPTY_ARRAY = [];
    var EMPTY_OPTIONS = {};
    function addWatchersToSet(watchers, set) {
      for (const ww of watchers) {
        const w = ww.watcher;
        if (!set.has(w.directoryWatcher)) {
          set.add(w.directoryWatcher);
        }
      }
    }
    __name(addWatchersToSet, "addWatchersToSet");
    var stringToRegexp = /* @__PURE__ */ __name((ignored) => {
      if (ignored.length === 0) {
        return;
      }
      const source = globToRegExp(ignored, { globstar: true, extended: true }).source;
      return source.slice(0, source.length - 1) + "(?:$|\\/)";
    }, "stringToRegexp");
    var ignoredToFunction = /* @__PURE__ */ __name((ignored) => {
      if (Array.isArray(ignored)) {
        const stringRegexps = ignored.map((i) => stringToRegexp(i)).filter(Boolean);
        if (stringRegexps.length === 0) {
          return () => false;
        }
        const regexp = new RegExp(stringRegexps.join("|"));
        return (x) => regexp.test(x.replace(/\\/g, "/"));
      } else if (typeof ignored === "string") {
        const stringRegexp = stringToRegexp(ignored);
        if (!stringRegexp) {
          return () => false;
        }
        const regexp = new RegExp(stringRegexp);
        return (x) => regexp.test(x.replace(/\\/g, "/"));
      } else if (ignored instanceof RegExp) {
        return (x) => ignored.test(x.replace(/\\/g, "/"));
      } else if (ignored instanceof Function) {
        return ignored;
      } else if (ignored) {
        throw new Error(`Invalid option for 'ignored': ${ignored}`);
      } else {
        return () => false;
      }
    }, "ignoredToFunction");
    var normalizeOptions = /* @__PURE__ */ __name((options) => {
      return {
        followSymlinks: !!options.followSymlinks,
        ignored: ignoredToFunction(options.ignored),
        poll: options.poll
      };
    }, "normalizeOptions");
    var normalizeCache = /* @__PURE__ */ new WeakMap();
    var cachedNormalizeOptions = /* @__PURE__ */ __name((options) => {
      const cacheEntry = normalizeCache.get(options);
      if (cacheEntry !== void 0) return cacheEntry;
      const normalized = normalizeOptions(options);
      normalizeCache.set(options, normalized);
      return normalized;
    }, "cachedNormalizeOptions");
    var WatchpackFileWatcher = class {
      static {
        __name(this, "WatchpackFileWatcher");
      }
      constructor(watchpack, watcher, files) {
        this.files = Array.isArray(files) ? files : [files];
        this.watcher = watcher;
        watcher.on("initial-missing", (type) => {
          for (const file of this.files) {
            if (!watchpack._missing.has(file))
              watchpack._onRemove(file, file, type);
          }
        });
        watcher.on("change", (mtime, type) => {
          for (const file of this.files) {
            watchpack._onChange(file, mtime, file, type);
          }
        });
        watcher.on("remove", (type) => {
          for (const file of this.files) {
            watchpack._onRemove(file, file, type);
          }
        });
      }
      update(files) {
        if (!Array.isArray(files)) {
          if (this.files.length !== 1) {
            this.files = [files];
          } else if (this.files[0] !== files) {
            this.files[0] = files;
          }
        } else {
          this.files = files;
        }
      }
      close() {
        this.watcher.close();
      }
    };
    var WatchpackDirectoryWatcher = class {
      static {
        __name(this, "WatchpackDirectoryWatcher");
      }
      constructor(watchpack, watcher, directories) {
        this.directories = Array.isArray(directories) ? directories : [directories];
        this.watcher = watcher;
        watcher.on("initial-missing", (type) => {
          for (const item of this.directories) {
            watchpack._onRemove(item, item, type);
          }
        });
        watcher.on("change", (file, mtime, type) => {
          for (const item of this.directories) {
            watchpack._onChange(item, mtime, file, type);
          }
        });
        watcher.on("remove", (type) => {
          for (const item of this.directories) {
            watchpack._onRemove(item, item, type);
          }
        });
      }
      update(directories) {
        if (!Array.isArray(directories)) {
          if (this.directories.length !== 1) {
            this.directories = [directories];
          } else if (this.directories[0] !== directories) {
            this.directories[0] = directories;
          }
        } else {
          this.directories = directories;
        }
      }
      close() {
        this.watcher.close();
      }
    };
    var Watchpack3 = class extends EventEmitter {
      static {
        __name(this, "Watchpack");
      }
      constructor(options) {
        super();
        if (!options) options = EMPTY_OPTIONS;
        this.options = options;
        this.aggregateTimeout = typeof options.aggregateTimeout === "number" ? options.aggregateTimeout : 200;
        this.watcherOptions = cachedNormalizeOptions(options);
        this.watcherManager = getWatcherManager(this.watcherOptions);
        this.fileWatchers = /* @__PURE__ */ new Map();
        this.directoryWatchers = /* @__PURE__ */ new Map();
        this._missing = /* @__PURE__ */ new Set();
        this.startTime = void 0;
        this.paused = false;
        this.aggregatedChanges = /* @__PURE__ */ new Set();
        this.aggregatedRemovals = /* @__PURE__ */ new Set();
        this.aggregateTimer = void 0;
        this._onTimeout = this._onTimeout.bind(this);
      }
      watch(arg1, arg2, arg3) {
        let files, directories, missing, startTime;
        if (!arg2) {
          ({
            files = EMPTY_ARRAY,
            directories = EMPTY_ARRAY,
            missing = EMPTY_ARRAY,
            startTime
          } = arg1);
        } else {
          files = arg1;
          directories = arg2;
          missing = EMPTY_ARRAY;
          startTime = arg3;
        }
        this.paused = false;
        const fileWatchers = this.fileWatchers;
        const directoryWatchers = this.directoryWatchers;
        const ignored = this.watcherOptions.ignored;
        const filter = /* @__PURE__ */ __name((path2) => !ignored(path2), "filter");
        const addToMap = /* @__PURE__ */ __name((map, key, item) => {
          const list = map.get(key);
          if (list === void 0) {
            map.set(key, item);
          } else if (Array.isArray(list)) {
            list.push(item);
          } else {
            map.set(key, [list, item]);
          }
        }, "addToMap");
        const fileWatchersNeeded = /* @__PURE__ */ new Map();
        const directoryWatchersNeeded = /* @__PURE__ */ new Map();
        const missingFiles = /* @__PURE__ */ new Set();
        if (this.watcherOptions.followSymlinks) {
          const resolver = new LinkResolver();
          for (const file of files) {
            if (filter(file)) {
              for (const innerFile of resolver.resolve(file)) {
                if (file === innerFile || filter(innerFile)) {
                  addToMap(fileWatchersNeeded, innerFile, file);
                }
              }
            }
          }
          for (const file of missing) {
            if (filter(file)) {
              for (const innerFile of resolver.resolve(file)) {
                if (file === innerFile || filter(innerFile)) {
                  missingFiles.add(file);
                  addToMap(fileWatchersNeeded, innerFile, file);
                }
              }
            }
          }
          for (const dir of directories) {
            if (filter(dir)) {
              let first = true;
              for (const innerItem of resolver.resolve(dir)) {
                if (filter(innerItem)) {
                  addToMap(
                    first ? directoryWatchersNeeded : fileWatchersNeeded,
                    innerItem,
                    dir
                  );
                }
                first = false;
              }
            }
          }
        } else {
          for (const file of files) {
            if (filter(file)) {
              addToMap(fileWatchersNeeded, file, file);
            }
          }
          for (const file of missing) {
            if (filter(file)) {
              missingFiles.add(file);
              addToMap(fileWatchersNeeded, file, file);
            }
          }
          for (const dir of directories) {
            if (filter(dir)) {
              addToMap(directoryWatchersNeeded, dir, dir);
            }
          }
        }
        for (const [key, w] of fileWatchers) {
          const needed = fileWatchersNeeded.get(key);
          if (needed === void 0) {
            w.close();
            fileWatchers.delete(key);
          } else {
            w.update(needed);
            fileWatchersNeeded.delete(key);
          }
        }
        for (const [key, w] of directoryWatchers) {
          const needed = directoryWatchersNeeded.get(key);
          if (needed === void 0) {
            w.close();
            directoryWatchers.delete(key);
          } else {
            w.update(needed);
            directoryWatchersNeeded.delete(key);
          }
        }
        watchEventSource.batch(() => {
          for (const [key, files2] of fileWatchersNeeded) {
            const watcher = this.watcherManager.watchFile(key, startTime);
            if (watcher) {
              fileWatchers.set(key, new WatchpackFileWatcher(this, watcher, files2));
            }
          }
          for (const [key, directories2] of directoryWatchersNeeded) {
            const watcher = this.watcherManager.watchDirectory(key, startTime);
            if (watcher) {
              directoryWatchers.set(
                key,
                new WatchpackDirectoryWatcher(this, watcher, directories2)
              );
            }
          }
        });
        this._missing = missingFiles;
        this.startTime = startTime;
      }
      close() {
        this.paused = true;
        if (this.aggregateTimer) clearTimeout(this.aggregateTimer);
        for (const w of this.fileWatchers.values()) w.close();
        for (const w of this.directoryWatchers.values()) w.close();
        this.fileWatchers.clear();
        this.directoryWatchers.clear();
      }
      pause() {
        this.paused = true;
        if (this.aggregateTimer) clearTimeout(this.aggregateTimer);
      }
      getTimes() {
        const directoryWatchers = /* @__PURE__ */ new Set();
        addWatchersToSet(this.fileWatchers.values(), directoryWatchers);
        addWatchersToSet(this.directoryWatchers.values(), directoryWatchers);
        const obj = /* @__PURE__ */ Object.create(null);
        for (const w of directoryWatchers) {
          const times = w.getTimes();
          for (const file of Object.keys(times)) obj[file] = times[file];
        }
        return obj;
      }
      getTimeInfoEntries() {
        const map = /* @__PURE__ */ new Map();
        this.collectTimeInfoEntries(map, map);
        return map;
      }
      collectTimeInfoEntries(fileTimestamps, directoryTimestamps) {
        const allWatchers = /* @__PURE__ */ new Set();
        addWatchersToSet(this.fileWatchers.values(), allWatchers);
        addWatchersToSet(this.directoryWatchers.values(), allWatchers);
        const safeTime = { value: 0 };
        for (const w of allWatchers) {
          w.collectTimeInfoEntries(fileTimestamps, directoryTimestamps, safeTime);
        }
      }
      getAggregated() {
        if (this.aggregateTimer) {
          clearTimeout(this.aggregateTimer);
          this.aggregateTimer = void 0;
        }
        const changes = this.aggregatedChanges;
        const removals = this.aggregatedRemovals;
        this.aggregatedChanges = /* @__PURE__ */ new Set();
        this.aggregatedRemovals = /* @__PURE__ */ new Set();
        return { changes, removals };
      }
      _onChange(item, mtime, file, type) {
        file = file || item;
        if (!this.paused) {
          this.emit("change", file, mtime, type);
          if (this.aggregateTimer) clearTimeout(this.aggregateTimer);
          this.aggregateTimer = setTimeout(this._onTimeout, this.aggregateTimeout);
        }
        this.aggregatedRemovals.delete(item);
        this.aggregatedChanges.add(item);
      }
      _onRemove(item, file, type) {
        file = file || item;
        if (!this.paused) {
          this.emit("remove", file, type);
          if (this.aggregateTimer) clearTimeout(this.aggregateTimer);
          this.aggregateTimer = setTimeout(this._onTimeout, this.aggregateTimeout);
        }
        this.aggregatedChanges.delete(item);
        this.aggregatedRemovals.add(item);
      }
      _onTimeout() {
        this.aggregateTimer = void 0;
        const changes = this.aggregatedChanges;
        const removals = this.aggregatedRemovals;
        this.aggregatedChanges = /* @__PURE__ */ new Set();
        this.aggregatedRemovals = /* @__PURE__ */ new Set();
        this.emit("aggregated", changes, removals);
      }
    };
    module.exports = Watchpack3;
  }
});

// ../node_modules/telejson/dist/index.js
var require_dist2 = __commonJS({
  "../node_modules/telejson/dist/index.js"(exports, module) {
    "use strict";
    var __create = Object.create;
    var __defProp = Object.defineProperty;
    var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames = Object.getOwnPropertyNames;
    var __getProtoOf = Object.getPrototypeOf;
    var __hasOwnProp = Object.prototype.hasOwnProperty;
    var __commonJS2 = /* @__PURE__ */ __name((cb, mod) => /* @__PURE__ */ __name(function __require2() {
      return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
    }, "__require"), "__commonJS");
    var __export = /* @__PURE__ */ __name((target, all) => {
      for (var name in all)
        __defProp(target, name, { get: all[name], enumerable: true });
    }, "__export");
    var __copyProps = /* @__PURE__ */ __name((to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))
          if (!__hasOwnProp.call(to, key) && key !== except)
            __defProp(to, key, { get: /* @__PURE__ */ __name(() => from[key], "get"), enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
      }
      return to;
    }, "__copyProps");
    var __toESM2 = /* @__PURE__ */ __name((mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
      // If the importer is in node compatibility mode or this is not an ESM
      // file that has been converted to a CommonJS file using a Babel-
      // compatible transform (i.e. "__esModule" has not been set), then set
      // "default" to the CommonJS "module.exports" for node compatibility.
      isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
      mod
    )), "__toESM");
    var __toCommonJS = /* @__PURE__ */ __name((mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod), "__toCommonJS");
    var require_es_object_atoms = __commonJS2({
      "node_modules/.pnpm/es-object-atoms@1.1.1/node_modules/es-object-atoms/index.js"(exports2, module2) {
        "use strict";
        module2.exports = Object;
      }
    });
    var require_es_errors = __commonJS2({
      "node_modules/.pnpm/es-errors@1.3.0/node_modules/es-errors/index.js"(exports2, module2) {
        "use strict";
        module2.exports = Error;
      }
    });
    var require_eval = __commonJS2({
      "node_modules/.pnpm/es-errors@1.3.0/node_modules/es-errors/eval.js"(exports2, module2) {
        "use strict";
        module2.exports = EvalError;
      }
    });
    var require_range = __commonJS2({
      "node_modules/.pnpm/es-errors@1.3.0/node_modules/es-errors/range.js"(exports2, module2) {
        "use strict";
        module2.exports = RangeError;
      }
    });
    var require_ref = __commonJS2({
      "node_modules/.pnpm/es-errors@1.3.0/node_modules/es-errors/ref.js"(exports2, module2) {
        "use strict";
        module2.exports = ReferenceError;
      }
    });
    var require_syntax = __commonJS2({
      "node_modules/.pnpm/es-errors@1.3.0/node_modules/es-errors/syntax.js"(exports2, module2) {
        "use strict";
        module2.exports = SyntaxError;
      }
    });
    var require_type = __commonJS2({
      "node_modules/.pnpm/es-errors@1.3.0/node_modules/es-errors/type.js"(exports2, module2) {
        "use strict";
        module2.exports = TypeError;
      }
    });
    var require_uri = __commonJS2({
      "node_modules/.pnpm/es-errors@1.3.0/node_modules/es-errors/uri.js"(exports2, module2) {
        "use strict";
        module2.exports = URIError;
      }
    });
    var require_abs = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/abs.js"(exports2, module2) {
        "use strict";
        module2.exports = Math.abs;
      }
    });
    var require_floor = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/floor.js"(exports2, module2) {
        "use strict";
        module2.exports = Math.floor;
      }
    });
    var require_max = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/max.js"(exports2, module2) {
        "use strict";
        module2.exports = Math.max;
      }
    });
    var require_min = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/min.js"(exports2, module2) {
        "use strict";
        module2.exports = Math.min;
      }
    });
    var require_pow = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/pow.js"(exports2, module2) {
        "use strict";
        module2.exports = Math.pow;
      }
    });
    var require_round = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/round.js"(exports2, module2) {
        "use strict";
        module2.exports = Math.round;
      }
    });
    var require_isNaN = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/isNaN.js"(exports2, module2) {
        "use strict";
        module2.exports = Number.isNaN || /* @__PURE__ */ __name(function isNaN2(a) {
          return a !== a;
        }, "isNaN2");
      }
    });
    var require_sign = __commonJS2({
      "node_modules/.pnpm/math-intrinsics@1.1.0/node_modules/math-intrinsics/sign.js"(exports2, module2) {
        "use strict";
        var $isNaN = require_isNaN();
        module2.exports = /* @__PURE__ */ __name(function sign(number) {
          if ($isNaN(number) || number === 0) {
            return number;
          }
          return number < 0 ? -1 : 1;
        }, "sign");
      }
    });
    var require_gOPD = __commonJS2({
      "node_modules/.pnpm/gopd@1.2.0/node_modules/gopd/gOPD.js"(exports2, module2) {
        "use strict";
        module2.exports = Object.getOwnPropertyDescriptor;
      }
    });
    var require_gopd = __commonJS2({
      "node_modules/.pnpm/gopd@1.2.0/node_modules/gopd/index.js"(exports2, module2) {
        "use strict";
        var $gOPD = require_gOPD();
        if ($gOPD) {
          try {
            $gOPD([], "length");
          } catch (e) {
            $gOPD = null;
          }
        }
        module2.exports = $gOPD;
      }
    });
    var require_es_define_property = __commonJS2({
      "node_modules/.pnpm/es-define-property@1.0.1/node_modules/es-define-property/index.js"(exports2, module2) {
        "use strict";
        var $defineProperty = Object.defineProperty || false;
        if ($defineProperty) {
          try {
            $defineProperty({}, "a", { value: 1 });
          } catch (e) {
            $defineProperty = false;
          }
        }
        module2.exports = $defineProperty;
      }
    });
    var require_shams = __commonJS2({
      "node_modules/.pnpm/has-symbols@1.1.0/node_modules/has-symbols/shams.js"(exports2, module2) {
        "use strict";
        module2.exports = /* @__PURE__ */ __name(function hasSymbols() {
          if (typeof Symbol !== "function" || typeof Object.getOwnPropertySymbols !== "function") {
            return false;
          }
          if (typeof Symbol.iterator === "symbol") {
            return true;
          }
          var obj = {};
          var sym = Symbol("test");
          var symObj = Object(sym);
          if (typeof sym === "string") {
            return false;
          }
          if (Object.prototype.toString.call(sym) !== "[object Symbol]") {
            return false;
          }
          if (Object.prototype.toString.call(symObj) !== "[object Symbol]") {
            return false;
          }
          var symVal = 42;
          obj[sym] = symVal;
          for (var _ in obj) {
            return false;
          }
          if (typeof Object.keys === "function" && Object.keys(obj).length !== 0) {
            return false;
          }
          if (typeof Object.getOwnPropertyNames === "function" && Object.getOwnPropertyNames(obj).length !== 0) {
            return false;
          }
          var syms = Object.getOwnPropertySymbols(obj);
          if (syms.length !== 1 || syms[0] !== sym) {
            return false;
          }
          if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) {
            return false;
          }
          if (typeof Object.getOwnPropertyDescriptor === "function") {
            var descriptor = (
              /** @type {PropertyDescriptor} */
              Object.getOwnPropertyDescriptor(obj, sym)
            );
            if (descriptor.value !== symVal || descriptor.enumerable !== true) {
              return false;
            }
          }
          return true;
        }, "hasSymbols");
      }
    });
    var require_has_symbols = __commonJS2({
      "node_modules/.pnpm/has-symbols@1.1.0/node_modules/has-symbols/index.js"(exports2, module2) {
        "use strict";
        var origSymbol = typeof Symbol !== "undefined" && Symbol;
        var hasSymbolSham = require_shams();
        module2.exports = /* @__PURE__ */ __name(function hasNativeSymbols() {
          if (typeof origSymbol !== "function") {
            return false;
          }
          if (typeof Symbol !== "function") {
            return false;
          }
          if (typeof origSymbol("foo") !== "symbol") {
            return false;
          }
          if (typeof Symbol("bar") !== "symbol") {
            return false;
          }
          return hasSymbolSham();
        }, "hasNativeSymbols");
      }
    });
    var require_Reflect_getPrototypeOf = __commonJS2({
      "node_modules/.pnpm/get-proto@1.0.1/node_modules/get-proto/Reflect.getPrototypeOf.js"(exports2, module2) {
        "use strict";
        module2.exports = typeof Reflect !== "undefined" && Reflect.getPrototypeOf || null;
      }
    });
    var require_Object_getPrototypeOf = __commonJS2({
      "node_modules/.pnpm/get-proto@1.0.1/node_modules/get-proto/Object.getPrototypeOf.js"(exports2, module2) {
        "use strict";
        var $Object = require_es_object_atoms();
        module2.exports = $Object.getPrototypeOf || null;
      }
    });
    var require_implementation = __commonJS2({
      "node_modules/.pnpm/function-bind@1.1.2/node_modules/function-bind/implementation.js"(exports2, module2) {
        "use strict";
        var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
        var toStr = Object.prototype.toString;
        var max = Math.max;
        var funcType = "[object Function]";
        var concatty = /* @__PURE__ */ __name(function concatty2(a, b) {
          var arr = [];
          for (var i = 0; i < a.length; i += 1) {
            arr[i] = a[i];
          }
          for (var j = 0; j < b.length; j += 1) {
            arr[j + a.length] = b[j];
          }
          return arr;
        }, "concatty2");
        var slicy = /* @__PURE__ */ __name(function slicy2(arrLike, offset) {
          var arr = [];
          for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
            arr[j] = arrLike[i];
          }
          return arr;
        }, "slicy2");
        var joiny = /* @__PURE__ */ __name(function(arr, joiner) {
          var str = "";
          for (var i = 0; i < arr.length; i += 1) {
            str += arr[i];
            if (i + 1 < arr.length) {
              str += joiner;
            }
          }
          return str;
        }, "joiny");
        module2.exports = /* @__PURE__ */ __name(function bind(that) {
          var target = this;
          if (typeof target !== "function" || toStr.apply(target) !== funcType) {
            throw new TypeError(ERROR_MESSAGE + target);
          }
          var args = slicy(arguments, 1);
          var bound;
          var binder = /* @__PURE__ */ __name(function() {
            if (this instanceof bound) {
              var result = target.apply(
                this,
                concatty(args, arguments)
              );
              if (Object(result) === result) {
                return result;
              }
              return this;
            }
            return target.apply(
              that,
              concatty(args, arguments)
            );
          }, "binder");
          var boundLength = max(0, target.length - args.length);
          var boundArgs = [];
          for (var i = 0; i < boundLength; i++) {
            boundArgs[i] = "$" + i;
          }
          bound = Function("binder", "return function (" + joiny(boundArgs, ",") + "){ return binder.apply(this,arguments); }")(binder);
          if (target.prototype) {
            var Empty = /* @__PURE__ */ __name(function Empty2() {
            }, "Empty2");
            Empty.prototype = target.prototype;
            bound.prototype = new Empty();
            Empty.prototype = null;
          }
          return bound;
        }, "bind");
      }
    });
    var require_function_bind = __commonJS2({
      "node_modules/.pnpm/function-bind@1.1.2/node_modules/function-bind/index.js"(exports2, module2) {
        "use strict";
        var implementation = require_implementation();
        module2.exports = Function.prototype.bind || implementation;
      }
    });
    var require_functionCall = __commonJS2({
      "node_modules/.pnpm/call-bind-apply-helpers@1.0.2/node_modules/call-bind-apply-helpers/functionCall.js"(exports2, module2) {
        "use strict";
        module2.exports = Function.prototype.call;
      }
    });
    var require_functionApply = __commonJS2({
      "node_modules/.pnpm/call-bind-apply-helpers@1.0.2/node_modules/call-bind-apply-helpers/functionApply.js"(exports2, module2) {
        "use strict";
        module2.exports = Function.prototype.apply;
      }
    });
    var require_reflectApply = __commonJS2({
      "node_modules/.pnpm/call-bind-apply-helpers@1.0.2/node_modules/call-bind-apply-helpers/reflectApply.js"(exports2, module2) {
        "use strict";
        module2.exports = typeof Reflect !== "undefined" && Reflect && Reflect.apply;
      }
    });
    var require_actualApply = __commonJS2({
      "node_modules/.pnpm/call-bind-apply-helpers@1.0.2/node_modules/call-bind-apply-helpers/actualApply.js"(exports2, module2) {
        "use strict";
        var bind = require_function_bind();
        var $apply = require_functionApply();
        var $call = require_functionCall();
        var $reflectApply = require_reflectApply();
        module2.exports = $reflectApply || bind.call($call, $apply);
      }
    });
    var require_call_bind_apply_helpers = __commonJS2({
      "node_modules/.pnpm/call-bind-apply-helpers@1.0.2/node_modules/call-bind-apply-helpers/index.js"(exports2, module2) {
        "use strict";
        var bind = require_function_bind();
        var $TypeError = require_type();
        var $call = require_functionCall();
        var $actualApply = require_actualApply();
        module2.exports = /* @__PURE__ */ __name(function callBindBasic(args) {
          if (args.length < 1 || typeof args[0] !== "function") {
            throw new $TypeError("a function is required");
          }
          return $actualApply(bind, $call, args);
        }, "callBindBasic");
      }
    });
    var require_get = __commonJS2({
      "node_modules/.pnpm/dunder-proto@1.0.1/node_modules/dunder-proto/get.js"(exports2, module2) {
        "use strict";
        var callBind = require_call_bind_apply_helpers();
        var gOPD = require_gopd();
        var hasProtoAccessor;
        try {
          hasProtoAccessor = /** @type {{ __proto__?: typeof Array.prototype }} */
          [].__proto__ === Array.prototype;
        } catch (e) {
          if (!e || typeof e !== "object" || !("code" in e) || e.code !== "ERR_PROTO_ACCESS") {
            throw e;
          }
        }
        var desc = !!hasProtoAccessor && gOPD && gOPD(
          Object.prototype,
          /** @type {keyof typeof Object.prototype} */
          "__proto__"
        );
        var $Object = Object;
        var $getPrototypeOf = $Object.getPrototypeOf;
        module2.exports = desc && typeof desc.get === "function" ? callBind([desc.get]) : typeof $getPrototypeOf === "function" ? (
          /** @type {import('./get')} */
          /* @__PURE__ */ __name(function getDunder(value) {
            return $getPrototypeOf(value == null ? value : $Object(value));
          }, "getDunder")
        ) : false;
      }
    });
    var require_get_proto = __commonJS2({
      "node_modules/.pnpm/get-proto@1.0.1/node_modules/get-proto/index.js"(exports2, module2) {
        "use strict";
        var reflectGetProto = require_Reflect_getPrototypeOf();
        var originalGetProto = require_Object_getPrototypeOf();
        var getDunderProto = require_get();
        module2.exports = reflectGetProto ? /* @__PURE__ */ __name(function getProto(O) {
          return reflectGetProto(O);
        }, "getProto") : originalGetProto ? /* @__PURE__ */ __name(function getProto(O) {
          if (!O || typeof O !== "object" && typeof O !== "function") {
            throw new TypeError("getProto: not an object");
          }
          return originalGetProto(O);
        }, "getProto") : getDunderProto ? /* @__PURE__ */ __name(function getProto(O) {
          return getDunderProto(O);
        }, "getProto") : null;
      }
    });
    var require_hasown = __commonJS2({
      "node_modules/.pnpm/hasown@2.0.2/node_modules/hasown/index.js"(exports2, module2) {
        "use strict";
        var call = Function.prototype.call;
        var $hasOwn = Object.prototype.hasOwnProperty;
        var bind = require_function_bind();
        module2.exports = bind.call(call, $hasOwn);
      }
    });
    var require_get_intrinsic = __commonJS2({
      "node_modules/.pnpm/get-intrinsic@1.3.0/node_modules/get-intrinsic/index.js"(exports2, module2) {
        "use strict";
        var undefined2;
        var $Object = require_es_object_atoms();
        var $Error = require_es_errors();
        var $EvalError = require_eval();
        var $RangeError = require_range();
        var $ReferenceError = require_ref();
        var $SyntaxError = require_syntax();
        var $TypeError = require_type();
        var $URIError = require_uri();
        var abs = require_abs();
        var floor = require_floor();
        var max = require_max();
        var min = require_min();
        var pow = require_pow();
        var round = require_round();
        var sign = require_sign();
        var $Function = Function;
        var getEvalledConstructor = /* @__PURE__ */ __name(function(expressionSyntax) {
          try {
            return $Function('"use strict"; return (' + expressionSyntax + ").constructor;")();
          } catch (e) {
          }
        }, "getEvalledConstructor");
        var $gOPD = require_gopd();
        var $defineProperty = require_es_define_property();
        var throwTypeError = /* @__PURE__ */ __name(function() {
          throw new $TypeError();
        }, "throwTypeError");
        var ThrowTypeError = $gOPD ? function() {
          try {
            arguments.callee;
            return throwTypeError;
          } catch (calleeThrows) {
            try {
              return $gOPD(arguments, "callee").get;
            } catch (gOPDthrows) {
              return throwTypeError;
            }
          }
        }() : throwTypeError;
        var hasSymbols = require_has_symbols()();
        var getProto = require_get_proto();
        var $ObjectGPO = require_Object_getPrototypeOf();
        var $ReflectGPO = require_Reflect_getPrototypeOf();
        var $apply = require_functionApply();
        var $call = require_functionCall();
        var needsEval = {};
        var TypedArray = typeof Uint8Array === "undefined" || !getProto ? undefined2 : getProto(Uint8Array);
        var INTRINSICS = {
          __proto__: null,
          "%AggregateError%": typeof AggregateError === "undefined" ? undefined2 : AggregateError,
          "%Array%": Array,
          "%ArrayBuffer%": typeof ArrayBuffer === "undefined" ? undefined2 : ArrayBuffer,
          "%ArrayIteratorPrototype%": hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined2,
          "%AsyncFromSyncIteratorPrototype%": undefined2,
          "%AsyncFunction%": needsEval,
          "%AsyncGenerator%": needsEval,
          "%AsyncGeneratorFunction%": needsEval,
          "%AsyncIteratorPrototype%": needsEval,
          "%Atomics%": typeof Atomics === "undefined" ? undefined2 : Atomics,
          "%BigInt%": typeof BigInt === "undefined" ? undefined2 : BigInt,
          "%BigInt64Array%": typeof BigInt64Array === "undefined" ? undefined2 : BigInt64Array,
          "%BigUint64Array%": typeof BigUint64Array === "undefined" ? undefined2 : BigUint64Array,
          "%Boolean%": Boolean,
          "%DataView%": typeof DataView === "undefined" ? undefined2 : DataView,
          "%Date%": Date,
          "%decodeURI%": decodeURI,
          "%decodeURIComponent%": decodeURIComponent,
          "%encodeURI%": encodeURI,
          "%encodeURIComponent%": encodeURIComponent,
          "%Error%": $Error,
          "%eval%": eval,
          // eslint-disable-line no-eval
          "%EvalError%": $EvalError,
          "%Float16Array%": typeof Float16Array === "undefined" ? undefined2 : Float16Array,
          "%Float32Array%": typeof Float32Array === "undefined" ? undefined2 : Float32Array,
          "%Float64Array%": typeof Float64Array === "undefined" ? undefined2 : Float64Array,
          "%FinalizationRegistry%": typeof FinalizationRegistry === "undefined" ? undefined2 : FinalizationRegistry,
          "%Function%": $Function,
          "%GeneratorFunction%": needsEval,
          "%Int8Array%": typeof Int8Array === "undefined" ? undefined2 : Int8Array,
          "%Int16Array%": typeof Int16Array === "undefined" ? undefined2 : Int16Array,
          "%Int32Array%": typeof Int32Array === "undefined" ? undefined2 : Int32Array,
          "%isFinite%": isFinite,
          "%isNaN%": isNaN,
          "%IteratorPrototype%": hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined2,
          "%JSON%": typeof JSON === "object" ? JSON : undefined2,
          "%Map%": typeof Map === "undefined" ? undefined2 : Map,
          "%MapIteratorPrototype%": typeof Map === "undefined" || !hasSymbols || !getProto ? undefined2 : getProto((/* @__PURE__ */ new Map())[Symbol.iterator]()),
          "%Math%": Math,
          "%Number%": Number,
          "%Object%": $Object,
          "%Object.getOwnPropertyDescriptor%": $gOPD,
          "%parseFloat%": parseFloat,
          "%parseInt%": parseInt,
          "%Promise%": typeof Promise === "undefined" ? undefined2 : Promise,
          "%Proxy%": typeof Proxy === "undefined" ? undefined2 : Proxy,
          "%RangeError%": $RangeError,
          "%ReferenceError%": $ReferenceError,
          "%Reflect%": typeof Reflect === "undefined" ? undefined2 : Reflect,
          "%RegExp%": RegExp,
          "%Set%": typeof Set === "undefined" ? undefined2 : Set,
          "%SetIteratorPrototype%": typeof Set === "undefined" || !hasSymbols || !getProto ? undefined2 : getProto((/* @__PURE__ */ new Set())[Symbol.iterator]()),
          "%SharedArrayBuffer%": typeof SharedArrayBuffer === "undefined" ? undefined2 : SharedArrayBuffer,
          "%String%": String,
          "%StringIteratorPrototype%": hasSymbols && getProto ? getProto(""[Symbol.iterator]()) : undefined2,
          "%Symbol%": hasSymbols ? Symbol : undefined2,
          "%SyntaxError%": $SyntaxError,
          "%ThrowTypeError%": ThrowTypeError,
          "%TypedArray%": TypedArray,
          "%TypeError%": $TypeError,
          "%Uint8Array%": typeof Uint8Array === "undefined" ? undefined2 : Uint8Array,
          "%Uint8ClampedArray%": typeof Uint8ClampedArray === "undefined" ? undefined2 : Uint8ClampedArray,
          "%Uint16Array%": typeof Uint16Array === "undefined" ? undefined2 : Uint16Array,
          "%Uint32Array%": typeof Uint32Array === "undefined" ? undefined2 : Uint32Array,
          "%URIError%": $URIError,
          "%WeakMap%": typeof WeakMap === "undefined" ? undefined2 : WeakMap,
          "%WeakRef%": typeof WeakRef === "undefined" ? undefined2 : WeakRef,
          "%WeakSet%": typeof WeakSet === "undefined" ? undefined2 : WeakSet,
          "%Function.prototype.call%": $call,
          "%Function.prototype.apply%": $apply,
          "%Object.defineProperty%": $defineProperty,
          "%Object.getPrototypeOf%": $ObjectGPO,
          "%Math.abs%": abs,
          "%Math.floor%": floor,
          "%Math.max%": max,
          "%Math.min%": min,
          "%Math.pow%": pow,
          "%Math.round%": round,
          "%Math.sign%": sign,
          "%Reflect.getPrototypeOf%": $ReflectGPO
        };
        if (getProto) {
          try {
            null.error;
          } catch (e) {
            errorProto = getProto(getProto(e));
            INTRINSICS["%Error.prototype%"] = errorProto;
          }
        }
        var errorProto;
        var doEval = /* @__PURE__ */ __name(function doEval2(name) {
          var value;
          if (name === "%AsyncFunction%") {
            value = getEvalledConstructor("async function () {}");
          } else if (name === "%GeneratorFunction%") {
            value = getEvalledConstructor("function* () {}");
          } else if (name === "%AsyncGeneratorFunction%") {
            value = getEvalledConstructor("async function* () {}");
          } else if (name === "%AsyncGenerator%") {
            var fn = doEval2("%AsyncGeneratorFunction%");
            if (fn) {
              value = fn.prototype;
            }
          } else if (name === "%AsyncIteratorPrototype%") {
            var gen = doEval2("%AsyncGenerator%");
            if (gen && getProto) {
              value = getProto(gen.prototype);
            }
          }
          INTRINSICS[name] = value;
          return value;
        }, "doEval2");
        var LEGACY_ALIASES = {
          __proto__: null,
          "%ArrayBufferPrototype%": ["ArrayBuffer", "prototype"],
          "%ArrayPrototype%": ["Array", "prototype"],
          "%ArrayProto_entries%": ["Array", "prototype", "entries"],
          "%ArrayProto_forEach%": ["Array", "prototype", "forEach"],
          "%ArrayProto_keys%": ["Array", "prototype", "keys"],
          "%ArrayProto_values%": ["Array", "prototype", "values"],
          "%AsyncFunctionPrototype%": ["AsyncFunction", "prototype"],
          "%AsyncGenerator%": ["AsyncGeneratorFunction", "prototype"],
          "%AsyncGeneratorPrototype%": ["AsyncGeneratorFunction", "prototype", "prototype"],
          "%BooleanPrototype%": ["Boolean", "prototype"],
          "%DataViewPrototype%": ["DataView", "prototype"],
          "%DatePrototype%": ["Date", "prototype"],
          "%ErrorPrototype%": ["Error", "prototype"],
          "%EvalErrorPrototype%": ["EvalError", "prototype"],
          "%Float32ArrayPrototype%": ["Float32Array", "prototype"],
          "%Float64ArrayPrototype%": ["Float64Array", "prototype"],
          "%FunctionPrototype%": ["Function", "prototype"],
          "%Generator%": ["GeneratorFunction", "prototype"],
          "%GeneratorPrototype%": ["GeneratorFunction", "prototype", "prototype"],
          "%Int8ArrayPrototype%": ["Int8Array", "prototype"],
          "%Int16ArrayPrototype%": ["Int16Array", "prototype"],
          "%Int32ArrayPrototype%": ["Int32Array", "prototype"],
          "%JSONParse%": ["JSON", "parse"],
          "%JSONStringify%": ["JSON", "stringify"],
          "%MapPrototype%": ["Map", "prototype"],
          "%NumberPrototype%": ["Number", "prototype"],
          "%ObjectPrototype%": ["Object", "prototype"],
          "%ObjProto_toString%": ["Object", "prototype", "toString"],
          "%ObjProto_valueOf%": ["Object", "prototype", "valueOf"],
          "%PromisePrototype%": ["Promise", "prototype"],
          "%PromiseProto_then%": ["Promise", "prototype", "then"],
          "%Promise_all%": ["Promise", "all"],
          "%Promise_reject%": ["Promise", "reject"],
          "%Promise_resolve%": ["Promise", "resolve"],
          "%RangeErrorPrototype%": ["RangeError", "prototype"],
          "%ReferenceErrorPrototype%": ["ReferenceError", "prototype"],
          "%RegExpPrototype%": ["RegExp", "prototype"],
          "%SetPrototype%": ["Set", "prototype"],
          "%SharedArrayBufferPrototype%": ["SharedArrayBuffer", "prototype"],
          "%StringPrototype%": ["String", "prototype"],
          "%SymbolPrototype%": ["Symbol", "prototype"],
          "%SyntaxErrorPrototype%": ["SyntaxError", "prototype"],
          "%TypedArrayPrototype%": ["TypedArray", "prototype"],
          "%TypeErrorPrototype%": ["TypeError", "prototype"],
          "%Uint8ArrayPrototype%": ["Uint8Array", "prototype"],
          "%Uint8ClampedArrayPrototype%": ["Uint8ClampedArray", "prototype"],
          "%Uint16ArrayPrototype%": ["Uint16Array", "prototype"],
          "%Uint32ArrayPrototype%": ["Uint32Array", "prototype"],
          "%URIErrorPrototype%": ["URIError", "prototype"],
          "%WeakMapPrototype%": ["WeakMap", "prototype"],
          "%WeakSetPrototype%": ["WeakSet", "prototype"]
        };
        var bind = require_function_bind();
        var hasOwn = require_hasown();
        var $concat = bind.call($call, Array.prototype.concat);
        var $spliceApply = bind.call($apply, Array.prototype.splice);
        var $replace = bind.call($call, String.prototype.replace);
        var $strSlice = bind.call($call, String.prototype.slice);
        var $exec = bind.call($call, RegExp.prototype.exec);
        var rePropName2 = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
        var reEscapeChar2 = /\\(\\)?/g;
        var stringToPath2 = /* @__PURE__ */ __name(function stringToPath3(string) {
          var first = $strSlice(string, 0, 1);
          var last = $strSlice(string, -1);
          if (first === "%" && last !== "%") {
            throw new $SyntaxError("invalid intrinsic syntax, expected closing `%`");
          } else if (last === "%" && first !== "%") {
            throw new $SyntaxError("invalid intrinsic syntax, expected opening `%`");
          }
          var result = [];
          $replace(string, rePropName2, function(match, number, quote, subString) {
            result[result.length] = quote ? $replace(subString, reEscapeChar2, "$1") : number || match;
          });
          return result;
        }, "stringToPath3");
        var getBaseIntrinsic = /* @__PURE__ */ __name(function getBaseIntrinsic2(name, allowMissing) {
          var intrinsicName = name;
          var alias;
          if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
            alias = LEGACY_ALIASES[intrinsicName];
            intrinsicName = "%" + alias[0] + "%";
          }
          if (hasOwn(INTRINSICS, intrinsicName)) {
            var value = INTRINSICS[intrinsicName];
            if (value === needsEval) {
              value = doEval(intrinsicName);
            }
            if (typeof value === "undefined" && !allowMissing) {
              throw new $TypeError("intrinsic " + name + " exists, but is not available. Please file an issue!");
            }
            return {
              alias,
              name: intrinsicName,
              value
            };
          }
          throw new $SyntaxError("intrinsic " + name + " does not exist!");
        }, "getBaseIntrinsic2");
        module2.exports = /* @__PURE__ */ __name(function GetIntrinsic(name, allowMissing) {
          if (typeof name !== "string" || name.length === 0) {
            throw new $TypeError("intrinsic name must be a non-empty string");
          }
          if (arguments.length > 1 && typeof allowMissing !== "boolean") {
            throw new $TypeError('"allowMissing" argument must be a boolean');
          }
          if ($exec(/^%?[^%]*%?$/, name) === null) {
            throw new $SyntaxError("`%` may not be present anywhere but at the beginning and end of the intrinsic name");
          }
          var parts = stringToPath2(name);
          var intrinsicBaseName = parts.length > 0 ? parts[0] : "";
          var intrinsic = getBaseIntrinsic("%" + intrinsicBaseName + "%", allowMissing);
          var intrinsicRealName = intrinsic.name;
          var value = intrinsic.value;
          var skipFurtherCaching = false;
          var alias = intrinsic.alias;
          if (alias) {
            intrinsicBaseName = alias[0];
            $spliceApply(parts, $concat([0, 1], alias));
          }
          for (var i = 1, isOwn = true; i < parts.length; i += 1) {
            var part = parts[i];
            var first = $strSlice(part, 0, 1);
            var last = $strSlice(part, -1);
            if ((first === '"' || first === "'" || first === "`" || (last === '"' || last === "'" || last === "`")) && first !== last) {
              throw new $SyntaxError("property names with quotes must have matching quotes");
            }
            if (part === "constructor" || !isOwn) {
              skipFurtherCaching = true;
            }
            intrinsicBaseName += "." + part;
            intrinsicRealName = "%" + intrinsicBaseName + "%";
            if (hasOwn(INTRINSICS, intrinsicRealName)) {
              value = INTRINSICS[intrinsicRealName];
            } else if (value != null) {
              if (!(part in value)) {
                if (!allowMissing) {
                  throw new $TypeError("base intrinsic for " + name + " exists, but the property is not available.");
                }
                return void 0;
              }
              if ($gOPD && i + 1 >= parts.length) {
                var desc = $gOPD(value, part);
                isOwn = !!desc;
                if (isOwn && "get" in desc && !("originalValue" in desc.get)) {
                  value = desc.get;
                } else {
                  value = value[part];
                }
              } else {
                isOwn = hasOwn(value, part);
                value = value[part];
              }
              if (isOwn && !skipFurtherCaching) {
                INTRINSICS[intrinsicRealName] = value;
              }
            }
          }
          return value;
        }, "GetIntrinsic");
      }
    });
    var require_call_bound = __commonJS2({
      "node_modules/.pnpm/call-bound@1.0.4/node_modules/call-bound/index.js"(exports2, module2) {
        "use strict";
        var GetIntrinsic = require_get_intrinsic();
        var callBindBasic = require_call_bind_apply_helpers();
        var $indexOf = callBindBasic([GetIntrinsic("%String.prototype.indexOf%")]);
        module2.exports = /* @__PURE__ */ __name(function callBoundIntrinsic(name, allowMissing) {
          var intrinsic = (
            /** @type {(this: unknown, ...args: unknown[]) => unknown} */
            GetIntrinsic(name, !!allowMissing)
          );
          if (typeof intrinsic === "function" && $indexOf(name, ".prototype.") > -1) {
            return callBindBasic(
              /** @type {const} */
              [intrinsic]
            );
          }
          return intrinsic;
        }, "callBoundIntrinsic");
      }
    });
    var require_shams2 = __commonJS2({
      "node_modules/.pnpm/has-tostringtag@1.0.2/node_modules/has-tostringtag/shams.js"(exports2, module2) {
        "use strict";
        var hasSymbols = require_shams();
        module2.exports = /* @__PURE__ */ __name(function hasToStringTagShams() {
          return hasSymbols() && !!Symbol.toStringTag;
        }, "hasToStringTagShams");
      }
    });
    var require_is_regex = __commonJS2({
      "node_modules/.pnpm/is-regex@1.2.1/node_modules/is-regex/index.js"(exports2, module2) {
        "use strict";
        var callBound = require_call_bound();
        var hasToStringTag = require_shams2()();
        var hasOwn = require_hasown();
        var gOPD = require_gopd();
        var fn;
        if (hasToStringTag) {
          $exec = callBound("RegExp.prototype.exec");
          isRegexMarker = {};
          throwRegexMarker = /* @__PURE__ */ __name(function() {
            throw isRegexMarker;
          }, "throwRegexMarker");
          badStringifier = {
            toString: throwRegexMarker,
            valueOf: throwRegexMarker
          };
          if (typeof Symbol.toPrimitive === "symbol") {
            badStringifier[Symbol.toPrimitive] = throwRegexMarker;
          }
          fn = /* @__PURE__ */ __name(function isRegex(value) {
            if (!value || typeof value !== "object") {
              return false;
            }
            var descriptor = (
              /** @type {NonNullable<typeof gOPD>} */
              gOPD(
                /** @type {{ lastIndex?: unknown }} */
                value,
                "lastIndex"
              )
            );
            var hasLastIndexDataProperty = descriptor && hasOwn(descriptor, "value");
            if (!hasLastIndexDataProperty) {
              return false;
            }
            try {
              $exec(
                value,
                /** @type {string} */
                /** @type {unknown} */
                badStringifier
              );
            } catch (e) {
              return e === isRegexMarker;
            }
          }, "isRegex");
        } else {
          $toString = callBound("Object.prototype.toString");
          regexClass = "[object RegExp]";
          fn = /* @__PURE__ */ __name(function isRegex(value) {
            if (!value || typeof value !== "object" && typeof value !== "function") {
              return false;
            }
            return $toString(value) === regexClass;
          }, "isRegex");
        }
        var $exec;
        var isRegexMarker;
        var throwRegexMarker;
        var badStringifier;
        var $toString;
        var regexClass;
        module2.exports = fn;
      }
    });
    var require_is_function = __commonJS2({
      "node_modules/.pnpm/is-function@1.0.2/node_modules/is-function/index.js"(exports2, module2) {
        module2.exports = isFunction3;
        var toString2 = Object.prototype.toString;
        function isFunction3(fn) {
          if (!fn) {
            return false;
          }
          var string = toString2.call(fn);
          return string === "[object Function]" || typeof fn === "function" && string !== "[object RegExp]" || typeof window !== "undefined" && // IE8 and below
          (fn === window.setTimeout || fn === window.alert || fn === window.confirm || fn === window.prompt);
        }
        __name(isFunction3, "isFunction3");
      }
    });
    var require_safe_regex_test = __commonJS2({
      "node_modules/.pnpm/safe-regex-test@1.1.0/node_modules/safe-regex-test/index.js"(exports2, module2) {
        "use strict";
        var callBound = require_call_bound();
        var isRegex = require_is_regex();
        var $exec = callBound("RegExp.prototype.exec");
        var $TypeError = require_type();
        module2.exports = /* @__PURE__ */ __name(function regexTester(regex) {
          if (!isRegex(regex)) {
            throw new $TypeError("`regex` must be a RegExp");
          }
          return /* @__PURE__ */ __name(function test(s) {
            return $exec(regex, s) !== null;
          }, "test");
        }, "regexTester");
      }
    });
    var require_is_symbol = __commonJS2({
      "node_modules/.pnpm/is-symbol@1.1.1/node_modules/is-symbol/index.js"(exports2, module2) {
        "use strict";
        var callBound = require_call_bound();
        var $toString = callBound("Object.prototype.toString");
        var hasSymbols = require_has_symbols()();
        var safeRegexTest = require_safe_regex_test();
        if (hasSymbols) {
          $symToStr = callBound("Symbol.prototype.toString");
          isSymString = safeRegexTest(/^Symbol\(.*\)$/);
          isSymbolObject = /* @__PURE__ */ __name(function isRealSymbolObject(value) {
            if (typeof value.valueOf() !== "symbol") {
              return false;
            }
            return isSymString($symToStr(value));
          }, "isRealSymbolObject");
          module2.exports = /* @__PURE__ */ __name(function isSymbol3(value) {
            if (typeof value === "symbol") {
              return true;
            }
            if (!value || typeof value !== "object" || $toString(value) !== "[object Symbol]") {
              return false;
            }
            try {
              return isSymbolObject(value);
            } catch (e) {
              return false;
            }
          }, "isSymbol3");
        } else {
          module2.exports = /* @__PURE__ */ __name(function isSymbol3(value) {
            return false;
          }, "isSymbol3");
        }
        var $symToStr;
        var isSymString;
        var isSymbolObject;
      }
    });
    var src_exports = {};
    __export(src_exports, {
      isJSON: /* @__PURE__ */ __name(() => isJSON2, "isJSON"),
      parse: /* @__PURE__ */ __name(() => parse5, "parse"),
      replacer: /* @__PURE__ */ __name(() => replacer, "replacer"),
      reviver: /* @__PURE__ */ __name(() => reviver, "reviver"),
      stringify: /* @__PURE__ */ __name(() => stringify2, "stringify")
    });
    module.exports = __toCommonJS(src_exports);
    var import_is_regex = __toESM2(require_is_regex());
    var import_is_function = __toESM2(require_is_function());
    var import_is_symbol = __toESM2(require_is_symbol());
    function isObject(val) {
      return val != null && typeof val === "object" && Array.isArray(val) === false;
    }
    __name(isObject, "isObject");
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    var freeGlobal_default = freeGlobal;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal_default || freeSelf || Function("return this")();
    var root_default = root;
    var Symbol2 = root_default.Symbol;
    var Symbol_default = Symbol2;
    var objectProto = Object.prototype;
    var hasOwnProperty2 = objectProto.hasOwnProperty;
    var nativeObjectToString = objectProto.toString;
    var symToStringTag = Symbol_default ? Symbol_default.toStringTag : void 0;
    function getRawTag(value) {
      var isOwn = hasOwnProperty2.call(value, symToStringTag), tag = value[symToStringTag];
      try {
        value[symToStringTag] = void 0;
        var unmasked = true;
      } catch (e) {
      }
      var result = nativeObjectToString.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag;
        } else {
          delete value[symToStringTag];
        }
      }
      return result;
    }
    __name(getRawTag, "getRawTag");
    var getRawTag_default = getRawTag;
    var objectProto2 = Object.prototype;
    var nativeObjectToString2 = objectProto2.toString;
    function objectToString(value) {
      return nativeObjectToString2.call(value);
    }
    __name(objectToString, "objectToString");
    var objectToString_default = objectToString;
    var nullTag = "[object Null]";
    var undefinedTag = "[object Undefined]";
    var symToStringTag2 = Symbol_default ? Symbol_default.toStringTag : void 0;
    function baseGetTag(value) {
      if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
      }
      return symToStringTag2 && symToStringTag2 in Object(value) ? getRawTag_default(value) : objectToString_default(value);
    }
    __name(baseGetTag, "baseGetTag");
    var baseGetTag_default = baseGetTag;
    function isObjectLike(value) {
      return value != null && typeof value == "object";
    }
    __name(isObjectLike, "isObjectLike");
    var isObjectLike_default = isObjectLike;
    var symbolTag = "[object Symbol]";
    function isSymbol(value) {
      return typeof value == "symbol" || isObjectLike_default(value) && baseGetTag_default(value) == symbolTag;
    }
    __name(isSymbol, "isSymbol");
    var isSymbol_default = isSymbol;
    function arrayMap(array, iteratee) {
      var index = -1, length = array == null ? 0 : array.length, result = Array(length);
      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }
    __name(arrayMap, "arrayMap");
    var arrayMap_default = arrayMap;
    var isArray = Array.isArray;
    var isArray_default = isArray;
    var INFINITY = 1 / 0;
    var symbolProto = Symbol_default ? Symbol_default.prototype : void 0;
    var symbolToString = symbolProto ? symbolProto.toString : void 0;
    function baseToString(value) {
      if (typeof value == "string") {
        return value;
      }
      if (isArray_default(value)) {
        return arrayMap_default(value, baseToString) + "";
      }
      if (isSymbol_default(value)) {
        return symbolToString ? symbolToString.call(value) : "";
      }
      var result = value + "";
      return result == "0" && 1 / value == -INFINITY ? "-0" : result;
    }
    __name(baseToString, "baseToString");
    var baseToString_default = baseToString;
    function isObject2(value) {
      var type = typeof value;
      return value != null && (type == "object" || type == "function");
    }
    __name(isObject2, "isObject2");
    var isObject_default = isObject2;
    var asyncTag = "[object AsyncFunction]";
    var funcTag = "[object Function]";
    var genTag = "[object GeneratorFunction]";
    var proxyTag = "[object Proxy]";
    function isFunction(value) {
      if (!isObject_default(value)) {
        return false;
      }
      var tag = baseGetTag_default(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    __name(isFunction, "isFunction");
    var isFunction_default = isFunction;
    var coreJsData = root_default["__core-js_shared__"];
    var coreJsData_default = coreJsData;
    var maskSrcKey = function() {
      var uid = /[^.]+$/.exec(coreJsData_default && coreJsData_default.keys && coreJsData_default.keys.IE_PROTO || "");
      return uid ? "Symbol(src)_1." + uid : "";
    }();
    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    __name(isMasked, "isMasked");
    var isMasked_default = isMasked;
    var funcProto = Function.prototype;
    var funcToString = funcProto.toString;
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e) {
        }
        try {
          return func + "";
        } catch (e) {
        }
      }
      return "";
    }
    __name(toSource, "toSource");
    var toSource_default = toSource;
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var funcProto2 = Function.prototype;
    var objectProto3 = Object.prototype;
    var funcToString2 = funcProto2.toString;
    var hasOwnProperty22 = objectProto3.hasOwnProperty;
    var reIsNative = RegExp(
      "^" + funcToString2.call(hasOwnProperty22).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
    );
    function baseIsNative(value) {
      if (!isObject_default(value) || isMasked_default(value)) {
        return false;
      }
      var pattern = isFunction_default(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource_default(value));
    }
    __name(baseIsNative, "baseIsNative");
    var baseIsNative_default = baseIsNative;
    function getValue(object, key) {
      return object == null ? void 0 : object[key];
    }
    __name(getValue, "getValue");
    var getValue_default = getValue;
    function getNative(object, key) {
      var value = getValue_default(object, key);
      return baseIsNative_default(value) ? value : void 0;
    }
    __name(getNative, "getNative");
    var getNative_default = getNative;
    function eq(value, other) {
      return value === other || value !== value && other !== other;
    }
    __name(eq, "eq");
    var eq_default = eq;
    var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/;
    var reIsPlainProp = /^\w*$/;
    function isKey(value, object) {
      if (isArray_default(value)) {
        return false;
      }
      var type = typeof value;
      if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol_default(value)) {
        return true;
      }
      return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
    }
    __name(isKey, "isKey");
    var isKey_default = isKey;
    var nativeCreate = getNative_default(Object, "create");
    var nativeCreate_default = nativeCreate;
    function hashClear() {
      this.__data__ = nativeCreate_default ? nativeCreate_default(null) : {};
      this.size = 0;
    }
    __name(hashClear, "hashClear");
    var hashClear_default = hashClear;
    function hashDelete(key) {
      var result = this.has(key) && delete this.__data__[key];
      this.size -= result ? 1 : 0;
      return result;
    }
    __name(hashDelete, "hashDelete");
    var hashDelete_default = hashDelete;
    var HASH_UNDEFINED = "__lodash_hash_undefined__";
    var objectProto4 = Object.prototype;
    var hasOwnProperty3 = objectProto4.hasOwnProperty;
    function hashGet(key) {
      var data = this.__data__;
      if (nativeCreate_default) {
        var result = data[key];
        return result === HASH_UNDEFINED ? void 0 : result;
      }
      return hasOwnProperty3.call(data, key) ? data[key] : void 0;
    }
    __name(hashGet, "hashGet");
    var hashGet_default = hashGet;
    var objectProto5 = Object.prototype;
    var hasOwnProperty4 = objectProto5.hasOwnProperty;
    function hashHas(key) {
      var data = this.__data__;
      return nativeCreate_default ? data[key] !== void 0 : hasOwnProperty4.call(data, key);
    }
    __name(hashHas, "hashHas");
    var hashHas_default = hashHas;
    var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
    function hashSet(key, value) {
      var data = this.__data__;
      this.size += this.has(key) ? 0 : 1;
      data[key] = nativeCreate_default && value === void 0 ? HASH_UNDEFINED2 : value;
      return this;
    }
    __name(hashSet, "hashSet");
    var hashSet_default = hashSet;
    function Hash(entries) {
      var index = -1, length = entries == null ? 0 : entries.length;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    __name(Hash, "Hash");
    Hash.prototype.clear = hashClear_default;
    Hash.prototype["delete"] = hashDelete_default;
    Hash.prototype.get = hashGet_default;
    Hash.prototype.has = hashHas_default;
    Hash.prototype.set = hashSet_default;
    var Hash_default = Hash;
    function listCacheClear() {
      this.__data__ = [];
      this.size = 0;
    }
    __name(listCacheClear, "listCacheClear");
    var listCacheClear_default = listCacheClear;
    function assocIndexOf(array, key) {
      var length = array.length;
      while (length--) {
        if (eq_default(array[length][0], key)) {
          return length;
        }
      }
      return -1;
    }
    __name(assocIndexOf, "assocIndexOf");
    var assocIndexOf_default = assocIndexOf;
    var arrayProto = Array.prototype;
    var splice = arrayProto.splice;
    function listCacheDelete(key) {
      var data = this.__data__, index = assocIndexOf_default(data, key);
      if (index < 0) {
        return false;
      }
      var lastIndex = data.length - 1;
      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }
      --this.size;
      return true;
    }
    __name(listCacheDelete, "listCacheDelete");
    var listCacheDelete_default = listCacheDelete;
    function listCacheGet(key) {
      var data = this.__data__, index = assocIndexOf_default(data, key);
      return index < 0 ? void 0 : data[index][1];
    }
    __name(listCacheGet, "listCacheGet");
    var listCacheGet_default = listCacheGet;
    function listCacheHas(key) {
      return assocIndexOf_default(this.__data__, key) > -1;
    }
    __name(listCacheHas, "listCacheHas");
    var listCacheHas_default = listCacheHas;
    function listCacheSet(key, value) {
      var data = this.__data__, index = assocIndexOf_default(data, key);
      if (index < 0) {
        ++this.size;
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }
      return this;
    }
    __name(listCacheSet, "listCacheSet");
    var listCacheSet_default = listCacheSet;
    function ListCache(entries) {
      var index = -1, length = entries == null ? 0 : entries.length;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    __name(ListCache, "ListCache");
    ListCache.prototype.clear = listCacheClear_default;
    ListCache.prototype["delete"] = listCacheDelete_default;
    ListCache.prototype.get = listCacheGet_default;
    ListCache.prototype.has = listCacheHas_default;
    ListCache.prototype.set = listCacheSet_default;
    var ListCache_default = ListCache;
    var Map2 = getNative_default(root_default, "Map");
    var Map_default = Map2;
    function mapCacheClear() {
      this.size = 0;
      this.__data__ = {
        "hash": new Hash_default(),
        "map": new (Map_default || ListCache_default)(),
        "string": new Hash_default()
      };
    }
    __name(mapCacheClear, "mapCacheClear");
    var mapCacheClear_default = mapCacheClear;
    function isKeyable(value) {
      var type = typeof value;
      return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
    }
    __name(isKeyable, "isKeyable");
    var isKeyable_default = isKeyable;
    function getMapData(map, key) {
      var data = map.__data__;
      return isKeyable_default(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
    }
    __name(getMapData, "getMapData");
    var getMapData_default = getMapData;
    function mapCacheDelete(key) {
      var result = getMapData_default(this, key)["delete"](key);
      this.size -= result ? 1 : 0;
      return result;
    }
    __name(mapCacheDelete, "mapCacheDelete");
    var mapCacheDelete_default = mapCacheDelete;
    function mapCacheGet(key) {
      return getMapData_default(this, key).get(key);
    }
    __name(mapCacheGet, "mapCacheGet");
    var mapCacheGet_default = mapCacheGet;
    function mapCacheHas(key) {
      return getMapData_default(this, key).has(key);
    }
    __name(mapCacheHas, "mapCacheHas");
    var mapCacheHas_default = mapCacheHas;
    function mapCacheSet(key, value) {
      var data = getMapData_default(this, key), size = data.size;
      data.set(key, value);
      this.size += data.size == size ? 0 : 1;
      return this;
    }
    __name(mapCacheSet, "mapCacheSet");
    var mapCacheSet_default = mapCacheSet;
    function MapCache(entries) {
      var index = -1, length = entries == null ? 0 : entries.length;
      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    __name(MapCache, "MapCache");
    MapCache.prototype.clear = mapCacheClear_default;
    MapCache.prototype["delete"] = mapCacheDelete_default;
    MapCache.prototype.get = mapCacheGet_default;
    MapCache.prototype.has = mapCacheHas_default;
    MapCache.prototype.set = mapCacheSet_default;
    var MapCache_default = MapCache;
    var FUNC_ERROR_TEXT = "Expected a function";
    function memoize2(func, resolver) {
      if (typeof func != "function" || resolver != null && typeof resolver != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var memoized = /* @__PURE__ */ __name(function() {
        var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache2 = memoized.cache;
        if (cache2.has(key)) {
          return cache2.get(key);
        }
        var result = func.apply(this, args);
        memoized.cache = cache2.set(key, result) || cache2;
        return result;
      }, "memoized");
      memoized.cache = new (memoize2.Cache || MapCache_default)();
      return memoized;
    }
    __name(memoize2, "memoize");
    memoize2.Cache = MapCache_default;
    var memoize_default = memoize2;
    var MAX_MEMOIZE_SIZE = 500;
    function memoizeCapped(func) {
      var result = memoize_default(func, function(key) {
        if (cache2.size === MAX_MEMOIZE_SIZE) {
          cache2.clear();
        }
        return key;
      });
      var cache2 = result.cache;
      return result;
    }
    __name(memoizeCapped, "memoizeCapped");
    var memoizeCapped_default = memoizeCapped;
    var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
    var reEscapeChar = /\\(\\)?/g;
    var stringToPath = memoizeCapped_default(function(string) {
      var result = [];
      if (string.charCodeAt(0) === 46) {
        result.push("");
      }
      string.replace(rePropName, function(match, number, quote, subString) {
        result.push(quote ? subString.replace(reEscapeChar, "$1") : number || match);
      });
      return result;
    });
    var stringToPath_default = stringToPath;
    function toString(value) {
      return value == null ? "" : baseToString_default(value);
    }
    __name(toString, "toString");
    var toString_default = toString;
    function castPath(value, object) {
      if (isArray_default(value)) {
        return value;
      }
      return isKey_default(value, object) ? [value] : stringToPath_default(toString_default(value));
    }
    __name(castPath, "castPath");
    var castPath_default = castPath;
    var INFINITY2 = 1 / 0;
    function toKey(value) {
      if (typeof value == "string" || isSymbol_default(value)) {
        return value;
      }
      var result = value + "";
      return result == "0" && 1 / value == -INFINITY2 ? "-0" : result;
    }
    __name(toKey, "toKey");
    var toKey_default = toKey;
    function baseGet(object, path2) {
      path2 = castPath_default(path2, object);
      var index = 0, length = path2.length;
      while (object != null && index < length) {
        object = object[toKey_default(path2[index++])];
      }
      return index && index == length ? object : void 0;
    }
    __name(baseGet, "baseGet");
    var baseGet_default = baseGet;
    function get(object, path2, defaultValue) {
      var result = object == null ? void 0 : baseGet_default(object, path2);
      return result === void 0 ? defaultValue : result;
    }
    __name(get, "get");
    var get_default = get;
    var eventProperties = [
      "bubbles",
      "cancelBubble",
      "cancelable",
      "composed",
      "currentTarget",
      "defaultPrevented",
      "eventPhase",
      "isTrusted",
      "returnValue",
      "srcElement",
      "target",
      "timeStamp",
      "type"
    ];
    var customEventSpecificProperties = ["detail"];
    function extractEventHiddenProperties(event) {
      const rebuildEvent = eventProperties.filter((value) => event[value] !== void 0).reduce((acc, value) => {
        acc[value] = event[value];
        return acc;
      }, {});
      if (event instanceof CustomEvent) {
        for (const value of customEventSpecificProperties.filter(
          (value2) => event[value2] !== void 0
        )) {
          rebuildEvent[value] = event[value];
        }
      }
      return rebuildEvent;
    }
    __name(extractEventHiddenProperties, "extractEventHiddenProperties");
    var isObject3 = isObject;
    var dateFormat = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d{3})?Z$/;
    var isJSON2 = /* @__PURE__ */ __name((input) => input.match(/^[\[\{\"\}].*[\]\}\"]$/), "isJSON");
    function convertUnconventionalData(data) {
      if (!isObject3(data)) {
        return data;
      }
      let result = data;
      let wasMutated = false;
      if (typeof Event !== "undefined" && data instanceof Event) {
        result = extractEventHiddenProperties(result);
        wasMutated = true;
      }
      result = Object.keys(result).reduce((acc, key) => {
        try {
          if (result[key]) {
            result[key].toJSON;
          }
          acc[key] = result[key];
        } catch (_err) {
          wasMutated = true;
        }
        return acc;
      }, {});
      return wasMutated ? result : data;
    }
    __name(convertUnconventionalData, "convertUnconventionalData");
    var replacer = /* @__PURE__ */ __name(function replacer2(options) {
      let objects;
      let map;
      let stack;
      let keys;
      return /* @__PURE__ */ __name(function replace(key, value) {
        try {
          if (key === "") {
            keys = [];
            objects = /* @__PURE__ */ new Map([[value, "[]"]]);
            map = /* @__PURE__ */ new Map();
            stack = [];
            return value;
          }
          const origin = map.get(this) || this;
          while (stack.length && origin !== stack[0]) {
            stack.shift();
            keys.pop();
          }
          if (typeof value === "boolean") {
            return value;
          }
          if (value === void 0) {
            if (!options.allowUndefined) {
              return void 0;
            }
            return "_undefined_";
          }
          if (value === null) {
            return null;
          }
          if (typeof value === "number") {
            if (value === Number.NEGATIVE_INFINITY) {
              return "_-Infinity_";
            }
            if (value === Number.POSITIVE_INFINITY) {
              return "_Infinity_";
            }
            if (Number.isNaN(value)) {
              return "_NaN_";
            }
            return value;
          }
          if (typeof value === "bigint") {
            return `_bigint_${value.toString()}`;
          }
          if (typeof value === "string") {
            if (dateFormat.test(value)) {
              if (!options.allowDate) {
                return void 0;
              }
              return `_date_${value}`;
            }
            return value;
          }
          if ((0, import_is_regex.default)(value)) {
            if (!options.allowRegExp) {
              return void 0;
            }
            return `_regexp_${value.flags}|${value.source}`;
          }
          if ((0, import_is_function.default)(value)) {
            return void 0;
          }
          if ((0, import_is_symbol.default)(value)) {
            if (!options.allowSymbol) {
              return void 0;
            }
            const globalRegistryKey = Symbol.keyFor(value);
            if (globalRegistryKey !== void 0) {
              return `_gsymbol_${globalRegistryKey}`;
            }
            return `_symbol_${value.toString().slice(7, -1)}`;
          }
          if (stack.length >= options.maxDepth) {
            if (Array.isArray(value)) {
              return `[Array(${value.length})]`;
            }
            return "[Object]";
          }
          if (value === this) {
            return `_duplicate_${JSON.stringify(keys)}`;
          }
          if (value instanceof Error && options.allowError) {
            return {
              __isConvertedError__: true,
              errorProperties: {
                // @ts-expect-error cause is not defined in the current tsconfig target(es2020)
                ...value.cause ? { cause: value.cause } : {},
                ...value,
                name: value.name,
                message: value.message,
                stack: value.stack,
                "_constructor-name_": value.constructor.name
              }
            };
          }
          if (value?.constructor?.name && value.constructor.name !== "Object" && !Array.isArray(value)) {
            const found2 = objects.get(value);
            if (!found2) {
              const plainObject = {
                __isClassInstance__: true,
                __className__: value.constructor.name,
                ...Object.getOwnPropertyNames(value).reduce(
                  (acc, prop) => {
                    try {
                      acc[prop] = value[prop];
                    } catch (_err) {
                    }
                    return acc;
                  },
                  {}
                )
              };
              keys.push(key);
              stack.unshift(plainObject);
              objects.set(value, JSON.stringify(keys));
              if (value !== plainObject) {
                map.set(value, plainObject);
              }
              return plainObject;
            }
            return `_duplicate_${found2}`;
          }
          const found = objects.get(value);
          if (!found) {
            const converted = Array.isArray(value) ? value : convertUnconventionalData(value);
            keys.push(key);
            stack.unshift(converted);
            objects.set(value, JSON.stringify(keys));
            if (value !== converted) {
              map.set(value, converted);
            }
            return converted;
          }
          return `_duplicate_${found}`;
        } catch (_e) {
          return void 0;
        }
      }, "replace");
    }, "replacer2");
    var reviver = /* @__PURE__ */ __name(function reviver2(options) {
      const refs = [];
      let root2;
      return /* @__PURE__ */ __name(function revive(key, value) {
        if (key === "") {
          root2 = value;
          refs.forEach(({ target, container, replacement }) => {
            const replacementArr = isJSON2(replacement) ? JSON.parse(replacement) : replacement.split(".");
            if (replacementArr.length === 0) {
              container[target] = root2;
            } else {
              container[target] = get_default(root2, replacementArr);
            }
          });
        }
        if (key === "_constructor-name_") {
          return value;
        }
        if (isObject3(value) && value.__isConvertedError__) {
          const { message, ...properties } = value.errorProperties;
          const error = new Error(message);
          Object.assign(error, properties);
          return error;
        }
        if (typeof value === "string" && value.startsWith("_regexp_") && options.allowRegExp) {
          const [, flags, source] = value.match(/_regexp_([^|]*)\|(.*)/) || [];
          return new RegExp(source, flags);
        }
        if (typeof value === "string" && value.startsWith("_date_") && options.allowDate) {
          return new Date(value.replace("_date_", ""));
        }
        if (typeof value === "string" && value.startsWith("_duplicate_")) {
          refs.push({ target: key, container: this, replacement: value.replace(/^_duplicate_/, "") });
          return null;
        }
        if (typeof value === "string" && value.startsWith("_symbol_") && options.allowSymbol) {
          return Symbol(value.replace("_symbol_", ""));
        }
        if (typeof value === "string" && value.startsWith("_gsymbol_") && options.allowSymbol) {
          return Symbol.for(value.replace("_gsymbol_", ""));
        }
        if (typeof value === "string" && value === "_-Infinity_") {
          return Number.NEGATIVE_INFINITY;
        }
        if (typeof value === "string" && value === "_Infinity_") {
          return Number.POSITIVE_INFINITY;
        }
        if (typeof value === "string" && value === "_NaN_") {
          return Number.NaN;
        }
        if (typeof value === "string" && value.startsWith("_bigint_") && typeof BigInt === "function") {
          return BigInt(value.replace("_bigint_", ""));
        }
        return value;
      }, "revive");
    }, "reviver2");
    var defaultOptions = {
      maxDepth: 10,
      space: void 0,
      allowRegExp: true,
      allowDate: true,
      allowError: true,
      allowUndefined: true,
      allowSymbol: true
    };
    var stringify2 = /* @__PURE__ */ __name((data, options = {}) => {
      const mergedOptions = { ...defaultOptions, ...options };
      return JSON.stringify(convertUnconventionalData(data), replacer(mergedOptions), options.space);
    }, "stringify");
    var mutator = /* @__PURE__ */ __name(() => {
      const mutated = /* @__PURE__ */ new Map();
      return /* @__PURE__ */ __name(function mutateUndefined(value) {
        if (isObject3(value)) {
          Object.entries(value).forEach(([k, v]) => {
            if (v === "_undefined_") {
              value[k] = void 0;
            } else if (!mutated.get(v)) {
              mutated.set(v, true);
              mutateUndefined(v);
            }
          });
        }
        if (Array.isArray(value)) {
          value.forEach((v, index) => {
            if (v === "_undefined_") {
              mutated.set(v, true);
              value[index] = void 0;
            } else if (!mutated.get(v)) {
              mutated.set(v, true);
              mutateUndefined(v);
            }
          });
        }
      }, "mutateUndefined");
    }, "mutator");
    var parse5 = /* @__PURE__ */ __name((data, options = {}) => {
      const mergedOptions = { ...defaultOptions, ...options };
      const result = JSON.parse(data, reviver(mergedOptions));
      mutator()(result);
      return result;
    }, "parse");
  }
});

// ../node_modules/address/lib/address.js
var require_address = __commonJS({
  "../node_modules/address/lib/address.js"(exports, module) {
    "use strict";
    var os3 = __require("os");
    var fs6 = __require("fs");
    var child = __require("child_process");
    var DEFAULT_RESOLV_FILE = "/etc/resolv.conf";
    function getInterfaceName() {
      var val = "eth";
      var platform2 = os3.platform();
      if (platform2 === "darwin") {
        val = "en";
      } else if (platform2 === "win32") {
        val = null;
      }
      return val;
    }
    __name(getInterfaceName, "getInterfaceName");
    function getIfconfigCMD() {
      if (os3.platform() === "win32") {
        return "ipconfig/all";
      }
      return "/sbin/ifconfig";
    }
    __name(getIfconfigCMD, "getIfconfigCMD");
    function matchName(actualFamily, expectedFamily) {
      if (expectedFamily === "IPv4") {
        return actualFamily === "IPv4" || actualFamily === 4;
      }
      if (expectedFamily === "IPv6") {
        return actualFamily === "IPv6" || actualFamily === 6;
      }
      return actualFamily === expectedFamily;
    }
    __name(matchName, "matchName");
    function address(interfaceName, callback) {
      if (typeof interfaceName === "function") {
        callback = interfaceName;
        interfaceName = null;
      }
      var addr = {
        ip: address.ip(interfaceName),
        ipv6: address.ipv6(interfaceName),
        mac: null
      };
      address.mac(interfaceName, function(err, mac) {
        if (mac) {
          addr.mac = mac;
        }
        callback(err, addr);
      });
    }
    __name(address, "address");
    address.interface = function(family, name) {
      var interfaces = os3.networkInterfaces();
      var noName = !name;
      name = name || getInterfaceName();
      family = family || "IPv4";
      for (var i = -1; i < 8; i++) {
        var interfaceName = name + (i >= 0 ? i : "");
        var items = interfaces[interfaceName];
        if (items) {
          for (var j = 0; j < items.length; j++) {
            var item = items[j];
            if (matchName(item.family, family)) {
              return item;
            }
          }
        }
      }
      if (noName) {
        for (var k in interfaces) {
          var items = interfaces[k];
          for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (matchName(item.family, family) && !item.address.startsWith("127.")) {
              return item;
            }
          }
        }
      }
      return;
    };
    address.ip = function(interfaceName) {
      var item = address.interface("IPv4", interfaceName);
      return item && item.address;
    };
    address.ipv6 = function(interfaceName) {
      var item = address.interface("IPv6", interfaceName);
      return item && item.address;
    };
    var MAC_OSX_START_LINE = /^(\w+)\:\s+flags=/;
    var MAC_LINUX_START_LINE = /^(\w+)\s{2,}link encap:\w+/i;
    var MAC_RE = address.MAC_RE = /(?:ether|HWaddr)\s+((?:[a-z0-9]{2}\:){5}[a-z0-9]{2})/i;
    var MAC_IP_RE = address.MAC_IP_RE = /inet\s(?:addr\:)?(\d+\.\d+\.\d+\.\d+)/;
    function getMAC(content, interfaceName, matchIP) {
      var lines = content.split("\n");
      for (var i = 0; i < lines.length; i++) {
        var line = lines[i].trimRight();
        var m = MAC_OSX_START_LINE.exec(line) || MAC_LINUX_START_LINE.exec(line);
        if (!m) {
          continue;
        }
        var name = m[1];
        if (name.indexOf(interfaceName) !== 0) {
          continue;
        }
        var ip = null;
        var mac = null;
        var match = MAC_RE.exec(line);
        if (match) {
          mac = match[1];
        }
        i++;
        while (true) {
          line = lines[i];
          if (!line || MAC_OSX_START_LINE.exec(line) || MAC_LINUX_START_LINE.exec(line)) {
            i--;
            break;
          }
          if (!mac) {
            match = MAC_RE.exec(line);
            if (match) {
              mac = match[1];
            }
          }
          if (!ip) {
            match = MAC_IP_RE.exec(line);
            if (match) {
              ip = match[1];
            }
          }
          i++;
        }
        if (ip === matchIP) {
          return mac;
        }
      }
    }
    __name(getMAC, "getMAC");
    address.mac = function(interfaceName, callback) {
      if (typeof interfaceName === "function") {
        callback = interfaceName;
        interfaceName = null;
      }
      interfaceName = interfaceName || getInterfaceName();
      var item = address.interface("IPv4", interfaceName);
      if (!item) {
        return callback();
      }
      if (!process.env.CI && (item.mac === "ff:00:00:00:00:00" || item.mac === "00:00:00:00:00:00")) {
        item.mac = "";
      }
      if (item.mac) {
        return callback(null, item.mac);
      }
      child.exec(getIfconfigCMD(), { timeout: 5e3 }, function(err, stdout, stderr) {
        if (err || !stdout) {
          return callback(err);
        }
        var mac = getMAC(stdout || "", interfaceName, item.address);
        callback(null, mac);
      });
    };
    var DNS_SERVER_RE = /^nameserver\s+(\d+\.\d+\.\d+\.\d+)$/i;
    address.dns = function(filepath, callback) {
      if (typeof filepath === "function") {
        callback = filepath;
        filepath = null;
      }
      filepath = filepath || DEFAULT_RESOLV_FILE;
      fs6.readFile(filepath, "utf8", function(err, content) {
        if (err) {
          return callback(err);
        }
        var servers = [];
        content = content || "";
        var lines = content.split("\n");
        for (var i = 0; i < lines.length; i++) {
          var line = lines[i].trim();
          var m = DNS_SERVER_RE.exec(line);
          if (m) {
            servers.push(m[1]);
          }
        }
        callback(null, servers);
      });
    };
    module.exports = address;
  }
});

// ../node_modules/detect-port/lib/detect-port.js
var require_detect_port = __commonJS({
  "../node_modules/detect-port/lib/detect-port.js"(exports, module) {
    "use strict";
    var net = __require("net");
    var address = require_address();
    var debug = require_src()("detect-port");
    module.exports = (port, callback) => {
      let hostname = "";
      if (typeof port === "object" && port) {
        hostname = port.hostname;
        callback = port.callback;
        port = port.port;
      } else {
        if (typeof port === "function") {
          callback = port;
          port = null;
        }
      }
      port = parseInt(port) || 0;
      let maxPort = port + 10;
      if (maxPort > 65535) {
        maxPort = 65535;
      }
      debug("detect free port between [%s, %s)", port, maxPort);
      if (typeof callback === "function") {
        return tryListen(port, maxPort, hostname, callback);
      }
      return new Promise((resolve4) => {
        tryListen(port, maxPort, hostname, (_, realPort) => {
          resolve4(realPort);
        });
      });
    };
    function tryListen(port, maxPort, hostname, callback) {
      function handleError() {
        port++;
        if (port >= maxPort) {
          debug("port: %s >= maxPort: %s, give up and use random port", port, maxPort);
          port = 0;
          maxPort = 0;
        }
        tryListen(port, maxPort, hostname, callback);
      }
      __name(handleError, "handleError");
      if (hostname) {
        listen(port, hostname, (err, realPort) => {
          if (err) {
            if (err.code === "EADDRNOTAVAIL") {
              return callback(new Error("the ip that is not unknown on the machine"));
            }
            return handleError();
          }
          callback(null, realPort);
        });
      } else {
        listen(port, null, (err, realPort) => {
          if (port === 0) {
            return callback(err, realPort);
          }
          if (err) {
            return handleError(err);
          }
          listen(port, "0.0.0.0", (err2) => {
            if (err2) {
              return handleError(err2);
            }
            listen(port, "localhost", (err3) => {
              if (err3 && err3.code !== "EADDRNOTAVAIL") {
                return handleError(err3);
              }
              listen(port, address.ip(), (err4, realPort2) => {
                if (err4) {
                  return handleError(err4);
                }
                callback(null, realPort2);
              });
            });
          });
        });
      }
    }
    __name(tryListen, "tryListen");
    function listen(port, hostname, callback) {
      const server = new net.Server();
      server.on("error", (err) => {
        debug("listen %s:%s error: %s", hostname, port, err);
        server.close();
        if (err.code === "ENOTFOUND") {
          debug("ignore dns ENOTFOUND error, get free %s:%s", hostname, port);
          return callback(null, port);
        }
        return callback(err);
      });
      server.listen(port, hostname, () => {
        port = server.address().port;
        server.close();
        debug("get free %s:%s", hostname, port);
        return callback(null, port);
      });
    }
    __name(listen, "listen");
  }
});

// ../node_modules/detect-port/lib/wait-port.js
var require_wait_port = __commonJS({
  "../node_modules/detect-port/lib/wait-port.js"(exports, module) {
    "use strict";
    var debug = require_src()("wait-port");
    var detect = require_detect_port();
    var sleep = /* @__PURE__ */ __name((ms) => new Promise((resolve4) => setTimeout(resolve4, ms)), "sleep");
    async function waitPort(port, options = {}) {
      const { retryInterval = 1e3, retries = Infinity } = options;
      let count = 1;
      async function loop() {
        debug("retries", retries, "count", count);
        if (count > retries) {
          const err = new Error("retries exceeded");
          err.retries = retries;
          err.count = count;
          throw err;
        }
        count++;
        const freePort = await detect(port);
        if (freePort === port) {
          await sleep(retryInterval);
          return loop();
        }
        return true;
      }
      __name(loop, "loop");
      return await loop();
    }
    __name(waitPort, "waitPort");
    module.exports = waitPort;
  }
});

// ../node_modules/detect-port/index.js
var require_detect_port2 = __commonJS({
  "../node_modules/detect-port/index.js"(exports, module) {
    "use strict";
    module.exports = require_detect_port();
    module.exports.waitPort = require_wait_port();
  }
});

// ../node_modules/cli-table3/src/debug.js
var require_debug = __commonJS({
  "../node_modules/cli-table3/src/debug.js"(exports, module) {
    var messages = [];
    var level = 0;
    var debug = /* @__PURE__ */ __name((msg, min) => {
      if (level >= min) {
        messages.push(msg);
      }
    }, "debug");
    debug.WARN = 1;
    debug.INFO = 2;
    debug.DEBUG = 3;
    debug.reset = () => {
      messages = [];
    };
    debug.setDebugLevel = (v) => {
      level = v;
    };
    debug.warn = (msg) => debug(msg, debug.WARN);
    debug.info = (msg) => debug(msg, debug.INFO);
    debug.debug = (msg) => debug(msg, debug.DEBUG);
    debug.debugMessages = () => messages;
    module.exports = debug;
  }
});

// ../node_modules/cli-table3/src/utils.js
var require_utils2 = __commonJS({
  "../node_modules/cli-table3/src/utils.js"(exports, module) {
    var stringWidth = require_string_width();
    function codeRegex(capture) {
      return capture ? /\u001b\[((?:\d*;){0,5}\d*)m/g : /\u001b\[(?:\d*;){0,5}\d*m/g;
    }
    __name(codeRegex, "codeRegex");
    function strlen(str) {
      let code = codeRegex();
      let stripped = ("" + str).replace(code, "");
      let split = stripped.split("\n");
      return split.reduce(function(memo, s) {
        return stringWidth(s) > memo ? stringWidth(s) : memo;
      }, 0);
    }
    __name(strlen, "strlen");
    function repeat(str, times) {
      return Array(times + 1).join(str);
    }
    __name(repeat, "repeat");
    function pad(str, len, pad2, dir) {
      let length = strlen(str);
      if (len + 1 >= length) {
        let padlen = len - length;
        switch (dir) {
          case "right": {
            str = repeat(pad2, padlen) + str;
            break;
          }
          case "center": {
            let right = Math.ceil(padlen / 2);
            let left = padlen - right;
            str = repeat(pad2, left) + str + repeat(pad2, right);
            break;
          }
          default: {
            str = str + repeat(pad2, padlen);
            break;
          }
        }
      }
      return str;
    }
    __name(pad, "pad");
    var codeCache = {};
    function addToCodeCache(name, on, off) {
      on = "\x1B[" + on + "m";
      off = "\x1B[" + off + "m";
      codeCache[on] = { set: name, to: true };
      codeCache[off] = { set: name, to: false };
      codeCache[name] = { on, off };
    }
    __name(addToCodeCache, "addToCodeCache");
    addToCodeCache("bold", 1, 22);
    addToCodeCache("italics", 3, 23);
    addToCodeCache("underline", 4, 24);
    addToCodeCache("inverse", 7, 27);
    addToCodeCache("strikethrough", 9, 29);
    function updateState(state, controlChars) {
      let controlCode = controlChars[1] ? parseInt(controlChars[1].split(";")[0]) : 0;
      if (controlCode >= 30 && controlCode <= 39 || controlCode >= 90 && controlCode <= 97) {
        state.lastForegroundAdded = controlChars[0];
        return;
      }
      if (controlCode >= 40 && controlCode <= 49 || controlCode >= 100 && controlCode <= 107) {
        state.lastBackgroundAdded = controlChars[0];
        return;
      }
      if (controlCode === 0) {
        for (let i in state) {
          if (Object.prototype.hasOwnProperty.call(state, i)) {
            delete state[i];
          }
        }
        return;
      }
      let info = codeCache[controlChars[0]];
      if (info) {
        state[info.set] = info.to;
      }
    }
    __name(updateState, "updateState");
    function readState(line) {
      let code = codeRegex(true);
      let controlChars = code.exec(line);
      let state = {};
      while (controlChars !== null) {
        updateState(state, controlChars);
        controlChars = code.exec(line);
      }
      return state;
    }
    __name(readState, "readState");
    function unwindState(state, ret) {
      let lastBackgroundAdded = state.lastBackgroundAdded;
      let lastForegroundAdded = state.lastForegroundAdded;
      delete state.lastBackgroundAdded;
      delete state.lastForegroundAdded;
      Object.keys(state).forEach(function(key) {
        if (state[key]) {
          ret += codeCache[key].off;
        }
      });
      if (lastBackgroundAdded && lastBackgroundAdded != "\x1B[49m") {
        ret += "\x1B[49m";
      }
      if (lastForegroundAdded && lastForegroundAdded != "\x1B[39m") {
        ret += "\x1B[39m";
      }
      return ret;
    }
    __name(unwindState, "unwindState");
    function rewindState(state, ret) {
      let lastBackgroundAdded = state.lastBackgroundAdded;
      let lastForegroundAdded = state.lastForegroundAdded;
      delete state.lastBackgroundAdded;
      delete state.lastForegroundAdded;
      Object.keys(state).forEach(function(key) {
        if (state[key]) {
          ret = codeCache[key].on + ret;
        }
      });
      if (lastBackgroundAdded && lastBackgroundAdded != "\x1B[49m") {
        ret = lastBackgroundAdded + ret;
      }
      if (lastForegroundAdded && lastForegroundAdded != "\x1B[39m") {
        ret = lastForegroundAdded + ret;
      }
      return ret;
    }
    __name(rewindState, "rewindState");
    function truncateWidth(str, desiredLength) {
      if (str.length === strlen(str)) {
        return str.substr(0, desiredLength);
      }
      while (strlen(str) > desiredLength) {
        str = str.slice(0, -1);
      }
      return str;
    }
    __name(truncateWidth, "truncateWidth");
    function truncateWidthWithAnsi(str, desiredLength) {
      let code = codeRegex(true);
      let split = str.split(codeRegex());
      let splitIndex = 0;
      let retLen = 0;
      let ret = "";
      let myArray;
      let state = {};
      while (retLen < desiredLength) {
        myArray = code.exec(str);
        let toAdd = split[splitIndex];
        splitIndex++;
        if (retLen + strlen(toAdd) > desiredLength) {
          toAdd = truncateWidth(toAdd, desiredLength - retLen);
        }
        ret += toAdd;
        retLen += strlen(toAdd);
        if (retLen < desiredLength) {
          if (!myArray) {
            break;
          }
          ret += myArray[0];
          updateState(state, myArray);
        }
      }
      return unwindState(state, ret);
    }
    __name(truncateWidthWithAnsi, "truncateWidthWithAnsi");
    function truncate(str, desiredLength, truncateChar) {
      truncateChar = truncateChar || "\u2026";
      let lengthOfStr = strlen(str);
      if (lengthOfStr <= desiredLength) {
        return str;
      }
      desiredLength -= strlen(truncateChar);
      let ret = truncateWidthWithAnsi(str, desiredLength);
      ret += truncateChar;
      const hrefTag = "\x1B]8;;\x07";
      if (str.includes(hrefTag) && !ret.includes(hrefTag)) {
        ret += hrefTag;
      }
      return ret;
    }
    __name(truncate, "truncate");
    function defaultOptions() {
      return {
        chars: {
          top: "\u2500",
          "top-mid": "\u252C",
          "top-left": "\u250C",
          "top-right": "\u2510",
          bottom: "\u2500",
          "bottom-mid": "\u2534",
          "bottom-left": "\u2514",
          "bottom-right": "\u2518",
          left: "\u2502",
          "left-mid": "\u251C",
          mid: "\u2500",
          "mid-mid": "\u253C",
          right: "\u2502",
          "right-mid": "\u2524",
          middle: "\u2502"
        },
        truncate: "\u2026",
        colWidths: [],
        rowHeights: [],
        colAligns: [],
        rowAligns: [],
        style: {
          "padding-left": 1,
          "padding-right": 1,
          head: ["red"],
          border: ["grey"],
          compact: false
        },
        head: []
      };
    }
    __name(defaultOptions, "defaultOptions");
    function mergeOptions(options, defaults) {
      options = options || {};
      defaults = defaults || defaultOptions();
      let ret = Object.assign({}, defaults, options);
      ret.chars = Object.assign({}, defaults.chars, options.chars);
      ret.style = Object.assign({}, defaults.style, options.style);
      return ret;
    }
    __name(mergeOptions, "mergeOptions");
    function wordWrap(maxLength, input) {
      let lines = [];
      let split = input.split(/(\s+)/g);
      let line = [];
      let lineLength = 0;
      let whitespace;
      for (let i = 0; i < split.length; i += 2) {
        let word = split[i];
        let newLength = lineLength + strlen(word);
        if (lineLength > 0 && whitespace) {
          newLength += whitespace.length;
        }
        if (newLength > maxLength) {
          if (lineLength !== 0) {
            lines.push(line.join(""));
          }
          line = [word];
          lineLength = strlen(word);
        } else {
          line.push(whitespace || "", word);
          lineLength = newLength;
        }
        whitespace = split[i + 1];
      }
      if (lineLength) {
        lines.push(line.join(""));
      }
      return lines;
    }
    __name(wordWrap, "wordWrap");
    function textWrap(maxLength, input) {
      let lines = [];
      let line = "";
      function pushLine(str, ws) {
        if (line.length && ws) line += ws;
        line += str;
        while (line.length > maxLength) {
          lines.push(line.slice(0, maxLength));
          line = line.slice(maxLength);
        }
      }
      __name(pushLine, "pushLine");
      let split = input.split(/(\s+)/g);
      for (let i = 0; i < split.length; i += 2) {
        pushLine(split[i], i && split[i - 1]);
      }
      if (line.length) lines.push(line);
      return lines;
    }
    __name(textWrap, "textWrap");
    function multiLineWordWrap(maxLength, input, wrapOnWordBoundary = true) {
      let output = [];
      input = input.split("\n");
      const handler = wrapOnWordBoundary ? wordWrap : textWrap;
      for (let i = 0; i < input.length; i++) {
        output.push.apply(output, handler(maxLength, input[i]));
      }
      return output;
    }
    __name(multiLineWordWrap, "multiLineWordWrap");
    function colorizeLines(input) {
      let state = {};
      let output = [];
      for (let i = 0; i < input.length; i++) {
        let line = rewindState(state, input[i]);
        state = readState(line);
        let temp = Object.assign({}, state);
        output.push(unwindState(temp, line));
      }
      return output;
    }
    __name(colorizeLines, "colorizeLines");
    function hyperlink(url, text) {
      const OSC = "\x1B]";
      const BEL = "\x07";
      const SEP = ";";
      return [OSC, "8", SEP, SEP, url || text, BEL, text, OSC, "8", SEP, SEP, BEL].join("");
    }
    __name(hyperlink, "hyperlink");
    module.exports = {
      strlen,
      repeat,
      pad,
      truncate,
      mergeOptions,
      wordWrap: multiLineWordWrap,
      colorizeLines,
      hyperlink
    };
  }
});

// ../node_modules/@colors/colors/lib/styles.js
var require_styles = __commonJS({
  "../node_modules/@colors/colors/lib/styles.js"(exports, module) {
    var styles = {};
    module["exports"] = styles;
    var codes = {
      reset: [0, 0],
      bold: [1, 22],
      dim: [2, 22],
      italic: [3, 23],
      underline: [4, 24],
      inverse: [7, 27],
      hidden: [8, 28],
      strikethrough: [9, 29],
      black: [30, 39],
      red: [31, 39],
      green: [32, 39],
      yellow: [33, 39],
      blue: [34, 39],
      magenta: [35, 39],
      cyan: [36, 39],
      white: [37, 39],
      gray: [90, 39],
      grey: [90, 39],
      brightRed: [91, 39],
      brightGreen: [92, 39],
      brightYellow: [93, 39],
      brightBlue: [94, 39],
      brightMagenta: [95, 39],
      brightCyan: [96, 39],
      brightWhite: [97, 39],
      bgBlack: [40, 49],
      bgRed: [41, 49],
      bgGreen: [42, 49],
      bgYellow: [43, 49],
      bgBlue: [44, 49],
      bgMagenta: [45, 49],
      bgCyan: [46, 49],
      bgWhite: [47, 49],
      bgGray: [100, 49],
      bgGrey: [100, 49],
      bgBrightRed: [101, 49],
      bgBrightGreen: [102, 49],
      bgBrightYellow: [103, 49],
      bgBrightBlue: [104, 49],
      bgBrightMagenta: [105, 49],
      bgBrightCyan: [106, 49],
      bgBrightWhite: [107, 49],
      // legacy styles for colors pre v1.0.0
      blackBG: [40, 49],
      redBG: [41, 49],
      greenBG: [42, 49],
      yellowBG: [43, 49],
      blueBG: [44, 49],
      magentaBG: [45, 49],
      cyanBG: [46, 49],
      whiteBG: [47, 49]
    };
    Object.keys(codes).forEach(function(key) {
      var val = codes[key];
      var style = styles[key] = [];
      style.open = "\x1B[" + val[0] + "m";
      style.close = "\x1B[" + val[1] + "m";
    });
  }
});

// ../node_modules/@colors/colors/lib/system/has-flag.js
var require_has_flag = __commonJS({
  "../node_modules/@colors/colors/lib/system/has-flag.js"(exports, module) {
    "use strict";
    module.exports = function(flag, argv) {
      argv = argv || process.argv;
      var terminatorPos = argv.indexOf("--");
      var prefix = /^-{1,2}/.test(flag) ? "" : "--";
      var pos = argv.indexOf(prefix + flag);
      return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
    };
  }
});

// ../node_modules/@colors/colors/lib/system/supports-colors.js
var require_supports_colors = __commonJS({
  "../node_modules/@colors/colors/lib/system/supports-colors.js"(exports, module) {
    "use strict";
    var os3 = __require("os");
    var hasFlag = require_has_flag();
    var env = process.env;
    var forceColor = void 0;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false")) {
      forceColor = false;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      forceColor = true;
    }
    if ("FORCE_COLOR" in env) {
      forceColor = env.FORCE_COLOR.length === 0 || parseInt(env.FORCE_COLOR, 10) !== 0;
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    __name(translateLevel, "translateLevel");
    function supportsColor(stream) {
      if (forceColor === false) {
        return 0;
      }
      if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
        return 3;
      }
      if (hasFlag("color=256")) {
        return 2;
      }
      if (stream && !stream.isTTY && forceColor !== true) {
        return 0;
      }
      var min = forceColor ? 1 : 0;
      if (process.platform === "win32") {
        var osRelease = os3.release().split(".");
        if (Number(process.versions.node.split(".")[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI"].some(function(sign) {
          return sign in env;
        }) || env.CI_NAME === "codeship") {
          return 1;
        }
        return min;
      }
      if ("TEAMCITY_VERSION" in env) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
      }
      if ("TERM_PROGRAM" in env) {
        var version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env.TERM_PROGRAM) {
          case "iTerm.app":
            return version >= 3 ? 3 : 2;
          case "Hyper":
            return 3;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env) {
        return 1;
      }
      if (env.TERM === "dumb") {
        return min;
      }
      return min;
    }
    __name(supportsColor, "supportsColor");
    function getSupportLevel(stream) {
      var level = supportsColor(stream);
      return translateLevel(level);
    }
    __name(getSupportLevel, "getSupportLevel");
    module.exports = {
      supportsColor: getSupportLevel,
      stdout: getSupportLevel(process.stdout),
      stderr: getSupportLevel(process.stderr)
    };
  }
});

// ../node_modules/@colors/colors/lib/custom/trap.js
var require_trap = __commonJS({
  "../node_modules/@colors/colors/lib/custom/trap.js"(exports, module) {
    module["exports"] = /* @__PURE__ */ __name(function runTheTrap(text, options) {
      var result = "";
      text = text || "Run the trap, drop the bass";
      text = text.split("");
      var trap = {
        a: ["@", "\u0104", "\u023A", "\u0245", "\u0394", "\u039B", "\u0414"],
        b: ["\xDF", "\u0181", "\u0243", "\u026E", "\u03B2", "\u0E3F"],
        c: ["\xA9", "\u023B", "\u03FE"],
        d: ["\xD0", "\u018A", "\u0500", "\u0501", "\u0502", "\u0503"],
        e: [
          "\xCB",
          "\u0115",
          "\u018E",
          "\u0258",
          "\u03A3",
          "\u03BE",
          "\u04BC",
          "\u0A6C"
        ],
        f: ["\u04FA"],
        g: ["\u0262"],
        h: ["\u0126", "\u0195", "\u04A2", "\u04BA", "\u04C7", "\u050A"],
        i: ["\u0F0F"],
        j: ["\u0134"],
        k: ["\u0138", "\u04A0", "\u04C3", "\u051E"],
        l: ["\u0139"],
        m: ["\u028D", "\u04CD", "\u04CE", "\u0520", "\u0521", "\u0D69"],
        n: ["\xD1", "\u014B", "\u019D", "\u0376", "\u03A0", "\u048A"],
        o: [
          "\xD8",
          "\xF5",
          "\xF8",
          "\u01FE",
          "\u0298",
          "\u047A",
          "\u05DD",
          "\u06DD",
          "\u0E4F"
        ],
        p: ["\u01F7", "\u048E"],
        q: ["\u09CD"],
        r: ["\xAE", "\u01A6", "\u0210", "\u024C", "\u0280", "\u042F"],
        s: ["\xA7", "\u03DE", "\u03DF", "\u03E8"],
        t: ["\u0141", "\u0166", "\u0373"],
        u: ["\u01B1", "\u054D"],
        v: ["\u05D8"],
        w: ["\u0428", "\u0460", "\u047C", "\u0D70"],
        x: ["\u04B2", "\u04FE", "\u04FC", "\u04FD"],
        y: ["\xA5", "\u04B0", "\u04CB"],
        z: ["\u01B5", "\u0240"]
      };
      text.forEach(function(c) {
        c = c.toLowerCase();
        var chars = trap[c] || [" "];
        var rand = Math.floor(Math.random() * chars.length);
        if (typeof trap[c] !== "undefined") {
          result += trap[c][rand];
        } else {
          result += c;
        }
      });
      return result;
    }, "runTheTrap");
  }
});

// ../node_modules/@colors/colors/lib/custom/zalgo.js
var require_zalgo = __commonJS({
  "../node_modules/@colors/colors/lib/custom/zalgo.js"(exports, module) {
    module["exports"] = /* @__PURE__ */ __name(function zalgo(text, options) {
      text = text || "   he is here   ";
      var soul = {
        "up": [
          "\u030D",
          "\u030E",
          "\u0304",
          "\u0305",
          "\u033F",
          "\u0311",
          "\u0306",
          "\u0310",
          "\u0352",
          "\u0357",
          "\u0351",
          "\u0307",
          "\u0308",
          "\u030A",
          "\u0342",
          "\u0313",
          "\u0308",
          "\u034A",
          "\u034B",
          "\u034C",
          "\u0303",
          "\u0302",
          "\u030C",
          "\u0350",
          "\u0300",
          "\u0301",
          "\u030B",
          "\u030F",
          "\u0312",
          "\u0313",
          "\u0314",
          "\u033D",
          "\u0309",
          "\u0363",
          "\u0364",
          "\u0365",
          "\u0366",
          "\u0367",
          "\u0368",
          "\u0369",
          "\u036A",
          "\u036B",
          "\u036C",
          "\u036D",
          "\u036E",
          "\u036F",
          "\u033E",
          "\u035B",
          "\u0346",
          "\u031A"
        ],
        "down": [
          "\u0316",
          "\u0317",
          "\u0318",
          "\u0319",
          "\u031C",
          "\u031D",
          "\u031E",
          "\u031F",
          "\u0320",
          "\u0324",
          "\u0325",
          "\u0326",
          "\u0329",
          "\u032A",
          "\u032B",
          "\u032C",
          "\u032D",
          "\u032E",
          "\u032F",
          "\u0330",
          "\u0331",
          "\u0332",
          "\u0333",
          "\u0339",
          "\u033A",
          "\u033B",
          "\u033C",
          "\u0345",
          "\u0347",
          "\u0348",
          "\u0349",
          "\u034D",
          "\u034E",
          "\u0353",
          "\u0354",
          "\u0355",
          "\u0356",
          "\u0359",
          "\u035A",
          "\u0323"
        ],
        "mid": [
          "\u0315",
          "\u031B",
          "\u0300",
          "\u0301",
          "\u0358",
          "\u0321",
          "\u0322",
          "\u0327",
          "\u0328",
          "\u0334",
          "\u0335",
          "\u0336",
          "\u035C",
          "\u035D",
          "\u035E",
          "\u035F",
          "\u0360",
          "\u0362",
          "\u0338",
          "\u0337",
          "\u0361",
          " \u0489"
        ]
      };
      var all = [].concat(soul.up, soul.down, soul.mid);
      function randomNumber(range) {
        var r = Math.floor(Math.random() * range);
        return r;
      }
      __name(randomNumber, "randomNumber");
      function isChar(character) {
        var bool = false;
        all.filter(function(i) {
          bool = i === character;
        });
        return bool;
      }
      __name(isChar, "isChar");
      function heComes(text2, options2) {
        var result = "";
        var counts;
        var l;
        options2 = options2 || {};
        options2["up"] = typeof options2["up"] !== "undefined" ? options2["up"] : true;
        options2["mid"] = typeof options2["mid"] !== "undefined" ? options2["mid"] : true;
        options2["down"] = typeof options2["down"] !== "undefined" ? options2["down"] : true;
        options2["size"] = typeof options2["size"] !== "undefined" ? options2["size"] : "maxi";
        text2 = text2.split("");
        for (l in text2) {
          if (isChar(l)) {
            continue;
          }
          result = result + text2[l];
          counts = { "up": 0, "down": 0, "mid": 0 };
          switch (options2.size) {
            case "mini":
              counts.up = randomNumber(8);
              counts.mid = randomNumber(2);
              counts.down = randomNumber(8);
              break;
            case "maxi":
              counts.up = randomNumber(16) + 3;
              counts.mid = randomNumber(4) + 1;
              counts.down = randomNumber(64) + 3;
              break;
            default:
              counts.up = randomNumber(8) + 1;
              counts.mid = randomNumber(6) / 2;
              counts.down = randomNumber(8) + 1;
              break;
          }
          var arr = ["up", "mid", "down"];
          for (var d in arr) {
            var index = arr[d];
            for (var i = 0; i <= counts[index]; i++) {
              if (options2[index]) {
                result = result + soul[index][randomNumber(soul[index].length)];
              }
            }
          }
        }
        return result;
      }
      __name(heComes, "heComes");
      return heComes(text, options);
    }, "zalgo");
  }
});

// ../node_modules/@colors/colors/lib/maps/america.js
var require_america = __commonJS({
  "../node_modules/@colors/colors/lib/maps/america.js"(exports, module) {
    module["exports"] = function(colors3) {
      return function(letter, i, exploded) {
        if (letter === " ") return letter;
        switch (i % 3) {
          case 0:
            return colors3.red(letter);
          case 1:
            return colors3.white(letter);
          case 2:
            return colors3.blue(letter);
        }
      };
    };
  }
});

// ../node_modules/@colors/colors/lib/maps/zebra.js
var require_zebra = __commonJS({
  "../node_modules/@colors/colors/lib/maps/zebra.js"(exports, module) {
    module["exports"] = function(colors3) {
      return function(letter, i, exploded) {
        return i % 2 === 0 ? letter : colors3.inverse(letter);
      };
    };
  }
});

// ../node_modules/@colors/colors/lib/maps/rainbow.js
var require_rainbow = __commonJS({
  "../node_modules/@colors/colors/lib/maps/rainbow.js"(exports, module) {
    module["exports"] = function(colors3) {
      var rainbowColors = ["red", "yellow", "green", "blue", "magenta"];
      return function(letter, i, exploded) {
        if (letter === " ") {
          return letter;
        } else {
          return colors3[rainbowColors[i++ % rainbowColors.length]](letter);
        }
      };
    };
  }
});

// ../node_modules/@colors/colors/lib/maps/random.js
var require_random = __commonJS({
  "../node_modules/@colors/colors/lib/maps/random.js"(exports, module) {
    module["exports"] = function(colors3) {
      var available = [
        "underline",
        "inverse",
        "grey",
        "yellow",
        "red",
        "green",
        "blue",
        "white",
        "cyan",
        "magenta",
        "brightYellow",
        "brightRed",
        "brightGreen",
        "brightBlue",
        "brightWhite",
        "brightCyan",
        "brightMagenta"
      ];
      return function(letter, i, exploded) {
        return letter === " " ? letter : colors3[available[Math.round(Math.random() * (available.length - 2))]](letter);
      };
    };
  }
});

// ../node_modules/@colors/colors/lib/colors.js
var require_colors = __commonJS({
  "../node_modules/@colors/colors/lib/colors.js"(exports, module) {
    var colors3 = {};
    module["exports"] = colors3;
    colors3.themes = {};
    var util = __require("util");
    var ansiStyles = colors3.styles = require_styles();
    var defineProps = Object.defineProperties;
    var newLineRegex = new RegExp(/[\r\n]+/g);
    colors3.supportsColor = require_supports_colors().supportsColor;
    if (typeof colors3.enabled === "undefined") {
      colors3.enabled = colors3.supportsColor() !== false;
    }
    colors3.enable = function() {
      colors3.enabled = true;
    };
    colors3.disable = function() {
      colors3.enabled = false;
    };
    colors3.stripColors = colors3.strip = function(str) {
      return ("" + str).replace(/\x1B\[\d+m/g, "");
    };
    var stylize = colors3.stylize = /* @__PURE__ */ __name(function stylize2(str, style) {
      if (!colors3.enabled) {
        return str + "";
      }
      var styleMap = ansiStyles[style];
      if (!styleMap && style in colors3) {
        return colors3[style](str);
      }
      return styleMap.open + str + styleMap.close;
    }, "stylize");
    var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
    var escapeStringRegexp = /* @__PURE__ */ __name(function(str) {
      if (typeof str !== "string") {
        throw new TypeError("Expected a string");
      }
      return str.replace(matchOperatorsRe, "\\$&");
    }, "escapeStringRegexp");
    function build2(_styles) {
      var builder = /* @__PURE__ */ __name(function builder2() {
        return applyStyle.apply(builder2, arguments);
      }, "builder");
      builder._styles = _styles;
      builder.__proto__ = proto;
      return builder;
    }
    __name(build2, "build");
    var styles = function() {
      var ret = {};
      ansiStyles.grey = ansiStyles.gray;
      Object.keys(ansiStyles).forEach(function(key) {
        ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), "g");
        ret[key] = {
          get: /* @__PURE__ */ __name(function() {
            return build2(this._styles.concat(key));
          }, "get")
        };
      });
      return ret;
    }();
    var proto = defineProps(/* @__PURE__ */ __name(function colors4() {
    }, "colors"), styles);
    function applyStyle() {
      var args = Array.prototype.slice.call(arguments);
      var str = args.map(function(arg) {
        if (arg != null && arg.constructor === String) {
          return arg;
        } else {
          return util.inspect(arg);
        }
      }).join(" ");
      if (!colors3.enabled || !str) {
        return str;
      }
      var newLinesPresent = str.indexOf("\n") != -1;
      var nestedStyles = this._styles;
      var i = nestedStyles.length;
      while (i--) {
        var code = ansiStyles[nestedStyles[i]];
        str = code.open + str.replace(code.closeRe, code.open) + code.close;
        if (newLinesPresent) {
          str = str.replace(newLineRegex, function(match) {
            return code.close + match + code.open;
          });
        }
      }
      return str;
    }
    __name(applyStyle, "applyStyle");
    colors3.setTheme = function(theme) {
      if (typeof theme === "string") {
        console.log("colors.setTheme now only accepts an object, not a string.  If you are trying to set a theme from a file, it is now your (the caller's) responsibility to require the file.  The old syntax looked like colors.setTheme(__dirname + '/../themes/generic-logging.js'); The new syntax looks like colors.setTheme(require(__dirname + '/../themes/generic-logging.js'));");
        return;
      }
      for (var style in theme) {
        (function(style2) {
          colors3[style2] = function(str) {
            if (typeof theme[style2] === "object") {
              var out = str;
              for (var i in theme[style2]) {
                out = colors3[theme[style2][i]](out);
              }
              return out;
            }
            return colors3[theme[style2]](str);
          };
        })(style);
      }
    };
    function init() {
      var ret = {};
      Object.keys(styles).forEach(function(name) {
        ret[name] = {
          get: /* @__PURE__ */ __name(function() {
            return build2([name]);
          }, "get")
        };
      });
      return ret;
    }
    __name(init, "init");
    var sequencer = /* @__PURE__ */ __name(function sequencer2(map2, str) {
      var exploded = str.split("");
      exploded = exploded.map(map2);
      return exploded.join("");
    }, "sequencer");
    colors3.trap = require_trap();
    colors3.zalgo = require_zalgo();
    colors3.maps = {};
    colors3.maps.america = require_america()(colors3);
    colors3.maps.zebra = require_zebra()(colors3);
    colors3.maps.rainbow = require_rainbow()(colors3);
    colors3.maps.random = require_random()(colors3);
    for (map in colors3.maps) {
      (function(map2) {
        colors3[map2] = function(str) {
          return sequencer(colors3.maps[map2], str);
        };
      })(map);
    }
    var map;
    defineProps(colors3, init());
  }
});

// ../node_modules/@colors/colors/safe.js
var require_safe = __commonJS({
  "../node_modules/@colors/colors/safe.js"(exports, module) {
    var colors3 = require_colors();
    module["exports"] = colors3;
  }
});

// ../node_modules/cli-table3/src/cell.js
var require_cell = __commonJS({
  "../node_modules/cli-table3/src/cell.js"(exports, module) {
    var { info, debug } = require_debug();
    var utils = require_utils2();
    var Cell = class _Cell {
      static {
        __name(this, "Cell");
      }
      /**
       * A representation of a cell within the table.
       * Implementations must have `init` and `draw` methods,
       * as well as `colSpan`, `rowSpan`, `desiredHeight` and `desiredWidth` properties.
       * @param options
       * @constructor
       */
      constructor(options) {
        this.setOptions(options);
        this.x = null;
        this.y = null;
      }
      setOptions(options) {
        if (["boolean", "number", "bigint", "string"].indexOf(typeof options) !== -1) {
          options = { content: "" + options };
        }
        options = options || {};
        this.options = options;
        let content = options.content;
        if (["boolean", "number", "bigint", "string"].indexOf(typeof content) !== -1) {
          this.content = String(content);
        } else if (!content) {
          this.content = this.options.href || "";
        } else {
          throw new Error("Content needs to be a primitive, got: " + typeof content);
        }
        this.colSpan = options.colSpan || 1;
        this.rowSpan = options.rowSpan || 1;
        if (this.options.href) {
          Object.defineProperty(this, "href", {
            get() {
              return this.options.href;
            }
          });
        }
      }
      mergeTableOptions(tableOptions, cells) {
        this.cells = cells;
        let optionsChars = this.options.chars || {};
        let tableChars = tableOptions.chars;
        let chars = this.chars = {};
        CHAR_NAMES.forEach(function(name) {
          setOption(optionsChars, tableChars, name, chars);
        });
        this.truncate = this.options.truncate || tableOptions.truncate;
        let style = this.options.style = this.options.style || {};
        let tableStyle = tableOptions.style;
        setOption(style, tableStyle, "padding-left", this);
        setOption(style, tableStyle, "padding-right", this);
        this.head = style.head || tableStyle.head;
        this.border = style.border || tableStyle.border;
        this.fixedWidth = tableOptions.colWidths[this.x];
        this.lines = this.computeLines(tableOptions);
        this.desiredWidth = utils.strlen(this.content) + this.paddingLeft + this.paddingRight;
        this.desiredHeight = this.lines.length;
      }
      computeLines(tableOptions) {
        const tableWordWrap = tableOptions.wordWrap || tableOptions.textWrap;
        const { wordWrap = tableWordWrap } = this.options;
        if (this.fixedWidth && wordWrap) {
          this.fixedWidth -= this.paddingLeft + this.paddingRight;
          if (this.colSpan) {
            let i = 1;
            while (i < this.colSpan) {
              this.fixedWidth += tableOptions.colWidths[this.x + i];
              i++;
            }
          }
          const { wrapOnWordBoundary: tableWrapOnWordBoundary = true } = tableOptions;
          const { wrapOnWordBoundary = tableWrapOnWordBoundary } = this.options;
          return this.wrapLines(utils.wordWrap(this.fixedWidth, this.content, wrapOnWordBoundary));
        }
        return this.wrapLines(this.content.split("\n"));
      }
      wrapLines(computedLines) {
        const lines = utils.colorizeLines(computedLines);
        if (this.href) {
          return lines.map((line) => utils.hyperlink(this.href, line));
        }
        return lines;
      }
      /**
       * Initializes the Cells data structure.
       *
       * @param tableOptions - A fully populated set of tableOptions.
       * In addition to the standard default values, tableOptions must have fully populated the
       * `colWidths` and `rowWidths` arrays. Those arrays must have lengths equal to the number
       * of columns or rows (respectively) in this table, and each array item must be a Number.
       *
       */
      init(tableOptions) {
        let x = this.x;
        let y = this.y;
        this.widths = tableOptions.colWidths.slice(x, x + this.colSpan);
        this.heights = tableOptions.rowHeights.slice(y, y + this.rowSpan);
        this.width = this.widths.reduce(sumPlusOne, -1);
        this.height = this.heights.reduce(sumPlusOne, -1);
        this.hAlign = this.options.hAlign || tableOptions.colAligns[x];
        this.vAlign = this.options.vAlign || tableOptions.rowAligns[y];
        this.drawRight = x + this.colSpan == tableOptions.colWidths.length;
      }
      /**
       * Draws the given line of the cell.
       * This default implementation defers to methods `drawTop`, `drawBottom`, `drawLine` and `drawEmpty`.
       * @param lineNum - can be `top`, `bottom` or a numerical line number.
       * @param spanningCell - will be a number if being called from a RowSpanCell, and will represent how
       * many rows below it's being called from. Otherwise it's undefined.
       * @returns {String} The representation of this line.
       */
      draw(lineNum, spanningCell) {
        if (lineNum == "top") return this.drawTop(this.drawRight);
        if (lineNum == "bottom") return this.drawBottom(this.drawRight);
        let content = utils.truncate(this.content, 10, this.truncate);
        if (!lineNum) {
          info(`${this.y}-${this.x}: ${this.rowSpan - lineNum}x${this.colSpan} Cell ${content}`);
        } else {
        }
        let padLen = Math.max(this.height - this.lines.length, 0);
        let padTop;
        switch (this.vAlign) {
          case "center":
            padTop = Math.ceil(padLen / 2);
            break;
          case "bottom":
            padTop = padLen;
            break;
          default:
            padTop = 0;
        }
        if (lineNum < padTop || lineNum >= padTop + this.lines.length) {
          return this.drawEmpty(this.drawRight, spanningCell);
        }
        let forceTruncation = this.lines.length > this.height && lineNum + 1 >= this.height;
        return this.drawLine(lineNum - padTop, this.drawRight, forceTruncation, spanningCell);
      }
      /**
       * Renders the top line of the cell.
       * @param drawRight - true if this method should render the right edge of the cell.
       * @returns {String}
       */
      drawTop(drawRight) {
        let content = [];
        if (this.cells) {
          this.widths.forEach(function(width, index) {
            content.push(this._topLeftChar(index));
            content.push(utils.repeat(this.chars[this.y == 0 ? "top" : "mid"], width));
          }, this);
        } else {
          content.push(this._topLeftChar(0));
          content.push(utils.repeat(this.chars[this.y == 0 ? "top" : "mid"], this.width));
        }
        if (drawRight) {
          content.push(this.chars[this.y == 0 ? "topRight" : "rightMid"]);
        }
        return this.wrapWithStyleColors("border", content.join(""));
      }
      _topLeftChar(offset) {
        let x = this.x + offset;
        let leftChar;
        if (this.y == 0) {
          leftChar = x == 0 ? "topLeft" : offset == 0 ? "topMid" : "top";
        } else {
          if (x == 0) {
            leftChar = "leftMid";
          } else {
            leftChar = offset == 0 ? "midMid" : "bottomMid";
            if (this.cells) {
              let spanAbove = this.cells[this.y - 1][x] instanceof _Cell.ColSpanCell;
              if (spanAbove) {
                leftChar = offset == 0 ? "topMid" : "mid";
              }
              if (offset == 0) {
                let i = 1;
                while (this.cells[this.y][x - i] instanceof _Cell.ColSpanCell) {
                  i++;
                }
                if (this.cells[this.y][x - i] instanceof _Cell.RowSpanCell) {
                  leftChar = "leftMid";
                }
              }
            }
          }
        }
        return this.chars[leftChar];
      }
      wrapWithStyleColors(styleProperty, content) {
        if (this[styleProperty] && this[styleProperty].length) {
          try {
            let colors3 = require_safe();
            for (let i = this[styleProperty].length - 1; i >= 0; i--) {
              colors3 = colors3[this[styleProperty][i]];
            }
            return colors3(content);
          } catch (e) {
            return content;
          }
        } else {
          return content;
        }
      }
      /**
       * Renders a line of text.
       * @param lineNum - Which line of text to render. This is not necessarily the line within the cell.
       * There may be top-padding above the first line of text.
       * @param drawRight - true if this method should render the right edge of the cell.
       * @param forceTruncationSymbol - `true` if the rendered text should end with the truncation symbol even
       * if the text fits. This is used when the cell is vertically truncated. If `false` the text should
       * only include the truncation symbol if the text will not fit horizontally within the cell width.
       * @param spanningCell - a number of if being called from a RowSpanCell. (how many rows below). otherwise undefined.
       * @returns {String}
       */
      drawLine(lineNum, drawRight, forceTruncationSymbol, spanningCell) {
        let left = this.chars[this.x == 0 ? "left" : "middle"];
        if (this.x && spanningCell && this.cells) {
          let cellLeft = this.cells[this.y + spanningCell][this.x - 1];
          while (cellLeft instanceof ColSpanCell) {
            cellLeft = this.cells[cellLeft.y][cellLeft.x - 1];
          }
          if (!(cellLeft instanceof RowSpanCell)) {
            left = this.chars["rightMid"];
          }
        }
        let leftPadding = utils.repeat(" ", this.paddingLeft);
        let right = drawRight ? this.chars["right"] : "";
        let rightPadding = utils.repeat(" ", this.paddingRight);
        let line = this.lines[lineNum];
        let len = this.width - (this.paddingLeft + this.paddingRight);
        if (forceTruncationSymbol) line += this.truncate || "\u2026";
        let content = utils.truncate(line, len, this.truncate);
        content = utils.pad(content, len, " ", this.hAlign);
        content = leftPadding + content + rightPadding;
        return this.stylizeLine(left, content, right);
      }
      stylizeLine(left, content, right) {
        left = this.wrapWithStyleColors("border", left);
        right = this.wrapWithStyleColors("border", right);
        if (this.y === 0) {
          content = this.wrapWithStyleColors("head", content);
        }
        return left + content + right;
      }
      /**
       * Renders the bottom line of the cell.
       * @param drawRight - true if this method should render the right edge of the cell.
       * @returns {String}
       */
      drawBottom(drawRight) {
        let left = this.chars[this.x == 0 ? "bottomLeft" : "bottomMid"];
        let content = utils.repeat(this.chars.bottom, this.width);
        let right = drawRight ? this.chars["bottomRight"] : "";
        return this.wrapWithStyleColors("border", left + content + right);
      }
      /**
       * Renders a blank line of text within the cell. Used for top and/or bottom padding.
       * @param drawRight - true if this method should render the right edge of the cell.
       * @param spanningCell - a number of if being called from a RowSpanCell. (how many rows below). otherwise undefined.
       * @returns {String}
       */
      drawEmpty(drawRight, spanningCell) {
        let left = this.chars[this.x == 0 ? "left" : "middle"];
        if (this.x && spanningCell && this.cells) {
          let cellLeft = this.cells[this.y + spanningCell][this.x - 1];
          while (cellLeft instanceof ColSpanCell) {
            cellLeft = this.cells[cellLeft.y][cellLeft.x - 1];
          }
          if (!(cellLeft instanceof RowSpanCell)) {
            left = this.chars["rightMid"];
          }
        }
        let right = drawRight ? this.chars["right"] : "";
        let content = utils.repeat(" ", this.width);
        return this.stylizeLine(left, content, right);
      }
    };
    var ColSpanCell = class {
      static {
        __name(this, "ColSpanCell");
      }
      /**
       * A Cell that doesn't do anything. It just draws empty lines.
       * Used as a placeholder in column spanning.
       * @constructor
       */
      constructor() {
      }
      draw(lineNum) {
        if (typeof lineNum === "number") {
          debug(`${this.y}-${this.x}: 1x1 ColSpanCell`);
        }
        return "";
      }
      init() {
      }
      mergeTableOptions() {
      }
    };
    var RowSpanCell = class {
      static {
        __name(this, "RowSpanCell");
      }
      /**
       * A placeholder Cell for a Cell that spans multiple rows.
       * It delegates rendering to the original cell, but adds the appropriate offset.
       * @param originalCell
       * @constructor
       */
      constructor(originalCell) {
        this.originalCell = originalCell;
      }
      init(tableOptions) {
        let y = this.y;
        let originalY = this.originalCell.y;
        this.cellOffset = y - originalY;
        this.offset = findDimension(tableOptions.rowHeights, originalY, this.cellOffset);
      }
      draw(lineNum) {
        if (lineNum == "top") {
          return this.originalCell.draw(this.offset, this.cellOffset);
        }
        if (lineNum == "bottom") {
          return this.originalCell.draw("bottom");
        }
        debug(`${this.y}-${this.x}: 1x${this.colSpan} RowSpanCell for ${this.originalCell.content}`);
        return this.originalCell.draw(this.offset + 1 + lineNum);
      }
      mergeTableOptions() {
      }
    };
    function firstDefined(...args) {
      return args.filter((v) => v !== void 0 && v !== null).shift();
    }
    __name(firstDefined, "firstDefined");
    function setOption(objA, objB, nameB, targetObj) {
      let nameA = nameB.split("-");
      if (nameA.length > 1) {
        nameA[1] = nameA[1].charAt(0).toUpperCase() + nameA[1].substr(1);
        nameA = nameA.join("");
        targetObj[nameA] = firstDefined(objA[nameA], objA[nameB], objB[nameA], objB[nameB]);
      } else {
        targetObj[nameB] = firstDefined(objA[nameB], objB[nameB]);
      }
    }
    __name(setOption, "setOption");
    function findDimension(dimensionTable, startingIndex, span) {
      let ret = dimensionTable[startingIndex];
      for (let i = 1; i < span; i++) {
        ret += 1 + dimensionTable[startingIndex + i];
      }
      return ret;
    }
    __name(findDimension, "findDimension");
    function sumPlusOne(a, b) {
      return a + b + 1;
    }
    __name(sumPlusOne, "sumPlusOne");
    var CHAR_NAMES = [
      "top",
      "top-mid",
      "top-left",
      "top-right",
      "bottom",
      "bottom-mid",
      "bottom-left",
      "bottom-right",
      "left",
      "left-mid",
      "mid",
      "mid-mid",
      "right",
      "right-mid",
      "middle"
    ];
    module.exports = Cell;
    module.exports.ColSpanCell = ColSpanCell;
    module.exports.RowSpanCell = RowSpanCell;
  }
});

// ../node_modules/cli-table3/src/layout-manager.js
var require_layout_manager = __commonJS({
  "../node_modules/cli-table3/src/layout-manager.js"(exports, module) {
    var { warn, debug } = require_debug();
    var Cell = require_cell();
    var { ColSpanCell, RowSpanCell } = Cell;
    (function() {
      function next(alloc, col) {
        if (alloc[col] > 0) {
          return next(alloc, col + 1);
        }
        return col;
      }
      __name(next, "next");
      function layoutTable(table) {
        let alloc = {};
        table.forEach(function(row, rowIndex) {
          let col = 0;
          row.forEach(function(cell) {
            cell.y = rowIndex;
            cell.x = rowIndex ? next(alloc, col) : col;
            const rowSpan = cell.rowSpan || 1;
            const colSpan = cell.colSpan || 1;
            if (rowSpan > 1) {
              for (let cs = 0; cs < colSpan; cs++) {
                alloc[cell.x + cs] = rowSpan;
              }
            }
            col = cell.x + colSpan;
          });
          Object.keys(alloc).forEach((idx) => {
            alloc[idx]--;
            if (alloc[idx] < 1) delete alloc[idx];
          });
        });
      }
      __name(layoutTable, "layoutTable");
      function maxWidth(table) {
        let mw = 0;
        table.forEach(function(row) {
          row.forEach(function(cell) {
            mw = Math.max(mw, cell.x + (cell.colSpan || 1));
          });
        });
        return mw;
      }
      __name(maxWidth, "maxWidth");
      function maxHeight(table) {
        return table.length;
      }
      __name(maxHeight, "maxHeight");
      function cellsConflict(cell1, cell2) {
        let yMin1 = cell1.y;
        let yMax1 = cell1.y - 1 + (cell1.rowSpan || 1);
        let yMin2 = cell2.y;
        let yMax2 = cell2.y - 1 + (cell2.rowSpan || 1);
        let yConflict = !(yMin1 > yMax2 || yMin2 > yMax1);
        let xMin1 = cell1.x;
        let xMax1 = cell1.x - 1 + (cell1.colSpan || 1);
        let xMin2 = cell2.x;
        let xMax2 = cell2.x - 1 + (cell2.colSpan || 1);
        let xConflict = !(xMin1 > xMax2 || xMin2 > xMax1);
        return yConflict && xConflict;
      }
      __name(cellsConflict, "cellsConflict");
      function conflictExists(rows, x, y) {
        let i_max = Math.min(rows.length - 1, y);
        let cell = { x, y };
        for (let i = 0; i <= i_max; i++) {
          let row = rows[i];
          for (let j = 0; j < row.length; j++) {
            if (cellsConflict(cell, row[j])) {
              return true;
            }
          }
        }
        return false;
      }
      __name(conflictExists, "conflictExists");
      function allBlank(rows, y, xMin, xMax) {
        for (let x = xMin; x < xMax; x++) {
          if (conflictExists(rows, x, y)) {
            return false;
          }
        }
        return true;
      }
      __name(allBlank, "allBlank");
      function addRowSpanCells(table) {
        table.forEach(function(row, rowIndex) {
          row.forEach(function(cell) {
            for (let i = 1; i < cell.rowSpan; i++) {
              let rowSpanCell = new RowSpanCell(cell);
              rowSpanCell.x = cell.x;
              rowSpanCell.y = cell.y + i;
              rowSpanCell.colSpan = cell.colSpan;
              insertCell(rowSpanCell, table[rowIndex + i]);
            }
          });
        });
      }
      __name(addRowSpanCells, "addRowSpanCells");
      function addColSpanCells(cellRows) {
        for (let rowIndex = cellRows.length - 1; rowIndex >= 0; rowIndex--) {
          let cellColumns = cellRows[rowIndex];
          for (let columnIndex = 0; columnIndex < cellColumns.length; columnIndex++) {
            let cell = cellColumns[columnIndex];
            for (let k = 1; k < cell.colSpan; k++) {
              let colSpanCell = new ColSpanCell();
              colSpanCell.x = cell.x + k;
              colSpanCell.y = cell.y;
              cellColumns.splice(columnIndex + 1, 0, colSpanCell);
            }
          }
        }
      }
      __name(addColSpanCells, "addColSpanCells");
      function insertCell(cell, row) {
        let x = 0;
        while (x < row.length && row[x].x < cell.x) {
          x++;
        }
        row.splice(x, 0, cell);
      }
      __name(insertCell, "insertCell");
      function fillInTable(table) {
        let h_max = maxHeight(table);
        let w_max = maxWidth(table);
        debug(`Max rows: ${h_max}; Max cols: ${w_max}`);
        for (let y = 0; y < h_max; y++) {
          for (let x = 0; x < w_max; x++) {
            if (!conflictExists(table, x, y)) {
              let opts = { x, y, colSpan: 1, rowSpan: 1 };
              x++;
              while (x < w_max && !conflictExists(table, x, y)) {
                opts.colSpan++;
                x++;
              }
              let y2 = y + 1;
              while (y2 < h_max && allBlank(table, y2, opts.x, opts.x + opts.colSpan)) {
                opts.rowSpan++;
                y2++;
              }
              let cell = new Cell(opts);
              cell.x = opts.x;
              cell.y = opts.y;
              warn(`Missing cell at ${cell.y}-${cell.x}.`);
              insertCell(cell, table[y]);
            }
          }
        }
      }
      __name(fillInTable, "fillInTable");
      function generateCells(rows) {
        return rows.map(function(row) {
          if (!Array.isArray(row)) {
            let key = Object.keys(row)[0];
            row = row[key];
            if (Array.isArray(row)) {
              row = row.slice();
              row.unshift(key);
            } else {
              row = [key, row];
            }
          }
          return row.map(function(cell) {
            return new Cell(cell);
          });
        });
      }
      __name(generateCells, "generateCells");
      function makeTableLayout(rows) {
        let cellRows = generateCells(rows);
        layoutTable(cellRows);
        fillInTable(cellRows);
        addRowSpanCells(cellRows);
        addColSpanCells(cellRows);
        return cellRows;
      }
      __name(makeTableLayout, "makeTableLayout");
      module.exports = {
        makeTableLayout,
        layoutTable,
        addRowSpanCells,
        maxWidth,
        fillInTable,
        computeWidths: makeComputeWidths("colSpan", "desiredWidth", "x", 1),
        computeHeights: makeComputeWidths("rowSpan", "desiredHeight", "y", 1)
      };
    })();
    function makeComputeWidths(colSpan, desiredWidth, x, forcedMin) {
      return function(vals, table) {
        let result = [];
        let spanners = [];
        let auto = {};
        table.forEach(function(row) {
          row.forEach(function(cell) {
            if ((cell[colSpan] || 1) > 1) {
              spanners.push(cell);
            } else {
              result[cell[x]] = Math.max(result[cell[x]] || 0, cell[desiredWidth] || 0, forcedMin);
            }
          });
        });
        vals.forEach(function(val, index) {
          if (typeof val === "number") {
            result[index] = val;
          }
        });
        for (let k = spanners.length - 1; k >= 0; k--) {
          let cell = spanners[k];
          let span = cell[colSpan];
          let col = cell[x];
          let existingWidth = result[col];
          let editableCols = typeof vals[col] === "number" ? 0 : 1;
          if (typeof existingWidth === "number") {
            for (let i = 1; i < span; i++) {
              existingWidth += 1 + result[col + i];
              if (typeof vals[col + i] !== "number") {
                editableCols++;
              }
            }
          } else {
            existingWidth = desiredWidth === "desiredWidth" ? cell.desiredWidth - 1 : 1;
            if (!auto[col] || auto[col] < existingWidth) {
              auto[col] = existingWidth;
            }
          }
          if (cell[desiredWidth] > existingWidth) {
            let i = 0;
            while (editableCols > 0 && cell[desiredWidth] > existingWidth) {
              if (typeof vals[col + i] !== "number") {
                let dif = Math.round((cell[desiredWidth] - existingWidth) / editableCols);
                existingWidth += dif;
                result[col + i] += dif;
                editableCols--;
              }
              i++;
            }
          }
        }
        Object.assign(vals, result, auto);
        for (let j = 0; j < vals.length; j++) {
          vals[j] = Math.max(forcedMin, vals[j] || 0);
        }
      };
    }
    __name(makeComputeWidths, "makeComputeWidths");
  }
});

// ../node_modules/cli-table3/src/table.js
var require_table = __commonJS({
  "../node_modules/cli-table3/src/table.js"(exports, module) {
    var debug = require_debug();
    var utils = require_utils2();
    var tableLayout = require_layout_manager();
    var Table2 = class extends Array {
      static {
        __name(this, "Table");
      }
      constructor(opts) {
        super();
        const options = utils.mergeOptions(opts);
        Object.defineProperty(this, "options", {
          value: options,
          enumerable: options.debug
        });
        if (options.debug) {
          switch (typeof options.debug) {
            case "boolean":
              debug.setDebugLevel(debug.WARN);
              break;
            case "number":
              debug.setDebugLevel(options.debug);
              break;
            case "string":
              debug.setDebugLevel(parseInt(options.debug, 10));
              break;
            default:
              debug.setDebugLevel(debug.WARN);
              debug.warn(`Debug option is expected to be boolean, number, or string. Received a ${typeof options.debug}`);
          }
          Object.defineProperty(this, "messages", {
            get() {
              return debug.debugMessages();
            }
          });
        }
      }
      toString() {
        let array = this;
        let headersPresent = this.options.head && this.options.head.length;
        if (headersPresent) {
          array = [this.options.head];
          if (this.length) {
            array.push.apply(array, this);
          }
        } else {
          this.options.style.head = [];
        }
        let cells = tableLayout.makeTableLayout(array);
        cells.forEach(function(row) {
          row.forEach(function(cell) {
            cell.mergeTableOptions(this.options, cells);
          }, this);
        }, this);
        tableLayout.computeWidths(this.options.colWidths, cells);
        tableLayout.computeHeights(this.options.rowHeights, cells);
        cells.forEach(function(row) {
          row.forEach(function(cell) {
            cell.init(this.options);
          }, this);
        }, this);
        let result = [];
        for (let rowIndex = 0; rowIndex < cells.length; rowIndex++) {
          let row = cells[rowIndex];
          let heightOfRow = this.options.rowHeights[rowIndex];
          if (rowIndex === 0 || !this.options.style.compact || rowIndex == 1 && headersPresent) {
            doDraw(row, "top", result);
          }
          for (let lineNum = 0; lineNum < heightOfRow; lineNum++) {
            doDraw(row, lineNum, result);
          }
          if (rowIndex + 1 == cells.length) {
            doDraw(row, "bottom", result);
          }
        }
        return result.join("\n");
      }
      get width() {
        let str = this.toString().split("\n");
        return str[0].length;
      }
    };
    Table2.reset = () => debug.reset();
    function doDraw(row, lineNum, result) {
      let line = [];
      row.forEach(function(cell) {
        line.push(cell.draw(lineNum));
      });
      let str = line.join("");
      if (str.length) result.push(str);
    }
    __name(doDraw, "doDraw");
    module.exports = Table2;
  }
});

// ../node_modules/cli-table3/index.js
var require_cli_table3 = __commonJS({
  "../node_modules/cli-table3/index.js"(exports, module) {
    module.exports = require_table();
  }
});

// src/core-server/index.ts
import { getPreviewHeadTemplate, getPreviewBodyTemplate } from "storybook/internal/common";

// src/core-server/build-static.ts
import { cp as cp2, mkdir } from "node:fs/promises";
import { rm } from "node:fs/promises";
import {
  loadAllPresets,
  loadMainConfig,
  logConfig,
  normalizeStories,
  resolveAddonName
} from "storybook/internal/common";
import { logger as logger4 } from "storybook/internal/node-logger";
import { getPrecedingUpgrade, telemetry as telemetry2 } from "storybook/internal/telemetry";
import { global as global2 } from "@storybook/global";
var import_picocolors4 = __toESM(require_picocolors(), 1);

// src/core-server/utils/StoryIndexGenerator.ts
import { existsSync } from "node:fs";
import { readFile } from "node:fs/promises";
import { dirname, extname, join as join2, normalize, relative as relative2, resolve as resolve2, sep } from "node:path";
import { commonGlobOptions, getProjectRoot, normalizeStoryPath } from "storybook/internal/common";
import { combineTags, storyNameFromExport, toId } from "storybook/internal/csf";
import { getStorySortParameter, loadConfig } from "storybook/internal/csf-tools";
import { logger, once } from "storybook/internal/node-logger";
import { isExampleStoryId } from "storybook/internal/telemetry";
var import_picocolors = __toESM(require_picocolors(), 1);
var import_ts_dedent2 = __toESM(require_dist(), 1);
var TsconfigPaths = __toESM(require_lib2(), 1);

// src/preview-api/modules/store/sortStories.ts
var import_ts_dedent = __toESM(require_dist(), 1);

// src/preview-api/modules/store/storySort.ts
var STORY_KIND_PATH_SEPARATOR = /\s*\/\s*/;
var storySort = /* @__PURE__ */ __name((options = {}) => (a, b) => {
  if (a.title === b.title && !options.includeNames) {
    return 0;
  }
  const method = options.method || "configure";
  let order = options.order || [];
  const storyTitleA = a.title.trim().split(STORY_KIND_PATH_SEPARATOR);
  const storyTitleB = b.title.trim().split(STORY_KIND_PATH_SEPARATOR);
  if (options.includeNames) {
    storyTitleA.push(a.name);
    storyTitleB.push(b.name);
  }
  let depth = 0;
  while (storyTitleA[depth] || storyTitleB[depth]) {
    if (!storyTitleA[depth]) {
      return -1;
    }
    if (!storyTitleB[depth]) {
      return 1;
    }
    const nameA = storyTitleA[depth];
    const nameB = storyTitleB[depth];
    if (nameA !== nameB) {
      let indexA = order.indexOf(nameA);
      let indexB = order.indexOf(nameB);
      const indexWildcard = order.indexOf("*");
      if (indexA !== -1 || indexB !== -1) {
        if (indexA === -1) {
          if (indexWildcard !== -1) {
            indexA = indexWildcard;
          } else {
            indexA = order.length;
          }
        }
        if (indexB === -1) {
          if (indexWildcard !== -1) {
            indexB = indexWildcard;
          } else {
            indexB = order.length;
          }
        }
        return indexA - indexB;
      }
      if (method === "configure") {
        return 0;
      }
      return nameA.localeCompare(nameB, options.locales ? options.locales : void 0, {
        numeric: true,
        sensitivity: "accent"
      });
    }
    let index = order.indexOf(nameA);
    if (index === -1) {
      index = order.indexOf("*");
    }
    order = index !== -1 && Array.isArray(order[index + 1]) ? order[index + 1] : [];
    depth += 1;
  }
  return 0;
}, "storySort");

// src/preview-api/modules/store/sortStories.ts
var sortStoriesCommon = /* @__PURE__ */ __name((stories, storySortParameter, fileNameOrder) => {
  if (storySortParameter) {
    let sortFn;
    if (typeof storySortParameter === "function") {
      sortFn = storySortParameter;
    } else {
      sortFn = storySort(storySortParameter);
    }
    stories.sort(sortFn);
  } else {
    stories.sort(
      (s1, s2) => fileNameOrder.indexOf(s1.importPath) - fileNameOrder.indexOf(s2.importPath)
    );
  }
  return stories;
}, "sortStoriesCommon");
var sortStoriesV7 = /* @__PURE__ */ __name((stories, storySortParameter, fileNameOrder) => {
  try {
    return sortStoriesCommon(stories, storySortParameter, fileNameOrder);
  } catch (err) {
    throw new Error(import_ts_dedent.dedent`
    Error sorting stories with sort parameter ${storySortParameter}:

    > ${err.message}

    Are you using a V6-style sort function in V7 mode?

    More info: https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#v7-style-story-sort
  `);
  }
}, "sortStoriesV7");

// src/core-server/utils/IndexingError.ts
var IndexingError = class extends Error {
  static {
    __name(this, "IndexingError");
  }
  constructor(message, importPaths, stack) {
    super();
    this.message = message;
    this.importPaths = importPaths;
    if (stack) {
      this.stack = stack;
    }
  }
  pathsString() {
    if (this.importPaths.length === 1) {
      return `${slash(this.importPaths[0])}`;
    }
    return `${this.importPaths.map(slash).join(",")}`;
  }
  toString() {
    return `${this.pathsString()}: ${this.message}`;
  }
};
var MultipleIndexingError = class extends Error {
  constructor(indexingErrors) {
    super();
    this.indexingErrors = indexingErrors;
    if (this.indexingErrors.length === 0) {
      throw new Error("Unexpected empty error list");
    }
    if (this.indexingErrors.length === 1) {
      const [err] = this.indexingErrors;
      this.message = `Unable to index ${err.pathsString()}`;
    } else {
      this.message = `Unable to index files:
${this.indexingErrors.map((err) => `- ${err}`).join("\n")}`;
    }
  }
  static {
    __name(this, "MultipleIndexingError");
  }
  toString() {
    if (this.indexingErrors.length === 1) {
      return `${this.message}:
  ${this.indexingErrors[0].stack}`;
    }
    return this.message;
  }
};

// src/core-server/utils/autoName.ts
import { basename } from "node:path";
function autoName(mdxImportPath, csfImportPath, defaultName) {
  const mdxBasename = basename(mdxImportPath);
  const csfBasename = basename(csfImportPath);
  const [mdxFilename] = mdxBasename.split(".");
  const [csfFilename] = csfBasename.split(".");
  if (mdxFilename === csfFilename) {
    return defaultName;
  }
  return mdxFilename;
}
__name(autoName, "autoName");

// src/core-server/utils/summarizeStats.ts
var addStats = /* @__PURE__ */ __name((stat, acc) => {
  Object.entries(stat).forEach(([key, value]) => {
    const statsKey = key;
    if (!acc[statsKey]) {
      acc[statsKey] = 0;
    }
    acc[statsKey] += value ? 1 : 0;
  });
}, "addStats");

// src/core-server/utils/StoryIndexGenerator.ts
var AUTODOCS_TAG = "autodocs";
var ATTACHED_MDX_TAG = "attached-mdx";
var UNATTACHED_MDX_TAG = "unattached-mdx";
var PLAY_FN_TAG = "play-fn";
var TEST_FN_TAG = "test-fn";
function isMdxEntry({ tags }) {
  return tags?.includes(UNATTACHED_MDX_TAG) || tags?.includes(ATTACHED_MDX_TAG);
}
__name(isMdxEntry, "isMdxEntry");
var makeAbsolute = /* @__PURE__ */ __name((otherImport, normalizedPath, workingDir) => otherImport.startsWith(".") ? slash(resolve2(workingDir, normalizeStoryPath(join2(dirname(normalizedPath), otherImport)))) : otherImport, "makeAbsolute");
var StoryIndexGenerator = class _StoryIndexGenerator {
  constructor(specifiers, options) {
    this.specifiers = specifiers;
    this.options = options;
    this.specifierToCache = /* @__PURE__ */ new Map();
  }
  static {
    __name(this, "StoryIndexGenerator");
  }
  static {
    /** Cache for findMatchingFiles results */
    this.findMatchingFilesCache = /* @__PURE__ */ new Map();
  }
  /** Generate a cache key for findMatchingFiles */
  static getFindMatchingFilesCacheKey(specifier, workingDir, ignoreWarnings) {
    return JSON.stringify({
      directory: specifier.directory,
      files: specifier.files,
      workingDir,
      ignoreWarnings
    });
  }
  /** Clear the findMatchingFiles cache */
  static clearFindMatchingFilesCache() {
    this.findMatchingFilesCache.clear();
  }
  static async findMatchingFiles(specifier, workingDir, ignoreWarnings = false) {
    const cacheKey = this.getFindMatchingFilesCacheKey(specifier, workingDir, ignoreWarnings);
    const cached = this.findMatchingFilesCache.get(cacheKey);
    if (cached) {
      return cached;
    }
    const pathToSubIndex = {};
    const fullGlob = slash(join2(specifier.directory, specifier.files));
    const { globby } = await import("../_node-chunks/globby-FODEQLAP.js");
    const files = await globby(fullGlob, {
      absolute: true,
      cwd: workingDir,
      ...commonGlobOptions(fullGlob)
    });
    if (files.length === 0 && !ignoreWarnings) {
      once.warn(
        `No story files found for the specified pattern: ${import_picocolors.default.blue(
          join2(specifier.directory, specifier.files)
        )}`
      );
    }
    files.sort().forEach((absolutePath) => {
      const ext = extname(absolutePath);
      if (ext === ".storyshot") {
        const relativePath = relative2(workingDir, absolutePath);
        logger.info(`Skipping ${ext} file ${relativePath}`);
        return;
      }
      pathToSubIndex[absolutePath] = false;
    });
    this.findMatchingFilesCache.set(cacheKey, pathToSubIndex);
    return pathToSubIndex;
  }
  static async findMatchingFilesForSpecifiers(specifiers, workingDir, ignoreWarnings = false) {
    return Promise.all(
      specifiers.map(async (specifier) => {
        const pathToSubIndex = await _StoryIndexGenerator.findMatchingFiles(
          specifier,
          workingDir,
          ignoreWarnings
        );
        return [specifier, pathToSubIndex];
      })
    );
  }
  async initialize() {
    const specifiersAndCaches = await _StoryIndexGenerator.findMatchingFilesForSpecifiers(
      this.specifiers,
      this.options.workingDir
    );
    specifiersAndCaches.forEach(
      ([specifier, cache2]) => this.specifierToCache.set(specifier, cache2)
    );
    const previewCode = await this.getPreviewCode();
    const projectTags = this.getProjectTags(previewCode);
    await this.ensureExtracted({ projectTags });
  }
  /** Run the updater function over all the empty cache entries */
  async updateExtracted(updater, overwrite = false) {
    await Promise.all(
      this.specifiers.map(async (specifier) => {
        const entry = this.specifierToCache.get(specifier);
        invariant(
          entry,
          `specifier does not have a matching cache entry in specifierToCache: ${JSON.stringify(
            specifier
          )}`
        );
        return Promise.all(
          Object.keys(entry).map(async (absolutePath) => {
            if (entry[absolutePath] && !overwrite) {
              return;
            }
            try {
              entry[absolutePath] = await updater(specifier, absolutePath, entry[absolutePath]);
            } catch (err) {
              const relativePath = `.${sep}${relative2(this.options.workingDir, absolutePath)}`;
              entry[absolutePath] = {
                type: "error",
                err: new IndexingError(
                  err instanceof Error ? err.message : String(err),
                  [relativePath],
                  err instanceof Error ? err.stack : void 0
                )
              };
            }
          })
        );
      })
    );
  }
  isDocsMdx(absolutePath) {
    return /(?<!\.stories)\.mdx$/i.test(absolutePath);
  }
  async ensureExtracted({
    projectTags
  }) {
    await this.updateExtracted(
      async (specifier, absolutePath) => this.isDocsMdx(absolutePath) ? false : this.extractStories(specifier, absolutePath, projectTags)
    );
    await this.updateExtracted(
      async (specifier, absolutePath) => this.extractDocs(specifier, absolutePath, projectTags)
    );
    const statsSummary = {};
    const entries = this.specifiers.flatMap((specifier) => {
      const cache2 = this.specifierToCache.get(specifier);
      invariant(
        cache2,
        `specifier does not have a matching cache entry in specifierToCache: ${JSON.stringify(
          specifier
        )}`
      );
      return Object.values(cache2).flatMap((entry) => {
        if (!entry) {
          return [];
        }
        if (entry.type === "docs") {
          return [entry];
        }
        if (entry.type === "error") {
          return [entry];
        }
        return entry.entries.map((item) => {
          if (item.type === "docs") {
            return item;
          }
          if (!isExampleStoryId(item.id)) {
            addStats(item.extra.stats, statsSummary);
          }
          const { extra, ...existing } = item;
          return existing;
        });
      });
    });
    return { entries, stats: statsSummary };
  }
  findDependencies(absoluteImports) {
    return [...this.specifierToCache.values()].flatMap(
      (cache2) => Object.entries(cache2).filter(([fileName, cacheEntry]) => {
        if (!cacheEntry || cacheEntry.type !== "stories") {
          return false;
        }
        return !!absoluteImports.find(
          (storyImport) => fileName.match(
            new RegExp(`^${storyImport.replace(/[.*+?^${}()|[\]\\]/g, "\\$&")}(\\.[^.]+)?$`)
          )
        );
      }).map(([_, cacheEntry]) => cacheEntry)
    );
  }
  /**
   * Try to find the component path from a raw import string and return it in the same format as
   * `importPath`. Respect tsconfig paths if available.
   *
   * If no such file exists, assume that the import is from a package and return the raw
   */
  resolveComponentPath(rawComponentPath, absolutePath, matchPath) {
    let rawPath = rawComponentPath;
    if (matchPath) {
      rawPath = matchPath(rawPath) ?? rawPath;
    }
    const absoluteComponentPath = resolve2(dirname(absolutePath), rawPath);
    const existing = ["", ".js", ".ts", ".jsx", ".tsx", ".mjs", ".mts"].map((ext) => `${absoluteComponentPath}${ext}`).find((candidate) => existsSync(candidate));
    if (existing) {
      const relativePath = relative2(this.options.workingDir, existing);
      return slash(normalizeStoryPath(relativePath));
    }
    return rawComponentPath;
  }
  async extractStories(specifier, absolutePath, projectTags = []) {
    const relativePath = relative2(this.options.workingDir, absolutePath);
    const importPath = slash(normalizeStoryPath(relativePath));
    const defaultMakeTitle = /* @__PURE__ */ __name((userTitle) => {
      const title = userOrAutoTitleFromSpecifier(importPath, specifier, userTitle);
      invariant(
        title,
        "makeTitle created an undefined title. This happens when the fileName doesn't match any specifier from main.js"
      );
      return title;
    }, "defaultMakeTitle");
    const indexer = this.options.indexers.find((ind) => ind.test.exec(absolutePath));
    invariant(indexer, `No matching indexer found for ${absolutePath}`);
    const indexInputs = await indexer.createIndex(absolutePath, {
      makeTitle: defaultMakeTitle
    });
    const tsconfigPath = up("tsconfig.json", {
      cwd: this.options.workingDir,
      last: getProjectRoot()
    });
    const tsconfig = TsconfigPaths.loadConfig(tsconfigPath);
    let matchPath;
    if (tsconfig.resultType === "success") {
      matchPath = TsconfigPaths.createMatchPath(tsconfig.absoluteBaseUrl, tsconfig.paths, [
        "browser",
        "module",
        "main"
      ]);
    }
    const storyEntries = indexInputs.map(
      (input) => {
        const name = input.name ?? storyNameFromExport(input.exportName);
        const componentPath = input.rawComponentPath && this.resolveComponentPath(input.rawComponentPath, absolutePath, matchPath);
        const title = input.title ?? defaultMakeTitle();
        const id = input.__id ?? toId(input.metaId ?? title, storyNameFromExport(input.exportName));
        const tags = combineTags(...projectTags, ...input.tags ?? []);
        const subtype = input.subtype ?? "story";
        const entry = {
          type: "story",
          subtype,
          id,
          extra: {
            metaId: input.metaId,
            stats: input.__stats ?? {}
          },
          name,
          title,
          importPath,
          componentPath,
          tags
        };
        if (subtype === "test") {
          entry.parent = input.parent;
          entry.parentName = input.parentName;
        }
        if (input.exportName) {
          entry.exportName = input.exportName;
        }
        return entry;
      }
    );
    const hasAutodocsTag = storyEntries.some((entry) => entry.tags.includes(AUTODOCS_TAG));
    const createDocEntry = hasAutodocsTag && !!this.options.docs;
    if (createDocEntry && this.options.build?.test?.disableAutoDocs !== true) {
      const docsName = this.options.docs?.defaultName ?? "Docs";
      const name = docsName;
      const { metaId } = indexInputs[0];
      const { title } = storyEntries[0];
      const id = toId(metaId ?? title, name);
      const tags = combineTags(...projectTags, ...indexInputs[0].tags ?? []);
      const docsEntry = {
        id,
        title,
        name,
        importPath,
        type: "docs",
        tags,
        storiesImports: []
      };
      return {
        entries: [docsEntry, ...storyEntries],
        dependents: [],
        type: "stories"
      };
    }
    return {
      entries: storyEntries,
      dependents: [],
      type: "stories"
    };
  }
  async extractDocs(specifier, absolutePath, projectTags = []) {
    const relativePath = relative2(this.options.workingDir, absolutePath);
    try {
      const normalizedPath = normalizeStoryPath(relativePath);
      const importPath = slash(normalizedPath);
      const content = await readFile(absolutePath, { encoding: "utf8" });
      const { analyze } = await import("../_node-chunks/dist-SD7YZH5A.js");
      const result = await analyze(content);
      if (result.isTemplate) {
        return false;
      }
      const absoluteImports = result.imports.map(
        (p) => makeAbsolute(p, normalizedPath, this.options.workingDir)
      );
      const dependencies = this.findDependencies(absoluteImports);
      let sortedDependencies = dependencies;
      let csfEntry;
      if (result.of) {
        const absoluteOf = makeAbsolute(result.of, normalizedPath, this.options.workingDir);
        dependencies.forEach((dep) => {
          if (dep.entries.length > 0) {
            const first = dep.entries.find((e) => e.type !== "docs");
            if (normalize(resolve2(this.options.workingDir, first.importPath)).startsWith(
              normalize(absoluteOf)
            )) {
              csfEntry = first;
            }
          }
          sortedDependencies = [dep, ...dependencies.filter((d) => d !== dep)];
        });
        invariant(
          csfEntry,
          import_ts_dedent2.dedent`
            Could not find or load CSF file at path "${result.of}" referenced by \`of={}\` in docs file "${relativePath}".

            - Does that file exist?
            - If so, is it a CSF file (\`.stories.*\`)?
            - If so, is it matched by the \`stories\` glob in \`main.js\`?
            - If so, has the file successfully loaded in Storybook and are its stories visible?
          `
        );
      }
      dependencies.forEach((dep) => {
        dep.dependents.push(absolutePath);
      });
      const title = csfEntry?.title || userOrAutoTitleFromSpecifier(importPath, specifier, result.title);
      invariant(
        title,
        "makeTitle created an undefined title. This happens when a specifier's doesn't have any matches in its fileName"
      );
      const defaultName = this.options.docs?.defaultName ?? "Docs";
      const name = result.name || (csfEntry ? autoName(importPath, csfEntry.importPath, defaultName) : defaultName);
      const id = toId(csfEntry?.extra.metaId || title, name);
      const tags = combineTags(
        ...projectTags,
        ...csfEntry?.tags ?? [],
        ...result.metaTags ?? [],
        csfEntry ? "attached-mdx" : "unattached-mdx"
      );
      const docsEntry = {
        id,
        title,
        name,
        importPath,
        storiesImports: sortedDependencies.map((dep) => dep.entries[0].importPath),
        type: "docs",
        tags
      };
      return docsEntry;
    } catch (err) {
      if (err && err.source?.match(/mdast-util-mdx-jsx/g)) {
        logger.warn(
          `\u{1F4A1} This seems to be an MDX2 syntax error. Please refer to the MDX section in the following resource for assistance on how to fix this: ${import_picocolors.default.yellow(
            "https://storybook.js.org/docs/7/migration-guide?ref=error"
          )}`
        );
      }
      throw err;
    }
  }
  chooseDuplicate(firstEntry, secondEntry, projectTags) {
    if (firstEntry.importPath === secondEntry.importPath) {
      return firstEntry;
    }
    let firstIsBetter = true;
    if (secondEntry.type === "story") {
      firstIsBetter = false;
    } else if (isMdxEntry(secondEntry) && firstEntry.type === "docs" && !isMdxEntry(firstEntry)) {
      firstIsBetter = false;
    }
    const betterEntry = firstIsBetter ? firstEntry : secondEntry;
    const worseEntry = firstIsBetter ? secondEntry : firstEntry;
    const changeDocsName = 'Use `<Meta of={} name="Other Name">` to distinguish them.';
    if (worseEntry.type === "story") {
      throw new IndexingError(`Duplicate stories with id: ${firstEntry.id}`, [
        firstEntry.importPath,
        secondEntry.importPath
      ]);
    }
    if (betterEntry.type === "story") {
      const worseDescriptor = isMdxEntry(worseEntry) ? `component docs page` : `automatically generated docs page`;
      const docsName = this.options.docs?.defaultName ?? "Docs";
      if (betterEntry.name === docsName) {
        throw new IndexingError(
          `You have a story for ${betterEntry.title} with the same name as your default docs entry name (${betterEntry.name}), so the docs page is being dropped. Consider changing the story name.`,
          [firstEntry.importPath, secondEntry.importPath]
        );
      } else {
        throw new IndexingError(
          `You have a story for ${betterEntry.title} with the same name as your ${worseDescriptor} (${worseEntry.name}), so the docs page is being dropped. ${changeDocsName}`,
          [firstEntry.importPath, secondEntry.importPath]
        );
      }
    } else if (isMdxEntry(betterEntry)) {
      if (isMdxEntry(worseEntry)) {
        throw new IndexingError(
          `You have two component docs pages with the same name ${betterEntry.title}:${betterEntry.name}. ${changeDocsName}`,
          [firstEntry.importPath, secondEntry.importPath]
        );
      }
      if (worseEntry.tags?.includes(AUTODOCS_TAG) && !projectTags?.includes(AUTODOCS_TAG)) {
        throw new IndexingError(
          `You created a component docs page for '${worseEntry.title}', but also tagged the CSF file with '${AUTODOCS_TAG}'. This is probably a mistake.`,
          [betterEntry.importPath, worseEntry.importPath]
        );
      }
    } else {
      return {
        ...betterEntry,
        storiesImports: [
          ...betterEntry.storiesImports,
          worseEntry.importPath,
          ...worseEntry.storiesImports
        ]
      };
    }
    return betterEntry;
  }
  async sortStories(entries, storySortParameter) {
    const sortableStories = Object.values(entries);
    const fileNameOrder = _StoryIndexGenerator.storyFileNames(this.specifierToCache);
    sortStoriesV7(sortableStories, storySortParameter, fileNameOrder);
    return sortableStories.reduce(
      (acc, item) => {
        acc[item.id] = item;
        return acc;
      },
      {}
    );
  }
  async getIndex() {
    return (await this.getIndexAndStats()).storyIndex;
  }
  async getIndexAndStats() {
    if (this.lastIndex && this.lastStats) {
      return { storyIndex: this.lastIndex, stats: this.lastStats };
    }
    if (this.lastError) {
      throw this.lastError;
    }
    const previewCode = await this.getPreviewCode();
    const projectTags = this.getProjectTags(previewCode);
    const { entries: storiesList, stats } = await this.ensureExtracted({ projectTags });
    try {
      const errorEntries = storiesList.filter((entry) => entry.type === "error");
      if (errorEntries.length) {
        throw new MultipleIndexingError(errorEntries.map((entry) => entry.err));
      }
      const duplicateErrors = [];
      const indexEntries = {};
      storiesList.forEach((entry) => {
        try {
          const existing = indexEntries[entry.id];
          if (existing) {
            indexEntries[entry.id] = this.chooseDuplicate(existing, entry, projectTags);
          } else {
            indexEntries[entry.id] = entry;
          }
        } catch (err) {
          if (err instanceof IndexingError) {
            duplicateErrors.push(err);
          }
        }
      });
      if (duplicateErrors.length) {
        throw new MultipleIndexingError(duplicateErrors);
      }
      const sorted = await this.sortStories(
        indexEntries,
        previewCode && getStorySortParameter(previewCode)
      );
      this.lastStats = stats;
      this.lastIndex = {
        v: 5,
        entries: sorted
      };
      return { storyIndex: this.lastIndex, stats: this.lastStats };
    } catch (err) {
      this.lastError = err == null || err instanceof Error ? err : void 0;
      invariant(this.lastError);
      logger.warn(`\u{1F6A8} ${this.lastError.toString()}`);
      throw this.lastError;
    }
  }
  invalidateAll() {
    this.specifierToCache.forEach((cache2) => {
      Object.keys(cache2).forEach((key) => {
        cache2[key] = false;
      });
    });
    this.lastIndex = null;
    this.lastError = null;
  }
  invalidate(specifier, importPath, removed) {
    const absolutePath = slash(resolve2(this.options.workingDir, importPath));
    const cache2 = this.specifierToCache.get(specifier);
    invariant(
      cache2,
      `specifier does not have a matching cache entry in specifierToCache: ${JSON.stringify(
        specifier
      )}`
    );
    const cacheEntry = cache2[absolutePath];
    if (cacheEntry && cacheEntry.type === "stories") {
      const { dependents } = cacheEntry;
      const invalidated = /* @__PURE__ */ new Set();
      this.specifierToCache.forEach((otherCache) => {
        dependents.forEach((dep) => {
          if (otherCache[dep]) {
            invalidated.add(dep);
            otherCache[dep] = false;
          }
        });
      });
    }
    if (removed) {
      if (cacheEntry && cacheEntry.type === "docs") {
        const absoluteImports = cacheEntry.storiesImports.map(
          (p) => resolve2(this.options.workingDir, p)
        );
        const dependencies = this.findDependencies(absoluteImports);
        dependencies.forEach(
          (dep) => dep.dependents.splice(dep.dependents.indexOf(absolutePath), 1)
        );
      }
      delete cache2[absolutePath];
    } else {
      cache2[absolutePath] = false;
    }
    this.lastIndex = null;
    this.lastError = null;
  }
  async getPreviewCode() {
    const previewFile = ["js", "jsx", "ts", "tsx", "mjs", "cjs", "mts"].map((ext) => join2(this.options.configDir, `preview.${ext}`)).find((fname) => existsSync(fname));
    return previewFile && (await readFile(previewFile, { encoding: "utf8" })).toString();
  }
  getProjectTags(previewCode) {
    let projectTags = [];
    const defaultTags = ["dev", "test"];
    if (previewCode) {
      try {
        const projectAnnotations = loadConfig(previewCode).parse();
        projectTags = projectAnnotations.getFieldValue(["tags"]) ?? [];
      } catch (err) {
        once.warn(import_ts_dedent2.dedent`
          Unable to parse tags from project configuration. If defined, tags should be specified inline, e.g.

          export default {
            tags: ['foo'],
          }

          ---

          Received:

          ${previewCode}
        `);
      }
    }
    return [...defaultTags, ...projectTags];
  }
  // Get the story file names in "imported order"
  static storyFileNames(specifierToCache) {
    return Array.from(specifierToCache.values()).flatMap((r) => Object.keys(r));
  }
};

// src/core-server/utils/build-or-throw.ts
import { NoMatchingExportError } from "storybook/internal/server-errors";
async function buildOrThrow(callback) {
  try {
    return await callback();
  } catch (err) {
    const builderErrors = err.errors;
    if (builderErrors) {
      const inconsistentVersionsError = builderErrors.find(
        (er) => er.text?.includes("No matching export")
      );
      if (inconsistentVersionsError) {
        throw new NoMatchingExportError(err);
      }
    }
    throw err;
  }
}
__name(buildOrThrow, "buildOrThrow");

// src/core-server/utils/copy-all-static-files.ts
var import_picocolors2 = __toESM(require_picocolors(), 1);
import { cp } from "node:fs/promises";
import { join as join3, relative as relative3 } from "node:path";
import { getDirectoryFromWorkingDir } from "storybook/internal/common";
import { logger as logger2 } from "storybook/internal/node-logger";
async function copyAllStaticFilesRelativeToMain(staticDirs, outputDir, configDir) {
  const workingDir = process.cwd();
  return staticDirs?.reduce(async (acc, dir) => {
    await acc;
    const staticDirAndTarget = typeof dir === "string" ? dir : `${dir.from}:${dir.to}`;
    const { staticPath: from, targetEndpoint: to } = parseStaticDir(
      getDirectoryFromWorkingDir({
        configDir,
        workingDir,
        directory: staticDirAndTarget
      })
    );
    const targetPath = join3(outputDir, to);
    const skipPaths = ["index.html", "iframe.html"].map((f) => join3(outputDir, f));
    if (!from.includes("node_modules")) {
      logger2.info(
        `=> Copying static files: ${import_picocolors2.default.cyan(print(from))} at ${import_picocolors2.default.cyan(print(targetPath))}`
      );
    }
    await cp(from, targetPath, {
      dereference: true,
      preserveTimestamps: true,
      filter: /* @__PURE__ */ __name((_, dest) => !skipPaths.includes(dest), "filter"),
      recursive: true
    });
  }, Promise.resolve());
}
__name(copyAllStaticFilesRelativeToMain, "copyAllStaticFilesRelativeToMain");
function print(p) {
  return relative3(process.cwd(), p);
}
__name(print, "print");

// src/core-server/utils/get-builders.ts
import { MissingBuilderError } from "storybook/internal/server-errors";
async function getManagerBuilder() {
  return await import("../_node-chunks/builder-manager-32BKVJNY.js");
}
__name(getManagerBuilder, "getManagerBuilder");
async function getPreviewBuilder(resolvedPreviewBuilder) {
  return await importModule(resolvedPreviewBuilder);
}
__name(getPreviewBuilder, "getPreviewBuilder");
async function getBuilders({ presets }) {
  const { builder } = await presets.apply("core", {});
  if (!builder) {
    throw new MissingBuilderError();
  }
  const resolvedPreviewBuilder = typeof builder === "string" ? builder : builder.name;
  return Promise.all([getPreviewBuilder(resolvedPreviewBuilder), getManagerBuilder()]);
}
__name(getBuilders, "getBuilders");

// src/core-server/utils/metadata.ts
import { writeFile } from "node:fs/promises";
import { getStorybookMetadata } from "storybook/internal/telemetry";
async function extractStorybookMetadata(outputFile, configDir) {
  const storybookMetadata = await getStorybookMetadata(configDir);
  await writeFile(outputFile, JSON.stringify(storybookMetadata));
}
__name(extractStorybookMetadata, "extractStorybookMetadata");
function useStorybookMetadata(app, configDir) {
  app.use("/project.json", async (req, res) => {
    const storybookMetadata = await getStorybookMetadata(configDir);
    res.setHeader("Content-Type", "application/json");
    res.write(JSON.stringify(storybookMetadata));
    res.end();
  });
}
__name(useStorybookMetadata, "useStorybookMetadata");

// src/core-server/utils/output-stats.ts
var import_json_ext = __toESM(require_src2(), 1);
var import_picocolors3 = __toESM(require_picocolors(), 1);
import { createWriteStream } from "node:fs";
import { join as join4 } from "node:path";
import { logger as logger3 } from "storybook/internal/node-logger";
async function outputStats(directory, previewStats, managerStats) {
  if (previewStats) {
    const filePath = await writeStats(directory, "preview", previewStats);
    logger3.info(`=> preview stats written to ${import_picocolors3.default.cyan(filePath)}`);
  }
  if (managerStats) {
    const filePath = await writeStats(directory, "manager", managerStats);
    logger3.info(`=> manager stats written to ${import_picocolors3.default.cyan(filePath)}`);
  }
}
__name(outputStats, "outputStats");
var writeStats = /* @__PURE__ */ __name(async (directory, name, stats) => {
  const filePath = join4(directory, `${name}-stats.json`);
  const { chunks, ...data } = stats.toJson();
  await new Promise((resolve4, reject) => {
    (0, import_json_ext.stringifyStream)(data, null, 2).on("error", reject).pipe(createWriteStream(filePath)).on("error", reject).on("finish", resolve4);
  });
  return filePath;
}, "writeStats");

// src/core-server/utils/stories-json.ts
import { writeFile as writeFile2 } from "node:fs/promises";
import { basename as basename3 } from "node:path";
import { STORY_INDEX_INVALIDATED } from "storybook/internal/core-events";

// ../node_modules/es-toolkit/dist/function/debounce.mjs
function debounce(func, debounceMs, { signal, edges } = {}) {
  let pendingThis = void 0;
  let pendingArgs = null;
  const leading = edges != null && edges.includes("leading");
  const trailing = edges == null || edges.includes("trailing");
  const invoke = /* @__PURE__ */ __name(() => {
    if (pendingArgs !== null) {
      func.apply(pendingThis, pendingArgs);
      pendingThis = void 0;
      pendingArgs = null;
    }
  }, "invoke");
  const onTimerEnd = /* @__PURE__ */ __name(() => {
    if (trailing) {
      invoke();
    }
    cancel();
  }, "onTimerEnd");
  let timeoutId = null;
  const schedule = /* @__PURE__ */ __name(() => {
    if (timeoutId != null) {
      clearTimeout(timeoutId);
    }
    timeoutId = setTimeout(() => {
      timeoutId = null;
      onTimerEnd();
    }, debounceMs);
  }, "schedule");
  const cancelTimer = /* @__PURE__ */ __name(() => {
    if (timeoutId !== null) {
      clearTimeout(timeoutId);
      timeoutId = null;
    }
  }, "cancelTimer");
  const cancel = /* @__PURE__ */ __name(() => {
    cancelTimer();
    pendingThis = void 0;
    pendingArgs = null;
  }, "cancel");
  const flush = /* @__PURE__ */ __name(() => {
    invoke();
  }, "flush");
  const debounced = /* @__PURE__ */ __name(function(...args) {
    if (signal?.aborted) {
      return;
    }
    pendingThis = this;
    pendingArgs = args;
    const isFirstCall = timeoutId == null;
    schedule();
    if (leading && isFirstCall) {
      invoke();
    }
  }, "debounced");
  debounced.schedule = schedule;
  debounced.cancel = cancel;
  debounced.flush = flush;
  signal?.addEventListener("abort", cancel, { once: true });
  return debounced;
}
__name(debounce, "debounce");

// ../node_modules/es-toolkit/dist/function/partial.mjs
function partial(func, ...partialArgs) {
  return partialImpl(func, placeholderSymbol, ...partialArgs);
}
__name(partial, "partial");
function partialImpl(func, placeholder, ...partialArgs) {
  const partialed = /* @__PURE__ */ __name(function(...providedArgs) {
    let providedArgsIndex = 0;
    const substitutedArgs = partialArgs.slice().map((arg) => arg === placeholder ? providedArgs[providedArgsIndex++] : arg);
    const remainingArgs = providedArgs.slice(providedArgsIndex);
    return func.apply(this, substitutedArgs.concat(remainingArgs));
  }, "partialed");
  if (func.prototype) {
    partialed.prototype = Object.create(func.prototype);
  }
  return partialed;
}
__name(partialImpl, "partialImpl");
var placeholderSymbol = Symbol("partial.placeholder");
partial.placeholder = placeholderSymbol;

// ../node_modules/es-toolkit/dist/function/partialRight.mjs
function partialRight(func, ...partialArgs) {
  return partialRightImpl(func, placeholderSymbol2, ...partialArgs);
}
__name(partialRight, "partialRight");
function partialRightImpl(func, placeholder, ...partialArgs) {
  const partialedRight = /* @__PURE__ */ __name(function(...providedArgs) {
    const placeholderLength = partialArgs.filter((arg) => arg === placeholder).length;
    const rangeLength = Math.max(providedArgs.length - placeholderLength, 0);
    const remainingArgs = providedArgs.slice(0, rangeLength);
    let providedArgsIndex = rangeLength;
    const substitutedArgs = partialArgs.slice().map((arg) => arg === placeholder ? providedArgs[providedArgsIndex++] : arg);
    return func.apply(this, remainingArgs.concat(substitutedArgs));
  }, "partialedRight");
  if (func.prototype) {
    partialedRight.prototype = Object.create(func.prototype);
  }
  return partialedRight;
}
__name(partialRightImpl, "partialRightImpl");
var placeholderSymbol2 = Symbol("partialRight.placeholder");
partialRight.placeholder = placeholderSymbol2;

// ../node_modules/es-toolkit/dist/function/retry.mjs
var DEFAULT_RETRIES = Number.POSITIVE_INFINITY;

// src/core-server/utils/watch-story-specifiers.ts
import { lstatSync, readdirSync } from "node:fs";
import { basename as basename2, join as join5, relative as relative4, resolve as resolve3 } from "node:path";
import { commonGlobOptions as commonGlobOptions2 } from "storybook/internal/common";
var import_watchpack = __toESM(require_watchpack(), 1);
var isDirectory = /* @__PURE__ */ __name((directory) => {
  try {
    return lstatSync(directory).isDirectory();
  } catch (err) {
    return false;
  }
}, "isDirectory");
function getNestedFilesAndDirectories(directories) {
  const traversedDirectories = /* @__PURE__ */ new Set();
  const files = /* @__PURE__ */ new Set();
  const traverse = /* @__PURE__ */ __name((directory) => {
    if (traversedDirectories.has(directory)) {
      return;
    }
    readdirSync(directory, { withFileTypes: true }).forEach((ent) => {
      if (ent.isDirectory()) {
        traverse(join5(directory, ent.name));
      } else if (ent.isFile()) {
        files.add(join5(directory, ent.name));
      }
    });
    traversedDirectories.add(directory);
  }, "traverse");
  directories.filter(isDirectory).forEach(traverse);
  return { files: Array.from(files), directories: Array.from(traversedDirectories) };
}
__name(getNestedFilesAndDirectories, "getNestedFilesAndDirectories");
function watchStorySpecifiers(specifiers, options, onInvalidate) {
  const { files, directories } = getNestedFilesAndDirectories(
    specifiers.map((ns) => resolve3(options.workingDir, ns.directory))
  );
  const wp = new import_watchpack.default({
    // poll: true, // Slow!!! Enable only in special cases
    followSymlinks: false,
    ignored: ["**/.git", "**/node_modules"]
  });
  wp.watch({ files, directories });
  const toImportPath = /* @__PURE__ */ __name((absolutePath) => {
    const relativePath = relative4(options.workingDir, absolutePath);
    return slash(relativePath.startsWith(".") ? relativePath : `./${relativePath}`);
  }, "toImportPath");
  async function onChangeOrRemove(absolutePath, removed) {
    const importPath = toImportPath(absolutePath);
    const matchingSpecifier = specifiers.find((ns) => ns.importPathMatcher.exec(importPath));
    if (matchingSpecifier) {
      onInvalidate(matchingSpecifier, importPath, removed);
      return;
    }
    if (!removed && isDirectory(absolutePath)) {
      await Promise.all(
        specifiers.filter((specifier) => importPath.startsWith(specifier.directory)).map(async (specifier) => {
          const dirGlob = join5(
            absolutePath,
            "**",
            // files can be e.g. '**/foo/*/*.js' so we just want the last bit,
            // because the directory could already be within the files part (e.g. './x/foo/bar')
            basename2(specifier.files)
          );
          const { globby } = await import("../_node-chunks/globby-FODEQLAP.js");
          const addedFiles = await globby(slash(dirGlob), commonGlobOptions2(dirGlob));
          addedFiles.forEach((filePath) => {
            const fileImportPath = toImportPath(filePath);
            if (specifier.importPathMatcher.exec(fileImportPath)) {
              onInvalidate(specifier, fileImportPath, removed);
            }
          });
        })
      );
    }
  }
  __name(onChangeOrRemove, "onChangeOrRemove");
  wp.on("change", async (filePath, mtime, explanation) => {
    const removed = !mtime;
    await onChangeOrRemove(filePath, removed);
  });
  wp.on("remove", async (filePath, explanation) => {
    await onChangeOrRemove(filePath, true);
  });
  return () => wp.close();
}
__name(watchStorySpecifiers, "watchStorySpecifiers");

// src/core-server/utils/watchConfig.ts
var import_watchpack2 = __toESM(require_watchpack(), 1);
function watchConfig(configDir, onInvalidate) {
  const wp = new import_watchpack2.default({
    followSymlinks: false,
    ignored: ["**/.git", "**/node_modules"]
  });
  wp.watch({
    directories: [configDir]
  });
  wp.on("change", async (filePath, mtime, explanation) => {
    const removed = !mtime;
    await onInvalidate(filePath, removed);
  });
  wp.on("remove", async (filePath, explanation) => {
    await onInvalidate(filePath, true);
  });
  return () => wp.close();
}
__name(watchConfig, "watchConfig");

// src/core-server/utils/stories-json.ts
var DEBOUNCE = 100;
async function extractStoriesJson(outputFile, initializedStoryIndexGenerator, transform) {
  const generator = await initializedStoryIndexGenerator;
  const storyIndex = await generator.getIndex();
  await writeFile2(outputFile, JSON.stringify(transform ? transform(storyIndex) : storyIndex));
}
__name(extractStoriesJson, "extractStoriesJson");
function useStoriesJson({
  app,
  initializedStoryIndexGenerator,
  workingDir = process.cwd(),
  configDir,
  serverChannel,
  normalizedStories
}) {
  const maybeInvalidate = debounce(() => serverChannel.emit(STORY_INDEX_INVALIDATED), DEBOUNCE, {
    edges: ["leading", "trailing"]
  });
  watchStorySpecifiers(normalizedStories, { workingDir }, async (specifier, path2, removed) => {
    const generator = await initializedStoryIndexGenerator;
    generator.invalidate(specifier, path2, removed);
    maybeInvalidate();
  });
  if (configDir) {
    watchConfig(configDir, async (filePath) => {
      if (basename3(filePath).startsWith("preview")) {
        const generator = await initializedStoryIndexGenerator;
        generator.invalidateAll();
        maybeInvalidate();
      }
    });
  }
  app.use("/index.json", async (req, res) => {
    try {
      const generator = await initializedStoryIndexGenerator;
      const index = await generator.getIndex();
      res.setHeader("Content-Type", "application/json");
      res.end(JSON.stringify(index));
    } catch (err) {
      res.statusCode = 500;
      res.end(err instanceof Error ? err.toString() : String(err));
    }
  });
}
__name(useStoriesJson, "useStoriesJson");

// src/core-server/utils/summarizeIndex.ts
import { isExampleStoryId as isExampleStoryId2 } from "storybook/internal/telemetry";
var PAGE_REGEX = /(page|screen)/i;
var isPageStory = /* @__PURE__ */ __name((storyId) => PAGE_REGEX.test(storyId), "isPageStory");
var isCLIExampleEntry = /* @__PURE__ */ __name((entry) => [
  "example-introduction--docs",
  "configure-your-project--docs",
  "example-button--docs",
  "example-button--primary",
  "example-button--secondary",
  "example-button--large",
  "example-button--small",
  "example-header--docs",
  "example-header--logged-in",
  "example-header--logged-out",
  "example-page--logged-in",
  "example-page--logged-out"
].includes(entry.id), "isCLIExampleEntry");
function summarizeIndex(storyIndex) {
  let storyCount = 0;
  const componentTitles = /* @__PURE__ */ new Set();
  let exampleStoryCount = 0;
  let onboardingStoryCount = 0;
  let onboardingDocsCount = 0;
  let exampleDocsCount = 0;
  let pageStoryCount = 0;
  let playStoryCount = 0;
  let testStoryCount = 0;
  let autodocsCount = 0;
  let mdxCount = 0;
  let svelteCsfV4Count = 0;
  let svelteCsfV5Count = 0;
  const testsPerParentStory = /* @__PURE__ */ new Map();
  Object.values(storyIndex.entries).forEach((entry) => {
    if (isCLIExampleEntry(entry)) {
      if (entry.type === "story") {
        exampleStoryCount += 1;
      }
      if (entry.type === "docs") {
        exampleDocsCount += 1;
      }
    } else if (isExampleStoryId2(entry.id)) {
      if (entry.type === "story") {
        onboardingStoryCount += 1;
      }
      if (entry.type === "docs") {
        onboardingDocsCount += 1;
      }
    } else if (entry.type === "story") {
      storyCount += 1;
      componentTitles.add(entry.title);
      if (isPageStory(entry.title)) {
        pageStoryCount += 1;
      }
      if (entry.tags?.includes(PLAY_FN_TAG)) {
        playStoryCount += 1;
      }
      if (entry.tags?.includes(TEST_FN_TAG) && entry.parent) {
        testStoryCount += 1;
        testsPerParentStory.set(entry.parent, (testsPerParentStory.get(entry.parent) ?? 0) + 1);
      }
      if (entry.tags?.includes("svelte-csf-v4")) {
        svelteCsfV4Count += 1;
      } else if (entry.tags?.includes("svelte-csf-v5")) {
        svelteCsfV5Count += 1;
      }
    } else if (entry.type === "docs") {
      if (isMdxEntry(entry)) {
        mdxCount += 1;
      } else if (entry.tags?.includes(AUTODOCS_TAG)) {
        autodocsCount += 1;
      }
    }
  });
  const componentCount = componentTitles.size;
  let maxTestsPerStory = 0;
  let singleTestStoryCount = 0;
  testsPerParentStory.forEach((count) => {
    if (count > maxTestsPerStory) {
      maxTestsPerStory = count;
    }
    if (count === 1) {
      singleTestStoryCount += 1;
    }
  });
  return {
    storyCount,
    componentCount,
    pageStoryCount,
    playStoryCount,
    testStoryCount,
    maxTestsPerStory,
    singleTestStoryCount,
    autodocsCount,
    mdxCount,
    exampleStoryCount,
    exampleDocsCount,
    onboardingStoryCount,
    onboardingDocsCount,
    svelteCsfV4Count,
    svelteCsfV5Count,
    version: storyIndex.v
  };
}
__name(summarizeIndex, "summarizeIndex");

// src/core-server/build-static.ts
async function buildStaticStandalone(options) {
  options.configType = "PRODUCTION";
  if (options.outputDir === "") {
    throw new Error("Won't remove current directory. Check your outputDir!");
  }
  options.outputDir = resolve(options.outputDir);
  options.configDir = resolve(options.configDir);
  logger4.info(
    `=> Cleaning outputDir: ${import_picocolors4.default.cyan(relative(process.cwd(), options.outputDir))}`
  );
  if (options.outputDir === "/") {
    throw new Error("Won't remove directory '/'. Check your outputDir!");
  }
  await rm(options.outputDir, { recursive: true, force: true }).catch(() => {
  });
  await mkdir(options.outputDir, { recursive: true });
  const config = await loadMainConfig(options);
  const { framework } = config;
  const corePresets = [];
  const frameworkName = typeof framework === "string" ? framework : framework?.name;
  if (frameworkName) {
    corePresets.push(join(frameworkName, "preset"));
  } else if (!options.ignorePreview) {
    logger4.warn(`you have not specified a framework in your ${options.configDir}/main.js`);
  }
  const commonPreset = join(
    resolvePackageDir("storybook"),
    "dist/core-server/presets/common-preset.js"
  );
  const commonOverridePreset = import.meta.resolve(
    "storybook/internal/core-server/presets/common-override-preset"
  );
  logger4.info("=> Loading presets");
  let presets = await loadAllPresets({
    corePresets: [commonPreset, ...corePresets],
    overridePresets: [commonOverridePreset],
    isCritical: true,
    ...options
  });
  const { renderer } = await presets.apply("core", {});
  const build2 = await presets.apply("build", {});
  const [previewBuilder, managerBuilder] = await getBuilders({ ...options, presets, build: build2 });
  const resolvedRenderer = renderer ? resolveAddonName(options.configDir, renderer, options) : void 0;
  presets = await loadAllPresets({
    corePresets: [
      commonPreset,
      ...managerBuilder.corePresets || [],
      ...previewBuilder.corePresets || [],
      ...resolvedRenderer ? [resolvedRenderer] : [],
      ...corePresets
    ],
    overridePresets: [...previewBuilder.overridePresets || [], commonOverridePreset],
    ...options,
    build: build2
  });
  const [features, core2, staticDirs, indexers, stories, docsOptions] = await Promise.all([
    presets.apply("features"),
    presets.apply("core"),
    presets.apply("staticDirs"),
    presets.apply("experimental_indexers", []),
    presets.apply("stories"),
    presets.apply("docs")
  ]);
  const invokedBy = process.env.STORYBOOK_INVOKED_BY;
  if (!core2?.disableTelemetry && invokedBy) {
    telemetry2("test-run", { runner: invokedBy, watch: false }, { configDir: options.configDir });
  }
  const fullOptions = {
    ...options,
    presets,
    features,
    build: build2
  };
  const effects = [];
  global2.FEATURES = features;
  if (!options.previewOnly) {
    await buildOrThrow(
      async () => managerBuilder.build({ startTime: process.hrtime(), options: fullOptions })
    );
  }
  if (staticDirs) {
    effects.push(
      copyAllStaticFilesRelativeToMain(staticDirs, options.outputDir, options.configDir)
    );
  }
  const coreServerPublicDir = join(resolvePackageDir("storybook"), "assets/browser");
  effects.push(cp2(coreServerPublicDir, options.outputDir, { recursive: true }));
  let initializedStoryIndexGenerator = Promise.resolve(void 0);
  if (!options.ignorePreview) {
    const workingDir = process.cwd();
    const directories = {
      configDir: options.configDir,
      workingDir
    };
    const normalizedStories = normalizeStories(stories, directories);
    const generator = new StoryIndexGenerator(normalizedStories, {
      ...directories,
      indexers,
      docs: docsOptions,
      build: build2
    });
    initializedStoryIndexGenerator = generator.initialize().then(() => generator);
    effects.push(
      extractStoriesJson(
        join(options.outputDir, "index.json"),
        initializedStoryIndexGenerator
      )
    );
  }
  if (!core2?.disableProjectJson) {
    effects.push(
      extractStorybookMetadata(join(options.outputDir, "project.json"), options.configDir)
    );
  }
  if (options.debugWebpack) {
    logConfig("Preview webpack config", await previewBuilder.getConfig(fullOptions));
  }
  if (options.ignorePreview) {
    logger4.info(`=> Not building preview`);
  } else {
    logger4.info("=> Building preview..");
  }
  const startTime = process.hrtime();
  await Promise.all([
    ...options.ignorePreview ? [] : [
      previewBuilder.build({
        startTime,
        options: fullOptions
      }).then(async (previewStats) => {
        logger4.trace({ message: "=> Preview built", time: process.hrtime(startTime) });
        const statsOption = options.webpackStatsJson || options.statsJson;
        if (statsOption) {
          const target = statsOption === true ? options.outputDir : statsOption;
          await outputStats(target, previewStats);
        }
      }).catch((error) => {
        logger4.error("=> Failed to build the preview");
        process.exitCode = 1;
        throw error;
      })
    ],
    ...effects
  ]);
  if (!core2?.disableTelemetry && !options.test) {
    effects.push(
      initializedStoryIndexGenerator.then(async (generator) => {
        const storyIndex = await generator?.getIndex();
        const payload = {
          precedingUpgrade: await getPrecedingUpgrade()
        };
        if (storyIndex) {
          Object.assign(payload, {
            storyIndex: summarizeIndex(storyIndex)
          });
        }
        await telemetry2("build", payload, { configDir: options.configDir });
      })
    );
  }
  logger4.info(`=> Output directory: ${options.outputDir}`);
}
__name(buildStaticStandalone, "buildStaticStandalone");

// src/core-server/build-dev.ts
import { readFile as readFile4 } from "node:fs/promises";
import {
  JsPackageManagerFactory,
  getConfigInfo,
  getInterpretedFile,
  getProjectRoot as getProjectRoot2,
  loadAllPresets as loadAllPresets2,
  loadMainConfig as loadMainConfig2,
  resolveAddonName as resolveAddonName2,
  resolvePathInStorybookCache,
  validateFrameworkName,
  versions
} from "storybook/internal/common";
import { deprecate, logger as logger11 } from "storybook/internal/node-logger";
import { MissingBuilderError as MissingBuilderError3, NoStatsForViteDevError } from "storybook/internal/server-errors";
import { oneWayHash, telemetry as telemetry4 } from "storybook/internal/telemetry";
import { global as global3 } from "@storybook/global";
var import_prompts = __toESM(require_prompts(), 1);
var import_ts_dedent8 = __toESM(require_dist(), 1);

// src/core-server/dev-server.ts
import { logConfig as logConfig2 } from "storybook/internal/common";
import { logger as logger8 } from "storybook/internal/node-logger";
import { MissingBuilderError as MissingBuilderError2 } from "storybook/internal/server-errors";

// ../node_modules/@polka/compression/build.mjs
import zlib from "node:zlib";
var NOOP = /* @__PURE__ */ __name(() => {
}, "NOOP");
var MIMES = /text|javascript|\/json|xml/i;
function getChunkSize(chunk, enc) {
  return chunk ? Buffer.byteLength(chunk, enc) : 0;
}
__name(getChunkSize, "getChunkSize");
function build_default({ threshold = 1024, level = -1, brotli = false, gzip = true, mimes = MIMES } = {}) {
  const brotliOpts = typeof brotli === "object" && brotli || {};
  const gzipOpts = typeof gzip === "object" && gzip || {};
  if (!zlib.createBrotliCompress) brotli = false;
  return (req, res, next = NOOP) => {
    const accept = req.headers["accept-encoding"] + "";
    const encoding = (brotli && /\bbr\b/.exec(accept) || gzip && /\bgzip\b/.exec(accept) || [])[0];
    if (req.method === "HEAD" || !encoding) return next();
    let compress;
    let pendingListeners = [];
    let pendingStatus = 0;
    let started = false;
    let size = 0;
    function start() {
      started = true;
      size = res.getHeader("Content-Length") | 0 || size;
      const compressible = mimes.test(
        String(res.getHeader("Content-Type") || "text/plain")
      );
      const cleartext = !res.getHeader("Content-Encoding");
      const listeners = pendingListeners || [];
      if (compressible && cleartext && size >= threshold) {
        res.setHeader("Content-Encoding", encoding);
        res.removeHeader("Content-Length");
        if (encoding === "br") {
          compress = zlib.createBrotliCompress({
            params: Object.assign({
              [zlib.constants.BROTLI_PARAM_QUALITY]: level,
              [zlib.constants.BROTLI_PARAM_SIZE_HINT]: size
            }, brotliOpts)
          });
        } else {
          compress = zlib.createGzip(
            Object.assign({ level }, gzipOpts)
          );
        }
        compress.on("data", (chunk) => write.call(res, chunk) || compress.pause());
        on.call(res, "drain", () => compress.resume());
        compress.on("end", () => end.call(res));
        listeners.forEach((p) => compress.on.apply(compress, p));
      } else {
        pendingListeners = null;
        listeners.forEach((p) => on.apply(res, p));
      }
      writeHead.call(res, pendingStatus || res.statusCode);
    }
    __name(start, "start");
    const { end, write, on, writeHead } = res;
    res.writeHead = function(status, reason, headers) {
      if (typeof reason !== "string") [headers, reason] = [reason, headers];
      if (headers) for (let k in headers) res.setHeader(k, headers[k]);
      pendingStatus = status;
      return this;
    };
    res.write = function(chunk, enc) {
      size += getChunkSize(chunk, enc);
      if (!started) start();
      if (!compress) return write.apply(this, arguments);
      return compress.write.apply(compress, arguments);
    };
    res.end = function(chunk, enc) {
      if (arguments.length > 0 && typeof chunk !== "function") {
        size += getChunkSize(chunk, enc);
      }
      if (!started) start();
      if (!compress) return end.apply(this, arguments);
      return compress.end.apply(compress, arguments);
    };
    res.on = function(type, listener) {
      if (!pendingListeners) on.call(this, type, listener);
      else if (compress) compress.on(type, listener);
      else pendingListeners.push([type, listener]);
      return this;
    };
    next();
  };
}
__name(build_default, "default");

// ../node_modules/polka/build.mjs
import http from "node:http";
import { setImmediate } from "node:timers";

// ../node_modules/regexparam/dist/index.mjs
function parse(input, loose) {
  if (input instanceof RegExp) return { keys: false, pattern: input };
  var c, o, tmp, ext, keys = [], pattern = "", arr = input.split("/");
  arr[0] || arr.shift();
  while (tmp = arr.shift()) {
    c = tmp[0];
    if (c === "*") {
      keys.push(c);
      pattern += tmp[1] === "?" ? "(?:/(.*))?" : "/(.*)";
    } else if (c === ":") {
      o = tmp.indexOf("?", 1);
      ext = tmp.indexOf(".", 1);
      keys.push(tmp.substring(1, !!~o ? o : !!~ext ? ext : tmp.length));
      pattern += !!~o && !~ext ? "(?:/([^/]+?))?" : "/([^/]+?)";
      if (!!~ext) pattern += (!!~o ? "?" : "") + "\\" + tmp.substring(ext);
    } else {
      pattern += "/" + tmp;
    }
  }
  return {
    keys,
    pattern: new RegExp("^" + pattern + (loose ? "(?=$|/)" : "/?$"), "i")
  };
}
__name(parse, "parse");

// ../node_modules/trouter/index.mjs
var MAP = {
  "": 0,
  GET: 1,
  HEAD: 2,
  PATCH: 3,
  OPTIONS: 4,
  CONNECT: 5,
  DELETE: 6,
  TRACE: 7,
  POST: 8,
  PUT: 9
};
var Trouter = class {
  static {
    __name(this, "Trouter");
  }
  constructor() {
    this.routes = [];
    this.all = this.add.bind(this, "");
    this.get = this.add.bind(this, "GET");
    this.head = this.add.bind(this, "HEAD");
    this.patch = this.add.bind(this, "PATCH");
    this.options = this.add.bind(this, "OPTIONS");
    this.connect = this.add.bind(this, "CONNECT");
    this.delete = this.add.bind(this, "DELETE");
    this.trace = this.add.bind(this, "TRACE");
    this.post = this.add.bind(this, "POST");
    this.put = this.add.bind(this, "PUT");
  }
  use(route, ...fns) {
    let handlers = [].concat.apply([], fns);
    let { keys, pattern } = parse(route, true);
    this.routes.push({ keys, pattern, method: "", handlers, midx: MAP[""] });
    return this;
  }
  add(method, route, ...fns) {
    let { keys, pattern } = parse(route);
    let handlers = [].concat.apply([], fns);
    this.routes.push({ keys, pattern, method, handlers, midx: MAP[method] });
    return this;
  }
  find(method, url) {
    let midx = MAP[method];
    let isHEAD = midx === 2;
    let i = 0, j = 0, k, tmp, arr = this.routes;
    let matches = [], params = {}, handlers = [];
    for (; i < arr.length; i++) {
      tmp = arr[i];
      if (tmp.midx === midx || tmp.midx === 0 || isHEAD && tmp.midx === 1) {
        if (tmp.keys === false) {
          matches = tmp.pattern.exec(url);
          if (matches === null) continue;
          if (matches.groups !== void 0) for (k in matches.groups) params[k] = matches.groups[k];
          tmp.handlers.length > 1 ? handlers = handlers.concat(tmp.handlers) : handlers.push(tmp.handlers[0]);
        } else if (tmp.keys.length > 0) {
          matches = tmp.pattern.exec(url);
          if (matches === null) continue;
          for (j = 0; j < tmp.keys.length; ) params[tmp.keys[j]] = matches[++j];
          tmp.handlers.length > 1 ? handlers = handlers.concat(tmp.handlers) : handlers.push(tmp.handlers[0]);
        } else if (tmp.pattern.test(url)) {
          tmp.handlers.length > 1 ? handlers = handlers.concat(tmp.handlers) : handlers.push(tmp.handlers[0]);
        }
      }
    }
    return { params, handlers };
  }
};

// ../node_modules/@polka/url/build.mjs
import * as qs from "node:querystring";
function parse3(req) {
  let raw = req.url;
  if (raw == null) return;
  let prev = req._parsedUrl;
  if (prev && prev.raw === raw) return prev;
  let pathname = raw, search = "", query, hash;
  if (raw.length > 1) {
    let idx = raw.indexOf("#", 1);
    if (idx !== -1) {
      hash = raw.substring(idx);
      pathname = raw.substring(0, idx);
    }
    idx = pathname.indexOf("?", 1);
    if (idx !== -1) {
      search = pathname.substring(idx);
      pathname = pathname.substring(0, idx);
      if (search.length > 1) {
        query = qs.parse(search.substring(1));
      }
    }
  }
  return req._parsedUrl = { pathname, search, query, hash, raw };
}
__name(parse3, "parse");

// ../node_modules/polka/build.mjs
function onError(err, req, res) {
  let code = typeof err.status === "number" && err.status;
  code = res.statusCode = code && code >= 100 ? code : 500;
  if (typeof err === "string" || Buffer.isBuffer(err)) res.end(err);
  else res.end(err.message || http.STATUS_CODES[code]);
}
__name(onError, "onError");
var mount = /* @__PURE__ */ __name((fn) => fn instanceof Polka ? fn.attach : fn, "mount");
var Polka = class _Polka extends Trouter {
  static {
    __name(this, "Polka");
  }
  constructor(opts = {}) {
    super();
    this.parse = parse3;
    this.server = opts.server;
    this.handler = this.handler.bind(this);
    this.onError = opts.onError || onError;
    this.onNoMatch = opts.onNoMatch || this.onError.bind(null, { status: 404 });
    this.attach = (req, res) => setImmediate(this.handler, req, res);
  }
  use(base, ...fns) {
    if (base === "/") {
      super.use(base, fns.map(mount));
    } else if (typeof base === "function" || base instanceof _Polka) {
      super.use("/", [base, ...fns].map(mount));
    } else {
      super.use(
        base,
        (req, _, next) => {
          if (typeof base === "string") {
            let len = base.length;
            base.startsWith("/") || len++;
            req.url = req.url.substring(len) || "/";
            req.path = req.path.substring(len) || "/";
          } else {
            req.url = req.url.replace(base, "") || "/";
            req.path = req.path.replace(base, "") || "/";
          }
          if (req.url.charAt(0) !== "/") {
            req.url = "/" + req.url;
          }
          next();
        },
        fns.map(mount),
        (req, _, next) => {
          req.path = req._parsedUrl.pathname;
          req.url = req.path + req._parsedUrl.search;
          next();
        }
      );
    }
    return this;
  }
  listen() {
    (this.server = this.server || http.createServer()).on("request", this.attach);
    this.server.listen.apply(this.server, arguments);
    return this;
  }
  handler(req, res, next) {
    let info = this.parse(req), path2 = info.pathname;
    let obj = this.find(req.method, req.path = path2);
    req.url = path2 + info.search;
    req.originalUrl = req.originalUrl || req.url;
    req.query = info.query || {};
    req.search = info.search;
    req.params = obj.params;
    if (path2.length > 1 && path2.indexOf("%", 1) !== -1) {
      for (let k in req.params) {
        try {
          req.params[k] = decodeURIComponent(req.params[k]);
        } catch (e) {
        }
      }
    }
    let i = 0, arr = obj.handlers.concat(this.onNoMatch), len = arr.length;
    let loop = /* @__PURE__ */ __name(async () => res.finished || i < len && arr[i++](req, res, next), "loop");
    (next = next || ((err) => err ? this.onError(err, req, res, next) : loop().catch(next)))();
  }
};
function build_default2(opts) {
  return new Polka(opts);
}
__name(build_default2, "default");

// src/core-server/utils/doTelemetry.ts
import { getPrecedingUpgrade as getPrecedingUpgrade2, telemetry as telemetry3 } from "storybook/internal/telemetry";

// src/core-server/utils/versionStatus.ts
var versionStatus = /* @__PURE__ */ __name((versionCheck) => {
  if (versionCheck.error) {
    return "error";
  }
  if (versionCheck.cached) {
    return "cached";
  }
  return "success";
}, "versionStatus");

// src/core-server/utils/doTelemetry.ts
async function doTelemetry(app, core2, initializedStoryIndexGenerator, options) {
  if (!core2?.disableTelemetry) {
    initializedStoryIndexGenerator.then(async (generator) => {
      let indexAndStats;
      try {
        indexAndStats = await generator?.getIndexAndStats();
      } catch (err) {
        if (!(err instanceof Error)) {
          throw new Error("encountered a non-recoverable error");
        }
        sendTelemetryError(err, "dev", {
          cliOptions: options,
          presetOptions: { ...options, corePresets: [], overridePresets: [] }
        });
        return;
      }
      const { versionCheck, versionUpdates } = options;
      invariant(
        !versionUpdates || versionUpdates && versionCheck,
        "versionCheck should be defined when versionUpdates is true"
      );
      const payload = {
        precedingUpgrade: await getPrecedingUpgrade2()
      };
      if (indexAndStats) {
        Object.assign(payload, {
          versionStatus: versionUpdates && versionCheck ? versionStatus(versionCheck) : "disabled",
          storyIndex: summarizeIndex(indexAndStats.storyIndex),
          storyStats: indexAndStats.stats
        });
      }
      telemetry3("dev", payload, { configDir: options.configDir });
    });
  }
  if (!core2?.disableProjectJson) {
    useStorybookMetadata(app, options.configDir);
  }
}
__name(doTelemetry, "doTelemetry");

// src/core-server/utils/get-caching-middleware.ts
function getCachingMiddleware() {
  return (req, res, next) => {
    res.setHeader("Cache-Control", "no-store");
    next();
  };
}
__name(getCachingMiddleware, "getCachingMiddleware");

// src/core-server/utils/get-server-channel.ts
var import_telejson = __toESM(require_dist2(), 1);
import { Channel, HEARTBEAT_INTERVAL } from "storybook/internal/channels";
import WebSocket, { WebSocketServer } from "ws";

// src/shared/universal-store/index.ts
var import_ts_dedent3 = __toESM(require_dist(), 1);

// src/shared/universal-store/instances.ts
var instances = /* @__PURE__ */ new Map();

// src/shared/universal-store/index.ts
var CHANNEL_EVENT_PREFIX = "UNIVERSAL_STORE:";
var ProgressState = {
  PENDING: "PENDING",
  RESOLVED: "RESOLVED",
  REJECTED: "REJECTED"
};
var UniversalStore = class _UniversalStore {
  constructor(options, environmentOverrides) {
    /** Enable debug logs for this store */
    this.debugging = false;
    // TODO: narrow type of listeners based on event type
    this.listeners = /* @__PURE__ */ new Map([["*", /* @__PURE__ */ new Set()]]);
    /** Gets the current state */
    this.getState = /* @__PURE__ */ __name(() => {
      this.debug("getState", { state: this.state });
      return this.state;
    }, "getState");
    /**
     * Subscribes to store events
     *
     * @returns A function to unsubscribe
     */
    this.subscribe = /* @__PURE__ */ __name((eventTypeOrListener, maybeListener) => {
      const subscribesToAllEvents = typeof eventTypeOrListener === "function";
      const eventType = subscribesToAllEvents ? "*" : eventTypeOrListener;
      const listener = subscribesToAllEvents ? eventTypeOrListener : maybeListener;
      this.debug("subscribe", { eventType, listener });
      if (!listener) {
        throw new TypeError(
          `Missing first subscribe argument, or second if first is the event type, when subscribing to a UniversalStore with id '${this.id}'`
        );
      }
      if (!this.listeners.has(eventType)) {
        this.listeners.set(eventType, /* @__PURE__ */ new Set());
      }
      this.listeners.get(eventType).add(listener);
      return () => {
        this.debug("unsubscribe", { eventType, listener });
        if (!this.listeners.has(eventType)) {
          return;
        }
        this.listeners.get(eventType).delete(listener);
        if (this.listeners.get(eventType)?.size === 0) {
          this.listeners.delete(eventType);
        }
      };
    }, "subscribe");
    /** Sends a custom event to the other stores */
    this.send = /* @__PURE__ */ __name((event) => {
      this.debug("send", { event });
      if (this.status !== _UniversalStore.Status.READY) {
        throw new TypeError(
          import_ts_dedent3.dedent`Cannot send event before store is ready. You can get the current status with store.status,
        or await store.readyPromise to wait for the store to be ready before sending events.
        ${JSON.stringify(
            {
              event,
              id: this.id,
              actor: this.actor,
              environment: this.environment
            },
            null,
            2
          )}`
        );
      }
      this.emitToListeners(event, { actor: this.actor });
      this.emitToChannel(event, { actor: this.actor });
    }, "send");
    this.debugging = options.debug ?? false;
    if (!_UniversalStore.isInternalConstructing) {
      throw new TypeError(
        "UniversalStore is not constructable - use UniversalStore.create() instead"
      );
    }
    _UniversalStore.isInternalConstructing = false;
    this.id = options.id;
    this.actorId = Date.now().toString(36) + Math.random().toString(36).substring(2);
    this.actorType = options.leader ? _UniversalStore.ActorType.LEADER : _UniversalStore.ActorType.FOLLOWER;
    this.state = options.initialState;
    this.channelEventName = `${CHANNEL_EVENT_PREFIX}${this.id}`;
    this.debug("constructor", {
      options,
      environmentOverrides,
      channelEventName: this.channelEventName
    });
    if (this.actor.type === _UniversalStore.ActorType.LEADER) {
      this.syncing = {
        state: ProgressState.RESOLVED,
        promise: Promise.resolve()
      };
    } else {
      let syncingResolve;
      let syncingReject;
      const syncingPromise = new Promise((resolve4, reject) => {
        syncingResolve = /* @__PURE__ */ __name(() => {
          if (this.syncing.state !== ProgressState.PENDING) {
            return;
          }
          this.syncing.state = ProgressState.RESOLVED;
          resolve4();
        }, "syncingResolve");
        syncingReject = /* @__PURE__ */ __name((reason) => {
          if (this.syncing.state !== ProgressState.PENDING) {
            return;
          }
          this.syncing.state = ProgressState.REJECTED;
          reject(reason);
        }, "syncingReject");
      });
      this.syncing = {
        state: ProgressState.PENDING,
        promise: syncingPromise,
        resolve: syncingResolve,
        reject: syncingReject
      };
    }
    this.getState = this.getState.bind(this);
    this.setState = this.setState.bind(this);
    this.subscribe = this.subscribe.bind(this);
    this.onStateChange = this.onStateChange.bind(this);
    this.send = this.send.bind(this);
    this.emitToChannel = this.emitToChannel.bind(this);
    this.prepareThis = this.prepareThis.bind(this);
    this.emitToListeners = this.emitToListeners.bind(this);
    this.handleChannelEvents = this.handleChannelEvents.bind(this);
    this.debug = this.debug.bind(this);
    this.channel = environmentOverrides?.channel ?? _UniversalStore.preparation.channel;
    this.environment = environmentOverrides?.environment ?? _UniversalStore.preparation.environment;
    if (this.channel && this.environment) {
      _UniversalStore.preparation.resolve({ channel: this.channel, environment: this.environment });
      this.prepareThis({ channel: this.channel, environment: this.environment });
    } else {
      _UniversalStore.preparation.promise.then(this.prepareThis);
    }
  }
  static {
    __name(this, "UniversalStore");
  }
  static {
    /**
     * Defines the possible actor types in the store system
     *
     * @readonly
     */
    this.ActorType = {
      LEADER: "LEADER",
      FOLLOWER: "FOLLOWER"
    };
  }
  static {
    /**
     * Defines the possible environments the store can run in
     *
     * @readonly
     */
    this.Environment = {
      SERVER: "SERVER",
      MANAGER: "MANAGER",
      PREVIEW: "PREVIEW",
      UNKNOWN: "UNKNOWN",
      MOCK: "MOCK"
    };
  }
  static {
    /**
     * Internal event types used for store synchronization
     *
     * @readonly
     */
    this.InternalEventType = {
      EXISTING_STATE_REQUEST: "__EXISTING_STATE_REQUEST",
      EXISTING_STATE_RESPONSE: "__EXISTING_STATE_RESPONSE",
      SET_STATE: "__SET_STATE",
      LEADER_CREATED: "__LEADER_CREATED",
      FOLLOWER_CREATED: "__FOLLOWER_CREATED"
    };
  }
  static {
    this.Status = {
      UNPREPARED: "UNPREPARED",
      SYNCING: "SYNCING",
      READY: "READY",
      ERROR: "ERROR"
    };
  }
  static {
    // This is used to check if constructor was called from the static factory create()
    this.isInternalConstructing = false;
  }
  static {
    _UniversalStore.setupPreparationPromise();
  }
  static setupPreparationPromise() {
    let resolveRef;
    let rejectRef;
    const promise = new Promise(
      (resolve4, reject) => {
        resolveRef = /* @__PURE__ */ __name((args) => {
          resolve4(args);
        }, "resolveRef");
        rejectRef = /* @__PURE__ */ __name((...args) => {
          reject(args);
        }, "rejectRef");
      }
    );
    _UniversalStore.preparation = {
      resolve: resolveRef,
      reject: rejectRef,
      promise
    };
  }
  /** The actor object representing the store instance with a unique ID and a type */
  get actor() {
    return Object.freeze({
      id: this.actorId,
      type: this.actorType,
      environment: this.environment ?? _UniversalStore.Environment.UNKNOWN
    });
  }
  /**
   * The current state of the store, that signals both if the store is prepared by Storybook and
   * also - in the case of a follower - if the state has been synced with the leader's state.
   */
  get status() {
    if (!this.channel || !this.environment) {
      return _UniversalStore.Status.UNPREPARED;
    }
    switch (this.syncing?.state) {
      case ProgressState.PENDING:
      case void 0:
        return _UniversalStore.Status.SYNCING;
      case ProgressState.REJECTED:
        return _UniversalStore.Status.ERROR;
      case ProgressState.RESOLVED:
      default:
        return _UniversalStore.Status.READY;
    }
  }
  /**
   * A promise that resolves when the store is fully ready. A leader will be ready when the store
   * has been prepared by Storybook, which is almost instantly.
   *
   * A follower will be ready when the state has been synced with the leader's state, within a few
   * hundred milliseconds.
   */
  untilReady() {
    return Promise.all([_UniversalStore.preparation.promise, this.syncing?.promise]);
  }
  /** Creates a new instance of UniversalStore */
  static create(options) {
    if (!options || typeof options?.id !== "string") {
      throw new TypeError("id is required and must be a string, when creating a UniversalStore");
    }
    if (options.debug) {
      console.debug(
        import_ts_dedent3.dedent`[UniversalStore]
        create`,
        { options }
      );
    }
    const existing = instances.get(options.id);
    if (existing) {
      console.warn(import_ts_dedent3.dedent`UniversalStore with id "${options.id}" already exists in this environment, re-using existing.
        You should reuse the existing instance instead of trying to create a new one.`);
      return existing;
    }
    _UniversalStore.isInternalConstructing = true;
    const store = new _UniversalStore(options);
    instances.set(options.id, store);
    return store;
  }
  /**
   * Used by Storybook to set the channel for all instances of UniversalStore in the given
   * environment.
   *
   * @internal
   */
  static __prepare(channel, environment) {
    _UniversalStore.preparation.channel = channel;
    _UniversalStore.preparation.environment = environment;
    _UniversalStore.preparation.resolve({ channel, environment });
  }
  /**
   * Updates the store's state
   *
   * Either a new state or a state updater function can be passed to the method.
   */
  setState(updater) {
    const previousState = this.state;
    const newState = typeof updater === "function" ? updater(previousState) : updater;
    this.debug("setState", { newState, previousState, updater });
    if (this.status !== _UniversalStore.Status.READY) {
      throw new TypeError(
        import_ts_dedent3.dedent`Cannot set state before store is ready. You can get the current status with store.status,
        or await store.readyPromise to wait for the store to be ready before sending events.
        ${JSON.stringify(
          {
            newState,
            id: this.id,
            actor: this.actor,
            environment: this.environment
          },
          null,
          2
        )}`
      );
    }
    this.state = newState;
    const event = {
      type: _UniversalStore.InternalEventType.SET_STATE,
      payload: {
        state: newState,
        previousState
      }
    };
    this.emitToChannel(event, { actor: this.actor });
    this.emitToListeners(event, { actor: this.actor });
  }
  /**
   * Subscribes to state changes
   *
   * @returns Unsubscribe function
   */
  onStateChange(listener) {
    this.debug("onStateChange", { listener });
    return this.subscribe(
      _UniversalStore.InternalEventType.SET_STATE,
      ({ payload }, eventInfo) => {
        listener(payload.state, payload.previousState, eventInfo);
      }
    );
  }
  emitToChannel(event, eventInfo) {
    this.debug("emitToChannel", { event, eventInfo, channel: !!this.channel });
    this.channel?.emit(this.channelEventName, {
      event,
      eventInfo
    });
  }
  prepareThis({
    channel,
    environment
  }) {
    this.channel = channel;
    this.environment = environment;
    this.debug("prepared", { channel: !!channel, environment });
    this.channel.on(this.channelEventName, this.handleChannelEvents);
    if (this.actor.type === _UniversalStore.ActorType.LEADER) {
      this.emitToChannel(
        { type: _UniversalStore.InternalEventType.LEADER_CREATED },
        { actor: this.actor }
      );
    } else {
      this.emitToChannel(
        { type: _UniversalStore.InternalEventType.FOLLOWER_CREATED },
        { actor: this.actor }
      );
      this.emitToChannel(
        { type: _UniversalStore.InternalEventType.EXISTING_STATE_REQUEST },
        { actor: this.actor }
      );
      setTimeout(() => {
        this.syncing.reject(
          new TypeError(
            `No existing state found for follower with id: '${this.id}'. Make sure a leader with the same id exists before creating a follower.`
          )
        );
      }, 1e3);
    }
  }
  emitToListeners(event, eventInfo) {
    const eventTypeListeners = this.listeners.get(event.type);
    const everythingListeners = this.listeners.get("*");
    this.debug("emitToListeners", {
      event,
      eventInfo,
      eventTypeListeners,
      everythingListeners
    });
    [...eventTypeListeners ?? [], ...everythingListeners ?? []].forEach(
      (listener) => listener(event, eventInfo)
    );
  }
  handleChannelEvents(channelEvent) {
    const { event, eventInfo } = channelEvent;
    if ([eventInfo.actor.id, eventInfo.forwardingActor?.id].includes(this.actor.id)) {
      this.debug("handleChannelEvents: Ignoring event from self", { channelEvent });
      return;
    } else if (this.syncing?.state === ProgressState.PENDING && event.type !== _UniversalStore.InternalEventType.EXISTING_STATE_RESPONSE) {
      this.debug("handleChannelEvents: Ignoring event while syncing", { channelEvent });
      return;
    }
    this.debug("handleChannelEvents", { channelEvent });
    if (this.actor.type === _UniversalStore.ActorType.LEADER) {
      let shouldForwardEvent = true;
      switch (event.type) {
        case _UniversalStore.InternalEventType.EXISTING_STATE_REQUEST:
          shouldForwardEvent = false;
          const responseEvent = {
            type: _UniversalStore.InternalEventType.EXISTING_STATE_RESPONSE,
            payload: this.state
          };
          this.debug("handleChannelEvents: responding to existing state request", {
            responseEvent
          });
          this.emitToChannel(responseEvent, { actor: this.actor });
          this.emitToListeners(responseEvent, { actor: this.actor });
          break;
        case _UniversalStore.InternalEventType.LEADER_CREATED:
          shouldForwardEvent = false;
          this.syncing.state = ProgressState.REJECTED;
          this.debug("handleChannelEvents: erroring due to second leader being created", {
            event
          });
          console.error(
            import_ts_dedent3.dedent`Detected multiple UniversalStore leaders created with the same id "${this.id}".
            Only one leader can exists at a time, your stores are now in an invalid state.
            Leaders detected:
            this: ${JSON.stringify(this.actor, null, 2)}
            other: ${JSON.stringify(eventInfo.actor, null, 2)}`
          );
          break;
      }
      if (shouldForwardEvent) {
        this.debug("handleChannelEvents: forwarding event", { channelEvent });
        this.emitToChannel(event, { actor: eventInfo.actor, forwardingActor: this.actor });
      }
    }
    if (this.actor.type === _UniversalStore.ActorType.FOLLOWER) {
      switch (event.type) {
        case _UniversalStore.InternalEventType.EXISTING_STATE_RESPONSE:
          this.debug("handleChannelEvents: Setting state from leader's existing state response", {
            event
          });
          if (this.syncing?.state !== ProgressState.PENDING) {
            break;
          }
          this.syncing.resolve?.();
          const setStateEvent = {
            type: _UniversalStore.InternalEventType.SET_STATE,
            payload: {
              state: event.payload,
              previousState: this.state
            }
          };
          this.state = event.payload;
          this.emitToListeners(setStateEvent, eventInfo);
          break;
      }
    }
    switch (event.type) {
      case _UniversalStore.InternalEventType.SET_STATE:
        this.debug("handleChannelEvents: Setting state", { event });
        this.state = event.payload.state;
        break;
    }
    this.emitToListeners(event, { actor: eventInfo.actor });
  }
  debug(message, data) {
    if (this.debugging) {
      console.debug(
        import_ts_dedent3.dedent`[UniversalStore::${this.id}::${this.environment ?? _UniversalStore.Environment.UNKNOWN}]
        ${message}`,
        JSON.stringify(
          {
            data,
            actor: this.actor,
            state: this.state,
            status: this.status
          },
          null,
          2
        )
      );
    }
  }
  /**
   * Used to reset the static fields of the UniversalStore class when cleaning up tests
   *
   * @internal
   */
  static __reset() {
    _UniversalStore.preparation.reject(new Error("reset"));
    _UniversalStore.setupPreparationPromise();
    _UniversalStore.isInternalConstructing = false;
  }
};

// src/core-server/utils/get-server-channel.ts
var ServerChannelTransport = class {
  static {
    __name(this, "ServerChannelTransport");
  }
  constructor(server) {
    this.socket = new WebSocketServer({ noServer: true });
    server.on("upgrade", (request, socket, head) => {
      if (request.url === "/storybook-server-channel") {
        this.socket.handleUpgrade(request, socket, head, (ws) => {
          this.socket.emit("connection", ws, request);
        });
      }
    });
    this.socket.on("connection", (wss) => {
      wss.on("message", (raw) => {
        const data = raw.toString();
        const event = typeof data === "string" && (0, import_telejson.isJSON)(data) ? (0, import_telejson.parse)(data, {}) : data;
        this.handler?.(event);
      });
    });
    const interval = setInterval(() => {
      this.send({ type: "ping" });
    }, HEARTBEAT_INTERVAL);
    this.socket.on("close", /* @__PURE__ */ __name(function close() {
      clearInterval(interval);
    }, "close"));
    process.on("SIGTERM", () => {
      this.socket.clients.forEach((client) => {
        if (client.readyState === WebSocket.OPEN) {
          client.close(1001, "Server is shutting down");
        }
      });
      this.socket.close(() => process.exit(0));
    });
  }
  setHandler(handler) {
    this.handler = handler;
  }
  send(event) {
    const data = (0, import_telejson.stringify)(event, { maxDepth: 15 });
    Array.from(this.socket.clients).filter((c) => c.readyState === WebSocket.OPEN).forEach((client) => client.send(data));
  }
};
function getServerChannel(server) {
  const transports = [new ServerChannelTransport(server)];
  const channel = new Channel({ transports, async: true });
  UniversalStore.__prepare(channel, UniversalStore.Environment.SERVER);
  return channel;
}
__name(getServerChannel, "getServerChannel");

// src/core-server/utils/getAccessControlMiddleware.ts
function getAccessControlMiddleware(crossOriginIsolated) {
  return (req, res, next) => {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    if (crossOriginIsolated) {
      res.setHeader("Cross-Origin-Opener-Policy", "same-origin");
      res.setHeader("Cross-Origin-Embedder-Policy", "require-corp");
    }
    next();
  };
}
__name(getAccessControlMiddleware, "getAccessControlMiddleware");

// src/core-server/utils/getStoryIndexGenerator.ts
import { normalizeStories as normalizeStories2 } from "storybook/internal/common";
async function getStoryIndexGenerator(app, options, serverChannel) {
  const workingDir = process.cwd();
  const configDir = options.configDir;
  const directories = {
    configDir,
    workingDir
  };
  const stories = options.presets.apply("stories");
  const indexers = options.presets.apply("experimental_indexers", []);
  const docsOptions = options.presets.apply("docs");
  const normalizedStories = normalizeStories2(await stories, directories);
  const generator = new StoryIndexGenerator(normalizedStories, {
    ...directories,
    indexers: await indexers,
    docs: await docsOptions,
    workingDir
  });
  const initializedStoryIndexGenerator = generator.initialize().then(() => generator);
  useStoriesJson({
    app,
    initializedStoryIndexGenerator,
    normalizedStories,
    serverChannel,
    workingDir,
    configDir
  });
  return initializedStoryIndexGenerator;
}
__name(getStoryIndexGenerator, "getStoryIndexGenerator");

// src/core-server/utils/middleware.ts
import { existsSync as existsSync2 } from "node:fs";
var fileExists = /* @__PURE__ */ __name((basename4) => [".js", ".mjs", ".cjs"].reduce((found, ext) => {
  const filename = `${basename4}${ext}`;
  return !found && existsSync2(filename) ? filename : found;
}, ""), "fileExists");
async function getMiddleware(configDir) {
  const middlewarePath = fileExists(resolve(configDir, "middleware"));
  if (middlewarePath) {
    const middlewareModule = await import(middlewarePath);
    return middlewareModule.default ?? middlewareModule;
  }
  return () => {
  };
}
__name(getMiddleware, "getMiddleware");

// src/core-server/utils/open-browser/open-in-browser.ts
import { logger as logger5 } from "storybook/internal/node-logger";

// ../node_modules/open/index.js
import process7 from "node:process";
import { Buffer as Buffer2 } from "node:buffer";
import path from "node:path";
import { fileURLToPath } from "node:url";
import { promisify as promisify5 } from "node:util";
import childProcess from "node:child_process";
import fs5, { constants as fsConstants2 } from "node:fs/promises";

// ../node_modules/wsl-utils/index.js
import process3 from "node:process";
import fs4, { constants as fsConstants } from "node:fs/promises";

// ../node_modules/is-wsl/index.js
import process2 from "node:process";
import os from "node:os";
import fs3 from "node:fs";

// ../node_modules/is-inside-container/index.js
import fs2 from "node:fs";

// ../node_modules/is-inside-container/node_modules/is-docker/index.js
import fs from "node:fs";
var isDockerCached;
function hasDockerEnv() {
  try {
    fs.statSync("/.dockerenv");
    return true;
  } catch {
    return false;
  }
}
__name(hasDockerEnv, "hasDockerEnv");
function hasDockerCGroup() {
  try {
    return fs.readFileSync("/proc/self/cgroup", "utf8").includes("docker");
  } catch {
    return false;
  }
}
__name(hasDockerCGroup, "hasDockerCGroup");
function isDocker() {
  if (isDockerCached === void 0) {
    isDockerCached = hasDockerEnv() || hasDockerCGroup();
  }
  return isDockerCached;
}
__name(isDocker, "isDocker");

// ../node_modules/is-inside-container/index.js
var cachedResult;
var hasContainerEnv = /* @__PURE__ */ __name(() => {
  try {
    fs2.statSync("/run/.containerenv");
    return true;
  } catch {
    return false;
  }
}, "hasContainerEnv");
function isInsideContainer() {
  if (cachedResult === void 0) {
    cachedResult = hasContainerEnv() || isDocker();
  }
  return cachedResult;
}
__name(isInsideContainer, "isInsideContainer");

// ../node_modules/is-wsl/index.js
var isWsl = /* @__PURE__ */ __name(() => {
  if (process2.platform !== "linux") {
    return false;
  }
  if (os.release().toLowerCase().includes("microsoft")) {
    if (isInsideContainer()) {
      return false;
    }
    return true;
  }
  try {
    return fs3.readFileSync("/proc/version", "utf8").toLowerCase().includes("microsoft") ? !isInsideContainer() : false;
  } catch {
    return false;
  }
}, "isWsl");
var is_wsl_default = process2.env.__IS_WSL_TEST__ ? isWsl : isWsl();

// ../node_modules/wsl-utils/index.js
var wslDrivesMountPoint = /* @__PURE__ */ (() => {
  const defaultMountPoint = "/mnt/";
  let mountPoint;
  return async function() {
    if (mountPoint) {
      return mountPoint;
    }
    const configFilePath = "/etc/wsl.conf";
    let isConfigFileExists = false;
    try {
      await fs4.access(configFilePath, fsConstants.F_OK);
      isConfigFileExists = true;
    } catch {
    }
    if (!isConfigFileExists) {
      return defaultMountPoint;
    }
    const configContent = await fs4.readFile(configFilePath, { encoding: "utf8" });
    const configMountPoint = /(?<!#.*)root\s*=\s*(?<mountPoint>.*)/g.exec(configContent);
    if (!configMountPoint) {
      return defaultMountPoint;
    }
    mountPoint = configMountPoint.groups.mountPoint.trim();
    mountPoint = mountPoint.endsWith("/") ? mountPoint : `${mountPoint}/`;
    return mountPoint;
  };
})();
var powerShellPathFromWsl = /* @__PURE__ */ __name(async () => {
  const mountPoint = await wslDrivesMountPoint();
  return `${mountPoint}c/Windows/System32/WindowsPowerShell/v1.0/powershell.exe`;
}, "powerShellPathFromWsl");
var powerShellPath = /* @__PURE__ */ __name(async () => {
  if (is_wsl_default) {
    return powerShellPathFromWsl();
  }
  return `${process3.env.SYSTEMROOT || process3.env.windir || String.raw`C:\Windows`}\\System32\\WindowsPowerShell\\v1.0\\powershell.exe`;
}, "powerShellPath");

// ../node_modules/define-lazy-prop/index.js
function defineLazyProperty(object, propertyName, valueGetter) {
  const define = /* @__PURE__ */ __name((value) => Object.defineProperty(object, propertyName, { value, enumerable: true, writable: true }), "define");
  Object.defineProperty(object, propertyName, {
    configurable: true,
    enumerable: true,
    get() {
      const result = valueGetter();
      define(result);
      return result;
    },
    set(value) {
      define(value);
    }
  });
  return object;
}
__name(defineLazyProperty, "defineLazyProperty");

// ../node_modules/default-browser/index.js
import { promisify as promisify4 } from "node:util";
import process6 from "node:process";
import { execFile as execFile4 } from "node:child_process";

// ../node_modules/default-browser-id/index.js
import { promisify } from "node:util";
import process4 from "node:process";
import { execFile } from "node:child_process";
var execFileAsync = promisify(execFile);
async function defaultBrowserId() {
  if (process4.platform !== "darwin") {
    throw new Error("macOS only");
  }
  const { stdout } = await execFileAsync("defaults", ["read", "com.apple.LaunchServices/com.apple.launchservices.secure", "LSHandlers"]);
  const match = /LSHandlerRoleAll = "(?!-)(?<id>[^"]+?)";\s+?LSHandlerURLScheme = (?:http|https);/.exec(stdout);
  const browserId = match?.groups.id ?? "com.apple.Safari";
  if (browserId === "com.apple.safari") {
    return "com.apple.Safari";
  }
  return browserId;
}
__name(defaultBrowserId, "defaultBrowserId");

// ../node_modules/run-applescript/index.js
import process5 from "node:process";
import { promisify as promisify2 } from "node:util";
import { execFile as execFile2, execFileSync } from "node:child_process";
var execFileAsync2 = promisify2(execFile2);
async function runAppleScript(script, { humanReadableOutput = true, signal } = {}) {
  if (process5.platform !== "darwin") {
    throw new Error("macOS only");
  }
  const outputArguments = humanReadableOutput ? [] : ["-ss"];
  const execOptions = {};
  if (signal) {
    execOptions.signal = signal;
  }
  const { stdout } = await execFileAsync2("osascript", ["-e", script, outputArguments], execOptions);
  return stdout.trim();
}
__name(runAppleScript, "runAppleScript");

// ../node_modules/bundle-name/index.js
async function bundleName(bundleId) {
  return runAppleScript(`tell application "Finder" to set app_path to application file id "${bundleId}" as string
tell application "System Events" to get value of property list item "CFBundleName" of property list file (app_path & ":Contents:Info.plist")`);
}
__name(bundleName, "bundleName");

// ../node_modules/default-browser/windows.js
import { promisify as promisify3 } from "node:util";
import { execFile as execFile3 } from "node:child_process";
var execFileAsync3 = promisify3(execFile3);
var windowsBrowserProgIds = {
  MSEdgeHTM: { name: "Edge", id: "com.microsoft.edge" },
  // The missing `L` is correct.
  MSEdgeBHTML: { name: "Edge Beta", id: "com.microsoft.edge.beta" },
  MSEdgeDHTML: { name: "Edge Dev", id: "com.microsoft.edge.dev" },
  AppXq0fevzme2pys62n3e0fbqa7peapykr8v: { name: "Edge", id: "com.microsoft.edge.old" },
  ChromeHTML: { name: "Chrome", id: "com.google.chrome" },
  ChromeBHTML: { name: "Chrome Beta", id: "com.google.chrome.beta" },
  ChromeDHTML: { name: "Chrome Dev", id: "com.google.chrome.dev" },
  ChromiumHTM: { name: "Chromium", id: "org.chromium.Chromium" },
  BraveHTML: { name: "Brave", id: "com.brave.Browser" },
  BraveBHTML: { name: "Brave Beta", id: "com.brave.Browser.beta" },
  BraveDHTML: { name: "Brave Dev", id: "com.brave.Browser.dev" },
  BraveSSHTM: { name: "Brave Nightly", id: "com.brave.Browser.nightly" },
  FirefoxURL: { name: "Firefox", id: "org.mozilla.firefox" },
  OperaStable: { name: "Opera", id: "com.operasoftware.Opera" },
  VivaldiHTM: { name: "Vivaldi", id: "com.vivaldi.Vivaldi" },
  "IE.HTTP": { name: "Internet Explorer", id: "com.microsoft.ie" }
};
var _windowsBrowserProgIdMap = new Map(Object.entries(windowsBrowserProgIds));
var UnknownBrowserError = class extends Error {
  static {
    __name(this, "UnknownBrowserError");
  }
};
async function defaultBrowser(_execFileAsync = execFileAsync3) {
  const { stdout } = await _execFileAsync("reg", [
    "QUERY",
    " HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice",
    "/v",
    "ProgId"
  ]);
  const match = /ProgId\s*REG_SZ\s*(?<id>\S+)/.exec(stdout);
  if (!match) {
    throw new UnknownBrowserError(`Cannot find Windows browser in stdout: ${JSON.stringify(stdout)}`);
  }
  const { id } = match.groups;
  const browser = windowsBrowserProgIds[id];
  if (!browser) {
    throw new UnknownBrowserError(`Unknown browser ID: ${id}`);
  }
  return browser;
}
__name(defaultBrowser, "defaultBrowser");

// ../node_modules/default-browser/index.js
var execFileAsync4 = promisify4(execFile4);
var titleize = /* @__PURE__ */ __name((string) => string.toLowerCase().replaceAll(/(?:^|\s|-)\S/g, (x) => x.toUpperCase()), "titleize");
async function defaultBrowser2() {
  if (process6.platform === "darwin") {
    const id = await defaultBrowserId();
    const name = await bundleName(id);
    return { name, id };
  }
  if (process6.platform === "linux") {
    const { stdout } = await execFileAsync4("xdg-mime", ["query", "default", "x-scheme-handler/http"]);
    const id = stdout.trim();
    const name = titleize(id.replace(/.desktop$/, "").replace("-", " "));
    return { name, id };
  }
  if (process6.platform === "win32") {
    return defaultBrowser();
  }
  throw new Error("Only macOS, Linux, and Windows are supported");
}
__name(defaultBrowser2, "defaultBrowser");

// ../node_modules/open/index.js
var execFile5 = promisify5(childProcess.execFile);
var __dirname2 = path.dirname(fileURLToPath(import.meta.url));
var localXdgOpenPath = path.join(__dirname2, "xdg-open");
var { platform, arch } = process7;
async function getWindowsDefaultBrowserFromWsl() {
  const powershellPath = await powerShellPath();
  const rawCommand = String.raw`(Get-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\Shell\Associations\UrlAssociations\http\UserChoice").ProgId`;
  const encodedCommand = Buffer2.from(rawCommand, "utf16le").toString("base64");
  const { stdout } = await execFile5(
    powershellPath,
    [
      "-NoProfile",
      "-NonInteractive",
      "-ExecutionPolicy",
      "Bypass",
      "-EncodedCommand",
      encodedCommand
    ],
    { encoding: "utf8" }
  );
  const progId = stdout.trim();
  const browserMap = {
    ChromeHTML: "com.google.chrome",
    BraveHTML: "com.brave.Browser",
    MSEdgeHTM: "com.microsoft.edge",
    FirefoxURL: "org.mozilla.firefox"
  };
  return browserMap[progId] ? { id: browserMap[progId] } : {};
}
__name(getWindowsDefaultBrowserFromWsl, "getWindowsDefaultBrowserFromWsl");
var pTryEach = /* @__PURE__ */ __name(async (array, mapper) => {
  let latestError;
  for (const item of array) {
    try {
      return await mapper(item);
    } catch (error) {
      latestError = error;
    }
  }
  throw latestError;
}, "pTryEach");
var baseOpen = /* @__PURE__ */ __name(async (options) => {
  options = {
    wait: false,
    background: false,
    newInstance: false,
    allowNonzeroExitCode: false,
    ...options
  };
  if (Array.isArray(options.app)) {
    return pTryEach(options.app, (singleApp) => baseOpen({
      ...options,
      app: singleApp
    }));
  }
  let { name: app, arguments: appArguments = [] } = options.app ?? {};
  appArguments = [...appArguments];
  if (Array.isArray(app)) {
    return pTryEach(app, (appName) => baseOpen({
      ...options,
      app: {
        name: appName,
        arguments: appArguments
      }
    }));
  }
  if (app === "browser" || app === "browserPrivate") {
    const ids = {
      "com.google.chrome": "chrome",
      "google-chrome.desktop": "chrome",
      "com.brave.Browser": "brave",
      "org.mozilla.firefox": "firefox",
      "firefox.desktop": "firefox",
      "com.microsoft.msedge": "edge",
      "com.microsoft.edge": "edge",
      "com.microsoft.edgemac": "edge",
      "microsoft-edge.desktop": "edge"
    };
    const flags = {
      chrome: "--incognito",
      brave: "--incognito",
      firefox: "--private-window",
      edge: "--inPrivate"
    };
    const browser = is_wsl_default ? await getWindowsDefaultBrowserFromWsl() : await defaultBrowser2();
    if (browser.id in ids) {
      const browserName = ids[browser.id];
      if (app === "browserPrivate") {
        appArguments.push(flags[browserName]);
      }
      return baseOpen({
        ...options,
        app: {
          name: apps[browserName],
          arguments: appArguments
        }
      });
    }
    throw new Error(`${browser.name} is not supported as a default browser`);
  }
  let command;
  const cliArguments = [];
  const childProcessOptions = {};
  if (platform === "darwin") {
    command = "open";
    if (options.wait) {
      cliArguments.push("--wait-apps");
    }
    if (options.background) {
      cliArguments.push("--background");
    }
    if (options.newInstance) {
      cliArguments.push("--new");
    }
    if (app) {
      cliArguments.push("-a", app);
    }
  } else if (platform === "win32" || is_wsl_default && !isInsideContainer() && !app) {
    command = await powerShellPath();
    cliArguments.push(
      "-NoProfile",
      "-NonInteractive",
      "-ExecutionPolicy",
      "Bypass",
      "-EncodedCommand"
    );
    if (!is_wsl_default) {
      childProcessOptions.windowsVerbatimArguments = true;
    }
    const encodedArguments = ["Start"];
    if (options.wait) {
      encodedArguments.push("-Wait");
    }
    if (app) {
      encodedArguments.push(`"\`"${app}\`""`);
      if (options.target) {
        appArguments.push(options.target);
      }
    } else if (options.target) {
      encodedArguments.push(`"${options.target}"`);
    }
    if (appArguments.length > 0) {
      appArguments = appArguments.map((argument) => `"\`"${argument}\`""`);
      encodedArguments.push("-ArgumentList", appArguments.join(","));
    }
    options.target = Buffer2.from(encodedArguments.join(" "), "utf16le").toString("base64");
  } else {
    if (app) {
      command = app;
    } else {
      const isBundled = !__dirname2 || __dirname2 === "/";
      let exeLocalXdgOpen = false;
      try {
        await fs5.access(localXdgOpenPath, fsConstants2.X_OK);
        exeLocalXdgOpen = true;
      } catch {
      }
      const useSystemXdgOpen = process7.versions.electron ?? (platform === "android" || isBundled || !exeLocalXdgOpen);
      command = useSystemXdgOpen ? "xdg-open" : localXdgOpenPath;
    }
    if (appArguments.length > 0) {
      cliArguments.push(...appArguments);
    }
    if (!options.wait) {
      childProcessOptions.stdio = "ignore";
      childProcessOptions.detached = true;
    }
  }
  if (platform === "darwin" && appArguments.length > 0) {
    cliArguments.push("--args", ...appArguments);
  }
  if (options.target) {
    cliArguments.push(options.target);
  }
  const subprocess = childProcess.spawn(command, cliArguments, childProcessOptions);
  if (options.wait) {
    return new Promise((resolve4, reject) => {
      subprocess.once("error", reject);
      subprocess.once("close", (exitCode) => {
        if (!options.allowNonzeroExitCode && exitCode > 0) {
          reject(new Error(`Exited with code ${exitCode}`));
          return;
        }
        resolve4(subprocess);
      });
    });
  }
  subprocess.unref();
  return subprocess;
}, "baseOpen");
var open = /* @__PURE__ */ __name((target, options) => {
  if (typeof target !== "string") {
    throw new TypeError("Expected a `target`");
  }
  return baseOpen({
    ...options,
    target
  });
}, "open");
function detectArchBinary(binary) {
  if (typeof binary === "string" || Array.isArray(binary)) {
    return binary;
  }
  const { [arch]: archBinary } = binary;
  if (!archBinary) {
    throw new Error(`${arch} is not supported`);
  }
  return archBinary;
}
__name(detectArchBinary, "detectArchBinary");
function detectPlatformBinary({ [platform]: platformBinary }, { wsl }) {
  if (wsl && is_wsl_default) {
    return detectArchBinary(wsl);
  }
  if (!platformBinary) {
    throw new Error(`${platform} is not supported`);
  }
  return detectArchBinary(platformBinary);
}
__name(detectPlatformBinary, "detectPlatformBinary");
var apps = {};
defineLazyProperty(apps, "chrome", () => detectPlatformBinary({
  darwin: "google chrome",
  win32: "chrome",
  linux: ["google-chrome", "google-chrome-stable", "chromium"]
}, {
  wsl: {
    ia32: "/mnt/c/Program Files (x86)/Google/Chrome/Application/chrome.exe",
    x64: ["/mnt/c/Program Files/Google/Chrome/Application/chrome.exe", "/mnt/c/Program Files (x86)/Google/Chrome/Application/chrome.exe"]
  }
}));
defineLazyProperty(apps, "brave", () => detectPlatformBinary({
  darwin: "brave browser",
  win32: "brave",
  linux: ["brave-browser", "brave"]
}, {
  wsl: {
    ia32: "/mnt/c/Program Files (x86)/BraveSoftware/Brave-Browser/Application/brave.exe",
    x64: ["/mnt/c/Program Files/BraveSoftware/Brave-Browser/Application/brave.exe", "/mnt/c/Program Files (x86)/BraveSoftware/Brave-Browser/Application/brave.exe"]
  }
}));
defineLazyProperty(apps, "firefox", () => detectPlatformBinary({
  darwin: "firefox",
  win32: String.raw`C:\Program Files\Mozilla Firefox\firefox.exe`,
  linux: "firefox"
}, {
  wsl: "/mnt/c/Program Files/Mozilla Firefox/firefox.exe"
}));
defineLazyProperty(apps, "edge", () => detectPlatformBinary({
  darwin: "microsoft edge",
  win32: "msedge",
  linux: ["microsoft-edge", "microsoft-edge-dev"]
}, {
  wsl: "/mnt/c/Program Files (x86)/Microsoft/Edge/Application/msedge.exe"
}));
defineLazyProperty(apps, "browser", () => "browser");
defineLazyProperty(apps, "browserPrivate", () => "browserPrivate");
var open_default = open;

// src/core-server/utils/open-browser/open-in-browser.ts
var import_ts_dedent4 = __toESM(require_dist(), 1);

// src/core-server/utils/open-browser/opener.ts
var import_cross_spawn = __toESM(require_cross_spawn(), 1);
import { execSync } from "node:child_process";
import { join as join6 } from "node:path";
var import_picocolors5 = __toESM(require_picocolors(), 1);
var OSX_CHROME = "google chrome";
var Actions = Object.freeze({
  NONE: 0,
  BROWSER: 1,
  SCRIPT: 2
});
function getBrowserEnv() {
  const value = process.env.BROWSER;
  const args = process.env.BROWSER_ARGS ? process.env.BROWSER_ARGS.split(" ") : [];
  let action;
  if (!value) {
    action = Actions.BROWSER;
  } else if (value.toLowerCase().endsWith(".js")) {
    action = Actions.SCRIPT;
  } else if (value.toLowerCase() === "none") {
    action = Actions.NONE;
  } else {
    action = Actions.BROWSER;
  }
  return { action, value, args };
}
__name(getBrowserEnv, "getBrowserEnv");
function executeNodeScript(scriptPath, url) {
  const extraArgs = process.argv.slice(2);
  const child = (0, import_cross_spawn.default)(process.execPath, [scriptPath, ...extraArgs, url], {
    stdio: "inherit"
  });
  child.on("close", (code) => {
    if (code !== 0) {
      console.log();
      console.log(import_picocolors5.default.red("The script specified as BROWSER environment variable failed."));
      console.log(`${import_picocolors5.default.cyan(scriptPath)} exited with code ${code}.`);
      console.log();
      return;
    }
  });
  return true;
}
__name(executeNodeScript, "executeNodeScript");
function startBrowserProcess(browser, url, args) {
  const shouldTryOpenChromiumWithAppleScript = process.platform === "darwin" && (typeof browser !== "string" || browser === OSX_CHROME);
  if (shouldTryOpenChromiumWithAppleScript) {
    const supportedChromiumBrowsers = [
      "Google Chrome Canary",
      "Google Chrome Dev",
      "Google Chrome Beta",
      "Google Chrome",
      "Microsoft Edge",
      "Brave Browser",
      "Vivaldi",
      "Chromium"
    ];
    for (const chromiumBrowser of supportedChromiumBrowsers) {
      try {
        execSync(`ps cax | grep "${chromiumBrowser}"`);
        const pathToApplescript = join6(
          resolvePackageDir("storybook"),
          "assets",
          "server",
          "openBrowser.applescript"
        );
        const command = `osascript "${pathToApplescript}" "`.concat(encodeURI(url), '" "').concat(
          process.env.OPEN_MATCH_HOST_ONLY === "true" ? encodeURI(new URL(url).origin) : encodeURI(url),
          '" "'
        ).concat(chromiumBrowser, '"');
        execSync(command, {
          cwd: __dirname
        });
        return true;
      } catch (err) {
      }
    }
  }
  if (process.platform === "darwin" && browser === "open") {
    browser = void 0;
  }
  if (typeof browser === "string" && args.length > 0) {
    browser = [browser].concat(args);
  }
  try {
    const options = { app: browser, wait: false, url: true };
    open_default(url, options).catch(() => {
    });
    return true;
  } catch (err) {
    return false;
  }
}
__name(startBrowserProcess, "startBrowserProcess");
function openBrowser(url) {
  const { action, value, args } = getBrowserEnv();
  switch (action) {
    case Actions.NONE: {
      return false;
    }
    case Actions.SCRIPT: {
      if (!value) {
        throw new Error("BROWSER environment variable is not set.");
      }
      return executeNodeScript(value, url);
    }
    case Actions.BROWSER: {
      return startBrowserProcess(value, url, args);
    }
    default: {
      throw new Error("Not implemented.");
    }
  }
}
__name(openBrowser, "openBrowser");

// src/core-server/utils/open-browser/open-in-browser.ts
async function openInBrowser(address) {
  let errorOccured = false;
  try {
    await openBrowser(address);
  } catch (error) {
    errorOccured = true;
  }
  try {
    if (errorOccured) {
      await open_default(address);
      errorOccured = false;
    }
  } catch (error) {
    errorOccured = true;
  }
  if (errorOccured) {
    logger5.error(import_ts_dedent4.dedent`
        Could not open ${address} inside a browser. If you're running this command inside a
        docker container or on a CI, you need to pass the '--ci' flag to prevent opening a
        browser by default.
      `);
  }
}
__name(openInBrowser, "openInBrowser");

// src/core-server/utils/server-address.ts
var import_detect_port = __toESM(require_detect_port2(), 1);
import os2 from "node:os";
import { logger as logger6 } from "storybook/internal/node-logger";
function getServerAddresses(port, host, proto, initialPath) {
  const address = new URL(`${proto}://localhost:${port}/`);
  const networkAddress = new URL(`${proto}://${host || getLocalIp()}:${port}/`);
  if (initialPath) {
    const searchParams = `?path=${decodeURIComponent(
      initialPath.startsWith("/") ? initialPath : `/${initialPath}`
    )}`;
    address.search = searchParams;
    networkAddress.search = searchParams;
  }
  return {
    address: address.href,
    networkAddress: networkAddress.href
  };
}
__name(getServerAddresses, "getServerAddresses");
var getServerPort = /* @__PURE__ */ __name((port, { exactPort } = {}) => (0, import_detect_port.default)(port).then((freePort) => {
  if (freePort !== port && exactPort) {
    process.exit(-1);
  }
  return freePort;
}).catch((error) => {
  logger6.error(error);
  process.exit(-1);
}), "getServerPort");
var getServerChannelUrl = /* @__PURE__ */ __name((port, { https: https2 }) => {
  return `${https2 ? "wss" : "ws"}://localhost:${port}/storybook-server-channel`;
}, "getServerChannelUrl");
var getLocalIp = /* @__PURE__ */ __name(() => {
  const allIps = Object.values(os2.networkInterfaces()).flat();
  const allFilteredIps = allIps.filter((ip) => ip && ip.family === "IPv4" && !ip.internal);
  return allFilteredIps.length ? allFilteredIps[0]?.address : "0.0.0.0";
}, "getLocalIp");

// src/core-server/utils/server-init.ts
import { readFile as readFile2 } from "node:fs/promises";
import { logger as logger7 } from "storybook/internal/node-logger";
import http2 from "http";
import https from "https";
async function getServer(options) {
  if (!options.https) {
    return http2.createServer();
  }
  if (!options.sslCert) {
    logger7.error("Error: --ssl-cert is required with --https");
    process.exit(-1);
  }
  if (!options.sslKey) {
    logger7.error("Error: --ssl-key is required with --https");
    process.exit(-1);
  }
  const sslOptions = {
    ca: await Promise.all((options.sslCa || []).map((ca) => readFile2(ca, { encoding: "utf8" }))),
    cert: await readFile2(options.sslCert, { encoding: "utf8" }),
    key: await readFile2(options.sslKey, { encoding: "utf8" })
  };
  return https.createServer(sslOptions);
}
__name(getServer, "getServer");

// src/core-server/dev-server.ts
async function storybookDevServer(options) {
  const [server, core2] = await Promise.all([getServer(options), options.presets.apply("core")]);
  const app = build_default2({ server });
  const serverChannel = await options.presets.apply(
    "experimental_serverChannel",
    getServerChannel(server)
  );
  let indexError;
  const initializedStoryIndexGenerator = getStoryIndexGenerator(app, options, serverChannel).catch((err) => {
    indexError = err;
    return void 0;
  });
  app.use(build_default({ level: 1 }));
  if (typeof options.extendServer === "function") {
    options.extendServer(server);
  }
  app.use(getAccessControlMiddleware(core2?.crossOriginIsolated ?? false));
  app.use(getCachingMiddleware());
  (await getMiddleware(options.configDir))(app);
  await options.presets.apply("experimental_devServer", app);
  const { port, host, initialPath } = options;
  invariant(port, "expected options to have a port");
  const proto = options.https ? "https" : "http";
  const { address, networkAddress } = getServerAddresses(port, host, proto, initialPath);
  options.networkAddress = networkAddress;
  if (!core2?.builder) {
    throw new MissingBuilderError2();
  }
  const resolvedPreviewBuilder = typeof core2?.builder === "string" ? core2.builder : core2?.builder?.name;
  const [previewBuilder, managerBuilder] = await Promise.all([
    getPreviewBuilder(resolvedPreviewBuilder),
    getManagerBuilder(),
    useStatics(app, options)
  ]);
  if (options.debugWebpack) {
    logConfig2("Preview webpack config", await previewBuilder.getConfig(options));
  }
  const managerResult = options.previewOnly ? void 0 : await managerBuilder.start({
    startTime: process.hrtime(),
    options,
    router: app,
    server,
    channel: serverChannel
  });
  let previewResult = await Promise.resolve();
  if (!options.ignorePreview) {
    if (!options.quiet) {
      logger8.info("=> Starting preview..");
    }
    previewResult = await previewBuilder.start({
      startTime: process.hrtime(),
      options,
      router: app,
      server,
      channel: serverChannel
    }).catch(async (e) => {
      logger8.error("=> Failed to build the preview");
      process.exitCode = 1;
      await managerBuilder?.bail().catch();
      await previewBuilder?.bail().catch();
      throw e;
    });
  }
  const listening = new Promise((resolve4, reject) => {
    server.once("error", reject);
    app.listen({ port, host }, resolve4);
  });
  await Promise.all([initializedStoryIndexGenerator, listening]).then(async ([indexGenerator]) => {
    if (indexGenerator && !options.ci && !options.smokeTest && options.open) {
      const url = host ? networkAddress : address;
      openInBrowser(options.previewOnly ? `${url}iframe.html?navigator=true` : url).catch(() => {
      });
    }
  });
  if (indexError) {
    await managerBuilder?.bail().catch();
    await previewBuilder?.bail().catch();
    throw indexError;
  }
  doTelemetry(app, core2, initializedStoryIndexGenerator, options);
  async function cancelTelemetry() {
    const payload = { eventType: "dev" };
    try {
      const generator = await initializedStoryIndexGenerator;
      const indexAndStats = await generator?.getIndexAndStats();
      if (indexAndStats) {
        Object.assign(payload, {
          storyIndex: summarizeIndex(indexAndStats.storyIndex),
          storyStats: indexAndStats.stats
        });
      }
    } catch (err) {
    }
    await telemetry("canceled", payload, { immediate: true });
    process.exit(0);
  }
  __name(cancelTelemetry, "cancelTelemetry");
  if (!core2?.disableTelemetry) {
    process.on("SIGINT", cancelTelemetry);
    process.on("SIGTERM", cancelTelemetry);
  }
  return { previewResult, managerResult, address, networkAddress };
}
__name(storybookDevServer, "storybookDevServer");

// src/core-server/utils/output-startup-information.ts
import { colors as colors2 } from "storybook/internal/node-logger";
var import_cli_table3 = __toESM(require_cli_table3(), 1);
var import_picocolors7 = __toESM(require_picocolors(), 1);
var import_pretty_hrtime = __toESM(require_pretty_hrtime(), 1);
var import_ts_dedent6 = __toESM(require_dist(), 1);

// src/core-server/utils/update-check.ts
var import_picocolors6 = __toESM(require_picocolors(), 1);
var import_ts_dedent5 = __toESM(require_dist(), 1);
import { cache } from "storybook/internal/common";
import { colors } from "storybook/internal/node-logger";
import semver from "semver";
var { STORYBOOK_VERSION_BASE = "https://storybook.js.org", CI } = process.env;
var updateCheck = /* @__PURE__ */ __name(async (version) => {
  let result;
  const time = Date.now();
  try {
    const fromCache = await cache.get("lastUpdateCheck", { success: false, time: 0 });
    if (time - 864e5 > fromCache.time && !CI) {
      const fromFetch = await Promise.race([
        fetch(`${STORYBOOK_VERSION_BASE}/versions.json?current=${version}`),
        // if fetch is too slow, we won't wait for it
        new Promise((res, rej) => global.setTimeout(rej, 1500))
      ]);
      const data = await fromFetch.json();
      result = { success: true, cached: false, data, time };
      await cache.set("lastUpdateCheck", result);
    } else {
      result = { ...fromCache, cached: true };
    }
  } catch (error) {
    result = { success: false, cached: false, error, time };
  }
  return result;
}, "updateCheck");
function createUpdateMessage(updateInfo, version) {
  let updateMessage;
  try {
    const isPrerelease = semver.prerelease(updateInfo.data.latest.version);
    const upgradeCommand = `npx storybook@${isPrerelease ? "next" : "latest"} upgrade`;
    updateMessage = updateInfo.success && semver.lt(version, updateInfo.data.latest.version) ? import_ts_dedent5.dedent`
          ${colors.orange(
      `A new version (${import_picocolors6.default.bold(updateInfo.data.latest.version)}) is available!`
    )}

          ${import_picocolors6.default.gray("Upgrade now:")} ${colors.green(upgradeCommand)}

          ${import_picocolors6.default.gray("Read full changelog:")} ${import_picocolors6.default.gray(
      import_picocolors6.default.underline("https://github.com/storybookjs/storybook/blob/main/CHANGELOG.md")
    )}
        ` : "";
  } catch (e) {
    updateMessage = "";
  }
  return updateMessage;
}
__name(createUpdateMessage, "createUpdateMessage");

// src/core-server/utils/output-startup-information.ts
function outputStartupInformation(options) {
  const { updateInfo, version, name, address, networkAddress, managerTotalTime, previewTotalTime } = options;
  const updateMessage = createUpdateMessage(updateInfo, version);
  const serveMessage = new import_cli_table3.default({
    chars: {
      top: "",
      "top-mid": "",
      "top-left": "",
      "top-right": "",
      bottom: "",
      "bottom-mid": "",
      "bottom-left": "",
      "bottom-right": "",
      left: "",
      "left-mid": "",
      mid: "",
      "mid-mid": "",
      right: "",
      "right-mid": "",
      middle: ""
    },
    // @ts-expect-error (Converted from ts-ignore)
    paddingLeft: 0,
    paddingRight: 0,
    paddingTop: 0,
    paddingBottom: 0
  });
  serveMessage.push(
    ["Local:", import_picocolors7.default.cyan(address)],
    ["On your network:", import_picocolors7.default.cyan(networkAddress)]
  );
  const timeStatement = [
    managerTotalTime && `${import_picocolors7.default.underline((0, import_pretty_hrtime.default)(managerTotalTime))} for manager`,
    previewTotalTime && `${import_picocolors7.default.underline((0, import_pretty_hrtime.default)(previewTotalTime))} for preview`
  ].filter(Boolean).join(" and ");
  console.log(
    boxen(
      import_ts_dedent6.dedent`
          ${colors2.green(
        `Storybook ${import_picocolors7.default.bold(version)} for ${import_picocolors7.default.bold(name)} started`
      )}
          ${import_picocolors7.default.gray(timeStatement)}

          ${serveMessage.toString()}${updateMessage ? `

${updateMessage}` : ""}
        `,
      { borderStyle: "round", padding: 1, borderColor: "#F1618C" }
    )
  );
}
__name(outputStartupInformation, "outputStartupInformation");

// src/core-server/utils/warnOnIncompatibleAddons.ts
import { logger as logger10 } from "storybook/internal/node-logger";

// ../lib/cli-storybook/src/doctor/getIncompatibleStorybookPackages.ts
var import_picocolors8 = __toESM(require_picocolors(), 1);
import { versions as storybookCorePackages } from "storybook/internal/common";
import { logger as logger9 } from "storybook/internal/node-logger";
import semver2 from "semver";

// ../lib/cli-storybook/src/automigrate/helpers/consolidated-packages.ts
var consolidatedPackages = {
  "@storybook/channels": "storybook/internal/channels",
  "@storybook/client-logger": "storybook/internal/client-logger",
  "@storybook/core-common": "storybook/internal/common",
  "@storybook/core-events": "storybook/internal/core-events",
  "@storybook/csf": "storybook/internal/csf",
  "@storybook/csf-tools": "storybook/internal/csf-tools",
  "@storybook/docs-tools": "storybook/internal/docs-tools",
  "@storybook/node-logger": "storybook/internal/node-logger",
  "@storybook/preview-api": "storybook/preview-api",
  "@storybook/router": "storybook/internal/router",
  "@storybook/telemetry": "storybook/internal/telemetry",
  "@storybook/theming": "storybook/theming",
  "@storybook/types": "storybook/internal/types",
  "@storybook/manager-api": "storybook/manager-api",
  "@storybook/manager": "storybook/internal/manager",
  "@storybook/preview": "storybook/internal/preview",
  "@storybook/core-server": "storybook/internal/core-server",
  "@storybook/builder-manager": "storybook/internal/builder-manager",
  "@storybook/components": "storybook/internal/components",
  "@storybook/test": "storybook/test",
  "@storybook/experimental-nextjs-vite": "@storybook/nextjs-vite",
  "@storybook/instrumenter": "storybook/internal/instrumenter",
  "@storybook/blocks": "@storybook/addon-docs/blocks"
};

// ../lib/cli-storybook/src/doctor/getIncompatibleStorybookPackages.ts
var checkPackageCompatibility = /* @__PURE__ */ __name(async (dependency, context) => {
  const { currentStorybookVersion, skipErrors, packageManager } = context;
  try {
    const dependencyPackageJson = await packageManager.getModulePackageJSON(dependency);
    if (dependencyPackageJson === null) {
      return { packageName: dependency };
    }
    const {
      version: packageVersion,
      name = dependency,
      dependencies,
      peerDependencies,
      homepage
    } = dependencyPackageJson;
    const packageStorybookVersion = Object.entries({
      ...dependencies,
      ...peerDependencies
    }).filter(
      ([dep]) => storybookCorePackages[dep] || consolidatedPackages[dep]
    ).map(([_, versionRange]) => versionRange).find((versionRange) => {
      return versionRange && // We can't check compatibility for 0.x packages, so we skip them
      !/^[~^]?0\./.test(versionRange) && semver2.validRange(versionRange) && !semver2.satisfies(currentStorybookVersion, versionRange);
    });
    const isCorePackage = storybookCorePackages[name];
    let availableUpdate;
    let availableCoreUpdate;
    if (isCorePackage && packageVersion && semver2.gt(currentStorybookVersion, packageVersion)) {
      availableUpdate = currentStorybookVersion;
    }
    if (isCorePackage && packageVersion && semver2.gt(packageVersion, currentStorybookVersion)) {
      availableCoreUpdate = packageVersion;
    }
    return {
      packageName: name,
      packageVersion,
      homepage,
      hasIncompatibleDependencies: packageStorybookVersion != null,
      packageStorybookVersion,
      availableUpdate,
      availableCoreUpdate
    };
  } catch (err) {
    if (!skipErrors) {
      logger9.log(
        `Error checking compatibility for ${dependency}, please report an issue:
` + String(err)
      );
    }
    return { packageName: dependency };
  }
}, "checkPackageCompatibility");
var getIncompatibleStorybookPackages = /* @__PURE__ */ __name(async (context) => {
  if (context.currentStorybookVersion.includes("0.0.0")) {
    return [];
  }
  const allDeps = context.packageManager.getAllDependencies();
  const storybookLikeDeps = Object.keys(allDeps).filter((dep) => dep.includes("storybook"));
  if (storybookLikeDeps.length === 0 && !context.skipErrors) {
    throw new Error("No Storybook dependencies found in the package.json");
  }
  return Promise.all(
    storybookLikeDeps.filter((dep) => !storybookCorePackages[dep]).map((dep) => checkPackageCompatibility(dep, context))
  );
}, "getIncompatibleStorybookPackages");
var getIncompatiblePackagesSummary = /* @__PURE__ */ __name((dependencyAnalysis, currentStorybookVersion) => {
  const summaryMessage = [];
  const incompatiblePackages = dependencyAnalysis.filter(
    (dep) => dep.hasIncompatibleDependencies
  );
  if (incompatiblePackages.length > 0) {
    summaryMessage.push(
      `You are currently using Storybook ${import_picocolors8.default.bold(
        currentStorybookVersion
      )} but you have packages which are incompatible with it:
`
    );
    incompatiblePackages.forEach(
      ({
        packageName: addonName,
        packageVersion: addonVersion,
        homepage,
        availableUpdate,
        packageStorybookVersion
      }) => {
        const packageDescription = `${addonName}@${addonVersion}`;
        const updateMessage = availableUpdate ? ` (${availableUpdate} available!)` : "";
        const dependsOnStorybook = packageStorybookVersion != null ? ` which depends on ${packageStorybookVersion}` : "";
        const packageRepo = homepage ? `
 Repo: ${homepage}` : "";
        summaryMessage.push(
          `- ${packageDescription}${updateMessage}${dependsOnStorybook}${packageRepo}`
        );
      }
    );
    summaryMessage.push(
      "\nPlease consider updating your packages or contacting the maintainers for compatibility details.",
      "\nFor more on Storybook 9 compatibility, see the linked GitHub issue:",
      "https://github.com/storybookjs/storybook/issues/30944"
    );
    if (incompatiblePackages.some((dep) => dep.availableCoreUpdate)) {
      summaryMessage.push(
        "\n",
        `The version of ${import_picocolors8.default.blue(`storybook@${currentStorybookVersion}`)} is behind the following core packages:`,
        `${incompatiblePackages.filter((dep) => dep.availableCoreUpdate).map(
          ({ packageName, packageVersion }) => `- ${import_picocolors8.default.blue(`${packageName}@${packageVersion}`)}`
        ).join("\n")}`,
        "\n",
        `Upgrade Storybook with:`,
        import_picocolors8.default.blue("npx storybook@latest upgrade")
      );
    }
  }
  return summaryMessage.join("\n");
}, "getIncompatiblePackagesSummary");

// src/core-server/utils/warnOnIncompatibleAddons.ts
var warnOnIncompatibleAddons = /* @__PURE__ */ __name(async (currentStorybookVersion, packageManager) => {
  const incompatiblePackagesList = await getIncompatibleStorybookPackages({
    skipUpgradeCheck: true,
    skipErrors: true,
    currentStorybookVersion,
    packageManager
  });
  const incompatiblePackagesMessage = getIncompatiblePackagesSummary(
    incompatiblePackagesList,
    currentStorybookVersion
  );
  if (incompatiblePackagesMessage) {
    logger10.warn(incompatiblePackagesMessage);
  }
}, "warnOnIncompatibleAddons");

// src/core-server/utils/warnWhenUsingArgTypesRegex.ts
var import_picocolors9 = __toESM(require_picocolors(), 1);
var import_ts_dedent7 = __toESM(require_dist(), 1);
import { readFile as readFile3 } from "node:fs/promises";
import { core } from "storybook/internal/babel";
import { babelParse } from "storybook/internal/csf-tools";
async function warnWhenUsingArgTypesRegex(previewConfigPath, config) {
  const previewContent = previewConfigPath ? await readFile3(previewConfigPath, { encoding: "utf8" }) : "";
  const hasVisualTestAddon = config?.addons?.some(
    (it) => typeof it === "string" ? it === "@chromatic-com/storybook" : it.name === "@chromatic-com/storybook"
  ) ?? false;
  if (hasVisualTestAddon && previewConfigPath && previewContent.includes("argTypesRegex")) {
    const file = new core.File(
      { filename: previewConfigPath },
      { code: previewContent, ast: babelParse(previewContent) }
    );
    file.path.traverse({
      Identifier: /* @__PURE__ */ __name((path2) => {
        if (path2.node.name === "argTypesRegex") {
          const message = import_ts_dedent7.dedent`
            ${import_picocolors9.default.bold("Attention")}: We've detected that you're using ${import_picocolors9.default.cyan(
            "actions.argTypesRegex"
          )} together with the visual test addon:
            
            ${path2.buildCodeFrameError(previewConfigPath).message}
            
            We recommend removing the ${import_picocolors9.default.cyan(
            "argTypesRegex"
          )} and assigning explicit action with the ${import_picocolors9.default.cyan(
            "fn"
          )} function from ${import_picocolors9.default.cyan("storybook/test")} instead:
            https://storybook.js.org/docs/essentials/actions#via-storybooktest-fn-spy-function
            
            The build used by the addon for snapshot testing doesn't take the regex into account, which can cause hard to debug problems when a snapshot depends on the presence of action props.
          `;
          console.warn(message);
        }
      }, "Identifier")
    });
  }
}
__name(warnWhenUsingArgTypesRegex, "warnWhenUsingArgTypesRegex");

// src/core-server/build-dev.ts
async function buildDevStandalone(options) {
  const { packageJson, versionUpdates } = options;
  let { storybookVersion, previewConfigPath } = options;
  const configDir = resolve(options.configDir);
  if (packageJson) {
    invariant(
      packageJson.version !== void 0,
      `Expected package.json#version to be defined in the "${packageJson.name}" package}`
    );
    storybookVersion = packageJson.version;
    previewConfigPath = getConfigInfo(configDir).previewConfigPath ?? void 0;
  } else {
    if (!storybookVersion) {
      storybookVersion = versions.storybook;
    }
  }
  const [port, versionCheck] = await Promise.all([
    getServerPort(options.port, { exactPort: options.exactPort }),
    versionUpdates ? updateCheck(storybookVersion) : Promise.resolve({ success: false, cached: false, data: {}, time: Date.now() })
  ]);
  if (!options.ci && !options.smokeTest && options.port != null && port !== options.port) {
    const { shouldChangePort } = await (0, import_prompts.default)({
      type: "confirm",
      initial: true,
      name: "shouldChangePort",
      message: `Port ${options.port} is not available. Would you like to run Storybook on port ${port} instead?`
    });
    if (!shouldChangePort) {
      process.exit(1);
    }
  }
  const cacheKey = oneWayHash(relative(getProjectRoot2(), configDir));
  const cacheOutputDir = resolvePathInStorybookCache("public", cacheKey);
  let outputDir = resolve(options.outputDir || cacheOutputDir);
  if (options.smokeTest) {
    outputDir = cacheOutputDir;
  }
  options.port = port;
  options.versionCheck = versionCheck;
  options.configType = "DEVELOPMENT";
  options.configDir = configDir;
  options.cacheKey = cacheKey;
  options.outputDir = outputDir;
  options.serverChannelUrl = getServerChannelUrl(port, options);
  options.pnp = await detectPnp();
  if (options.pnp) {
    deprecate(import_ts_dedent8.dedent`
      As of Storybook 10.0, PnP is deprecated.
      If you are using PnP, you can continue to use Storybook 10.0, but we recommend migrating to a different package manager or linker-mode.

      In future versions, PnP compatibility will be removed.
    `);
  }
  const config = await loadMainConfig2(options);
  const { framework } = config;
  const corePresets = [];
  let frameworkName = typeof framework === "string" ? framework : framework?.name;
  if (!options.ignorePreview) {
    validateFrameworkName(frameworkName);
  }
  if (frameworkName) {
    corePresets.push(join(frameworkName, "preset"));
  }
  frameworkName = frameworkName || "custom";
  const packageManager = JsPackageManagerFactory.getPackageManager({
    configDir: options.configDir
  });
  try {
    await warnOnIncompatibleAddons(storybookVersion, packageManager);
  } catch (e) {
    logger11.warn("Storybook failed to check addon compatibility");
    logger11.debug(`${e instanceof Error ? e.stack : String(e)}`);
  }
  try {
    await warnWhenUsingArgTypesRegex(previewConfigPath, config);
  } catch (e) {
  }
  let presets = await loadAllPresets2({
    corePresets,
    overridePresets: [
      import.meta.resolve("storybook/internal/core-server/presets/common-override-preset")
    ],
    ...options,
    isCritical: true
  });
  const { renderer, builder, disableTelemetry } = await presets.apply("core", {});
  if (!builder) {
    throw new MissingBuilderError3();
  }
  if (!options.disableTelemetry && !disableTelemetry) {
    if (versionCheck.success && !versionCheck.cached) {
      telemetry4("version-update");
    }
  }
  const resolvedPreviewBuilder = typeof builder === "string" ? builder : builder.name;
  const [previewBuilder, managerBuilder] = await Promise.all([
    getPreviewBuilder(resolvedPreviewBuilder),
    getManagerBuilder()
  ]);
  if (resolvedPreviewBuilder.includes("builder-vite")) {
    const deprecationMessage = (0, import_ts_dedent8.dedent)(`Using CommonJS in your main configuration file is deprecated with Vite.
              - Refer to the migration guide at https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#commonjs-with-vite-is-deprecated`);
    const mainJsPath = getInterpretedFile(
      resolve(options.configDir || ".storybook", "main")
    );
    if (/\.c[jt]s$/.test(mainJsPath)) {
      deprecate(deprecationMessage);
    }
    const mainJsContent = await readFile4(mainJsPath, { encoding: "utf8" });
    const CJS_CONTENT_REGEX = /\bmodule\.exports\b|\bexports[.[]|\brequire\s*\(|\bObject\.(?:defineProperty|defineProperties|assign)\s*\(\s*exports\b/;
    if (CJS_CONTENT_REGEX.test(mainJsContent)) {
      deprecate(deprecationMessage);
    }
  }
  const resolvedRenderer = renderer && resolveAddonName2(options.configDir, renderer, options);
  presets = await loadAllPresets2({
    corePresets: [
      join(resolvePackageDir("storybook"), "dist/core-server/presets/common-preset.js"),
      ...managerBuilder.corePresets || [],
      ...previewBuilder.corePresets || [],
      ...resolvedRenderer ? [resolvedRenderer] : [],
      ...corePresets
    ],
    overridePresets: [
      ...previewBuilder.overridePresets || [],
      import.meta.resolve("storybook/internal/core-server/presets/common-override-preset")
    ],
    ...options
  });
  const features = await presets.apply("features");
  global3.FEATURES = features;
  const fullOptions = {
    ...options,
    presets,
    features
  };
  const { address, networkAddress, managerResult, previewResult } = await buildOrThrow(
    async () => storybookDevServer(fullOptions)
  );
  const previewTotalTime = previewResult?.totalTime;
  const managerTotalTime = managerResult?.totalTime;
  const previewStats = previewResult?.stats;
  const managerStats = managerResult?.stats;
  const statsOption = options.webpackStatsJson || options.statsJson;
  if (statsOption) {
    const target = statsOption === true ? options.outputDir : statsOption;
    await outputStats(target, previewStats);
  }
  if (options.smokeTest) {
    const warnings = [];
    warnings.push(...managerStats?.toJson()?.warnings || []);
    try {
      warnings.push(...previewStats?.toJson()?.warnings || []);
    } catch (err) {
      if (err instanceof NoStatsForViteDevError) {
      } else {
        throw err;
      }
    }
    const problems = warnings.filter((warning) => !warning.message.includes(`export 'useInsertionEffect'`)).filter((warning) => !warning.message.includes(`compilation but it's unused`)).filter(
      (warning) => !warning.message.includes(`Conflicting values for 'process.env.NODE_ENV'`)
    );
    logger11.log(problems.map((p) => p.stack).join("\n"));
    process.exit(problems.length > 0 ? 1 : 0);
  } else {
    const name = frameworkName.split("@storybook/").length > 1 ? frameworkName.split("@storybook/")[1] : frameworkName;
    if (!options.quiet) {
      outputStartupInformation({
        updateInfo: versionCheck,
        version: storybookVersion,
        name,
        address,
        networkAddress,
        managerTotalTime,
        previewTotalTime
      });
    }
  }
  return { port, address, networkAddress };
}
__name(buildDevStandalone, "buildDevStandalone");

// src/core-server/build-index.ts
import { writeFile as writeFile3 } from "node:fs/promises";
import { normalizeStories as normalizeStories3 } from "storybook/internal/common";
import { logger as logger12 } from "storybook/internal/node-logger";

// src/core-server/load.ts
import {
  getProjectRoot as getProjectRoot3,
  loadAllPresets as loadAllPresets3,
  loadMainConfig as loadMainConfig3,
  resolveAddonName as resolveAddonName3,
  validateFrameworkName as validateFrameworkName2
} from "storybook/internal/common";
import { oneWayHash as oneWayHash2 } from "storybook/internal/telemetry";
import { global as global4 } from "@storybook/global";
async function loadStorybook(options) {
  const configDir = resolve(options.configDir);
  const cacheKey = oneWayHash2(relative(getProjectRoot3(), configDir));
  options.configType = "DEVELOPMENT";
  options.configDir = configDir;
  options.cacheKey = cacheKey;
  const config = await loadMainConfig3(options);
  const { framework } = config;
  const corePresets = [];
  let frameworkName = typeof framework === "string" ? framework : framework?.name;
  if (!options.ignorePreview) {
    validateFrameworkName2(frameworkName);
  }
  if (frameworkName) {
    corePresets.push(join(frameworkName, "preset"));
  }
  frameworkName = frameworkName || "custom";
  let presets = await loadAllPresets3({
    corePresets,
    overridePresets: [
      import.meta.resolve("storybook/internal/core-server/presets/common-override-preset")
    ],
    ...options,
    isCritical: true
  });
  const { renderer } = await presets.apply("core", {});
  const resolvedRenderer = renderer && resolveAddonName3(options.configDir, renderer, options);
  presets = await loadAllPresets3({
    corePresets: [
      join(resolvePackageDir("storybook"), "dist/core-server/presets/common-preset.js"),
      ...resolvedRenderer ? [resolvedRenderer] : [],
      ...corePresets
    ],
    overridePresets: [
      import.meta.resolve("storybook/internal/core-server/presets/common-override-preset")
    ],
    ...options
  });
  const features = await presets.apply("features");
  global4.FEATURES = features;
  return {
    ...options,
    presets,
    features
  };
}
__name(loadStorybook, "loadStorybook");

// src/core-server/build-index.ts
var buildIndex = /* @__PURE__ */ __name(async (options) => {
  const { presets } = await loadStorybook(options);
  const [indexers, stories, docsOptions] = await Promise.all([
    presets.apply("experimental_indexers", []),
    presets.apply("stories", []),
    presets.apply("docs")
  ]);
  const { configDir } = options;
  const workingDir = process.cwd();
  const directories = {
    configDir,
    workingDir
  };
  const normalizedStories = normalizeStories3(stories, directories);
  const generator = new StoryIndexGenerator(normalizedStories, {
    ...directories,
    indexers,
    docs: docsOptions,
    build: {}
  });
  await generator.initialize();
  return generator.getIndex();
}, "buildIndex");
var buildIndexStandalone = /* @__PURE__ */ __name(async (options) => {
  const index = await buildIndex(options);
  logger12.info(`Writing index to ${options.outputFile}`);
  await writeFile3(options.outputFile, JSON.stringify(index));
}, "buildIndexStandalone");

// src/core-server/standalone.ts
async function build(options = {}, frameworkOptions = {}) {
  const { mode = "dev" } = options;
  const { default: packageJson } = await import("storybook/package.json", { with: { type: "json" } });
  const commonOptions = {
    ...options,
    ...frameworkOptions,
    frameworkPresets: [
      ...options.frameworkPresets || [],
      ...frameworkOptions.frameworkPresets || []
    ],
    packageJson
  };
  if (mode === "dev") {
    return buildDevStandalone(commonOptions);
  }
  if (mode === "static") {
    return buildStaticStandalone(commonOptions);
  }
  if (mode === "index") {
    return buildIndexStandalone(commonOptions);
  }
  throw new Error(`'mode' parameter should be either 'dev', 'static', or 'index'`);
}
__name(build, "build");
var standalone_default = build;

// src/shared/universal-store/mock.ts
var import_ts_dedent9 = __toESM(require_dist(), 1);
import { Channel as Channel2 } from "storybook/internal/channels";
var MockUniversalStore = class _MockUniversalStore extends UniversalStore {
  static {
    __name(this, "MockUniversalStore");
  }
  constructor(options, testUtils) {
    UniversalStore.isInternalConstructing = true;
    super(
      { ...options, leader: true },
      { channel: new Channel2({}), environment: UniversalStore.Environment.MOCK }
    );
    UniversalStore.isInternalConstructing = false;
    if (typeof testUtils?.fn !== "function") {
      return;
    }
    this.testUtils = testUtils;
    this.getState = testUtils.fn(this.getState);
    this.setState = testUtils.fn(this.setState);
    this.subscribe = testUtils.fn(this.subscribe);
    this.onStateChange = testUtils.fn(this.onStateChange);
    this.send = testUtils.fn(this.send);
  }
  /** Create a mock universal store. This is just an alias for the constructor */
  static create(options, testUtils) {
    return new _MockUniversalStore(options, testUtils);
  }
  unsubscribeAll() {
    if (!this.testUtils) {
      throw new Error(
        import_ts_dedent9.dedent`Cannot call unsubscribeAll on a store that does not have testUtils.
        Please provide testUtils as the second argument when creating the store.`
      );
    }
    const callReturnedUnsubscribeFn = /* @__PURE__ */ __name((result) => {
      try {
        result.value();
      } catch (e) {
      }
    }, "callReturnedUnsubscribeFn");
    this.subscribe.mock?.results.forEach(callReturnedUnsubscribeFn);
    this.onStateChange.mock?.results.forEach(callReturnedUnsubscribeFn);
  }
};

// src/manager-errors.ts
var StatusTypeIdMismatchError2 = class extends StorybookError {
  constructor(data) {
    super({
      category: "MANAGER_API" /* MANAGER_API */,
      code: 1,
      message: `Status has typeId "${data.status.typeId}" but was added to store with typeId "${data.typeId}". Full status: ${JSON.stringify(
        data.status,
        null,
        2
      )}`
    });
    this.data = data;
  }
  static {
    __name(this, "StatusTypeIdMismatchError");
  }
};

// src/preview-errors.ts
var import_ts_dedent10 = __toESM(require_dist(), 1);
var StatusTypeIdMismatchError3 = class extends StorybookError {
  constructor(data) {
    super({
      category: "PREVIEW_API" /* PREVIEW_API */,
      code: 16,
      message: `Status has typeId "${data.status.typeId}" but was added to store with typeId "${data.typeId}". Full status: ${JSON.stringify(
        data.status,
        null,
        2
      )}`
    });
    this.data = data;
  }
  static {
    __name(this, "StatusTypeIdMismatchError");
  }
};

// src/shared/status-store/index.ts
var UNIVERSAL_STATUS_STORE_OPTIONS = {
  id: "storybook/status",
  leader: true,
  initialState: {}
};
var StatusStoreEventType = {
  SELECT: "select"
};
function createStatusStore({
  universalStatusStore: universalStatusStore2,
  useUniversalStore,
  environment
}) {
  const fullStatusStore2 = {
    getAll() {
      return universalStatusStore2.getState();
    },
    set(statuses) {
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const status of statuses) {
          const { storyId, typeId } = status;
          newState[storyId] = { ...newState[storyId] ?? {}, [typeId]: status };
        }
        return newState;
      });
    },
    onAllStatusChange(listener) {
      return universalStatusStore2.onStateChange((state, prevState) => {
        listener(state, prevState);
      });
    },
    onSelect(listener) {
      return universalStatusStore2.subscribe(StatusStoreEventType.SELECT, (event) => {
        listener(event.payload);
      });
    },
    selectStatuses: /* @__PURE__ */ __name((statuses) => {
      universalStatusStore2.send({ type: StatusStoreEventType.SELECT, payload: statuses });
    }, "selectStatuses"),
    unset(storyIds) {
      if (!storyIds) {
        universalStatusStore2.setState({});
        return;
      }
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const storyId of storyIds) {
          delete newState[storyId];
        }
        return newState;
      });
    },
    typeId: void 0
  };
  const getStatusStoreByTypeId2 = /* @__PURE__ */ __name((typeId) => ({
    getAll: fullStatusStore2.getAll,
    set(statuses) {
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const status of statuses) {
          const { storyId } = status;
          if (status.typeId !== typeId) {
            switch (environment) {
              case "server":
                throw new StatusTypeIdMismatchError({
                  status,
                  typeId
                });
              case "manager":
                throw new StatusTypeIdMismatchError2({
                  status,
                  typeId
                });
              case "preview":
              default:
                throw new StatusTypeIdMismatchError3({
                  status,
                  typeId
                });
            }
          }
          newState[storyId] = { ...newState[storyId] ?? {}, [typeId]: status };
        }
        return newState;
      });
    },
    onAllStatusChange: fullStatusStore2.onAllStatusChange,
    onSelect(listener) {
      return universalStatusStore2.subscribe(StatusStoreEventType.SELECT, (event) => {
        if (event.payload.some((status) => status.typeId === typeId)) {
          listener(event.payload);
        }
      });
    },
    unset(storyIds) {
      universalStatusStore2.setState((state) => {
        const newState = { ...state };
        for (const storyId in newState) {
          if (newState[storyId]?.[typeId] && (!storyIds || storyIds?.includes(storyId))) {
            const { [typeId]: omittedStatus, ...storyStatusesWithoutTypeId } = newState[storyId];
            newState[storyId] = storyStatusesWithoutTypeId;
          }
        }
        return newState;
      });
    },
    typeId
  }), "getStatusStoreByTypeId");
  if (!useUniversalStore) {
    return { getStatusStoreByTypeId: getStatusStoreByTypeId2, fullStatusStore: fullStatusStore2, universalStatusStore: universalStatusStore2 };
  }
  return {
    getStatusStoreByTypeId: getStatusStoreByTypeId2,
    fullStatusStore: fullStatusStore2,
    universalStatusStore: universalStatusStore2,
    useStatusStore: /* @__PURE__ */ __name((selector) => useUniversalStore(universalStatusStore2, selector)[0], "useStatusStore")
  };
}
__name(createStatusStore, "createStatusStore");

// src/core-server/stores/status.ts
var statusStore = createStatusStore({
  universalStatusStore: UniversalStore.create({
    ...UNIVERSAL_STATUS_STORE_OPTIONS,
    /*
      This is a temporary workaround, to ensure that the store is not created in the
      vitest sub-process in addon-vitest, even though it imports from core-server
      If it was created in the sub-process, it would try to connect to the leader in the dev server
      before it was ready.
      This will be fixed when we do the planned UniversalStore v0.2.
    */
    leader: !optionalEnvToBoolean(process.env.VITEST_CHILD_PROCESS)
  }),
  environment: "server"
});
var { fullStatusStore, getStatusStoreByTypeId, universalStatusStore } = statusStore;

// src/shared/test-provider-store/index.ts
var UNIVERSAL_TEST_PROVIDER_STORE_OPTIONS = {
  id: "storybook/test-provider",
  leader: true,
  initialState: {}
};
function createTestProviderStore({
  universalTestProviderStore: universalTestProviderStore2,
  useUniversalStore
}) {
  const baseStore = {
    settingsChanged: /* @__PURE__ */ __name(() => {
      universalTestProviderStore2.untilReady().then(() => {
        universalTestProviderStore2.send({ type: "settings-changed" });
      });
    }, "settingsChanged"),
    onRunAll: /* @__PURE__ */ __name((listener) => universalTestProviderStore2.subscribe("run-all", listener), "onRunAll"),
    onClearAll: /* @__PURE__ */ __name((listener) => universalTestProviderStore2.subscribe("clear-all", listener), "onClearAll")
  };
  const fullTestProviderStore2 = {
    ...baseStore,
    getFullState: universalTestProviderStore2.getState,
    setFullState: universalTestProviderStore2.setState,
    onSettingsChanged: /* @__PURE__ */ __name((listener) => universalTestProviderStore2.subscribe("settings-changed", listener), "onSettingsChanged"),
    runAll: /* @__PURE__ */ __name(async () => {
      await universalTestProviderStore2.untilReady();
      universalTestProviderStore2.send({ type: "run-all" });
    }, "runAll"),
    clearAll: /* @__PURE__ */ __name(async () => {
      await universalTestProviderStore2.untilReady();
      universalTestProviderStore2.send({ type: "clear-all" });
    }, "clearAll")
  };
  const getTestProviderStoreById2 = /* @__PURE__ */ __name((testProviderId) => {
    const getStateForTestProvider = /* @__PURE__ */ __name(() => universalTestProviderStore2.getState()[testProviderId] ?? "test-provider-state:pending", "getStateForTestProvider");
    const setStateForTestProvider = /* @__PURE__ */ __name((state) => {
      universalTestProviderStore2.untilReady().then(() => {
        universalTestProviderStore2.setState((currentState) => ({
          ...currentState,
          [testProviderId]: state
        }));
      });
    }, "setStateForTestProvider");
    return {
      ...baseStore,
      testProviderId,
      getState: getStateForTestProvider,
      setState: setStateForTestProvider,
      runWithState: /* @__PURE__ */ __name(async (callback) => {
        setStateForTestProvider("test-provider-state:running");
        try {
          await callback();
          setStateForTestProvider("test-provider-state:succeeded");
        } catch (error) {
          setStateForTestProvider("test-provider-state:crashed");
        }
      }, "runWithState")
    };
  }, "getTestProviderStoreById");
  if (useUniversalStore) {
    return {
      getTestProviderStoreById: getTestProviderStoreById2,
      fullTestProviderStore: fullTestProviderStore2,
      universalTestProviderStore: universalTestProviderStore2,
      useTestProviderStore: /* @__PURE__ */ __name((selector) => useUniversalStore(universalTestProviderStore2, selector)[0], "useTestProviderStore")
    };
  }
  return {
    getTestProviderStoreById: getTestProviderStoreById2,
    fullTestProviderStore: fullTestProviderStore2,
    universalTestProviderStore: universalTestProviderStore2
  };
}
__name(createTestProviderStore, "createTestProviderStore");

// src/core-server/stores/test-provider.ts
var testProviderStore = createTestProviderStore({
  universalTestProviderStore: UniversalStore.create({
    ...UNIVERSAL_TEST_PROVIDER_STORE_OPTIONS,
    /*
            This is a temporary workaround, to ensure that the store is not created in the
            vitest sub-process in addon-vitest, even though it imports from core-server
            If it was created in the sub-process, it would try to connect to the leader in the dev server
            before it was ready.
            This will be fixed when we do the planned UniversalStore v0.2.
          */
    leader: !optionalEnvToBoolean(process.env.VITEST_CHILD_PROCESS)
  })
});
var { fullTestProviderStore, getTestProviderStoreById, universalTestProviderStore } = testProviderStore;
export {
  StoryIndexGenerator,
  standalone_default as build,
  buildDevStandalone,
  buildIndex,
  buildIndexStandalone,
  buildStaticStandalone,
  MockUniversalStore as experimental_MockUniversalStore,
  UniversalStore as experimental_UniversalStore,
  getStatusStoreByTypeId as experimental_getStatusStore,
  getTestProviderStoreById as experimental_getTestProviderStore,
  loadStorybook as experimental_loadStorybook,
  getErrorLevel,
  getPreviewBodyTemplate,
  getPreviewHeadTemplate,
  fullStatusStore as internal_fullStatusStore,
  fullTestProviderStore as internal_fullTestProviderStore,
  universalStatusStore as internal_universalStatusStore,
  universalTestProviderStore as internal_universalTestProviderStore,
  mapStaticDir,
  sendTelemetryError,
  withTelemetry
};
