import {
  ActionBar,
  ScrollArea,
  createCopyToClipboardFunction
} from "../_browser-chunks/chunk-RNE2IUTB.js";
import {
  WithToolTipState
} from "../_browser-chunks/chunk-BOOOPFZF.js";
import {
  _objectWithoutPropertiesLoose
} from "../_browser-chunks/chunk-VAMFPZY3.js";
import {
  curriedDarken$1,
  curriedLighten$1,
  curriedTransparentize$1,
  rgba
} from "../_browser-chunks/chunk-OBXWFEPB.js";
import {
  _extends
} from "../_browser-chunks/chunk-MH6AXFXB.js";
import {
  isTestEnvironment
} from "../_browser-chunks/chunk-LYCSRYYR.js";
import {
  require_memoizerific
} from "../_browser-chunks/chunk-NVV6MIOE.js";
import {
  __export,
  __name,
  __toESM
} from "../_browser-chunks/chunk-MM7DTO55.js";

// src/components/index.ts
import { createElement as createElement9, forwardRef as forwardRef17 } from "react";

// src/components/components/typography/components.tsx
import React4 from "react";

// src/components/components/typography/DocumentFormatting.tsx
var nameSpaceClassNames = /* @__PURE__ */ __name(({ ...props }, key) => {
  const classes = [props.class, props.className];
  delete props.class;
  props.className = ["sbdocs", `sbdocs-${key}`, ...classes].filter(Boolean).join(" ");
  return props;
}, "nameSpaceClassNames");

// src/components/components/typography/ResetWrapper.tsx
import { styled } from "storybook/theming";

// src/components/components/typography/lib/common.tsx
var headerCommon = /* @__PURE__ */ __name(({ theme }) => ({
  margin: "20px 0 8px",
  padding: 0,
  cursor: "text",
  position: "relative",
  color: theme.color.defaultText,
  "&:first-of-type": {
    marginTop: 0,
    paddingTop: 0
  },
  "&:hover a.anchor": {
    textDecoration: "none"
  },
  "& tt, & code": {
    fontSize: "inherit"
  }
}), "headerCommon");
var codeCommon = /* @__PURE__ */ __name(({ theme }) => ({
  lineHeight: 1,
  margin: "0 2px",
  padding: "3px 5px",
  whiteSpace: "nowrap",
  borderRadius: 3,
  fontSize: theme.typography.size.s2 - 1,
  border: theme.base === "light" ? `1px solid ${theme.color.mediumlight}` : `1px solid ${theme.color.darker}`,
  color: theme.base === "light" ? curriedTransparentize$1(0.1, theme.color.defaultText) : curriedTransparentize$1(0.3, theme.color.defaultText),
  backgroundColor: theme.base === "light" ? theme.color.lighter : theme.color.border
}), "codeCommon");
var withReset = /* @__PURE__ */ __name(({ theme }) => ({
  fontFamily: theme.typography.fonts.base,
  fontSize: theme.typography.size.s3,
  margin: 0,
  WebkitFontSmoothing: "antialiased",
  MozOsxFontSmoothing: "grayscale",
  WebkitTapHighlightColor: "rgba(0, 0, 0, 0)",
  WebkitOverflowScrolling: "touch"
}), "withReset");
var withMargin = {
  margin: "16px 0"
};

// src/components/components/typography/ResetWrapper.tsx
var ResetWrapper = styled.div(withReset);

// src/components/components/typography/elements/A.tsx
import { styled as styled2 } from "storybook/theming";

// src/components/components/typography/elements/Link.tsx
import React from "react";
var Link = /* @__PURE__ */ __name(({
  href: input = "",
  ...props
}) => {
  const isStorybookPath = /^\//.test(input);
  const href = isStorybookPath ? `./?path=${input}` : input;
  const isAnchorUrl = /^#.*/.test(input);
  const target = isAnchorUrl ? "_self" : "_top";
  return React.createElement("a", { href, target, ...props });
}, "Link");

// src/components/components/typography/elements/A.tsx
var A = styled2(Link)(withReset, ({ theme }) => ({
  fontSize: "inherit",
  lineHeight: "24px",
  color: theme.color.secondary,
  textDecoration: "none",
  "&.absent": {
    color: "#cc0000"
  },
  "&.anchor": {
    display: "block",
    paddingLeft: 30,
    marginLeft: -30,
    cursor: "pointer",
    position: "absolute",
    top: 0,
    left: 0,
    bottom: 0
  }
}));

// src/components/components/typography/elements/Blockquote.tsx
import { styled as styled3 } from "storybook/theming";
var Blockquote = styled3.blockquote(withReset, withMargin, ({ theme }) => ({
  borderLeft: `4px solid ${theme.color.medium}`,
  padding: "0 15px",
  color: theme.color.dark,
  "& > :first-of-type": {
    marginTop: 0
  },
  "& > :last-child": {
    marginBottom: 0
  }
}));

// src/components/components/typography/elements/Code.tsx
import React3, { Children } from "react";
import { styled as styled4 } from "storybook/theming";

// src/components/components/syntaxhighlighter/lazy-syntaxhighlighter.tsx
import React2, { Suspense, lazy } from "react";
var languages = [];
var Comp = null;
var LazySyntaxHighlighter = lazy(async () => {
  const { SyntaxHighlighter: SyntaxHighlighter2 } = await import("../_browser-chunks/syntaxhighlighter-CAVLW7PM.js");
  if (languages.length > 0) {
    languages.forEach((args) => {
      SyntaxHighlighter2.registerLanguage(...args);
    });
    languages = [];
  }
  if (Comp === null) {
    Comp = SyntaxHighlighter2;
  }
  return {
    default: /* @__PURE__ */ __name((props) => React2.createElement(SyntaxHighlighter2, { ...props }), "default")
  };
});
var LazySyntaxHighlighterWithFormatter = lazy(async () => {
  const [{ SyntaxHighlighter: SyntaxHighlighter2 }, { formatter }] = await Promise.all([
    import("../_browser-chunks/syntaxhighlighter-CAVLW7PM.js"),
    import("../_browser-chunks/formatter-OMEEQ6HG.js")
  ]);
  if (languages.length > 0) {
    languages.forEach((args) => {
      SyntaxHighlighter2.registerLanguage(...args);
    });
    languages = [];
  }
  if (Comp === null) {
    Comp = SyntaxHighlighter2;
  }
  return {
    default: /* @__PURE__ */ __name((props) => React2.createElement(SyntaxHighlighter2, { ...props, formatter }), "default")
  };
});
var SyntaxHighlighter = /* @__PURE__ */ __name((props) => React2.createElement(Suspense, { fallback: React2.createElement("div", null) }, props.format !== false ? React2.createElement(LazySyntaxHighlighterWithFormatter, { ...props }) : React2.createElement(LazySyntaxHighlighter, { ...props })), "SyntaxHighlighter");
SyntaxHighlighter.registerLanguage = (...args) => {
  if (Comp !== null) {
    Comp.registerLanguage(...args);
    return;
  }
  languages.push(args);
};

// src/components/components/typography/lib/isReactChildString.tsx
var isReactChildString = /* @__PURE__ */ __name((child) => typeof child === "string", "isReactChildString");

// src/components/components/typography/elements/Code.tsx
var isInlineCodeRegex = /[\n\r]/g;
var DefaultCodeBlock = styled4.code(
  ({ theme }) => ({
    // from reset
    fontFamily: theme.typography.fonts.mono,
    WebkitFontSmoothing: "antialiased",
    MozOsxFontSmoothing: "grayscale",
    display: "inline-block",
    paddingLeft: 2,
    paddingRight: 2,
    verticalAlign: "baseline",
    color: "inherit"
  }),
  codeCommon
);
var StyledSyntaxHighlighter = styled4(SyntaxHighlighter)(({ theme }) => ({
  // DocBlocks-specific styling and overrides
  fontFamily: theme.typography.fonts.mono,
  fontSize: `${theme.typography.size.s2 - 1}px`,
  lineHeight: "19px",
  margin: "25px 0 40px",
  borderRadius: theme.appBorderRadius,
  boxShadow: theme.base === "light" ? "rgba(0, 0, 0, 0.10) 0 1px 3px 0" : "rgba(0, 0, 0, 0.20) 0 2px 5px 0",
  "pre.prismjs": {
    padding: 20,
    background: "inherit"
  }
}));
var Code = /* @__PURE__ */ __name(({
  className,
  children,
  ...props
}) => {
  const language = (className || "").match(/lang-(\S+)/);
  const childrenArray = Children.toArray(children);
  const isInlineCode = !childrenArray.filter(isReactChildString).some((child) => child.match(isInlineCodeRegex));
  if (isInlineCode) {
    return React3.createElement(DefaultCodeBlock, { ...props, className }, childrenArray);
  }
  return React3.createElement(
    StyledSyntaxHighlighter,
    {
      bordered: true,
      copyable: true,
      language: language?.[1] ?? "text",
      format: false,
      ...props
    },
    children
  );
}, "Code");

// src/components/components/typography/elements/DL.tsx
import { styled as styled5 } from "storybook/theming";
var DL = styled5.dl(withReset, withMargin, {
  padding: 0,
  "& dt": {
    fontSize: "14px",
    fontWeight: "bold",
    fontStyle: "italic",
    padding: 0,
    margin: "16px 0 4px"
  },
  "& dt:first-of-type": {
    padding: 0
  },
  "& dt > :first-of-type": {
    marginTop: 0
  },
  "& dt > :last-child": {
    marginBottom: 0
  },
  "& dd": {
    margin: "0 0 16px",
    padding: "0 15px"
  },
  "& dd > :first-of-type": {
    marginTop: 0
  },
  "& dd > :last-child": {
    marginBottom: 0
  }
});

// src/components/components/typography/elements/Div.tsx
import { styled as styled6 } from "storybook/theming";
var Div = styled6.div(withReset);

// src/components/components/typography/elements/H1.tsx
import { styled as styled7 } from "storybook/theming";
var H1 = styled7.h1(withReset, headerCommon, ({ theme }) => ({
  fontSize: `${theme.typography.size.l1}px`,
  fontWeight: theme.typography.weight.bold
}));

// src/components/components/typography/elements/H2.tsx
import { styled as styled8 } from "storybook/theming";
var H2 = styled8.h2(withReset, headerCommon, ({ theme }) => ({
  fontSize: `${theme.typography.size.m2}px`,
  paddingBottom: 4,
  borderBottom: `1px solid ${theme.appBorderColor}`
}));

// src/components/components/typography/elements/H3.tsx
import { styled as styled9 } from "storybook/theming";
var H3 = styled9.h3(withReset, headerCommon, ({ theme }) => ({
  fontSize: `${theme.typography.size.m1}px`
}));

// src/components/components/typography/elements/H4.tsx
import { styled as styled10 } from "storybook/theming";
var H4 = styled10.h4(withReset, headerCommon, ({ theme }) => ({
  fontSize: `${theme.typography.size.s3}px`
}));

// src/components/components/typography/elements/H5.tsx
import { styled as styled11 } from "storybook/theming";
var H5 = styled11.h5(withReset, headerCommon, ({ theme }) => ({
  fontSize: `${theme.typography.size.s2}px`
}));

// src/components/components/typography/elements/H6.tsx
import { styled as styled12 } from "storybook/theming";
var H6 = styled12.h6(withReset, headerCommon, ({ theme }) => ({
  fontSize: `${theme.typography.size.s2}px`,
  color: theme.color.dark
}));

// src/components/components/typography/elements/HR.tsx
import { styled as styled13 } from "storybook/theming";
var HR = styled13.hr(({ theme }) => ({
  border: "0 none",
  borderTop: `1px solid ${theme.appBorderColor}`,
  height: 4,
  padding: 0
}));

// src/components/components/typography/elements/Img.tsx
import { styled as styled14 } from "storybook/theming";
var Img = styled14.img({
  maxWidth: "100%"
});

// src/components/components/typography/elements/LI.tsx
import { styled as styled15 } from "storybook/theming";
var LI = styled15.li(withReset, ({ theme }) => ({
  fontSize: theme.typography.size.s2,
  color: theme.color.defaultText,
  lineHeight: "24px",
  "& + li": {
    marginTop: ".25em"
  },
  "& ul, & ol": {
    marginTop: ".25em",
    marginBottom: 0
  },
  "& code": codeCommon({ theme })
}));

// src/components/components/typography/elements/OL.tsx
import { styled as styled16 } from "storybook/theming";
var listCommon = {
  paddingLeft: 30,
  "& :first-of-type": {
    marginTop: 0
  },
  "& :last-child": {
    marginBottom: 0
  }
};
var OL = styled16.ol(withReset, withMargin, listCommon, {
  listStyle: "decimal"
});

// src/components/components/typography/elements/P.tsx
import { styled as styled17 } from "storybook/theming";
var P = styled17.p(withReset, withMargin, ({ theme }) => ({
  fontSize: theme.typography.size.s2,
  lineHeight: "24px",
  color: theme.color.defaultText,
  "& code": codeCommon({ theme })
}));

// src/components/components/typography/elements/Pre.tsx
import { styled as styled18 } from "storybook/theming";
var Pre = styled18.pre(withReset, withMargin, ({ theme }) => ({
  // reset
  fontFamily: theme.typography.fonts.mono,
  WebkitFontSmoothing: "antialiased",
  MozOsxFontSmoothing: "grayscale",
  lineHeight: "18px",
  padding: "11px 1rem",
  whiteSpace: "pre-wrap",
  color: "inherit",
  borderRadius: 3,
  margin: "1rem 0",
  "&:not(.prismjs)": {
    background: "transparent",
    border: "none",
    borderRadius: 0,
    padding: 0,
    margin: 0
  },
  "& pre, &.prismjs": {
    padding: 15,
    margin: 0,
    whiteSpace: "pre-wrap",
    color: "inherit",
    fontSize: "13px",
    lineHeight: "19px",
    code: {
      color: "inherit",
      fontSize: "inherit"
    }
  },
  "& code": {
    whiteSpace: "pre"
  },
  "& code, & tt": {
    border: "none"
  }
}));

// src/components/components/typography/elements/Span.tsx
import { styled as styled19 } from "storybook/theming";
var Span = styled19.span(withReset, ({ theme }) => ({
  "&.frame": {
    display: "block",
    overflow: "hidden",
    "& > span": {
      border: `1px solid ${theme.color.medium}`,
      display: "block",
      float: "left",
      overflow: "hidden",
      margin: "13px 0 0",
      padding: 7,
      width: "auto"
    },
    "& span img": {
      display: "block",
      float: "left"
    },
    "& span span": {
      clear: "both",
      color: theme.color.darkest,
      display: "block",
      padding: "5px 0 0"
    }
  },
  "&.align-center": {
    display: "block",
    overflow: "hidden",
    clear: "both",
    "& > span": {
      display: "block",
      overflow: "hidden",
      margin: "13px auto 0",
      textAlign: "center"
    },
    "& span img": {
      margin: "0 auto",
      textAlign: "center"
    }
  },
  "&.align-right": {
    display: "block",
    overflow: "hidden",
    clear: "both",
    "& > span": {
      display: "block",
      overflow: "hidden",
      margin: "13px 0 0",
      textAlign: "right"
    },
    "& span img": {
      margin: 0,
      textAlign: "right"
    }
  },
  "&.float-left": {
    display: "block",
    marginRight: 13,
    overflow: "hidden",
    float: "left",
    "& span": {
      margin: "13px 0 0"
    }
  },
  "&.float-right": {
    display: "block",
    marginLeft: 13,
    overflow: "hidden",
    float: "right",
    "& > span": {
      display: "block",
      overflow: "hidden",
      margin: "13px auto 0",
      textAlign: "right"
    }
  }
}));

// src/components/components/typography/elements/TT.tsx
import { styled as styled20 } from "storybook/theming";
var TT = styled20.title(codeCommon);

// src/components/components/typography/elements/Table.tsx
import { styled as styled21 } from "storybook/theming";
var Table = styled21.table(withReset, withMargin, ({ theme }) => ({
  fontSize: theme.typography.size.s2,
  lineHeight: "24px",
  padding: 0,
  borderCollapse: "collapse",
  "& tr": {
    borderTop: `1px solid ${theme.appBorderColor}`,
    backgroundColor: theme.appContentBg,
    margin: 0,
    padding: 0
  },
  "& tr:nth-of-type(2n)": {
    backgroundColor: theme.base === "dark" ? theme.color.darker : theme.color.lighter
  },
  "& tr th": {
    fontWeight: "bold",
    color: theme.color.defaultText,
    border: `1px solid ${theme.appBorderColor}`,
    margin: 0,
    padding: "6px 13px"
  },
  "& tr td": {
    border: `1px solid ${theme.appBorderColor}`,
    color: theme.color.defaultText,
    margin: 0,
    padding: "6px 13px"
  },
  "& tr th :first-of-type, & tr td :first-of-type": {
    marginTop: 0
  },
  "& tr th :last-child, & tr td :last-child": {
    marginBottom: 0
  }
}));

// src/components/components/typography/elements/UL.tsx
import { styled as styled22 } from "storybook/theming";
var listCommon2 = {
  paddingLeft: 30,
  "& :first-of-type": {
    marginTop: 0
  },
  "& :last-child": {
    marginBottom: 0
  }
};
var UL = styled22.ul(withReset, withMargin, listCommon2, { listStyle: "disc" });

// src/components/components/typography/components.tsx
var components = {
  h1: /* @__PURE__ */ __name((props) => React4.createElement(H1, { ...nameSpaceClassNames(props, "h1") }), "h1"),
  h2: /* @__PURE__ */ __name((props) => React4.createElement(H2, { ...nameSpaceClassNames(props, "h2") }), "h2"),
  h3: /* @__PURE__ */ __name((props) => React4.createElement(H3, { ...nameSpaceClassNames(props, "h3") }), "h3"),
  h4: /* @__PURE__ */ __name((props) => React4.createElement(H4, { ...nameSpaceClassNames(props, "h4") }), "h4"),
  h5: /* @__PURE__ */ __name((props) => React4.createElement(H5, { ...nameSpaceClassNames(props, "h5") }), "h5"),
  h6: /* @__PURE__ */ __name((props) => React4.createElement(H6, { ...nameSpaceClassNames(props, "h6") }), "h6"),
  pre: /* @__PURE__ */ __name((props) => React4.createElement(Pre, { ...nameSpaceClassNames(props, "pre") }), "pre"),
  a: /* @__PURE__ */ __name((props) => React4.createElement(A, { ...nameSpaceClassNames(props, "a") }), "a"),
  hr: /* @__PURE__ */ __name((props) => React4.createElement(HR, { ...nameSpaceClassNames(props, "hr") }), "hr"),
  dl: /* @__PURE__ */ __name((props) => React4.createElement(DL, { ...nameSpaceClassNames(props, "dl") }), "dl"),
  blockquote: /* @__PURE__ */ __name((props) => React4.createElement(Blockquote, { ...nameSpaceClassNames(props, "blockquote") }), "blockquote"),
  table: /* @__PURE__ */ __name((props) => React4.createElement(Table, { ...nameSpaceClassNames(props, "table") }), "table"),
  img: /* @__PURE__ */ __name((props) => React4.createElement(Img, { ...nameSpaceClassNames(props, "img") }), "img"),
  div: /* @__PURE__ */ __name((props) => React4.createElement(Div, { ...nameSpaceClassNames(props, "div") }), "div"),
  span: /* @__PURE__ */ __name((props) => React4.createElement(Span, { ...nameSpaceClassNames(props, "span") }), "span"),
  li: /* @__PURE__ */ __name((props) => React4.createElement(LI, { ...nameSpaceClassNames(props, "li") }), "li"),
  ul: /* @__PURE__ */ __name((props) => React4.createElement(UL, { ...nameSpaceClassNames(props, "ul") }), "ul"),
  ol: /* @__PURE__ */ __name((props) => React4.createElement(OL, { ...nameSpaceClassNames(props, "ol") }), "ol"),
  p: /* @__PURE__ */ __name((props) => React4.createElement(P, { ...nameSpaceClassNames(props, "p") }), "p"),
  code: /* @__PURE__ */ __name((props) => React4.createElement(Code, { ...nameSpaceClassNames(props, "code") }), "code"),
  tt: /* @__PURE__ */ __name((props) => React4.createElement(TT, { ...nameSpaceClassNames(props, "tt") }), "tt"),
  resetwrapper: /* @__PURE__ */ __name((props) => React4.createElement(ResetWrapper, { ...nameSpaceClassNames(props, "resetwrapper") }), "resetwrapper")
};

// src/components/components/Badge/Badge.tsx
import React5 from "react";
import { styled as styled23 } from "storybook/theming";
var BadgeWrapper = styled23.div(
  ({ theme, compact }) => ({
    display: "inline-flex",
    alignItems: "center",
    justifyContent: "center",
    fontSize: theme.typography.size.s1,
    fontWeight: theme.typography.weight.bold,
    lineHeight: "12px",
    minWidth: 20,
    borderRadius: 20,
    padding: compact ? "4px 7px" : "4px 10px"
  }),
  {
    svg: {
      height: 12,
      width: 12,
      marginRight: 4,
      marginTop: -2,
      path: {
        fill: "currentColor"
      }
    }
  },
  ({ theme, status }) => {
    switch (status) {
      case "critical": {
        return {
          color: theme.color.critical,
          background: theme.background.critical
        };
      }
      case "negative": {
        return {
          color: theme.color.negativeText,
          background: theme.background.negative,
          boxShadow: theme.base === "light" ? `inset 0 0 0 1px ${curriedTransparentize$1(0.9, theme.color.negativeText)}` : "none"
        };
      }
      case "warning": {
        return {
          color: theme.color.warningText,
          background: theme.background.warning,
          boxShadow: theme.base === "light" ? `inset 0 0 0 1px ${curriedTransparentize$1(0.9, theme.color.warningText)}` : "none"
        };
      }
      case "neutral": {
        return {
          color: theme.textMutedColor,
          background: theme.base === "light" ? theme.background.app : theme.barBg,
          boxShadow: `inset 0 0 0 1px ${curriedTransparentize$1(0.8, theme.textMutedColor)}`
        };
      }
      case "positive": {
        return {
          color: theme.color.positiveText,
          background: theme.background.positive,
          boxShadow: theme.base === "light" ? `inset 0 0 0 1px ${curriedTransparentize$1(0.9, theme.color.positiveText)}` : "none"
        };
      }
      case "active": {
        return {
          color: theme.color.secondary,
          background: theme.background.hoverable,
          boxShadow: `inset 0 0 0 1px ${curriedTransparentize$1(0.9, theme.color.secondary)}`
        };
      }
      default: {
        return {};
      }
    }
  }
);
var Badge = /* @__PURE__ */ __name(({ ...props }) => {
  return React5.createElement(BadgeWrapper, { ...props });
}, "Badge");

// src/components/components/typography/link/link.tsx
import React6 from "react";
import { ChevronRightIcon } from "@storybook/icons";
import { styled as styled24 } from "storybook/theming";
var LEFT_BUTTON = 0;
var isPlainLeftClick = /* @__PURE__ */ __name((e) => e.button === LEFT_BUTTON && !e.altKey && !e.ctrlKey && !e.metaKey && !e.shiftKey, "isPlainLeftClick");
var cancelled = /* @__PURE__ */ __name((e, cb) => {
  if (isPlainLeftClick(e)) {
    e.preventDefault();
    cb(e);
  }
}, "cancelled");
var LinkInner = styled24.span(
  ({ withArrow }) => withArrow ? {
    "> svg:last-of-type": {
      height: "0.7em",
      width: "0.7em",
      marginRight: 0,
      marginLeft: "0.25em",
      bottom: "auto",
      verticalAlign: "inherit"
    }
  } : {},
  ({ containsIcon }) => containsIcon ? {
    svg: {
      height: "1em",
      width: "1em",
      verticalAlign: "middle",
      position: "relative",
      bottom: 0,
      marginRight: 0
    }
  } : {}
);
var A2 = styled24.a(
  ({ theme }) => ({
    display: "inline-block",
    transition: "all 150ms ease-out",
    textDecoration: "none",
    color: theme.color.secondary,
    "&:hover, &:focus": {
      cursor: "pointer",
      color: curriedDarken$1(0.07, theme.color.secondary),
      "svg path:not([fill])": {
        fill: curriedDarken$1(0.07, theme.color.secondary)
      }
    },
    "&:active": {
      color: curriedDarken$1(0.1, theme.color.secondary),
      "svg path:not([fill])": {
        fill: curriedDarken$1(0.1, theme.color.secondary)
      }
    },
    svg: {
      display: "inline-block",
      height: "1em",
      width: "1em",
      verticalAlign: "text-top",
      position: "relative",
      bottom: "-0.125em",
      marginRight: "0.4em",
      "& path": {
        fill: theme.color.secondary
      }
    }
  }),
  ({ theme, secondary, tertiary }) => {
    let colors;
    if (secondary) {
      colors = [theme.textMutedColor, theme.color.dark, theme.color.darker];
    }
    if (tertiary) {
      colors = [theme.color.dark, theme.color.darkest, theme.textMutedColor];
    }
    return colors ? {
      color: colors[0],
      "svg path:not([fill])": {
        fill: colors[0]
      },
      "&:hover": {
        color: colors[1],
        "svg path:not([fill])": {
          fill: colors[1]
        }
      },
      "&:active": {
        color: colors[2],
        "svg path:not([fill])": {
          fill: colors[2]
        }
      }
    } : {};
  },
  ({ nochrome }) => nochrome ? {
    color: "inherit",
    "&:hover, &:active": {
      color: "inherit",
      textDecoration: "underline"
    }
  } : {},
  ({ theme, inverse }) => inverse ? {
    color: theme.color.lightest,
    ":not([fill])": {
      fill: theme.color.lightest
    },
    "&:hover": {
      color: theme.color.lighter,
      "svg path:not([fill])": {
        fill: theme.color.lighter
      }
    },
    "&:active": {
      color: theme.color.light,
      "svg path:not([fill])": {
        fill: theme.color.light
      }
    }
  } : {},
  ({ isButton: isButton2 }) => isButton2 ? {
    border: 0,
    borderRadius: 0,
    background: "none",
    padding: 0,
    fontSize: "inherit"
  } : {}
);
var Link2 = /* @__PURE__ */ __name(({
  cancel = true,
  children,
  onClick = void 0,
  withArrow = false,
  containsIcon = false,
  className = void 0,
  style = void 0,
  ...rest
}) => React6.createElement(
  A2,
  {
    ...rest,
    onClick: onClick && cancel ? (e) => cancelled(e, onClick) : onClick,
    className
  },
  React6.createElement(LinkInner, { withArrow, containsIcon }, children, withArrow && React6.createElement(ChevronRightIcon, null))
), "Link");

// src/components/components/typography/DocumentWrapper.tsx
import { styled as styled25 } from "storybook/theming";
var DocumentWrapper = styled25.div(({ theme }) => ({
  fontSize: `${theme.typography.size.s2}px`,
  lineHeight: "1.6",
  h1: {
    fontSize: `${theme.typography.size.l1}px`,
    fontWeight: theme.typography.weight.bold
  },
  h2: {
    fontSize: `${theme.typography.size.m2}px`,
    borderBottom: `1px solid ${theme.appBorderColor}`
  },
  h3: {
    fontSize: `${theme.typography.size.m1}px`
  },
  h4: {
    fontSize: `${theme.typography.size.s3}px`
  },
  h5: {
    fontSize: `${theme.typography.size.s2}px`
  },
  h6: {
    fontSize: `${theme.typography.size.s2}px`,
    color: theme.color.dark
  },
  "pre:not(.prismjs)": {
    background: "transparent",
    border: "none",
    borderRadius: 0,
    padding: 0,
    margin: 0
  },
  "pre pre, pre.prismjs": {
    padding: 15,
    margin: 0,
    whiteSpace: "pre-wrap",
    color: "inherit",
    fontSize: "13px",
    lineHeight: "19px"
  },
  "pre pre code, pre.prismjs code": {
    color: "inherit",
    fontSize: "inherit"
  },
  "pre code": {
    margin: 0,
    padding: 0,
    whiteSpace: "pre",
    border: "none",
    background: "transparent"
  },
  "pre code, pre tt": {
    backgroundColor: "transparent",
    border: "none"
  },
  /* GitHub inspired Markdown styles loosely from https://gist.github.com/tuzz/3331384 */
  "body > *:first-of-type": {
    marginTop: "0 !important"
  },
  "body > *:last-child": {
    marginBottom: "0 !important"
  },
  a: {
    color: theme.color.secondary,
    textDecoration: "none"
  },
  "a.absent": {
    color: "#cc0000"
  },
  "a.anchor": {
    display: "block",
    paddingLeft: 30,
    marginLeft: -30,
    cursor: "pointer",
    position: "absolute",
    top: 0,
    left: 0,
    bottom: 0
  },
  "h1, h2, h3, h4, h5, h6": {
    margin: "20px 0 10px",
    padding: 0,
    cursor: "text",
    position: "relative",
    "&:first-of-type": {
      marginTop: 0,
      paddingTop: 0
    },
    "&:hover a.anchor": {
      textDecoration: "none"
    },
    "& tt, & code": {
      fontSize: "inherit"
    }
  },
  "h1:first-of-type + h2": {
    marginTop: 0,
    paddingTop: 0
  },
  "p, blockquote, ul, ol, dl, li, table, pre": {
    margin: "15px 0"
  },
  hr: {
    border: "0 none",
    borderTop: `1px solid ${theme.appBorderColor}`,
    height: 4,
    padding: 0
  },
  "body > h1:first-of-type, body > h2:first-of-type, body > h3:first-of-type, body > h4:first-of-type, body > h5:first-of-type, body > h6:first-of-type": {
    marginTop: 0,
    paddingTop: 0
  },
  "body > h1:first-of-type + h2": {
    marginTop: 0,
    paddingTop: 0
  },
  "a:first-of-type h1, a:first-of-type h2, a:first-of-type h3, a:first-of-type h4, a:first-of-type h5, a:first-of-type h6": {
    marginTop: 0,
    paddingTop: 0
  },
  "h1 p, h2 p, h3 p, h4 p, h5 p, h6 p": {
    marginTop: 0
  },
  "li p.first": {
    display: "inline-block"
  },
  "ul, ol": {
    paddingLeft: 30,
    "& :first-of-type": {
      marginTop: 0
    },
    "& :last-child": {
      marginBottom: 0
    }
  },
  dl: {
    padding: 0
  },
  "dl dt": {
    fontSize: "14px",
    fontWeight: "bold",
    fontStyle: "italic",
    margin: "0 0 15px",
    padding: "0 15px",
    "&:first-of-type": {
      padding: 0
    },
    "& > :first-of-type": {
      marginTop: 0
    },
    "& > :last-child": {
      marginBottom: 0
    }
  },
  blockquote: {
    borderLeft: `4px solid ${theme.color.medium}`,
    padding: "0 15px",
    color: theme.color.dark,
    "& > :first-of-type": {
      marginTop: 0
    },
    "& > :last-child": {
      marginBottom: 0
    }
  },
  table: {
    padding: 0,
    borderCollapse: "collapse",
    "& tr": {
      borderTop: `1px solid ${theme.appBorderColor}`,
      backgroundColor: "white",
      margin: 0,
      padding: 0,
      "& th": {
        fontWeight: "bold",
        border: `1px solid ${theme.appBorderColor}`,
        textAlign: "left",
        margin: 0,
        padding: "6px 13px"
      },
      "& td": {
        border: `1px solid ${theme.appBorderColor}`,
        textAlign: "left",
        margin: 0,
        padding: "6px 13px"
      },
      "&:nth-of-type(2n)": {
        backgroundColor: theme.color.lighter
      },
      "& th :first-of-type, & td :first-of-type": {
        marginTop: 0
      },
      "& th :last-child, & td :last-child": {
        marginBottom: 0
      }
    }
  },
  img: {
    maxWidth: "100%"
  },
  "span.frame": {
    display: "block",
    overflow: "hidden",
    "& > span": {
      border: `1px solid ${theme.color.medium}`,
      display: "block",
      float: "left",
      overflow: "hidden",
      margin: "13px 0 0",
      padding: 7,
      width: "auto"
    },
    "& span img": {
      display: "block",
      float: "left"
    },
    "& span span": {
      clear: "both",
      color: theme.color.darkest,
      display: "block",
      padding: "5px 0 0"
    }
  },
  "span.align-center": {
    display: "block",
    overflow: "hidden",
    clear: "both",
    "& > span": {
      display: "block",
      overflow: "hidden",
      margin: "13px auto 0",
      textAlign: "center"
    },
    "& span img": {
      margin: "0 auto",
      textAlign: "center"
    }
  },
  "span.align-right": {
    display: "block",
    overflow: "hidden",
    clear: "both",
    "& > span": {
      display: "block",
      overflow: "hidden",
      margin: "13px 0 0",
      textAlign: "right"
    },
    "& span img": {
      margin: 0,
      textAlign: "right"
    }
  },
  "span.float-left": {
    display: "block",
    marginRight: 13,
    overflow: "hidden",
    float: "left",
    "& span": {
      margin: "13px 0 0"
    }
  },
  "span.float-right": {
    display: "block",
    marginLeft: 13,
    overflow: "hidden",
    float: "right",
    "& > span": {
      display: "block",
      overflow: "hidden",
      margin: "13px auto 0",
      textAlign: "right"
    }
  },
  "code, tt": {
    margin: "0 2px",
    padding: "0 5px",
    whiteSpace: "nowrap",
    border: `1px solid ${theme.color.mediumlight}`,
    backgroundColor: theme.color.lighter,
    borderRadius: 3,
    color: theme.base === "dark" ? theme.color.darkest : theme.color.dark
  }
}));

// src/components/components/Modal/Modal.tsx
import React39 from "react";

// ../node_modules/@radix-ui/react-dialog/dist/index.mjs
var dist_exports = {};
__export(dist_exports, {
  Close: () => Close,
  Content: () => Content,
  Description: () => Description,
  Dialog: () => Dialog,
  DialogClose: () => DialogClose,
  DialogContent: () => DialogContent,
  DialogDescription: () => DialogDescription,
  DialogOverlay: () => DialogOverlay,
  DialogPortal: () => DialogPortal,
  DialogTitle: () => DialogTitle,
  DialogTrigger: () => DialogTrigger,
  Overlay: () => Overlay,
  Portal: () => Portal2,
  Root: () => Root,
  Title: () => Title,
  Trigger: () => Trigger,
  WarningProvider: () => WarningProvider,
  createDialogScope: () => createDialogScope
});
import * as React34 from "react";

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/primitive/dist/index.mjs
var canUseDOM = !!(typeof window !== "undefined" && window.document && window.document.createElement);
function composeEventHandlers(originalEventHandler, ourEventHandler, { checkForDefaultPrevented = true } = {}) {
  return /* @__PURE__ */ __name(function handleEvent(event) {
    originalEventHandler?.(event);
    if (checkForDefaultPrevented === false || !event.defaultPrevented) {
      return ourEventHandler?.(event);
    }
  }, "handleEvent");
}
__name(composeEventHandlers, "composeEventHandlers");

// ../node_modules/@radix-ui/react-compose-refs/dist/index.mjs
import * as React7 from "react";
function setRef(ref, value) {
  if (typeof ref === "function") {
    return ref(value);
  } else if (ref !== null && ref !== void 0) {
    ref.current = value;
  }
}
__name(setRef, "setRef");
function composeRefs(...refs) {
  return (node) => {
    let hasCleanup = false;
    const cleanups = refs.map((ref) => {
      const cleanup = setRef(ref, node);
      if (!hasCleanup && typeof cleanup == "function") {
        hasCleanup = true;
      }
      return cleanup;
    });
    if (hasCleanup) {
      return () => {
        for (let i = 0; i < cleanups.length; i++) {
          const cleanup = cleanups[i];
          if (typeof cleanup == "function") {
            cleanup();
          } else {
            setRef(refs[i], null);
          }
        }
      };
    }
  };
}
__name(composeRefs, "composeRefs");
function useComposedRefs(...refs) {
  return React7.useCallback(composeRefs(...refs), refs);
}
__name(useComposedRefs, "useComposedRefs");

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/react-context/dist/index.mjs
import * as React8 from "react";
import { jsx } from "react/jsx-runtime";
function createContext2(rootComponentName, defaultContext) {
  const Context = React8.createContext(defaultContext);
  const Provider = /* @__PURE__ */ __name((props) => {
    const { children, ...context } = props;
    const value = React8.useMemo(() => context, Object.values(context));
    return jsx(Context.Provider, { value, children });
  }, "Provider");
  Provider.displayName = rootComponentName + "Provider";
  function useContext22(consumerName) {
    const context = React8.useContext(Context);
    if (context) return context;
    if (defaultContext !== void 0) return defaultContext;
    throw new Error(`\`${consumerName}\` must be used within \`${rootComponentName}\``);
  }
  __name(useContext22, "useContext2");
  return [Provider, useContext22];
}
__name(createContext2, "createContext2");
function createContextScope(scopeName, createContextScopeDeps = []) {
  let defaultContexts = [];
  function createContext32(rootComponentName, defaultContext) {
    const BaseContext = React8.createContext(defaultContext);
    const index3 = defaultContexts.length;
    defaultContexts = [...defaultContexts, defaultContext];
    const Provider = /* @__PURE__ */ __name((props) => {
      const { scope, children, ...context } = props;
      const Context = scope?.[scopeName]?.[index3] || BaseContext;
      const value = React8.useMemo(() => context, Object.values(context));
      return jsx(Context.Provider, { value, children });
    }, "Provider");
    Provider.displayName = rootComponentName + "Provider";
    function useContext22(consumerName, scope) {
      const Context = scope?.[scopeName]?.[index3] || BaseContext;
      const context = React8.useContext(Context);
      if (context) return context;
      if (defaultContext !== void 0) return defaultContext;
      throw new Error(`\`${consumerName}\` must be used within \`${rootComponentName}\``);
    }
    __name(useContext22, "useContext2");
    return [Provider, useContext22];
  }
  __name(createContext32, "createContext3");
  const createScope = /* @__PURE__ */ __name(() => {
    const scopeContexts = defaultContexts.map((defaultContext) => {
      return React8.createContext(defaultContext);
    });
    return /* @__PURE__ */ __name(function useScope(scope) {
      const contexts = scope?.[scopeName] || scopeContexts;
      return React8.useMemo(
        () => ({ [`__scope${scopeName}`]: { ...scope, [scopeName]: contexts } }),
        [scope, contexts]
      );
    }, "useScope");
  }, "createScope");
  createScope.scopeName = scopeName;
  return [createContext32, composeContextScopes(createScope, ...createContextScopeDeps)];
}
__name(createContextScope, "createContextScope");
function composeContextScopes(...scopes) {
  const baseScope = scopes[0];
  if (scopes.length === 1) return baseScope;
  const createScope = /* @__PURE__ */ __name(() => {
    const scopeHooks = scopes.map((createScope2) => ({
      useScope: createScope2(),
      scopeName: createScope2.scopeName
    }));
    return /* @__PURE__ */ __name(function useComposedScopes(overrideScopes) {
      const nextScopes = scopeHooks.reduce((nextScopes2, { useScope, scopeName }) => {
        const scopeProps = useScope(overrideScopes);
        const currentScope = scopeProps[`__scope${scopeName}`];
        return { ...nextScopes2, ...currentScope };
      }, {});
      return React8.useMemo(() => ({ [`__scope${baseScope.scopeName}`]: nextScopes }), [nextScopes]);
    }, "useComposedScopes");
  }, "createScope");
  createScope.scopeName = baseScope.scopeName;
  return createScope;
}
__name(composeContextScopes, "composeContextScopes");

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/react-id/dist/index.mjs
import * as React10 from "react";

// ../node_modules/@radix-ui/react-use-layout-effect/dist/index.mjs
import * as React9 from "react";
var useLayoutEffect2 = globalThis?.document ? React9.useLayoutEffect : () => {
};

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/react-id/dist/index.mjs
var useReactId = React10[" useId ".trim().toString()] || (() => void 0);
var count = 0;
function useId(deterministicId) {
  const [id, setId] = React10.useState(useReactId());
  useLayoutEffect2(() => {
    if (!deterministicId) setId((reactId) => reactId ?? String(count++));
  }, [deterministicId]);
  return deterministicId || (id ? `radix-${id}` : "");
}
__name(useId, "useId");

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/react-use-controllable-state/dist/index.mjs
import * as React12 from "react";
import * as React22 from "react";

// ../node_modules/@radix-ui/react-use-effect-event/dist/index.mjs
import * as React11 from "react";
var useReactEffectEvent = React11[" useEffectEvent ".trim().toString()];
var useReactInsertionEffect = React11[" useInsertionEffect ".trim().toString()];

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/react-use-controllable-state/dist/index.mjs
var useInsertionEffect = React12[" useInsertionEffect ".trim().toString()] || useLayoutEffect2;
function useControllableState({
  prop,
  defaultProp,
  onChange = /* @__PURE__ */ __name(() => {
  }, "onChange"),
  caller
}) {
  const [uncontrolledProp, setUncontrolledProp, onChangeRef] = useUncontrolledState({
    defaultProp,
    onChange
  });
  const isControlled = prop !== void 0;
  const value = isControlled ? prop : uncontrolledProp;
  if (true) {
    const isControlledRef = React12.useRef(prop !== void 0);
    React12.useEffect(() => {
      const wasControlled = isControlledRef.current;
      if (wasControlled !== isControlled) {
        const from = wasControlled ? "controlled" : "uncontrolled";
        const to = isControlled ? "controlled" : "uncontrolled";
        console.warn(
          `${caller} is changing from ${from} to ${to}. Components should not switch from controlled to uncontrolled (or vice versa). Decide between using a controlled or uncontrolled value for the lifetime of the component.`
        );
      }
      isControlledRef.current = isControlled;
    }, [isControlled, caller]);
  }
  const setValue = React12.useCallback(
    (nextValue) => {
      if (isControlled) {
        const value2 = isFunction(nextValue) ? nextValue(prop) : nextValue;
        if (value2 !== prop) {
          onChangeRef.current?.(value2);
        }
      } else {
        setUncontrolledProp(nextValue);
      }
    },
    [isControlled, prop, setUncontrolledProp, onChangeRef]
  );
  return [value, setValue];
}
__name(useControllableState, "useControllableState");
function useUncontrolledState({
  defaultProp,
  onChange
}) {
  const [value, setValue] = React12.useState(defaultProp);
  const prevValueRef = React12.useRef(value);
  const onChangeRef = React12.useRef(onChange);
  useInsertionEffect(() => {
    onChangeRef.current = onChange;
  }, [onChange]);
  React12.useEffect(() => {
    if (prevValueRef.current !== value) {
      onChangeRef.current?.(value);
      prevValueRef.current = value;
    }
  }, [value, prevValueRef]);
  return [value, setValue, onChangeRef];
}
__name(useUncontrolledState, "useUncontrolledState");
function isFunction(value) {
  return typeof value === "function";
}
__name(isFunction, "isFunction");
var SYNC_STATE = Symbol("RADIX:SYNC_STATE");

// ../node_modules/@radix-ui/react-dismissable-layer/dist/index.mjs
import * as React17 from "react";

// ../node_modules/@radix-ui/react-dismissable-layer/node_modules/@radix-ui/primitive/dist/index.mjs
var canUseDOM2 = !!(typeof window !== "undefined" && window.document && window.document.createElement);
function composeEventHandlers2(originalEventHandler, ourEventHandler, { checkForDefaultPrevented = true } = {}) {
  return /* @__PURE__ */ __name(function handleEvent(event) {
    originalEventHandler?.(event);
    if (checkForDefaultPrevented === false || !event.defaultPrevented) {
      return ourEventHandler?.(event);
    }
  }, "handleEvent");
}
__name(composeEventHandlers2, "composeEventHandlers");

// ../node_modules/@radix-ui/react-primitive/dist/index.mjs
import * as React14 from "react";
import * as ReactDOM from "react-dom";

// ../node_modules/@radix-ui/react-primitive/node_modules/@radix-ui/react-slot/dist/index.mjs
import * as React13 from "react";
import { Fragment as Fragment2, jsx as jsx2 } from "react/jsx-runtime";
function createSlot(ownerName) {
  const SlotClone = createSlotClone(ownerName);
  const Slot22 = React13.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    const childrenArray = React13.Children.toArray(children);
    const slottable = childrenArray.find(isSlottable);
    if (slottable) {
      const newElement = slottable.props.children;
      const newChildren = childrenArray.map((child) => {
        if (child === slottable) {
          if (React13.Children.count(newElement) > 1) return React13.Children.only(null);
          return React13.isValidElement(newElement) ? newElement.props.children : null;
        } else {
          return child;
        }
      });
      return jsx2(SlotClone, { ...slotProps, ref: forwardedRef, children: React13.isValidElement(newElement) ? React13.cloneElement(newElement, void 0, newChildren) : null });
    }
    return jsx2(SlotClone, { ...slotProps, ref: forwardedRef, children });
  });
  Slot22.displayName = `${ownerName}.Slot`;
  return Slot22;
}
__name(createSlot, "createSlot");
var Slot = createSlot("Slot");
function createSlotClone(ownerName) {
  const SlotClone = React13.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    if (React13.isValidElement(children)) {
      const childrenRef = getElementRef(children);
      const props2 = mergeProps(slotProps, children.props);
      if (children.type !== React13.Fragment) {
        props2.ref = forwardedRef ? composeRefs(forwardedRef, childrenRef) : childrenRef;
      }
      return React13.cloneElement(children, props2);
    }
    return React13.Children.count(children) > 1 ? React13.Children.only(null) : null;
  });
  SlotClone.displayName = `${ownerName}.SlotClone`;
  return SlotClone;
}
__name(createSlotClone, "createSlotClone");
var SLOTTABLE_IDENTIFIER = Symbol("radix.slottable");
function createSlottable(ownerName) {
  const Slottable22 = /* @__PURE__ */ __name(({ children }) => {
    return jsx2(Fragment2, { children });
  }, "Slottable2");
  Slottable22.displayName = `${ownerName}.Slottable`;
  Slottable22.__radixId = SLOTTABLE_IDENTIFIER;
  return Slottable22;
}
__name(createSlottable, "createSlottable");
var Slottable = createSlottable("Slottable");
function isSlottable(child) {
  return React13.isValidElement(child) && typeof child.type === "function" && "__radixId" in child.type && child.type.__radixId === SLOTTABLE_IDENTIFIER;
}
__name(isSlottable, "isSlottable");
function mergeProps(slotProps, childProps) {
  const overrideProps = { ...childProps };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      if (slotPropValue && childPropValue) {
        overrideProps[propName] = (...args) => {
          const result = childPropValue(...args);
          slotPropValue(...args);
          return result;
        };
      } else if (slotPropValue) {
        overrideProps[propName] = slotPropValue;
      }
    } else if (propName === "style") {
      overrideProps[propName] = { ...slotPropValue, ...childPropValue };
    } else if (propName === "className") {
      overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(" ");
    }
  }
  return { ...slotProps, ...overrideProps };
}
__name(mergeProps, "mergeProps");
function getElementRef(element) {
  let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
  let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.ref;
  }
  getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
  mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.props.ref;
  }
  return element.props.ref || element.ref;
}
__name(getElementRef, "getElementRef");

// ../node_modules/@radix-ui/react-primitive/dist/index.mjs
import { jsx as jsx3 } from "react/jsx-runtime";
var NODES = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "select",
  "span",
  "svg",
  "ul"
];
var Primitive = NODES.reduce((primitive, node) => {
  const Slot5 = createSlot(`Primitive.${node}`);
  const Node2 = React14.forwardRef((props, forwardedRef) => {
    const { asChild, ...primitiveProps } = props;
    const Comp2 = asChild ? Slot5 : node;
    if (typeof window !== "undefined") {
      window[Symbol.for("radix-ui")] = true;
    }
    return jsx3(Comp2, { ...primitiveProps, ref: forwardedRef });
  });
  Node2.displayName = `Primitive.${node}`;
  return { ...primitive, [node]: Node2 };
}, {});
function dispatchDiscreteCustomEvent(target, event) {
  if (target) ReactDOM.flushSync(() => target.dispatchEvent(event));
}
__name(dispatchDiscreteCustomEvent, "dispatchDiscreteCustomEvent");

// ../node_modules/@radix-ui/react-use-callback-ref/dist/index.mjs
import * as React15 from "react";
function useCallbackRef(callback) {
  const callbackRef = React15.useRef(callback);
  React15.useEffect(() => {
    callbackRef.current = callback;
  });
  return React15.useMemo(() => (...args) => callbackRef.current?.(...args), []);
}
__name(useCallbackRef, "useCallbackRef");

// ../node_modules/@radix-ui/react-use-escape-keydown/dist/index.mjs
import * as React16 from "react";
function useEscapeKeydown(onEscapeKeyDownProp, ownerDocument = globalThis?.document) {
  const onEscapeKeyDown = useCallbackRef(onEscapeKeyDownProp);
  React16.useEffect(() => {
    const handleKeyDown = /* @__PURE__ */ __name((event) => {
      if (event.key === "Escape") {
        onEscapeKeyDown(event);
      }
    }, "handleKeyDown");
    ownerDocument.addEventListener("keydown", handleKeyDown, { capture: true });
    return () => ownerDocument.removeEventListener("keydown", handleKeyDown, { capture: true });
  }, [onEscapeKeyDown, ownerDocument]);
}
__name(useEscapeKeydown, "useEscapeKeydown");

// ../node_modules/@radix-ui/react-dismissable-layer/dist/index.mjs
import { jsx as jsx4 } from "react/jsx-runtime";
var DISMISSABLE_LAYER_NAME = "DismissableLayer";
var CONTEXT_UPDATE = "dismissableLayer.update";
var POINTER_DOWN_OUTSIDE = "dismissableLayer.pointerDownOutside";
var FOCUS_OUTSIDE = "dismissableLayer.focusOutside";
var originalBodyPointerEvents;
var DismissableLayerContext = React17.createContext({
  layers: /* @__PURE__ */ new Set(),
  layersWithOutsidePointerEventsDisabled: /* @__PURE__ */ new Set(),
  branches: /* @__PURE__ */ new Set()
});
var DismissableLayer = React17.forwardRef(
  (props, forwardedRef) => {
    const {
      disableOutsidePointerEvents = false,
      onEscapeKeyDown,
      onPointerDownOutside,
      onFocusOutside,
      onInteractOutside,
      onDismiss,
      ...layerProps
    } = props;
    const context = React17.useContext(DismissableLayerContext);
    const [node, setNode] = React17.useState(null);
    const ownerDocument = node?.ownerDocument ?? globalThis?.document;
    const [, force] = React17.useState({});
    const composedRefs = useComposedRefs(forwardedRef, (node2) => setNode(node2));
    const layers = Array.from(context.layers);
    const [highestLayerWithOutsidePointerEventsDisabled] = [...context.layersWithOutsidePointerEventsDisabled].slice(-1);
    const highestLayerWithOutsidePointerEventsDisabledIndex = layers.indexOf(highestLayerWithOutsidePointerEventsDisabled);
    const index3 = node ? layers.indexOf(node) : -1;
    const isBodyPointerEventsDisabled = context.layersWithOutsidePointerEventsDisabled.size > 0;
    const isPointerEventsEnabled = index3 >= highestLayerWithOutsidePointerEventsDisabledIndex;
    const pointerDownOutside = usePointerDownOutside((event) => {
      const target = event.target;
      const isPointerDownOnBranch = [...context.branches].some((branch) => branch.contains(target));
      if (!isPointerEventsEnabled || isPointerDownOnBranch) return;
      onPointerDownOutside?.(event);
      onInteractOutside?.(event);
      if (!event.defaultPrevented) onDismiss?.();
    }, ownerDocument);
    const focusOutside = useFocusOutside((event) => {
      const target = event.target;
      const isFocusInBranch = [...context.branches].some((branch) => branch.contains(target));
      if (isFocusInBranch) return;
      onFocusOutside?.(event);
      onInteractOutside?.(event);
      if (!event.defaultPrevented) onDismiss?.();
    }, ownerDocument);
    useEscapeKeydown((event) => {
      const isHighestLayer = index3 === context.layers.size - 1;
      if (!isHighestLayer) return;
      onEscapeKeyDown?.(event);
      if (!event.defaultPrevented && onDismiss) {
        event.preventDefault();
        onDismiss();
      }
    }, ownerDocument);
    React17.useEffect(() => {
      if (!node) return;
      if (disableOutsidePointerEvents) {
        if (context.layersWithOutsidePointerEventsDisabled.size === 0) {
          originalBodyPointerEvents = ownerDocument.body.style.pointerEvents;
          ownerDocument.body.style.pointerEvents = "none";
        }
        context.layersWithOutsidePointerEventsDisabled.add(node);
      }
      context.layers.add(node);
      dispatchUpdate();
      return () => {
        if (disableOutsidePointerEvents && context.layersWithOutsidePointerEventsDisabled.size === 1) {
          ownerDocument.body.style.pointerEvents = originalBodyPointerEvents;
        }
      };
    }, [node, ownerDocument, disableOutsidePointerEvents, context]);
    React17.useEffect(() => {
      return () => {
        if (!node) return;
        context.layers.delete(node);
        context.layersWithOutsidePointerEventsDisabled.delete(node);
        dispatchUpdate();
      };
    }, [node, context]);
    React17.useEffect(() => {
      const handleUpdate = /* @__PURE__ */ __name(() => force({}), "handleUpdate");
      document.addEventListener(CONTEXT_UPDATE, handleUpdate);
      return () => document.removeEventListener(CONTEXT_UPDATE, handleUpdate);
    }, []);
    return jsx4(
      Primitive.div,
      {
        ...layerProps,
        ref: composedRefs,
        style: {
          pointerEvents: isBodyPointerEventsDisabled ? isPointerEventsEnabled ? "auto" : "none" : void 0,
          ...props.style
        },
        onFocusCapture: composeEventHandlers2(props.onFocusCapture, focusOutside.onFocusCapture),
        onBlurCapture: composeEventHandlers2(props.onBlurCapture, focusOutside.onBlurCapture),
        onPointerDownCapture: composeEventHandlers2(
          props.onPointerDownCapture,
          pointerDownOutside.onPointerDownCapture
        )
      }
    );
  }
);
DismissableLayer.displayName = DISMISSABLE_LAYER_NAME;
var BRANCH_NAME = "DismissableLayerBranch";
var DismissableLayerBranch = React17.forwardRef((props, forwardedRef) => {
  const context = React17.useContext(DismissableLayerContext);
  const ref = React17.useRef(null);
  const composedRefs = useComposedRefs(forwardedRef, ref);
  React17.useEffect(() => {
    const node = ref.current;
    if (node) {
      context.branches.add(node);
      return () => {
        context.branches.delete(node);
      };
    }
  }, [context.branches]);
  return jsx4(Primitive.div, { ...props, ref: composedRefs });
});
DismissableLayerBranch.displayName = BRANCH_NAME;
function usePointerDownOutside(onPointerDownOutside, ownerDocument = globalThis?.document) {
  const handlePointerDownOutside = useCallbackRef(onPointerDownOutside);
  const isPointerInsideReactTreeRef = React17.useRef(false);
  const handleClickRef = React17.useRef(() => {
  });
  React17.useEffect(() => {
    const handlePointerDown = /* @__PURE__ */ __name((event) => {
      if (event.target && !isPointerInsideReactTreeRef.current) {
        let handleAndDispatchPointerDownOutsideEvent2 = /* @__PURE__ */ __name(function() {
          handleAndDispatchCustomEvent(
            POINTER_DOWN_OUTSIDE,
            handlePointerDownOutside,
            eventDetail,
            { discrete: true }
          );
        }, "handleAndDispatchPointerDownOutsideEvent2");
        var handleAndDispatchPointerDownOutsideEvent = handleAndDispatchPointerDownOutsideEvent2;
        const eventDetail = { originalEvent: event };
        if (event.pointerType === "touch") {
          ownerDocument.removeEventListener("click", handleClickRef.current);
          handleClickRef.current = handleAndDispatchPointerDownOutsideEvent2;
          ownerDocument.addEventListener("click", handleClickRef.current, { once: true });
        } else {
          handleAndDispatchPointerDownOutsideEvent2();
        }
      } else {
        ownerDocument.removeEventListener("click", handleClickRef.current);
      }
      isPointerInsideReactTreeRef.current = false;
    }, "handlePointerDown");
    const timerId = window.setTimeout(() => {
      ownerDocument.addEventListener("pointerdown", handlePointerDown);
    }, 0);
    return () => {
      window.clearTimeout(timerId);
      ownerDocument.removeEventListener("pointerdown", handlePointerDown);
      ownerDocument.removeEventListener("click", handleClickRef.current);
    };
  }, [ownerDocument, handlePointerDownOutside]);
  return {
    // ensures we check React component tree (not just DOM tree)
    onPointerDownCapture: /* @__PURE__ */ __name(() => isPointerInsideReactTreeRef.current = true, "onPointerDownCapture")
  };
}
__name(usePointerDownOutside, "usePointerDownOutside");
function useFocusOutside(onFocusOutside, ownerDocument = globalThis?.document) {
  const handleFocusOutside = useCallbackRef(onFocusOutside);
  const isFocusInsideReactTreeRef = React17.useRef(false);
  React17.useEffect(() => {
    const handleFocus = /* @__PURE__ */ __name((event) => {
      if (event.target && !isFocusInsideReactTreeRef.current) {
        const eventDetail = { originalEvent: event };
        handleAndDispatchCustomEvent(FOCUS_OUTSIDE, handleFocusOutside, eventDetail, {
          discrete: false
        });
      }
    }, "handleFocus");
    ownerDocument.addEventListener("focusin", handleFocus);
    return () => ownerDocument.removeEventListener("focusin", handleFocus);
  }, [ownerDocument, handleFocusOutside]);
  return {
    onFocusCapture: /* @__PURE__ */ __name(() => isFocusInsideReactTreeRef.current = true, "onFocusCapture"),
    onBlurCapture: /* @__PURE__ */ __name(() => isFocusInsideReactTreeRef.current = false, "onBlurCapture")
  };
}
__name(useFocusOutside, "useFocusOutside");
function dispatchUpdate() {
  const event = new CustomEvent(CONTEXT_UPDATE);
  document.dispatchEvent(event);
}
__name(dispatchUpdate, "dispatchUpdate");
function handleAndDispatchCustomEvent(name, handler, detail, { discrete }) {
  const target = detail.originalEvent.target;
  const event = new CustomEvent(name, { bubbles: false, cancelable: true, detail });
  if (handler) target.addEventListener(name, handler, { once: true });
  if (discrete) {
    dispatchDiscreteCustomEvent(target, event);
  } else {
    target.dispatchEvent(event);
  }
}
__name(handleAndDispatchCustomEvent, "handleAndDispatchCustomEvent");

// ../node_modules/@radix-ui/react-focus-scope/dist/index.mjs
import * as React18 from "react";
import { jsx as jsx5 } from "react/jsx-runtime";
var AUTOFOCUS_ON_MOUNT = "focusScope.autoFocusOnMount";
var AUTOFOCUS_ON_UNMOUNT = "focusScope.autoFocusOnUnmount";
var EVENT_OPTIONS = { bubbles: false, cancelable: true };
var FOCUS_SCOPE_NAME = "FocusScope";
var FocusScope = React18.forwardRef((props, forwardedRef) => {
  const {
    loop = false,
    trapped = false,
    onMountAutoFocus: onMountAutoFocusProp,
    onUnmountAutoFocus: onUnmountAutoFocusProp,
    ...scopeProps
  } = props;
  const [container, setContainer] = React18.useState(null);
  const onMountAutoFocus = useCallbackRef(onMountAutoFocusProp);
  const onUnmountAutoFocus = useCallbackRef(onUnmountAutoFocusProp);
  const lastFocusedElementRef = React18.useRef(null);
  const composedRefs = useComposedRefs(forwardedRef, (node) => setContainer(node));
  const focusScope = React18.useRef({
    paused: false,
    pause() {
      this.paused = true;
    },
    resume() {
      this.paused = false;
    }
  }).current;
  React18.useEffect(() => {
    if (trapped) {
      let handleFocusIn2 = /* @__PURE__ */ __name(function(event) {
        if (focusScope.paused || !container) return;
        const target = event.target;
        if (container.contains(target)) {
          lastFocusedElementRef.current = target;
        } else {
          focus(lastFocusedElementRef.current, { select: true });
        }
      }, "handleFocusIn2"), handleFocusOut2 = /* @__PURE__ */ __name(function(event) {
        if (focusScope.paused || !container) return;
        const relatedTarget = event.relatedTarget;
        if (relatedTarget === null) return;
        if (!container.contains(relatedTarget)) {
          focus(lastFocusedElementRef.current, { select: true });
        }
      }, "handleFocusOut2"), handleMutations2 = /* @__PURE__ */ __name(function(mutations) {
        const focusedElement = document.activeElement;
        if (focusedElement !== document.body) return;
        for (const mutation of mutations) {
          if (mutation.removedNodes.length > 0) focus(container);
        }
      }, "handleMutations2");
      var handleFocusIn = handleFocusIn2, handleFocusOut = handleFocusOut2, handleMutations = handleMutations2;
      document.addEventListener("focusin", handleFocusIn2);
      document.addEventListener("focusout", handleFocusOut2);
      const mutationObserver = new MutationObserver(handleMutations2);
      if (container) mutationObserver.observe(container, { childList: true, subtree: true });
      return () => {
        document.removeEventListener("focusin", handleFocusIn2);
        document.removeEventListener("focusout", handleFocusOut2);
        mutationObserver.disconnect();
      };
    }
  }, [trapped, container, focusScope.paused]);
  React18.useEffect(() => {
    if (container) {
      focusScopesStack.add(focusScope);
      const previouslyFocusedElement = document.activeElement;
      const hasFocusedCandidate = container.contains(previouslyFocusedElement);
      if (!hasFocusedCandidate) {
        const mountEvent = new CustomEvent(AUTOFOCUS_ON_MOUNT, EVENT_OPTIONS);
        container.addEventListener(AUTOFOCUS_ON_MOUNT, onMountAutoFocus);
        container.dispatchEvent(mountEvent);
        if (!mountEvent.defaultPrevented) {
          focusFirst(removeLinks(getTabbableCandidates(container)), { select: true });
          if (document.activeElement === previouslyFocusedElement) {
            focus(container);
          }
        }
      }
      return () => {
        container.removeEventListener(AUTOFOCUS_ON_MOUNT, onMountAutoFocus);
        setTimeout(() => {
          const unmountEvent = new CustomEvent(AUTOFOCUS_ON_UNMOUNT, EVENT_OPTIONS);
          container.addEventListener(AUTOFOCUS_ON_UNMOUNT, onUnmountAutoFocus);
          container.dispatchEvent(unmountEvent);
          if (!unmountEvent.defaultPrevented) {
            focus(previouslyFocusedElement ?? document.body, { select: true });
          }
          container.removeEventListener(AUTOFOCUS_ON_UNMOUNT, onUnmountAutoFocus);
          focusScopesStack.remove(focusScope);
        }, 0);
      };
    }
  }, [container, onMountAutoFocus, onUnmountAutoFocus, focusScope]);
  const handleKeyDown = React18.useCallback(
    (event) => {
      if (!loop && !trapped) return;
      if (focusScope.paused) return;
      const isTabKey = event.key === "Tab" && !event.altKey && !event.ctrlKey && !event.metaKey;
      const focusedElement = document.activeElement;
      if (isTabKey && focusedElement) {
        const container2 = event.currentTarget;
        const [first, last] = getTabbableEdges(container2);
        const hasTabbableElementsInside = first && last;
        if (!hasTabbableElementsInside) {
          if (focusedElement === container2) event.preventDefault();
        } else {
          if (!event.shiftKey && focusedElement === last) {
            event.preventDefault();
            if (loop) focus(first, { select: true });
          } else if (event.shiftKey && focusedElement === first) {
            event.preventDefault();
            if (loop) focus(last, { select: true });
          }
        }
      }
    },
    [loop, trapped, focusScope.paused]
  );
  return jsx5(Primitive.div, { tabIndex: -1, ...scopeProps, ref: composedRefs, onKeyDown: handleKeyDown });
});
FocusScope.displayName = FOCUS_SCOPE_NAME;
function focusFirst(candidates, { select = false } = {}) {
  const previouslyFocusedElement = document.activeElement;
  for (const candidate of candidates) {
    focus(candidate, { select });
    if (document.activeElement !== previouslyFocusedElement) return;
  }
}
__name(focusFirst, "focusFirst");
function getTabbableEdges(container) {
  const candidates = getTabbableCandidates(container);
  const first = findVisible(candidates, container);
  const last = findVisible(candidates.reverse(), container);
  return [first, last];
}
__name(getTabbableEdges, "getTabbableEdges");
function getTabbableCandidates(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
    acceptNode: /* @__PURE__ */ __name((node) => {
      const isHiddenInput = node.tagName === "INPUT" && node.type === "hidden";
      if (node.disabled || node.hidden || isHiddenInput) return NodeFilter.FILTER_SKIP;
      return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
    }, "acceptNode")
  });
  while (walker.nextNode()) nodes.push(walker.currentNode);
  return nodes;
}
__name(getTabbableCandidates, "getTabbableCandidates");
function findVisible(elements, container) {
  for (const element of elements) {
    if (!isHidden(element, { upTo: container })) return element;
  }
}
__name(findVisible, "findVisible");
function isHidden(node, { upTo }) {
  if (getComputedStyle(node).visibility === "hidden") return true;
  while (node) {
    if (upTo !== void 0 && node === upTo) return false;
    if (getComputedStyle(node).display === "none") return true;
    node = node.parentElement;
  }
  return false;
}
__name(isHidden, "isHidden");
function isSelectableInput(element) {
  return element instanceof HTMLInputElement && "select" in element;
}
__name(isSelectableInput, "isSelectableInput");
function focus(element, { select = false } = {}) {
  if (element && element.focus) {
    const previouslyFocusedElement = document.activeElement;
    element.focus({ preventScroll: true });
    if (element !== previouslyFocusedElement && isSelectableInput(element) && select)
      element.select();
  }
}
__name(focus, "focus");
var focusScopesStack = createFocusScopesStack();
function createFocusScopesStack() {
  let stack = [];
  return {
    add(focusScope) {
      const activeFocusScope = stack[0];
      if (focusScope !== activeFocusScope) {
        activeFocusScope?.pause();
      }
      stack = arrayRemove(stack, focusScope);
      stack.unshift(focusScope);
    },
    remove(focusScope) {
      stack = arrayRemove(stack, focusScope);
      stack[0]?.resume();
    }
  };
}
__name(createFocusScopesStack, "createFocusScopesStack");
function arrayRemove(array, item) {
  const updatedArray = [...array];
  const index3 = updatedArray.indexOf(item);
  if (index3 !== -1) {
    updatedArray.splice(index3, 1);
  }
  return updatedArray;
}
__name(arrayRemove, "arrayRemove");
function removeLinks(items) {
  return items.filter((item) => item.tagName !== "A");
}
__name(removeLinks, "removeLinks");

// ../node_modules/@radix-ui/react-portal/dist/index.mjs
import * as React19 from "react";
import ReactDOM2 from "react-dom";
import { jsx as jsx6 } from "react/jsx-runtime";
var PORTAL_NAME = "Portal";
var Portal = React19.forwardRef((props, forwardedRef) => {
  const { container: containerProp, ...portalProps } = props;
  const [mounted, setMounted] = React19.useState(false);
  useLayoutEffect2(() => setMounted(true), []);
  const container = containerProp || mounted && globalThis?.document?.body;
  return container ? ReactDOM2.createPortal(jsx6(Primitive.div, { ...portalProps, ref: forwardedRef }), container) : null;
});
Portal.displayName = PORTAL_NAME;

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/react-presence/dist/index.mjs
import * as React23 from "react";
import * as React20 from "react";
function useStateMachine(initialState, machine) {
  return React20.useReducer((state, event) => {
    const nextState = machine[state][event];
    return nextState ?? state;
  }, initialState);
}
__name(useStateMachine, "useStateMachine");
var Presence = /* @__PURE__ */ __name((props) => {
  const { present, children } = props;
  const presence = usePresence(present);
  const child = typeof children === "function" ? children({ present: presence.isPresent }) : React23.Children.only(children);
  const ref = useComposedRefs(presence.ref, getElementRef2(child));
  const forceMount = typeof children === "function";
  return forceMount || presence.isPresent ? React23.cloneElement(child, { ref }) : null;
}, "Presence");
Presence.displayName = "Presence";
function usePresence(present) {
  const [node, setNode] = React23.useState();
  const stylesRef = React23.useRef(null);
  const prevPresentRef = React23.useRef(present);
  const prevAnimationNameRef = React23.useRef("none");
  const initialState = present ? "mounted" : "unmounted";
  const [state, send] = useStateMachine(initialState, {
    mounted: {
      UNMOUNT: "unmounted",
      ANIMATION_OUT: "unmountSuspended"
    },
    unmountSuspended: {
      MOUNT: "mounted",
      ANIMATION_END: "unmounted"
    },
    unmounted: {
      MOUNT: "mounted"
    }
  });
  React23.useEffect(() => {
    const currentAnimationName = getAnimationName(stylesRef.current);
    prevAnimationNameRef.current = state === "mounted" ? currentAnimationName : "none";
  }, [state]);
  useLayoutEffect2(() => {
    const styles2 = stylesRef.current;
    const wasPresent = prevPresentRef.current;
    const hasPresentChanged = wasPresent !== present;
    if (hasPresentChanged) {
      const prevAnimationName = prevAnimationNameRef.current;
      const currentAnimationName = getAnimationName(styles2);
      if (present) {
        send("MOUNT");
      } else if (currentAnimationName === "none" || styles2?.display === "none") {
        send("UNMOUNT");
      } else {
        const isAnimating = prevAnimationName !== currentAnimationName;
        if (wasPresent && isAnimating) {
          send("ANIMATION_OUT");
        } else {
          send("UNMOUNT");
        }
      }
      prevPresentRef.current = present;
    }
  }, [present, send]);
  useLayoutEffect2(() => {
    if (node) {
      let timeoutId;
      const ownerWindow = node.ownerDocument.defaultView ?? window;
      const handleAnimationEnd = /* @__PURE__ */ __name((event) => {
        const currentAnimationName = getAnimationName(stylesRef.current);
        const isCurrentAnimation = currentAnimationName.includes(CSS.escape(event.animationName));
        if (event.target === node && isCurrentAnimation) {
          send("ANIMATION_END");
          if (!prevPresentRef.current) {
            const currentFillMode = node.style.animationFillMode;
            node.style.animationFillMode = "forwards";
            timeoutId = ownerWindow.setTimeout(() => {
              if (node.style.animationFillMode === "forwards") {
                node.style.animationFillMode = currentFillMode;
              }
            });
          }
        }
      }, "handleAnimationEnd");
      const handleAnimationStart = /* @__PURE__ */ __name((event) => {
        if (event.target === node) {
          prevAnimationNameRef.current = getAnimationName(stylesRef.current);
        }
      }, "handleAnimationStart");
      node.addEventListener("animationstart", handleAnimationStart);
      node.addEventListener("animationcancel", handleAnimationEnd);
      node.addEventListener("animationend", handleAnimationEnd);
      return () => {
        ownerWindow.clearTimeout(timeoutId);
        node.removeEventListener("animationstart", handleAnimationStart);
        node.removeEventListener("animationcancel", handleAnimationEnd);
        node.removeEventListener("animationend", handleAnimationEnd);
      };
    } else {
      send("ANIMATION_END");
    }
  }, [node, send]);
  return {
    isPresent: ["mounted", "unmountSuspended"].includes(state),
    ref: React23.useCallback((node2) => {
      stylesRef.current = node2 ? getComputedStyle(node2) : null;
      setNode(node2);
    }, [])
  };
}
__name(usePresence, "usePresence");
function getAnimationName(styles2) {
  return styles2?.animationName || "none";
}
__name(getAnimationName, "getAnimationName");
function getElementRef2(element) {
  let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
  let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.ref;
  }
  getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
  mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.props.ref;
  }
  return element.props.ref || element.ref;
}
__name(getElementRef2, "getElementRef");

// ../node_modules/@radix-ui/react-focus-guards/dist/index.mjs
import * as React21 from "react";
var count2 = 0;
function useFocusGuards() {
  React21.useEffect(() => {
    const edgeGuards = document.querySelectorAll("[data-radix-focus-guard]");
    document.body.insertAdjacentElement("afterbegin", edgeGuards[0] ?? createFocusGuard());
    document.body.insertAdjacentElement("beforeend", edgeGuards[1] ?? createFocusGuard());
    count2++;
    return () => {
      if (count2 === 1) {
        document.querySelectorAll("[data-radix-focus-guard]").forEach((node) => node.remove());
      }
      count2--;
    };
  }, []);
}
__name(useFocusGuards, "useFocusGuards");
function createFocusGuard() {
  const element = document.createElement("span");
  element.setAttribute("data-radix-focus-guard", "");
  element.tabIndex = 0;
  element.style.outline = "none";
  element.style.opacity = "0";
  element.style.position = "fixed";
  element.style.pointerEvents = "none";
  return element;
}
__name(createFocusGuard, "createFocusGuard");

// ../node_modules/tslib/tslib.es6.mjs
var __assign = /* @__PURE__ */ __name(function() {
  __assign = Object.assign || /* @__PURE__ */ __name(function __assign2(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];
      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
    }
    return t;
  }, "__assign");
  return __assign.apply(this, arguments);
}, "__assign");
function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
    t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t[p[i]] = s[p[i]];
    }
  return t;
}
__name(__rest, "__rest");
function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
    if (ar || !(i in from)) {
      if (!ar) ar = Array.prototype.slice.call(from, 0, i);
      ar[i] = from[i];
    }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}
__name(__spreadArray, "__spreadArray");

// ../node_modules/react-remove-scroll/dist/es2015/Combination.js
import * as React32 from "react";

// ../node_modules/react-remove-scroll/dist/es2015/UI.js
import * as React28 from "react";

// ../node_modules/react-remove-scroll-bar/dist/es2015/constants.js
var zeroRightClassName = "right-scroll-bar-position";
var fullWidthClassName = "width-before-scroll-bar";
var noScrollbarsClassName = "with-scroll-bars-hidden";
var removedBarSizeVariable = "--removed-body-scroll-bar-size";

// ../node_modules/use-callback-ref/dist/es2015/assignRef.js
function assignRef(ref, value) {
  if (typeof ref === "function") {
    ref(value);
  } else if (ref) {
    ref.current = value;
  }
  return ref;
}
__name(assignRef, "assignRef");

// ../node_modules/use-callback-ref/dist/es2015/useRef.js
import { useState as useState7 } from "react";
function useCallbackRef2(initialValue, callback) {
  var ref = useState7(function() {
    return {
      // value
      value: initialValue,
      // last callback
      callback,
      // "memoized" public interface
      facade: {
        get current() {
          return ref.value;
        },
        set current(value) {
          var last = ref.value;
          if (last !== value) {
            ref.value = value;
            ref.callback(value, last);
          }
        }
      }
    };
  })[0];
  ref.callback = callback;
  return ref.facade;
}
__name(useCallbackRef2, "useCallbackRef");

// ../node_modules/use-callback-ref/dist/es2015/useMergeRef.js
import * as React24 from "react";
var useIsomorphicLayoutEffect = typeof window !== "undefined" ? React24.useLayoutEffect : React24.useEffect;
var currentValues = /* @__PURE__ */ new WeakMap();
function useMergeRefs(refs, defaultValue) {
  var callbackRef = useCallbackRef2(defaultValue || null, function(newValue) {
    return refs.forEach(function(ref) {
      return assignRef(ref, newValue);
    });
  });
  useIsomorphicLayoutEffect(function() {
    var oldValue = currentValues.get(callbackRef);
    if (oldValue) {
      var prevRefs_1 = new Set(oldValue);
      var nextRefs_1 = new Set(refs);
      var current_1 = callbackRef.current;
      prevRefs_1.forEach(function(ref) {
        if (!nextRefs_1.has(ref)) {
          assignRef(ref, null);
        }
      });
      nextRefs_1.forEach(function(ref) {
        if (!prevRefs_1.has(ref)) {
          assignRef(ref, current_1);
        }
      });
    }
    currentValues.set(callbackRef, refs);
  }, [refs]);
  return callbackRef;
}
__name(useMergeRefs, "useMergeRefs");

// ../node_modules/use-sidecar/dist/es2015/hoc.js
import * as React25 from "react";

// ../node_modules/use-sidecar/dist/es2015/hook.js
import { useState as useState8, useEffect as useEffect10 } from "react";

// ../node_modules/use-sidecar/dist/es2015/medium.js
function ItoI(a) {
  return a;
}
__name(ItoI, "ItoI");
function innerCreateMedium(defaults, middleware) {
  if (middleware === void 0) {
    middleware = ItoI;
  }
  var buffer = [];
  var assigned = false;
  var medium = {
    read: /* @__PURE__ */ __name(function() {
      if (assigned) {
        throw new Error("Sidecar: could not `read` from an `assigned` medium. `read` could be used only with `useMedium`.");
      }
      if (buffer.length) {
        return buffer[buffer.length - 1];
      }
      return defaults;
    }, "read"),
    useMedium: /* @__PURE__ */ __name(function(data) {
      var item = middleware(data, assigned);
      buffer.push(item);
      return function() {
        buffer = buffer.filter(function(x) {
          return x !== item;
        });
      };
    }, "useMedium"),
    assignSyncMedium: /* @__PURE__ */ __name(function(cb) {
      assigned = true;
      while (buffer.length) {
        var cbs = buffer;
        buffer = [];
        cbs.forEach(cb);
      }
      buffer = {
        push: /* @__PURE__ */ __name(function(x) {
          return cb(x);
        }, "push"),
        filter: /* @__PURE__ */ __name(function() {
          return buffer;
        }, "filter")
      };
    }, "assignSyncMedium"),
    assignMedium: /* @__PURE__ */ __name(function(cb) {
      assigned = true;
      var pendingQueue = [];
      if (buffer.length) {
        var cbs = buffer;
        buffer = [];
        cbs.forEach(cb);
        pendingQueue = buffer;
      }
      var executeQueue = /* @__PURE__ */ __name(function() {
        var cbs2 = pendingQueue;
        pendingQueue = [];
        cbs2.forEach(cb);
      }, "executeQueue");
      var cycle = /* @__PURE__ */ __name(function() {
        return Promise.resolve().then(executeQueue);
      }, "cycle");
      cycle();
      buffer = {
        push: /* @__PURE__ */ __name(function(x) {
          pendingQueue.push(x);
          cycle();
        }, "push"),
        filter: /* @__PURE__ */ __name(function(filter) {
          pendingQueue = pendingQueue.filter(filter);
          return buffer;
        }, "filter")
      };
    }, "assignMedium")
  };
  return medium;
}
__name(innerCreateMedium, "innerCreateMedium");
function createSidecarMedium(options) {
  if (options === void 0) {
    options = {};
  }
  var medium = innerCreateMedium(null);
  medium.options = __assign({ async: true, ssr: false }, options);
  return medium;
}
__name(createSidecarMedium, "createSidecarMedium");

// ../node_modules/use-sidecar/dist/es2015/renderProp.js
import * as React26 from "react";
import { useState as useState9, useCallback as useCallback5, useEffect as useEffect11, useLayoutEffect as useLayoutEffect4 } from "react";

// ../node_modules/use-sidecar/dist/es2015/exports.js
import * as React27 from "react";
var SideCar = /* @__PURE__ */ __name(function(_a) {
  var sideCar = _a.sideCar, rest = __rest(_a, ["sideCar"]);
  if (!sideCar) {
    throw new Error("Sidecar: please provide `sideCar` property to import the right car");
  }
  var Target = sideCar.read();
  if (!Target) {
    throw new Error("Sidecar medium not found");
  }
  return React27.createElement(Target, __assign({}, rest));
}, "SideCar");
SideCar.isSideCarExport = true;
function exportSidecar(medium, exported) {
  medium.useMedium(exported);
  return SideCar;
}
__name(exportSidecar, "exportSidecar");

// ../node_modules/react-remove-scroll/dist/es2015/medium.js
var effectCar = createSidecarMedium();

// ../node_modules/react-remove-scroll/dist/es2015/UI.js
var nothing = /* @__PURE__ */ __name(function() {
  return;
}, "nothing");
var RemoveScroll = React28.forwardRef(function(props, parentRef) {
  var ref = React28.useRef(null);
  var _a = React28.useState({
    onScrollCapture: nothing,
    onWheelCapture: nothing,
    onTouchMoveCapture: nothing
  }), callbacks = _a[0], setCallbacks = _a[1];
  var forwardProps = props.forwardProps, children = props.children, className = props.className, removeScrollBar = props.removeScrollBar, enabled = props.enabled, shards = props.shards, sideCar = props.sideCar, noRelative = props.noRelative, noIsolation = props.noIsolation, inert = props.inert, allowPinchZoom = props.allowPinchZoom, _b = props.as, Container3 = _b === void 0 ? "div" : _b, gapMode = props.gapMode, rest = __rest(props, ["forwardProps", "children", "className", "removeScrollBar", "enabled", "shards", "sideCar", "noRelative", "noIsolation", "inert", "allowPinchZoom", "as", "gapMode"]);
  var SideCar2 = sideCar;
  var containerRef = useMergeRefs([ref, parentRef]);
  var containerProps = __assign(__assign({}, rest), callbacks);
  return React28.createElement(
    React28.Fragment,
    null,
    enabled && React28.createElement(SideCar2, { sideCar: effectCar, removeScrollBar, shards, noRelative, noIsolation, inert, setCallbacks, allowPinchZoom: !!allowPinchZoom, lockRef: ref, gapMode }),
    forwardProps ? React28.cloneElement(React28.Children.only(children), __assign(__assign({}, containerProps), { ref: containerRef })) : React28.createElement(Container3, __assign({}, containerProps, { className, ref: containerRef }), children)
  );
});
RemoveScroll.defaultProps = {
  enabled: true,
  removeScrollBar: true,
  inert: false
};
RemoveScroll.classNames = {
  fullWidth: fullWidthClassName,
  zeroRight: zeroRightClassName
};

// ../node_modules/react-remove-scroll/dist/es2015/SideEffect.js
import * as React31 from "react";

// ../node_modules/react-remove-scroll-bar/dist/es2015/component.js
import * as React30 from "react";

// ../node_modules/react-style-singleton/dist/es2015/hook.js
import * as React29 from "react";

// ../node_modules/get-nonce/dist/es2015/index.js
var currentNonce;
var getNonce = /* @__PURE__ */ __name(function() {
  if (currentNonce) {
    return currentNonce;
  }
  if (typeof __webpack_nonce__ !== "undefined") {
    return __webpack_nonce__;
  }
  return void 0;
}, "getNonce");

// ../node_modules/react-style-singleton/dist/es2015/singleton.js
function makeStyleTag() {
  if (!document)
    return null;
  var tag = document.createElement("style");
  tag.type = "text/css";
  var nonce = getNonce();
  if (nonce) {
    tag.setAttribute("nonce", nonce);
  }
  return tag;
}
__name(makeStyleTag, "makeStyleTag");
function injectStyles(tag, css) {
  if (tag.styleSheet) {
    tag.styleSheet.cssText = css;
  } else {
    tag.appendChild(document.createTextNode(css));
  }
}
__name(injectStyles, "injectStyles");
function insertStyleTag(tag) {
  var head = document.head || document.getElementsByTagName("head")[0];
  head.appendChild(tag);
}
__name(insertStyleTag, "insertStyleTag");
var stylesheetSingleton = /* @__PURE__ */ __name(function() {
  var counter = 0;
  var stylesheet = null;
  return {
    add: /* @__PURE__ */ __name(function(style) {
      if (counter == 0) {
        if (stylesheet = makeStyleTag()) {
          injectStyles(stylesheet, style);
          insertStyleTag(stylesheet);
        }
      }
      counter++;
    }, "add"),
    remove: /* @__PURE__ */ __name(function() {
      counter--;
      if (!counter && stylesheet) {
        stylesheet.parentNode && stylesheet.parentNode.removeChild(stylesheet);
        stylesheet = null;
      }
    }, "remove")
  };
}, "stylesheetSingleton");

// ../node_modules/react-style-singleton/dist/es2015/hook.js
var styleHookSingleton = /* @__PURE__ */ __name(function() {
  var sheet = stylesheetSingleton();
  return function(styles2, isDynamic) {
    React29.useEffect(function() {
      sheet.add(styles2);
      return function() {
        sheet.remove();
      };
    }, [styles2 && isDynamic]);
  };
}, "styleHookSingleton");

// ../node_modules/react-style-singleton/dist/es2015/component.js
var styleSingleton = /* @__PURE__ */ __name(function() {
  var useStyle = styleHookSingleton();
  var Sheet = /* @__PURE__ */ __name(function(_a) {
    var styles2 = _a.styles, dynamic = _a.dynamic;
    useStyle(styles2, dynamic);
    return null;
  }, "Sheet");
  return Sheet;
}, "styleSingleton");

// ../node_modules/react-remove-scroll-bar/dist/es2015/utils.js
var zeroGap = {
  left: 0,
  top: 0,
  right: 0,
  gap: 0
};
var parse = /* @__PURE__ */ __name(function(x) {
  return parseInt(x || "", 10) || 0;
}, "parse");
var getOffset = /* @__PURE__ */ __name(function(gapMode) {
  var cs = window.getComputedStyle(document.body);
  var left = cs[gapMode === "padding" ? "paddingLeft" : "marginLeft"];
  var top = cs[gapMode === "padding" ? "paddingTop" : "marginTop"];
  var right = cs[gapMode === "padding" ? "paddingRight" : "marginRight"];
  return [parse(left), parse(top), parse(right)];
}, "getOffset");
var getGapWidth = /* @__PURE__ */ __name(function(gapMode) {
  if (gapMode === void 0) {
    gapMode = "margin";
  }
  if (typeof window === "undefined") {
    return zeroGap;
  }
  var offsets = getOffset(gapMode);
  var documentWidth = document.documentElement.clientWidth;
  var windowWidth = window.innerWidth;
  return {
    left: offsets[0],
    top: offsets[1],
    right: offsets[2],
    gap: Math.max(0, windowWidth - documentWidth + offsets[2] - offsets[0])
  };
}, "getGapWidth");

// ../node_modules/react-remove-scroll-bar/dist/es2015/component.js
var Style = styleSingleton();
var lockAttribute = "data-scroll-locked";
var getStyles = /* @__PURE__ */ __name(function(_a, allowRelative, gapMode, important) {
  var left = _a.left, top = _a.top, right = _a.right, gap = _a.gap;
  if (gapMode === void 0) {
    gapMode = "margin";
  }
  return "\n  .".concat(noScrollbarsClassName, " {\n   overflow: hidden ").concat(important, ";\n   padding-right: ").concat(gap, "px ").concat(important, ";\n  }\n  body[").concat(lockAttribute, "] {\n    overflow: hidden ").concat(important, ";\n    overscroll-behavior: contain;\n    ").concat([
    allowRelative && "position: relative ".concat(important, ";"),
    gapMode === "margin" && "\n    padding-left: ".concat(left, "px;\n    padding-top: ").concat(top, "px;\n    padding-right: ").concat(right, "px;\n    margin-left:0;\n    margin-top:0;\n    margin-right: ").concat(gap, "px ").concat(important, ";\n    "),
    gapMode === "padding" && "padding-right: ".concat(gap, "px ").concat(important, ";")
  ].filter(Boolean).join(""), "\n  }\n  \n  .").concat(zeroRightClassName, " {\n    right: ").concat(gap, "px ").concat(important, ";\n  }\n  \n  .").concat(fullWidthClassName, " {\n    margin-right: ").concat(gap, "px ").concat(important, ";\n  }\n  \n  .").concat(zeroRightClassName, " .").concat(zeroRightClassName, " {\n    right: 0 ").concat(important, ";\n  }\n  \n  .").concat(fullWidthClassName, " .").concat(fullWidthClassName, " {\n    margin-right: 0 ").concat(important, ";\n  }\n  \n  body[").concat(lockAttribute, "] {\n    ").concat(removedBarSizeVariable, ": ").concat(gap, "px;\n  }\n");
}, "getStyles");
var getCurrentUseCounter = /* @__PURE__ */ __name(function() {
  var counter = parseInt(document.body.getAttribute(lockAttribute) || "0", 10);
  return isFinite(counter) ? counter : 0;
}, "getCurrentUseCounter");
var useLockAttribute = /* @__PURE__ */ __name(function() {
  React30.useEffect(function() {
    document.body.setAttribute(lockAttribute, (getCurrentUseCounter() + 1).toString());
    return function() {
      var newCounter = getCurrentUseCounter() - 1;
      if (newCounter <= 0) {
        document.body.removeAttribute(lockAttribute);
      } else {
        document.body.setAttribute(lockAttribute, newCounter.toString());
      }
    };
  }, []);
}, "useLockAttribute");
var RemoveScrollBar = /* @__PURE__ */ __name(function(_a) {
  var noRelative = _a.noRelative, noImportant = _a.noImportant, _b = _a.gapMode, gapMode = _b === void 0 ? "margin" : _b;
  useLockAttribute();
  var gap = React30.useMemo(function() {
    return getGapWidth(gapMode);
  }, [gapMode]);
  return React30.createElement(Style, { styles: getStyles(gap, !noRelative, gapMode, !noImportant ? "!important" : "") });
}, "RemoveScrollBar");

// ../node_modules/react-remove-scroll/dist/es2015/aggresiveCapture.js
var passiveSupported = false;
if (typeof window !== "undefined") {
  try {
    options = Object.defineProperty({}, "passive", {
      get: /* @__PURE__ */ __name(function() {
        passiveSupported = true;
        return true;
      }, "get")
    });
    window.addEventListener("test", options, options);
    window.removeEventListener("test", options, options);
  } catch (err) {
    passiveSupported = false;
  }
}
var options;
var nonPassive = passiveSupported ? { passive: false } : false;

// ../node_modules/react-remove-scroll/dist/es2015/handleScroll.js
var alwaysContainsScroll = /* @__PURE__ */ __name(function(node) {
  return node.tagName === "TEXTAREA";
}, "alwaysContainsScroll");
var elementCanBeScrolled = /* @__PURE__ */ __name(function(node, overflow) {
  if (!(node instanceof Element)) {
    return false;
  }
  var styles2 = window.getComputedStyle(node);
  return (
    // not-not-scrollable
    styles2[overflow] !== "hidden" && // contains scroll inside self
    !(styles2.overflowY === styles2.overflowX && !alwaysContainsScroll(node) && styles2[overflow] === "visible")
  );
}, "elementCanBeScrolled");
var elementCouldBeVScrolled = /* @__PURE__ */ __name(function(node) {
  return elementCanBeScrolled(node, "overflowY");
}, "elementCouldBeVScrolled");
var elementCouldBeHScrolled = /* @__PURE__ */ __name(function(node) {
  return elementCanBeScrolled(node, "overflowX");
}, "elementCouldBeHScrolled");
var locationCouldBeScrolled = /* @__PURE__ */ __name(function(axis, node) {
  var ownerDocument = node.ownerDocument;
  var current = node;
  do {
    if (typeof ShadowRoot !== "undefined" && current instanceof ShadowRoot) {
      current = current.host;
    }
    var isScrollable = elementCouldBeScrolled(axis, current);
    if (isScrollable) {
      var _a = getScrollVariables(axis, current), scrollHeight = _a[1], clientHeight = _a[2];
      if (scrollHeight > clientHeight) {
        return true;
      }
    }
    current = current.parentNode;
  } while (current && current !== ownerDocument.body);
  return false;
}, "locationCouldBeScrolled");
var getVScrollVariables = /* @__PURE__ */ __name(function(_a) {
  var scrollTop = _a.scrollTop, scrollHeight = _a.scrollHeight, clientHeight = _a.clientHeight;
  return [
    scrollTop,
    scrollHeight,
    clientHeight
  ];
}, "getVScrollVariables");
var getHScrollVariables = /* @__PURE__ */ __name(function(_a) {
  var scrollLeft = _a.scrollLeft, scrollWidth = _a.scrollWidth, clientWidth = _a.clientWidth;
  return [
    scrollLeft,
    scrollWidth,
    clientWidth
  ];
}, "getHScrollVariables");
var elementCouldBeScrolled = /* @__PURE__ */ __name(function(axis, node) {
  return axis === "v" ? elementCouldBeVScrolled(node) : elementCouldBeHScrolled(node);
}, "elementCouldBeScrolled");
var getScrollVariables = /* @__PURE__ */ __name(function(axis, node) {
  return axis === "v" ? getVScrollVariables(node) : getHScrollVariables(node);
}, "getScrollVariables");
var getDirectionFactor = /* @__PURE__ */ __name(function(axis, direction) {
  return axis === "h" && direction === "rtl" ? -1 : 1;
}, "getDirectionFactor");
var handleScroll = /* @__PURE__ */ __name(function(axis, endTarget, event, sourceDelta, noOverscroll) {
  var directionFactor = getDirectionFactor(axis, window.getComputedStyle(endTarget).direction);
  var delta = directionFactor * sourceDelta;
  var target = event.target;
  var targetInLock = endTarget.contains(target);
  var shouldCancelScroll = false;
  var isDeltaPositive = delta > 0;
  var availableScroll = 0;
  var availableScrollTop = 0;
  do {
    if (!target) {
      break;
    }
    var _a = getScrollVariables(axis, target), position = _a[0], scroll_1 = _a[1], capacity = _a[2];
    var elementScroll = scroll_1 - capacity - directionFactor * position;
    if (position || elementScroll) {
      if (elementCouldBeScrolled(axis, target)) {
        availableScroll += elementScroll;
        availableScrollTop += position;
      }
    }
    var parent_1 = target.parentNode;
    target = parent_1 && parent_1.nodeType === Node.DOCUMENT_FRAGMENT_NODE ? parent_1.host : parent_1;
  } while (
    // portaled content
    !targetInLock && target !== document.body || // self content
    targetInLock && (endTarget.contains(target) || endTarget === target)
  );
  if (isDeltaPositive && (noOverscroll && Math.abs(availableScroll) < 1 || !noOverscroll && delta > availableScroll)) {
    shouldCancelScroll = true;
  } else if (!isDeltaPositive && (noOverscroll && Math.abs(availableScrollTop) < 1 || !noOverscroll && -delta > availableScrollTop)) {
    shouldCancelScroll = true;
  }
  return shouldCancelScroll;
}, "handleScroll");

// ../node_modules/react-remove-scroll/dist/es2015/SideEffect.js
var getTouchXY = /* @__PURE__ */ __name(function(event) {
  return "changedTouches" in event ? [event.changedTouches[0].clientX, event.changedTouches[0].clientY] : [0, 0];
}, "getTouchXY");
var getDeltaXY = /* @__PURE__ */ __name(function(event) {
  return [event.deltaX, event.deltaY];
}, "getDeltaXY");
var extractRef = /* @__PURE__ */ __name(function(ref) {
  return ref && "current" in ref ? ref.current : ref;
}, "extractRef");
var deltaCompare = /* @__PURE__ */ __name(function(x, y) {
  return x[0] === y[0] && x[1] === y[1];
}, "deltaCompare");
var generateStyle = /* @__PURE__ */ __name(function(id) {
  return "\n  .block-interactivity-".concat(id, " {pointer-events: none;}\n  .allow-interactivity-").concat(id, " {pointer-events: all;}\n");
}, "generateStyle");
var idCounter = 0;
var lockStack = [];
function RemoveScrollSideCar(props) {
  var shouldPreventQueue = React31.useRef([]);
  var touchStartRef = React31.useRef([0, 0]);
  var activeAxis = React31.useRef();
  var id = React31.useState(idCounter++)[0];
  var Style2 = React31.useState(styleSingleton)[0];
  var lastProps = React31.useRef(props);
  React31.useEffect(function() {
    lastProps.current = props;
  }, [props]);
  React31.useEffect(function() {
    if (props.inert) {
      document.body.classList.add("block-interactivity-".concat(id));
      var allow_1 = __spreadArray([props.lockRef.current], (props.shards || []).map(extractRef), true).filter(Boolean);
      allow_1.forEach(function(el) {
        return el.classList.add("allow-interactivity-".concat(id));
      });
      return function() {
        document.body.classList.remove("block-interactivity-".concat(id));
        allow_1.forEach(function(el) {
          return el.classList.remove("allow-interactivity-".concat(id));
        });
      };
    }
    return;
  }, [props.inert, props.lockRef.current, props.shards]);
  var shouldCancelEvent = React31.useCallback(function(event, parent) {
    if ("touches" in event && event.touches.length === 2 || event.type === "wheel" && event.ctrlKey) {
      return !lastProps.current.allowPinchZoom;
    }
    var touch = getTouchXY(event);
    var touchStart = touchStartRef.current;
    var deltaX = "deltaX" in event ? event.deltaX : touchStart[0] - touch[0];
    var deltaY = "deltaY" in event ? event.deltaY : touchStart[1] - touch[1];
    var currentAxis;
    var target = event.target;
    var moveDirection = Math.abs(deltaX) > Math.abs(deltaY) ? "h" : "v";
    if ("touches" in event && moveDirection === "h" && target.type === "range") {
      return false;
    }
    var canBeScrolledInMainDirection = locationCouldBeScrolled(moveDirection, target);
    if (!canBeScrolledInMainDirection) {
      return true;
    }
    if (canBeScrolledInMainDirection) {
      currentAxis = moveDirection;
    } else {
      currentAxis = moveDirection === "v" ? "h" : "v";
      canBeScrolledInMainDirection = locationCouldBeScrolled(moveDirection, target);
    }
    if (!canBeScrolledInMainDirection) {
      return false;
    }
    if (!activeAxis.current && "changedTouches" in event && (deltaX || deltaY)) {
      activeAxis.current = currentAxis;
    }
    if (!currentAxis) {
      return true;
    }
    var cancelingAxis = activeAxis.current || currentAxis;
    return handleScroll(cancelingAxis, parent, event, cancelingAxis === "h" ? deltaX : deltaY, true);
  }, []);
  var shouldPrevent = React31.useCallback(function(_event) {
    var event = _event;
    if (!lockStack.length || lockStack[lockStack.length - 1] !== Style2) {
      return;
    }
    var delta = "deltaY" in event ? getDeltaXY(event) : getTouchXY(event);
    var sourceEvent = shouldPreventQueue.current.filter(function(e) {
      return e.name === event.type && (e.target === event.target || event.target === e.shadowParent) && deltaCompare(e.delta, delta);
    })[0];
    if (sourceEvent && sourceEvent.should) {
      if (event.cancelable) {
        event.preventDefault();
      }
      return;
    }
    if (!sourceEvent) {
      var shardNodes = (lastProps.current.shards || []).map(extractRef).filter(Boolean).filter(function(node) {
        return node.contains(event.target);
      });
      var shouldStop = shardNodes.length > 0 ? shouldCancelEvent(event, shardNodes[0]) : !lastProps.current.noIsolation;
      if (shouldStop) {
        if (event.cancelable) {
          event.preventDefault();
        }
      }
    }
  }, []);
  var shouldCancel = React31.useCallback(function(name, delta, target, should) {
    var event = { name, delta, target, should, shadowParent: getOutermostShadowParent(target) };
    shouldPreventQueue.current.push(event);
    setTimeout(function() {
      shouldPreventQueue.current = shouldPreventQueue.current.filter(function(e) {
        return e !== event;
      });
    }, 1);
  }, []);
  var scrollTouchStart = React31.useCallback(function(event) {
    touchStartRef.current = getTouchXY(event);
    activeAxis.current = void 0;
  }, []);
  var scrollWheel = React31.useCallback(function(event) {
    shouldCancel(event.type, getDeltaXY(event), event.target, shouldCancelEvent(event, props.lockRef.current));
  }, []);
  var scrollTouchMove = React31.useCallback(function(event) {
    shouldCancel(event.type, getTouchXY(event), event.target, shouldCancelEvent(event, props.lockRef.current));
  }, []);
  React31.useEffect(function() {
    lockStack.push(Style2);
    props.setCallbacks({
      onScrollCapture: scrollWheel,
      onWheelCapture: scrollWheel,
      onTouchMoveCapture: scrollTouchMove
    });
    document.addEventListener("wheel", shouldPrevent, nonPassive);
    document.addEventListener("touchmove", shouldPrevent, nonPassive);
    document.addEventListener("touchstart", scrollTouchStart, nonPassive);
    return function() {
      lockStack = lockStack.filter(function(inst) {
        return inst !== Style2;
      });
      document.removeEventListener("wheel", shouldPrevent, nonPassive);
      document.removeEventListener("touchmove", shouldPrevent, nonPassive);
      document.removeEventListener("touchstart", scrollTouchStart, nonPassive);
    };
  }, []);
  var removeScrollBar = props.removeScrollBar, inert = props.inert;
  return React31.createElement(
    React31.Fragment,
    null,
    inert ? React31.createElement(Style2, { styles: generateStyle(id) }) : null,
    removeScrollBar ? React31.createElement(RemoveScrollBar, { noRelative: props.noRelative, gapMode: props.gapMode }) : null
  );
}
__name(RemoveScrollSideCar, "RemoveScrollSideCar");
function getOutermostShadowParent(node) {
  var shadowParent = null;
  while (node !== null) {
    if (node instanceof ShadowRoot) {
      shadowParent = node.host;
      node = node.host;
    }
    node = node.parentNode;
  }
  return shadowParent;
}
__name(getOutermostShadowParent, "getOutermostShadowParent");

// ../node_modules/react-remove-scroll/dist/es2015/sidecar.js
var sidecar_default = exportSidecar(effectCar, RemoveScrollSideCar);

// ../node_modules/react-remove-scroll/dist/es2015/Combination.js
var ReactRemoveScroll = React32.forwardRef(function(props, ref) {
  return React32.createElement(RemoveScroll, __assign({}, props, { ref, sideCar: sidecar_default }));
});
ReactRemoveScroll.classNames = RemoveScroll.classNames;
var Combination_default = ReactRemoveScroll;

// ../node_modules/aria-hidden/dist/es2015/index.js
var getDefaultParent = /* @__PURE__ */ __name(function(originalTarget) {
  if (typeof document === "undefined") {
    return null;
  }
  var sampleTarget = Array.isArray(originalTarget) ? originalTarget[0] : originalTarget;
  return sampleTarget.ownerDocument.body;
}, "getDefaultParent");
var counterMap = /* @__PURE__ */ new WeakMap();
var uncontrolledNodes = /* @__PURE__ */ new WeakMap();
var markerMap = {};
var lockCount = 0;
var unwrapHost = /* @__PURE__ */ __name(function(node) {
  return node && (node.host || unwrapHost(node.parentNode));
}, "unwrapHost");
var correctTargets = /* @__PURE__ */ __name(function(parent, targets) {
  return targets.map(function(target) {
    if (parent.contains(target)) {
      return target;
    }
    var correctedTarget = unwrapHost(target);
    if (correctedTarget && parent.contains(correctedTarget)) {
      return correctedTarget;
    }
    console.error("aria-hidden", target, "in not contained inside", parent, ". Doing nothing");
    return null;
  }).filter(function(x) {
    return Boolean(x);
  });
}, "correctTargets");
var applyAttributeToOthers = /* @__PURE__ */ __name(function(originalTarget, parentNode, markerName, controlAttribute) {
  var targets = correctTargets(parentNode, Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  if (!markerMap[markerName]) {
    markerMap[markerName] = /* @__PURE__ */ new WeakMap();
  }
  var markerCounter = markerMap[markerName];
  var hiddenNodes = [];
  var elementsToKeep = /* @__PURE__ */ new Set();
  var elementsToStop = new Set(targets);
  var keep = /* @__PURE__ */ __name(function(el) {
    if (!el || elementsToKeep.has(el)) {
      return;
    }
    elementsToKeep.add(el);
    keep(el.parentNode);
  }, "keep");
  targets.forEach(keep);
  var deep = /* @__PURE__ */ __name(function(parent) {
    if (!parent || elementsToStop.has(parent)) {
      return;
    }
    Array.prototype.forEach.call(parent.children, function(node) {
      if (elementsToKeep.has(node)) {
        deep(node);
      } else {
        try {
          var attr = node.getAttribute(controlAttribute);
          var alreadyHidden = attr !== null && attr !== "false";
          var counterValue = (counterMap.get(node) || 0) + 1;
          var markerValue = (markerCounter.get(node) || 0) + 1;
          counterMap.set(node, counterValue);
          markerCounter.set(node, markerValue);
          hiddenNodes.push(node);
          if (counterValue === 1 && alreadyHidden) {
            uncontrolledNodes.set(node, true);
          }
          if (markerValue === 1) {
            node.setAttribute(markerName, "true");
          }
          if (!alreadyHidden) {
            node.setAttribute(controlAttribute, "true");
          }
        } catch (e) {
          console.error("aria-hidden: cannot operate on ", node, e);
        }
      }
    });
  }, "deep");
  deep(parentNode);
  elementsToKeep.clear();
  lockCount++;
  return function() {
    hiddenNodes.forEach(function(node) {
      var counterValue = counterMap.get(node) - 1;
      var markerValue = markerCounter.get(node) - 1;
      counterMap.set(node, counterValue);
      markerCounter.set(node, markerValue);
      if (!counterValue) {
        if (!uncontrolledNodes.has(node)) {
          node.removeAttribute(controlAttribute);
        }
        uncontrolledNodes.delete(node);
      }
      if (!markerValue) {
        node.removeAttribute(markerName);
      }
    });
    lockCount--;
    if (!lockCount) {
      counterMap = /* @__PURE__ */ new WeakMap();
      counterMap = /* @__PURE__ */ new WeakMap();
      uncontrolledNodes = /* @__PURE__ */ new WeakMap();
      markerMap = {};
    }
  };
}, "applyAttributeToOthers");
var hideOthers = /* @__PURE__ */ __name(function(originalTarget, parentNode, markerName) {
  if (markerName === void 0) {
    markerName = "data-aria-hidden";
  }
  var targets = Array.from(Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  var activeParentNode = parentNode || getDefaultParent(originalTarget);
  if (!activeParentNode) {
    return function() {
      return null;
    };
  }
  targets.push.apply(targets, Array.from(activeParentNode.querySelectorAll("[aria-live], script")));
  return applyAttributeToOthers(targets, activeParentNode, markerName, "aria-hidden");
}, "hideOthers");

// ../node_modules/@radix-ui/react-dialog/node_modules/@radix-ui/react-slot/dist/index.mjs
import * as React33 from "react";
import { Fragment as Fragment22, jsx as jsx7 } from "react/jsx-runtime";
function createSlot2(ownerName) {
  const SlotClone = createSlotClone2(ownerName);
  const Slot22 = React33.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    const childrenArray = React33.Children.toArray(children);
    const slottable = childrenArray.find(isSlottable2);
    if (slottable) {
      const newElement = slottable.props.children;
      const newChildren = childrenArray.map((child) => {
        if (child === slottable) {
          if (React33.Children.count(newElement) > 1) return React33.Children.only(null);
          return React33.isValidElement(newElement) ? newElement.props.children : null;
        } else {
          return child;
        }
      });
      return jsx7(SlotClone, { ...slotProps, ref: forwardedRef, children: React33.isValidElement(newElement) ? React33.cloneElement(newElement, void 0, newChildren) : null });
    }
    return jsx7(SlotClone, { ...slotProps, ref: forwardedRef, children });
  });
  Slot22.displayName = `${ownerName}.Slot`;
  return Slot22;
}
__name(createSlot2, "createSlot");
var Slot2 = createSlot2("Slot");
function createSlotClone2(ownerName) {
  const SlotClone = React33.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    if (React33.isValidElement(children)) {
      const childrenRef = getElementRef3(children);
      const props2 = mergeProps2(slotProps, children.props);
      if (children.type !== React33.Fragment) {
        props2.ref = forwardedRef ? composeRefs(forwardedRef, childrenRef) : childrenRef;
      }
      return React33.cloneElement(children, props2);
    }
    return React33.Children.count(children) > 1 ? React33.Children.only(null) : null;
  });
  SlotClone.displayName = `${ownerName}.SlotClone`;
  return SlotClone;
}
__name(createSlotClone2, "createSlotClone");
var SLOTTABLE_IDENTIFIER2 = Symbol("radix.slottable");
function createSlottable2(ownerName) {
  const Slottable22 = /* @__PURE__ */ __name(({ children }) => {
    return jsx7(Fragment22, { children });
  }, "Slottable2");
  Slottable22.displayName = `${ownerName}.Slottable`;
  Slottable22.__radixId = SLOTTABLE_IDENTIFIER2;
  return Slottable22;
}
__name(createSlottable2, "createSlottable");
var Slottable2 = createSlottable2("Slottable");
function isSlottable2(child) {
  return React33.isValidElement(child) && typeof child.type === "function" && "__radixId" in child.type && child.type.__radixId === SLOTTABLE_IDENTIFIER2;
}
__name(isSlottable2, "isSlottable");
function mergeProps2(slotProps, childProps) {
  const overrideProps = { ...childProps };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      if (slotPropValue && childPropValue) {
        overrideProps[propName] = (...args) => {
          const result = childPropValue(...args);
          slotPropValue(...args);
          return result;
        };
      } else if (slotPropValue) {
        overrideProps[propName] = slotPropValue;
      }
    } else if (propName === "style") {
      overrideProps[propName] = { ...slotPropValue, ...childPropValue };
    } else if (propName === "className") {
      overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(" ");
    }
  }
  return { ...slotProps, ...overrideProps };
}
__name(mergeProps2, "mergeProps");
function getElementRef3(element) {
  let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
  let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.ref;
  }
  getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
  mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.props.ref;
  }
  return element.props.ref || element.ref;
}
__name(getElementRef3, "getElementRef");

// ../node_modules/@radix-ui/react-dialog/dist/index.mjs
import { Fragment as Fragment7, jsx as jsx8, jsxs } from "react/jsx-runtime";
var DIALOG_NAME = "Dialog";
var [createDialogContext, createDialogScope] = createContextScope(DIALOG_NAME);
var [DialogProvider, useDialogContext] = createDialogContext(DIALOG_NAME);
var Dialog = /* @__PURE__ */ __name((props) => {
  const {
    __scopeDialog,
    children,
    open: openProp,
    defaultOpen,
    onOpenChange,
    modal = true
  } = props;
  const triggerRef = React34.useRef(null);
  const contentRef = React34.useRef(null);
  const [open, setOpen] = useControllableState({
    prop: openProp,
    defaultProp: defaultOpen ?? false,
    onChange: onOpenChange,
    caller: DIALOG_NAME
  });
  return jsx8(
    DialogProvider,
    {
      scope: __scopeDialog,
      triggerRef,
      contentRef,
      contentId: useId(),
      titleId: useId(),
      descriptionId: useId(),
      open,
      onOpenChange: setOpen,
      onOpenToggle: React34.useCallback(() => setOpen((prevOpen) => !prevOpen), [setOpen]),
      modal,
      children
    }
  );
}, "Dialog");
Dialog.displayName = DIALOG_NAME;
var TRIGGER_NAME = "DialogTrigger";
var DialogTrigger = React34.forwardRef(
  (props, forwardedRef) => {
    const { __scopeDialog, ...triggerProps } = props;
    const context = useDialogContext(TRIGGER_NAME, __scopeDialog);
    const composedTriggerRef = useComposedRefs(forwardedRef, context.triggerRef);
    return jsx8(
      Primitive.button,
      {
        type: "button",
        "aria-haspopup": "dialog",
        "aria-expanded": context.open,
        "aria-controls": context.contentId,
        "data-state": getState(context.open),
        ...triggerProps,
        ref: composedTriggerRef,
        onClick: composeEventHandlers(props.onClick, context.onOpenToggle)
      }
    );
  }
);
DialogTrigger.displayName = TRIGGER_NAME;
var PORTAL_NAME2 = "DialogPortal";
var [PortalProvider, usePortalContext] = createDialogContext(PORTAL_NAME2, {
  forceMount: void 0
});
var DialogPortal = /* @__PURE__ */ __name((props) => {
  const { __scopeDialog, forceMount, children, container } = props;
  const context = useDialogContext(PORTAL_NAME2, __scopeDialog);
  return jsx8(PortalProvider, { scope: __scopeDialog, forceMount, children: React34.Children.map(children, (child) => jsx8(Presence, { present: forceMount || context.open, children: jsx8(Portal, { asChild: true, container, children: child }) })) });
}, "DialogPortal");
DialogPortal.displayName = PORTAL_NAME2;
var OVERLAY_NAME = "DialogOverlay";
var DialogOverlay = React34.forwardRef(
  (props, forwardedRef) => {
    const portalContext = usePortalContext(OVERLAY_NAME, props.__scopeDialog);
    const { forceMount = portalContext.forceMount, ...overlayProps } = props;
    const context = useDialogContext(OVERLAY_NAME, props.__scopeDialog);
    return context.modal ? jsx8(Presence, { present: forceMount || context.open, children: jsx8(DialogOverlayImpl, { ...overlayProps, ref: forwardedRef }) }) : null;
  }
);
DialogOverlay.displayName = OVERLAY_NAME;
var Slot3 = createSlot2("DialogOverlay.RemoveScroll");
var DialogOverlayImpl = React34.forwardRef(
  (props, forwardedRef) => {
    const { __scopeDialog, ...overlayProps } = props;
    const context = useDialogContext(OVERLAY_NAME, __scopeDialog);
    return (
      // Make sure `Content` is scrollable even when it doesn't live inside `RemoveScroll`
      // ie. when `Overlay` and `Content` are siblings
      jsx8(Combination_default, { as: Slot3, allowPinchZoom: true, shards: [context.contentRef], children: jsx8(
        Primitive.div,
        {
          "data-state": getState(context.open),
          ...overlayProps,
          ref: forwardedRef,
          style: { pointerEvents: "auto", ...overlayProps.style }
        }
      ) })
    );
  }
);
var CONTENT_NAME = "DialogContent";
var DialogContent = React34.forwardRef(
  (props, forwardedRef) => {
    const portalContext = usePortalContext(CONTENT_NAME, props.__scopeDialog);
    const { forceMount = portalContext.forceMount, ...contentProps } = props;
    const context = useDialogContext(CONTENT_NAME, props.__scopeDialog);
    return jsx8(Presence, { present: forceMount || context.open, children: context.modal ? jsx8(DialogContentModal, { ...contentProps, ref: forwardedRef }) : jsx8(DialogContentNonModal, { ...contentProps, ref: forwardedRef }) });
  }
);
DialogContent.displayName = CONTENT_NAME;
var DialogContentModal = React34.forwardRef(
  (props, forwardedRef) => {
    const context = useDialogContext(CONTENT_NAME, props.__scopeDialog);
    const contentRef = React34.useRef(null);
    const composedRefs = useComposedRefs(forwardedRef, context.contentRef, contentRef);
    React34.useEffect(() => {
      const content = contentRef.current;
      if (content) return hideOthers(content);
    }, []);
    return jsx8(
      DialogContentImpl,
      {
        ...props,
        ref: composedRefs,
        trapFocus: context.open,
        disableOutsidePointerEvents: true,
        onCloseAutoFocus: composeEventHandlers(props.onCloseAutoFocus, (event) => {
          event.preventDefault();
          context.triggerRef.current?.focus();
        }),
        onPointerDownOutside: composeEventHandlers(props.onPointerDownOutside, (event) => {
          const originalEvent = event.detail.originalEvent;
          const ctrlLeftClick = originalEvent.button === 0 && originalEvent.ctrlKey === true;
          const isRightClick = originalEvent.button === 2 || ctrlLeftClick;
          if (isRightClick) event.preventDefault();
        }),
        onFocusOutside: composeEventHandlers(
          props.onFocusOutside,
          (event) => event.preventDefault()
        )
      }
    );
  }
);
var DialogContentNonModal = React34.forwardRef(
  (props, forwardedRef) => {
    const context = useDialogContext(CONTENT_NAME, props.__scopeDialog);
    const hasInteractedOutsideRef = React34.useRef(false);
    const hasPointerDownOutsideRef = React34.useRef(false);
    return jsx8(
      DialogContentImpl,
      {
        ...props,
        ref: forwardedRef,
        trapFocus: false,
        disableOutsidePointerEvents: false,
        onCloseAutoFocus: /* @__PURE__ */ __name((event) => {
          props.onCloseAutoFocus?.(event);
          if (!event.defaultPrevented) {
            if (!hasInteractedOutsideRef.current) context.triggerRef.current?.focus();
            event.preventDefault();
          }
          hasInteractedOutsideRef.current = false;
          hasPointerDownOutsideRef.current = false;
        }, "onCloseAutoFocus"),
        onInteractOutside: /* @__PURE__ */ __name((event) => {
          props.onInteractOutside?.(event);
          if (!event.defaultPrevented) {
            hasInteractedOutsideRef.current = true;
            if (event.detail.originalEvent.type === "pointerdown") {
              hasPointerDownOutsideRef.current = true;
            }
          }
          const target = event.target;
          const targetIsTrigger = context.triggerRef.current?.contains(target);
          if (targetIsTrigger) event.preventDefault();
          if (event.detail.originalEvent.type === "focusin" && hasPointerDownOutsideRef.current) {
            event.preventDefault();
          }
        }, "onInteractOutside")
      }
    );
  }
);
var DialogContentImpl = React34.forwardRef(
  (props, forwardedRef) => {
    const { __scopeDialog, trapFocus, onOpenAutoFocus, onCloseAutoFocus, ...contentProps } = props;
    const context = useDialogContext(CONTENT_NAME, __scopeDialog);
    const contentRef = React34.useRef(null);
    const composedRefs = useComposedRefs(forwardedRef, contentRef);
    useFocusGuards();
    return jsxs(Fragment7, { children: [
      jsx8(
        FocusScope,
        {
          asChild: true,
          loop: true,
          trapped: trapFocus,
          onMountAutoFocus: onOpenAutoFocus,
          onUnmountAutoFocus: onCloseAutoFocus,
          children: jsx8(
            DismissableLayer,
            {
              role: "dialog",
              id: context.contentId,
              "aria-describedby": context.descriptionId,
              "aria-labelledby": context.titleId,
              "data-state": getState(context.open),
              ...contentProps,
              ref: composedRefs,
              onDismiss: /* @__PURE__ */ __name(() => context.onOpenChange(false), "onDismiss")
            }
          )
        }
      ),
      jsxs(Fragment7, { children: [
        jsx8(TitleWarning, { titleId: context.titleId }),
        jsx8(DescriptionWarning, { contentRef, descriptionId: context.descriptionId })
      ] })
    ] });
  }
);
var TITLE_NAME = "DialogTitle";
var DialogTitle = React34.forwardRef(
  (props, forwardedRef) => {
    const { __scopeDialog, ...titleProps } = props;
    const context = useDialogContext(TITLE_NAME, __scopeDialog);
    return jsx8(Primitive.h2, { id: context.titleId, ...titleProps, ref: forwardedRef });
  }
);
DialogTitle.displayName = TITLE_NAME;
var DESCRIPTION_NAME = "DialogDescription";
var DialogDescription = React34.forwardRef(
  (props, forwardedRef) => {
    const { __scopeDialog, ...descriptionProps } = props;
    const context = useDialogContext(DESCRIPTION_NAME, __scopeDialog);
    return jsx8(Primitive.p, { id: context.descriptionId, ...descriptionProps, ref: forwardedRef });
  }
);
DialogDescription.displayName = DESCRIPTION_NAME;
var CLOSE_NAME = "DialogClose";
var DialogClose = React34.forwardRef(
  (props, forwardedRef) => {
    const { __scopeDialog, ...closeProps } = props;
    const context = useDialogContext(CLOSE_NAME, __scopeDialog);
    return jsx8(
      Primitive.button,
      {
        type: "button",
        ...closeProps,
        ref: forwardedRef,
        onClick: composeEventHandlers(props.onClick, () => context.onOpenChange(false))
      }
    );
  }
);
DialogClose.displayName = CLOSE_NAME;
function getState(open) {
  return open ? "open" : "closed";
}
__name(getState, "getState");
var TITLE_WARNING_NAME = "DialogTitleWarning";
var [WarningProvider, useWarningContext] = createContext2(TITLE_WARNING_NAME, {
  contentName: CONTENT_NAME,
  titleName: TITLE_NAME,
  docsSlug: "dialog"
});
var TitleWarning = /* @__PURE__ */ __name(({ titleId }) => {
  const titleWarningContext = useWarningContext(TITLE_WARNING_NAME);
  const MESSAGE = `\`${titleWarningContext.contentName}\` requires a \`${titleWarningContext.titleName}\` for the component to be accessible for screen reader users.

If you want to hide the \`${titleWarningContext.titleName}\`, you can wrap it with our VisuallyHidden component.

For more information, see https://radix-ui.com/primitives/docs/components/${titleWarningContext.docsSlug}`;
  React34.useEffect(() => {
    if (titleId) {
      const hasTitle = document.getElementById(titleId);
      if (!hasTitle) console.error(MESSAGE);
    }
  }, [MESSAGE, titleId]);
  return null;
}, "TitleWarning");
var DESCRIPTION_WARNING_NAME = "DialogDescriptionWarning";
var DescriptionWarning = /* @__PURE__ */ __name(({ contentRef, descriptionId }) => {
  const descriptionWarningContext = useWarningContext(DESCRIPTION_WARNING_NAME);
  const MESSAGE = `Warning: Missing \`Description\` or \`aria-describedby={undefined}\` for {${descriptionWarningContext.contentName}}.`;
  React34.useEffect(() => {
    const describedById = contentRef.current?.getAttribute("aria-describedby");
    if (descriptionId && describedById) {
      const hasDescription = document.getElementById(descriptionId);
      if (!hasDescription) console.warn(MESSAGE);
    }
  }, [MESSAGE, contentRef, descriptionId]);
  return null;
}, "DescriptionWarning");
var Root = Dialog;
var Trigger = DialogTrigger;
var Portal2 = DialogPortal;
var Overlay = DialogOverlay;
var Content = DialogContent;
var Title = DialogTitle;
var Description = DialogDescription;
var Close = DialogClose;

// src/components/components/Modal/Modal.styled.tsx
var Modal_styled_exports = {};
__export(Modal_styled_exports, {
  Actions: () => Actions,
  CloseButton: () => CloseButton,
  Col: () => Col,
  Container: () => Container,
  Content: () => Content2,
  Description: () => Description2,
  Error: () => Error2,
  ErrorWrapper: () => ErrorWrapper,
  Header: () => Header,
  Overlay: () => Overlay2,
  Row: () => Row,
  Title: () => Title2
});
import React38 from "react";
import { CrossIcon } from "@storybook/icons";
import { keyframes, styled as styled27 } from "storybook/theming";

// src/components/components/IconButton/IconButton.tsx
import React37, { forwardRef as forwardRef12 } from "react";

// src/components/components/Button/Button.tsx
import React36, { forwardRef as forwardRef11, useEffect as useEffect16, useState as useState12 } from "react";

// ../node_modules/@radix-ui/react-slot/dist/index.mjs
import * as React35 from "react";
import { Fragment as Fragment23, jsx as jsx9 } from "react/jsx-runtime";
var REACT_LAZY_TYPE = Symbol.for("react.lazy");
var use = React35[" use ".trim().toString()];
function isPromiseLike(value) {
  return typeof value === "object" && value !== null && "then" in value;
}
__name(isPromiseLike, "isPromiseLike");
function isLazyComponent(element) {
  return element != null && typeof element === "object" && "$$typeof" in element && element.$$typeof === REACT_LAZY_TYPE && "_payload" in element && isPromiseLike(element._payload);
}
__name(isLazyComponent, "isLazyComponent");
function createSlot3(ownerName) {
  const SlotClone = createSlotClone3(ownerName);
  const Slot22 = React35.forwardRef((props, forwardedRef) => {
    let { children, ...slotProps } = props;
    if (isLazyComponent(children) && typeof use === "function") {
      children = use(children._payload);
    }
    const childrenArray = React35.Children.toArray(children);
    const slottable = childrenArray.find(isSlottable3);
    if (slottable) {
      const newElement = slottable.props.children;
      const newChildren = childrenArray.map((child) => {
        if (child === slottable) {
          if (React35.Children.count(newElement) > 1) return React35.Children.only(null);
          return React35.isValidElement(newElement) ? newElement.props.children : null;
        } else {
          return child;
        }
      });
      return jsx9(SlotClone, { ...slotProps, ref: forwardedRef, children: React35.isValidElement(newElement) ? React35.cloneElement(newElement, void 0, newChildren) : null });
    }
    return jsx9(SlotClone, { ...slotProps, ref: forwardedRef, children });
  });
  Slot22.displayName = `${ownerName}.Slot`;
  return Slot22;
}
__name(createSlot3, "createSlot");
var Slot4 = createSlot3("Slot");
function createSlotClone3(ownerName) {
  const SlotClone = React35.forwardRef((props, forwardedRef) => {
    let { children, ...slotProps } = props;
    if (isLazyComponent(children) && typeof use === "function") {
      children = use(children._payload);
    }
    if (React35.isValidElement(children)) {
      const childrenRef = getElementRef4(children);
      const props2 = mergeProps3(slotProps, children.props);
      if (children.type !== React35.Fragment) {
        props2.ref = forwardedRef ? composeRefs(forwardedRef, childrenRef) : childrenRef;
      }
      return React35.cloneElement(children, props2);
    }
    return React35.Children.count(children) > 1 ? React35.Children.only(null) : null;
  });
  SlotClone.displayName = `${ownerName}.SlotClone`;
  return SlotClone;
}
__name(createSlotClone3, "createSlotClone");
var SLOTTABLE_IDENTIFIER3 = Symbol("radix.slottable");
function createSlottable3(ownerName) {
  const Slottable22 = /* @__PURE__ */ __name(({ children }) => {
    return jsx9(Fragment23, { children });
  }, "Slottable2");
  Slottable22.displayName = `${ownerName}.Slottable`;
  Slottable22.__radixId = SLOTTABLE_IDENTIFIER3;
  return Slottable22;
}
__name(createSlottable3, "createSlottable");
var Slottable3 = createSlottable3("Slottable");
function isSlottable3(child) {
  return React35.isValidElement(child) && typeof child.type === "function" && "__radixId" in child.type && child.type.__radixId === SLOTTABLE_IDENTIFIER3;
}
__name(isSlottable3, "isSlottable");
function mergeProps3(slotProps, childProps) {
  const overrideProps = { ...childProps };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      if (slotPropValue && childPropValue) {
        overrideProps[propName] = (...args) => {
          const result = childPropValue(...args);
          slotPropValue(...args);
          return result;
        };
      } else if (slotPropValue) {
        overrideProps[propName] = slotPropValue;
      }
    } else if (propName === "style") {
      overrideProps[propName] = { ...slotPropValue, ...childPropValue };
    } else if (propName === "className") {
      overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(" ");
    }
  }
  return { ...slotProps, ...overrideProps };
}
__name(mergeProps3, "mergeProps");
function getElementRef4(element) {
  let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
  let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.ref;
  }
  getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
  mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.props.ref;
  }
  return element.props.ref || element.ref;
}
__name(getElementRef4, "getElementRef");

// src/components/components/Button/Button.tsx
import { isPropValid, styled as styled26 } from "storybook/theming";
var Button = forwardRef11(
  ({
    asChild = false,
    animation = "none",
    size = "small",
    variant = "outline",
    padding = "medium",
    disabled = false,
    active = false,
    onClick,
    ...props
  }, ref) => {
    let Comp2 = "button";
    if (asChild) {
      Comp2 = Slot4;
    }
    const [isAnimating, setIsAnimating] = useState12(false);
    const handleClick = /* @__PURE__ */ __name((event) => {
      if (onClick) {
        onClick(event);
      }
      if (animation === "none") {
        return;
      }
      setIsAnimating(true);
    }, "handleClick");
    useEffect16(() => {
      const timer = setTimeout(() => {
        if (isAnimating) {
          setIsAnimating(false);
        }
      }, 1e3);
      return () => clearTimeout(timer);
    }, [isAnimating]);
    return React36.createElement(
      StyledButton,
      {
        as: Comp2,
        ref,
        variant,
        size,
        padding,
        disabled,
        active,
        animating: isAnimating,
        animation,
        onClick: handleClick,
        ...props
      }
    );
  }
);
Button.displayName = "Button";
var StyledButton = styled26("button", {
  shouldForwardProp: /* @__PURE__ */ __name((prop) => isPropValid(prop), "shouldForwardProp")
})(({ theme, variant, size, disabled, active, animating, animation = "none", padding }) => ({
  border: 0,
  cursor: disabled ? "not-allowed" : "pointer",
  display: "inline-flex",
  gap: "6px",
  alignItems: "center",
  justifyContent: "center",
  overflow: "hidden",
  padding: (() => {
    if (padding === "none") {
      return 0;
    }
    if (padding === "small" && size === "small") {
      return "0 7px";
    }
    if (padding === "small" && size === "medium") {
      return "0 9px";
    }
    if (size === "small") {
      return "0 10px";
    }
    if (size === "medium") {
      return "0 12px";
    }
    return 0;
  })(),
  height: size === "small" ? "28px" : "32px",
  position: "relative",
  textAlign: "center",
  textDecoration: "none",
  transitionProperty: "background, box-shadow",
  transitionDuration: "150ms",
  transitionTimingFunction: "ease-out",
  verticalAlign: "top",
  whiteSpace: "nowrap",
  userSelect: "none",
  opacity: disabled ? 0.5 : 1,
  margin: 0,
  fontSize: `${theme.typography.size.s1}px`,
  fontWeight: theme.typography.weight.bold,
  lineHeight: "1",
  background: (() => {
    if (variant === "solid") {
      return theme.color.secondary;
    }
    if (variant === "outline") {
      return theme.button.background;
    }
    if (variant === "ghost" && active) {
      return theme.background.hoverable;
    }
    return "transparent";
  })(),
  ...variant === "ghost" ? {
    // This is a hack to apply bar styles to the button as soon as it is part of a bar
    // It is a temporary solution until we have implemented Theming 2.0.
    ".sb-bar &": {
      background: (() => {
        if (active) {
          return curriedTransparentize$1(0.9, theme.barTextColor);
        }
        return "transparent";
      })(),
      color: (() => {
        if (active) {
          return theme.barSelectedColor;
        }
        return theme.barTextColor;
      })(),
      "&:hover": {
        color: theme.barHoverColor,
        background: curriedTransparentize$1(0.86, theme.barHoverColor)
      },
      "&:active": {
        color: theme.barSelectedColor,
        background: curriedTransparentize$1(0.9, theme.barSelectedColor)
      },
      "&:focus": {
        boxShadow: `${rgba(theme.barHoverColor, 1)} 0 0 0 1px inset`,
        outline: "none"
      }
    }
  } : {},
  color: (() => {
    if (variant === "solid") {
      return theme.color.lightest;
    }
    if (variant === "outline") {
      return theme.input.color;
    }
    if (variant === "ghost" && active) {
      return theme.color.secondary;
    }
    if (variant === "ghost") {
      return theme.color.mediumdark;
    }
    return theme.input.color;
  })(),
  boxShadow: variant === "outline" ? `${theme.button.border} 0 0 0 1px inset` : "none",
  borderRadius: theme.input.borderRadius,
  // Making sure that the button never shrinks below its minimum size
  flexShrink: 0,
  "&:hover": {
    color: variant === "ghost" ? theme.color.secondary : void 0,
    background: (() => {
      let bgColor = theme.color.secondary;
      if (variant === "solid") {
        bgColor = theme.color.secondary;
      }
      if (variant === "outline") {
        bgColor = theme.button.background;
      }
      if (variant === "ghost") {
        return curriedTransparentize$1(0.86, theme.color.secondary);
      }
      return theme.base === "light" ? curriedDarken$1(0.02, bgColor) : curriedLighten$1(0.03, bgColor);
    })()
  },
  "&:active": {
    color: variant === "ghost" ? theme.color.secondary : void 0,
    background: (() => {
      let bgColor = theme.color.secondary;
      if (variant === "solid") {
        bgColor = theme.color.secondary;
      }
      if (variant === "outline") {
        bgColor = theme.button.background;
      }
      if (variant === "ghost") {
        return theme.background.hoverable;
      }
      return theme.base === "light" ? curriedDarken$1(0.02, bgColor) : curriedLighten$1(0.03, bgColor);
    })()
  },
  "&:focus": {
    boxShadow: `${rgba(theme.color.secondary, 1)} 0 0 0 1px inset`,
    outline: "none"
  },
  "> svg": {
    animation: animating && animation !== "none" ? `${theme.animation[animation]} 1000ms ease-out` : ""
  }
}));

// src/components/components/IconButton/IconButton.tsx
var IconButton = forwardRef12(
  ({ padding = "small", variant = "ghost", ...props }, ref) => {
    return React37.createElement(Button, { padding, variant, ref, ...props });
  }
);
IconButton.displayName = "IconButton";

// src/components/components/Modal/Modal.styled.tsx
var fadeIn = keyframes({
  from: { opacity: 0 },
  to: { opacity: 1 }
});
var expand = keyframes({
  from: { maxHeight: 0 },
  to: {}
});
var zoomIn = keyframes({
  from: {
    opacity: 0,
    transform: "translate(-50%, -50%) scale(0.9)"
  },
  to: {
    opacity: 1,
    transform: "translate(-50%, -50%) scale(1)"
  }
});
var Overlay2 = styled27.div({
  backdropFilter: "blur(24px)",
  position: "fixed",
  inset: 0,
  width: "100%",
  height: "100%",
  zIndex: 10,
  animation: `${fadeIn} 200ms`
});
var Container = styled27.div(
  ({ theme, width, height }) => ({
    backgroundColor: theme.background.bar,
    borderRadius: 6,
    boxShadow: "0px 4px 67px 0px #00000040",
    position: "fixed",
    top: "50%",
    left: "50%",
    transform: "translate(-50%, -50%)",
    width: width ?? 740,
    height: height ?? "auto",
    maxWidth: "calc(100% - 40px)",
    maxHeight: "85vh",
    overflow: "auto",
    zIndex: 11,
    animation: `${zoomIn} 200ms`,
    "&:focus-visible": {
      outline: "none"
    }
  })
);
var CloseButton = /* @__PURE__ */ __name((props) => React38.createElement(Close, { asChild: true }, React38.createElement(IconButton, { "aria-label": "Close", ...props }, React38.createElement(CrossIcon, null))), "CloseButton");
var Content2 = styled27.div({
  display: "flex",
  flexDirection: "column",
  margin: 16,
  gap: 16
});
var Row = styled27.div({
  display: "flex",
  justifyContent: "space-between",
  gap: 16
});
var Col = styled27.div({
  display: "flex",
  flexDirection: "column",
  gap: 4
});
var Header = /* @__PURE__ */ __name((props) => React38.createElement(Row, null, React38.createElement(Col, { ...props }), React38.createElement(CloseButton, null)), "Header");
var Title2 = styled27(Title)(({ theme }) => ({
  margin: 0,
  fontSize: theme.typography.size.s3,
  fontWeight: theme.typography.weight.bold
}));
var Description2 = styled27(Description)(({ theme }) => ({
  position: "relative",
  zIndex: 1,
  margin: 0,
  fontSize: theme.typography.size.s2
}));
var Actions = styled27.div({
  display: "flex",
  flexDirection: "row-reverse",
  gap: 8
});
var ErrorWrapper = styled27.div(({ theme }) => ({
  maxHeight: 100,
  overflow: "auto",
  animation: `${expand} 300ms, ${fadeIn} 300ms`,
  backgroundColor: theme.background.critical,
  color: theme.color.lightest,
  fontSize: theme.typography.size.s2,
  "& > div": {
    position: "relative",
    padding: "8px 16px"
  }
}));
var Error2 = /* @__PURE__ */ __name(({
  children,
  ...props
}) => React38.createElement(ErrorWrapper, { ...props }, React38.createElement("div", null, children)), "Error");

// src/components/components/Modal/Modal.tsx
function BaseModal({
  children,
  width,
  height,
  onEscapeKeyDown,
  onInteractOutside = /* @__PURE__ */ __name((ev) => ev.preventDefault(), "onInteractOutside"),
  className,
  container,
  portalSelector,
  ...rootProps
}) {
  const containerElement = container ?? (portalSelector ? document.querySelector(portalSelector) : null) ?? document.body;
  return React39.createElement(Root, { ...rootProps }, React39.createElement(Portal2, { container: containerElement }, React39.createElement(Overlay, { asChild: true }, React39.createElement(Overlay2, null)), React39.createElement(
    Content,
    {
      asChild: true,
      onInteractOutside,
      onEscapeKeyDown
    },
    React39.createElement(Container, { className, width, height }, children)
  )));
}
__name(BaseModal, "BaseModal");
var Modal = Object.assign(BaseModal, Modal_styled_exports, { Dialog: dist_exports });

// src/components/components/spaced/Spaced.tsx
import React40 from "react";
import { ignoreSsrWarning, styled as styled28 } from "storybook/theming";
var toNumber = /* @__PURE__ */ __name((input) => typeof input === "number" ? input : Number(input), "toNumber");
var Container2 = styled28.div(
  ({ theme, col, row = 1 }) => col ? {
    display: "inline-block",
    verticalAlign: "inherit",
    "& > *": {
      marginLeft: col * theme.layoutMargin,
      verticalAlign: "inherit"
    },
    [`& > *:first-child${ignoreSsrWarning}`]: {
      marginLeft: 0
    }
  } : {
    "& > *": {
      marginTop: row * theme.layoutMargin
    },
    [`& > *:first-child${ignoreSsrWarning}`]: {
      marginTop: 0
    }
  },
  ({ theme, outer, col, row }) => {
    switch (true) {
      case !!(outer && col): {
        return {
          marginLeft: outer * theme.layoutMargin,
          marginRight: outer * theme.layoutMargin
        };
      }
      case !!(outer && row): {
        return {
          marginTop: outer * theme.layoutMargin,
          marginBottom: outer * theme.layoutMargin
        };
      }
      default: {
        return {};
      }
    }
  }
);
var Spaced = /* @__PURE__ */ __name(({ col, row, outer, children, ...rest }) => {
  const outerAmount = toNumber(typeof outer === "number" || !outer ? outer : col || row);
  return React40.createElement(Container2, { col, row, outer: outerAmount, ...rest }, children);
}, "Spaced");

// src/components/components/placeholder/placeholder.tsx
import React41, { Children as Children8 } from "react";
import { styled as styled29 } from "storybook/theming";
var Title3 = styled29.div(({ theme }) => ({
  fontWeight: theme.typography.weight.bold
}));
var Desc = styled29.div();
var Message = styled29.div(({ theme }) => ({
  padding: 30,
  textAlign: "center",
  color: theme.color.defaultText,
  fontSize: theme.typography.size.s2 - 1
}));
var Placeholder = /* @__PURE__ */ __name(({ children, ...props }) => {
  const [title, desc] = Children8.toArray(children);
  return React41.createElement(Message, { ...props }, React41.createElement(Title3, null, title), desc && React41.createElement(Desc, null, desc));
}, "Placeholder");

// src/components/components/Zoom/ZoomElement.tsx
import React42, { useCallback as useCallback9, useEffect as useEffect18, useRef as useRef13, useState as useState14 } from "react";
import { styled as styled30 } from "storybook/theming";

// ../node_modules/use-resize-observer/dist/bundle.esm.js
import { useRef as useRef12, useEffect as useEffect17, useCallback as useCallback8, useState as useState13, useMemo as useMemo6 } from "react";
function useResolvedElement(subscriber, refOrElement) {
  var lastReportRef = useRef12(null);
  var refOrElementRef = useRef12(null);
  refOrElementRef.current = refOrElement;
  var cbElementRef = useRef12(null);
  useEffect17(function() {
    evaluateSubscription();
  });
  var evaluateSubscription = useCallback8(function() {
    var cbElement = cbElementRef.current;
    var refOrElement2 = refOrElementRef.current;
    var element = cbElement ? cbElement : refOrElement2 ? refOrElement2 instanceof Element ? refOrElement2 : refOrElement2.current : null;
    if (lastReportRef.current && lastReportRef.current.element === element && lastReportRef.current.subscriber === subscriber) {
      return;
    }
    if (lastReportRef.current && lastReportRef.current.cleanup) {
      lastReportRef.current.cleanup();
    }
    lastReportRef.current = {
      element,
      subscriber,
      // Only calling the subscriber, if there's an actual element to report.
      // Setting cleanup to undefined unless a subscriber returns one, as an existing cleanup function would've been just called.
      cleanup: element ? subscriber(element) : void 0
    };
  }, [subscriber]);
  useEffect17(function() {
    return function() {
      if (lastReportRef.current && lastReportRef.current.cleanup) {
        lastReportRef.current.cleanup();
        lastReportRef.current = null;
      }
    };
  }, []);
  return useCallback8(function(element) {
    cbElementRef.current = element;
    evaluateSubscription();
  }, [evaluateSubscription]);
}
__name(useResolvedElement, "useResolvedElement");
function extractSize(entry, boxProp, sizeType) {
  if (!entry[boxProp]) {
    if (boxProp === "contentBoxSize") {
      return entry.contentRect[sizeType === "inlineSize" ? "width" : "height"];
    }
    return void 0;
  }
  return entry[boxProp][0] ? entry[boxProp][0][sizeType] : (
    // TS complains about this, because the RO entry type follows the spec and does not reflect Firefox's current
    // behaviour of returning objects instead of arrays for `borderBoxSize` and `contentBoxSize`.
    // @ts-ignore
    entry[boxProp][sizeType]
  );
}
__name(extractSize, "extractSize");
function useResizeObserver(opts) {
  if (opts === void 0) {
    opts = {};
  }
  var onResize = opts.onResize;
  var onResizeRef = useRef12(void 0);
  onResizeRef.current = onResize;
  var round = opts.round || Math.round;
  var resizeObserverRef = useRef12();
  var _useState = useState13({
    width: void 0,
    height: void 0
  }), size = _useState[0], setSize = _useState[1];
  var didUnmount = useRef12(false);
  useEffect17(function() {
    didUnmount.current = false;
    return function() {
      didUnmount.current = true;
    };
  }, []);
  var previous = useRef12({
    width: void 0,
    height: void 0
  });
  var refCallback = useResolvedElement(useCallback8(function(element) {
    if (!resizeObserverRef.current || resizeObserverRef.current.box !== opts.box || resizeObserverRef.current.round !== round) {
      resizeObserverRef.current = {
        box: opts.box,
        round,
        instance: new ResizeObserver(function(entries) {
          var entry = entries[0];
          var boxProp = opts.box === "border-box" ? "borderBoxSize" : opts.box === "device-pixel-content-box" ? "devicePixelContentBoxSize" : "contentBoxSize";
          var reportedWidth = extractSize(entry, boxProp, "inlineSize");
          var reportedHeight = extractSize(entry, boxProp, "blockSize");
          var newWidth = reportedWidth ? round(reportedWidth) : void 0;
          var newHeight = reportedHeight ? round(reportedHeight) : void 0;
          if (previous.current.width !== newWidth || previous.current.height !== newHeight) {
            var newSize = {
              width: newWidth,
              height: newHeight
            };
            previous.current.width = newWidth;
            previous.current.height = newHeight;
            if (onResizeRef.current) {
              onResizeRef.current(newSize);
            } else {
              if (!didUnmount.current) {
                setSize(newSize);
              }
            }
          }
        })
      };
    }
    resizeObserverRef.current.instance.observe(element, {
      box: opts.box
    });
    return function() {
      if (resizeObserverRef.current) {
        resizeObserverRef.current.instance.unobserve(element);
      }
    };
  }, [opts.box, round]), opts.ref);
  return useMemo6(function() {
    return {
      ref: refCallback,
      width: size.width,
      height: size.height
    };
  }, [refCallback, size.width, size.height]);
}
__name(useResizeObserver, "useResizeObserver");

// src/components/components/Zoom/ZoomElement.tsx
var ZoomElementWrapper = styled30.div(
  ({ centered = false, scale = 1, elementHeight }) => ({
    height: elementHeight || "auto",
    transformOrigin: centered ? "center top" : "left top",
    transform: `scale(${1 / scale})`
  })
);
function ZoomElement({ centered, scale, children }) {
  const componentWrapperRef = useRef13(null);
  const [elementHeight, setElementHeight] = useState14(0);
  const onResize = useCallback9(
    ({ height }) => {
      if (height) {
        setElementHeight(height / scale);
      }
    },
    [scale]
  );
  useEffect18(() => {
    if (componentWrapperRef.current) {
      setElementHeight(componentWrapperRef.current.getBoundingClientRect().height);
    }
  }, [scale]);
  useResizeObserver({
    ref: componentWrapperRef,
    onResize
  });
  return React42.createElement(ZoomElementWrapper, { centered, scale, elementHeight }, React42.createElement("div", { ref: componentWrapperRef, className: "innerZoomElementWrapper" }, children));
}
__name(ZoomElement, "ZoomElement");

// src/components/components/Zoom/ZoomIFrame.tsx
import React43, { Component } from "react";
var _ZoomIFrame = class _ZoomIFrame extends Component {
  constructor() {
    super(...arguments);
    // @ts-expect-error (non strict)
    this.iframe = null;
  }
  componentDidMount() {
    const { iFrameRef } = this.props;
    this.iframe = iFrameRef.current;
  }
  shouldComponentUpdate(nextProps) {
    const { scale, active } = this.props;
    if (scale !== nextProps.scale) {
      this.setIframeInnerZoom(nextProps.scale);
    }
    if (active !== nextProps.active) {
      this.iframe.setAttribute("data-is-storybook", nextProps.active ? "true" : "false");
    }
    return nextProps.children.props.src !== this.props.children.props.src;
  }
  setIframeInnerZoom(scale) {
    try {
      Object.assign(this.iframe.contentDocument.body.style, {
        width: `${scale * 100}%`,
        height: `${scale * 100}%`,
        transform: `scale(${1 / scale})`,
        transformOrigin: "top left"
      });
    } catch (e) {
      this.setIframeZoom(scale);
    }
  }
  setIframeZoom(scale) {
    Object.assign(this.iframe.style, {
      width: `${scale * 100}%`,
      height: `${scale * 100}%`,
      transform: `scale(${1 / scale})`,
      transformOrigin: "top left"
    });
  }
  render() {
    const { children } = this.props;
    return React43.createElement(React43.Fragment, null, children);
  }
};
__name(_ZoomIFrame, "ZoomIFrame");
var ZoomIFrame = _ZoomIFrame;

// src/components/components/Zoom/Zoom.tsx
var Zoom = {
  Element: ZoomElement,
  IFrame: ZoomIFrame
};

// src/components/components/ErrorFormatter/ErrorFormatter.tsx
import React44, { Fragment as Fragment9 } from "react";
import { global } from "@storybook/global";
import { styled as styled31 } from "storybook/theming";
var { document: document2 } = global;
var ErrorName = styled31.strong(({ theme }) => ({
  color: theme.color.orange
}));
var ErrorImportant = styled31.strong(({ theme }) => ({
  color: theme.color.ancillary,
  textDecoration: "underline"
}));
var ErrorDetail = styled31.em(({ theme }) => ({
  color: theme.textMutedColor
}));
var firstLineRegex = /(Error): (.*)\n/;
var linesRegexChromium = /at (?:(.*) )?\(?(.+)\)?/;
var linesRegexFirefox = /([^@]+)?(?:\/<)?@(.+)?/;
var linesRegexSafari = /([^@]+)?@(.+)?/;
var ErrorFormatter = /* @__PURE__ */ __name(({ error }) => {
  if (!error) {
    return React44.createElement(Fragment9, null, "This error has no stack or message");
  }
  if (!error.stack) {
    return React44.createElement(Fragment9, null, error.message || "This error has no stack or message");
  }
  let input = error.stack.toString();
  if (input && error.message && !input.includes(error.message)) {
    input = `Error: ${error.message}

${input}`;
  }
  const match = input.match(firstLineRegex);
  if (!match) {
    return React44.createElement(Fragment9, null, input);
  }
  const [, type, name] = match;
  const rawLines = input.split(/\n/).slice(1);
  const [, ...lines] = rawLines.map((line) => {
    const result = line.match(linesRegexChromium) || line.match(linesRegexFirefox) || line.match(linesRegexSafari);
    if (result) {
      return {
        name: (result[1] || "").replace("/<", ""),
        location: result[2].replace(document2.location.origin, "")
      };
    }
    return null;
  }).filter(Boolean);
  return React44.createElement(Fragment9, null, React44.createElement("span", null, type), ": ", React44.createElement(ErrorName, null, name), React44.createElement("br", null), lines.map(
    (l, i) => l?.name ? React44.createElement(Fragment9, { key: i }, "  ", "at ", React44.createElement(ErrorImportant, null, l.name), " (", React44.createElement(ErrorDetail, null, l.location), ")", React44.createElement("br", null)) : React44.createElement(Fragment9, { key: i }, "  ", "at ", React44.createElement(ErrorDetail, null, l?.location), React44.createElement("br", null))
  ));
}, "ErrorFormatter");

// src/components/components/Form/Form.tsx
import { styled as styled38 } from "storybook/theming";

// src/components/components/Form/Checkbox.tsx
import React45 from "react";
import { color, styled as styled32 } from "storybook/theming";
var Input = styled32.input({
  appearance: "none",
  display: "grid",
  placeContent: "center",
  width: 14,
  height: 14,
  flexShrink: 0,
  margin: 0,
  border: `1px solid ${color.border}`,
  borderRadius: 2,
  backgroundColor: "white",
  transition: "background-color 0.1s",
  "&:enabled": {
    cursor: "pointer"
  },
  "&:disabled": {
    backgroundColor: color.medium
  },
  "&:disabled:checked, &:disabled:indeterminate": {
    backgroundColor: color.mediumdark
  },
  "&:checked, &:indeterminate": {
    backgroundColor: color.secondary
  },
  "&:checked::before": {
    content: '""',
    width: 14,
    height: 14,
    background: `no-repeat center url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='14' height='14'%3E%3Cpath fill='none' stroke='%23fff' stroke-width='2' d='m3 7 2.5 2.5L11 4'/%3E%3C/svg%3E")`
  },
  "&:indeterminate::before": {
    content: '""',
    width: 8,
    height: 2,
    background: "white"
  },
  "&:enabled:focus-visible": {
    outline: `1px solid ${color.secondary}`,
    outlineOffset: 1
  }
});
var Checkbox = /* @__PURE__ */ __name((props) => {
  return React45.createElement(Input, { ...props, type: "checkbox" });
}, "Checkbox");

// src/components/components/Form/Field.tsx
import React46 from "react";
import { styled as styled33 } from "storybook/theming";
var Wrapper = styled33.label(({ theme }) => ({
  display: "flex",
  borderBottom: `1px solid ${theme.appBorderColor}`,
  margin: "0 15px",
  padding: "8px 0",
  "&:last-child": {
    marginBottom: "3rem"
  }
}));
var Label = styled33.span(({ theme }) => ({
  minWidth: 100,
  fontWeight: theme.typography.weight.bold,
  marginRight: 15,
  display: "flex",
  justifyContent: "flex-start",
  alignItems: "center",
  lineHeight: "16px"
}));
var Field = /* @__PURE__ */ __name(({ label, children, ...props }) => React46.createElement(Wrapper, { ...props }, label ? React46.createElement(Label, null, React46.createElement("span", null, label)) : null, children), "Field");

// src/components/components/Form/Input.tsx
import React47 from "react";
import { forwardRef as forwardRef13 } from "react";
import { styled as styled34 } from "storybook/theming";

// src/components/components/Form/styles.ts
var sizes = /* @__PURE__ */ __name(({ size }) => {
  switch (size) {
    case "100%": {
      return { width: "100%" };
    }
    case "flex": {
      return { flex: 1 };
    }
    case "auto":
    default: {
      return { display: "inline" };
    }
  }
}, "sizes");
var alignment = /* @__PURE__ */ __name(({
  align
}) => {
  switch (align) {
    case "end": {
      return { textAlign: "right" };
    }
    case "center": {
      return { textAlign: "center" };
    }
    case "start":
    default: {
      return { textAlign: "left" };
    }
  }
}, "alignment");
var validation = /* @__PURE__ */ __name(({
  valid,
  theme
}) => {
  switch (valid) {
    case "valid": {
      return { boxShadow: `${theme.color.positive} 0 0 0 1px inset !important` };
    }
    case "error": {
      return { boxShadow: `${theme.color.negative} 0 0 0 1px inset !important` };
    }
    case "warn": {
      return {
        boxShadow: `${theme.color.warning} 0 0 0 1px inset`
      };
    }
    case void 0:
    case null:
    default: {
      return {};
    }
  }
}, "validation");
var styleResets = {
  // resets
  appearance: "none",
  border: "0 none",
  boxSizing: "inherit",
  display: " block",
  margin: " 0",
  background: "transparent",
  padding: 0,
  fontSize: "inherit",
  position: "relative"
};
var styles = /* @__PURE__ */ __name(({ theme }) => ({
  ...styleResets,
  transition: "box-shadow 200ms ease-out, opacity 200ms ease-out",
  color: theme.input.color || "inherit",
  background: theme.input.background,
  boxShadow: `${theme.input.border} 0 0 0 1px inset`,
  borderRadius: theme.input.borderRadius,
  fontSize: theme.typography.size.s2 - 1,
  lineHeight: "20px",
  padding: "6px 10px",
  // 32
  boxSizing: "border-box",
  height: 32,
  '&[type="file"]': {
    height: "auto"
  },
  "&:focus": {
    boxShadow: `${theme.color.secondary} 0 0 0 1px inset`,
    outline: "none",
    "@media (forced-colors: active)": {
      outline: "1px solid highlight"
    }
  },
  "&[disabled]": {
    cursor: "not-allowed",
    opacity: 0.5
  },
  "&:-webkit-autofill": { WebkitBoxShadow: `0 0 0 3em ${theme.color.lightest} inset` },
  "&::placeholder": {
    color: theme.textMutedColor,
    opacity: 1
  }
}), "styles");

// src/components/components/Form/Input.tsx
var Input2 = Object.assign(
  styled34(
    forwardRef13(/* @__PURE__ */ __name(function Input3({ size, valid, align, ...props }, ref) {
      return React47.createElement("input", { ...props, ref });
    }, "Input"))
  )(styles, sizes, alignment, validation, {
    minHeight: 32
  }),
  {
    displayName: "Input"
  }
);

// src/components/components/Form/Radio.tsx
import React48 from "react";
import { color as color2, styled as styled35 } from "storybook/theming";
var Input4 = styled35.input({
  appearance: "none",
  display: "grid",
  placeContent: "center",
  width: 16,
  height: 16,
  flexShrink: 0,
  margin: -1,
  border: `1px solid ${color2.border}`,
  borderRadius: 8,
  backgroundColor: "white",
  transition: "background-color 0.1s",
  "&:enabled": {
    cursor: "pointer"
  },
  "&:disabled": {
    backgroundColor: color2.medium
  },
  "&:disabled:checked": {
    backgroundColor: color2.mediumdark
  },
  "&:checked": {
    backgroundColor: color2.secondary,
    boxShadow: `inset 0 0 0 2px white`
  },
  "&:enabled:focus-visible": {
    outline: `1px solid ${color2.secondary}`,
    outlineOffset: 1
  }
});
var Radio = /* @__PURE__ */ __name((props) => {
  return React48.createElement(Input4, { ...props, type: "radio" });
}, "Radio");

// src/components/components/Form/Select.tsx
import React49 from "react";
import { lighten, styled as styled36 } from "storybook/theming";
var BaseSelect = styled36.select(sizes, ({ theme }) => ({
  appearance: "none",
  background: `calc(100% - 12px) center no-repeat url("data:image/svg+xml,%3Csvg width='8' height='4' viewBox='0 0 8 4' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M1.30303 0.196815C1.13566 0.0294472 0.864304 0.0294472 0.696937 0.196815C0.529569 0.364182 0.529569 0.635539 0.696937 0.802906L3.69694 3.80291C3.8643 3.97027 4.13566 3.97027 4.30303 3.80291L7.30303 0.802906C7.4704 0.635539 7.4704 0.364182 7.30303 0.196815C7.13566 0.0294473 6.8643 0.0294473 6.69694 0.196815L3.99998 2.89377L1.30303 0.196815Z' fill='%2373828C'/%3E%3C/svg%3E%0A")`,
  backgroundSize: 10,
  padding: "6px 30px 6px 10px",
  "@supports (appearance: base-select)": {
    appearance: "base-select",
    background: theme.input.background,
    padding: "6px 10px"
  },
  transition: "box-shadow 200ms ease-out, opacity 200ms ease-out",
  color: theme.input.color || "inherit",
  boxShadow: `${theme.input.border} 0 0 0 1px inset`,
  borderRadius: theme.input.borderRadius,
  fontSize: theme.typography.size.s2 - 1,
  lineHeight: "20px",
  boxSizing: "border-box",
  border: "none",
  cursor: "pointer",
  "& > button": {
    display: "flex",
    alignItems: "center",
    justifyContent: "space-between",
    width: "100%",
    gap: 8,
    "& > svg": {
      width: 14,
      height: 14,
      color: theme.color.mediumdark
    }
  },
  "&:has(option:not([hidden]):checked)": {
    color: theme.color.defaultText
  },
  "&:focus-visible, &:focus-within": {
    outline: "none",
    boxShadow: `${theme.color.secondary} 0 0 0 1px inset`
  },
  "&::picker-icon": {
    display: "none"
  },
  "&::picker(select)": {
    appearance: "base-select",
    border: "1px solid #e4e4e7",
    padding: 4,
    marginTop: 4,
    background: theme.base === "light" ? lighten(theme.background.app) : theme.background.app,
    filter: `
      drop-shadow(0 5px 5px rgba(0,0,0,0.05))
      drop-shadow(0 0 3px rgba(0,0,0,0.1))
    `,
    borderRadius: theme.appBorderRadius + 2,
    fontSize: theme.typography.size.s1,
    cursor: "default",
    transition: "opacity 100ms ease-in-out, transform 100ms ease-in-out",
    transformOrigin: "top",
    transform: "translateY(0)",
    opacity: 1,
    "@starting-style": {
      transform: "translateY(-0.25rem) scale(0.95)",
      opacity: 0
    }
  },
  "& optgroup label": {
    display: "block",
    padding: "3px 6px"
  },
  "& option": {
    lineHeight: "18px",
    padding: "7px 10px",
    borderRadius: 4,
    outline: "none",
    cursor: "pointer",
    color: theme.color.defaultText,
    "&::checkmark": {
      display: "none"
    },
    "&:hover, &:focus-visible": {
      backgroundColor: theme.background.hoverable
    },
    "&:checked": {
      color: theme.color.secondary,
      fontWeight: theme.typography.weight.bold
    },
    "&:disabled": {
      backgroundColor: "transparent",
      cursor: "default",
      color: theme.color.defaultText
    }
  }
}));
var Select = /* @__PURE__ */ __name(({ children, ...props }) => {
  return (
    // @ts-expect-error Weird props mismatch
    React49.createElement(BaseSelect, { ...props }, !isTestEnvironment() && React49.createElement("button", null, React49.createElement("selectedcontent", null), React49.createElement(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        strokeWidth: "2",
        strokeLinecap: "round",
        strokeLinejoin: "round",
        "aria-hidden": "true"
      },
      React49.createElement("path", { d: "m6 9 6 6 6-6" })
    )), React49.createElement("optgroup", null, children))
  );
}, "Select");

// src/components/components/Form/Textarea.tsx
import React53, { forwardRef as forwardRef15 } from "react";

// ../node_modules/react-textarea-autosize/dist/react-textarea-autosize.browser.esm.js
import * as React52 from "react";

// ../node_modules/use-latest/dist/use-latest.esm.js
import React50 from "react";

// ../node_modules/use-isomorphic-layout-effect/dist/use-isomorphic-layout-effect.browser.esm.js
import { useLayoutEffect as useLayoutEffect5 } from "react";
var index = useLayoutEffect5;

// ../node_modules/use-latest/dist/use-latest.esm.js
var useLatest = /* @__PURE__ */ __name(function useLatest2(value) {
  var ref = React50.useRef(value);
  index(function() {
    ref.current = value;
  });
  return ref;
}, "useLatest");

// ../node_modules/use-composed-ref/dist/use-composed-ref.esm.js
import React51 from "react";
var updateRef = /* @__PURE__ */ __name(function updateRef2(ref, value) {
  if (typeof ref === "function") {
    ref(value);
    return;
  }
  ref.current = value;
}, "updateRef");
var useComposedRef = /* @__PURE__ */ __name(function useComposedRef2(libRef, userRef) {
  var prevUserRef = React51.useRef();
  return React51.useCallback(function(instance) {
    libRef.current = instance;
    if (prevUserRef.current) {
      updateRef(prevUserRef.current, null);
    }
    prevUserRef.current = userRef;
    if (!userRef) {
      return;
    }
    updateRef(userRef, instance);
  }, [userRef]);
}, "useComposedRef");

// ../node_modules/react-textarea-autosize/dist/react-textarea-autosize.browser.esm.js
var HIDDEN_TEXTAREA_STYLE = {
  "min-height": "0",
  "max-height": "none",
  height: "0",
  visibility: "hidden",
  overflow: "hidden",
  position: "absolute",
  "z-index": "-1000",
  top: "0",
  right: "0",
  display: "block"
};
var forceHiddenStyles = /* @__PURE__ */ __name(function forceHiddenStyles2(node) {
  Object.keys(HIDDEN_TEXTAREA_STYLE).forEach(function(key) {
    node.style.setProperty(key, HIDDEN_TEXTAREA_STYLE[key], "important");
  });
}, "forceHiddenStyles");
var forceHiddenStyles$1 = forceHiddenStyles;
var hiddenTextarea = null;
var getHeight = /* @__PURE__ */ __name(function getHeight2(node, sizingData) {
  var height = node.scrollHeight;
  if (sizingData.sizingStyle.boxSizing === "border-box") {
    return height + sizingData.borderSize;
  }
  return height - sizingData.paddingSize;
}, "getHeight");
function calculateNodeHeight(sizingData, value, minRows, maxRows) {
  if (minRows === void 0) {
    minRows = 1;
  }
  if (maxRows === void 0) {
    maxRows = Infinity;
  }
  if (!hiddenTextarea) {
    hiddenTextarea = document.createElement("textarea");
    hiddenTextarea.setAttribute("tabindex", "-1");
    hiddenTextarea.setAttribute("aria-hidden", "true");
    forceHiddenStyles$1(hiddenTextarea);
  }
  if (hiddenTextarea.parentNode === null) {
    document.body.appendChild(hiddenTextarea);
  }
  var paddingSize = sizingData.paddingSize, borderSize = sizingData.borderSize, sizingStyle = sizingData.sizingStyle;
  var boxSizing = sizingStyle.boxSizing;
  Object.keys(sizingStyle).forEach(function(_key) {
    var key = _key;
    hiddenTextarea.style[key] = sizingStyle[key];
  });
  forceHiddenStyles$1(hiddenTextarea);
  hiddenTextarea.value = value;
  var height = getHeight(hiddenTextarea, sizingData);
  hiddenTextarea.value = value;
  height = getHeight(hiddenTextarea, sizingData);
  hiddenTextarea.value = "x";
  var rowHeight = hiddenTextarea.scrollHeight - paddingSize;
  var minHeight = rowHeight * minRows;
  if (boxSizing === "border-box") {
    minHeight = minHeight + paddingSize + borderSize;
  }
  height = Math.max(minHeight, height);
  var maxHeight = rowHeight * maxRows;
  if (boxSizing === "border-box") {
    maxHeight = maxHeight + paddingSize + borderSize;
  }
  height = Math.min(maxHeight, height);
  return [height, rowHeight];
}
__name(calculateNodeHeight, "calculateNodeHeight");
var noop = /* @__PURE__ */ __name(function noop2() {
}, "noop");
var pick = /* @__PURE__ */ __name(function pick2(props, obj) {
  return props.reduce(function(acc, prop) {
    acc[prop] = obj[prop];
    return acc;
  }, {});
}, "pick");
var SIZING_STYLE = [
  "borderBottomWidth",
  "borderLeftWidth",
  "borderRightWidth",
  "borderTopWidth",
  "boxSizing",
  "fontFamily",
  "fontSize",
  "fontStyle",
  "fontWeight",
  "letterSpacing",
  "lineHeight",
  "paddingBottom",
  "paddingLeft",
  "paddingRight",
  "paddingTop",
  // non-standard
  "tabSize",
  "textIndent",
  // non-standard
  "textRendering",
  "textTransform",
  "width",
  "wordBreak",
  "wordSpacing",
  "scrollbarGutter"
];
var isIE = !!document.documentElement.currentStyle;
var getSizingData = /* @__PURE__ */ __name(function getSizingData2(node) {
  var style = window.getComputedStyle(node);
  if (style === null) {
    return null;
  }
  var sizingStyle = pick(SIZING_STYLE, style);
  var boxSizing = sizingStyle.boxSizing;
  if (boxSizing === "") {
    return null;
  }
  if (isIE && boxSizing === "border-box") {
    sizingStyle.width = parseFloat(sizingStyle.width) + parseFloat(sizingStyle.borderRightWidth) + parseFloat(sizingStyle.borderLeftWidth) + parseFloat(sizingStyle.paddingRight) + parseFloat(sizingStyle.paddingLeft) + "px";
  }
  var paddingSize = parseFloat(sizingStyle.paddingBottom) + parseFloat(sizingStyle.paddingTop);
  var borderSize = parseFloat(sizingStyle.borderBottomWidth) + parseFloat(sizingStyle.borderTopWidth);
  return {
    sizingStyle,
    paddingSize,
    borderSize
  };
}, "getSizingData");
var getSizingData$1 = getSizingData;
function useListener(target, type, listener) {
  var latestListener = useLatest(listener);
  React52.useLayoutEffect(function() {
    var handler = /* @__PURE__ */ __name(function handler2(ev) {
      return latestListener.current(ev);
    }, "handler");
    if (!target) {
      return;
    }
    target.addEventListener(type, handler);
    return function() {
      return target.removeEventListener(type, handler);
    };
  }, []);
}
__name(useListener, "useListener");
var useFormResetListener = /* @__PURE__ */ __name(function useFormResetListener2(libRef, listener) {
  useListener(document.body, "reset", function(ev) {
    if (libRef.current.form === ev.target) {
      listener(ev);
    }
  });
}, "useFormResetListener");
var useWindowResizeListener = /* @__PURE__ */ __name(function useWindowResizeListener2(listener) {
  useListener(window, "resize", listener);
}, "useWindowResizeListener");
var useFontsLoadedListener = /* @__PURE__ */ __name(function useFontsLoadedListener2(listener) {
  useListener(document.fonts, "loadingdone", listener);
}, "useFontsLoadedListener");
var _excluded = ["cacheMeasurements", "maxRows", "minRows", "onChange", "onHeightChange"];
var TextareaAutosize = /* @__PURE__ */ __name(function TextareaAutosize2(_ref, userRef) {
  var cacheMeasurements = _ref.cacheMeasurements, maxRows = _ref.maxRows, minRows = _ref.minRows, _ref$onChange = _ref.onChange, onChange = _ref$onChange === void 0 ? noop : _ref$onChange, _ref$onHeightChange = _ref.onHeightChange, onHeightChange = _ref$onHeightChange === void 0 ? noop : _ref$onHeightChange, props = _objectWithoutPropertiesLoose(_ref, _excluded);
  var isControlled = props.value !== void 0;
  var libRef = React52.useRef(null);
  var ref = useComposedRef(libRef, userRef);
  var heightRef = React52.useRef(0);
  var measurementsCacheRef = React52.useRef();
  var resizeTextarea = /* @__PURE__ */ __name(function resizeTextarea2() {
    var node = libRef.current;
    var nodeSizingData = cacheMeasurements && measurementsCacheRef.current ? measurementsCacheRef.current : getSizingData$1(node);
    if (!nodeSizingData) {
      return;
    }
    measurementsCacheRef.current = nodeSizingData;
    var _calculateNodeHeight = calculateNodeHeight(nodeSizingData, node.value || node.placeholder || "x", minRows, maxRows), height = _calculateNodeHeight[0], rowHeight = _calculateNodeHeight[1];
    if (heightRef.current !== height) {
      heightRef.current = height;
      node.style.setProperty("height", height + "px", "important");
      onHeightChange(height, {
        rowHeight
      });
    }
  }, "resizeTextarea");
  var handleChange = /* @__PURE__ */ __name(function handleChange2(event) {
    if (!isControlled) {
      resizeTextarea();
    }
    onChange(event);
  }, "handleChange");
  {
    React52.useLayoutEffect(resizeTextarea);
    useFormResetListener(libRef, function() {
      if (!isControlled) {
        var currentValue = libRef.current.value;
        requestAnimationFrame(function() {
          var node = libRef.current;
          if (node && currentValue !== node.value) {
            resizeTextarea();
          }
        });
      }
    });
    useWindowResizeListener(resizeTextarea);
    useFontsLoadedListener(resizeTextarea);
    return React52.createElement("textarea", _extends({}, props, {
      onChange: handleChange,
      ref
    }));
  }
}, "TextareaAutosize");
var index2 = React52.forwardRef(TextareaAutosize);

// src/components/components/Form/Textarea.tsx
import { styled as styled37 } from "storybook/theming";
var Textarea = Object.assign(
  styled37(
    forwardRef15(/* @__PURE__ */ __name(function Textarea2({ size, valid, align, ...props }, ref) {
      return React53.createElement(index2, { ...props, ref });
    }, "Textarea"))
  )(styles, sizes, alignment, validation, ({ height = 400 }) => ({
    overflow: "visible",
    maxHeight: height
  })),
  {
    displayName: "Textarea"
  }
);

// src/components/components/Form/Form.tsx
var Form = Object.assign(
  styled38.form({
    boxSizing: "border-box",
    width: "100%"
  }),
  {
    Field,
    Input: Input2,
    Select,
    Textarea,
    Button,
    Checkbox,
    Radio
  }
);

// src/components/components/tooltip/lazy-WithTooltip.tsx
import React54, { Suspense as Suspense2, lazy as lazy2 } from "react";
var LazyWithTooltip = lazy2(
  () => import("../_browser-chunks/WithTooltip-SK46ZJ2J.js").then((mod) => ({ default: mod.WithTooltip }))
);
var WithTooltip = /* @__PURE__ */ __name((props) => React54.createElement(Suspense2, { fallback: React54.createElement("div", null) }, React54.createElement(LazyWithTooltip, { ...props })), "WithTooltip");
var LazyWithTooltipPure = lazy2(
  () => import("../_browser-chunks/WithTooltip-SK46ZJ2J.js").then((mod) => ({ default: mod.WithTooltipPure }))
);
var WithTooltipPure = /* @__PURE__ */ __name((props) => React54.createElement(Suspense2, { fallback: React54.createElement("div", null) }, React54.createElement(LazyWithTooltipPure, { ...props })), "WithTooltipPure");

// src/components/components/tooltip/TooltipMessage.tsx
import React55 from "react";
import { styled as styled39 } from "storybook/theming";
var Title4 = styled39.div(({ theme }) => ({
  fontWeight: theme.typography.weight.bold
}));
var Desc2 = styled39.span();
var Links = styled39.div(({ theme }) => ({
  marginTop: 8,
  textAlign: "center",
  "> *": {
    margin: "0 8px",
    fontWeight: theme.typography.weight.bold
  }
}));
var Message2 = styled39.div(({ theme }) => ({
  color: theme.color.defaultText,
  lineHeight: "18px"
}));
var MessageWrapper = styled39.div({
  padding: 15,
  width: 280,
  boxSizing: "border-box"
});
var TooltipMessage = /* @__PURE__ */ __name(({ title, desc, links }) => {
  return React55.createElement(MessageWrapper, null, React55.createElement(Message2, null, title && React55.createElement(Title4, null, title), desc && React55.createElement(Desc2, null, desc)), links && React55.createElement(Links, null, links.map(({ title: linkTitle, ...other }) => React55.createElement(Link2, { ...other, key: linkTitle }, linkTitle))));
}, "TooltipMessage");

// src/components/components/tooltip/TooltipNote.tsx
import React56 from "react";
import { styled as styled40 } from "storybook/theming";
var Note = styled40.div(({ theme }) => ({
  padding: "2px 6px",
  lineHeight: "16px",
  fontSize: 10,
  fontWeight: theme.typography.weight.bold,
  color: theme.color.lightest,
  boxShadow: "0 0 5px 0 rgba(0, 0, 0, 0.3)",
  borderRadius: 4,
  whiteSpace: "nowrap",
  pointerEvents: "none",
  zIndex: -1,
  background: theme.base === "light" ? "rgba(60, 60, 60, 0.9)" : "rgba(0, 0, 0, 0.95)",
  margin: 6
}));
var TooltipNote = /* @__PURE__ */ __name(({ note, ...props }) => {
  return React56.createElement(Note, { ...props }, note);
}, "TooltipNote");

// src/components/components/tooltip/TooltipLinkList.tsx
import React58, { Fragment as Fragment10, useCallback as useCallback10 } from "react";
import { styled as styled42 } from "storybook/theming";

// src/components/components/tooltip/ListItem.tsx
var import_memoizerific = __toESM(require_memoizerific(), 1);
import React57 from "react";
import { styled as styled41 } from "storybook/theming";
var Title5 = styled41(({ active, loading, disabled, ...rest }) => React57.createElement("span", { ...rest }))(
  ({ theme }) => ({
    color: theme.color.defaultText,
    // Previously was theme.typography.weight.normal but this weight does not exists in Theme
    fontWeight: theme.typography.weight.regular
  }),
  ({ active, theme }) => active ? {
    color: theme.color.secondary,
    fontWeight: theme.typography.weight.bold
  } : {},
  ({ loading, theme }) => loading ? {
    display: "inline-block",
    flex: "none",
    ...theme.animation.inlineGlow
  } : {},
  ({ disabled, theme }) => disabled ? {
    color: theme.textMutedColor
  } : {}
);
var Right = styled41.span({
  display: "flex",
  "& svg": {
    height: 12,
    width: 12,
    margin: "3px 0",
    verticalAlign: "top"
  }
});
var Center = styled41.span(
  {
    flex: 1,
    textAlign: "left",
    display: "flex",
    flexDirection: "column",
    minWidth: 0
    // required for overflow
  },
  ({ isIndented }) => isIndented ? { marginLeft: 24 } : {}
);
var CenterText = styled41.span(
  ({ theme }) => ({
    fontSize: "11px",
    lineHeight: "14px"
  }),
  ({ active, theme }) => active ? {
    color: theme.color.secondary
  } : {},
  ({ theme, disabled }) => disabled ? {
    color: theme.textMutedColor
  } : {}
);
var Left = styled41.span(
  ({ active, theme }) => active ? {
    color: theme.color.secondary
  } : {},
  () => ({
    display: "flex",
    maxWidth: 14
  })
);
var Item = styled41.div(
  ({ theme }) => ({
    width: "100%",
    minWidth: 0,
    // required for overflow
    border: "none",
    borderRadius: theme.appBorderRadius,
    background: "none",
    fontSize: theme.typography.size.s1,
    transition: "all 150ms ease-out",
    color: theme.color.dark,
    textDecoration: "none",
    justifyContent: "space-between",
    lineHeight: "18px",
    padding: "7px 10px",
    display: "flex",
    alignItems: "center",
    "& > * + *": {
      paddingLeft: 10
    }
  }),
  ({ theme, href, onClick }) => (href || onClick) && {
    cursor: "pointer",
    "&:hover": {
      background: theme.background.hoverable
    },
    "&:hover svg": {
      opacity: 1
    }
  },
  ({ theme, as }) => as === "label" && {
    "&:has(input:not(:disabled))": {
      cursor: "pointer",
      "&:hover": {
        background: theme.background.hoverable
      }
    }
  },
  ({ disabled }) => disabled && { cursor: "not-allowed" }
);
var getItemProps = (0, import_memoizerific.default)(100)(({ onClick, input, href, LinkWrapper }) => ({
  ...onClick && {
    as: "button",
    onClick
  },
  ...input && {
    as: "label"
  },
  ...href && {
    as: "a",
    href,
    ...LinkWrapper && {
      as: LinkWrapper,
      to: href
    }
  }
}));
var ListItem = /* @__PURE__ */ __name((props) => {
  const {
    loading = false,
    title = React57.createElement("span", null, "Loading state"),
    center = null,
    right = null,
    active = false,
    disabled = false,
    isIndented = false,
    href = void 0,
    onClick = void 0,
    icon,
    input,
    LinkWrapper = void 0,
    ...rest
  } = props;
  const commonProps = { active, disabled };
  const itemProps = getItemProps(props);
  const left = icon || input;
  return React57.createElement(Item, { ...rest, ...commonProps, ...itemProps }, React57.createElement(React57.Fragment, null, left && React57.createElement(Left, { ...commonProps }, left), title || center ? React57.createElement(Center, { isIndented: isIndented && !left }, title && React57.createElement(Title5, { ...commonProps, loading }, title), center && React57.createElement(CenterText, { ...commonProps }, center)) : null, right && React57.createElement(Right, { ...commonProps }, right)));
}, "ListItem");
var ListItem_default = ListItem;

// src/components/components/tooltip/TooltipLinkList.tsx
var List = styled42.div(
  {
    minWidth: 180,
    overflow: "hidden",
    overflowY: "auto",
    maxHeight: 15.5 * 32 + 8
    // 15.5 items at 32px each + 8px padding
  },
  ({ theme }) => ({
    borderRadius: theme.appBorderRadius + 2
  }),
  ({ theme }) => theme.base === "dark" ? { background: theme.background.content } : {}
);
var Group = styled42.div(({ theme }) => ({
  padding: 4,
  "& + &": {
    borderTop: `1px solid ${theme.appBorderColor}`
  }
}));
var Item2 = /* @__PURE__ */ __name(({ id, onClick, ...rest }) => {
  const { active, disabled, title, href } = rest;
  const handleClick = useCallback10(
    (event) => onClick?.(event, { id, active, disabled, title, href }),
    [onClick, id, active, disabled, title, href]
  );
  return React58.createElement(ListItem_default, { id: `list-item-${id}`, ...rest, ...onClick && { onClick: handleClick } });
}, "Item");
var TooltipLinkList = /* @__PURE__ */ __name(({ links, LinkWrapper, ...props }) => {
  const groups = Array.isArray(links[0]) ? links : [links];
  const isIndented = groups.some(
    (group) => group.some((link) => "icon" in link && link.icon || "input" in link && link.input)
  );
  return React58.createElement(List, { ...props }, groups.filter((group) => group.length).map((group, index3) => {
    return React58.createElement(Group, { key: group.map((link) => link.id).join(`~${index3}~`) }, group.map((link) => {
      if ("content" in link) {
        return React58.createElement(Fragment10, { key: link.id }, link.content);
      }
      return React58.createElement(Item2, { key: link.id, isIndented, LinkWrapper, ...link });
    }));
  }));
}, "TooltipLinkList");

// src/components/components/tabs/tabs.tsx
import React64, { Component as Component2, memo as memo2, useMemo as useMemo7 } from "react";
import { sanitize as sanitize2 } from "storybook/internal/csf";
import { styled as styled48 } from "storybook/theming";

// src/components/components/bar/bar.tsx
import React59, { Children as Children9 } from "react";
import { styled as styled43 } from "storybook/theming";
var Side = styled43.div(
  {
    display: "flex",
    whiteSpace: "nowrap",
    flexBasis: "auto",
    marginLeft: 3,
    marginRight: 10
  },
  ({ scrollable }) => scrollable ? { flexShrink: 0 } : {},
  ({ left }) => left ? {
    "& > *": {
      marginLeft: 4
    }
  } : {},
  ({ right }) => right ? {
    gap: 6
  } : {}
);
Side.displayName = "Side";
var UnstyledBar = /* @__PURE__ */ __name(({ children, className, scrollable }) => scrollable ? React59.createElement(ScrollArea, { vertical: false, className }, children) : React59.createElement("div", { className }, children), "UnstyledBar");
var Bar = styled43(UnstyledBar)(
  ({ backgroundColor, theme, scrollable = true }) => ({
    color: theme.barTextColor,
    width: "100%",
    minHeight: 40,
    flexShrink: 0,
    scrollbarColor: `${theme.barTextColor} ${backgroundColor || theme.barBg}`,
    scrollbarWidth: "thin",
    overflow: scrollable ? "auto" : "hidden",
    overflowY: "hidden"
  }),
  ({ theme, border = false }) => border ? {
    boxShadow: `${theme.appBorderColor}  0 -1px 0 0 inset`,
    background: theme.barBg
  } : {}
);
Bar.displayName = "Bar";
var BarInner = styled43.div(({ bgColor }) => ({
  display: "flex",
  justifyContent: "space-between",
  position: "relative",
  flexWrap: "nowrap",
  flexShrink: 0,
  height: 40,
  backgroundColor: bgColor || ""
}));
var FlexBar = /* @__PURE__ */ __name(({ children, backgroundColor, className, ...rest }) => {
  const [left, right] = Children9.toArray(children);
  return React59.createElement(Bar, { backgroundColor, className: `sb-bar ${className}`, ...rest }, React59.createElement(BarInner, { bgColor: backgroundColor }, React59.createElement(Side, { scrollable: rest.scrollable, left: true }, left), right ? React59.createElement(Side, { right: true }, right) : null));
}, "FlexBar");
FlexBar.displayName = "FlexBar";

// src/components/components/bar/button.tsx
import React60, { forwardRef as forwardRef16 } from "react";
import { isPropValid as isPropValid2, styled as styled44 } from "storybook/theming";
var isLink = /* @__PURE__ */ __name((obj) => {
  return typeof obj.props.href === "string";
}, "isLink");
var isButton = /* @__PURE__ */ __name((obj) => {
  return typeof obj.props.href !== "string";
}, "isButton");
function ForwardRefFunction({ children, ...rest }, ref) {
  const o = { props: rest, ref };
  if (isLink(o)) {
    return React60.createElement("a", { ref: o.ref, ...o.props }, children);
  }
  if (isButton(o)) {
    return React60.createElement("button", { ref: o.ref, type: "button", ...o.props }, children);
  }
  throw new Error("invalid props");
}
__name(ForwardRefFunction, "ForwardRefFunction");
var ButtonOrLink = forwardRef16(ForwardRefFunction);
ButtonOrLink.displayName = "ButtonOrLink";
var TabButton = styled44(ButtonOrLink, { shouldForwardProp: isPropValid2 })(
  {
    whiteSpace: "normal",
    display: "inline-flex",
    overflow: "hidden",
    verticalAlign: "top",
    justifyContent: "center",
    alignItems: "center",
    textAlign: "center",
    textDecoration: "none",
    "&:empty": {
      display: "none"
    },
    "&[hidden]": {
      display: "none"
    }
  },
  ({ theme }) => ({
    padding: "0 15px",
    transition: "color 0.2s linear, border-bottom-color 0.2s linear",
    height: 40,
    lineHeight: "12px",
    cursor: "pointer",
    background: "transparent",
    border: "0 solid transparent",
    borderTop: "3px solid transparent",
    borderBottom: "3px solid transparent",
    fontWeight: "bold",
    fontSize: 13,
    "&:focus": {
      outline: "0 none",
      borderBottomColor: theme.barSelectedColor
    }
  }),
  ({ active, textColor, theme }) => active ? {
    color: textColor || theme.barSelectedColor,
    borderBottomColor: theme.barSelectedColor
  } : {
    color: textColor || theme.barTextColor,
    borderBottomColor: "transparent",
    "&:hover": {
      color: theme.barHoverColor
    }
  }
);
TabButton.displayName = "TabButton";

// src/components/components/tabs/EmptyTabContent.tsx
import React61 from "react";
import { styled as styled45 } from "storybook/theming";
var Wrapper2 = styled45.div(({ theme }) => ({
  height: "100%",
  display: "flex",
  padding: 30,
  alignItems: "center",
  justifyContent: "center",
  flexDirection: "column",
  gap: 15,
  background: theme.background.content
}));
var Content3 = styled45.div({
  display: "flex",
  flexDirection: "column",
  gap: 4,
  maxWidth: 415
});
var Title6 = styled45.div(({ theme }) => ({
  fontWeight: theme.typography.weight.bold,
  fontSize: theme.typography.size.s2 - 1,
  textAlign: "center",
  color: theme.textColor
}));
var Description3 = styled45.div(({ theme }) => ({
  fontWeight: theme.typography.weight.regular,
  fontSize: theme.typography.size.s2 - 1,
  textAlign: "center",
  color: theme.textMutedColor
}));
var EmptyTabContent = /* @__PURE__ */ __name(({ title, description, footer }) => {
  return React61.createElement(Wrapper2, null, React61.createElement(Content3, null, React61.createElement(Title6, null, title), description && React61.createElement(Description3, null, description)), footer);
}, "EmptyTabContent");

// src/components/components/tabs/tabs.helpers.tsx
import React62, { Children as Children10 } from "react";
import { styled as styled46 } from "storybook/theming";
var VisuallyHidden = styled46.div(
  ({ active }) => active ? { display: "block" } : { display: "none" }
);
var childrenToList = /* @__PURE__ */ __name((children) => Children10.toArray(children).map(
  // @ts-expect-error (non strict)
  ({
    props: { title, id, color: color4, children: childrenOfChild }
  }) => {
    const content = Array.isArray(
      childrenOfChild
    ) ? childrenOfChild[0] : childrenOfChild;
    const render = typeof content === "function" ? content : ({ active }) => React62.createElement(VisuallyHidden, { active, role: "tabpanel" }, content);
    return {
      title,
      id,
      ...color4 ? { color: color4 } : {},
      render
    };
  }
), "childrenToList");

// src/components/components/tabs/tabs.hooks.tsx
import React63, { useCallback as useCallback11, useLayoutEffect as useLayoutEffect7, useRef as useRef15, useState as useState15 } from "react";
import { sanitize } from "storybook/internal/csf";
import { styled as styled47 } from "storybook/theming";
var CollapseIcon = styled47.span(({ theme, isActive }) => ({
  display: "inline-block",
  width: 0,
  height: 0,
  marginLeft: 8,
  color: isActive ? theme.color.secondary : theme.color.mediumdark,
  borderRight: "3px solid transparent",
  borderLeft: `3px solid transparent`,
  borderTop: "3px solid",
  transition: "transform .1s ease-out"
}));
var AddonButton = styled47(TabButton)(({ active, theme, preActive }) => {
  return `
    color: ${preActive || active ? theme.barSelectedColor : theme.barTextColor};
    .addon-collapsible-icon {
      color: ${preActive || active ? theme.barSelectedColor : theme.barTextColor};
    }
    &:hover {
      color: ${theme.barHoverColor};
      .addon-collapsible-icon {
        color: ${theme.barHoverColor};
      }
    }
  `;
});
function useList(list) {
  const tabBarRef = useRef15();
  const addonsRef = useRef15();
  const tabRefs = useRef15(/* @__PURE__ */ new Map());
  const { width: tabBarWidth = 1 } = useResizeObserver({
    // @ts-expect-error (non strict)
    ref: tabBarRef
  });
  const [visibleList, setVisibleList] = useState15(list);
  const [invisibleList, setInvisibleList] = useState15([]);
  const previousList = useRef15(list);
  const AddonTab = useCallback11(
    ({
      menuName,
      actions
    }) => {
      const isAddonsActive = invisibleList.some(({ active }) => active);
      const [isTooltipVisible, setTooltipVisible] = useState15(false);
      return React63.createElement(React63.Fragment, null, React63.createElement(
        WithToolTipState,
        {
          interactive: true,
          visible: isTooltipVisible,
          onVisibleChange: setTooltipVisible,
          placement: "bottom",
          delayHide: 100,
          tooltip: React63.createElement(
            TooltipLinkList,
            {
              links: invisibleList.map(({ title, id, color: color4, active }) => {
                return {
                  id,
                  title,
                  color: color4,
                  active,
                  onClick: /* @__PURE__ */ __name((e) => {
                    e.preventDefault();
                    actions.onSelect(id);
                  }, "onClick")
                };
              })
            }
          )
        },
        React63.createElement(
          AddonButton,
          {
            id: "addons-menu-button",
            ref: addonsRef,
            active: isAddonsActive,
            preActive: isTooltipVisible,
            style: { visibility: invisibleList.length ? "visible" : "hidden" },
            "aria-hidden": !invisibleList.length,
            className: "tabbutton",
            type: "button",
            role: "tab"
          },
          menuName,
          React63.createElement(
            CollapseIcon,
            {
              className: "addon-collapsible-icon",
              isActive: isAddonsActive || isTooltipVisible
            }
          )
        )
      ), invisibleList.map(({ title, id, color: color4 }, index3) => {
        const indexId = `index-${index3}`;
        return React63.createElement(
          TabButton,
          {
            id: `tabbutton-${sanitize(id) ?? indexId}`,
            style: { visibility: "hidden" },
            "aria-hidden": true,
            tabIndex: -1,
            ref: (ref) => {
              tabRefs.current.set(id, ref);
            },
            className: "tabbutton",
            type: "button",
            key: id,
            textColor: color4,
            role: "tab"
          },
          title
        );
      }));
    },
    [invisibleList]
  );
  const setTabLists = useCallback11(() => {
    if (!tabBarRef.current || !addonsRef.current) {
      return;
    }
    const { x, width } = tabBarRef.current.getBoundingClientRect();
    const { width: widthAddonsTab } = addonsRef.current.getBoundingClientRect();
    const rightBorder = invisibleList.length ? x + width - widthAddonsTab : x + width;
    const newVisibleList = [];
    let widthSum = 0;
    const newInvisibleList = list.filter((item) => {
      const { id } = item;
      const tabButton = tabRefs.current.get(id);
      const { width: tabWidth = 0 } = tabButton?.getBoundingClientRect() || {};
      const crossBorder = x + widthSum + tabWidth > rightBorder;
      if (!crossBorder || !tabButton) {
        newVisibleList.push(item);
      }
      widthSum += tabWidth;
      return crossBorder;
    });
    if (newVisibleList.length !== visibleList.length || previousList.current !== list) {
      setVisibleList(newVisibleList);
      setInvisibleList(newInvisibleList);
      previousList.current = list;
    }
  }, [invisibleList.length, list, visibleList]);
  useLayoutEffect7(setTabLists, [setTabLists, tabBarWidth]);
  return {
    tabRefs,
    addonsRef,
    tabBarRef,
    visibleList,
    invisibleList,
    AddonTab
  };
}
__name(useList, "useList");

// src/components/components/tabs/tabs.tsx
var ignoreSsrWarning2 = "/* emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason */";
var Wrapper3 = styled48.div(
  ({ theme, bordered }) => bordered ? {
    backgroundClip: "padding-box",
    border: `1px solid ${theme.appBorderColor}`,
    borderRadius: theme.appBorderRadius,
    overflow: "hidden",
    boxSizing: "border-box"
  } : {},
  ({ absolute }) => absolute ? {
    width: "100%",
    height: "100%",
    boxSizing: "border-box",
    display: "flex",
    flexDirection: "column"
  } : {
    display: "block"
  }
);
var TabBar = styled48.div({
  overflow: "hidden",
  "&:first-of-type": {
    marginLeft: -3
  },
  whiteSpace: "nowrap",
  flexGrow: 1
});
TabBar.displayName = "TabBar";
var Content4 = styled48.div(
  {
    display: "block",
    position: "relative",
    container: "tab-content / inline-size"
  },
  ({ theme }) => ({
    fontSize: theme.typography.size.s2 - 1,
    background: theme.background.content
  }),
  ({ bordered, theme }) => bordered ? {
    borderRadius: `0 0 ${theme.appBorderRadius - 1}px ${theme.appBorderRadius - 1}px`
  } : {},
  ({ absolute, bordered }) => absolute ? {
    height: `calc(100% - ${bordered ? 42 : 40}px)`,
    position: "absolute",
    left: 0 + (bordered ? 1 : 0),
    right: 0 + (bordered ? 1 : 0),
    bottom: 0 + (bordered ? 1 : 0),
    top: 40 + (bordered ? 1 : 0),
    overflow: "auto",
    [`& > *:first-child${ignoreSsrWarning2}`]: {
      position: "absolute",
      left: 0 + (bordered ? 1 : 0),
      right: 0 + (bordered ? 1 : 0),
      bottom: 0 + (bordered ? 1 : 0),
      top: 0 + (bordered ? 1 : 0),
      height: `calc(100% - ${bordered ? 2 : 0}px)`,
      overflow: "auto"
    }
  } : {}
);
var TabWrapper = /* @__PURE__ */ __name(({ active, render, children }) => React64.createElement(VisuallyHidden, { active }, render ? render() : children), "TabWrapper");
var _TabErrorBoundary = class _TabErrorBoundary extends Component2 {
  constructor(props) {
    super(props);
    this.state = { hasError: false };
  }
  static getDerivedStateFromError() {
    return { hasError: true };
  }
  componentDidCatch(error, info) {
    console.error("Error rendering addon panel");
    console.error(error);
    console.error(info.componentStack);
  }
  render() {
    if (this.state.hasError && this.props.active) {
      return React64.createElement(
        EmptyTabContent,
        {
          title: "This addon has errors",
          description: "Check your browser logs and addon code to pinpoint what went wrong. This issue was not caused by Storybook."
        }
      );
    }
    return this.props.children;
  }
};
__name(_TabErrorBoundary, "TabErrorBoundary");
var TabErrorBoundary = _TabErrorBoundary;
var Tabs = memo2(
  ({
    children,
    selected = null,
    actions,
    absolute = false,
    bordered = false,
    tools = null,
    backgroundColor,
    id: htmlId = null,
    menuName = "Tabs",
    emptyState,
    showToolsWhenEmpty
  }) => {
    const list = useMemo7(
      () => childrenToList(children).map((i, index3) => ({
        ...i,
        active: selected ? i.id === selected : index3 === 0
      })),
      [children, selected]
    );
    const { visibleList, tabBarRef, tabRefs, AddonTab } = useList(list);
    const EmptyContent = emptyState ?? React64.createElement(EmptyTabContent, { title: "Nothing found" });
    if (!showToolsWhenEmpty && list.length === 0) {
      return EmptyContent;
    }
    return (
      // @ts-expect-error (non strict)
      React64.createElement(Wrapper3, { absolute, bordered, id: htmlId }, React64.createElement(FlexBar, { scrollable: false, border: true, backgroundColor }, React64.createElement(TabBar, { style: { whiteSpace: "normal" }, ref: tabBarRef, role: "tablist" }, visibleList.map(({ title, id, active, color: color4 }, index3) => {
        const indexId = `index-${index3}`;
        return React64.createElement(
          TabButton,
          {
            id: `tabbutton-${sanitize2(id) ?? indexId}`,
            ref: (ref) => {
              tabRefs.current.set(id, ref);
            },
            className: `tabbutton ${active ? "tabbutton-active" : ""}`,
            type: "button",
            key: id,
            active,
            textColor: color4,
            onClick: (e) => {
              e.preventDefault();
              actions.onSelect(id);
            },
            role: "tab"
          },
          typeof title === "function" ? React64.createElement("title", null) : title
        );
      }), React64.createElement(AddonTab, { menuName, actions })), tools), React64.createElement(Content4, { id: "panel-tab-content", bordered, absolute }, list.length ? list.map(({ id, active, render }) => {
        return React64.createElement(TabErrorBoundary, { key: id, active }, React64.createElement(render, { active }, null));
      }) : EmptyContent))
    );
  }
);
Tabs.displayName = "Tabs";
var _TabsState = class _TabsState extends Component2 {
  constructor(props) {
    super(props);
    this.handlers = {
      onSelect: /* @__PURE__ */ __name((id) => this.setState({ selected: id }), "onSelect")
    };
    this.state = {
      selected: props.initial
    };
  }
  render() {
    const { bordered = false, absolute = false, children, backgroundColor, menuName } = this.props;
    const { selected } = this.state;
    return React64.createElement(
      Tabs,
      {
        bordered,
        absolute,
        selected,
        backgroundColor,
        menuName,
        actions: this.handlers
      },
      children
    );
  }
};
__name(_TabsState, "TabsState");
_TabsState.defaultProps = {
  children: [],
  // @ts-expect-error (non strict)
  initial: null,
  absolute: false,
  bordered: false,
  backgroundColor: "",
  // @ts-expect-error (non strict)
  menuName: void 0
};
var TabsState = _TabsState;

// src/components/components/bar/separator.tsx
import React65, { Fragment as Fragment11 } from "react";
import { styled as styled49 } from "storybook/theming";
var Separator = styled49.span(
  ({ theme }) => ({
    width: 1,
    height: 20,
    background: theme.appBorderColor,
    marginLeft: 2,
    marginRight: 2
  }),
  ({ force }) => force ? {} : {
    "& + &": {
      display: "none"
    }
  }
);
Separator.displayName = "Separator";
var interleaveSeparators = /* @__PURE__ */ __name((list) => list.reduce(
  (acc, item, index3) => item ? React65.createElement(Fragment11, { key: item.id || item.key || `f-${index3}` }, acc, index3 > 0 ? React65.createElement(Separator, { key: `s-${index3}` }) : null, item.render() || item) : acc,
  null
), "interleaveSeparators");

// src/components/components/addon-panel/addon-panel.tsx
import React66, { useEffect as useEffect19, useRef as useRef16 } from "react";
var usePrevious = /* @__PURE__ */ __name((value) => {
  const ref = useRef16();
  useEffect19(() => {
    ref.current = value;
  }, [value]);
  return ref.current;
}, "usePrevious");
var useUpdate = /* @__PURE__ */ __name((update, value) => {
  const previousValue = usePrevious(value);
  return update ? value : previousValue;
}, "useUpdate");
var AddonPanel = /* @__PURE__ */ __name(({ active, children }) => {
  return (
    // the hidden attribute is an valid html element that's both accessible and works to visually hide content
    React66.createElement("div", { hidden: !active }, useUpdate(active, children))
  );
}, "AddonPanel");

// src/components/brand/StorybookLogo.tsx
import React67 from "react";
var StorybookLogo = /* @__PURE__ */ __name(({ alt, ...props }) => React67.createElement("svg", { width: "200px", height: "40px", viewBox: "0 0 200 40", ...props, role: "img" }, alt ? React67.createElement("title", null, alt) : null, React67.createElement("defs", null, React67.createElement(
  "path",
  {
    d: "M1.2 36.9L0 3.9c0-1.1.8-2 1.9-2.1l28-1.8a2 2 0 0 1 2.2 1.9 2 2 0 0 1 0 .1v36a2 2 0 0 1-2 2 2 2 0 0 1-.1 0L3.2 38.8a2 2 0 0 1-2-2z",
    id: "a"
  }
)), React67.createElement("g", { fill: "none", fillRule: "evenodd" }, React67.createElement(
  "path",
  {
    d: "M53.3 31.7c-1.7 0-3.4-.3-5-.7-1.5-.5-2.8-1.1-3.9-2l1.6-3.5c2.2 1.5 4.6 2.3 7.3 2.3 1.5 0 2.5-.2 3.3-.7.7-.5 1.1-1 1.1-1.9 0-.7-.3-1.3-1-1.7s-2-.8-3.7-1.2c-2-.4-3.6-.9-4.8-1.5-1.1-.5-2-1.2-2.6-2-.5-1-.8-2-.8-3.2 0-1.4.4-2.6 1.2-3.6.7-1.1 1.8-2 3.2-2.6 1.3-.6 2.9-.9 4.7-.9 1.6 0 3.1.3 4.6.7 1.5.5 2.7 1.1 3.5 2l-1.6 3.5c-2-1.5-4.2-2.3-6.5-2.3-1.3 0-2.3.2-3 .8-.8.5-1.2 1.1-1.2 2 0 .5.2 1 .5 1.3.2.3.7.6 1.4.9l2.9.8c2.9.6 5 1.4 6.2 2.4a5 5 0 0 1 2 4.2 6 6 0 0 1-2.5 5c-1.7 1.2-4 1.9-7 1.9zm21-3.6l1.4-.1-.2 3.5-1.9.1c-2.4 0-4.1-.5-5.2-1.5-1.1-1-1.6-2.7-1.6-4.8v-6h-3v-3.6h3V11h4.8v4.6h4v3.6h-4v6c0 1.8.9 2.8 2.6 2.8zm11.1 3.5c-1.6 0-3-.3-4.3-1a7 7 0 0 1-3-2.8c-.6-1.3-1-2.7-1-4.4 0-1.6.4-3 1-4.3a7 7 0 0 1 3-2.8c1.2-.7 2.7-1 4.3-1 1.7 0 3.2.3 4.4 1a7 7 0 0 1 3 2.8c.6 1.2 1 2.7 1 4.3 0 1.7-.4 3.1-1 4.4a7 7 0 0 1-3 2.8c-1.2.7-2.7 1-4.4 1zm0-3.6c2.4 0 3.6-1.6 3.6-4.6 0-1.5-.3-2.6-1-3.4a3.2 3.2 0 0 0-2.6-1c-2.3 0-3.5 1.4-3.5 4.4 0 3 1.2 4.6 3.5 4.6zm21.7-8.8l-2.7.3c-1.3.2-2.3.5-2.8 1.2-.6.6-.9 1.4-.9 2.5v8.2H96V15.7h4.6v2.6c.8-1.8 2.5-2.8 5-3h1.3l.3 4zm14-3.5h4.8L116.4 37h-4.9l3-6.6-6.4-14.8h5l4 10 4-10zm16-.4c1.4 0 2.6.3 3.6 1 1 .6 1.9 1.6 2.5 2.8.6 1.2.9 2.7.9 4.3 0 1.6-.3 3-1 4.3a6.9 6.9 0 0 1-2.4 2.9c-1 .7-2.2 1-3.6 1-1 0-2-.2-3-.7-.8-.4-1.5-1-2-1.9v2.4h-4.7V8.8h4.8v9c.5-.8 1.2-1.4 2-1.9.9-.4 1.8-.6 3-.6zM135.7 28c1.1 0 2-.4 2.6-1.2.6-.8 1-2 1-3.4 0-1.5-.4-2.5-1-3.3s-1.5-1.1-2.6-1.1-2 .3-2.6 1.1c-.6.8-1 2-1 3.3 0 1.5.4 2.6 1 3.4.6.8 1.5 1.2 2.6 1.2zm18.9 3.6c-1.7 0-3.2-.3-4.4-1a7 7 0 0 1-3-2.8c-.6-1.3-1-2.7-1-4.4 0-1.6.4-3 1-4.3a7 7 0 0 1 3-2.8c1.2-.7 2.7-1 4.4-1 1.6 0 3 .3 4.3 1a7 7 0 0 1 3 2.8c.6 1.2 1 2.7 1 4.3 0 1.7-.4 3.1-1 4.4a7 7 0 0 1-3 2.8c-1.2.7-2.7 1-4.3 1zm0-3.6c2.3 0 3.5-1.6 3.5-4.6 0-1.5-.3-2.6-1-3.4a3.2 3.2 0 0 0-2.5-1c-2.4 0-3.6 1.4-3.6 4.4 0 3 1.2 4.6 3.6 4.6zm18 3.6c-1.7 0-3.2-.3-4.4-1a7 7 0 0 1-3-2.8c-.6-1.3-1-2.7-1-4.4 0-1.6.4-3 1-4.3a7 7 0 0 1 3-2.8c1.2-.7 2.7-1 4.4-1 1.6 0 3 .3 4.4 1a7 7 0 0 1 2.9 2.8c.6 1.2 1 2.7 1 4.3 0 1.7-.4 3.1-1 4.4a7 7 0 0 1-3 2.8c-1.2.7-2.7 1-4.3 1zm0-3.6c2.3 0 3.5-1.6 3.5-4.6 0-1.5-.3-2.6-1-3.4a3.2 3.2 0 0 0-2.5-1c-2.4 0-3.6 1.4-3.6 4.4 0 3 1.2 4.6 3.6 4.6zm27.4 3.4h-6l-6-7v7h-4.8V8.8h4.9v13.6l5.8-6.7h5.7l-6.6 7.5 7 8.2z",
    fill: "currentColor"
  }
), React67.createElement("mask", { id: "b", fill: "#fff" }, React67.createElement("use", { xlinkHref: "#a" })), React67.createElement("use", { fill: "#FF4785", fillRule: "nonzero", xlinkHref: "#a" }), React67.createElement(
  "path",
  {
    d: "M23.7 5L24 .2l3.9-.3.1 4.8a.3.3 0 0 1-.5.2L26 3.8l-1.7 1.4a.3.3 0 0 1-.5-.3zm-5 10c0 .9 5.3.5 6 0 0-5.4-2.8-8.2-8-8.2-5.3 0-8.2 2.8-8.2 7.1 0 7.4 10 7.6 10 11.6 0 1.2-.5 1.9-1.8 1.9-1.6 0-2.2-.9-2.1-3.6 0-.6-6.1-.8-6.3 0-.5 6.7 3.7 8.6 8.5 8.6 4.6 0 8.3-2.5 8.3-7 0-7.9-10.2-7.7-10.2-11.6 0-1.6 1.2-1.8 2-1.8.6 0 2 0 1.9 3z",
    fill: "#FFF",
    fillRule: "nonzero",
    mask: "url(#b)"
  }
))), "StorybookLogo");

// src/components/brand/StorybookIcon.tsx
import React68 from "react";
var StorybookIcon = /* @__PURE__ */ __name((props) => React68.createElement("svg", { viewBox: "0 0 64 64", ...props }, React68.createElement("title", null, "Storybook icon"), React68.createElement("g", { id: "Artboard", stroke: "none", strokeWidth: "1", fill: "none", fillRule: "evenodd" }, React68.createElement(
  "path",
  {
    d: "M8.04798541,58.7875918 L6.07908839,6.32540407 C6.01406344,4.5927838 7.34257463,3.12440831 9.07303814,3.01625434 L53.6958037,0.227331489 C55.457209,0.117243658 56.974354,1.45590096 57.0844418,3.21730626 C57.0885895,3.28366922 57.0906648,3.35014546 57.0906648,3.41663791 L57.0906648,60.5834697 C57.0906648,62.3483119 55.6599776,63.7789992 53.8951354,63.7789992 C53.847325,63.7789992 53.7995207,63.7779262 53.7517585,63.775781 L11.0978899,61.8600599 C9.43669044,61.7854501 8.11034889,60.4492961 8.04798541,58.7875918 Z",
    id: "path-1",
    fill: "#FF4785",
    fillRule: "nonzero"
  }
), React68.createElement(
  "path",
  {
    d: "M35.9095005,24.1768792 C35.9095005,25.420127 44.2838488,24.8242707 45.4080313,23.9509748 C45.4080313,15.4847538 40.8652557,11.0358878 32.5466666,11.0358878 C24.2280775,11.0358878 19.5673077,15.553972 19.5673077,22.3311017 C19.5673077,34.1346028 35.4965208,34.3605071 35.4965208,40.7987804 C35.4965208,42.606015 34.6115646,43.6790606 32.6646607,43.6790606 C30.127786,43.6790606 29.1248356,42.3834613 29.2428298,37.9783269 C29.2428298,37.0226907 19.5673077,36.7247626 19.2723223,37.9783269 C18.5211693,48.6535354 25.1720308,51.7326752 32.7826549,51.7326752 C40.1572906,51.7326752 45.939005,47.8018145 45.939005,40.6858282 C45.939005,28.035186 29.7738035,28.3740425 29.7738035,22.1051974 C29.7738035,19.5637737 31.6617103,19.2249173 32.7826549,19.2249173 C33.9625966,19.2249173 36.0864917,19.4328883 35.9095005,24.1768792 Z",
    id: "path9_fill-path",
    fill: "#FFFFFF",
    fillRule: "nonzero"
  }
), React68.createElement(
  "path",
  {
    d: "M44.0461638,0.830433986 L50.1874092,0.446606143 L50.443532,7.7810017 C50.4527198,8.04410717 50.2468789,8.26484453 49.9837734,8.27403237 C49.871115,8.27796649 49.7607078,8.24184808 49.6721567,8.17209069 L47.3089847,6.3104681 L44.5110468,8.43287463 C44.3012992,8.591981 44.0022839,8.55092814 43.8431776,8.34118051 C43.7762017,8.25288717 43.742082,8.14401677 43.7466857,8.03329059 L44.0461638,0.830433986 Z",
    id: "Path",
    fill: "#FFFFFF"
  }
))), "StorybookIcon");

// src/components/components/Loader/Loader.tsx
import React69 from "react";
import { LightningOffIcon } from "@storybook/icons";
import { keyframes as keyframes3, styled as styled50 } from "storybook/theming";

// src/components/components/shared/animation.ts
import { keyframes as keyframes2 } from "storybook/theming";
var rotate360 = keyframes2`
	from {
		transform: rotate(0deg);
	}
	to {
		transform: rotate(360deg);
	}
`;

// src/components/components/Loader/Loader.tsx
var LoaderWrapper = styled50.div(({ size = 32 }) => ({
  borderRadius: "50%",
  cursor: "progress",
  display: "inline-block",
  overflow: "hidden",
  position: "absolute",
  transition: "all 200ms ease-out",
  verticalAlign: "top",
  top: "50%",
  left: "50%",
  marginTop: -(size / 2),
  marginLeft: -(size / 2),
  height: size,
  width: size,
  zIndex: 4,
  borderWidth: 2,
  borderStyle: "solid",
  borderColor: "rgba(97, 97, 97, 0.29)",
  borderTopColor: "rgb(100,100,100)",
  animation: `${rotate360} 0.7s linear infinite`,
  mixBlendMode: "difference"
}));
var ProgressWrapper = styled50.div({
  position: "absolute",
  display: "flex",
  flexDirection: "column",
  justifyContent: "center",
  alignItems: "center",
  width: "100%",
  height: "100%"
});
var ProgressTrack = styled50.div(({ theme }) => ({
  position: "relative",
  width: "80%",
  marginBottom: "0.75rem",
  maxWidth: 300,
  height: 5,
  borderRadius: 5,
  background: curriedTransparentize$1(0.8, theme.color.secondary),
  overflow: "hidden",
  cursor: "progress"
}));
var ProgressBar = styled50.div(({ theme }) => ({
  position: "absolute",
  top: 0,
  left: 0,
  height: "100%",
  background: theme.color.secondary
}));
var ProgressMessage = styled50.div(({ theme }) => ({
  minHeight: "2em",
  fontSize: `${theme.typography.size.s1}px`,
  color: theme.textMutedColor
}));
var ErrorIcon = styled50(LightningOffIcon)(({ theme }) => ({
  width: 20,
  height: 20,
  marginBottom: "0.5rem",
  color: theme.textMutedColor
}));
var ellipsis = keyframes3`
  from { content: "..." }
  33% { content: "." }
  66% { content: ".." }
  to { content: "..." }
`;
var Ellipsis = styled50.span({
  "&::after": {
    content: "'...'",
    animation: `${ellipsis} 1s linear infinite`,
    animationDelay: "1s",
    display: "inline-block",
    width: "1em",
    height: "auto"
  }
});
var Loader = /* @__PURE__ */ __name(({ progress, error, size, ...props }) => {
  if (error) {
    return React69.createElement(ProgressWrapper, { "aria-label": error.toString(), "aria-live": "polite", role: "status", ...props }, React69.createElement(ErrorIcon, null), React69.createElement(ProgressMessage, null, error.message));
  }
  if (progress) {
    const { value, modules } = progress;
    let { message } = progress;
    if (modules) {
      message += ` ${modules.complete} / ${modules.total} modules`;
    }
    return React69.createElement(
      ProgressWrapper,
      {
        "aria-label": "Content is loading...",
        "aria-live": "polite",
        "aria-valuemin": 0,
        "aria-valuemax": 100,
        "aria-valuenow": value * 100,
        "aria-valuetext": message,
        role: "progressbar",
        ...props
      },
      React69.createElement(ProgressTrack, null, React69.createElement(ProgressBar, { style: { width: `${value * 100}%` } })),
      React69.createElement(ProgressMessage, null, message, value < 1 && React69.createElement(Ellipsis, { key: message }))
    );
  }
  return React69.createElement(
    LoaderWrapper,
    {
      "aria-label": "Content is loading...",
      "aria-live": "polite",
      role: "status",
      size,
      ...props
    }
  );
}, "Loader");

// src/components/components/ProgressSpinner/ProgressSpinner.tsx
import React70 from "react";
import { keyframes as keyframes4, styled as styled51 } from "storybook/theming";
var XMLNS = "http://www.w3.org/2000/svg";
var rotate = keyframes4({
  "0%": {
    transform: "rotate(0deg)"
  },
  "100%": {
    transform: "rotate(360deg)"
  }
});
var Wrapper4 = styled51.div(({ size }) => ({
  display: "inline-flex",
  alignItems: "center",
  justifyContent: "center",
  position: "relative",
  minWidth: size,
  minHeight: size
}));
var Circle = styled51.svg(
  ({ size, width }) => ({
    position: "absolute",
    width: `${size}px!important`,
    height: `${size}px!important`,
    transform: "rotate(-90deg)",
    circle: {
      r: (size - Math.ceil(width)) / 2,
      cx: size / 2,
      cy: size / 2,
      opacity: 0.15,
      fill: "transparent",
      stroke: "currentColor",
      strokeWidth: width,
      strokeLinecap: "round",
      strokeDasharray: Math.PI * (size - Math.ceil(width))
    }
  }),
  ({ progress }) => progress && {
    circle: {
      opacity: 0.75
    }
  },
  ({ spinner }) => spinner && {
    animation: `${rotate} 1s linear infinite`,
    circle: {
      opacity: 0.25
    }
  }
);
var ProgressSpinner = /* @__PURE__ */ __name(({
  percentage = void 0,
  running = true,
  size = 24,
  width = 1.5,
  children = null,
  ...props
}) => typeof percentage === "number" ? React70.createElement(Wrapper4, { size, ...props }, children, React70.createElement(Circle, { size, width, xmlns: XMLNS }, React70.createElement("circle", null)), running && React70.createElement(Circle, { size, width, xmlns: XMLNS, spinner: true }, React70.createElement("circle", { strokeDashoffset: Math.PI * (size - Math.ceil(width)) * (1 - percentage / 100) })), React70.createElement(Circle, { size, width, xmlns: XMLNS, progress: true }, React70.createElement("circle", { strokeDashoffset: Math.PI * (size - Math.ceil(width)) * (1 - percentage / 100) }))) : React70.createElement(Wrapper4, { size, ...props }, children), "ProgressSpinner");

// src/components/components/utils/getStoryHref.ts
function parseQuery(queryString) {
  const query = {};
  const pairs = queryString.split("&");
  for (let i = 0; i < pairs.length; i++) {
    const pair = pairs[i].split("=");
    query[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1] || "");
  }
  return query;
}
__name(parseQuery, "parseQuery");
var getStoryHref = /* @__PURE__ */ __name((baseUrl, storyId, additionalParams = {}) => {
  const [url, paramsStr] = baseUrl.split("?");
  const params = paramsStr ? {
    ...parseQuery(paramsStr),
    ...additionalParams,
    id: storyId
  } : {
    ...additionalParams,
    id: storyId
  };
  return `${url}?${Object.entries(params).map((item) => `${item[0]}=${item[1]}`).join("&")}`;
}, "getStoryHref");

// src/components/components/clipboard/ClipboardCode.tsx
import React71 from "react";
import { color as color3, styled as styled52, typography } from "storybook/theming";
var Code2 = styled52.pre`
  line-height: 18px;
  padding: 11px 1rem;
  white-space: pre-wrap;
  background: rgba(0, 0, 0, 0.05);
  color: ${color3.darkest};
  border-radius: 3px;
  margin: 1rem 0;
  width: 100%;
  display: block;
  overflow: hidden;
  font-family: ${typography.fonts.mono};
  font-size: ${typography.size.s2 - 1}px;
`;
var ClipboardCode = /* @__PURE__ */ __name(({ code, ...props }) => React71.createElement(Code2, { id: "clipboard-code", ...props }, code), "ClipboardCode");

// src/components/index.ts
var components2 = components;
var resetComponents = {};
Object.keys(components).forEach((key) => {
  resetComponents[key] = forwardRef17((props, ref) => createElement9(key, { ...props, ref }));
});
export {
  A,
  ActionBar,
  AddonPanel,
  Badge,
  Bar,
  Blockquote,
  Button,
  ClipboardCode,
  Code,
  DL,
  Div,
  DocumentWrapper,
  EmptyTabContent,
  ErrorFormatter,
  FlexBar,
  Form,
  H1,
  H2,
  H3,
  H4,
  H5,
  H6,
  HR,
  IconButton,
  Img,
  LI,
  Link2 as Link,
  ListItem_default as ListItem,
  Loader,
  Modal,
  OL,
  P,
  Placeholder,
  Pre,
  ProgressSpinner,
  ResetWrapper,
  ScrollArea,
  Separator,
  Spaced,
  Span,
  StorybookIcon,
  StorybookLogo,
  SyntaxHighlighter,
  TT,
  TabBar,
  TabButton,
  TabWrapper,
  Table,
  Tabs,
  TabsState,
  TooltipLinkList,
  TooltipMessage,
  TooltipNote,
  UL,
  WithTooltip,
  WithTooltipPure,
  Zoom,
  codeCommon,
  components2 as components,
  createCopyToClipboardFunction,
  getStoryHref,
  interleaveSeparators,
  nameSpaceClassNames,
  resetComponents,
  withReset
};
