#!/usr/bin/env node
import CJS_COMPAT_NODE_URL_39zvq8kkt8 from 'node:url';
import CJS_COMPAT_NODE_PATH_39zvq8kkt8 from 'node:path';
import CJS_COMPAT_NODE_MODULE_39zvq8kkt8 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_39zvq8kkt8.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_39zvq8kkt8.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_39zvq8kkt8.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  versions_default
} from "../_node-chunks/chunk-NEOS45YA.js";
import {
  resolvePackageDir
} from "../_node-chunks/chunk-425EMBPZ.js";
import {
  join
} from "../_node-chunks/chunk-J5R55OCP.js";
import {
  require_dist
} from "../_node-chunks/chunk-PK3UILX6.js";
import {
  __name,
  __toESM
} from "../_node-chunks/chunk-JBW3FROT.js";

// src/bin/dispatcher.ts
import { spawn } from "node:child_process";
import { pathToFileURL } from "node:url";
import { logger } from "storybook/internal/node-logger";
var import_ts_dedent = __toESM(require_dist(), 1);
var [majorNodeVersion, minorNodeVersion] = process.versions.node.split(".").map(Number);
if (majorNodeVersion < 20 || majorNodeVersion === 20 && minorNodeVersion < 19 || majorNodeVersion === 22 && minorNodeVersion < 12) {
  logger.error(
    import_ts_dedent.dedent`To run Storybook, you need Node.js version 20.19+ or 22.12+.
    You are currently running Node.js ${process.version}. Please upgrade your Node.js installation.`
  );
  process.exit(1);
}
async function run() {
  const args = process.argv.slice(2);
  if (["dev", "build", "index"].includes(args[0])) {
    const coreBin = pathToFileURL(join(resolvePackageDir("storybook"), "dist/bin/core.js")).href;
    await import(coreBin);
    return;
  }
  const targetCli = args[0] === "init" ? {
    pkg: "create-storybook",
    args: args.slice(1)
  } : {
    pkg: "@storybook/cli",
    args
  };
  let command;
  try {
    const { default: targetCliPackageJson } = await import(`${targetCli.pkg}/package.json`, {
      with: { type: "json" }
    });
    if (targetCliPackageJson.version === versions_default[targetCli.pkg]) {
      command = [
        "node",
        `"${join(resolvePackageDir(targetCli.pkg), "dist/bin/index.js")}"`,
        ...targetCli.args
      ];
    }
  } catch (e) {
  }
  command ??= ["npx", "--yes", `${targetCli.pkg}@${versions_default[targetCli.pkg]}`, ...targetCli.args];
  const child = spawn(command[0], command.slice(1), { stdio: "inherit", shell: true });
  child.on("exit", (code) => {
    process.exit(code);
  });
}
__name(run, "run");
run();
