import * as recast from 'recast';
export { recast };
export { Options as RecastOptions } from 'recast';

declare function isCompatTag(tagName?: string): boolean;

type ReturnedChild = JSXSpreadChild | JSXElement | JSXFragment | Expression;
declare function buildChildren(node: JSXElement | JSXFragment): ReturnedChild[];

declare function assertNode(node?: any): asserts node is Node$1;

declare function assertArrayExpression(node: object | null | undefined, opts?: object | null): asserts node is ArrayExpression;
declare function assertAssignmentExpression(node: object | null | undefined, opts?: object | null): asserts node is AssignmentExpression;
declare function assertBinaryExpression(node: object | null | undefined, opts?: object | null): asserts node is BinaryExpression;
declare function assertInterpreterDirective(node: object | null | undefined, opts?: object | null): asserts node is InterpreterDirective;
declare function assertDirective(node: object | null | undefined, opts?: object | null): asserts node is Directive;
declare function assertDirectiveLiteral(node: object | null | undefined, opts?: object | null): asserts node is DirectiveLiteral;
declare function assertBlockStatement(node: object | null | undefined, opts?: object | null): asserts node is BlockStatement;
declare function assertBreakStatement(node: object | null | undefined, opts?: object | null): asserts node is BreakStatement;
declare function assertCallExpression(node: object | null | undefined, opts?: object | null): asserts node is CallExpression;
declare function assertCatchClause(node: object | null | undefined, opts?: object | null): asserts node is CatchClause;
declare function assertConditionalExpression(node: object | null | undefined, opts?: object | null): asserts node is ConditionalExpression;
declare function assertContinueStatement(node: object | null | undefined, opts?: object | null): asserts node is ContinueStatement;
declare function assertDebuggerStatement(node: object | null | undefined, opts?: object | null): asserts node is DebuggerStatement;
declare function assertDoWhileStatement(node: object | null | undefined, opts?: object | null): asserts node is DoWhileStatement;
declare function assertEmptyStatement(node: object | null | undefined, opts?: object | null): asserts node is EmptyStatement;
declare function assertExpressionStatement(node: object | null | undefined, opts?: object | null): asserts node is ExpressionStatement;
declare function assertFile(node: object | null | undefined, opts?: object | null): asserts node is File;
declare function assertForInStatement(node: object | null | undefined, opts?: object | null): asserts node is ForInStatement;
declare function assertForStatement(node: object | null | undefined, opts?: object | null): asserts node is ForStatement;
declare function assertFunctionDeclaration(node: object | null | undefined, opts?: object | null): asserts node is FunctionDeclaration;
declare function assertFunctionExpression(node: object | null | undefined, opts?: object | null): asserts node is FunctionExpression;
declare function assertIdentifier(node: object | null | undefined, opts?: object | null): asserts node is Identifier;
declare function assertIfStatement(node: object | null | undefined, opts?: object | null): asserts node is IfStatement;
declare function assertLabeledStatement(node: object | null | undefined, opts?: object | null): asserts node is LabeledStatement;
declare function assertStringLiteral(node: object | null | undefined, opts?: object | null): asserts node is StringLiteral;
declare function assertNumericLiteral(node: object | null | undefined, opts?: object | null): asserts node is NumericLiteral;
declare function assertNullLiteral(node: object | null | undefined, opts?: object | null): asserts node is NullLiteral;
declare function assertBooleanLiteral(node: object | null | undefined, opts?: object | null): asserts node is BooleanLiteral;
declare function assertRegExpLiteral(node: object | null | undefined, opts?: object | null): asserts node is RegExpLiteral;
declare function assertLogicalExpression(node: object | null | undefined, opts?: object | null): asserts node is LogicalExpression;
declare function assertMemberExpression(node: object | null | undefined, opts?: object | null): asserts node is MemberExpression;
declare function assertNewExpression(node: object | null | undefined, opts?: object | null): asserts node is NewExpression;
declare function assertProgram(node: object | null | undefined, opts?: object | null): asserts node is Program;
declare function assertObjectExpression(node: object | null | undefined, opts?: object | null): asserts node is ObjectExpression;
declare function assertObjectMethod(node: object | null | undefined, opts?: object | null): asserts node is ObjectMethod;
declare function assertObjectProperty(node: object | null | undefined, opts?: object | null): asserts node is ObjectProperty;
declare function assertRestElement(node: object | null | undefined, opts?: object | null): asserts node is RestElement;
declare function assertReturnStatement(node: object | null | undefined, opts?: object | null): asserts node is ReturnStatement;
declare function assertSequenceExpression(node: object | null | undefined, opts?: object | null): asserts node is SequenceExpression;
declare function assertParenthesizedExpression(node: object | null | undefined, opts?: object | null): asserts node is ParenthesizedExpression;
declare function assertSwitchCase(node: object | null | undefined, opts?: object | null): asserts node is SwitchCase;
declare function assertSwitchStatement(node: object | null | undefined, opts?: object | null): asserts node is SwitchStatement;
declare function assertThisExpression(node: object | null | undefined, opts?: object | null): asserts node is ThisExpression;
declare function assertThrowStatement(node: object | null | undefined, opts?: object | null): asserts node is ThrowStatement;
declare function assertTryStatement(node: object | null | undefined, opts?: object | null): asserts node is TryStatement;
declare function assertUnaryExpression(node: object | null | undefined, opts?: object | null): asserts node is UnaryExpression;
declare function assertUpdateExpression(node: object | null | undefined, opts?: object | null): asserts node is UpdateExpression;
declare function assertVariableDeclaration(node: object | null | undefined, opts?: object | null): asserts node is VariableDeclaration;
declare function assertVariableDeclarator(node: object | null | undefined, opts?: object | null): asserts node is VariableDeclarator;
declare function assertWhileStatement(node: object | null | undefined, opts?: object | null): asserts node is WhileStatement;
declare function assertWithStatement(node: object | null | undefined, opts?: object | null): asserts node is WithStatement;
declare function assertAssignmentPattern(node: object | null | undefined, opts?: object | null): asserts node is AssignmentPattern;
declare function assertArrayPattern(node: object | null | undefined, opts?: object | null): asserts node is ArrayPattern;
declare function assertArrowFunctionExpression(node: object | null | undefined, opts?: object | null): asserts node is ArrowFunctionExpression;
declare function assertClassBody(node: object | null | undefined, opts?: object | null): asserts node is ClassBody;
declare function assertClassExpression(node: object | null | undefined, opts?: object | null): asserts node is ClassExpression;
declare function assertClassDeclaration(node: object | null | undefined, opts?: object | null): asserts node is ClassDeclaration;
declare function assertExportAllDeclaration(node: object | null | undefined, opts?: object | null): asserts node is ExportAllDeclaration;
declare function assertExportDefaultDeclaration(node: object | null | undefined, opts?: object | null): asserts node is ExportDefaultDeclaration;
declare function assertExportNamedDeclaration(node: object | null | undefined, opts?: object | null): asserts node is ExportNamedDeclaration;
declare function assertExportSpecifier(node: object | null | undefined, opts?: object | null): asserts node is ExportSpecifier;
declare function assertForOfStatement(node: object | null | undefined, opts?: object | null): asserts node is ForOfStatement;
declare function assertImportDeclaration(node: object | null | undefined, opts?: object | null): asserts node is ImportDeclaration;
declare function assertImportDefaultSpecifier(node: object | null | undefined, opts?: object | null): asserts node is ImportDefaultSpecifier;
declare function assertImportNamespaceSpecifier(node: object | null | undefined, opts?: object | null): asserts node is ImportNamespaceSpecifier;
declare function assertImportSpecifier(node: object | null | undefined, opts?: object | null): asserts node is ImportSpecifier;
declare function assertImportExpression(node: object | null | undefined, opts?: object | null): asserts node is ImportExpression;
declare function assertMetaProperty(node: object | null | undefined, opts?: object | null): asserts node is MetaProperty;
declare function assertClassMethod(node: object | null | undefined, opts?: object | null): asserts node is ClassMethod;
declare function assertObjectPattern(node: object | null | undefined, opts?: object | null): asserts node is ObjectPattern;
declare function assertSpreadElement(node: object | null | undefined, opts?: object | null): asserts node is SpreadElement;
declare function assertSuper(node: object | null | undefined, opts?: object | null): asserts node is Super;
declare function assertTaggedTemplateExpression(node: object | null | undefined, opts?: object | null): asserts node is TaggedTemplateExpression;
declare function assertTemplateElement(node: object | null | undefined, opts?: object | null): asserts node is TemplateElement;
declare function assertTemplateLiteral(node: object | null | undefined, opts?: object | null): asserts node is TemplateLiteral;
declare function assertYieldExpression(node: object | null | undefined, opts?: object | null): asserts node is YieldExpression;
declare function assertAwaitExpression(node: object | null | undefined, opts?: object | null): asserts node is AwaitExpression;
declare function assertImport(node: object | null | undefined, opts?: object | null): asserts node is Import;
declare function assertBigIntLiteral(node: object | null | undefined, opts?: object | null): asserts node is BigIntLiteral;
declare function assertExportNamespaceSpecifier(node: object | null | undefined, opts?: object | null): asserts node is ExportNamespaceSpecifier;
declare function assertOptionalMemberExpression(node: object | null | undefined, opts?: object | null): asserts node is OptionalMemberExpression;
declare function assertOptionalCallExpression(node: object | null | undefined, opts?: object | null): asserts node is OptionalCallExpression;
declare function assertClassProperty(node: object | null | undefined, opts?: object | null): asserts node is ClassProperty;
declare function assertClassAccessorProperty(node: object | null | undefined, opts?: object | null): asserts node is ClassAccessorProperty;
declare function assertClassPrivateProperty(node: object | null | undefined, opts?: object | null): asserts node is ClassPrivateProperty;
declare function assertClassPrivateMethod(node: object | null | undefined, opts?: object | null): asserts node is ClassPrivateMethod;
declare function assertPrivateName(node: object | null | undefined, opts?: object | null): asserts node is PrivateName;
declare function assertStaticBlock(node: object | null | undefined, opts?: object | null): asserts node is StaticBlock;
declare function assertImportAttribute(node: object | null | undefined, opts?: object | null): asserts node is ImportAttribute;
declare function assertAnyTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is AnyTypeAnnotation;
declare function assertArrayTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is ArrayTypeAnnotation;
declare function assertBooleanTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is BooleanTypeAnnotation;
declare function assertBooleanLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is BooleanLiteralTypeAnnotation;
declare function assertNullLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is NullLiteralTypeAnnotation;
declare function assertClassImplements(node: object | null | undefined, opts?: object | null): asserts node is ClassImplements;
declare function assertDeclareClass(node: object | null | undefined, opts?: object | null): asserts node is DeclareClass;
declare function assertDeclareFunction(node: object | null | undefined, opts?: object | null): asserts node is DeclareFunction;
declare function assertDeclareInterface(node: object | null | undefined, opts?: object | null): asserts node is DeclareInterface;
declare function assertDeclareModule(node: object | null | undefined, opts?: object | null): asserts node is DeclareModule;
declare function assertDeclareModuleExports(node: object | null | undefined, opts?: object | null): asserts node is DeclareModuleExports;
declare function assertDeclareTypeAlias(node: object | null | undefined, opts?: object | null): asserts node is DeclareTypeAlias;
declare function assertDeclareOpaqueType(node: object | null | undefined, opts?: object | null): asserts node is DeclareOpaqueType;
declare function assertDeclareVariable(node: object | null | undefined, opts?: object | null): asserts node is DeclareVariable;
declare function assertDeclareExportDeclaration(node: object | null | undefined, opts?: object | null): asserts node is DeclareExportDeclaration;
declare function assertDeclareExportAllDeclaration(node: object | null | undefined, opts?: object | null): asserts node is DeclareExportAllDeclaration;
declare function assertDeclaredPredicate(node: object | null | undefined, opts?: object | null): asserts node is DeclaredPredicate;
declare function assertExistsTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is ExistsTypeAnnotation;
declare function assertFunctionTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is FunctionTypeAnnotation;
declare function assertFunctionTypeParam(node: object | null | undefined, opts?: object | null): asserts node is FunctionTypeParam;
declare function assertGenericTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is GenericTypeAnnotation;
declare function assertInferredPredicate(node: object | null | undefined, opts?: object | null): asserts node is InferredPredicate;
declare function assertInterfaceExtends(node: object | null | undefined, opts?: object | null): asserts node is InterfaceExtends;
declare function assertInterfaceDeclaration(node: object | null | undefined, opts?: object | null): asserts node is InterfaceDeclaration;
declare function assertInterfaceTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is InterfaceTypeAnnotation;
declare function assertIntersectionTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is IntersectionTypeAnnotation;
declare function assertMixedTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is MixedTypeAnnotation;
declare function assertEmptyTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is EmptyTypeAnnotation;
declare function assertNullableTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is NullableTypeAnnotation;
declare function assertNumberLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is NumberLiteralTypeAnnotation;
declare function assertNumberTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is NumberTypeAnnotation;
declare function assertObjectTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is ObjectTypeAnnotation;
declare function assertObjectTypeInternalSlot(node: object | null | undefined, opts?: object | null): asserts node is ObjectTypeInternalSlot;
declare function assertObjectTypeCallProperty(node: object | null | undefined, opts?: object | null): asserts node is ObjectTypeCallProperty;
declare function assertObjectTypeIndexer(node: object | null | undefined, opts?: object | null): asserts node is ObjectTypeIndexer;
declare function assertObjectTypeProperty(node: object | null | undefined, opts?: object | null): asserts node is ObjectTypeProperty;
declare function assertObjectTypeSpreadProperty(node: object | null | undefined, opts?: object | null): asserts node is ObjectTypeSpreadProperty;
declare function assertOpaqueType(node: object | null | undefined, opts?: object | null): asserts node is OpaqueType;
declare function assertQualifiedTypeIdentifier(node: object | null | undefined, opts?: object | null): asserts node is QualifiedTypeIdentifier;
declare function assertStringLiteralTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is StringLiteralTypeAnnotation;
declare function assertStringTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is StringTypeAnnotation;
declare function assertSymbolTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is SymbolTypeAnnotation;
declare function assertThisTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is ThisTypeAnnotation;
declare function assertTupleTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is TupleTypeAnnotation;
declare function assertTypeofTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is TypeofTypeAnnotation;
declare function assertTypeAlias(node: object | null | undefined, opts?: object | null): asserts node is TypeAlias;
declare function assertTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is TypeAnnotation;
declare function assertTypeCastExpression(node: object | null | undefined, opts?: object | null): asserts node is TypeCastExpression;
declare function assertTypeParameter(node: object | null | undefined, opts?: object | null): asserts node is TypeParameter;
declare function assertTypeParameterDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TypeParameterDeclaration;
declare function assertTypeParameterInstantiation(node: object | null | undefined, opts?: object | null): asserts node is TypeParameterInstantiation;
declare function assertUnionTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is UnionTypeAnnotation;
declare function assertVariance(node: object | null | undefined, opts?: object | null): asserts node is Variance;
declare function assertVoidTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is VoidTypeAnnotation;
declare function assertEnumDeclaration(node: object | null | undefined, opts?: object | null): asserts node is EnumDeclaration;
declare function assertEnumBooleanBody(node: object | null | undefined, opts?: object | null): asserts node is EnumBooleanBody;
declare function assertEnumNumberBody(node: object | null | undefined, opts?: object | null): asserts node is EnumNumberBody;
declare function assertEnumStringBody(node: object | null | undefined, opts?: object | null): asserts node is EnumStringBody;
declare function assertEnumSymbolBody(node: object | null | undefined, opts?: object | null): asserts node is EnumSymbolBody;
declare function assertEnumBooleanMember(node: object | null | undefined, opts?: object | null): asserts node is EnumBooleanMember;
declare function assertEnumNumberMember(node: object | null | undefined, opts?: object | null): asserts node is EnumNumberMember;
declare function assertEnumStringMember(node: object | null | undefined, opts?: object | null): asserts node is EnumStringMember;
declare function assertEnumDefaultedMember(node: object | null | undefined, opts?: object | null): asserts node is EnumDefaultedMember;
declare function assertIndexedAccessType(node: object | null | undefined, opts?: object | null): asserts node is IndexedAccessType;
declare function assertOptionalIndexedAccessType(node: object | null | undefined, opts?: object | null): asserts node is OptionalIndexedAccessType;
declare function assertJSXAttribute(node: object | null | undefined, opts?: object | null): asserts node is JSXAttribute;
declare function assertJSXClosingElement(node: object | null | undefined, opts?: object | null): asserts node is JSXClosingElement;
declare function assertJSXElement(node: object | null | undefined, opts?: object | null): asserts node is JSXElement;
declare function assertJSXEmptyExpression(node: object | null | undefined, opts?: object | null): asserts node is JSXEmptyExpression;
declare function assertJSXExpressionContainer(node: object | null | undefined, opts?: object | null): asserts node is JSXExpressionContainer;
declare function assertJSXSpreadChild(node: object | null | undefined, opts?: object | null): asserts node is JSXSpreadChild;
declare function assertJSXIdentifier(node: object | null | undefined, opts?: object | null): asserts node is JSXIdentifier;
declare function assertJSXMemberExpression(node: object | null | undefined, opts?: object | null): asserts node is JSXMemberExpression;
declare function assertJSXNamespacedName(node: object | null | undefined, opts?: object | null): asserts node is JSXNamespacedName;
declare function assertJSXOpeningElement(node: object | null | undefined, opts?: object | null): asserts node is JSXOpeningElement;
declare function assertJSXSpreadAttribute(node: object | null | undefined, opts?: object | null): asserts node is JSXSpreadAttribute;
declare function assertJSXText(node: object | null | undefined, opts?: object | null): asserts node is JSXText;
declare function assertJSXFragment(node: object | null | undefined, opts?: object | null): asserts node is JSXFragment;
declare function assertJSXOpeningFragment(node: object | null | undefined, opts?: object | null): asserts node is JSXOpeningFragment;
declare function assertJSXClosingFragment(node: object | null | undefined, opts?: object | null): asserts node is JSXClosingFragment;
declare function assertNoop(node: object | null | undefined, opts?: object | null): asserts node is Noop;
declare function assertPlaceholder(node: object | null | undefined, opts?: object | null): asserts node is Placeholder;
declare function assertV8IntrinsicIdentifier(node: object | null | undefined, opts?: object | null): asserts node is V8IntrinsicIdentifier;
declare function assertArgumentPlaceholder(node: object | null | undefined, opts?: object | null): asserts node is ArgumentPlaceholder;
declare function assertBindExpression(node: object | null | undefined, opts?: object | null): asserts node is BindExpression;
declare function assertDecorator(node: object | null | undefined, opts?: object | null): asserts node is Decorator;
declare function assertDoExpression(node: object | null | undefined, opts?: object | null): asserts node is DoExpression;
declare function assertExportDefaultSpecifier(node: object | null | undefined, opts?: object | null): asserts node is ExportDefaultSpecifier;
declare function assertRecordExpression(node: object | null | undefined, opts?: object | null): asserts node is RecordExpression;
declare function assertTupleExpression(node: object | null | undefined, opts?: object | null): asserts node is TupleExpression;
declare function assertDecimalLiteral(node: object | null | undefined, opts?: object | null): asserts node is DecimalLiteral;
declare function assertModuleExpression(node: object | null | undefined, opts?: object | null): asserts node is ModuleExpression;
declare function assertTopicReference(node: object | null | undefined, opts?: object | null): asserts node is TopicReference;
declare function assertPipelineTopicExpression(node: object | null | undefined, opts?: object | null): asserts node is PipelineTopicExpression;
declare function assertPipelineBareFunction(node: object | null | undefined, opts?: object | null): asserts node is PipelineBareFunction;
declare function assertPipelinePrimaryTopicReference(node: object | null | undefined, opts?: object | null): asserts node is PipelinePrimaryTopicReference;
declare function assertVoidPattern(node: object | null | undefined, opts?: object | null): asserts node is VoidPattern;
declare function assertTSParameterProperty(node: object | null | undefined, opts?: object | null): asserts node is TSParameterProperty;
declare function assertTSDeclareFunction(node: object | null | undefined, opts?: object | null): asserts node is TSDeclareFunction;
declare function assertTSDeclareMethod(node: object | null | undefined, opts?: object | null): asserts node is TSDeclareMethod;
declare function assertTSQualifiedName(node: object | null | undefined, opts?: object | null): asserts node is TSQualifiedName;
declare function assertTSCallSignatureDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSCallSignatureDeclaration;
declare function assertTSConstructSignatureDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSConstructSignatureDeclaration;
declare function assertTSPropertySignature(node: object | null | undefined, opts?: object | null): asserts node is TSPropertySignature;
declare function assertTSMethodSignature(node: object | null | undefined, opts?: object | null): asserts node is TSMethodSignature;
declare function assertTSIndexSignature(node: object | null | undefined, opts?: object | null): asserts node is TSIndexSignature;
declare function assertTSAnyKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSAnyKeyword;
declare function assertTSBooleanKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSBooleanKeyword;
declare function assertTSBigIntKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSBigIntKeyword;
declare function assertTSIntrinsicKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSIntrinsicKeyword;
declare function assertTSNeverKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSNeverKeyword;
declare function assertTSNullKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSNullKeyword;
declare function assertTSNumberKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSNumberKeyword;
declare function assertTSObjectKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSObjectKeyword;
declare function assertTSStringKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSStringKeyword;
declare function assertTSSymbolKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSSymbolKeyword;
declare function assertTSUndefinedKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSUndefinedKeyword;
declare function assertTSUnknownKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSUnknownKeyword;
declare function assertTSVoidKeyword(node: object | null | undefined, opts?: object | null): asserts node is TSVoidKeyword;
declare function assertTSThisType(node: object | null | undefined, opts?: object | null): asserts node is TSThisType;
declare function assertTSFunctionType(node: object | null | undefined, opts?: object | null): asserts node is TSFunctionType;
declare function assertTSConstructorType(node: object | null | undefined, opts?: object | null): asserts node is TSConstructorType;
declare function assertTSTypeReference(node: object | null | undefined, opts?: object | null): asserts node is TSTypeReference;
declare function assertTSTypePredicate(node: object | null | undefined, opts?: object | null): asserts node is TSTypePredicate;
declare function assertTSTypeQuery(node: object | null | undefined, opts?: object | null): asserts node is TSTypeQuery;
declare function assertTSTypeLiteral(node: object | null | undefined, opts?: object | null): asserts node is TSTypeLiteral;
declare function assertTSArrayType(node: object | null | undefined, opts?: object | null): asserts node is TSArrayType;
declare function assertTSTupleType(node: object | null | undefined, opts?: object | null): asserts node is TSTupleType;
declare function assertTSOptionalType(node: object | null | undefined, opts?: object | null): asserts node is TSOptionalType;
declare function assertTSRestType(node: object | null | undefined, opts?: object | null): asserts node is TSRestType;
declare function assertTSNamedTupleMember(node: object | null | undefined, opts?: object | null): asserts node is TSNamedTupleMember;
declare function assertTSUnionType(node: object | null | undefined, opts?: object | null): asserts node is TSUnionType;
declare function assertTSIntersectionType(node: object | null | undefined, opts?: object | null): asserts node is TSIntersectionType;
declare function assertTSConditionalType(node: object | null | undefined, opts?: object | null): asserts node is TSConditionalType;
declare function assertTSInferType(node: object | null | undefined, opts?: object | null): asserts node is TSInferType;
declare function assertTSParenthesizedType(node: object | null | undefined, opts?: object | null): asserts node is TSParenthesizedType;
declare function assertTSTypeOperator(node: object | null | undefined, opts?: object | null): asserts node is TSTypeOperator;
declare function assertTSIndexedAccessType(node: object | null | undefined, opts?: object | null): asserts node is TSIndexedAccessType;
declare function assertTSMappedType(node: object | null | undefined, opts?: object | null): asserts node is TSMappedType;
declare function assertTSTemplateLiteralType(node: object | null | undefined, opts?: object | null): asserts node is TSTemplateLiteralType;
declare function assertTSLiteralType(node: object | null | undefined, opts?: object | null): asserts node is TSLiteralType;
declare function assertTSExpressionWithTypeArguments(node: object | null | undefined, opts?: object | null): asserts node is TSExpressionWithTypeArguments;
declare function assertTSInterfaceDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSInterfaceDeclaration;
declare function assertTSInterfaceBody(node: object | null | undefined, opts?: object | null): asserts node is TSInterfaceBody;
declare function assertTSTypeAliasDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSTypeAliasDeclaration;
declare function assertTSInstantiationExpression(node: object | null | undefined, opts?: object | null): asserts node is TSInstantiationExpression;
declare function assertTSAsExpression(node: object | null | undefined, opts?: object | null): asserts node is TSAsExpression;
declare function assertTSSatisfiesExpression(node: object | null | undefined, opts?: object | null): asserts node is TSSatisfiesExpression;
declare function assertTSTypeAssertion(node: object | null | undefined, opts?: object | null): asserts node is TSTypeAssertion;
declare function assertTSEnumBody(node: object | null | undefined, opts?: object | null): asserts node is TSEnumBody;
declare function assertTSEnumDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSEnumDeclaration;
declare function assertTSEnumMember(node: object | null | undefined, opts?: object | null): asserts node is TSEnumMember;
declare function assertTSModuleDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSModuleDeclaration;
declare function assertTSModuleBlock(node: object | null | undefined, opts?: object | null): asserts node is TSModuleBlock;
declare function assertTSImportType(node: object | null | undefined, opts?: object | null): asserts node is TSImportType;
declare function assertTSImportEqualsDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSImportEqualsDeclaration;
declare function assertTSExternalModuleReference(node: object | null | undefined, opts?: object | null): asserts node is TSExternalModuleReference;
declare function assertTSNonNullExpression(node: object | null | undefined, opts?: object | null): asserts node is TSNonNullExpression;
declare function assertTSExportAssignment(node: object | null | undefined, opts?: object | null): asserts node is TSExportAssignment;
declare function assertTSNamespaceExportDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSNamespaceExportDeclaration;
declare function assertTSTypeAnnotation(node: object | null | undefined, opts?: object | null): asserts node is TSTypeAnnotation;
declare function assertTSTypeParameterInstantiation(node: object | null | undefined, opts?: object | null): asserts node is TSTypeParameterInstantiation;
declare function assertTSTypeParameterDeclaration(node: object | null | undefined, opts?: object | null): asserts node is TSTypeParameterDeclaration;
declare function assertTSTypeParameter(node: object | null | undefined, opts?: object | null): asserts node is TSTypeParameter;
declare function assertStandardized(node: object | null | undefined, opts?: object | null): asserts node is Standardized;
declare function assertExpression(node: object | null | undefined, opts?: object | null): asserts node is Expression;
declare function assertBinary(node: object | null | undefined, opts?: object | null): asserts node is Binary;
declare function assertScopable(node: object | null | undefined, opts?: object | null): asserts node is Scopable;
declare function assertBlockParent(node: object | null | undefined, opts?: object | null): asserts node is BlockParent;
declare function assertBlock(node: object | null | undefined, opts?: object | null): asserts node is Block;
declare function assertStatement(node: object | null | undefined, opts?: object | null): asserts node is Statement;
declare function assertTerminatorless(node: object | null | undefined, opts?: object | null): asserts node is Terminatorless;
declare function assertCompletionStatement(node: object | null | undefined, opts?: object | null): asserts node is CompletionStatement;
declare function assertConditional(node: object | null | undefined, opts?: object | null): asserts node is Conditional;
declare function assertLoop(node: object | null | undefined, opts?: object | null): asserts node is Loop;
declare function assertWhile(node: object | null | undefined, opts?: object | null): asserts node is While;
declare function assertExpressionWrapper(node: object | null | undefined, opts?: object | null): asserts node is ExpressionWrapper;
declare function assertFor(node: object | null | undefined, opts?: object | null): asserts node is For;
declare function assertForXStatement(node: object | null | undefined, opts?: object | null): asserts node is ForXStatement;
declare function assertFunction(node: object | null | undefined, opts?: object | null): asserts node is Function;
declare function assertFunctionParent(node: object | null | undefined, opts?: object | null): asserts node is FunctionParent;
declare function assertPureish(node: object | null | undefined, opts?: object | null): asserts node is Pureish;
declare function assertDeclaration(node: object | null | undefined, opts?: object | null): asserts node is Declaration;
declare function assertFunctionParameter(node: object | null | undefined, opts?: object | null): asserts node is FunctionParameter;
declare function assertPatternLike(node: object | null | undefined, opts?: object | null): asserts node is PatternLike;
declare function assertLVal(node: object | null | undefined, opts?: object | null): asserts node is LVal;
declare function assertTSEntityName(node: object | null | undefined, opts?: object | null): asserts node is TSEntityName;
declare function assertLiteral(node: object | null | undefined, opts?: object | null): asserts node is Literal;
declare function assertImmutable(node: object | null | undefined, opts?: object | null): asserts node is Immutable;
declare function assertUserWhitespacable(node: object | null | undefined, opts?: object | null): asserts node is UserWhitespacable;
declare function assertMethod(node: object | null | undefined, opts?: object | null): asserts node is Method;
declare function assertObjectMember(node: object | null | undefined, opts?: object | null): asserts node is ObjectMember;
declare function assertProperty(node: object | null | undefined, opts?: object | null): asserts node is Property;
declare function assertUnaryLike(node: object | null | undefined, opts?: object | null): asserts node is UnaryLike;
declare function assertPattern(node: object | null | undefined, opts?: object | null): asserts node is Pattern;
declare function assertClass(node: object | null | undefined, opts?: object | null): asserts node is Class;
declare function assertImportOrExportDeclaration(node: object | null | undefined, opts?: object | null): asserts node is ImportOrExportDeclaration;
declare function assertExportDeclaration(node: object | null | undefined, opts?: object | null): asserts node is ExportDeclaration;
declare function assertModuleSpecifier(node: object | null | undefined, opts?: object | null): asserts node is ModuleSpecifier;
declare function assertAccessor(node: object | null | undefined, opts?: object | null): asserts node is Accessor;
declare function assertPrivate(node: object | null | undefined, opts?: object | null): asserts node is Private;
declare function assertFlow(node: object | null | undefined, opts?: object | null): asserts node is Flow;
declare function assertFlowType(node: object | null | undefined, opts?: object | null): asserts node is FlowType;
declare function assertFlowBaseAnnotation(node: object | null | undefined, opts?: object | null): asserts node is FlowBaseAnnotation;
declare function assertFlowDeclaration(node: object | null | undefined, opts?: object | null): asserts node is FlowDeclaration;
declare function assertFlowPredicate(node: object | null | undefined, opts?: object | null): asserts node is FlowPredicate;
declare function assertEnumBody(node: object | null | undefined, opts?: object | null): asserts node is EnumBody;
declare function assertEnumMember(node: object | null | undefined, opts?: object | null): asserts node is EnumMember;
declare function assertJSX(node: object | null | undefined, opts?: object | null): asserts node is JSX;
declare function assertMiscellaneous(node: object | null | undefined, opts?: object | null): asserts node is Miscellaneous;
declare function assertTypeScript(node: object | null | undefined, opts?: object | null): asserts node is TypeScript;
declare function assertTSTypeElement(node: object | null | undefined, opts?: object | null): asserts node is TSTypeElement;
declare function assertTSType(node: object | null | undefined, opts?: object | null): asserts node is TSType;
declare function assertTSBaseType(node: object | null | undefined, opts?: object | null): asserts node is TSBaseType;
declare function assertNumberLiteral(node: any, opts: any): void;
declare function assertRegexLiteral(node: any, opts: any): void;
declare function assertRestProperty(node: any, opts: any): void;
declare function assertSpreadProperty(node: any, opts: any): void;
declare function assertModuleDeclaration(node: any, opts: any): void;

declare const _default$4: {
    (type: "string"): StringTypeAnnotation;
    (type: "number"): NumberTypeAnnotation;
    (type: "undefined"): VoidTypeAnnotation;
    (type: "boolean"): BooleanTypeAnnotation;
    (type: "function"): GenericTypeAnnotation;
    (type: "object"): GenericTypeAnnotation;
    (type: "symbol"): GenericTypeAnnotation;
    (type: "bigint"): AnyTypeAnnotation;
};
//# sourceMappingURL=createTypeAnnotationBasedOnTypeof.d.ts.map

/**
 * Takes an array of `types` and flattens them, removing duplicates and
 * returns a `UnionTypeAnnotation` node containing them.
 */
declare function createFlowUnionType<T extends FlowType>(types: [T] | Array<T>): T | UnionTypeAnnotation;

/**
 * Takes an array of `types` and flattens them, removing duplicates and
 * returns a `UnionTypeAnnotation` node containing them.
 */
declare function createTSUnionType(typeAnnotations: Array<TSTypeAnnotation | TSType>): TSType;

interface BaseComment {
    value: string;
    start?: number;
    end?: number;
    loc?: SourceLocation;
    ignore?: boolean;
    type: "CommentBlock" | "CommentLine";
}
interface Position$1 {
    line: number;
    column: number;
    index: number;
}
interface CommentBlock extends BaseComment {
    type: "CommentBlock";
}
interface CommentLine extends BaseComment {
    type: "CommentLine";
}
type Comment = CommentBlock | CommentLine;
interface SourceLocation {
    start: Position$1;
    end: Position$1;
    filename: string;
    identifierName: string | undefined | null;
}
interface BaseNode {
    leadingComments?: Comment[] | null;
    innerComments?: Comment[] | null;
    trailingComments?: Comment[] | null;
    start?: number | null;
    end?: number | null;
    loc?: SourceLocation | null;
    range?: [number, number];
    extra?: Record<string, unknown>;
}
type CommentTypeShorthand = "leading" | "inner" | "trailing";
type Node$1 = AnyTypeAnnotation | ArgumentPlaceholder | ArrayExpression | ArrayPattern | ArrayTypeAnnotation | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BigIntLiteral | BinaryExpression | BindExpression | BlockStatement | BooleanLiteral | BooleanLiteralTypeAnnotation | BooleanTypeAnnotation | BreakStatement | CallExpression | CatchClause | ClassAccessorProperty | ClassBody | ClassDeclaration | ClassExpression | ClassImplements | ClassMethod | ClassPrivateMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | ContinueStatement | DebuggerStatement | DecimalLiteral | DeclareClass | DeclareExportAllDeclaration | DeclareExportDeclaration | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareOpaqueType | DeclareTypeAlias | DeclareVariable | DeclaredPredicate | Decorator | Directive | DirectiveLiteral | DoExpression | DoWhileStatement | EmptyStatement | EmptyTypeAnnotation | EnumBooleanBody | EnumBooleanMember | EnumDeclaration | EnumDefaultedMember | EnumNumberBody | EnumNumberMember | EnumStringBody | EnumStringMember | EnumSymbolBody | ExistsTypeAnnotation | ExportAllDeclaration | ExportDefaultDeclaration | ExportDefaultSpecifier | ExportNamedDeclaration | ExportNamespaceSpecifier | ExportSpecifier | ExpressionStatement | File | ForInStatement | ForOfStatement | ForStatement | FunctionDeclaration | FunctionExpression | FunctionTypeAnnotation | FunctionTypeParam | GenericTypeAnnotation | Identifier | IfStatement | Import | ImportAttribute | ImportDeclaration | ImportDefaultSpecifier | ImportExpression | ImportNamespaceSpecifier | ImportSpecifier | IndexedAccessType | InferredPredicate | InterfaceDeclaration | InterfaceExtends | InterfaceTypeAnnotation | InterpreterDirective | IntersectionTypeAnnotation | JSXAttribute | JSXClosingElement | JSXClosingFragment | JSXElement | JSXEmptyExpression | JSXExpressionContainer | JSXFragment | JSXIdentifier | JSXMemberExpression | JSXNamespacedName | JSXOpeningElement | JSXOpeningFragment | JSXSpreadAttribute | JSXSpreadChild | JSXText | LabeledStatement | LogicalExpression | MemberExpression | MetaProperty | MixedTypeAnnotation | ModuleExpression | NewExpression | Noop | NullLiteral | NullLiteralTypeAnnotation | NullableTypeAnnotation | NumberLiteral$1 | NumberLiteralTypeAnnotation | NumberTypeAnnotation | NumericLiteral | ObjectExpression | ObjectMethod | ObjectPattern | ObjectProperty | ObjectTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalCallExpression | OptionalIndexedAccessType | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelinePrimaryTopicReference | PipelineTopicExpression | Placeholder | PrivateName | Program | QualifiedTypeIdentifier | RecordExpression | RegExpLiteral | RegexLiteral$1 | RestElement | RestProperty$1 | ReturnStatement | SequenceExpression | SpreadElement | SpreadProperty$1 | StaticBlock | StringLiteral | StringLiteralTypeAnnotation | StringTypeAnnotation | Super | SwitchCase | SwitchStatement | SymbolTypeAnnotation | TSAnyKeyword | TSArrayType | TSAsExpression | TSBigIntKeyword | TSBooleanKeyword | TSCallSignatureDeclaration | TSConditionalType | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSEnumBody | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSExpressionWithTypeArguments | TSExternalModuleReference | TSFunctionType | TSImportEqualsDeclaration | TSImportType | TSIndexSignature | TSIndexedAccessType | TSInferType | TSInstantiationExpression | TSInterfaceBody | TSInterfaceDeclaration | TSIntersectionType | TSIntrinsicKeyword | TSLiteralType | TSMappedType | TSMethodSignature | TSModuleBlock | TSModuleDeclaration | TSNamedTupleMember | TSNamespaceExportDeclaration | TSNeverKeyword | TSNonNullExpression | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSOptionalType | TSParameterProperty | TSParenthesizedType | TSPropertySignature | TSQualifiedName | TSRestType | TSSatisfiesExpression | TSStringKeyword | TSSymbolKeyword | TSTemplateLiteralType | TSThisType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeLiteral | TSTypeOperator | TSTypeParameter | TSTypeParameterDeclaration | TSTypeParameterInstantiation | TSTypePredicate | TSTypeQuery | TSTypeReference | TSUndefinedKeyword | TSUnionType | TSUnknownKeyword | TSVoidKeyword | TaggedTemplateExpression | TemplateElement | TemplateLiteral | ThisExpression | ThisTypeAnnotation | ThrowStatement | TopicReference | TryStatement | TupleExpression | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeCastExpression | TypeParameter | TypeParameterDeclaration | TypeParameterInstantiation | TypeofTypeAnnotation | UnaryExpression | UnionTypeAnnotation | UpdateExpression | V8IntrinsicIdentifier | VariableDeclaration | VariableDeclarator | Variance | VoidPattern | VoidTypeAnnotation | WhileStatement | WithStatement | YieldExpression;
interface ArrayExpression extends BaseNode {
    type: "ArrayExpression";
    elements: Array<null | Expression | SpreadElement>;
}
interface AssignmentExpression extends BaseNode {
    type: "AssignmentExpression";
    operator: string;
    left: LVal | OptionalMemberExpression;
    right: Expression;
}
interface BinaryExpression extends BaseNode {
    type: "BinaryExpression";
    operator: "+" | "-" | "/" | "%" | "*" | "**" | "&" | "|" | ">>" | ">>>" | "<<" | "^" | "==" | "===" | "!=" | "!==" | "in" | "instanceof" | ">" | "<" | ">=" | "<=" | "|>";
    left: Expression | PrivateName;
    right: Expression;
}
interface InterpreterDirective extends BaseNode {
    type: "InterpreterDirective";
    value: string;
}
interface Directive extends BaseNode {
    type: "Directive";
    value: DirectiveLiteral;
}
interface DirectiveLiteral extends BaseNode {
    type: "DirectiveLiteral";
    value: string;
}
interface BlockStatement extends BaseNode {
    type: "BlockStatement";
    body: Array<Statement>;
    directives: Array<Directive>;
}
interface BreakStatement extends BaseNode {
    type: "BreakStatement";
    label?: Identifier | null;
}
interface CallExpression extends BaseNode {
    type: "CallExpression";
    callee: Expression | Super | V8IntrinsicIdentifier;
    arguments: Array<Expression | SpreadElement | ArgumentPlaceholder>;
    optional?: boolean | null;
    typeArguments?: TypeParameterInstantiation | null;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface CatchClause extends BaseNode {
    type: "CatchClause";
    param?: Identifier | ArrayPattern | ObjectPattern | null;
    body: BlockStatement;
}
interface ConditionalExpression extends BaseNode {
    type: "ConditionalExpression";
    test: Expression;
    consequent: Expression;
    alternate: Expression;
}
interface ContinueStatement extends BaseNode {
    type: "ContinueStatement";
    label?: Identifier | null;
}
interface DebuggerStatement extends BaseNode {
    type: "DebuggerStatement";
}
interface DoWhileStatement extends BaseNode {
    type: "DoWhileStatement";
    test: Expression;
    body: Statement;
}
interface EmptyStatement extends BaseNode {
    type: "EmptyStatement";
}
interface ExpressionStatement extends BaseNode {
    type: "ExpressionStatement";
    expression: Expression;
}
interface File extends BaseNode {
    type: "File";
    program: Program;
    comments?: Array<CommentBlock | CommentLine> | null;
    tokens?: Array<any> | null;
}
interface ForInStatement extends BaseNode {
    type: "ForInStatement";
    left: VariableDeclaration | LVal;
    right: Expression;
    body: Statement;
}
interface ForStatement extends BaseNode {
    type: "ForStatement";
    init?: VariableDeclaration | Expression | null;
    test?: Expression | null;
    update?: Expression | null;
    body: Statement;
}
interface FunctionDeclaration extends BaseNode {
    type: "FunctionDeclaration";
    id?: Identifier | null;
    params: Array<FunctionParameter>;
    body: BlockStatement;
    generator: boolean;
    async: boolean;
    declare?: boolean | null;
    predicate?: DeclaredPredicate | InferredPredicate | null;
    returnType?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface FunctionExpression extends BaseNode {
    type: "FunctionExpression";
    id?: Identifier | null;
    params: Array<FunctionParameter>;
    body: BlockStatement;
    generator: boolean;
    async: boolean;
    predicate?: DeclaredPredicate | InferredPredicate | null;
    returnType?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface Identifier extends BaseNode {
    type: "Identifier";
    name: string;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
}
interface IfStatement extends BaseNode {
    type: "IfStatement";
    test: Expression;
    consequent: Statement;
    alternate?: Statement | null;
}
interface LabeledStatement extends BaseNode {
    type: "LabeledStatement";
    label: Identifier;
    body: Statement;
}
interface StringLiteral extends BaseNode {
    type: "StringLiteral";
    value: string;
}
interface NumericLiteral extends BaseNode {
    type: "NumericLiteral";
    value: number;
}
/**
 * @deprecated Use `NumericLiteral`
 */
interface NumberLiteral$1 extends BaseNode {
    type: "NumberLiteral";
    value: number;
}
interface NullLiteral extends BaseNode {
    type: "NullLiteral";
}
interface BooleanLiteral extends BaseNode {
    type: "BooleanLiteral";
    value: boolean;
}
interface RegExpLiteral extends BaseNode {
    type: "RegExpLiteral";
    pattern: string;
    flags: string;
}
/**
 * @deprecated Use `RegExpLiteral`
 */
interface RegexLiteral$1 extends BaseNode {
    type: "RegexLiteral";
    pattern: string;
    flags: string;
}
interface LogicalExpression extends BaseNode {
    type: "LogicalExpression";
    operator: "||" | "&&" | "??";
    left: Expression;
    right: Expression;
}
interface MemberExpression extends BaseNode {
    type: "MemberExpression";
    object: Expression | Super;
    property: Expression | Identifier | PrivateName;
    computed: boolean;
    optional?: boolean | null;
}
interface NewExpression extends BaseNode {
    type: "NewExpression";
    callee: Expression | Super | V8IntrinsicIdentifier;
    arguments: Array<Expression | SpreadElement | ArgumentPlaceholder>;
    optional?: boolean | null;
    typeArguments?: TypeParameterInstantiation | null;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface Program extends BaseNode {
    type: "Program";
    body: Array<Statement>;
    directives: Array<Directive>;
    sourceType: "script" | "module";
    interpreter?: InterpreterDirective | null;
}
interface ObjectExpression extends BaseNode {
    type: "ObjectExpression";
    properties: Array<ObjectMethod | ObjectProperty | SpreadElement>;
}
interface ObjectMethod extends BaseNode {
    type: "ObjectMethod";
    kind: "method" | "get" | "set";
    key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral;
    params: Array<FunctionParameter>;
    body: BlockStatement;
    computed: boolean;
    generator: boolean;
    async: boolean;
    decorators?: Array<Decorator> | null;
    returnType?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface ObjectProperty extends BaseNode {
    type: "ObjectProperty";
    key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral | DecimalLiteral | PrivateName;
    value: Expression | PatternLike;
    computed: boolean;
    shorthand: boolean;
    decorators?: Array<Decorator> | null;
}
interface RestElement extends BaseNode {
    type: "RestElement";
    argument: Identifier | ArrayPattern | ObjectPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression | RestElement | AssignmentPattern;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
}
/**
 * @deprecated Use `RestElement`
 */
interface RestProperty$1 extends BaseNode {
    type: "RestProperty";
    argument: Identifier | ArrayPattern | ObjectPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression | RestElement | AssignmentPattern;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
}
interface ReturnStatement extends BaseNode {
    type: "ReturnStatement";
    argument?: Expression | null;
}
interface SequenceExpression extends BaseNode {
    type: "SequenceExpression";
    expressions: Array<Expression>;
}
interface ParenthesizedExpression extends BaseNode {
    type: "ParenthesizedExpression";
    expression: Expression;
}
interface SwitchCase extends BaseNode {
    type: "SwitchCase";
    test?: Expression | null;
    consequent: Array<Statement>;
}
interface SwitchStatement extends BaseNode {
    type: "SwitchStatement";
    discriminant: Expression;
    cases: Array<SwitchCase>;
}
interface ThisExpression extends BaseNode {
    type: "ThisExpression";
}
interface ThrowStatement extends BaseNode {
    type: "ThrowStatement";
    argument: Expression;
}
interface TryStatement extends BaseNode {
    type: "TryStatement";
    block: BlockStatement;
    handler?: CatchClause | null;
    finalizer?: BlockStatement | null;
}
interface UnaryExpression extends BaseNode {
    type: "UnaryExpression";
    operator: "void" | "throw" | "delete" | "!" | "+" | "-" | "~" | "typeof";
    argument: Expression;
    prefix: boolean;
}
interface UpdateExpression extends BaseNode {
    type: "UpdateExpression";
    operator: "++" | "--";
    argument: Expression;
    prefix: boolean;
}
interface VariableDeclaration extends BaseNode {
    type: "VariableDeclaration";
    kind: "var" | "let" | "const" | "using" | "await using";
    declarations: Array<VariableDeclarator>;
    declare?: boolean | null;
}
interface VariableDeclarator extends BaseNode {
    type: "VariableDeclarator";
    id: LVal | VoidPattern;
    init?: Expression | null;
    definite?: boolean | null;
}
interface WhileStatement extends BaseNode {
    type: "WhileStatement";
    test: Expression;
    body: Statement;
}
interface WithStatement extends BaseNode {
    type: "WithStatement";
    object: Expression;
    body: Statement;
}
interface AssignmentPattern extends BaseNode {
    type: "AssignmentPattern";
    left: Identifier | ObjectPattern | ArrayPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
    right: Expression;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
}
interface ArrayPattern extends BaseNode {
    type: "ArrayPattern";
    elements: Array<null | PatternLike>;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
}
interface ArrowFunctionExpression extends BaseNode {
    type: "ArrowFunctionExpression";
    params: Array<FunctionParameter>;
    body: BlockStatement | Expression;
    async: boolean;
    expression: boolean;
    generator?: boolean;
    predicate?: DeclaredPredicate | InferredPredicate | null;
    returnType?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface ClassBody extends BaseNode {
    type: "ClassBody";
    body: Array<ClassMethod | ClassPrivateMethod | ClassProperty | ClassPrivateProperty | ClassAccessorProperty | TSDeclareMethod | TSIndexSignature | StaticBlock>;
}
interface ClassExpression extends BaseNode {
    type: "ClassExpression";
    id?: Identifier | null;
    superClass?: Expression | null;
    body: ClassBody;
    decorators?: Array<Decorator> | null;
    implements?: Array<TSExpressionWithTypeArguments | ClassImplements> | null;
    mixins?: InterfaceExtends | null;
    superTypeParameters?: TypeParameterInstantiation | TSTypeParameterInstantiation | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface ClassDeclaration extends BaseNode {
    type: "ClassDeclaration";
    id?: Identifier | null;
    superClass?: Expression | null;
    body: ClassBody;
    decorators?: Array<Decorator> | null;
    abstract?: boolean | null;
    declare?: boolean | null;
    implements?: Array<TSExpressionWithTypeArguments | ClassImplements> | null;
    mixins?: InterfaceExtends | null;
    superTypeParameters?: TypeParameterInstantiation | TSTypeParameterInstantiation | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface ExportAllDeclaration extends BaseNode {
    type: "ExportAllDeclaration";
    source: StringLiteral;
    /** @deprecated */
    assertions?: Array<ImportAttribute> | null;
    attributes?: Array<ImportAttribute> | null;
    exportKind?: "type" | "value" | null;
}
interface ExportDefaultDeclaration extends BaseNode {
    type: "ExportDefaultDeclaration";
    declaration: TSDeclareFunction | FunctionDeclaration | ClassDeclaration | Expression;
    exportKind?: "value" | null;
}
interface ExportNamedDeclaration extends BaseNode {
    type: "ExportNamedDeclaration";
    declaration?: Declaration | null;
    specifiers: Array<ExportSpecifier | ExportDefaultSpecifier | ExportNamespaceSpecifier>;
    source?: StringLiteral | null;
    /** @deprecated */
    assertions?: Array<ImportAttribute> | null;
    attributes?: Array<ImportAttribute> | null;
    exportKind?: "type" | "value" | null;
}
interface ExportSpecifier extends BaseNode {
    type: "ExportSpecifier";
    local: Identifier;
    exported: Identifier | StringLiteral;
    exportKind?: "type" | "value" | null;
}
interface ForOfStatement extends BaseNode {
    type: "ForOfStatement";
    left: VariableDeclaration | LVal;
    right: Expression;
    body: Statement;
    await: boolean;
}
interface ImportDeclaration extends BaseNode {
    type: "ImportDeclaration";
    specifiers: Array<ImportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier>;
    source: StringLiteral;
    /** @deprecated */
    assertions?: Array<ImportAttribute> | null;
    attributes?: Array<ImportAttribute> | null;
    importKind?: "type" | "typeof" | "value" | null;
    module?: boolean | null;
    phase?: "source" | "defer" | null;
}
interface ImportDefaultSpecifier extends BaseNode {
    type: "ImportDefaultSpecifier";
    local: Identifier;
}
interface ImportNamespaceSpecifier extends BaseNode {
    type: "ImportNamespaceSpecifier";
    local: Identifier;
}
interface ImportSpecifier extends BaseNode {
    type: "ImportSpecifier";
    local: Identifier;
    imported: Identifier | StringLiteral;
    importKind?: "type" | "typeof" | "value" | null;
}
interface ImportExpression extends BaseNode {
    type: "ImportExpression";
    source: Expression;
    options?: Expression | null;
    phase?: "source" | "defer" | null;
}
interface MetaProperty extends BaseNode {
    type: "MetaProperty";
    meta: Identifier;
    property: Identifier;
}
interface ClassMethod extends BaseNode {
    type: "ClassMethod";
    kind: "get" | "set" | "method" | "constructor";
    key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression;
    params: Array<FunctionParameter | TSParameterProperty>;
    body: BlockStatement;
    computed: boolean;
    static: boolean;
    generator: boolean;
    async: boolean;
    abstract?: boolean | null;
    access?: "public" | "private" | "protected" | null;
    accessibility?: "public" | "private" | "protected" | null;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    override?: boolean;
    returnType?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface ObjectPattern extends BaseNode {
    type: "ObjectPattern";
    properties: Array<RestElement | ObjectProperty>;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
}
interface SpreadElement extends BaseNode {
    type: "SpreadElement";
    argument: Expression;
}
/**
 * @deprecated Use `SpreadElement`
 */
interface SpreadProperty$1 extends BaseNode {
    type: "SpreadProperty";
    argument: Expression;
}
interface Super extends BaseNode {
    type: "Super";
}
interface TaggedTemplateExpression extends BaseNode {
    type: "TaggedTemplateExpression";
    tag: Expression;
    quasi: TemplateLiteral;
    typeParameters?: TypeParameterInstantiation | TSTypeParameterInstantiation | null;
}
interface TemplateElement extends BaseNode {
    type: "TemplateElement";
    value: {
        raw: string;
        cooked?: string;
    };
    tail: boolean;
}
interface TemplateLiteral extends BaseNode {
    type: "TemplateLiteral";
    quasis: Array<TemplateElement>;
    expressions: Array<Expression | TSType>;
}
interface YieldExpression extends BaseNode {
    type: "YieldExpression";
    argument?: Expression | null;
    delegate: boolean;
}
interface AwaitExpression extends BaseNode {
    type: "AwaitExpression";
    argument: Expression;
}
interface Import extends BaseNode {
    type: "Import";
}
interface BigIntLiteral extends BaseNode {
    type: "BigIntLiteral";
    value: string;
}
interface ExportNamespaceSpecifier extends BaseNode {
    type: "ExportNamespaceSpecifier";
    exported: Identifier;
}
interface OptionalMemberExpression extends BaseNode {
    type: "OptionalMemberExpression";
    object: Expression;
    property: Expression | Identifier;
    computed: boolean;
    optional: boolean;
}
interface OptionalCallExpression extends BaseNode {
    type: "OptionalCallExpression";
    callee: Expression;
    arguments: Array<Expression | SpreadElement | ArgumentPlaceholder>;
    optional: boolean;
    typeArguments?: TypeParameterInstantiation | null;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface ClassProperty extends BaseNode {
    type: "ClassProperty";
    key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression;
    value?: Expression | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    decorators?: Array<Decorator> | null;
    computed: boolean;
    static: boolean;
    abstract?: boolean | null;
    accessibility?: "public" | "private" | "protected" | null;
    declare?: boolean | null;
    definite?: boolean | null;
    optional?: boolean | null;
    override?: boolean;
    readonly?: boolean | null;
    variance?: Variance | null;
}
interface ClassAccessorProperty extends BaseNode {
    type: "ClassAccessorProperty";
    key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression | PrivateName;
    value?: Expression | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    decorators?: Array<Decorator> | null;
    computed: boolean;
    static: boolean;
    abstract?: boolean | null;
    accessibility?: "public" | "private" | "protected" | null;
    declare?: boolean | null;
    definite?: boolean | null;
    optional?: boolean | null;
    override?: boolean;
    readonly?: boolean | null;
    variance?: Variance | null;
}
interface ClassPrivateProperty extends BaseNode {
    type: "ClassPrivateProperty";
    key: PrivateName;
    value?: Expression | null;
    decorators?: Array<Decorator> | null;
    static: boolean;
    definite?: boolean | null;
    optional?: boolean | null;
    readonly?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    variance?: Variance | null;
}
interface ClassPrivateMethod extends BaseNode {
    type: "ClassPrivateMethod";
    kind: "get" | "set" | "method";
    key: PrivateName;
    params: Array<FunctionParameter | TSParameterProperty>;
    body: BlockStatement;
    static: boolean;
    abstract?: boolean | null;
    access?: "public" | "private" | "protected" | null;
    accessibility?: "public" | "private" | "protected" | null;
    async?: boolean;
    computed?: boolean;
    decorators?: Array<Decorator> | null;
    generator?: boolean;
    optional?: boolean | null;
    override?: boolean;
    returnType?: TypeAnnotation | TSTypeAnnotation | Noop | null;
    typeParameters?: TypeParameterDeclaration | TSTypeParameterDeclaration | Noop | null;
}
interface PrivateName extends BaseNode {
    type: "PrivateName";
    id: Identifier;
}
interface StaticBlock extends BaseNode {
    type: "StaticBlock";
    body: Array<Statement>;
}
interface ImportAttribute extends BaseNode {
    type: "ImportAttribute";
    key: Identifier | StringLiteral;
    value: StringLiteral;
}
interface AnyTypeAnnotation extends BaseNode {
    type: "AnyTypeAnnotation";
}
interface ArrayTypeAnnotation extends BaseNode {
    type: "ArrayTypeAnnotation";
    elementType: FlowType;
}
interface BooleanTypeAnnotation extends BaseNode {
    type: "BooleanTypeAnnotation";
}
interface BooleanLiteralTypeAnnotation extends BaseNode {
    type: "BooleanLiteralTypeAnnotation";
    value: boolean;
}
interface NullLiteralTypeAnnotation extends BaseNode {
    type: "NullLiteralTypeAnnotation";
}
interface ClassImplements extends BaseNode {
    type: "ClassImplements";
    id: Identifier;
    typeParameters?: TypeParameterInstantiation | null;
}
interface DeclareClass extends BaseNode {
    type: "DeclareClass";
    id: Identifier;
    typeParameters?: TypeParameterDeclaration | null;
    extends?: Array<InterfaceExtends> | null;
    body: ObjectTypeAnnotation;
    implements?: Array<ClassImplements> | null;
    mixins?: Array<InterfaceExtends> | null;
}
interface DeclareFunction extends BaseNode {
    type: "DeclareFunction";
    id: Identifier;
    predicate?: DeclaredPredicate | null;
}
interface DeclareInterface extends BaseNode {
    type: "DeclareInterface";
    id: Identifier;
    typeParameters?: TypeParameterDeclaration | null;
    extends?: Array<InterfaceExtends> | null;
    body: ObjectTypeAnnotation;
}
interface DeclareModule extends BaseNode {
    type: "DeclareModule";
    id: Identifier | StringLiteral;
    body: BlockStatement;
    kind?: "CommonJS" | "ES" | null;
}
interface DeclareModuleExports extends BaseNode {
    type: "DeclareModuleExports";
    typeAnnotation: TypeAnnotation;
}
interface DeclareTypeAlias extends BaseNode {
    type: "DeclareTypeAlias";
    id: Identifier;
    typeParameters?: TypeParameterDeclaration | null;
    right: FlowType;
}
interface DeclareOpaqueType extends BaseNode {
    type: "DeclareOpaqueType";
    id: Identifier;
    typeParameters?: TypeParameterDeclaration | null;
    supertype?: FlowType | null;
    impltype?: FlowType | null;
}
interface DeclareVariable extends BaseNode {
    type: "DeclareVariable";
    id: Identifier;
}
interface DeclareExportDeclaration extends BaseNode {
    type: "DeclareExportDeclaration";
    declaration?: Flow | null;
    specifiers?: Array<ExportSpecifier | ExportNamespaceSpecifier> | null;
    source?: StringLiteral | null;
    attributes?: Array<ImportAttribute> | null;
    /** @deprecated */
    assertions?: Array<ImportAttribute> | null;
    default?: boolean | null;
}
interface DeclareExportAllDeclaration extends BaseNode {
    type: "DeclareExportAllDeclaration";
    source: StringLiteral;
    attributes?: Array<ImportAttribute> | null;
    /** @deprecated */
    assertions?: Array<ImportAttribute> | null;
    exportKind?: "type" | "value" | null;
}
interface DeclaredPredicate extends BaseNode {
    type: "DeclaredPredicate";
    value: Flow;
}
interface ExistsTypeAnnotation extends BaseNode {
    type: "ExistsTypeAnnotation";
}
interface FunctionTypeAnnotation extends BaseNode {
    type: "FunctionTypeAnnotation";
    typeParameters?: TypeParameterDeclaration | null;
    params: Array<FunctionTypeParam>;
    rest?: FunctionTypeParam | null;
    returnType: FlowType;
    this?: FunctionTypeParam | null;
}
interface FunctionTypeParam extends BaseNode {
    type: "FunctionTypeParam";
    name?: Identifier | null;
    typeAnnotation: FlowType;
    optional?: boolean | null;
}
interface GenericTypeAnnotation extends BaseNode {
    type: "GenericTypeAnnotation";
    id: Identifier | QualifiedTypeIdentifier;
    typeParameters?: TypeParameterInstantiation | null;
}
interface InferredPredicate extends BaseNode {
    type: "InferredPredicate";
}
interface InterfaceExtends extends BaseNode {
    type: "InterfaceExtends";
    id: Identifier | QualifiedTypeIdentifier;
    typeParameters?: TypeParameterInstantiation | null;
}
interface InterfaceDeclaration extends BaseNode {
    type: "InterfaceDeclaration";
    id: Identifier;
    typeParameters?: TypeParameterDeclaration | null;
    extends?: Array<InterfaceExtends> | null;
    body: ObjectTypeAnnotation;
}
interface InterfaceTypeAnnotation extends BaseNode {
    type: "InterfaceTypeAnnotation";
    extends?: Array<InterfaceExtends> | null;
    body: ObjectTypeAnnotation;
}
interface IntersectionTypeAnnotation extends BaseNode {
    type: "IntersectionTypeAnnotation";
    types: Array<FlowType>;
}
interface MixedTypeAnnotation extends BaseNode {
    type: "MixedTypeAnnotation";
}
interface EmptyTypeAnnotation extends BaseNode {
    type: "EmptyTypeAnnotation";
}
interface NullableTypeAnnotation extends BaseNode {
    type: "NullableTypeAnnotation";
    typeAnnotation: FlowType;
}
interface NumberLiteralTypeAnnotation extends BaseNode {
    type: "NumberLiteralTypeAnnotation";
    value: number;
}
interface NumberTypeAnnotation extends BaseNode {
    type: "NumberTypeAnnotation";
}
interface ObjectTypeAnnotation extends BaseNode {
    type: "ObjectTypeAnnotation";
    properties: Array<ObjectTypeProperty | ObjectTypeSpreadProperty>;
    indexers?: Array<ObjectTypeIndexer>;
    callProperties?: Array<ObjectTypeCallProperty>;
    internalSlots?: Array<ObjectTypeInternalSlot>;
    exact: boolean;
    inexact?: boolean | null;
}
interface ObjectTypeInternalSlot extends BaseNode {
    type: "ObjectTypeInternalSlot";
    id: Identifier;
    value: FlowType;
    optional: boolean;
    static: boolean;
    method: boolean;
}
interface ObjectTypeCallProperty extends BaseNode {
    type: "ObjectTypeCallProperty";
    value: FlowType;
    static: boolean;
}
interface ObjectTypeIndexer extends BaseNode {
    type: "ObjectTypeIndexer";
    id?: Identifier | null;
    key: FlowType;
    value: FlowType;
    variance?: Variance | null;
    static: boolean;
}
interface ObjectTypeProperty extends BaseNode {
    type: "ObjectTypeProperty";
    key: Identifier | StringLiteral;
    value: FlowType;
    variance?: Variance | null;
    kind: "init" | "get" | "set";
    method: boolean;
    optional: boolean;
    proto: boolean;
    static: boolean;
}
interface ObjectTypeSpreadProperty extends BaseNode {
    type: "ObjectTypeSpreadProperty";
    argument: FlowType;
}
interface OpaqueType extends BaseNode {
    type: "OpaqueType";
    id: Identifier;
    typeParameters?: TypeParameterDeclaration | null;
    supertype?: FlowType | null;
    impltype: FlowType;
}
interface QualifiedTypeIdentifier extends BaseNode {
    type: "QualifiedTypeIdentifier";
    id: Identifier;
    qualification: Identifier | QualifiedTypeIdentifier;
}
interface StringLiteralTypeAnnotation extends BaseNode {
    type: "StringLiteralTypeAnnotation";
    value: string;
}
interface StringTypeAnnotation extends BaseNode {
    type: "StringTypeAnnotation";
}
interface SymbolTypeAnnotation extends BaseNode {
    type: "SymbolTypeAnnotation";
}
interface ThisTypeAnnotation extends BaseNode {
    type: "ThisTypeAnnotation";
}
interface TupleTypeAnnotation extends BaseNode {
    type: "TupleTypeAnnotation";
    types: Array<FlowType>;
}
interface TypeofTypeAnnotation extends BaseNode {
    type: "TypeofTypeAnnotation";
    argument: FlowType;
}
interface TypeAlias extends BaseNode {
    type: "TypeAlias";
    id: Identifier;
    typeParameters?: TypeParameterDeclaration | null;
    right: FlowType;
}
interface TypeAnnotation extends BaseNode {
    type: "TypeAnnotation";
    typeAnnotation: FlowType;
}
interface TypeCastExpression extends BaseNode {
    type: "TypeCastExpression";
    expression: Expression;
    typeAnnotation: TypeAnnotation;
}
interface TypeParameter extends BaseNode {
    type: "TypeParameter";
    bound?: TypeAnnotation | null;
    default?: FlowType | null;
    variance?: Variance | null;
    name: string;
}
interface TypeParameterDeclaration extends BaseNode {
    type: "TypeParameterDeclaration";
    params: Array<TypeParameter>;
}
interface TypeParameterInstantiation extends BaseNode {
    type: "TypeParameterInstantiation";
    params: Array<FlowType>;
}
interface UnionTypeAnnotation extends BaseNode {
    type: "UnionTypeAnnotation";
    types: Array<FlowType>;
}
interface Variance extends BaseNode {
    type: "Variance";
    kind: "minus" | "plus";
}
interface VoidTypeAnnotation extends BaseNode {
    type: "VoidTypeAnnotation";
}
interface EnumDeclaration extends BaseNode {
    type: "EnumDeclaration";
    id: Identifier;
    body: EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody;
}
interface EnumBooleanBody extends BaseNode {
    type: "EnumBooleanBody";
    members: Array<EnumBooleanMember>;
    explicitType: boolean;
    hasUnknownMembers: boolean;
}
interface EnumNumberBody extends BaseNode {
    type: "EnumNumberBody";
    members: Array<EnumNumberMember>;
    explicitType: boolean;
    hasUnknownMembers: boolean;
}
interface EnumStringBody extends BaseNode {
    type: "EnumStringBody";
    members: Array<EnumStringMember | EnumDefaultedMember>;
    explicitType: boolean;
    hasUnknownMembers: boolean;
}
interface EnumSymbolBody extends BaseNode {
    type: "EnumSymbolBody";
    members: Array<EnumDefaultedMember>;
    hasUnknownMembers: boolean;
}
interface EnumBooleanMember extends BaseNode {
    type: "EnumBooleanMember";
    id: Identifier;
    init: BooleanLiteral;
}
interface EnumNumberMember extends BaseNode {
    type: "EnumNumberMember";
    id: Identifier;
    init: NumericLiteral;
}
interface EnumStringMember extends BaseNode {
    type: "EnumStringMember";
    id: Identifier;
    init: StringLiteral;
}
interface EnumDefaultedMember extends BaseNode {
    type: "EnumDefaultedMember";
    id: Identifier;
}
interface IndexedAccessType extends BaseNode {
    type: "IndexedAccessType";
    objectType: FlowType;
    indexType: FlowType;
}
interface OptionalIndexedAccessType extends BaseNode {
    type: "OptionalIndexedAccessType";
    objectType: FlowType;
    indexType: FlowType;
    optional: boolean;
}
interface JSXAttribute extends BaseNode {
    type: "JSXAttribute";
    name: JSXIdentifier | JSXNamespacedName;
    value?: JSXElement | JSXFragment | StringLiteral | JSXExpressionContainer | null;
}
interface JSXClosingElement extends BaseNode {
    type: "JSXClosingElement";
    name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName;
}
interface JSXElement extends BaseNode {
    type: "JSXElement";
    openingElement: JSXOpeningElement;
    closingElement?: JSXClosingElement | null;
    children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>;
    selfClosing?: boolean | null;
}
interface JSXEmptyExpression extends BaseNode {
    type: "JSXEmptyExpression";
}
interface JSXExpressionContainer extends BaseNode {
    type: "JSXExpressionContainer";
    expression: Expression | JSXEmptyExpression;
}
interface JSXSpreadChild extends BaseNode {
    type: "JSXSpreadChild";
    expression: Expression;
}
interface JSXIdentifier extends BaseNode {
    type: "JSXIdentifier";
    name: string;
}
interface JSXMemberExpression extends BaseNode {
    type: "JSXMemberExpression";
    object: JSXMemberExpression | JSXIdentifier;
    property: JSXIdentifier;
}
interface JSXNamespacedName extends BaseNode {
    type: "JSXNamespacedName";
    namespace: JSXIdentifier;
    name: JSXIdentifier;
}
interface JSXOpeningElement extends BaseNode {
    type: "JSXOpeningElement";
    name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName;
    attributes: Array<JSXAttribute | JSXSpreadAttribute>;
    selfClosing: boolean;
    typeArguments?: TypeParameterInstantiation | null;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface JSXSpreadAttribute extends BaseNode {
    type: "JSXSpreadAttribute";
    argument: Expression;
}
interface JSXText extends BaseNode {
    type: "JSXText";
    value: string;
}
interface JSXFragment extends BaseNode {
    type: "JSXFragment";
    openingFragment: JSXOpeningFragment;
    closingFragment: JSXClosingFragment;
    children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>;
}
interface JSXOpeningFragment extends BaseNode {
    type: "JSXOpeningFragment";
}
interface JSXClosingFragment extends BaseNode {
    type: "JSXClosingFragment";
}
interface Noop extends BaseNode {
    type: "Noop";
}
interface Placeholder extends BaseNode {
    type: "Placeholder";
    expectedNode: "Identifier" | "StringLiteral" | "Expression" | "Statement" | "Declaration" | "BlockStatement" | "ClassBody" | "Pattern";
    name: Identifier;
    decorators?: Array<Decorator> | null;
    optional?: boolean | null;
    typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null;
}
interface V8IntrinsicIdentifier extends BaseNode {
    type: "V8IntrinsicIdentifier";
    name: string;
}
interface ArgumentPlaceholder extends BaseNode {
    type: "ArgumentPlaceholder";
}
interface BindExpression extends BaseNode {
    type: "BindExpression";
    object: Expression;
    callee: Expression;
}
interface Decorator extends BaseNode {
    type: "Decorator";
    expression: Expression;
}
interface DoExpression extends BaseNode {
    type: "DoExpression";
    body: BlockStatement;
    async: boolean;
}
interface ExportDefaultSpecifier extends BaseNode {
    type: "ExportDefaultSpecifier";
    exported: Identifier;
}
interface RecordExpression extends BaseNode {
    type: "RecordExpression";
    properties: Array<ObjectProperty | SpreadElement>;
}
interface TupleExpression extends BaseNode {
    type: "TupleExpression";
    elements: Array<Expression | SpreadElement>;
}
interface DecimalLiteral extends BaseNode {
    type: "DecimalLiteral";
    value: string;
}
interface ModuleExpression extends BaseNode {
    type: "ModuleExpression";
    body: Program;
}
interface TopicReference extends BaseNode {
    type: "TopicReference";
}
interface PipelineTopicExpression extends BaseNode {
    type: "PipelineTopicExpression";
    expression: Expression;
}
interface PipelineBareFunction extends BaseNode {
    type: "PipelineBareFunction";
    callee: Expression;
}
interface PipelinePrimaryTopicReference extends BaseNode {
    type: "PipelinePrimaryTopicReference";
}
interface VoidPattern extends BaseNode {
    type: "VoidPattern";
}
interface TSParameterProperty extends BaseNode {
    type: "TSParameterProperty";
    parameter: Identifier | AssignmentPattern;
    accessibility?: "public" | "private" | "protected" | null;
    decorators?: Array<Decorator> | null;
    override?: boolean | null;
    readonly?: boolean | null;
}
interface TSDeclareFunction extends BaseNode {
    type: "TSDeclareFunction";
    id?: Identifier | null;
    typeParameters?: TSTypeParameterDeclaration | Noop | null;
    params: Array<FunctionParameter>;
    returnType?: TSTypeAnnotation | Noop | null;
    async?: boolean;
    declare?: boolean | null;
    generator?: boolean;
}
interface TSDeclareMethod extends BaseNode {
    type: "TSDeclareMethod";
    decorators?: Array<Decorator> | null;
    key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression;
    typeParameters?: TSTypeParameterDeclaration | Noop | null;
    params: Array<FunctionParameter | TSParameterProperty>;
    returnType?: TSTypeAnnotation | Noop | null;
    abstract?: boolean | null;
    access?: "public" | "private" | "protected" | null;
    accessibility?: "public" | "private" | "protected" | null;
    async?: boolean;
    computed?: boolean;
    generator?: boolean;
    kind?: "get" | "set" | "method" | "constructor";
    optional?: boolean | null;
    override?: boolean;
    static?: boolean;
}
interface TSQualifiedName extends BaseNode {
    type: "TSQualifiedName";
    left: TSEntityName;
    right: Identifier;
}
interface TSCallSignatureDeclaration extends BaseNode {
    type: "TSCallSignatureDeclaration";
    typeParameters?: TSTypeParameterDeclaration | null;
    parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
    typeAnnotation?: TSTypeAnnotation | null;
}
interface TSConstructSignatureDeclaration extends BaseNode {
    type: "TSConstructSignatureDeclaration";
    typeParameters?: TSTypeParameterDeclaration | null;
    parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
    typeAnnotation?: TSTypeAnnotation | null;
}
interface TSPropertySignature extends BaseNode {
    type: "TSPropertySignature";
    key: Expression;
    typeAnnotation?: TSTypeAnnotation | null;
    computed?: boolean;
    kind?: "get" | "set" | null;
    optional?: boolean | null;
    readonly?: boolean | null;
}
interface TSMethodSignature extends BaseNode {
    type: "TSMethodSignature";
    key: Expression;
    typeParameters?: TSTypeParameterDeclaration | null;
    parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
    typeAnnotation?: TSTypeAnnotation | null;
    computed?: boolean;
    kind: "method" | "get" | "set";
    optional?: boolean | null;
}
interface TSIndexSignature extends BaseNode {
    type: "TSIndexSignature";
    parameters: Array<Identifier>;
    typeAnnotation?: TSTypeAnnotation | null;
    readonly?: boolean | null;
    static?: boolean | null;
}
interface TSAnyKeyword extends BaseNode {
    type: "TSAnyKeyword";
}
interface TSBooleanKeyword extends BaseNode {
    type: "TSBooleanKeyword";
}
interface TSBigIntKeyword extends BaseNode {
    type: "TSBigIntKeyword";
}
interface TSIntrinsicKeyword extends BaseNode {
    type: "TSIntrinsicKeyword";
}
interface TSNeverKeyword extends BaseNode {
    type: "TSNeverKeyword";
}
interface TSNullKeyword extends BaseNode {
    type: "TSNullKeyword";
}
interface TSNumberKeyword extends BaseNode {
    type: "TSNumberKeyword";
}
interface TSObjectKeyword extends BaseNode {
    type: "TSObjectKeyword";
}
interface TSStringKeyword extends BaseNode {
    type: "TSStringKeyword";
}
interface TSSymbolKeyword extends BaseNode {
    type: "TSSymbolKeyword";
}
interface TSUndefinedKeyword extends BaseNode {
    type: "TSUndefinedKeyword";
}
interface TSUnknownKeyword extends BaseNode {
    type: "TSUnknownKeyword";
}
interface TSVoidKeyword extends BaseNode {
    type: "TSVoidKeyword";
}
interface TSThisType extends BaseNode {
    type: "TSThisType";
}
interface TSFunctionType extends BaseNode {
    type: "TSFunctionType";
    typeParameters?: TSTypeParameterDeclaration | null;
    parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
    typeAnnotation?: TSTypeAnnotation | null;
}
interface TSConstructorType extends BaseNode {
    type: "TSConstructorType";
    typeParameters?: TSTypeParameterDeclaration | null;
    parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>;
    typeAnnotation?: TSTypeAnnotation | null;
    abstract?: boolean | null;
}
interface TSTypeReference extends BaseNode {
    type: "TSTypeReference";
    typeName: TSEntityName;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface TSTypePredicate extends BaseNode {
    type: "TSTypePredicate";
    parameterName: Identifier | TSThisType;
    typeAnnotation?: TSTypeAnnotation | null;
    asserts?: boolean | null;
}
interface TSTypeQuery extends BaseNode {
    type: "TSTypeQuery";
    exprName: TSEntityName | TSImportType;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface TSTypeLiteral extends BaseNode {
    type: "TSTypeLiteral";
    members: Array<TSTypeElement>;
}
interface TSArrayType extends BaseNode {
    type: "TSArrayType";
    elementType: TSType;
}
interface TSTupleType extends BaseNode {
    type: "TSTupleType";
    elementTypes: Array<TSType | TSNamedTupleMember>;
}
interface TSOptionalType extends BaseNode {
    type: "TSOptionalType";
    typeAnnotation: TSType;
}
interface TSRestType extends BaseNode {
    type: "TSRestType";
    typeAnnotation: TSType;
}
interface TSNamedTupleMember extends BaseNode {
    type: "TSNamedTupleMember";
    label: Identifier;
    elementType: TSType;
    optional: boolean;
}
interface TSUnionType extends BaseNode {
    type: "TSUnionType";
    types: Array<TSType>;
}
interface TSIntersectionType extends BaseNode {
    type: "TSIntersectionType";
    types: Array<TSType>;
}
interface TSConditionalType extends BaseNode {
    type: "TSConditionalType";
    checkType: TSType;
    extendsType: TSType;
    trueType: TSType;
    falseType: TSType;
}
interface TSInferType extends BaseNode {
    type: "TSInferType";
    typeParameter: TSTypeParameter;
}
interface TSParenthesizedType extends BaseNode {
    type: "TSParenthesizedType";
    typeAnnotation: TSType;
}
interface TSTypeOperator extends BaseNode {
    type: "TSTypeOperator";
    typeAnnotation: TSType;
    operator: string;
}
interface TSIndexedAccessType extends BaseNode {
    type: "TSIndexedAccessType";
    objectType: TSType;
    indexType: TSType;
}
interface TSMappedType extends BaseNode {
    type: "TSMappedType";
    typeParameter: TSTypeParameter;
    typeAnnotation?: TSType | null;
    nameType?: TSType | null;
    optional?: true | false | "+" | "-" | null;
    readonly?: true | false | "+" | "-" | null;
}
interface TSTemplateLiteralType extends BaseNode {
    type: "TSTemplateLiteralType";
    quasis: Array<TemplateElement>;
    types: Array<TSType>;
}
interface TSLiteralType extends BaseNode {
    type: "TSLiteralType";
    literal: NumericLiteral | StringLiteral | BooleanLiteral | BigIntLiteral | TemplateLiteral | UnaryExpression;
}
interface TSExpressionWithTypeArguments extends BaseNode {
    type: "TSExpressionWithTypeArguments";
    expression: TSEntityName;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface TSInterfaceDeclaration extends BaseNode {
    type: "TSInterfaceDeclaration";
    id: Identifier;
    typeParameters?: TSTypeParameterDeclaration | null;
    extends?: Array<TSExpressionWithTypeArguments> | null;
    body: TSInterfaceBody;
    declare?: boolean | null;
}
interface TSInterfaceBody extends BaseNode {
    type: "TSInterfaceBody";
    body: Array<TSTypeElement>;
}
interface TSTypeAliasDeclaration extends BaseNode {
    type: "TSTypeAliasDeclaration";
    id: Identifier;
    typeParameters?: TSTypeParameterDeclaration | null;
    typeAnnotation: TSType;
    declare?: boolean | null;
}
interface TSInstantiationExpression extends BaseNode {
    type: "TSInstantiationExpression";
    expression: Expression;
    typeParameters?: TSTypeParameterInstantiation | null;
}
interface TSAsExpression extends BaseNode {
    type: "TSAsExpression";
    expression: Expression;
    typeAnnotation: TSType;
}
interface TSSatisfiesExpression extends BaseNode {
    type: "TSSatisfiesExpression";
    expression: Expression;
    typeAnnotation: TSType;
}
interface TSTypeAssertion extends BaseNode {
    type: "TSTypeAssertion";
    typeAnnotation: TSType;
    expression: Expression;
}
interface TSEnumBody extends BaseNode {
    type: "TSEnumBody";
    members: Array<TSEnumMember>;
}
interface TSEnumDeclaration extends BaseNode {
    type: "TSEnumDeclaration";
    id: Identifier;
    members: Array<TSEnumMember>;
    body?: TSEnumBody | null;
    const?: boolean | null;
    declare?: boolean | null;
    initializer?: Expression | null;
}
interface TSEnumMember extends BaseNode {
    type: "TSEnumMember";
    id: Identifier | StringLiteral;
    initializer?: Expression | null;
}
interface TSModuleDeclaration extends BaseNode {
    type: "TSModuleDeclaration";
    id: Identifier | StringLiteral;
    body: TSModuleBlock | TSModuleDeclaration;
    declare?: boolean | null;
    global?: boolean | null;
    kind: "global" | "module" | "namespace";
}
interface TSModuleBlock extends BaseNode {
    type: "TSModuleBlock";
    body: Array<Statement>;
}
interface TSImportType extends BaseNode {
    type: "TSImportType";
    argument: StringLiteral;
    qualifier?: TSEntityName | null;
    typeParameters?: TSTypeParameterInstantiation | null;
    options?: ObjectExpression | null;
}
interface TSImportEqualsDeclaration extends BaseNode {
    type: "TSImportEqualsDeclaration";
    id: Identifier;
    moduleReference: TSEntityName | TSExternalModuleReference;
    importKind?: "type" | "value" | null;
    isExport: boolean;
}
interface TSExternalModuleReference extends BaseNode {
    type: "TSExternalModuleReference";
    expression: StringLiteral;
}
interface TSNonNullExpression extends BaseNode {
    type: "TSNonNullExpression";
    expression: Expression;
}
interface TSExportAssignment extends BaseNode {
    type: "TSExportAssignment";
    expression: Expression;
}
interface TSNamespaceExportDeclaration extends BaseNode {
    type: "TSNamespaceExportDeclaration";
    id: Identifier;
}
interface TSTypeAnnotation extends BaseNode {
    type: "TSTypeAnnotation";
    typeAnnotation: TSType;
}
interface TSTypeParameterInstantiation extends BaseNode {
    type: "TSTypeParameterInstantiation";
    params: Array<TSType>;
}
interface TSTypeParameterDeclaration extends BaseNode {
    type: "TSTypeParameterDeclaration";
    params: Array<TSTypeParameter>;
}
interface TSTypeParameter extends BaseNode {
    type: "TSTypeParameter";
    constraint?: TSType | null;
    default?: TSType | null;
    name: string;
    const?: boolean | null;
    in?: boolean | null;
    out?: boolean | null;
}
type Standardized = ArrayExpression | AssignmentExpression | BinaryExpression | InterpreterDirective | Directive | DirectiveLiteral | BlockStatement | BreakStatement | CallExpression | CatchClause | ConditionalExpression | ContinueStatement | DebuggerStatement | DoWhileStatement | EmptyStatement | ExpressionStatement | File | ForInStatement | ForStatement | FunctionDeclaration | FunctionExpression | Identifier | IfStatement | LabeledStatement | StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | LogicalExpression | MemberExpression | NewExpression | Program | ObjectExpression | ObjectMethod | ObjectProperty | RestElement | ReturnStatement | SequenceExpression | ParenthesizedExpression | SwitchCase | SwitchStatement | ThisExpression | ThrowStatement | TryStatement | UnaryExpression | UpdateExpression | VariableDeclaration | VariableDeclarator | WhileStatement | WithStatement | AssignmentPattern | ArrayPattern | ArrowFunctionExpression | ClassBody | ClassExpression | ClassDeclaration | ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ExportSpecifier | ForOfStatement | ImportDeclaration | ImportDefaultSpecifier | ImportNamespaceSpecifier | ImportSpecifier | ImportExpression | MetaProperty | ClassMethod | ObjectPattern | SpreadElement | Super | TaggedTemplateExpression | TemplateElement | TemplateLiteral | YieldExpression | AwaitExpression | Import | BigIntLiteral | ExportNamespaceSpecifier | OptionalMemberExpression | OptionalCallExpression | ClassProperty | ClassAccessorProperty | ClassPrivateProperty | ClassPrivateMethod | PrivateName | StaticBlock | ImportAttribute;
type Expression = ArrayExpression | AssignmentExpression | BinaryExpression | CallExpression | ConditionalExpression | FunctionExpression | Identifier | StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | LogicalExpression | MemberExpression | NewExpression | ObjectExpression | SequenceExpression | ParenthesizedExpression | ThisExpression | UnaryExpression | UpdateExpression | ArrowFunctionExpression | ClassExpression | ImportExpression | MetaProperty | Super | TaggedTemplateExpression | TemplateLiteral | YieldExpression | AwaitExpression | Import | BigIntLiteral | OptionalMemberExpression | OptionalCallExpression | TypeCastExpression | JSXElement | JSXFragment | BindExpression | DoExpression | RecordExpression | TupleExpression | DecimalLiteral | ModuleExpression | TopicReference | PipelineTopicExpression | PipelineBareFunction | PipelinePrimaryTopicReference | TSInstantiationExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
type Binary = BinaryExpression | LogicalExpression;
type Scopable = BlockStatement | CatchClause | DoWhileStatement | ForInStatement | ForStatement | FunctionDeclaration | FunctionExpression | Program | ObjectMethod | SwitchStatement | WhileStatement | ArrowFunctionExpression | ClassExpression | ClassDeclaration | ForOfStatement | ClassMethod | ClassPrivateMethod | StaticBlock | TSModuleBlock;
type BlockParent = BlockStatement | CatchClause | DoWhileStatement | ForInStatement | ForStatement | FunctionDeclaration | FunctionExpression | Program | ObjectMethod | SwitchStatement | WhileStatement | ArrowFunctionExpression | ForOfStatement | ClassMethod | ClassPrivateMethod | StaticBlock | TSModuleBlock;
type Block = BlockStatement | Program | TSModuleBlock;
type Statement = BlockStatement | BreakStatement | ContinueStatement | DebuggerStatement | DoWhileStatement | EmptyStatement | ExpressionStatement | ForInStatement | ForStatement | FunctionDeclaration | IfStatement | LabeledStatement | ReturnStatement | SwitchStatement | ThrowStatement | TryStatement | VariableDeclaration | WhileStatement | WithStatement | ClassDeclaration | ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ForOfStatement | ImportDeclaration | DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | InterfaceDeclaration | OpaqueType | TypeAlias | EnumDeclaration | TSDeclareFunction | TSInterfaceDeclaration | TSTypeAliasDeclaration | TSEnumDeclaration | TSModuleDeclaration | TSImportEqualsDeclaration | TSExportAssignment | TSNamespaceExportDeclaration;
type Terminatorless = BreakStatement | ContinueStatement | ReturnStatement | ThrowStatement | YieldExpression | AwaitExpression;
type CompletionStatement = BreakStatement | ContinueStatement | ReturnStatement | ThrowStatement;
type Conditional = ConditionalExpression | IfStatement;
type Loop = DoWhileStatement | ForInStatement | ForStatement | WhileStatement | ForOfStatement;
type While = DoWhileStatement | WhileStatement;
type ExpressionWrapper = ExpressionStatement | ParenthesizedExpression | TypeCastExpression;
type For = ForInStatement | ForStatement | ForOfStatement;
type ForXStatement = ForInStatement | ForOfStatement;
type Function = FunctionDeclaration | FunctionExpression | ObjectMethod | ArrowFunctionExpression | ClassMethod | ClassPrivateMethod;
type FunctionParent = FunctionDeclaration | FunctionExpression | ObjectMethod | ArrowFunctionExpression | ClassMethod | ClassPrivateMethod | StaticBlock | TSModuleBlock;
type Pureish = FunctionDeclaration | FunctionExpression | StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | ArrowFunctionExpression | BigIntLiteral | DecimalLiteral;
type Declaration = FunctionDeclaration | VariableDeclaration | ClassDeclaration | ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ImportDeclaration | DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | InterfaceDeclaration | OpaqueType | TypeAlias | EnumDeclaration | TSDeclareFunction | TSInterfaceDeclaration | TSTypeAliasDeclaration | TSEnumDeclaration | TSModuleDeclaration | TSImportEqualsDeclaration;
type FunctionParameter = Identifier | RestElement | AssignmentPattern | ArrayPattern | ObjectPattern | VoidPattern;
type PatternLike = Identifier | MemberExpression | RestElement | AssignmentPattern | ArrayPattern | ObjectPattern | VoidPattern | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
type LVal = Identifier | MemberExpression | RestElement | AssignmentPattern | ArrayPattern | ObjectPattern | TSParameterProperty | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression;
type TSEntityName = Identifier | TSQualifiedName;
type Literal = StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | TemplateLiteral | BigIntLiteral | DecimalLiteral;
type Immutable = StringLiteral | NumericLiteral | NullLiteral | BooleanLiteral | BigIntLiteral | JSXAttribute | JSXClosingElement | JSXElement | JSXExpressionContainer | JSXSpreadChild | JSXOpeningElement | JSXText | JSXFragment | JSXOpeningFragment | JSXClosingFragment | DecimalLiteral;
type UserWhitespacable = ObjectMethod | ObjectProperty | ObjectTypeInternalSlot | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeProperty | ObjectTypeSpreadProperty;
type Method = ObjectMethod | ClassMethod | ClassPrivateMethod;
type ObjectMember = ObjectMethod | ObjectProperty;
type Property = ObjectProperty | ClassProperty | ClassAccessorProperty | ClassPrivateProperty;
type UnaryLike = UnaryExpression | SpreadElement;
type Pattern = AssignmentPattern | ArrayPattern | ObjectPattern | VoidPattern;
type Class = ClassExpression | ClassDeclaration;
type ImportOrExportDeclaration = ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ImportDeclaration;
type ExportDeclaration = ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration;
type ModuleSpecifier = ExportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier | ImportSpecifier | ExportNamespaceSpecifier | ExportDefaultSpecifier;
type Accessor = ClassAccessorProperty;
type Private = ClassPrivateProperty | ClassPrivateMethod | PrivateName;
type Flow = AnyTypeAnnotation | ArrayTypeAnnotation | BooleanTypeAnnotation | BooleanLiteralTypeAnnotation | NullLiteralTypeAnnotation | ClassImplements | DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | DeclaredPredicate | ExistsTypeAnnotation | FunctionTypeAnnotation | FunctionTypeParam | GenericTypeAnnotation | InferredPredicate | InterfaceExtends | InterfaceDeclaration | InterfaceTypeAnnotation | IntersectionTypeAnnotation | MixedTypeAnnotation | EmptyTypeAnnotation | NullableTypeAnnotation | NumberLiteralTypeAnnotation | NumberTypeAnnotation | ObjectTypeAnnotation | ObjectTypeInternalSlot | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | QualifiedTypeIdentifier | StringLiteralTypeAnnotation | StringTypeAnnotation | SymbolTypeAnnotation | ThisTypeAnnotation | TupleTypeAnnotation | TypeofTypeAnnotation | TypeAlias | TypeAnnotation | TypeCastExpression | TypeParameter | TypeParameterDeclaration | TypeParameterInstantiation | UnionTypeAnnotation | Variance | VoidTypeAnnotation | EnumDeclaration | EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody | EnumBooleanMember | EnumNumberMember | EnumStringMember | EnumDefaultedMember | IndexedAccessType | OptionalIndexedAccessType;
type FlowType = AnyTypeAnnotation | ArrayTypeAnnotation | BooleanTypeAnnotation | BooleanLiteralTypeAnnotation | NullLiteralTypeAnnotation | ExistsTypeAnnotation | FunctionTypeAnnotation | GenericTypeAnnotation | InterfaceTypeAnnotation | IntersectionTypeAnnotation | MixedTypeAnnotation | EmptyTypeAnnotation | NullableTypeAnnotation | NumberLiteralTypeAnnotation | NumberTypeAnnotation | ObjectTypeAnnotation | StringLiteralTypeAnnotation | StringTypeAnnotation | SymbolTypeAnnotation | ThisTypeAnnotation | TupleTypeAnnotation | TypeofTypeAnnotation | UnionTypeAnnotation | VoidTypeAnnotation | IndexedAccessType | OptionalIndexedAccessType;
type FlowBaseAnnotation = AnyTypeAnnotation | BooleanTypeAnnotation | NullLiteralTypeAnnotation | MixedTypeAnnotation | EmptyTypeAnnotation | NumberTypeAnnotation | StringTypeAnnotation | SymbolTypeAnnotation | ThisTypeAnnotation | VoidTypeAnnotation;
type FlowDeclaration = DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareModuleExports | DeclareTypeAlias | DeclareOpaqueType | DeclareVariable | DeclareExportDeclaration | DeclareExportAllDeclaration | InterfaceDeclaration | OpaqueType | TypeAlias;
type FlowPredicate = DeclaredPredicate | InferredPredicate;
type EnumBody = EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody;
type EnumMember = EnumBooleanMember | EnumNumberMember | EnumStringMember | EnumDefaultedMember;
type JSX = JSXAttribute | JSXClosingElement | JSXElement | JSXEmptyExpression | JSXExpressionContainer | JSXSpreadChild | JSXIdentifier | JSXMemberExpression | JSXNamespacedName | JSXOpeningElement | JSXSpreadAttribute | JSXText | JSXFragment | JSXOpeningFragment | JSXClosingFragment;
type Miscellaneous = Noop | Placeholder | V8IntrinsicIdentifier;
type TypeScript = TSParameterProperty | TSDeclareFunction | TSDeclareMethod | TSQualifiedName | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSPropertySignature | TSMethodSignature | TSIndexSignature | TSAnyKeyword | TSBooleanKeyword | TSBigIntKeyword | TSIntrinsicKeyword | TSNeverKeyword | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSStringKeyword | TSSymbolKeyword | TSUndefinedKeyword | TSUnknownKeyword | TSVoidKeyword | TSThisType | TSFunctionType | TSConstructorType | TSTypeReference | TSTypePredicate | TSTypeQuery | TSTypeLiteral | TSArrayType | TSTupleType | TSOptionalType | TSRestType | TSNamedTupleMember | TSUnionType | TSIntersectionType | TSConditionalType | TSInferType | TSParenthesizedType | TSTypeOperator | TSIndexedAccessType | TSMappedType | TSTemplateLiteralType | TSLiteralType | TSExpressionWithTypeArguments | TSInterfaceDeclaration | TSInterfaceBody | TSTypeAliasDeclaration | TSInstantiationExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSEnumBody | TSEnumDeclaration | TSEnumMember | TSModuleDeclaration | TSModuleBlock | TSImportType | TSImportEqualsDeclaration | TSExternalModuleReference | TSNonNullExpression | TSExportAssignment | TSNamespaceExportDeclaration | TSTypeAnnotation | TSTypeParameterInstantiation | TSTypeParameterDeclaration | TSTypeParameter;
type TSTypeElement = TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSPropertySignature | TSMethodSignature | TSIndexSignature;
type TSType = TSAnyKeyword | TSBooleanKeyword | TSBigIntKeyword | TSIntrinsicKeyword | TSNeverKeyword | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSStringKeyword | TSSymbolKeyword | TSUndefinedKeyword | TSUnknownKeyword | TSVoidKeyword | TSThisType | TSFunctionType | TSConstructorType | TSTypeReference | TSTypePredicate | TSTypeQuery | TSTypeLiteral | TSArrayType | TSTupleType | TSOptionalType | TSRestType | TSUnionType | TSIntersectionType | TSConditionalType | TSInferType | TSParenthesizedType | TSTypeOperator | TSIndexedAccessType | TSMappedType | TSTemplateLiteralType | TSLiteralType | TSExpressionWithTypeArguments | TSImportType;
type TSBaseType = TSAnyKeyword | TSBooleanKeyword | TSBigIntKeyword | TSIntrinsicKeyword | TSNeverKeyword | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSStringKeyword | TSSymbolKeyword | TSUndefinedKeyword | TSUnknownKeyword | TSVoidKeyword | TSThisType | TSTemplateLiteralType | TSLiteralType;
type ModuleDeclaration = ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ImportDeclaration;
interface Aliases {
    Standardized: Standardized;
    Expression: Expression;
    Binary: Binary;
    Scopable: Scopable;
    BlockParent: BlockParent;
    Block: Block;
    Statement: Statement;
    Terminatorless: Terminatorless;
    CompletionStatement: CompletionStatement;
    Conditional: Conditional;
    Loop: Loop;
    While: While;
    ExpressionWrapper: ExpressionWrapper;
    For: For;
    ForXStatement: ForXStatement;
    Function: Function;
    FunctionParent: FunctionParent;
    Pureish: Pureish;
    Declaration: Declaration;
    FunctionParameter: FunctionParameter;
    PatternLike: PatternLike;
    LVal: LVal;
    TSEntityName: TSEntityName;
    Literal: Literal;
    Immutable: Immutable;
    UserWhitespacable: UserWhitespacable;
    Method: Method;
    ObjectMember: ObjectMember;
    Property: Property;
    UnaryLike: UnaryLike;
    Pattern: Pattern;
    Class: Class;
    ImportOrExportDeclaration: ImportOrExportDeclaration;
    ExportDeclaration: ExportDeclaration;
    ModuleSpecifier: ModuleSpecifier;
    Accessor: Accessor;
    Private: Private;
    Flow: Flow;
    FlowType: FlowType;
    FlowBaseAnnotation: FlowBaseAnnotation;
    FlowDeclaration: FlowDeclaration;
    FlowPredicate: FlowPredicate;
    EnumBody: EnumBody;
    EnumMember: EnumMember;
    JSX: JSX;
    Miscellaneous: Miscellaneous;
    TypeScript: TypeScript;
    TSTypeElement: TSTypeElement;
    TSType: TSType;
    TSBaseType: TSBaseType;
    ModuleDeclaration: ModuleDeclaration;
}
type DeprecatedAliases = NumberLiteral$1 | RegexLiteral$1 | RestProperty$1 | SpreadProperty$1;
interface ParentMaps {
    AnyTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    ArgumentPlaceholder: CallExpression | NewExpression | OptionalCallExpression;
    ArrayExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ArrayPattern: ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | CatchClause | ClassMethod | ClassPrivateMethod | ForInStatement | ForOfStatement | FunctionDeclaration | FunctionExpression | ObjectMethod | ObjectProperty | RestElement | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSFunctionType | TSMethodSignature | VariableDeclarator;
    ArrayTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    ArrowFunctionExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    AssignmentExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    AssignmentPattern: ArrayPattern | ArrowFunctionExpression | AssignmentExpression | ClassMethod | ClassPrivateMethod | ForInStatement | ForOfStatement | FunctionDeclaration | FunctionExpression | ObjectMethod | ObjectProperty | RestElement | TSDeclareFunction | TSDeclareMethod | TSParameterProperty | VariableDeclarator;
    AwaitExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    BigIntLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSLiteralType | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    BinaryExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    BindExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    BlockStatement: ArrowFunctionExpression | BlockStatement | CatchClause | ClassMethod | ClassPrivateMethod | DeclareModule | DoExpression | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | FunctionDeclaration | FunctionExpression | IfStatement | LabeledStatement | ObjectMethod | Program | StaticBlock | SwitchCase | TSModuleBlock | TryStatement | WhileStatement | WithStatement;
    BooleanLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | EnumBooleanMember | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSLiteralType | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    BooleanLiteralTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    BooleanTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    BreakStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    CallExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    CatchClause: TryStatement;
    ClassAccessorProperty: ClassBody;
    ClassBody: ClassDeclaration | ClassExpression;
    ClassDeclaration: BlockStatement | DoWhileStatement | ExportDefaultDeclaration | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    ClassExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ClassImplements: ClassDeclaration | ClassExpression | DeclareClass | DeclareExportDeclaration | DeclaredPredicate;
    ClassMethod: ClassBody;
    ClassPrivateMethod: ClassBody;
    ClassPrivateProperty: ClassBody;
    ClassProperty: ClassBody;
    CommentBlock: File;
    CommentLine: File;
    ConditionalExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ContinueStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DebuggerStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DecimalLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    DeclareClass: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareExportAllDeclaration: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareExportDeclaration: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareFunction: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareInterface: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareModule: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareModuleExports: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareOpaqueType: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareTypeAlias: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclareVariable: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    DeclaredPredicate: ArrowFunctionExpression | DeclareExportDeclaration | DeclareFunction | DeclaredPredicate | FunctionDeclaration | FunctionExpression;
    Decorator: ArrayPattern | AssignmentPattern | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateMethod | ClassPrivateProperty | ClassProperty | Identifier | ObjectMethod | ObjectPattern | ObjectProperty | Placeholder | RestElement | TSDeclareMethod | TSParameterProperty;
    Directive: BlockStatement | Program;
    DirectiveLiteral: Directive;
    DoExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    DoWhileStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    EmptyStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    EmptyTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    EnumBooleanBody: DeclareExportDeclaration | DeclaredPredicate | EnumDeclaration;
    EnumBooleanMember: DeclareExportDeclaration | DeclaredPredicate | EnumBooleanBody;
    EnumDeclaration: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    EnumDefaultedMember: DeclareExportDeclaration | DeclaredPredicate | EnumStringBody | EnumSymbolBody;
    EnumNumberBody: DeclareExportDeclaration | DeclaredPredicate | EnumDeclaration;
    EnumNumberMember: DeclareExportDeclaration | DeclaredPredicate | EnumNumberBody;
    EnumStringBody: DeclareExportDeclaration | DeclaredPredicate | EnumDeclaration;
    EnumStringMember: DeclareExportDeclaration | DeclaredPredicate | EnumStringBody;
    EnumSymbolBody: DeclareExportDeclaration | DeclaredPredicate | EnumDeclaration;
    ExistsTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    ExportAllDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    ExportDefaultDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    ExportDefaultSpecifier: ExportNamedDeclaration;
    ExportNamedDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    ExportNamespaceSpecifier: DeclareExportDeclaration | ExportNamedDeclaration;
    ExportSpecifier: DeclareExportDeclaration | ExportNamedDeclaration;
    ExpressionStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    File: null;
    ForInStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    ForOfStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    ForStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    FunctionDeclaration: BlockStatement | DoWhileStatement | ExportDefaultDeclaration | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    FunctionExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    FunctionTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    FunctionTypeParam: DeclareExportDeclaration | DeclaredPredicate | FunctionTypeAnnotation;
    GenericTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    Identifier: ArrayExpression | ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | BreakStatement | CallExpression | CatchClause | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassImplements | ClassMethod | ClassPrivateMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | ContinueStatement | DeclareClass | DeclareFunction | DeclareInterface | DeclareModule | DeclareOpaqueType | DeclareTypeAlias | DeclareVariable | Decorator | DoWhileStatement | EnumBooleanMember | EnumDeclaration | EnumDefaultedMember | EnumNumberMember | EnumStringMember | ExportDefaultDeclaration | ExportDefaultSpecifier | ExportNamespaceSpecifier | ExportSpecifier | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | FunctionDeclaration | FunctionExpression | FunctionTypeParam | GenericTypeAnnotation | IfStatement | ImportAttribute | ImportDefaultSpecifier | ImportExpression | ImportNamespaceSpecifier | ImportSpecifier | InterfaceDeclaration | InterfaceExtends | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LabeledStatement | LogicalExpression | MemberExpression | MetaProperty | NewExpression | ObjectMethod | ObjectProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | OpaqueType | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | Placeholder | PrivateName | QualifiedTypeIdentifier | RestElement | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSExpressionWithTypeArguments | TSFunctionType | TSImportEqualsDeclaration | TSImportType | TSIndexSignature | TSInstantiationExpression | TSInterfaceDeclaration | TSMethodSignature | TSModuleDeclaration | TSNamedTupleMember | TSNamespaceExportDeclaration | TSNonNullExpression | TSParameterProperty | TSPropertySignature | TSQualifiedName | TSSatisfiesExpression | TSTypeAliasDeclaration | TSTypeAssertion | TSTypePredicate | TSTypeQuery | TSTypeReference | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeAlias | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    IfStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    Import: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ImportAttribute: DeclareExportAllDeclaration | DeclareExportDeclaration | ExportAllDeclaration | ExportNamedDeclaration | ImportDeclaration;
    ImportDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    ImportDefaultSpecifier: ImportDeclaration;
    ImportExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ImportNamespaceSpecifier: ImportDeclaration;
    ImportSpecifier: ImportDeclaration;
    IndexedAccessType: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    InferredPredicate: ArrowFunctionExpression | DeclareExportDeclaration | DeclaredPredicate | FunctionDeclaration | FunctionExpression;
    InterfaceDeclaration: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    InterfaceExtends: ClassDeclaration | ClassExpression | DeclareClass | DeclareExportDeclaration | DeclareInterface | DeclaredPredicate | InterfaceDeclaration | InterfaceTypeAnnotation;
    InterfaceTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    InterpreterDirective: Program;
    IntersectionTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    JSXAttribute: JSXOpeningElement;
    JSXClosingElement: JSXElement;
    JSXClosingFragment: JSXFragment;
    JSXElement: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXAttribute | JSXElement | JSXExpressionContainer | JSXFragment | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    JSXEmptyExpression: JSXExpressionContainer;
    JSXExpressionContainer: JSXAttribute | JSXElement | JSXFragment;
    JSXFragment: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXAttribute | JSXElement | JSXExpressionContainer | JSXFragment | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    JSXIdentifier: JSXAttribute | JSXClosingElement | JSXMemberExpression | JSXNamespacedName | JSXOpeningElement;
    JSXMemberExpression: JSXClosingElement | JSXMemberExpression | JSXOpeningElement;
    JSXNamespacedName: JSXAttribute | JSXClosingElement | JSXOpeningElement;
    JSXOpeningElement: JSXElement;
    JSXOpeningFragment: JSXFragment;
    JSXSpreadAttribute: JSXOpeningElement;
    JSXSpreadChild: JSXElement | JSXFragment;
    JSXText: JSXElement | JSXFragment;
    LabeledStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    LogicalExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    MemberExpression: ArrayExpression | ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | RestElement | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    MetaProperty: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    MixedTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    ModuleExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    NewExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    Noop: ArrayPattern | ArrowFunctionExpression | AssignmentPattern | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateMethod | ClassPrivateProperty | ClassProperty | FunctionDeclaration | FunctionExpression | Identifier | ObjectMethod | ObjectPattern | Placeholder | RestElement | TSDeclareFunction | TSDeclareMethod;
    NullLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    NullLiteralTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    NullableTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    NumberLiteral: null;
    NumberLiteralTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    NumberTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    NumericLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | EnumNumberMember | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSLiteralType | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ObjectExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSImportType | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ObjectMethod: ObjectExpression;
    ObjectPattern: ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | CatchClause | ClassMethod | ClassPrivateMethod | ForInStatement | ForOfStatement | FunctionDeclaration | FunctionExpression | ObjectMethod | ObjectProperty | RestElement | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSFunctionType | TSMethodSignature | VariableDeclarator;
    ObjectProperty: ObjectExpression | ObjectPattern | RecordExpression;
    ObjectTypeAnnotation: ArrayTypeAnnotation | DeclareClass | DeclareExportDeclaration | DeclareInterface | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | InterfaceDeclaration | InterfaceTypeAnnotation | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    ObjectTypeCallProperty: DeclareExportDeclaration | DeclaredPredicate | ObjectTypeAnnotation;
    ObjectTypeIndexer: DeclareExportDeclaration | DeclaredPredicate | ObjectTypeAnnotation;
    ObjectTypeInternalSlot: DeclareExportDeclaration | DeclaredPredicate | ObjectTypeAnnotation;
    ObjectTypeProperty: DeclareExportDeclaration | DeclaredPredicate | ObjectTypeAnnotation;
    ObjectTypeSpreadProperty: DeclareExportDeclaration | DeclaredPredicate | ObjectTypeAnnotation;
    OpaqueType: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    OptionalCallExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    OptionalIndexedAccessType: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    OptionalMemberExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ParenthesizedExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    PipelineBareFunction: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    PipelinePrimaryTopicReference: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    PipelineTopicExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    Placeholder: Node$1;
    PrivateName: BinaryExpression | ClassAccessorProperty | ClassPrivateMethod | ClassPrivateProperty | MemberExpression | ObjectProperty;
    Program: File | ModuleExpression;
    QualifiedTypeIdentifier: DeclareExportDeclaration | DeclaredPredicate | GenericTypeAnnotation | InterfaceExtends | QualifiedTypeIdentifier;
    RecordExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    RegExpLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    RegexLiteral: null;
    RestElement: ArrayPattern | ArrowFunctionExpression | AssignmentExpression | ClassMethod | ClassPrivateMethod | ForInStatement | ForOfStatement | FunctionDeclaration | FunctionExpression | ObjectMethod | ObjectPattern | ObjectProperty | RestElement | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSFunctionType | TSMethodSignature | VariableDeclarator;
    RestProperty: null;
    ReturnStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    SequenceExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    SpreadElement: ArrayExpression | CallExpression | NewExpression | ObjectExpression | OptionalCallExpression | RecordExpression | TupleExpression;
    SpreadProperty: null;
    StaticBlock: ClassBody;
    StringLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | DeclareExportAllDeclaration | DeclareExportDeclaration | DeclareModule | Decorator | DoWhileStatement | EnumStringMember | ExportAllDeclaration | ExportDefaultDeclaration | ExportNamedDeclaration | ExportSpecifier | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportAttribute | ImportDeclaration | ImportExpression | ImportSpecifier | JSXAttribute | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | ObjectTypeProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSExternalModuleReference | TSImportType | TSInstantiationExpression | TSLiteralType | TSMethodSignature | TSModuleDeclaration | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    StringLiteralTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    StringTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    Super: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    SwitchCase: SwitchStatement;
    SwitchStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    SymbolTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    TSAnyKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSArrayType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSAsExpression: ArrayExpression | ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | RestElement | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TSBigIntKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSBooleanKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSCallSignatureDeclaration: TSInterfaceBody | TSTypeLiteral;
    TSConditionalType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSConstructSignatureDeclaration: TSInterfaceBody | TSTypeLiteral;
    TSConstructorType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSDeclareFunction: BlockStatement | DoWhileStatement | ExportDefaultDeclaration | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TSDeclareMethod: ClassBody;
    TSEnumBody: TSEnumDeclaration;
    TSEnumDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TSEnumMember: TSEnumBody | TSEnumDeclaration;
    TSExportAssignment: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TSExpressionWithTypeArguments: ClassDeclaration | ClassExpression | TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSInterfaceDeclaration | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSExternalModuleReference: TSImportEqualsDeclaration;
    TSFunctionType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSImportEqualsDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TSImportType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSTypeQuery | TSUnionType | TemplateLiteral;
    TSIndexSignature: ClassBody | TSInterfaceBody | TSTypeLiteral;
    TSIndexedAccessType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSInferType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSInstantiationExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TSInterfaceBody: TSInterfaceDeclaration;
    TSInterfaceDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TSIntersectionType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSIntrinsicKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSLiteralType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSMappedType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSMethodSignature: TSInterfaceBody | TSTypeLiteral;
    TSModuleBlock: TSModuleDeclaration;
    TSModuleDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | TSModuleDeclaration | WhileStatement | WithStatement;
    TSNamedTupleMember: TSTupleType;
    TSNamespaceExportDeclaration: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TSNeverKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSNonNullExpression: ArrayExpression | ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | RestElement | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TSNullKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSNumberKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSObjectKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSOptionalType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSParameterProperty: AssignmentExpression | ClassMethod | ClassPrivateMethod | ForInStatement | ForOfStatement | TSDeclareMethod | VariableDeclarator;
    TSParenthesizedType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSPropertySignature: TSInterfaceBody | TSTypeLiteral;
    TSQualifiedName: TSExpressionWithTypeArguments | TSImportEqualsDeclaration | TSImportType | TSQualifiedName | TSTypeQuery | TSTypeReference;
    TSRestType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSSatisfiesExpression: ArrayExpression | ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | RestElement | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TSStringKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSSymbolKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSTemplateLiteralType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSThisType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSTypePredicate | TSUnionType | TemplateLiteral;
    TSTupleType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSTypeAliasDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TSTypeAnnotation: ArrayPattern | ArrowFunctionExpression | AssignmentPattern | ClassAccessorProperty | ClassMethod | ClassPrivateMethod | ClassPrivateProperty | ClassProperty | FunctionDeclaration | FunctionExpression | Identifier | ObjectMethod | ObjectPattern | Placeholder | RestElement | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSFunctionType | TSIndexSignature | TSMethodSignature | TSPropertySignature | TSTypePredicate;
    TSTypeAssertion: ArrayExpression | ArrayPattern | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | RestElement | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TSTypeLiteral: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSTypeOperator: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSTypeParameter: TSInferType | TSMappedType | TSTypeParameterDeclaration;
    TSTypeParameterDeclaration: ArrowFunctionExpression | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateMethod | FunctionDeclaration | FunctionExpression | ObjectMethod | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSFunctionType | TSInterfaceDeclaration | TSMethodSignature | TSTypeAliasDeclaration;
    TSTypeParameterInstantiation: CallExpression | ClassDeclaration | ClassExpression | JSXOpeningElement | NewExpression | OptionalCallExpression | TSExpressionWithTypeArguments | TSImportType | TSInstantiationExpression | TSTypeQuery | TSTypeReference | TaggedTemplateExpression;
    TSTypePredicate: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSTypeQuery: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSTypeReference: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSUndefinedKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSUnionType: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSUnknownKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TSVoidKeyword: TSArrayType | TSAsExpression | TSConditionalType | TSIndexedAccessType | TSIntersectionType | TSMappedType | TSNamedTupleMember | TSOptionalType | TSParenthesizedType | TSRestType | TSSatisfiesExpression | TSTemplateLiteralType | TSTupleType | TSTypeAliasDeclaration | TSTypeAnnotation | TSTypeAssertion | TSTypeOperator | TSTypeParameter | TSTypeParameterInstantiation | TSUnionType | TemplateLiteral;
    TaggedTemplateExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TemplateElement: TSTemplateLiteralType | TemplateLiteral;
    TemplateLiteral: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSLiteralType | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ThisExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    ThisTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    ThrowStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TopicReference: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TryStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TupleExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TupleTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    TypeAlias: BlockStatement | DeclareExportDeclaration | DeclaredPredicate | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    TypeAnnotation: ArrayPattern | ArrowFunctionExpression | AssignmentPattern | ClassAccessorProperty | ClassMethod | ClassPrivateMethod | ClassPrivateProperty | ClassProperty | DeclareExportDeclaration | DeclareModuleExports | DeclaredPredicate | FunctionDeclaration | FunctionExpression | Identifier | ObjectMethod | ObjectPattern | Placeholder | RestElement | TypeCastExpression | TypeParameter;
    TypeCastExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | DeclareExportDeclaration | DeclaredPredicate | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    TypeParameter: DeclareExportDeclaration | DeclaredPredicate | TypeParameterDeclaration;
    TypeParameterDeclaration: ArrowFunctionExpression | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateMethod | DeclareClass | DeclareExportDeclaration | DeclareInterface | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionDeclaration | FunctionExpression | FunctionTypeAnnotation | InterfaceDeclaration | ObjectMethod | OpaqueType | TypeAlias;
    TypeParameterInstantiation: CallExpression | ClassDeclaration | ClassExpression | ClassImplements | DeclareExportDeclaration | DeclaredPredicate | GenericTypeAnnotation | InterfaceExtends | JSXOpeningElement | NewExpression | OptionalCallExpression | TaggedTemplateExpression;
    TypeofTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    UnaryExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSLiteralType | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    UnionTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    UpdateExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
    V8IntrinsicIdentifier: CallExpression | NewExpression;
    VariableDeclaration: BlockStatement | DoWhileStatement | ExportNamedDeclaration | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    VariableDeclarator: VariableDeclaration;
    Variance: ClassAccessorProperty | ClassPrivateProperty | ClassProperty | DeclareExportDeclaration | DeclaredPredicate | ObjectTypeIndexer | ObjectTypeProperty | TypeParameter;
    VoidPattern: ArrayPattern | ArrowFunctionExpression | ClassMethod | ClassPrivateMethod | FunctionDeclaration | FunctionExpression | ObjectMethod | ObjectProperty | TSDeclareFunction | TSDeclareMethod | VariableDeclarator;
    VoidTypeAnnotation: ArrayTypeAnnotation | DeclareExportDeclaration | DeclareOpaqueType | DeclareTypeAlias | DeclaredPredicate | FunctionTypeAnnotation | FunctionTypeParam | IndexedAccessType | IntersectionTypeAnnotation | NullableTypeAnnotation | ObjectTypeCallProperty | ObjectTypeIndexer | ObjectTypeInternalSlot | ObjectTypeProperty | ObjectTypeSpreadProperty | OpaqueType | OptionalIndexedAccessType | TupleTypeAnnotation | TypeAlias | TypeAnnotation | TypeParameter | TypeParameterInstantiation | TypeofTypeAnnotation | UnionTypeAnnotation;
    WhileStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    WithStatement: BlockStatement | DoWhileStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | LabeledStatement | Program | StaticBlock | SwitchCase | TSModuleBlock | WhileStatement | WithStatement;
    YieldExpression: ArrayExpression | ArrowFunctionExpression | AssignmentExpression | AssignmentPattern | AwaitExpression | BinaryExpression | BindExpression | CallExpression | ClassAccessorProperty | ClassDeclaration | ClassExpression | ClassMethod | ClassPrivateProperty | ClassProperty | ConditionalExpression | Decorator | DoWhileStatement | ExportDefaultDeclaration | ExpressionStatement | ForInStatement | ForOfStatement | ForStatement | IfStatement | ImportExpression | JSXExpressionContainer | JSXSpreadAttribute | JSXSpreadChild | LogicalExpression | MemberExpression | NewExpression | ObjectMethod | ObjectProperty | OptionalCallExpression | OptionalMemberExpression | ParenthesizedExpression | PipelineBareFunction | PipelineTopicExpression | ReturnStatement | SequenceExpression | SpreadElement | SwitchCase | SwitchStatement | TSAsExpression | TSDeclareMethod | TSEnumDeclaration | TSEnumMember | TSExportAssignment | TSInstantiationExpression | TSMethodSignature | TSNonNullExpression | TSPropertySignature | TSSatisfiesExpression | TSTypeAssertion | TaggedTemplateExpression | TemplateLiteral | ThrowStatement | TupleExpression | TypeCastExpression | UnaryExpression | UpdateExpression | VariableDeclarator | WhileStatement | WithStatement | YieldExpression;
}

/** @deprecated */ declare function bigIntLiteral(value: string): BigIntLiteral;
declare function bigIntLiteral(value: bigint): BigIntLiteral;
declare function arrayExpression(elements?: Array<null | Expression | SpreadElement>): ArrayExpression;
declare function assignmentExpression(operator: string, left: LVal | OptionalMemberExpression, right: Expression): AssignmentExpression;
declare function binaryExpression(operator: "+" | "-" | "/" | "%" | "*" | "**" | "&" | "|" | ">>" | ">>>" | "<<" | "^" | "==" | "===" | "!=" | "!==" | "in" | "instanceof" | ">" | "<" | ">=" | "<=" | "|>", left: Expression | PrivateName, right: Expression): BinaryExpression;
declare function interpreterDirective(value: string): InterpreterDirective;
declare function directive(value: DirectiveLiteral): Directive;
declare function directiveLiteral(value: string): DirectiveLiteral;
declare function blockStatement(body: Array<Statement>, directives?: Array<Directive>): BlockStatement;
declare function breakStatement(label?: Identifier | null): BreakStatement;
declare function callExpression(callee: Expression | Super | V8IntrinsicIdentifier, _arguments: Array<Expression | SpreadElement | ArgumentPlaceholder>): CallExpression;
declare function catchClause(param: Identifier | ArrayPattern | ObjectPattern | null | undefined, body: BlockStatement): CatchClause;
declare function conditionalExpression(test: Expression, consequent: Expression, alternate: Expression): ConditionalExpression;
declare function continueStatement(label?: Identifier | null): ContinueStatement;
declare function debuggerStatement(): DebuggerStatement;
declare function doWhileStatement(test: Expression, body: Statement): DoWhileStatement;
declare function emptyStatement(): EmptyStatement;
declare function expressionStatement(expression: Expression): ExpressionStatement;
declare function file(program: Program, comments?: Array<CommentBlock | CommentLine> | null, tokens?: Array<any> | null): File;
declare function forInStatement(left: VariableDeclaration | LVal, right: Expression, body: Statement): ForInStatement;
declare function forStatement(init: VariableDeclaration | Expression | null | undefined, test: Expression | null | undefined, update: Expression | null | undefined, body: Statement): ForStatement;
declare function functionDeclaration(id: Identifier | null | undefined, params: Array<FunctionParameter>, body: BlockStatement, generator?: boolean, async?: boolean): FunctionDeclaration;
declare function functionExpression(id: Identifier | null | undefined, params: Array<FunctionParameter>, body: BlockStatement, generator?: boolean, async?: boolean): FunctionExpression;
declare function identifier(name: string): Identifier;
declare function ifStatement(test: Expression, consequent: Statement, alternate?: Statement | null): IfStatement;
declare function labeledStatement(label: Identifier, body: Statement): LabeledStatement;
declare function stringLiteral(value: string): StringLiteral;
declare function numericLiteral(value: number): NumericLiteral;
declare function nullLiteral(): NullLiteral;
declare function booleanLiteral(value: boolean): BooleanLiteral;
declare function regExpLiteral(pattern: string, flags?: string): RegExpLiteral;
declare function logicalExpression(operator: "||" | "&&" | "??", left: Expression, right: Expression): LogicalExpression;
declare function memberExpression(object: Expression | Super, property: Expression | Identifier | PrivateName, computed?: boolean, optional?: boolean | null): MemberExpression;
declare function newExpression(callee: Expression | Super | V8IntrinsicIdentifier, _arguments: Array<Expression | SpreadElement | ArgumentPlaceholder>): NewExpression;
declare function program$1(body: Array<Statement>, directives?: Array<Directive>, sourceType?: "script" | "module", interpreter?: InterpreterDirective | null): Program;
declare function objectExpression(properties: Array<ObjectMethod | ObjectProperty | SpreadElement>): ObjectExpression;
declare function objectMethod(kind: "method" | "get" | "set" | undefined, key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral, params: Array<FunctionParameter>, body: BlockStatement, computed?: boolean, generator?: boolean, async?: boolean): ObjectMethod;
declare function objectProperty(key: Expression | Identifier | StringLiteral | NumericLiteral | BigIntLiteral | DecimalLiteral | PrivateName, value: Expression | PatternLike, computed?: boolean, shorthand?: boolean, decorators?: Array<Decorator> | null): ObjectProperty;
declare function restElement(argument: Identifier | ArrayPattern | ObjectPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression | RestElement | AssignmentPattern): RestElement;
declare function returnStatement(argument?: Expression | null): ReturnStatement;
declare function sequenceExpression(expressions: Array<Expression>): SequenceExpression;
declare function parenthesizedExpression(expression: Expression): ParenthesizedExpression;
declare function switchCase(test: Expression | null | undefined, consequent: Array<Statement>): SwitchCase;
declare function switchStatement(discriminant: Expression, cases: Array<SwitchCase>): SwitchStatement;
declare function thisExpression(): ThisExpression;
declare function throwStatement(argument: Expression): ThrowStatement;
declare function tryStatement(block: BlockStatement, handler?: CatchClause | null, finalizer?: BlockStatement | null): TryStatement;
declare function unaryExpression(operator: "void" | "throw" | "delete" | "!" | "+" | "-" | "~" | "typeof", argument: Expression, prefix?: boolean): UnaryExpression;
declare function updateExpression(operator: "++" | "--", argument: Expression, prefix?: boolean): UpdateExpression;
declare function variableDeclaration(kind: "var" | "let" | "const" | "using" | "await using", declarations: Array<VariableDeclarator>): VariableDeclaration;
declare function variableDeclarator(id: LVal | VoidPattern, init?: Expression | null): VariableDeclarator;
declare function whileStatement(test: Expression, body: Statement): WhileStatement;
declare function withStatement(object: Expression, body: Statement): WithStatement;
declare function assignmentPattern(left: Identifier | ObjectPattern | ArrayPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression, right: Expression): AssignmentPattern;
declare function arrayPattern(elements: Array<null | PatternLike>): ArrayPattern;
declare function arrowFunctionExpression(params: Array<FunctionParameter>, body: BlockStatement | Expression, async?: boolean): ArrowFunctionExpression;
declare function classBody(body: Array<ClassMethod | ClassPrivateMethod | ClassProperty | ClassPrivateProperty | ClassAccessorProperty | TSDeclareMethod | TSIndexSignature | StaticBlock>): ClassBody;
declare function classExpression(id: Identifier | null | undefined, superClass: Expression | null | undefined, body: ClassBody, decorators?: Array<Decorator> | null): ClassExpression;
declare function classDeclaration(id: Identifier | null | undefined, superClass: Expression | null | undefined, body: ClassBody, decorators?: Array<Decorator> | null): ClassDeclaration;
declare function exportAllDeclaration(source: StringLiteral): ExportAllDeclaration;
declare function exportDefaultDeclaration(declaration: TSDeclareFunction | FunctionDeclaration | ClassDeclaration | Expression): ExportDefaultDeclaration;
declare function exportNamedDeclaration(declaration?: Declaration | null, specifiers?: Array<ExportSpecifier | ExportDefaultSpecifier | ExportNamespaceSpecifier>, source?: StringLiteral | null): ExportNamedDeclaration;
declare function exportSpecifier(local: Identifier, exported: Identifier | StringLiteral): ExportSpecifier;
declare function forOfStatement(left: VariableDeclaration | LVal, right: Expression, body: Statement, _await?: boolean): ForOfStatement;
declare function importDeclaration(specifiers: Array<ImportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier>, source: StringLiteral): ImportDeclaration;
declare function importDefaultSpecifier(local: Identifier): ImportDefaultSpecifier;
declare function importNamespaceSpecifier(local: Identifier): ImportNamespaceSpecifier;
declare function importSpecifier(local: Identifier, imported: Identifier | StringLiteral): ImportSpecifier;
declare function importExpression(source: Expression, options?: Expression | null): ImportExpression;
declare function metaProperty(meta: Identifier, property: Identifier): MetaProperty;
declare function classMethod(kind: "get" | "set" | "method" | "constructor" | undefined, key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression, params: Array<FunctionParameter | TSParameterProperty>, body: BlockStatement, computed?: boolean, _static?: boolean, generator?: boolean, async?: boolean): ClassMethod;
declare function objectPattern(properties: Array<RestElement | ObjectProperty>): ObjectPattern;
declare function spreadElement(argument: Expression): SpreadElement;
declare function _super(): Super;

declare function taggedTemplateExpression(tag: Expression, quasi: TemplateLiteral): TaggedTemplateExpression;
declare function templateElement(value: {
    raw: string;
    cooked?: string;
}, tail?: boolean): TemplateElement;
declare function templateLiteral(quasis: Array<TemplateElement>, expressions: Array<Expression | TSType>): TemplateLiteral;
declare function yieldExpression(argument?: Expression | null, delegate?: boolean): YieldExpression;
declare function awaitExpression(argument: Expression): AwaitExpression;
declare function _import(): Import;

declare function exportNamespaceSpecifier(exported: Identifier): ExportNamespaceSpecifier;
declare function optionalMemberExpression(object: Expression, property: Expression | Identifier, computed: boolean | undefined, optional: boolean): OptionalMemberExpression;
declare function optionalCallExpression(callee: Expression, _arguments: Array<Expression | SpreadElement | ArgumentPlaceholder>, optional: boolean): OptionalCallExpression;
declare function classProperty(key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression, value?: Expression | null, typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null, decorators?: Array<Decorator> | null, computed?: boolean, _static?: boolean): ClassProperty;
declare function classAccessorProperty(key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression | PrivateName, value?: Expression | null, typeAnnotation?: TypeAnnotation | TSTypeAnnotation | Noop | null, decorators?: Array<Decorator> | null, computed?: boolean, _static?: boolean): ClassAccessorProperty;
declare function classPrivateProperty(key: PrivateName, value?: Expression | null, decorators?: Array<Decorator> | null, _static?: boolean): ClassPrivateProperty;
declare function classPrivateMethod(kind: "get" | "set" | "method" | undefined, key: PrivateName, params: Array<FunctionParameter | TSParameterProperty>, body: BlockStatement, _static?: boolean): ClassPrivateMethod;
declare function privateName(id: Identifier): PrivateName;
declare function staticBlock(body: Array<Statement>): StaticBlock;
declare function importAttribute(key: Identifier | StringLiteral, value: StringLiteral): ImportAttribute;
declare function anyTypeAnnotation(): AnyTypeAnnotation;
declare function arrayTypeAnnotation(elementType: FlowType): ArrayTypeAnnotation;
declare function booleanTypeAnnotation(): BooleanTypeAnnotation;
declare function booleanLiteralTypeAnnotation(value: boolean): BooleanLiteralTypeAnnotation;
declare function nullLiteralTypeAnnotation(): NullLiteralTypeAnnotation;
declare function classImplements(id: Identifier, typeParameters?: TypeParameterInstantiation | null): ClassImplements;
declare function declareClass(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, _extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): DeclareClass;
declare function declareFunction(id: Identifier): DeclareFunction;
declare function declareInterface(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, _extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): DeclareInterface;
declare function declareModule(id: Identifier | StringLiteral, body: BlockStatement, kind?: "CommonJS" | "ES" | null): DeclareModule;
declare function declareModuleExports(typeAnnotation: TypeAnnotation): DeclareModuleExports;
declare function declareTypeAlias(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, right: FlowType): DeclareTypeAlias;
declare function declareOpaqueType(id: Identifier, typeParameters?: TypeParameterDeclaration | null, supertype?: FlowType | null): DeclareOpaqueType;
declare function declareVariable(id: Identifier): DeclareVariable;
declare function declareExportDeclaration(declaration?: Flow | null, specifiers?: Array<ExportSpecifier | ExportNamespaceSpecifier> | null, source?: StringLiteral | null, attributes?: Array<ImportAttribute> | null): DeclareExportDeclaration;
declare function declareExportAllDeclaration(source: StringLiteral, attributes?: Array<ImportAttribute> | null): DeclareExportAllDeclaration;
declare function declaredPredicate(value: Flow): DeclaredPredicate;
declare function existsTypeAnnotation(): ExistsTypeAnnotation;
declare function functionTypeAnnotation(typeParameters: TypeParameterDeclaration | null | undefined, params: Array<FunctionTypeParam>, rest: FunctionTypeParam | null | undefined, returnType: FlowType): FunctionTypeAnnotation;
declare function functionTypeParam(name: Identifier | null | undefined, typeAnnotation: FlowType): FunctionTypeParam;
declare function genericTypeAnnotation(id: Identifier | QualifiedTypeIdentifier, typeParameters?: TypeParameterInstantiation | null): GenericTypeAnnotation;
declare function inferredPredicate(): InferredPredicate;
declare function interfaceExtends(id: Identifier | QualifiedTypeIdentifier, typeParameters?: TypeParameterInstantiation | null): InterfaceExtends;
declare function interfaceDeclaration(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, _extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): InterfaceDeclaration;
declare function interfaceTypeAnnotation(_extends: Array<InterfaceExtends> | null | undefined, body: ObjectTypeAnnotation): InterfaceTypeAnnotation;
declare function intersectionTypeAnnotation(types: Array<FlowType>): IntersectionTypeAnnotation;
declare function mixedTypeAnnotation(): MixedTypeAnnotation;
declare function emptyTypeAnnotation(): EmptyTypeAnnotation;
declare function nullableTypeAnnotation(typeAnnotation: FlowType): NullableTypeAnnotation;
declare function numberLiteralTypeAnnotation(value: number): NumberLiteralTypeAnnotation;
declare function numberTypeAnnotation(): NumberTypeAnnotation;
declare function objectTypeAnnotation(properties: Array<ObjectTypeProperty | ObjectTypeSpreadProperty>, indexers?: Array<ObjectTypeIndexer>, callProperties?: Array<ObjectTypeCallProperty>, internalSlots?: Array<ObjectTypeInternalSlot>, exact?: boolean): ObjectTypeAnnotation;
declare function objectTypeInternalSlot(id: Identifier, value: FlowType, optional: boolean, _static: boolean, method: boolean): ObjectTypeInternalSlot;
declare function objectTypeCallProperty(value: FlowType): ObjectTypeCallProperty;
declare function objectTypeIndexer(id: Identifier | null | undefined, key: FlowType, value: FlowType, variance?: Variance | null): ObjectTypeIndexer;
declare function objectTypeProperty(key: Identifier | StringLiteral, value: FlowType, variance?: Variance | null): ObjectTypeProperty;
declare function objectTypeSpreadProperty(argument: FlowType): ObjectTypeSpreadProperty;
declare function opaqueType(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, supertype: FlowType | null | undefined, impltype: FlowType): OpaqueType;
declare function qualifiedTypeIdentifier(id: Identifier, qualification: Identifier | QualifiedTypeIdentifier): QualifiedTypeIdentifier;
declare function stringLiteralTypeAnnotation(value: string): StringLiteralTypeAnnotation;
declare function stringTypeAnnotation(): StringTypeAnnotation;
declare function symbolTypeAnnotation(): SymbolTypeAnnotation;
declare function thisTypeAnnotation(): ThisTypeAnnotation;
declare function tupleTypeAnnotation(types: Array<FlowType>): TupleTypeAnnotation;
declare function typeofTypeAnnotation(argument: FlowType): TypeofTypeAnnotation;
declare function typeAlias(id: Identifier, typeParameters: TypeParameterDeclaration | null | undefined, right: FlowType): TypeAlias;
declare function typeAnnotation(typeAnnotation: FlowType): TypeAnnotation;
declare function typeCastExpression(expression: Expression, typeAnnotation: TypeAnnotation): TypeCastExpression;
declare function typeParameter(bound?: TypeAnnotation | null, _default?: FlowType | null, variance?: Variance | null): TypeParameter;
declare function typeParameterDeclaration(params: Array<TypeParameter>): TypeParameterDeclaration;
declare function typeParameterInstantiation(params: Array<FlowType>): TypeParameterInstantiation;
declare function unionTypeAnnotation(types: Array<FlowType>): UnionTypeAnnotation;
declare function variance(kind: "minus" | "plus"): Variance;
declare function voidTypeAnnotation(): VoidTypeAnnotation;
declare function enumDeclaration(id: Identifier, body: EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody): EnumDeclaration;
declare function enumBooleanBody(members: Array<EnumBooleanMember>): EnumBooleanBody;
declare function enumNumberBody(members: Array<EnumNumberMember>): EnumNumberBody;
declare function enumStringBody(members: Array<EnumStringMember | EnumDefaultedMember>): EnumStringBody;
declare function enumSymbolBody(members: Array<EnumDefaultedMember>): EnumSymbolBody;
declare function enumBooleanMember(id: Identifier): EnumBooleanMember;
declare function enumNumberMember(id: Identifier, init: NumericLiteral): EnumNumberMember;
declare function enumStringMember(id: Identifier, init: StringLiteral): EnumStringMember;
declare function enumDefaultedMember(id: Identifier): EnumDefaultedMember;
declare function indexedAccessType(objectType: FlowType, indexType: FlowType): IndexedAccessType;
declare function optionalIndexedAccessType(objectType: FlowType, indexType: FlowType): OptionalIndexedAccessType;
declare function jsxAttribute(name: JSXIdentifier | JSXNamespacedName, value?: JSXElement | JSXFragment | StringLiteral | JSXExpressionContainer | null): JSXAttribute;

declare function jsxClosingElement(name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName): JSXClosingElement;

declare function jsxElement(openingElement: JSXOpeningElement, closingElement: JSXClosingElement | null | undefined, children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>, selfClosing?: boolean | null): JSXElement;

declare function jsxEmptyExpression(): JSXEmptyExpression;

declare function jsxExpressionContainer(expression: Expression | JSXEmptyExpression): JSXExpressionContainer;

declare function jsxSpreadChild(expression: Expression): JSXSpreadChild;

declare function jsxIdentifier(name: string): JSXIdentifier;

declare function jsxMemberExpression(object: JSXMemberExpression | JSXIdentifier, property: JSXIdentifier): JSXMemberExpression;

declare function jsxNamespacedName(namespace: JSXIdentifier, name: JSXIdentifier): JSXNamespacedName;

declare function jsxOpeningElement(name: JSXIdentifier | JSXMemberExpression | JSXNamespacedName, attributes: Array<JSXAttribute | JSXSpreadAttribute>, selfClosing?: boolean): JSXOpeningElement;

declare function jsxSpreadAttribute(argument: Expression): JSXSpreadAttribute;

declare function jsxText(value: string): JSXText;

declare function jsxFragment(openingFragment: JSXOpeningFragment, closingFragment: JSXClosingFragment, children: Array<JSXText | JSXExpressionContainer | JSXSpreadChild | JSXElement | JSXFragment>): JSXFragment;

declare function jsxOpeningFragment(): JSXOpeningFragment;

declare function jsxClosingFragment(): JSXClosingFragment;

declare function noop(): Noop;
declare function placeholder(expectedNode: "Identifier" | "StringLiteral" | "Expression" | "Statement" | "Declaration" | "BlockStatement" | "ClassBody" | "Pattern", name: Identifier): Placeholder;
declare function v8IntrinsicIdentifier(name: string): V8IntrinsicIdentifier;
declare function argumentPlaceholder(): ArgumentPlaceholder;
declare function bindExpression(object: Expression, callee: Expression): BindExpression;
declare function decorator(expression: Expression): Decorator;
declare function doExpression(body: BlockStatement, async?: boolean): DoExpression;
declare function exportDefaultSpecifier(exported: Identifier): ExportDefaultSpecifier;
declare function recordExpression(properties: Array<ObjectProperty | SpreadElement>): RecordExpression;
declare function tupleExpression(elements?: Array<Expression | SpreadElement>): TupleExpression;
declare function decimalLiteral(value: string): DecimalLiteral;
declare function moduleExpression(body: Program): ModuleExpression;
declare function topicReference(): TopicReference;
declare function pipelineTopicExpression(expression: Expression): PipelineTopicExpression;
declare function pipelineBareFunction(callee: Expression): PipelineBareFunction;
declare function pipelinePrimaryTopicReference(): PipelinePrimaryTopicReference;
declare function voidPattern(): VoidPattern;
declare function tsParameterProperty(parameter: Identifier | AssignmentPattern): TSParameterProperty;

declare function tsDeclareFunction(id: Identifier | null | undefined, typeParameters: TSTypeParameterDeclaration | Noop | null | undefined, params: Array<FunctionParameter>, returnType?: TSTypeAnnotation | Noop | null): TSDeclareFunction;

declare function tsDeclareMethod(decorators: Array<Decorator> | null | undefined, key: Identifier | StringLiteral | NumericLiteral | BigIntLiteral | Expression, typeParameters: TSTypeParameterDeclaration | Noop | null | undefined, params: Array<FunctionParameter | TSParameterProperty>, returnType?: TSTypeAnnotation | Noop | null): TSDeclareMethod;

declare function tsQualifiedName(left: TSEntityName, right: Identifier): TSQualifiedName;

declare function tsCallSignatureDeclaration(typeParameters: TSTypeParameterDeclaration | null | undefined, parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, typeAnnotation?: TSTypeAnnotation | null): TSCallSignatureDeclaration;

declare function tsConstructSignatureDeclaration(typeParameters: TSTypeParameterDeclaration | null | undefined, parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, typeAnnotation?: TSTypeAnnotation | null): TSConstructSignatureDeclaration;

declare function tsPropertySignature(key: Expression, typeAnnotation?: TSTypeAnnotation | null): TSPropertySignature;

declare function tsMethodSignature(key: Expression, typeParameters: TSTypeParameterDeclaration | null | undefined, parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, typeAnnotation?: TSTypeAnnotation | null): TSMethodSignature;

declare function tsIndexSignature(parameters: Array<Identifier>, typeAnnotation?: TSTypeAnnotation | null): TSIndexSignature;

declare function tsAnyKeyword(): TSAnyKeyword;

declare function tsBooleanKeyword(): TSBooleanKeyword;

declare function tsBigIntKeyword(): TSBigIntKeyword;

declare function tsIntrinsicKeyword(): TSIntrinsicKeyword;

declare function tsNeverKeyword(): TSNeverKeyword;

declare function tsNullKeyword(): TSNullKeyword;

declare function tsNumberKeyword(): TSNumberKeyword;

declare function tsObjectKeyword(): TSObjectKeyword;

declare function tsStringKeyword(): TSStringKeyword;

declare function tsSymbolKeyword(): TSSymbolKeyword;

declare function tsUndefinedKeyword(): TSUndefinedKeyword;

declare function tsUnknownKeyword(): TSUnknownKeyword;

declare function tsVoidKeyword(): TSVoidKeyword;

declare function tsThisType(): TSThisType;

declare function tsFunctionType(typeParameters: TSTypeParameterDeclaration | null | undefined, parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, typeAnnotation?: TSTypeAnnotation | null): TSFunctionType;

declare function tsConstructorType(typeParameters: TSTypeParameterDeclaration | null | undefined, parameters: Array<ArrayPattern | Identifier | ObjectPattern | RestElement>, typeAnnotation?: TSTypeAnnotation | null): TSConstructorType;

declare function tsTypeReference(typeName: TSEntityName, typeParameters?: TSTypeParameterInstantiation | null): TSTypeReference;

declare function tsTypePredicate(parameterName: Identifier | TSThisType, typeAnnotation?: TSTypeAnnotation | null, asserts?: boolean | null): TSTypePredicate;

declare function tsTypeQuery(exprName: TSEntityName | TSImportType, typeParameters?: TSTypeParameterInstantiation | null): TSTypeQuery;

declare function tsTypeLiteral(members: Array<TSTypeElement>): TSTypeLiteral;

declare function tsArrayType(elementType: TSType): TSArrayType;

declare function tsTupleType(elementTypes: Array<TSType | TSNamedTupleMember>): TSTupleType;

declare function tsOptionalType(typeAnnotation: TSType): TSOptionalType;

declare function tsRestType(typeAnnotation: TSType): TSRestType;

declare function tsNamedTupleMember(label: Identifier, elementType: TSType, optional?: boolean): TSNamedTupleMember;

declare function tsUnionType(types: Array<TSType>): TSUnionType;

declare function tsIntersectionType(types: Array<TSType>): TSIntersectionType;

declare function tsConditionalType(checkType: TSType, extendsType: TSType, trueType: TSType, falseType: TSType): TSConditionalType;

declare function tsInferType(typeParameter: TSTypeParameter): TSInferType;

declare function tsParenthesizedType(typeAnnotation: TSType): TSParenthesizedType;

declare function tsTypeOperator(typeAnnotation: TSType, operator?: string): TSTypeOperator;

declare function tsIndexedAccessType(objectType: TSType, indexType: TSType): TSIndexedAccessType;

declare function tsMappedType(typeParameter: TSTypeParameter, typeAnnotation?: TSType | null, nameType?: TSType | null): TSMappedType;

declare function tsTemplateLiteralType(quasis: Array<TemplateElement>, types: Array<TSType>): TSTemplateLiteralType;

declare function tsLiteralType(literal: NumericLiteral | StringLiteral | BooleanLiteral | BigIntLiteral | TemplateLiteral | UnaryExpression): TSLiteralType;

declare function tsExpressionWithTypeArguments(expression: TSEntityName, typeParameters?: TSTypeParameterInstantiation | null): TSExpressionWithTypeArguments;

declare function tsInterfaceDeclaration(id: Identifier, typeParameters: TSTypeParameterDeclaration | null | undefined, _extends: Array<TSExpressionWithTypeArguments> | null | undefined, body: TSInterfaceBody): TSInterfaceDeclaration;

declare function tsInterfaceBody(body: Array<TSTypeElement>): TSInterfaceBody;

declare function tsTypeAliasDeclaration(id: Identifier, typeParameters: TSTypeParameterDeclaration | null | undefined, typeAnnotation: TSType): TSTypeAliasDeclaration;

declare function tsInstantiationExpression(expression: Expression, typeParameters?: TSTypeParameterInstantiation | null): TSInstantiationExpression;

declare function tsAsExpression(expression: Expression, typeAnnotation: TSType): TSAsExpression;

declare function tsSatisfiesExpression(expression: Expression, typeAnnotation: TSType): TSSatisfiesExpression;

declare function tsTypeAssertion(typeAnnotation: TSType, expression: Expression): TSTypeAssertion;

declare function tsEnumBody(members: Array<TSEnumMember>): TSEnumBody;

declare function tsEnumDeclaration(id: Identifier, members: Array<TSEnumMember>): TSEnumDeclaration;

declare function tsEnumMember(id: Identifier | StringLiteral, initializer?: Expression | null): TSEnumMember;

declare function tsModuleDeclaration(id: Identifier | StringLiteral, body: TSModuleBlock | TSModuleDeclaration): TSModuleDeclaration;

declare function tsModuleBlock(body: Array<Statement>): TSModuleBlock;

declare function tsImportType(argument: StringLiteral, qualifier?: TSEntityName | null, typeParameters?: TSTypeParameterInstantiation | null): TSImportType;

declare function tsImportEqualsDeclaration(id: Identifier, moduleReference: TSEntityName | TSExternalModuleReference): TSImportEqualsDeclaration;

declare function tsExternalModuleReference(expression: StringLiteral): TSExternalModuleReference;

declare function tsNonNullExpression(expression: Expression): TSNonNullExpression;

declare function tsExportAssignment(expression: Expression): TSExportAssignment;

declare function tsNamespaceExportDeclaration(id: Identifier): TSNamespaceExportDeclaration;

declare function tsTypeAnnotation(typeAnnotation: TSType): TSTypeAnnotation;

declare function tsTypeParameterInstantiation(params: Array<TSType>): TSTypeParameterInstantiation;

declare function tsTypeParameterDeclaration(params: Array<TSTypeParameter>): TSTypeParameterDeclaration;

declare function tsTypeParameter(constraint: TSType | null | undefined, _default: TSType | null | undefined, name: string): TSTypeParameter;

/** @deprecated */
declare function NumberLiteral(value: number): NumericLiteral;

/** @deprecated */
declare function RegexLiteral(pattern: string, flags?: string): RegExpLiteral;

/** @deprecated */
declare function RestProperty(argument: Identifier | ArrayPattern | ObjectPattern | MemberExpression | TSAsExpression | TSSatisfiesExpression | TSTypeAssertion | TSNonNullExpression | RestElement | AssignmentPattern): RestElement;

/** @deprecated */
declare function SpreadProperty(argument: Expression): SpreadElement;

declare function buildUndefinedNode(): UnaryExpression;

/**
 * Create a clone of a `node` including only properties belonging to the node.
 * If the second parameter is `false`, cloneNode performs a shallow clone.
 * If the third parameter is true, the cloned nodes exclude location properties.
 */
declare function cloneNode<T extends Node$1>(node: T, deep?: boolean, withoutLoc?: boolean): T;

/**
 * Create a shallow clone of a `node`, including only
 * properties belonging to the node.
 * @deprecated Use t.cloneNode instead.
 */
declare function clone<T extends Node$1>(node: T): T;

/**
 * Create a deep clone of a `node` and all of it's child nodes
 * including only properties belonging to the node.
 * @deprecated Use t.cloneNode instead.
 */
declare function cloneDeep<T extends Node$1>(node: T): T;

/**
 * Create a deep clone of a `node` and all of it's child nodes
 * including only properties belonging to the node.
 * excluding `_private` and location properties.
 */
declare function cloneDeepWithoutLoc<T extends Node$1>(node: T): T;

/**
 * Create a shallow clone of a `node` excluding `_private` and location properties.
 */
declare function cloneWithoutLoc<T extends Node$1>(node: T): T;

/**
 * Add comment of certain type to a node.
 */
declare function addComment<T extends Node$1>(node: T, type: CommentTypeShorthand, content: string, line?: boolean): T;

/**
 * Add comments of certain type to a node.
 */
declare function addComments<T extends Node$1>(node: T, type: CommentTypeShorthand, comments: Array<Comment>): T;

declare function inheritInnerComments(child: Node$1, parent: Node$1): void;

declare function inheritLeadingComments(child: Node$1, parent: Node$1): void;

/**
 * Inherit all unique comments from `parent` node to `child` node.
 */
declare function inheritsComments<T extends Node$1>(child: T, parent: Node$1): T;

declare function inheritTrailingComments(child: Node$1, parent: Node$1): void;

/**
 * Remove comment properties from a node.
 */
declare function removeComments<T extends Node$1>(node: T): T;

declare const STANDARDIZED_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const EXPRESSION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const BINARY_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const SCOPABLE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const BLOCKPARENT_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const BLOCK_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const STATEMENT_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const TERMINATORLESS_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const COMPLETIONSTATEMENT_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const CONDITIONAL_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const LOOP_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const WHILE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const EXPRESSIONWRAPPER_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FOR_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FORXSTATEMENT_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FUNCTION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FUNCTIONPARENT_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const PUREISH_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const DECLARATION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FUNCTIONPARAMETER_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const PATTERNLIKE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const LVAL_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const TSENTITYNAME_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const LITERAL_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const IMMUTABLE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const USERWHITESPACABLE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const METHOD_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const OBJECTMEMBER_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const PROPERTY_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const UNARYLIKE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const PATTERN_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const CLASS_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const IMPORTOREXPORTDECLARATION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const EXPORTDECLARATION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const MODULESPECIFIER_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const ACCESSOR_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const PRIVATE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FLOW_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FLOWTYPE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FLOWBASEANNOTATION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FLOWDECLARATION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const FLOWPREDICATE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const ENUMBODY_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const ENUMMEMBER_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const JSX_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const MISCELLANEOUS_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const TYPESCRIPT_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const TSTYPEELEMENT_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const TSTYPE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
declare const TSBASETYPE_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];
/**
 * @deprecated migrate to IMPORTOREXPORTDECLARATION_TYPES.
 */
declare const MODULEDECLARATION_TYPES: ("AnyTypeAnnotation" | "ArgumentPlaceholder" | "ArrayExpression" | "ArrayPattern" | "ArrayTypeAnnotation" | "ArrowFunctionExpression" | "AssignmentExpression" | "AssignmentPattern" | "AwaitExpression" | "BigIntLiteral" | "BinaryExpression" | "BindExpression" | "BlockStatement" | "BooleanLiteral" | "BooleanLiteralTypeAnnotation" | "BooleanTypeAnnotation" | "BreakStatement" | "CallExpression" | "CatchClause" | "ClassAccessorProperty" | "ClassBody" | "ClassDeclaration" | "ClassExpression" | "ClassImplements" | "ClassMethod" | "ClassPrivateMethod" | "ClassPrivateProperty" | "ClassProperty" | "ConditionalExpression" | "ContinueStatement" | "DebuggerStatement" | "DecimalLiteral" | "DeclareClass" | "DeclareExportAllDeclaration" | "DeclareExportDeclaration" | "DeclareFunction" | "DeclareInterface" | "DeclareModule" | "DeclareModuleExports" | "DeclareOpaqueType" | "DeclareTypeAlias" | "DeclareVariable" | "DeclaredPredicate" | "Decorator" | "Directive" | "DirectiveLiteral" | "DoExpression" | "DoWhileStatement" | "EmptyStatement" | "EmptyTypeAnnotation" | "EnumBooleanBody" | "EnumBooleanMember" | "EnumDeclaration" | "EnumDefaultedMember" | "EnumNumberBody" | "EnumNumberMember" | "EnumStringBody" | "EnumStringMember" | "EnumSymbolBody" | "ExistsTypeAnnotation" | "ExportAllDeclaration" | "ExportDefaultDeclaration" | "ExportDefaultSpecifier" | "ExportNamedDeclaration" | "ExportNamespaceSpecifier" | "ExportSpecifier" | "ExpressionStatement" | "File" | "ForInStatement" | "ForOfStatement" | "ForStatement" | "FunctionDeclaration" | "FunctionExpression" | "FunctionTypeAnnotation" | "FunctionTypeParam" | "GenericTypeAnnotation" | "Identifier" | "IfStatement" | "Import" | "ImportAttribute" | "ImportDeclaration" | "ImportDefaultSpecifier" | "ImportExpression" | "ImportNamespaceSpecifier" | "ImportSpecifier" | "IndexedAccessType" | "InferredPredicate" | "InterfaceDeclaration" | "InterfaceExtends" | "InterfaceTypeAnnotation" | "InterpreterDirective" | "IntersectionTypeAnnotation" | "JSXAttribute" | "JSXClosingElement" | "JSXClosingFragment" | "JSXElement" | "JSXEmptyExpression" | "JSXExpressionContainer" | "JSXFragment" | "JSXIdentifier" | "JSXMemberExpression" | "JSXNamespacedName" | "JSXOpeningElement" | "JSXOpeningFragment" | "JSXSpreadAttribute" | "JSXSpreadChild" | "JSXText" | "LabeledStatement" | "LogicalExpression" | "MemberExpression" | "MetaProperty" | "MixedTypeAnnotation" | "ModuleExpression" | "NewExpression" | "Noop" | "NullLiteral" | "NullLiteralTypeAnnotation" | "NullableTypeAnnotation" | "NumberLiteral" | "NumberLiteralTypeAnnotation" | "NumberTypeAnnotation" | "NumericLiteral" | "ObjectExpression" | "ObjectMethod" | "ObjectPattern" | "ObjectProperty" | "ObjectTypeAnnotation" | "ObjectTypeCallProperty" | "ObjectTypeIndexer" | "ObjectTypeInternalSlot" | "ObjectTypeProperty" | "ObjectTypeSpreadProperty" | "OpaqueType" | "OptionalCallExpression" | "OptionalIndexedAccessType" | "OptionalMemberExpression" | "ParenthesizedExpression" | "PipelineBareFunction" | "PipelinePrimaryTopicReference" | "PipelineTopicExpression" | "Placeholder" | "PrivateName" | "Program" | "QualifiedTypeIdentifier" | "RecordExpression" | "RegExpLiteral" | "RegexLiteral" | "RestElement" | "RestProperty" | "ReturnStatement" | "SequenceExpression" | "SpreadElement" | "SpreadProperty" | "StaticBlock" | "StringLiteral" | "StringLiteralTypeAnnotation" | "StringTypeAnnotation" | "Super" | "SwitchCase" | "SwitchStatement" | "SymbolTypeAnnotation" | "TSAnyKeyword" | "TSArrayType" | "TSAsExpression" | "TSBigIntKeyword" | "TSBooleanKeyword" | "TSCallSignatureDeclaration" | "TSConditionalType" | "TSConstructSignatureDeclaration" | "TSConstructorType" | "TSDeclareFunction" | "TSDeclareMethod" | "TSEnumBody" | "TSEnumDeclaration" | "TSEnumMember" | "TSExportAssignment" | "TSExpressionWithTypeArguments" | "TSExternalModuleReference" | "TSFunctionType" | "TSImportEqualsDeclaration" | "TSImportType" | "TSIndexSignature" | "TSIndexedAccessType" | "TSInferType" | "TSInstantiationExpression" | "TSInterfaceBody" | "TSInterfaceDeclaration" | "TSIntersectionType" | "TSIntrinsicKeyword" | "TSLiteralType" | "TSMappedType" | "TSMethodSignature" | "TSModuleBlock" | "TSModuleDeclaration" | "TSNamedTupleMember" | "TSNamespaceExportDeclaration" | "TSNeverKeyword" | "TSNonNullExpression" | "TSNullKeyword" | "TSNumberKeyword" | "TSObjectKeyword" | "TSOptionalType" | "TSParameterProperty" | "TSParenthesizedType" | "TSPropertySignature" | "TSQualifiedName" | "TSRestType" | "TSSatisfiesExpression" | "TSStringKeyword" | "TSSymbolKeyword" | "TSTemplateLiteralType" | "TSThisType" | "TSTupleType" | "TSTypeAliasDeclaration" | "TSTypeAnnotation" | "TSTypeAssertion" | "TSTypeLiteral" | "TSTypeOperator" | "TSTypeParameter" | "TSTypeParameterDeclaration" | "TSTypeParameterInstantiation" | "TSTypePredicate" | "TSTypeQuery" | "TSTypeReference" | "TSUndefinedKeyword" | "TSUnionType" | "TSUnknownKeyword" | "TSVoidKeyword" | "TaggedTemplateExpression" | "TemplateElement" | "TemplateLiteral" | "ThisExpression" | "ThisTypeAnnotation" | "ThrowStatement" | "TopicReference" | "TryStatement" | "TupleExpression" | "TupleTypeAnnotation" | "TypeAlias" | "TypeAnnotation" | "TypeCastExpression" | "TypeParameter" | "TypeParameterDeclaration" | "TypeParameterInstantiation" | "TypeofTypeAnnotation" | "UnaryExpression" | "UnionTypeAnnotation" | "UpdateExpression" | "V8IntrinsicIdentifier" | "VariableDeclaration" | "VariableDeclarator" | "Variance" | "VoidPattern" | "VoidTypeAnnotation" | "WhileStatement" | "WithStatement" | "YieldExpression" | keyof Aliases)[];

declare const STATEMENT_OR_BLOCK_KEYS: string[];
declare const FLATTENABLE_KEYS: string[];
declare const FOR_INIT_KEYS: string[];
declare const COMMENT_KEYS: readonly ["leadingComments", "trailingComments", "innerComments"];
declare const LOGICAL_OPERATORS: string[];
declare const UPDATE_OPERATORS: string[];
declare const BOOLEAN_NUMBER_BINARY_OPERATORS: string[];
declare const EQUALITY_BINARY_OPERATORS: string[];
declare const COMPARISON_BINARY_OPERATORS: string[];
declare const BOOLEAN_BINARY_OPERATORS: string[];
declare const NUMBER_BINARY_OPERATORS: string[];
declare const BINARY_OPERATORS: string[];
declare const ASSIGNMENT_OPERATORS: string[];
declare const BOOLEAN_UNARY_OPERATORS: string[];
declare const NUMBER_UNARY_OPERATORS: string[];
declare const STRING_UNARY_OPERATORS: string[];
declare const UNARY_OPERATORS: string[];
declare const INHERIT_KEYS: {
    readonly optional: readonly ["typeAnnotation", "typeParameters", "returnType"];
    readonly force: readonly ["start", "loc", "end"];
};

/**
 * Ensure the `key` (defaults to "body") of a `node` is a block.
 * Casting it to a block if it is not.
 *
 * Returns the BlockStatement
 */
declare function ensureBlock(node: Node$1, key?: string): BlockStatement;

declare function toBindingIdentifierName(name: string): string;

declare function toBlock(node: Statement | Expression, parent?: Node$1): BlockStatement;

declare function toComputedKey(node: ObjectMember | ObjectProperty | ClassMethod | ClassProperty | ClassAccessorProperty | MemberExpression | OptionalMemberExpression, key?: Expression | PrivateName): PrivateName | Expression;

declare const _default$3: {
    (node: Function): FunctionExpression;
    (node: Class): ClassExpression;
    (node: ExpressionStatement | Expression | Class | Function): Expression;
};
//# sourceMappingURL=toExpression.d.ts.map

declare function toIdentifier(input: string): string;

declare function toKeyAlias(node: Method | Property, key?: Node$1): string;
declare namespace toKeyAlias {
    var uid: number;
    var increment: () => number;
}
//# sourceMappingURL=toKeyAlias.d.ts.map

declare const _default$2: {
    (node: AssignmentExpression, ignore?: boolean): ExpressionStatement;
    <T extends Statement>(node: T, ignore: false): T;
    <T extends Statement>(node: T, ignore?: boolean): T | false;
    (node: Class, ignore: false): ClassDeclaration;
    (node: Class, ignore?: boolean): ClassDeclaration | false;
    (node: Function, ignore: false): FunctionDeclaration;
    (node: Function, ignore?: boolean): FunctionDeclaration | false;
    (node: Node$1, ignore: false): Statement;
    (node: Node$1, ignore?: boolean): Statement | false;
};
//# sourceMappingURL=toStatement.d.ts.map

declare const _default$1: {
    (value: undefined): Identifier;
    (value: boolean): BooleanLiteral;
    (value: null): NullLiteral;
    (value: string): StringLiteral;
    (value: number): NumericLiteral | BinaryExpression | UnaryExpression;
    (value: bigint): BigIntLiteral;
    (value: RegExp): RegExpLiteral;
    (value: ReadonlyArray<unknown>): ArrayExpression;
    (value: object): ObjectExpression;
    (value: unknown): Expression;
};
//# sourceMappingURL=valueToNode.d.ts.map

declare const VISITOR_KEYS: Record<string, string[]>;
declare const ALIAS_KEYS: Partial<Record<NodeTypesWithoutComment, string[]>>;
declare const FLIPPED_ALIAS_KEYS: Record<string, NodeTypesWithoutComment[]>;
declare const NODE_FIELDS: Record<string, FieldDefinitions>;
declare const BUILDER_KEYS: Record<string, string[]>;
declare const DEPRECATED_KEYS: Record<string, NodeTypesWithoutComment>;
declare const NODE_PARENT_VALIDATIONS: Record<string, Validator>;
declare function getType(val: any): "string" | "number" | "bigint" | "boolean" | "symbol" | "undefined" | "object" | "function" | "array" | "null";
type NodeTypesWithoutComment = Node$1["type"] | keyof Aliases;
type NodeTypes = NodeTypesWithoutComment | Comment["type"];
type PrimitiveTypes = ReturnType<typeof getType>;
type FieldDefinitions = {
    [x: string]: FieldOptions;
};
type ValidatorImpl = (node?: Node$1, key?: string | {
    toString(): string;
}, val?: any) => void;
type ValidatorType = {
    type: PrimitiveTypes;
} & ValidatorImpl;
type ValidatorEach = {
    each: Validator;
} & ValidatorImpl;
type ValidatorChainOf = {
    chainOf: readonly Validator[];
} & ValidatorImpl;
type ValidatorOneOf = {
    oneOf: readonly any[];
} & ValidatorImpl;
type ValidatorOneOfNodeTypes = {
    oneOfNodeTypes: readonly NodeTypes[];
} & ValidatorImpl;
type ValidatorOneOfNodeOrValueTypes = {
    oneOfNodeOrValueTypes: readonly (NodeTypes | PrimitiveTypes)[];
} & ValidatorImpl;
type ValidatorShapeOf = {
    shapeOf: {
        [x: string]: FieldOptions;
    };
} & ValidatorImpl;
type Validator = ValidatorType | ValidatorEach | ValidatorChainOf | ValidatorOneOf | ValidatorOneOfNodeTypes | ValidatorOneOfNodeOrValueTypes | ValidatorShapeOf | ValidatorImpl;
type FieldOptions = {
    default?: string | number | boolean | [];
    optional?: boolean;
    deprecated?: boolean;
    validate?: Validator;
};

declare const PLACEHOLDERS: readonly ["Identifier", "StringLiteral", "Expression", "Statement", "Declaration", "BlockStatement", "ClassBody", "Pattern"];
declare const PLACEHOLDERS_ALIAS: Record<string, string[]>;
declare const PLACEHOLDERS_FLIPPED_ALIAS: Record<string, string[]>;

declare const DEPRECATED_ALIASES: {
    ModuleDeclaration: string;
};

declare const TYPES: Array<string>;
//# sourceMappingURL=index.d.ts.map

/**
 * Append a node to a member expression.
 */
declare function appendToMemberExpression(member: MemberExpression, append: MemberExpression["property"], computed?: boolean): MemberExpression;

/**
 * Inherit all contextual properties from `parent` node to `child` node.
 */
declare function inherits<T extends Node$1 | null | undefined>(child: T, parent: Node$1 | null | undefined): T;

/**
 * Prepend a node to a member expression.
 */
declare function prependToMemberExpression<T extends Pick<MemberExpression, "object" | "property">>(member: T, prepend: MemberExpression["object"]): T;

type Options$1 = {
    preserveComments?: boolean;
};
/**
 * Remove all of the _* properties from a node along with the additional metadata
 * properties like location data and raw token data.
 */
declare function removeProperties(node: Node$1, opts?: Options$1): void;

declare function removePropertiesDeep<T extends Node$1>(tree: T, opts?: {
    preserveComments: boolean;
} | null): T;

/**
 * Dedupe type annotations.
 */
declare function removeTypeDuplicates(nodesIn: ReadonlyArray<FlowType | false | null | undefined>): FlowType[];

/**
 * For the given node, generate a map from assignment id names to the identifier node.
 * Unlike getBindingIdentifiers, this function does not handle declarations and imports.
 * @param node the assignment expression or forXstatement
 * @returns an object map
 * @see getBindingIdentifiers
 */
declare function getAssignmentIdentifiers(node: Node$1 | Node$1[]): Record<string, Identifier>;

declare function getBindingIdentifiers(node: Node$1, duplicates: true, outerOnly?: boolean, newBindingsOnly?: boolean): Record<string, Array<Identifier>>;
declare function getBindingIdentifiers(node: Node$1, duplicates?: false, outerOnly?: boolean, newBindingsOnly?: boolean): Record<string, Identifier>;
declare function getBindingIdentifiers(node: Node$1, duplicates?: boolean, outerOnly?: boolean, newBindingsOnly?: boolean): Record<string, Identifier> | Record<string, Array<Identifier>>;
declare namespace getBindingIdentifiers {
    var keys: KeysMap;
}
/**
 * Mapping of types to their identifier keys.
 */
type KeysMap = {
    [N in Node$1 as N["type"]]?: (keyof N)[];
};
//# sourceMappingURL=getBindingIdentifiers.d.ts.map

declare const _default: {
    (node: Node$1, duplicates: true): Record<string, Array<Identifier>>;
    (node: Node$1, duplicates?: false): Record<string, Identifier>;
    (node: Node$1, duplicates?: boolean): Record<string, Identifier> | Record<string, Array<Identifier>>;
};
//# sourceMappingURL=getOuterBindingIdentifiers.d.ts.map

type GetFunctionNameResult = {
    name: string;
    originalNode: Node$1;
} | null;
declare function getFunctionName(node: ObjectMethod | ClassMethod): GetFunctionNameResult;
declare function getFunctionName(node: Function | Class, parent: Node$1): GetFunctionNameResult;

type TraversalAncestors = Array<{
    node: Node$1;
    key: string;
    index?: number;
}>;
type TraversalHandler<T> = (this: undefined, node: Node$1, parent: TraversalAncestors, state: T) => void;
type TraversalHandlers<T> = {
    enter?: TraversalHandler<T>;
    exit?: TraversalHandler<T>;
};
/**
 * A general AST traversal with both prefix and postfix handlers, and a
 * state object. Exposes ancestry data to each handler so that more complex
 * AST data can be taken into account.
 */
declare function traverse$2<T>(node: Node$1, handlers: TraversalHandler<T> | TraversalHandlers<T>, state?: T): void;

declare const _skip: unique symbol;
declare const _stop: unique symbol;
/**
 * A prefix AST traversal implementation meant for simple searching and processing.
 * @param enter The callback can return `traverseFast.skip` to skip the subtree of the current node, or `traverseFast.stop` to stop the traversal.
 * @returns `true` if the traversal was stopped by callback, `false` otherwise.
 */
declare function traverseFast<Options = object>(node: Node$1 | null | undefined, enter: (node: Node$1, opts?: Options) => void | typeof traverseFast.skip | typeof traverseFast.stop, opts?: Options): boolean;
declare namespace traverseFast {
    var skip: typeof _skip;
    var stop: typeof _stop;
}
//# sourceMappingURL=traverseFast.d.ts.map

declare function shallowEqual<T extends object>(actual: object, expected: T): actual is T;

declare function is<T extends Node$1["type"]>(type: T, node: Node$1 | null | undefined, opts?: undefined): node is Extract<Node$1, {
    type: T;
}>;
declare function is<T extends Node$1["type"], P extends Extract<Node$1, {
    type: T;
}>>(type: T, n: Node$1 | null | undefined, required: Partial<P>): n is P;
declare function is<P extends Node$1>(type: string, node: Node$1 | null | undefined, opts: Partial<P>): node is P;
declare function is(type: string, node: Node$1 | null | undefined, opts?: Partial<Node$1>): node is Node$1;

/**
 * Check if the input `node` is a binding identifier.
 */
declare function isBinding(node: Node$1, parent: Node$1, grandparent?: Node$1): boolean;

/**
 * Check if the input `node` is block scoped.
 */
declare function isBlockScoped(node: Node$1 | null | undefined): boolean;

/**
 * Check if the input `node` is definitely immutable.
 */
declare function isImmutable(node: Node$1): boolean;

/**
 * Check if the input `node` is a `let` variable declaration.
 */
declare function isLet(node: Node$1): boolean;

declare function isNode(node: any): node is Node$1;

/**
 * Check if two nodes are equivalent
 */
declare function isNodesEquivalent<T extends Partial<Node$1>>(a: T, b: any): b is T;

/**
 * Test if a `placeholderType` is a `targetType` or if `targetType` is an alias of `placeholderType`.
 */
declare function isPlaceholderType(placeholderType: string, targetType: string): boolean;

/**
 * Check if the input `node` is a reference to a bound variable.
 */
declare function isReferenced(node: Node$1 | null | undefined, parent: Node$1, grandparent?: Node$1): boolean;

/**
 * Check if the input `node` is a scope.
 */
declare function isScope(node: Node$1 | null | undefined, parent: Node$1): boolean;

/**
 * Check if the input `specifier` is a `default` import or export.
 */
declare function isSpecifierDefault(specifier: ModuleSpecifier): boolean;

declare function isType<T extends Node$1["type"]>(nodeType: string, targetType: T): nodeType is T;
declare function isType(nodeType: string | null | undefined, targetType: string): boolean;

/**
 * Check if the input `name` is a valid identifier name according to the ES3 specification.
 *
 * Additional ES3 reserved words are
 */
declare function isValidES3Identifier(name: string): boolean;

/**
 * Check if the input `name` is a valid identifier name
 * and isn't a reserved word.
 */
declare function isValidIdentifier(name: string, reserved?: boolean): boolean;

/**
 * Check if the input `node` is a variable declaration.
 */
declare function isVar(node: Node$1 | null | undefined): boolean;

/**
 * Determines whether or not the input node `member` matches the
 * input `match`.
 *
 * For example, given the match `React.createClass` it would match the
 * parsed nodes of `React.createClass` and `React["createClass"]`.
 */
declare function matchesPattern(member: Node$1 | null | undefined, match: string | string[], allowPartial?: boolean): boolean;

declare function validate(node: Node$1 | undefined | null, key: string, val: unknown): void;

/**
 * Build a function that when called will return whether or not the
 * input `node` `MemberExpression` matches the input `match`.
 *
 * For example, given the match `React.createClass` it would match the
 * parsed nodes of `React.createClass` and `React["createClass"]`.
 */
declare function buildMatchMemberExpression(match: string, allowPartial?: boolean): (member: Node$1) => boolean;

type Options$2<Obj> = Partial<{
    [Prop in Exclude<keyof Obj, "type">]: Obj[Prop] extends Node$1 ? Node$1 : Obj[Prop] extends Node$1[] ? Node$1[] : Obj[Prop];
}>;
declare function isArrayExpression(node: Node$1 | null | undefined): node is ArrayExpression;
declare function isArrayExpression<Opts extends Options$2<ArrayExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ArrayExpression & Opts;
declare function isAssignmentExpression(node: Node$1 | null | undefined): node is AssignmentExpression;
declare function isAssignmentExpression<Opts extends Options$2<AssignmentExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is AssignmentExpression & Opts;
declare function isBinaryExpression(node: Node$1 | null | undefined): node is BinaryExpression;
declare function isBinaryExpression<Opts extends Options$2<BinaryExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BinaryExpression & Opts;
declare function isInterpreterDirective(node: Node$1 | null | undefined): node is InterpreterDirective;
declare function isInterpreterDirective<Opts extends Options$2<InterpreterDirective>>(node: Node$1 | null | undefined, opts?: Opts | null): node is InterpreterDirective & Opts;
declare function isDirective(node: Node$1 | null | undefined): node is Directive;
declare function isDirective<Opts extends Options$2<Directive>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Directive & Opts;
declare function isDirectiveLiteral(node: Node$1 | null | undefined): node is DirectiveLiteral;
declare function isDirectiveLiteral<Opts extends Options$2<DirectiveLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DirectiveLiteral & Opts;
declare function isBlockStatement(node: Node$1 | null | undefined): node is BlockStatement;
declare function isBlockStatement<Opts extends Options$2<BlockStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BlockStatement & Opts;
declare function isBreakStatement(node: Node$1 | null | undefined): node is BreakStatement;
declare function isBreakStatement<Opts extends Options$2<BreakStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BreakStatement & Opts;
declare function isCallExpression(node: Node$1 | null | undefined): node is CallExpression;
declare function isCallExpression<Opts extends Options$2<CallExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is CallExpression & Opts;
declare function isCatchClause(node: Node$1 | null | undefined): node is CatchClause;
declare function isCatchClause<Opts extends Options$2<CatchClause>>(node: Node$1 | null | undefined, opts?: Opts | null): node is CatchClause & Opts;
declare function isConditionalExpression(node: Node$1 | null | undefined): node is ConditionalExpression;
declare function isConditionalExpression<Opts extends Options$2<ConditionalExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ConditionalExpression & Opts;
declare function isContinueStatement(node: Node$1 | null | undefined): node is ContinueStatement;
declare function isContinueStatement<Opts extends Options$2<ContinueStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ContinueStatement & Opts;
declare function isDebuggerStatement(node: Node$1 | null | undefined): node is DebuggerStatement;
declare function isDebuggerStatement<Opts extends Options$2<DebuggerStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DebuggerStatement & Opts;
declare function isDoWhileStatement(node: Node$1 | null | undefined): node is DoWhileStatement;
declare function isDoWhileStatement<Opts extends Options$2<DoWhileStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DoWhileStatement & Opts;
declare function isEmptyStatement(node: Node$1 | null | undefined): node is EmptyStatement;
declare function isEmptyStatement<Opts extends Options$2<EmptyStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EmptyStatement & Opts;
declare function isExpressionStatement(node: Node$1 | null | undefined): node is ExpressionStatement;
declare function isExpressionStatement<Opts extends Options$2<ExpressionStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExpressionStatement & Opts;
declare function isFile(node: Node$1 | null | undefined): node is File;
declare function isFile<Opts extends Options$2<File>>(node: Node$1 | null | undefined, opts?: Opts | null): node is File & Opts;
declare function isForInStatement(node: Node$1 | null | undefined): node is ForInStatement;
declare function isForInStatement<Opts extends Options$2<ForInStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ForInStatement & Opts;
declare function isForStatement(node: Node$1 | null | undefined): node is ForStatement;
declare function isForStatement<Opts extends Options$2<ForStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ForStatement & Opts;
declare function isFunctionDeclaration(node: Node$1 | null | undefined): node is FunctionDeclaration;
declare function isFunctionDeclaration<Opts extends Options$2<FunctionDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FunctionDeclaration & Opts;
declare function isFunctionExpression(node: Node$1 | null | undefined): node is FunctionExpression;
declare function isFunctionExpression<Opts extends Options$2<FunctionExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FunctionExpression & Opts;
declare function isIdentifier(node: Node$1 | null | undefined): node is Identifier;
declare function isIdentifier<Opts extends Options$2<Identifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Identifier & Opts;
declare function isIfStatement(node: Node$1 | null | undefined): node is IfStatement;
declare function isIfStatement<Opts extends Options$2<IfStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is IfStatement & Opts;
declare function isLabeledStatement(node: Node$1 | null | undefined): node is LabeledStatement;
declare function isLabeledStatement<Opts extends Options$2<LabeledStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is LabeledStatement & Opts;
declare function isStringLiteral(node: Node$1 | null | undefined): node is StringLiteral;
declare function isStringLiteral<Opts extends Options$2<StringLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is StringLiteral & Opts;
declare function isNumericLiteral(node: Node$1 | null | undefined): node is NumericLiteral;
declare function isNumericLiteral<Opts extends Options$2<NumericLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is NumericLiteral & Opts;
declare function isNullLiteral(node: Node$1 | null | undefined): node is NullLiteral;
declare function isNullLiteral<Opts extends Options$2<NullLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is NullLiteral & Opts;
declare function isBooleanLiteral(node: Node$1 | null | undefined): node is BooleanLiteral;
declare function isBooleanLiteral<Opts extends Options$2<BooleanLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BooleanLiteral & Opts;
declare function isRegExpLiteral(node: Node$1 | null | undefined): node is RegExpLiteral;
declare function isRegExpLiteral<Opts extends Options$2<RegExpLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is RegExpLiteral & Opts;
declare function isLogicalExpression(node: Node$1 | null | undefined): node is LogicalExpression;
declare function isLogicalExpression<Opts extends Options$2<LogicalExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is LogicalExpression & Opts;
declare function isMemberExpression(node: Node$1 | null | undefined): node is MemberExpression;
declare function isMemberExpression<Opts extends Options$2<MemberExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is MemberExpression & Opts;
declare function isNewExpression(node: Node$1 | null | undefined): node is NewExpression;
declare function isNewExpression<Opts extends Options$2<NewExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is NewExpression & Opts;
declare function isProgram(node: Node$1 | null | undefined): node is Program;
declare function isProgram<Opts extends Options$2<Program>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Program & Opts;
declare function isObjectExpression(node: Node$1 | null | undefined): node is ObjectExpression;
declare function isObjectExpression<Opts extends Options$2<ObjectExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectExpression & Opts;
declare function isObjectMethod(node: Node$1 | null | undefined): node is ObjectMethod;
declare function isObjectMethod<Opts extends Options$2<ObjectMethod>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectMethod & Opts;
declare function isObjectProperty(node: Node$1 | null | undefined): node is ObjectProperty;
declare function isObjectProperty<Opts extends Options$2<ObjectProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectProperty & Opts;
declare function isRestElement(node: Node$1 | null | undefined): node is RestElement;
declare function isRestElement<Opts extends Options$2<RestElement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is RestElement & Opts;
declare function isReturnStatement(node: Node$1 | null | undefined): node is ReturnStatement;
declare function isReturnStatement<Opts extends Options$2<ReturnStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ReturnStatement & Opts;
declare function isSequenceExpression(node: Node$1 | null | undefined): node is SequenceExpression;
declare function isSequenceExpression<Opts extends Options$2<SequenceExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is SequenceExpression & Opts;
declare function isParenthesizedExpression(node: Node$1 | null | undefined): node is ParenthesizedExpression;
declare function isParenthesizedExpression<Opts extends Options$2<ParenthesizedExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ParenthesizedExpression & Opts;
declare function isSwitchCase(node: Node$1 | null | undefined): node is SwitchCase;
declare function isSwitchCase<Opts extends Options$2<SwitchCase>>(node: Node$1 | null | undefined, opts?: Opts | null): node is SwitchCase & Opts;
declare function isSwitchStatement(node: Node$1 | null | undefined): node is SwitchStatement;
declare function isSwitchStatement<Opts extends Options$2<SwitchStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is SwitchStatement & Opts;
declare function isThisExpression(node: Node$1 | null | undefined): node is ThisExpression;
declare function isThisExpression<Opts extends Options$2<ThisExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ThisExpression & Opts;
declare function isThrowStatement(node: Node$1 | null | undefined): node is ThrowStatement;
declare function isThrowStatement<Opts extends Options$2<ThrowStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ThrowStatement & Opts;
declare function isTryStatement(node: Node$1 | null | undefined): node is TryStatement;
declare function isTryStatement<Opts extends Options$2<TryStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TryStatement & Opts;
declare function isUnaryExpression(node: Node$1 | null | undefined): node is UnaryExpression;
declare function isUnaryExpression<Opts extends Options$2<UnaryExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is UnaryExpression & Opts;
declare function isUpdateExpression(node: Node$1 | null | undefined): node is UpdateExpression;
declare function isUpdateExpression<Opts extends Options$2<UpdateExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is UpdateExpression & Opts;
declare function isVariableDeclaration(node: Node$1 | null | undefined): node is VariableDeclaration;
declare function isVariableDeclaration<Opts extends Options$2<VariableDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is VariableDeclaration & Opts;
declare function isVariableDeclarator(node: Node$1 | null | undefined): node is VariableDeclarator;
declare function isVariableDeclarator<Opts extends Options$2<VariableDeclarator>>(node: Node$1 | null | undefined, opts?: Opts | null): node is VariableDeclarator & Opts;
declare function isWhileStatement(node: Node$1 | null | undefined): node is WhileStatement;
declare function isWhileStatement<Opts extends Options$2<WhileStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is WhileStatement & Opts;
declare function isWithStatement(node: Node$1 | null | undefined): node is WithStatement;
declare function isWithStatement<Opts extends Options$2<WithStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is WithStatement & Opts;
declare function isAssignmentPattern(node: Node$1 | null | undefined): node is AssignmentPattern;
declare function isAssignmentPattern<Opts extends Options$2<AssignmentPattern>>(node: Node$1 | null | undefined, opts?: Opts | null): node is AssignmentPattern & Opts;
declare function isArrayPattern(node: Node$1 | null | undefined): node is ArrayPattern;
declare function isArrayPattern<Opts extends Options$2<ArrayPattern>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ArrayPattern & Opts;
declare function isArrowFunctionExpression(node: Node$1 | null | undefined): node is ArrowFunctionExpression;
declare function isArrowFunctionExpression<Opts extends Options$2<ArrowFunctionExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ArrowFunctionExpression & Opts;
declare function isClassBody(node: Node$1 | null | undefined): node is ClassBody;
declare function isClassBody<Opts extends Options$2<ClassBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassBody & Opts;
declare function isClassExpression(node: Node$1 | null | undefined): node is ClassExpression;
declare function isClassExpression<Opts extends Options$2<ClassExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassExpression & Opts;
declare function isClassDeclaration(node: Node$1 | null | undefined): node is ClassDeclaration;
declare function isClassDeclaration<Opts extends Options$2<ClassDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassDeclaration & Opts;
declare function isExportAllDeclaration(node: Node$1 | null | undefined): node is ExportAllDeclaration;
declare function isExportAllDeclaration<Opts extends Options$2<ExportAllDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExportAllDeclaration & Opts;
declare function isExportDefaultDeclaration(node: Node$1 | null | undefined): node is ExportDefaultDeclaration;
declare function isExportDefaultDeclaration<Opts extends Options$2<ExportDefaultDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExportDefaultDeclaration & Opts;
declare function isExportNamedDeclaration(node: Node$1 | null | undefined): node is ExportNamedDeclaration;
declare function isExportNamedDeclaration<Opts extends Options$2<ExportNamedDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExportNamedDeclaration & Opts;
declare function isExportSpecifier(node: Node$1 | null | undefined): node is ExportSpecifier;
declare function isExportSpecifier<Opts extends Options$2<ExportSpecifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExportSpecifier & Opts;
declare function isForOfStatement(node: Node$1 | null | undefined): node is ForOfStatement;
declare function isForOfStatement<Opts extends Options$2<ForOfStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ForOfStatement & Opts;
declare function isImportDeclaration(node: Node$1 | null | undefined): node is ImportDeclaration;
declare function isImportDeclaration<Opts extends Options$2<ImportDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportDeclaration & Opts;
declare function isImportDefaultSpecifier(node: Node$1 | null | undefined): node is ImportDefaultSpecifier;
declare function isImportDefaultSpecifier<Opts extends Options$2<ImportDefaultSpecifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportDefaultSpecifier & Opts;
declare function isImportNamespaceSpecifier(node: Node$1 | null | undefined): node is ImportNamespaceSpecifier;
declare function isImportNamespaceSpecifier<Opts extends Options$2<ImportNamespaceSpecifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportNamespaceSpecifier & Opts;
declare function isImportSpecifier(node: Node$1 | null | undefined): node is ImportSpecifier;
declare function isImportSpecifier<Opts extends Options$2<ImportSpecifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportSpecifier & Opts;
declare function isImportExpression(node: Node$1 | null | undefined): node is ImportExpression;
declare function isImportExpression<Opts extends Options$2<ImportExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportExpression & Opts;
declare function isMetaProperty(node: Node$1 | null | undefined): node is MetaProperty;
declare function isMetaProperty<Opts extends Options$2<MetaProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is MetaProperty & Opts;
declare function isClassMethod(node: Node$1 | null | undefined): node is ClassMethod;
declare function isClassMethod<Opts extends Options$2<ClassMethod>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassMethod & Opts;
declare function isObjectPattern(node: Node$1 | null | undefined): node is ObjectPattern;
declare function isObjectPattern<Opts extends Options$2<ObjectPattern>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectPattern & Opts;
declare function isSpreadElement(node: Node$1 | null | undefined): node is SpreadElement;
declare function isSpreadElement<Opts extends Options$2<SpreadElement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is SpreadElement & Opts;
declare function isSuper(node: Node$1 | null | undefined): node is Super;
declare function isSuper<Opts extends Options$2<Super>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Super & Opts;
declare function isTaggedTemplateExpression(node: Node$1 | null | undefined): node is TaggedTemplateExpression;
declare function isTaggedTemplateExpression<Opts extends Options$2<TaggedTemplateExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TaggedTemplateExpression & Opts;
declare function isTemplateElement(node: Node$1 | null | undefined): node is TemplateElement;
declare function isTemplateElement<Opts extends Options$2<TemplateElement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TemplateElement & Opts;
declare function isTemplateLiteral(node: Node$1 | null | undefined): node is TemplateLiteral;
declare function isTemplateLiteral<Opts extends Options$2<TemplateLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TemplateLiteral & Opts;
declare function isYieldExpression(node: Node$1 | null | undefined): node is YieldExpression;
declare function isYieldExpression<Opts extends Options$2<YieldExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is YieldExpression & Opts;
declare function isAwaitExpression(node: Node$1 | null | undefined): node is AwaitExpression;
declare function isAwaitExpression<Opts extends Options$2<AwaitExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is AwaitExpression & Opts;
declare function isImport(node: Node$1 | null | undefined): node is Import;
declare function isImport<Opts extends Options$2<Import>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Import & Opts;
declare function isBigIntLiteral(node: Node$1 | null | undefined): node is BigIntLiteral;
declare function isBigIntLiteral<Opts extends Options$2<BigIntLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BigIntLiteral & Opts;
declare function isExportNamespaceSpecifier(node: Node$1 | null | undefined): node is ExportNamespaceSpecifier;
declare function isExportNamespaceSpecifier<Opts extends Options$2<ExportNamespaceSpecifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExportNamespaceSpecifier & Opts;
declare function isOptionalMemberExpression(node: Node$1 | null | undefined): node is OptionalMemberExpression;
declare function isOptionalMemberExpression<Opts extends Options$2<OptionalMemberExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is OptionalMemberExpression & Opts;
declare function isOptionalCallExpression(node: Node$1 | null | undefined): node is OptionalCallExpression;
declare function isOptionalCallExpression<Opts extends Options$2<OptionalCallExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is OptionalCallExpression & Opts;
declare function isClassProperty(node: Node$1 | null | undefined): node is ClassProperty;
declare function isClassProperty<Opts extends Options$2<ClassProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassProperty & Opts;
declare function isClassAccessorProperty(node: Node$1 | null | undefined): node is ClassAccessorProperty;
declare function isClassAccessorProperty<Opts extends Options$2<ClassAccessorProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassAccessorProperty & Opts;
declare function isClassPrivateProperty(node: Node$1 | null | undefined): node is ClassPrivateProperty;
declare function isClassPrivateProperty<Opts extends Options$2<ClassPrivateProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassPrivateProperty & Opts;
declare function isClassPrivateMethod(node: Node$1 | null | undefined): node is ClassPrivateMethod;
declare function isClassPrivateMethod<Opts extends Options$2<ClassPrivateMethod>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassPrivateMethod & Opts;
declare function isPrivateName(node: Node$1 | null | undefined): node is PrivateName;
declare function isPrivateName<Opts extends Options$2<PrivateName>>(node: Node$1 | null | undefined, opts?: Opts | null): node is PrivateName & Opts;
declare function isStaticBlock(node: Node$1 | null | undefined): node is StaticBlock;
declare function isStaticBlock<Opts extends Options$2<StaticBlock>>(node: Node$1 | null | undefined, opts?: Opts | null): node is StaticBlock & Opts;
declare function isImportAttribute(node: Node$1 | null | undefined): node is ImportAttribute;
declare function isImportAttribute<Opts extends Options$2<ImportAttribute>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportAttribute & Opts;
declare function isAnyTypeAnnotation(node: Node$1 | null | undefined): node is AnyTypeAnnotation;
declare function isAnyTypeAnnotation<Opts extends Options$2<AnyTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is AnyTypeAnnotation & Opts;
declare function isArrayTypeAnnotation(node: Node$1 | null | undefined): node is ArrayTypeAnnotation;
declare function isArrayTypeAnnotation<Opts extends Options$2<ArrayTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ArrayTypeAnnotation & Opts;
declare function isBooleanTypeAnnotation(node: Node$1 | null | undefined): node is BooleanTypeAnnotation;
declare function isBooleanTypeAnnotation<Opts extends Options$2<BooleanTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BooleanTypeAnnotation & Opts;
declare function isBooleanLiteralTypeAnnotation(node: Node$1 | null | undefined): node is BooleanLiteralTypeAnnotation;
declare function isBooleanLiteralTypeAnnotation<Opts extends Options$2<BooleanLiteralTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BooleanLiteralTypeAnnotation & Opts;
declare function isNullLiteralTypeAnnotation(node: Node$1 | null | undefined): node is NullLiteralTypeAnnotation;
declare function isNullLiteralTypeAnnotation<Opts extends Options$2<NullLiteralTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is NullLiteralTypeAnnotation & Opts;
declare function isClassImplements(node: Node$1 | null | undefined): node is ClassImplements;
declare function isClassImplements<Opts extends Options$2<ClassImplements>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ClassImplements & Opts;
declare function isDeclareClass(node: Node$1 | null | undefined): node is DeclareClass;
declare function isDeclareClass<Opts extends Options$2<DeclareClass>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareClass & Opts;
declare function isDeclareFunction(node: Node$1 | null | undefined): node is DeclareFunction;
declare function isDeclareFunction<Opts extends Options$2<DeclareFunction>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareFunction & Opts;
declare function isDeclareInterface(node: Node$1 | null | undefined): node is DeclareInterface;
declare function isDeclareInterface<Opts extends Options$2<DeclareInterface>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareInterface & Opts;
declare function isDeclareModule(node: Node$1 | null | undefined): node is DeclareModule;
declare function isDeclareModule<Opts extends Options$2<DeclareModule>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareModule & Opts;
declare function isDeclareModuleExports(node: Node$1 | null | undefined): node is DeclareModuleExports;
declare function isDeclareModuleExports<Opts extends Options$2<DeclareModuleExports>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareModuleExports & Opts;
declare function isDeclareTypeAlias(node: Node$1 | null | undefined): node is DeclareTypeAlias;
declare function isDeclareTypeAlias<Opts extends Options$2<DeclareTypeAlias>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareTypeAlias & Opts;
declare function isDeclareOpaqueType(node: Node$1 | null | undefined): node is DeclareOpaqueType;
declare function isDeclareOpaqueType<Opts extends Options$2<DeclareOpaqueType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareOpaqueType & Opts;
declare function isDeclareVariable(node: Node$1 | null | undefined): node is DeclareVariable;
declare function isDeclareVariable<Opts extends Options$2<DeclareVariable>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareVariable & Opts;
declare function isDeclareExportDeclaration(node: Node$1 | null | undefined): node is DeclareExportDeclaration;
declare function isDeclareExportDeclaration<Opts extends Options$2<DeclareExportDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareExportDeclaration & Opts;
declare function isDeclareExportAllDeclaration(node: Node$1 | null | undefined): node is DeclareExportAllDeclaration;
declare function isDeclareExportAllDeclaration<Opts extends Options$2<DeclareExportAllDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclareExportAllDeclaration & Opts;
declare function isDeclaredPredicate(node: Node$1 | null | undefined): node is DeclaredPredicate;
declare function isDeclaredPredicate<Opts extends Options$2<DeclaredPredicate>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DeclaredPredicate & Opts;
declare function isExistsTypeAnnotation(node: Node$1 | null | undefined): node is ExistsTypeAnnotation;
declare function isExistsTypeAnnotation<Opts extends Options$2<ExistsTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExistsTypeAnnotation & Opts;
declare function isFunctionTypeAnnotation(node: Node$1 | null | undefined): node is FunctionTypeAnnotation;
declare function isFunctionTypeAnnotation<Opts extends Options$2<FunctionTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FunctionTypeAnnotation & Opts;
declare function isFunctionTypeParam(node: Node$1 | null | undefined): node is FunctionTypeParam;
declare function isFunctionTypeParam<Opts extends Options$2<FunctionTypeParam>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FunctionTypeParam & Opts;
declare function isGenericTypeAnnotation(node: Node$1 | null | undefined): node is GenericTypeAnnotation;
declare function isGenericTypeAnnotation<Opts extends Options$2<GenericTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is GenericTypeAnnotation & Opts;
declare function isInferredPredicate(node: Node$1 | null | undefined): node is InferredPredicate;
declare function isInferredPredicate<Opts extends Options$2<InferredPredicate>>(node: Node$1 | null | undefined, opts?: Opts | null): node is InferredPredicate & Opts;
declare function isInterfaceExtends(node: Node$1 | null | undefined): node is InterfaceExtends;
declare function isInterfaceExtends<Opts extends Options$2<InterfaceExtends>>(node: Node$1 | null | undefined, opts?: Opts | null): node is InterfaceExtends & Opts;
declare function isInterfaceDeclaration(node: Node$1 | null | undefined): node is InterfaceDeclaration;
declare function isInterfaceDeclaration<Opts extends Options$2<InterfaceDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is InterfaceDeclaration & Opts;
declare function isInterfaceTypeAnnotation(node: Node$1 | null | undefined): node is InterfaceTypeAnnotation;
declare function isInterfaceTypeAnnotation<Opts extends Options$2<InterfaceTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is InterfaceTypeAnnotation & Opts;
declare function isIntersectionTypeAnnotation(node: Node$1 | null | undefined): node is IntersectionTypeAnnotation;
declare function isIntersectionTypeAnnotation<Opts extends Options$2<IntersectionTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is IntersectionTypeAnnotation & Opts;
declare function isMixedTypeAnnotation(node: Node$1 | null | undefined): node is MixedTypeAnnotation;
declare function isMixedTypeAnnotation<Opts extends Options$2<MixedTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is MixedTypeAnnotation & Opts;
declare function isEmptyTypeAnnotation(node: Node$1 | null | undefined): node is EmptyTypeAnnotation;
declare function isEmptyTypeAnnotation<Opts extends Options$2<EmptyTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EmptyTypeAnnotation & Opts;
declare function isNullableTypeAnnotation(node: Node$1 | null | undefined): node is NullableTypeAnnotation;
declare function isNullableTypeAnnotation<Opts extends Options$2<NullableTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is NullableTypeAnnotation & Opts;
declare function isNumberLiteralTypeAnnotation(node: Node$1 | null | undefined): node is NumberLiteralTypeAnnotation;
declare function isNumberLiteralTypeAnnotation<Opts extends Options$2<NumberLiteralTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is NumberLiteralTypeAnnotation & Opts;
declare function isNumberTypeAnnotation(node: Node$1 | null | undefined): node is NumberTypeAnnotation;
declare function isNumberTypeAnnotation<Opts extends Options$2<NumberTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is NumberTypeAnnotation & Opts;
declare function isObjectTypeAnnotation(node: Node$1 | null | undefined): node is ObjectTypeAnnotation;
declare function isObjectTypeAnnotation<Opts extends Options$2<ObjectTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectTypeAnnotation & Opts;
declare function isObjectTypeInternalSlot(node: Node$1 | null | undefined): node is ObjectTypeInternalSlot;
declare function isObjectTypeInternalSlot<Opts extends Options$2<ObjectTypeInternalSlot>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectTypeInternalSlot & Opts;
declare function isObjectTypeCallProperty(node: Node$1 | null | undefined): node is ObjectTypeCallProperty;
declare function isObjectTypeCallProperty<Opts extends Options$2<ObjectTypeCallProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectTypeCallProperty & Opts;
declare function isObjectTypeIndexer(node: Node$1 | null | undefined): node is ObjectTypeIndexer;
declare function isObjectTypeIndexer<Opts extends Options$2<ObjectTypeIndexer>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectTypeIndexer & Opts;
declare function isObjectTypeProperty(node: Node$1 | null | undefined): node is ObjectTypeProperty;
declare function isObjectTypeProperty<Opts extends Options$2<ObjectTypeProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectTypeProperty & Opts;
declare function isObjectTypeSpreadProperty(node: Node$1 | null | undefined): node is ObjectTypeSpreadProperty;
declare function isObjectTypeSpreadProperty<Opts extends Options$2<ObjectTypeSpreadProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectTypeSpreadProperty & Opts;
declare function isOpaqueType(node: Node$1 | null | undefined): node is OpaqueType;
declare function isOpaqueType<Opts extends Options$2<OpaqueType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is OpaqueType & Opts;
declare function isQualifiedTypeIdentifier(node: Node$1 | null | undefined): node is QualifiedTypeIdentifier;
declare function isQualifiedTypeIdentifier<Opts extends Options$2<QualifiedTypeIdentifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is QualifiedTypeIdentifier & Opts;
declare function isStringLiteralTypeAnnotation(node: Node$1 | null | undefined): node is StringLiteralTypeAnnotation;
declare function isStringLiteralTypeAnnotation<Opts extends Options$2<StringLiteralTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is StringLiteralTypeAnnotation & Opts;
declare function isStringTypeAnnotation(node: Node$1 | null | undefined): node is StringTypeAnnotation;
declare function isStringTypeAnnotation<Opts extends Options$2<StringTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is StringTypeAnnotation & Opts;
declare function isSymbolTypeAnnotation(node: Node$1 | null | undefined): node is SymbolTypeAnnotation;
declare function isSymbolTypeAnnotation<Opts extends Options$2<SymbolTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is SymbolTypeAnnotation & Opts;
declare function isThisTypeAnnotation(node: Node$1 | null | undefined): node is ThisTypeAnnotation;
declare function isThisTypeAnnotation<Opts extends Options$2<ThisTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ThisTypeAnnotation & Opts;
declare function isTupleTypeAnnotation(node: Node$1 | null | undefined): node is TupleTypeAnnotation;
declare function isTupleTypeAnnotation<Opts extends Options$2<TupleTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TupleTypeAnnotation & Opts;
declare function isTypeofTypeAnnotation(node: Node$1 | null | undefined): node is TypeofTypeAnnotation;
declare function isTypeofTypeAnnotation<Opts extends Options$2<TypeofTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeofTypeAnnotation & Opts;
declare function isTypeAlias(node: Node$1 | null | undefined): node is TypeAlias;
declare function isTypeAlias<Opts extends Options$2<TypeAlias>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeAlias & Opts;
declare function isTypeAnnotation(node: Node$1 | null | undefined): node is TypeAnnotation;
declare function isTypeAnnotation<Opts extends Options$2<TypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeAnnotation & Opts;
declare function isTypeCastExpression(node: Node$1 | null | undefined): node is TypeCastExpression;
declare function isTypeCastExpression<Opts extends Options$2<TypeCastExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeCastExpression & Opts;
declare function isTypeParameter(node: Node$1 | null | undefined): node is TypeParameter;
declare function isTypeParameter<Opts extends Options$2<TypeParameter>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeParameter & Opts;
declare function isTypeParameterDeclaration(node: Node$1 | null | undefined): node is TypeParameterDeclaration;
declare function isTypeParameterDeclaration<Opts extends Options$2<TypeParameterDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeParameterDeclaration & Opts;
declare function isTypeParameterInstantiation(node: Node$1 | null | undefined): node is TypeParameterInstantiation;
declare function isTypeParameterInstantiation<Opts extends Options$2<TypeParameterInstantiation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeParameterInstantiation & Opts;
declare function isUnionTypeAnnotation(node: Node$1 | null | undefined): node is UnionTypeAnnotation;
declare function isUnionTypeAnnotation<Opts extends Options$2<UnionTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is UnionTypeAnnotation & Opts;
declare function isVariance(node: Node$1 | null | undefined): node is Variance;
declare function isVariance<Opts extends Options$2<Variance>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Variance & Opts;
declare function isVoidTypeAnnotation(node: Node$1 | null | undefined): node is VoidTypeAnnotation;
declare function isVoidTypeAnnotation<Opts extends Options$2<VoidTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is VoidTypeAnnotation & Opts;
declare function isEnumDeclaration(node: Node$1 | null | undefined): node is EnumDeclaration;
declare function isEnumDeclaration<Opts extends Options$2<EnumDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumDeclaration & Opts;
declare function isEnumBooleanBody(node: Node$1 | null | undefined): node is EnumBooleanBody;
declare function isEnumBooleanBody<Opts extends Options$2<EnumBooleanBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumBooleanBody & Opts;
declare function isEnumNumberBody(node: Node$1 | null | undefined): node is EnumNumberBody;
declare function isEnumNumberBody<Opts extends Options$2<EnumNumberBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumNumberBody & Opts;
declare function isEnumStringBody(node: Node$1 | null | undefined): node is EnumStringBody;
declare function isEnumStringBody<Opts extends Options$2<EnumStringBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumStringBody & Opts;
declare function isEnumSymbolBody(node: Node$1 | null | undefined): node is EnumSymbolBody;
declare function isEnumSymbolBody<Opts extends Options$2<EnumSymbolBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumSymbolBody & Opts;
declare function isEnumBooleanMember(node: Node$1 | null | undefined): node is EnumBooleanMember;
declare function isEnumBooleanMember<Opts extends Options$2<EnumBooleanMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumBooleanMember & Opts;
declare function isEnumNumberMember(node: Node$1 | null | undefined): node is EnumNumberMember;
declare function isEnumNumberMember<Opts extends Options$2<EnumNumberMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumNumberMember & Opts;
declare function isEnumStringMember(node: Node$1 | null | undefined): node is EnumStringMember;
declare function isEnumStringMember<Opts extends Options$2<EnumStringMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumStringMember & Opts;
declare function isEnumDefaultedMember(node: Node$1 | null | undefined): node is EnumDefaultedMember;
declare function isEnumDefaultedMember<Opts extends Options$2<EnumDefaultedMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumDefaultedMember & Opts;
declare function isIndexedAccessType(node: Node$1 | null | undefined): node is IndexedAccessType;
declare function isIndexedAccessType<Opts extends Options$2<IndexedAccessType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is IndexedAccessType & Opts;
declare function isOptionalIndexedAccessType(node: Node$1 | null | undefined): node is OptionalIndexedAccessType;
declare function isOptionalIndexedAccessType<Opts extends Options$2<OptionalIndexedAccessType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is OptionalIndexedAccessType & Opts;
declare function isJSXAttribute(node: Node$1 | null | undefined): node is JSXAttribute;
declare function isJSXAttribute<Opts extends Options$2<JSXAttribute>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXAttribute & Opts;
declare function isJSXClosingElement(node: Node$1 | null | undefined): node is JSXClosingElement;
declare function isJSXClosingElement<Opts extends Options$2<JSXClosingElement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXClosingElement & Opts;
declare function isJSXElement(node: Node$1 | null | undefined): node is JSXElement;
declare function isJSXElement<Opts extends Options$2<JSXElement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXElement & Opts;
declare function isJSXEmptyExpression(node: Node$1 | null | undefined): node is JSXEmptyExpression;
declare function isJSXEmptyExpression<Opts extends Options$2<JSXEmptyExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXEmptyExpression & Opts;
declare function isJSXExpressionContainer(node: Node$1 | null | undefined): node is JSXExpressionContainer;
declare function isJSXExpressionContainer<Opts extends Options$2<JSXExpressionContainer>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXExpressionContainer & Opts;
declare function isJSXSpreadChild(node: Node$1 | null | undefined): node is JSXSpreadChild;
declare function isJSXSpreadChild<Opts extends Options$2<JSXSpreadChild>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXSpreadChild & Opts;
declare function isJSXIdentifier(node: Node$1 | null | undefined): node is JSXIdentifier;
declare function isJSXIdentifier<Opts extends Options$2<JSXIdentifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXIdentifier & Opts;
declare function isJSXMemberExpression(node: Node$1 | null | undefined): node is JSXMemberExpression;
declare function isJSXMemberExpression<Opts extends Options$2<JSXMemberExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXMemberExpression & Opts;
declare function isJSXNamespacedName(node: Node$1 | null | undefined): node is JSXNamespacedName;
declare function isJSXNamespacedName<Opts extends Options$2<JSXNamespacedName>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXNamespacedName & Opts;
declare function isJSXOpeningElement(node: Node$1 | null | undefined): node is JSXOpeningElement;
declare function isJSXOpeningElement<Opts extends Options$2<JSXOpeningElement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXOpeningElement & Opts;
declare function isJSXSpreadAttribute(node: Node$1 | null | undefined): node is JSXSpreadAttribute;
declare function isJSXSpreadAttribute<Opts extends Options$2<JSXSpreadAttribute>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXSpreadAttribute & Opts;
declare function isJSXText(node: Node$1 | null | undefined): node is JSXText;
declare function isJSXText<Opts extends Options$2<JSXText>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXText & Opts;
declare function isJSXFragment(node: Node$1 | null | undefined): node is JSXFragment;
declare function isJSXFragment<Opts extends Options$2<JSXFragment>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXFragment & Opts;
declare function isJSXOpeningFragment(node: Node$1 | null | undefined): node is JSXOpeningFragment;
declare function isJSXOpeningFragment<Opts extends Options$2<JSXOpeningFragment>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXOpeningFragment & Opts;
declare function isJSXClosingFragment(node: Node$1 | null | undefined): node is JSXClosingFragment;
declare function isJSXClosingFragment<Opts extends Options$2<JSXClosingFragment>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSXClosingFragment & Opts;
declare function isNoop(node: Node$1 | null | undefined): node is Noop;
declare function isNoop<Opts extends Options$2<Noop>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Noop & Opts;
declare function isPlaceholder(node: Node$1 | null | undefined): node is Placeholder;
declare function isPlaceholder<Opts extends Options$2<Placeholder>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Placeholder & Opts;
declare function isV8IntrinsicIdentifier(node: Node$1 | null | undefined): node is V8IntrinsicIdentifier;
declare function isV8IntrinsicIdentifier<Opts extends Options$2<V8IntrinsicIdentifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is V8IntrinsicIdentifier & Opts;
declare function isArgumentPlaceholder(node: Node$1 | null | undefined): node is ArgumentPlaceholder;
declare function isArgumentPlaceholder<Opts extends Options$2<ArgumentPlaceholder>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ArgumentPlaceholder & Opts;
declare function isBindExpression(node: Node$1 | null | undefined): node is BindExpression;
declare function isBindExpression<Opts extends Options$2<BindExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BindExpression & Opts;
declare function isDecorator(node: Node$1 | null | undefined): node is Decorator;
declare function isDecorator<Opts extends Options$2<Decorator>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Decorator & Opts;
declare function isDoExpression(node: Node$1 | null | undefined): node is DoExpression;
declare function isDoExpression<Opts extends Options$2<DoExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DoExpression & Opts;
declare function isExportDefaultSpecifier(node: Node$1 | null | undefined): node is ExportDefaultSpecifier;
declare function isExportDefaultSpecifier<Opts extends Options$2<ExportDefaultSpecifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExportDefaultSpecifier & Opts;
declare function isRecordExpression(node: Node$1 | null | undefined): node is RecordExpression;
declare function isRecordExpression<Opts extends Options$2<RecordExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is RecordExpression & Opts;
declare function isTupleExpression(node: Node$1 | null | undefined): node is TupleExpression;
declare function isTupleExpression<Opts extends Options$2<TupleExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TupleExpression & Opts;
declare function isDecimalLiteral(node: Node$1 | null | undefined): node is DecimalLiteral;
declare function isDecimalLiteral<Opts extends Options$2<DecimalLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is DecimalLiteral & Opts;
declare function isModuleExpression(node: Node$1 | null | undefined): node is ModuleExpression;
declare function isModuleExpression<Opts extends Options$2<ModuleExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ModuleExpression & Opts;
declare function isTopicReference(node: Node$1 | null | undefined): node is TopicReference;
declare function isTopicReference<Opts extends Options$2<TopicReference>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TopicReference & Opts;
declare function isPipelineTopicExpression(node: Node$1 | null | undefined): node is PipelineTopicExpression;
declare function isPipelineTopicExpression<Opts extends Options$2<PipelineTopicExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is PipelineTopicExpression & Opts;
declare function isPipelineBareFunction(node: Node$1 | null | undefined): node is PipelineBareFunction;
declare function isPipelineBareFunction<Opts extends Options$2<PipelineBareFunction>>(node: Node$1 | null | undefined, opts?: Opts | null): node is PipelineBareFunction & Opts;
declare function isPipelinePrimaryTopicReference(node: Node$1 | null | undefined): node is PipelinePrimaryTopicReference;
declare function isPipelinePrimaryTopicReference<Opts extends Options$2<PipelinePrimaryTopicReference>>(node: Node$1 | null | undefined, opts?: Opts | null): node is PipelinePrimaryTopicReference & Opts;
declare function isVoidPattern(node: Node$1 | null | undefined): node is VoidPattern;
declare function isVoidPattern<Opts extends Options$2<VoidPattern>>(node: Node$1 | null | undefined, opts?: Opts | null): node is VoidPattern & Opts;
declare function isTSParameterProperty(node: Node$1 | null | undefined): node is TSParameterProperty;
declare function isTSParameterProperty<Opts extends Options$2<TSParameterProperty>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSParameterProperty & Opts;
declare function isTSDeclareFunction(node: Node$1 | null | undefined): node is TSDeclareFunction;
declare function isTSDeclareFunction<Opts extends Options$2<TSDeclareFunction>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSDeclareFunction & Opts;
declare function isTSDeclareMethod(node: Node$1 | null | undefined): node is TSDeclareMethod;
declare function isTSDeclareMethod<Opts extends Options$2<TSDeclareMethod>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSDeclareMethod & Opts;
declare function isTSQualifiedName(node: Node$1 | null | undefined): node is TSQualifiedName;
declare function isTSQualifiedName<Opts extends Options$2<TSQualifiedName>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSQualifiedName & Opts;
declare function isTSCallSignatureDeclaration(node: Node$1 | null | undefined): node is TSCallSignatureDeclaration;
declare function isTSCallSignatureDeclaration<Opts extends Options$2<TSCallSignatureDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSCallSignatureDeclaration & Opts;
declare function isTSConstructSignatureDeclaration(node: Node$1 | null | undefined): node is TSConstructSignatureDeclaration;
declare function isTSConstructSignatureDeclaration<Opts extends Options$2<TSConstructSignatureDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSConstructSignatureDeclaration & Opts;
declare function isTSPropertySignature(node: Node$1 | null | undefined): node is TSPropertySignature;
declare function isTSPropertySignature<Opts extends Options$2<TSPropertySignature>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSPropertySignature & Opts;
declare function isTSMethodSignature(node: Node$1 | null | undefined): node is TSMethodSignature;
declare function isTSMethodSignature<Opts extends Options$2<TSMethodSignature>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSMethodSignature & Opts;
declare function isTSIndexSignature(node: Node$1 | null | undefined): node is TSIndexSignature;
declare function isTSIndexSignature<Opts extends Options$2<TSIndexSignature>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSIndexSignature & Opts;
declare function isTSAnyKeyword(node: Node$1 | null | undefined): node is TSAnyKeyword;
declare function isTSAnyKeyword<Opts extends Options$2<TSAnyKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSAnyKeyword & Opts;
declare function isTSBooleanKeyword(node: Node$1 | null | undefined): node is TSBooleanKeyword;
declare function isTSBooleanKeyword<Opts extends Options$2<TSBooleanKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSBooleanKeyword & Opts;
declare function isTSBigIntKeyword(node: Node$1 | null | undefined): node is TSBigIntKeyword;
declare function isTSBigIntKeyword<Opts extends Options$2<TSBigIntKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSBigIntKeyword & Opts;
declare function isTSIntrinsicKeyword(node: Node$1 | null | undefined): node is TSIntrinsicKeyword;
declare function isTSIntrinsicKeyword<Opts extends Options$2<TSIntrinsicKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSIntrinsicKeyword & Opts;
declare function isTSNeverKeyword(node: Node$1 | null | undefined): node is TSNeverKeyword;
declare function isTSNeverKeyword<Opts extends Options$2<TSNeverKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSNeverKeyword & Opts;
declare function isTSNullKeyword(node: Node$1 | null | undefined): node is TSNullKeyword;
declare function isTSNullKeyword<Opts extends Options$2<TSNullKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSNullKeyword & Opts;
declare function isTSNumberKeyword(node: Node$1 | null | undefined): node is TSNumberKeyword;
declare function isTSNumberKeyword<Opts extends Options$2<TSNumberKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSNumberKeyword & Opts;
declare function isTSObjectKeyword(node: Node$1 | null | undefined): node is TSObjectKeyword;
declare function isTSObjectKeyword<Opts extends Options$2<TSObjectKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSObjectKeyword & Opts;
declare function isTSStringKeyword(node: Node$1 | null | undefined): node is TSStringKeyword;
declare function isTSStringKeyword<Opts extends Options$2<TSStringKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSStringKeyword & Opts;
declare function isTSSymbolKeyword(node: Node$1 | null | undefined): node is TSSymbolKeyword;
declare function isTSSymbolKeyword<Opts extends Options$2<TSSymbolKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSSymbolKeyword & Opts;
declare function isTSUndefinedKeyword(node: Node$1 | null | undefined): node is TSUndefinedKeyword;
declare function isTSUndefinedKeyword<Opts extends Options$2<TSUndefinedKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSUndefinedKeyword & Opts;
declare function isTSUnknownKeyword(node: Node$1 | null | undefined): node is TSUnknownKeyword;
declare function isTSUnknownKeyword<Opts extends Options$2<TSUnknownKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSUnknownKeyword & Opts;
declare function isTSVoidKeyword(node: Node$1 | null | undefined): node is TSVoidKeyword;
declare function isTSVoidKeyword<Opts extends Options$2<TSVoidKeyword>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSVoidKeyword & Opts;
declare function isTSThisType(node: Node$1 | null | undefined): node is TSThisType;
declare function isTSThisType<Opts extends Options$2<TSThisType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSThisType & Opts;
declare function isTSFunctionType(node: Node$1 | null | undefined): node is TSFunctionType;
declare function isTSFunctionType<Opts extends Options$2<TSFunctionType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSFunctionType & Opts;
declare function isTSConstructorType(node: Node$1 | null | undefined): node is TSConstructorType;
declare function isTSConstructorType<Opts extends Options$2<TSConstructorType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSConstructorType & Opts;
declare function isTSTypeReference(node: Node$1 | null | undefined): node is TSTypeReference;
declare function isTSTypeReference<Opts extends Options$2<TSTypeReference>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeReference & Opts;
declare function isTSTypePredicate(node: Node$1 | null | undefined): node is TSTypePredicate;
declare function isTSTypePredicate<Opts extends Options$2<TSTypePredicate>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypePredicate & Opts;
declare function isTSTypeQuery(node: Node$1 | null | undefined): node is TSTypeQuery;
declare function isTSTypeQuery<Opts extends Options$2<TSTypeQuery>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeQuery & Opts;
declare function isTSTypeLiteral(node: Node$1 | null | undefined): node is TSTypeLiteral;
declare function isTSTypeLiteral<Opts extends Options$2<TSTypeLiteral>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeLiteral & Opts;
declare function isTSArrayType(node: Node$1 | null | undefined): node is TSArrayType;
declare function isTSArrayType<Opts extends Options$2<TSArrayType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSArrayType & Opts;
declare function isTSTupleType(node: Node$1 | null | undefined): node is TSTupleType;
declare function isTSTupleType<Opts extends Options$2<TSTupleType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTupleType & Opts;
declare function isTSOptionalType(node: Node$1 | null | undefined): node is TSOptionalType;
declare function isTSOptionalType<Opts extends Options$2<TSOptionalType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSOptionalType & Opts;
declare function isTSRestType(node: Node$1 | null | undefined): node is TSRestType;
declare function isTSRestType<Opts extends Options$2<TSRestType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSRestType & Opts;
declare function isTSNamedTupleMember(node: Node$1 | null | undefined): node is TSNamedTupleMember;
declare function isTSNamedTupleMember<Opts extends Options$2<TSNamedTupleMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSNamedTupleMember & Opts;
declare function isTSUnionType(node: Node$1 | null | undefined): node is TSUnionType;
declare function isTSUnionType<Opts extends Options$2<TSUnionType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSUnionType & Opts;
declare function isTSIntersectionType(node: Node$1 | null | undefined): node is TSIntersectionType;
declare function isTSIntersectionType<Opts extends Options$2<TSIntersectionType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSIntersectionType & Opts;
declare function isTSConditionalType(node: Node$1 | null | undefined): node is TSConditionalType;
declare function isTSConditionalType<Opts extends Options$2<TSConditionalType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSConditionalType & Opts;
declare function isTSInferType(node: Node$1 | null | undefined): node is TSInferType;
declare function isTSInferType<Opts extends Options$2<TSInferType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSInferType & Opts;
declare function isTSParenthesizedType(node: Node$1 | null | undefined): node is TSParenthesizedType;
declare function isTSParenthesizedType<Opts extends Options$2<TSParenthesizedType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSParenthesizedType & Opts;
declare function isTSTypeOperator(node: Node$1 | null | undefined): node is TSTypeOperator;
declare function isTSTypeOperator<Opts extends Options$2<TSTypeOperator>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeOperator & Opts;
declare function isTSIndexedAccessType(node: Node$1 | null | undefined): node is TSIndexedAccessType;
declare function isTSIndexedAccessType<Opts extends Options$2<TSIndexedAccessType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSIndexedAccessType & Opts;
declare function isTSMappedType(node: Node$1 | null | undefined): node is TSMappedType;
declare function isTSMappedType<Opts extends Options$2<TSMappedType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSMappedType & Opts;
declare function isTSTemplateLiteralType(node: Node$1 | null | undefined): node is TSTemplateLiteralType;
declare function isTSTemplateLiteralType<Opts extends Options$2<TSTemplateLiteralType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTemplateLiteralType & Opts;
declare function isTSLiteralType(node: Node$1 | null | undefined): node is TSLiteralType;
declare function isTSLiteralType<Opts extends Options$2<TSLiteralType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSLiteralType & Opts;
declare function isTSExpressionWithTypeArguments(node: Node$1 | null | undefined): node is TSExpressionWithTypeArguments;
declare function isTSExpressionWithTypeArguments<Opts extends Options$2<TSExpressionWithTypeArguments>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSExpressionWithTypeArguments & Opts;
declare function isTSInterfaceDeclaration(node: Node$1 | null | undefined): node is TSInterfaceDeclaration;
declare function isTSInterfaceDeclaration<Opts extends Options$2<TSInterfaceDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSInterfaceDeclaration & Opts;
declare function isTSInterfaceBody(node: Node$1 | null | undefined): node is TSInterfaceBody;
declare function isTSInterfaceBody<Opts extends Options$2<TSInterfaceBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSInterfaceBody & Opts;
declare function isTSTypeAliasDeclaration(node: Node$1 | null | undefined): node is TSTypeAliasDeclaration;
declare function isTSTypeAliasDeclaration<Opts extends Options$2<TSTypeAliasDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeAliasDeclaration & Opts;
declare function isTSInstantiationExpression(node: Node$1 | null | undefined): node is TSInstantiationExpression;
declare function isTSInstantiationExpression<Opts extends Options$2<TSInstantiationExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSInstantiationExpression & Opts;
declare function isTSAsExpression(node: Node$1 | null | undefined): node is TSAsExpression;
declare function isTSAsExpression<Opts extends Options$2<TSAsExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSAsExpression & Opts;
declare function isTSSatisfiesExpression(node: Node$1 | null | undefined): node is TSSatisfiesExpression;
declare function isTSSatisfiesExpression<Opts extends Options$2<TSSatisfiesExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSSatisfiesExpression & Opts;
declare function isTSTypeAssertion(node: Node$1 | null | undefined): node is TSTypeAssertion;
declare function isTSTypeAssertion<Opts extends Options$2<TSTypeAssertion>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeAssertion & Opts;
declare function isTSEnumBody(node: Node$1 | null | undefined): node is TSEnumBody;
declare function isTSEnumBody<Opts extends Options$2<TSEnumBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSEnumBody & Opts;
declare function isTSEnumDeclaration(node: Node$1 | null | undefined): node is TSEnumDeclaration;
declare function isTSEnumDeclaration<Opts extends Options$2<TSEnumDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSEnumDeclaration & Opts;
declare function isTSEnumMember(node: Node$1 | null | undefined): node is TSEnumMember;
declare function isTSEnumMember<Opts extends Options$2<TSEnumMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSEnumMember & Opts;
declare function isTSModuleDeclaration(node: Node$1 | null | undefined): node is TSModuleDeclaration;
declare function isTSModuleDeclaration<Opts extends Options$2<TSModuleDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSModuleDeclaration & Opts;
declare function isTSModuleBlock(node: Node$1 | null | undefined): node is TSModuleBlock;
declare function isTSModuleBlock<Opts extends Options$2<TSModuleBlock>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSModuleBlock & Opts;
declare function isTSImportType(node: Node$1 | null | undefined): node is TSImportType;
declare function isTSImportType<Opts extends Options$2<TSImportType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSImportType & Opts;
declare function isTSImportEqualsDeclaration(node: Node$1 | null | undefined): node is TSImportEqualsDeclaration;
declare function isTSImportEqualsDeclaration<Opts extends Options$2<TSImportEqualsDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSImportEqualsDeclaration & Opts;
declare function isTSExternalModuleReference(node: Node$1 | null | undefined): node is TSExternalModuleReference;
declare function isTSExternalModuleReference<Opts extends Options$2<TSExternalModuleReference>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSExternalModuleReference & Opts;
declare function isTSNonNullExpression(node: Node$1 | null | undefined): node is TSNonNullExpression;
declare function isTSNonNullExpression<Opts extends Options$2<TSNonNullExpression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSNonNullExpression & Opts;
declare function isTSExportAssignment(node: Node$1 | null | undefined): node is TSExportAssignment;
declare function isTSExportAssignment<Opts extends Options$2<TSExportAssignment>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSExportAssignment & Opts;
declare function isTSNamespaceExportDeclaration(node: Node$1 | null | undefined): node is TSNamespaceExportDeclaration;
declare function isTSNamespaceExportDeclaration<Opts extends Options$2<TSNamespaceExportDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSNamespaceExportDeclaration & Opts;
declare function isTSTypeAnnotation(node: Node$1 | null | undefined): node is TSTypeAnnotation;
declare function isTSTypeAnnotation<Opts extends Options$2<TSTypeAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeAnnotation & Opts;
declare function isTSTypeParameterInstantiation(node: Node$1 | null | undefined): node is TSTypeParameterInstantiation;
declare function isTSTypeParameterInstantiation<Opts extends Options$2<TSTypeParameterInstantiation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeParameterInstantiation & Opts;
declare function isTSTypeParameterDeclaration(node: Node$1 | null | undefined): node is TSTypeParameterDeclaration;
declare function isTSTypeParameterDeclaration<Opts extends Options$2<TSTypeParameterDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeParameterDeclaration & Opts;
declare function isTSTypeParameter(node: Node$1 | null | undefined): node is TSTypeParameter;
declare function isTSTypeParameter<Opts extends Options$2<TSTypeParameter>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeParameter & Opts;
declare function isStandardized(node: Node$1 | null | undefined): node is Standardized;
declare function isStandardized<Opts extends Options$2<Standardized>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Standardized & Opts;
declare function isExpression(node: Node$1 | null | undefined): node is Expression;
declare function isExpression<Opts extends Options$2<Expression>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Expression & Opts;
declare function isBinary(node: Node$1 | null | undefined): node is Binary;
declare function isBinary<Opts extends Options$2<Binary>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Binary & Opts;
declare function isScopable(node: Node$1 | null | undefined): node is Scopable;
declare function isScopable<Opts extends Options$2<Scopable>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Scopable & Opts;
declare function isBlockParent(node: Node$1 | null | undefined): node is BlockParent;
declare function isBlockParent<Opts extends Options$2<BlockParent>>(node: Node$1 | null | undefined, opts?: Opts | null): node is BlockParent & Opts;
declare function isBlock(node: Node$1 | null | undefined): node is Block;
declare function isBlock<Opts extends Options$2<Block>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Block & Opts;
declare function isStatement(node: Node$1 | null | undefined): node is Statement;
declare function isStatement<Opts extends Options$2<Statement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Statement & Opts;
declare function isTerminatorless(node: Node$1 | null | undefined): node is Terminatorless;
declare function isTerminatorless<Opts extends Options$2<Terminatorless>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Terminatorless & Opts;
declare function isCompletionStatement(node: Node$1 | null | undefined): node is CompletionStatement;
declare function isCompletionStatement<Opts extends Options$2<CompletionStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is CompletionStatement & Opts;
declare function isConditional(node: Node$1 | null | undefined): node is Conditional;
declare function isConditional<Opts extends Options$2<Conditional>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Conditional & Opts;
declare function isLoop(node: Node$1 | null | undefined): node is Loop;
declare function isLoop<Opts extends Options$2<Loop>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Loop & Opts;
declare function isWhile(node: Node$1 | null | undefined): node is While;
declare function isWhile<Opts extends Options$2<While>>(node: Node$1 | null | undefined, opts?: Opts | null): node is While & Opts;
declare function isExpressionWrapper(node: Node$1 | null | undefined): node is ExpressionWrapper;
declare function isExpressionWrapper<Opts extends Options$2<ExpressionWrapper>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExpressionWrapper & Opts;
declare function isFor(node: Node$1 | null | undefined): node is For;
declare function isFor<Opts extends Options$2<For>>(node: Node$1 | null | undefined, opts?: Opts | null): node is For & Opts;
declare function isForXStatement(node: Node$1 | null | undefined): node is ForXStatement;
declare function isForXStatement<Opts extends Options$2<ForXStatement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ForXStatement & Opts;
declare function isFunction(node: Node$1 | null | undefined): node is Function;
declare function isFunction<Opts extends Options$2<Function>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Function & Opts;
declare function isFunctionParent(node: Node$1 | null | undefined): node is FunctionParent;
declare function isFunctionParent<Opts extends Options$2<FunctionParent>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FunctionParent & Opts;
declare function isPureish(node: Node$1 | null | undefined): node is Pureish;
declare function isPureish<Opts extends Options$2<Pureish>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Pureish & Opts;
declare function isDeclaration(node: Node$1 | null | undefined): node is Declaration;
declare function isDeclaration<Opts extends Options$2<Declaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Declaration & Opts;
declare function isFunctionParameter(node: Node$1 | null | undefined): node is FunctionParameter;
declare function isFunctionParameter<Opts extends Options$2<FunctionParameter>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FunctionParameter & Opts;
declare function isPatternLike(node: Node$1 | null | undefined): node is PatternLike;
declare function isPatternLike<Opts extends Options$2<PatternLike>>(node: Node$1 | null | undefined, opts?: Opts | null): node is PatternLike & Opts;
declare function isLVal(node: Node$1 | null | undefined): node is LVal;
declare function isLVal<Opts extends Options$2<LVal>>(node: Node$1 | null | undefined, opts?: Opts | null): node is LVal & Opts;
declare function isTSEntityName(node: Node$1 | null | undefined): node is TSEntityName;
declare function isTSEntityName<Opts extends Options$2<TSEntityName>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSEntityName & Opts;
declare function isLiteral(node: Node$1 | null | undefined): node is Literal;
declare function isLiteral<Opts extends Options$2<Literal>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Literal & Opts;
declare function isUserWhitespacable(node: Node$1 | null | undefined): node is UserWhitespacable;
declare function isUserWhitespacable<Opts extends Options$2<UserWhitespacable>>(node: Node$1 | null | undefined, opts?: Opts | null): node is UserWhitespacable & Opts;
declare function isMethod(node: Node$1 | null | undefined): node is Method;
declare function isMethod<Opts extends Options$2<Method>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Method & Opts;
declare function isObjectMember(node: Node$1 | null | undefined): node is ObjectMember;
declare function isObjectMember<Opts extends Options$2<ObjectMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ObjectMember & Opts;
declare function isProperty(node: Node$1 | null | undefined): node is Property;
declare function isProperty<Opts extends Options$2<Property>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Property & Opts;
declare function isUnaryLike(node: Node$1 | null | undefined): node is UnaryLike;
declare function isUnaryLike<Opts extends Options$2<UnaryLike>>(node: Node$1 | null | undefined, opts?: Opts | null): node is UnaryLike & Opts;
declare function isPattern(node: Node$1 | null | undefined): node is Pattern;
declare function isPattern<Opts extends Options$2<Pattern>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Pattern & Opts;
declare function isClass(node: Node$1 | null | undefined): node is Class;
declare function isClass<Opts extends Options$2<Class>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Class & Opts;
declare function isImportOrExportDeclaration(node: Node$1 | null | undefined): node is ImportOrExportDeclaration;
declare function isImportOrExportDeclaration<Opts extends Options$2<ImportOrExportDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportOrExportDeclaration & Opts;
declare function isExportDeclaration(node: Node$1 | null | undefined): node is ExportDeclaration;
declare function isExportDeclaration<Opts extends Options$2<ExportDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ExportDeclaration & Opts;
declare function isModuleSpecifier(node: Node$1 | null | undefined): node is ModuleSpecifier;
declare function isModuleSpecifier<Opts extends Options$2<ModuleSpecifier>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ModuleSpecifier & Opts;
declare function isAccessor(node: Node$1 | null | undefined): node is Accessor;
declare function isAccessor<Opts extends Options$2<Accessor>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Accessor & Opts;
declare function isPrivate(node: Node$1 | null | undefined): node is Private;
declare function isPrivate<Opts extends Options$2<Private>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Private & Opts;
declare function isFlow(node: Node$1 | null | undefined): node is Flow;
declare function isFlow<Opts extends Options$2<Flow>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Flow & Opts;
declare function isFlowType(node: Node$1 | null | undefined): node is FlowType;
declare function isFlowType<Opts extends Options$2<FlowType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FlowType & Opts;
declare function isFlowBaseAnnotation(node: Node$1 | null | undefined): node is FlowBaseAnnotation;
declare function isFlowBaseAnnotation<Opts extends Options$2<FlowBaseAnnotation>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FlowBaseAnnotation & Opts;
declare function isFlowDeclaration(node: Node$1 | null | undefined): node is FlowDeclaration;
declare function isFlowDeclaration<Opts extends Options$2<FlowDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FlowDeclaration & Opts;
declare function isFlowPredicate(node: Node$1 | null | undefined): node is FlowPredicate;
declare function isFlowPredicate<Opts extends Options$2<FlowPredicate>>(node: Node$1 | null | undefined, opts?: Opts | null): node is FlowPredicate & Opts;
declare function isEnumBody(node: Node$1 | null | undefined): node is EnumBody;
declare function isEnumBody<Opts extends Options$2<EnumBody>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumBody & Opts;
declare function isEnumMember(node: Node$1 | null | undefined): node is EnumMember;
declare function isEnumMember<Opts extends Options$2<EnumMember>>(node: Node$1 | null | undefined, opts?: Opts | null): node is EnumMember & Opts;
declare function isJSX(node: Node$1 | null | undefined): node is JSX;
declare function isJSX<Opts extends Options$2<JSX>>(node: Node$1 | null | undefined, opts?: Opts | null): node is JSX & Opts;
declare function isMiscellaneous(node: Node$1 | null | undefined): node is Miscellaneous;
declare function isMiscellaneous<Opts extends Options$2<Miscellaneous>>(node: Node$1 | null | undefined, opts?: Opts | null): node is Miscellaneous & Opts;
declare function isTypeScript(node: Node$1 | null | undefined): node is TypeScript;
declare function isTypeScript<Opts extends Options$2<TypeScript>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TypeScript & Opts;
declare function isTSTypeElement(node: Node$1 | null | undefined): node is TSTypeElement;
declare function isTSTypeElement<Opts extends Options$2<TSTypeElement>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSTypeElement & Opts;
declare function isTSType(node: Node$1 | null | undefined): node is TSType;
declare function isTSType<Opts extends Options$2<TSType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSType & Opts;
declare function isTSBaseType(node: Node$1 | null | undefined): node is TSBaseType;
declare function isTSBaseType<Opts extends Options$2<TSBaseType>>(node: Node$1 | null | undefined, opts?: Opts | null): node is TSBaseType & Opts;
/**
 * @deprecated Use `isNumericLiteral`
 */
declare function isNumberLiteral(node: Node$1 | null | undefined): boolean;
declare function isNumberLiteral<Opts extends Options$2<NumberLiteral$1>>(node: Node$1 | null | undefined, opts?: Opts | null): boolean;
/**
 * @deprecated Use `isRegExpLiteral`
 */
declare function isRegexLiteral(node: Node$1 | null | undefined): boolean;
declare function isRegexLiteral<Opts extends Options$2<RegexLiteral$1>>(node: Node$1 | null | undefined, opts?: Opts | null): boolean;
/**
 * @deprecated Use `isRestElement`
 */
declare function isRestProperty(node: Node$1 | null | undefined): boolean;
declare function isRestProperty<Opts extends Options$2<RestProperty$1>>(node: Node$1 | null | undefined, opts?: Opts | null): boolean;
/**
 * @deprecated Use `isSpreadElement`
 */
declare function isSpreadProperty(node: Node$1 | null | undefined): boolean;
declare function isSpreadProperty<Opts extends Options$2<SpreadProperty$1>>(node: Node$1 | null | undefined, opts?: Opts | null): boolean;
/**
 * @deprecated Use `isImportOrExportDeclaration`
 */
declare function isModuleDeclaration<Opts extends Options$2<ModuleDeclaration>>(node: Node$1 | null | undefined, opts?: Opts | null): node is ImportOrExportDeclaration & Opts;

declare function deprecationWarning(oldName: string, newName: string, prefix?: string, cacheKey?: string): void;

declare const react: {
    isReactComponent: (member: Node$1) => boolean;
    isCompatTag: typeof isCompatTag;
    buildChildren: typeof buildChildren;
};

declare const index_d$1_ACCESSOR_TYPES: typeof ACCESSOR_TYPES;
declare const index_d$1_ALIAS_KEYS: typeof ALIAS_KEYS;
declare const index_d$1_ASSIGNMENT_OPERATORS: typeof ASSIGNMENT_OPERATORS;
type index_d$1_Accessor = Accessor;
type index_d$1_Aliases = Aliases;
type index_d$1_AnyTypeAnnotation = AnyTypeAnnotation;
type index_d$1_ArgumentPlaceholder = ArgumentPlaceholder;
type index_d$1_ArrayExpression = ArrayExpression;
type index_d$1_ArrayPattern = ArrayPattern;
type index_d$1_ArrayTypeAnnotation = ArrayTypeAnnotation;
type index_d$1_ArrowFunctionExpression = ArrowFunctionExpression;
type index_d$1_AssignmentExpression = AssignmentExpression;
type index_d$1_AssignmentPattern = AssignmentPattern;
type index_d$1_AwaitExpression = AwaitExpression;
declare const index_d$1_BINARY_OPERATORS: typeof BINARY_OPERATORS;
declare const index_d$1_BINARY_TYPES: typeof BINARY_TYPES;
declare const index_d$1_BLOCKPARENT_TYPES: typeof BLOCKPARENT_TYPES;
declare const index_d$1_BLOCK_TYPES: typeof BLOCK_TYPES;
declare const index_d$1_BOOLEAN_BINARY_OPERATORS: typeof BOOLEAN_BINARY_OPERATORS;
declare const index_d$1_BOOLEAN_NUMBER_BINARY_OPERATORS: typeof BOOLEAN_NUMBER_BINARY_OPERATORS;
declare const index_d$1_BOOLEAN_UNARY_OPERATORS: typeof BOOLEAN_UNARY_OPERATORS;
declare const index_d$1_BUILDER_KEYS: typeof BUILDER_KEYS;
type index_d$1_BigIntLiteral = BigIntLiteral;
type index_d$1_Binary = Binary;
type index_d$1_BinaryExpression = BinaryExpression;
type index_d$1_BindExpression = BindExpression;
type index_d$1_Block = Block;
type index_d$1_BlockParent = BlockParent;
type index_d$1_BlockStatement = BlockStatement;
type index_d$1_BooleanLiteral = BooleanLiteral;
type index_d$1_BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
type index_d$1_BooleanTypeAnnotation = BooleanTypeAnnotation;
type index_d$1_BreakStatement = BreakStatement;
declare const index_d$1_CLASS_TYPES: typeof CLASS_TYPES;
declare const index_d$1_COMMENT_KEYS: typeof COMMENT_KEYS;
declare const index_d$1_COMPARISON_BINARY_OPERATORS: typeof COMPARISON_BINARY_OPERATORS;
declare const index_d$1_COMPLETIONSTATEMENT_TYPES: typeof COMPLETIONSTATEMENT_TYPES;
declare const index_d$1_CONDITIONAL_TYPES: typeof CONDITIONAL_TYPES;
type index_d$1_CallExpression = CallExpression;
type index_d$1_CatchClause = CatchClause;
type index_d$1_Class = Class;
type index_d$1_ClassAccessorProperty = ClassAccessorProperty;
type index_d$1_ClassBody = ClassBody;
type index_d$1_ClassDeclaration = ClassDeclaration;
type index_d$1_ClassExpression = ClassExpression;
type index_d$1_ClassImplements = ClassImplements;
type index_d$1_ClassMethod = ClassMethod;
type index_d$1_ClassPrivateMethod = ClassPrivateMethod;
type index_d$1_ClassPrivateProperty = ClassPrivateProperty;
type index_d$1_ClassProperty = ClassProperty;
type index_d$1_Comment = Comment;
type index_d$1_CommentBlock = CommentBlock;
type index_d$1_CommentLine = CommentLine;
type index_d$1_CommentTypeShorthand = CommentTypeShorthand;
type index_d$1_CompletionStatement = CompletionStatement;
type index_d$1_Conditional = Conditional;
type index_d$1_ConditionalExpression = ConditionalExpression;
type index_d$1_ContinueStatement = ContinueStatement;
declare const index_d$1_DECLARATION_TYPES: typeof DECLARATION_TYPES;
declare const index_d$1_DEPRECATED_ALIASES: typeof DEPRECATED_ALIASES;
declare const index_d$1_DEPRECATED_KEYS: typeof DEPRECATED_KEYS;
type index_d$1_DebuggerStatement = DebuggerStatement;
type index_d$1_DecimalLiteral = DecimalLiteral;
type index_d$1_Declaration = Declaration;
type index_d$1_DeclareClass = DeclareClass;
type index_d$1_DeclareExportAllDeclaration = DeclareExportAllDeclaration;
type index_d$1_DeclareExportDeclaration = DeclareExportDeclaration;
type index_d$1_DeclareFunction = DeclareFunction;
type index_d$1_DeclareInterface = DeclareInterface;
type index_d$1_DeclareModule = DeclareModule;
type index_d$1_DeclareModuleExports = DeclareModuleExports;
type index_d$1_DeclareOpaqueType = DeclareOpaqueType;
type index_d$1_DeclareTypeAlias = DeclareTypeAlias;
type index_d$1_DeclareVariable = DeclareVariable;
type index_d$1_DeclaredPredicate = DeclaredPredicate;
type index_d$1_Decorator = Decorator;
type index_d$1_DeprecatedAliases = DeprecatedAliases;
type index_d$1_Directive = Directive;
type index_d$1_DirectiveLiteral = DirectiveLiteral;
type index_d$1_DoExpression = DoExpression;
type index_d$1_DoWhileStatement = DoWhileStatement;
declare const index_d$1_ENUMBODY_TYPES: typeof ENUMBODY_TYPES;
declare const index_d$1_ENUMMEMBER_TYPES: typeof ENUMMEMBER_TYPES;
declare const index_d$1_EQUALITY_BINARY_OPERATORS: typeof EQUALITY_BINARY_OPERATORS;
declare const index_d$1_EXPORTDECLARATION_TYPES: typeof EXPORTDECLARATION_TYPES;
declare const index_d$1_EXPRESSIONWRAPPER_TYPES: typeof EXPRESSIONWRAPPER_TYPES;
declare const index_d$1_EXPRESSION_TYPES: typeof EXPRESSION_TYPES;
type index_d$1_EmptyStatement = EmptyStatement;
type index_d$1_EmptyTypeAnnotation = EmptyTypeAnnotation;
type index_d$1_EnumBody = EnumBody;
type index_d$1_EnumBooleanBody = EnumBooleanBody;
type index_d$1_EnumBooleanMember = EnumBooleanMember;
type index_d$1_EnumDeclaration = EnumDeclaration;
type index_d$1_EnumDefaultedMember = EnumDefaultedMember;
type index_d$1_EnumMember = EnumMember;
type index_d$1_EnumNumberBody = EnumNumberBody;
type index_d$1_EnumNumberMember = EnumNumberMember;
type index_d$1_EnumStringBody = EnumStringBody;
type index_d$1_EnumStringMember = EnumStringMember;
type index_d$1_EnumSymbolBody = EnumSymbolBody;
type index_d$1_ExistsTypeAnnotation = ExistsTypeAnnotation;
type index_d$1_ExportAllDeclaration = ExportAllDeclaration;
type index_d$1_ExportDeclaration = ExportDeclaration;
type index_d$1_ExportDefaultDeclaration = ExportDefaultDeclaration;
type index_d$1_ExportDefaultSpecifier = ExportDefaultSpecifier;
type index_d$1_ExportNamedDeclaration = ExportNamedDeclaration;
type index_d$1_ExportNamespaceSpecifier = ExportNamespaceSpecifier;
type index_d$1_ExportSpecifier = ExportSpecifier;
type index_d$1_Expression = Expression;
type index_d$1_ExpressionStatement = ExpressionStatement;
type index_d$1_ExpressionWrapper = ExpressionWrapper;
declare const index_d$1_FLATTENABLE_KEYS: typeof FLATTENABLE_KEYS;
declare const index_d$1_FLIPPED_ALIAS_KEYS: typeof FLIPPED_ALIAS_KEYS;
declare const index_d$1_FLOWBASEANNOTATION_TYPES: typeof FLOWBASEANNOTATION_TYPES;
declare const index_d$1_FLOWDECLARATION_TYPES: typeof FLOWDECLARATION_TYPES;
declare const index_d$1_FLOWPREDICATE_TYPES: typeof FLOWPREDICATE_TYPES;
declare const index_d$1_FLOWTYPE_TYPES: typeof FLOWTYPE_TYPES;
declare const index_d$1_FLOW_TYPES: typeof FLOW_TYPES;
declare const index_d$1_FORXSTATEMENT_TYPES: typeof FORXSTATEMENT_TYPES;
declare const index_d$1_FOR_INIT_KEYS: typeof FOR_INIT_KEYS;
declare const index_d$1_FOR_TYPES: typeof FOR_TYPES;
declare const index_d$1_FUNCTIONPARAMETER_TYPES: typeof FUNCTIONPARAMETER_TYPES;
declare const index_d$1_FUNCTIONPARENT_TYPES: typeof FUNCTIONPARENT_TYPES;
declare const index_d$1_FUNCTION_TYPES: typeof FUNCTION_TYPES;
type index_d$1_FieldOptions = FieldOptions;
type index_d$1_File = File;
type index_d$1_Flow = Flow;
type index_d$1_FlowBaseAnnotation = FlowBaseAnnotation;
type index_d$1_FlowDeclaration = FlowDeclaration;
type index_d$1_FlowPredicate = FlowPredicate;
type index_d$1_FlowType = FlowType;
type index_d$1_For = For;
type index_d$1_ForInStatement = ForInStatement;
type index_d$1_ForOfStatement = ForOfStatement;
type index_d$1_ForStatement = ForStatement;
type index_d$1_ForXStatement = ForXStatement;
type index_d$1_Function = Function;
type index_d$1_FunctionDeclaration = FunctionDeclaration;
type index_d$1_FunctionExpression = FunctionExpression;
type index_d$1_FunctionParameter = FunctionParameter;
type index_d$1_FunctionParent = FunctionParent;
type index_d$1_FunctionTypeAnnotation = FunctionTypeAnnotation;
type index_d$1_FunctionTypeParam = FunctionTypeParam;
type index_d$1_GenericTypeAnnotation = GenericTypeAnnotation;
declare const index_d$1_IMMUTABLE_TYPES: typeof IMMUTABLE_TYPES;
declare const index_d$1_IMPORTOREXPORTDECLARATION_TYPES: typeof IMPORTOREXPORTDECLARATION_TYPES;
declare const index_d$1_INHERIT_KEYS: typeof INHERIT_KEYS;
type index_d$1_Identifier = Identifier;
type index_d$1_IfStatement = IfStatement;
type index_d$1_Immutable = Immutable;
type index_d$1_Import = Import;
type index_d$1_ImportAttribute = ImportAttribute;
type index_d$1_ImportDeclaration = ImportDeclaration;
type index_d$1_ImportDefaultSpecifier = ImportDefaultSpecifier;
type index_d$1_ImportExpression = ImportExpression;
type index_d$1_ImportNamespaceSpecifier = ImportNamespaceSpecifier;
type index_d$1_ImportOrExportDeclaration = ImportOrExportDeclaration;
type index_d$1_ImportSpecifier = ImportSpecifier;
type index_d$1_IndexedAccessType = IndexedAccessType;
type index_d$1_InferredPredicate = InferredPredicate;
type index_d$1_InterfaceDeclaration = InterfaceDeclaration;
type index_d$1_InterfaceExtends = InterfaceExtends;
type index_d$1_InterfaceTypeAnnotation = InterfaceTypeAnnotation;
type index_d$1_InterpreterDirective = InterpreterDirective;
type index_d$1_IntersectionTypeAnnotation = IntersectionTypeAnnotation;
type index_d$1_JSX = JSX;
type index_d$1_JSXAttribute = JSXAttribute;
type index_d$1_JSXClosingElement = JSXClosingElement;
type index_d$1_JSXClosingFragment = JSXClosingFragment;
type index_d$1_JSXElement = JSXElement;
type index_d$1_JSXEmptyExpression = JSXEmptyExpression;
type index_d$1_JSXExpressionContainer = JSXExpressionContainer;
type index_d$1_JSXFragment = JSXFragment;
type index_d$1_JSXIdentifier = JSXIdentifier;
type index_d$1_JSXMemberExpression = JSXMemberExpression;
type index_d$1_JSXNamespacedName = JSXNamespacedName;
type index_d$1_JSXOpeningElement = JSXOpeningElement;
type index_d$1_JSXOpeningFragment = JSXOpeningFragment;
type index_d$1_JSXSpreadAttribute = JSXSpreadAttribute;
type index_d$1_JSXSpreadChild = JSXSpreadChild;
type index_d$1_JSXText = JSXText;
declare const index_d$1_JSX_TYPES: typeof JSX_TYPES;
declare const index_d$1_LITERAL_TYPES: typeof LITERAL_TYPES;
declare const index_d$1_LOGICAL_OPERATORS: typeof LOGICAL_OPERATORS;
declare const index_d$1_LOOP_TYPES: typeof LOOP_TYPES;
declare const index_d$1_LVAL_TYPES: typeof LVAL_TYPES;
type index_d$1_LVal = LVal;
type index_d$1_LabeledStatement = LabeledStatement;
type index_d$1_Literal = Literal;
type index_d$1_LogicalExpression = LogicalExpression;
type index_d$1_Loop = Loop;
declare const index_d$1_METHOD_TYPES: typeof METHOD_TYPES;
declare const index_d$1_MISCELLANEOUS_TYPES: typeof MISCELLANEOUS_TYPES;
declare const index_d$1_MODULEDECLARATION_TYPES: typeof MODULEDECLARATION_TYPES;
declare const index_d$1_MODULESPECIFIER_TYPES: typeof MODULESPECIFIER_TYPES;
type index_d$1_MemberExpression = MemberExpression;
type index_d$1_MetaProperty = MetaProperty;
type index_d$1_Method = Method;
type index_d$1_Miscellaneous = Miscellaneous;
type index_d$1_MixedTypeAnnotation = MixedTypeAnnotation;
type index_d$1_ModuleDeclaration = ModuleDeclaration;
type index_d$1_ModuleExpression = ModuleExpression;
type index_d$1_ModuleSpecifier = ModuleSpecifier;
declare const index_d$1_NODE_FIELDS: typeof NODE_FIELDS;
declare const index_d$1_NODE_PARENT_VALIDATIONS: typeof NODE_PARENT_VALIDATIONS;
declare const index_d$1_NUMBER_BINARY_OPERATORS: typeof NUMBER_BINARY_OPERATORS;
declare const index_d$1_NUMBER_UNARY_OPERATORS: typeof NUMBER_UNARY_OPERATORS;
type index_d$1_NewExpression = NewExpression;
type index_d$1_Noop = Noop;
type index_d$1_NullLiteral = NullLiteral;
type index_d$1_NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
type index_d$1_NullableTypeAnnotation = NullableTypeAnnotation;
type index_d$1_NumberLiteralTypeAnnotation = NumberLiteralTypeAnnotation;
type index_d$1_NumberTypeAnnotation = NumberTypeAnnotation;
type index_d$1_NumericLiteral = NumericLiteral;
declare const index_d$1_OBJECTMEMBER_TYPES: typeof OBJECTMEMBER_TYPES;
type index_d$1_ObjectExpression = ObjectExpression;
type index_d$1_ObjectMember = ObjectMember;
type index_d$1_ObjectMethod = ObjectMethod;
type index_d$1_ObjectPattern = ObjectPattern;
type index_d$1_ObjectProperty = ObjectProperty;
type index_d$1_ObjectTypeAnnotation = ObjectTypeAnnotation;
type index_d$1_ObjectTypeCallProperty = ObjectTypeCallProperty;
type index_d$1_ObjectTypeIndexer = ObjectTypeIndexer;
type index_d$1_ObjectTypeInternalSlot = ObjectTypeInternalSlot;
type index_d$1_ObjectTypeProperty = ObjectTypeProperty;
type index_d$1_ObjectTypeSpreadProperty = ObjectTypeSpreadProperty;
type index_d$1_OpaqueType = OpaqueType;
type index_d$1_OptionalCallExpression = OptionalCallExpression;
type index_d$1_OptionalIndexedAccessType = OptionalIndexedAccessType;
type index_d$1_OptionalMemberExpression = OptionalMemberExpression;
declare const index_d$1_PATTERNLIKE_TYPES: typeof PATTERNLIKE_TYPES;
declare const index_d$1_PATTERN_TYPES: typeof PATTERN_TYPES;
declare const index_d$1_PLACEHOLDERS: typeof PLACEHOLDERS;
declare const index_d$1_PLACEHOLDERS_ALIAS: typeof PLACEHOLDERS_ALIAS;
declare const index_d$1_PLACEHOLDERS_FLIPPED_ALIAS: typeof PLACEHOLDERS_FLIPPED_ALIAS;
declare const index_d$1_PRIVATE_TYPES: typeof PRIVATE_TYPES;
declare const index_d$1_PROPERTY_TYPES: typeof PROPERTY_TYPES;
declare const index_d$1_PUREISH_TYPES: typeof PUREISH_TYPES;
type index_d$1_ParentMaps = ParentMaps;
type index_d$1_ParenthesizedExpression = ParenthesizedExpression;
type index_d$1_Pattern = Pattern;
type index_d$1_PatternLike = PatternLike;
type index_d$1_PipelineBareFunction = PipelineBareFunction;
type index_d$1_PipelinePrimaryTopicReference = PipelinePrimaryTopicReference;
type index_d$1_PipelineTopicExpression = PipelineTopicExpression;
type index_d$1_Placeholder = Placeholder;
type index_d$1_Private = Private;
type index_d$1_PrivateName = PrivateName;
type index_d$1_Program = Program;
type index_d$1_Property = Property;
type index_d$1_Pureish = Pureish;
type index_d$1_QualifiedTypeIdentifier = QualifiedTypeIdentifier;
type index_d$1_RecordExpression = RecordExpression;
type index_d$1_RegExpLiteral = RegExpLiteral;
type index_d$1_RestElement = RestElement;
type index_d$1_ReturnStatement = ReturnStatement;
declare const index_d$1_SCOPABLE_TYPES: typeof SCOPABLE_TYPES;
declare const index_d$1_STANDARDIZED_TYPES: typeof STANDARDIZED_TYPES;
declare const index_d$1_STATEMENT_OR_BLOCK_KEYS: typeof STATEMENT_OR_BLOCK_KEYS;
declare const index_d$1_STATEMENT_TYPES: typeof STATEMENT_TYPES;
declare const index_d$1_STRING_UNARY_OPERATORS: typeof STRING_UNARY_OPERATORS;
type index_d$1_Scopable = Scopable;
type index_d$1_SequenceExpression = SequenceExpression;
type index_d$1_SourceLocation = SourceLocation;
type index_d$1_SpreadElement = SpreadElement;
type index_d$1_Standardized = Standardized;
type index_d$1_Statement = Statement;
type index_d$1_StaticBlock = StaticBlock;
type index_d$1_StringLiteral = StringLiteral;
type index_d$1_StringLiteralTypeAnnotation = StringLiteralTypeAnnotation;
type index_d$1_StringTypeAnnotation = StringTypeAnnotation;
type index_d$1_Super = Super;
type index_d$1_SwitchCase = SwitchCase;
type index_d$1_SwitchStatement = SwitchStatement;
type index_d$1_SymbolTypeAnnotation = SymbolTypeAnnotation;
declare const index_d$1_TERMINATORLESS_TYPES: typeof TERMINATORLESS_TYPES;
type index_d$1_TSAnyKeyword = TSAnyKeyword;
type index_d$1_TSArrayType = TSArrayType;
type index_d$1_TSAsExpression = TSAsExpression;
declare const index_d$1_TSBASETYPE_TYPES: typeof TSBASETYPE_TYPES;
type index_d$1_TSBaseType = TSBaseType;
type index_d$1_TSBigIntKeyword = TSBigIntKeyword;
type index_d$1_TSBooleanKeyword = TSBooleanKeyword;
type index_d$1_TSCallSignatureDeclaration = TSCallSignatureDeclaration;
type index_d$1_TSConditionalType = TSConditionalType;
type index_d$1_TSConstructSignatureDeclaration = TSConstructSignatureDeclaration;
type index_d$1_TSConstructorType = TSConstructorType;
type index_d$1_TSDeclareFunction = TSDeclareFunction;
type index_d$1_TSDeclareMethod = TSDeclareMethod;
declare const index_d$1_TSENTITYNAME_TYPES: typeof TSENTITYNAME_TYPES;
type index_d$1_TSEntityName = TSEntityName;
type index_d$1_TSEnumBody = TSEnumBody;
type index_d$1_TSEnumDeclaration = TSEnumDeclaration;
type index_d$1_TSEnumMember = TSEnumMember;
type index_d$1_TSExportAssignment = TSExportAssignment;
type index_d$1_TSExpressionWithTypeArguments = TSExpressionWithTypeArguments;
type index_d$1_TSExternalModuleReference = TSExternalModuleReference;
type index_d$1_TSFunctionType = TSFunctionType;
type index_d$1_TSImportEqualsDeclaration = TSImportEqualsDeclaration;
type index_d$1_TSImportType = TSImportType;
type index_d$1_TSIndexSignature = TSIndexSignature;
type index_d$1_TSIndexedAccessType = TSIndexedAccessType;
type index_d$1_TSInferType = TSInferType;
type index_d$1_TSInstantiationExpression = TSInstantiationExpression;
type index_d$1_TSInterfaceBody = TSInterfaceBody;
type index_d$1_TSInterfaceDeclaration = TSInterfaceDeclaration;
type index_d$1_TSIntersectionType = TSIntersectionType;
type index_d$1_TSIntrinsicKeyword = TSIntrinsicKeyword;
type index_d$1_TSLiteralType = TSLiteralType;
type index_d$1_TSMappedType = TSMappedType;
type index_d$1_TSMethodSignature = TSMethodSignature;
type index_d$1_TSModuleBlock = TSModuleBlock;
type index_d$1_TSModuleDeclaration = TSModuleDeclaration;
type index_d$1_TSNamedTupleMember = TSNamedTupleMember;
type index_d$1_TSNamespaceExportDeclaration = TSNamespaceExportDeclaration;
type index_d$1_TSNeverKeyword = TSNeverKeyword;
type index_d$1_TSNonNullExpression = TSNonNullExpression;
type index_d$1_TSNullKeyword = TSNullKeyword;
type index_d$1_TSNumberKeyword = TSNumberKeyword;
type index_d$1_TSObjectKeyword = TSObjectKeyword;
type index_d$1_TSOptionalType = TSOptionalType;
type index_d$1_TSParameterProperty = TSParameterProperty;
type index_d$1_TSParenthesizedType = TSParenthesizedType;
type index_d$1_TSPropertySignature = TSPropertySignature;
type index_d$1_TSQualifiedName = TSQualifiedName;
type index_d$1_TSRestType = TSRestType;
type index_d$1_TSSatisfiesExpression = TSSatisfiesExpression;
type index_d$1_TSStringKeyword = TSStringKeyword;
type index_d$1_TSSymbolKeyword = TSSymbolKeyword;
declare const index_d$1_TSTYPEELEMENT_TYPES: typeof TSTYPEELEMENT_TYPES;
declare const index_d$1_TSTYPE_TYPES: typeof TSTYPE_TYPES;
type index_d$1_TSTemplateLiteralType = TSTemplateLiteralType;
type index_d$1_TSThisType = TSThisType;
type index_d$1_TSTupleType = TSTupleType;
type index_d$1_TSType = TSType;
type index_d$1_TSTypeAliasDeclaration = TSTypeAliasDeclaration;
type index_d$1_TSTypeAnnotation = TSTypeAnnotation;
type index_d$1_TSTypeAssertion = TSTypeAssertion;
type index_d$1_TSTypeElement = TSTypeElement;
type index_d$1_TSTypeLiteral = TSTypeLiteral;
type index_d$1_TSTypeOperator = TSTypeOperator;
type index_d$1_TSTypeParameter = TSTypeParameter;
type index_d$1_TSTypeParameterDeclaration = TSTypeParameterDeclaration;
type index_d$1_TSTypeParameterInstantiation = TSTypeParameterInstantiation;
type index_d$1_TSTypePredicate = TSTypePredicate;
type index_d$1_TSTypeQuery = TSTypeQuery;
type index_d$1_TSTypeReference = TSTypeReference;
type index_d$1_TSUndefinedKeyword = TSUndefinedKeyword;
type index_d$1_TSUnionType = TSUnionType;
type index_d$1_TSUnknownKeyword = TSUnknownKeyword;
type index_d$1_TSVoidKeyword = TSVoidKeyword;
declare const index_d$1_TYPES: typeof TYPES;
declare const index_d$1_TYPESCRIPT_TYPES: typeof TYPESCRIPT_TYPES;
type index_d$1_TaggedTemplateExpression = TaggedTemplateExpression;
type index_d$1_TemplateElement = TemplateElement;
type index_d$1_TemplateLiteral = TemplateLiteral;
type index_d$1_Terminatorless = Terminatorless;
type index_d$1_ThisExpression = ThisExpression;
type index_d$1_ThisTypeAnnotation = ThisTypeAnnotation;
type index_d$1_ThrowStatement = ThrowStatement;
type index_d$1_TopicReference = TopicReference;
type index_d$1_TraversalAncestors = TraversalAncestors;
type index_d$1_TraversalHandler<T> = TraversalHandler<T>;
type index_d$1_TraversalHandlers<T> = TraversalHandlers<T>;
type index_d$1_TryStatement = TryStatement;
type index_d$1_TupleExpression = TupleExpression;
type index_d$1_TupleTypeAnnotation = TupleTypeAnnotation;
type index_d$1_TypeAlias = TypeAlias;
type index_d$1_TypeAnnotation = TypeAnnotation;
type index_d$1_TypeCastExpression = TypeCastExpression;
type index_d$1_TypeParameter = TypeParameter;
type index_d$1_TypeParameterDeclaration = TypeParameterDeclaration;
type index_d$1_TypeParameterInstantiation = TypeParameterInstantiation;
type index_d$1_TypeScript = TypeScript;
type index_d$1_TypeofTypeAnnotation = TypeofTypeAnnotation;
declare const index_d$1_UNARYLIKE_TYPES: typeof UNARYLIKE_TYPES;
declare const index_d$1_UNARY_OPERATORS: typeof UNARY_OPERATORS;
declare const index_d$1_UPDATE_OPERATORS: typeof UPDATE_OPERATORS;
declare const index_d$1_USERWHITESPACABLE_TYPES: typeof USERWHITESPACABLE_TYPES;
type index_d$1_UnaryExpression = UnaryExpression;
type index_d$1_UnaryLike = UnaryLike;
type index_d$1_UnionTypeAnnotation = UnionTypeAnnotation;
type index_d$1_UpdateExpression = UpdateExpression;
type index_d$1_UserWhitespacable = UserWhitespacable;
type index_d$1_V8IntrinsicIdentifier = V8IntrinsicIdentifier;
declare const index_d$1_VISITOR_KEYS: typeof VISITOR_KEYS;
type index_d$1_VariableDeclaration = VariableDeclaration;
type index_d$1_VariableDeclarator = VariableDeclarator;
type index_d$1_Variance = Variance;
type index_d$1_VoidPattern = VoidPattern;
type index_d$1_VoidTypeAnnotation = VoidTypeAnnotation;
declare const index_d$1_WHILE_TYPES: typeof WHILE_TYPES;
type index_d$1_While = While;
type index_d$1_WhileStatement = WhileStatement;
type index_d$1_WithStatement = WithStatement;
type index_d$1_YieldExpression = YieldExpression;
declare const index_d$1_addComment: typeof addComment;
declare const index_d$1_addComments: typeof addComments;
declare const index_d$1_anyTypeAnnotation: typeof anyTypeAnnotation;
declare const index_d$1_appendToMemberExpression: typeof appendToMemberExpression;
declare const index_d$1_argumentPlaceholder: typeof argumentPlaceholder;
declare const index_d$1_arrayExpression: typeof arrayExpression;
declare const index_d$1_arrayPattern: typeof arrayPattern;
declare const index_d$1_arrayTypeAnnotation: typeof arrayTypeAnnotation;
declare const index_d$1_arrowFunctionExpression: typeof arrowFunctionExpression;
declare const index_d$1_assertAccessor: typeof assertAccessor;
declare const index_d$1_assertAnyTypeAnnotation: typeof assertAnyTypeAnnotation;
declare const index_d$1_assertArgumentPlaceholder: typeof assertArgumentPlaceholder;
declare const index_d$1_assertArrayExpression: typeof assertArrayExpression;
declare const index_d$1_assertArrayPattern: typeof assertArrayPattern;
declare const index_d$1_assertArrayTypeAnnotation: typeof assertArrayTypeAnnotation;
declare const index_d$1_assertArrowFunctionExpression: typeof assertArrowFunctionExpression;
declare const index_d$1_assertAssignmentExpression: typeof assertAssignmentExpression;
declare const index_d$1_assertAssignmentPattern: typeof assertAssignmentPattern;
declare const index_d$1_assertAwaitExpression: typeof assertAwaitExpression;
declare const index_d$1_assertBigIntLiteral: typeof assertBigIntLiteral;
declare const index_d$1_assertBinary: typeof assertBinary;
declare const index_d$1_assertBinaryExpression: typeof assertBinaryExpression;
declare const index_d$1_assertBindExpression: typeof assertBindExpression;
declare const index_d$1_assertBlock: typeof assertBlock;
declare const index_d$1_assertBlockParent: typeof assertBlockParent;
declare const index_d$1_assertBlockStatement: typeof assertBlockStatement;
declare const index_d$1_assertBooleanLiteral: typeof assertBooleanLiteral;
declare const index_d$1_assertBooleanLiteralTypeAnnotation: typeof assertBooleanLiteralTypeAnnotation;
declare const index_d$1_assertBooleanTypeAnnotation: typeof assertBooleanTypeAnnotation;
declare const index_d$1_assertBreakStatement: typeof assertBreakStatement;
declare const index_d$1_assertCallExpression: typeof assertCallExpression;
declare const index_d$1_assertCatchClause: typeof assertCatchClause;
declare const index_d$1_assertClass: typeof assertClass;
declare const index_d$1_assertClassAccessorProperty: typeof assertClassAccessorProperty;
declare const index_d$1_assertClassBody: typeof assertClassBody;
declare const index_d$1_assertClassDeclaration: typeof assertClassDeclaration;
declare const index_d$1_assertClassExpression: typeof assertClassExpression;
declare const index_d$1_assertClassImplements: typeof assertClassImplements;
declare const index_d$1_assertClassMethod: typeof assertClassMethod;
declare const index_d$1_assertClassPrivateMethod: typeof assertClassPrivateMethod;
declare const index_d$1_assertClassPrivateProperty: typeof assertClassPrivateProperty;
declare const index_d$1_assertClassProperty: typeof assertClassProperty;
declare const index_d$1_assertCompletionStatement: typeof assertCompletionStatement;
declare const index_d$1_assertConditional: typeof assertConditional;
declare const index_d$1_assertConditionalExpression: typeof assertConditionalExpression;
declare const index_d$1_assertContinueStatement: typeof assertContinueStatement;
declare const index_d$1_assertDebuggerStatement: typeof assertDebuggerStatement;
declare const index_d$1_assertDecimalLiteral: typeof assertDecimalLiteral;
declare const index_d$1_assertDeclaration: typeof assertDeclaration;
declare const index_d$1_assertDeclareClass: typeof assertDeclareClass;
declare const index_d$1_assertDeclareExportAllDeclaration: typeof assertDeclareExportAllDeclaration;
declare const index_d$1_assertDeclareExportDeclaration: typeof assertDeclareExportDeclaration;
declare const index_d$1_assertDeclareFunction: typeof assertDeclareFunction;
declare const index_d$1_assertDeclareInterface: typeof assertDeclareInterface;
declare const index_d$1_assertDeclareModule: typeof assertDeclareModule;
declare const index_d$1_assertDeclareModuleExports: typeof assertDeclareModuleExports;
declare const index_d$1_assertDeclareOpaqueType: typeof assertDeclareOpaqueType;
declare const index_d$1_assertDeclareTypeAlias: typeof assertDeclareTypeAlias;
declare const index_d$1_assertDeclareVariable: typeof assertDeclareVariable;
declare const index_d$1_assertDeclaredPredicate: typeof assertDeclaredPredicate;
declare const index_d$1_assertDecorator: typeof assertDecorator;
declare const index_d$1_assertDirective: typeof assertDirective;
declare const index_d$1_assertDirectiveLiteral: typeof assertDirectiveLiteral;
declare const index_d$1_assertDoExpression: typeof assertDoExpression;
declare const index_d$1_assertDoWhileStatement: typeof assertDoWhileStatement;
declare const index_d$1_assertEmptyStatement: typeof assertEmptyStatement;
declare const index_d$1_assertEmptyTypeAnnotation: typeof assertEmptyTypeAnnotation;
declare const index_d$1_assertEnumBody: typeof assertEnumBody;
declare const index_d$1_assertEnumBooleanBody: typeof assertEnumBooleanBody;
declare const index_d$1_assertEnumBooleanMember: typeof assertEnumBooleanMember;
declare const index_d$1_assertEnumDeclaration: typeof assertEnumDeclaration;
declare const index_d$1_assertEnumDefaultedMember: typeof assertEnumDefaultedMember;
declare const index_d$1_assertEnumMember: typeof assertEnumMember;
declare const index_d$1_assertEnumNumberBody: typeof assertEnumNumberBody;
declare const index_d$1_assertEnumNumberMember: typeof assertEnumNumberMember;
declare const index_d$1_assertEnumStringBody: typeof assertEnumStringBody;
declare const index_d$1_assertEnumStringMember: typeof assertEnumStringMember;
declare const index_d$1_assertEnumSymbolBody: typeof assertEnumSymbolBody;
declare const index_d$1_assertExistsTypeAnnotation: typeof assertExistsTypeAnnotation;
declare const index_d$1_assertExportAllDeclaration: typeof assertExportAllDeclaration;
declare const index_d$1_assertExportDeclaration: typeof assertExportDeclaration;
declare const index_d$1_assertExportDefaultDeclaration: typeof assertExportDefaultDeclaration;
declare const index_d$1_assertExportDefaultSpecifier: typeof assertExportDefaultSpecifier;
declare const index_d$1_assertExportNamedDeclaration: typeof assertExportNamedDeclaration;
declare const index_d$1_assertExportNamespaceSpecifier: typeof assertExportNamespaceSpecifier;
declare const index_d$1_assertExportSpecifier: typeof assertExportSpecifier;
declare const index_d$1_assertExpression: typeof assertExpression;
declare const index_d$1_assertExpressionStatement: typeof assertExpressionStatement;
declare const index_d$1_assertExpressionWrapper: typeof assertExpressionWrapper;
declare const index_d$1_assertFile: typeof assertFile;
declare const index_d$1_assertFlow: typeof assertFlow;
declare const index_d$1_assertFlowBaseAnnotation: typeof assertFlowBaseAnnotation;
declare const index_d$1_assertFlowDeclaration: typeof assertFlowDeclaration;
declare const index_d$1_assertFlowPredicate: typeof assertFlowPredicate;
declare const index_d$1_assertFlowType: typeof assertFlowType;
declare const index_d$1_assertFor: typeof assertFor;
declare const index_d$1_assertForInStatement: typeof assertForInStatement;
declare const index_d$1_assertForOfStatement: typeof assertForOfStatement;
declare const index_d$1_assertForStatement: typeof assertForStatement;
declare const index_d$1_assertForXStatement: typeof assertForXStatement;
declare const index_d$1_assertFunction: typeof assertFunction;
declare const index_d$1_assertFunctionDeclaration: typeof assertFunctionDeclaration;
declare const index_d$1_assertFunctionExpression: typeof assertFunctionExpression;
declare const index_d$1_assertFunctionParameter: typeof assertFunctionParameter;
declare const index_d$1_assertFunctionParent: typeof assertFunctionParent;
declare const index_d$1_assertFunctionTypeAnnotation: typeof assertFunctionTypeAnnotation;
declare const index_d$1_assertFunctionTypeParam: typeof assertFunctionTypeParam;
declare const index_d$1_assertGenericTypeAnnotation: typeof assertGenericTypeAnnotation;
declare const index_d$1_assertIdentifier: typeof assertIdentifier;
declare const index_d$1_assertIfStatement: typeof assertIfStatement;
declare const index_d$1_assertImmutable: typeof assertImmutable;
declare const index_d$1_assertImport: typeof assertImport;
declare const index_d$1_assertImportAttribute: typeof assertImportAttribute;
declare const index_d$1_assertImportDeclaration: typeof assertImportDeclaration;
declare const index_d$1_assertImportDefaultSpecifier: typeof assertImportDefaultSpecifier;
declare const index_d$1_assertImportExpression: typeof assertImportExpression;
declare const index_d$1_assertImportNamespaceSpecifier: typeof assertImportNamespaceSpecifier;
declare const index_d$1_assertImportOrExportDeclaration: typeof assertImportOrExportDeclaration;
declare const index_d$1_assertImportSpecifier: typeof assertImportSpecifier;
declare const index_d$1_assertIndexedAccessType: typeof assertIndexedAccessType;
declare const index_d$1_assertInferredPredicate: typeof assertInferredPredicate;
declare const index_d$1_assertInterfaceDeclaration: typeof assertInterfaceDeclaration;
declare const index_d$1_assertInterfaceExtends: typeof assertInterfaceExtends;
declare const index_d$1_assertInterfaceTypeAnnotation: typeof assertInterfaceTypeAnnotation;
declare const index_d$1_assertInterpreterDirective: typeof assertInterpreterDirective;
declare const index_d$1_assertIntersectionTypeAnnotation: typeof assertIntersectionTypeAnnotation;
declare const index_d$1_assertJSX: typeof assertJSX;
declare const index_d$1_assertJSXAttribute: typeof assertJSXAttribute;
declare const index_d$1_assertJSXClosingElement: typeof assertJSXClosingElement;
declare const index_d$1_assertJSXClosingFragment: typeof assertJSXClosingFragment;
declare const index_d$1_assertJSXElement: typeof assertJSXElement;
declare const index_d$1_assertJSXEmptyExpression: typeof assertJSXEmptyExpression;
declare const index_d$1_assertJSXExpressionContainer: typeof assertJSXExpressionContainer;
declare const index_d$1_assertJSXFragment: typeof assertJSXFragment;
declare const index_d$1_assertJSXIdentifier: typeof assertJSXIdentifier;
declare const index_d$1_assertJSXMemberExpression: typeof assertJSXMemberExpression;
declare const index_d$1_assertJSXNamespacedName: typeof assertJSXNamespacedName;
declare const index_d$1_assertJSXOpeningElement: typeof assertJSXOpeningElement;
declare const index_d$1_assertJSXOpeningFragment: typeof assertJSXOpeningFragment;
declare const index_d$1_assertJSXSpreadAttribute: typeof assertJSXSpreadAttribute;
declare const index_d$1_assertJSXSpreadChild: typeof assertJSXSpreadChild;
declare const index_d$1_assertJSXText: typeof assertJSXText;
declare const index_d$1_assertLVal: typeof assertLVal;
declare const index_d$1_assertLabeledStatement: typeof assertLabeledStatement;
declare const index_d$1_assertLiteral: typeof assertLiteral;
declare const index_d$1_assertLogicalExpression: typeof assertLogicalExpression;
declare const index_d$1_assertLoop: typeof assertLoop;
declare const index_d$1_assertMemberExpression: typeof assertMemberExpression;
declare const index_d$1_assertMetaProperty: typeof assertMetaProperty;
declare const index_d$1_assertMethod: typeof assertMethod;
declare const index_d$1_assertMiscellaneous: typeof assertMiscellaneous;
declare const index_d$1_assertMixedTypeAnnotation: typeof assertMixedTypeAnnotation;
declare const index_d$1_assertModuleDeclaration: typeof assertModuleDeclaration;
declare const index_d$1_assertModuleExpression: typeof assertModuleExpression;
declare const index_d$1_assertModuleSpecifier: typeof assertModuleSpecifier;
declare const index_d$1_assertNewExpression: typeof assertNewExpression;
declare const index_d$1_assertNode: typeof assertNode;
declare const index_d$1_assertNoop: typeof assertNoop;
declare const index_d$1_assertNullLiteral: typeof assertNullLiteral;
declare const index_d$1_assertNullLiteralTypeAnnotation: typeof assertNullLiteralTypeAnnotation;
declare const index_d$1_assertNullableTypeAnnotation: typeof assertNullableTypeAnnotation;
declare const index_d$1_assertNumberLiteral: typeof assertNumberLiteral;
declare const index_d$1_assertNumberLiteralTypeAnnotation: typeof assertNumberLiteralTypeAnnotation;
declare const index_d$1_assertNumberTypeAnnotation: typeof assertNumberTypeAnnotation;
declare const index_d$1_assertNumericLiteral: typeof assertNumericLiteral;
declare const index_d$1_assertObjectExpression: typeof assertObjectExpression;
declare const index_d$1_assertObjectMember: typeof assertObjectMember;
declare const index_d$1_assertObjectMethod: typeof assertObjectMethod;
declare const index_d$1_assertObjectPattern: typeof assertObjectPattern;
declare const index_d$1_assertObjectProperty: typeof assertObjectProperty;
declare const index_d$1_assertObjectTypeAnnotation: typeof assertObjectTypeAnnotation;
declare const index_d$1_assertObjectTypeCallProperty: typeof assertObjectTypeCallProperty;
declare const index_d$1_assertObjectTypeIndexer: typeof assertObjectTypeIndexer;
declare const index_d$1_assertObjectTypeInternalSlot: typeof assertObjectTypeInternalSlot;
declare const index_d$1_assertObjectTypeProperty: typeof assertObjectTypeProperty;
declare const index_d$1_assertObjectTypeSpreadProperty: typeof assertObjectTypeSpreadProperty;
declare const index_d$1_assertOpaqueType: typeof assertOpaqueType;
declare const index_d$1_assertOptionalCallExpression: typeof assertOptionalCallExpression;
declare const index_d$1_assertOptionalIndexedAccessType: typeof assertOptionalIndexedAccessType;
declare const index_d$1_assertOptionalMemberExpression: typeof assertOptionalMemberExpression;
declare const index_d$1_assertParenthesizedExpression: typeof assertParenthesizedExpression;
declare const index_d$1_assertPattern: typeof assertPattern;
declare const index_d$1_assertPatternLike: typeof assertPatternLike;
declare const index_d$1_assertPipelineBareFunction: typeof assertPipelineBareFunction;
declare const index_d$1_assertPipelinePrimaryTopicReference: typeof assertPipelinePrimaryTopicReference;
declare const index_d$1_assertPipelineTopicExpression: typeof assertPipelineTopicExpression;
declare const index_d$1_assertPlaceholder: typeof assertPlaceholder;
declare const index_d$1_assertPrivate: typeof assertPrivate;
declare const index_d$1_assertPrivateName: typeof assertPrivateName;
declare const index_d$1_assertProgram: typeof assertProgram;
declare const index_d$1_assertProperty: typeof assertProperty;
declare const index_d$1_assertPureish: typeof assertPureish;
declare const index_d$1_assertQualifiedTypeIdentifier: typeof assertQualifiedTypeIdentifier;
declare const index_d$1_assertRecordExpression: typeof assertRecordExpression;
declare const index_d$1_assertRegExpLiteral: typeof assertRegExpLiteral;
declare const index_d$1_assertRegexLiteral: typeof assertRegexLiteral;
declare const index_d$1_assertRestElement: typeof assertRestElement;
declare const index_d$1_assertRestProperty: typeof assertRestProperty;
declare const index_d$1_assertReturnStatement: typeof assertReturnStatement;
declare const index_d$1_assertScopable: typeof assertScopable;
declare const index_d$1_assertSequenceExpression: typeof assertSequenceExpression;
declare const index_d$1_assertSpreadElement: typeof assertSpreadElement;
declare const index_d$1_assertSpreadProperty: typeof assertSpreadProperty;
declare const index_d$1_assertStandardized: typeof assertStandardized;
declare const index_d$1_assertStatement: typeof assertStatement;
declare const index_d$1_assertStaticBlock: typeof assertStaticBlock;
declare const index_d$1_assertStringLiteral: typeof assertStringLiteral;
declare const index_d$1_assertStringLiteralTypeAnnotation: typeof assertStringLiteralTypeAnnotation;
declare const index_d$1_assertStringTypeAnnotation: typeof assertStringTypeAnnotation;
declare const index_d$1_assertSuper: typeof assertSuper;
declare const index_d$1_assertSwitchCase: typeof assertSwitchCase;
declare const index_d$1_assertSwitchStatement: typeof assertSwitchStatement;
declare const index_d$1_assertSymbolTypeAnnotation: typeof assertSymbolTypeAnnotation;
declare const index_d$1_assertTSAnyKeyword: typeof assertTSAnyKeyword;
declare const index_d$1_assertTSArrayType: typeof assertTSArrayType;
declare const index_d$1_assertTSAsExpression: typeof assertTSAsExpression;
declare const index_d$1_assertTSBaseType: typeof assertTSBaseType;
declare const index_d$1_assertTSBigIntKeyword: typeof assertTSBigIntKeyword;
declare const index_d$1_assertTSBooleanKeyword: typeof assertTSBooleanKeyword;
declare const index_d$1_assertTSCallSignatureDeclaration: typeof assertTSCallSignatureDeclaration;
declare const index_d$1_assertTSConditionalType: typeof assertTSConditionalType;
declare const index_d$1_assertTSConstructSignatureDeclaration: typeof assertTSConstructSignatureDeclaration;
declare const index_d$1_assertTSConstructorType: typeof assertTSConstructorType;
declare const index_d$1_assertTSDeclareFunction: typeof assertTSDeclareFunction;
declare const index_d$1_assertTSDeclareMethod: typeof assertTSDeclareMethod;
declare const index_d$1_assertTSEntityName: typeof assertTSEntityName;
declare const index_d$1_assertTSEnumBody: typeof assertTSEnumBody;
declare const index_d$1_assertTSEnumDeclaration: typeof assertTSEnumDeclaration;
declare const index_d$1_assertTSEnumMember: typeof assertTSEnumMember;
declare const index_d$1_assertTSExportAssignment: typeof assertTSExportAssignment;
declare const index_d$1_assertTSExpressionWithTypeArguments: typeof assertTSExpressionWithTypeArguments;
declare const index_d$1_assertTSExternalModuleReference: typeof assertTSExternalModuleReference;
declare const index_d$1_assertTSFunctionType: typeof assertTSFunctionType;
declare const index_d$1_assertTSImportEqualsDeclaration: typeof assertTSImportEqualsDeclaration;
declare const index_d$1_assertTSImportType: typeof assertTSImportType;
declare const index_d$1_assertTSIndexSignature: typeof assertTSIndexSignature;
declare const index_d$1_assertTSIndexedAccessType: typeof assertTSIndexedAccessType;
declare const index_d$1_assertTSInferType: typeof assertTSInferType;
declare const index_d$1_assertTSInstantiationExpression: typeof assertTSInstantiationExpression;
declare const index_d$1_assertTSInterfaceBody: typeof assertTSInterfaceBody;
declare const index_d$1_assertTSInterfaceDeclaration: typeof assertTSInterfaceDeclaration;
declare const index_d$1_assertTSIntersectionType: typeof assertTSIntersectionType;
declare const index_d$1_assertTSIntrinsicKeyword: typeof assertTSIntrinsicKeyword;
declare const index_d$1_assertTSLiteralType: typeof assertTSLiteralType;
declare const index_d$1_assertTSMappedType: typeof assertTSMappedType;
declare const index_d$1_assertTSMethodSignature: typeof assertTSMethodSignature;
declare const index_d$1_assertTSModuleBlock: typeof assertTSModuleBlock;
declare const index_d$1_assertTSModuleDeclaration: typeof assertTSModuleDeclaration;
declare const index_d$1_assertTSNamedTupleMember: typeof assertTSNamedTupleMember;
declare const index_d$1_assertTSNamespaceExportDeclaration: typeof assertTSNamespaceExportDeclaration;
declare const index_d$1_assertTSNeverKeyword: typeof assertTSNeverKeyword;
declare const index_d$1_assertTSNonNullExpression: typeof assertTSNonNullExpression;
declare const index_d$1_assertTSNullKeyword: typeof assertTSNullKeyword;
declare const index_d$1_assertTSNumberKeyword: typeof assertTSNumberKeyword;
declare const index_d$1_assertTSObjectKeyword: typeof assertTSObjectKeyword;
declare const index_d$1_assertTSOptionalType: typeof assertTSOptionalType;
declare const index_d$1_assertTSParameterProperty: typeof assertTSParameterProperty;
declare const index_d$1_assertTSParenthesizedType: typeof assertTSParenthesizedType;
declare const index_d$1_assertTSPropertySignature: typeof assertTSPropertySignature;
declare const index_d$1_assertTSQualifiedName: typeof assertTSQualifiedName;
declare const index_d$1_assertTSRestType: typeof assertTSRestType;
declare const index_d$1_assertTSSatisfiesExpression: typeof assertTSSatisfiesExpression;
declare const index_d$1_assertTSStringKeyword: typeof assertTSStringKeyword;
declare const index_d$1_assertTSSymbolKeyword: typeof assertTSSymbolKeyword;
declare const index_d$1_assertTSTemplateLiteralType: typeof assertTSTemplateLiteralType;
declare const index_d$1_assertTSThisType: typeof assertTSThisType;
declare const index_d$1_assertTSTupleType: typeof assertTSTupleType;
declare const index_d$1_assertTSType: typeof assertTSType;
declare const index_d$1_assertTSTypeAliasDeclaration: typeof assertTSTypeAliasDeclaration;
declare const index_d$1_assertTSTypeAnnotation: typeof assertTSTypeAnnotation;
declare const index_d$1_assertTSTypeAssertion: typeof assertTSTypeAssertion;
declare const index_d$1_assertTSTypeElement: typeof assertTSTypeElement;
declare const index_d$1_assertTSTypeLiteral: typeof assertTSTypeLiteral;
declare const index_d$1_assertTSTypeOperator: typeof assertTSTypeOperator;
declare const index_d$1_assertTSTypeParameter: typeof assertTSTypeParameter;
declare const index_d$1_assertTSTypeParameterDeclaration: typeof assertTSTypeParameterDeclaration;
declare const index_d$1_assertTSTypeParameterInstantiation: typeof assertTSTypeParameterInstantiation;
declare const index_d$1_assertTSTypePredicate: typeof assertTSTypePredicate;
declare const index_d$1_assertTSTypeQuery: typeof assertTSTypeQuery;
declare const index_d$1_assertTSTypeReference: typeof assertTSTypeReference;
declare const index_d$1_assertTSUndefinedKeyword: typeof assertTSUndefinedKeyword;
declare const index_d$1_assertTSUnionType: typeof assertTSUnionType;
declare const index_d$1_assertTSUnknownKeyword: typeof assertTSUnknownKeyword;
declare const index_d$1_assertTSVoidKeyword: typeof assertTSVoidKeyword;
declare const index_d$1_assertTaggedTemplateExpression: typeof assertTaggedTemplateExpression;
declare const index_d$1_assertTemplateElement: typeof assertTemplateElement;
declare const index_d$1_assertTemplateLiteral: typeof assertTemplateLiteral;
declare const index_d$1_assertTerminatorless: typeof assertTerminatorless;
declare const index_d$1_assertThisExpression: typeof assertThisExpression;
declare const index_d$1_assertThisTypeAnnotation: typeof assertThisTypeAnnotation;
declare const index_d$1_assertThrowStatement: typeof assertThrowStatement;
declare const index_d$1_assertTopicReference: typeof assertTopicReference;
declare const index_d$1_assertTryStatement: typeof assertTryStatement;
declare const index_d$1_assertTupleExpression: typeof assertTupleExpression;
declare const index_d$1_assertTupleTypeAnnotation: typeof assertTupleTypeAnnotation;
declare const index_d$1_assertTypeAlias: typeof assertTypeAlias;
declare const index_d$1_assertTypeAnnotation: typeof assertTypeAnnotation;
declare const index_d$1_assertTypeCastExpression: typeof assertTypeCastExpression;
declare const index_d$1_assertTypeParameter: typeof assertTypeParameter;
declare const index_d$1_assertTypeParameterDeclaration: typeof assertTypeParameterDeclaration;
declare const index_d$1_assertTypeParameterInstantiation: typeof assertTypeParameterInstantiation;
declare const index_d$1_assertTypeScript: typeof assertTypeScript;
declare const index_d$1_assertTypeofTypeAnnotation: typeof assertTypeofTypeAnnotation;
declare const index_d$1_assertUnaryExpression: typeof assertUnaryExpression;
declare const index_d$1_assertUnaryLike: typeof assertUnaryLike;
declare const index_d$1_assertUnionTypeAnnotation: typeof assertUnionTypeAnnotation;
declare const index_d$1_assertUpdateExpression: typeof assertUpdateExpression;
declare const index_d$1_assertUserWhitespacable: typeof assertUserWhitespacable;
declare const index_d$1_assertV8IntrinsicIdentifier: typeof assertV8IntrinsicIdentifier;
declare const index_d$1_assertVariableDeclaration: typeof assertVariableDeclaration;
declare const index_d$1_assertVariableDeclarator: typeof assertVariableDeclarator;
declare const index_d$1_assertVariance: typeof assertVariance;
declare const index_d$1_assertVoidPattern: typeof assertVoidPattern;
declare const index_d$1_assertVoidTypeAnnotation: typeof assertVoidTypeAnnotation;
declare const index_d$1_assertWhile: typeof assertWhile;
declare const index_d$1_assertWhileStatement: typeof assertWhileStatement;
declare const index_d$1_assertWithStatement: typeof assertWithStatement;
declare const index_d$1_assertYieldExpression: typeof assertYieldExpression;
declare const index_d$1_assignmentExpression: typeof assignmentExpression;
declare const index_d$1_assignmentPattern: typeof assignmentPattern;
declare const index_d$1_awaitExpression: typeof awaitExpression;
declare const index_d$1_bigIntLiteral: typeof bigIntLiteral;
declare const index_d$1_binaryExpression: typeof binaryExpression;
declare const index_d$1_bindExpression: typeof bindExpression;
declare const index_d$1_blockStatement: typeof blockStatement;
declare const index_d$1_booleanLiteral: typeof booleanLiteral;
declare const index_d$1_booleanLiteralTypeAnnotation: typeof booleanLiteralTypeAnnotation;
declare const index_d$1_booleanTypeAnnotation: typeof booleanTypeAnnotation;
declare const index_d$1_breakStatement: typeof breakStatement;
declare const index_d$1_buildMatchMemberExpression: typeof buildMatchMemberExpression;
declare const index_d$1_buildUndefinedNode: typeof buildUndefinedNode;
declare const index_d$1_callExpression: typeof callExpression;
declare const index_d$1_catchClause: typeof catchClause;
declare const index_d$1_classAccessorProperty: typeof classAccessorProperty;
declare const index_d$1_classBody: typeof classBody;
declare const index_d$1_classDeclaration: typeof classDeclaration;
declare const index_d$1_classExpression: typeof classExpression;
declare const index_d$1_classImplements: typeof classImplements;
declare const index_d$1_classMethod: typeof classMethod;
declare const index_d$1_classPrivateMethod: typeof classPrivateMethod;
declare const index_d$1_classPrivateProperty: typeof classPrivateProperty;
declare const index_d$1_classProperty: typeof classProperty;
declare const index_d$1_clone: typeof clone;
declare const index_d$1_cloneDeep: typeof cloneDeep;
declare const index_d$1_cloneDeepWithoutLoc: typeof cloneDeepWithoutLoc;
declare const index_d$1_cloneNode: typeof cloneNode;
declare const index_d$1_cloneWithoutLoc: typeof cloneWithoutLoc;
declare const index_d$1_conditionalExpression: typeof conditionalExpression;
declare const index_d$1_continueStatement: typeof continueStatement;
declare const index_d$1_createFlowUnionType: typeof createFlowUnionType;
declare const index_d$1_createTSUnionType: typeof createTSUnionType;
declare const index_d$1_debuggerStatement: typeof debuggerStatement;
declare const index_d$1_decimalLiteral: typeof decimalLiteral;
declare const index_d$1_declareClass: typeof declareClass;
declare const index_d$1_declareExportAllDeclaration: typeof declareExportAllDeclaration;
declare const index_d$1_declareExportDeclaration: typeof declareExportDeclaration;
declare const index_d$1_declareFunction: typeof declareFunction;
declare const index_d$1_declareInterface: typeof declareInterface;
declare const index_d$1_declareModule: typeof declareModule;
declare const index_d$1_declareModuleExports: typeof declareModuleExports;
declare const index_d$1_declareOpaqueType: typeof declareOpaqueType;
declare const index_d$1_declareTypeAlias: typeof declareTypeAlias;
declare const index_d$1_declareVariable: typeof declareVariable;
declare const index_d$1_declaredPredicate: typeof declaredPredicate;
declare const index_d$1_decorator: typeof decorator;
declare const index_d$1_directive: typeof directive;
declare const index_d$1_directiveLiteral: typeof directiveLiteral;
declare const index_d$1_doExpression: typeof doExpression;
declare const index_d$1_doWhileStatement: typeof doWhileStatement;
declare const index_d$1_emptyStatement: typeof emptyStatement;
declare const index_d$1_emptyTypeAnnotation: typeof emptyTypeAnnotation;
declare const index_d$1_ensureBlock: typeof ensureBlock;
declare const index_d$1_enumBooleanBody: typeof enumBooleanBody;
declare const index_d$1_enumBooleanMember: typeof enumBooleanMember;
declare const index_d$1_enumDeclaration: typeof enumDeclaration;
declare const index_d$1_enumDefaultedMember: typeof enumDefaultedMember;
declare const index_d$1_enumNumberBody: typeof enumNumberBody;
declare const index_d$1_enumNumberMember: typeof enumNumberMember;
declare const index_d$1_enumStringBody: typeof enumStringBody;
declare const index_d$1_enumStringMember: typeof enumStringMember;
declare const index_d$1_enumSymbolBody: typeof enumSymbolBody;
declare const index_d$1_existsTypeAnnotation: typeof existsTypeAnnotation;
declare const index_d$1_exportAllDeclaration: typeof exportAllDeclaration;
declare const index_d$1_exportDefaultDeclaration: typeof exportDefaultDeclaration;
declare const index_d$1_exportDefaultSpecifier: typeof exportDefaultSpecifier;
declare const index_d$1_exportNamedDeclaration: typeof exportNamedDeclaration;
declare const index_d$1_exportNamespaceSpecifier: typeof exportNamespaceSpecifier;
declare const index_d$1_exportSpecifier: typeof exportSpecifier;
declare const index_d$1_expressionStatement: typeof expressionStatement;
declare const index_d$1_file: typeof file;
declare const index_d$1_forInStatement: typeof forInStatement;
declare const index_d$1_forOfStatement: typeof forOfStatement;
declare const index_d$1_forStatement: typeof forStatement;
declare const index_d$1_functionDeclaration: typeof functionDeclaration;
declare const index_d$1_functionExpression: typeof functionExpression;
declare const index_d$1_functionTypeAnnotation: typeof functionTypeAnnotation;
declare const index_d$1_functionTypeParam: typeof functionTypeParam;
declare const index_d$1_genericTypeAnnotation: typeof genericTypeAnnotation;
declare const index_d$1_getAssignmentIdentifiers: typeof getAssignmentIdentifiers;
declare const index_d$1_getBindingIdentifiers: typeof getBindingIdentifiers;
declare const index_d$1_getFunctionName: typeof getFunctionName;
declare const index_d$1_identifier: typeof identifier;
declare const index_d$1_ifStatement: typeof ifStatement;
declare const index_d$1_importAttribute: typeof importAttribute;
declare const index_d$1_importDeclaration: typeof importDeclaration;
declare const index_d$1_importDefaultSpecifier: typeof importDefaultSpecifier;
declare const index_d$1_importExpression: typeof importExpression;
declare const index_d$1_importNamespaceSpecifier: typeof importNamespaceSpecifier;
declare const index_d$1_importSpecifier: typeof importSpecifier;
declare const index_d$1_indexedAccessType: typeof indexedAccessType;
declare const index_d$1_inferredPredicate: typeof inferredPredicate;
declare const index_d$1_inheritInnerComments: typeof inheritInnerComments;
declare const index_d$1_inheritLeadingComments: typeof inheritLeadingComments;
declare const index_d$1_inheritTrailingComments: typeof inheritTrailingComments;
declare const index_d$1_inherits: typeof inherits;
declare const index_d$1_inheritsComments: typeof inheritsComments;
declare const index_d$1_interfaceDeclaration: typeof interfaceDeclaration;
declare const index_d$1_interfaceExtends: typeof interfaceExtends;
declare const index_d$1_interfaceTypeAnnotation: typeof interfaceTypeAnnotation;
declare const index_d$1_interpreterDirective: typeof interpreterDirective;
declare const index_d$1_intersectionTypeAnnotation: typeof intersectionTypeAnnotation;
declare const index_d$1_is: typeof is;
declare const index_d$1_isAccessor: typeof isAccessor;
declare const index_d$1_isAnyTypeAnnotation: typeof isAnyTypeAnnotation;
declare const index_d$1_isArgumentPlaceholder: typeof isArgumentPlaceholder;
declare const index_d$1_isArrayExpression: typeof isArrayExpression;
declare const index_d$1_isArrayPattern: typeof isArrayPattern;
declare const index_d$1_isArrayTypeAnnotation: typeof isArrayTypeAnnotation;
declare const index_d$1_isArrowFunctionExpression: typeof isArrowFunctionExpression;
declare const index_d$1_isAssignmentExpression: typeof isAssignmentExpression;
declare const index_d$1_isAssignmentPattern: typeof isAssignmentPattern;
declare const index_d$1_isAwaitExpression: typeof isAwaitExpression;
declare const index_d$1_isBigIntLiteral: typeof isBigIntLiteral;
declare const index_d$1_isBinary: typeof isBinary;
declare const index_d$1_isBinaryExpression: typeof isBinaryExpression;
declare const index_d$1_isBindExpression: typeof isBindExpression;
declare const index_d$1_isBinding: typeof isBinding;
declare const index_d$1_isBlock: typeof isBlock;
declare const index_d$1_isBlockParent: typeof isBlockParent;
declare const index_d$1_isBlockScoped: typeof isBlockScoped;
declare const index_d$1_isBlockStatement: typeof isBlockStatement;
declare const index_d$1_isBooleanLiteral: typeof isBooleanLiteral;
declare const index_d$1_isBooleanLiteralTypeAnnotation: typeof isBooleanLiteralTypeAnnotation;
declare const index_d$1_isBooleanTypeAnnotation: typeof isBooleanTypeAnnotation;
declare const index_d$1_isBreakStatement: typeof isBreakStatement;
declare const index_d$1_isCallExpression: typeof isCallExpression;
declare const index_d$1_isCatchClause: typeof isCatchClause;
declare const index_d$1_isClass: typeof isClass;
declare const index_d$1_isClassAccessorProperty: typeof isClassAccessorProperty;
declare const index_d$1_isClassBody: typeof isClassBody;
declare const index_d$1_isClassDeclaration: typeof isClassDeclaration;
declare const index_d$1_isClassExpression: typeof isClassExpression;
declare const index_d$1_isClassImplements: typeof isClassImplements;
declare const index_d$1_isClassMethod: typeof isClassMethod;
declare const index_d$1_isClassPrivateMethod: typeof isClassPrivateMethod;
declare const index_d$1_isClassPrivateProperty: typeof isClassPrivateProperty;
declare const index_d$1_isClassProperty: typeof isClassProperty;
declare const index_d$1_isCompletionStatement: typeof isCompletionStatement;
declare const index_d$1_isConditional: typeof isConditional;
declare const index_d$1_isConditionalExpression: typeof isConditionalExpression;
declare const index_d$1_isContinueStatement: typeof isContinueStatement;
declare const index_d$1_isDebuggerStatement: typeof isDebuggerStatement;
declare const index_d$1_isDecimalLiteral: typeof isDecimalLiteral;
declare const index_d$1_isDeclaration: typeof isDeclaration;
declare const index_d$1_isDeclareClass: typeof isDeclareClass;
declare const index_d$1_isDeclareExportAllDeclaration: typeof isDeclareExportAllDeclaration;
declare const index_d$1_isDeclareExportDeclaration: typeof isDeclareExportDeclaration;
declare const index_d$1_isDeclareFunction: typeof isDeclareFunction;
declare const index_d$1_isDeclareInterface: typeof isDeclareInterface;
declare const index_d$1_isDeclareModule: typeof isDeclareModule;
declare const index_d$1_isDeclareModuleExports: typeof isDeclareModuleExports;
declare const index_d$1_isDeclareOpaqueType: typeof isDeclareOpaqueType;
declare const index_d$1_isDeclareTypeAlias: typeof isDeclareTypeAlias;
declare const index_d$1_isDeclareVariable: typeof isDeclareVariable;
declare const index_d$1_isDeclaredPredicate: typeof isDeclaredPredicate;
declare const index_d$1_isDecorator: typeof isDecorator;
declare const index_d$1_isDirective: typeof isDirective;
declare const index_d$1_isDirectiveLiteral: typeof isDirectiveLiteral;
declare const index_d$1_isDoExpression: typeof isDoExpression;
declare const index_d$1_isDoWhileStatement: typeof isDoWhileStatement;
declare const index_d$1_isEmptyStatement: typeof isEmptyStatement;
declare const index_d$1_isEmptyTypeAnnotation: typeof isEmptyTypeAnnotation;
declare const index_d$1_isEnumBody: typeof isEnumBody;
declare const index_d$1_isEnumBooleanBody: typeof isEnumBooleanBody;
declare const index_d$1_isEnumBooleanMember: typeof isEnumBooleanMember;
declare const index_d$1_isEnumDeclaration: typeof isEnumDeclaration;
declare const index_d$1_isEnumDefaultedMember: typeof isEnumDefaultedMember;
declare const index_d$1_isEnumMember: typeof isEnumMember;
declare const index_d$1_isEnumNumberBody: typeof isEnumNumberBody;
declare const index_d$1_isEnumNumberMember: typeof isEnumNumberMember;
declare const index_d$1_isEnumStringBody: typeof isEnumStringBody;
declare const index_d$1_isEnumStringMember: typeof isEnumStringMember;
declare const index_d$1_isEnumSymbolBody: typeof isEnumSymbolBody;
declare const index_d$1_isExistsTypeAnnotation: typeof isExistsTypeAnnotation;
declare const index_d$1_isExportAllDeclaration: typeof isExportAllDeclaration;
declare const index_d$1_isExportDeclaration: typeof isExportDeclaration;
declare const index_d$1_isExportDefaultDeclaration: typeof isExportDefaultDeclaration;
declare const index_d$1_isExportDefaultSpecifier: typeof isExportDefaultSpecifier;
declare const index_d$1_isExportNamedDeclaration: typeof isExportNamedDeclaration;
declare const index_d$1_isExportNamespaceSpecifier: typeof isExportNamespaceSpecifier;
declare const index_d$1_isExportSpecifier: typeof isExportSpecifier;
declare const index_d$1_isExpression: typeof isExpression;
declare const index_d$1_isExpressionStatement: typeof isExpressionStatement;
declare const index_d$1_isExpressionWrapper: typeof isExpressionWrapper;
declare const index_d$1_isFile: typeof isFile;
declare const index_d$1_isFlow: typeof isFlow;
declare const index_d$1_isFlowBaseAnnotation: typeof isFlowBaseAnnotation;
declare const index_d$1_isFlowDeclaration: typeof isFlowDeclaration;
declare const index_d$1_isFlowPredicate: typeof isFlowPredicate;
declare const index_d$1_isFlowType: typeof isFlowType;
declare const index_d$1_isFor: typeof isFor;
declare const index_d$1_isForInStatement: typeof isForInStatement;
declare const index_d$1_isForOfStatement: typeof isForOfStatement;
declare const index_d$1_isForStatement: typeof isForStatement;
declare const index_d$1_isForXStatement: typeof isForXStatement;
declare const index_d$1_isFunction: typeof isFunction;
declare const index_d$1_isFunctionDeclaration: typeof isFunctionDeclaration;
declare const index_d$1_isFunctionExpression: typeof isFunctionExpression;
declare const index_d$1_isFunctionParameter: typeof isFunctionParameter;
declare const index_d$1_isFunctionParent: typeof isFunctionParent;
declare const index_d$1_isFunctionTypeAnnotation: typeof isFunctionTypeAnnotation;
declare const index_d$1_isFunctionTypeParam: typeof isFunctionTypeParam;
declare const index_d$1_isGenericTypeAnnotation: typeof isGenericTypeAnnotation;
declare const index_d$1_isIdentifier: typeof isIdentifier;
declare const index_d$1_isIfStatement: typeof isIfStatement;
declare const index_d$1_isImmutable: typeof isImmutable;
declare const index_d$1_isImport: typeof isImport;
declare const index_d$1_isImportAttribute: typeof isImportAttribute;
declare const index_d$1_isImportDeclaration: typeof isImportDeclaration;
declare const index_d$1_isImportDefaultSpecifier: typeof isImportDefaultSpecifier;
declare const index_d$1_isImportExpression: typeof isImportExpression;
declare const index_d$1_isImportNamespaceSpecifier: typeof isImportNamespaceSpecifier;
declare const index_d$1_isImportOrExportDeclaration: typeof isImportOrExportDeclaration;
declare const index_d$1_isImportSpecifier: typeof isImportSpecifier;
declare const index_d$1_isIndexedAccessType: typeof isIndexedAccessType;
declare const index_d$1_isInferredPredicate: typeof isInferredPredicate;
declare const index_d$1_isInterfaceDeclaration: typeof isInterfaceDeclaration;
declare const index_d$1_isInterfaceExtends: typeof isInterfaceExtends;
declare const index_d$1_isInterfaceTypeAnnotation: typeof isInterfaceTypeAnnotation;
declare const index_d$1_isInterpreterDirective: typeof isInterpreterDirective;
declare const index_d$1_isIntersectionTypeAnnotation: typeof isIntersectionTypeAnnotation;
declare const index_d$1_isJSX: typeof isJSX;
declare const index_d$1_isJSXAttribute: typeof isJSXAttribute;
declare const index_d$1_isJSXClosingElement: typeof isJSXClosingElement;
declare const index_d$1_isJSXClosingFragment: typeof isJSXClosingFragment;
declare const index_d$1_isJSXElement: typeof isJSXElement;
declare const index_d$1_isJSXEmptyExpression: typeof isJSXEmptyExpression;
declare const index_d$1_isJSXExpressionContainer: typeof isJSXExpressionContainer;
declare const index_d$1_isJSXFragment: typeof isJSXFragment;
declare const index_d$1_isJSXIdentifier: typeof isJSXIdentifier;
declare const index_d$1_isJSXMemberExpression: typeof isJSXMemberExpression;
declare const index_d$1_isJSXNamespacedName: typeof isJSXNamespacedName;
declare const index_d$1_isJSXOpeningElement: typeof isJSXOpeningElement;
declare const index_d$1_isJSXOpeningFragment: typeof isJSXOpeningFragment;
declare const index_d$1_isJSXSpreadAttribute: typeof isJSXSpreadAttribute;
declare const index_d$1_isJSXSpreadChild: typeof isJSXSpreadChild;
declare const index_d$1_isJSXText: typeof isJSXText;
declare const index_d$1_isLVal: typeof isLVal;
declare const index_d$1_isLabeledStatement: typeof isLabeledStatement;
declare const index_d$1_isLet: typeof isLet;
declare const index_d$1_isLiteral: typeof isLiteral;
declare const index_d$1_isLogicalExpression: typeof isLogicalExpression;
declare const index_d$1_isLoop: typeof isLoop;
declare const index_d$1_isMemberExpression: typeof isMemberExpression;
declare const index_d$1_isMetaProperty: typeof isMetaProperty;
declare const index_d$1_isMethod: typeof isMethod;
declare const index_d$1_isMiscellaneous: typeof isMiscellaneous;
declare const index_d$1_isMixedTypeAnnotation: typeof isMixedTypeAnnotation;
declare const index_d$1_isModuleDeclaration: typeof isModuleDeclaration;
declare const index_d$1_isModuleExpression: typeof isModuleExpression;
declare const index_d$1_isModuleSpecifier: typeof isModuleSpecifier;
declare const index_d$1_isNewExpression: typeof isNewExpression;
declare const index_d$1_isNode: typeof isNode;
declare const index_d$1_isNodesEquivalent: typeof isNodesEquivalent;
declare const index_d$1_isNoop: typeof isNoop;
declare const index_d$1_isNullLiteral: typeof isNullLiteral;
declare const index_d$1_isNullLiteralTypeAnnotation: typeof isNullLiteralTypeAnnotation;
declare const index_d$1_isNullableTypeAnnotation: typeof isNullableTypeAnnotation;
declare const index_d$1_isNumberLiteral: typeof isNumberLiteral;
declare const index_d$1_isNumberLiteralTypeAnnotation: typeof isNumberLiteralTypeAnnotation;
declare const index_d$1_isNumberTypeAnnotation: typeof isNumberTypeAnnotation;
declare const index_d$1_isNumericLiteral: typeof isNumericLiteral;
declare const index_d$1_isObjectExpression: typeof isObjectExpression;
declare const index_d$1_isObjectMember: typeof isObjectMember;
declare const index_d$1_isObjectMethod: typeof isObjectMethod;
declare const index_d$1_isObjectPattern: typeof isObjectPattern;
declare const index_d$1_isObjectProperty: typeof isObjectProperty;
declare const index_d$1_isObjectTypeAnnotation: typeof isObjectTypeAnnotation;
declare const index_d$1_isObjectTypeCallProperty: typeof isObjectTypeCallProperty;
declare const index_d$1_isObjectTypeIndexer: typeof isObjectTypeIndexer;
declare const index_d$1_isObjectTypeInternalSlot: typeof isObjectTypeInternalSlot;
declare const index_d$1_isObjectTypeProperty: typeof isObjectTypeProperty;
declare const index_d$1_isObjectTypeSpreadProperty: typeof isObjectTypeSpreadProperty;
declare const index_d$1_isOpaqueType: typeof isOpaqueType;
declare const index_d$1_isOptionalCallExpression: typeof isOptionalCallExpression;
declare const index_d$1_isOptionalIndexedAccessType: typeof isOptionalIndexedAccessType;
declare const index_d$1_isOptionalMemberExpression: typeof isOptionalMemberExpression;
declare const index_d$1_isParenthesizedExpression: typeof isParenthesizedExpression;
declare const index_d$1_isPattern: typeof isPattern;
declare const index_d$1_isPatternLike: typeof isPatternLike;
declare const index_d$1_isPipelineBareFunction: typeof isPipelineBareFunction;
declare const index_d$1_isPipelinePrimaryTopicReference: typeof isPipelinePrimaryTopicReference;
declare const index_d$1_isPipelineTopicExpression: typeof isPipelineTopicExpression;
declare const index_d$1_isPlaceholder: typeof isPlaceholder;
declare const index_d$1_isPlaceholderType: typeof isPlaceholderType;
declare const index_d$1_isPrivate: typeof isPrivate;
declare const index_d$1_isPrivateName: typeof isPrivateName;
declare const index_d$1_isProgram: typeof isProgram;
declare const index_d$1_isProperty: typeof isProperty;
declare const index_d$1_isPureish: typeof isPureish;
declare const index_d$1_isQualifiedTypeIdentifier: typeof isQualifiedTypeIdentifier;
declare const index_d$1_isRecordExpression: typeof isRecordExpression;
declare const index_d$1_isReferenced: typeof isReferenced;
declare const index_d$1_isRegExpLiteral: typeof isRegExpLiteral;
declare const index_d$1_isRegexLiteral: typeof isRegexLiteral;
declare const index_d$1_isRestElement: typeof isRestElement;
declare const index_d$1_isRestProperty: typeof isRestProperty;
declare const index_d$1_isReturnStatement: typeof isReturnStatement;
declare const index_d$1_isScopable: typeof isScopable;
declare const index_d$1_isScope: typeof isScope;
declare const index_d$1_isSequenceExpression: typeof isSequenceExpression;
declare const index_d$1_isSpecifierDefault: typeof isSpecifierDefault;
declare const index_d$1_isSpreadElement: typeof isSpreadElement;
declare const index_d$1_isSpreadProperty: typeof isSpreadProperty;
declare const index_d$1_isStandardized: typeof isStandardized;
declare const index_d$1_isStatement: typeof isStatement;
declare const index_d$1_isStaticBlock: typeof isStaticBlock;
declare const index_d$1_isStringLiteral: typeof isStringLiteral;
declare const index_d$1_isStringLiteralTypeAnnotation: typeof isStringLiteralTypeAnnotation;
declare const index_d$1_isStringTypeAnnotation: typeof isStringTypeAnnotation;
declare const index_d$1_isSuper: typeof isSuper;
declare const index_d$1_isSwitchCase: typeof isSwitchCase;
declare const index_d$1_isSwitchStatement: typeof isSwitchStatement;
declare const index_d$1_isSymbolTypeAnnotation: typeof isSymbolTypeAnnotation;
declare const index_d$1_isTSAnyKeyword: typeof isTSAnyKeyword;
declare const index_d$1_isTSArrayType: typeof isTSArrayType;
declare const index_d$1_isTSAsExpression: typeof isTSAsExpression;
declare const index_d$1_isTSBaseType: typeof isTSBaseType;
declare const index_d$1_isTSBigIntKeyword: typeof isTSBigIntKeyword;
declare const index_d$1_isTSBooleanKeyword: typeof isTSBooleanKeyword;
declare const index_d$1_isTSCallSignatureDeclaration: typeof isTSCallSignatureDeclaration;
declare const index_d$1_isTSConditionalType: typeof isTSConditionalType;
declare const index_d$1_isTSConstructSignatureDeclaration: typeof isTSConstructSignatureDeclaration;
declare const index_d$1_isTSConstructorType: typeof isTSConstructorType;
declare const index_d$1_isTSDeclareFunction: typeof isTSDeclareFunction;
declare const index_d$1_isTSDeclareMethod: typeof isTSDeclareMethod;
declare const index_d$1_isTSEntityName: typeof isTSEntityName;
declare const index_d$1_isTSEnumBody: typeof isTSEnumBody;
declare const index_d$1_isTSEnumDeclaration: typeof isTSEnumDeclaration;
declare const index_d$1_isTSEnumMember: typeof isTSEnumMember;
declare const index_d$1_isTSExportAssignment: typeof isTSExportAssignment;
declare const index_d$1_isTSExpressionWithTypeArguments: typeof isTSExpressionWithTypeArguments;
declare const index_d$1_isTSExternalModuleReference: typeof isTSExternalModuleReference;
declare const index_d$1_isTSFunctionType: typeof isTSFunctionType;
declare const index_d$1_isTSImportEqualsDeclaration: typeof isTSImportEqualsDeclaration;
declare const index_d$1_isTSImportType: typeof isTSImportType;
declare const index_d$1_isTSIndexSignature: typeof isTSIndexSignature;
declare const index_d$1_isTSIndexedAccessType: typeof isTSIndexedAccessType;
declare const index_d$1_isTSInferType: typeof isTSInferType;
declare const index_d$1_isTSInstantiationExpression: typeof isTSInstantiationExpression;
declare const index_d$1_isTSInterfaceBody: typeof isTSInterfaceBody;
declare const index_d$1_isTSInterfaceDeclaration: typeof isTSInterfaceDeclaration;
declare const index_d$1_isTSIntersectionType: typeof isTSIntersectionType;
declare const index_d$1_isTSIntrinsicKeyword: typeof isTSIntrinsicKeyword;
declare const index_d$1_isTSLiteralType: typeof isTSLiteralType;
declare const index_d$1_isTSMappedType: typeof isTSMappedType;
declare const index_d$1_isTSMethodSignature: typeof isTSMethodSignature;
declare const index_d$1_isTSModuleBlock: typeof isTSModuleBlock;
declare const index_d$1_isTSModuleDeclaration: typeof isTSModuleDeclaration;
declare const index_d$1_isTSNamedTupleMember: typeof isTSNamedTupleMember;
declare const index_d$1_isTSNamespaceExportDeclaration: typeof isTSNamespaceExportDeclaration;
declare const index_d$1_isTSNeverKeyword: typeof isTSNeverKeyword;
declare const index_d$1_isTSNonNullExpression: typeof isTSNonNullExpression;
declare const index_d$1_isTSNullKeyword: typeof isTSNullKeyword;
declare const index_d$1_isTSNumberKeyword: typeof isTSNumberKeyword;
declare const index_d$1_isTSObjectKeyword: typeof isTSObjectKeyword;
declare const index_d$1_isTSOptionalType: typeof isTSOptionalType;
declare const index_d$1_isTSParameterProperty: typeof isTSParameterProperty;
declare const index_d$1_isTSParenthesizedType: typeof isTSParenthesizedType;
declare const index_d$1_isTSPropertySignature: typeof isTSPropertySignature;
declare const index_d$1_isTSQualifiedName: typeof isTSQualifiedName;
declare const index_d$1_isTSRestType: typeof isTSRestType;
declare const index_d$1_isTSSatisfiesExpression: typeof isTSSatisfiesExpression;
declare const index_d$1_isTSStringKeyword: typeof isTSStringKeyword;
declare const index_d$1_isTSSymbolKeyword: typeof isTSSymbolKeyword;
declare const index_d$1_isTSTemplateLiteralType: typeof isTSTemplateLiteralType;
declare const index_d$1_isTSThisType: typeof isTSThisType;
declare const index_d$1_isTSTupleType: typeof isTSTupleType;
declare const index_d$1_isTSType: typeof isTSType;
declare const index_d$1_isTSTypeAliasDeclaration: typeof isTSTypeAliasDeclaration;
declare const index_d$1_isTSTypeAnnotation: typeof isTSTypeAnnotation;
declare const index_d$1_isTSTypeAssertion: typeof isTSTypeAssertion;
declare const index_d$1_isTSTypeElement: typeof isTSTypeElement;
declare const index_d$1_isTSTypeLiteral: typeof isTSTypeLiteral;
declare const index_d$1_isTSTypeOperator: typeof isTSTypeOperator;
declare const index_d$1_isTSTypeParameter: typeof isTSTypeParameter;
declare const index_d$1_isTSTypeParameterDeclaration: typeof isTSTypeParameterDeclaration;
declare const index_d$1_isTSTypeParameterInstantiation: typeof isTSTypeParameterInstantiation;
declare const index_d$1_isTSTypePredicate: typeof isTSTypePredicate;
declare const index_d$1_isTSTypeQuery: typeof isTSTypeQuery;
declare const index_d$1_isTSTypeReference: typeof isTSTypeReference;
declare const index_d$1_isTSUndefinedKeyword: typeof isTSUndefinedKeyword;
declare const index_d$1_isTSUnionType: typeof isTSUnionType;
declare const index_d$1_isTSUnknownKeyword: typeof isTSUnknownKeyword;
declare const index_d$1_isTSVoidKeyword: typeof isTSVoidKeyword;
declare const index_d$1_isTaggedTemplateExpression: typeof isTaggedTemplateExpression;
declare const index_d$1_isTemplateElement: typeof isTemplateElement;
declare const index_d$1_isTemplateLiteral: typeof isTemplateLiteral;
declare const index_d$1_isTerminatorless: typeof isTerminatorless;
declare const index_d$1_isThisExpression: typeof isThisExpression;
declare const index_d$1_isThisTypeAnnotation: typeof isThisTypeAnnotation;
declare const index_d$1_isThrowStatement: typeof isThrowStatement;
declare const index_d$1_isTopicReference: typeof isTopicReference;
declare const index_d$1_isTryStatement: typeof isTryStatement;
declare const index_d$1_isTupleExpression: typeof isTupleExpression;
declare const index_d$1_isTupleTypeAnnotation: typeof isTupleTypeAnnotation;
declare const index_d$1_isType: typeof isType;
declare const index_d$1_isTypeAlias: typeof isTypeAlias;
declare const index_d$1_isTypeAnnotation: typeof isTypeAnnotation;
declare const index_d$1_isTypeCastExpression: typeof isTypeCastExpression;
declare const index_d$1_isTypeParameter: typeof isTypeParameter;
declare const index_d$1_isTypeParameterDeclaration: typeof isTypeParameterDeclaration;
declare const index_d$1_isTypeParameterInstantiation: typeof isTypeParameterInstantiation;
declare const index_d$1_isTypeScript: typeof isTypeScript;
declare const index_d$1_isTypeofTypeAnnotation: typeof isTypeofTypeAnnotation;
declare const index_d$1_isUnaryExpression: typeof isUnaryExpression;
declare const index_d$1_isUnaryLike: typeof isUnaryLike;
declare const index_d$1_isUnionTypeAnnotation: typeof isUnionTypeAnnotation;
declare const index_d$1_isUpdateExpression: typeof isUpdateExpression;
declare const index_d$1_isUserWhitespacable: typeof isUserWhitespacable;
declare const index_d$1_isV8IntrinsicIdentifier: typeof isV8IntrinsicIdentifier;
declare const index_d$1_isValidES3Identifier: typeof isValidES3Identifier;
declare const index_d$1_isValidIdentifier: typeof isValidIdentifier;
declare const index_d$1_isVar: typeof isVar;
declare const index_d$1_isVariableDeclaration: typeof isVariableDeclaration;
declare const index_d$1_isVariableDeclarator: typeof isVariableDeclarator;
declare const index_d$1_isVariance: typeof isVariance;
declare const index_d$1_isVoidPattern: typeof isVoidPattern;
declare const index_d$1_isVoidTypeAnnotation: typeof isVoidTypeAnnotation;
declare const index_d$1_isWhile: typeof isWhile;
declare const index_d$1_isWhileStatement: typeof isWhileStatement;
declare const index_d$1_isWithStatement: typeof isWithStatement;
declare const index_d$1_isYieldExpression: typeof isYieldExpression;
declare const index_d$1_jsxAttribute: typeof jsxAttribute;
declare const index_d$1_jsxClosingElement: typeof jsxClosingElement;
declare const index_d$1_jsxClosingFragment: typeof jsxClosingFragment;
declare const index_d$1_jsxElement: typeof jsxElement;
declare const index_d$1_jsxEmptyExpression: typeof jsxEmptyExpression;
declare const index_d$1_jsxExpressionContainer: typeof jsxExpressionContainer;
declare const index_d$1_jsxFragment: typeof jsxFragment;
declare const index_d$1_jsxIdentifier: typeof jsxIdentifier;
declare const index_d$1_jsxMemberExpression: typeof jsxMemberExpression;
declare const index_d$1_jsxNamespacedName: typeof jsxNamespacedName;
declare const index_d$1_jsxOpeningElement: typeof jsxOpeningElement;
declare const index_d$1_jsxOpeningFragment: typeof jsxOpeningFragment;
declare const index_d$1_jsxSpreadAttribute: typeof jsxSpreadAttribute;
declare const index_d$1_jsxSpreadChild: typeof jsxSpreadChild;
declare const index_d$1_jsxText: typeof jsxText;
declare const index_d$1_labeledStatement: typeof labeledStatement;
declare const index_d$1_logicalExpression: typeof logicalExpression;
declare const index_d$1_matchesPattern: typeof matchesPattern;
declare const index_d$1_memberExpression: typeof memberExpression;
declare const index_d$1_metaProperty: typeof metaProperty;
declare const index_d$1_mixedTypeAnnotation: typeof mixedTypeAnnotation;
declare const index_d$1_moduleExpression: typeof moduleExpression;
declare const index_d$1_newExpression: typeof newExpression;
declare const index_d$1_noop: typeof noop;
declare const index_d$1_nullLiteral: typeof nullLiteral;
declare const index_d$1_nullLiteralTypeAnnotation: typeof nullLiteralTypeAnnotation;
declare const index_d$1_nullableTypeAnnotation: typeof nullableTypeAnnotation;
declare const index_d$1_numberLiteralTypeAnnotation: typeof numberLiteralTypeAnnotation;
declare const index_d$1_numberTypeAnnotation: typeof numberTypeAnnotation;
declare const index_d$1_numericLiteral: typeof numericLiteral;
declare const index_d$1_objectExpression: typeof objectExpression;
declare const index_d$1_objectMethod: typeof objectMethod;
declare const index_d$1_objectPattern: typeof objectPattern;
declare const index_d$1_objectProperty: typeof objectProperty;
declare const index_d$1_objectTypeAnnotation: typeof objectTypeAnnotation;
declare const index_d$1_objectTypeCallProperty: typeof objectTypeCallProperty;
declare const index_d$1_objectTypeIndexer: typeof objectTypeIndexer;
declare const index_d$1_objectTypeInternalSlot: typeof objectTypeInternalSlot;
declare const index_d$1_objectTypeProperty: typeof objectTypeProperty;
declare const index_d$1_objectTypeSpreadProperty: typeof objectTypeSpreadProperty;
declare const index_d$1_opaqueType: typeof opaqueType;
declare const index_d$1_optionalCallExpression: typeof optionalCallExpression;
declare const index_d$1_optionalIndexedAccessType: typeof optionalIndexedAccessType;
declare const index_d$1_optionalMemberExpression: typeof optionalMemberExpression;
declare const index_d$1_parenthesizedExpression: typeof parenthesizedExpression;
declare const index_d$1_pipelineBareFunction: typeof pipelineBareFunction;
declare const index_d$1_pipelinePrimaryTopicReference: typeof pipelinePrimaryTopicReference;
declare const index_d$1_pipelineTopicExpression: typeof pipelineTopicExpression;
declare const index_d$1_placeholder: typeof placeholder;
declare const index_d$1_prependToMemberExpression: typeof prependToMemberExpression;
declare const index_d$1_privateName: typeof privateName;
declare const index_d$1_qualifiedTypeIdentifier: typeof qualifiedTypeIdentifier;
declare const index_d$1_react: typeof react;
declare const index_d$1_recordExpression: typeof recordExpression;
declare const index_d$1_regExpLiteral: typeof regExpLiteral;
declare const index_d$1_removeComments: typeof removeComments;
declare const index_d$1_removeProperties: typeof removeProperties;
declare const index_d$1_removePropertiesDeep: typeof removePropertiesDeep;
declare const index_d$1_removeTypeDuplicates: typeof removeTypeDuplicates;
declare const index_d$1_restElement: typeof restElement;
declare const index_d$1_returnStatement: typeof returnStatement;
declare const index_d$1_sequenceExpression: typeof sequenceExpression;
declare const index_d$1_shallowEqual: typeof shallowEqual;
declare const index_d$1_spreadElement: typeof spreadElement;
declare const index_d$1_staticBlock: typeof staticBlock;
declare const index_d$1_stringLiteral: typeof stringLiteral;
declare const index_d$1_stringLiteralTypeAnnotation: typeof stringLiteralTypeAnnotation;
declare const index_d$1_stringTypeAnnotation: typeof stringTypeAnnotation;
declare const index_d$1_switchCase: typeof switchCase;
declare const index_d$1_switchStatement: typeof switchStatement;
declare const index_d$1_symbolTypeAnnotation: typeof symbolTypeAnnotation;
declare const index_d$1_taggedTemplateExpression: typeof taggedTemplateExpression;
declare const index_d$1_templateElement: typeof templateElement;
declare const index_d$1_templateLiteral: typeof templateLiteral;
declare const index_d$1_thisExpression: typeof thisExpression;
declare const index_d$1_thisTypeAnnotation: typeof thisTypeAnnotation;
declare const index_d$1_throwStatement: typeof throwStatement;
declare const index_d$1_toBindingIdentifierName: typeof toBindingIdentifierName;
declare const index_d$1_toBlock: typeof toBlock;
declare const index_d$1_toComputedKey: typeof toComputedKey;
declare const index_d$1_toIdentifier: typeof toIdentifier;
declare const index_d$1_toKeyAlias: typeof toKeyAlias;
declare const index_d$1_topicReference: typeof topicReference;
declare const index_d$1_traverseFast: typeof traverseFast;
declare const index_d$1_tryStatement: typeof tryStatement;
declare const index_d$1_tsAnyKeyword: typeof tsAnyKeyword;
declare const index_d$1_tsArrayType: typeof tsArrayType;
declare const index_d$1_tsAsExpression: typeof tsAsExpression;
declare const index_d$1_tsBigIntKeyword: typeof tsBigIntKeyword;
declare const index_d$1_tsBooleanKeyword: typeof tsBooleanKeyword;
declare const index_d$1_tsCallSignatureDeclaration: typeof tsCallSignatureDeclaration;
declare const index_d$1_tsConditionalType: typeof tsConditionalType;
declare const index_d$1_tsConstructSignatureDeclaration: typeof tsConstructSignatureDeclaration;
declare const index_d$1_tsConstructorType: typeof tsConstructorType;
declare const index_d$1_tsDeclareFunction: typeof tsDeclareFunction;
declare const index_d$1_tsDeclareMethod: typeof tsDeclareMethod;
declare const index_d$1_tsEnumBody: typeof tsEnumBody;
declare const index_d$1_tsEnumDeclaration: typeof tsEnumDeclaration;
declare const index_d$1_tsEnumMember: typeof tsEnumMember;
declare const index_d$1_tsExportAssignment: typeof tsExportAssignment;
declare const index_d$1_tsExpressionWithTypeArguments: typeof tsExpressionWithTypeArguments;
declare const index_d$1_tsExternalModuleReference: typeof tsExternalModuleReference;
declare const index_d$1_tsFunctionType: typeof tsFunctionType;
declare const index_d$1_tsImportEqualsDeclaration: typeof tsImportEqualsDeclaration;
declare const index_d$1_tsImportType: typeof tsImportType;
declare const index_d$1_tsIndexSignature: typeof tsIndexSignature;
declare const index_d$1_tsIndexedAccessType: typeof tsIndexedAccessType;
declare const index_d$1_tsInferType: typeof tsInferType;
declare const index_d$1_tsInstantiationExpression: typeof tsInstantiationExpression;
declare const index_d$1_tsInterfaceBody: typeof tsInterfaceBody;
declare const index_d$1_tsInterfaceDeclaration: typeof tsInterfaceDeclaration;
declare const index_d$1_tsIntersectionType: typeof tsIntersectionType;
declare const index_d$1_tsIntrinsicKeyword: typeof tsIntrinsicKeyword;
declare const index_d$1_tsLiteralType: typeof tsLiteralType;
declare const index_d$1_tsMappedType: typeof tsMappedType;
declare const index_d$1_tsMethodSignature: typeof tsMethodSignature;
declare const index_d$1_tsModuleBlock: typeof tsModuleBlock;
declare const index_d$1_tsModuleDeclaration: typeof tsModuleDeclaration;
declare const index_d$1_tsNamedTupleMember: typeof tsNamedTupleMember;
declare const index_d$1_tsNamespaceExportDeclaration: typeof tsNamespaceExportDeclaration;
declare const index_d$1_tsNeverKeyword: typeof tsNeverKeyword;
declare const index_d$1_tsNonNullExpression: typeof tsNonNullExpression;
declare const index_d$1_tsNullKeyword: typeof tsNullKeyword;
declare const index_d$1_tsNumberKeyword: typeof tsNumberKeyword;
declare const index_d$1_tsObjectKeyword: typeof tsObjectKeyword;
declare const index_d$1_tsOptionalType: typeof tsOptionalType;
declare const index_d$1_tsParameterProperty: typeof tsParameterProperty;
declare const index_d$1_tsParenthesizedType: typeof tsParenthesizedType;
declare const index_d$1_tsPropertySignature: typeof tsPropertySignature;
declare const index_d$1_tsQualifiedName: typeof tsQualifiedName;
declare const index_d$1_tsRestType: typeof tsRestType;
declare const index_d$1_tsSatisfiesExpression: typeof tsSatisfiesExpression;
declare const index_d$1_tsStringKeyword: typeof tsStringKeyword;
declare const index_d$1_tsSymbolKeyword: typeof tsSymbolKeyword;
declare const index_d$1_tsTemplateLiteralType: typeof tsTemplateLiteralType;
declare const index_d$1_tsThisType: typeof tsThisType;
declare const index_d$1_tsTupleType: typeof tsTupleType;
declare const index_d$1_tsTypeAliasDeclaration: typeof tsTypeAliasDeclaration;
declare const index_d$1_tsTypeAnnotation: typeof tsTypeAnnotation;
declare const index_d$1_tsTypeAssertion: typeof tsTypeAssertion;
declare const index_d$1_tsTypeLiteral: typeof tsTypeLiteral;
declare const index_d$1_tsTypeOperator: typeof tsTypeOperator;
declare const index_d$1_tsTypeParameter: typeof tsTypeParameter;
declare const index_d$1_tsTypeParameterDeclaration: typeof tsTypeParameterDeclaration;
declare const index_d$1_tsTypeParameterInstantiation: typeof tsTypeParameterInstantiation;
declare const index_d$1_tsTypePredicate: typeof tsTypePredicate;
declare const index_d$1_tsTypeQuery: typeof tsTypeQuery;
declare const index_d$1_tsTypeReference: typeof tsTypeReference;
declare const index_d$1_tsUndefinedKeyword: typeof tsUndefinedKeyword;
declare const index_d$1_tsUnionType: typeof tsUnionType;
declare const index_d$1_tsUnknownKeyword: typeof tsUnknownKeyword;
declare const index_d$1_tsVoidKeyword: typeof tsVoidKeyword;
declare const index_d$1_tupleExpression: typeof tupleExpression;
declare const index_d$1_tupleTypeAnnotation: typeof tupleTypeAnnotation;
declare const index_d$1_typeAlias: typeof typeAlias;
declare const index_d$1_typeAnnotation: typeof typeAnnotation;
declare const index_d$1_typeCastExpression: typeof typeCastExpression;
declare const index_d$1_typeParameter: typeof typeParameter;
declare const index_d$1_typeParameterDeclaration: typeof typeParameterDeclaration;
declare const index_d$1_typeParameterInstantiation: typeof typeParameterInstantiation;
declare const index_d$1_typeofTypeAnnotation: typeof typeofTypeAnnotation;
declare const index_d$1_unaryExpression: typeof unaryExpression;
declare const index_d$1_unionTypeAnnotation: typeof unionTypeAnnotation;
declare const index_d$1_updateExpression: typeof updateExpression;
declare const index_d$1_v8IntrinsicIdentifier: typeof v8IntrinsicIdentifier;
declare const index_d$1_validate: typeof validate;
declare const index_d$1_variableDeclaration: typeof variableDeclaration;
declare const index_d$1_variableDeclarator: typeof variableDeclarator;
declare const index_d$1_variance: typeof variance;
declare const index_d$1_voidPattern: typeof voidPattern;
declare const index_d$1_voidTypeAnnotation: typeof voidTypeAnnotation;
declare const index_d$1_whileStatement: typeof whileStatement;
declare const index_d$1_withStatement: typeof withStatement;
declare const index_d$1_yieldExpression: typeof yieldExpression;
declare namespace index_d$1 {
  export { index_d$1_ACCESSOR_TYPES as ACCESSOR_TYPES, index_d$1_ALIAS_KEYS as ALIAS_KEYS, index_d$1_ASSIGNMENT_OPERATORS as ASSIGNMENT_OPERATORS, type index_d$1_Accessor as Accessor, type index_d$1_Aliases as Aliases, type index_d$1_AnyTypeAnnotation as AnyTypeAnnotation, type index_d$1_ArgumentPlaceholder as ArgumentPlaceholder, type index_d$1_ArrayExpression as ArrayExpression, type index_d$1_ArrayPattern as ArrayPattern, type index_d$1_ArrayTypeAnnotation as ArrayTypeAnnotation, type index_d$1_ArrowFunctionExpression as ArrowFunctionExpression, type index_d$1_AssignmentExpression as AssignmentExpression, type index_d$1_AssignmentPattern as AssignmentPattern, type index_d$1_AwaitExpression as AwaitExpression, index_d$1_BINARY_OPERATORS as BINARY_OPERATORS, index_d$1_BINARY_TYPES as BINARY_TYPES, index_d$1_BLOCKPARENT_TYPES as BLOCKPARENT_TYPES, index_d$1_BLOCK_TYPES as BLOCK_TYPES, index_d$1_BOOLEAN_BINARY_OPERATORS as BOOLEAN_BINARY_OPERATORS, index_d$1_BOOLEAN_NUMBER_BINARY_OPERATORS as BOOLEAN_NUMBER_BINARY_OPERATORS, index_d$1_BOOLEAN_UNARY_OPERATORS as BOOLEAN_UNARY_OPERATORS, index_d$1_BUILDER_KEYS as BUILDER_KEYS, type index_d$1_BigIntLiteral as BigIntLiteral, type index_d$1_Binary as Binary, type index_d$1_BinaryExpression as BinaryExpression, type index_d$1_BindExpression as BindExpression, type index_d$1_Block as Block, type index_d$1_BlockParent as BlockParent, type index_d$1_BlockStatement as BlockStatement, type index_d$1_BooleanLiteral as BooleanLiteral, type index_d$1_BooleanLiteralTypeAnnotation as BooleanLiteralTypeAnnotation, type index_d$1_BooleanTypeAnnotation as BooleanTypeAnnotation, type index_d$1_BreakStatement as BreakStatement, index_d$1_CLASS_TYPES as CLASS_TYPES, index_d$1_COMMENT_KEYS as COMMENT_KEYS, index_d$1_COMPARISON_BINARY_OPERATORS as COMPARISON_BINARY_OPERATORS, index_d$1_COMPLETIONSTATEMENT_TYPES as COMPLETIONSTATEMENT_TYPES, index_d$1_CONDITIONAL_TYPES as CONDITIONAL_TYPES, type index_d$1_CallExpression as CallExpression, type index_d$1_CatchClause as CatchClause, type index_d$1_Class as Class, type index_d$1_ClassAccessorProperty as ClassAccessorProperty, type index_d$1_ClassBody as ClassBody, type index_d$1_ClassDeclaration as ClassDeclaration, type index_d$1_ClassExpression as ClassExpression, type index_d$1_ClassImplements as ClassImplements, type index_d$1_ClassMethod as ClassMethod, type index_d$1_ClassPrivateMethod as ClassPrivateMethod, type index_d$1_ClassPrivateProperty as ClassPrivateProperty, type index_d$1_ClassProperty as ClassProperty, type index_d$1_Comment as Comment, type index_d$1_CommentBlock as CommentBlock, type index_d$1_CommentLine as CommentLine, type index_d$1_CommentTypeShorthand as CommentTypeShorthand, type index_d$1_CompletionStatement as CompletionStatement, type index_d$1_Conditional as Conditional, type index_d$1_ConditionalExpression as ConditionalExpression, type index_d$1_ContinueStatement as ContinueStatement, index_d$1_DECLARATION_TYPES as DECLARATION_TYPES, index_d$1_DEPRECATED_ALIASES as DEPRECATED_ALIASES, index_d$1_DEPRECATED_KEYS as DEPRECATED_KEYS, type index_d$1_DebuggerStatement as DebuggerStatement, type index_d$1_DecimalLiteral as DecimalLiteral, type index_d$1_Declaration as Declaration, type index_d$1_DeclareClass as DeclareClass, type index_d$1_DeclareExportAllDeclaration as DeclareExportAllDeclaration, type index_d$1_DeclareExportDeclaration as DeclareExportDeclaration, type index_d$1_DeclareFunction as DeclareFunction, type index_d$1_DeclareInterface as DeclareInterface, type index_d$1_DeclareModule as DeclareModule, type index_d$1_DeclareModuleExports as DeclareModuleExports, type index_d$1_DeclareOpaqueType as DeclareOpaqueType, type index_d$1_DeclareTypeAlias as DeclareTypeAlias, type index_d$1_DeclareVariable as DeclareVariable, type index_d$1_DeclaredPredicate as DeclaredPredicate, type index_d$1_Decorator as Decorator, type index_d$1_DeprecatedAliases as DeprecatedAliases, type index_d$1_Directive as Directive, type index_d$1_DirectiveLiteral as DirectiveLiteral, type index_d$1_DoExpression as DoExpression, type index_d$1_DoWhileStatement as DoWhileStatement, index_d$1_ENUMBODY_TYPES as ENUMBODY_TYPES, index_d$1_ENUMMEMBER_TYPES as ENUMMEMBER_TYPES, index_d$1_EQUALITY_BINARY_OPERATORS as EQUALITY_BINARY_OPERATORS, index_d$1_EXPORTDECLARATION_TYPES as EXPORTDECLARATION_TYPES, index_d$1_EXPRESSIONWRAPPER_TYPES as EXPRESSIONWRAPPER_TYPES, index_d$1_EXPRESSION_TYPES as EXPRESSION_TYPES, type index_d$1_EmptyStatement as EmptyStatement, type index_d$1_EmptyTypeAnnotation as EmptyTypeAnnotation, type index_d$1_EnumBody as EnumBody, type index_d$1_EnumBooleanBody as EnumBooleanBody, type index_d$1_EnumBooleanMember as EnumBooleanMember, type index_d$1_EnumDeclaration as EnumDeclaration, type index_d$1_EnumDefaultedMember as EnumDefaultedMember, type index_d$1_EnumMember as EnumMember, type index_d$1_EnumNumberBody as EnumNumberBody, type index_d$1_EnumNumberMember as EnumNumberMember, type index_d$1_EnumStringBody as EnumStringBody, type index_d$1_EnumStringMember as EnumStringMember, type index_d$1_EnumSymbolBody as EnumSymbolBody, type index_d$1_ExistsTypeAnnotation as ExistsTypeAnnotation, type index_d$1_ExportAllDeclaration as ExportAllDeclaration, type index_d$1_ExportDeclaration as ExportDeclaration, type index_d$1_ExportDefaultDeclaration as ExportDefaultDeclaration, type index_d$1_ExportDefaultSpecifier as ExportDefaultSpecifier, type index_d$1_ExportNamedDeclaration as ExportNamedDeclaration, type index_d$1_ExportNamespaceSpecifier as ExportNamespaceSpecifier, type index_d$1_ExportSpecifier as ExportSpecifier, type index_d$1_Expression as Expression, type index_d$1_ExpressionStatement as ExpressionStatement, type index_d$1_ExpressionWrapper as ExpressionWrapper, index_d$1_FLATTENABLE_KEYS as FLATTENABLE_KEYS, index_d$1_FLIPPED_ALIAS_KEYS as FLIPPED_ALIAS_KEYS, index_d$1_FLOWBASEANNOTATION_TYPES as FLOWBASEANNOTATION_TYPES, index_d$1_FLOWDECLARATION_TYPES as FLOWDECLARATION_TYPES, index_d$1_FLOWPREDICATE_TYPES as FLOWPREDICATE_TYPES, index_d$1_FLOWTYPE_TYPES as FLOWTYPE_TYPES, index_d$1_FLOW_TYPES as FLOW_TYPES, index_d$1_FORXSTATEMENT_TYPES as FORXSTATEMENT_TYPES, index_d$1_FOR_INIT_KEYS as FOR_INIT_KEYS, index_d$1_FOR_TYPES as FOR_TYPES, index_d$1_FUNCTIONPARAMETER_TYPES as FUNCTIONPARAMETER_TYPES, index_d$1_FUNCTIONPARENT_TYPES as FUNCTIONPARENT_TYPES, index_d$1_FUNCTION_TYPES as FUNCTION_TYPES, type index_d$1_FieldOptions as FieldOptions, type index_d$1_File as File, type index_d$1_Flow as Flow, type index_d$1_FlowBaseAnnotation as FlowBaseAnnotation, type index_d$1_FlowDeclaration as FlowDeclaration, type index_d$1_FlowPredicate as FlowPredicate, type index_d$1_FlowType as FlowType, type index_d$1_For as For, type index_d$1_ForInStatement as ForInStatement, type index_d$1_ForOfStatement as ForOfStatement, type index_d$1_ForStatement as ForStatement, type index_d$1_ForXStatement as ForXStatement, type index_d$1_Function as Function, type index_d$1_FunctionDeclaration as FunctionDeclaration, type index_d$1_FunctionExpression as FunctionExpression, type index_d$1_FunctionParameter as FunctionParameter, type index_d$1_FunctionParent as FunctionParent, type index_d$1_FunctionTypeAnnotation as FunctionTypeAnnotation, type index_d$1_FunctionTypeParam as FunctionTypeParam, type index_d$1_GenericTypeAnnotation as GenericTypeAnnotation, index_d$1_IMMUTABLE_TYPES as IMMUTABLE_TYPES, index_d$1_IMPORTOREXPORTDECLARATION_TYPES as IMPORTOREXPORTDECLARATION_TYPES, index_d$1_INHERIT_KEYS as INHERIT_KEYS, type index_d$1_Identifier as Identifier, type index_d$1_IfStatement as IfStatement, type index_d$1_Immutable as Immutable, type index_d$1_Import as Import, type index_d$1_ImportAttribute as ImportAttribute, type index_d$1_ImportDeclaration as ImportDeclaration, type index_d$1_ImportDefaultSpecifier as ImportDefaultSpecifier, type index_d$1_ImportExpression as ImportExpression, type index_d$1_ImportNamespaceSpecifier as ImportNamespaceSpecifier, type index_d$1_ImportOrExportDeclaration as ImportOrExportDeclaration, type index_d$1_ImportSpecifier as ImportSpecifier, type index_d$1_IndexedAccessType as IndexedAccessType, type index_d$1_InferredPredicate as InferredPredicate, type index_d$1_InterfaceDeclaration as InterfaceDeclaration, type index_d$1_InterfaceExtends as InterfaceExtends, type index_d$1_InterfaceTypeAnnotation as InterfaceTypeAnnotation, type index_d$1_InterpreterDirective as InterpreterDirective, type index_d$1_IntersectionTypeAnnotation as IntersectionTypeAnnotation, type index_d$1_JSX as JSX, type index_d$1_JSXAttribute as JSXAttribute, type index_d$1_JSXClosingElement as JSXClosingElement, type index_d$1_JSXClosingFragment as JSXClosingFragment, type index_d$1_JSXElement as JSXElement, type index_d$1_JSXEmptyExpression as JSXEmptyExpression, type index_d$1_JSXExpressionContainer as JSXExpressionContainer, type index_d$1_JSXFragment as JSXFragment, type index_d$1_JSXIdentifier as JSXIdentifier, type index_d$1_JSXMemberExpression as JSXMemberExpression, type index_d$1_JSXNamespacedName as JSXNamespacedName, type index_d$1_JSXOpeningElement as JSXOpeningElement, type index_d$1_JSXOpeningFragment as JSXOpeningFragment, type index_d$1_JSXSpreadAttribute as JSXSpreadAttribute, type index_d$1_JSXSpreadChild as JSXSpreadChild, type index_d$1_JSXText as JSXText, index_d$1_JSX_TYPES as JSX_TYPES, index_d$1_LITERAL_TYPES as LITERAL_TYPES, index_d$1_LOGICAL_OPERATORS as LOGICAL_OPERATORS, index_d$1_LOOP_TYPES as LOOP_TYPES, index_d$1_LVAL_TYPES as LVAL_TYPES, type index_d$1_LVal as LVal, type index_d$1_LabeledStatement as LabeledStatement, type index_d$1_Literal as Literal, type index_d$1_LogicalExpression as LogicalExpression, type index_d$1_Loop as Loop, index_d$1_METHOD_TYPES as METHOD_TYPES, index_d$1_MISCELLANEOUS_TYPES as MISCELLANEOUS_TYPES, index_d$1_MODULEDECLARATION_TYPES as MODULEDECLARATION_TYPES, index_d$1_MODULESPECIFIER_TYPES as MODULESPECIFIER_TYPES, type index_d$1_MemberExpression as MemberExpression, type index_d$1_MetaProperty as MetaProperty, type index_d$1_Method as Method, type index_d$1_Miscellaneous as Miscellaneous, type index_d$1_MixedTypeAnnotation as MixedTypeAnnotation, type index_d$1_ModuleDeclaration as ModuleDeclaration, type index_d$1_ModuleExpression as ModuleExpression, type index_d$1_ModuleSpecifier as ModuleSpecifier, index_d$1_NODE_FIELDS as NODE_FIELDS, index_d$1_NODE_PARENT_VALIDATIONS as NODE_PARENT_VALIDATIONS, index_d$1_NUMBER_BINARY_OPERATORS as NUMBER_BINARY_OPERATORS, index_d$1_NUMBER_UNARY_OPERATORS as NUMBER_UNARY_OPERATORS, type index_d$1_NewExpression as NewExpression, type Node$1 as Node, type index_d$1_Noop as Noop, type index_d$1_NullLiteral as NullLiteral, type index_d$1_NullLiteralTypeAnnotation as NullLiteralTypeAnnotation, type index_d$1_NullableTypeAnnotation as NullableTypeAnnotation, type NumberLiteral$1 as NumberLiteral, type index_d$1_NumberLiteralTypeAnnotation as NumberLiteralTypeAnnotation, type index_d$1_NumberTypeAnnotation as NumberTypeAnnotation, type index_d$1_NumericLiteral as NumericLiteral, index_d$1_OBJECTMEMBER_TYPES as OBJECTMEMBER_TYPES, type index_d$1_ObjectExpression as ObjectExpression, type index_d$1_ObjectMember as ObjectMember, type index_d$1_ObjectMethod as ObjectMethod, type index_d$1_ObjectPattern as ObjectPattern, type index_d$1_ObjectProperty as ObjectProperty, type index_d$1_ObjectTypeAnnotation as ObjectTypeAnnotation, type index_d$1_ObjectTypeCallProperty as ObjectTypeCallProperty, type index_d$1_ObjectTypeIndexer as ObjectTypeIndexer, type index_d$1_ObjectTypeInternalSlot as ObjectTypeInternalSlot, type index_d$1_ObjectTypeProperty as ObjectTypeProperty, type index_d$1_ObjectTypeSpreadProperty as ObjectTypeSpreadProperty, type index_d$1_OpaqueType as OpaqueType, type index_d$1_OptionalCallExpression as OptionalCallExpression, type index_d$1_OptionalIndexedAccessType as OptionalIndexedAccessType, type index_d$1_OptionalMemberExpression as OptionalMemberExpression, index_d$1_PATTERNLIKE_TYPES as PATTERNLIKE_TYPES, index_d$1_PATTERN_TYPES as PATTERN_TYPES, index_d$1_PLACEHOLDERS as PLACEHOLDERS, index_d$1_PLACEHOLDERS_ALIAS as PLACEHOLDERS_ALIAS, index_d$1_PLACEHOLDERS_FLIPPED_ALIAS as PLACEHOLDERS_FLIPPED_ALIAS, index_d$1_PRIVATE_TYPES as PRIVATE_TYPES, index_d$1_PROPERTY_TYPES as PROPERTY_TYPES, index_d$1_PUREISH_TYPES as PUREISH_TYPES, type index_d$1_ParentMaps as ParentMaps, type index_d$1_ParenthesizedExpression as ParenthesizedExpression, type index_d$1_Pattern as Pattern, type index_d$1_PatternLike as PatternLike, type index_d$1_PipelineBareFunction as PipelineBareFunction, type index_d$1_PipelinePrimaryTopicReference as PipelinePrimaryTopicReference, type index_d$1_PipelineTopicExpression as PipelineTopicExpression, type index_d$1_Placeholder as Placeholder, type index_d$1_Private as Private, type index_d$1_PrivateName as PrivateName, type index_d$1_Program as Program, type index_d$1_Property as Property, type index_d$1_Pureish as Pureish, type index_d$1_QualifiedTypeIdentifier as QualifiedTypeIdentifier, type index_d$1_RecordExpression as RecordExpression, type index_d$1_RegExpLiteral as RegExpLiteral, type RegexLiteral$1 as RegexLiteral, type Options$1 as RemovePropertiesOptions, type index_d$1_RestElement as RestElement, type RestProperty$1 as RestProperty, type index_d$1_ReturnStatement as ReturnStatement, index_d$1_SCOPABLE_TYPES as SCOPABLE_TYPES, index_d$1_STANDARDIZED_TYPES as STANDARDIZED_TYPES, index_d$1_STATEMENT_OR_BLOCK_KEYS as STATEMENT_OR_BLOCK_KEYS, index_d$1_STATEMENT_TYPES as STATEMENT_TYPES, index_d$1_STRING_UNARY_OPERATORS as STRING_UNARY_OPERATORS, type index_d$1_Scopable as Scopable, type index_d$1_SequenceExpression as SequenceExpression, type index_d$1_SourceLocation as SourceLocation, type index_d$1_SpreadElement as SpreadElement, type SpreadProperty$1 as SpreadProperty, type index_d$1_Standardized as Standardized, type index_d$1_Statement as Statement, type index_d$1_StaticBlock as StaticBlock, type index_d$1_StringLiteral as StringLiteral, type index_d$1_StringLiteralTypeAnnotation as StringLiteralTypeAnnotation, type index_d$1_StringTypeAnnotation as StringTypeAnnotation, type index_d$1_Super as Super, type index_d$1_SwitchCase as SwitchCase, type index_d$1_SwitchStatement as SwitchStatement, type index_d$1_SymbolTypeAnnotation as SymbolTypeAnnotation, index_d$1_TERMINATORLESS_TYPES as TERMINATORLESS_TYPES, type index_d$1_TSAnyKeyword as TSAnyKeyword, type index_d$1_TSArrayType as TSArrayType, type index_d$1_TSAsExpression as TSAsExpression, index_d$1_TSBASETYPE_TYPES as TSBASETYPE_TYPES, type index_d$1_TSBaseType as TSBaseType, type index_d$1_TSBigIntKeyword as TSBigIntKeyword, type index_d$1_TSBooleanKeyword as TSBooleanKeyword, type index_d$1_TSCallSignatureDeclaration as TSCallSignatureDeclaration, type index_d$1_TSConditionalType as TSConditionalType, type index_d$1_TSConstructSignatureDeclaration as TSConstructSignatureDeclaration, type index_d$1_TSConstructorType as TSConstructorType, type index_d$1_TSDeclareFunction as TSDeclareFunction, type index_d$1_TSDeclareMethod as TSDeclareMethod, index_d$1_TSENTITYNAME_TYPES as TSENTITYNAME_TYPES, type index_d$1_TSEntityName as TSEntityName, type index_d$1_TSEnumBody as TSEnumBody, type index_d$1_TSEnumDeclaration as TSEnumDeclaration, type index_d$1_TSEnumMember as TSEnumMember, type index_d$1_TSExportAssignment as TSExportAssignment, type index_d$1_TSExpressionWithTypeArguments as TSExpressionWithTypeArguments, type index_d$1_TSExternalModuleReference as TSExternalModuleReference, type index_d$1_TSFunctionType as TSFunctionType, type index_d$1_TSImportEqualsDeclaration as TSImportEqualsDeclaration, type index_d$1_TSImportType as TSImportType, type index_d$1_TSIndexSignature as TSIndexSignature, type index_d$1_TSIndexedAccessType as TSIndexedAccessType, type index_d$1_TSInferType as TSInferType, type index_d$1_TSInstantiationExpression as TSInstantiationExpression, type index_d$1_TSInterfaceBody as TSInterfaceBody, type index_d$1_TSInterfaceDeclaration as TSInterfaceDeclaration, type index_d$1_TSIntersectionType as TSIntersectionType, type index_d$1_TSIntrinsicKeyword as TSIntrinsicKeyword, type index_d$1_TSLiteralType as TSLiteralType, type index_d$1_TSMappedType as TSMappedType, type index_d$1_TSMethodSignature as TSMethodSignature, type index_d$1_TSModuleBlock as TSModuleBlock, type index_d$1_TSModuleDeclaration as TSModuleDeclaration, type index_d$1_TSNamedTupleMember as TSNamedTupleMember, type index_d$1_TSNamespaceExportDeclaration as TSNamespaceExportDeclaration, type index_d$1_TSNeverKeyword as TSNeverKeyword, type index_d$1_TSNonNullExpression as TSNonNullExpression, type index_d$1_TSNullKeyword as TSNullKeyword, type index_d$1_TSNumberKeyword as TSNumberKeyword, type index_d$1_TSObjectKeyword as TSObjectKeyword, type index_d$1_TSOptionalType as TSOptionalType, type index_d$1_TSParameterProperty as TSParameterProperty, type index_d$1_TSParenthesizedType as TSParenthesizedType, type index_d$1_TSPropertySignature as TSPropertySignature, type index_d$1_TSQualifiedName as TSQualifiedName, type index_d$1_TSRestType as TSRestType, type index_d$1_TSSatisfiesExpression as TSSatisfiesExpression, type index_d$1_TSStringKeyword as TSStringKeyword, type index_d$1_TSSymbolKeyword as TSSymbolKeyword, index_d$1_TSTYPEELEMENT_TYPES as TSTYPEELEMENT_TYPES, index_d$1_TSTYPE_TYPES as TSTYPE_TYPES, type index_d$1_TSTemplateLiteralType as TSTemplateLiteralType, type index_d$1_TSThisType as TSThisType, type index_d$1_TSTupleType as TSTupleType, type index_d$1_TSType as TSType, type index_d$1_TSTypeAliasDeclaration as TSTypeAliasDeclaration, type index_d$1_TSTypeAnnotation as TSTypeAnnotation, type index_d$1_TSTypeAssertion as TSTypeAssertion, type index_d$1_TSTypeElement as TSTypeElement, type index_d$1_TSTypeLiteral as TSTypeLiteral, type index_d$1_TSTypeOperator as TSTypeOperator, type index_d$1_TSTypeParameter as TSTypeParameter, type index_d$1_TSTypeParameterDeclaration as TSTypeParameterDeclaration, type index_d$1_TSTypeParameterInstantiation as TSTypeParameterInstantiation, type index_d$1_TSTypePredicate as TSTypePredicate, type index_d$1_TSTypeQuery as TSTypeQuery, type index_d$1_TSTypeReference as TSTypeReference, type index_d$1_TSUndefinedKeyword as TSUndefinedKeyword, type index_d$1_TSUnionType as TSUnionType, type index_d$1_TSUnknownKeyword as TSUnknownKeyword, type index_d$1_TSVoidKeyword as TSVoidKeyword, index_d$1_TYPES as TYPES, index_d$1_TYPESCRIPT_TYPES as TYPESCRIPT_TYPES, type index_d$1_TaggedTemplateExpression as TaggedTemplateExpression, type index_d$1_TemplateElement as TemplateElement, type index_d$1_TemplateLiteral as TemplateLiteral, type index_d$1_Terminatorless as Terminatorless, type index_d$1_ThisExpression as ThisExpression, type index_d$1_ThisTypeAnnotation as ThisTypeAnnotation, type index_d$1_ThrowStatement as ThrowStatement, type index_d$1_TopicReference as TopicReference, type index_d$1_TraversalAncestors as TraversalAncestors, type index_d$1_TraversalHandler as TraversalHandler, type index_d$1_TraversalHandlers as TraversalHandlers, type index_d$1_TryStatement as TryStatement, type index_d$1_TupleExpression as TupleExpression, type index_d$1_TupleTypeAnnotation as TupleTypeAnnotation, type index_d$1_TypeAlias as TypeAlias, type index_d$1_TypeAnnotation as TypeAnnotation, type index_d$1_TypeCastExpression as TypeCastExpression, type index_d$1_TypeParameter as TypeParameter, type index_d$1_TypeParameterDeclaration as TypeParameterDeclaration, type index_d$1_TypeParameterInstantiation as TypeParameterInstantiation, type index_d$1_TypeScript as TypeScript, type index_d$1_TypeofTypeAnnotation as TypeofTypeAnnotation, index_d$1_UNARYLIKE_TYPES as UNARYLIKE_TYPES, index_d$1_UNARY_OPERATORS as UNARY_OPERATORS, index_d$1_UPDATE_OPERATORS as UPDATE_OPERATORS, index_d$1_USERWHITESPACABLE_TYPES as USERWHITESPACABLE_TYPES, type index_d$1_UnaryExpression as UnaryExpression, type index_d$1_UnaryLike as UnaryLike, type index_d$1_UnionTypeAnnotation as UnionTypeAnnotation, type index_d$1_UpdateExpression as UpdateExpression, type index_d$1_UserWhitespacable as UserWhitespacable, type index_d$1_V8IntrinsicIdentifier as V8IntrinsicIdentifier, index_d$1_VISITOR_KEYS as VISITOR_KEYS, type index_d$1_VariableDeclaration as VariableDeclaration, type index_d$1_VariableDeclarator as VariableDeclarator, type index_d$1_Variance as Variance, type index_d$1_VoidPattern as VoidPattern, type index_d$1_VoidTypeAnnotation as VoidTypeAnnotation, index_d$1_WHILE_TYPES as WHILE_TYPES, type index_d$1_While as While, type index_d$1_WhileStatement as WhileStatement, type index_d$1_WithStatement as WithStatement, type index_d$1_YieldExpression as YieldExpression, deprecationWarning as __internal__deprecationWarning, index_d$1_addComment as addComment, index_d$1_addComments as addComments, index_d$1_anyTypeAnnotation as anyTypeAnnotation, index_d$1_appendToMemberExpression as appendToMemberExpression, index_d$1_argumentPlaceholder as argumentPlaceholder, index_d$1_arrayExpression as arrayExpression, index_d$1_arrayPattern as arrayPattern, index_d$1_arrayTypeAnnotation as arrayTypeAnnotation, index_d$1_arrowFunctionExpression as arrowFunctionExpression, index_d$1_assertAccessor as assertAccessor, index_d$1_assertAnyTypeAnnotation as assertAnyTypeAnnotation, index_d$1_assertArgumentPlaceholder as assertArgumentPlaceholder, index_d$1_assertArrayExpression as assertArrayExpression, index_d$1_assertArrayPattern as assertArrayPattern, index_d$1_assertArrayTypeAnnotation as assertArrayTypeAnnotation, index_d$1_assertArrowFunctionExpression as assertArrowFunctionExpression, index_d$1_assertAssignmentExpression as assertAssignmentExpression, index_d$1_assertAssignmentPattern as assertAssignmentPattern, index_d$1_assertAwaitExpression as assertAwaitExpression, index_d$1_assertBigIntLiteral as assertBigIntLiteral, index_d$1_assertBinary as assertBinary, index_d$1_assertBinaryExpression as assertBinaryExpression, index_d$1_assertBindExpression as assertBindExpression, index_d$1_assertBlock as assertBlock, index_d$1_assertBlockParent as assertBlockParent, index_d$1_assertBlockStatement as assertBlockStatement, index_d$1_assertBooleanLiteral as assertBooleanLiteral, index_d$1_assertBooleanLiteralTypeAnnotation as assertBooleanLiteralTypeAnnotation, index_d$1_assertBooleanTypeAnnotation as assertBooleanTypeAnnotation, index_d$1_assertBreakStatement as assertBreakStatement, index_d$1_assertCallExpression as assertCallExpression, index_d$1_assertCatchClause as assertCatchClause, index_d$1_assertClass as assertClass, index_d$1_assertClassAccessorProperty as assertClassAccessorProperty, index_d$1_assertClassBody as assertClassBody, index_d$1_assertClassDeclaration as assertClassDeclaration, index_d$1_assertClassExpression as assertClassExpression, index_d$1_assertClassImplements as assertClassImplements, index_d$1_assertClassMethod as assertClassMethod, index_d$1_assertClassPrivateMethod as assertClassPrivateMethod, index_d$1_assertClassPrivateProperty as assertClassPrivateProperty, index_d$1_assertClassProperty as assertClassProperty, index_d$1_assertCompletionStatement as assertCompletionStatement, index_d$1_assertConditional as assertConditional, index_d$1_assertConditionalExpression as assertConditionalExpression, index_d$1_assertContinueStatement as assertContinueStatement, index_d$1_assertDebuggerStatement as assertDebuggerStatement, index_d$1_assertDecimalLiteral as assertDecimalLiteral, index_d$1_assertDeclaration as assertDeclaration, index_d$1_assertDeclareClass as assertDeclareClass, index_d$1_assertDeclareExportAllDeclaration as assertDeclareExportAllDeclaration, index_d$1_assertDeclareExportDeclaration as assertDeclareExportDeclaration, index_d$1_assertDeclareFunction as assertDeclareFunction, index_d$1_assertDeclareInterface as assertDeclareInterface, index_d$1_assertDeclareModule as assertDeclareModule, index_d$1_assertDeclareModuleExports as assertDeclareModuleExports, index_d$1_assertDeclareOpaqueType as assertDeclareOpaqueType, index_d$1_assertDeclareTypeAlias as assertDeclareTypeAlias, index_d$1_assertDeclareVariable as assertDeclareVariable, index_d$1_assertDeclaredPredicate as assertDeclaredPredicate, index_d$1_assertDecorator as assertDecorator, index_d$1_assertDirective as assertDirective, index_d$1_assertDirectiveLiteral as assertDirectiveLiteral, index_d$1_assertDoExpression as assertDoExpression, index_d$1_assertDoWhileStatement as assertDoWhileStatement, index_d$1_assertEmptyStatement as assertEmptyStatement, index_d$1_assertEmptyTypeAnnotation as assertEmptyTypeAnnotation, index_d$1_assertEnumBody as assertEnumBody, index_d$1_assertEnumBooleanBody as assertEnumBooleanBody, index_d$1_assertEnumBooleanMember as assertEnumBooleanMember, index_d$1_assertEnumDeclaration as assertEnumDeclaration, index_d$1_assertEnumDefaultedMember as assertEnumDefaultedMember, index_d$1_assertEnumMember as assertEnumMember, index_d$1_assertEnumNumberBody as assertEnumNumberBody, index_d$1_assertEnumNumberMember as assertEnumNumberMember, index_d$1_assertEnumStringBody as assertEnumStringBody, index_d$1_assertEnumStringMember as assertEnumStringMember, index_d$1_assertEnumSymbolBody as assertEnumSymbolBody, index_d$1_assertExistsTypeAnnotation as assertExistsTypeAnnotation, index_d$1_assertExportAllDeclaration as assertExportAllDeclaration, index_d$1_assertExportDeclaration as assertExportDeclaration, index_d$1_assertExportDefaultDeclaration as assertExportDefaultDeclaration, index_d$1_assertExportDefaultSpecifier as assertExportDefaultSpecifier, index_d$1_assertExportNamedDeclaration as assertExportNamedDeclaration, index_d$1_assertExportNamespaceSpecifier as assertExportNamespaceSpecifier, index_d$1_assertExportSpecifier as assertExportSpecifier, index_d$1_assertExpression as assertExpression, index_d$1_assertExpressionStatement as assertExpressionStatement, index_d$1_assertExpressionWrapper as assertExpressionWrapper, index_d$1_assertFile as assertFile, index_d$1_assertFlow as assertFlow, index_d$1_assertFlowBaseAnnotation as assertFlowBaseAnnotation, index_d$1_assertFlowDeclaration as assertFlowDeclaration, index_d$1_assertFlowPredicate as assertFlowPredicate, index_d$1_assertFlowType as assertFlowType, index_d$1_assertFor as assertFor, index_d$1_assertForInStatement as assertForInStatement, index_d$1_assertForOfStatement as assertForOfStatement, index_d$1_assertForStatement as assertForStatement, index_d$1_assertForXStatement as assertForXStatement, index_d$1_assertFunction as assertFunction, index_d$1_assertFunctionDeclaration as assertFunctionDeclaration, index_d$1_assertFunctionExpression as assertFunctionExpression, index_d$1_assertFunctionParameter as assertFunctionParameter, index_d$1_assertFunctionParent as assertFunctionParent, index_d$1_assertFunctionTypeAnnotation as assertFunctionTypeAnnotation, index_d$1_assertFunctionTypeParam as assertFunctionTypeParam, index_d$1_assertGenericTypeAnnotation as assertGenericTypeAnnotation, index_d$1_assertIdentifier as assertIdentifier, index_d$1_assertIfStatement as assertIfStatement, index_d$1_assertImmutable as assertImmutable, index_d$1_assertImport as assertImport, index_d$1_assertImportAttribute as assertImportAttribute, index_d$1_assertImportDeclaration as assertImportDeclaration, index_d$1_assertImportDefaultSpecifier as assertImportDefaultSpecifier, index_d$1_assertImportExpression as assertImportExpression, index_d$1_assertImportNamespaceSpecifier as assertImportNamespaceSpecifier, index_d$1_assertImportOrExportDeclaration as assertImportOrExportDeclaration, index_d$1_assertImportSpecifier as assertImportSpecifier, index_d$1_assertIndexedAccessType as assertIndexedAccessType, index_d$1_assertInferredPredicate as assertInferredPredicate, index_d$1_assertInterfaceDeclaration as assertInterfaceDeclaration, index_d$1_assertInterfaceExtends as assertInterfaceExtends, index_d$1_assertInterfaceTypeAnnotation as assertInterfaceTypeAnnotation, index_d$1_assertInterpreterDirective as assertInterpreterDirective, index_d$1_assertIntersectionTypeAnnotation as assertIntersectionTypeAnnotation, index_d$1_assertJSX as assertJSX, index_d$1_assertJSXAttribute as assertJSXAttribute, index_d$1_assertJSXClosingElement as assertJSXClosingElement, index_d$1_assertJSXClosingFragment as assertJSXClosingFragment, index_d$1_assertJSXElement as assertJSXElement, index_d$1_assertJSXEmptyExpression as assertJSXEmptyExpression, index_d$1_assertJSXExpressionContainer as assertJSXExpressionContainer, index_d$1_assertJSXFragment as assertJSXFragment, index_d$1_assertJSXIdentifier as assertJSXIdentifier, index_d$1_assertJSXMemberExpression as assertJSXMemberExpression, index_d$1_assertJSXNamespacedName as assertJSXNamespacedName, index_d$1_assertJSXOpeningElement as assertJSXOpeningElement, index_d$1_assertJSXOpeningFragment as assertJSXOpeningFragment, index_d$1_assertJSXSpreadAttribute as assertJSXSpreadAttribute, index_d$1_assertJSXSpreadChild as assertJSXSpreadChild, index_d$1_assertJSXText as assertJSXText, index_d$1_assertLVal as assertLVal, index_d$1_assertLabeledStatement as assertLabeledStatement, index_d$1_assertLiteral as assertLiteral, index_d$1_assertLogicalExpression as assertLogicalExpression, index_d$1_assertLoop as assertLoop, index_d$1_assertMemberExpression as assertMemberExpression, index_d$1_assertMetaProperty as assertMetaProperty, index_d$1_assertMethod as assertMethod, index_d$1_assertMiscellaneous as assertMiscellaneous, index_d$1_assertMixedTypeAnnotation as assertMixedTypeAnnotation, index_d$1_assertModuleDeclaration as assertModuleDeclaration, index_d$1_assertModuleExpression as assertModuleExpression, index_d$1_assertModuleSpecifier as assertModuleSpecifier, index_d$1_assertNewExpression as assertNewExpression, index_d$1_assertNode as assertNode, index_d$1_assertNoop as assertNoop, index_d$1_assertNullLiteral as assertNullLiteral, index_d$1_assertNullLiteralTypeAnnotation as assertNullLiteralTypeAnnotation, index_d$1_assertNullableTypeAnnotation as assertNullableTypeAnnotation, index_d$1_assertNumberLiteral as assertNumberLiteral, index_d$1_assertNumberLiteralTypeAnnotation as assertNumberLiteralTypeAnnotation, index_d$1_assertNumberTypeAnnotation as assertNumberTypeAnnotation, index_d$1_assertNumericLiteral as assertNumericLiteral, index_d$1_assertObjectExpression as assertObjectExpression, index_d$1_assertObjectMember as assertObjectMember, index_d$1_assertObjectMethod as assertObjectMethod, index_d$1_assertObjectPattern as assertObjectPattern, index_d$1_assertObjectProperty as assertObjectProperty, index_d$1_assertObjectTypeAnnotation as assertObjectTypeAnnotation, index_d$1_assertObjectTypeCallProperty as assertObjectTypeCallProperty, index_d$1_assertObjectTypeIndexer as assertObjectTypeIndexer, index_d$1_assertObjectTypeInternalSlot as assertObjectTypeInternalSlot, index_d$1_assertObjectTypeProperty as assertObjectTypeProperty, index_d$1_assertObjectTypeSpreadProperty as assertObjectTypeSpreadProperty, index_d$1_assertOpaqueType as assertOpaqueType, index_d$1_assertOptionalCallExpression as assertOptionalCallExpression, index_d$1_assertOptionalIndexedAccessType as assertOptionalIndexedAccessType, index_d$1_assertOptionalMemberExpression as assertOptionalMemberExpression, index_d$1_assertParenthesizedExpression as assertParenthesizedExpression, index_d$1_assertPattern as assertPattern, index_d$1_assertPatternLike as assertPatternLike, index_d$1_assertPipelineBareFunction as assertPipelineBareFunction, index_d$1_assertPipelinePrimaryTopicReference as assertPipelinePrimaryTopicReference, index_d$1_assertPipelineTopicExpression as assertPipelineTopicExpression, index_d$1_assertPlaceholder as assertPlaceholder, index_d$1_assertPrivate as assertPrivate, index_d$1_assertPrivateName as assertPrivateName, index_d$1_assertProgram as assertProgram, index_d$1_assertProperty as assertProperty, index_d$1_assertPureish as assertPureish, index_d$1_assertQualifiedTypeIdentifier as assertQualifiedTypeIdentifier, index_d$1_assertRecordExpression as assertRecordExpression, index_d$1_assertRegExpLiteral as assertRegExpLiteral, index_d$1_assertRegexLiteral as assertRegexLiteral, index_d$1_assertRestElement as assertRestElement, index_d$1_assertRestProperty as assertRestProperty, index_d$1_assertReturnStatement as assertReturnStatement, index_d$1_assertScopable as assertScopable, index_d$1_assertSequenceExpression as assertSequenceExpression, index_d$1_assertSpreadElement as assertSpreadElement, index_d$1_assertSpreadProperty as assertSpreadProperty, index_d$1_assertStandardized as assertStandardized, index_d$1_assertStatement as assertStatement, index_d$1_assertStaticBlock as assertStaticBlock, index_d$1_assertStringLiteral as assertStringLiteral, index_d$1_assertStringLiteralTypeAnnotation as assertStringLiteralTypeAnnotation, index_d$1_assertStringTypeAnnotation as assertStringTypeAnnotation, index_d$1_assertSuper as assertSuper, index_d$1_assertSwitchCase as assertSwitchCase, index_d$1_assertSwitchStatement as assertSwitchStatement, index_d$1_assertSymbolTypeAnnotation as assertSymbolTypeAnnotation, index_d$1_assertTSAnyKeyword as assertTSAnyKeyword, index_d$1_assertTSArrayType as assertTSArrayType, index_d$1_assertTSAsExpression as assertTSAsExpression, index_d$1_assertTSBaseType as assertTSBaseType, index_d$1_assertTSBigIntKeyword as assertTSBigIntKeyword, index_d$1_assertTSBooleanKeyword as assertTSBooleanKeyword, index_d$1_assertTSCallSignatureDeclaration as assertTSCallSignatureDeclaration, index_d$1_assertTSConditionalType as assertTSConditionalType, index_d$1_assertTSConstructSignatureDeclaration as assertTSConstructSignatureDeclaration, index_d$1_assertTSConstructorType as assertTSConstructorType, index_d$1_assertTSDeclareFunction as assertTSDeclareFunction, index_d$1_assertTSDeclareMethod as assertTSDeclareMethod, index_d$1_assertTSEntityName as assertTSEntityName, index_d$1_assertTSEnumBody as assertTSEnumBody, index_d$1_assertTSEnumDeclaration as assertTSEnumDeclaration, index_d$1_assertTSEnumMember as assertTSEnumMember, index_d$1_assertTSExportAssignment as assertTSExportAssignment, index_d$1_assertTSExpressionWithTypeArguments as assertTSExpressionWithTypeArguments, index_d$1_assertTSExternalModuleReference as assertTSExternalModuleReference, index_d$1_assertTSFunctionType as assertTSFunctionType, index_d$1_assertTSImportEqualsDeclaration as assertTSImportEqualsDeclaration, index_d$1_assertTSImportType as assertTSImportType, index_d$1_assertTSIndexSignature as assertTSIndexSignature, index_d$1_assertTSIndexedAccessType as assertTSIndexedAccessType, index_d$1_assertTSInferType as assertTSInferType, index_d$1_assertTSInstantiationExpression as assertTSInstantiationExpression, index_d$1_assertTSInterfaceBody as assertTSInterfaceBody, index_d$1_assertTSInterfaceDeclaration as assertTSInterfaceDeclaration, index_d$1_assertTSIntersectionType as assertTSIntersectionType, index_d$1_assertTSIntrinsicKeyword as assertTSIntrinsicKeyword, index_d$1_assertTSLiteralType as assertTSLiteralType, index_d$1_assertTSMappedType as assertTSMappedType, index_d$1_assertTSMethodSignature as assertTSMethodSignature, index_d$1_assertTSModuleBlock as assertTSModuleBlock, index_d$1_assertTSModuleDeclaration as assertTSModuleDeclaration, index_d$1_assertTSNamedTupleMember as assertTSNamedTupleMember, index_d$1_assertTSNamespaceExportDeclaration as assertTSNamespaceExportDeclaration, index_d$1_assertTSNeverKeyword as assertTSNeverKeyword, index_d$1_assertTSNonNullExpression as assertTSNonNullExpression, index_d$1_assertTSNullKeyword as assertTSNullKeyword, index_d$1_assertTSNumberKeyword as assertTSNumberKeyword, index_d$1_assertTSObjectKeyword as assertTSObjectKeyword, index_d$1_assertTSOptionalType as assertTSOptionalType, index_d$1_assertTSParameterProperty as assertTSParameterProperty, index_d$1_assertTSParenthesizedType as assertTSParenthesizedType, index_d$1_assertTSPropertySignature as assertTSPropertySignature, index_d$1_assertTSQualifiedName as assertTSQualifiedName, index_d$1_assertTSRestType as assertTSRestType, index_d$1_assertTSSatisfiesExpression as assertTSSatisfiesExpression, index_d$1_assertTSStringKeyword as assertTSStringKeyword, index_d$1_assertTSSymbolKeyword as assertTSSymbolKeyword, index_d$1_assertTSTemplateLiteralType as assertTSTemplateLiteralType, index_d$1_assertTSThisType as assertTSThisType, index_d$1_assertTSTupleType as assertTSTupleType, index_d$1_assertTSType as assertTSType, index_d$1_assertTSTypeAliasDeclaration as assertTSTypeAliasDeclaration, index_d$1_assertTSTypeAnnotation as assertTSTypeAnnotation, index_d$1_assertTSTypeAssertion as assertTSTypeAssertion, index_d$1_assertTSTypeElement as assertTSTypeElement, index_d$1_assertTSTypeLiteral as assertTSTypeLiteral, index_d$1_assertTSTypeOperator as assertTSTypeOperator, index_d$1_assertTSTypeParameter as assertTSTypeParameter, index_d$1_assertTSTypeParameterDeclaration as assertTSTypeParameterDeclaration, index_d$1_assertTSTypeParameterInstantiation as assertTSTypeParameterInstantiation, index_d$1_assertTSTypePredicate as assertTSTypePredicate, index_d$1_assertTSTypeQuery as assertTSTypeQuery, index_d$1_assertTSTypeReference as assertTSTypeReference, index_d$1_assertTSUndefinedKeyword as assertTSUndefinedKeyword, index_d$1_assertTSUnionType as assertTSUnionType, index_d$1_assertTSUnknownKeyword as assertTSUnknownKeyword, index_d$1_assertTSVoidKeyword as assertTSVoidKeyword, index_d$1_assertTaggedTemplateExpression as assertTaggedTemplateExpression, index_d$1_assertTemplateElement as assertTemplateElement, index_d$1_assertTemplateLiteral as assertTemplateLiteral, index_d$1_assertTerminatorless as assertTerminatorless, index_d$1_assertThisExpression as assertThisExpression, index_d$1_assertThisTypeAnnotation as assertThisTypeAnnotation, index_d$1_assertThrowStatement as assertThrowStatement, index_d$1_assertTopicReference as assertTopicReference, index_d$1_assertTryStatement as assertTryStatement, index_d$1_assertTupleExpression as assertTupleExpression, index_d$1_assertTupleTypeAnnotation as assertTupleTypeAnnotation, index_d$1_assertTypeAlias as assertTypeAlias, index_d$1_assertTypeAnnotation as assertTypeAnnotation, index_d$1_assertTypeCastExpression as assertTypeCastExpression, index_d$1_assertTypeParameter as assertTypeParameter, index_d$1_assertTypeParameterDeclaration as assertTypeParameterDeclaration, index_d$1_assertTypeParameterInstantiation as assertTypeParameterInstantiation, index_d$1_assertTypeScript as assertTypeScript, index_d$1_assertTypeofTypeAnnotation as assertTypeofTypeAnnotation, index_d$1_assertUnaryExpression as assertUnaryExpression, index_d$1_assertUnaryLike as assertUnaryLike, index_d$1_assertUnionTypeAnnotation as assertUnionTypeAnnotation, index_d$1_assertUpdateExpression as assertUpdateExpression, index_d$1_assertUserWhitespacable as assertUserWhitespacable, index_d$1_assertV8IntrinsicIdentifier as assertV8IntrinsicIdentifier, index_d$1_assertVariableDeclaration as assertVariableDeclaration, index_d$1_assertVariableDeclarator as assertVariableDeclarator, index_d$1_assertVariance as assertVariance, index_d$1_assertVoidPattern as assertVoidPattern, index_d$1_assertVoidTypeAnnotation as assertVoidTypeAnnotation, index_d$1_assertWhile as assertWhile, index_d$1_assertWhileStatement as assertWhileStatement, index_d$1_assertWithStatement as assertWithStatement, index_d$1_assertYieldExpression as assertYieldExpression, index_d$1_assignmentExpression as assignmentExpression, index_d$1_assignmentPattern as assignmentPattern, index_d$1_awaitExpression as awaitExpression, index_d$1_bigIntLiteral as bigIntLiteral, index_d$1_binaryExpression as binaryExpression, index_d$1_bindExpression as bindExpression, index_d$1_blockStatement as blockStatement, index_d$1_booleanLiteral as booleanLiteral, index_d$1_booleanLiteralTypeAnnotation as booleanLiteralTypeAnnotation, index_d$1_booleanTypeAnnotation as booleanTypeAnnotation, index_d$1_breakStatement as breakStatement, index_d$1_buildMatchMemberExpression as buildMatchMemberExpression, index_d$1_buildUndefinedNode as buildUndefinedNode, index_d$1_callExpression as callExpression, index_d$1_catchClause as catchClause, index_d$1_classAccessorProperty as classAccessorProperty, index_d$1_classBody as classBody, index_d$1_classDeclaration as classDeclaration, index_d$1_classExpression as classExpression, index_d$1_classImplements as classImplements, index_d$1_classMethod as classMethod, index_d$1_classPrivateMethod as classPrivateMethod, index_d$1_classPrivateProperty as classPrivateProperty, index_d$1_classProperty as classProperty, index_d$1_clone as clone, index_d$1_cloneDeep as cloneDeep, index_d$1_cloneDeepWithoutLoc as cloneDeepWithoutLoc, index_d$1_cloneNode as cloneNode, index_d$1_cloneWithoutLoc as cloneWithoutLoc, index_d$1_conditionalExpression as conditionalExpression, index_d$1_continueStatement as continueStatement, index_d$1_createFlowUnionType as createFlowUnionType, index_d$1_createTSUnionType as createTSUnionType, _default$4 as createTypeAnnotationBasedOnTypeof, createFlowUnionType as createUnionTypeAnnotation, index_d$1_debuggerStatement as debuggerStatement, index_d$1_decimalLiteral as decimalLiteral, index_d$1_declareClass as declareClass, index_d$1_declareExportAllDeclaration as declareExportAllDeclaration, index_d$1_declareExportDeclaration as declareExportDeclaration, index_d$1_declareFunction as declareFunction, index_d$1_declareInterface as declareInterface, index_d$1_declareModule as declareModule, index_d$1_declareModuleExports as declareModuleExports, index_d$1_declareOpaqueType as declareOpaqueType, index_d$1_declareTypeAlias as declareTypeAlias, index_d$1_declareVariable as declareVariable, index_d$1_declaredPredicate as declaredPredicate, index_d$1_decorator as decorator, index_d$1_directive as directive, index_d$1_directiveLiteral as directiveLiteral, index_d$1_doExpression as doExpression, index_d$1_doWhileStatement as doWhileStatement, index_d$1_emptyStatement as emptyStatement, index_d$1_emptyTypeAnnotation as emptyTypeAnnotation, index_d$1_ensureBlock as ensureBlock, index_d$1_enumBooleanBody as enumBooleanBody, index_d$1_enumBooleanMember as enumBooleanMember, index_d$1_enumDeclaration as enumDeclaration, index_d$1_enumDefaultedMember as enumDefaultedMember, index_d$1_enumNumberBody as enumNumberBody, index_d$1_enumNumberMember as enumNumberMember, index_d$1_enumStringBody as enumStringBody, index_d$1_enumStringMember as enumStringMember, index_d$1_enumSymbolBody as enumSymbolBody, index_d$1_existsTypeAnnotation as existsTypeAnnotation, index_d$1_exportAllDeclaration as exportAllDeclaration, index_d$1_exportDefaultDeclaration as exportDefaultDeclaration, index_d$1_exportDefaultSpecifier as exportDefaultSpecifier, index_d$1_exportNamedDeclaration as exportNamedDeclaration, index_d$1_exportNamespaceSpecifier as exportNamespaceSpecifier, index_d$1_exportSpecifier as exportSpecifier, index_d$1_expressionStatement as expressionStatement, index_d$1_file as file, index_d$1_forInStatement as forInStatement, index_d$1_forOfStatement as forOfStatement, index_d$1_forStatement as forStatement, index_d$1_functionDeclaration as functionDeclaration, index_d$1_functionExpression as functionExpression, index_d$1_functionTypeAnnotation as functionTypeAnnotation, index_d$1_functionTypeParam as functionTypeParam, index_d$1_genericTypeAnnotation as genericTypeAnnotation, index_d$1_getAssignmentIdentifiers as getAssignmentIdentifiers, index_d$1_getBindingIdentifiers as getBindingIdentifiers, index_d$1_getFunctionName as getFunctionName, _default as getOuterBindingIdentifiers, index_d$1_identifier as identifier, index_d$1_ifStatement as ifStatement, _import as import, index_d$1_importAttribute as importAttribute, index_d$1_importDeclaration as importDeclaration, index_d$1_importDefaultSpecifier as importDefaultSpecifier, index_d$1_importExpression as importExpression, index_d$1_importNamespaceSpecifier as importNamespaceSpecifier, index_d$1_importSpecifier as importSpecifier, index_d$1_indexedAccessType as indexedAccessType, index_d$1_inferredPredicate as inferredPredicate, index_d$1_inheritInnerComments as inheritInnerComments, index_d$1_inheritLeadingComments as inheritLeadingComments, index_d$1_inheritTrailingComments as inheritTrailingComments, index_d$1_inherits as inherits, index_d$1_inheritsComments as inheritsComments, index_d$1_interfaceDeclaration as interfaceDeclaration, index_d$1_interfaceExtends as interfaceExtends, index_d$1_interfaceTypeAnnotation as interfaceTypeAnnotation, index_d$1_interpreterDirective as interpreterDirective, index_d$1_intersectionTypeAnnotation as intersectionTypeAnnotation, index_d$1_is as is, index_d$1_isAccessor as isAccessor, index_d$1_isAnyTypeAnnotation as isAnyTypeAnnotation, index_d$1_isArgumentPlaceholder as isArgumentPlaceholder, index_d$1_isArrayExpression as isArrayExpression, index_d$1_isArrayPattern as isArrayPattern, index_d$1_isArrayTypeAnnotation as isArrayTypeAnnotation, index_d$1_isArrowFunctionExpression as isArrowFunctionExpression, index_d$1_isAssignmentExpression as isAssignmentExpression, index_d$1_isAssignmentPattern as isAssignmentPattern, index_d$1_isAwaitExpression as isAwaitExpression, index_d$1_isBigIntLiteral as isBigIntLiteral, index_d$1_isBinary as isBinary, index_d$1_isBinaryExpression as isBinaryExpression, index_d$1_isBindExpression as isBindExpression, index_d$1_isBinding as isBinding, index_d$1_isBlock as isBlock, index_d$1_isBlockParent as isBlockParent, index_d$1_isBlockScoped as isBlockScoped, index_d$1_isBlockStatement as isBlockStatement, index_d$1_isBooleanLiteral as isBooleanLiteral, index_d$1_isBooleanLiteralTypeAnnotation as isBooleanLiteralTypeAnnotation, index_d$1_isBooleanTypeAnnotation as isBooleanTypeAnnotation, index_d$1_isBreakStatement as isBreakStatement, index_d$1_isCallExpression as isCallExpression, index_d$1_isCatchClause as isCatchClause, index_d$1_isClass as isClass, index_d$1_isClassAccessorProperty as isClassAccessorProperty, index_d$1_isClassBody as isClassBody, index_d$1_isClassDeclaration as isClassDeclaration, index_d$1_isClassExpression as isClassExpression, index_d$1_isClassImplements as isClassImplements, index_d$1_isClassMethod as isClassMethod, index_d$1_isClassPrivateMethod as isClassPrivateMethod, index_d$1_isClassPrivateProperty as isClassPrivateProperty, index_d$1_isClassProperty as isClassProperty, index_d$1_isCompletionStatement as isCompletionStatement, index_d$1_isConditional as isConditional, index_d$1_isConditionalExpression as isConditionalExpression, index_d$1_isContinueStatement as isContinueStatement, index_d$1_isDebuggerStatement as isDebuggerStatement, index_d$1_isDecimalLiteral as isDecimalLiteral, index_d$1_isDeclaration as isDeclaration, index_d$1_isDeclareClass as isDeclareClass, index_d$1_isDeclareExportAllDeclaration as isDeclareExportAllDeclaration, index_d$1_isDeclareExportDeclaration as isDeclareExportDeclaration, index_d$1_isDeclareFunction as isDeclareFunction, index_d$1_isDeclareInterface as isDeclareInterface, index_d$1_isDeclareModule as isDeclareModule, index_d$1_isDeclareModuleExports as isDeclareModuleExports, index_d$1_isDeclareOpaqueType as isDeclareOpaqueType, index_d$1_isDeclareTypeAlias as isDeclareTypeAlias, index_d$1_isDeclareVariable as isDeclareVariable, index_d$1_isDeclaredPredicate as isDeclaredPredicate, index_d$1_isDecorator as isDecorator, index_d$1_isDirective as isDirective, index_d$1_isDirectiveLiteral as isDirectiveLiteral, index_d$1_isDoExpression as isDoExpression, index_d$1_isDoWhileStatement as isDoWhileStatement, index_d$1_isEmptyStatement as isEmptyStatement, index_d$1_isEmptyTypeAnnotation as isEmptyTypeAnnotation, index_d$1_isEnumBody as isEnumBody, index_d$1_isEnumBooleanBody as isEnumBooleanBody, index_d$1_isEnumBooleanMember as isEnumBooleanMember, index_d$1_isEnumDeclaration as isEnumDeclaration, index_d$1_isEnumDefaultedMember as isEnumDefaultedMember, index_d$1_isEnumMember as isEnumMember, index_d$1_isEnumNumberBody as isEnumNumberBody, index_d$1_isEnumNumberMember as isEnumNumberMember, index_d$1_isEnumStringBody as isEnumStringBody, index_d$1_isEnumStringMember as isEnumStringMember, index_d$1_isEnumSymbolBody as isEnumSymbolBody, index_d$1_isExistsTypeAnnotation as isExistsTypeAnnotation, index_d$1_isExportAllDeclaration as isExportAllDeclaration, index_d$1_isExportDeclaration as isExportDeclaration, index_d$1_isExportDefaultDeclaration as isExportDefaultDeclaration, index_d$1_isExportDefaultSpecifier as isExportDefaultSpecifier, index_d$1_isExportNamedDeclaration as isExportNamedDeclaration, index_d$1_isExportNamespaceSpecifier as isExportNamespaceSpecifier, index_d$1_isExportSpecifier as isExportSpecifier, index_d$1_isExpression as isExpression, index_d$1_isExpressionStatement as isExpressionStatement, index_d$1_isExpressionWrapper as isExpressionWrapper, index_d$1_isFile as isFile, index_d$1_isFlow as isFlow, index_d$1_isFlowBaseAnnotation as isFlowBaseAnnotation, index_d$1_isFlowDeclaration as isFlowDeclaration, index_d$1_isFlowPredicate as isFlowPredicate, index_d$1_isFlowType as isFlowType, index_d$1_isFor as isFor, index_d$1_isForInStatement as isForInStatement, index_d$1_isForOfStatement as isForOfStatement, index_d$1_isForStatement as isForStatement, index_d$1_isForXStatement as isForXStatement, index_d$1_isFunction as isFunction, index_d$1_isFunctionDeclaration as isFunctionDeclaration, index_d$1_isFunctionExpression as isFunctionExpression, index_d$1_isFunctionParameter as isFunctionParameter, index_d$1_isFunctionParent as isFunctionParent, index_d$1_isFunctionTypeAnnotation as isFunctionTypeAnnotation, index_d$1_isFunctionTypeParam as isFunctionTypeParam, index_d$1_isGenericTypeAnnotation as isGenericTypeAnnotation, index_d$1_isIdentifier as isIdentifier, index_d$1_isIfStatement as isIfStatement, index_d$1_isImmutable as isImmutable, index_d$1_isImport as isImport, index_d$1_isImportAttribute as isImportAttribute, index_d$1_isImportDeclaration as isImportDeclaration, index_d$1_isImportDefaultSpecifier as isImportDefaultSpecifier, index_d$1_isImportExpression as isImportExpression, index_d$1_isImportNamespaceSpecifier as isImportNamespaceSpecifier, index_d$1_isImportOrExportDeclaration as isImportOrExportDeclaration, index_d$1_isImportSpecifier as isImportSpecifier, index_d$1_isIndexedAccessType as isIndexedAccessType, index_d$1_isInferredPredicate as isInferredPredicate, index_d$1_isInterfaceDeclaration as isInterfaceDeclaration, index_d$1_isInterfaceExtends as isInterfaceExtends, index_d$1_isInterfaceTypeAnnotation as isInterfaceTypeAnnotation, index_d$1_isInterpreterDirective as isInterpreterDirective, index_d$1_isIntersectionTypeAnnotation as isIntersectionTypeAnnotation, index_d$1_isJSX as isJSX, index_d$1_isJSXAttribute as isJSXAttribute, index_d$1_isJSXClosingElement as isJSXClosingElement, index_d$1_isJSXClosingFragment as isJSXClosingFragment, index_d$1_isJSXElement as isJSXElement, index_d$1_isJSXEmptyExpression as isJSXEmptyExpression, index_d$1_isJSXExpressionContainer as isJSXExpressionContainer, index_d$1_isJSXFragment as isJSXFragment, index_d$1_isJSXIdentifier as isJSXIdentifier, index_d$1_isJSXMemberExpression as isJSXMemberExpression, index_d$1_isJSXNamespacedName as isJSXNamespacedName, index_d$1_isJSXOpeningElement as isJSXOpeningElement, index_d$1_isJSXOpeningFragment as isJSXOpeningFragment, index_d$1_isJSXSpreadAttribute as isJSXSpreadAttribute, index_d$1_isJSXSpreadChild as isJSXSpreadChild, index_d$1_isJSXText as isJSXText, index_d$1_isLVal as isLVal, index_d$1_isLabeledStatement as isLabeledStatement, index_d$1_isLet as isLet, index_d$1_isLiteral as isLiteral, index_d$1_isLogicalExpression as isLogicalExpression, index_d$1_isLoop as isLoop, index_d$1_isMemberExpression as isMemberExpression, index_d$1_isMetaProperty as isMetaProperty, index_d$1_isMethod as isMethod, index_d$1_isMiscellaneous as isMiscellaneous, index_d$1_isMixedTypeAnnotation as isMixedTypeAnnotation, index_d$1_isModuleDeclaration as isModuleDeclaration, index_d$1_isModuleExpression as isModuleExpression, index_d$1_isModuleSpecifier as isModuleSpecifier, index_d$1_isNewExpression as isNewExpression, index_d$1_isNode as isNode, index_d$1_isNodesEquivalent as isNodesEquivalent, index_d$1_isNoop as isNoop, index_d$1_isNullLiteral as isNullLiteral, index_d$1_isNullLiteralTypeAnnotation as isNullLiteralTypeAnnotation, index_d$1_isNullableTypeAnnotation as isNullableTypeAnnotation, index_d$1_isNumberLiteral as isNumberLiteral, index_d$1_isNumberLiteralTypeAnnotation as isNumberLiteralTypeAnnotation, index_d$1_isNumberTypeAnnotation as isNumberTypeAnnotation, index_d$1_isNumericLiteral as isNumericLiteral, index_d$1_isObjectExpression as isObjectExpression, index_d$1_isObjectMember as isObjectMember, index_d$1_isObjectMethod as isObjectMethod, index_d$1_isObjectPattern as isObjectPattern, index_d$1_isObjectProperty as isObjectProperty, index_d$1_isObjectTypeAnnotation as isObjectTypeAnnotation, index_d$1_isObjectTypeCallProperty as isObjectTypeCallProperty, index_d$1_isObjectTypeIndexer as isObjectTypeIndexer, index_d$1_isObjectTypeInternalSlot as isObjectTypeInternalSlot, index_d$1_isObjectTypeProperty as isObjectTypeProperty, index_d$1_isObjectTypeSpreadProperty as isObjectTypeSpreadProperty, index_d$1_isOpaqueType as isOpaqueType, index_d$1_isOptionalCallExpression as isOptionalCallExpression, index_d$1_isOptionalIndexedAccessType as isOptionalIndexedAccessType, index_d$1_isOptionalMemberExpression as isOptionalMemberExpression, index_d$1_isParenthesizedExpression as isParenthesizedExpression, index_d$1_isPattern as isPattern, index_d$1_isPatternLike as isPatternLike, index_d$1_isPipelineBareFunction as isPipelineBareFunction, index_d$1_isPipelinePrimaryTopicReference as isPipelinePrimaryTopicReference, index_d$1_isPipelineTopicExpression as isPipelineTopicExpression, index_d$1_isPlaceholder as isPlaceholder, index_d$1_isPlaceholderType as isPlaceholderType, index_d$1_isPrivate as isPrivate, index_d$1_isPrivateName as isPrivateName, index_d$1_isProgram as isProgram, index_d$1_isProperty as isProperty, index_d$1_isPureish as isPureish, index_d$1_isQualifiedTypeIdentifier as isQualifiedTypeIdentifier, index_d$1_isRecordExpression as isRecordExpression, index_d$1_isReferenced as isReferenced, index_d$1_isRegExpLiteral as isRegExpLiteral, index_d$1_isRegexLiteral as isRegexLiteral, index_d$1_isRestElement as isRestElement, index_d$1_isRestProperty as isRestProperty, index_d$1_isReturnStatement as isReturnStatement, index_d$1_isScopable as isScopable, index_d$1_isScope as isScope, index_d$1_isSequenceExpression as isSequenceExpression, index_d$1_isSpecifierDefault as isSpecifierDefault, index_d$1_isSpreadElement as isSpreadElement, index_d$1_isSpreadProperty as isSpreadProperty, index_d$1_isStandardized as isStandardized, index_d$1_isStatement as isStatement, index_d$1_isStaticBlock as isStaticBlock, index_d$1_isStringLiteral as isStringLiteral, index_d$1_isStringLiteralTypeAnnotation as isStringLiteralTypeAnnotation, index_d$1_isStringTypeAnnotation as isStringTypeAnnotation, index_d$1_isSuper as isSuper, index_d$1_isSwitchCase as isSwitchCase, index_d$1_isSwitchStatement as isSwitchStatement, index_d$1_isSymbolTypeAnnotation as isSymbolTypeAnnotation, index_d$1_isTSAnyKeyword as isTSAnyKeyword, index_d$1_isTSArrayType as isTSArrayType, index_d$1_isTSAsExpression as isTSAsExpression, index_d$1_isTSBaseType as isTSBaseType, index_d$1_isTSBigIntKeyword as isTSBigIntKeyword, index_d$1_isTSBooleanKeyword as isTSBooleanKeyword, index_d$1_isTSCallSignatureDeclaration as isTSCallSignatureDeclaration, index_d$1_isTSConditionalType as isTSConditionalType, index_d$1_isTSConstructSignatureDeclaration as isTSConstructSignatureDeclaration, index_d$1_isTSConstructorType as isTSConstructorType, index_d$1_isTSDeclareFunction as isTSDeclareFunction, index_d$1_isTSDeclareMethod as isTSDeclareMethod, index_d$1_isTSEntityName as isTSEntityName, index_d$1_isTSEnumBody as isTSEnumBody, index_d$1_isTSEnumDeclaration as isTSEnumDeclaration, index_d$1_isTSEnumMember as isTSEnumMember, index_d$1_isTSExportAssignment as isTSExportAssignment, index_d$1_isTSExpressionWithTypeArguments as isTSExpressionWithTypeArguments, index_d$1_isTSExternalModuleReference as isTSExternalModuleReference, index_d$1_isTSFunctionType as isTSFunctionType, index_d$1_isTSImportEqualsDeclaration as isTSImportEqualsDeclaration, index_d$1_isTSImportType as isTSImportType, index_d$1_isTSIndexSignature as isTSIndexSignature, index_d$1_isTSIndexedAccessType as isTSIndexedAccessType, index_d$1_isTSInferType as isTSInferType, index_d$1_isTSInstantiationExpression as isTSInstantiationExpression, index_d$1_isTSInterfaceBody as isTSInterfaceBody, index_d$1_isTSInterfaceDeclaration as isTSInterfaceDeclaration, index_d$1_isTSIntersectionType as isTSIntersectionType, index_d$1_isTSIntrinsicKeyword as isTSIntrinsicKeyword, index_d$1_isTSLiteralType as isTSLiteralType, index_d$1_isTSMappedType as isTSMappedType, index_d$1_isTSMethodSignature as isTSMethodSignature, index_d$1_isTSModuleBlock as isTSModuleBlock, index_d$1_isTSModuleDeclaration as isTSModuleDeclaration, index_d$1_isTSNamedTupleMember as isTSNamedTupleMember, index_d$1_isTSNamespaceExportDeclaration as isTSNamespaceExportDeclaration, index_d$1_isTSNeverKeyword as isTSNeverKeyword, index_d$1_isTSNonNullExpression as isTSNonNullExpression, index_d$1_isTSNullKeyword as isTSNullKeyword, index_d$1_isTSNumberKeyword as isTSNumberKeyword, index_d$1_isTSObjectKeyword as isTSObjectKeyword, index_d$1_isTSOptionalType as isTSOptionalType, index_d$1_isTSParameterProperty as isTSParameterProperty, index_d$1_isTSParenthesizedType as isTSParenthesizedType, index_d$1_isTSPropertySignature as isTSPropertySignature, index_d$1_isTSQualifiedName as isTSQualifiedName, index_d$1_isTSRestType as isTSRestType, index_d$1_isTSSatisfiesExpression as isTSSatisfiesExpression, index_d$1_isTSStringKeyword as isTSStringKeyword, index_d$1_isTSSymbolKeyword as isTSSymbolKeyword, index_d$1_isTSTemplateLiteralType as isTSTemplateLiteralType, index_d$1_isTSThisType as isTSThisType, index_d$1_isTSTupleType as isTSTupleType, index_d$1_isTSType as isTSType, index_d$1_isTSTypeAliasDeclaration as isTSTypeAliasDeclaration, index_d$1_isTSTypeAnnotation as isTSTypeAnnotation, index_d$1_isTSTypeAssertion as isTSTypeAssertion, index_d$1_isTSTypeElement as isTSTypeElement, index_d$1_isTSTypeLiteral as isTSTypeLiteral, index_d$1_isTSTypeOperator as isTSTypeOperator, index_d$1_isTSTypeParameter as isTSTypeParameter, index_d$1_isTSTypeParameterDeclaration as isTSTypeParameterDeclaration, index_d$1_isTSTypeParameterInstantiation as isTSTypeParameterInstantiation, index_d$1_isTSTypePredicate as isTSTypePredicate, index_d$1_isTSTypeQuery as isTSTypeQuery, index_d$1_isTSTypeReference as isTSTypeReference, index_d$1_isTSUndefinedKeyword as isTSUndefinedKeyword, index_d$1_isTSUnionType as isTSUnionType, index_d$1_isTSUnknownKeyword as isTSUnknownKeyword, index_d$1_isTSVoidKeyword as isTSVoidKeyword, index_d$1_isTaggedTemplateExpression as isTaggedTemplateExpression, index_d$1_isTemplateElement as isTemplateElement, index_d$1_isTemplateLiteral as isTemplateLiteral, index_d$1_isTerminatorless as isTerminatorless, index_d$1_isThisExpression as isThisExpression, index_d$1_isThisTypeAnnotation as isThisTypeAnnotation, index_d$1_isThrowStatement as isThrowStatement, index_d$1_isTopicReference as isTopicReference, index_d$1_isTryStatement as isTryStatement, index_d$1_isTupleExpression as isTupleExpression, index_d$1_isTupleTypeAnnotation as isTupleTypeAnnotation, index_d$1_isType as isType, index_d$1_isTypeAlias as isTypeAlias, index_d$1_isTypeAnnotation as isTypeAnnotation, index_d$1_isTypeCastExpression as isTypeCastExpression, index_d$1_isTypeParameter as isTypeParameter, index_d$1_isTypeParameterDeclaration as isTypeParameterDeclaration, index_d$1_isTypeParameterInstantiation as isTypeParameterInstantiation, index_d$1_isTypeScript as isTypeScript, index_d$1_isTypeofTypeAnnotation as isTypeofTypeAnnotation, index_d$1_isUnaryExpression as isUnaryExpression, index_d$1_isUnaryLike as isUnaryLike, index_d$1_isUnionTypeAnnotation as isUnionTypeAnnotation, index_d$1_isUpdateExpression as isUpdateExpression, index_d$1_isUserWhitespacable as isUserWhitespacable, index_d$1_isV8IntrinsicIdentifier as isV8IntrinsicIdentifier, index_d$1_isValidES3Identifier as isValidES3Identifier, index_d$1_isValidIdentifier as isValidIdentifier, index_d$1_isVar as isVar, index_d$1_isVariableDeclaration as isVariableDeclaration, index_d$1_isVariableDeclarator as isVariableDeclarator, index_d$1_isVariance as isVariance, index_d$1_isVoidPattern as isVoidPattern, index_d$1_isVoidTypeAnnotation as isVoidTypeAnnotation, index_d$1_isWhile as isWhile, index_d$1_isWhileStatement as isWhileStatement, index_d$1_isWithStatement as isWithStatement, index_d$1_isYieldExpression as isYieldExpression, jsxAttribute as jSXAttribute, jsxClosingElement as jSXClosingElement, jsxClosingFragment as jSXClosingFragment, jsxElement as jSXElement, jsxEmptyExpression as jSXEmptyExpression, jsxExpressionContainer as jSXExpressionContainer, jsxFragment as jSXFragment, jsxIdentifier as jSXIdentifier, jsxMemberExpression as jSXMemberExpression, jsxNamespacedName as jSXNamespacedName, jsxOpeningElement as jSXOpeningElement, jsxOpeningFragment as jSXOpeningFragment, jsxSpreadAttribute as jSXSpreadAttribute, jsxSpreadChild as jSXSpreadChild, jsxText as jSXText, index_d$1_jsxAttribute as jsxAttribute, index_d$1_jsxClosingElement as jsxClosingElement, index_d$1_jsxClosingFragment as jsxClosingFragment, index_d$1_jsxElement as jsxElement, index_d$1_jsxEmptyExpression as jsxEmptyExpression, index_d$1_jsxExpressionContainer as jsxExpressionContainer, index_d$1_jsxFragment as jsxFragment, index_d$1_jsxIdentifier as jsxIdentifier, index_d$1_jsxMemberExpression as jsxMemberExpression, index_d$1_jsxNamespacedName as jsxNamespacedName, index_d$1_jsxOpeningElement as jsxOpeningElement, index_d$1_jsxOpeningFragment as jsxOpeningFragment, index_d$1_jsxSpreadAttribute as jsxSpreadAttribute, index_d$1_jsxSpreadChild as jsxSpreadChild, index_d$1_jsxText as jsxText, index_d$1_labeledStatement as labeledStatement, index_d$1_logicalExpression as logicalExpression, index_d$1_matchesPattern as matchesPattern, index_d$1_memberExpression as memberExpression, index_d$1_metaProperty as metaProperty, index_d$1_mixedTypeAnnotation as mixedTypeAnnotation, index_d$1_moduleExpression as moduleExpression, index_d$1_newExpression as newExpression, index_d$1_noop as noop, index_d$1_nullLiteral as nullLiteral, index_d$1_nullLiteralTypeAnnotation as nullLiteralTypeAnnotation, index_d$1_nullableTypeAnnotation as nullableTypeAnnotation, NumberLiteral as numberLiteral, index_d$1_numberLiteralTypeAnnotation as numberLiteralTypeAnnotation, index_d$1_numberTypeAnnotation as numberTypeAnnotation, index_d$1_numericLiteral as numericLiteral, index_d$1_objectExpression as objectExpression, index_d$1_objectMethod as objectMethod, index_d$1_objectPattern as objectPattern, index_d$1_objectProperty as objectProperty, index_d$1_objectTypeAnnotation as objectTypeAnnotation, index_d$1_objectTypeCallProperty as objectTypeCallProperty, index_d$1_objectTypeIndexer as objectTypeIndexer, index_d$1_objectTypeInternalSlot as objectTypeInternalSlot, index_d$1_objectTypeProperty as objectTypeProperty, index_d$1_objectTypeSpreadProperty as objectTypeSpreadProperty, index_d$1_opaqueType as opaqueType, index_d$1_optionalCallExpression as optionalCallExpression, index_d$1_optionalIndexedAccessType as optionalIndexedAccessType, index_d$1_optionalMemberExpression as optionalMemberExpression, index_d$1_parenthesizedExpression as parenthesizedExpression, index_d$1_pipelineBareFunction as pipelineBareFunction, index_d$1_pipelinePrimaryTopicReference as pipelinePrimaryTopicReference, index_d$1_pipelineTopicExpression as pipelineTopicExpression, index_d$1_placeholder as placeholder, index_d$1_prependToMemberExpression as prependToMemberExpression, index_d$1_privateName as privateName, program$1 as program, index_d$1_qualifiedTypeIdentifier as qualifiedTypeIdentifier, index_d$1_react as react, index_d$1_recordExpression as recordExpression, index_d$1_regExpLiteral as regExpLiteral, RegexLiteral as regexLiteral, index_d$1_removeComments as removeComments, index_d$1_removeProperties as removeProperties, index_d$1_removePropertiesDeep as removePropertiesDeep, index_d$1_removeTypeDuplicates as removeTypeDuplicates, index_d$1_restElement as restElement, RestProperty as restProperty, index_d$1_returnStatement as returnStatement, index_d$1_sequenceExpression as sequenceExpression, index_d$1_shallowEqual as shallowEqual, index_d$1_spreadElement as spreadElement, SpreadProperty as spreadProperty, index_d$1_staticBlock as staticBlock, index_d$1_stringLiteral as stringLiteral, index_d$1_stringLiteralTypeAnnotation as stringLiteralTypeAnnotation, index_d$1_stringTypeAnnotation as stringTypeAnnotation, _super as super, index_d$1_switchCase as switchCase, index_d$1_switchStatement as switchStatement, index_d$1_symbolTypeAnnotation as symbolTypeAnnotation, tsAnyKeyword as tSAnyKeyword, tsArrayType as tSArrayType, tsAsExpression as tSAsExpression, tsBigIntKeyword as tSBigIntKeyword, tsBooleanKeyword as tSBooleanKeyword, tsCallSignatureDeclaration as tSCallSignatureDeclaration, tsConditionalType as tSConditionalType, tsConstructSignatureDeclaration as tSConstructSignatureDeclaration, tsConstructorType as tSConstructorType, tsDeclareFunction as tSDeclareFunction, tsDeclareMethod as tSDeclareMethod, tsEnumBody as tSEnumBody, tsEnumDeclaration as tSEnumDeclaration, tsEnumMember as tSEnumMember, tsExportAssignment as tSExportAssignment, tsExpressionWithTypeArguments as tSExpressionWithTypeArguments, tsExternalModuleReference as tSExternalModuleReference, tsFunctionType as tSFunctionType, tsImportEqualsDeclaration as tSImportEqualsDeclaration, tsImportType as tSImportType, tsIndexSignature as tSIndexSignature, tsIndexedAccessType as tSIndexedAccessType, tsInferType as tSInferType, tsInstantiationExpression as tSInstantiationExpression, tsInterfaceBody as tSInterfaceBody, tsInterfaceDeclaration as tSInterfaceDeclaration, tsIntersectionType as tSIntersectionType, tsIntrinsicKeyword as tSIntrinsicKeyword, tsLiteralType as tSLiteralType, tsMappedType as tSMappedType, tsMethodSignature as tSMethodSignature, tsModuleBlock as tSModuleBlock, tsModuleDeclaration as tSModuleDeclaration, tsNamedTupleMember as tSNamedTupleMember, tsNamespaceExportDeclaration as tSNamespaceExportDeclaration, tsNeverKeyword as tSNeverKeyword, tsNonNullExpression as tSNonNullExpression, tsNullKeyword as tSNullKeyword, tsNumberKeyword as tSNumberKeyword, tsObjectKeyword as tSObjectKeyword, tsOptionalType as tSOptionalType, tsParameterProperty as tSParameterProperty, tsParenthesizedType as tSParenthesizedType, tsPropertySignature as tSPropertySignature, tsQualifiedName as tSQualifiedName, tsRestType as tSRestType, tsSatisfiesExpression as tSSatisfiesExpression, tsStringKeyword as tSStringKeyword, tsSymbolKeyword as tSSymbolKeyword, tsTemplateLiteralType as tSTemplateLiteralType, tsThisType as tSThisType, tsTupleType as tSTupleType, tsTypeAliasDeclaration as tSTypeAliasDeclaration, tsTypeAnnotation as tSTypeAnnotation, tsTypeAssertion as tSTypeAssertion, tsTypeLiteral as tSTypeLiteral, tsTypeOperator as tSTypeOperator, tsTypeParameter as tSTypeParameter, tsTypeParameterDeclaration as tSTypeParameterDeclaration, tsTypeParameterInstantiation as tSTypeParameterInstantiation, tsTypePredicate as tSTypePredicate, tsTypeQuery as tSTypeQuery, tsTypeReference as tSTypeReference, tsUndefinedKeyword as tSUndefinedKeyword, tsUnionType as tSUnionType, tsUnknownKeyword as tSUnknownKeyword, tsVoidKeyword as tSVoidKeyword, index_d$1_taggedTemplateExpression as taggedTemplateExpression, index_d$1_templateElement as templateElement, index_d$1_templateLiteral as templateLiteral, index_d$1_thisExpression as thisExpression, index_d$1_thisTypeAnnotation as thisTypeAnnotation, index_d$1_throwStatement as throwStatement, index_d$1_toBindingIdentifierName as toBindingIdentifierName, index_d$1_toBlock as toBlock, index_d$1_toComputedKey as toComputedKey, _default$3 as toExpression, index_d$1_toIdentifier as toIdentifier, index_d$1_toKeyAlias as toKeyAlias, _default$2 as toStatement, index_d$1_topicReference as topicReference, traverse$2 as traverse, index_d$1_traverseFast as traverseFast, index_d$1_tryStatement as tryStatement, index_d$1_tsAnyKeyword as tsAnyKeyword, index_d$1_tsArrayType as tsArrayType, index_d$1_tsAsExpression as tsAsExpression, index_d$1_tsBigIntKeyword as tsBigIntKeyword, index_d$1_tsBooleanKeyword as tsBooleanKeyword, index_d$1_tsCallSignatureDeclaration as tsCallSignatureDeclaration, index_d$1_tsConditionalType as tsConditionalType, index_d$1_tsConstructSignatureDeclaration as tsConstructSignatureDeclaration, index_d$1_tsConstructorType as tsConstructorType, index_d$1_tsDeclareFunction as tsDeclareFunction, index_d$1_tsDeclareMethod as tsDeclareMethod, index_d$1_tsEnumBody as tsEnumBody, index_d$1_tsEnumDeclaration as tsEnumDeclaration, index_d$1_tsEnumMember as tsEnumMember, index_d$1_tsExportAssignment as tsExportAssignment, index_d$1_tsExpressionWithTypeArguments as tsExpressionWithTypeArguments, index_d$1_tsExternalModuleReference as tsExternalModuleReference, index_d$1_tsFunctionType as tsFunctionType, index_d$1_tsImportEqualsDeclaration as tsImportEqualsDeclaration, index_d$1_tsImportType as tsImportType, index_d$1_tsIndexSignature as tsIndexSignature, index_d$1_tsIndexedAccessType as tsIndexedAccessType, index_d$1_tsInferType as tsInferType, index_d$1_tsInstantiationExpression as tsInstantiationExpression, index_d$1_tsInterfaceBody as tsInterfaceBody, index_d$1_tsInterfaceDeclaration as tsInterfaceDeclaration, index_d$1_tsIntersectionType as tsIntersectionType, index_d$1_tsIntrinsicKeyword as tsIntrinsicKeyword, index_d$1_tsLiteralType as tsLiteralType, index_d$1_tsMappedType as tsMappedType, index_d$1_tsMethodSignature as tsMethodSignature, index_d$1_tsModuleBlock as tsModuleBlock, index_d$1_tsModuleDeclaration as tsModuleDeclaration, index_d$1_tsNamedTupleMember as tsNamedTupleMember, index_d$1_tsNamespaceExportDeclaration as tsNamespaceExportDeclaration, index_d$1_tsNeverKeyword as tsNeverKeyword, index_d$1_tsNonNullExpression as tsNonNullExpression, index_d$1_tsNullKeyword as tsNullKeyword, index_d$1_tsNumberKeyword as tsNumberKeyword, index_d$1_tsObjectKeyword as tsObjectKeyword, index_d$1_tsOptionalType as tsOptionalType, index_d$1_tsParameterProperty as tsParameterProperty, index_d$1_tsParenthesizedType as tsParenthesizedType, index_d$1_tsPropertySignature as tsPropertySignature, index_d$1_tsQualifiedName as tsQualifiedName, index_d$1_tsRestType as tsRestType, index_d$1_tsSatisfiesExpression as tsSatisfiesExpression, index_d$1_tsStringKeyword as tsStringKeyword, index_d$1_tsSymbolKeyword as tsSymbolKeyword, index_d$1_tsTemplateLiteralType as tsTemplateLiteralType, index_d$1_tsThisType as tsThisType, index_d$1_tsTupleType as tsTupleType, index_d$1_tsTypeAliasDeclaration as tsTypeAliasDeclaration, index_d$1_tsTypeAnnotation as tsTypeAnnotation, index_d$1_tsTypeAssertion as tsTypeAssertion, index_d$1_tsTypeLiteral as tsTypeLiteral, index_d$1_tsTypeOperator as tsTypeOperator, index_d$1_tsTypeParameter as tsTypeParameter, index_d$1_tsTypeParameterDeclaration as tsTypeParameterDeclaration, index_d$1_tsTypeParameterInstantiation as tsTypeParameterInstantiation, index_d$1_tsTypePredicate as tsTypePredicate, index_d$1_tsTypeQuery as tsTypeQuery, index_d$1_tsTypeReference as tsTypeReference, index_d$1_tsUndefinedKeyword as tsUndefinedKeyword, index_d$1_tsUnionType as tsUnionType, index_d$1_tsUnknownKeyword as tsUnknownKeyword, index_d$1_tsVoidKeyword as tsVoidKeyword, index_d$1_tupleExpression as tupleExpression, index_d$1_tupleTypeAnnotation as tupleTypeAnnotation, index_d$1_typeAlias as typeAlias, index_d$1_typeAnnotation as typeAnnotation, index_d$1_typeCastExpression as typeCastExpression, index_d$1_typeParameter as typeParameter, index_d$1_typeParameterDeclaration as typeParameterDeclaration, index_d$1_typeParameterInstantiation as typeParameterInstantiation, index_d$1_typeofTypeAnnotation as typeofTypeAnnotation, index_d$1_unaryExpression as unaryExpression, index_d$1_unionTypeAnnotation as unionTypeAnnotation, index_d$1_updateExpression as updateExpression, index_d$1_v8IntrinsicIdentifier as v8IntrinsicIdentifier, index_d$1_validate as validate, _default$1 as valueToNode, index_d$1_variableDeclaration as variableDeclaration, index_d$1_variableDeclarator as variableDeclarator, index_d$1_variance as variance, index_d$1_voidPattern as voidPattern, index_d$1_voidTypeAnnotation as voidTypeAnnotation, index_d$1_whileStatement as whileStatement, index_d$1_withStatement as withStatement, index_d$1_yieldExpression as yieldExpression };
}

// This file is auto-generated! Do not modify it directly.
// Run `yarn gulp bundle-dts` to re-generate it.
/* eslint-disable @typescript-eslint/consistent-type-imports, @typescript-eslint/no-redundant-type-constituents */


declare class Position {
    line: number;
    column: number;
    index: number;
    constructor(line: number, col: number, index: number);
}

type SyntaxPlugin = "flow" | "typescript" | "jsx" | "pipelineOperator" | "placeholders";
type ParseErrorCode = "BABEL_PARSER_SYNTAX_ERROR" | "BABEL_PARSER_SOURCETYPE_MODULE_REQUIRED";
interface ParseErrorSpecification<ErrorDetails> {
    code: ParseErrorCode;
    reasonCode: string;
    syntaxPlugin?: SyntaxPlugin;
    missingPlugin?: string | string[];
    loc: Position;
    details: ErrorDetails;
    pos: number;
}
type ParseError$1<ErrorDetails> = SyntaxError & ParseErrorSpecification<ErrorDetails>;

type BABEL_8_BREAKING = false;
type IF_BABEL_7<V> = false extends BABEL_8_BREAKING ? V : never;

type Plugin$1 =
  | "asyncDoExpressions"
  | IF_BABEL_7<"asyncGenerators">
  | IF_BABEL_7<"bigInt">
  | IF_BABEL_7<"classPrivateMethods">
  | IF_BABEL_7<"classPrivateProperties">
  | IF_BABEL_7<"classProperties">
  | IF_BABEL_7<"classStaticBlock">
  | IF_BABEL_7<"decimal">
  | "decorators-legacy"
  | "deferredImportEvaluation"
  | "decoratorAutoAccessors"
  | "destructuringPrivate"
  | "deprecatedImportAssert"
  | "doExpressions"
  | IF_BABEL_7<"dynamicImport">
  | IF_BABEL_7<"explicitResourceManagement">
  | "exportDefaultFrom"
  | IF_BABEL_7<"exportNamespaceFrom">
  | "flow"
  | "flowComments"
  | "functionBind"
  | "functionSent"
  | "importMeta"
  | "jsx"
  | IF_BABEL_7<"jsonStrings">
  | IF_BABEL_7<"logicalAssignment">
  | IF_BABEL_7<"importAssertions">
  | IF_BABEL_7<"importReflection">
  | "moduleBlocks"
  | IF_BABEL_7<"moduleStringNames">
  | IF_BABEL_7<"nullishCoalescingOperator">
  | IF_BABEL_7<"numericSeparator">
  | IF_BABEL_7<"objectRestSpread">
  | IF_BABEL_7<"optionalCatchBinding">
  | IF_BABEL_7<"optionalChaining">
  | "partialApplication"
  | "placeholders"
  | IF_BABEL_7<"privateIn">
  | IF_BABEL_7<"regexpUnicodeSets">
  | "sourcePhaseImports"
  | "throwExpressions"
  | IF_BABEL_7<"topLevelAwait">
  | "v8intrinsic"
  | ParserPluginWithOptions[0];

type ParserPluginWithOptions =
  | ["decorators", DecoratorsPluginOptions]
  | ["discardBinding", { syntaxType: "void" }]
  | ["estree", { classFeatures?: boolean }]
  | IF_BABEL_7<["importAttributes", { deprecatedAssertSyntax: boolean }]>
  | IF_BABEL_7<["moduleAttributes", { version: "may-2020" }]>
  | ["optionalChainingAssign", { version: "2023-07" }]
  | ["pipelineOperator", PipelineOperatorPluginOptions]
  | ["recordAndTuple", RecordAndTuplePluginOptions]
  | ["flow", FlowPluginOptions]
  | ["typescript", TypeScriptPluginOptions];

type PluginConfig = Plugin$1 | ParserPluginWithOptions;

interface DecoratorsPluginOptions {
  decoratorsBeforeExport?: boolean;
  allowCallParenthesized?: boolean;
}

interface PipelineOperatorPluginOptions {
  proposal: BABEL_8_BREAKING extends false
    ? "minimal" | "fsharp" | "hack" | "smart"
    : "fsharp" | "hack";
  topicToken?: "%" | "#" | "@@" | "^^" | "^";
}

interface RecordAndTuplePluginOptions {
  syntaxType: "bar" | "hash";
}

type FlowPluginOptions = BABEL_8_BREAKING extends true
  ? {
      all?: boolean;
      enums?: boolean;
    }
  : {
      all?: boolean;
    };

interface TypeScriptPluginOptions {
  dts?: boolean;
  disallowAmbiguousJSXLike?: boolean;
}

type Plugin = PluginConfig;

type SourceType = "script" | "commonjs" | "module" | "unambiguous";
interface Options {
    /**
     * By default, import and export declarations can only appear at a program's top level.
     * Setting this option to true allows them anywhere where a statement is allowed.
     */
    allowImportExportEverywhere?: boolean;
    /**
     * By default, await use is not allowed outside of an async function.
     * Set this to true to accept such code.
     */
    allowAwaitOutsideFunction?: boolean;
    /**
     * By default, a return statement at the top level raises an error.
     * Set this to true to accept such code.
     */
    allowReturnOutsideFunction?: boolean;
    /**
     * By default, new.target use is not allowed outside of a function or class.
     * Set this to true to accept such code.
     */
    allowNewTargetOutsideFunction?: boolean;
    /**
     * By default, super calls are not allowed outside of a method.
     * Set this to true to accept such code.
     */
    allowSuperOutsideMethod?: boolean;
    /**
     * By default, exported identifiers must refer to a declared variable.
     * Set this to true to allow export statements to reference undeclared variables.
     */
    allowUndeclaredExports?: boolean;
    /**
     * By default, yield use is not allowed outside of a generator function.
     * Set this to true to accept such code.
     */
    allowYieldOutsideFunction?: boolean;
    /**
     * By default, Babel parser JavaScript code according to Annex B syntax.
     * Set this to `false` to disable such behavior.
     */
    annexB?: boolean;
    /**
     * By default, Babel attaches comments to adjacent AST nodes.
     * When this option is set to false, comments are not attached.
     * It can provide up to 30% performance improvement when the input code has many comments.
     * @babel/eslint-parser will set it for you.
     * It is not recommended to use attachComment: false with Babel transform,
     * as doing so removes all the comments in output code, and renders annotations such as
     * /* istanbul ignore next *\/ nonfunctional.
     */
    attachComment?: boolean;
    /**
     * By default, Babel always throws an error when it finds some invalid code.
     * When this option is set to true, it will store the parsing error and
     * try to continue parsing the invalid input file.
     */
    errorRecovery?: boolean;
    /**
     * Indicate the mode the code should be parsed in.
     * Can be one of "script", "commonjs", "module", or "unambiguous". Defaults to "script".
     * "unambiguous" will make @babel/parser attempt to guess, based on the presence
     * of ES6 import or export statements.
     * Files with ES6 imports and exports are considered "module" and are otherwise "script".
     *
     * Use "commonjs" to parse code that is intended to be run in a CommonJS environment such as Node.js.
     */
    sourceType?: SourceType;
    /**
     * Correlate output AST nodes with their source filename.
     * Useful when generating code and source maps from the ASTs of multiple input files.
     */
    sourceFilename?: string;
    /**
     * By default, all source indexes start from 0.
     * You can provide a start index to alternatively start with.
     * Useful for integration with other source tools.
     */
    startIndex?: number;
    /**
     * By default, the first line of code parsed is treated as line 1.
     * You can provide a line number to alternatively start with.
     * Useful for integration with other source tools.
     */
    startLine?: number;
    /**
     * By default, the parsed code is treated as if it starts from line 1, column 0.
     * You can provide a column number to alternatively start with.
     * Useful for integration with other source tools.
     */
    startColumn?: number;
    /**
     * Array containing the plugins that you want to enable.
     */
    plugins?: Plugin[];
    /**
     * Should the parser work in strict mode.
     * Defaults to true if sourceType === 'module'. Otherwise, false.
     */
    strictMode?: boolean;
    /**
     * Adds a ranges property to each node: [node.start, node.end]
     */
    ranges?: boolean;
    /**
     * Adds all parsed tokens to a tokens property on the File node.
     */
    tokens?: boolean;
    /**
     * By default, the parser adds information about parentheses by setting
     * `extra.parenthesized` to `true` as needed.
     * When this option is `true` the parser creates `ParenthesizedExpression`
     * AST nodes instead of using the `extra` property.
     */
    createParenthesizedExpressions?: boolean;
    /**
     * The default is false in Babel 7 and true in Babel 8
     * Set this to true to parse it as an `ImportExpression` node.
     * Otherwise `import(foo)` is parsed as `CallExpression(Import, [Identifier(foo)])`.
     */
    createImportExpressions?: boolean;
}

type ParserOptions = Partial<Options>;
type ParseError = ParseError$1<object>;
type ParseResult$1<Result extends File | Expression = File> = Result & {
    comments: File["comments"];
    errors: null | ParseError[];
    tokens?: File["tokens"];
};
/**
 * Parse the provided code as an entire ECMAScript program.
 */
declare function parse$1(input: string, options?: ParserOptions): ParseResult$1<File>;
declare function parseExpression(input: string, options?: ParserOptions): ParseResult$1<Expression>;

declare const tokTypes: {
  // todo(flow->ts) real token type
  [name: string]: any;
};

type babelParser_d_DecoratorsPluginOptions = DecoratorsPluginOptions;
type babelParser_d_FlowPluginOptions = FlowPluginOptions;
type babelParser_d_ParseError = ParseError;
type babelParser_d_ParserOptions = ParserOptions;
type babelParser_d_ParserPluginWithOptions = ParserPluginWithOptions;
type babelParser_d_PipelineOperatorPluginOptions = PipelineOperatorPluginOptions;
type babelParser_d_RecordAndTuplePluginOptions = RecordAndTuplePluginOptions;
type babelParser_d_TypeScriptPluginOptions = TypeScriptPluginOptions;
declare const babelParser_d_parseExpression: typeof parseExpression;
declare const babelParser_d_tokTypes: typeof tokTypes;
declare namespace babelParser_d {
  export { type babelParser_d_DecoratorsPluginOptions as DecoratorsPluginOptions, type babelParser_d_FlowPluginOptions as FlowPluginOptions, type babelParser_d_ParseError as ParseError, type ParseResult$1 as ParseResult, type babelParser_d_ParserOptions as ParserOptions, type PluginConfig as ParserPlugin, type babelParser_d_ParserPluginWithOptions as ParserPluginWithOptions, type babelParser_d_PipelineOperatorPluginOptions as PipelineOperatorPluginOptions, type babelParser_d_RecordAndTuplePluginOptions as RecordAndTuplePluginOptions, type babelParser_d_TypeScriptPluginOptions as TypeScriptPluginOptions, parse$1 as parse, babelParser_d_parseExpression as parseExpression, babelParser_d_tokTypes as tokTypes };
}

interface GeneratorOptions {
    /**
     * Optional string to add as a block comment at the start of the output file.
     */
    auxiliaryCommentBefore?: string | undefined;

    /**
     * Optional string to add as a block comment at the end of the output file.
     */
    auxiliaryCommentAfter?: string | undefined;

    /**
     * Function that takes a comment (as a string) and returns true if the comment should be included in the output.
     * By default, comments are included if `opts.comments` is `true` or if `opts.minifed` is `false` and the comment
     * contains `@preserve` or `@license`.
     */
    shouldPrintComment?(comment: string): boolean;

    /**
     * Attempt to use the same line numbers in the output code as in the source code (helps preserve stack traces).
     * Defaults to `false`.
     */
    retainLines?: boolean | undefined;

    /**
     * Retain parens around function expressions (could be used to change engine parsing behavior)
     * Defaults to `false`.
     */
    retainFunctionParens?: boolean | undefined;

    /**
     * Should comments be included in output? Defaults to `true`.
     */
    comments?: boolean | undefined;

    /**
     * Set to true to avoid adding whitespace for formatting. Defaults to the value of `opts.minified`.
     */
    compact?: boolean | "auto" | undefined;

    /**
     * Should the output be minified. Defaults to `false`.
     */
    minified?: boolean | undefined;

    /**
     * Set to true to reduce whitespace (but not as much as opts.compact). Defaults to `false`.
     */
    concise?: boolean | undefined;

    /**
     * Used in warning messages
     */
    filename?: string | undefined;

    /**
     * Enable generating source maps. Defaults to `false`.
     */
    sourceMaps?: boolean | undefined;

    /**
     * A root for all relative URLs in the source map.
     */
    sourceRoot?: string | undefined;

    /**
     * The filename for the source code (i.e. the code in the `code` argument).
     * This will only be used if `code` is a string.
     */
    sourceFileName?: string | undefined;

    /**
     * Set to true to run jsesc with "json": true to print "\u00A9" vs. "©";
     */
    jsonCompatibleStrings?: boolean | undefined;

    /**
     * Set to true to enable support for experimental decorators syntax before module exports.
     * Defaults to `false`.
     */
    decoratorsBeforeExport?: boolean | undefined;

    /**
     * The import attributes/assertions syntax to use.
     * When not specified, @babel/generator will try to match the style in the input code based on the AST shape.
     */
    importAttributesKeyword?: "with" | "assert" | "with-legacy";

    /**
     * Options for outputting jsesc representation.
     */
    jsescOption?: {
        /**
         * The default value for the quotes option is 'single'. This means that any occurrences of ' in the input
         * string are escaped as \', so that the output can be used in a string literal wrapped in single quotes.
         */
        quotes?: "single" | "double" | "backtick" | undefined;

        /**
         * The default value for the numbers option is 'decimal'. This means that any numeric values are represented
         * using decimal integer literals. Other valid options are binary, octal, and hexadecimal, which result in
         * binary integer literals, octal integer literals, and hexadecimal integer literals, respectively.
         */
        numbers?: "binary" | "octal" | "decimal" | "hexadecimal" | undefined;

        /**
         * The wrap option takes a boolean value (true or false), and defaults to false (disabled). When enabled, the
         * output is a valid JavaScript string literal wrapped in quotes. The type of quotes can be specified through
         * the quotes setting.
         */
        wrap?: boolean | undefined;

        /**
         * The es6 option takes a boolean value (true or false), and defaults to false (disabled). When enabled, any
         * astral Unicode symbols in the input are escaped using ECMAScript 6 Unicode code point escape sequences
         * instead of using separate escape sequences for each surrogate half. If backwards compatibility with ES5
         * environments is a concern, don’t enable this setting. If the json setting is enabled, the value for the es6
         * setting is ignored (as if it was false).
         */
        es6?: boolean | undefined;

        /**
         * The escapeEverything option takes a boolean value (true or false), and defaults to false (disabled). When
         * enabled, all the symbols in the output are escaped — even printable ASCII symbols.
         */
        escapeEverything?: boolean | undefined;

        /**
         * The minimal option takes a boolean value (true or false), and defaults to false (disabled). When enabled,
         * only a limited set of symbols in the output are escaped: \0, \b, \t, \n, \f, \r, \\, \u2028, \u2029.
         */
        minimal?: boolean | undefined;

        /**
         * The isScriptContext option takes a boolean value (true or false), and defaults to false (disabled). When
         * enabled, occurrences of </script and </style in the output are escaped as <\/script and <\/style, and <!--
         * is escaped as \x3C!-- (or \u003C!-- when the json option is enabled). This setting is useful when jsesc’s
         * output ends up as part of a <script> or <style> element in an HTML document.
         */
        isScriptContext?: boolean | undefined;

        /**
         * The compact option takes a boolean value (true or false), and defaults to true (enabled). When enabled,
         * the output for arrays and objects is as compact as possible; it’s not formatted nicely.
         */
        compact?: boolean | undefined;

        /**
         * The indent option takes a string value, and defaults to '\t'. When the compact setting is enabled (true),
         * the value of the indent option is used to format the output for arrays and objects.
         */
        indent?: string | undefined;

        /**
         * The indentLevel option takes a numeric value, and defaults to 0. It represents the current indentation level,
         * i.e. the number of times the value of the indent option is repeated.
         */
        indentLevel?: number | undefined;

        /**
         * The json option takes a boolean value (true or false), and defaults to false (disabled). When enabled, the
         * output is valid JSON. Hexadecimal character escape sequences and the \v or \0 escape sequences are not used.
         * Setting json: true implies quotes: 'double', wrap: true, es6: false, although these values can still be
         * overridden if needed — but in such cases, the output won’t be valid JSON anymore.
         */
        json?: boolean | undefined;

        /**
         * The lowercaseHex option takes a boolean value (true or false), and defaults to false (disabled). When enabled,
         * any alphabetical hexadecimal digits in escape sequences as well as any hexadecimal integer literals (see the
         * numbers option) in the output are in lowercase.
         */
        lowercaseHex?: boolean | undefined;
    } | undefined;
}

/**
 * Turns an AST into code, maintaining sourcemaps, user preferences, and valid output.
 * @param ast - the abstract syntax tree from which to generate output code.
 * @param opts - used for specifying options for code generation.
 * @param code - the original source code, used for source maps.
 * @returns - an object containing the output code and source map.
 */
declare function generate$1(
    ast: Node$1,
    opts?: GeneratorOptions,
    code?: string | { [filename: string]: string },
): GeneratorResult;


interface GeneratorResult {
    code: string;
    map: {
        version: number;
        sources: string[];
        names: string[];
        sourceRoot?: string | undefined;
        sourcesContent?: string[] | undefined;
        mappings: string;
        file: string;
    } | null;
}

interface TemplateBuilderOptions extends ParserOptions {
    /**
     * A set of placeholder names to automatically accept.
     * Items in this list do not need to match `placeholderPattern`.
     *
     * This option cannot be used when using `%%foo%%` style placeholders.
     */
    placeholderWhitelist?: Set<string> | null | undefined;

    /**
     * A pattern to search for when looking for `Identifier` and `StringLiteral`
     * nodes that should be considered as placeholders.
     *
     * `false` will disable placeholder searching placeholders, leaving only
     * the `placeholderWhitelist` value to find replacements.
     *
     * This option cannot be used when using `%%foo%%` style placeholders.
     *
     * @default /^[_$A-Z0-9]+$/
     */
    placeholderPattern?: RegExp | false | null | undefined;

    /**
     * Set this to `true` to preserve comments from the template string
     * into the resulting AST, or `false` to automatically discard comments.
     *
     * @default false
     */
    preserveComments?: boolean | null | undefined;

    /**
     * Set to `true` to use `%%foo%%` style placeholders, `false` to use legacy placeholders
     * described by `placeholderPattern` or `placeholderWhitelist`.
     *
     * When it is not set, it behaves as `true` if there are syntactic placeholders, otherwise as `false`.
     *
     * @since 7.4.0
     */
    syntacticPlaceholders?: boolean | null | undefined;
}

interface TemplateBuilder<T> {
    /**
     * Build a new builder, merging the given options with the previous ones.
     */
    (opts: TemplateBuilderOptions): TemplateBuilder<T>;

    /**
     * Building from a string produces an AST builder function by default.
     */
    (code: string, opts?: TemplateBuilderOptions): (arg?: PublicReplacements) => T;

    /**
     * Building from a template literal produces an AST builder function by default.
     */
    (tpl: TemplateStringsArray, ...args: unknown[]): (arg?: PublicReplacements) => T;

    /**
     * Allow users to explicitly create templates that produce ASTs,
     * skipping the need for an intermediate function.
     *
     * Does not allow `%%foo%%` style placeholders.
     */
    ast: {
        (tpl: string, opts?: TemplateBuilderOptions): T;
        (tpl: TemplateStringsArray, ...args: unknown[]): T;
    };
}

type PublicReplacements = { [index: string]: unknown } | unknown[];

declare const smart: TemplateBuilder<Statement | Statement[]>;
declare const statement: TemplateBuilder<Statement>;
declare const statements: TemplateBuilder<Statement[]>;
declare const expression: TemplateBuilder<Expression>;
declare const program: TemplateBuilder<Program>;

type DefaultTemplateBuilder = typeof smart & {
    smart: typeof smart;
    statement: typeof statement;
    statements: typeof statements;
    expression: typeof expression;
    program: typeof program;
    ast: typeof smart.ast;
};

declare const templateBuilder: DefaultTemplateBuilder;

declare const traverse$1: {
    <S>(parent: Node$1, opts: TraverseOptions<S>, scope: Scope | undefined, state: S, parentPath?: NodePath): void;
    (parent: Node$1, opts?: TraverseOptions, scope?: Scope, state?: any, parentPath?: NodePath): void;

    visitors: typeof visitors;
    verify: typeof visitors.verify;
    explode: typeof visitors.explode;

    cheap: (node: Node$1, enter: (node: Node$1) => void) => void;
    node: (
        node: Node$1,
        opts: TraverseOptions,
        scope?: Scope,
        state?: any,
        path?: NodePath,
        skipKeys?: Record<string, boolean>,
    ) => void;
    clearNode: (node: Node$1, opts?: Options$1) => void;
    removeProperties: (tree: Node$1, opts?: Options$1) => Node$1;
    hasType: (tree: Node$1, type: Node$1["type"], denylistTypes?: string[]) => boolean;

    cache: typeof cache;
};

declare namespace visitors {
    /**
     * `explode()` will take a `Visitor` object with all of the various shorthands
     * that we support, and validates & normalizes it into a common format, ready
     * to be used in traversal.
     *
     * The various shorthands are:
     * - `Identifier() { ... }` -> `Identifier: { enter() { ... } }`
     * - `"Identifier|NumericLiteral": { ... }` -> `Identifier: { ... }, NumericLiteral: { ... }`
     * - Aliases in `@babel/types`: e.g. `Property: { ... }` -> `ObjectProperty: { ... }, ClassProperty: { ... }`
     *
     * Other normalizations are:
     * - Visitors of virtual types are wrapped, so that they are only visited when their dynamic check passes
     * - `enter` and `exit` functions are wrapped in arrays, to ease merging of visitors
     */
    function explode<S = unknown>(
        visitor: Visitor<S>,
    ): {
        [Type in Exclude<Node$1, DeprecatedAliases>["type"]]?: VisitNodeObject<S, Extract<Node$1, { type: Type }>>;
    };
    function verify(visitor: Visitor): void;
    function merge<State>(visitors: Array<Visitor<State>>): Visitor<State>;
    function merge(
        visitors: Visitor[],
        states?: any[],
        wrapper?: (
            stateKey: any,
            visitorKey: keyof Visitor,
            func: VisitNodeFunction<unknown, Node$1>,
        ) => VisitNodeFunction<unknown, Node$1> | null,
    ): Visitor;
}

declare namespace cache {
    let path: WeakMap<Node$1, Map<Node$1, NodePath>>;
    let scope: WeakMap<Node$1, Scope>;
    function clear(): void;
    function clearPath(): void;
    function clearScope(): void;
}


type TraverseOptions<S = Node$1> = {
    scope?: Scope;
    noScope?: boolean;
    denylist?: NodeType[];
    /** @deprecated will be removed in Babel 8 */
    blacklist?: NodeType[];
    shouldSkip?: (node: NodePath) => boolean;
} & Visitor<S>;

declare class Scope {
    /**
     * This searches the current "scope" and collects all references/bindings
     * within.
     */
    constructor(path: NodePath, parentScope?: Scope);
    uid: number;
    path: NodePath;
    block: Node$1;
    labels: Map<string, NodePath<LabeledStatement>>;
    parentBlock: Node$1;
    parent: Scope;
    hub: HubInterface;
    bindings: { [name: string]: Binding };
    references: { [name: string]: true };
    globals: { [name: string]: Identifier | JSXIdentifier };
    uids: { [name: string]: boolean };
    data: Record<string | symbol, unknown>;
    crawling: boolean;

    static globals: string[];
    /** Variables available in current context. */
    static contextVariables: string[];

    /** Traverse node with current scope and path. */
    traverse<S>(node: Node$1 | Node$1[], opts: TraverseOptions<S>, state: S): void;
    traverse(node: Node$1 | Node$1[], opts?: TraverseOptions, state?: any): void;

    /** Generate a unique identifier and add it to the current scope. */
    generateDeclaredUidIdentifier(name?: string): Identifier;

    /** Generate a unique identifier. */
    generateUidIdentifier(name?: string): Identifier;

    /** Generate a unique `_id1` binding. */
    generateUid(name?: string): string;

    /** Generate a unique identifier based on a node. */
    generateUidIdentifierBasedOnNode(parent: Node$1, defaultName?: string): Identifier;

    /**
     * Determine whether evaluating the specific input `node` is a consequenceless reference. ie.
     * evaluating it wont result in potentially arbitrary code from being ran. The following are
     * whitelisted and determined not to cause side effects:
     *
     *  - `this` expressions
     *  - `super` expressions
     *  - Bound identifiers
     */
    isStatic(node: Node$1): boolean;

    /** Possibly generate a memoised identifier if it is not static and has consequences. */
    maybeGenerateMemoised(node: Node$1, dontPush?: boolean): Identifier;

    checkBlockScopedCollisions(local: Binding, kind: BindingKind, name: string, id: object): void;

    rename(oldName: string, newName?: string, block?: Node$1): void;

    dump(): void;

    toArray(
        node: Node$1,
        i?: number | boolean,
        arrayLikeIsIterable?: boolean,
    ): ArrayExpression | CallExpression | Identifier;

    hasLabel(name: string): boolean;

    getLabel(name: string): NodePath<LabeledStatement> | undefined;

    registerLabel(path: NodePath<LabeledStatement>): void;

    registerDeclaration(path: NodePath): void;

    buildUndefinedNode(): UnaryExpression;

    registerConstantViolation(path: NodePath): void;

    registerBinding(kind: BindingKind, path: NodePath, bindingPath?: NodePath): void;

    addGlobal(node: Identifier | JSXIdentifier): void;

    hasUid(name: string): boolean;

    hasGlobal(name: string): boolean;

    hasReference(name: string): boolean;

    isPure(node: Node$1, constantsOnly?: boolean): boolean;

    /**
     * Set some arbitrary data on the current scope.
     */
    setData(key: string, val: any): any;

    /**
     * Recursively walk up scope tree looking for the data `key`.
     */
    getData(key: string): any;

    /**
     * Recursively walk up scope tree looking for the data `key` and if it exists,
     * remove it.
     */
    removeData(key: string): void;

    crawl(): void;

    push(opts: {
        id: LVal;
        init?: Expression;
        unique?: boolean;
        _blockHoist?: number | undefined;
        kind?: "var" | "let" | "const";
    }): void;

    /** Walk up to the top of the scope tree and get the `Program`. */
    getProgramParent(): Scope;

    /** Walk up the scope tree until we hit either a Function or return null. */
    getFunctionParent(): Scope | null;

    /**
     * Walk up the scope tree until we hit either a BlockStatement/Loop/Program/Function/Switch or reach the
     * very top and hit Program.
     */
    getBlockParent(): Scope;

    /**
     * Walk up from a pattern scope (function param initializer) until we hit a non-pattern scope,
     * then returns its block parent
     * @returns An ancestry scope whose path is a block parent
     */
    getPatternParent(): Scope;

    /** Walks the scope tree and gathers **all** bindings. */
    getAllBindings(): Record<string, Binding>;

    /** Walks the scope tree and gathers all declarations of `kind`. */
    getAllBindingsOfKind(...kinds: string[]): Record<string, Binding>;

    bindingIdentifierEquals(name: string, node: Node$1): boolean;

    getBinding(name: string): Binding | undefined;

    getOwnBinding(name: string): Binding | undefined;

    getBindingIdentifier(name: string): Identifier;

    getOwnBindingIdentifier(name: string): Identifier;

    hasOwnBinding(name: string): boolean;

    hasBinding(
        name: string,
        optsOrNoGlobals?:
            | boolean
            | {
                noGlobals?: boolean;
                noUids?: boolean;
            },
    ): boolean;

    parentHasBinding(
        name: string,
        opts?: {
            noGlobals?: boolean;
            noUids?: boolean;
        },
    ): boolean;

    /** Move a binding of `name` to another `scope`. */
    moveBindingTo(name: string, scope: Scope): void;

    removeOwnBinding(name: string): void;

    removeBinding(name: string): void;
}

type BindingKind = "var" | "let" | "const" | "module" | "hoisted" | "param" | "local" | "unknown";

/**
 * This class is responsible for a binding inside of a scope.
 *
 * It tracks the following:
 *
 *  * Node path.
 *  * Amount of times referenced by other nodes.
 *  * Paths to nodes that reassign or modify this binding.
 *  * The kind of binding. (Is it a parameter, declaration etc)
 */
declare class Binding {
    constructor(opts: { identifier: Identifier; scope: Scope; path: NodePath; kind: BindingKind });
    identifier: Identifier;
    scope: Scope;
    path: NodePath;
    kind: BindingKind;
    referenced: boolean;
    references: number;
    referencePaths: NodePath[];
    constant: boolean;
    constantViolations: NodePath[];
    hasDeoptedValue: boolean;
    hasValue: boolean;
    value: any;

    deopValue(): void;
    setValue(value: any): void;
    clearValue(): void;

    /** Register a constant violation with the provided `path`. */
    reassign(path: NodePath): void;
    /** Increment the amount of references to this binding. */
    reference(path: NodePath): void;
    /** Decrement the amount of references to this binding. */
    dereference(): void;
}

type Visitor<S = unknown> =
    & VisitNodeObject<S, Node$1>
    & {
        [N in Node$1 as N["type"]]?: VisitNode<S, N extends { type: N["type"] } ? N : never>;
    }
    & {
        [K in keyof Aliases]?: VisitNode<S, Aliases[K]>;
    }
    & {
        [K in keyof VirtualTypeAliases]?: VisitNode<S, VirtualTypeAliases[K]>;
    }
    & {
        // Babel supports `NodeTypesWithoutComment | NodeTypesWithoutComment | ... ` but it is
        // too complex for TS. So we type it as a general visitor only if the key contains `|`
        // this is good enough for non-visitor traverse options e.g. `noScope`
        [k: `${string}|${string}`]: VisitNode<S, Node$1>;
    };

type VisitNode<S, P extends Node$1> = VisitNodeFunction<S, P> | VisitNodeObject<S, P>;

type VisitNodeFunction<S, P extends Node$1> = (this: S, path: NodePath<P>, state: S) => void;

type NodeType = Node$1["type"] | keyof Aliases;

interface VisitNodeObject<S, P extends Node$1> {
    enter?: VisitNodeFunction<S, P>;
    exit?: VisitNodeFunction<S, P>;
}

type NodeKeyOfArrays<T extends Node$1> = {
    [P in keyof T]-?: T[P] extends Array<Node$1 | null | undefined> ? P : never;
}[keyof T];

type NodePaths<T extends Node$1 | readonly Node$1[]> = T extends readonly Node$1[]
    ? { -readonly [K in keyof T]: NodePath<Extract<T[K], Node$1>> }
    : T extends Node$1 ? [NodePath<T>]
    : never;

type NodeListType<N, K extends keyof N> = N[K] extends Array<infer P> ? (P extends Node$1 ? P : never) : never;

type NodesInsertionParam<T extends Node$1> = T | readonly T[] | [T, ...T[]];

declare class NodePath<T = Node$1> {
    constructor(hub: HubInterface, parent: Node$1);
    parent: Node$1;
    hub: Hub;
    data: Record<string | symbol, unknown>;
    context: TraversalContext;
    scope: Scope;
    contexts: TraversalContext[];
    state: any;
    opts: any; // exploded TraverseOptions
    skipKeys: Record<string, boolean> | null;
    parentPath: T extends Program ? null : NodePath;
    container: Node$1 | Node$1[] | null;
    listKey: string | null;
    key: string | number | null;
    node: T;
    type: T extends Node$1 ? T["type"] : T extends null | undefined ? undefined : Node$1["type"] | undefined;
    shouldSkip: boolean;
    shouldStop: boolean;
    removed: boolean;
    inList: boolean;
    parentKey: string;
    typeAnnotation: object;

    static get<C extends Node$1, K extends keyof C>(opts: {
        hub?: HubInterface;
        parentPath: NodePath | null;
        parent: Node$1;
        container: C;
        key: K;
    }): NodePath<C[K]>;
    static get<C extends Node$1, L extends NodeKeyOfArrays<C>>(opts: {
        hub?: HubInterface;
        parentPath: NodePath | null;
        parent: Node$1;
        container: C;
        listKey: L;
        key: number;
    }): C[L] extends Array<Node$1 | null | undefined> ? NodePath<C[L][number]> : never;

    getScope(scope: Scope): Scope;

    setData(key: string | symbol, val: any): any;

    getData(key: string | symbol, def?: any): any;

    hasNode(): this is NodePath<Exclude<T, null | undefined>>;

    buildCodeFrameError(msg: string, Error?: ErrorConstructor): Error;

    traverse<T>(visitor: TraverseOptions<T>, state: T): void;
    traverse(visitor: TraverseOptions): void;

    set(key: string, node: any): void;

    getPathLocation(): string;

    // Example: https://github.com/babel/babel/blob/63204ae51e020d84a5b246312f5eeb4d981ab952/packages/babel-traverse/src/path/modification.js#L83
    debug(buildMessage: () => string): void;

    // #region ------------------------- ancestry -------------------------
    /**
     * Starting at the parent path of the current `NodePath` and going up the
     * tree, return the first `NodePath` that causes the provided `callback`
     * to return a truthy value, or `null` if the `callback` never returns a
     * truthy value.
     */
    findParent(callback: (path: NodePath) => boolean): NodePath | null;

    /**
     * Starting at current `NodePath` and going up the tree, return the first
     * `NodePath` that causes the provided `callback` to return a truthy value,
     * or `null` if the `callback` never returns a truthy value.
     */
    find(callback: (path: NodePath) => boolean): NodePath | null;

    /** Get the parent function of the current path. */
    getFunctionParent(): NodePath<Function> | null;

    /** Walk up the tree until we hit a parent node path in a list. */
    getStatementParent(): NodePath<Statement> | null;

    /**
     * Get the deepest common ancestor and then from it, get the earliest relationship path
     * to that ancestor.
     *
     * Earliest is defined as being "before" all the other nodes in terms of list container
     * position and visiting key.
     */
    getEarliestCommonAncestorFrom(paths: NodePath[]): NodePath;

    /** Get the earliest path in the tree where the provided `paths` intersect. */
    getDeepestCommonAncestorFrom(
        paths: NodePath[],
        filter?: (deepest: Node$1, i: number, ancestries: NodePath[][]) => NodePath,
    ): NodePath;

    /**
     * Build an array of node paths containing the entire ancestry of the current node path.
     *
     * NOTE: The current node path is included in this.
     */
    getAncestry(): [this, ...NodePath[]];

    /**
     * A helper to find if `this` path is an ancestor of `maybeDescendant`
     */
    isAncestor(maybeDescendant: NodePath): boolean;

    /**
     * A helper to find if `this` path is a descendant of `maybeAncestor`
     */
    isDescendant(maybeAncestor: NodePath): boolean;

    inType(...candidateTypes: string[]): boolean;
    // #endregion

    // #region ------------------------- inference -------------------------
    /** Infer the type of the current `NodePath`. */
    getTypeAnnotation(): FlowType | TSType;

    isBaseType(baseName: string, soft?: boolean): boolean;

    couldBeBaseType(name: string): boolean;

    baseTypeStrictlyMatches(rightArg: NodePath): boolean;

    isGenericType(genericName: string): boolean;
    // #endregion

    // #region ------------------------- replacement -------------------------
    /**
     * Replace a node with an array of multiple. This method performs the following steps:
     *
     *  - Inherit the comments of first provided node with that of the current node.
     *  - Insert the provided nodes after the current node.
     *  - Remove the current node.
     */
    replaceWithMultiple<Nodes extends Node$1 | readonly Node$1[] | [Node$1, ...Node$1[]]>(nodes: Nodes): NodePaths<Nodes>;

    /**
     * Parse a string as an expression and replace the current node with the result.
     *
     * NOTE: This is typically not a good idea to use. Building source strings when
     * transforming ASTs is an antipattern and SHOULD NOT be encouraged. Even if it's
     * easier to use, your transforms will be extremely brittle.
     */
    replaceWithSourceString(replacement: string): [NodePath];

    /** Replace the current node with another. */
    replaceWith<R extends Node$1>(replacementPath: R | NodePath<R>): [NodePath<R>];
    replaceWith<R extends NodePath>(replacementPath: R): [R];

    /**
     * This method takes an array of statements nodes and then explodes it
     * into expressions. This method retains completion records which is
     * extremely important to retain original semantics.
     */
    replaceExpressionWithStatements(nodes: Statement[]): NodePaths<Expression | Statement>;

    replaceInline<Nodes extends Node$1 | readonly Node$1[] | [Node$1, ...Node$1[]]>(nodes: Nodes): NodePaths<Nodes>;
    // #endregion

    // #region ------------------------- evaluation -------------------------
    /**
     * Walk the input `node` and statically evaluate if it's truthy.
     *
     * Returning `true` when we're sure that the expression will evaluate to a
     * truthy value, `false` if we're sure that it will evaluate to a falsy
     * value and `undefined` if we aren't sure. Because of this please do not
     * rely on coercion when using this method and check with === if it's false.
     */
    evaluateTruthy(): boolean | undefined;

    /**
     * Walk the input `node` and statically evaluate it.
     *
     * Returns an object in the form `{ confident, value, deopt }`. `confident`
     * indicates whether or not we had to drop out of evaluating the expression
     * because of hitting an unknown node that we couldn't confidently find the
     * value of, in which case `deopt` is the path of said node.
     *
     * Example:
     *
     *   t.evaluate(parse("5 + 5")) // { confident: true, value: 10 }
     *   t.evaluate(parse("!true")) // { confident: true, value: false }
     *   t.evaluate(parse("foo + foo")) // { confident: false, value: undefined, deopt: NodePath }
     */
    evaluate(): {
        confident: boolean;
        value: any;
        deopt?: NodePath;
    };
    // #endregion

    // #region ------------------------- introspection -------------------------
    /**
     * Match the current node if it matches the provided `pattern`.
     *
     * For example, given the match `React.createClass` it would match the
     * parsed nodes of `React.createClass` and `React["createClass"]`.
     */
    matchesPattern(pattern: string, allowPartial?: boolean): boolean;

    /**
     * Check whether we have the input `key`. If the `key` references an array then we check
     * if the array has any items, otherwise we just check if it's falsy.
     */
    has(key: string): boolean;
    // has(key: keyof T): boolean;

    isStatic(): boolean;

    /** Alias of `has`. */
    is(key: string): boolean;
    // is(key: keyof T): boolean;

    /** Opposite of `has`. */
    isnt(key: string): boolean;
    // isnt(key: keyof T): boolean;

    /** Check whether the path node `key` strict equals `value`. */
    equals(key: string, value: any): boolean;
    // equals(key: keyof T, value: any): boolean;

    /**
     * Check the type against our stored internal type of the node. This is handy when a node has
     * been removed yet we still internally know the type and need it to calculate node replacement.
     */
    isNodeType(type: string): boolean;

    /**
     * This checks whether or not we're in one of the following positions:
     *
     *   for (KEY in right);
     *   for (KEY;;);
     *
     * This is because these spots allow VariableDeclarations AND normal expressions so we need
     * to tell the path replacement that it's ok to replace this with an expression.
     */
    canHaveVariableDeclarationOrExpression(): boolean;

    /**
     * This checks whether we are swapping an arrow function's body between an
     * expression and a block statement (or vice versa).
     *
     * This is because arrow functions may implicitly return an expression, which
     * is the same as containing a block statement.
     */
    canSwapBetweenExpressionAndStatement(replacement: Node$1): boolean;

    /** Check whether the current path references a completion record */
    isCompletionRecord(allowInsideFunction?: boolean): boolean;

    /**
     * Check whether or not the current `key` allows either a single statement or block statement
     * so we can explode it if necessary.
     */
    isStatementOrBlock(): boolean;

    /** Check if the currently assigned path references the `importName` of `moduleSource`. */
    referencesImport(moduleSource: string, importName: string): boolean;

    /** Get the source code associated with this node. */
    getSource(): string;

    /** Check if the current path will maybe execute before another path */
    willIMaybeExecuteBefore(target: NodePath): boolean;

    resolve(dangerous?: boolean, resolved?: NodePath[]): NodePath;

    isConstantExpression(): boolean;

    isInStrictMode(): boolean;
    // #endregion

    // #region ------------------------- context -------------------------
    call(key: string): boolean;

    isDenylisted(): boolean;

    /** @deprecated will be removed in Babel 8 */
    isBlacklisted(): boolean;

    visit(): boolean;

    skip(): void;

    skipKey(key: string): void;

    stop(): void;

    setScope(): void;

    setContext(context?: TraversalContext): this;

    /**
     * Here we resync the node paths `key` and `container`. If they've changed according
     * to what we have stored internally then we attempt to resync by crawling and looking
     * for the new values.
     */
    resync(): void;

    popContext(): void;

    pushContext(context: TraversalContext): void;

    requeue(pathToQueue?: NodePath): void;
    // #endregion

    // #region ------------------------- removal -------------------------
    remove(): void;
    // #endregion

    // #region ------------------------- conversion -------------------------
    toComputedKey(): PrivateName | Expression;

    /** @deprecated Use `arrowFunctionToExpression` */
    arrowFunctionToShadowed(): void;

    /**
     * Given an arbitrary function, process its content as if it were an arrow function, moving references
     * to "this", "arguments", "super", and such into the function's parent scope. This method is useful if
     * you have wrapped some set of items in an IIFE or other function, but want "this", "arguments", and super"
     * to continue behaving as expected.
     */
    unwrapFunctionEnvironment(): void;

    /**
     * Convert a given arrow function into a normal ES5 function expression.
     */
    arrowFunctionToExpression({
        allowInsertArrow,
        allowInsertArrowWithRest,
        /** @deprecated Use `noNewArrows` instead */
        specCompliant,
        noNewArrows,
    }?: {
        allowInsertArrow?: boolean;
        allowInsertArrowWithRest?: boolean;
        specCompliant?: boolean;
        noNewArrows?: boolean;
    }): NodePath<Exclude<Function, Method | ArrowFunctionExpression> | CallExpression>;

    ensureBlock(
        this: NodePath<Loop | WithStatement | Function | LabeledStatement | CatchClause>,
    ): asserts this is NodePath<
        T & {
            body: BlockStatement;
        }
    >;
    // #endregion

    // #region ------------------------- modification -------------------------
    /** Insert the provided nodes before the current one. */
    insertBefore<Nodes extends NodesInsertionParam<Node$1>>(nodes: Nodes): NodePaths<Nodes>;

    /**
     * Insert the provided nodes after the current one. When inserting nodes after an
     * expression, ensure that the completion record is correct by pushing the current node.
     */
    insertAfter<Nodes extends NodesInsertionParam<Node$1>>(nodes: Nodes): NodePaths<Nodes>;

    /** Update all sibling node paths after `fromIndex` by `incrementBy`. */
    updateSiblingKeys(fromIndex: number, incrementBy: number): void;

    /**
     * Insert child nodes at the start of the current node.
     * @param listKey - The key at which the child nodes are stored (usually body).
     * @param nodes - the nodes to insert.
     */
    unshiftContainer<
        T extends Node$1,
        K extends NodeKeyOfArrays<T>,
        Nodes extends NodesInsertionParam<NodeListType<T, K>>,
    >(this: NodePath<T>, listKey: K, nodes: Nodes): NodePaths<Nodes>;

    /**
     * Insert child nodes at the end of the current node.
     * @param listKey - The key at which the child nodes are stored (usually body).
     * @param nodes - the nodes to insert.
     */
    pushContainer<T extends Node$1, K extends NodeKeyOfArrays<T>, Nodes extends NodesInsertionParam<NodeListType<T, K>>>(
        this: NodePath<T>,
        listKey: K,
        nodes: Nodes,
    ): NodePaths<Nodes>;

    /** Hoist the current node to the highest scope possible and return a UID referencing it. */
    hoist(scope: Scope): void;
    // #endregion

    // #region ------------------------- family -------------------------
    getOpposite(): NodePath | null;

    getCompletionRecords(): NodePath[];

    getSibling(key: string | number): NodePath;
    getPrevSibling(): NodePath;
    getNextSibling(): NodePath;
    getAllPrevSiblings(): NodePath[];
    getAllNextSiblings(): NodePath[];

    get<K extends keyof T>(key: K, context?: boolean | TraversalContext): NodePathResult<T[K]>;
    get(key: string, context?: boolean | TraversalContext): NodePath | NodePath[];

    getBindingIdentifiers(duplicates: true): Record<string, Identifier[]>;
    getBindingIdentifiers(duplicates?: false): Record<string, Identifier>;
    getBindingIdentifiers(duplicates?: boolean): Record<string, Identifier | Identifier[]>;

    getOuterBindingIdentifiers(duplicates: true): Record<string, Identifier[]>;
    getOuterBindingIdentifiers(duplicates?: false): Record<string, Identifier>;
    getOuterBindingIdentifiers(duplicates?: boolean): Record<string, Identifier | Identifier[]>;

    getBindingIdentifierPaths(duplicates: true, outerOnly?: boolean): Record<string, Array<NodePath<Identifier>>>;
    getBindingIdentifierPaths(duplicates?: false, outerOnly?: boolean): Record<string, NodePath<Identifier>>;
    getBindingIdentifierPaths(
        duplicates?: boolean,
        outerOnly?: boolean,
    ): Record<string, NodePath<Identifier> | Array<NodePath<Identifier>>>;

    getOuterBindingIdentifierPaths(duplicates: true): Record<string, Array<NodePath<Identifier>>>;
    getOuterBindingIdentifierPaths(duplicates?: false): Record<string, NodePath<Identifier>>;
    getOuterBindingIdentifierPaths(
        duplicates?: boolean,
        outerOnly?: boolean,
    ): Record<string, NodePath<Identifier> | Array<NodePath<Identifier>>>;
    // #endregion

    // #region ------------------------- comments -------------------------
    /** Share comments amongst siblings. */
    shareCommentsWithSiblings(): void;

    addComment(type: CommentTypeShorthand, content: string, line?: boolean): void;

    /** Give node `comments` of the specified `type`. */
    addComments(type: CommentTypeShorthand, comments: Comment[]): void;
    // #endregion

    // #region ------------------------- isXXX -------------------------
    isAccessor(opts?: object): this is NodePath<Accessor>;
    isAnyTypeAnnotation(opts?: object): this is NodePath<AnyTypeAnnotation>;
    isArgumentPlaceholder(opts?: object): this is NodePath<ArgumentPlaceholder>;
    isArrayExpression(opts?: object): this is NodePath<ArrayExpression>;
    isArrayPattern(opts?: object): this is NodePath<ArrayPattern>;
    isArrayTypeAnnotation(opts?: object): this is NodePath<ArrayTypeAnnotation>;
    isArrowFunctionExpression(opts?: object): this is NodePath<ArrowFunctionExpression>;
    isAssignmentExpression(opts?: object): this is NodePath<AssignmentExpression>;
    isAssignmentPattern(opts?: object): this is NodePath<AssignmentPattern>;
    isAwaitExpression(opts?: object): this is NodePath<AwaitExpression>;
    isBigIntLiteral(opts?: object): this is NodePath<BigIntLiteral>;
    isBinary(opts?: object): this is NodePath<Binary>;
    isBinaryExpression(opts?: object): this is NodePath<BinaryExpression>;
    isBindExpression(opts?: object): this is NodePath<BindExpression>;
    isBlock(opts?: object): this is NodePath<Block>;
    isBlockParent(opts?: object): this is NodePath<BlockParent>;
    isBlockStatement(opts?: object): this is NodePath<BlockStatement>;
    isBooleanLiteral(opts?: object): this is NodePath<BooleanLiteral>;
    isBooleanLiteralTypeAnnotation(opts?: object): this is NodePath<BooleanLiteralTypeAnnotation>;
    isBooleanTypeAnnotation(opts?: object): this is NodePath<BooleanTypeAnnotation>;
    isBreakStatement(opts?: object): this is NodePath<BreakStatement>;
    isCallExpression(opts?: object): this is NodePath<CallExpression>;
    isCatchClause(opts?: object): this is NodePath<CatchClause>;
    isClass(opts?: object): this is NodePath<Class>;
    isClassAccessorProperty(opts?: object): this is NodePath<ClassAccessorProperty>;
    isClassBody(opts?: object): this is NodePath<ClassBody>;
    isClassDeclaration(opts?: object): this is NodePath<ClassDeclaration>;
    isClassExpression(opts?: object): this is NodePath<ClassExpression>;
    isClassImplements(opts?: object): this is NodePath<ClassImplements>;
    isClassMethod(opts?: object): this is NodePath<ClassMethod>;
    isClassPrivateMethod(opts?: object): this is NodePath<ClassPrivateMethod>;
    isClassPrivateProperty(opts?: object): this is NodePath<ClassPrivateProperty>;
    isClassProperty(opts?: object): this is NodePath<ClassProperty>;
    isCompletionStatement(opts?: object): this is NodePath<CompletionStatement>;
    isConditional(opts?: object): this is NodePath<Conditional>;
    isConditionalExpression(opts?: object): this is NodePath<ConditionalExpression>;
    isContinueStatement(opts?: object): this is NodePath<ContinueStatement>;
    isDebuggerStatement(opts?: object): this is NodePath<DebuggerStatement>;
    isDecimalLiteral(opts?: object): this is NodePath<DecimalLiteral>;
    isDeclaration(opts?: object): this is NodePath<Declaration>;
    isDeclareClass(opts?: object): this is NodePath<DeclareClass>;
    isDeclareExportAllDeclaration(opts?: object): this is NodePath<DeclareExportAllDeclaration>;
    isDeclareExportDeclaration(opts?: object): this is NodePath<DeclareExportDeclaration>;
    isDeclareFunction(opts?: object): this is NodePath<DeclareFunction>;
    isDeclareInterface(opts?: object): this is NodePath<DeclareInterface>;
    isDeclareModule(opts?: object): this is NodePath<DeclareModule>;
    isDeclareModuleExports(opts?: object): this is NodePath<DeclareModuleExports>;
    isDeclareOpaqueType(opts?: object): this is NodePath<DeclareOpaqueType>;
    isDeclareTypeAlias(opts?: object): this is NodePath<DeclareTypeAlias>;
    isDeclareVariable(opts?: object): this is NodePath<DeclareVariable>;
    isDeclaredPredicate(opts?: object): this is NodePath<DeclaredPredicate>;
    isDecorator(opts?: object): this is NodePath<Decorator>;
    isDirective(opts?: object): this is NodePath<Directive>;
    isDirectiveLiteral(opts?: object): this is NodePath<DirectiveLiteral>;
    isDoExpression(opts?: object): this is NodePath<DoExpression>;
    isDoWhileStatement(opts?: object): this is NodePath<DoWhileStatement>;
    isEmptyStatement(opts?: object): this is NodePath<EmptyStatement>;
    isEmptyTypeAnnotation(opts?: object): this is NodePath<EmptyTypeAnnotation>;
    isEnumBody(opts?: object): this is NodePath<EnumBody>;
    isEnumBooleanBody(opts?: object): this is NodePath<EnumBooleanBody>;
    isEnumBooleanMember(opts?: object): this is NodePath<EnumBooleanMember>;
    isEnumDeclaration(opts?: object): this is NodePath<EnumDeclaration>;
    isEnumDefaultedMember(opts?: object): this is NodePath<EnumDefaultedMember>;
    isEnumMember(opts?: object): this is NodePath<EnumMember>;
    isEnumNumberBody(opts?: object): this is NodePath<EnumNumberBody>;
    isEnumNumberMember(opts?: object): this is NodePath<EnumNumberMember>;
    isEnumStringBody(opts?: object): this is NodePath<EnumStringBody>;
    isEnumStringMember(opts?: object): this is NodePath<EnumStringMember>;
    isEnumSymbolBody(opts?: object): this is NodePath<EnumSymbolBody>;
    isExistsTypeAnnotation(opts?: object): this is NodePath<ExistsTypeAnnotation>;
    isExportAllDeclaration(opts?: object): this is NodePath<ExportAllDeclaration>;
    isExportDeclaration(opts?: object): this is NodePath<ExportDeclaration>;
    isExportDefaultDeclaration(opts?: object): this is NodePath<ExportDefaultDeclaration>;
    isExportDefaultSpecifier(opts?: object): this is NodePath<ExportDefaultSpecifier>;
    isExportNamedDeclaration(opts?: object): this is NodePath<ExportNamedDeclaration>;
    isExportNamespaceSpecifier(opts?: object): this is NodePath<ExportNamespaceSpecifier>;
    isExportSpecifier(opts?: object): this is NodePath<ExportSpecifier>;
    isExpression(opts?: object): this is NodePath<Expression>;
    isExpressionStatement(opts?: object): this is NodePath<ExpressionStatement>;
    isExpressionWrapper(opts?: object): this is NodePath<ExpressionWrapper>;
    isFile(opts?: object): this is NodePath<File>;
    isFlow(opts?: object): this is NodePath<Flow>;
    isFlowBaseAnnotation(opts?: object): this is NodePath<FlowBaseAnnotation>;
    isFlowDeclaration(opts?: object): this is NodePath<FlowDeclaration>;
    isFlowPredicate(opts?: object): this is NodePath<FlowPredicate>;
    isFlowType(opts?: object): this is NodePath<FlowType>;
    isFor(opts?: object): this is NodePath<For>;
    isForInStatement(opts?: object): this is NodePath<ForInStatement>;
    isForOfStatement(opts?: object): this is NodePath<ForOfStatement>;
    isForStatement(opts?: object): this is NodePath<ForStatement>;
    isForXStatement(opts?: object): this is NodePath<ForXStatement>;
    isFunction(opts?: object): this is NodePath<Function>;
    isFunctionDeclaration(opts?: object): this is NodePath<FunctionDeclaration>;
    isFunctionExpression(opts?: object): this is NodePath<FunctionExpression>;
    isFunctionParent(opts?: object): this is NodePath<FunctionParent>;
    isFunctionTypeAnnotation(opts?: object): this is NodePath<FunctionTypeAnnotation>;
    isFunctionTypeParam(opts?: object): this is NodePath<FunctionTypeParam>;
    isGenericTypeAnnotation(opts?: object): this is NodePath<GenericTypeAnnotation>;
    isIdentifier(opts?: object): this is NodePath<Identifier>;
    isIfStatement(opts?: object): this is NodePath<IfStatement>;
    isImmutable(opts?: object): this is NodePath<Immutable>;
    isImport(opts?: object): this is NodePath<Import>;
    isImportAttribute(opts?: object): this is NodePath<ImportAttribute>;
    isImportDeclaration(opts?: object): this is NodePath<ImportDeclaration>;
    isImportDefaultSpecifier(opts?: object): this is NodePath<ImportDefaultSpecifier>;
    isImportNamespaceSpecifier(opts?: object): this is NodePath<ImportNamespaceSpecifier>;
    isImportSpecifier(opts?: object): this is NodePath<ImportSpecifier>;
    isIndexedAccessType(opts?: object): this is NodePath<IndexedAccessType>;
    isInferredPredicate(opts?: object): this is NodePath<InferredPredicate>;
    isInterfaceDeclaration(opts?: object): this is NodePath<InterfaceDeclaration>;
    isInterfaceExtends(opts?: object): this is NodePath<InterfaceExtends>;
    isInterfaceTypeAnnotation(opts?: object): this is NodePath<InterfaceTypeAnnotation>;
    isInterpreterDirective(opts?: object): this is NodePath<InterpreterDirective>;
    isIntersectionTypeAnnotation(opts?: object): this is NodePath<IntersectionTypeAnnotation>;
    isJSX(opts?: object): this is NodePath<JSX>;
    isJSXAttribute(opts?: object): this is NodePath<JSXAttribute>;
    isJSXClosingElement(opts?: object): this is NodePath<JSXClosingElement>;
    isJSXClosingFragment(opts?: object): this is NodePath<JSXClosingFragment>;
    isJSXElement(opts?: object): this is NodePath<JSXElement>;
    isJSXEmptyExpression(opts?: object): this is NodePath<JSXEmptyExpression>;
    isJSXExpressionContainer(opts?: object): this is NodePath<JSXExpressionContainer>;
    isJSXFragment(opts?: object): this is NodePath<JSXFragment>;
    isJSXIdentifier(opts?: object): this is NodePath<JSXIdentifier>;
    isJSXMemberExpression(opts?: object): this is NodePath<JSXMemberExpression>;
    isJSXNamespacedName(opts?: object): this is NodePath<JSXNamespacedName>;
    isJSXOpeningElement(opts?: object): this is NodePath<JSXOpeningElement>;
    isJSXOpeningFragment(opts?: object): this is NodePath<JSXOpeningFragment>;
    isJSXSpreadAttribute(opts?: object): this is NodePath<JSXSpreadAttribute>;
    isJSXSpreadChild(opts?: object): this is NodePath<JSXSpreadChild>;
    isJSXText(opts?: object): this is NodePath<JSXText>;
    isLVal(opts?: object): this is NodePath<LVal>;
    isLabeledStatement(opts?: object): this is NodePath<LabeledStatement>;
    isLiteral(opts?: object): this is NodePath<Literal>;
    isLogicalExpression(opts?: object): this is NodePath<LogicalExpression>;
    isLoop(opts?: object): this is NodePath<Loop>;
    isMemberExpression(opts?: object): this is NodePath<MemberExpression>;
    isMetaProperty(opts?: object): this is NodePath<MetaProperty>;
    isMethod(opts?: object): this is NodePath<Method>;
    isMiscellaneous(opts?: object): this is NodePath<Miscellaneous>;
    isMixedTypeAnnotation(opts?: object): this is NodePath<MixedTypeAnnotation>;
    isModuleDeclaration(opts?: object): this is NodePath<ModuleDeclaration>;
    isModuleExpression(opts?: object): this is NodePath<ModuleExpression>;
    isModuleSpecifier(opts?: object): this is NodePath<ModuleSpecifier>;
    isNewExpression(opts?: object): this is NodePath<NewExpression>;
    isNoop(opts?: object): this is NodePath<Noop>;
    isNullLiteral(opts?: object): this is NodePath<NullLiteral>;
    isNullLiteralTypeAnnotation(opts?: object): this is NodePath<NullLiteralTypeAnnotation>;
    isNullableTypeAnnotation(opts?: object): this is NodePath<NullableTypeAnnotation>;

    /** @deprecated Use `isNumericLiteral` */
    isNumberLiteral(opts?: object): this is NodePath<NumberLiteral$1>;
    isNumberLiteralTypeAnnotation(opts?: object): this is NodePath<NumberLiteralTypeAnnotation>;
    isNumberTypeAnnotation(opts?: object): this is NodePath<NumberTypeAnnotation>;
    isNumericLiteral(opts?: object): this is NodePath<NumericLiteral>;
    isObjectExpression(opts?: object): this is NodePath<ObjectExpression>;
    isObjectMember(opts?: object): this is NodePath<ObjectMember>;
    isObjectMethod(opts?: object): this is NodePath<ObjectMethod>;
    isObjectPattern(opts?: object): this is NodePath<ObjectPattern>;
    isObjectProperty(opts?: object): this is NodePath<ObjectProperty>;
    isObjectTypeAnnotation(opts?: object): this is NodePath<ObjectTypeAnnotation>;
    isObjectTypeCallProperty(opts?: object): this is NodePath<ObjectTypeCallProperty>;
    isObjectTypeIndexer(opts?: object): this is NodePath<ObjectTypeIndexer>;
    isObjectTypeInternalSlot(opts?: object): this is NodePath<ObjectTypeInternalSlot>;
    isObjectTypeProperty(opts?: object): this is NodePath<ObjectTypeProperty>;
    isObjectTypeSpreadProperty(opts?: object): this is NodePath<ObjectTypeSpreadProperty>;
    isOpaqueType(opts?: object): this is NodePath<OpaqueType>;
    isOptionalCallExpression(opts?: object): this is NodePath<OptionalCallExpression>;
    isOptionalIndexedAccessType(opts?: object): this is NodePath<OptionalIndexedAccessType>;
    isOptionalMemberExpression(opts?: object): this is NodePath<OptionalMemberExpression>;
    isParenthesizedExpression(opts?: object): this is NodePath<ParenthesizedExpression>;
    isPattern(opts?: object): this is NodePath<Pattern>;
    isPatternLike(opts?: object): this is NodePath<PatternLike>;
    isPipelineBareFunction(opts?: object): this is NodePath<PipelineBareFunction>;
    isPipelinePrimaryTopicReference(opts?: object): this is NodePath<PipelinePrimaryTopicReference>;
    isPipelineTopicExpression(opts?: object): this is NodePath<PipelineTopicExpression>;
    isPlaceholder(opts?: object): this is NodePath<Placeholder>;
    isPrivate(opts?: object): this is NodePath<Private>;
    isPrivateName(opts?: object): this is NodePath<PrivateName>;
    isProgram(opts?: object): this is NodePath<Program>;
    isProperty(opts?: object): this is NodePath<Property>;
    isPureish(opts?: object): this is NodePath<Pureish>;
    isQualifiedTypeIdentifier(opts?: object): this is NodePath<QualifiedTypeIdentifier>;
    isRecordExpression(opts?: object): this is NodePath<RecordExpression>;
    isRegExpLiteral(opts?: object): this is NodePath<RegExpLiteral>;

    /** @deprecated Use `isRegExpLiteral` */
    isRegexLiteral(opts?: object): this is NodePath<RegexLiteral$1>;
    isRestElement(opts?: object): this is NodePath<RestElement>;

    /** @deprecated Use `isRestElement` */
    isRestProperty(opts?: object): this is NodePath<RestProperty$1>;
    isReturnStatement(opts?: object): this is NodePath<ReturnStatement>;
    isScopable(opts?: object): this is NodePath<Scopable>;
    isSequenceExpression(opts?: object): this is NodePath<SequenceExpression>;
    isSpreadElement(opts?: object): this is NodePath<SpreadElement>;

    /** @deprecated Use `isSpreadElement` */
    isSpreadProperty(opts?: object): this is NodePath<SpreadProperty$1>;
    isStandardized(opts?: object): this is NodePath<Standardized>;
    isStatement(opts?: object): this is NodePath<Statement>;
    isStaticBlock(opts?: object): this is NodePath<StaticBlock>;
    isStringLiteral(opts?: object): this is NodePath<StringLiteral>;
    isStringLiteralTypeAnnotation(opts?: object): this is NodePath<StringLiteralTypeAnnotation>;
    isStringTypeAnnotation(opts?: object): this is NodePath<StringTypeAnnotation>;
    isSuper(opts?: object): this is NodePath<Super>;
    isSwitchCase(opts?: object): this is NodePath<SwitchCase>;
    isSwitchStatement(opts?: object): this is NodePath<SwitchStatement>;
    isSymbolTypeAnnotation(opts?: object): this is NodePath<SymbolTypeAnnotation>;
    isTSAnyKeyword(opts?: object): this is NodePath<TSAnyKeyword>;
    isTSArrayType(opts?: object): this is NodePath<TSArrayType>;
    isTSAsExpression(opts?: object): this is NodePath<TSAsExpression>;
    isTSBaseType(opts?: object): this is NodePath<TSBaseType>;
    isTSBigIntKeyword(opts?: object): this is NodePath<TSBigIntKeyword>;
    isTSBooleanKeyword(opts?: object): this is NodePath<TSBooleanKeyword>;
    isTSCallSignatureDeclaration(opts?: object): this is NodePath<TSCallSignatureDeclaration>;
    isTSConditionalType(opts?: object): this is NodePath<TSConditionalType>;
    isTSConstructSignatureDeclaration(opts?: object): this is NodePath<TSConstructSignatureDeclaration>;
    isTSConstructorType(opts?: object): this is NodePath<TSConstructorType>;
    isTSDeclareFunction(opts?: object): this is NodePath<TSDeclareFunction>;
    isTSDeclareMethod(opts?: object): this is NodePath<TSDeclareMethod>;
    isTSEntityName(opts?: object): this is NodePath<TSEntityName>;
    isTSEnumDeclaration(opts?: object): this is NodePath<TSEnumDeclaration>;
    isTSEnumMember(opts?: object): this is NodePath<TSEnumMember>;
    isTSExportAssignment(opts?: object): this is NodePath<TSExportAssignment>;
    isTSExpressionWithTypeArguments(opts?: object): this is NodePath<TSExpressionWithTypeArguments>;
    isTSExternalModuleReference(opts?: object): this is NodePath<TSExternalModuleReference>;
    isTSFunctionType(opts?: object): this is NodePath<TSFunctionType>;
    isTSImportEqualsDeclaration(opts?: object): this is NodePath<TSImportEqualsDeclaration>;
    isTSImportType(opts?: object): this is NodePath<TSImportType>;
    isTSIndexSignature(opts?: object): this is NodePath<TSIndexSignature>;
    isTSIndexedAccessType(opts?: object): this is NodePath<TSIndexedAccessType>;
    isTSInferType(opts?: object): this is NodePath<TSInferType>;
    isTSInstantiationExpression(opts?: object): this is NodePath<TSInstantiationExpression>;
    isTSInterfaceBody(opts?: object): this is NodePath<TSInterfaceBody>;
    isTSInterfaceDeclaration(opts?: object): this is NodePath<TSInterfaceDeclaration>;
    isTSIntersectionType(opts?: object): this is NodePath<TSIntersectionType>;
    isTSIntrinsicKeyword(opts?: object): this is NodePath<TSIntrinsicKeyword>;
    isTSLiteralType(opts?: object): this is NodePath<TSLiteralType>;
    isTSMappedType(opts?: object): this is NodePath<TSMappedType>;
    isTSMethodSignature(opts?: object): this is NodePath<TSMethodSignature>;
    isTSModuleBlock(opts?: object): this is NodePath<TSModuleBlock>;
    isTSModuleDeclaration(opts?: object): this is NodePath<TSModuleDeclaration>;
    isTSNamedTupleMember(opts?: object): this is NodePath<TSNamedTupleMember>;
    isTSNamespaceExportDeclaration(opts?: object): this is NodePath<TSNamespaceExportDeclaration>;
    isTSNeverKeyword(opts?: object): this is NodePath<TSNeverKeyword>;
    isTSNonNullExpression(opts?: object): this is NodePath<TSNonNullExpression>;
    isTSNullKeyword(opts?: object): this is NodePath<TSNullKeyword>;
    isTSNumberKeyword(opts?: object): this is NodePath<TSNumberKeyword>;
    isTSObjectKeyword(opts?: object): this is NodePath<TSObjectKeyword>;
    isTSOptionalType(opts?: object): this is NodePath<TSOptionalType>;
    isTSParameterProperty(opts?: object): this is NodePath<TSParameterProperty>;
    isTSParenthesizedType(opts?: object): this is NodePath<TSParenthesizedType>;
    isTSPropertySignature(opts?: object): this is NodePath<TSPropertySignature>;
    isTSQualifiedName(opts?: object): this is NodePath<TSQualifiedName>;
    isTSRestType(opts?: object): this is NodePath<TSRestType>;
    isTSSatisfiesExpression(opts?: object): this is NodePath<TSSatisfiesExpression>;
    isTSStringKeyword(opts?: object): this is NodePath<TSStringKeyword>;
    isTSSymbolKeyword(opts?: object): this is NodePath<TSSymbolKeyword>;
    isTSThisType(opts?: object): this is NodePath<TSThisType>;
    isTSTupleType(opts?: object): this is NodePath<TSTupleType>;
    isTSType(opts?: object): this is NodePath<TSType>;
    isTSTypeAliasDeclaration(opts?: object): this is NodePath<TSTypeAliasDeclaration>;
    isTSTypeAnnotation(opts?: object): this is NodePath<TSTypeAnnotation>;
    isTSTypeAssertion(opts?: object): this is NodePath<TSTypeAssertion>;
    isTSTypeElement(opts?: object): this is NodePath<TSTypeElement>;
    isTSTypeLiteral(opts?: object): this is NodePath<TSTypeLiteral>;
    isTSTypeOperator(opts?: object): this is NodePath<TSTypeOperator>;
    isTSTypeParameter(opts?: object): this is NodePath<TSTypeParameter>;
    isTSTypeParameterDeclaration(opts?: object): this is NodePath<TSTypeParameterDeclaration>;
    isTSTypeParameterInstantiation(opts?: object): this is NodePath<TSTypeParameterInstantiation>;
    isTSTypePredicate(opts?: object): this is NodePath<TSTypePredicate>;
    isTSTypeQuery(opts?: object): this is NodePath<TSTypeQuery>;
    isTSTypeReference(opts?: object): this is NodePath<TSTypeReference>;
    isTSUndefinedKeyword(opts?: object): this is NodePath<TSUndefinedKeyword>;
    isTSUnionType(opts?: object): this is NodePath<TSUnionType>;
    isTSUnknownKeyword(opts?: object): this is NodePath<TSUnknownKeyword>;
    isTSVoidKeyword(opts?: object): this is NodePath<TSVoidKeyword>;
    isTaggedTemplateExpression(opts?: object): this is NodePath<TaggedTemplateExpression>;
    isTemplateElement(opts?: object): this is NodePath<TemplateElement>;
    isTemplateLiteral(opts?: object): this is NodePath<TemplateLiteral>;
    isTerminatorless(opts?: object): this is NodePath<Terminatorless>;
    isThisExpression(opts?: object): this is NodePath<ThisExpression>;
    isThisTypeAnnotation(opts?: object): this is NodePath<ThisTypeAnnotation>;
    isThrowStatement(opts?: object): this is NodePath<ThrowStatement>;
    isTopicReference(opts?: object): this is NodePath<TopicReference>;
    isTryStatement(opts?: object): this is NodePath<TryStatement>;
    isTupleExpression(opts?: object): this is NodePath<TupleExpression>;
    isTupleTypeAnnotation(opts?: object): this is NodePath<TupleTypeAnnotation>;
    isTypeAlias(opts?: object): this is NodePath<TypeAlias>;
    isTypeAnnotation(opts?: object): this is NodePath<TypeAnnotation>;
    isTypeCastExpression(opts?: object): this is NodePath<TypeCastExpression>;
    isTypeParameter(opts?: object): this is NodePath<TypeParameter>;
    isTypeParameterDeclaration(opts?: object): this is NodePath<TypeParameterDeclaration>;
    isTypeParameterInstantiation(opts?: object): this is NodePath<TypeParameterInstantiation>;
    isTypeScript(opts?: object): this is NodePath<TypeScript>;
    isTypeofTypeAnnotation(opts?: object): this is NodePath<TypeofTypeAnnotation>;
    isUnaryExpression(opts?: object): this is NodePath<UnaryExpression>;
    isUnaryLike(opts?: object): this is NodePath<UnaryLike>;
    isUnionTypeAnnotation(opts?: object): this is NodePath<UnionTypeAnnotation>;
    isUpdateExpression(opts?: object): this is NodePath<UpdateExpression>;
    isUserWhitespacable(opts?: object): this is NodePath<UserWhitespacable>;
    isV8IntrinsicIdentifier(opts?: object): this is NodePath<V8IntrinsicIdentifier>;
    isVariableDeclaration(opts?: object): this is NodePath<VariableDeclaration>;
    isVariableDeclarator(opts?: object): this is NodePath<VariableDeclarator>;
    isVariance(opts?: object): this is NodePath<Variance>;
    isVoidTypeAnnotation(opts?: object): this is NodePath<VoidTypeAnnotation>;
    isWhile(opts?: object): this is NodePath<While>;
    isWhileStatement(opts?: object): this is NodePath<WhileStatement>;
    isWithStatement(opts?: object): this is NodePath<WithStatement>;
    isYieldExpression(opts?: object): this is NodePath<YieldExpression>;

    isBindingIdentifier(opts?: object): this is NodePath<VirtualTypeAliases["BindingIdentifier"]>;
    isBlockScoped(opts?: object): this is NodePath<FunctionDeclaration | ClassDeclaration | VariableDeclaration>;

    /** @deprecated */
    isExistentialTypeParam(opts?: object): this is NodePath<VirtualTypeAliases["ExistentialTypeParam"]>;
    isForAwaitStatement(opts?: object): this is NodePath<VirtualTypeAliases["ForAwaitStatement"]>;
    isGenerated(opts?: object): boolean;

    /** @deprecated */
    isNumericLiteralTypeAnnotation(opts?: object): void;
    isPure(opts?: object): boolean;
    isReferenced(opts?: object): boolean;
    isReferencedIdentifier(opts?: object): this is NodePath<VirtualTypeAliases["ReferencedIdentifier"]>;
    isReferencedMemberExpression(opts?: object): this is NodePath<VirtualTypeAliases["ReferencedMemberExpression"]>;
    isScope(opts?: object): this is NodePath<VirtualTypeAliases["Scope"]>;
    isUser(opts?: object): boolean;
    isVar(opts?: object): this is NodePath<VirtualTypeAliases["Var"]>;
    // #endregion

    // #region ------------------------- assertXXX -------------------------
    assertAccessor(opts?: object): asserts this is NodePath<Accessor>;
    assertAnyTypeAnnotation(opts?: object): asserts this is NodePath<AnyTypeAnnotation>;
    assertArgumentPlaceholder(opts?: object): asserts this is NodePath<ArgumentPlaceholder>;
    assertArrayExpression(opts?: object): asserts this is NodePath<ArrayExpression>;
    assertArrayPattern(opts?: object): asserts this is NodePath<ArrayPattern>;
    assertArrayTypeAnnotation(opts?: object): asserts this is NodePath<ArrayTypeAnnotation>;
    assertArrowFunctionExpression(opts?: object): asserts this is NodePath<ArrowFunctionExpression>;
    assertAssignmentExpression(opts?: object): asserts this is NodePath<AssignmentExpression>;
    assertAssignmentPattern(opts?: object): asserts this is NodePath<AssignmentPattern>;
    assertAwaitExpression(opts?: object): asserts this is NodePath<AwaitExpression>;
    assertBigIntLiteral(opts?: object): asserts this is NodePath<BigIntLiteral>;
    assertBinary(opts?: object): asserts this is NodePath<Binary>;
    assertBinaryExpression(opts?: object): asserts this is NodePath<BinaryExpression>;
    assertBindExpression(opts?: object): asserts this is NodePath<BindExpression>;
    assertBlock(opts?: object): asserts this is NodePath<Block>;
    assertBlockParent(opts?: object): asserts this is NodePath<BlockParent>;
    assertBlockStatement(opts?: object): asserts this is NodePath<BlockStatement>;
    assertBooleanLiteral(opts?: object): asserts this is NodePath<BooleanLiteral>;
    assertBooleanLiteralTypeAnnotation(opts?: object): asserts this is NodePath<BooleanLiteralTypeAnnotation>;
    assertBooleanTypeAnnotation(opts?: object): asserts this is NodePath<BooleanTypeAnnotation>;
    assertBreakStatement(opts?: object): asserts this is NodePath<BreakStatement>;
    assertCallExpression(opts?: object): asserts this is NodePath<CallExpression>;
    assertCatchClause(opts?: object): asserts this is NodePath<CatchClause>;
    assertClass(opts?: object): asserts this is NodePath<Class>;
    assertClassAccessorProperty(opts?: object): asserts this is NodePath<ClassAccessorProperty>;
    assertClassBody(opts?: object): asserts this is NodePath<ClassBody>;
    assertClassDeclaration(opts?: object): asserts this is NodePath<ClassDeclaration>;
    assertClassExpression(opts?: object): asserts this is NodePath<ClassExpression>;
    assertClassImplements(opts?: object): asserts this is NodePath<ClassImplements>;
    assertClassMethod(opts?: object): asserts this is NodePath<ClassMethod>;
    assertClassPrivateMethod(opts?: object): asserts this is NodePath<ClassPrivateMethod>;
    assertClassPrivateProperty(opts?: object): asserts this is NodePath<ClassPrivateProperty>;
    assertClassProperty(opts?: object): asserts this is NodePath<ClassProperty>;
    assertCompletionStatement(opts?: object): asserts this is NodePath<CompletionStatement>;
    assertConditional(opts?: object): asserts this is NodePath<Conditional>;
    assertConditionalExpression(opts?: object): asserts this is NodePath<ConditionalExpression>;
    assertContinueStatement(opts?: object): asserts this is NodePath<ContinueStatement>;
    assertDebuggerStatement(opts?: object): asserts this is NodePath<DebuggerStatement>;
    assertDecimalLiteral(opts?: object): asserts this is NodePath<DecimalLiteral>;
    assertDeclaration(opts?: object): asserts this is NodePath<Declaration>;
    assertDeclareClass(opts?: object): asserts this is NodePath<DeclareClass>;
    assertDeclareExportAllDeclaration(opts?: object): asserts this is NodePath<DeclareExportAllDeclaration>;
    assertDeclareExportDeclaration(opts?: object): asserts this is NodePath<DeclareExportDeclaration>;
    assertDeclareFunction(opts?: object): asserts this is NodePath<DeclareFunction>;
    assertDeclareInterface(opts?: object): asserts this is NodePath<DeclareInterface>;
    assertDeclareModule(opts?: object): asserts this is NodePath<DeclareModule>;
    assertDeclareModuleExports(opts?: object): asserts this is NodePath<DeclareModuleExports>;
    assertDeclareOpaqueType(opts?: object): asserts this is NodePath<DeclareOpaqueType>;
    assertDeclareTypeAlias(opts?: object): asserts this is NodePath<DeclareTypeAlias>;
    assertDeclareVariable(opts?: object): asserts this is NodePath<DeclareVariable>;
    assertDeclaredPredicate(opts?: object): asserts this is NodePath<DeclaredPredicate>;
    assertDecorator(opts?: object): asserts this is NodePath<Decorator>;
    assertDirective(opts?: object): asserts this is NodePath<Directive>;
    assertDirectiveLiteral(opts?: object): asserts this is NodePath<DirectiveLiteral>;
    assertDoExpression(opts?: object): asserts this is NodePath<DoExpression>;
    assertDoWhileStatement(opts?: object): asserts this is NodePath<DoWhileStatement>;
    assertEmptyStatement(opts?: object): asserts this is NodePath<EmptyStatement>;
    assertEmptyTypeAnnotation(opts?: object): asserts this is NodePath<EmptyTypeAnnotation>;
    assertEnumBody(opts?: object): asserts this is NodePath<EnumBody>;
    assertEnumBooleanBody(opts?: object): asserts this is NodePath<EnumBooleanBody>;
    assertEnumBooleanMember(opts?: object): asserts this is NodePath<EnumBooleanMember>;
    assertEnumDeclaration(opts?: object): asserts this is NodePath<EnumDeclaration>;
    assertEnumDefaultedMember(opts?: object): asserts this is NodePath<EnumDefaultedMember>;
    assertEnumMember(opts?: object): asserts this is NodePath<EnumMember>;
    assertEnumNumberBody(opts?: object): asserts this is NodePath<EnumNumberBody>;
    assertEnumNumberMember(opts?: object): asserts this is NodePath<EnumNumberMember>;
    assertEnumStringBody(opts?: object): asserts this is NodePath<EnumStringBody>;
    assertEnumStringMember(opts?: object): asserts this is NodePath<EnumStringMember>;
    assertEnumSymbolBody(opts?: object): asserts this is NodePath<EnumSymbolBody>;
    assertExistsTypeAnnotation(opts?: object): asserts this is NodePath<ExistsTypeAnnotation>;
    assertExportAllDeclaration(opts?: object): asserts this is NodePath<ExportAllDeclaration>;
    assertExportDeclaration(opts?: object): asserts this is NodePath<ExportDeclaration>;
    assertExportDefaultDeclaration(opts?: object): asserts this is NodePath<ExportDefaultDeclaration>;
    assertExportDefaultSpecifier(opts?: object): asserts this is NodePath<ExportDefaultSpecifier>;
    assertExportNamedDeclaration(opts?: object): asserts this is NodePath<ExportNamedDeclaration>;
    assertExportNamespaceSpecifier(opts?: object): asserts this is NodePath<ExportNamespaceSpecifier>;
    assertExportSpecifier(opts?: object): asserts this is NodePath<ExportSpecifier>;
    assertExpression(opts?: object): asserts this is NodePath<Expression>;
    assertExpressionStatement(opts?: object): asserts this is NodePath<ExpressionStatement>;
    assertExpressionWrapper(opts?: object): asserts this is NodePath<ExpressionWrapper>;
    assertFile(opts?: object): asserts this is NodePath<File>;
    assertFlow(opts?: object): asserts this is NodePath<Flow>;
    assertFlowBaseAnnotation(opts?: object): asserts this is NodePath<FlowBaseAnnotation>;
    assertFlowDeclaration(opts?: object): asserts this is NodePath<FlowDeclaration>;
    assertFlowPredicate(opts?: object): asserts this is NodePath<FlowPredicate>;
    assertFlowType(opts?: object): asserts this is NodePath<FlowType>;
    assertFor(opts?: object): asserts this is NodePath<For>;
    assertForInStatement(opts?: object): asserts this is NodePath<ForInStatement>;
    assertForOfStatement(opts?: object): asserts this is NodePath<ForOfStatement>;
    assertForStatement(opts?: object): asserts this is NodePath<ForStatement>;
    assertForXStatement(opts?: object): asserts this is NodePath<ForXStatement>;
    assertFunction(opts?: object): asserts this is NodePath<Function>;
    assertFunctionDeclaration(opts?: object): asserts this is NodePath<FunctionDeclaration>;
    assertFunctionExpression(opts?: object): asserts this is NodePath<FunctionExpression>;
    assertFunctionParent(opts?: object): asserts this is NodePath<FunctionParent>;
    assertFunctionTypeAnnotation(opts?: object): asserts this is NodePath<FunctionTypeAnnotation>;
    assertFunctionTypeParam(opts?: object): asserts this is NodePath<FunctionTypeParam>;
    assertGenericTypeAnnotation(opts?: object): asserts this is NodePath<GenericTypeAnnotation>;
    assertIdentifier(opts?: object): asserts this is NodePath<Identifier>;
    assertIfStatement(opts?: object): asserts this is NodePath<IfStatement>;
    assertImmutable(opts?: object): asserts this is NodePath<Immutable>;
    assertImport(opts?: object): asserts this is NodePath<Import>;
    assertImportAttribute(opts?: object): asserts this is NodePath<ImportAttribute>;
    assertImportDeclaration(opts?: object): asserts this is NodePath<ImportDeclaration>;
    assertImportDefaultSpecifier(opts?: object): asserts this is NodePath<ImportDefaultSpecifier>;
    assertImportNamespaceSpecifier(opts?: object): asserts this is NodePath<ImportNamespaceSpecifier>;
    assertImportSpecifier(opts?: object): asserts this is NodePath<ImportSpecifier>;
    assertIndexedAccessType(opts?: object): asserts this is NodePath<IndexedAccessType>;
    assertInferredPredicate(opts?: object): asserts this is NodePath<InferredPredicate>;
    assertInterfaceDeclaration(opts?: object): asserts this is NodePath<InterfaceDeclaration>;
    assertInterfaceExtends(opts?: object): asserts this is NodePath<InterfaceExtends>;
    assertInterfaceTypeAnnotation(opts?: object): asserts this is NodePath<InterfaceTypeAnnotation>;
    assertInterpreterDirective(opts?: object): asserts this is NodePath<InterpreterDirective>;
    assertIntersectionTypeAnnotation(opts?: object): asserts this is NodePath<IntersectionTypeAnnotation>;
    assertJSX(opts?: object): asserts this is NodePath<JSX>;
    assertJSXAttribute(opts?: object): asserts this is NodePath<JSXAttribute>;
    assertJSXClosingElement(opts?: object): asserts this is NodePath<JSXClosingElement>;
    assertJSXClosingFragment(opts?: object): asserts this is NodePath<JSXClosingFragment>;
    assertJSXElement(opts?: object): asserts this is NodePath<JSXElement>;
    assertJSXEmptyExpression(opts?: object): asserts this is NodePath<JSXEmptyExpression>;
    assertJSXExpressionContainer(opts?: object): asserts this is NodePath<JSXExpressionContainer>;
    assertJSXFragment(opts?: object): asserts this is NodePath<JSXFragment>;
    assertJSXIdentifier(opts?: object): asserts this is NodePath<JSXIdentifier>;
    assertJSXMemberExpression(opts?: object): asserts this is NodePath<JSXMemberExpression>;
    assertJSXNamespacedName(opts?: object): asserts this is NodePath<JSXNamespacedName>;
    assertJSXOpeningElement(opts?: object): asserts this is NodePath<JSXOpeningElement>;
    assertJSXOpeningFragment(opts?: object): asserts this is NodePath<JSXOpeningFragment>;
    assertJSXSpreadAttribute(opts?: object): asserts this is NodePath<JSXSpreadAttribute>;
    assertJSXSpreadChild(opts?: object): asserts this is NodePath<JSXSpreadChild>;
    assertJSXText(opts?: object): asserts this is NodePath<JSXText>;
    assertLVal(opts?: object): asserts this is NodePath<LVal>;
    assertLabeledStatement(opts?: object): asserts this is NodePath<LabeledStatement>;
    assertLiteral(opts?: object): asserts this is NodePath<Literal>;
    assertLogicalExpression(opts?: object): asserts this is NodePath<LogicalExpression>;
    assertLoop(opts?: object): asserts this is NodePath<Loop>;
    assertMemberExpression(opts?: object): asserts this is NodePath<MemberExpression>;
    assertMetaProperty(opts?: object): asserts this is NodePath<MetaProperty>;
    assertMethod(opts?: object): asserts this is NodePath<Method>;
    assertMiscellaneous(opts?: object): asserts this is NodePath<Miscellaneous>;
    assertMixedTypeAnnotation(opts?: object): asserts this is NodePath<MixedTypeAnnotation>;
    assertModuleDeclaration(opts?: object): asserts this is NodePath<ModuleDeclaration>;
    assertModuleExpression(opts?: object): asserts this is NodePath<ModuleExpression>;
    assertModuleSpecifier(opts?: object): asserts this is NodePath<ModuleSpecifier>;
    assertNewExpression(opts?: object): asserts this is NodePath<NewExpression>;
    assertNoop(opts?: object): asserts this is NodePath<Noop>;
    assertNullLiteral(opts?: object): asserts this is NodePath<NullLiteral>;
    assertNullLiteralTypeAnnotation(opts?: object): asserts this is NodePath<NullLiteralTypeAnnotation>;
    assertNullableTypeAnnotation(opts?: object): asserts this is NodePath<NullableTypeAnnotation>;

    /** @deprecated Use `assertNumericLiteral` */
    assertNumberLiteral(opts?: object): asserts this is NodePath<NumberLiteral$1>;
    assertNumberLiteralTypeAnnotation(opts?: object): asserts this is NodePath<NumberLiteralTypeAnnotation>;
    assertNumberTypeAnnotation(opts?: object): asserts this is NodePath<NumberTypeAnnotation>;
    assertNumericLiteral(opts?: object): asserts this is NodePath<NumericLiteral>;
    assertObjectExpression(opts?: object): asserts this is NodePath<ObjectExpression>;
    assertObjectMember(opts?: object): asserts this is NodePath<ObjectMember>;
    assertObjectMethod(opts?: object): asserts this is NodePath<ObjectMethod>;
    assertObjectPattern(opts?: object): asserts this is NodePath<ObjectPattern>;
    assertObjectProperty(opts?: object): asserts this is NodePath<ObjectProperty>;
    assertObjectTypeAnnotation(opts?: object): asserts this is NodePath<ObjectTypeAnnotation>;
    assertObjectTypeCallProperty(opts?: object): asserts this is NodePath<ObjectTypeCallProperty>;
    assertObjectTypeIndexer(opts?: object): asserts this is NodePath<ObjectTypeIndexer>;
    assertObjectTypeInternalSlot(opts?: object): asserts this is NodePath<ObjectTypeInternalSlot>;
    assertObjectTypeProperty(opts?: object): asserts this is NodePath<ObjectTypeProperty>;
    assertObjectTypeSpreadProperty(opts?: object): asserts this is NodePath<ObjectTypeSpreadProperty>;
    assertOpaqueType(opts?: object): asserts this is NodePath<OpaqueType>;
    assertOptionalCallExpression(opts?: object): asserts this is NodePath<OptionalCallExpression>;
    assertOptionalIndexedAccessType(opts?: object): asserts this is NodePath<OptionalIndexedAccessType>;
    assertOptionalMemberExpression(opts?: object): asserts this is NodePath<OptionalMemberExpression>;
    assertParenthesizedExpression(opts?: object): asserts this is NodePath<ParenthesizedExpression>;
    assertPattern(opts?: object): asserts this is NodePath<Pattern>;
    assertPatternLike(opts?: object): asserts this is NodePath<PatternLike>;
    assertPipelineBareFunction(opts?: object): asserts this is NodePath<PipelineBareFunction>;
    assertPipelinePrimaryTopicReference(opts?: object): asserts this is NodePath<PipelinePrimaryTopicReference>;
    assertPipelineTopicExpression(opts?: object): asserts this is NodePath<PipelineTopicExpression>;
    assertPlaceholder(opts?: object): asserts this is NodePath<Placeholder>;
    assertPrivate(opts?: object): asserts this is NodePath<Private>;
    assertPrivateName(opts?: object): asserts this is NodePath<PrivateName>;
    assertProgram(opts?: object): asserts this is NodePath<Program>;
    assertProperty(opts?: object): asserts this is NodePath<Property>;
    assertPureish(opts?: object): asserts this is NodePath<Pureish>;
    assertQualifiedTypeIdentifier(opts?: object): asserts this is NodePath<QualifiedTypeIdentifier>;
    assertRecordExpression(opts?: object): asserts this is NodePath<RecordExpression>;
    assertRegExpLiteral(opts?: object): asserts this is NodePath<RegExpLiteral>;

    /** @deprecated Use `assertRegExpLiteral` */
    assertRegexLiteral(opts?: object): asserts this is NodePath<RegexLiteral$1>;
    assertRestElement(opts?: object): asserts this is NodePath<RestElement>;

    /** @deprecated Use `assertRestElement` */
    assertRestProperty(opts?: object): asserts this is NodePath<RestProperty$1>;
    assertReturnStatement(opts?: object): asserts this is NodePath<ReturnStatement>;
    assertScopable(opts?: object): asserts this is NodePath<Scopable>;
    assertSequenceExpression(opts?: object): asserts this is NodePath<SequenceExpression>;
    assertSpreadElement(opts?: object): asserts this is NodePath<SpreadElement>;

    /** @deprecated Use `assertSpreadElement` */
    assertSpreadProperty(opts?: object): asserts this is NodePath<SpreadProperty$1>;
    assertStandardized(opts?: object): asserts this is NodePath<Standardized>;
    assertStatement(opts?: object): asserts this is NodePath<Statement>;
    assertStaticBlock(opts?: object): asserts this is NodePath<StaticBlock>;
    assertStringLiteral(opts?: object): asserts this is NodePath<StringLiteral>;
    assertStringLiteralTypeAnnotation(opts?: object): asserts this is NodePath<StringLiteralTypeAnnotation>;
    assertStringTypeAnnotation(opts?: object): asserts this is NodePath<StringTypeAnnotation>;
    assertSuper(opts?: object): asserts this is NodePath<Super>;
    assertSwitchCase(opts?: object): asserts this is NodePath<SwitchCase>;
    assertSwitchStatement(opts?: object): asserts this is NodePath<SwitchStatement>;
    assertSymbolTypeAnnotation(opts?: object): asserts this is NodePath<SymbolTypeAnnotation>;
    assertTSAnyKeyword(opts?: object): asserts this is NodePath<TSAnyKeyword>;
    assertTSArrayType(opts?: object): asserts this is NodePath<TSArrayType>;
    assertTSAsExpression(opts?: object): asserts this is NodePath<TSAsExpression>;
    assertTSBaseType(opts?: object): asserts this is NodePath<TSBaseType>;
    assertTSBigIntKeyword(opts?: object): asserts this is NodePath<TSBigIntKeyword>;
    assertTSBooleanKeyword(opts?: object): asserts this is NodePath<TSBooleanKeyword>;
    assertTSCallSignatureDeclaration(opts?: object): asserts this is NodePath<TSCallSignatureDeclaration>;
    assertTSConditionalType(opts?: object): asserts this is NodePath<TSConditionalType>;
    assertTSConstructSignatureDeclaration(opts?: object): asserts this is NodePath<TSConstructSignatureDeclaration>;
    assertTSConstructorType(opts?: object): asserts this is NodePath<TSConstructorType>;
    assertTSDeclareFunction(opts?: object): asserts this is NodePath<TSDeclareFunction>;
    assertTSDeclareMethod(opts?: object): asserts this is NodePath<TSDeclareMethod>;
    assertTSEntityName(opts?: object): asserts this is NodePath<TSEntityName>;
    assertTSEnumDeclaration(opts?: object): asserts this is NodePath<TSEnumDeclaration>;
    assertTSEnumMember(opts?: object): asserts this is NodePath<TSEnumMember>;
    assertTSExportAssignment(opts?: object): asserts this is NodePath<TSExportAssignment>;
    assertTSExpressionWithTypeArguments(opts?: object): asserts this is NodePath<TSExpressionWithTypeArguments>;
    assertTSExternalModuleReference(opts?: object): asserts this is NodePath<TSExternalModuleReference>;
    assertTSFunctionType(opts?: object): asserts this is NodePath<TSFunctionType>;
    assertTSImportEqualsDeclaration(opts?: object): asserts this is NodePath<TSImportEqualsDeclaration>;
    assertTSImportType(opts?: object): asserts this is NodePath<TSImportType>;
    assertTSIndexSignature(opts?: object): asserts this is NodePath<TSIndexSignature>;
    assertTSIndexedAccessType(opts?: object): asserts this is NodePath<TSIndexedAccessType>;
    assertTSInferType(opts?: object): asserts this is NodePath<TSInferType>;
    assertTSInstantiationExpression(opts?: object): asserts this is NodePath<TSInstantiationExpression>;
    assertTSInterfaceBody(opts?: object): asserts this is NodePath<TSInterfaceBody>;
    assertTSInterfaceDeclaration(opts?: object): asserts this is NodePath<TSInterfaceDeclaration>;
    assertTSIntersectionType(opts?: object): asserts this is NodePath<TSIntersectionType>;
    assertTSIntrinsicKeyword(opts?: object): asserts this is NodePath<TSIntrinsicKeyword>;
    assertTSLiteralType(opts?: object): asserts this is NodePath<TSLiteralType>;
    assertTSMappedType(opts?: object): asserts this is NodePath<TSMappedType>;
    assertTSMethodSignature(opts?: object): asserts this is NodePath<TSMethodSignature>;
    assertTSModuleBlock(opts?: object): asserts this is NodePath<TSModuleBlock>;
    assertTSModuleDeclaration(opts?: object): asserts this is NodePath<TSModuleDeclaration>;
    assertTSNamedTupleMember(opts?: object): asserts this is NodePath<TSNamedTupleMember>;
    assertTSNamespaceExportDeclaration(opts?: object): asserts this is NodePath<TSNamespaceExportDeclaration>;
    assertTSNeverKeyword(opts?: object): asserts this is NodePath<TSNeverKeyword>;
    assertTSNonNullExpression(opts?: object): asserts this is NodePath<TSNonNullExpression>;
    assertTSNullKeyword(opts?: object): asserts this is NodePath<TSNullKeyword>;
    assertTSNumberKeyword(opts?: object): asserts this is NodePath<TSNumberKeyword>;
    assertTSObjectKeyword(opts?: object): asserts this is NodePath<TSObjectKeyword>;
    assertTSOptionalType(opts?: object): asserts this is NodePath<TSOptionalType>;
    assertTSParameterProperty(opts?: object): asserts this is NodePath<TSParameterProperty>;
    assertTSParenthesizedType(opts?: object): asserts this is NodePath<TSParenthesizedType>;
    assertTSPropertySignature(opts?: object): asserts this is NodePath<TSPropertySignature>;
    assertTSQualifiedName(opts?: object): asserts this is NodePath<TSQualifiedName>;
    assertTSRestType(opts?: object): asserts this is NodePath<TSRestType>;
    assertTSSatisfiesExpression(opts?: object): asserts this is NodePath<TSSatisfiesExpression>;
    assertTSStringKeyword(opts?: object): asserts this is NodePath<TSStringKeyword>;
    assertTSSymbolKeyword(opts?: object): asserts this is NodePath<TSSymbolKeyword>;
    assertTSThisType(opts?: object): asserts this is NodePath<TSThisType>;
    assertTSTupleType(opts?: object): asserts this is NodePath<TSTupleType>;
    assertTSType(opts?: object): asserts this is NodePath<TSType>;
    assertTSTypeAliasDeclaration(opts?: object): asserts this is NodePath<TSTypeAliasDeclaration>;
    assertTSTypeAnnotation(opts?: object): asserts this is NodePath<TSTypeAnnotation>;
    assertTSTypeAssertion(opts?: object): asserts this is NodePath<TSTypeAssertion>;
    assertTSTypeElement(opts?: object): asserts this is NodePath<TSTypeElement>;
    assertTSTypeLiteral(opts?: object): asserts this is NodePath<TSTypeLiteral>;
    assertTSTypeOperator(opts?: object): asserts this is NodePath<TSTypeOperator>;
    assertTSTypeParameter(opts?: object): asserts this is NodePath<TSTypeParameter>;
    assertTSTypeParameterDeclaration(opts?: object): asserts this is NodePath<TSTypeParameterDeclaration>;
    assertTSTypeParameterInstantiation(opts?: object): asserts this is NodePath<TSTypeParameterInstantiation>;
    assertTSTypePredicate(opts?: object): asserts this is NodePath<TSTypePredicate>;
    assertTSTypeQuery(opts?: object): asserts this is NodePath<TSTypeQuery>;
    assertTSTypeReference(opts?: object): asserts this is NodePath<TSTypeReference>;
    assertTSUndefinedKeyword(opts?: object): asserts this is NodePath<TSUndefinedKeyword>;
    assertTSUnionType(opts?: object): asserts this is NodePath<TSUnionType>;
    assertTSUnknownKeyword(opts?: object): asserts this is NodePath<TSUnknownKeyword>;
    assertTSVoidKeyword(opts?: object): asserts this is NodePath<TSVoidKeyword>;
    assertTaggedTemplateExpression(opts?: object): asserts this is NodePath<TaggedTemplateExpression>;
    assertTemplateElement(opts?: object): asserts this is NodePath<TemplateElement>;
    assertTemplateLiteral(opts?: object): asserts this is NodePath<TemplateLiteral>;
    assertTerminatorless(opts?: object): asserts this is NodePath<Terminatorless>;
    assertThisExpression(opts?: object): asserts this is NodePath<ThisExpression>;
    assertThisTypeAnnotation(opts?: object): asserts this is NodePath<ThisTypeAnnotation>;
    assertThrowStatement(opts?: object): asserts this is NodePath<ThrowStatement>;
    assertTopicReference(opts?: object): asserts this is NodePath<TopicReference>;
    assertTryStatement(opts?: object): asserts this is NodePath<TryStatement>;
    assertTupleExpression(opts?: object): asserts this is NodePath<TupleExpression>;
    assertTupleTypeAnnotation(opts?: object): asserts this is NodePath<TupleTypeAnnotation>;
    assertTypeAlias(opts?: object): asserts this is NodePath<TypeAlias>;
    assertTypeAnnotation(opts?: object): asserts this is NodePath<TypeAnnotation>;
    assertTypeCastExpression(opts?: object): asserts this is NodePath<TypeCastExpression>;
    assertTypeParameter(opts?: object): asserts this is NodePath<TypeParameter>;
    assertTypeParameterDeclaration(opts?: object): asserts this is NodePath<TypeParameterDeclaration>;
    assertTypeParameterInstantiation(opts?: object): asserts this is NodePath<TypeParameterInstantiation>;
    assertTypeScript(opts?: object): asserts this is NodePath<TypeScript>;
    assertTypeofTypeAnnotation(opts?: object): asserts this is NodePath<TypeofTypeAnnotation>;
    assertUnaryExpression(opts?: object): asserts this is NodePath<UnaryExpression>;
    assertUnaryLike(opts?: object): asserts this is NodePath<UnaryLike>;
    assertUnionTypeAnnotation(opts?: object): asserts this is NodePath<UnionTypeAnnotation>;
    assertUpdateExpression(opts?: object): asserts this is NodePath<UpdateExpression>;
    assertUserWhitespacable(opts?: object): asserts this is NodePath<UserWhitespacable>;
    assertV8IntrinsicIdentifier(opts?: object): asserts this is NodePath<V8IntrinsicIdentifier>;
    assertVariableDeclaration(opts?: object): asserts this is NodePath<VariableDeclaration>;
    assertVariableDeclarator(opts?: object): asserts this is NodePath<VariableDeclarator>;
    assertVariance(opts?: object): asserts this is NodePath<Variance>;
    assertVoidTypeAnnotation(opts?: object): asserts this is NodePath<VoidTypeAnnotation>;
    assertWhile(opts?: object): asserts this is NodePath<While>;
    assertWhileStatement(opts?: object): asserts this is NodePath<WhileStatement>;
    assertWithStatement(opts?: object): asserts this is NodePath<WithStatement>;
    assertYieldExpression(opts?: object): asserts this is NodePath<YieldExpression>;
    // #endregion
}

interface HubInterface {
    getCode(): string | undefined;
    getScope(): Scope | undefined;
    addHelper(name: string): any;
    buildError(node: Node$1, msg: string, Error: ErrorConstructor): Error;
}

declare class Hub implements HubInterface {
    constructor();
    getCode(): string | undefined;
    getScope(): Scope | undefined;
    addHelper(name: string): any;
    buildError(node: Node$1, msg: string, Error?: ErrorConstructor): Error;
}

interface TraversalContext<S = unknown> {
    parentPath: NodePath;
    scope: Scope;
    state: S;
    opts: TraverseOptions;
}

type NodePathResult<T> =
    | (Extract<T, Node$1 | null | undefined> extends never ? never : NodePath<Extract<T, Node$1 | null | undefined>>)
    | (T extends Array<Node$1 | null | undefined> ? Array<NodePath<T[number]>> : never);

interface VirtualTypeAliases {
    BindingIdentifier: Identifier;
    BlockScoped: Node$1;
    ExistentialTypeParam: ExistsTypeAnnotation;
    Flow: Flow | ImportDeclaration | ExportDeclaration | ImportSpecifier;
    ForAwaitStatement: ForOfStatement;
    Generated: Node$1;
    NumericLiteralTypeAnnotation: NumberLiteralTypeAnnotation;
    Pure: Node$1;
    Referenced: Node$1;
    ReferencedIdentifier: Identifier | JSXIdentifier;
    ReferencedMemberExpression: MemberExpression;
    RestProperty: RestElement;
    Scope: Scopable | Pattern;
    SpreadProperty: RestElement;
    User: Node$1;
    Var: VariableDeclaration;
}

type Node = Node$1;
type ParseResult = ReturnType<typeof parse$1>;
declare const version: string;
declare const DEFAULT_EXTENSIONS: [".js", ".jsx", ".es6", ".es", ".mjs"];

/**
 * Source map standard format as to revision 3
 * @see {@link https://sourcemaps.info/spec.html}
 * @see {@link https://github.com/mozilla/source-map/blob/HEAD/source-map.d.ts}
 */
interface InputSourceMap {
    version: number;
    sources: string[];
    names: string[];
    sourceRoot?: string | undefined;
    sourcesContent?: string[] | undefined;
    mappings: string;
    file: string;
}

interface TransformOptions {
    /**
     * Specify which assumptions it can make about your code, to better optimize the compilation result. **NOTE**: This replaces the various `loose` options in plugins in favor of
     * top-level options that can apply to multiple plugins
     *
     * @see https://babeljs.io/docs/en/assumptions
     */
    assumptions?: { [name: string]: boolean } | null | undefined;

    /**
     * Include the AST in the returned object
     *
     * Default: `false`
     */
    ast?: boolean | null | undefined;

    /**
     * Attach a comment after all non-user injected code
     *
     * Default: `null`
     */
    auxiliaryCommentAfter?: string | null | undefined;

    /**
     * Attach a comment before all non-user injected code
     *
     * Default: `null`
     */
    auxiliaryCommentBefore?: string | null | undefined;

    /**
     * Specify the "root" folder that defines the location to search for "babel.config.js", and the default folder to allow `.babelrc` files inside of.
     *
     * Default: `"."`
     */
    root?: string | null | undefined;

    /**
     * This option, combined with the "root" value, defines how Babel chooses its project root.
     * The different modes define different ways that Babel can process the "root" value to get
     * the final project root.
     *
     * @see https://babeljs.io/docs/en/next/options#rootmode
     */
    rootMode?: "root" | "upward" | "upward-optional" | undefined;

    /**
     * The config file to load Babel's config from. Defaults to searching for "babel.config.js" inside the "root" folder. `false` will disable searching for config files.
     *
     * Default: `undefined`
     */
    configFile?: string | boolean | null | undefined;

    /**
     * Specify whether or not to use .babelrc and
     * .babelignore files.
     *
     * Default: `true`
     */
    babelrc?: boolean | null | undefined;

    /**
     * Specify which packages should be search for .babelrc files when they are being compiled. `true` to always search, or a path string or an array of paths to packages to search
     * inside of. Defaults to only searching the "root" package.
     *
     * Default: `(root)`
     */
    babelrcRoots?: boolean | MatchPattern | MatchPattern[] | null | undefined;

    /**
     * Toggles whether or not browserslist config sources are used, which includes searching for any browserslist files or referencing the browserslist key inside package.json.
     * This is useful for projects that use a browserslist config for files that won't be compiled with Babel.
     *
     * If a string is specified, it must represent the path of a browserslist configuration file. Relative paths are resolved relative to the configuration file which specifies
     * this option, or to `cwd` when it's passed as part of the programmatic options.
     *
     * Default: `true`
     */
    browserslistConfigFile?: boolean | null | undefined;

    /**
     * The Browserslist environment to use.
     *
     * Default: `undefined`
     */
    browserslistEnv?: string | null | undefined;

    /**
     * By default `babel.transformFromAst` will clone the input AST to avoid mutations.
     * Specifying `cloneInputAst: false` can improve parsing performance if the input AST is not used elsewhere.
     *
     * Default: `true`
     */
    cloneInputAst?: boolean | null | undefined;

    /**
     * Defaults to environment variable `BABEL_ENV` if set, or else `NODE_ENV` if set, or else it defaults to `"development"`
     *
     * Default: env vars
     */
    envName?: string | undefined;

    /**
     * If any of patterns match, the current configuration object is considered inactive and is ignored during config processing.
     */
    exclude?: MatchPattern | MatchPattern[] | undefined;

    /**
     * Enable code generation
     *
     * Default: `true`
     */
    code?: boolean | null | undefined;

    /**
     * Output comments in generated output
     *
     * Default: `true`
     */
    comments?: boolean | null | undefined;

    /**
     * Do not include superfluous whitespace characters and line terminators. When set to `"auto"` compact is set to `true` on input sizes of >500KB
     *
     * Default: `"auto"`
     */
    compact?: boolean | "auto" | null | undefined;

    /**
     * The working directory that Babel's programmatic options are loaded relative to.
     *
     * Default: `"."`
     */
    cwd?: string | null | undefined;

    /**
     * Utilities may pass a caller object to identify themselves to Babel and
     * pass capability-related flags for use by configs, presets and plugins.
     *
     * @see https://babeljs.io/docs/en/next/options#caller
     */
    caller?: TransformCaller | undefined;

    /**
     * This is an object of keys that represent different environments. For example, you may have: `{ env: { production: { \/* specific options *\/ } } }`
     * which will use those options when the `envName` is `production`
     *
     * Default: `{}`
     */
    env?: { [index: string]: TransformOptions | null | undefined } | null | undefined;

    /**
     * A path to a `.babelrc` file to extend
     *
     * Default: `null`
     */
    extends?: string | null | undefined;

    /**
     * Filename for use in errors etc
     *
     * Default: `"unknown"`
     */
    filename?: string | null | undefined;

    /**
     * Filename relative to `sourceRoot`
     *
     * Default: `(filename)`
     */
    filenameRelative?: string | null | undefined;

    /**
     * An object containing the options to be passed down to the babel code generator, @babel/generator
     *
     * Default: `{}`
     */
    generatorOpts?: GeneratorOptions | null | undefined;

    /**
     * Specify a custom callback to generate a module id with. Called as `getModuleId(moduleName)`. If falsy value is returned then the generated module id is used
     *
     * Default: `null`
     */
    getModuleId?: ((moduleName: string) => string | null | undefined) | null | undefined;

    /**
     * ANSI highlight syntax error code frames
     *
     * Default: `true`
     */
    highlightCode?: boolean | null | undefined;

    /**
     * Opposite to the `only` option. `ignore` is disregarded if `only` is specified
     *
     * Default: `null`
     */
    ignore?: MatchPattern[] | null | undefined;

    /**
     * This option is a synonym for "test"
     */
    include?: MatchPattern | MatchPattern[] | undefined;

    /**
     * A source map object that the output source map will be based on
     *
     * Default: `null`
     */
    inputSourceMap?: InputSourceMap | null | undefined;

    /**
     * Should the output be minified (not printing last semicolons in blocks, printing literal string values instead of escaped ones, stripping `()` from `new` when safe)
     *
     * Default: `false`
     */
    minified?: boolean | null | undefined;

    /**
     * Specify a custom name for module ids
     *
     * Default: `null`
     */
    moduleId?: string | null | undefined;

    /**
     * If truthy, insert an explicit id for modules. By default, all modules are anonymous. (Not available for `common` modules)
     *
     * Default: `false`
     */
    moduleIds?: boolean | null | undefined;

    /**
     * Optional prefix for the AMD module formatter that will be prepend to the filename on module definitions
     *
     * Default: `(sourceRoot)`
     */
    moduleRoot?: string | null | undefined;

    /**
     * A glob, regex, or mixed array of both, matching paths to **only** compile. Can also be an array of arrays containing paths to explicitly match. When attempting to compile
     * a non-matching file it's returned verbatim
     *
     * Default: `null`
     */
    only?: MatchPattern[] | null | undefined;

    /**
     * Allows users to provide an array of options that will be merged into the current configuration one at a time.
     * This feature is best used alongside the "test"/"include"/"exclude" options to provide conditions for which an override should apply
     */
    overrides?: TransformOptions[] | undefined;

    /**
     * An object containing the options to be passed down to the babel parser, @babel/parser
     *
     * Default: `{}`
     */
    parserOpts?: ParserOptions | null | undefined;

    /**
     * List of plugins to load and use
     *
     * Default: `[]`
     */
    plugins?: PluginItem[] | null | undefined;

    /**
     * List of presets (a set of plugins) to load and use
     *
     * Default: `[]`
     */
    presets?: PluginItem[] | null | undefined;

    /**
     * Retain line numbers. This will lead to wacky code but is handy for scenarios where you can't use source maps. (**NOTE**: This will not retain the columns)
     *
     * Default: `false`
     */
    retainLines?: boolean | null | undefined;

    /**
     * An optional callback that controls whether a comment should be output or not. Called as `shouldPrintComment(commentContents)`. **NOTE**: This overrides the `comment` option when used
     *
     * Default: `null`
     */
    shouldPrintComment?: ((commentContents: string) => boolean) | null | undefined;

    /**
     * Set `sources[0]` on returned source map
     *
     * Default: `(filenameRelative)`
     */
    sourceFileName?: string | null | undefined;

    /**
     * If truthy, adds a `map` property to returned output. If set to `"inline"`, a comment with a sourceMappingURL directive is added to the bottom of the returned code. If set to `"both"`
     * then a `map` property is returned as well as a source map comment appended. **This does not emit sourcemap files by itself!**
     *
     * Default: `false`
     */
    sourceMaps?: boolean | "inline" | "both" | null | undefined;

    /**
     * The root from which all sources are relative
     *
     * Default: `(moduleRoot)`
     */
    sourceRoot?: string | null | undefined;

    /**
     * Indicate the mode the code should be parsed in. Can be one of "script", "module", or "unambiguous". `"unambiguous"` will make Babel attempt to guess, based on the presence of ES6
     * `import` or `export` statements. Files with ES6 `import`s and `export`s are considered `"module"` and are otherwise `"script"`.
     *
     * Default: `("module")`
     */
    sourceType?: "script" | "module" | "unambiguous" | null | undefined;

    /**
     * If all patterns fail to match, the current configuration object is considered inactive and is ignored during config processing.
     */
    test?: MatchPattern | MatchPattern[] | undefined;

    /**
     * Describes the environments you support/target for your project.
     * This can either be a [browserslist-compatible](https://github.com/ai/browserslist) query (with [caveats](https://babeljs.io/docs/en/babel-preset-env#ineffective-browserslist-queries))
     *
     * Default: `{}`
     */
    targets?:
        | string
        | string[]
        | {
            esmodules?: boolean;
            node?: Omit<string, "current"> | "current" | true;
            safari?: Omit<string, "tp"> | "tp";
            browsers?: string | string[];
            android?: string;
            chrome?: string;
            deno?: string;
            edge?: string;
            electron?: string;
            firefox?: string;
            ie?: string;
            ios?: string;
            opera?: string;
            rhino?: string;
            samsung?: string;
        };

    /**
     * An optional callback that can be used to wrap visitor methods. **NOTE**: This is useful for things like introspection, and not really needed for implementing anything. Called as
     * `wrapPluginVisitorMethod(pluginAlias, visitorType, callback)`.
     */
    wrapPluginVisitorMethod?:
        | ((
            pluginAlias: string,
            visitorType: "enter" | "exit",
            callback: (path: NodePath, state: any) => void,
        ) => (path: NodePath, state: any) => void)
        | null
        | undefined;
}

interface TransformCaller {
    // the only required property
    name: string;
    // e.g. set to true by `babel-loader` and false by `babel-jest`
    supportsStaticESM?: boolean | undefined;
    supportsDynamicImport?: boolean | undefined;
    supportsExportNamespaceFrom?: boolean | undefined;
    supportsTopLevelAwait?: boolean | undefined;
    // augment this with a "declare module '@babel/core' { ... }" if you need more keys
}

type FileResultCallback = (err: Error | null, result: BabelFileResult | null) => any;

interface MatchPatternContext {
    envName: string;
    dirname: string;
    caller: TransformCaller | undefined;
}
type MatchPattern = string | RegExp | ((filename: string | undefined, context: MatchPatternContext) => boolean);

/**
 * Transforms the passed in code. Calling a callback with an object with the generated code, source map, and AST.
 */
declare function transform(code: string, callback: FileResultCallback): void;

/**
 * Transforms the passed in code. Calling a callback with an object with the generated code, source map, and AST.
 */
declare function transform(code: string, opts: TransformOptions | undefined, callback: FileResultCallback): void;

/**
 * Here for backward-compatibility. Ideally use `transformSync` if you want a synchronous API.
 */
declare function transform(code: string, opts?: TransformOptions): BabelFileResult | null;

/**
 * Transforms the passed in code. Returning an object with the generated code, source map, and AST.
 */
declare function transformSync(code: string, opts?: TransformOptions): BabelFileResult | null;

/**
 * Transforms the passed in code. Calling a callback with an object with the generated code, source map, and AST.
 */
declare function transformAsync(code: string, opts?: TransformOptions): Promise<BabelFileResult | null>;

/**
 * Asynchronously transforms the entire contents of a file.
 */
declare function transformFile(filename: string, callback: FileResultCallback): void;

/**
 * Asynchronously transforms the entire contents of a file.
 */
declare function transformFile(filename: string, opts: TransformOptions | undefined, callback: FileResultCallback): void;

/**
 * Synchronous version of `babel.transformFile`. Returns the transformed contents of the `filename`.
 */
declare function transformFileSync(filename: string, opts?: TransformOptions): BabelFileResult | null;

/**
 * Asynchronously transforms the entire contents of a file.
 */
declare function transformFileAsync(filename: string, opts?: TransformOptions): Promise<BabelFileResult | null>;

/**
 * Given an AST, transform it.
 */
declare function transformFromAst(ast: Node, code: string | undefined, callback: FileResultCallback): void;

/**
 * Given an AST, transform it.
 */
declare function transformFromAst(
    ast: Node,
    code: string | undefined,
    opts: TransformOptions | undefined,
    callback: FileResultCallback,
): void;

/**
 * Here for backward-compatibility. Ideally use ".transformSync" if you want a synchronous API.
 */
declare function transformFromAstSync(ast: Node, code?: string, opts?: TransformOptions): BabelFileResult | null;

/**
 * Given an AST, transform it.
 */
declare function transformFromAstAsync(
    ast: Node,
    code?: string,
    opts?: TransformOptions,
): Promise<BabelFileResult | null>;

// A babel plugin is a simple function which must return an object matching
// the following interface. Babel will throw if it finds unknown properties.
// The list of allowed plugin keys is here:
// https://github.com/babel/babel/blob/4e50b2d9d9c376cee7a2cbf56553fe5b982ea53c/packages/babel-core/src/config/option-manager.js#L71
interface PluginObj<S = PluginPass> {
    name?: string | undefined;
    manipulateOptions?(opts: any, parserOpts: any): void;
    pre?(this: S, file: BabelFile): void;
    visitor: Visitor<S>;
    post?(this: S, file: BabelFile): void;
    inherits?: any;
}

interface BabelFile {
    ast: File;
    opts: TransformOptions;
    hub: Hub;
    metadata: object;
    path: NodePath<Program>;
    scope: Scope;
    inputMap: object | null;
    code: string;
}

interface PluginPass {
    file: BabelFile;
    key: string;
    opts: object;
    cwd: string;
    filename: string | undefined;
    get(key: unknown): any;
    set(key: unknown, value: unknown): void;
    [key: string]: unknown;
}

interface BabelFileResult {
    ast?: File | null | undefined;
    code?: string | null | undefined;
    ignored?: boolean | undefined;
    map?:
        | {
            version: number;
            sources: string[];
            names: string[];
            sourceRoot?: string | undefined;
            sourcesContent?: string[] | undefined;
            mappings: string;
            file: string;
        }
        | null
        | undefined;
    metadata?: BabelFileMetadata | undefined;
}

interface BabelFileMetadata {
    usedHelpers: string[];
    marked: Array<{
        type: string;
        message: string;
        loc: object;
    }>;
    modules: BabelFileModulesMetadata;
}

interface BabelFileModulesMetadata {
    imports: object[];
    exports: {
        exported: object[];
        specifiers: object[];
    };
}

type FileParseCallback = (err: Error | null, result: ParseResult | null) => any;

/**
 * Given some code, parse it using Babel's standard behavior.
 * Referenced presets and plugins will be loaded such that optional syntax plugins are automatically enabled.
 */
declare function parse(code: string, callback: FileParseCallback): void;

/**
 * Given some code, parse it using Babel's standard behavior.
 * Referenced presets and plugins will be loaded such that optional syntax plugins are automatically enabled.
 */
declare function parse(code: string, options: TransformOptions | undefined, callback: FileParseCallback): void;

/**
 * Given some code, parse it using Babel's standard behavior.
 * Referenced presets and plugins will be loaded such that optional syntax plugins are automatically enabled.
 */
declare function parse(code: string, options?: TransformOptions): ParseResult | null;

/**
 * Given some code, parse it using Babel's standard behavior.
 * Referenced presets and plugins will be loaded such that optional syntax plugins are automatically enabled.
 */
declare function parseSync(code: string, options?: TransformOptions): ParseResult | null;

/**
 * Given some code, parse it using Babel's standard behavior.
 * Referenced presets and plugins will be loaded such that optional syntax plugins are automatically enabled.
 */
declare function parseAsync(code: string, options?: TransformOptions): Promise<ParseResult | null>;

/**
 * Resolve Babel's options fully, resulting in an options object where:
 *
 * * opts.plugins is a full list of Plugin instances.
 * * opts.presets is empty and all presets are flattened into opts.
 * * It can be safely passed back to Babel. Fields like babelrc have been set to false so that later calls to Babel
 * will not make a second attempt to load config files.
 *
 * Plugin instances aren't meant to be manipulated directly, but often callers will serialize this opts to JSON to
 * use it as a cache key representing the options Babel has received. Caching on this isn't 100% guaranteed to
 * invalidate properly, but it is the best we have at the moment.
 */
declare function loadOptions(options?: TransformOptions): object | null;

/**
 * To allow systems to easily manipulate and validate a user's config, this function resolves the plugins and
 * presets and proceeds no further. The expectation is that callers will take the config's .options, manipulate it
 * as then see fit and pass it back to Babel again.
 *
 * * `babelrc: string | void` - The path of the `.babelrc` file, if there was one.
 * * `babelignore: string | void` - The path of the `.babelignore` file, if there was one.
 * * `options: ValidatedOptions` - The partially resolved options, which can be manipulated and passed back
 * to Babel again.
 *  * `plugins: Array<ConfigItem>` - See below.
 *  * `presets: Array<ConfigItem>` - See below.
 *  * It can be safely passed back to Babel. Fields like `babelrc` have been set to false so that later calls to
 * Babel will not make a second attempt to load config files.
 *
 * `ConfigItem` instances expose properties to introspect the values, but each item should be treated as
 * immutable. If changes are desired, the item should be removed from the list and replaced with either a normal
 * Babel config value, or with a replacement item created by `babel.createConfigItem`. See that function for
 * information about `ConfigItem` fields.
 */
declare function loadPartialConfig(options?: TransformOptions): Readonly<PartialConfig> | null;
declare function loadPartialConfigAsync(options?: TransformOptions): Promise<Readonly<PartialConfig> | null>;

interface PartialConfig {
    options: TransformOptions;
    babelrc?: string | undefined;
    babelignore?: string | undefined;
    config?: string | undefined;
    hasFilesystemConfig: () => boolean;
}

interface ConfigItem {
    /**
     * The name that the user gave the plugin instance, e.g. `plugins: [ ['env', {}, 'my-env'] ]`
     */
    name?: string | undefined;

    /**
     * The resolved value of the plugin.
     */
    value: object | ((...args: any[]) => any);

    /**
     * The options object passed to the plugin.
     */
    options?: object | false | undefined;

    /**
     * The path that the options are relative to.
     */
    dirname: string;

    /**
     * Information about the plugin's file, if Babel knows it.
     *  *
     */
    file?:
        | {
            /**
             * The file that the user requested, e.g. `"@babel/env"`
             */
            request: string;

            /**
             * The full path of the resolved file, e.g. `"/tmp/node_modules/@babel/preset-env/lib/index.js"`
             */
            resolved: string;
        }
        | null
        | undefined;
}

type PluginOptions = object | undefined | false;

type PluginTarget = string | object | ((...args: any[]) => any);

type PluginItem =
    | ConfigItem
    | PluginObj<any>
    | PluginTarget
    | [PluginTarget, PluginOptions]
    | [PluginTarget, PluginOptions, string | undefined];

declare function resolvePlugin(name: string, dirname: string): string | null;
declare function resolvePreset(name: string, dirname: string): string | null;

interface CreateConfigItemOptions {
    dirname?: string | undefined;
    type?: "preset" | "plugin" | undefined;
}

/**
 * Allows build tooling to create and cache config items up front. If this function is called multiple times for a
 * given plugin, Babel will call the plugin's function itself multiple times. If you have a clear set of expected
 * plugins and presets to inject, pre-constructing the config items would be recommended.
 */
declare function createConfigItem(
    value: PluginTarget | [PluginTarget, PluginOptions] | [PluginTarget, PluginOptions, string | undefined],
    options?: CreateConfigItemOptions,
): ConfigItem;

// NOTE: the documentation says the ConfigAPI also exposes @babel/core's exports, but it actually doesn't
/**
 * @see https://babeljs.io/docs/en/next/config-files#config-function-api
 */
interface ConfigAPI {
    /**
     * The version string for the Babel version that is loading the config file.
     *
     * @see https://babeljs.io/docs/en/next/config-files#apiversion
     */
    version: string;
    /**
     * @see https://babeljs.io/docs/en/next/config-files#apicache
     */
    cache: SimpleCacheConfigurator;
    /**
     * @see https://babeljs.io/docs/en/next/config-files#apienv
     */
    env: EnvFunction;
    // undocumented; currently hardcoded to return 'false'
    // async(): boolean
    /**
     * This API is used as a way to access the `caller` data that has been passed to Babel.
     * Since many instances of Babel may be running in the same process with different `caller` values,
     * this API is designed to automatically configure `api.cache`, the same way `api.env()` does.
     *
     * The `caller` value is available as the first parameter of the callback function.
     * It is best used with something like this to toggle configuration behavior
     * based on a specific environment:
     *
     * @example
     * function isBabelRegister(caller?: { name: string }) {
     *   return !!(caller && caller.name === "@babel/register")
     * }
     * api.caller(isBabelRegister)
     *
     * @see https://babeljs.io/docs/en/next/config-files#apicallercb
     */
    caller<T extends SimpleCacheKey>(callerCallback: (caller: TransformOptions["caller"]) => T): T;
    /**
     * While `api.version` can be useful in general, it's sometimes nice to just declare your version.
     * This API exposes a simple way to do that with:
     *
     * @example
     * api.assertVersion(7) // major version only
     * api.assertVersion("^7.2")
     *
     * @see https://babeljs.io/docs/en/next/config-files#apiassertversionrange
     */
    assertVersion(versionRange: number | string): boolean;
    // NOTE: this is an undocumented reexport from "@babel/parser" but it's missing from its types
    // tokTypes: typeof tokTypes
}

/**
 * JS configs are great because they can compute a config on the fly,
 * but the downside there is that it makes caching harder.
 * Babel wants to avoid re-executing the config function every time a file is compiled,
 * because then it would also need to re-execute any plugin and preset functions
 * referenced in that config.
 *
 * To avoid this, Babel expects users of config functions to tell it how to manage caching
 * within a config file.
 *
 * @see https://babeljs.io/docs/en/next/config-files#apicache
 */
interface SimpleCacheConfigurator {
    // there is an undocumented call signature that is a shorthand for forever()/never()/using().
    // (ever: boolean): void
    // <T extends SimpleCacheKey>(callback: CacheCallback<T>): T
    /**
     * Permacache the computed config and never call the function again.
     */
    forever(): void;
    /**
     * Do not cache this config, and re-execute the function every time.
     */
    never(): void;
    /**
     * Any time the using callback returns a value other than the one that was expected,
     * the overall config function will be called again and a new entry will be added to the cache.
     *
     * @example
     * api.cache.using(() => process.env.NODE_ENV)
     */
    using<T extends SimpleCacheKey>(callback: SimpleCacheCallback<T>): T;
    /**
     * Any time the using callback returns a value other than the one that was expected,
     * the overall config function will be called again and all entries in the cache will
     * be replaced with the result.
     *
     * @example
     * api.cache.invalidate(() => process.env.NODE_ENV)
     */
    invalidate<T extends SimpleCacheKey>(callback: SimpleCacheCallback<T>): T;
}

// https://github.com/babel/babel/blob/v7.3.3/packages/babel-core/src/config/caching.js#L231
type SimpleCacheKey = string | boolean | number | null | undefined;
type SimpleCacheCallback<T extends SimpleCacheKey> = () => T;

/**
 * Since `NODE_ENV` is a fairly common way to toggle behavior, Babel also includes an API function
 * meant specifically for that. This API is used as a quick way to check the `"envName"` that Babel
 * was loaded with, which takes `NODE_ENV` into account if no other overriding environment is set.
 *
 * @see https://babeljs.io/docs/en/next/config-files#apienv
 */
interface EnvFunction {
    /**
     * @returns the current `envName` string
     */
    (): string;
    /**
     * @returns `true` if the `envName` is `===` any of the given strings
     */
    (envName: string | readonly string[]): boolean;
    // the official documentation is misleading for this one...
    // this just passes the callback to `cache.using` but with an additional argument.
    // it returns its result instead of necessarily returning a boolean.
    <T extends SimpleCacheKey>(envCallback: (envName: NonNullable<TransformOptions["envName"]>) => T): T;
}

type ConfigFunction = (api: ConfigAPI) => TransformOptions;

type index_d_BabelFile = BabelFile;
type index_d_BabelFileMetadata = BabelFileMetadata;
type index_d_BabelFileModulesMetadata = BabelFileModulesMetadata;
type index_d_BabelFileResult = BabelFileResult;
type index_d_ConfigAPI = ConfigAPI;
type index_d_ConfigFunction = ConfigFunction;
type index_d_ConfigItem = ConfigItem;
type index_d_CreateConfigItemOptions = CreateConfigItemOptions;
declare const index_d_DEFAULT_EXTENSIONS: typeof DEFAULT_EXTENSIONS;
type index_d_EnvFunction = EnvFunction;
type index_d_FileParseCallback = FileParseCallback;
type index_d_FileResultCallback = FileResultCallback;
type index_d_GeneratorOptions = GeneratorOptions;
type index_d_MatchPattern = MatchPattern;
type index_d_MatchPatternContext = MatchPatternContext;
type index_d_Node = Node;
type index_d_NodePath<T = Node$1> = NodePath<T>;
declare const index_d_NodePath: typeof NodePath;
type index_d_ParseResult = ParseResult;
type index_d_ParserOptions = ParserOptions;
type index_d_PartialConfig = PartialConfig;
type index_d_PluginItem = PluginItem;
type index_d_PluginObj<S = PluginPass> = PluginObj<S>;
type index_d_PluginOptions = PluginOptions;
type index_d_PluginPass = PluginPass;
type index_d_PluginTarget = PluginTarget;
type index_d_SimpleCacheCallback<T extends SimpleCacheKey> = SimpleCacheCallback<T>;
type index_d_SimpleCacheConfigurator = SimpleCacheConfigurator;
type index_d_SimpleCacheKey = SimpleCacheKey;
type index_d_TransformCaller = TransformCaller;
type index_d_TransformOptions = TransformOptions;
type index_d_Visitor<S = unknown> = Visitor<S>;
declare const index_d_createConfigItem: typeof createConfigItem;
declare const index_d_loadOptions: typeof loadOptions;
declare const index_d_loadPartialConfig: typeof loadPartialConfig;
declare const index_d_loadPartialConfigAsync: typeof loadPartialConfigAsync;
declare const index_d_parse: typeof parse;
declare const index_d_parseAsync: typeof parseAsync;
declare const index_d_parseSync: typeof parseSync;
declare const index_d_resolvePlugin: typeof resolvePlugin;
declare const index_d_resolvePreset: typeof resolvePreset;
declare const index_d_transform: typeof transform;
declare const index_d_transformAsync: typeof transformAsync;
declare const index_d_transformFile: typeof transformFile;
declare const index_d_transformFileAsync: typeof transformFileAsync;
declare const index_d_transformFileSync: typeof transformFileSync;
declare const index_d_transformFromAst: typeof transformFromAst;
declare const index_d_transformFromAstAsync: typeof transformFromAstAsync;
declare const index_d_transformFromAstSync: typeof transformFromAstSync;
declare const index_d_transformSync: typeof transformSync;
declare const index_d_version: typeof version;
declare namespace index_d {
  export { type index_d_BabelFile as BabelFile, type index_d_BabelFileMetadata as BabelFileMetadata, type index_d_BabelFileModulesMetadata as BabelFileModulesMetadata, type index_d_BabelFileResult as BabelFileResult, type index_d_ConfigAPI as ConfigAPI, type index_d_ConfigFunction as ConfigFunction, type index_d_ConfigItem as ConfigItem, type index_d_CreateConfigItemOptions as CreateConfigItemOptions, index_d_DEFAULT_EXTENSIONS as DEFAULT_EXTENSIONS, type index_d_EnvFunction as EnvFunction, type index_d_FileParseCallback as FileParseCallback, type index_d_FileResultCallback as FileResultCallback, type index_d_GeneratorOptions as GeneratorOptions, type index_d_MatchPattern as MatchPattern, type index_d_MatchPatternContext as MatchPatternContext, type index_d_Node as Node, index_d_NodePath as NodePath, type index_d_ParseResult as ParseResult, type index_d_ParserOptions as ParserOptions, type index_d_PartialConfig as PartialConfig, type index_d_PluginItem as PluginItem, type index_d_PluginObj as PluginObj, type index_d_PluginOptions as PluginOptions, type index_d_PluginPass as PluginPass, type index_d_PluginTarget as PluginTarget, type index_d_SimpleCacheCallback as SimpleCacheCallback, type index_d_SimpleCacheConfigurator as SimpleCacheConfigurator, type index_d_SimpleCacheKey as SimpleCacheKey, type index_d_TransformCaller as TransformCaller, type index_d_TransformOptions as TransformOptions, type index_d_Visitor as Visitor, index_d_createConfigItem as createConfigItem, index_d_loadOptions as loadOptions, index_d_loadPartialConfig as loadPartialConfig, index_d_loadPartialConfigAsync as loadPartialConfigAsync, index_d_parse as parse, index_d_parseAsync as parseAsync, index_d_parseSync as parseSync, index_d_resolvePlugin as resolvePlugin, index_d_resolvePreset as resolvePreset, templateBuilder as template, index_d_transform as transform, index_d_transformAsync as transformAsync, index_d_transformFile as transformFile, index_d_transformFileAsync as transformFileAsync, index_d_transformFileSync as transformFileSync, index_d_transformFromAst as transformFromAst, index_d_transformFromAstAsync as transformFromAstAsync, index_d_transformFromAstSync as transformFromAstSync, index_d_transformSync as transformSync, traverse$1 as traverse, index_d$1 as types, index_d_version as version };
}

declare const parserOptions: ParserOptions;
declare const babelParse: (code: string) => File;
interface ASTNode {
    type: string;
}
declare const babelPrint: (ast: ASTNode) => string;
declare const babelParseExpression: (code: string) => ParseResult$1<Expression>;

/**
 * This entry is to ensure we use a single version of Babel across the codebase. This is to prevent
 * issues with multiple versions of Babel being used in the same project. It also prevents us from
 * bundling babel multiple times in the final bundles.
 */

declare const traverse: typeof traverse$1;
declare const generate: typeof generate$1;
declare const BabelFileClass: any;

export { type BabelFile, BabelFileClass, type GeneratorOptions, NodePath, babelParse, babelParseExpression, babelPrint, index_d as core, generate, babelParser_d as parser, parserOptions, transformSync, traverse, index_d$1 as types };
