import CJS_COMPAT_NODE_URL_39zvq8kkt8 from 'node:url';
import CJS_COMPAT_NODE_PATH_39zvq8kkt8 from 'node:path';
import CJS_COMPAT_NODE_MODULE_39zvq8kkt8 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_39zvq8kkt8.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_39zvq8kkt8.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_39zvq8kkt8.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  toEstree
} from "./chunk-JFMDUYER.js";
import {
  __name
} from "./chunk-JBW3FROT.js";

// ../node_modules/@storybook/docs-mdx/dist/index.js
var getAttr = /* @__PURE__ */ __name((elt, what) => elt.attributes.find((n) => n.type === "JSXAttribute" && n.name.name === what), "getAttr");
var getAttrValue = /* @__PURE__ */ __name((elt, what) => {
  const attr = getAttr(elt, what);
  return attr?.value;
}, "getAttrValue");
var getAttrLiteral = /* @__PURE__ */ __name((elt, what) => {
  const attrValue = getAttrValue(elt, what);
  if (!attrValue)
    return void 0;
  if (attrValue.type === "Literal") {
    return attrValue.value;
  } else {
    throw new Error(`Expected string literal ${what}, received ${attrValue.type}`);
  }
}, "getAttrLiteral");
var getOf = /* @__PURE__ */ __name((elt, varToImport) => {
  const ofAttrValue = getAttrValue(elt, "of");
  if (ofAttrValue) {
    if (ofAttrValue.type === "JSXExpressionContainer") {
      const of = ofAttrValue.expression;
      if (of?.type === "Identifier") {
        const importName = varToImport[of.name];
        if (importName) {
          return importName;
        } else {
          throw new Error(`Unknown identifier ${of.name}`);
        }
      } else {
        throw new Error(`Expected identifier, received ${of.type}`);
      }
    } else {
      throw new Error(`Expected JSX expression, received ${ofAttrValue.type}`);
    }
  }
}, "getOf");
var getTags = /* @__PURE__ */ __name((elt) => {
  const tagsAttr = getAttr(elt, "tags");
  if (!tagsAttr)
    return void 0;
  const tagsContainer = tagsAttr.value;
  if (tagsContainer.type === "JSXExpressionContainer") {
    const tagsArray = tagsContainer.expression;
    if (tagsArray.type === "ArrayExpression") {
      const metaTags = tagsArray.elements.map((tag) => {
        if (tag.type === "Literal" && typeof tag.value === "string") {
          return tag.value;
        } else {
          throw new Error(`Expected string literal tag, received ${tag.type}`);
        }
      });
      return metaTags;
    } else {
      throw new Error(`Expected tags array, received ${tagsArray.type}`);
    }
  } else {
    throw new Error(`Expected JSX expression tags, received ${tagsContainer.type}`);
  }
}, "getTags");
var getIsTemplate = /* @__PURE__ */ __name((elt) => {
  const isTemplateAttr = getAttr(elt, "isTemplate");
  if (!isTemplateAttr)
    return false;
  const isTemplate = isTemplateAttr.value;
  if (isTemplate == null) {
    return true;
  } else if (isTemplate.type === "JSXExpressionContainer") {
    const expression = isTemplate.expression;
    if (expression.type === "Literal" && typeof expression.value === "boolean") {
      return expression.value;
    } else {
      throw new Error(`Expected boolean isTemplate, received ${typeof expression.value}`);
    }
  } else {
    throw new Error(`Expected expression isTemplate, received ${isTemplate.type}`);
  }
}, "getIsTemplate");
var extractTitle = /* @__PURE__ */ __name((root, varToImport) => {
  const result = { title: void 0, of: void 0, name: void 0, isTemplate: false };
  let fragments = root.body.filter(
    (child) => child.type === "ExpressionStatement" && child.expression.type === "JSXFragment"
  );
  if (fragments.length > 1)
    throw new Error("duplicate contents");
  if (fragments.length === 0)
    return result;
  const fragment = fragments[0].expression;
  fragment.children.forEach((child) => {
    if (child.type === "JSXElement") {
      const { openingElement } = child;
      const name = openingElement.name.name;
      if (name === "Meta") {
        if (result.title || result.name || result.of) {
          throw new Error("Meta can only be declared once");
        }
        result.title = getAttrLiteral(openingElement, "title");
        result.name = getAttrLiteral(openingElement, "name");
        result.of = getOf(openingElement, varToImport);
        result.isTemplate = getIsTemplate(openingElement);
        result.metaTags = getTags(openingElement);
      }
    } else if (child.type === "JSXExpressionContainer") {
    } else {
      throw new Error(`Unexpected JSX child: ${child.type}`);
    }
  });
  return result;
}, "extractTitle");
var extractImports = /* @__PURE__ */ __name((root) => {
  const varToImport = {};
  root.body.forEach((child) => {
    if (child.type === "ImportDeclaration") {
      const { source, specifiers } = child;
      if (source.type === "Literal") {
        specifiers.forEach((s) => {
          varToImport[s.local.name] = source.value.toString();
        });
      } else {
        throw new Error("MDX: unexpected import source");
      }
    }
  });
  return varToImport;
}, "extractImports");
var plugin = /* @__PURE__ */ __name((store) => (root) => {
  const estree = toEstree(root);
  const varToImport = extractImports(estree);
  const { title, of, name, isTemplate, metaTags } = extractTitle(estree, varToImport);
  store.title = title;
  store.of = of;
  store.name = name;
  store.isTemplate = isTemplate;
  store.metaTags = metaTags;
  store.imports = Array.from(new Set(Object.values(varToImport)));
  return root;
}, "plugin");
var analyze = /* @__PURE__ */ __name(async (code) => {
  const store = {
    title: void 0,
    of: void 0,
    name: void 0,
    isTemplate: false,
    metaTags: void 0,
    imports: void 0
  };
  const { compile } = await import("./mdx-N42X6CFJ-MK2KTUH7.js");
  await compile(code, {
    rehypePlugins: [[plugin, store]]
  });
  const { title, of, name, isTemplate, metaTags, imports = [] } = store;
  return { title, of, name, isTemplate, metaTags, imports };
}, "analyze");
export {
  analyze,
  extractImports,
  plugin
};
