import CJS_COMPAT_NODE_URL_39zvq8kkt8 from 'node:url';
import CJS_COMPAT_NODE_PATH_39zvq8kkt8 from 'node:path';
import CJS_COMPAT_NODE_MODULE_39zvq8kkt8 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_39zvq8kkt8.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_39zvq8kkt8.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_39zvq8kkt8.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name,
  __require
} from "./chunk-JBW3FROT.js";

// ../node_modules/@storybook/docs-mdx/dist/chunk-H6DQNFQR.js
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __require2 = ((x) => typeof __require !== "undefined" ? __require : typeof Proxy !== "undefined" ? new Proxy(x, {
  get: /* @__PURE__ */ __name((a, b) => (typeof __require !== "undefined" ? __require : a)[b], "get")
}) : x)(function(x) {
  if (typeof __require !== "undefined")
    return __require.apply(this, arguments);
  throw new Error('Dynamic require of "' + x + '" is not supported');
});
var __commonJS = /* @__PURE__ */ __name((cb, mod) => /* @__PURE__ */ __name(function __require22() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
}, "__require2"), "__commonJS");
var __export = /* @__PURE__ */ __name((target, all2) => {
  for (var name2 in all2)
    __defProp(target, name2, { get: all2[name2], enumerable: true });
}, "__export");
var __copyProps = /* @__PURE__ */ __name((to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: /* @__PURE__ */ __name(() => from[key], "get"), enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
}, "__copyProps");
var __toESM = /* @__PURE__ */ __name((mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
)), "__toESM");
var require_inline_style_parser = __commonJS({
  "node_modules/inline-style-parser/index.js"(exports, module) {
    var COMMENT_REGEX = /\/\*[^*]*\*+([^/*][^*]*\*+)*\//g;
    var NEWLINE_REGEX = /\n/g;
    var WHITESPACE_REGEX = /^\s*/;
    var PROPERTY_REGEX = /^(\*?[-#/*\\\w]+(\[[0-9a-z_-]+\])?)\s*/;
    var COLON_REGEX = /^:\s*/;
    var VALUE_REGEX = /^((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^)]*?\)|[^};])+)/;
    var SEMICOLON_REGEX = /^[;\s]*/;
    var TRIM_REGEX = /^\s+|\s+$/g;
    var NEWLINE = "\n";
    var FORWARD_SLASH = "/";
    var ASTERISK = "*";
    var EMPTY_STRING = "";
    var TYPE_COMMENT = "comment";
    var TYPE_DECLARATION = "declaration";
    module.exports = function(style, options) {
      if (typeof style !== "string") {
        throw new TypeError("First argument must be a string");
      }
      if (!style)
        return [];
      options = options || {};
      var lineno = 1;
      var column = 1;
      function updatePosition(str) {
        var lines = str.match(NEWLINE_REGEX);
        if (lines)
          lineno += lines.length;
        var i = str.lastIndexOf(NEWLINE);
        column = ~i ? str.length - i : column + str.length;
      }
      __name(updatePosition, "updatePosition");
      function position2() {
        var start2 = { line: lineno, column };
        return function(node) {
          node.position = new Position(start2);
          whitespace2();
          return node;
        };
      }
      __name(position2, "position2");
      function Position(start2) {
        this.start = start2;
        this.end = { line: lineno, column };
        this.source = options.source;
      }
      __name(Position, "Position");
      Position.prototype.content = style;
      var errorsList = [];
      function error(msg) {
        var err = new Error(
          options.source + ":" + lineno + ":" + column + ": " + msg
        );
        err.reason = msg;
        err.filename = options.source;
        err.line = lineno;
        err.column = column;
        err.source = style;
        if (options.silent) {
          errorsList.push(err);
        } else {
          throw err;
        }
      }
      __name(error, "error");
      function match(re2) {
        var m = re2.exec(style);
        if (!m)
          return;
        var str = m[0];
        updatePosition(str);
        style = style.slice(str.length);
        return m;
      }
      __name(match, "match");
      function whitespace2() {
        match(WHITESPACE_REGEX);
      }
      __name(whitespace2, "whitespace2");
      function comments(rules) {
        var c;
        rules = rules || [];
        while (c = comment2()) {
          if (c !== false) {
            rules.push(c);
          }
        }
        return rules;
      }
      __name(comments, "comments");
      function comment2() {
        var pos = position2();
        if (FORWARD_SLASH != style.charAt(0) || ASTERISK != style.charAt(1))
          return;
        var i = 2;
        while (EMPTY_STRING != style.charAt(i) && (ASTERISK != style.charAt(i) || FORWARD_SLASH != style.charAt(i + 1))) {
          ++i;
        }
        i += 2;
        if (EMPTY_STRING === style.charAt(i - 1)) {
          return error("End of comment missing");
        }
        var str = style.slice(2, i - 2);
        column += 2;
        updatePosition(str);
        style = style.slice(i);
        column += 2;
        return pos({
          type: TYPE_COMMENT,
          comment: str
        });
      }
      __name(comment2, "comment2");
      function declaration() {
        var pos = position2();
        var prop = match(PROPERTY_REGEX);
        if (!prop)
          return;
        comment2();
        if (!match(COLON_REGEX))
          return error("property missing ':'");
        var val = match(VALUE_REGEX);
        var ret = pos({
          type: TYPE_DECLARATION,
          property: trim(prop[0].replace(COMMENT_REGEX, EMPTY_STRING)),
          value: val ? trim(val[0].replace(COMMENT_REGEX, EMPTY_STRING)) : EMPTY_STRING
        });
        match(SEMICOLON_REGEX);
        return ret;
      }
      __name(declaration, "declaration");
      function declarations() {
        var decls = [];
        comments(decls);
        var decl;
        while (decl = declaration()) {
          if (decl !== false) {
            decls.push(decl);
            comments(decls);
          }
        }
        return decls;
      }
      __name(declarations, "declarations");
      whitespace2();
      return declarations();
    };
    function trim(str) {
      return str ? str.replace(TRIM_REGEX, EMPTY_STRING) : EMPTY_STRING;
    }
    __name(trim, "trim");
  }
});
var require_style_to_object = __commonJS({
  "node_modules/style-to-object/index.js"(exports, module) {
    var parse = require_inline_style_parser();
    function StyleToObject2(style, iterator) {
      var output = null;
      if (!style || typeof style !== "string") {
        return output;
      }
      var declaration;
      var declarations = parse(style);
      var hasIterator = typeof iterator === "function";
      var property;
      var value;
      for (var i = 0, len = declarations.length; i < len; i++) {
        declaration = declarations[i];
        property = declaration.property;
        value = declaration.value;
        if (hasIterator) {
          iterator(property, value, declaration);
        } else if (value) {
          output || (output = {});
          output[property] = value;
        }
      }
      return output;
    }
    __name(StyleToObject2, "StyleToObject2");
    module.exports = StyleToObject2;
    module.exports.default = StyleToObject2;
  }
});
function ok() {
}
__name(ok, "ok");
function unreachable() {
}
__name(unreachable, "unreachable");
var Schema = class {
  static {
    __name(this, "Schema");
  }
  /**
   * @constructor
   * @param {Properties} property
   * @param {Normal} normal
   * @param {string} [space]
   */
  constructor(property, normal, space) {
    this.property = property;
    this.normal = normal;
    if (space) {
      this.space = space;
    }
  }
};
Schema.prototype.property = {};
Schema.prototype.normal = {};
Schema.prototype.space = null;
function merge(definitions, space) {
  const property = {};
  const normal = {};
  let index = -1;
  while (++index < definitions.length) {
    Object.assign(property, definitions[index].property);
    Object.assign(normal, definitions[index].normal);
  }
  return new Schema(property, normal, space);
}
__name(merge, "merge");
function normalize(value) {
  return value.toLowerCase();
}
__name(normalize, "normalize");
var Info = class {
  static {
    __name(this, "Info");
  }
  /**
   * @constructor
   * @param {string} property
   * @param {string} attribute
   */
  constructor(property, attribute) {
    this.property = property;
    this.attribute = attribute;
  }
};
Info.prototype.space = null;
Info.prototype.boolean = false;
Info.prototype.booleanish = false;
Info.prototype.overloadedBoolean = false;
Info.prototype.number = false;
Info.prototype.commaSeparated = false;
Info.prototype.spaceSeparated = false;
Info.prototype.commaOrSpaceSeparated = false;
Info.prototype.mustUseProperty = false;
Info.prototype.defined = false;
var types_exports = {};
__export(types_exports, {
  boolean: /* @__PURE__ */ __name(() => boolean, "boolean"),
  booleanish: /* @__PURE__ */ __name(() => booleanish, "booleanish"),
  commaOrSpaceSeparated: /* @__PURE__ */ __name(() => commaOrSpaceSeparated, "commaOrSpaceSeparated"),
  commaSeparated: /* @__PURE__ */ __name(() => commaSeparated, "commaSeparated"),
  number: /* @__PURE__ */ __name(() => number, "number"),
  overloadedBoolean: /* @__PURE__ */ __name(() => overloadedBoolean, "overloadedBoolean"),
  spaceSeparated: /* @__PURE__ */ __name(() => spaceSeparated, "spaceSeparated")
});
var powers = 0;
var boolean = increment();
var booleanish = increment();
var overloadedBoolean = increment();
var number = increment();
var spaceSeparated = increment();
var commaSeparated = increment();
var commaOrSpaceSeparated = increment();
function increment() {
  return 2 ** ++powers;
}
__name(increment, "increment");
var checks = Object.keys(types_exports);
var DefinedInfo = class extends Info {
  static {
    __name(this, "DefinedInfo");
  }
  /**
   * @constructor
   * @param {string} property
   * @param {string} attribute
   * @param {number|null} [mask]
   * @param {string} [space]
   */
  constructor(property, attribute, mask, space) {
    let index = -1;
    super(property, attribute);
    mark(this, "space", space);
    if (typeof mask === "number") {
      while (++index < checks.length) {
        const check = checks[index];
        mark(this, checks[index], (mask & types_exports[check]) === types_exports[check]);
      }
    }
  }
};
DefinedInfo.prototype.defined = true;
function mark(values, key, value) {
  if (value) {
    values[key] = value;
  }
}
__name(mark, "mark");
var own = {}.hasOwnProperty;
function create(definition) {
  const property = {};
  const normal = {};
  let prop;
  for (prop in definition.properties) {
    if (own.call(definition.properties, prop)) {
      const value = definition.properties[prop];
      const info = new DefinedInfo(
        prop,
        definition.transform(definition.attributes || {}, prop),
        value,
        definition.space
      );
      if (definition.mustUseProperty && definition.mustUseProperty.includes(prop)) {
        info.mustUseProperty = true;
      }
      property[prop] = info;
      normal[normalize(prop)] = prop;
      normal[normalize(info.attribute)] = prop;
    }
  }
  return new Schema(property, normal, definition.space);
}
__name(create, "create");
var xlink = create({
  space: "xlink",
  transform(_, prop) {
    return "xlink:" + prop.slice(5).toLowerCase();
  },
  properties: {
    xLinkActuate: null,
    xLinkArcRole: null,
    xLinkHref: null,
    xLinkRole: null,
    xLinkShow: null,
    xLinkTitle: null,
    xLinkType: null
  }
});
var xml = create({
  space: "xml",
  transform(_, prop) {
    return "xml:" + prop.slice(3).toLowerCase();
  },
  properties: { xmlLang: null, xmlBase: null, xmlSpace: null }
});
function caseSensitiveTransform(attributes, attribute) {
  return attribute in attributes ? attributes[attribute] : attribute;
}
__name(caseSensitiveTransform, "caseSensitiveTransform");
function caseInsensitiveTransform(attributes, property) {
  return caseSensitiveTransform(attributes, property.toLowerCase());
}
__name(caseInsensitiveTransform, "caseInsensitiveTransform");
var xmlns = create({
  space: "xmlns",
  attributes: { xmlnsxlink: "xmlns:xlink" },
  transform: caseInsensitiveTransform,
  properties: { xmlns: null, xmlnsXLink: null }
});
var aria = create({
  transform(_, prop) {
    return prop === "role" ? prop : "aria-" + prop.slice(4).toLowerCase();
  },
  properties: {
    ariaActiveDescendant: null,
    ariaAtomic: booleanish,
    ariaAutoComplete: null,
    ariaBusy: booleanish,
    ariaChecked: booleanish,
    ariaColCount: number,
    ariaColIndex: number,
    ariaColSpan: number,
    ariaControls: spaceSeparated,
    ariaCurrent: null,
    ariaDescribedBy: spaceSeparated,
    ariaDetails: null,
    ariaDisabled: booleanish,
    ariaDropEffect: spaceSeparated,
    ariaErrorMessage: null,
    ariaExpanded: booleanish,
    ariaFlowTo: spaceSeparated,
    ariaGrabbed: booleanish,
    ariaHasPopup: null,
    ariaHidden: booleanish,
    ariaInvalid: null,
    ariaKeyShortcuts: null,
    ariaLabel: null,
    ariaLabelledBy: spaceSeparated,
    ariaLevel: number,
    ariaLive: null,
    ariaModal: booleanish,
    ariaMultiLine: booleanish,
    ariaMultiSelectable: booleanish,
    ariaOrientation: null,
    ariaOwns: spaceSeparated,
    ariaPlaceholder: null,
    ariaPosInSet: number,
    ariaPressed: booleanish,
    ariaReadOnly: booleanish,
    ariaRelevant: null,
    ariaRequired: booleanish,
    ariaRoleDescription: spaceSeparated,
    ariaRowCount: number,
    ariaRowIndex: number,
    ariaRowSpan: number,
    ariaSelected: booleanish,
    ariaSetSize: number,
    ariaSort: null,
    ariaValueMax: number,
    ariaValueMin: number,
    ariaValueNow: number,
    ariaValueText: null,
    role: null
  }
});
var html = create({
  space: "html",
  attributes: {
    acceptcharset: "accept-charset",
    classname: "class",
    htmlfor: "for",
    httpequiv: "http-equiv"
  },
  transform: caseInsensitiveTransform,
  mustUseProperty: ["checked", "multiple", "muted", "selected"],
  properties: {
    // Standard Properties.
    abbr: null,
    accept: commaSeparated,
    acceptCharset: spaceSeparated,
    accessKey: spaceSeparated,
    action: null,
    allow: null,
    allowFullScreen: boolean,
    allowPaymentRequest: boolean,
    allowUserMedia: boolean,
    alt: null,
    as: null,
    async: boolean,
    autoCapitalize: null,
    autoComplete: spaceSeparated,
    autoFocus: boolean,
    autoPlay: boolean,
    blocking: spaceSeparated,
    capture: boolean,
    charSet: null,
    checked: boolean,
    cite: null,
    className: spaceSeparated,
    cols: number,
    colSpan: null,
    content: null,
    contentEditable: booleanish,
    controls: boolean,
    controlsList: spaceSeparated,
    coords: number | commaSeparated,
    crossOrigin: null,
    data: null,
    dateTime: null,
    decoding: null,
    default: boolean,
    defer: boolean,
    dir: null,
    dirName: null,
    disabled: boolean,
    download: overloadedBoolean,
    draggable: booleanish,
    encType: null,
    enterKeyHint: null,
    fetchPriority: null,
    form: null,
    formAction: null,
    formEncType: null,
    formMethod: null,
    formNoValidate: boolean,
    formTarget: null,
    headers: spaceSeparated,
    height: number,
    hidden: boolean,
    high: number,
    href: null,
    hrefLang: null,
    htmlFor: spaceSeparated,
    httpEquiv: spaceSeparated,
    id: null,
    imageSizes: null,
    imageSrcSet: null,
    inert: boolean,
    inputMode: null,
    integrity: null,
    is: null,
    isMap: boolean,
    itemId: null,
    itemProp: spaceSeparated,
    itemRef: spaceSeparated,
    itemScope: boolean,
    itemType: spaceSeparated,
    kind: null,
    label: null,
    lang: null,
    language: null,
    list: null,
    loading: null,
    loop: boolean,
    low: number,
    manifest: null,
    max: null,
    maxLength: number,
    media: null,
    method: null,
    min: null,
    minLength: number,
    multiple: boolean,
    muted: boolean,
    name: null,
    nonce: null,
    noModule: boolean,
    noValidate: boolean,
    onAbort: null,
    onAfterPrint: null,
    onAuxClick: null,
    onBeforeMatch: null,
    onBeforePrint: null,
    onBeforeToggle: null,
    onBeforeUnload: null,
    onBlur: null,
    onCancel: null,
    onCanPlay: null,
    onCanPlayThrough: null,
    onChange: null,
    onClick: null,
    onClose: null,
    onContextLost: null,
    onContextMenu: null,
    onContextRestored: null,
    onCopy: null,
    onCueChange: null,
    onCut: null,
    onDblClick: null,
    onDrag: null,
    onDragEnd: null,
    onDragEnter: null,
    onDragExit: null,
    onDragLeave: null,
    onDragOver: null,
    onDragStart: null,
    onDrop: null,
    onDurationChange: null,
    onEmptied: null,
    onEnded: null,
    onError: null,
    onFocus: null,
    onFormData: null,
    onHashChange: null,
    onInput: null,
    onInvalid: null,
    onKeyDown: null,
    onKeyPress: null,
    onKeyUp: null,
    onLanguageChange: null,
    onLoad: null,
    onLoadedData: null,
    onLoadedMetadata: null,
    onLoadEnd: null,
    onLoadStart: null,
    onMessage: null,
    onMessageError: null,
    onMouseDown: null,
    onMouseEnter: null,
    onMouseLeave: null,
    onMouseMove: null,
    onMouseOut: null,
    onMouseOver: null,
    onMouseUp: null,
    onOffline: null,
    onOnline: null,
    onPageHide: null,
    onPageShow: null,
    onPaste: null,
    onPause: null,
    onPlay: null,
    onPlaying: null,
    onPopState: null,
    onProgress: null,
    onRateChange: null,
    onRejectionHandled: null,
    onReset: null,
    onResize: null,
    onScroll: null,
    onScrollEnd: null,
    onSecurityPolicyViolation: null,
    onSeeked: null,
    onSeeking: null,
    onSelect: null,
    onSlotChange: null,
    onStalled: null,
    onStorage: null,
    onSubmit: null,
    onSuspend: null,
    onTimeUpdate: null,
    onToggle: null,
    onUnhandledRejection: null,
    onUnload: null,
    onVolumeChange: null,
    onWaiting: null,
    onWheel: null,
    open: boolean,
    optimum: number,
    pattern: null,
    ping: spaceSeparated,
    placeholder: null,
    playsInline: boolean,
    popover: null,
    popoverTarget: null,
    popoverTargetAction: null,
    poster: null,
    preload: null,
    readOnly: boolean,
    referrerPolicy: null,
    rel: spaceSeparated,
    required: boolean,
    reversed: boolean,
    rows: number,
    rowSpan: number,
    sandbox: spaceSeparated,
    scope: null,
    scoped: boolean,
    seamless: boolean,
    selected: boolean,
    shadowRootDelegatesFocus: boolean,
    shadowRootMode: null,
    shape: null,
    size: number,
    sizes: null,
    slot: null,
    span: number,
    spellCheck: booleanish,
    src: null,
    srcDoc: null,
    srcLang: null,
    srcSet: null,
    start: number,
    step: null,
    style: null,
    tabIndex: number,
    target: null,
    title: null,
    translate: null,
    type: null,
    typeMustMatch: boolean,
    useMap: null,
    value: booleanish,
    width: number,
    wrap: null,
    // Legacy.
    // See: https://html.spec.whatwg.org/#other-elements,-attributes-and-apis
    align: null,
    // Several. Use CSS `text-align` instead,
    aLink: null,
    // `<body>`. Use CSS `a:active {color}` instead
    archive: spaceSeparated,
    // `<object>`. List of URIs to archives
    axis: null,
    // `<td>` and `<th>`. Use `scope` on `<th>`
    background: null,
    // `<body>`. Use CSS `background-image` instead
    bgColor: null,
    // `<body>` and table elements. Use CSS `background-color` instead
    border: number,
    // `<table>`. Use CSS `border-width` instead,
    borderColor: null,
    // `<table>`. Use CSS `border-color` instead,
    bottomMargin: number,
    // `<body>`
    cellPadding: null,
    // `<table>`
    cellSpacing: null,
    // `<table>`
    char: null,
    // Several table elements. When `align=char`, sets the character to align on
    charOff: null,
    // Several table elements. When `char`, offsets the alignment
    classId: null,
    // `<object>`
    clear: null,
    // `<br>`. Use CSS `clear` instead
    code: null,
    // `<object>`
    codeBase: null,
    // `<object>`
    codeType: null,
    // `<object>`
    color: null,
    // `<font>` and `<hr>`. Use CSS instead
    compact: boolean,
    // Lists. Use CSS to reduce space between items instead
    declare: boolean,
    // `<object>`
    event: null,
    // `<script>`
    face: null,
    // `<font>`. Use CSS instead
    frame: null,
    // `<table>`
    frameBorder: null,
    // `<iframe>`. Use CSS `border` instead
    hSpace: number,
    // `<img>` and `<object>`
    leftMargin: number,
    // `<body>`
    link: null,
    // `<body>`. Use CSS `a:link {color: *}` instead
    longDesc: null,
    // `<frame>`, `<iframe>`, and `<img>`. Use an `<a>`
    lowSrc: null,
    // `<img>`. Use a `<picture>`
    marginHeight: number,
    // `<body>`
    marginWidth: number,
    // `<body>`
    noResize: boolean,
    // `<frame>`
    noHref: boolean,
    // `<area>`. Use no href instead of an explicit `nohref`
    noShade: boolean,
    // `<hr>`. Use background-color and height instead of borders
    noWrap: boolean,
    // `<td>` and `<th>`
    object: null,
    // `<applet>`
    profile: null,
    // `<head>`
    prompt: null,
    // `<isindex>`
    rev: null,
    // `<link>`
    rightMargin: number,
    // `<body>`
    rules: null,
    // `<table>`
    scheme: null,
    // `<meta>`
    scrolling: booleanish,
    // `<frame>`. Use overflow in the child context
    standby: null,
    // `<object>`
    summary: null,
    // `<table>`
    text: null,
    // `<body>`. Use CSS `color` instead
    topMargin: number,
    // `<body>`
    valueType: null,
    // `<param>`
    version: null,
    // `<html>`. Use a doctype.
    vAlign: null,
    // Several. Use CSS `vertical-align` instead
    vLink: null,
    // `<body>`. Use CSS `a:visited {color}` instead
    vSpace: number,
    // `<img>` and `<object>`
    // Non-standard Properties.
    allowTransparency: null,
    autoCorrect: null,
    autoSave: null,
    disablePictureInPicture: boolean,
    disableRemotePlayback: boolean,
    prefix: null,
    property: null,
    results: number,
    security: null,
    unselectable: null
  }
});
var svg = create({
  space: "svg",
  attributes: {
    accentHeight: "accent-height",
    alignmentBaseline: "alignment-baseline",
    arabicForm: "arabic-form",
    baselineShift: "baseline-shift",
    capHeight: "cap-height",
    className: "class",
    clipPath: "clip-path",
    clipRule: "clip-rule",
    colorInterpolation: "color-interpolation",
    colorInterpolationFilters: "color-interpolation-filters",
    colorProfile: "color-profile",
    colorRendering: "color-rendering",
    crossOrigin: "crossorigin",
    dataType: "datatype",
    dominantBaseline: "dominant-baseline",
    enableBackground: "enable-background",
    fillOpacity: "fill-opacity",
    fillRule: "fill-rule",
    floodColor: "flood-color",
    floodOpacity: "flood-opacity",
    fontFamily: "font-family",
    fontSize: "font-size",
    fontSizeAdjust: "font-size-adjust",
    fontStretch: "font-stretch",
    fontStyle: "font-style",
    fontVariant: "font-variant",
    fontWeight: "font-weight",
    glyphName: "glyph-name",
    glyphOrientationHorizontal: "glyph-orientation-horizontal",
    glyphOrientationVertical: "glyph-orientation-vertical",
    hrefLang: "hreflang",
    horizAdvX: "horiz-adv-x",
    horizOriginX: "horiz-origin-x",
    horizOriginY: "horiz-origin-y",
    imageRendering: "image-rendering",
    letterSpacing: "letter-spacing",
    lightingColor: "lighting-color",
    markerEnd: "marker-end",
    markerMid: "marker-mid",
    markerStart: "marker-start",
    navDown: "nav-down",
    navDownLeft: "nav-down-left",
    navDownRight: "nav-down-right",
    navLeft: "nav-left",
    navNext: "nav-next",
    navPrev: "nav-prev",
    navRight: "nav-right",
    navUp: "nav-up",
    navUpLeft: "nav-up-left",
    navUpRight: "nav-up-right",
    onAbort: "onabort",
    onActivate: "onactivate",
    onAfterPrint: "onafterprint",
    onBeforePrint: "onbeforeprint",
    onBegin: "onbegin",
    onCancel: "oncancel",
    onCanPlay: "oncanplay",
    onCanPlayThrough: "oncanplaythrough",
    onChange: "onchange",
    onClick: "onclick",
    onClose: "onclose",
    onCopy: "oncopy",
    onCueChange: "oncuechange",
    onCut: "oncut",
    onDblClick: "ondblclick",
    onDrag: "ondrag",
    onDragEnd: "ondragend",
    onDragEnter: "ondragenter",
    onDragExit: "ondragexit",
    onDragLeave: "ondragleave",
    onDragOver: "ondragover",
    onDragStart: "ondragstart",
    onDrop: "ondrop",
    onDurationChange: "ondurationchange",
    onEmptied: "onemptied",
    onEnd: "onend",
    onEnded: "onended",
    onError: "onerror",
    onFocus: "onfocus",
    onFocusIn: "onfocusin",
    onFocusOut: "onfocusout",
    onHashChange: "onhashchange",
    onInput: "oninput",
    onInvalid: "oninvalid",
    onKeyDown: "onkeydown",
    onKeyPress: "onkeypress",
    onKeyUp: "onkeyup",
    onLoad: "onload",
    onLoadedData: "onloadeddata",
    onLoadedMetadata: "onloadedmetadata",
    onLoadStart: "onloadstart",
    onMessage: "onmessage",
    onMouseDown: "onmousedown",
    onMouseEnter: "onmouseenter",
    onMouseLeave: "onmouseleave",
    onMouseMove: "onmousemove",
    onMouseOut: "onmouseout",
    onMouseOver: "onmouseover",
    onMouseUp: "onmouseup",
    onMouseWheel: "onmousewheel",
    onOffline: "onoffline",
    onOnline: "ononline",
    onPageHide: "onpagehide",
    onPageShow: "onpageshow",
    onPaste: "onpaste",
    onPause: "onpause",
    onPlay: "onplay",
    onPlaying: "onplaying",
    onPopState: "onpopstate",
    onProgress: "onprogress",
    onRateChange: "onratechange",
    onRepeat: "onrepeat",
    onReset: "onreset",
    onResize: "onresize",
    onScroll: "onscroll",
    onSeeked: "onseeked",
    onSeeking: "onseeking",
    onSelect: "onselect",
    onShow: "onshow",
    onStalled: "onstalled",
    onStorage: "onstorage",
    onSubmit: "onsubmit",
    onSuspend: "onsuspend",
    onTimeUpdate: "ontimeupdate",
    onToggle: "ontoggle",
    onUnload: "onunload",
    onVolumeChange: "onvolumechange",
    onWaiting: "onwaiting",
    onZoom: "onzoom",
    overlinePosition: "overline-position",
    overlineThickness: "overline-thickness",
    paintOrder: "paint-order",
    panose1: "panose-1",
    pointerEvents: "pointer-events",
    referrerPolicy: "referrerpolicy",
    renderingIntent: "rendering-intent",
    shapeRendering: "shape-rendering",
    stopColor: "stop-color",
    stopOpacity: "stop-opacity",
    strikethroughPosition: "strikethrough-position",
    strikethroughThickness: "strikethrough-thickness",
    strokeDashArray: "stroke-dasharray",
    strokeDashOffset: "stroke-dashoffset",
    strokeLineCap: "stroke-linecap",
    strokeLineJoin: "stroke-linejoin",
    strokeMiterLimit: "stroke-miterlimit",
    strokeOpacity: "stroke-opacity",
    strokeWidth: "stroke-width",
    tabIndex: "tabindex",
    textAnchor: "text-anchor",
    textDecoration: "text-decoration",
    textRendering: "text-rendering",
    transformOrigin: "transform-origin",
    typeOf: "typeof",
    underlinePosition: "underline-position",
    underlineThickness: "underline-thickness",
    unicodeBidi: "unicode-bidi",
    unicodeRange: "unicode-range",
    unitsPerEm: "units-per-em",
    vAlphabetic: "v-alphabetic",
    vHanging: "v-hanging",
    vIdeographic: "v-ideographic",
    vMathematical: "v-mathematical",
    vectorEffect: "vector-effect",
    vertAdvY: "vert-adv-y",
    vertOriginX: "vert-origin-x",
    vertOriginY: "vert-origin-y",
    wordSpacing: "word-spacing",
    writingMode: "writing-mode",
    xHeight: "x-height",
    // These were camelcased in Tiny. Now lowercased in SVG 2
    playbackOrder: "playbackorder",
    timelineBegin: "timelinebegin"
  },
  transform: caseSensitiveTransform,
  properties: {
    about: commaOrSpaceSeparated,
    accentHeight: number,
    accumulate: null,
    additive: null,
    alignmentBaseline: null,
    alphabetic: number,
    amplitude: number,
    arabicForm: null,
    ascent: number,
    attributeName: null,
    attributeType: null,
    azimuth: number,
    bandwidth: null,
    baselineShift: null,
    baseFrequency: null,
    baseProfile: null,
    bbox: null,
    begin: null,
    bias: number,
    by: null,
    calcMode: null,
    capHeight: number,
    className: spaceSeparated,
    clip: null,
    clipPath: null,
    clipPathUnits: null,
    clipRule: null,
    color: null,
    colorInterpolation: null,
    colorInterpolationFilters: null,
    colorProfile: null,
    colorRendering: null,
    content: null,
    contentScriptType: null,
    contentStyleType: null,
    crossOrigin: null,
    cursor: null,
    cx: null,
    cy: null,
    d: null,
    dataType: null,
    defaultAction: null,
    descent: number,
    diffuseConstant: number,
    direction: null,
    display: null,
    dur: null,
    divisor: number,
    dominantBaseline: null,
    download: boolean,
    dx: null,
    dy: null,
    edgeMode: null,
    editable: null,
    elevation: number,
    enableBackground: null,
    end: null,
    event: null,
    exponent: number,
    externalResourcesRequired: null,
    fill: null,
    fillOpacity: number,
    fillRule: null,
    filter: null,
    filterRes: null,
    filterUnits: null,
    floodColor: null,
    floodOpacity: null,
    focusable: null,
    focusHighlight: null,
    fontFamily: null,
    fontSize: null,
    fontSizeAdjust: null,
    fontStretch: null,
    fontStyle: null,
    fontVariant: null,
    fontWeight: null,
    format: null,
    fr: null,
    from: null,
    fx: null,
    fy: null,
    g1: commaSeparated,
    g2: commaSeparated,
    glyphName: commaSeparated,
    glyphOrientationHorizontal: null,
    glyphOrientationVertical: null,
    glyphRef: null,
    gradientTransform: null,
    gradientUnits: null,
    handler: null,
    hanging: number,
    hatchContentUnits: null,
    hatchUnits: null,
    height: null,
    href: null,
    hrefLang: null,
    horizAdvX: number,
    horizOriginX: number,
    horizOriginY: number,
    id: null,
    ideographic: number,
    imageRendering: null,
    initialVisibility: null,
    in: null,
    in2: null,
    intercept: number,
    k: number,
    k1: number,
    k2: number,
    k3: number,
    k4: number,
    kernelMatrix: commaOrSpaceSeparated,
    kernelUnitLength: null,
    keyPoints: null,
    // SEMI_COLON_SEPARATED
    keySplines: null,
    // SEMI_COLON_SEPARATED
    keyTimes: null,
    // SEMI_COLON_SEPARATED
    kerning: null,
    lang: null,
    lengthAdjust: null,
    letterSpacing: null,
    lightingColor: null,
    limitingConeAngle: number,
    local: null,
    markerEnd: null,
    markerMid: null,
    markerStart: null,
    markerHeight: null,
    markerUnits: null,
    markerWidth: null,
    mask: null,
    maskContentUnits: null,
    maskUnits: null,
    mathematical: null,
    max: null,
    media: null,
    mediaCharacterEncoding: null,
    mediaContentEncodings: null,
    mediaSize: number,
    mediaTime: null,
    method: null,
    min: null,
    mode: null,
    name: null,
    navDown: null,
    navDownLeft: null,
    navDownRight: null,
    navLeft: null,
    navNext: null,
    navPrev: null,
    navRight: null,
    navUp: null,
    navUpLeft: null,
    navUpRight: null,
    numOctaves: null,
    observer: null,
    offset: null,
    onAbort: null,
    onActivate: null,
    onAfterPrint: null,
    onBeforePrint: null,
    onBegin: null,
    onCancel: null,
    onCanPlay: null,
    onCanPlayThrough: null,
    onChange: null,
    onClick: null,
    onClose: null,
    onCopy: null,
    onCueChange: null,
    onCut: null,
    onDblClick: null,
    onDrag: null,
    onDragEnd: null,
    onDragEnter: null,
    onDragExit: null,
    onDragLeave: null,
    onDragOver: null,
    onDragStart: null,
    onDrop: null,
    onDurationChange: null,
    onEmptied: null,
    onEnd: null,
    onEnded: null,
    onError: null,
    onFocus: null,
    onFocusIn: null,
    onFocusOut: null,
    onHashChange: null,
    onInput: null,
    onInvalid: null,
    onKeyDown: null,
    onKeyPress: null,
    onKeyUp: null,
    onLoad: null,
    onLoadedData: null,
    onLoadedMetadata: null,
    onLoadStart: null,
    onMessage: null,
    onMouseDown: null,
    onMouseEnter: null,
    onMouseLeave: null,
    onMouseMove: null,
    onMouseOut: null,
    onMouseOver: null,
    onMouseUp: null,
    onMouseWheel: null,
    onOffline: null,
    onOnline: null,
    onPageHide: null,
    onPageShow: null,
    onPaste: null,
    onPause: null,
    onPlay: null,
    onPlaying: null,
    onPopState: null,
    onProgress: null,
    onRateChange: null,
    onRepeat: null,
    onReset: null,
    onResize: null,
    onScroll: null,
    onSeeked: null,
    onSeeking: null,
    onSelect: null,
    onShow: null,
    onStalled: null,
    onStorage: null,
    onSubmit: null,
    onSuspend: null,
    onTimeUpdate: null,
    onToggle: null,
    onUnload: null,
    onVolumeChange: null,
    onWaiting: null,
    onZoom: null,
    opacity: null,
    operator: null,
    order: null,
    orient: null,
    orientation: null,
    origin: null,
    overflow: null,
    overlay: null,
    overlinePosition: number,
    overlineThickness: number,
    paintOrder: null,
    panose1: null,
    path: null,
    pathLength: number,
    patternContentUnits: null,
    patternTransform: null,
    patternUnits: null,
    phase: null,
    ping: spaceSeparated,
    pitch: null,
    playbackOrder: null,
    pointerEvents: null,
    points: null,
    pointsAtX: number,
    pointsAtY: number,
    pointsAtZ: number,
    preserveAlpha: null,
    preserveAspectRatio: null,
    primitiveUnits: null,
    propagate: null,
    property: commaOrSpaceSeparated,
    r: null,
    radius: null,
    referrerPolicy: null,
    refX: null,
    refY: null,
    rel: commaOrSpaceSeparated,
    rev: commaOrSpaceSeparated,
    renderingIntent: null,
    repeatCount: null,
    repeatDur: null,
    requiredExtensions: commaOrSpaceSeparated,
    requiredFeatures: commaOrSpaceSeparated,
    requiredFonts: commaOrSpaceSeparated,
    requiredFormats: commaOrSpaceSeparated,
    resource: null,
    restart: null,
    result: null,
    rotate: null,
    rx: null,
    ry: null,
    scale: null,
    seed: null,
    shapeRendering: null,
    side: null,
    slope: null,
    snapshotTime: null,
    specularConstant: number,
    specularExponent: number,
    spreadMethod: null,
    spacing: null,
    startOffset: null,
    stdDeviation: null,
    stemh: null,
    stemv: null,
    stitchTiles: null,
    stopColor: null,
    stopOpacity: null,
    strikethroughPosition: number,
    strikethroughThickness: number,
    string: null,
    stroke: null,
    strokeDashArray: commaOrSpaceSeparated,
    strokeDashOffset: null,
    strokeLineCap: null,
    strokeLineJoin: null,
    strokeMiterLimit: number,
    strokeOpacity: number,
    strokeWidth: null,
    style: null,
    surfaceScale: number,
    syncBehavior: null,
    syncBehaviorDefault: null,
    syncMaster: null,
    syncTolerance: null,
    syncToleranceDefault: null,
    systemLanguage: commaOrSpaceSeparated,
    tabIndex: number,
    tableValues: null,
    target: null,
    targetX: number,
    targetY: number,
    textAnchor: null,
    textDecoration: null,
    textRendering: null,
    textLength: null,
    timelineBegin: null,
    title: null,
    transformBehavior: null,
    type: null,
    typeOf: commaOrSpaceSeparated,
    to: null,
    transform: null,
    transformOrigin: null,
    u1: null,
    u2: null,
    underlinePosition: number,
    underlineThickness: number,
    unicode: null,
    unicodeBidi: null,
    unicodeRange: null,
    unitsPerEm: number,
    values: null,
    vAlphabetic: number,
    vMathematical: number,
    vectorEffect: null,
    vHanging: number,
    vIdeographic: number,
    version: null,
    vertAdvY: number,
    vertOriginX: number,
    vertOriginY: number,
    viewBox: null,
    viewTarget: null,
    visibility: null,
    width: null,
    widths: null,
    wordSpacing: null,
    writingMode: null,
    x: null,
    x1: null,
    x2: null,
    xChannelSelector: null,
    xHeight: number,
    y: null,
    y1: null,
    y2: null,
    yChannelSelector: null,
    z: null,
    zoomAndPan: null
  }
});
var valid = /^data[-\w.:]+$/i;
var dash = /-[a-z]/g;
var cap = /[A-Z]/g;
function find(schema, value) {
  const normal = normalize(value);
  let prop = value;
  let Type = Info;
  if (normal in schema.normal) {
    return schema.property[schema.normal[normal]];
  }
  if (normal.length > 4 && normal.slice(0, 4) === "data" && valid.test(value)) {
    if (value.charAt(4) === "-") {
      const rest = value.slice(5).replace(dash, camelcase);
      prop = "data" + rest.charAt(0).toUpperCase() + rest.slice(1);
    } else {
      const rest = value.slice(4);
      if (!dash.test(rest)) {
        let dashes = rest.replace(cap, kebab);
        if (dashes.charAt(0) !== "-") {
          dashes = "-" + dashes;
        }
        value = "data" + dashes;
      }
    }
    Type = DefinedInfo;
  }
  return new Type(prop, value);
}
__name(find, "find");
function kebab($0) {
  return "-" + $0.toLowerCase();
}
__name(kebab, "kebab");
function camelcase($0) {
  return $0.charAt(1).toUpperCase();
}
__name(camelcase, "camelcase");
var hastToReact = {
  classId: "classID",
  dataType: "datatype",
  itemId: "itemID",
  strokeDashArray: "strokeDasharray",
  strokeDashOffset: "strokeDashoffset",
  strokeLineCap: "strokeLinecap",
  strokeLineJoin: "strokeLinejoin",
  strokeMiterLimit: "strokeMiterlimit",
  typeOf: "typeof",
  xLinkActuate: "xlinkActuate",
  xLinkArcRole: "xlinkArcrole",
  xLinkHref: "xlinkHref",
  xLinkRole: "xlinkRole",
  xLinkShow: "xlinkShow",
  xLinkTitle: "xlinkTitle",
  xLinkType: "xlinkType",
  xmlnsXLink: "xmlnsXlink"
};
var html2 = merge([xml, xlink, xmlns, aria, html], "html");
var svg2 = merge([xml, xlink, xmlns, aria, svg], "svg");
var pointEnd = point("end");
var pointStart = point("start");
function point(type) {
  return point2;
  function point2(node) {
    const point3 = node && node.position && node.position[type] || {};
    if (typeof point3.line === "number" && point3.line > 0 && typeof point3.column === "number" && point3.column > 0) {
      return {
        line: point3.line,
        column: point3.column,
        offset: typeof point3.offset === "number" && point3.offset > -1 ? point3.offset : void 0
      };
    }
  }
  __name(point2, "point2");
}
__name(point, "point");
function position(node) {
  const start2 = pointStart(node);
  const end = pointEnd(node);
  if (start2 && end) {
    return { start: start2, end };
  }
}
__name(position, "position");
var own2 = {}.hasOwnProperty;
function zwitch(key, options) {
  const settings = options || {};
  function one(value, ...parameters) {
    let fn = one.invalid;
    const handlers2 = one.handlers;
    if (value && own2.call(value, key)) {
      const id = String(value[key]);
      fn = own2.call(handlers2, id) ? handlers2[id] : one.unknown;
    }
    if (fn) {
      return fn.call(this, value, ...parameters);
    }
  }
  __name(one, "one");
  one.handlers = settings.handlers || {};
  one.invalid = settings.invalid;
  one.unknown = settings.unknown;
  return one;
}
__name(zwitch, "zwitch");
function comment(node, state) {
  const result = { type: "Block", value: node.value };
  state.inherit(node, result);
  state.comments.push(result);
  const expression = {
    type: "JSXEmptyExpression",
    // @ts-expect-error: `comments` is custom.
    comments: [Object.assign({}, result, { leading: false, trailing: true })]
  };
  state.patch(node, expression);
  const container = { type: "JSXExpressionContainer", expression };
  state.patch(node, container);
  return container;
}
__name(comment, "comment");
function stringify(values, options) {
  const settings = options || {};
  const input = values[values.length - 1] === "" ? [...values, ""] : values;
  return input.join(
    (settings.padRight ? " " : "") + "," + (settings.padLeft === false ? "" : " ")
  ).trim();
}
__name(stringify, "stringify");
var startRe = /[$_\p{ID_Start}]/u;
var contRe = /[$_\u{200C}\u{200D}\p{ID_Continue}]/u;
var contReJsx = /[-$_\u{200C}\u{200D}\p{ID_Continue}]/u;
var nameRe = /^[$_\p{ID_Start}][$_\u{200C}\u{200D}\p{ID_Continue}]*$/u;
var nameReJsx = /^[$_\p{ID_Start}][-$_\u{200C}\u{200D}\p{ID_Continue}]*$/u;
var emptyOptions = {};
function start(code) {
  return code ? startRe.test(String.fromCodePoint(code)) : false;
}
__name(start, "start");
function cont(code, options) {
  const settings = options || emptyOptions;
  const re2 = settings.jsx ? contReJsx : contRe;
  return code ? re2.test(String.fromCodePoint(code)) : false;
}
__name(cont, "cont");
function name(name2, options) {
  const settings = options || emptyOptions;
  const re2 = settings.jsx ? nameReJsx : nameRe;
  return re2.test(name2);
}
__name(name, "name");
function stringify2(values) {
  return values.join(" ").trim();
}
__name(stringify2, "stringify2");
var import_index = __toESM(require_style_to_object(), 1);
var style_to_object_default = import_index.default;
var own3 = {}.hasOwnProperty;
var cap2 = /[A-Z]/g;
var dashSomething = /-([a-z])/g;
var tableCellElement = /* @__PURE__ */ new Set(["td", "th"]);
function element(node, state) {
  const parentSchema = state.schema;
  let schema = parentSchema;
  const props = node.properties || {};
  if (parentSchema.space === "html" && node.tagName.toLowerCase() === "svg") {
    schema = svg2;
    state.schema = schema;
  }
  const children = state.all(node);
  const attributes = [];
  let prop;
  let alignValue;
  let styleProperties;
  for (prop in props) {
    if (own3.call(props, prop)) {
      let value = props[prop];
      const info = find(schema, prop);
      let attributeValue;
      if (value === null || value === void 0 || value === false || typeof value === "number" && Number.isNaN(value) || !value && info.boolean) {
        continue;
      }
      prop = state.elementAttributeNameCase === "react" && info.space ? hastToReact[info.property] || info.property : info.attribute;
      if (Array.isArray(value)) {
        value = info.commaSeparated ? stringify(value) : stringify2(value);
      }
      if (prop === "style") {
        let styleObject = typeof value === "object" ? value : parseStyle(String(value), node.tagName);
        if (state.stylePropertyNameCase === "css") {
          styleObject = transformStylesToCssCasing(styleObject);
        }
        const cssProperties = [];
        let cssProp;
        for (cssProp in styleObject) {
          if (own3.call(styleObject, cssProp)) {
            cssProperties.push({
              type: "Property",
              method: false,
              shorthand: false,
              computed: false,
              key: name(cssProp) ? { type: "Identifier", name: cssProp } : { type: "Literal", value: cssProp },
              value: { type: "Literal", value: String(styleObject[cssProp]) },
              kind: "init"
            });
          }
        }
        styleProperties = cssProperties;
        attributeValue = {
          type: "JSXExpressionContainer",
          expression: { type: "ObjectExpression", properties: cssProperties }
        };
      } else if (value === true) {
        attributeValue = null;
      } else if (state.tableCellAlignToStyle && tableCellElement.has(node.tagName) && prop === "align") {
        alignValue = String(value);
        continue;
      } else {
        attributeValue = { type: "Literal", value: String(value) };
      }
      if (name(prop, { jsx: true })) {
        attributes.push({
          type: "JSXAttribute",
          name: { type: "JSXIdentifier", name: prop },
          value: attributeValue
        });
      } else {
        attributes.push({
          type: "JSXSpreadAttribute",
          argument: {
            type: "ObjectExpression",
            properties: [
              {
                type: "Property",
                method: false,
                shorthand: false,
                computed: false,
                key: { type: "Literal", value: String(prop) },
                // @ts-expect-error No need to worry about `style` (which has a
                // `JSXExpressionContainer` value) because that’s a valid identifier.
                value: attributeValue || { type: "Literal", value: true },
                kind: "init"
              }
            ]
          }
        });
      }
    }
  }
  if (alignValue !== void 0) {
    if (!styleProperties) {
      styleProperties = [];
      attributes.push({
        type: "JSXAttribute",
        name: { type: "JSXIdentifier", name: "style" },
        value: {
          type: "JSXExpressionContainer",
          expression: { type: "ObjectExpression", properties: styleProperties }
        }
      });
    }
    const cssProp = state.stylePropertyNameCase === "css" ? transformStyleToCssCasing("textAlign") : "textAlign";
    styleProperties.push({
      type: "Property",
      method: false,
      shorthand: false,
      computed: false,
      key: name(cssProp) ? { type: "Identifier", name: cssProp } : { type: "Literal", value: cssProp },
      value: { type: "Literal", value: alignValue },
      kind: "init"
    });
  }
  state.schema = parentSchema;
  const result = {
    type: "JSXElement",
    openingElement: {
      type: "JSXOpeningElement",
      attributes,
      name: state.createJsxElementName(node.tagName),
      selfClosing: children.length === 0
    },
    closingElement: children.length > 0 ? {
      type: "JSXClosingElement",
      name: state.createJsxElementName(node.tagName)
    } : null,
    children
  };
  state.inherit(node, result);
  return result;
}
__name(element, "element");
function parseStyle(value, tagName) {
  const result = {};
  try {
    style_to_object_default(value, iterator);
  } catch (error) {
    const cause = (
      /** @type {Error} */
      error
    );
    const exception = new Error(
      "Could not parse `style` attribute on `" + tagName + "`",
      { cause }
    );
    throw exception;
  }
  return result;
  function iterator(name2, value2) {
    let key = name2;
    if (key.slice(0, 2) !== "--") {
      if (key.slice(0, 4) === "-ms-")
        key = "ms-" + key.slice(4);
      key = key.replace(dashSomething, toCamel);
    }
    result[key] = value2;
  }
  __name(iterator, "iterator");
}
__name(parseStyle, "parseStyle");
function transformStylesToCssCasing(domCasing) {
  const cssCasing = {};
  let from;
  for (from in domCasing) {
    if (own3.call(domCasing, from)) {
      cssCasing[transformStyleToCssCasing(from)] = domCasing[from];
    }
  }
  return cssCasing;
}
__name(transformStylesToCssCasing, "transformStylesToCssCasing");
function transformStyleToCssCasing(from) {
  let to = from.replace(cap2, toDash);
  if (to.slice(0, 3) === "ms-")
    to = "-" + to;
  return to;
}
__name(transformStyleToCssCasing, "transformStyleToCssCasing");
function toCamel(_, $1) {
  return $1.toUpperCase();
}
__name(toCamel, "toCamel");
function toDash($0) {
  return "-" + $0.toLowerCase();
}
__name(toDash, "toDash");
var own4 = {}.hasOwnProperty;
var emptyComments = [];
function attachComments(tree, comments) {
  const list = comments ? [...comments].sort(compare) : emptyComments;
  if (list.length > 0)
    walk(tree, { comments: list, index: 0 });
}
__name(attachComments, "attachComments");
function walk(node, state) {
  if (state.index === state.comments.length) {
    return;
  }
  const children = [];
  const comments = [];
  let key;
  for (key in node) {
    if (own4.call(node, key)) {
      const value = node[key];
      if (value && typeof value === "object" && key !== "comments") {
        if (Array.isArray(value)) {
          let index2 = -1;
          while (++index2 < value.length) {
            if (value[index2] && typeof value[index2].type === "string") {
              children.push(value[index2]);
            }
          }
        } else if (typeof value.type === "string") {
          children.push(value);
        }
      }
    }
  }
  children.sort(compare);
  comments.push(...slice(state, node, false, { leading: true, trailing: false }));
  let index = -1;
  while (++index < children.length) {
    walk(children[index], state);
  }
  comments.push(
    ...slice(state, node, true, {
      leading: false,
      trailing: children.length > 0
    })
  );
  if (comments.length > 0) {
    node.comments = comments;
  }
}
__name(walk, "walk");
function slice(state, node, compareEnd, fields) {
  const result = [];
  while (state.comments[state.index] && compare(state.comments[state.index], node, compareEnd) < 1) {
    result.push(Object.assign({}, state.comments[state.index++], fields));
  }
  return result;
}
__name(slice, "slice");
function compare(left, right, compareEnd) {
  const field = compareEnd ? "end" : "start";
  if (left.range && right.range) {
    return left.range[0] - right.range[compareEnd ? 1 : 0];
  }
  if (left.loc && left.loc.start && right.loc && right.loc[field]) {
    return left.loc.start.line - right.loc[field].line || left.loc.start.column - right.loc[field].column;
  }
  if ("start" in left && field in right) {
    return left.start - right[field];
  }
  return Number.NaN;
}
__name(compare, "compare");
function mdxExpression(node, state) {
  const estree = node.data && node.data.estree;
  const comments = estree && estree.comments || [];
  let expression;
  if (estree) {
    state.comments.push(...comments);
    attachComments(estree, estree.comments);
    expression = estree.body[0] && estree.body[0].type === "ExpressionStatement" && estree.body[0].expression || void 0;
  }
  if (!expression) {
    expression = { type: "JSXEmptyExpression" };
    state.patch(node, expression);
  }
  const result = { type: "JSXExpressionContainer", expression };
  state.inherit(node, result);
  return result;
}
__name(mdxExpression, "mdxExpression");
function mdxJsxElement(node, state) {
  const parentSchema = state.schema;
  let schema = parentSchema;
  const attrs = node.attributes || [];
  let index = -1;
  if (node.name && parentSchema.space === "html" && node.name.toLowerCase() === "svg") {
    schema = svg2;
    state.schema = schema;
  }
  const children = state.all(node);
  const attributes = [];
  while (++index < attrs.length) {
    const attr = attrs[index];
    const value = attr.value;
    let attributeValue;
    if (attr.type === "mdxJsxAttribute") {
      if (value === null || value === void 0) {
        attributeValue = null;
      } else if (typeof value === "object") {
        const estree = value.data && value.data.estree;
        const comments = estree && estree.comments || [];
        let expression;
        if (estree) {
          state.comments.push(...comments);
          attachComments(estree, estree.comments);
          expression = estree.body[0] && estree.body[0].type === "ExpressionStatement" && estree.body[0].expression || void 0;
        }
        attributeValue = {
          type: "JSXExpressionContainer",
          expression: expression || { type: "JSXEmptyExpression" }
        };
        state.inherit(value, attributeValue);
      } else {
        attributeValue = { type: "Literal", value: String(value) };
      }
      const attribute = {
        type: "JSXAttribute",
        name: state.createJsxAttributeName(attr.name),
        value: attributeValue
      };
      state.inherit(attr, attribute);
      attributes.push(attribute);
    } else {
      const estree = attr.data && attr.data.estree;
      const comments = estree && estree.comments || [];
      let argumentValue;
      if (estree) {
        state.comments.push(...comments);
        attachComments(estree, estree.comments);
        argumentValue = estree.body[0] && estree.body[0].type === "ExpressionStatement" && estree.body[0].expression && estree.body[0].expression.type === "ObjectExpression" && estree.body[0].expression.properties && estree.body[0].expression.properties[0] && estree.body[0].expression.properties[0].type === "SpreadElement" && estree.body[0].expression.properties[0].argument || void 0;
      }
      const attribute = {
        type: "JSXSpreadAttribute",
        argument: argumentValue || { type: "ObjectExpression", properties: [] }
      };
      state.inherit(attr, attribute);
      attributes.push(attribute);
    }
  }
  state.schema = parentSchema;
  const result = node.name ? {
    type: "JSXElement",
    openingElement: {
      type: "JSXOpeningElement",
      attributes,
      name: state.createJsxElementName(node.name),
      selfClosing: children.length === 0
    },
    closingElement: children.length > 0 ? {
      type: "JSXClosingElement",
      name: state.createJsxElementName(node.name)
    } : null,
    children
  } : {
    type: "JSXFragment",
    openingFragment: { type: "JSXOpeningFragment" },
    closingFragment: { type: "JSXClosingFragment" },
    children
  };
  state.inherit(node, result);
  return result;
}
__name(mdxJsxElement, "mdxJsxElement");
function mdxjsEsm(node, state) {
  const estree = node.data && node.data.estree;
  const comments = estree && estree.comments || [];
  if (estree) {
    state.comments.push(...comments);
    attachComments(estree, comments);
    state.esm.push(...estree.body);
  }
}
__name(mdxjsEsm, "mdxjsEsm");
var re = /[ \t\n\f\r]/g;
function whitespace(thing) {
  return typeof thing === "object" ? thing.type === "text" ? empty(thing.value) : false : empty(thing);
}
__name(whitespace, "whitespace");
function empty(value) {
  return value.replace(re, "") === "";
}
__name(empty, "empty");
function root(node, state) {
  const children = state.all(node);
  const cleanChildren = [];
  let index = -1;
  let queue;
  while (++index < children.length) {
    const child = children[index];
    if (child.type === "JSXExpressionContainer" && child.expression.type === "Literal" && whitespace(String(child.expression.value))) {
      if (queue)
        queue.push(child);
    } else {
      if (queue)
        cleanChildren.push(...queue);
      cleanChildren.push(child);
      queue = [];
    }
  }
  const result = {
    type: "JSXFragment",
    openingFragment: { type: "JSXOpeningFragment" },
    closingFragment: { type: "JSXClosingFragment" },
    children: cleanChildren
  };
  state.inherit(node, result);
  return result;
}
__name(root, "root");
function text(node, state) {
  const value = String(node.value || "");
  if (value) {
    const result = { type: "Literal", value };
    state.inherit(node, result);
    const container = { type: "JSXExpressionContainer", expression: result };
    state.patch(node, container);
    return container;
  }
}
__name(text, "text");
var handlers = {
  comment,
  doctype: ignore,
  element,
  mdxFlowExpression: mdxExpression,
  mdxJsxFlowElement: mdxJsxElement,
  mdxJsxTextElement: mdxJsxElement,
  mdxTextExpression: mdxExpression,
  mdxjsEsm,
  root,
  text
};
function ignore() {
}
__name(ignore, "ignore");
var own5 = {}.hasOwnProperty;
var tableElements = /* @__PURE__ */ new Set(["table", "tbody", "thead", "tfoot", "tr"]);
function createState(options) {
  const one = zwitch("type", {
    invalid,
    unknown,
    handlers: { ...handlers, ...options.handlers }
  });
  return {
    // Current space.
    elementAttributeNameCase: options.elementAttributeNameCase || "react",
    schema: options.space === "svg" ? svg2 : html2,
    stylePropertyNameCase: options.stylePropertyNameCase || "dom",
    tableCellAlignToStyle: options.tableCellAlignToStyle !== false,
    // Results.
    comments: [],
    esm: [],
    // Useful functions.
    all,
    createJsxAttributeName,
    createJsxElementName,
    handle,
    inherit,
    patch
  };
  function handle(node) {
    return one(node, this);
  }
  __name(handle, "handle");
}
__name(createState, "createState");
function invalid(value) {
  throw new Error("Cannot handle value `" + value + "`, expected node");
}
__name(invalid, "invalid");
function unknown(node) {
  ok(node && typeof node === "object");
  ok("type" in node);
  throw new Error("Cannot handle unknown node `" + node.type + "`");
}
__name(unknown, "unknown");
function all(parent) {
  const children = parent.children || [];
  let index = -1;
  const results = [];
  const ignoreLineBreak = this.schema.space === "html" && parent.type === "element" && tableElements.has(parent.tagName.toLowerCase());
  while (++index < children.length) {
    const child = children[index];
    if (ignoreLineBreak && child.type === "text" && child.value === "\n") {
      continue;
    }
    const result = this.handle(child);
    if (Array.isArray(result)) {
      results.push(...result);
    } else if (result) {
      results.push(result);
    }
  }
  return results;
}
__name(all, "all");
function inherit(from, to) {
  const left = (
    /** @type {Record<string, unknown> | undefined} */
    from.data
  );
  let right;
  let key;
  patch(from, to);
  if (left) {
    for (key in left) {
      if (own5.call(left, key) && key !== "estree") {
        if (!right)
          right = {};
        right[key] = left[key];
      }
    }
    if (right) {
      to.data = right;
    }
  }
}
__name(inherit, "inherit");
function patch(from, to) {
  const p = position(from);
  if (p && p.start.offset !== void 0 && p.end.offset !== void 0) {
    to.start = p.start.offset;
    to.end = p.end.offset;
    to.loc = {
      start: { line: p.start.line, column: p.start.column - 1 },
      end: { line: p.end.line, column: p.end.column - 1 }
    };
    to.range = [p.start.offset, p.end.offset];
  }
}
__name(patch, "patch");
function createJsxAttributeName(name2) {
  const node = createJsxNameFromString(name2);
  if (node.type === "JSXMemberExpression") {
    throw new Error("Member expressions in attribute names are not supported");
  }
  return node;
}
__name(createJsxAttributeName, "createJsxAttributeName");
function createJsxElementName(name2) {
  return createJsxNameFromString(name2);
}
__name(createJsxElementName, "createJsxElementName");
function createJsxNameFromString(name2) {
  if (name2.includes(".")) {
    const names = name2.split(".");
    let part = names.shift();
    ok(part, "Expected `part` to be defined");
    let node = { type: "JSXIdentifier", name: part };
    while (part = names.shift()) {
      node = {
        type: "JSXMemberExpression",
        object: node,
        property: { type: "JSXIdentifier", name: part }
      };
    }
    return node;
  }
  if (name2.includes(":")) {
    const parts = name2.split(":");
    return {
      type: "JSXNamespacedName",
      namespace: { type: "JSXIdentifier", name: parts[0] },
      name: { type: "JSXIdentifier", name: parts[1] }
    };
  }
  return { type: "JSXIdentifier", name: name2 };
}
__name(createJsxNameFromString, "createJsxNameFromString");
function toEstree(tree, options) {
  const state = createState(options || {});
  let result = state.handle(tree);
  const body = state.esm;
  if (result) {
    if (result.type !== "JSXFragment" && result.type !== "JSXElement") {
      result = {
        type: "JSXFragment",
        openingFragment: { type: "JSXOpeningFragment" },
        closingFragment: { type: "JSXClosingFragment" },
        children: [result]
      };
      state.patch(tree, result);
    }
    const statement = { type: "ExpressionStatement", expression: result };
    state.patch(tree, statement);
    body.push(statement);
  }
  const program = {
    type: "Program",
    body,
    sourceType: "module",
    comments: state.comments
  };
  state.patch(tree, program);
  return program;
}
__name(toEstree, "toEstree");

export {
  __require2 as __require,
  __commonJS,
  __export,
  __toESM,
  ok,
  unreachable,
  pointEnd,
  pointStart,
  position,
  start,
  cont,
  name,
  toEstree
};
