import CJS_COMPAT_NODE_URL_39zvq8kkt8 from 'node:url';
import CJS_COMPAT_NODE_PATH_39zvq8kkt8 from 'node:path';
import CJS_COMPAT_NODE_MODULE_39zvq8kkt8 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_39zvq8kkt8.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_39zvq8kkt8.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_39zvq8kkt8.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "./chunk-JBW3FROT.js";

// src/telemetry/event-cache.ts
import { cache } from "storybook/internal/common";
var operation = Promise.resolve();
var setHelper = /* @__PURE__ */ __name(async (eventType, body) => {
  const lastEvents = await cache.get("lastEvents") || {};
  lastEvents[eventType] = { body, timestamp: Date.now() };
  await cache.set("lastEvents", lastEvents);
}, "setHelper");
var set = /* @__PURE__ */ __name(async (eventType, body) => {
  await operation;
  operation = setHelper(eventType, body);
  return operation;
}, "set");
var getLastEvents = /* @__PURE__ */ __name(async () => {
  return await cache.get("lastEvents") || {};
}, "getLastEvents");
var upgradeFields = /* @__PURE__ */ __name((event) => {
  const { body, timestamp } = event;
  return {
    timestamp,
    eventType: body?.eventType,
    eventId: body?.eventId,
    sessionId: body?.sessionId
  };
}, "upgradeFields");
var UPGRADE_EVENTS = ["init", "upgrade"];
var RUN_EVENTS = ["build", "dev", "error"];
var lastEvent = /* @__PURE__ */ __name((lastEvents, eventTypes) => {
  const descendingEvents = eventTypes.map((eventType) => lastEvents?.[eventType]).filter(Boolean).sort((a, b) => b.timestamp - a.timestamp);
  return descendingEvents.length > 0 ? descendingEvents[0] : void 0;
}, "lastEvent");
var getPrecedingUpgrade = /* @__PURE__ */ __name(async (events = void 0) => {
  const lastEvents = events || await cache.get("lastEvents") || {};
  const lastUpgradeEvent = lastEvent(lastEvents, UPGRADE_EVENTS);
  const lastRunEvent = lastEvent(lastEvents, RUN_EVENTS);
  if (!lastUpgradeEvent) {
    return void 0;
  }
  return !lastRunEvent?.timestamp || lastUpgradeEvent.timestamp > lastRunEvent.timestamp ? upgradeFields(lastUpgradeEvent) : void 0;
}, "getPrecedingUpgrade");

// ../node_modules/nanoid/index.js
import { randomFillSync } from "crypto";

// ../node_modules/nanoid/url-alphabet/index.js
var urlAlphabet = "useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict";

// ../node_modules/nanoid/index.js
var POOL_SIZE_MULTIPLIER = 128;
var pool;
var poolOffset;
var fillPool = /* @__PURE__ */ __name((bytes) => {
  if (!pool || pool.length < bytes) {
    pool = Buffer.allocUnsafe(bytes * POOL_SIZE_MULTIPLIER);
    randomFillSync(pool);
    poolOffset = 0;
  } else if (poolOffset + bytes > pool.length) {
    randomFillSync(pool);
    poolOffset = 0;
  }
  poolOffset += bytes;
}, "fillPool");
var nanoid = /* @__PURE__ */ __name((size = 21) => {
  fillPool(size -= 0);
  let id = "";
  for (let i = poolOffset - size; i < poolOffset; i++) {
    id += urlAlphabet[pool[i] & 63];
  }
  return id;
}, "nanoid");

// src/telemetry/session-id.ts
import { cache as cache2 } from "storybook/internal/common";
var SESSION_TIMEOUT = 1e3 * 60 * 60 * 2;
var sessionId;
var getSessionId = /* @__PURE__ */ __name(async () => {
  const now = Date.now();
  if (!sessionId) {
    const session = await cache2.get("session");
    if (session && session.lastUsed >= now - SESSION_TIMEOUT) {
      sessionId = session.id;
    } else {
      sessionId = nanoid();
    }
  }
  await cache2.set("session", { id: sessionId, lastUsed: now });
  return sessionId;
}, "getSessionId");

export {
  nanoid,
  set,
  getLastEvents,
  getPrecedingUpgrade,
  getSessionId
};
