import {
  getControlId
} from "./chunk-U46RQHA4.js";
import "./chunk-AB7OOPUX.js";
import {
  __commonJS,
  __name,
  __toESM
} from "./chunk-MM7DTO55.js";

// ../node_modules/color-name/index.js
var require_color_name = __commonJS({
  "../node_modules/color-name/index.js"(exports, module) {
    "use strict";
    module.exports = {
      "aliceblue": [240, 248, 255],
      "antiquewhite": [250, 235, 215],
      "aqua": [0, 255, 255],
      "aquamarine": [127, 255, 212],
      "azure": [240, 255, 255],
      "beige": [245, 245, 220],
      "bisque": [255, 228, 196],
      "black": [0, 0, 0],
      "blanchedalmond": [255, 235, 205],
      "blue": [0, 0, 255],
      "blueviolet": [138, 43, 226],
      "brown": [165, 42, 42],
      "burlywood": [222, 184, 135],
      "cadetblue": [95, 158, 160],
      "chartreuse": [127, 255, 0],
      "chocolate": [210, 105, 30],
      "coral": [255, 127, 80],
      "cornflowerblue": [100, 149, 237],
      "cornsilk": [255, 248, 220],
      "crimson": [220, 20, 60],
      "cyan": [0, 255, 255],
      "darkblue": [0, 0, 139],
      "darkcyan": [0, 139, 139],
      "darkgoldenrod": [184, 134, 11],
      "darkgray": [169, 169, 169],
      "darkgreen": [0, 100, 0],
      "darkgrey": [169, 169, 169],
      "darkkhaki": [189, 183, 107],
      "darkmagenta": [139, 0, 139],
      "darkolivegreen": [85, 107, 47],
      "darkorange": [255, 140, 0],
      "darkorchid": [153, 50, 204],
      "darkred": [139, 0, 0],
      "darksalmon": [233, 150, 122],
      "darkseagreen": [143, 188, 143],
      "darkslateblue": [72, 61, 139],
      "darkslategray": [47, 79, 79],
      "darkslategrey": [47, 79, 79],
      "darkturquoise": [0, 206, 209],
      "darkviolet": [148, 0, 211],
      "deeppink": [255, 20, 147],
      "deepskyblue": [0, 191, 255],
      "dimgray": [105, 105, 105],
      "dimgrey": [105, 105, 105],
      "dodgerblue": [30, 144, 255],
      "firebrick": [178, 34, 34],
      "floralwhite": [255, 250, 240],
      "forestgreen": [34, 139, 34],
      "fuchsia": [255, 0, 255],
      "gainsboro": [220, 220, 220],
      "ghostwhite": [248, 248, 255],
      "gold": [255, 215, 0],
      "goldenrod": [218, 165, 32],
      "gray": [128, 128, 128],
      "green": [0, 128, 0],
      "greenyellow": [173, 255, 47],
      "grey": [128, 128, 128],
      "honeydew": [240, 255, 240],
      "hotpink": [255, 105, 180],
      "indianred": [205, 92, 92],
      "indigo": [75, 0, 130],
      "ivory": [255, 255, 240],
      "khaki": [240, 230, 140],
      "lavender": [230, 230, 250],
      "lavenderblush": [255, 240, 245],
      "lawngreen": [124, 252, 0],
      "lemonchiffon": [255, 250, 205],
      "lightblue": [173, 216, 230],
      "lightcoral": [240, 128, 128],
      "lightcyan": [224, 255, 255],
      "lightgoldenrodyellow": [250, 250, 210],
      "lightgray": [211, 211, 211],
      "lightgreen": [144, 238, 144],
      "lightgrey": [211, 211, 211],
      "lightpink": [255, 182, 193],
      "lightsalmon": [255, 160, 122],
      "lightseagreen": [32, 178, 170],
      "lightskyblue": [135, 206, 250],
      "lightslategray": [119, 136, 153],
      "lightslategrey": [119, 136, 153],
      "lightsteelblue": [176, 196, 222],
      "lightyellow": [255, 255, 224],
      "lime": [0, 255, 0],
      "limegreen": [50, 205, 50],
      "linen": [250, 240, 230],
      "magenta": [255, 0, 255],
      "maroon": [128, 0, 0],
      "mediumaquamarine": [102, 205, 170],
      "mediumblue": [0, 0, 205],
      "mediumorchid": [186, 85, 211],
      "mediumpurple": [147, 112, 219],
      "mediumseagreen": [60, 179, 113],
      "mediumslateblue": [123, 104, 238],
      "mediumspringgreen": [0, 250, 154],
      "mediumturquoise": [72, 209, 204],
      "mediumvioletred": [199, 21, 133],
      "midnightblue": [25, 25, 112],
      "mintcream": [245, 255, 250],
      "mistyrose": [255, 228, 225],
      "moccasin": [255, 228, 181],
      "navajowhite": [255, 222, 173],
      "navy": [0, 0, 128],
      "oldlace": [253, 245, 230],
      "olive": [128, 128, 0],
      "olivedrab": [107, 142, 35],
      "orange": [255, 165, 0],
      "orangered": [255, 69, 0],
      "orchid": [218, 112, 214],
      "palegoldenrod": [238, 232, 170],
      "palegreen": [152, 251, 152],
      "paleturquoise": [175, 238, 238],
      "palevioletred": [219, 112, 147],
      "papayawhip": [255, 239, 213],
      "peachpuff": [255, 218, 185],
      "peru": [205, 133, 63],
      "pink": [255, 192, 203],
      "plum": [221, 160, 221],
      "powderblue": [176, 224, 230],
      "purple": [128, 0, 128],
      "rebeccapurple": [102, 51, 153],
      "red": [255, 0, 0],
      "rosybrown": [188, 143, 143],
      "royalblue": [65, 105, 225],
      "saddlebrown": [139, 69, 19],
      "salmon": [250, 128, 114],
      "sandybrown": [244, 164, 96],
      "seagreen": [46, 139, 87],
      "seashell": [255, 245, 238],
      "sienna": [160, 82, 45],
      "silver": [192, 192, 192],
      "skyblue": [135, 206, 235],
      "slateblue": [106, 90, 205],
      "slategray": [112, 128, 144],
      "slategrey": [112, 128, 144],
      "snow": [255, 250, 250],
      "springgreen": [0, 255, 127],
      "steelblue": [70, 130, 180],
      "tan": [210, 180, 140],
      "teal": [0, 128, 128],
      "thistle": [216, 191, 216],
      "tomato": [255, 99, 71],
      "turquoise": [64, 224, 208],
      "violet": [238, 130, 238],
      "wheat": [245, 222, 179],
      "white": [255, 255, 255],
      "whitesmoke": [245, 245, 245],
      "yellow": [255, 255, 0],
      "yellowgreen": [154, 205, 50]
    };
  }
});

// ../node_modules/color-convert/conversions.js
var require_conversions = __commonJS({
  "../node_modules/color-convert/conversions.js"(exports, module) {
    var cssKeywords = require_color_name();
    var reverseKeywords = {};
    for (const key of Object.keys(cssKeywords)) {
      reverseKeywords[cssKeywords[key]] = key;
    }
    var convert2 = {
      rgb: { channels: 3, labels: "rgb" },
      hsl: { channels: 3, labels: "hsl" },
      hsv: { channels: 3, labels: "hsv" },
      hwb: { channels: 3, labels: "hwb" },
      cmyk: { channels: 4, labels: "cmyk" },
      xyz: { channels: 3, labels: "xyz" },
      lab: { channels: 3, labels: "lab" },
      lch: { channels: 3, labels: "lch" },
      hex: { channels: 1, labels: ["hex"] },
      keyword: { channels: 1, labels: ["keyword"] },
      ansi16: { channels: 1, labels: ["ansi16"] },
      ansi256: { channels: 1, labels: ["ansi256"] },
      hcg: { channels: 3, labels: ["h", "c", "g"] },
      apple: { channels: 3, labels: ["r16", "g16", "b16"] },
      gray: { channels: 1, labels: ["gray"] }
    };
    module.exports = convert2;
    for (const model of Object.keys(convert2)) {
      if (!("channels" in convert2[model])) {
        throw new Error("missing channels property: " + model);
      }
      if (!("labels" in convert2[model])) {
        throw new Error("missing channel labels property: " + model);
      }
      if (convert2[model].labels.length !== convert2[model].channels) {
        throw new Error("channel and label counts mismatch: " + model);
      }
      const { channels, labels } = convert2[model];
      delete convert2[model].channels;
      delete convert2[model].labels;
      Object.defineProperty(convert2[model], "channels", { value: channels });
      Object.defineProperty(convert2[model], "labels", { value: labels });
    }
    convert2.rgb.hsl = function(rgb) {
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const min = Math.min(r2, g2, b2);
      const max = Math.max(r2, g2, b2);
      const delta = max - min;
      let h2;
      let s2;
      if (max === min) {
        h2 = 0;
      } else if (r2 === max) {
        h2 = (g2 - b2) / delta;
      } else if (g2 === max) {
        h2 = 2 + (b2 - r2) / delta;
      } else if (b2 === max) {
        h2 = 4 + (r2 - g2) / delta;
      }
      h2 = Math.min(h2 * 60, 360);
      if (h2 < 0) {
        h2 += 360;
      }
      const l2 = (min + max) / 2;
      if (max === min) {
        s2 = 0;
      } else if (l2 <= 0.5) {
        s2 = delta / (max + min);
      } else {
        s2 = delta / (2 - max - min);
      }
      return [h2, s2 * 100, l2 * 100];
    };
    convert2.rgb.hsv = function(rgb) {
      let rdif;
      let gdif;
      let bdif;
      let h2;
      let s2;
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const v2 = Math.max(r2, g2, b2);
      const diff = v2 - Math.min(r2, g2, b2);
      const diffc = /* @__PURE__ */ __name(function(c2) {
        return (v2 - c2) / 6 / diff + 1 / 2;
      }, "diffc");
      if (diff === 0) {
        h2 = 0;
        s2 = 0;
      } else {
        s2 = diff / v2;
        rdif = diffc(r2);
        gdif = diffc(g2);
        bdif = diffc(b2);
        if (r2 === v2) {
          h2 = bdif - gdif;
        } else if (g2 === v2) {
          h2 = 1 / 3 + rdif - bdif;
        } else if (b2 === v2) {
          h2 = 2 / 3 + gdif - rdif;
        }
        if (h2 < 0) {
          h2 += 1;
        } else if (h2 > 1) {
          h2 -= 1;
        }
      }
      return [
        h2 * 360,
        s2 * 100,
        v2 * 100
      ];
    };
    convert2.rgb.hwb = function(rgb) {
      const r2 = rgb[0];
      const g2 = rgb[1];
      let b2 = rgb[2];
      const h2 = convert2.rgb.hsl(rgb)[0];
      const w2 = 1 / 255 * Math.min(r2, Math.min(g2, b2));
      b2 = 1 - 1 / 255 * Math.max(r2, Math.max(g2, b2));
      return [h2, w2 * 100, b2 * 100];
    };
    convert2.rgb.cmyk = function(rgb) {
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const k2 = Math.min(1 - r2, 1 - g2, 1 - b2);
      const c2 = (1 - r2 - k2) / (1 - k2) || 0;
      const m2 = (1 - g2 - k2) / (1 - k2) || 0;
      const y2 = (1 - b2 - k2) / (1 - k2) || 0;
      return [c2 * 100, m2 * 100, y2 * 100, k2 * 100];
    };
    function comparativeDistance(x2, y2) {
      return (x2[0] - y2[0]) ** 2 + (x2[1] - y2[1]) ** 2 + (x2[2] - y2[2]) ** 2;
    }
    __name(comparativeDistance, "comparativeDistance");
    convert2.rgb.keyword = function(rgb) {
      const reversed = reverseKeywords[rgb];
      if (reversed) {
        return reversed;
      }
      let currentClosestDistance = Infinity;
      let currentClosestKeyword;
      for (const keyword of Object.keys(cssKeywords)) {
        const value = cssKeywords[keyword];
        const distance = comparativeDistance(rgb, value);
        if (distance < currentClosestDistance) {
          currentClosestDistance = distance;
          currentClosestKeyword = keyword;
        }
      }
      return currentClosestKeyword;
    };
    convert2.keyword.rgb = function(keyword) {
      return cssKeywords[keyword];
    };
    convert2.rgb.xyz = function(rgb) {
      let r2 = rgb[0] / 255;
      let g2 = rgb[1] / 255;
      let b2 = rgb[2] / 255;
      r2 = r2 > 0.04045 ? ((r2 + 0.055) / 1.055) ** 2.4 : r2 / 12.92;
      g2 = g2 > 0.04045 ? ((g2 + 0.055) / 1.055) ** 2.4 : g2 / 12.92;
      b2 = b2 > 0.04045 ? ((b2 + 0.055) / 1.055) ** 2.4 : b2 / 12.92;
      const x2 = r2 * 0.4124 + g2 * 0.3576 + b2 * 0.1805;
      const y2 = r2 * 0.2126 + g2 * 0.7152 + b2 * 0.0722;
      const z2 = r2 * 0.0193 + g2 * 0.1192 + b2 * 0.9505;
      return [x2 * 100, y2 * 100, z2 * 100];
    };
    convert2.rgb.lab = function(rgb) {
      const xyz = convert2.rgb.xyz(rgb);
      let x2 = xyz[0];
      let y2 = xyz[1];
      let z2 = xyz[2];
      x2 /= 95.047;
      y2 /= 100;
      z2 /= 108.883;
      x2 = x2 > 8856e-6 ? x2 ** (1 / 3) : 7.787 * x2 + 16 / 116;
      y2 = y2 > 8856e-6 ? y2 ** (1 / 3) : 7.787 * y2 + 16 / 116;
      z2 = z2 > 8856e-6 ? z2 ** (1 / 3) : 7.787 * z2 + 16 / 116;
      const l2 = 116 * y2 - 16;
      const a2 = 500 * (x2 - y2);
      const b2 = 200 * (y2 - z2);
      return [l2, a2, b2];
    };
    convert2.hsl.rgb = function(hsl) {
      const h2 = hsl[0] / 360;
      const s2 = hsl[1] / 100;
      const l2 = hsl[2] / 100;
      let t2;
      let t3;
      let val;
      if (s2 === 0) {
        val = l2 * 255;
        return [val, val, val];
      }
      if (l2 < 0.5) {
        t2 = l2 * (1 + s2);
      } else {
        t2 = l2 + s2 - l2 * s2;
      }
      const t1 = 2 * l2 - t2;
      const rgb = [0, 0, 0];
      for (let i2 = 0; i2 < 3; i2++) {
        t3 = h2 + 1 / 3 * -(i2 - 1);
        if (t3 < 0) {
          t3++;
        }
        if (t3 > 1) {
          t3--;
        }
        if (6 * t3 < 1) {
          val = t1 + (t2 - t1) * 6 * t3;
        } else if (2 * t3 < 1) {
          val = t2;
        } else if (3 * t3 < 2) {
          val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
        } else {
          val = t1;
        }
        rgb[i2] = val * 255;
      }
      return rgb;
    };
    convert2.hsl.hsv = function(hsl) {
      const h2 = hsl[0];
      let s2 = hsl[1] / 100;
      let l2 = hsl[2] / 100;
      let smin = s2;
      const lmin = Math.max(l2, 0.01);
      l2 *= 2;
      s2 *= l2 <= 1 ? l2 : 2 - l2;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      const v2 = (l2 + s2) / 2;
      const sv = l2 === 0 ? 2 * smin / (lmin + smin) : 2 * s2 / (l2 + s2);
      return [h2, sv * 100, v2 * 100];
    };
    convert2.hsv.rgb = function(hsv) {
      const h2 = hsv[0] / 60;
      const s2 = hsv[1] / 100;
      let v2 = hsv[2] / 100;
      const hi = Math.floor(h2) % 6;
      const f2 = h2 - Math.floor(h2);
      const p2 = 255 * v2 * (1 - s2);
      const q2 = 255 * v2 * (1 - s2 * f2);
      const t2 = 255 * v2 * (1 - s2 * (1 - f2));
      v2 *= 255;
      switch (hi) {
        case 0:
          return [v2, t2, p2];
        case 1:
          return [q2, v2, p2];
        case 2:
          return [p2, v2, t2];
        case 3:
          return [p2, q2, v2];
        case 4:
          return [t2, p2, v2];
        case 5:
          return [v2, p2, q2];
      }
    };
    convert2.hsv.hsl = function(hsv) {
      const h2 = hsv[0];
      const s2 = hsv[1] / 100;
      const v2 = hsv[2] / 100;
      const vmin = Math.max(v2, 0.01);
      let sl;
      let l2;
      l2 = (2 - s2) * v2;
      const lmin = (2 - s2) * vmin;
      sl = s2 * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l2 /= 2;
      return [h2, sl * 100, l2 * 100];
    };
    convert2.hwb.rgb = function(hwb) {
      const h2 = hwb[0] / 360;
      let wh = hwb[1] / 100;
      let bl = hwb[2] / 100;
      const ratio = wh + bl;
      let f2;
      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }
      const i2 = Math.floor(6 * h2);
      const v2 = 1 - bl;
      f2 = 6 * h2 - i2;
      if ((i2 & 1) !== 0) {
        f2 = 1 - f2;
      }
      const n2 = wh + f2 * (v2 - wh);
      let r2;
      let g2;
      let b2;
      switch (i2) {
        default:
        case 6:
        case 0:
          r2 = v2;
          g2 = n2;
          b2 = wh;
          break;
        case 1:
          r2 = n2;
          g2 = v2;
          b2 = wh;
          break;
        case 2:
          r2 = wh;
          g2 = v2;
          b2 = n2;
          break;
        case 3:
          r2 = wh;
          g2 = n2;
          b2 = v2;
          break;
        case 4:
          r2 = n2;
          g2 = wh;
          b2 = v2;
          break;
        case 5:
          r2 = v2;
          g2 = wh;
          b2 = n2;
          break;
      }
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert2.cmyk.rgb = function(cmyk) {
      const c2 = cmyk[0] / 100;
      const m2 = cmyk[1] / 100;
      const y2 = cmyk[2] / 100;
      const k2 = cmyk[3] / 100;
      const r2 = 1 - Math.min(1, c2 * (1 - k2) + k2);
      const g2 = 1 - Math.min(1, m2 * (1 - k2) + k2);
      const b2 = 1 - Math.min(1, y2 * (1 - k2) + k2);
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert2.xyz.rgb = function(xyz) {
      const x2 = xyz[0] / 100;
      const y2 = xyz[1] / 100;
      const z2 = xyz[2] / 100;
      let r2;
      let g2;
      let b2;
      r2 = x2 * 3.2406 + y2 * -1.5372 + z2 * -0.4986;
      g2 = x2 * -0.9689 + y2 * 1.8758 + z2 * 0.0415;
      b2 = x2 * 0.0557 + y2 * -0.204 + z2 * 1.057;
      r2 = r2 > 31308e-7 ? 1.055 * r2 ** (1 / 2.4) - 0.055 : r2 * 12.92;
      g2 = g2 > 31308e-7 ? 1.055 * g2 ** (1 / 2.4) - 0.055 : g2 * 12.92;
      b2 = b2 > 31308e-7 ? 1.055 * b2 ** (1 / 2.4) - 0.055 : b2 * 12.92;
      r2 = Math.min(Math.max(0, r2), 1);
      g2 = Math.min(Math.max(0, g2), 1);
      b2 = Math.min(Math.max(0, b2), 1);
      return [r2 * 255, g2 * 255, b2 * 255];
    };
    convert2.xyz.lab = function(xyz) {
      let x2 = xyz[0];
      let y2 = xyz[1];
      let z2 = xyz[2];
      x2 /= 95.047;
      y2 /= 100;
      z2 /= 108.883;
      x2 = x2 > 8856e-6 ? x2 ** (1 / 3) : 7.787 * x2 + 16 / 116;
      y2 = y2 > 8856e-6 ? y2 ** (1 / 3) : 7.787 * y2 + 16 / 116;
      z2 = z2 > 8856e-6 ? z2 ** (1 / 3) : 7.787 * z2 + 16 / 116;
      const l2 = 116 * y2 - 16;
      const a2 = 500 * (x2 - y2);
      const b2 = 200 * (y2 - z2);
      return [l2, a2, b2];
    };
    convert2.lab.xyz = function(lab) {
      const l2 = lab[0];
      const a2 = lab[1];
      const b2 = lab[2];
      let x2;
      let y2;
      let z2;
      y2 = (l2 + 16) / 116;
      x2 = a2 / 500 + y2;
      z2 = y2 - b2 / 200;
      const y22 = y2 ** 3;
      const x22 = x2 ** 3;
      const z22 = z2 ** 3;
      y2 = y22 > 8856e-6 ? y22 : (y2 - 16 / 116) / 7.787;
      x2 = x22 > 8856e-6 ? x22 : (x2 - 16 / 116) / 7.787;
      z2 = z22 > 8856e-6 ? z22 : (z2 - 16 / 116) / 7.787;
      x2 *= 95.047;
      y2 *= 100;
      z2 *= 108.883;
      return [x2, y2, z2];
    };
    convert2.lab.lch = function(lab) {
      const l2 = lab[0];
      const a2 = lab[1];
      const b2 = lab[2];
      let h2;
      const hr = Math.atan2(b2, a2);
      h2 = hr * 360 / 2 / Math.PI;
      if (h2 < 0) {
        h2 += 360;
      }
      const c2 = Math.sqrt(a2 * a2 + b2 * b2);
      return [l2, c2, h2];
    };
    convert2.lch.lab = function(lch) {
      const l2 = lch[0];
      const c2 = lch[1];
      const h2 = lch[2];
      const hr = h2 / 360 * 2 * Math.PI;
      const a2 = c2 * Math.cos(hr);
      const b2 = c2 * Math.sin(hr);
      return [l2, a2, b2];
    };
    convert2.rgb.ansi16 = function(args, saturation = null) {
      const [r2, g2, b2] = args;
      let value = saturation === null ? convert2.rgb.hsv(args)[2] : saturation;
      value = Math.round(value / 50);
      if (value === 0) {
        return 30;
      }
      let ansi = 30 + (Math.round(b2 / 255) << 2 | Math.round(g2 / 255) << 1 | Math.round(r2 / 255));
      if (value === 2) {
        ansi += 60;
      }
      return ansi;
    };
    convert2.hsv.ansi16 = function(args) {
      return convert2.rgb.ansi16(convert2.hsv.rgb(args), args[2]);
    };
    convert2.rgb.ansi256 = function(args) {
      const r2 = args[0];
      const g2 = args[1];
      const b2 = args[2];
      if (r2 === g2 && g2 === b2) {
        if (r2 < 8) {
          return 16;
        }
        if (r2 > 248) {
          return 231;
        }
        return Math.round((r2 - 8) / 247 * 24) + 232;
      }
      const ansi = 16 + 36 * Math.round(r2 / 255 * 5) + 6 * Math.round(g2 / 255 * 5) + Math.round(b2 / 255 * 5);
      return ansi;
    };
    convert2.ansi16.rgb = function(args) {
      let color = args % 10;
      if (color === 0 || color === 7) {
        if (args > 50) {
          color += 3.5;
        }
        color = color / 10.5 * 255;
        return [color, color, color];
      }
      const mult = (~~(args > 50) + 1) * 0.5;
      const r2 = (color & 1) * mult * 255;
      const g2 = (color >> 1 & 1) * mult * 255;
      const b2 = (color >> 2 & 1) * mult * 255;
      return [r2, g2, b2];
    };
    convert2.ansi256.rgb = function(args) {
      if (args >= 232) {
        const c2 = (args - 232) * 10 + 8;
        return [c2, c2, c2];
      }
      args -= 16;
      let rem;
      const r2 = Math.floor(args / 36) / 5 * 255;
      const g2 = Math.floor((rem = args % 36) / 6) / 5 * 255;
      const b2 = rem % 6 / 5 * 255;
      return [r2, g2, b2];
    };
    convert2.rgb.hex = function(args) {
      const integer = ((Math.round(args[0]) & 255) << 16) + ((Math.round(args[1]) & 255) << 8) + (Math.round(args[2]) & 255);
      const string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert2.hex.rgb = function(args) {
      const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
      if (!match) {
        return [0, 0, 0];
      }
      let colorString = match[0];
      if (match[0].length === 3) {
        colorString = colorString.split("").map((char) => {
          return char + char;
        }).join("");
      }
      const integer = parseInt(colorString, 16);
      const r2 = integer >> 16 & 255;
      const g2 = integer >> 8 & 255;
      const b2 = integer & 255;
      return [r2, g2, b2];
    };
    convert2.rgb.hcg = function(rgb) {
      const r2 = rgb[0] / 255;
      const g2 = rgb[1] / 255;
      const b2 = rgb[2] / 255;
      const max = Math.max(Math.max(r2, g2), b2);
      const min = Math.min(Math.min(r2, g2), b2);
      const chroma = max - min;
      let grayscale;
      let hue;
      if (chroma < 1) {
        grayscale = min / (1 - chroma);
      } else {
        grayscale = 0;
      }
      if (chroma <= 0) {
        hue = 0;
      } else if (max === r2) {
        hue = (g2 - b2) / chroma % 6;
      } else if (max === g2) {
        hue = 2 + (b2 - r2) / chroma;
      } else {
        hue = 4 + (r2 - g2) / chroma;
      }
      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };
    convert2.hsl.hcg = function(hsl) {
      const s2 = hsl[1] / 100;
      const l2 = hsl[2] / 100;
      const c2 = l2 < 0.5 ? 2 * s2 * l2 : 2 * s2 * (1 - l2);
      let f2 = 0;
      if (c2 < 1) {
        f2 = (l2 - 0.5 * c2) / (1 - c2);
      }
      return [hsl[0], c2 * 100, f2 * 100];
    };
    convert2.hsv.hcg = function(hsv) {
      const s2 = hsv[1] / 100;
      const v2 = hsv[2] / 100;
      const c2 = s2 * v2;
      let f2 = 0;
      if (c2 < 1) {
        f2 = (v2 - c2) / (1 - c2);
      }
      return [hsv[0], c2 * 100, f2 * 100];
    };
    convert2.hcg.rgb = function(hcg) {
      const h2 = hcg[0] / 360;
      const c2 = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      if (c2 === 0) {
        return [g2 * 255, g2 * 255, g2 * 255];
      }
      const pure = [0, 0, 0];
      const hi = h2 % 1 * 6;
      const v2 = hi % 1;
      const w2 = 1 - v2;
      let mg = 0;
      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v2;
          pure[2] = 0;
          break;
        case 1:
          pure[0] = w2;
          pure[1] = 1;
          pure[2] = 0;
          break;
        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v2;
          break;
        case 3:
          pure[0] = 0;
          pure[1] = w2;
          pure[2] = 1;
          break;
        case 4:
          pure[0] = v2;
          pure[1] = 0;
          pure[2] = 1;
          break;
        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w2;
      }
      mg = (1 - c2) * g2;
      return [
        (c2 * pure[0] + mg) * 255,
        (c2 * pure[1] + mg) * 255,
        (c2 * pure[2] + mg) * 255
      ];
    };
    convert2.hcg.hsv = function(hcg) {
      const c2 = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      const v2 = c2 + g2 * (1 - c2);
      let f2 = 0;
      if (v2 > 0) {
        f2 = c2 / v2;
      }
      return [hcg[0], f2 * 100, v2 * 100];
    };
    convert2.hcg.hsl = function(hcg) {
      const c2 = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      const l2 = g2 * (1 - c2) + 0.5 * c2;
      let s2 = 0;
      if (l2 > 0 && l2 < 0.5) {
        s2 = c2 / (2 * l2);
      } else if (l2 >= 0.5 && l2 < 1) {
        s2 = c2 / (2 * (1 - l2));
      }
      return [hcg[0], s2 * 100, l2 * 100];
    };
    convert2.hcg.hwb = function(hcg) {
      const c2 = hcg[1] / 100;
      const g2 = hcg[2] / 100;
      const v2 = c2 + g2 * (1 - c2);
      return [hcg[0], (v2 - c2) * 100, (1 - v2) * 100];
    };
    convert2.hwb.hcg = function(hwb) {
      const w2 = hwb[1] / 100;
      const b2 = hwb[2] / 100;
      const v2 = 1 - b2;
      const c2 = v2 - w2;
      let g2 = 0;
      if (c2 < 1) {
        g2 = (v2 - c2) / (1 - c2);
      }
      return [hwb[0], c2 * 100, g2 * 100];
    };
    convert2.apple.rgb = function(apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };
    convert2.rgb.apple = function(rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };
    convert2.gray.rgb = function(args) {
      return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };
    convert2.gray.hsl = function(args) {
      return [0, 0, args[0]];
    };
    convert2.gray.hsv = convert2.gray.hsl;
    convert2.gray.hwb = function(gray) {
      return [0, 100, gray[0]];
    };
    convert2.gray.cmyk = function(gray) {
      return [0, 0, 0, gray[0]];
    };
    convert2.gray.lab = function(gray) {
      return [gray[0], 0, 0];
    };
    convert2.gray.hex = function(gray) {
      const val = Math.round(gray[0] / 100 * 255) & 255;
      const integer = (val << 16) + (val << 8) + val;
      const string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert2.rgb.gray = function(rgb) {
      const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  }
});

// ../node_modules/color-convert/route.js
var require_route = __commonJS({
  "../node_modules/color-convert/route.js"(exports, module) {
    var conversions = require_conversions();
    function buildGraph() {
      const graph = {};
      const models = Object.keys(conversions);
      for (let len = models.length, i2 = 0; i2 < len; i2++) {
        graph[models[i2]] = {
          // http://jsperf.com/1-vs-infinity
          // micro-opt, but this is simple.
          distance: -1,
          parent: null
        };
      }
      return graph;
    }
    __name(buildGraph, "buildGraph");
    function deriveBFS(fromModel) {
      const graph = buildGraph();
      const queue = [fromModel];
      graph[fromModel].distance = 0;
      while (queue.length) {
        const current = queue.pop();
        const adjacents = Object.keys(conversions[current]);
        for (let len = adjacents.length, i2 = 0; i2 < len; i2++) {
          const adjacent = adjacents[i2];
          const node = graph[adjacent];
          if (node.distance === -1) {
            node.distance = graph[current].distance + 1;
            node.parent = current;
            queue.unshift(adjacent);
          }
        }
      }
      return graph;
    }
    __name(deriveBFS, "deriveBFS");
    function link(from, to) {
      return function(args) {
        return to(from(args));
      };
    }
    __name(link, "link");
    function wrapConversion(toModel, graph) {
      const path = [graph[toModel].parent, toModel];
      let fn = conversions[graph[toModel].parent][toModel];
      let cur = graph[toModel].parent;
      while (graph[cur].parent) {
        path.unshift(graph[cur].parent);
        fn = link(conversions[graph[cur].parent][cur], fn);
        cur = graph[cur].parent;
      }
      fn.conversion = path;
      return fn;
    }
    __name(wrapConversion, "wrapConversion");
    module.exports = function(fromModel) {
      const graph = deriveBFS(fromModel);
      const conversion = {};
      const models = Object.keys(graph);
      for (let len = models.length, i2 = 0; i2 < len; i2++) {
        const toModel = models[i2];
        const node = graph[toModel];
        if (node.parent === null) {
          continue;
        }
        conversion[toModel] = wrapConversion(toModel, graph);
      }
      return conversion;
    };
  }
});

// ../node_modules/color-convert/index.js
var require_color_convert = __commonJS({
  "../node_modules/color-convert/index.js"(exports, module) {
    var conversions = require_conversions();
    var route = require_route();
    var convert2 = {};
    var models = Object.keys(conversions);
    function wrapRaw(fn) {
      const wrappedFn = /* @__PURE__ */ __name(function(...args) {
        const arg0 = args[0];
        if (arg0 === void 0 || arg0 === null) {
          return arg0;
        }
        if (arg0.length > 1) {
          args = arg0;
        }
        return fn(args);
      }, "wrappedFn");
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRaw, "wrapRaw");
    function wrapRounded(fn) {
      const wrappedFn = /* @__PURE__ */ __name(function(...args) {
        const arg0 = args[0];
        if (arg0 === void 0 || arg0 === null) {
          return arg0;
        }
        if (arg0.length > 1) {
          args = arg0;
        }
        const result = fn(args);
        if (typeof result === "object") {
          for (let len = result.length, i2 = 0; i2 < len; i2++) {
            result[i2] = Math.round(result[i2]);
          }
        }
        return result;
      }, "wrappedFn");
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRounded, "wrapRounded");
    models.forEach((fromModel) => {
      convert2[fromModel] = {};
      Object.defineProperty(convert2[fromModel], "channels", { value: conversions[fromModel].channels });
      Object.defineProperty(convert2[fromModel], "labels", { value: conversions[fromModel].labels });
      const routes = route(fromModel);
      const routeModels = Object.keys(routes);
      routeModels.forEach((toModel) => {
        const fn = routes[toModel];
        convert2[fromModel][toModel] = wrapRounded(fn);
        convert2[fromModel][toModel].raw = wrapRaw(fn);
      });
    });
    module.exports = convert2;
  }
});

// ../addons/docs/src/blocks/controls/Color.tsx
var import_color_convert = __toESM(require_color_convert(), 1);
import React, { useCallback, useEffect, useMemo, useState } from "react";
import { Form, TooltipNote, WithTooltip } from "storybook/internal/components";
import { MarkupIcon } from "@storybook/icons";

// ../node_modules/es-toolkit/dist/function/debounce.mjs
function debounce(func, debounceMs, { signal, edges } = {}) {
  let pendingThis = void 0;
  let pendingArgs = null;
  const leading = edges != null && edges.includes("leading");
  const trailing = edges == null || edges.includes("trailing");
  const invoke = /* @__PURE__ */ __name(() => {
    if (pendingArgs !== null) {
      func.apply(pendingThis, pendingArgs);
      pendingThis = void 0;
      pendingArgs = null;
    }
  }, "invoke");
  const onTimerEnd = /* @__PURE__ */ __name(() => {
    if (trailing) {
      invoke();
    }
    cancel();
  }, "onTimerEnd");
  let timeoutId = null;
  const schedule = /* @__PURE__ */ __name(() => {
    if (timeoutId != null) {
      clearTimeout(timeoutId);
    }
    timeoutId = setTimeout(() => {
      timeoutId = null;
      onTimerEnd();
    }, debounceMs);
  }, "schedule");
  const cancelTimer = /* @__PURE__ */ __name(() => {
    if (timeoutId !== null) {
      clearTimeout(timeoutId);
      timeoutId = null;
    }
  }, "cancelTimer");
  const cancel = /* @__PURE__ */ __name(() => {
    cancelTimer();
    pendingThis = void 0;
    pendingArgs = null;
  }, "cancel");
  const flush = /* @__PURE__ */ __name(() => {
    invoke();
  }, "flush");
  const debounced = /* @__PURE__ */ __name(function(...args) {
    if (signal?.aborted) {
      return;
    }
    pendingThis = this;
    pendingArgs = args;
    const isFirstCall = timeoutId == null;
    schedule();
    if (leading && isFirstCall) {
      invoke();
    }
  }, "debounced");
  debounced.schedule = schedule;
  debounced.cancel = cancel;
  debounced.flush = flush;
  signal?.addEventListener("abort", cancel, { once: true });
  return debounced;
}
__name(debounce, "debounce");

// ../node_modules/es-toolkit/dist/function/partial.mjs
function partial(func, ...partialArgs) {
  return partialImpl(func, placeholderSymbol, ...partialArgs);
}
__name(partial, "partial");
function partialImpl(func, placeholder, ...partialArgs) {
  const partialed = /* @__PURE__ */ __name(function(...providedArgs) {
    let providedArgsIndex = 0;
    const substitutedArgs = partialArgs.slice().map((arg) => arg === placeholder ? providedArgs[providedArgsIndex++] : arg);
    const remainingArgs = providedArgs.slice(providedArgsIndex);
    return func.apply(this, substitutedArgs.concat(remainingArgs));
  }, "partialed");
  if (func.prototype) {
    partialed.prototype = Object.create(func.prototype);
  }
  return partialed;
}
__name(partialImpl, "partialImpl");
var placeholderSymbol = Symbol("partial.placeholder");
partial.placeholder = placeholderSymbol;

// ../node_modules/es-toolkit/dist/function/partialRight.mjs
function partialRight(func, ...partialArgs) {
  return partialRightImpl(func, placeholderSymbol2, ...partialArgs);
}
__name(partialRight, "partialRight");
function partialRightImpl(func, placeholder, ...partialArgs) {
  const partialedRight = /* @__PURE__ */ __name(function(...providedArgs) {
    const placeholderLength = partialArgs.filter((arg) => arg === placeholder).length;
    const rangeLength = Math.max(providedArgs.length - placeholderLength, 0);
    const remainingArgs = providedArgs.slice(0, rangeLength);
    let providedArgsIndex = rangeLength;
    const substitutedArgs = partialArgs.slice().map((arg) => arg === placeholder ? providedArgs[providedArgsIndex++] : arg);
    return func.apply(this, remainingArgs.concat(substitutedArgs));
  }, "partialedRight");
  if (func.prototype) {
    partialedRight.prototype = Object.create(func.prototype);
  }
  return partialedRight;
}
__name(partialRightImpl, "partialRightImpl");
var placeholderSymbol2 = Symbol("partialRight.placeholder");
partialRight.placeholder = placeholderSymbol2;

// ../node_modules/es-toolkit/dist/function/retry.mjs
var DEFAULT_RETRIES = Number.POSITIVE_INFINITY;

// ../node_modules/react-colorful/dist/index.mjs
import e, { useRef as r, useMemo as t, useEffect as n, useState as o, useCallback as a, useLayoutEffect as l } from "react";
function u() {
  return (u = Object.assign || function(e2) {
    for (var r2 = 1; r2 < arguments.length; r2++) {
      var t2 = arguments[r2];
      for (var n2 in t2) Object.prototype.hasOwnProperty.call(t2, n2) && (e2[n2] = t2[n2]);
    }
    return e2;
  }).apply(this, arguments);
}
__name(u, "u");
function c(e2, r2) {
  if (null == e2) return {};
  var t2, n2, o2 = {}, a2 = Object.keys(e2);
  for (n2 = 0; n2 < a2.length; n2++) r2.indexOf(t2 = a2[n2]) >= 0 || (o2[t2] = e2[t2]);
  return o2;
}
__name(c, "c");
function i(e2) {
  var t2 = r(e2), n2 = r(function(e3) {
    t2.current && t2.current(e3);
  });
  return t2.current = e2, n2.current;
}
__name(i, "i");
var s = /* @__PURE__ */ __name(function(e2, r2, t2) {
  return void 0 === r2 && (r2 = 0), void 0 === t2 && (t2 = 1), e2 > t2 ? t2 : e2 < r2 ? r2 : e2;
}, "s");
var f = /* @__PURE__ */ __name(function(e2) {
  return "touches" in e2;
}, "f");
var v = /* @__PURE__ */ __name(function(e2) {
  return e2 && e2.ownerDocument.defaultView || self;
}, "v");
var d = /* @__PURE__ */ __name(function(e2, r2, t2) {
  var n2 = e2.getBoundingClientRect(), o2 = f(r2) ? function(e3, r3) {
    for (var t3 = 0; t3 < e3.length; t3++) if (e3[t3].identifier === r3) return e3[t3];
    return e3[0];
  }(r2.touches, t2) : r2;
  return { left: s((o2.pageX - (n2.left + v(e2).pageXOffset)) / n2.width), top: s((o2.pageY - (n2.top + v(e2).pageYOffset)) / n2.height) };
}, "d");
var h = /* @__PURE__ */ __name(function(e2) {
  !f(e2) && e2.preventDefault();
}, "h");
var m = e.memo(function(o2) {
  var a2 = o2.onMove, l2 = o2.onKey, s2 = c(o2, ["onMove", "onKey"]), m2 = r(null), g2 = i(a2), p2 = i(l2), b2 = r(null), _2 = r(false), x2 = t(function() {
    var e2 = /* @__PURE__ */ __name(function(e3) {
      h(e3), (f(e3) ? e3.touches.length > 0 : e3.buttons > 0) && m2.current ? g2(d(m2.current, e3, b2.current)) : t2(false);
    }, "e"), r2 = /* @__PURE__ */ __name(function() {
      return t2(false);
    }, "r");
    function t2(t3) {
      var n2 = _2.current, o3 = v(m2.current), a3 = t3 ? o3.addEventListener : o3.removeEventListener;
      a3(n2 ? "touchmove" : "mousemove", e2), a3(n2 ? "touchend" : "mouseup", r2);
    }
    __name(t2, "t");
    return [function(e3) {
      var r3 = e3.nativeEvent, n2 = m2.current;
      if (n2 && (h(r3), !function(e4, r4) {
        return r4 && !f(e4);
      }(r3, _2.current) && n2)) {
        if (f(r3)) {
          _2.current = true;
          var o3 = r3.changedTouches || [];
          o3.length && (b2.current = o3[0].identifier);
        }
        n2.focus(), g2(d(n2, r3, b2.current)), t2(true);
      }
    }, function(e3) {
      var r3 = e3.which || e3.keyCode;
      r3 < 37 || r3 > 40 || (e3.preventDefault(), p2({ left: 39 === r3 ? 0.05 : 37 === r3 ? -0.05 : 0, top: 40 === r3 ? 0.05 : 38 === r3 ? -0.05 : 0 }));
    }, t2];
  }, [p2, g2]), C2 = x2[0], E2 = x2[1], H2 = x2[2];
  return n(function() {
    return H2;
  }, [H2]), e.createElement("div", u({}, s2, { onTouchStart: C2, onMouseDown: C2, className: "react-colorful__interactive", ref: m2, onKeyDown: E2, tabIndex: 0, role: "slider" }));
});
var g = /* @__PURE__ */ __name(function(e2) {
  return e2.filter(Boolean).join(" ");
}, "g");
var p = /* @__PURE__ */ __name(function(r2) {
  var t2 = r2.color, n2 = r2.left, o2 = r2.top, a2 = void 0 === o2 ? 0.5 : o2, l2 = g(["react-colorful__pointer", r2.className]);
  return e.createElement("div", { className: l2, style: { top: 100 * a2 + "%", left: 100 * n2 + "%" } }, e.createElement("div", { className: "react-colorful__pointer-fill", style: { backgroundColor: t2 } }));
}, "p");
var b = /* @__PURE__ */ __name(function(e2, r2, t2) {
  return void 0 === r2 && (r2 = 0), void 0 === t2 && (t2 = Math.pow(10, r2)), Math.round(t2 * e2) / t2;
}, "b");
var _ = { grad: 0.9, turn: 360, rad: 360 / (2 * Math.PI) };
var x = /* @__PURE__ */ __name(function(e2) {
  return L(C(e2));
}, "x");
var C = /* @__PURE__ */ __name(function(e2) {
  return "#" === e2[0] && (e2 = e2.substring(1)), e2.length < 6 ? { r: parseInt(e2[0] + e2[0], 16), g: parseInt(e2[1] + e2[1], 16), b: parseInt(e2[2] + e2[2], 16), a: 4 === e2.length ? b(parseInt(e2[3] + e2[3], 16) / 255, 2) : 1 } : { r: parseInt(e2.substring(0, 2), 16), g: parseInt(e2.substring(2, 4), 16), b: parseInt(e2.substring(4, 6), 16), a: 8 === e2.length ? b(parseInt(e2.substring(6, 8), 16) / 255, 2) : 1 };
}, "C");
var E = /* @__PURE__ */ __name(function(e2, r2) {
  return void 0 === r2 && (r2 = "deg"), Number(e2) * (_[r2] || 1);
}, "E");
var H = /* @__PURE__ */ __name(function(e2) {
  var r2 = /hsla?\(?\s*(-?\d*\.?\d+)(deg|rad|grad|turn)?[,\s]+(-?\d*\.?\d+)%?[,\s]+(-?\d*\.?\d+)%?,?\s*[/\s]*(-?\d*\.?\d+)?(%)?\s*\)?/i.exec(e2);
  return r2 ? N({ h: E(r2[1], r2[2]), s: Number(r2[3]), l: Number(r2[4]), a: void 0 === r2[5] ? 1 : Number(r2[5]) / (r2[6] ? 100 : 1) }) : { h: 0, s: 0, v: 0, a: 1 };
}, "H");
var N = /* @__PURE__ */ __name(function(e2) {
  var r2 = e2.s, t2 = e2.l;
  return { h: e2.h, s: (r2 *= (t2 < 50 ? t2 : 100 - t2) / 100) > 0 ? 2 * r2 / (t2 + r2) * 100 : 0, v: t2 + r2, a: e2.a };
}, "N");
var w = /* @__PURE__ */ __name(function(e2) {
  return K(I(e2));
}, "w");
var y = /* @__PURE__ */ __name(function(e2) {
  var r2 = e2.s, t2 = e2.v, n2 = e2.a, o2 = (200 - r2) * t2 / 100;
  return { h: b(e2.h), s: b(o2 > 0 && o2 < 200 ? r2 * t2 / 100 / (o2 <= 100 ? o2 : 200 - o2) * 100 : 0), l: b(o2 / 2), a: b(n2, 2) };
}, "y");
var q = /* @__PURE__ */ __name(function(e2) {
  var r2 = y(e2);
  return "hsl(" + r2.h + ", " + r2.s + "%, " + r2.l + "%)";
}, "q");
var k = /* @__PURE__ */ __name(function(e2) {
  var r2 = y(e2);
  return "hsla(" + r2.h + ", " + r2.s + "%, " + r2.l + "%, " + r2.a + ")";
}, "k");
var I = /* @__PURE__ */ __name(function(e2) {
  var r2 = e2.h, t2 = e2.s, n2 = e2.v, o2 = e2.a;
  r2 = r2 / 360 * 6, t2 /= 100, n2 /= 100;
  var a2 = Math.floor(r2), l2 = n2 * (1 - t2), u2 = n2 * (1 - (r2 - a2) * t2), c2 = n2 * (1 - (1 - r2 + a2) * t2), i2 = a2 % 6;
  return { r: b(255 * [n2, u2, l2, l2, c2, n2][i2]), g: b(255 * [c2, n2, n2, u2, l2, l2][i2]), b: b(255 * [l2, l2, c2, n2, n2, u2][i2]), a: b(o2, 2) };
}, "I");
var z = /* @__PURE__ */ __name(function(e2) {
  var r2 = /rgba?\(?\s*(-?\d*\.?\d+)(%)?[,\s]+(-?\d*\.?\d+)(%)?[,\s]+(-?\d*\.?\d+)(%)?,?\s*[/\s]*(-?\d*\.?\d+)?(%)?\s*\)?/i.exec(e2);
  return r2 ? L({ r: Number(r2[1]) / (r2[2] ? 100 / 255 : 1), g: Number(r2[3]) / (r2[4] ? 100 / 255 : 1), b: Number(r2[5]) / (r2[6] ? 100 / 255 : 1), a: void 0 === r2[7] ? 1 : Number(r2[7]) / (r2[8] ? 100 : 1) }) : { h: 0, s: 0, v: 0, a: 1 };
}, "z");
var D = /* @__PURE__ */ __name(function(e2) {
  var r2 = e2.toString(16);
  return r2.length < 2 ? "0" + r2 : r2;
}, "D");
var K = /* @__PURE__ */ __name(function(e2) {
  var r2 = e2.r, t2 = e2.g, n2 = e2.b, o2 = e2.a, a2 = o2 < 1 ? D(b(255 * o2)) : "";
  return "#" + D(r2) + D(t2) + D(n2) + a2;
}, "K");
var L = /* @__PURE__ */ __name(function(e2) {
  var r2 = e2.r, t2 = e2.g, n2 = e2.b, o2 = e2.a, a2 = Math.max(r2, t2, n2), l2 = a2 - Math.min(r2, t2, n2), u2 = l2 ? a2 === r2 ? (t2 - n2) / l2 : a2 === t2 ? 2 + (n2 - r2) / l2 : 4 + (r2 - t2) / l2 : 0;
  return { h: b(60 * (u2 < 0 ? u2 + 6 : u2)), s: b(a2 ? l2 / a2 * 100 : 0), v: b(a2 / 255 * 100), a: o2 };
}, "L");
var S = e.memo(function(r2) {
  var t2 = r2.hue, n2 = r2.onChange, o2 = g(["react-colorful__hue", r2.className]);
  return e.createElement("div", { className: o2 }, e.createElement(m, { onMove: /* @__PURE__ */ __name(function(e2) {
    n2({ h: 360 * e2.left });
  }, "onMove"), onKey: /* @__PURE__ */ __name(function(e2) {
    n2({ h: s(t2 + 360 * e2.left, 0, 360) });
  }, "onKey"), "aria-label": "Hue", "aria-valuenow": b(t2), "aria-valuemax": "360", "aria-valuemin": "0" }, e.createElement(p, { className: "react-colorful__hue-pointer", left: t2 / 360, color: q({ h: t2, s: 100, v: 100, a: 1 }) })));
});
var T = e.memo(function(r2) {
  var t2 = r2.hsva, n2 = r2.onChange, o2 = { backgroundColor: q({ h: t2.h, s: 100, v: 100, a: 1 }) };
  return e.createElement("div", { className: "react-colorful__saturation", style: o2 }, e.createElement(m, { onMove: /* @__PURE__ */ __name(function(e2) {
    n2({ s: 100 * e2.left, v: 100 - 100 * e2.top });
  }, "onMove"), onKey: /* @__PURE__ */ __name(function(e2) {
    n2({ s: s(t2.s + 100 * e2.left, 0, 100), v: s(t2.v - 100 * e2.top, 0, 100) });
  }, "onKey"), "aria-label": "Color", "aria-valuetext": "Saturation " + b(t2.s) + "%, Brightness " + b(t2.v) + "%" }, e.createElement(p, { className: "react-colorful__saturation-pointer", top: 1 - t2.v / 100, left: t2.s / 100, color: q(t2) })));
});
var F = /* @__PURE__ */ __name(function(e2, r2) {
  if (e2 === r2) return true;
  for (var t2 in e2) if (e2[t2] !== r2[t2]) return false;
  return true;
}, "F");
var P = /* @__PURE__ */ __name(function(e2, r2) {
  return e2.replace(/\s/g, "") === r2.replace(/\s/g, "");
}, "P");
var X = /* @__PURE__ */ __name(function(e2, r2) {
  return e2.toLowerCase() === r2.toLowerCase() || F(C(e2), C(r2));
}, "X");
function Y(e2, t2, l2) {
  var u2 = i(l2), c2 = o(function() {
    return e2.toHsva(t2);
  }), s2 = c2[0], f2 = c2[1], v2 = r({ color: t2, hsva: s2 });
  n(function() {
    if (!e2.equal(t2, v2.current.color)) {
      var r2 = e2.toHsva(t2);
      v2.current = { hsva: r2, color: t2 }, f2(r2);
    }
  }, [t2, e2]), n(function() {
    var r2;
    F(s2, v2.current.hsva) || e2.equal(r2 = e2.fromHsva(s2), v2.current.color) || (v2.current = { hsva: s2, color: r2 }, u2(r2));
  }, [s2, e2, u2]);
  var d2 = a(function(e3) {
    f2(function(r2) {
      return Object.assign({}, r2, e3);
    });
  }, []);
  return [s2, d2];
}
__name(Y, "Y");
var R;
var V = "undefined" != typeof window ? l : n;
var $ = /* @__PURE__ */ __name(function() {
  return R || ("undefined" != typeof __webpack_nonce__ ? __webpack_nonce__ : void 0);
}, "$");
var J = /* @__PURE__ */ new Map();
var Q = /* @__PURE__ */ __name(function(e2) {
  V(function() {
    var r2 = e2.current ? e2.current.ownerDocument : document;
    if (void 0 !== r2 && !J.has(r2)) {
      var t2 = r2.createElement("style");
      t2.innerHTML = `.react-colorful{position:relative;display:flex;flex-direction:column;width:200px;height:200px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;cursor:default}.react-colorful__saturation{position:relative;flex-grow:1;border-color:transparent;border-bottom:12px solid #000;border-radius:8px 8px 0 0;background-image:linear-gradient(0deg,#000,transparent),linear-gradient(90deg,#fff,hsla(0,0%,100%,0))}.react-colorful__alpha-gradient,.react-colorful__pointer-fill{content:"";position:absolute;left:0;top:0;right:0;bottom:0;pointer-events:none;border-radius:inherit}.react-colorful__alpha-gradient,.react-colorful__saturation{box-shadow:inset 0 0 0 1px rgba(0,0,0,.05)}.react-colorful__alpha,.react-colorful__hue{position:relative;height:24px}.react-colorful__hue{background:linear-gradient(90deg,red 0,#ff0 17%,#0f0 33%,#0ff 50%,#00f 67%,#f0f 83%,red)}.react-colorful__last-control{border-radius:0 0 8px 8px}.react-colorful__interactive{position:absolute;left:0;top:0;right:0;bottom:0;border-radius:inherit;outline:none;touch-action:none}.react-colorful__pointer{position:absolute;z-index:1;box-sizing:border-box;width:28px;height:28px;transform:translate(-50%,-50%);background-color:#fff;border:2px solid #fff;border-radius:50%;box-shadow:0 2px 4px rgba(0,0,0,.2)}.react-colorful__interactive:focus .react-colorful__pointer{transform:translate(-50%,-50%) scale(1.1)}.react-colorful__alpha,.react-colorful__alpha-pointer{background-color:#fff;background-image:url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill-opacity=".05"><path d="M8 0h8v8H8zM0 8h8v8H0z"/></svg>')}.react-colorful__saturation-pointer{z-index:3}.react-colorful__hue-pointer{z-index:2}`, J.set(r2, t2);
      var n2 = $();
      n2 && t2.setAttribute("nonce", n2), r2.head.appendChild(t2);
    }
  }, []);
}, "Q");
var U = /* @__PURE__ */ __name(function(t2) {
  var n2 = t2.className, o2 = t2.colorModel, a2 = t2.color, l2 = void 0 === a2 ? o2.defaultColor : a2, i2 = t2.onChange, s2 = c(t2, ["className", "colorModel", "color", "onChange"]), f2 = r(null);
  Q(f2);
  var v2 = Y(o2, l2, i2), d2 = v2[0], h2 = v2[1], m2 = g(["react-colorful", n2]);
  return e.createElement("div", u({}, s2, { ref: f2, className: m2 }), e.createElement(T, { hsva: d2, onChange: h2 }), e.createElement(S, { hue: d2.h, onChange: h2, className: "react-colorful__last-control" }));
}, "U");
var W = { defaultColor: "000", toHsva: x, fromHsva: /* @__PURE__ */ __name(function(e2) {
  return w({ h: e2.h, s: e2.s, v: e2.v, a: 1 });
}, "fromHsva"), equal: X };
var Z = /* @__PURE__ */ __name(function(r2) {
  return e.createElement(U, u({}, r2, { colorModel: W }));
}, "Z");
var ee = /* @__PURE__ */ __name(function(r2) {
  var t2 = r2.className, n2 = r2.hsva, o2 = r2.onChange, a2 = { backgroundImage: "linear-gradient(90deg, " + k(Object.assign({}, n2, { a: 0 })) + ", " + k(Object.assign({}, n2, { a: 1 })) + ")" }, l2 = g(["react-colorful__alpha", t2]), u2 = b(100 * n2.a);
  return e.createElement("div", { className: l2 }, e.createElement("div", { className: "react-colorful__alpha-gradient", style: a2 }), e.createElement(m, { onMove: /* @__PURE__ */ __name(function(e2) {
    o2({ a: e2.left });
  }, "onMove"), onKey: /* @__PURE__ */ __name(function(e2) {
    o2({ a: s(n2.a + e2.left) });
  }, "onKey"), "aria-label": "Alpha", "aria-valuetext": u2 + "%", "aria-valuenow": u2, "aria-valuemin": "0", "aria-valuemax": "100" }, e.createElement(p, { className: "react-colorful__alpha-pointer", left: n2.a, color: k(n2) })));
}, "ee");
var re = /* @__PURE__ */ __name(function(t2) {
  var n2 = t2.className, o2 = t2.colorModel, a2 = t2.color, l2 = void 0 === a2 ? o2.defaultColor : a2, i2 = t2.onChange, s2 = c(t2, ["className", "colorModel", "color", "onChange"]), f2 = r(null);
  Q(f2);
  var v2 = Y(o2, l2, i2), d2 = v2[0], h2 = v2[1], m2 = g(["react-colorful", n2]);
  return e.createElement("div", u({}, s2, { ref: f2, className: m2 }), e.createElement(T, { hsva: d2, onChange: h2 }), e.createElement(S, { hue: d2.h, onChange: h2 }), e.createElement(ee, { hsva: d2, onChange: h2, className: "react-colorful__last-control" }));
}, "re");
var le = { defaultColor: "hsla(0, 0%, 0%, 1)", toHsva: H, fromHsva: k, equal: P };
var ue = /* @__PURE__ */ __name(function(r2) {
  return e.createElement(re, u({}, r2, { colorModel: le }));
}, "ue");
var Ee = { defaultColor: "rgba(0, 0, 0, 1)", toHsva: z, fromHsva: /* @__PURE__ */ __name(function(e2) {
  var r2 = I(e2);
  return "rgba(" + r2.r + ", " + r2.g + ", " + r2.b + ", " + r2.a + ")";
}, "fromHsva"), equal: P };
var He = /* @__PURE__ */ __name(function(r2) {
  return e.createElement(re, u({}, r2, { colorModel: Ee }));
}, "He");

// ../addons/docs/src/blocks/controls/Color.tsx
import { styled } from "storybook/theming";
var Wrapper = styled.div({
  position: "relative",
  maxWidth: 250,
  '&[aria-readonly="true"]': {
    opacity: 0.5
  }
});
var PickerTooltip = styled(WithTooltip)({
  position: "absolute",
  zIndex: 1,
  top: 4,
  left: 4,
  "[aria-readonly=true] &": {
    cursor: "not-allowed"
  }
});
var TooltipContent = styled.div({
  width: 200,
  margin: 5,
  ".react-colorful__saturation": {
    borderRadius: "4px 4px 0 0"
  },
  ".react-colorful__hue": {
    boxShadow: "inset 0 0 0 1px rgb(0 0 0 / 5%)"
  },
  ".react-colorful__last-control": {
    borderRadius: "0 0 4px 4px"
  }
});
var Note = styled(TooltipNote)(({ theme }) => ({
  fontFamily: theme.typography.fonts.base
}));
var Swatches = styled.div({
  display: "grid",
  gridTemplateColumns: "repeat(9, 16px)",
  gap: 6,
  padding: 3,
  marginTop: 5,
  width: 200
});
var SwatchColor = styled.div(({ theme, active }) => ({
  width: 16,
  height: 16,
  boxShadow: active ? `${theme.appBorderColor} 0 0 0 1px inset, ${theme.textMutedColor}50 0 0 0 4px` : `${theme.appBorderColor} 0 0 0 1px inset`,
  borderRadius: theme.appBorderRadius
}));
var swatchBackground = `url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill-opacity=".05"><path d="M8 0h8v8H8zM0 8h8v8H0z"/></svg>')`;
var Swatch = /* @__PURE__ */ __name(({ value, style, ...props }) => {
  const backgroundImage = `linear-gradient(${value}, ${value}), ${swatchBackground}, linear-gradient(#fff, #fff)`;
  return React.createElement(SwatchColor, { ...props, style: { ...style, backgroundImage } });
}, "Swatch");
var Input = styled(Form.Input)(({ theme, readOnly }) => ({
  width: "100%",
  paddingLeft: 30,
  paddingRight: 30,
  boxSizing: "border-box",
  fontFamily: theme.typography.fonts.base
}));
var ToggleIcon = styled(MarkupIcon)(({ theme }) => ({
  position: "absolute",
  zIndex: 1,
  top: 6,
  right: 7,
  width: 20,
  height: 20,
  padding: 4,
  boxSizing: "border-box",
  cursor: "pointer",
  color: theme.input.color
}));
var ColorSpace = /* @__PURE__ */ ((ColorSpace2) => {
  ColorSpace2["RGB"] = "rgb";
  ColorSpace2["HSL"] = "hsl";
  ColorSpace2["HEX"] = "hex";
  return ColorSpace2;
})(ColorSpace || {});
var COLOR_SPACES = Object.values(ColorSpace);
var COLOR_REGEXP = /\(([0-9]+),\s*([0-9]+)%?,\s*([0-9]+)%?,?\s*([0-9.]+)?\)/;
var RGB_REGEXP = /^\s*rgba?\(([0-9]+),\s*([0-9]+),\s*([0-9]+),?\s*([0-9.]+)?\)\s*$/i;
var HSL_REGEXP = /^\s*hsla?\(([0-9]+),\s*([0-9]+)%,\s*([0-9]+)%,?\s*([0-9.]+)?\)\s*$/i;
var HEX_REGEXP = /^\s*#?([0-9a-f]{3}|[0-9a-f]{6})\s*$/i;
var SHORTHEX_REGEXP = /^\s*#?([0-9a-f]{3})\s*$/i;
var ColorPicker = {
  ["hex" /* HEX */]: Z,
  ["rgb" /* RGB */]: He,
  ["hsl" /* HSL */]: ue
};
var fallbackColor = {
  ["hex" /* HEX */]: "transparent",
  ["rgb" /* RGB */]: "rgba(0, 0, 0, 0)",
  ["hsl" /* HSL */]: "hsla(0, 0%, 0%, 0)"
};
var stringToArgs = /* @__PURE__ */ __name((value) => {
  const match = value?.match(COLOR_REGEXP);
  if (!match) {
    return [0, 0, 0, 1];
  }
  const [, x2, y2, z2, a2 = 1] = match;
  return [x2, y2, z2, a2].map(Number);
}, "stringToArgs");
var parseRgb = /* @__PURE__ */ __name((value) => {
  const [r2, g2, b2, a2] = stringToArgs(value);
  const [h2, s2, l2] = import_color_convert.default.rgb.hsl([r2, g2, b2]) || [0, 0, 0];
  return {
    valid: true,
    value,
    keyword: import_color_convert.default.rgb.keyword([r2, g2, b2]),
    colorSpace: "rgb" /* RGB */,
    ["rgb" /* RGB */]: value,
    ["hsl" /* HSL */]: `hsla(${h2}, ${s2}%, ${l2}%, ${a2})`,
    ["hex" /* HEX */]: `#${import_color_convert.default.rgb.hex([r2, g2, b2]).toLowerCase()}`
  };
}, "parseRgb");
var parseHsl = /* @__PURE__ */ __name((value) => {
  const [h2, s2, l2, a2] = stringToArgs(value);
  const [r2, g2, b2] = import_color_convert.default.hsl.rgb([h2, s2, l2]) || [0, 0, 0];
  return {
    valid: true,
    value,
    keyword: import_color_convert.default.hsl.keyword([h2, s2, l2]),
    colorSpace: "hsl" /* HSL */,
    ["rgb" /* RGB */]: `rgba(${r2}, ${g2}, ${b2}, ${a2})`,
    ["hsl" /* HSL */]: value,
    ["hex" /* HEX */]: `#${import_color_convert.default.hsl.hex([h2, s2, l2]).toLowerCase()}`
  };
}, "parseHsl");
var parseHexOrKeyword = /* @__PURE__ */ __name((value) => {
  const plain = value.replace("#", "");
  const rgb = import_color_convert.default.keyword.rgb(plain) || import_color_convert.default.hex.rgb(plain);
  const hsl = import_color_convert.default.rgb.hsl(rgb);
  let mapped = value;
  if (/[^#a-f0-9]/i.test(value)) {
    mapped = plain;
  } else if (HEX_REGEXP.test(value)) {
    mapped = `#${plain}`;
  }
  let valid = true;
  if (mapped.startsWith("#")) {
    valid = HEX_REGEXP.test(mapped);
  } else {
    try {
      import_color_convert.default.keyword.hex(mapped);
    } catch (e2) {
      valid = false;
    }
  }
  return {
    valid,
    value: mapped,
    keyword: import_color_convert.default.rgb.keyword(rgb),
    colorSpace: "hex" /* HEX */,
    ["rgb" /* RGB */]: `rgba(${rgb[0]}, ${rgb[1]}, ${rgb[2]}, 1)`,
    ["hsl" /* HSL */]: `hsla(${hsl[0]}, ${hsl[1]}%, ${hsl[2]}%, 1)`,
    ["hex" /* HEX */]: mapped
  };
}, "parseHexOrKeyword");
var parseValue = /* @__PURE__ */ __name((value) => {
  if (!value) {
    return void 0;
  }
  if (RGB_REGEXP.test(value)) {
    return parseRgb(value);
  }
  if (HSL_REGEXP.test(value)) {
    return parseHsl(value);
  }
  return parseHexOrKeyword(value);
}, "parseValue");
var getRealValue = /* @__PURE__ */ __name((value, color, colorSpace) => {
  if (!value || !color?.valid) {
    return fallbackColor[colorSpace];
  }
  if (colorSpace !== "hex" /* HEX */) {
    return color?.[colorSpace] || fallbackColor[colorSpace];
  }
  if (!color.hex.startsWith("#")) {
    try {
      return `#${import_color_convert.default.keyword.hex(color.hex)}`;
    } catch (e2) {
      return fallbackColor.hex;
    }
  }
  const short = color.hex.match(SHORTHEX_REGEXP);
  if (!short) {
    return HEX_REGEXP.test(color.hex) ? color.hex : fallbackColor.hex;
  }
  const [r2, g2, b2] = short[1].split("");
  return `#${r2}${r2}${g2}${g2}${b2}${b2}`;
}, "getRealValue");
var useColorInput = /* @__PURE__ */ __name((initialValue, onChange) => {
  const [value, setValue] = useState(initialValue || "");
  const [color, setColor] = useState(() => parseValue(value));
  const [colorSpace, setColorSpace] = useState(color?.colorSpace || "hex" /* HEX */);
  useEffect(() => {
    const nextValue = initialValue || "";
    const nextColor = parseValue(nextValue);
    setValue(nextValue);
    setColor(nextColor);
    setColorSpace(nextColor?.colorSpace || "hex" /* HEX */);
  }, [initialValue]);
  const realValue = useMemo(
    () => getRealValue(value, color, colorSpace).toLowerCase(),
    [value, color, colorSpace]
  );
  const updateValue = useCallback(
    (update) => {
      const parsed = parseValue(update);
      const v2 = parsed?.value || update || "";
      setValue(v2);
      if (v2 === "") {
        setColor(void 0);
        onChange(void 0);
      }
      if (!parsed) {
        return;
      }
      setColor(parsed);
      setColorSpace(parsed.colorSpace);
      onChange(parsed.value);
    },
    [onChange]
  );
  const cycleColorSpace = useCallback(() => {
    const currentIndex = COLOR_SPACES.indexOf(colorSpace);
    const nextIndex = (currentIndex + 1) % COLOR_SPACES.length;
    const nextSpace = COLOR_SPACES[nextIndex];
    setColorSpace(nextSpace);
    const updatedValue = color?.[nextSpace] || "";
    setValue(updatedValue);
    onChange(updatedValue);
  }, [color, colorSpace, onChange]);
  return { value, realValue, updateValue, color, colorSpace, cycleColorSpace };
}, "useColorInput");
var id = /* @__PURE__ */ __name((value) => value.replace(/\s*/, "").toLowerCase(), "id");
var usePresets = /* @__PURE__ */ __name((presetColors, currentColor, colorSpace) => {
  const [selectedColors, setSelectedColors] = useState(currentColor?.valid ? [currentColor] : []);
  useEffect(() => {
    if (currentColor !== void 0) {
      return;
    }
    setSelectedColors([]);
  }, [currentColor]);
  const presets = useMemo(() => {
    const initialPresets = (presetColors || []).map((preset) => {
      if (typeof preset === "string") {
        return parseValue(preset);
      }
      if (preset.title) {
        return { ...parseValue(preset.color), keyword: preset.title };
      }
      return parseValue(preset.color);
    });
    return initialPresets.concat(selectedColors).filter(Boolean).slice(-27);
  }, [presetColors, selectedColors]);
  const addPreset = useCallback(
    (color) => {
      if (!color?.valid) {
        return;
      }
      if (presets.some(
        (preset) => preset && preset[colorSpace] && id(preset[colorSpace] || "") === id(color[colorSpace] || "")
      )) {
        return;
      }
      setSelectedColors((arr) => arr.concat(color));
    },
    [colorSpace, presets]
  );
  return { presets, addPreset };
}, "usePresets");
var ColorControl = /* @__PURE__ */ __name(({
  name,
  value: initialValue,
  onChange,
  onFocus,
  onBlur,
  presetColors,
  startOpen = false,
  argType
}) => {
  const debouncedOnChange = useCallback(debounce(onChange, 200), [onChange]);
  const { value, realValue, updateValue, color, colorSpace, cycleColorSpace } = useColorInput(
    initialValue,
    debouncedOnChange
  );
  const { presets, addPreset } = usePresets(presetColors ?? [], color, colorSpace);
  const Picker = ColorPicker[colorSpace];
  const readonly = !!argType?.table?.readonly;
  return React.createElement(Wrapper, { "aria-readonly": readonly }, React.createElement(
    PickerTooltip,
    {
      startOpen,
      trigger: readonly ? null : void 0,
      closeOnOutsideClick: true,
      onVisibleChange: () => color && addPreset(color),
      tooltip: React.createElement(TooltipContent, null, React.createElement(
        Picker,
        {
          color: realValue === "transparent" ? "#000000" : realValue,
          ...{ onChange: updateValue, onFocus, onBlur }
        }
      ), presets.length > 0 && React.createElement(Swatches, null, presets.map((preset, index) => React.createElement(
        WithTooltip,
        {
          key: `${preset?.value || index}-${index}`,
          hasChrome: false,
          tooltip: React.createElement(Note, { note: preset?.keyword || preset?.value || "" })
        },
        React.createElement(
          Swatch,
          {
            value: preset?.[colorSpace] || "",
            active: !!(color && preset && preset[colorSpace] && id(preset[colorSpace] || "") === id(color[colorSpace])),
            onClick: () => preset && updateValue(preset.value || "")
          }
        )
      ))))
    },
    React.createElement(Swatch, { value: realValue, style: { margin: 4 } })
  ), React.createElement(
    Input,
    {
      id: getControlId(name),
      value,
      onChange: (e2) => updateValue(e2.target.value),
      onFocus: (e2) => e2.target.select(),
      readOnly: readonly,
      placeholder: "Choose color..."
    }
  ), value ? React.createElement(ToggleIcon, { onClick: cycleColorSpace }) : null);
}, "ColorControl");
var Color_default = ColorControl;
export {
  ColorControl,
  Color_default as default
};
