import { EventCallback, INode, INodeRef, NodeId } from "./types";
export declare const noop: () => void;
export declare const composeHandlers: (...handlers: EventCallback[]) => EventCallback;
export declare const difference: (a: Set<NodeId>, b: Set<NodeId>) => Set<NodeId>;
export declare const symmetricDifference: (a: Set<NodeId>, b: Set<NodeId>) => Set<NodeId>;
export declare const usePrevious: (x: Set<NodeId>) => Set<NodeId> | undefined;
export declare const usePreviousData: (value: INode[]) => INode<IFlatMetadata>[] | undefined;
export declare const isBranchNode: (data: INode[], i: NodeId) => boolean;
export declare const getBranchNodesToExpand: (data: INode[], id: NodeId) => NodeId[];
export declare const scrollToRef: (ref: INodeRef) => void;
export declare const focusRef: (ref: INodeRef) => void;
export declare const getParent: (data: INode[], id: NodeId) => NodeId | null;
export declare const getAncestors: (data: INode[], childId: NodeId, disabledIds: Set<NodeId>) => NodeId[];
export declare const getDescendants: (data: INode[], id: NodeId, disabledIds: Set<NodeId>) => NodeId[];
export declare const getChildren: (data: INode[], id: NodeId) => NodeId[];
export declare const getSibling: (data: INode[], id: NodeId, diff: number) => NodeId | null;
export declare const getLastAccessible: (data: INode[], id: NodeId, expandedIds: Set<NodeId>) => NodeId;
export declare const getPreviousAccessible: (data: INode[], id: NodeId, expandedIds: Set<NodeId>) => NodeId | null;
export declare const getNextAccessible: (data: INode[], id: NodeId, expandedIds: Set<NodeId>) => NodeId | null;
export declare const propagateSelectChange: (data: INode[], ids: Set<NodeId>, selectedIds: Set<NodeId>, disabledIds: Set<NodeId>, halfSelectedIds: Set<NodeId>, multiSelect?: boolean) => {
    every: Set<NodeId>;
    some: Set<NodeId>;
    none: Set<NodeId>;
};
export declare const getAccessibleRange: ({ data, expandedIds, from, to, }: {
    data: INode[];
    expandedIds: Set<NodeId>;
    from: NodeId;
    to: NodeId;
}) => NodeId[];
/**
 * This is to help consumers to understand that we do not currently support metadata that is a nested object. If this is needed, make an issue in Github
 */
export type IFlatMetadata = Record<string, string | number | boolean | undefined | null>;
interface ITreeNode<M extends IFlatMetadata = IFlatMetadata> {
    id?: NodeId;
    name: string;
    isBranch?: boolean;
    children?: ITreeNode<M>[];
    metadata?: M;
}
export declare const flattenTree: <M extends IFlatMetadata = IFlatMetadata>(tree: ITreeNode<M>) => INode<M>[];
export declare const getAriaSelected: ({ isSelected, isDisabled, multiSelect, }: {
    isSelected: boolean;
    isDisabled: boolean;
    multiSelect: boolean;
}) => boolean | undefined;
export declare const getAriaChecked: ({ isSelected, isDisabled, isHalfSelected, multiSelect, }: {
    isSelected: boolean;
    isDisabled: boolean;
    isHalfSelected: boolean;
    multiSelect: boolean;
}) => boolean | undefined | "mixed";
export declare const propagatedIds: (data: INode[], ids: NodeId[], disabledIds: Set<NodeId>) => NodeId[];
export declare const onComponentBlur: (event: React.FocusEvent, treeNode: HTMLUListElement | null, callback: () => void) => void;
export declare const isBranchSelectedAndHasSelectedDescendants: (data: INode[], elementId: NodeId, selectedIds: Set<NodeId>) => boolean;
export declare const isBranchSelectedAndHasAllSelectedEnabledDescendants: (data: INode[], elementId: NodeId, selectedIds: Set<NodeId>, disabledIds: Set<NodeId>) => boolean;
export declare const isBranchNotSelectedAndHasOnlySelectedChild: (data: INode[], elementId: NodeId, selectedIds: Set<NodeId>) => boolean;
export declare const isBranchSelectedAndHasOnlySelectedChild: (data: INode[], elementId: NodeId, selectedIds: Set<NodeId>) => boolean;
export declare const getOnSelectTreeAction: (data: INode[], elementId: NodeId, selectedIds: Set<NodeId>, disabledIds: Set<NodeId>) => "HALF_SELECT" | "TOGGLE_SELECT";
export declare const getTreeParent: <M extends IFlatMetadata = IFlatMetadata>(data: INode<M>[]) => INode<M>;
export declare const getTreeNode: <M extends IFlatMetadata = IFlatMetadata>(data: INode<M>[], id: NodeId) => INode<M>;
/**
 * We need to validate a tree data for
 * - duplicates
 * - node references to itself
 * - node has duplicated children
 * - no root node in a tree
 * - more then one root node in a tree
 * - to have nodes to display
 * */
export declare const validateTreeViewData: (data: INode[]) => void;
export {};
