import { NodeId } from "./types";
export type TreeViewAction = {
    type: "COLLAPSE";
    id: NodeId;
    lastInteractedWith?: NodeId | null;
} | {
    type: "COLLAPSE_MANY";
    ids: NodeId[];
    lastInteractedWith?: NodeId | null;
} | {
    type: "EXPAND";
    id: NodeId;
    lastInteractedWith?: NodeId | null;
} | {
    type: "EXPAND_MANY";
    ids: NodeId[];
    lastInteractedWith?: NodeId | null;
} | {
    type: "HALF_SELECT";
    id: NodeId;
    lastInteractedWith?: NodeId | null;
    lastManuallyToggled?: NodeId | null;
    keepFocus?: boolean;
    NotUserAction?: boolean;
} | {
    type: "SELECT";
    id: NodeId;
    multiSelect?: boolean;
    keepFocus?: boolean;
    NotUserAction?: boolean;
    lastInteractedWith?: NodeId | null;
    lastManuallyToggled?: NodeId | null;
} | {
    type: "DESELECT";
    id: NodeId;
    multiSelect?: boolean;
    keepFocus?: boolean;
    NotUserAction?: boolean;
    lastInteractedWith?: NodeId | null;
    lastManuallyToggled?: NodeId | null;
} | {
    type: "TOGGLE";
    id: NodeId;
    lastInteractedWith?: NodeId | null;
} | {
    type: "TOGGLE_SELECT";
    id: NodeId;
    multiSelect?: boolean;
    NotUserAction?: boolean;
    lastInteractedWith?: NodeId | null;
    lastManuallyToggled?: NodeId | null;
} | {
    type: "SELECT_MANY";
    ids: NodeId[];
    select?: boolean;
    multiSelect?: boolean;
    lastInteractedWith?: NodeId | null;
    lastManuallyToggled?: NodeId | null;
} | {
    type: "EXCLUSIVE_SELECT_MANY";
} | {
    type: "EXCLUSIVE_CHANGE_SELECT_MANY";
    ids: NodeId[];
    select?: boolean;
    multiSelect?: boolean;
    lastInteractedWith?: NodeId | null;
    lastManuallyToggled?: NodeId | null;
} | {
    type: "FOCUS";
    id: NodeId;
    lastInteractedWith?: NodeId | null;
} | {
    type: "CLEAR_FOCUS";
    id: NodeId;
} | {
    type: "BLUR";
} | {
    type: "DISABLE";
    id: NodeId;
} | {
    type: "ENABLE";
    id: NodeId;
} | {
    type: "CLEAR_MANUALLY_TOGGLED";
} | {
    type: "CONTROLLED_SELECT_MANY";
    ids: NodeId[];
    multiSelect?: boolean;
} | {
    type: "UPDATE_TREE_STATE_WHEN_DATA_CHANGED";
    tabbableId: NodeId;
    lastInteractedWith?: NodeId | null;
    lastManuallyToggled?: NodeId | null;
    lastUserSelect: NodeId;
};
export interface ITreeViewState {
    /** Set of the ids of the expanded nodes */
    expandedIds: Set<NodeId>;
    /** Set of the ids of the selected nodes */
    disabledIds: Set<NodeId>;
    /** Set of the ids of the selected nodes */
    halfSelectedIds: Set<NodeId>;
    /** Set of the ids of the selected nodes */
    selectedIds: Set<NodeId>;
    /** Set of the ids of the controlled selected nodes */
    controlledIds: Set<NodeId>;
    /** Id of the node with tabindex = 0 */
    tabbableId: NodeId;
    /** Whether the tree has focus */
    isFocused: boolean;
    /** Last selection made directly by the user */
    lastUserSelect: NodeId;
    /** Last node interacted with */
    lastInteractedWith?: NodeId | null;
    /** Last node manually selected/deselected */
    lastManuallyToggled?: NodeId | null;
    lastAction?: TreeViewAction["type"];
}
export declare const treeReducer: (state: ITreeViewState, action: TreeViewAction) => ITreeViewState;
