import React from "react";
import { ITreeViewState, TreeViewAction } from "./reducer";
import { ClickActions, INode, INodeRefs, INodeRendererProps, NodeAction, NodeId } from "./types";
import { IFlatMetadata } from "./utils";
import { baseClassNames } from "./constants";
export interface INodeProps<M extends IFlatMetadata = IFlatMetadata> {
    element: INode<M>;
    dispatch: React.Dispatch<TreeViewAction>;
    data: INode<M>[];
    nodeAction: NodeAction;
    selectedIds: Set<NodeId>;
    tabbableId: NodeId;
    isFocused: boolean;
    expandedIds: Set<NodeId>;
    disabledIds: Set<NodeId>;
    halfSelectedIds: Set<NodeId>;
    lastUserSelect: NodeId;
    nodeRefs: INodeRefs;
    leafRefs: INodeRefs;
    baseClassNames: typeof baseClassNames;
    nodeRenderer: (props: INodeRendererProps<M>) => React.ReactNode;
    setsize: number;
    posinset: number;
    level: number;
    propagateCollapse: boolean;
    propagateSelect: boolean;
    multiSelect: boolean;
    togglableSelect: boolean;
    clickAction?: ClickActions;
    state: ITreeViewState;
    propagateSelectUpwards: boolean;
}
export interface INodeGroupProps<M extends IFlatMetadata = IFlatMetadata> extends Omit<INodeProps<M>, "setsize" | "posinset"> {
    getClasses: (className: string) => string;
    /** don't send this. The NodeGroup render function, determines it for you */
    setsize?: undefined;
    /** don't send this. The NodeGroup render function, determines it for you */
    posinset?: undefined;
}
export declare const Node: <M extends IFlatMetadata = IFlatMetadata>(props: INodeProps<M>) => JSX.Element;
export declare const NodeGroup: <M extends IFlatMetadata = IFlatMetadata>({ data, element, expandedIds, getClasses, baseClassNames, level, ...rest }: INodeGroupProps<M>) => JSX.Element;
