import React from "react";
import { ITreeViewState, TreeViewAction } from "./reducer";
import { ClickActions, INode, INodeRendererProps, NodeAction, NodeId } from "./types";
import { IFlatMetadata } from "./utils";
export interface ITreeViewOnSelectProps {
    element: INode;
    isBranch: boolean;
    isExpanded: boolean;
    isSelected: boolean;
    isHalfSelected: boolean;
    isDisabled: boolean;
    treeState: ITreeViewState;
}
export interface ITreeViewOnNodeSelectProps {
    element: INode;
    isSelected: boolean;
    isBranch: boolean;
    treeState?: ITreeViewState;
}
export interface ITreeViewOnExpandProps {
    element: INode;
    isExpanded: boolean;
    isSelected: boolean;
    isHalfSelected: boolean;
    isDisabled: boolean;
    treeState: ITreeViewState;
}
export interface ITreeViewOnLoadDataProps {
    element: INode;
    isExpanded: boolean;
    isSelected: boolean;
    isHalfSelected: boolean;
    isDisabled: boolean;
    treeState: ITreeViewState;
}
export interface ITreeViewProps<M extends IFlatMetadata = IFlatMetadata> {
    /** Tree data*/
    data: INode<M>[];
    /** Function called when a node changes its selected state */
    onSelect?: (props: ITreeViewOnSelectProps) => void;
    /** Function called when a single node is manually selected/unselected. */
    onNodeSelect?: (props: ITreeViewOnNodeSelectProps) => void;
    /** Function called when a node changes its expanded state */
    onExpand?: (props: ITreeViewOnExpandProps) => void;
    /** Function called to load data asynchronously on expand */
    onLoadData?: (props: ITreeViewOnLoadDataProps) => Promise<any>;
    /** className to add to the outermost ul */
    className?: string;
    /** Render prop for the node */
    nodeRenderer: (props: INodeRendererProps<M>) => React.ReactNode;
    /** Indicates what action will be performed on a node which informs the correct aria-* properties to use on the node (aria-checked if using checkboxes, aria-selected if not). */
    nodeAction?: NodeAction;
    /** Array with the ids of the default expanded nodes */
    defaultExpandedIds?: NodeId[];
    /** Array with the ids of the default selected nodes */
    defaultSelectedIds?: NodeId[];
    /** Array with the ids of controlled expanded nodes */
    expandedIds?: NodeId[];
    /** Array with the ids of controlled selected nodes */
    selectedIds?: NodeId[];
    /** Array with the ids of the default disabled nodes */
    defaultDisabledIds?: NodeId[];
    /** If true, collapsing a node will also collapse its descendants */
    propagateCollapse?: boolean;
    /** If true, selecting a node will also select its descendants */
    propagateSelect?: boolean;
    /** If true, selecting a node will update the state of its parent (e.g. a parent node in a checkbox will be automatically selected if all of its children are selected) */
    propagateSelectUpwards?: boolean;
    /** Allows multiple nodes to be selected */
    multiSelect?: boolean;
    /** Selecting a node with a keyboard (using Space or Enter) will also toggle its expanded state */
    expandOnKeyboardSelect?: boolean;
    /** Wether the selected state is togglable */
    togglableSelect?: boolean;
    /** action to perform on click */
    clickAction?: ClickActions;
    /** Custom onBlur event that is triggered when focusing out of the component as a whole (moving focus between the nodes won't trigger it) */
    onBlur?: (event: {
        treeState: ITreeViewState;
        dispatch: React.Dispatch<TreeViewAction>;
    }) => void;
    /** Id of the node to focus */
    focusedId?: NodeId;
}
declare const TreeView: React.ForwardRefExoticComponent<ITreeViewProps<IFlatMetadata> & React.RefAttributes<HTMLUListElement>>;
export default TreeView;
