"use strict";

var _loglevelColoredLevelPrefix = _interopRequireDefault(require("loglevel-colored-level-prefix"));
var _uncaughtExceptionHandler = _interopRequireDefault(require("./uncaught-exception-handler"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
jest.mock('loglevel-colored-level-prefix', () => {
  const logger = {};
  const __mock__ = {
    logger,
    level: 4,
    resetAll
  };
  const getLogger = jest.fn(() => resetAll());
  getLogger.__mock__ = __mock__;
  return getLogger;
  function resetAll() {
    getLogger.mockClear();
    Object.assign(logger, {
      getLevel: jest.fn(() => getLogger.__mock__.level),
      trace: jest.fn(),
      debug: jest.fn(),
      info: jest.fn(),
      warn: jest.fn(),
      error: jest.fn()
    });
    return logger;
  }
});
beforeEach(() => {
  _loglevelColoredLevelPrefix.default.__mock__.resetAll();
});
test('logs all options', () => {
  const logger = (0, _loglevelColoredLevelPrefix.default)();
  runWithCatch(new Error('my error'));
  expect(logger.error).toHaveBeenCalledTimes(1);
  const errorLog = logger.error.mock.calls[0].join(' ');
  expect(errorLog).toMatchSnapshot();
});
test('logs a check for trace', () => {
  _loglevelColoredLevelPrefix.default.__mock__.level = 0;
  const logger = (0, _loglevelColoredLevelPrefix.default)();
  runWithCatch(new Error('my error'));
  expect(logger.error).toHaveBeenCalledTimes(1);
  const errorLog = logger.error.mock.calls[0].join(' ');
  expect(errorLog).toContain('✅');
  expect(errorLog).toMatchSnapshot();
});
test('re-throws the given error', () => {
  const myError = new Error('my error');
  expect(() => (0, _uncaughtExceptionHandler.default)(myError)).toThrow(myError);
});
function runWithCatch(...args) {
  try {
    (0, _uncaughtExceptionHandler.default)(...args);
  } catch (e) {
    // ignore
  }
}