import CJS_COMPAT_NODE_URL_kskacf63vmi from 'node:url';
import CJS_COMPAT_NODE_PATH_kskacf63vmi from 'node:path';
import CJS_COMPAT_NODE_MODULE_kskacf63vmi from "node:module";

var __filename = CJS_COMPAT_NODE_URL_kskacf63vmi.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_kskacf63vmi.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_kskacf63vmi.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// ../../node_modules/ts-dedent/dist/index.js
var require_dist = __commonJS({
  "../../node_modules/ts-dedent/dist/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.dedent = void 0;
    function dedent2(templ) {
      var values = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        values[_i - 1] = arguments[_i];
      }
      var strings = Array.from(typeof templ === "string" ? [templ] : templ);
      strings[strings.length - 1] = strings[strings.length - 1].replace(/\r?\n([\t ]*)$/, "");
      var indentLengths = strings.reduce(function(arr, str) {
        var matches = str.match(/\n([\t ]+|(?!\s).)/g);
        if (matches) {
          return arr.concat(matches.map(function(match) {
            var _a, _b;
            return (_b = (_a = match.match(/[\t ]/g)) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0;
          }));
        }
        return arr;
      }, []);
      if (indentLengths.length) {
        var pattern_1 = new RegExp("\n[	 ]{" + Math.min.apply(Math, indentLengths) + "}", "g");
        strings = strings.map(function(str) {
          return str.replace(pattern_1, "\n");
        });
      }
      strings[0] = strings[0].replace(/^\r?\n/, "");
      var string = strings[0];
      values.forEach(function(value, i) {
        var endentations = string.match(/(?:^|\n)( *)$/);
        var endentation = endentations ? endentations[1] : "";
        var indentedValue = value;
        if (typeof value === "string" && value.includes("\n")) {
          indentedValue = String(value).split("\n").map(function(str, i2) {
            return i2 === 0 ? str : "" + endentation + str;
          }).join("\n");
        }
        string += indentedValue + strings[i + 1];
      });
      return string;
    }
    __name(dedent2, "dedent");
    exports.dedent = dedent2;
    exports.default = dedent2;
  }
});

// src/configs/addon-interactions.ts
var addon_interactions_default = {
  plugins: ["storybook"],
  overrides: [
    {
      files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
      rules: {
        "react-hooks/rules-of-hooks": "off",
        "import/no-anonymous-default-export": "off",
        "storybook/await-interactions": "error",
        "storybook/context-in-play-function": "error",
        "storybook/use-storybook-expect": "error",
        "storybook/use-storybook-testing-library": "error"
      }
    },
    {
      files: [".storybook/main.@(js|cjs|mjs|ts)"],
      rules: {
        "storybook/no-uninstalled-addons": "error"
      }
    }
  ]
};

// src/configs/csf.ts
var csf_default = {
  plugins: ["storybook"],
  overrides: [
    {
      files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
      rules: {
        "react-hooks/rules-of-hooks": "off",
        "import/no-anonymous-default-export": "off",
        "storybook/csf-component": "warn",
        "storybook/default-exports": "error",
        "storybook/hierarchy-separator": "warn",
        "storybook/no-redundant-story-name": "warn",
        "storybook/story-exports": "error"
      }
    },
    {
      files: [".storybook/main.@(js|cjs|mjs|ts)"],
      rules: {
        "storybook/no-uninstalled-addons": "error"
      }
    }
  ]
};

// src/configs/csf-strict.ts
var csf_strict_default = {
  // This file is bundled in an index.js file at the root
  // so the reference is relative to the src directory
  extends: "./configs/csf",
  overrides: [
    {
      files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
      rules: {
        "react-hooks/rules-of-hooks": "off",
        "import/no-anonymous-default-export": "off",
        "storybook/no-stories-of": "error",
        "storybook/no-title-property-in-meta": "error"
      }
    }
  ]
};

// src/configs/flat/addon-interactions.ts
var addon_interactions_default2 = [
  {
    name: "storybook:addon-interactions:setup",
    plugins: {
      get storybook() {
        return index_default;
      }
    }
  },
  {
    name: "storybook:addon-interactions:stories-rules",
    files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
    rules: {
      "react-hooks/rules-of-hooks": "off",
      "import/no-anonymous-default-export": "off",
      "storybook/await-interactions": "error",
      "storybook/context-in-play-function": "error",
      "storybook/use-storybook-expect": "error",
      "storybook/use-storybook-testing-library": "error"
    }
  },
  {
    name: "storybook:addon-interactions:main-rules",
    files: [".storybook/main.@(js|cjs|mjs|ts)"],
    rules: {
      "storybook/no-uninstalled-addons": "error"
    }
  }
];

// src/configs/flat/csf.ts
var csf_default2 = [
  {
    name: "storybook:csf:setup",
    plugins: {
      get storybook() {
        return index_default;
      }
    }
  },
  {
    name: "storybook:csf:stories-rules",
    files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
    rules: {
      "react-hooks/rules-of-hooks": "off",
      "import/no-anonymous-default-export": "off",
      "storybook/csf-component": "warn",
      "storybook/default-exports": "error",
      "storybook/hierarchy-separator": "warn",
      "storybook/no-redundant-story-name": "warn",
      "storybook/story-exports": "error"
    }
  },
  {
    name: "storybook:csf:main-rules",
    files: [".storybook/main.@(js|cjs|mjs|ts)"],
    rules: {
      "storybook/no-uninstalled-addons": "error"
    }
  }
];

// src/configs/flat/csf-strict.ts
var csf_strict_default2 = [
  ...csf_default2,
  {
    name: "storybook:csf-strict:rules",
    files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
    rules: {
      "react-hooks/rules-of-hooks": "off",
      "import/no-anonymous-default-export": "off",
      "storybook/no-stories-of": "error",
      "storybook/no-title-property-in-meta": "error"
    }
  }
];

// src/configs/flat/recommended.ts
var recommended_default = [
  {
    name: "storybook:recommended:setup",
    plugins: {
      get storybook() {
        return index_default;
      }
    }
  },
  {
    name: "storybook:recommended:stories-rules",
    files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
    rules: {
      "react-hooks/rules-of-hooks": "off",
      "import/no-anonymous-default-export": "off",
      "storybook/await-interactions": "error",
      "storybook/context-in-play-function": "error",
      "storybook/default-exports": "error",
      "storybook/hierarchy-separator": "warn",
      "storybook/no-redundant-story-name": "warn",
      "storybook/no-renderer-packages": "error",
      "storybook/prefer-pascal-case": "warn",
      "storybook/story-exports": "error",
      "storybook/use-storybook-expect": "error",
      "storybook/use-storybook-testing-library": "error"
    }
  },
  {
    name: "storybook:recommended:main-rules",
    files: [".storybook/main.@(js|cjs|mjs|ts)"],
    rules: {
      "storybook/no-uninstalled-addons": "error"
    }
  }
];

// src/configs/recommended.ts
var recommended_default2 = {
  plugins: ["storybook"],
  overrides: [
    {
      files: ["**/*.stories.@(ts|tsx|js|jsx|mjs|cjs)", "**/*.story.@(ts|tsx|js|jsx|mjs|cjs)"],
      rules: {
        "react-hooks/rules-of-hooks": "off",
        "import/no-anonymous-default-export": "off",
        "storybook/await-interactions": "error",
        "storybook/context-in-play-function": "error",
        "storybook/default-exports": "error",
        "storybook/hierarchy-separator": "warn",
        "storybook/no-redundant-story-name": "warn",
        "storybook/no-renderer-packages": "error",
        "storybook/prefer-pascal-case": "warn",
        "storybook/story-exports": "error",
        "storybook/use-storybook-expect": "error",
        "storybook/use-storybook-testing-library": "error"
      }
    },
    {
      files: [".storybook/main.@(js|cjs|mjs|ts)"],
      rules: {
        "storybook/no-uninstalled-addons": "error"
      }
    }
  ]
};

// src/utils/ast.ts
import { AST_NODE_TYPES } from "@typescript-eslint/utils";
import { ASTUtils } from "@typescript-eslint/utils";
var isNodeOfType = /* @__PURE__ */ __name((nodeType) => (node) => node?.type === nodeType, "isNodeOfType");
var isAwaitExpression = isNodeOfType(AST_NODE_TYPES.AwaitExpression);
var isIdentifier = isNodeOfType(AST_NODE_TYPES.Identifier);
var isVariableDeclarator = isNodeOfType(AST_NODE_TYPES.VariableDeclarator);
var isArrayExpression = isNodeOfType(AST_NODE_TYPES.ArrayExpression);
var isArrowFunctionExpression = isNodeOfType(AST_NODE_TYPES.ArrowFunctionExpression);
var isBlockStatement = isNodeOfType(AST_NODE_TYPES.BlockStatement);
var isCallExpression = isNodeOfType(AST_NODE_TYPES.CallExpression);
var isExpressionStatement = isNodeOfType(AST_NODE_TYPES.ExpressionStatement);
var isVariableDeclaration = isNodeOfType(AST_NODE_TYPES.VariableDeclaration);
var isAssignmentExpression = isNodeOfType(AST_NODE_TYPES.AssignmentExpression);
var isSequenceExpression = isNodeOfType(AST_NODE_TYPES.SequenceExpression);
var isImportDeclaration = isNodeOfType(AST_NODE_TYPES.ImportDeclaration);
var isImportDefaultSpecifier = isNodeOfType(AST_NODE_TYPES.ImportDefaultSpecifier);
var isImportNamespaceSpecifier = isNodeOfType(AST_NODE_TYPES.ImportNamespaceSpecifier);
var isImportSpecifier = isNodeOfType(AST_NODE_TYPES.ImportSpecifier);
var isJSXAttribute = isNodeOfType(AST_NODE_TYPES.JSXAttribute);
var isLiteral = isNodeOfType(AST_NODE_TYPES.Literal);
var isMemberExpression = isNodeOfType(AST_NODE_TYPES.MemberExpression);
var isNewExpression = isNodeOfType(AST_NODE_TYPES.NewExpression);
var isObjectExpression = isNodeOfType(AST_NODE_TYPES.ObjectExpression);
var isObjectPattern = isNodeOfType(AST_NODE_TYPES.ObjectPattern);
var isProperty = isNodeOfType(AST_NODE_TYPES.Property);
var isSpreadElement = isNodeOfType(AST_NODE_TYPES.SpreadElement);
var isRestElement = isNodeOfType(AST_NODE_TYPES.RestElement);
var isReturnStatement = isNodeOfType(AST_NODE_TYPES.ReturnStatement);
var isFunctionDeclaration = isNodeOfType(AST_NODE_TYPES.FunctionDeclaration);
var isFunctionExpression = isNodeOfType(AST_NODE_TYPES.FunctionExpression);
var isProgram = isNodeOfType(AST_NODE_TYPES.Program);
var isTSTypeAliasDeclaration = isNodeOfType(AST_NODE_TYPES.TSTypeAliasDeclaration);
var isTSInterfaceDeclaration = isNodeOfType(AST_NODE_TYPES.TSInterfaceDeclaration);
var isTSAsExpression = isNodeOfType(AST_NODE_TYPES.TSAsExpression);
var isTSSatisfiesExpression = isNodeOfType(AST_NODE_TYPES.TSSatisfiesExpression);
var isTSNonNullExpression = isNodeOfType(AST_NODE_TYPES.TSNonNullExpression);
var isMetaProperty = isNodeOfType(AST_NODE_TYPES.MetaProperty);

// src/utils/create-storybook-rule.ts
import { ESLintUtils } from "@typescript-eslint/utils";

// src/utils/index.ts
import { isExportStory } from "storybook/internal/csf";
import { ASTUtils as ASTUtils2 } from "@typescript-eslint/utils";
var docsUrl = /* @__PURE__ */ __name((ruleName) => `https://github.com/storybookjs/storybook/blob/next/code/lib/eslint-plugin/docs/rules/${ruleName}.md`, "docsUrl");
var getMetaObjectExpression = /* @__PURE__ */ __name((node, context) => {
  let meta = node.declaration;
  const { sourceCode } = context;
  if (isIdentifier(meta)) {
    const scope = sourceCode.getScope ? sourceCode.getScope(node) : context.getScope();
    const variable = ASTUtils2.findVariable(scope, meta.name);
    const decl = variable && variable.defs.find((def) => isVariableDeclarator(def.node));
    if (decl && isVariableDeclarator(decl.node)) {
      meta = decl.node.init;
    }
  }
  if (isTSAsExpression(meta) || isTSSatisfiesExpression(meta)) {
    meta = meta.expression;
  }
  return isObjectExpression(meta) ? meta : null;
}, "getMetaObjectExpression");
var getDescriptor = /* @__PURE__ */ __name((metaDeclaration, propertyName) => {
  const property = metaDeclaration && metaDeclaration.properties.find(
    (p) => "key" in p && "name" in p.key && p.key.name === propertyName
  );
  if (!property || isSpreadElement(property)) {
    return void 0;
  }
  const { type } = property.value;
  switch (type) {
    case "ArrayExpression":
      return property.value.elements.map((t) => {
        if (t === null) {
          throw new Error(`Unexpected descriptor element: null`);
        }
        if (!["StringLiteral", "Literal"].includes(t.type)) {
          throw new Error(`Unexpected descriptor element: ${t.type}`);
        }
        return t.value;
      });
    case "Literal":
    // @ts-expect-error TODO: Investigation needed. Type systems says, that "RegExpLiteral" does not exist
    case "RegExpLiteral":
      return property.value.value;
    default:
      throw new Error(`Unexpected descriptor: ${type}`);
  }
}, "getDescriptor");
var isValidStoryExport = /* @__PURE__ */ __name((node, nonStoryExportsConfig) => isExportStory(node.name, nonStoryExportsConfig) && node.name !== "__namedExportsOrder", "isValidStoryExport");
var getAllNamedExports = /* @__PURE__ */ __name((node) => {
  if (!node.declaration && node.specifiers) {
    return node.specifiers.reduce((acc, specifier) => {
      if (isIdentifier(specifier.exported)) {
        acc.push(specifier.exported);
      }
      return acc;
    }, []);
  }
  const decl = node.declaration;
  if (isVariableDeclaration(decl)) {
    const declaration = decl.declarations[0];
    if (declaration) {
      const { id } = declaration;
      if (isIdentifier(id)) {
        return [id];
      }
    }
  }
  if (isFunctionDeclaration(decl)) {
    if (isIdentifier(decl.id)) {
      return [decl.id];
    }
  }
  return [];
}, "getAllNamedExports");

// src/utils/create-storybook-rule.ts
function createStorybookRule({
  create,
  meta,
  ...remainingConfig
}) {
  const ruleCreator = ESLintUtils.RuleCreator(docsUrl);
  return ruleCreator({
    ...remainingConfig,
    create,
    meta: {
      ...meta,
      docs: {
        ...meta.docs
      },
      defaultOptions: remainingConfig.defaultOptions
    }
  });
}
__name(createStorybookRule, "createStorybookRule");

// src/rules/await-interactions.ts
var await_interactions_default = createStorybookRule({
  name: "await-interactions",
  defaultOptions: [],
  meta: {
    severity: "error",
    docs: {
      description: "Interactions should be awaited",
      categories: ["addon-interactions" /* ADDON_INTERACTIONS */, "recommended" /* RECOMMENDED */]
    },
    messages: {
      interactionShouldBeAwaited: "Interaction should be awaited: {{method}}",
      fixSuggestion: "Add `await` to method"
    },
    type: "problem",
    fixable: "code",
    hasSuggestions: true,
    schema: []
  },
  create(context) {
    const FUNCTIONS_TO_BE_AWAITED = [
      "waitFor",
      "waitForElementToBeRemoved",
      "wait",
      "waitForElement",
      "waitForDomChange",
      "userEvent",
      "play"
    ];
    const getMethodThatShouldBeAwaited = /* @__PURE__ */ __name((expr) => {
      const shouldAwait = /* @__PURE__ */ __name((name) => {
        return FUNCTIONS_TO_BE_AWAITED.includes(name) || name.startsWith("findBy");
      }, "shouldAwait");
      if (isArrowFunctionExpression(expr.parent) || isReturnStatement(expr.parent)) {
        return null;
      }
      if (isMemberExpression(expr.callee) && isIdentifier(expr.callee.object) && shouldAwait(expr.callee.object.name)) {
        return expr.callee.object;
      }
      if (isTSNonNullExpression(expr.callee) && isMemberExpression(expr.callee.expression) && isIdentifier(expr.callee.expression.property) && shouldAwait(expr.callee.expression.property.name)) {
        return expr.callee.expression.property;
      }
      if (isMemberExpression(expr.callee) && isIdentifier(expr.callee.property) && shouldAwait(expr.callee.property.name)) {
        return expr.callee.property;
      }
      if (isMemberExpression(expr.callee) && isCallExpression(expr.callee.object) && isIdentifier(expr.callee.object.callee) && isIdentifier(expr.callee.property) && expr.callee.object.callee.name === "expect") {
        return expr.callee.property;
      }
      if (isIdentifier(expr.callee) && shouldAwait(expr.callee.name)) {
        return expr.callee;
      }
      return null;
    }, "getMethodThatShouldBeAwaited");
    const getClosestFunctionAncestor = /* @__PURE__ */ __name((node) => {
      const parent = node.parent;
      if (!parent || isProgram(parent)) {
        return void 0;
      }
      if (isArrowFunctionExpression(parent) || isFunctionExpression(parent) || isFunctionDeclaration(parent)) {
        return node.parent;
      }
      return getClosestFunctionAncestor(parent);
    }, "getClosestFunctionAncestor");
    const isUserEventFromStorybookImported = /* @__PURE__ */ __name((node) => {
      return (node.source.value === "@storybook/testing-library" || node.source.value === "@storybook/test") && node.specifiers.find(
        (spec) => isImportSpecifier(spec) && "name" in spec.imported && spec.imported.name === "userEvent" && spec.local.name === "userEvent"
      ) !== void 0;
    }, "isUserEventFromStorybookImported");
    const isExpectFromStorybookImported = /* @__PURE__ */ __name((node) => {
      return (node.source.value === "@storybook/jest" || node.source.value === "@storybook/test") && node.specifiers.find(
        (spec) => isImportSpecifier(spec) && "name" in spec.imported && spec.imported.name === "expect"
      ) !== void 0;
    }, "isExpectFromStorybookImported");
    let isImportedFromStorybook = true;
    const invocationsThatShouldBeAwaited = [];
    return {
      ImportDeclaration(node) {
        isImportedFromStorybook = isUserEventFromStorybookImported(node) || isExpectFromStorybookImported(node);
      },
      VariableDeclarator(node) {
        isImportedFromStorybook = isImportedFromStorybook && isIdentifier(node.id) && node.id.name !== "userEvent";
      },
      CallExpression(node) {
        const method = getMethodThatShouldBeAwaited(node);
        if (method && !isAwaitExpression(node.parent) && !isAwaitExpression(node.parent?.parent)) {
          invocationsThatShouldBeAwaited.push({ node, method });
        }
      },
      "Program:exit": /* @__PURE__ */ __name(function() {
        if (isImportedFromStorybook && invocationsThatShouldBeAwaited.length) {
          invocationsThatShouldBeAwaited.forEach(({ node, method }) => {
            const parentFnNode = getClosestFunctionAncestor(node);
            const parentFnNeedsAsync = parentFnNode && !("async" in parentFnNode && parentFnNode.async);
            const fixFn = /* @__PURE__ */ __name((fixer) => {
              const fixerResult = [fixer.insertTextBefore(node, "await ")];
              if (parentFnNeedsAsync) {
                fixerResult.push(fixer.insertTextBefore(parentFnNode, "async "));
              }
              return fixerResult;
            }, "fixFn");
            context.report({
              node,
              messageId: "interactionShouldBeAwaited",
              data: {
                method: method.name
              },
              fix: fixFn,
              suggest: [
                {
                  messageId: "fixSuggestion",
                  fix: fixFn
                }
              ]
            });
          });
        }
      }, "Program:exit")
    };
  }
});

// src/rules/context-in-play-function.ts
var context_in_play_function_default = createStorybookRule({
  name: "context-in-play-function",
  defaultOptions: [],
  meta: {
    type: "problem",
    severity: "error",
    docs: {
      description: "Pass a context when invoking play function of another story",
      categories: ["recommended" /* RECOMMENDED */, "addon-interactions" /* ADDON_INTERACTIONS */]
    },
    messages: {
      passContextToPlayFunction: "Pass a context when invoking play function of another story"
    },
    fixable: void 0,
    schema: []
  },
  create(context) {
    const isPlayFunctionFromAnotherStory = /* @__PURE__ */ __name((expr) => {
      if (isTSNonNullExpression(expr.callee) && isMemberExpression(expr.callee.expression) && isIdentifier(expr.callee.expression.property) && expr.callee.expression.property.name === "play") {
        return true;
      }
      if (isMemberExpression(expr.callee) && isIdentifier(expr.callee.property) && expr.callee.property.name === "play") {
        return true;
      }
      return false;
    }, "isPlayFunctionFromAnotherStory");
    const getParentParameterName = /* @__PURE__ */ __name((node) => {
      if (!isArrowFunctionExpression(node)) {
        if (!node.parent) {
          return void 0;
        }
        return getParentParameterName(node.parent);
      }
      if (node.params.length === 0) {
        return void 0;
      }
      if (node.params.length >= 1) {
        const param = node.params[0];
        if (isIdentifier(param)) {
          return param.name;
        }
        if (isObjectPattern(param)) {
          if (param.properties.find((prop) => {
            return prop.type === "Property" && prop.key.type === "Identifier" && prop.key.name === "context";
          })) {
            return "context";
          }
          const restElement = param.properties.find(isRestElement);
          if (!restElement || !isIdentifier(restElement.argument)) {
            return void 0;
          }
          return restElement.argument.name;
        }
      }
      return void 0;
    }, "getParentParameterName");
    const isNotPassingContextCorrectly = /* @__PURE__ */ __name((expr) => {
      const firstExpressionArgument = expr.arguments[0];
      if (!firstExpressionArgument) {
        return true;
      }
      const contextVariableName = getParentParameterName(expr);
      if (!contextVariableName) {
        return true;
      }
      if (expr.arguments.length === 1 && isIdentifier(firstExpressionArgument) && firstExpressionArgument.name === contextVariableName) {
        return false;
      }
      if (isObjectExpression(firstExpressionArgument) && firstExpressionArgument.properties.some((prop) => {
        return isSpreadElement(prop) && isIdentifier(prop.argument) && prop.argument.name === contextVariableName;
      })) {
        return false;
      }
      return true;
    }, "isNotPassingContextCorrectly");
    const invocationsWithoutProperContext = [];
    return {
      CallExpression(node) {
        if (isPlayFunctionFromAnotherStory(node) && isNotPassingContextCorrectly(node)) {
          invocationsWithoutProperContext.push(node);
        }
      },
      "Program:exit": /* @__PURE__ */ __name(function() {
        invocationsWithoutProperContext.forEach((node) => {
          context.report({
            node,
            messageId: "passContextToPlayFunction"
          });
        });
      }, "Program:exit")
    };
  }
});

// src/rules/csf-component.ts
var csf_component_default = createStorybookRule({
  name: "csf-component",
  defaultOptions: [],
  meta: {
    type: "suggestion",
    severity: "warn",
    docs: {
      description: "The component property should be set",
      categories: ["csf" /* CSF */]
    },
    messages: {
      missingComponentProperty: "Missing component property."
    },
    schema: []
  },
  create(context) {
    return {
      ExportDefaultDeclaration(node) {
        const meta = getMetaObjectExpression(node, context);
        if (!meta) {
          return null;
        }
        const componentProperty = meta.properties.find(
          (property) => !isSpreadElement(property) && "name" in property.key && property.key.name === "component"
        );
        if (!componentProperty) {
          context.report({
            node,
            messageId: "missingComponentProperty"
          });
        }
      }
    };
  }
});

// src/rules/default-exports.ts
import path from "path";
var default_exports_default = createStorybookRule({
  name: "default-exports",
  defaultOptions: [],
  meta: {
    type: "problem",
    severity: "error",
    docs: {
      description: "Story files should have a default export",
      categories: ["csf" /* CSF */, "recommended" /* RECOMMENDED */]
    },
    messages: {
      shouldHaveDefaultExport: "The file should have a default export.",
      fixSuggestion: "Add default export"
    },
    fixable: "code",
    hasSuggestions: true,
    schema: []
  },
  create(context) {
    const getComponentName = /* @__PURE__ */ __name((node, filePath) => {
      const name = path.basename(filePath).split(".")[0];
      const imported = node.body.find((stmt) => {
        if (isImportDeclaration(stmt) && isLiteral(stmt.source) && stmt.source.value.startsWith(`./${name}`)) {
          return !!stmt.specifiers.find(
            (spec) => isIdentifier(spec.local) && spec.local.name === name
          );
        }
      });
      return imported ? name : null;
    }, "getComponentName");
    let hasDefaultExport = false;
    let isCsf4Style = false;
    let hasStoriesOfImport = false;
    return {
      ImportSpecifier(node) {
        if ("name" in node.imported && node.imported.name === "storiesOf") {
          hasStoriesOfImport = true;
        }
      },
      VariableDeclaration(node) {
        if (node.parent.type === "Program") {
          node.declarations.forEach((declaration) => {
            const init = declaration.init;
            if (init && init.type === "CallExpression") {
              const callee = init.callee;
              if (callee.type === "MemberExpression" && callee.property.type === "Identifier" && callee.property.name === "meta") {
                isCsf4Style = true;
              }
            }
          });
        }
      },
      ExportDefaultSpecifier: /* @__PURE__ */ __name(function() {
        hasDefaultExport = true;
      }, "ExportDefaultSpecifier"),
      ExportDefaultDeclaration: /* @__PURE__ */ __name(function() {
        hasDefaultExport = true;
      }, "ExportDefaultDeclaration"),
      "Program:exit": /* @__PURE__ */ __name(function(program) {
        if (!isCsf4Style && !hasDefaultExport && !hasStoriesOfImport) {
          const componentName = getComponentName(program, context.getFilename());
          const firstNonImportStatement = program.body.find((n) => !isImportDeclaration(n));
          const node = firstNonImportStatement || program.body[0] || program;
          const report = {
            node,
            messageId: "shouldHaveDefaultExport"
          };
          const fix = /* @__PURE__ */ __name((fixer) => {
            const metaDeclaration = componentName ? `export default { component: ${componentName} }
` : "export default {}\n";
            return fixer.insertTextBefore(node, metaDeclaration);
          }, "fix");
          context.report({
            ...report,
            fix,
            suggest: [
              {
                messageId: "fixSuggestion",
                fix
              }
            ]
          });
        }
      }, "Program:exit")
    };
  }
});

// src/rules/hierarchy-separator.ts
var hierarchy_separator_default = createStorybookRule({
  name: "hierarchy-separator",
  defaultOptions: [],
  meta: {
    type: "problem",
    fixable: "code",
    hasSuggestions: true,
    severity: "warn",
    docs: {
      description: "Deprecated hierarchy separator in title property",
      categories: ["csf" /* CSF */, "recommended" /* RECOMMENDED */]
    },
    messages: {
      useCorrectSeparators: "Use correct separators",
      deprecatedHierarchySeparator: "Deprecated hierarchy separator in title property: {{metaTitle}}."
    },
    schema: []
  },
  create: /* @__PURE__ */ __name(function(context) {
    return {
      ExportDefaultDeclaration: /* @__PURE__ */ __name(function(node) {
        const meta = getMetaObjectExpression(node, context);
        if (!meta) {
          return null;
        }
        const titleNode = meta.properties.find(
          (prop) => !isSpreadElement(prop) && "name" in prop.key && prop.key?.name === "title"
        );
        if (!titleNode || !isLiteral(titleNode.value)) {
          return;
        }
        const metaTitle = titleNode.value.raw || "";
        if (metaTitle.includes("|")) {
          context.report({
            node: titleNode,
            messageId: "deprecatedHierarchySeparator",
            data: { metaTitle },
            // In case we want this to be auto fixed by --fix
            fix: /* @__PURE__ */ __name(function(fixer) {
              return fixer.replaceTextRange(titleNode.value.range, metaTitle.replace(/\|/g, "/"));
            }, "fix"),
            suggest: [
              {
                messageId: "useCorrectSeparators",
                fix: /* @__PURE__ */ __name(function(fixer) {
                  return fixer.replaceTextRange(
                    titleNode.value.range,
                    metaTitle.replace(/\|/g, "/")
                  );
                }, "fix")
              }
            ]
          });
        }
      }, "ExportDefaultDeclaration")
    };
  }, "create")
});

// src/rules/meta-inline-properties.ts
var meta_inline_properties_default = createStorybookRule({
  name: "meta-inline-properties",
  defaultOptions: [{ csfVersion: 3 }],
  meta: {
    type: "problem",
    severity: "error",
    docs: {
      description: "Meta should only have inline properties",
      categories: ["csf" /* CSF */, "recommended" /* RECOMMENDED */],
      excludeFromConfig: true
    },
    messages: {
      metaShouldHaveInlineProperties: "Meta should only have inline properties: {{property}}"
    },
    schema: [
      {
        type: "object",
        properties: {
          csfVersion: {
            type: "number"
          }
        },
        additionalProperties: false
      }
    ]
  },
  create(context) {
    const isInline = /* @__PURE__ */ __name((node) => {
      if (!(node && typeof node === "object" && "value" in node)) {
        return false;
      }
      return node.value.type === "ObjectExpression" || node.value.type === "Literal" || node.value.type === "ArrayExpression";
    }, "isInline");
    return {
      ExportDefaultDeclaration(node) {
        const meta = getMetaObjectExpression(node, context);
        if (!meta) {
          return null;
        }
        const ruleProperties = ["title", "args"];
        const dynamicProperties = [];
        const metaNodes = meta.properties.filter(
          (prop) => "key" in prop && "name" in prop.key && ruleProperties.includes(prop.key.name)
        );
        metaNodes.forEach((metaNode) => {
          if (!isInline(metaNode)) {
            dynamicProperties.push(metaNode);
          }
        });
        if (dynamicProperties.length > 0) {
          dynamicProperties.forEach((propertyNode) => {
            context.report({
              node: propertyNode,
              messageId: "metaShouldHaveInlineProperties",
              data: {
                property: propertyNode.key?.name
              }
            });
          });
        }
      }
    };
  }
});

// src/rules/meta-satisfies-type.ts
import { ASTUtils as ASTUtils3, AST_NODE_TYPES as AST_NODE_TYPES2 } from "@typescript-eslint/utils";
var meta_satisfies_type_default = createStorybookRule({
  name: "meta-satisfies-type",
  defaultOptions: [],
  meta: {
    type: "problem",
    fixable: "code",
    severity: "error",
    docs: {
      description: "Meta should use `satisfies Meta`",
      categories: [],
      excludeFromConfig: true
    },
    messages: {
      metaShouldSatisfyType: "CSF Meta should use `satisfies` for type safety"
    },
    schema: []
  },
  create(context) {
    const sourceCode = context.getSourceCode();
    const getTextWithParentheses = /* @__PURE__ */ __name((node) => {
      let beforeCount = 0;
      let afterCount = 0;
      if (ASTUtils3.isParenthesized(node, sourceCode)) {
        const bodyOpeningParen = sourceCode.getTokenBefore(node, ASTUtils3.isOpeningParenToken);
        const bodyClosingParen = sourceCode.getTokenAfter(node, ASTUtils3.isClosingParenToken);
        if (bodyOpeningParen && bodyClosingParen) {
          beforeCount = node.range[0] - bodyOpeningParen.range[0];
          afterCount = bodyClosingParen.range[1] - node.range[1];
        }
      }
      return sourceCode.getText(node, beforeCount, afterCount);
    }, "getTextWithParentheses");
    const getFixer = /* @__PURE__ */ __name((meta) => {
      const { parent } = meta;
      if (!parent) {
        return void 0;
      }
      switch (parent.type) {
        // {} as Meta
        case AST_NODE_TYPES2.TSAsExpression:
          return (fixer) => [
            fixer.replaceText(parent, getTextWithParentheses(meta)),
            fixer.insertTextAfter(
              parent,
              ` satisfies ${getTextWithParentheses(parent.typeAnnotation)}`
            )
          ];
        // const meta: Meta = {}
        case AST_NODE_TYPES2.VariableDeclarator: {
          const { typeAnnotation } = parent.id;
          if (typeAnnotation) {
            return (fixer) => [
              fixer.remove(typeAnnotation),
              fixer.insertTextAfter(
                meta,
                ` satisfies ${getTextWithParentheses(typeAnnotation.typeAnnotation)}`
              )
            ];
          }
          return void 0;
        }
        default:
          return void 0;
      }
    }, "getFixer");
    return {
      ExportDefaultDeclaration(node) {
        const meta = getMetaObjectExpression(node, context);
        if (!meta) {
          return null;
        }
        if (!meta.parent || !isTSSatisfiesExpression(meta.parent)) {
          context.report({
            node: meta,
            messageId: "metaShouldSatisfyType",
            fix: getFixer(meta)
          });
        }
      }
    };
  }
});

// src/rules/no-redundant-story-name.ts
import { storyNameFromExport } from "storybook/internal/csf";
var no_redundant_story_name_default = createStorybookRule({
  name: "no-redundant-story-name",
  defaultOptions: [],
  meta: {
    type: "suggestion",
    fixable: "code",
    hasSuggestions: true,
    severity: "warn",
    docs: {
      description: "A story should not have a redundant name property",
      categories: ["csf" /* CSF */, "recommended" /* RECOMMENDED */]
    },
    messages: {
      removeRedundantName: "Remove redundant name",
      storyNameIsRedundant: "Named exports should not use the name annotation if it is redundant to the name that would be generated by the export name"
    },
    schema: []
  },
  create(context) {
    return {
      // CSF3
      ExportNamedDeclaration: /* @__PURE__ */ __name(function(node) {
        if (!node.declaration) {
          return;
        }
        const decl = node.declaration;
        if (isVariableDeclaration(decl)) {
          const declaration = decl.declarations[0];
          if (declaration == null) {
            return;
          }
          const { id, init } = declaration;
          if (isIdentifier(id) && isObjectExpression(init)) {
            const storyNameNode = init.properties.find(
              (prop) => isProperty(prop) && isIdentifier(prop.key) && (prop.key?.name === "name" || prop.key?.name === "storyName")
            );
            if (!storyNameNode) {
              return;
            }
            const { name } = id;
            const resolvedStoryName = storyNameFromExport(name);
            if (!isSpreadElement(storyNameNode) && isLiteral(storyNameNode.value) && storyNameNode.value.value === resolvedStoryName) {
              context.report({
                node: storyNameNode,
                messageId: "storyNameIsRedundant",
                suggest: [
                  {
                    messageId: "removeRedundantName",
                    fix: /* @__PURE__ */ __name(function(fixer) {
                      return fixer.remove(storyNameNode);
                    }, "fix")
                  }
                ]
              });
            }
          }
        }
      }, "ExportNamedDeclaration"),
      // CSF2
      AssignmentExpression: /* @__PURE__ */ __name(function(node) {
        if (!isExpressionStatement(node.parent)) {
          return;
        }
        const { left, right } = node;
        if ("property" in left && isIdentifier(left.property) && !isMetaProperty(left) && left.property.name === "storyName") {
          if (!("name" in left.object && "value" in right)) {
            return;
          }
          const propertyName = left.object.name;
          const propertyValue = right.value;
          const resolvedStoryName = storyNameFromExport(propertyName);
          if (propertyValue === resolvedStoryName) {
            context.report({
              node,
              messageId: "storyNameIsRedundant",
              suggest: [
                {
                  messageId: "removeRedundantName",
                  fix: /* @__PURE__ */ __name(function(fixer) {
                    return fixer.remove(node);
                  }, "fix")
                }
              ]
            });
          }
        }
      }, "AssignmentExpression")
    };
  }
});

// src/rules/no-renderer-packages.ts
var rendererToFrameworks = {
  "@storybook/html": ["@storybook/html-vite", "@storybook/html-webpack5"],
  "@storybook/preact": ["@storybook/preact-vite", "@storybook/preact-webpack5"],
  "@storybook/react": [
    "@storybook/nextjs",
    "@storybook/react-vite",
    "@storybook/nextjs-vite",
    "@storybook/react-webpack5",
    "@storybook/react-native-web-vite"
  ],
  "@storybook/server": ["@storybook/server-webpack5"],
  "@storybook/svelte": [
    "@storybook/svelte-vite",
    "@storybook/svelte-webpack5",
    "@storybook/sveltekit"
  ],
  "@storybook/vue3": ["@storybook/vue3-vite", "@storybook/vue3-webpack5"],
  "@storybook/web-components": [
    "@storybook/web-components-vite",
    "@storybook/web-components-webpack5"
  ]
};
var no_renderer_packages_default = createStorybookRule({
  name: "no-renderer-packages",
  defaultOptions: [],
  meta: {
    type: "problem",
    severity: "error",
    docs: {
      description: "Do not import renderer packages directly in stories",
      categories: ["recommended" /* RECOMMENDED */]
    },
    schema: [],
    messages: {
      noRendererPackages: 'Do not import renderer package "{{rendererPackage}}" directly. Use a framework package instead (e.g. {{suggestions}}).'
    }
  },
  create(context) {
    return {
      ImportDeclaration(node) {
        const packageName = node.source.value;
        if (typeof packageName === "string" && packageName in rendererToFrameworks) {
          const suggestions = rendererToFrameworks[packageName];
          context.report({
            node,
            messageId: "noRendererPackages",
            data: {
              rendererPackage: packageName,
              suggestions: suggestions.join(", ")
            }
          });
        }
      }
    };
  }
});

// src/rules/no-stories-of.ts
var no_stories_of_default = createStorybookRule({
  name: "no-stories-of",
  defaultOptions: [],
  meta: {
    type: "problem",
    severity: "error",
    docs: {
      description: "storiesOf is deprecated and should not be used",
      categories: ["csf-strict" /* CSF_STRICT */]
    },
    messages: {
      doNotUseStoriesOf: "storiesOf is deprecated and should not be used"
    },
    schema: []
  },
  create(context) {
    return {
      ImportSpecifier(node) {
        if ("name" in node.imported && node.imported.name === "storiesOf") {
          context.report({
            node,
            messageId: "doNotUseStoriesOf"
          });
        }
      }
    };
  }
});

// src/rules/no-title-property-in-meta.ts
var no_title_property_in_meta_default = createStorybookRule({
  name: "no-title-property-in-meta",
  defaultOptions: [],
  meta: {
    type: "problem",
    fixable: "code",
    hasSuggestions: true,
    severity: "error",
    docs: {
      description: "Do not define a title in meta",
      categories: ["csf-strict" /* CSF_STRICT */]
    },
    messages: {
      removeTitleInMeta: "Remove title property from meta",
      noTitleInMeta: `CSF3 does not need a title in meta`
    },
    schema: []
  },
  create: /* @__PURE__ */ __name(function(context) {
    return {
      ExportDefaultDeclaration: /* @__PURE__ */ __name(function(node) {
        const meta = getMetaObjectExpression(node, context);
        if (!meta) {
          return null;
        }
        const titleNode = meta.properties.find(
          (prop) => !isSpreadElement(prop) && "name" in prop.key && prop.key?.name === "title"
        );
        if (titleNode) {
          context.report({
            node: titleNode,
            messageId: "noTitleInMeta",
            suggest: [
              {
                messageId: "removeTitleInMeta",
                fix(fixer) {
                  const fullText = context.getSourceCode().text;
                  const propertyTextWithExtraCharacter = fullText.slice(
                    titleNode.range[0],
                    titleNode.range[1] + 1
                  );
                  const hasComma = propertyTextWithExtraCharacter.slice(-1) === ",";
                  const propertyRange = [
                    titleNode.range[0],
                    hasComma ? titleNode.range[1] + 1 : titleNode.range[1]
                  ];
                  return fixer.removeRange(propertyRange);
                }
              }
            ]
          });
        }
      }, "ExportDefaultDeclaration")
    };
  }, "create")
});

// src/rules/no-uninstalled-addons.ts
var import_ts_dedent = __toESM(require_dist(), 1);
import { readFileSync } from "fs";
import { relative, resolve, sep } from "path";
var no_uninstalled_addons_default = createStorybookRule({
  name: "no-uninstalled-addons",
  defaultOptions: [
    {
      packageJsonLocation: "",
      ignore: []
    }
  ],
  meta: {
    type: "problem",
    severity: "error",
    docs: {
      description: "This rule identifies storybook addons that are invalid because they are either not installed or contain a typo in their name.",
      categories: ["recommended" /* RECOMMENDED */]
    },
    messages: {
      addonIsNotInstalled: `The {{ addonName }} is not installed in {{packageJsonPath}}. Did you forget to install it or is your package.json in a different location?`
    },
    schema: [
      {
        type: "object",
        properties: {
          packageJsonLocation: {
            type: "string"
          },
          ignore: {
            type: "array",
            items: {
              type: "string"
            }
          }
        }
      }
    ]
  },
  create(context) {
    const { packageJsonLocation, ignore } = context.options.reduce(
      (acc, val) => {
        return {
          packageJsonLocation: val.packageJsonLocation || acc.packageJsonLocation,
          ignore: val.ignore || acc.ignore
        };
      },
      { packageJsonLocation: "", ignore: [] }
    );
    function excludeNullable(item) {
      return !!item;
    }
    __name(excludeNullable, "excludeNullable");
    const mergeDepsWithDevDeps = /* @__PURE__ */ __name((packageJson) => {
      const deps = Object.keys(packageJson.dependencies || {});
      const devDeps = Object.keys(packageJson.devDependencies || {});
      return [...deps, ...devDeps];
    }, "mergeDepsWithDevDeps");
    const isAddonInstalled = /* @__PURE__ */ __name((addon, installedAddons) => {
      const addonName = addon.replace(/\.[mc]?js$/, "").replace(/\/register$/, "").replace(/\/preset$/, "");
      return installedAddons.includes(addonName);
    }, "isAddonInstalled");
    const filterLocalAddons = /* @__PURE__ */ __name((addon) => {
      const isLocalAddon = /* @__PURE__ */ __name((addonName) => addonName.startsWith(".") || addonName.startsWith("/") || // for local Windows files e.g. (C: F: D:)
      /\w:.*/.test(addonName) || addonName.startsWith("\\"), "isLocalAddon");
      return !isLocalAddon(addon);
    }, "filterLocalAddons");
    const areThereAddonsNotInstalled = /* @__PURE__ */ __name((addons, installedSbAddons) => {
      const result = addons.filter(filterLocalAddons).filter((addon) => !isAddonInstalled(addon, installedSbAddons) && !ignore.includes(addon)).map((addon) => ({ name: addon }));
      return result.length ? result : false;
    }, "areThereAddonsNotInstalled");
    const getPackageJson = /* @__PURE__ */ __name((path2) => {
      const packageJson = {
        devDependencies: {},
        dependencies: {}
      };
      try {
        const file = readFileSync(path2, "utf8");
        const parsedFile = JSON.parse(file);
        packageJson.dependencies = parsedFile.dependencies || {};
        packageJson.devDependencies = parsedFile.devDependencies || {};
      } catch (err) {
        throw new Error(
          import_ts_dedent.dedent`The provided path in your eslintrc.json - ${path2} is not a valid path to a package.json file or your package.json file is not in the same folder as ESLint is running from.

          Read more at: https://github.com/storybookjs/storybook/blob/next/code/lib/eslint-plugin/docs/rules/no-uninstalled-addons.md
          `
        );
      }
      return packageJson;
    }, "getPackageJson");
    const extractAllAddonsFromTheStorybookConfig = /* @__PURE__ */ __name((addonsExpression) => {
      if (addonsExpression?.elements) {
        const nodesWithAddons = addonsExpression.elements.map((elem) => isLiteral(elem) ? { value: elem.value, node: elem } : void 0).filter(excludeNullable);
        const listOfAddonsInString = nodesWithAddons.map((elem) => elem.value);
        const nodesWithAddonsInObj = addonsExpression.elements.map((elem) => isObjectExpression(elem) ? elem : { properties: [] }).map((elem) => {
          const property = elem.properties.find(
            (prop) => isProperty(prop) && isIdentifier(prop.key) && prop.key.name === "name"
          );
          return isLiteral(property?.value) ? { value: property.value.value, node: property.value } : void 0;
        }).filter(excludeNullable);
        const listOfAddonsInObj = nodesWithAddonsInObj.map((elem) => elem.value);
        const listOfAddons = [...listOfAddonsInString, ...listOfAddonsInObj];
        const listOfAddonElements = [...nodesWithAddons, ...nodesWithAddonsInObj];
        return { listOfAddons, listOfAddonElements };
      }
      return { listOfAddons: [], listOfAddonElements: [] };
    }, "extractAllAddonsFromTheStorybookConfig");
    function reportUninstalledAddons(addonsProp) {
      const packageJsonPath = resolve(packageJsonLocation || `./package.json`);
      let packageJsonObject;
      try {
        packageJsonObject = getPackageJson(packageJsonPath);
      } catch (e) {
        throw new Error(e);
      }
      const depsAndDevDeps = mergeDepsWithDevDeps(packageJsonObject);
      const { listOfAddons, listOfAddonElements } = extractAllAddonsFromTheStorybookConfig(addonsProp);
      const result = areThereAddonsNotInstalled(listOfAddons, depsAndDevDeps);
      if (result) {
        const elemsWithErrors = listOfAddonElements.filter(
          (elem) => !!result.find((addon) => addon.name === elem.value)
        );
        const rootDir = process.cwd().split(sep).pop();
        const currentPackageJsonPath = `${rootDir}${sep}${relative(process.cwd(), packageJsonLocation)}`;
        elemsWithErrors.forEach((elem) => {
          context.report({
            node: elem.node,
            messageId: "addonIsNotInstalled",
            data: {
              addonName: elem.value,
              packageJsonPath: currentPackageJsonPath
            }
          });
        });
      }
    }
    __name(reportUninstalledAddons, "reportUninstalledAddons");
    function findAddonsPropAndReport(node) {
      const addonsProp = node.properties.find(
        (prop) => isProperty(prop) && isIdentifier(prop.key) && prop.key.name === "addons"
      );
      if (addonsProp?.value && isArrayExpression(addonsProp.value)) {
        reportUninstalledAddons(addonsProp.value);
      }
    }
    __name(findAddonsPropAndReport, "findAddonsPropAndReport");
    return {
      AssignmentExpression: /* @__PURE__ */ __name(function(node) {
        if (isObjectExpression(node.right)) {
          findAddonsPropAndReport(node.right);
        }
      }, "AssignmentExpression"),
      ExportDefaultDeclaration: /* @__PURE__ */ __name(function(node) {
        const meta = getMetaObjectExpression(node, context);
        if (!meta) {
          return null;
        }
        findAddonsPropAndReport(meta);
      }, "ExportDefaultDeclaration"),
      ExportNamedDeclaration: /* @__PURE__ */ __name(function(node) {
        const addonsProp = isVariableDeclaration(node.declaration) && node.declaration.declarations.find(
          (decl) => isVariableDeclarator(decl) && isIdentifier(decl.id) && decl.id.name === "addons"
        );
        if (addonsProp && isArrayExpression(addonsProp.init)) {
          reportUninstalledAddons(addonsProp.init);
        }
      }, "ExportNamedDeclaration")
    };
  }
});

// src/rules/prefer-pascal-case.ts
import { isExportStory as isExportStory2 } from "storybook/internal/csf";
import { ASTUtils as ASTUtils4 } from "@typescript-eslint/utils";
var prefer_pascal_case_default = createStorybookRule({
  name: "prefer-pascal-case",
  defaultOptions: [],
  meta: {
    type: "suggestion",
    fixable: "code",
    hasSuggestions: true,
    severity: "warn",
    docs: {
      description: "Stories should use PascalCase",
      categories: ["recommended" /* RECOMMENDED */]
    },
    messages: {
      convertToPascalCase: "Use pascal case",
      usePascalCase: "The story should use PascalCase notation: {{name}}"
    },
    schema: []
  },
  create(context) {
    const isPascalCase = /* @__PURE__ */ __name((str) => /^[A-Z]+([a-z0-9]?)+/.test(str), "isPascalCase");
    const toPascalCase = /* @__PURE__ */ __name((str) => {
      return str.replace(new RegExp(/[-_]+/, "g"), " ").replace(new RegExp(/[^\w\s]/, "g"), "").replace(
        new RegExp(/\s+(.)(\w+)/, "g"),
        (_, $2, $3) => `${$2.toUpperCase() + $3.toLowerCase()}`
      ).replace(new RegExp(/\s/, "g"), "").replace(new RegExp(/\w/), (s) => s.toUpperCase());
    }, "toPascalCase");
    const getModuleScope = /* @__PURE__ */ __name(() => {
      const { sourceCode } = context;
      if (sourceCode.getScope) {
        return sourceCode.scopeManager?.scopes?.find(
          (scope) => scope.type === "module"
        );
      } else {
        return context.getScope().childScopes.find((scope) => scope.type === "module");
      }
    }, "getModuleScope");
    const checkAndReportError = /* @__PURE__ */ __name((id, nonStoryExportsConfig2 = {}) => {
      const { name } = id;
      if (!isExportStory2(name, nonStoryExportsConfig2) || name === "__namedExportsOrder") {
        return null;
      }
      if (!name.startsWith("_") && !isPascalCase(name)) {
        context.report({
          node: id,
          messageId: "usePascalCase",
          data: {
            name
          },
          suggest: [
            {
              messageId: "convertToPascalCase",
              *fix(fixer) {
                const fullText = context.getSourceCode().text;
                const fullName = fullText.slice(id.range[0], id.range[1]);
                const suffix = fullName.substring(name.length);
                const pascal = toPascalCase(name);
                yield fixer.replaceTextRange(id.range, pascal + suffix);
                const scope = getModuleScope();
                if (scope) {
                  const variable = ASTUtils4.findVariable(scope, name);
                  const referenceCount = variable?.references?.length || 0;
                  for (let i = 0; i < referenceCount; i++) {
                    const ref = variable?.references[i];
                    if (ref && !ref.init) {
                      yield fixer.replaceTextRange(ref.identifier.range, pascal);
                    }
                  }
                }
              }
            }
          ]
        });
      }
    }, "checkAndReportError");
    let meta;
    let nonStoryExportsConfig;
    const namedExports = [];
    let hasStoriesOfImport = false;
    return {
      ImportSpecifier(node) {
        if ("name" in node.imported && node.imported.name === "storiesOf") {
          hasStoriesOfImport = true;
        }
      },
      ExportDefaultDeclaration: /* @__PURE__ */ __name(function(node) {
        meta = getMetaObjectExpression(node, context);
        if (meta) {
          try {
            nonStoryExportsConfig = {
              excludeStories: getDescriptor(meta, "excludeStories"),
              includeStories: getDescriptor(meta, "includeStories")
            };
          } catch (err) {
          }
        }
      }, "ExportDefaultDeclaration"),
      ExportNamedDeclaration: /* @__PURE__ */ __name(function(node) {
        if (!node.declaration) {
          return;
        }
        const decl = node.declaration;
        if (isVariableDeclaration(decl)) {
          const declaration = decl.declarations[0];
          if (declaration == null) {
            return;
          }
          const { id } = declaration;
          if (isIdentifier(id)) {
            namedExports.push(id);
          }
        }
      }, "ExportNamedDeclaration"),
      "Program:exit": /* @__PURE__ */ __name(function() {
        if (namedExports.length && !hasStoriesOfImport) {
          namedExports.forEach((n) => checkAndReportError(n, nonStoryExportsConfig));
        }
      }, "Program:exit")
    };
  }
});

// src/rules/story-exports.ts
var story_exports_default = createStorybookRule({
  name: "story-exports",
  defaultOptions: [],
  meta: {
    type: "problem",
    severity: "error",
    docs: {
      description: "A story file must contain at least one story export",
      categories: ["recommended" /* RECOMMENDED */, "csf" /* CSF */]
    },
    messages: {
      shouldHaveStoryExport: "The file should have at least one story export",
      shouldHaveStoryExportWithFilters: "The file should have at least one story export. Make sure the includeStories/excludeStories you defined are correct, otherwise Storybook will not use any stories for this file.",
      addStoryExport: "Add a story export"
    },
    fixable: void 0,
    // change to 'code' once we have autofixes
    schema: []
  },
  create(context) {
    let hasStoriesOfImport = false;
    let nonStoryExportsConfig = {};
    let meta;
    const namedExports = [];
    return {
      ImportSpecifier(node) {
        if ("name" in node.imported && node.imported.name === "storiesOf") {
          hasStoriesOfImport = true;
        }
      },
      ExportDefaultDeclaration: /* @__PURE__ */ __name(function(node) {
        meta = getMetaObjectExpression(node, context);
        if (meta) {
          try {
            nonStoryExportsConfig = {
              excludeStories: getDescriptor(meta, "excludeStories"),
              includeStories: getDescriptor(meta, "includeStories")
            };
          } catch (err) {
          }
        }
      }, "ExportDefaultDeclaration"),
      ExportNamedDeclaration: /* @__PURE__ */ __name(function(node) {
        namedExports.push(...getAllNamedExports(node));
      }, "ExportNamedDeclaration"),
      "Program:exit": /* @__PURE__ */ __name(function(program) {
        if (hasStoriesOfImport || !meta) {
          return;
        }
        const storyExports = namedExports.filter(
          (exp) => isValidStoryExport(exp, nonStoryExportsConfig)
        );
        if (storyExports.length) {
          return;
        }
        const firstNonImportStatement = program.body.find((n) => !isImportDeclaration(n));
        const node = firstNonImportStatement || program.body[0] || program;
        const hasFilter = nonStoryExportsConfig.includeStories || nonStoryExportsConfig.excludeStories;
        const report = {
          node,
          messageId: hasFilter ? "shouldHaveStoryExportWithFilters" : "shouldHaveStoryExport"
          // fix,
        };
        context.report(report);
      }, "Program:exit")
    };
  }
});

// src/rules/use-storybook-expect.ts
var use_storybook_expect_default = createStorybookRule({
  name: "use-storybook-expect",
  defaultOptions: [],
  meta: {
    type: "suggestion",
    fixable: "code",
    schema: [],
    severity: "error",
    docs: {
      description: "Use expect from `@storybook/test`, `storybook/test` or `@storybook/jest`",
      categories: ["addon-interactions" /* ADDON_INTERACTIONS */, "recommended" /* RECOMMENDED */]
    },
    messages: {
      useExpectFromStorybook: "Do not use global expect directly in the story. You should import it from `@storybook/test` (preferrably) or `@storybook/jest` instead."
    }
  },
  create(context) {
    const isExpectFromStorybookImported = /* @__PURE__ */ __name((node) => {
      const { value: packageName } = node.source;
      const usesExpectFromStorybook = packageName === "@storybook/jest" || packageName === "@storybook/test" || packageName === "storybook/test";
      return usesExpectFromStorybook && node.specifiers.find(
        (spec) => isImportSpecifier(spec) && "name" in spec.imported && spec.imported.name === "expect"
      );
    }, "isExpectFromStorybookImported");
    let isImportingFromStorybookExpect = false;
    const expectInvocations = [];
    return {
      ImportDeclaration(node) {
        if (isExpectFromStorybookImported(node)) {
          isImportingFromStorybookExpect = true;
        }
      },
      CallExpression(node) {
        if (!isIdentifier(node.callee)) {
          return null;
        }
        if (node.callee.name === "expect") {
          expectInvocations.push(node.callee);
        }
      },
      "Program:exit": /* @__PURE__ */ __name(function() {
        if (!isImportingFromStorybookExpect && expectInvocations.length) {
          expectInvocations.forEach((node) => {
            context.report({
              node,
              messageId: "useExpectFromStorybook"
            });
          });
        }
      }, "Program:exit")
    };
  }
});

// src/rules/use-storybook-testing-library.ts
var use_storybook_testing_library_default = createStorybookRule({
  name: "use-storybook-testing-library",
  defaultOptions: [],
  meta: {
    type: "suggestion",
    fixable: "code",
    hasSuggestions: true,
    severity: "error",
    docs: {
      description: "Do not use testing-library directly on stories",
      categories: ["addon-interactions" /* ADDON_INTERACTIONS */, "recommended" /* RECOMMENDED */]
    },
    schema: [],
    messages: {
      updateImports: "Update imports",
      dontUseTestingLibraryDirectly: "Do not use `{{library}}` directly in the story. You should import the functions from `@storybook/test` (preferrably) or `@storybook/testing-library` instead."
    }
  },
  create(context) {
    const getRangeWithoutQuotes = /* @__PURE__ */ __name((source) => {
      return [
        // Not sure how to improve this. If I use node.source.range
        // it will eat the quotes and we do not want to specify whether the quotes are single or double
        source.range[0] + 1,
        source.range[1] - 1
      ];
    }, "getRangeWithoutQuotes");
    const hasDefaultImport = /* @__PURE__ */ __name((specifiers) => specifiers.find((s) => isImportDefaultSpecifier(s)), "hasDefaultImport");
    const getSpecifiers = /* @__PURE__ */ __name((node) => {
      const { specifiers } = node;
      if (!specifiers[0]) {
        return null;
      }
      const start = specifiers[0].range[0];
      const previousSpecifier = specifiers[specifiers.length - 1];
      if (!previousSpecifier) {
        return null;
      }
      let end = previousSpecifier.range[1];
      const fullText = context.getSourceCode().text;
      const importEnd = node.range[1];
      const closingBrace = fullText.indexOf("}", end - 1);
      if (closingBrace > -1 && closingBrace <= importEnd) {
        end = closingBrace + 1;
      }
      const text = fullText.substring(start, end);
      return { range: [start, end], text };
    }, "getSpecifiers");
    const fixSpecifiers = /* @__PURE__ */ __name((specifiersText) => {
      const flattened = specifiersText.replace("{", "").replace("}", "").replace(/\s\s+/g, " ").trim();
      return `{ ${flattened} }`;
    }, "fixSpecifiers");
    return {
      ImportDeclaration(node) {
        if (node.source.value.includes("@testing-library")) {
          context.report({
            node,
            messageId: "dontUseTestingLibraryDirectly",
            data: {
              library: node.source.value
            },
            *fix(fixer) {
              yield fixer.replaceTextRange(
                getRangeWithoutQuotes(node.source),
                "@storybook/testing-library"
              );
              if (hasDefaultImport(node.specifiers)) {
                const specifiers = getSpecifiers(node);
                if (specifiers) {
                  const { range, text } = specifiers;
                  yield fixer.replaceTextRange(range, fixSpecifiers(text));
                }
              }
            },
            suggest: [
              {
                messageId: "updateImports",
                *fix(fixer) {
                  yield fixer.replaceTextRange(
                    getRangeWithoutQuotes(node.source),
                    "@storybook/testing-library"
                  );
                  if (hasDefaultImport(node.specifiers)) {
                    const specifiers = getSpecifiers(node);
                    if (specifiers) {
                      const { range, text } = specifiers;
                      yield fixer.replaceTextRange(range, fixSpecifiers(text));
                    }
                  }
                }
              }
            ]
          });
        }
      }
    };
  }
});

// src/index.ts
var configs = {
  // eslintrc configs
  csf: csf_default,
  "csf-strict": csf_strict_default,
  "addon-interactions": addon_interactions_default,
  recommended: recommended_default2,
  // flat configs
  "flat/csf": csf_default2,
  "flat/csf-strict": csf_strict_default2,
  "flat/addon-interactions": addon_interactions_default2,
  "flat/recommended": recommended_default
};
var rules = {
  "await-interactions": await_interactions_default,
  "context-in-play-function": context_in_play_function_default,
  "csf-component": csf_component_default,
  "default-exports": default_exports_default,
  "hierarchy-separator": hierarchy_separator_default,
  "meta-inline-properties": meta_inline_properties_default,
  "meta-satisfies-type": meta_satisfies_type_default,
  "no-redundant-story-name": no_redundant_story_name_default,
  "no-renderer-packages": no_renderer_packages_default,
  "no-stories-of": no_stories_of_default,
  "no-title-property-in-meta": no_title_property_in_meta_default,
  "no-uninstalled-addons": no_uninstalled_addons_default,
  "prefer-pascal-case": prefer_pascal_case_default,
  "story-exports": story_exports_default,
  "use-storybook-expect": use_storybook_expect_default,
  "use-storybook-testing-library": use_storybook_testing_library_default
};
var index_default = {
  configs,
  rules
};
export {
  configs,
  index_default as default,
  rules
};
