"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_WB_TWILIGHT({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { height: "2", transform: "matrix(0.7069 -0.7074 0.7074 0.7069 -0.3887 15.676)", width: "3", x: "17.22", y: "7.31" }),
                React.createElement("rect", { height: "2", width: "20", x: "2", y: "18" }),
                React.createElement("rect", { height: "3", width: "2", x: "11", y: "4" }),
                React.createElement("rect", { height: "3", transform: "matrix(0.7071 -0.7071 0.7071 0.7071 -4.2992 6.1783)", width: "2", x: "4.31", y: "6.78" }),
                React.createElement("path", { d: "M5,16h14c0-3.87-3.13-7-7-7S5,12.13,5,16z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { height: "2", transform: "matrix(0.7069 -0.7074 0.7074 0.7069 -0.3887 15.676)", width: "3", x: "17.22", y: "7.31" }),
                React.createElement("rect", { height: "2", width: "20", x: "2", y: "18" }),
                React.createElement("rect", { height: "3", width: "2", x: "11", y: "4" }),
                React.createElement("rect", { height: "3", transform: "matrix(0.7071 -0.7071 0.7071 0.7071 -4.2992 6.1783)", width: "2", x: "4.31", y: "6.78" }),
                React.createElement("path", { d: "M5,16h14c0-3.87-3.13-7-7-7S5,12.13,5,16z" }))));
}
;
exports.default = EOS_WB_TWILIGHT;
