"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_VIRTUAL_SPACE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z" }),
                React.createElement("circle", { cx: "11.99866", cy: "7.49265", r: "1.49264" }),
                React.createElement("circle", { cx: "11.99866", cy: "16.49265", r: "1.49264" }),
                React.createElement("circle", { cx: "16.49592", cy: "12", r: "1.49264" }),
                React.createElement("circle", { cx: "7.49592", cy: "12", r: "1.49264" }),
                React.createElement("circle", { cx: "11.99866", cy: "12", r: "1" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z" }),
                React.createElement("circle", { cx: "11.99866", cy: "7.49265", r: "1.49264" }),
                React.createElement("circle", { cx: "11.99866", cy: "16.49265", r: "1.49264" }),
                React.createElement("circle", { cx: "16.49592", cy: "12", r: "1.49264" }),
                React.createElement("circle", { cx: "7.49592", cy: "12", r: "1.49264" }),
                React.createElement("circle", { cx: "11.99866", cy: "12", r: "1" }))));
}
;
exports.default = EOS_VIRTUAL_SPACE;
